/**
 * @module crm/timeline/item/ui/body/blocks/client-mark
 */
jn.define('crm/timeline/item/ui/body/blocks/client-mark', (require, exports, module) => {
	const AppTheme = require('apptheme');
	const { TimelineItemBodyBlock } = require('crm/timeline/item/ui/body/blocks/base');

	const ClientMarkColor = {
		positive: AppTheme.colors.accentMainSuccess,
		neutral: AppTheme.colors.accentMainWarning,
		negative: AppTheme.colors.accentMainAlert,
	};

	const Mark = {
		negative: 'negative',
	};

	class TimelineItemBodyClientMark extends TimelineItemBodyBlock
	{
		render()
		{
			const color = ClientMarkColor[this.props.mark];

			return View(
				{
					style: {
						flexDirection: 'row',
					},
				},
				View(
					{
						style: {
							width: 18,
							height: 18,
							justifyContent: 'center',
							alignItems: 'center',
							marginRight: 3,
						},
					},
					Image(
						{
							style: {
								width: 12,
								height: 12,
							},
							svg: {
								content: this.props.mark === Mark.negative
									? SvgIcons.negative(color)
									: SvgIcons.positive(color),
							},
						},
					),
				),
				Text(
					{
						style: {
							fontSize: 13,
							color,
						},
						text: this.props.text,
					},
				),
			);
		}
	}

	const SvgIcons = {
		positive: (color) => {
			return `<svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M11.1275 4.53759L8.42632 4.53812C8.34856 4.53812 8.27344 4.49315 8.24434 4.42174C8.12266 4.11755 8.12743 3.77475 8.26074 3.47268C8.48451 2.82145 8.50991 2.11786 8.33427 1.45182C8.1507 0.993691 8.10203 0.156782 7.25507 0.118164C6.99003 0.157311 6.75885 0.316546 6.62554 0.548786C6.60173 0.590049 6.59168 0.638719 6.59168 0.685802C6.59168 0.685802 6.6306 1.49844 6.59168 2.06337C6.55276 2.6283 5.47175 4.06729 4.78455 4.98091C4.74117 5.0391 4.68034 5.07719 4.60839 5.0883C4.35075 5.12688 3.85932 5.19221 3.68218 5.2156C3.64072 5.22108 3.61648 5.27315 3.61648 5.2976C3.61648 6.43967 3.61648 8.14807 3.61648 10.4228C3.61648 10.4417 3.63922 10.4828 3.67964 10.4894C3.81841 10.5123 4.16553 10.5758 4.51581 10.6885C4.95596 10.8297 5.32257 11.1641 6.05632 11.4117C6.09493 11.4249 6.13778 11.4318 6.17852 11.4318H9.62402C10.0689 11.3524 10.4001 10.9721 10.4228 10.5155C10.4292 10.2611 10.3784 10.0092 10.2742 9.77806C10.2594 9.74473 10.2789 9.70981 10.3149 9.70294C10.7567 9.62252 11.3089 8.78403 10.6286 8.10847C10.6106 8.09101 10.6138 8.06721 10.6382 8.06086C11.0132 7.96511 11.3005 7.66568 11.3883 7.29219C11.4222 7.14936 11.41 7.00176 11.3677 6.86157C11.3179 6.6944 11.2386 6.53781 11.1333 6.39815C11.1069 6.36324 11.1217 6.31774 11.164 6.30399C11.5375 6.17755 11.7946 5.82046 11.7919 5.41418C11.8348 5.01582 11.5147 4.53812 11.1275 4.53759ZM2.55897 4.75343H0.606358C0.504787 4.75343 0.42755 4.84336 0.445007 4.94123L1.57922 11.3133C1.59668 11.4111 1.68291 11.4826 1.78396 11.4826H2.50607C2.61769 11.4826 2.70815 11.3942 2.70815 11.2852L2.72402 4.91531C2.72402 4.82591 2.65049 4.75343 2.55897 4.75343Z" fill="${color}"/></svg>`;
		},
		negative: (color) => {
			return `<svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M11.1273 7.46241L8.42617 7.46188C8.3484 7.46188 8.27328 7.50685 8.24419 7.57826C8.12251 7.88245 8.12727 8.22525 8.26059 8.52732C8.48436 9.17855 8.50975 9.88214 8.33412 10.5482C8.15055 11.0063 8.10188 11.8432 7.25492 11.8818C6.98988 11.8427 6.7587 11.6835 6.62539 11.4512C6.60158 11.41 6.59153 11.3613 6.59153 11.3142C6.59153 11.3142 6.63045 10.5016 6.59153 9.93663C6.55261 9.3717 5.4716 7.93271 4.7844 7.01909C4.74102 6.9609 4.68018 6.92281 4.60824 6.9117C4.3506 6.87312 3.85917 6.80779 3.68203 6.7844C3.64057 6.77892 3.61633 6.72685 3.61633 6.7024C3.61633 5.56033 3.61633 3.85193 3.61633 1.57718C3.61633 1.55832 3.63907 1.51723 3.67949 1.51056C3.81826 1.48765 4.16537 1.42417 4.51566 1.3115C4.9558 1.17025 5.32241 0.835913 6.05616 0.588332C6.09478 0.575107 6.13763 0.568229 6.17837 0.568229H9.62387C10.0688 0.647582 10.3999 1.02795 10.4227 1.48449C10.429 1.73895 10.3783 1.99076 10.274 2.22194C10.2592 2.25527 10.2788 2.29019 10.3148 2.29706C10.7565 2.37748 11.3088 3.21597 10.6285 3.89153C10.6105 3.90899 10.6137 3.93279 10.638 3.93914C11.0131 4.03489 11.3003 4.33432 11.3881 4.70781C11.422 4.85064 11.4098 4.99824 11.3675 5.13843C11.3178 5.3056 11.2384 5.46219 11.1332 5.60185C11.1067 5.63676 11.1215 5.68226 11.1638 5.69601C11.5373 5.82245 11.7944 6.17954 11.7918 6.58582C11.8346 6.98418 11.5146 7.46188 11.1273 7.46241ZM2.55882 7.24657H0.606206C0.504634 7.24657 0.427397 7.15664 0.444855 7.05877L1.57907 0.686729C1.59653 0.588861 1.68276 0.517444 1.7838 0.517444H2.50591C2.61754 0.517444 2.708 0.60579 2.708 0.714767L2.72387 7.08469C2.72387 7.17409 2.65034 7.24657 2.55882 7.24657Z" fill="${color}"/></svg>`;
		},
	};

	module.exports = { TimelineItemBodyClientMark };
});
