/**
 * @module crm/terminal/entity/payment-create/steps/finish/layout
 */
jn.define('crm/terminal/entity/payment-create/steps/finish/layout', (require, exports, module) => {
	const AppTheme = require('apptheme');
	const { Loc } = require('loc');
	const { Random } = require('utils/random');
	const { PureComponent } = require('layout/pure-component');
	const { getEntityMessage } = require('crm/loc');
	const { EventEmitter } = require('event-emitter');
	const { Haptics } = require('haptics');

	const PATH_TO_EXTENSION_IMAGES = `${currentDomain}/bitrix/mobileapp/crmmobile/extensions/crm/terminal/entity/payment-create/steps/finish`;

	const STATUSES = {
		creating: 'creating',
		success: 'success',
		error: 'error',
	};

	/**
	 * @class Layout
	 */
	class Layout extends PureComponent
	{
		constructor(props)
		{
			super(props);

			this.state = {
				status: null,
				payment: null,
				initialAnimationFinished: false,
				isError: false,
			};

			this.uid = props.uid || Random.getString();
			this.customEventEmitter = EventEmitter.createWithUid(this.uid);
		}

		render()
		{
			return View(
				{
					style: {
						backgroundColor: AppTheme.colors.bgContentPrimary,
						borderRadius: 12,
						alignItems: 'center',
						paddingBottom: 32,
						paddingHorizontal: 16,
					},
				},
				this.renderCloudBlock(),
				this.renderTopText(),
				this.renderBottomText(),
				this.renderBackButton(),
				this.renderOpenPaymentPayButton(),
			);
		}

		renderCloudBlock()
		{
			if (this.state.status === STATUSES.creating)
			{
				return this.renderLottieCloud();
			}

			if (this.state.status === STATUSES.success)
			{
				return this.renderSvgCloud('green-clouds.svg');
			}

			if (this.state.status === STATUSES.error)
			{
				return this.renderSvgCloud('error.svg');
			}

			return '';
		}

		renderSvgCloud(image)
		{
			return Image({
				svg: { uri: `${PATH_TO_EXTENSION_IMAGES}/images/${image}` },
				style: {
					height: 186,
					width: 229,
					marginTop: 27,
					marginBottom: 25,
					opacity: 0.7,
				},
				ref: (ref) => {
					ref.animate({
						duration: 300,
						opacity: 1,
					});
				},
			});
		}

		renderLottieCloud()
		{
			return LottieView(
				{
					style: {
						height: 216,
						width: 256,
						marginTop: 15,
						marginBottom: 14,
						marginLeft: -3,
					},
					data: {
						content: '{"nm":"Terminal loader","v":"5.9.6","fr":60,"ip":0,"op":107.00000429153444,"w":198,"h":172,"ddd":0,"markers":[],"assets":[{"nm":"[GROUP] 3rd - Null / 3rd / 3rd - Null / 3rd","fr":60,"id":"llb2yki0mxznafpwts","layers":[{"ty":3,"ddd":0,"ind":19,"hd":false,"nm":"3rd - Null","ks":{"a":{"a":0,"k":[0,0]},"o":{"a":1,"k":[{"t":90.0000035762787,"s":[0],"o":{"x":[0],"y":[0]},"i":{"x":[0.58],"y":[1]}},{"t":108.00000429153444,"s":[80]}]},"p":{"a":0,"k":[85,64.6067]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":3,"ddd":0,"ind":20,"hd":false,"nm":"3rd - Null","parent":19,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[33.959,0]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":21,"hd":false,"nm":"3rd","parent":20,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[1.2172,0],[4.8689,0],[6.0861,1.2172],[6.0861,1.2172],[4.8689,2.4344],[1.2172,2.4344],[0,1.2172],[0,1.2172],[1.2172,0],[1.2172,0]],"i":[[0,0],[0,0],[0,-0.6722],[0,0],[0.6722,0],[0,0],[0,0.6722],[0,0],[-0.6722,0],[0,0]],"o":[[0,0],[0.6722400000000004,0],[0,0],[0,0.67224],[0,0],[-0.67224,0],[0,0],[0,-0.67224],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[1,1,1,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":22,"hd":false,"nm":"3rd - Null","parent":19,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[0,0]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":23,"hd":false,"nm":"3rd","parent":22,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[1.2172,0],[25.2128,0],[26.43,1.2172],[26.43,1.2172],[25.2128,2.4344],[1.2172,2.4344],[0,1.2172],[0,1.2172],[1.2172,0],[1.2172,0]],"i":[[0,0],[0,0],[0,-0.6722],[0,0],[0.6722,0],[0,0],[0,0.6722],[0,0],[-0.6722,0],[0,0]],"o":[[0,0],[0.6722399999999986,0],[0,0],[0,0.67224],[0,0],[-0.67224,0],[0,0],[0,-0.67224],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[1,1,1,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]}]},{"nm":"[GROUP] 2nd - Null / 2nd / 2nd - Null / 2nd","fr":60,"id":"llb2yki3bwcw6kh2cwl","layers":[{"ty":3,"ddd":0,"ind":24,"hd":false,"nm":"2nd - Null","ks":{"a":{"a":0,"k":[0,0]},"o":{"a":1,"k":[{"t":54.00000214576721,"s":[0],"o":{"x":[0],"y":[0]},"i":{"x":[0.58],"y":[1]}},{"t":72.00000286102296,"s":[80]}]},"p":{"a":0,"k":[85,57.3032]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":3,"ddd":0,"ind":25,"hd":false,"nm":"2nd - Null","parent":24,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[33.959,0]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":26,"hd":false,"nm":"2nd","parent":25,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[1.2172,0],[4.8689,0],[6.0861,1.2172],[6.0861,1.2172],[4.8689,2.4344],[1.2172,2.4344],[0,1.2172],[0,1.2172],[1.2172,0],[1.2172,0]],"i":[[0,0],[0,0],[0,-0.6722],[0,0],[0.6722,0],[0,0],[0,0.6722],[0,0],[-0.6722,0],[0,0]],"o":[[0,0],[0.6722400000000004,0],[0,0],[0,0.67224],[0,0],[-0.67224,0],[0,0],[0,-0.67224],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[1,1,1,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":27,"hd":false,"nm":"2nd - Null","parent":24,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[0,0]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":28,"hd":false,"nm":"2nd","parent":27,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[1.2172,0],[25.2128,0],[26.43,1.2172],[26.43,1.2172],[25.2128,2.4344],[1.2172,2.4344],[0,1.2172],[0,1.2172],[1.2172,0],[1.2172,0]],"i":[[0,0],[0,0],[0,-0.6722],[0,0],[0.6722,0],[0,0],[0,0.6722],[0,0],[-0.6722,0],[0,0]],"o":[[0,0],[0.6722399999999986,0],[0,0],[0,0.67224],[0,0],[-0.67224,0],[0,0],[0,-0.67224],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[1,1,1,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]}]},{"nm":"[GROUP] 1st - Null / 1st / 1st - Null / 1st","fr":60,"id":"llb2yki4wnqga2mr799","layers":[{"ty":3,"ddd":0,"ind":29,"hd":false,"nm":"1st - Null","ks":{"a":{"a":0,"k":[0,0]},"o":{"a":1,"k":[{"t":18.00000071525574,"s":[0],"o":{"x":[0],"y":[0]},"i":{"x":[0.58],"y":[1]}},{"t":36.000001430511475,"s":[80]}]},"p":{"a":0,"k":[85,50]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":3,"ddd":0,"ind":30,"hd":false,"nm":"1st - Null","parent":29,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[33.959,0]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":31,"hd":false,"nm":"1st","parent":30,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[1.2172,0],[4.8689,0],[6.0861,1.2172],[6.0861,1.2172],[4.8689,2.4344],[1.2172,2.4344],[0,1.2172],[0,1.2172],[1.2172,0],[1.2172,0]],"i":[[0,0],[0,0],[0,-0.6722],[0,0],[0.6722,0],[0,0],[0,0.6722],[0,0],[-0.6722,0],[0,0]],"o":[[0,0],[0.6722400000000004,0],[0,0],[0,0.67224],[0,0],[-0.67224,0],[0,0],[0,-0.67224],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[1,1,1,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":32,"hd":false,"nm":"1st - Null","parent":29,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[0,0]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":33,"hd":false,"nm":"1st","parent":32,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[1.2172,0],[25.2128,0],[26.43,1.2172],[26.43,1.2172],[25.2128,2.4344],[1.2172,2.4344],[0,1.2172],[0,1.2172],[1.2172,0],[1.2172,0]],"i":[[0,0],[0,0],[0,-0.6722],[0,0],[0.6722,0],[0,0],[0,0.6722],[0,0],[-0.6722,0],[0,0]],"o":[[0,0],[0.6722399999999986,0],[0,0],[0,0.67224],[0,0],[-0.67224,0],[0,0],[0,-0.67224],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[1,1,1,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]}]},{"nm":"[GROUP] Path - Null / Path / Path - Null / Path / Path - Null / Path / Path - Null / Path / Path - Null / Path / Path - Null / Path / Path - Null / Path / Path - Null / Path / Path - Null / Path","fr":60,"id":"llb2yki6vvi0p4o8vfr","layers":[{"ty":3,"ddd":0,"ind":34,"hd":false,"nm":"Terminal - Null","ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[68,33]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":3,"ddd":0,"ind":35,"hd":false,"nm":"buttons - Null","parent":34,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[13.23390000000001,65]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":3,"ddd":0,"ind":36,"hd":false,"nm":"Path - Null","parent":35,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":30.000001192092903},"p":{"a":0,"k":[34.8569,0]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":37,"hd":false,"nm":"Path","parent":36,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":30.000001192092903}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[9.5699,0],[3.7345,0],[0,3.7345],[3.0633,7.4095],[3.3986,7.4396],[3.5668,7.4524],[3.7345,7.4621],[3.9025,7.4681],[4.071,7.4697],[9.5699,7.4697],[13.3051,3.7345],[10.2411,0.0603],[9.9053,0.0303],[9.7374,0.0175],[9.5693,0.0077],[9.4015,0.0025],[9.2327,0],[9.5699,0],[9.5699,0]],"i":[[0,0],[0,0],[0,-2.0613],[-1.7419,-0.3164],[-0.0593,-0.0053],[-0.0594,-0.0038],[-0.0595,-0.0023],[-0.0596,-0.0015],[-0.0597,0],[0,0],[0,2.062],[1.742,0.3164],[0.0592,0.0053],[0.0593,0.0038],[0.0594,0.0023],[0.0595,0.0015],[0.0596,0],[0,0],[0,0]],"o":[[0,0],[-2.062,0],[0,1.8329],[0,0],[0.05929999999999991,0.005300000000000082],[0.05940000000000012,0.0038000000000000256],[0.059499999999999886,0.0022999999999999687],[0.0596000000000001,0.0015000000000000568],[0.05970000000000031,0],[2.0619999999999994,0],[0,-1.8323],[0,0],[-0.059200000000000585,-0.005299999999999999],[-0.05930000000000035,-0.0037999999999999996],[-0.05940000000000012,-0.0023],[-0.059499999999999886,-0.0015],[-0.05959999999999965,0],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[0.1843137254901961,0.7764705882352941,0.9647058823529412,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":38,"hd":false,"nm":"Path - Null","parent":35,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":30.000001192092903},"p":{"a":0,"k":[0,0.001199999999997203]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":39,"hd":false,"nm":"Path","parent":38,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":30.000001192092903}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[9.5703,0],[3.7348,0],[0.0001,3.7352],[3.0637,7.4095],[3.399,7.4396],[3.5671,7.4525],[3.7347,7.4622],[3.9028,7.4674],[4.0711,7.4697],[9.5703,7.4697],[13.3052,3.7352],[10.2414,0.0602],[9.9061,0.0301],[9.738,0.0172],[9.5704,0.0075],[9.4023,0.0023],[9.234,0],[9.5703,0],[9.5703,0]],"i":[[0,0],[0,0],[0,-2.062],[-1.7419,-0.3164],[-0.0593,-0.0053],[-0.0594,-0.0038],[-0.0595,-0.0023],[-0.0596,-0.0015],[-0.0597,0],[0,0],[0,2.0613],[1.7418,0.3164],[0.0593,0.0053],[0.0594,0.0038],[0.0595,0.0023],[0.0596,0.0015],[0.0597,0],[0,0],[0,0]],"o":[[0,0],[-2.0619,0],[0,1.8323],[0,0],[0.05929999999999991,0.005300000000000082],[0.05940000000000012,0.0038000000000000256],[0.059499999999999886,0.0022999999999999687],[0.0596000000000001,0.0015000000000000568],[0.05970000000000031,0],[2.0617,0],[0,-1.8329],[0,0],[-0.05930000000000035,-0.005299999999999999],[-0.05940000000000012,-0.0037999999999999996],[-0.059499999999999886,-0.0023],[-0.05959999999999965,-0.0015],[-0.05969999999999942,0],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[0.1843137254901961,0.7764705882352941,0.9647058823529412,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":40,"hd":false,"nm":"Path - Null","parent":35,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":30.000001192092903},"p":{"a":0,"k":[17.42819999999999,0.0006999999999948159]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":41,"hd":false,"nm":"Path","parent":40,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":30.000001192092903}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[9.5706,0],[3.7352,0],[0,3.7345],[3.7352,7.4697],[9.5706,7.4697],[13.3051,3.7345],[9.5707,0.0001],[9.5706,-0.0001],[9.5705,0],[9.5706,0]],"i":[[0,0],[0,0],[0,-2.0613],[-2.062,0],[0,0],[0,2.062],[2.062,0],[0,0],[0,0],[0,0]],"o":[[0,0],[-2.062,0],[0,2.062],[0,0],[2.0619999999999994,0],[0,-2.0613],[0,0],[0,0],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[0.1843137254901961,0.7764705882352941,0.9647058823529412,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":42,"hd":false,"nm":"Path - Null","parent":35,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":30.000001192092903},"p":{"a":0,"k":[34.8569,13.655]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":43,"hd":false,"nm":"Path","parent":42,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":30.000001192092903}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[9.5699,0],[3.7345,0],[0,3.7352],[3.7345,7.4697],[9.5699,7.4697],[13.3051,3.7352],[9.5699,0],[9.5699,0]],"i":[[0,0],[0,0],[0,-2.062],[-2.062,0],[0,0],[0,2.062],[2.062,0],[0,0]],"o":[[0,0],[-2.062,0],[0,2.0613],[0,0],[2.0619999999999994,0],[0,-2.062],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[0.1843137254901961,0.7764705882352941,0.9647058823529412,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":44,"hd":false,"nm":"Path - Null","parent":35,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":30.000001192092903},"p":{"a":0,"k":[17.42819999999999,13.6558]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":45,"hd":false,"nm":"Path","parent":44,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":30.000001192092903}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[9.5706,0],[3.7352,0],[0,3.7352],[3.064,7.4095],[3.3993,7.4396],[3.5675,7.4524],[3.7352,7.4621],[3.9032,7.4681],[4.0717,7.4697],[9.5706,7.4697],[13.3051,3.7352],[10.2418,0.0602],[9.9065,0.0301],[9.7383,0.0173],[9.5706,0.0076],[9.4026,0.0016],[9.2341,0],[9.5706,0],[9.5706,0]],"i":[[0,0],[0,0],[0,-2.062],[-1.742,-0.3163],[-0.0593,-0.0053],[-0.0594,-0.0038],[-0.0595,-0.0023],[-0.0596,-0.0015],[-0.0597,0],[0,0],[0,2.062],[1.7419,0.3164],[0.0593,0.0053],[0.0594,0.0038],[0.0595,0.0023],[0.0596,0.0015],[0.0597,0],[0,0],[0,0]],"o":[[0,0],[-2.062,0],[0,1.8328999999999995],[0,0],[0.05929999999999991,0.005300000000000082],[0.05940000000000012,0.0038000000000000256],[0.059499999999999886,0.0022999999999999687],[0.0596000000000001,0.0015000000000000568],[0.05970000000000031,0],[2.0619999999999994,0],[0,-1.8329],[0,0],[-0.05930000000000035,-0.005299999999999999],[-0.05940000000000012,-0.0037999999999999996],[-0.059499999999999886,-0.0023],[-0.05959999999999965,-0.0015],[-0.05969999999999942,0],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[0.1843137254901961,0.7764705882352941,0.9647058823529412,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":46,"hd":false,"nm":"Path - Null","parent":35,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":30.000001192092903},"p":{"a":0,"k":[0,13.6563]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":47,"hd":false,"nm":"Path","parent":46,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":30.000001192092903}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[9.5703,0],[3.7348,0],[0.0001,3.7352],[3.7348,7.4697],[9.5703,7.4697],[13.3052,3.7352],[9.5703,0],[9.5703,0]],"i":[[0,0],[0,0],[0,-2.062],[-2.062,0],[0,0],[0,2.062],[2.0617,0],[0,0]],"o":[[0,0],[-2.0619,0],[0,2.0620000000000003],[0,0],[2.0617,0],[0,-2.062],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[0.1843137254901961,0.7764705882352941,0.9647058823529412,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":48,"hd":false,"nm":"Path - Null","parent":35,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":30.000001192092903},"p":{"a":0,"k":[34.8569,27.271]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":49,"hd":false,"nm":"Path","parent":48,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":30.000001192092903}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[9.5699,0],[3.7345,0],[0,3.7352],[3.0633,7.4095],[3.3986,7.4396],[3.5668,7.4524],[3.7345,7.4621],[3.9025,7.4681],[4.071,7.4697],[9.5699,7.4697],[13.3051,3.7352],[10.2411,0.0602],[9.9058,0.0301],[9.7376,0.0173],[9.5699,0.0076],[9.4019,0.0016],[9.2334,0],[9.5699,0],[9.5699,0]],"i":[[0,0],[0,0],[0,-2.062],[-1.7419,-0.3163],[-0.0593,-0.0053],[-0.0594,-0.0038],[-0.0595,-0.0023],[-0.0596,-0.0015],[-0.0597,0],[0,0],[0,2.062],[1.742,0.3164],[0.0593,0.0053],[0.0594,0.0038],[0.0595,0.0023],[0.0596,0.0015],[0.0597,0],[0,0],[0,0]],"o":[[0,0],[-2.062,0],[0,1.8328999999999995],[0,0],[0.05929999999999991,0.005300000000000082],[0.05940000000000012,0.0038000000000000256],[0.059499999999999886,0.0022999999999999687],[0.0596000000000001,0.0015000000000000568],[0.05970000000000031,0],[2.0619999999999994,0],[0,-1.8329],[0,0],[-0.05930000000000035,-0.005299999999999999],[-0.05940000000000012,-0.0037999999999999996],[-0.059499999999999886,-0.0023],[-0.05959999999999965,-0.0015],[-0.05969999999999942,0],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[0.1843137254901961,0.7764705882352941,0.9647058823529412,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":50,"hd":false,"nm":"Path - Null","parent":35,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":30.000001192092903},"p":{"a":0,"k":[17.42819999999999,27.2715]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":51,"hd":false,"nm":"Path","parent":50,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":30.000001192092903}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[9.5706,0],[3.7352,0],[0,3.7352],[3.7352,7.4697],[9.5706,7.4697],[13.3051,3.7352],[9.5707,0],[9.5708,0],[9.5706,0]],"i":[[0,0],[0,0],[0,-2.062],[-2.062,0],[0,0],[0,2.062],[2.062,0],[0,0],[0,0]],"o":[[0,0],[-2.062,0],[0,2.0620000000000003],[0,0],[2.0619999999999994,0],[0,-2.062],[0,0],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[0.1843137254901961,0.7764705882352941,0.9647058823529412,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":52,"hd":false,"nm":"Path - Null","parent":35,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":30.000001192092903},"p":{"a":0,"k":[0,27.27290000000001]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":53,"hd":false,"nm":"Path","parent":52,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":30.000001192092903}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[9.5703,0],[3.7348,0],[0.0001,3.7345],[3.7348,7.469],[9.5703,7.469],[13.3052,3.7346],[9.5703,0.0002],[9.5703,0.0001],[9.5702,0],[9.5703,0]],"i":[[0,0],[0,0],[0,-2.062],[-2.062,0],[0,0],[0,2.062],[2.0617,0],[0,0],[0,0],[0,0]],"o":[[0,0],[-2.0619,0],[0,2.062],[0,0],[2.0617,0],[0,-2.062],[0,0],[0,0],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[0.1843137254901961,0.7764705882352941,0.9647058823529412,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]}]},{"nm":"[GROUP] Screen - Null / Screen / buttons / line - Null / line / Shape - Null / Shape - Stroke / Shape / Shape","fr":60,"id":"llb2yki6niq8w4j04lo","layers":[{"ty":3,"ddd":0,"ind":54,"hd":false,"nm":"Terminal - Null","ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[68,33]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":3,"ddd":0,"ind":55,"hd":false,"nm":"Screen - Null","parent":54,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[8,9]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":56,"hd":false,"nm":"Screen","parent":55,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[5,0],[53,0],[58,5],[58,29],[53,34],[5,34],[0,29],[0,5],[5,0],[5,0]],"i":[[0,0],[0,0],[0,-2.7614],[0,0],[2.7614,0],[0,0],[0,2.7614],[0,0],[-2.7614,0],[0,0]],"o":[[0,0],[2.761420000000001,0],[0,0],[0,2.761420000000001],[0,0],[-2.76142,0],[0,0],[0,-2.76142],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[0.1843137254901961,0.7764705882352941,0.9647058823529412,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ddd":0,"ind":57,"ty":0,"nm":"buttons","refId":"llb2yki6vvi0p4o8vfr","sr":1,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"ao":0,"w":198,"h":172,"ip":0,"op":108.00000429153444,"st":0,"hd":false,"bm":0},{"ty":3,"ddd":0,"ind":58,"hd":false,"nm":"line - Null","parent":54,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[23,52]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":59,"hd":false,"nm":"line","parent":58,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[1.2172,0],[29.2132,0],[30.4304,1.2172],[30.4304,1.2172],[29.2132,2.4344],[1.2172,2.4344],[0,1.2172],[0,1.2172],[1.2172,0],[1.2172,0]],"i":[[0,0],[0,0],[0,-0.6722],[0,0],[0.6722,0],[0,0],[0,0.6722],[0,0],[-0.6722,0],[0,0]],"o":[[0,0],[0.6722399999999986,0],[0,0],[0,0.67224],[0,0],[-0.67224,0],[0,0],[0,-0.67224],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[0.7568627450980392,0.9333333333333333,0.9882352941176471,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":60,"hd":false,"nm":"Shape - Null","parent":54,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[0,0]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ddd":0,"ind":61,"hd":false,"nm":"Shape - Stroke","parent":60,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"ty":4,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[66.3801,0],[74.535,7.3139],[74.5739,8.0416],[74.5777,8.1225],[74.5802,8.2029],[74.5822,8.2839],[74.5829,8.3644],[74.5829,51.6925],[73.5586,53.677],[71.1117,57.5524],[70.1414,59.3174],[70.1092,59.3891],[70.0823,59.463],[70.0607,59.5386],[70.0447,59.6157],[70.0182,59.9304],[70.0168,103.8715],[62.7031,112.0263],[61.9754,112.0652],[61.8945,112.069],[61.8141,112.0715],[61.7331,112.0735],[61.6526,112.0742],[12.7679,112.0742],[4.613,104.7605],[4.5741,104.0328],[4.5703,103.9519],[4.5678,103.8715],[4.5658,103.7905],[4.5651,103.71],[4.5651,59.2982],[3.5388,57.2986],[0.7363,52.8198],[0.1202,51.6434],[0.0892,51.5704],[0.0633,51.4956],[0.0423,51.4192],[0.0266,51.3417],[0.0001,51.025],[0.0001,8.203],[7.314,0.0481],[8.0417,0.0092],[8.1226,0.0054],[8.203,0.0029],[8.284,0.0009],[8.3645,0.0002],[65.1766,0],[65.7694,0.0294],[66.3568,0.117],[66.9322,0.2628],[67.4908,0.4644],[66.3801,0],[66.3801,0]],"i":[[0,0],[-0.4435,-4.0906],[-0.0015,-0.0282],[-0.0009,-0.0282],[-0.0009,-0.0282],[-0.0003,-0.0282],[0.0003,-0.0283],[0,0],[0.5951,-0.9669],[0,0],[0.0123,-0.0248],[0.0104,-0.0256],[0.0085,-0.0263],[0.0066,-0.0269],[0.0046,-0.0273],[0,-0.1584],[0,0],[4.0908,-0.4434],[0.0282,-0.0015],[0.0282,-0.0009],[0.0282,-0.0009],[0.0282,-0.0003],[0.0283,0.0003],[0,0],[0.4435,4.0909],[0.0015,0.0282],[0.0009,0.0282],[0.0009,0.0282],[0.0003,0.0282],[-0.0003,0.0283],[0,0],[0.5962,0.972],[0,0],[0.0117,0.0253],[0.0099,0.0259],[0.0083,0.0266],[0.0064,0.0271],[0.0047,0.0275],[0,0.1594],[0,0],[-4.0906,0.4435],[-0.0282,0.0015],[-0.0282,0.0009],[-0.0282,0.0009],[-0.0282,0.0003],[-0.0283,-0.0003],[-0.2088,0],[-0.2076,-0.0204],[-0.2046,-0.0408],[-0.1998,-0.0612],[-0.1926,-0.0804],[0,0],[0,0]],"o":[[4.243799999999993,0],[0,0],[0.0014999999999929514,0.028200000000000003],[0.0009000000000014552,0.028200000000000003],[0.0009000000000014552,0.028200000000000003],[0.0002999999999957481,0.028200000000000003],[-0.0002999999999957481,0.02829999999999977],[0,0.25150000000000006],[0,0],[-0.5045999999999964,0.8216999999999999],[-0.012299999999996203,0.024799999999999045],[-0.010400000000004184,0.02559999999999718],[-0.008499999999997954,0.026299999999999102],[-0.0066000000000059345,0.026899999999997704],[-0.004599999999996385,0.02729999999999677],[0,0],[0,4.244500000000002],[0,0],[-0.028199999999998226,0.0014999999999929514],[-0.028199999999998226,0.0009000000000014552],[-0.028199999999998226,0.0009000000000014552],[-0.028199999999998226,0.0002999999999957481],[-0.028300000000001546,-0.0002999999999957481],[-4.244100000000001,0],[0,0],[-0.0015000000000000568,-0.028199999999998226],[-0.0008999999999996788,-0.028199999999998226],[-0.0008999999999996788,-0.028199999999998226],[-0.000300000000000189,-0.028199999999998226],[0.000300000000000189,-0.028300000000001546],[0,-0.2563000000000031],[0,0],[-0.3305,-0.5617000000000019],[-0.011700000000000002,-0.025300000000001432],[-0.009900000000000006,-0.025900000000000034],[-0.008300000000000002,-0.026600000000001955],[-0.006400000000000003,-0.027099999999997237],[-0.004699999999999999,-0.02750000000000341],[0,0],[0,-4.244],[0,0],[0.028200000000000003,-0.0014999999999999996],[0.028200000000000003,-0.0008999999999999998],[0.028200000000000003,-0.0008999999999999998],[0.028200000000000003,-0.0002999999999999999],[0.02829999999999977,0.00030000000000000003],[0.20879999999999654,0],[0.20759999999999934,0.020399999999999998],[0.20459999999999923,0.04079999999999999],[0.1997999999999962,0.06119999999999998],[0.19259999999999877,0.08039999999999997],[0,0],[0,0]]}}},{"ty":"st","o":{"a":0,"k":100},"w":{"a":0,"k":2},"c":{"a":0,"k":[0.11764705882352941,0.7764705882352941,0.9803921568627451,1]},"ml":4,"lc":1,"lj":1,"nm":"Stroke","hd":false},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]},{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"rc","nm":"Rectangle","hd":false,"p":{"a":0,"k":[37.79145,56.5371]},"s":{"a":0,"k":[151.1658,226.1484]},"r":{"a":0,"k":0}},{"ty":"fl","o":{"a":0,"k":0},"c":{"a":0,"k":[0,1,0,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}],"hasMask":true,"masksProperties":[{"nm":"Mask","pt":{"a":0,"k":{"c":true,"v":[[66.3801,0],[74.535,7.3139],[74.5739,8.0416],[74.5777,8.1225],[74.5802,8.2029],[74.5822,8.2839],[74.5829,8.3644],[74.5829,51.6925],[73.5586,53.677],[71.1117,57.5524],[70.1414,59.3174],[70.1092,59.3891],[70.0823,59.463],[70.0607,59.5386],[70.0447,59.6157],[70.0182,59.9304],[70.0168,103.8715],[62.7031,112.0263],[61.9754,112.0652],[61.8945,112.069],[61.8141,112.0715],[61.7331,112.0735],[61.6526,112.0742],[12.7679,112.0742],[4.613,104.7605],[4.5741,104.0328],[4.5703,103.9519],[4.5678,103.8715],[4.5658,103.7905],[4.5651,103.71],[4.5651,59.2982],[3.5388,57.2986],[0.7363,52.8198],[0.1202,51.6434],[0.0892,51.5704],[0.0633,51.4956],[0.0423,51.4192],[0.0266,51.3417],[0.0001,51.025],[0.0001,8.203],[7.314,0.0481],[8.0417,0.0092],[8.1226,0.0054],[8.203,0.0029],[8.284,0.0009],[8.3645,0.0002],[65.1766,0],[65.7694,0.0294],[66.3568,0.117],[66.9322,0.2628],[67.4908,0.4644],[66.3801,0],[66.3801,0]],"i":[[0,0],[-0.4435,-4.0906],[-0.0015,-0.0282],[-0.0009,-0.0282],[-0.0009,-0.0282],[-0.0003,-0.0282],[0.0003,-0.0283],[0,0],[0.5951,-0.9669],[0,0],[0.0123,-0.0248],[0.0104,-0.0256],[0.0085,-0.0263],[0.0066,-0.0269],[0.0046,-0.0273],[0,-0.1584],[0,0],[4.0908,-0.4434],[0.0282,-0.0015],[0.0282,-0.0009],[0.0282,-0.0009],[0.0282,-0.0003],[0.0283,0.0003],[0,0],[0.4435,4.0909],[0.0015,0.0282],[0.0009,0.0282],[0.0009,0.0282],[0.0003,0.0282],[-0.0003,0.0283],[0,0],[0.5962,0.972],[0,0],[0.0117,0.0253],[0.0099,0.0259],[0.0083,0.0266],[0.0064,0.0271],[0.0047,0.0275],[0,0.1594],[0,0],[-4.0906,0.4435],[-0.0282,0.0015],[-0.0282,0.0009],[-0.0282,0.0009],[-0.0282,0.0003],[-0.0283,-0.0003],[-0.2088,0],[-0.2076,-0.0204],[-0.2046,-0.0408],[-0.1998,-0.0612],[-0.1926,-0.0804],[0,0],[0,0]],"o":[[4.243799999999993,0],[0,0],[0.0014999999999929514,0.028200000000000003],[0.0009000000000014552,0.028200000000000003],[0.0009000000000014552,0.028200000000000003],[0.0002999999999957481,0.028200000000000003],[-0.0002999999999957481,0.02829999999999977],[0,0.25150000000000006],[0,0],[-0.5045999999999964,0.8216999999999999],[-0.012299999999996203,0.024799999999999045],[-0.010400000000004184,0.02559999999999718],[-0.008499999999997954,0.026299999999999102],[-0.0066000000000059345,0.026899999999997704],[-0.004599999999996385,0.02729999999999677],[0,0],[0,4.244500000000002],[0,0],[-0.028199999999998226,0.0014999999999929514],[-0.028199999999998226,0.0009000000000014552],[-0.028199999999998226,0.0009000000000014552],[-0.028199999999998226,0.0002999999999957481],[-0.028300000000001546,-0.0002999999999957481],[-4.244100000000001,0],[0,0],[-0.0015000000000000568,-0.028199999999998226],[-0.0008999999999996788,-0.028199999999998226],[-0.0008999999999996788,-0.028199999999998226],[-0.000300000000000189,-0.028199999999998226],[0.000300000000000189,-0.028300000000001546],[0,-0.2563000000000031],[0,0],[-0.3305,-0.5617000000000019],[-0.011700000000000002,-0.025300000000001432],[-0.009900000000000006,-0.025900000000000034],[-0.008300000000000002,-0.026600000000001955],[-0.006400000000000003,-0.027099999999997237],[-0.004699999999999999,-0.02750000000000341],[0,0],[0,-4.244],[0,0],[0.028200000000000003,-0.0014999999999999996],[0.028200000000000003,-0.0008999999999999998],[0.028200000000000003,-0.0008999999999999998],[0.028200000000000003,-0.0002999999999999999],[0.02829999999999977,0.00030000000000000003],[0.20879999999999654,0],[0.20759999999999934,0.020399999999999998],[0.20459999999999923,0.04079999999999999],[0.1997999999999962,0.06119999999999998],[0.19259999999999877,0.08039999999999997],[0,0],[0,0]]}},"o":{"a":0,"k":100},"mode":"a","x":{"a":0,"k":0}}]},{"ty":4,"ddd":0,"ind":62,"hd":false,"nm":"Shape","parent":60,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[66.3801,0],[74.535,7.3139],[74.5739,8.0416],[74.5777,8.1225],[74.5802,8.2029],[74.5822,8.2839],[74.5829,8.3644],[74.5829,51.6925],[73.5586,53.677],[71.1117,57.5524],[70.1414,59.3174],[70.1092,59.3891],[70.0823,59.463],[70.0607,59.5386],[70.0447,59.6157],[70.0182,59.9304],[70.0168,103.8715],[62.7031,112.0263],[61.9754,112.0652],[61.8945,112.069],[61.8141,112.0715],[61.7331,112.0735],[61.6526,112.0742],[12.7679,112.0742],[4.613,104.7605],[4.5741,104.0328],[4.5703,103.9519],[4.5678,103.8715],[4.5658,103.7905],[4.5651,103.71],[4.5651,59.2982],[3.5388,57.2986],[0.7363,52.8198],[0.1202,51.6434],[0.0892,51.5704],[0.0633,51.4956],[0.0423,51.4192],[0.0266,51.3417],[0.0001,51.025],[0.0001,8.203],[7.314,0.0481],[8.0417,0.0092],[8.1226,0.0054],[8.203,0.0029],[8.284,0.0009],[8.3645,0.0002],[65.1766,0],[65.7694,0.0294],[66.3568,0.117],[66.9322,0.2628],[67.4908,0.4644],[66.3801,0],[66.3801,0]],"i":[[0,0],[-0.4435,-4.0906],[-0.0015,-0.0282],[-0.0009,-0.0282],[-0.0009,-0.0282],[-0.0003,-0.0282],[0.0003,-0.0283],[0,0],[0.5951,-0.9669],[0,0],[0.0123,-0.0248],[0.0104,-0.0256],[0.0085,-0.0263],[0.0066,-0.0269],[0.0046,-0.0273],[0,-0.1584],[0,0],[4.0908,-0.4434],[0.0282,-0.0015],[0.0282,-0.0009],[0.0282,-0.0009],[0.0282,-0.0003],[0.0283,0.0003],[0,0],[0.4435,4.0909],[0.0015,0.0282],[0.0009,0.0282],[0.0009,0.0282],[0.0003,0.0282],[-0.0003,0.0283],[0,0],[0.5962,0.972],[0,0],[0.0117,0.0253],[0.0099,0.0259],[0.0083,0.0266],[0.0064,0.0271],[0.0047,0.0275],[0,0.1594],[0,0],[-4.0906,0.4435],[-0.0282,0.0015],[-0.0282,0.0009],[-0.0282,0.0009],[-0.0282,0.0003],[-0.0283,-0.0003],[-0.2088,0],[-0.2076,-0.0204],[-0.2046,-0.0408],[-0.1998,-0.0612],[-0.1926,-0.0804],[0,0],[0,0]],"o":[[4.243799999999993,0],[0,0],[0.0014999999999929514,0.028200000000000003],[0.0009000000000014552,0.028200000000000003],[0.0009000000000014552,0.028200000000000003],[0.0002999999999957481,0.028200000000000003],[-0.0002999999999957481,0.02829999999999977],[0,0.25150000000000006],[0,0],[-0.5045999999999964,0.8216999999999999],[-0.012299999999996203,0.024799999999999045],[-0.010400000000004184,0.02559999999999718],[-0.008499999999997954,0.026299999999999102],[-0.0066000000000059345,0.026899999999997704],[-0.004599999999996385,0.02729999999999677],[0,0],[0,4.244500000000002],[0,0],[-0.028199999999998226,0.0014999999999929514],[-0.028199999999998226,0.0009000000000014552],[-0.028199999999998226,0.0009000000000014552],[-0.028199999999998226,0.0002999999999957481],[-0.028300000000001546,-0.0002999999999957481],[-4.244100000000001,0],[0,0],[-0.0015000000000000568,-0.028199999999998226],[-0.0008999999999996788,-0.028199999999998226],[-0.0008999999999996788,-0.028199999999998226],[-0.000300000000000189,-0.028199999999998226],[0.000300000000000189,-0.028300000000001546],[0,-0.2563000000000031],[0,0],[-0.3305,-0.5617000000000019],[-0.011700000000000002,-0.025300000000001432],[-0.009900000000000006,-0.025900000000000034],[-0.008300000000000002,-0.026600000000001955],[-0.006400000000000003,-0.027099999999997237],[-0.004699999999999999,-0.02750000000000341],[0,0],[0,-4.244],[0,0],[0.028200000000000003,-0.0014999999999999996],[0.028200000000000003,-0.0008999999999999998],[0.028200000000000003,-0.0008999999999999998],[0.028200000000000003,-0.0002999999999999999],[0.02829999999999977,0.00030000000000000003],[0.20879999999999654,0],[0.20759999999999934,0.020399999999999998],[0.20459999999999923,0.04079999999999999],[0.1997999999999962,0.06119999999999998],[0.19259999999999877,0.08039999999999997],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[1,1,1,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":4,"ddd":0,"ind":63,"hd":false,"nm":"Shape","parent":60,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[66.3801,0],[74.535,7.3139],[74.5739,8.0416],[74.5777,8.1225],[74.5802,8.2029],[74.5822,8.2839],[74.5829,8.3644],[74.5829,51.6925],[73.5586,53.677],[71.1117,57.5524],[70.1414,59.3174],[70.1092,59.3891],[70.0823,59.463],[70.0607,59.5386],[70.0447,59.6157],[70.0182,59.9304],[70.0168,103.8715],[62.7031,112.0263],[61.9754,112.0652],[61.8945,112.069],[61.8141,112.0715],[61.7331,112.0735],[61.6526,112.0742],[12.7679,112.0742],[4.613,104.7605],[4.5741,104.0328],[4.5703,103.9519],[4.5678,103.8715],[4.5658,103.7905],[4.5651,103.71],[4.5651,59.2982],[3.5388,57.2986],[0.7363,52.8198],[0.1202,51.6434],[0.0892,51.5704],[0.0633,51.4956],[0.0423,51.4192],[0.0266,51.3417],[0.0001,51.025],[0.0001,8.203],[7.314,0.0481],[8.0417,0.0092],[8.1226,0.0054],[8.203,0.0029],[8.284,0.0009],[8.3645,0.0002],[65.1766,0],[65.7694,0.0294],[66.3568,0.117],[66.9322,0.2628],[67.4908,0.4644],[66.3801,0],[66.3801,0]],"i":[[0,0],[-0.4435,-4.0906],[-0.0015,-0.0282],[-0.0009,-0.0282],[-0.0009,-0.0282],[-0.0003,-0.0282],[0.0003,-0.0283],[0,0],[0.5951,-0.9669],[0,0],[0.0123,-0.0248],[0.0104,-0.0256],[0.0085,-0.0263],[0.0066,-0.0269],[0.0046,-0.0273],[0,-0.1584],[0,0],[4.0908,-0.4434],[0.0282,-0.0015],[0.0282,-0.0009],[0.0282,-0.0009],[0.0282,-0.0003],[0.0283,0.0003],[0,0],[0.4435,4.0909],[0.0015,0.0282],[0.0009,0.0282],[0.0009,0.0282],[0.0003,0.0282],[-0.0003,0.0283],[0,0],[0.5962,0.972],[0,0],[0.0117,0.0253],[0.0099,0.0259],[0.0083,0.0266],[0.0064,0.0271],[0.0047,0.0275],[0,0.1594],[0,0],[-4.0906,0.4435],[-0.0282,0.0015],[-0.0282,0.0009],[-0.0282,0.0009],[-0.0282,0.0003],[-0.0283,-0.0003],[-0.2088,0],[-0.2076,-0.0204],[-0.2046,-0.0408],[-0.1998,-0.0612],[-0.1926,-0.0804],[0,0],[0,0]],"o":[[4.243799999999993,0],[0,0],[0.0014999999999929514,0.028200000000000003],[0.0009000000000014552,0.028200000000000003],[0.0009000000000014552,0.028200000000000003],[0.0002999999999957481,0.028200000000000003],[-0.0002999999999957481,0.02829999999999977],[0,0.25150000000000006],[0,0],[-0.5045999999999964,0.8216999999999999],[-0.012299999999996203,0.024799999999999045],[-0.010400000000004184,0.02559999999999718],[-0.008499999999997954,0.026299999999999102],[-0.0066000000000059345,0.026899999999997704],[-0.004599999999996385,0.02729999999999677],[0,0],[0,4.244500000000002],[0,0],[-0.028199999999998226,0.0014999999999929514],[-0.028199999999998226,0.0009000000000014552],[-0.028199999999998226,0.0009000000000014552],[-0.028199999999998226,0.0002999999999957481],[-0.028300000000001546,-0.0002999999999957481],[-4.244100000000001,0],[0,0],[-0.0015000000000000568,-0.028199999999998226],[-0.0008999999999996788,-0.028199999999998226],[-0.0008999999999996788,-0.028199999999998226],[-0.000300000000000189,-0.028199999999998226],[0.000300000000000189,-0.028300000000001546],[0,-0.2563000000000031],[0,0],[-0.3305,-0.5617000000000019],[-0.011700000000000002,-0.025300000000001432],[-0.009900000000000006,-0.025900000000000034],[-0.008300000000000002,-0.026600000000001955],[-0.006400000000000003,-0.027099999999997237],[-0.004699999999999999,-0.02750000000000341],[0,0],[0,-4.244],[0,0],[0.028200000000000003,-0.0014999999999999996],[0.028200000000000003,-0.0008999999999999998],[0.028200000000000003,-0.0008999999999999998],[0.028200000000000003,-0.0002999999999999999],[0.02829999999999977,0.00030000000000000003],[0.20879999999999654,0],[0.20759999999999934,0.020399999999999998],[0.20459999999999923,0.04079999999999999],[0.1997999999999962,0.06119999999999998],[0.19259999999999877,0.08039999999999997],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[1,1,1,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]},{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"rc","nm":"Rectangle","hd":false,"p":{"a":0,"k":[37.79145,56.5371]},"s":{"a":0,"k":[151.1658,226.1484]},"r":{"a":0,"k":0}},{"ty":"fl","o":{"a":0,"k":0},"c":{"a":0,"k":[0,1,0,1]},"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}],"ef":[{"nm":"DropShadow","ty":25,"en":1,"ef":[{"ty":2,"v":{"a":0,"k":[0,0.29411764705882354,0.38823529411764707,1]}},{"ty":0,"v":{"a":0,"k":9}},{"ty":1,"v":{"a":0,"k":1.5707963267948966}},{"ty":0,"v":{"a":0,"k":-1}},{"ty":0,"v":{"a":0,"k":3}}]}]}]},{"nm":"[GROUP] Path - Null / Path / Subtract - Null / Subtract / Subtract - Null / Subtract / Subtract - Null / Subtract / Subtract - Null / Subtract","fr":60,"id":"llb2ykir6228wksz2qp","layers":[{"ty":3,"ddd":0,"ind":64,"hd":false,"nm":"periphery - Null","ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[-0.3135,-5.7292]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":3,"ddd":0,"ind":65,"hd":false,"nm":"Path - Null","parent":64,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":7.999999821186066},"p":{"a":0,"k":[179.3135,26.7292]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":66,"hd":false,"nm":"Path","parent":65,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":7.999999821186066}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[14.6844,11.9938],[4.4375,11.9938],[4.1768,11.985],[-0.0001,8.0753],[1.2549,5.3088],[2.6825,4.4467],[2.6691,4.1267],[3.9934,1.2076],[7.1867,0],[10.8886,1.774],[12.1245,1.5809],[15.794,4.625],[18.9998,8.2728],[14.9195,12],[14.6843,11.9938],[14.6844,11.9938]],"i":[[0,0],[0,0],[0.0861,0.0058],[0.0001,2.1295],[-0.8029,0.7335],[-0.5294,0.1947],[0,0.1077],[-0.8472,0.7739],[-1.1974,-0.0007],[-0.8138,-1.0707],[-0.4334,-0.0002],[-0.1823,-1.7071],[0.0016,-1.7872],[2.2519,0.0008],[0.0778,0.0041],[0,0]],"o":[[0,0],[-0.08767999999999976,0],[-2.31582,-0.04823000000000022],[0.00067,-1.0379000000000005],[0.4115599999999999,-0.3759699999999997],[-0.008859999999999868,-0.10561000000000043],[0.0007299999999998974,-1.0951399999999998],[0.8472000000000004,-0.77391],[1.53383,0.00171],[0.3864800000000006,-0.12524000000000002],[1.91465,0.0021100000000000563],[1.8345699999999994,0.3658000000000001],[-0.0018700000000002603,2.0595999999999997],[-0.07896000000000036,-0.000030000000000640625],[0,0],[0,0]]}}},{"ty":"fl","o":{"a":0,"k":100},"c":{"a":0,"k":[0.11764705882352941,0.7764705882352941,0.9803921568627451,1]},"nm":"Fill","hd":false,"r":2},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":67,"hd":false,"nm":"Subtract - Null","parent":64,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[164.3135,155.7292]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":68,"hd":false,"nm":"Subtract","parent":67,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":4,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[6.5202,13.0404],[13.0404,6.5202],[6.5202,0],[0,6.5202],[6.5202,13.0404],[6.5202,13.0404]],"i":[[0,0],[0,3.601],[3.601,0],[0,-3.601],[-3.601,0],[0,0]],"o":[[3.601,0],[0,-3.60101],[-3.60101,0],[0,3.601],[0,0],[0,0]]}}},{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[6.5204,9.6471],[9.6474,6.5201],[6.5204,3.3931],[3.3934,6.5201],[6.5204,9.6471],[6.5204,9.6471]],"i":[[0,0],[0,1.727],[1.727,0],[0,-1.727],[-1.727,0],[0,0]],"o":[[1.72701,0],[0,-1.72701],[-1.72701,0],[0,1.727009999999999],[0,0],[0,0]]}}},{"ty":"gf","o":{"a":0,"k":10.00000014901161},"g":{"p":2,"k":{"a":0,"k":[0,0.11764705882352941,0.7764705882352941,0.9803921568627451,1,0.11764705882352941,0.7764705882352941,0.9803921568627451,0,1,1,1]}},"s":{"a":0,"k":[13.0404,0]},"e":{"a":0,"k":[13.0404,13.0404]},"t":1,"nm":"Fill","hd":false,"r":2},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":69,"hd":false,"nm":"Subtract - Null","parent":64,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[149.8174,0]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":70,"hd":false,"nm":"Subtract","parent":69,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[4.8112,2.4056],[2.4056,4.8112],[0,2.4056],[2.4056,0],[4.8112,2.4056],[4.8112,2.4056]],"i":[[0,0],[1.3286,0],[0,1.3286],[-1.3286,0],[0,-1.3286],[0,0]],"o":[[0,1.32858],[-1.32858,0],[0,-1.32858],[1.32858,0],[0,0],[0,0]]}}},{"ty":"gf","o":{"a":0,"k":10.00000014901161},"g":{"p":2,"k":{"a":0,"k":[0,0.11764705882352941,0.7764705882352941,0.9803921568627451,1,0.11764705882352941,0.7764705882352941,0.9803921568627451,0,1,1,1]}},"s":{"a":0,"k":[-7.182999608998969,-4.356210405371626]},"e":{"a":0,"k":[-7.182999608998968,6.073743073016745]},"t":1,"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":71,"hd":false,"nm":"Subtract - Null","parent":64,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[28.3026,15.1619]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":72,"hd":false,"nm":"Subtract","parent":71,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":4,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[5.215,10.43],[10.43,5.215],[5.215,0],[0,5.215],[5.215,10.43],[5.215,10.43]],"i":[[0,0],[0,2.8802],[2.8802,0],[0,-2.8802],[-2.8802,0],[0,0]],"o":[[2.8801699999999997,0],[0,-2.88016],[-2.88016,0],[0,2.8801699999999997],[0,0],[0,0]]}}},{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[5.215,7.5223],[7.5223,5.215],[5.215,2.9077],[2.9077,5.215],[5.215,7.5223],[5.215,7.5223]],"i":[[0,0],[0,1.2743],[1.2743,0],[0,-1.2743],[-1.2743,0],[0,0]],"o":[[1.2743000000000002,0],[0,-1.2743099999999998],[-1.2743099999999998,0],[0,1.2743000000000002],[0,0],[0,0]]}}},{"ty":"gf","o":{"a":0,"k":10.00000014901161},"g":{"p":2,"k":{"a":0,"k":[0,0.11764705882352941,0.7764705882352941,0.9803921568627451,1,0.11764705882352941,0.7764705882352941,0.9803921568627451,0,1,1,1]}},"s":{"a":0,"k":[10.43,0]},"e":{"a":0,"k":[10.43,10.43]},"t":1,"nm":"Fill","hd":false,"r":2},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]},{"ty":3,"ddd":0,"ind":73,"hd":false,"nm":"Subtract - Null","parent":64,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[0,42.455]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":74,"hd":false,"nm":"Subtract","parent":73,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":4,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[7.0239,14.0478],[14.0478,7.0239],[7.0239,0],[0,7.0239],[7.0239,14.0478],[7.0239,14.0478]],"i":[[0,0],[0,3.8792],[3.8792,0],[0,-3.8792],[-3.8792,0],[0,0]],"o":[[3.8791900000000004,0],[0,-3.8792],[-3.8792,0],[0,3.8791900000000004],[0,0],[0,0]]}}},{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[7.0239,10.382],[10.382,7.0239],[7.0239,3.6658],[3.6658,7.0239],[7.0239,10.382],[7.0239,10.382]],"i":[[0,0],[0,1.8546],[1.8546,0],[0,-1.8547],[-1.8546,0],[0,0]],"o":[[1.8546400000000007,0],[0,-1.8546500000000004],[-1.8546399999999998,0],[0,1.8546400000000007],[0,0],[0,0]]}}},{"ty":"gf","o":{"a":0,"k":10.00000014901161},"g":{"p":2,"k":{"a":0,"k":[0,0.11764705882352941,0.7764705882352941,0.9803921568627451,1,0.11764705882352941,0.7764705882352941,0.9803921568627451,0,1,1,1]}},"s":{"a":0,"k":[14.0478,-4.9907809915606085e-14]},"e":{"a":0,"k":[14.0478,14.04779999999995]},"t":1,"nm":"Fill","hd":false,"r":2},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]}]},{"nm":"Terminal loader","fr":60,"id":"llb2yki0rxnuvunb2uk","layers":[{"ty":3,"ddd":0,"ind":75,"hd":false,"nm":"Terminal loader - Null","ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[0,0]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ddd":0,"ind":76,"ty":0,"nm":"3rd","refId":"llb2yki0mxznafpwts","sr":1,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":1,"k":[{"t":90.0000035762787,"s":[0],"o":{"x":[0],"y":[0]},"i":{"x":[0.58],"y":[1]}},{"t":108.00000429153444,"s":[80]}]}},"ao":0,"w":198,"h":172,"ip":0,"op":108.00000429153444,"st":0,"hd":false,"bm":0},{"ddd":0,"ind":77,"ty":0,"nm":"2nd","refId":"llb2yki3bwcw6kh2cwl","sr":1,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":1,"k":[{"t":54.00000214576721,"s":[0],"o":{"x":[0],"y":[0]},"i":{"x":[0.58],"y":[1]}},{"t":72.00000286102296,"s":[80]}]}},"ao":0,"w":198,"h":172,"ip":0,"op":108.00000429153444,"st":0,"hd":false,"bm":0},{"ddd":0,"ind":78,"ty":0,"nm":"1st","refId":"llb2yki4wnqga2mr799","sr":1,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":1,"k":[{"t":18.00000071525574,"s":[0],"o":{"x":[0],"y":[0]},"i":{"x":[0.58],"y":[1]}},{"t":36.000001430511475,"s":[80]}]}},"ao":0,"w":198,"h":172,"ip":0,"op":108.00000429153444,"st":0,"hd":false,"bm":0},{"ddd":0,"ind":79,"ty":0,"nm":"Terminal","refId":"llb2yki6niq8w4j04lo","sr":1,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"ao":0,"w":198,"h":172,"ip":0,"op":108.00000429153444,"st":0,"hd":false,"bm":0},{"ddd":0,"ind":80,"ty":0,"nm":"periphery","refId":"llb2ykir6228wksz2qp","sr":1,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"ao":0,"w":198,"h":172,"ip":0,"op":108.00000429153444,"st":0,"hd":false,"bm":0},{"ty":3,"ddd":0,"ind":81,"hd":false,"nm":"bg - Null","parent":75,"ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[18.8662,0]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ty":4,"ddd":0,"ind":82,"hd":false,"nm":"bg","parent":81,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1,"shapes":[{"ty":"gr","nm":"Group","hd":false,"np":3,"it":[{"ty":"sh","nm":"Path","hd":false,"ks":{"a":0,"k":{"c":true,"v":[[172.1375,86.0688],[86.0688,172.1375],[0,86.0688],[86.0688,0],[172.1375,86.0688],[172.1375,86.0688]],"i":[[0,0],[47.5358,0],[0,47.5358],[-47.5358,0],[0,-47.5358],[0,0]],"o":[[0,47.53580000000001],[-47.5358,0],[0,-47.5358],[47.53580000000001,0],[0,0],[0,0]]}}},{"ty":"gf","o":{"a":0,"k":10.00000014901161},"g":{"p":2,"k":{"a":0,"k":[0,0.11764705882352941,0.7764705882352941,0.9803921568627451,1,0.11764705882352941,0.7764705882352941,0.9803921568627451,0,1,1,1]}},"s":{"a":0,"k":[172.1375,-1.0540382379343967e-14]},"e":{"a":0,"k":[172.1375,172.13749999999996]},"t":1,"nm":"Fill","hd":false,"r":1},{"ty":"tr","a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}}]}]}]}],"layers":[{"ty":3,"ddd":0,"ind":75,"hd":false,"nm":"Terminal loader - Null","ks":{"a":{"a":0,"k":[0,0]},"o":{"a":0,"k":100},"p":{"a":0,"k":[0,0]},"r":{"a":0,"k":0},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0}},"st":0,"ip":0,"op":108.00000429153444,"bm":0,"sr":1},{"ddd":0,"ind":2,"ty":0,"nm":"Terminal loader","refId":"llb2yki0rxnuvunb2uk","sr":1,"ks":{"a":{"a":0,"k":[0,0]},"p":{"a":0,"k":[0,0]},"s":{"a":0,"k":[100,100]},"sk":{"a":0,"k":0},"sa":{"a":0,"k":0},"r":{"a":0,"k":0},"o":{"a":0,"k":100}},"ao":0,"w":198,"h":172,"ip":0,"op":108.00000429153444,"st":0,"hd":false,"bm":0}],"meta":{"a":"","d":"","tc":"","g":"Aninix"}}',
					},
					params: {
						loopMode: 'loop',
						repeatCount: 1,
					},
					autoPlay: true,
				},
			);
		}

		renderTopText()
		{
			let text = '';
			let fontSize = 18;
			let marginBottom = 2;

			// eslint-disable-next-line default-case
			switch (this.state.status)
			{
				case STATUSES.creating:
					text = Loc.getMessage('M_CRM_TL_EPC_FINISH_STEP_CREATING_PAYMENT');
					fontSize = 16;
					marginBottom = 4;
					break;

				case STATUSES.success:
					text = Loc.getMessage('M_CRM_TL_EPC_FINISH_STEP_SENT_TO_TERMINAL');
					break;

				case STATUSES.error:
					text = Loc.getMessage('M_CRM_TL_EPC_FINISH_STEP_ERROR_TITLE');
					break;
			}

			return Text({
				text,
				style: {
					fontSize,
					marginBottom,
					color: AppTheme.colors.base2,
					textAlign: 'center',
				},
			});
		}

		renderBottomText()
		{
			let text = '';
			const responsible = this.getResponsible();

			// eslint-disable-next-line default-case
			switch (this.state.status)
			{
				case STATUSES.success:
					if (responsible)
					{
						const locPhrase = responsible.id === this.currentUserId
							? 'M_CRM_TL_EPC_FINISH_STEP_SUCCESS_BOTTOM_TEXT_CASE_SELF'
							: 'M_CRM_TL_EPC_FINISH_STEP_SUCCESS_BOTTOM_TEXT';

						text = Loc.getMessage(locPhrase, {
							'#NAME#': responsible.name,
						});
					}

					break;

				case STATUSES.error:
					text = Loc.getMessage('M_CRM_TL_EPC_FINISH_STEP_ERROR_TEXT');
					break;
			}

			return text && Text({
				text,
				style: {
					fontSize: 17,
					color: AppTheme.colors.base4,
					marginTop: 15,
					textAlign: 'center',
				},
			});
		}

		renderBackButton()
		{
			let additionalStyle = {};
			if (this.state.status === STATUSES.success)
			{
				additionalStyle = {
					color: AppTheme.colors.bgContentPrimary,
					backgroundColor: AppTheme.colors.accentMainPrimary,
				};
			}
			else if (this.state.status === STATUSES.error)
			{
				additionalStyle = {
					color: AppTheme.colors.base1,
					backgroundColor: AppTheme.colors.bgContentPrimary,
					borderColor: AppTheme.colors.base6,
					borderWidth: 1,
				};
			}
			else
			{
				return null;
			}

			return Button({
				testId: 'TerminalEntityPaymentCreateFinishStepBackButton',
				style: {
					height: 44,
					width: 266,
					borderRadius: 512,
					selfAlign: 'center',
					marginTop: 25,
					fontSize: 17,
					...additionalStyle,
				},
				text: getEntityMessage(
					'M_CRM_TL_EPC_FINISH_STEP_BACK_TO',
					this.entityTypeId,
				),
				onClick: () => {
					this.customEventEmitter.emit('TerminalEntityCreatePayment.FinishStepButton::Click');
					layout.close();
				},
			});
		}

		renderOpenPaymentPayButton()
		{
			if (this.state.status !== STATUSES.success)
			{
				return null;
			}

			return Button({
				testId: 'TerminalEntityPaymentCreateFinishStepOpenPaymentButton',
				style: {
					height: 44,
					width: 266,
					borderRadius: 512,
					selfAlign: 'center',
					marginTop: 16,
					fontSize: 17,
					color: AppTheme.colors.base2,
					borderWidth: 1,
					borderColor: AppTheme.colors.base6,
					backgroundColor: AppTheme.colors.bgContentPrimary,
				},
				text: Loc.getMessage('M_CRM_TL_EPC_FINISH_STEP_RECEIVE_PAYMENT'),
				onClick: () => {
					layout.close(() => {
						this.customEventEmitter.emit(
							'TerminalEntityCreatePayment.OpenPaymentPay::Click',
							[this.state.payment.id],
						);
					});
				},
			});
		}

		componentDidMount()
		{
			if (!this.createPayment)
			{
				return;
			}

			this.setState({ status: STATUSES.creating });

			this.showInitialAnimation().then(() => {
				this.finishCreating();
			});

			this.createPayment()
				.then((payment) => {
					this.setState({ payment }, () => {
						this.finishCreating();
					});
				})
				.catch(() => {
					this.setState({
						isError: true,
					}, () => {
						this.finishCreating();
					});
				});
		}

		/**
		 * @return {Promise}
		 */
		showInitialAnimation()
		{
			return new Promise((resolve) => {
				setTimeout(() => {
					this.setState({ initialAnimationFinished: true }, () => {
						resolve();
					});
				}, 2000);
			});
		}

		finishCreating()
		{
			if (this.state.initialAnimationFinished === false)
			{
				return;
			}

			if (this.state.payment)
			{
				this.setState({ status: STATUSES.success });
				Haptics.notifySuccess();
			}
			else if (this.state.isError)
			{
				this.setState({ status: STATUSES.error });
				Haptics.notifyFailure();
			}
		}

		get createPayment()
		{
			return BX.prop.getFunction(this.props, 'createPayment', null);
		}

		get entityTypeId()
		{
			return BX.prop.getInteger(this.props, 'entityTypeId', 0);
		}

		get getResponsible()
		{
			return BX.prop.getFunction(this.props, 'getResponsible', null);
		}

		get currentUserId()
		{
			return BX.prop.getInteger(this.props, 'currentUserId', null);
		}
	}

	module.exports = { Layout };
});
