/**
 * @module crm/mail/message/elements/icon
 */
jn.define('crm/mail/message/elements/icon', (require, exports, module) => {
	const svgIcons = {
		moreBtn: {
			content: '<svg width="30" height="31" viewBox="0 0 30 31" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7.5 18.3955C8.88071 18.3955 10 17.2762 10 15.8955C10 14.5148 8.88071 13.3955 7.5 13.3955C6.11929 13.3955 5 14.5148 5 15.8955C5 17.2762 6.11929 18.3955 7.5 18.3955Z" fill="#D5D7DB"/><path d="M15 18.3955C16.3807 18.3955 17.5 17.2762 17.5 15.8955C17.5 14.5148 16.3807 13.3955 15 13.3955C13.6193 13.3955 12.5 14.5148 12.5 15.8955C12.5 17.2762 13.6193 18.3955 15 18.3955Z" fill="#D5D7DB"/><path d="M25 15.8955C25 17.2762 23.8807 18.3955 22.5 18.3955C21.1193 18.3955 20 17.2762 20 15.8955C20 14.5148 21.1193 13.3955 22.5 13.3955C23.8807 13.3955 25 14.5148 25 15.8955Z" fill="#D5D7DB"/></svg>',
		},
		forward: {
			content: '<svg width="30" height="31" viewBox="0 0 30 31" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M24.4454 15.2227L14.7227 5.5V11.75H8.75V19.25H14.7227V24.9454L24.4454 15.2227Z" fill="#828B95"/></svg>',
		},
		replyAll: {
			content: '<svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.7561 6.43926C17.7561 6.17949 17.4484 6.0425 17.2554 6.21632L8.60954 14.0015C8.43309 14.1604 8.43309 14.4371 8.60954 14.596L17.2554 22.3811C17.4484 22.5549 17.7561 22.4179 17.7561 22.1582V17.2307C22.1557 17.8572 25.8255 21.0117 27.2793 22.4277C27.4903 22.6333 27.8428 22.4611 27.7823 22.1728C27.2236 19.5084 25.0235 12.0561 17.7561 10.9336V6.43926ZM12.6937 22.1599V20.1075L6.5748 14.5977C6.39835 14.4388 6.39835 14.1621 6.5748 14.0032L12.6937 8.49339V6.44098C12.6937 6.18121 12.386 6.04422 12.193 6.21804L3.54715 14.0032C3.3707 14.1621 3.3707 14.4388 3.54715 14.5977L12.193 22.3828C12.386 22.5566 12.6937 22.4197 12.6937 22.1599Z" fill="#828B95"/></svg>',
		},
		reply: {
			content: '<svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M13.6035 6.32851C13.8448 6.11123 14.2295 6.28247 14.2295 6.60718V10.8194C14.2726 10.8033 14.3194 10.7951 14.3679 10.7964C22.6338 11.0312 25.189 18.8924 25.8693 21.9331C25.9497 22.2925 25.511 22.5139 25.2442 22.26C23.5034 20.6028 19.2651 17.1217 14.3773 17.1211C14.3252 17.1211 14.2753 17.1109 14.2295 17.0925V21.9892C14.2295 22.3139 13.8448 22.4851 13.6035 22.2678L5.16543 14.6697C4.94486 14.4711 4.94486 14.1252 5.16543 13.9266L13.6035 6.32851Z" fill="#828B95"/></svg>',
		},
		done: {
			content: '<svg width="22" height="21" viewBox="0 0 22 21" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M21.0992 10.5C21.0992 16.0778 16.5776 20.5994 10.9998 20.5994C5.42206 20.5994 0.900391 16.0778 0.900391 10.5C0.900391 4.92224 5.42206 0.400574 10.9998 0.400574C16.5776 0.400574 21.0992 4.92224 21.0992 10.5ZM9.40645 11.6031L7.07124 9.18449L5.23644 11.5197L9.40645 15.6897L17.2912 7.80495L15.2445 5.68168L9.40645 11.6031Z" fill="#828B95"/></svg>',
		},
		exclude: {
			content: '<svg width="30" height="31" viewBox="0 0 30 31" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M14.8278 11.4363C18.2796 11.4363 21.0778 14.2345 21.0778 17.6863C21.0778 21.1381 18.2796 23.9363 14.8278 23.9363C11.376 23.9363 8.57779 21.1381 8.57779 17.6863C8.57779 14.2345 11.376 11.4363 14.8278 11.4363ZM17.4577 13.7414L14.8278 16.3713L12.1978 13.7414L10.8829 15.0564L13.5128 17.6863L10.8829 20.3163L12.1978 21.6312L14.8278 19.0013L17.4577 21.6312L18.7727 20.3163L16.1428 17.6863L18.7727 15.0564L17.4577 13.7414ZM12.8675 6.75V9.02375L9.465 9.02409C7.53793 9.02409 5.97574 10.5863 5.97574 12.5134C5.97574 13.755 6.62431 14.8452 7.60117 15.4636C7.38462 16.1649 7.26821 16.912 7.26821 17.6863L7.27123 17.8243C5.20202 16.9497 3.75 14.9011 3.75 12.5134C3.75 9.33034 6.33034 6.75 9.51336 6.75H12.8675ZM20.1422 6.75C23.3252 6.75 25.9056 9.33034 25.9056 12.5134C25.9056 14.9011 24.4536 16.9497 22.3843 17.8243L22.3874 17.6863C22.3874 16.912 22.271 16.1649 22.0547 15.4615C23.0316 14.8447 23.6798 13.7547 23.6798 12.5134C23.6798 10.5863 22.1176 9.02409 20.1906 9.02409L16.7875 9.02375V6.75H20.1422Z" fill="#828B95"/></svg>',
		},
		remove: {
			content: '<svg width="14" height="19" viewBox="0 0 14 19" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8.36344 0.586601H5.63698V1.95789H2.05908C1.02355 1.95789 0.184082 2.79736 0.184082 3.83289V4.70048H13.8163V3.83289C13.8163 2.79736 12.9769 1.95789 11.9413 1.95789H8.36344V0.586601Z" fill="#828B95"/><path d="M1.54731 6.07177H12.4531L11.4633 17.2734C11.4063 17.9186 10.8658 18.4134 10.2181 18.4134H3.7823C3.13459 18.4134 2.59417 17.9186 2.53715 17.2734L1.54731 6.07177Z" fill="#828B95"/></svg>',
		},
		spam: {
			content: '<svg width="22" height="21" viewBox="0 0 22 21" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.2524 16.6866C8.34512 17.3564 9.63052 17.7425 11.0061 17.7425C14.9785 17.7425 18.1988 14.5222 18.1988 10.5498C18.1988 9.17422 17.8127 7.88883 17.1429 6.7961L7.2524 16.6866ZM4.86936 14.3035L14.7598 4.41307C13.6671 3.74324 12.3817 3.35709 11.0061 3.35709C7.03368 3.35709 3.81339 6.57738 3.81339 10.5498C3.81339 11.9254 4.19954 13.2108 4.86936 14.3035ZM11.0061 20.5691C5.47261 20.5691 0.986816 16.0833 0.986816 10.5498C0.986816 5.01631 5.47261 0.530518 11.0061 0.530518C16.5396 0.530518 21.0254 5.01631 21.0254 10.5498C21.0254 16.0833 16.5396 20.5691 11.0061 20.5691Z" fill="#828B95"/></svg>',
		},
	};

	/**
	 * @function MoreButton
	 */
	function MoreButton(props)
	{
		return View(
			{
				style: {
					...props.style,
				},
				onClick: props.action,
			},
			Image({
				style: {
					width: 30,
					height: 30,
				},
				svg: {
					content: Icon('moreBtn'),
				},

			}),
		);
	}

	/**
	 * @function Icon
	 */
	function Icon(name)
	{
		return (svgIcons)[name].content;
	}

	module.exports = {
		Icon,
		MoreButton,
	};
});
