/**
 * @module crm/mail/mailbox/connector/steps/services-list
 */

jn.define('crm/mail/mailbox/connector/steps/services-list', (require, exports, module) => {
	const { WizardStep } = require('layout/ui/wizard/step');
	const { ProgressBarNumber } = require('crm/salescenter/progress-bar-number');
	const { Loc } = require('loc');
	const AppTheme = require('apptheme');

	const services = {
		aol: {
			key: 'aol',
			name: Loc.getMessage('MAILBOX_CONNECTOR_SERVICE_NAME_AOL'),
			svgContent: '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.42917 2.55224C5.40662 2.63603 5.35288 2.83876 5.30973 3.00276C5.08102 3.8722 5.00994 4.13148 4.9982 4.13911C4.99106 4.14374 4.9889 4.15687 4.99338 4.16828C4.99787 4.1797 4.99506 4.18903 4.98713 4.18903C4.97921 4.18903 4.97586 4.2007 4.97968 4.21496C4.98348 4.22923 4.98056 4.24089 4.97316 4.24089C4.96577 4.24089 4.96316 4.24965 4.96736 4.26034C4.97156 4.27104 4.96852 4.27979 4.9606 4.27979C4.95267 4.27979 4.94932 4.29146 4.95314 4.30572C4.95695 4.31998 4.95396 4.33165 4.9465 4.33165C4.93903 4.33165 4.93597 4.34303 4.9397 4.35695C4.94343 4.37088 4.94194 4.384 4.93638 4.38612C4.93083 4.38825 4.88965 4.53001 4.84486 4.70114C4.76347 5.01209 4.72984 5.13783 4.63673 5.47903C4.60947 5.57885 4.57984 5.69262 4.57086 5.73184C4.56188 5.77106 4.52426 5.91399 4.48728 6.04947C4.4503 6.18495 4.37809 6.45624 4.3268 6.65233C4.27551 6.84843 4.20354 7.11971 4.16688 7.25519C4.1302 7.39067 4.07872 7.58611 4.05246 7.6895C4.0262 7.79288 3.99844 7.88126 3.99076 7.8859C3.98308 7.89053 3.98046 7.90368 3.98495 7.91509C3.98943 7.92651 3.98662 7.93584 3.9787 7.93584C3.97078 7.93584 3.96742 7.94751 3.97124 7.96177C3.97505 7.97603 3.97213 7.9877 3.96473 7.9877C3.95734 7.9877 3.95472 7.99645 3.95893 8.00715C3.96312 8.01784 3.96008 8.02659 3.95216 8.02659C3.94424 8.02659 3.94088 8.03826 3.9447 8.05252C3.94851 8.06679 3.94553 8.07845 3.93807 8.07845C3.9306 8.07845 3.92761 8.09012 3.93143 8.10438C3.93524 8.11864 3.93226 8.13031 3.9248 8.13031C3.91733 8.13031 3.91426 8.1417 3.91799 8.15562C3.92172 8.16954 3.92047 8.18266 3.91523 8.18479C3.90998 8.18692 3.87772 8.29367 3.84354 8.42202C3.80937 8.55037 3.73898 8.81291 3.68714 9.00543C3.6353 9.19796 3.56106 9.478 3.52217 9.62774C3.48329 9.77748 3.42716 9.99043 3.39746 10.101C3.36775 10.2115 3.30813 10.4361 3.26497 10.6001C3.22182 10.7641 3.16853 10.9654 3.14657 11.0474C3.12459 11.1294 3.08516 11.2781 3.05893 11.378C3.03269 11.4778 3.00474 11.5721 2.9968 11.5874C2.98887 11.6028 2.98641 11.6217 2.99135 11.6296C2.99628 11.6374 2.99337 11.6438 2.98486 11.6438C2.97635 11.6438 2.97283 11.6525 2.97703 11.6632C2.98122 11.6739 2.97819 11.6826 2.97026 11.6826C2.96234 11.6826 2.95899 11.6943 2.96281 11.7086C2.96661 11.7228 2.96363 11.7345 2.95617 11.7345C2.9487 11.7345 2.94572 11.7462 2.94954 11.7604C2.95335 11.7747 2.95043 11.7864 2.94302 11.7864C2.93563 11.7864 2.93302 11.7951 2.93722 11.8058C2.94142 11.8165 2.93838 11.8253 2.93046 11.8253C2.92226 11.8253 2.91878 11.8392 2.9224 11.8577C2.92589 11.8755 2.92296 11.8901 2.91589 11.8901C2.90883 11.8901 2.90648 11.8988 2.91069 11.9095C2.91488 11.9202 2.91184 11.929 2.90392 11.929C2.896 11.929 2.89256 11.9404 2.89629 11.9543C2.90002 11.9682 2.89831 11.9813 2.8925 11.9835C2.8827 11.987 2.85796 12.0768 2.68052 12.7522C2.64494 12.8877 2.58894 13.0977 2.5561 13.219C2.50033 13.4248 2.4173 13.7382 2.24866 14.3793C2.21021 14.5255 2.1446 14.7705 2.10284 14.9238C2.06107 15.0771 2.02097 15.2288 2.01372 15.2609C2.00647 15.293 1.99474 15.3263 1.98765 15.3349C1.98058 15.3435 1.97831 15.3561 1.98264 15.363C1.98696 15.3698 1.98569 15.3773 1.97982 15.3797C1.96529 15.3856 1.89582 15.6497 1.90497 15.6642C1.90899 15.6706 1.90526 15.6758 1.89668 15.6758C1.88775 15.6758 1.88398 15.6866 1.88786 15.7011C1.89158 15.715 1.8905 15.7281 1.88543 15.7303C1.87703 15.7338 1.773 16.1046 1.70977 16.3564C1.67668 16.4883 1.59475 16.7958 1.51293 17.0954C1.47787 17.2238 1.43001 17.4046 1.40657 17.4973C1.38311 17.59 1.33469 17.7725 1.29894 17.9029C1.23801 18.1252 1.0494 18.8398 1.0176 18.9688C1.00969 19.0009 0.997661 19.0309 0.990867 19.0354C0.98406 19.04 0.9826 19.0502 0.987616 19.0581C0.992632 19.0661 0.989712 19.0725 0.981127 19.0725C0.972065 19.0725 0.968442 19.0834 0.972476 19.0985C0.976284 19.1127 0.973365 19.1244 0.965961 19.1244C0.95857 19.1244 0.95581 19.1328 0.95983 19.143C0.963851 19.1533 0.962445 19.1635 0.956726 19.1657C0.950994 19.1679 0.927043 19.2456 0.903504 19.3383C0.879965 19.431 0.809508 19.6965 0.746945 19.9282C0.684382 20.16 0.625959 20.3817 0.617122 20.4209C0.608298 20.4601 0.560663 20.641 0.511263 20.8228C0.461863 21.0046 0.389892 21.273 0.35132 21.4192C0.312761 21.5653 0.259247 21.7666 0.232418 21.8664C0.126625 22.2602 0.0398066 22.602 0.0398066 22.6249C0.0398066 22.6381 0.0308501 22.6577 0.0199033 22.6684C0.00895649 22.6791 0 22.7024 0 22.7201C0 22.748 0.00851862 22.7542 0.0630272 22.7662C0.0976987 22.7738 0.215619 22.8035 0.325087 22.8323C0.434556 22.861 0.616671 22.9069 0.729788 22.9344C0.842905 22.9619 1.15638 23.0411 1.4264 23.1105C1.69643 23.1798 2.00095 23.2576 2.10312 23.2834C2.20529 23.3092 2.29187 23.3341 2.29552 23.3388C2.29916 23.3435 2.42456 23.3781 2.57416 23.4158C2.72377 23.4535 3.00441 23.5248 3.1978 23.5742C3.39119 23.6237 3.63003 23.6844 3.72855 23.7092C3.82708 23.7339 4.02412 23.7834 4.16643 23.8191C4.30874 23.8548 4.4706 23.8958 4.52613 23.9101L4.62708 23.9362L4.57072 24.1135C4.53971 24.211 4.45948 24.463 4.39245 24.6733C4.3254 24.8837 4.24949 25.1229 4.22377 25.2049C4.06885 25.6987 4.00205 25.8994 3.9902 25.9069C3.98283 25.9115 3.98046 25.9246 3.98495 25.9361C3.98943 25.9475 3.98696 25.9568 3.97947 25.9568C3.97196 25.9568 3.96952 25.9626 3.97403 25.9698C3.97854 25.9769 3.97521 25.9827 3.96662 25.9827C3.95756 25.9827 3.95394 25.9936 3.95797 26.0087C3.96178 26.0229 3.96049 26.0346 3.95511 26.0346C3.94972 26.0346 3.92565 26.0973 3.90163 26.174C3.87762 26.2506 3.82928 26.4038 3.79421 26.5143C3.64662 26.9794 3.60586 27.1083 3.50296 27.4348C3.44341 27.6238 3.37428 27.8396 3.34932 27.9145C3.32437 27.9894 3.30395 28.0628 3.30395 28.0775C3.30395 28.1009 3.32909 28.1117 3.49683 28.1605C3.60291 28.1914 3.69234 28.2208 3.69555 28.2259C3.69877 28.231 3.74185 28.2473 3.79128 28.262C3.8407 28.2768 3.99758 28.3248 4.13989 28.3686C4.2822 28.4125 4.49715 28.4777 4.61757 28.5134C4.81991 28.5735 5.20429 28.69 5.65918 28.829C5.76135 28.8603 6.039 28.9448 6.27618 29.0168C6.8426 29.1888 6.87758 29.1998 6.89318 29.211C6.90048 29.2162 6.98706 29.2451 7.08558 29.2751C7.1841 29.3052 7.31845 29.3464 7.38413 29.3668C7.76778 29.4858 8.16579 29.5999 8.19733 29.5999C8.23748 29.5999 8.23811 29.5982 8.42635 28.997C8.4643 28.8758 8.52114 28.6979 8.55267 28.6016C8.58419 28.5054 8.63181 28.3566 8.65848 28.271C8.78198 27.8748 8.81796 27.7611 8.89653 27.5191C8.94281 27.3765 8.98467 27.2408 8.98954 27.2176C8.99441 27.1945 9.00426 27.1755 9.0114 27.1755C9.01855 27.1755 9.02071 27.1697 9.0162 27.1625C9.01169 27.1554 9.01502 27.1496 9.0236 27.1496C9.03267 27.1496 9.03629 27.1387 9.03226 27.1236C9.02845 27.1094 9.03137 27.0977 9.03877 27.0977C9.04616 27.0977 9.04877 27.089 9.04457 27.0783C9.04038 27.0676 9.04336 27.0588 9.0512 27.0588C9.05906 27.0588 9.06204 27.0501 9.05784 27.0394C9.05364 27.0287 9.05668 27.0199 9.0646 27.0199C9.07253 27.0199 9.07588 27.0083 9.07206 26.994C9.06825 26.9797 9.07089 26.9681 9.07794 26.9681C9.08499 26.9681 9.08706 26.9622 9.08255 26.9551C9.07803 26.948 9.08136 26.9421 9.08995 26.9421C9.09901 26.9421 9.10263 26.9313 9.0986 26.9162C9.09479 26.9019 9.09771 26.8903 9.10512 26.8903C9.11251 26.8903 9.11512 26.8815 9.11091 26.8708C9.10672 26.8601 9.10825 26.8514 9.11432 26.8514C9.1204 26.8514 9.14184 26.7945 9.16199 26.725C9.18213 26.6555 9.2183 26.5402 9.24238 26.4689C9.26645 26.3976 9.31703 26.2401 9.35478 26.1189C9.39253 25.9977 9.46811 25.7585 9.52274 25.5873C9.77944 24.7831 9.82369 24.6439 9.86693 24.5048C9.9707 24.1709 10.0091 24.0571 10.0206 24.0498C10.0272 24.0456 10.0309 24.0339 10.0287 24.0239C10.0264 24.0138 10.032 24.0071 10.041 24.0088C10.0625 24.013 10.5248 24.3098 10.5421 24.3305C10.5565 24.3477 10.8449 24.5307 10.8577 24.5307C10.8619 24.5307 10.93 24.5726 11.009 24.6238C11.279 24.7989 11.8822 25.1824 11.9471 25.2203C12.0123 25.2583 12.068 25.2644 12.068 25.2336C12.068 25.2244 12.0745 25.2127 12.0824 25.2076C12.105 25.1931 12.6372 24.4037 12.6831 24.3168C12.7153 24.2556 13.0054 23.8257 13.0252 23.8099C13.0349 23.802 13.0391 23.792 13.0346 23.7875C13.03 23.783 13.036 23.7757 13.048 23.7712C13.0599 23.7667 13.0664 23.7578 13.0623 23.7514C13.0582 23.7449 13.0642 23.7362 13.0756 23.7319C13.0869 23.7276 13.0929 23.7189 13.0888 23.7125C13.0848 23.706 13.0908 23.6973 13.1022 23.693C13.1136 23.6887 13.1229 23.6771 13.1229 23.6672C13.1229 23.6572 13.1289 23.6491 13.1362 23.6491C13.1435 23.6491 13.1495 23.6408 13.1495 23.6307C13.1495 23.6206 13.1539 23.6104 13.1594 23.608C13.17 23.6034 13.3291 23.3668 13.3371 23.3437C13.342 23.3298 13.4094 23.2285 13.7446 22.732C13.8494 22.5768 13.953 22.4192 13.9748 22.3818C13.9966 22.3443 14.0202 22.3137 14.0272 22.3137C14.0343 22.3137 14.0363 22.3079 14.0318 22.3007C14.0272 22.2935 14.0328 22.2841 14.0442 22.2799C14.0556 22.2756 14.0616 22.2669 14.0575 22.2605C14.0535 22.2541 14.0568 22.2489 14.065 22.2489C14.0732 22.2489 14.0761 22.243 14.0716 22.2358C14.067 22.2287 14.0726 22.2193 14.084 22.215C14.0954 22.2108 14.1013 22.202 14.0973 22.1956C14.0932 22.1892 14.0992 22.1804 14.1105 22.1761C14.1219 22.1719 14.1279 22.1631 14.1238 22.1567C14.1197 22.1503 14.1257 22.1415 14.1372 22.1372C14.1485 22.1329 14.1579 22.1243 14.1579 22.118C14.1579 22.1117 14.1667 22.0963 14.1775 22.0837C14.2006 22.0569 14.6635 21.3631 14.7749 21.1885C14.8622 21.0515 15.0253 20.8153 15.0348 20.812C15.0415 20.8096 15.0437 20.8022 15.0395 20.7957C15.0354 20.7891 15.0413 20.7802 15.0526 20.776C15.064 20.7717 15.07 20.7629 15.0659 20.7565C15.0618 20.7501 15.0678 20.7413 15.0792 20.737C15.0906 20.7328 15.1 20.7211 15.1 20.7112C15.1 20.7013 15.106 20.6931 15.1132 20.6931C15.1205 20.6931 15.1265 20.6844 15.1265 20.6737C15.1265 20.663 15.1325 20.6542 15.1398 20.6542C15.1471 20.6542 15.1531 20.646 15.1531 20.6359C15.1531 20.6258 15.158 20.6156 15.164 20.6132C15.1755 20.6087 15.299 20.4275 15.299 20.4152C15.299 20.4057 15.6682 19.8497 15.6919 19.8235C15.7226 19.7895 15.7139 19.7643 15.6257 19.6314C15.4058 19.3003 15.1545 18.7226 15.0795 18.3757C15.0667 18.3169 15.0523 18.2687 15.0473 18.2687C15.0423 18.2687 15.0409 18.2512 15.0441 18.2298C15.0473 18.2083 15.0439 18.1909 15.0364 18.1909C15.0289 18.1909 15.026 18.1793 15.0298 18.165C15.0336 18.1508 15.0312 18.1391 15.0244 18.1391C14.9944 18.1391 14.9407 17.6528 14.9408 17.3816C14.9409 17.1124 14.9833 16.7123 15.0207 16.6287C15.0396 16.5863 15.0626 16.4551 15.0537 16.4409C15.0491 16.4337 15.0523 16.4277 15.0608 16.4277C15.0693 16.4277 15.0728 16.419 15.0686 16.4083C15.0644 16.3976 15.0675 16.3888 15.0754 16.3888C15.0836 16.3888 15.0871 16.3749 15.0835 16.3564C15.08 16.3386 15.0829 16.324 15.09 16.324C15.097 16.324 15.0994 16.3153 15.0952 16.3046C15.091 16.2939 15.094 16.2851 15.1019 16.2851C15.1099 16.2851 15.1132 16.2735 15.1094 16.2592C15.1056 16.2449 15.1086 16.2333 15.116 16.2333C15.1235 16.2333 15.1265 16.2216 15.1227 16.2073C15.1189 16.1931 15.1207 16.1814 15.1268 16.1814C15.1329 16.1814 15.1478 16.1479 15.16 16.1069C15.2063 15.9504 15.3466 15.6255 15.4609 15.41C15.5451 15.2511 15.7235 14.9849 15.8518 14.8266C16.0025 14.6407 16.331 14.3223 16.5067 14.1917C16.8612 13.9284 17.2712 13.7199 17.6713 13.5994C17.7203 13.5847 17.7634 13.5685 17.767 13.5635C17.7889 13.5334 18.2011 13.45 18.5101 13.4132C18.7872 13.3801 19.3793 13.3827 19.666 13.4182C19.9452 13.4528 20.3677 13.5397 20.3677 13.5626C20.3677 13.568 20.3961 13.5794 20.4308 13.5879C20.5248 13.611 20.8891 13.7522 21.0179 13.8155C21.3945 14.0005 21.6559 14.1846 21.97 14.4858C22.3165 14.8182 22.5707 15.1704 22.7585 15.5784C22.8078 15.6855 22.8563 15.7747 22.8663 15.7768C22.8792 15.7795 22.8928 15.7427 22.9141 15.6471C22.9305 15.5738 22.9584 15.454 22.9761 15.3811C22.9938 15.3082 23.0082 15.2367 23.0082 15.2223C23.0082 15.2079 23.0148 15.1961 23.0229 15.1961C23.031 15.1961 23.0342 15.1873 23.03 15.1766C23.0258 15.1659 23.0288 15.1572 23.0367 15.1572C23.0449 15.1572 23.0484 15.1432 23.0448 15.1248C23.0413 15.107 23.0443 15.0924 23.0514 15.0924C23.0586 15.0924 23.0613 15.0807 23.0575 15.0664C23.0536 15.0522 23.0566 15.0405 23.0641 15.0405C23.0716 15.0405 23.0745 15.0288 23.0707 15.0146C23.0669 15.0003 23.0699 14.9887 23.0774 14.9887C23.0848 14.9887 23.0881 14.9741 23.0846 14.9562C23.0811 14.9384 23.0841 14.9238 23.0912 14.9238C23.0984 14.9238 23.1011 14.9122 23.0973 14.8979C23.0935 14.8836 23.0949 14.872 23.1005 14.872C23.1061 14.872 23.1174 14.8413 23.1256 14.8039C23.173 14.5873 23.2234 14.3628 23.24 14.295C23.2505 14.2523 23.2926 14.0714 23.3336 13.8931C23.3747 13.7149 23.4227 13.5078 23.4403 13.4329C23.5565 12.9397 23.8411 11.7039 23.8643 11.5919C23.8739 11.5455 23.8937 11.461 23.9083 11.4039C23.9464 11.255 24.0008 11.0231 24.0109 10.9663C24.0157 10.9396 24.0256 10.9177 24.033 10.9177C24.0403 10.9177 24.0432 10.9061 24.0394 10.8918C24.0355 10.8775 24.0385 10.8659 24.046 10.8659C24.0535 10.8659 24.0567 10.8513 24.0532 10.8335C24.0497 10.8156 24.0518 10.801 24.0577 10.801C24.0637 10.801 24.0723 10.7792 24.0769 10.7524C24.0875 10.6912 24.15 10.4145 24.2547 9.96482C24.3961 9.35792 24.5604 8.64714 24.5888 8.51925C24.6039 8.45151 24.6304 8.33775 24.6477 8.26644C24.7136 7.9947 24.7633 7.78278 24.7862 7.67655C24.7992 7.61594 24.8502 7.39716 24.8994 7.19037C24.9486 6.98358 24.9952 6.7823 25.0028 6.74309C25.0105 6.70387 25.0225 6.66799 25.0295 6.66337C25.0365 6.65874 25.0386 6.6456 25.0341 6.6342C25.0296 6.62277 25.0324 6.61344 25.0403 6.61344C25.0485 6.61344 25.052 6.59949 25.0484 6.58103C25.0449 6.5632 25.0479 6.54862 25.055 6.54862C25.0622 6.54862 25.0649 6.53695 25.0611 6.52269C25.0572 6.50842 25.0602 6.49676 25.0677 6.49676C25.0752 6.49676 25.0784 6.48217 25.0749 6.46434C25.0714 6.44652 25.0744 6.43193 25.0816 6.43193C25.0887 6.43193 25.0914 6.42026 25.0876 6.406C25.0838 6.39174 25.0868 6.38007 25.0942 6.38007C25.1017 6.38007 25.1047 6.36841 25.1009 6.35414C25.0971 6.33988 25.1 6.32822 25.1075 6.32822C25.115 6.32822 25.1182 6.31363 25.1147 6.2958C25.1112 6.27798 25.1131 6.26339 25.1189 6.26339C25.1247 6.26339 25.1361 6.22985 25.1443 6.18884C25.1596 6.11213 25.1715 6.06106 25.2312 5.81665C25.2704 5.65636 25.2689 5.65165 25.1737 5.63529C25.1296 5.62772 24.5276 5.49606 24.0764 5.39531C23.9815 5.37413 23.7546 5.32401 23.5722 5.28395C23.3897 5.24387 23.127 5.18558 22.9883 5.15441C22.8497 5.12325 22.6138 5.07082 22.4642 5.03791C22.3146 5.005 22.022 4.94022 21.814 4.89395C21.606 4.84769 21.3821 4.79814 21.3164 4.78386C21.2508 4.76957 21.1851 4.75268 21.1705 4.74631C21.1283 4.72794 20.2861 4.53908 20.2464 4.53908C20.2337 4.53908 20.2201 4.54418 20.2162 4.5504C20.2122 4.55662 20.1912 4.64267 20.1695 4.74163C20.1477 4.84058 20.1084 5.01197 20.0822 5.1225C20.0559 5.23302 20.031 5.3424 20.0268 5.36558C20.0227 5.38877 20.0134 5.40772 20.0062 5.40772C19.999 5.40772 19.996 5.4223 19.9994 5.44013C20.0029 5.45796 20 5.47254 19.9928 5.47254C19.9857 5.47254 19.983 5.48421 19.9868 5.49847C19.9906 5.51273 19.989 5.5244 19.9832 5.5244C19.9774 5.5244 19.9685 5.54629 19.9636 5.57302C19.9586 5.59977 19.9165 5.78499 19.87 5.98465C19.8236 6.18431 19.7837 6.36125 19.7814 6.37786C19.7776 6.40574 19.7548 6.39388 19.483 6.22228C19.0059 5.92097 18.8974 5.85522 18.871 5.85113C18.8512 5.84807 18.7859 5.93686 18.5619 6.2716C18.4057 6.50499 18.2755 6.70218 18.2726 6.70979C18.2587 6.74602 18.0281 7.08017 18.017 7.08017C18.01 7.08017 18.008 7.08604 18.0125 7.09322C18.0171 7.10041 18.0115 7.10977 18.0001 7.11403C17.9888 7.1183 17.9828 7.127 17.9868 7.13339C17.9909 7.13977 17.9875 7.14499 17.9793 7.14499C17.9712 7.14499 17.9682 7.15087 17.9727 7.15805C17.9773 7.16523 17.9717 7.17459 17.9603 7.17886C17.949 7.18312 17.943 7.19187 17.9471 7.1983C17.9511 7.20473 17.9451 7.2135 17.9337 7.21778C17.9223 7.22206 17.913 7.23368 17.913 7.24362C17.913 7.25355 17.907 7.26168 17.8997 7.26168C17.8924 7.26168 17.8864 7.26993 17.8864 7.28005C17.8864 7.29015 17.882 7.30035 17.8765 7.30274C17.8655 7.30749 17.6488 7.6249 17.6213 7.67655C17.5973 7.7215 17.3201 8.13909 17.0041 8.60625C16.6096 9.18931 16.3907 9.51694 16.3517 9.58236C16.2725 9.71548 16.0107 10.101 15.9995 10.101C15.9929 10.101 15.9911 10.1068 15.9957 10.114C16.0002 10.1212 15.9946 10.1305 15.9833 10.1348C15.9719 10.1391 15.9659 10.1478 15.97 10.1543C15.9741 10.1607 15.9681 10.1694 15.9567 10.1737C15.9454 10.178 15.9394 10.1867 15.9435 10.1932C15.9475 10.1996 15.9415 10.2084 15.9301 10.2126C15.9187 10.2169 15.9094 10.2285 15.9094 10.2385C15.9094 10.2484 15.9035 10.2565 15.8964 10.2565C15.8892 10.2565 15.8796 10.2712 15.875 10.2891C15.8704 10.307 15.8598 10.326 15.8515 10.3312C15.8344 10.3421 15.6665 10.5888 15.654 10.6214C15.6496 10.6331 15.6029 10.7061 15.5503 10.7835C15.358 11.0664 15.0248 11.5731 15.0165 11.5951C15.0118 11.6076 15.0014 11.6178 14.9935 11.6178C14.9855 11.6178 14.9827 11.6237 14.9872 11.6309C14.9918 11.6381 14.9862 11.6474 14.9748 11.6517C14.9635 11.656 14.9572 11.6643 14.961 11.6702C14.9648 11.6762 14.9573 11.6871 14.9443 11.6944C14.9314 11.7018 14.9268 11.7081 14.9341 11.7084C14.9414 11.7087 14.9391 11.7141 14.9291 11.7203C14.9075 11.7337 14.3569 12.5527 14.3569 12.5714C14.3569 12.5872 14.0069 13.0958 13.996 13.0958C13.9893 13.0958 13.9875 13.1017 13.9921 13.1089C13.9966 13.116 13.991 13.1254 13.9797 13.1297C13.9683 13.1339 13.9623 13.1427 13.9664 13.1491C13.9705 13.1555 13.9645 13.1643 13.9531 13.1686C13.9418 13.1728 13.9358 13.1815 13.9398 13.1879C13.9438 13.1943 13.9408 13.1995 13.9331 13.1995C13.9254 13.1995 13.919 13.2083 13.919 13.219C13.919 13.2297 13.9131 13.2384 13.9058 13.2384C13.8985 13.2384 13.8925 13.2472 13.8925 13.2579C13.8925 13.2686 13.8865 13.2773 13.8792 13.2773C13.8719 13.2773 13.866 13.2856 13.866 13.2957C13.866 13.3058 13.8612 13.316 13.8553 13.3184C13.8453 13.3224 13.6935 13.5448 13.6935 13.5554C13.6935 13.558 13.622 13.6672 13.5347 13.798C13.4473 13.9288 13.3213 14.1189 13.2546 14.2205C13.188 14.3221 13.1318 14.4052 13.1299 14.4052C13.128 14.4052 13.1796 14.2404 13.2447 14.039C13.3098 13.8375 13.3773 13.6261 13.3949 13.569C13.4399 13.4223 13.5377 13.1141 13.621 12.856C13.6602 12.7347 13.7289 12.5189 13.7737 12.3763C13.8835 12.0271 13.9144 11.9296 13.9302 11.8836C13.9375 11.8622 13.9562 11.8039 13.9718 11.754C13.9873 11.704 14.009 11.6442 14.0199 11.6209C14.0309 11.5977 14.0362 11.5729 14.0317 11.5658C14.0273 11.5588 14.0306 11.553 14.0391 11.553C14.0476 11.553 14.0511 11.5442 14.0469 11.5336C14.0427 11.5229 14.0458 11.5141 14.0537 11.5141C14.0616 11.5141 14.065 11.5024 14.0612 11.4882C14.0574 11.4739 14.06 11.4622 14.067 11.4622C14.0741 11.4622 14.0762 11.4564 14.0716 11.4493C14.0671 11.4422 14.0705 11.4363 14.079 11.4363C14.0881 11.4363 14.0917 11.4255 14.0877 11.4104C14.0839 11.3961 14.0865 11.3845 14.0936 11.3845C14.1006 11.3845 14.1027 11.3786 14.0982 11.3715C14.0937 11.3644 14.097 11.3585 14.1056 11.3585C14.1146 11.3585 14.1183 11.3477 14.1142 11.3326C14.1104 11.3183 14.1133 11.3067 14.1208 11.3067C14.1281 11.3067 14.1309 11.2983 14.1269 11.2881C14.1229 11.2778 14.1243 11.2676 14.1302 11.2654C14.136 11.2631 14.1631 11.1913 14.1903 11.1057C14.2176 11.0202 14.2597 10.8889 14.2839 10.814C14.308 10.7391 14.3437 10.6254 14.3631 10.5612C14.3826 10.497 14.4243 10.3658 14.4558 10.2695C14.4874 10.1732 14.5502 9.97487 14.5953 9.82869C14.6405 9.68252 14.6975 9.50166 14.722 9.42679C15.0008 8.57403 15.0013 8.57262 14.9793 8.55252C14.9691 8.54311 14.7965 8.48556 14.5958 8.42461C14.3951 8.36368 14.0846 8.26919 13.9058 8.21464C13.727 8.16009 13.4911 8.0888 13.3817 8.05622C12.9714 7.93409 12.1727 7.6871 12.1344 7.67051C12.1125 7.66103 11.8796 7.58784 11.6169 7.50789C11.3542 7.42792 10.972 7.31102 10.7677 7.24809C10.5634 7.18517 10.3314 7.11542 10.2523 7.09311C10.1732 7.07078 10.1009 7.04966 10.0916 7.04619C10.0801 7.04188 10.0632 7.07563 10.0393 7.15076C10.0198 7.21176 9.99739 7.26168 9.98949 7.26168C9.98158 7.26168 9.97822 7.27334 9.98204 7.28761C9.98585 7.30187 9.98293 7.31353 9.97553 7.31353C9.96814 7.31353 9.96552 7.32229 9.96973 7.33298C9.97392 7.34368 9.97094 7.35243 9.96309 7.35243C9.95524 7.35243 9.95211 7.3608 9.95613 7.37103C9.96015 7.38128 9.95909 7.39148 9.95378 7.39372C9.94846 7.39596 9.91557 7.49115 9.88067 7.60524C9.82051 7.80189 9.71993 8.11593 9.60663 8.46091C9.57852 8.54648 9.54583 8.65149 9.53397 8.69428C9.52212 8.73706 9.45077 8.96459 9.37542 9.1999C9.30008 9.43521 9.18915 9.78234 9.12892 9.9713C9.06869 10.1603 9.01426 10.3212 9.00796 10.329C9.00167 10.3368 9.00045 10.347 9.00525 10.3517C9.01006 10.3564 9.00638 10.3602 8.99709 10.3602C8.98779 10.3602 8.98348 10.3686 8.9875 10.3789C8.99152 10.3891 8.99043 10.3993 8.98509 10.4015C8.97974 10.4038 8.95856 10.461 8.93803 10.5288C8.89094 10.6842 8.80073 10.9716 8.77617 11.0446C8.76587 11.0751 8.75746 11.1087 8.75746 11.1191C8.75746 11.1357 8.8863 11.1381 9.74334 11.1381H10.7292L10.8109 11.3423C10.8558 11.4546 10.9117 11.599 10.9351 11.6632C10.9585 11.7274 10.9842 11.7842 10.9921 11.7894C11.0007 11.7951 11.0011 11.7991 10.9933 11.7993C10.9852 11.7996 10.9856 11.8035 10.9942 11.8092C11.0081 11.8185 11.0958 12.031 11.2392 12.4022C11.31 12.5856 11.3538 12.6962 11.5648 13.2255C11.6287 13.3859 11.6893 13.5405 11.6994 13.569C11.7438 13.6943 11.8954 14.0621 11.9042 14.0658C11.9096 14.068 11.9107 14.0782 11.9067 14.0884C11.9026 14.0987 11.9063 14.1071 11.9148 14.1071C11.9233 14.1071 11.9266 14.1129 11.9221 14.12C11.9176 14.1271 11.92 14.133 11.9275 14.133C11.935 14.133 11.9377 14.1417 11.9335 14.1524C11.9293 14.1631 11.9328 14.1719 11.9414 14.1719C11.9499 14.1719 11.9531 14.1777 11.9486 14.1848C11.9441 14.192 11.9466 14.1978 11.9541 14.1978C11.9616 14.1978 11.9643 14.2066 11.9601 14.2173C11.9559 14.2279 11.9594 14.2367 11.9679 14.2367C11.9764 14.2367 11.9797 14.2425 11.9752 14.2497C11.9706 14.2568 11.9731 14.2626 11.9806 14.2626C11.9881 14.2626 11.9908 14.2714 11.9866 14.2821C11.9824 14.2928 11.9854 14.3015 11.9932 14.3015C12.0011 14.3015 12.0041 14.3103 11.9999 14.321C11.9957 14.3317 11.9979 14.3404 12.0048 14.3404C12.0117 14.3404 12.0328 14.3798 12.0516 14.4279C12.0704 14.4761 12.1142 14.5884 12.1487 14.6775C12.2541 14.9488 12.2704 14.9903 12.3241 15.1248C12.3527 15.1961 12.3985 15.3128 12.426 15.3841C12.4535 15.4554 12.5049 15.5867 12.5402 15.6758C12.5756 15.7649 12.6635 15.9866 12.7356 16.1684C12.8077 16.3503 12.8867 16.553 12.9113 16.619C12.9359 16.6849 12.961 16.7389 12.9672 16.7389C12.9734 16.7389 12.9748 16.7447 12.9703 16.7519C12.9658 16.759 12.9683 16.7648 12.9758 16.7648C12.9833 16.7648 12.986 16.7736 12.9818 16.7843C12.9776 16.795 12.9811 16.8037 12.9896 16.8037C12.9981 16.8037 13.0017 16.8091 12.9976 16.8156C12.9934 16.8221 12.9948 16.8294 13.0006 16.8318C13.0065 16.8342 13.0639 16.9703 13.1284 17.1343C13.1929 17.2983 13.3111 17.5988 13.3912 17.802C13.4713 18.0052 13.5595 18.2298 13.5873 18.3011C13.7686 18.7674 13.9002 19.0926 13.909 19.0963C13.9146 19.0987 13.9158 19.106 13.9117 19.1125C13.9076 19.1191 13.9103 19.1244 13.9179 19.1244C13.9254 19.1244 13.928 19.1332 13.9239 19.1438C13.9196 19.1545 13.9232 19.1633 13.9317 19.1633C13.9402 19.1633 13.9435 19.1691 13.939 19.1763C13.9344 19.1834 13.9369 19.1892 13.9444 19.1892C13.9519 19.1892 13.9546 19.198 13.9504 19.2087C13.9462 19.2194 13.9497 19.2281 13.9582 19.2281C13.9667 19.2281 13.97 19.234 13.9655 19.2411C13.961 19.2482 13.9634 19.2541 13.9709 19.2541C13.9784 19.2541 13.9811 19.2628 13.9769 19.2735C13.9727 19.2842 13.9763 19.2929 13.9848 19.2929C13.9933 19.2929 13.9965 19.2988 13.992 19.3059C13.9875 19.313 13.99 19.3189 13.9975 19.3189C14.005 19.3189 14.0077 19.3276 14.0035 19.3383C13.9993 19.349 14.0024 19.3578 14.0105 19.3578C14.0186 19.3578 14.0252 19.3638 14.0252 19.3712C14.0252 19.3786 14.0903 19.5492 14.1699 19.7504C14.2494 19.9516 14.3397 20.1804 14.3705 20.2588C14.4013 20.3373 14.4826 20.5444 14.5512 20.7191C14.6198 20.8938 14.6848 21.0559 14.6956 21.0793C14.7361 21.1672 14.8552 21.1603 13.3452 21.1567L11.9752 21.1534L11.7363 20.453C11.605 20.0679 11.4945 19.7454 11.4907 19.7364C11.4854 19.7235 11.1177 19.7202 9.69944 19.7201C8.71794 19.7201 7.90678 19.7203 7.89688 19.7204C7.88674 19.7206 7.88207 19.7289 7.88618 19.7394C7.8902 19.7496 7.88908 19.7598 7.88367 19.7621C7.87237 19.7668 7.80377 19.9401 7.70863 20.2045C7.67221 20.3057 7.58338 20.5489 7.51119 20.745C7.43902 20.9411 7.37604 21.1147 7.37121 21.1307L7.36243 21.1599H5.99646H4.63048L4.65017 21.1138C4.67139 21.0642 4.78391 20.7874 4.87652 20.557C4.90805 20.4786 4.94707 20.3779 4.96325 20.3334C4.97942 20.2888 4.99846 20.2523 5.00556 20.2523C5.01266 20.2523 5.01504 20.2436 5.01083 20.2329C5.00664 20.2222 5.00933 20.2134 5.01683 20.2134C5.02434 20.2134 5.02678 20.2076 5.02227 20.2005C5.01776 20.1933 5.02103 20.1875 5.02954 20.1875C5.03805 20.1875 5.04157 20.1788 5.03737 20.1681C5.03318 20.1574 5.03587 20.1486 5.04337 20.1486C5.05088 20.1486 5.05332 20.1428 5.04881 20.1357C5.0443 20.1285 5.04757 20.1227 5.05608 20.1227C5.06458 20.1227 5.06811 20.1139 5.06391 20.1032C5.05971 20.0925 5.0627 20.0838 5.07054 20.0838C5.0784 20.0838 5.08138 20.075 5.07717 20.0643C5.07298 20.0536 5.07568 20.0449 5.08317 20.0449C5.09068 20.0449 5.09312 20.0391 5.08861 20.0319C5.0841 20.0248 5.08709 20.019 5.09525 20.019C5.10341 20.019 5.10639 20.0131 5.10188 20.006C5.09737 19.9989 5.10065 19.993 5.10915 19.993C5.11766 19.993 5.12133 19.9847 5.11731 19.9744C5.11329 19.9642 5.11494 19.954 5.12098 19.9517C5.1321 19.9476 5.23721 19.6943 5.34051 19.4226C5.37169 19.3406 5.47767 19.0722 5.57603 18.8262C5.67438 18.5802 5.81039 18.2389 5.87827 18.0678C5.94614 17.8966 6.00675 17.7547 6.01295 17.7523C6.01916 17.7499 6.02086 17.7426 6.01673 17.7361C6.01261 17.7296 6.0162 17.7242 6.02471 17.7242C6.03321 17.7242 6.03674 17.7155 6.03253 17.7048C6.02834 17.6941 6.02975 17.6853 6.03565 17.6853C6.04157 17.6853 6.06281 17.643 6.08286 17.5913C6.15832 17.3967 6.29701 17.0473 6.40312 16.7843C6.46353 16.6345 6.54584 16.4274 6.58603 16.324C6.69578 16.0417 6.85846 15.6358 6.88041 15.5896C6.89108 15.5671 6.89982 15.5434 6.89982 15.537C6.89982 15.5142 6.99564 15.2932 7.00904 15.2851C7.01652 15.2805 7.01853 15.2703 7.01352 15.2624C7.0085 15.2544 7.01107 15.2479 7.01923 15.2479C7.0274 15.2479 7.03038 15.2421 7.02587 15.235C7.02136 15.2279 7.02463 15.222 7.03314 15.222C7.04165 15.222 7.04518 15.2133 7.04097 15.2026C7.03678 15.1919 7.03947 15.1831 7.04697 15.1831C7.05448 15.1831 7.05692 15.1773 7.05241 15.1702C7.0479 15.163 7.05117 15.1572 7.05968 15.1572C7.06818 15.1572 7.07171 15.1484 7.06751 15.1377C7.06331 15.1271 7.0663 15.1183 7.07414 15.1183C7.082 15.1183 7.08498 15.1096 7.08077 15.0989C7.07658 15.0882 7.07928 15.0794 7.08677 15.0794C7.09428 15.0794 7.09672 15.0736 7.09221 15.0664C7.0877 15.0593 7.09098 15.0535 7.09948 15.0535C7.10799 15.0535 7.11167 15.0451 7.10764 15.0349C7.10362 15.0246 7.10539 15.0144 7.11156 15.0122C7.12229 15.0083 7.16449 14.9055 7.42464 14.2497C7.48828 14.0892 7.56984 13.885 7.60589 13.7959C7.64194 13.7068 7.67927 13.6105 7.68884 13.582C7.6984 13.5535 7.73583 13.4572 7.77203 13.3681C7.80822 13.2789 7.87554 13.1127 7.92161 12.9986C7.96769 12.8845 8.01191 12.7868 8.01985 12.7816C8.0284 12.776 8.02889 12.7719 8.02104 12.7717C8.01374 12.7715 8.01486 12.7669 8.02354 12.7615C8.03222 12.7561 8.0602 12.6731 8.08573 12.5769C8.11125 12.4808 8.157 12.3088 8.18739 12.1948C8.27769 11.8556 8.30291 11.7597 8.33223 11.6438C8.36097 11.5301 8.3951 11.4043 8.46411 11.1576C8.48604 11.0791 8.54577 10.8545 8.59681 10.6584C8.64786 10.4623 8.70843 10.2319 8.73141 10.1463C8.75441 10.0608 8.81085 9.84781 8.85687 9.67312C8.98297 9.19437 8.99537 9.14999 9.01012 9.12482C9.01761 9.11205 9.02019 9.09602 9.01587 9.08917C9.01154 9.08234 9.01502 9.07674 9.0236 9.07674C9.03267 9.07674 9.03629 9.06587 9.03226 9.05081C9.02845 9.03655 9.03137 9.02488 9.03877 9.02488C9.04616 9.02488 9.04877 9.01613 9.04457 9.00543C9.04038 8.99474 9.04341 8.98598 9.05134 8.98598C9.05926 8.98598 9.06269 8.9746 9.05897 8.96068C9.05524 8.94675 9.0563 8.93363 9.06132 8.93151C9.06634 8.92938 9.09641 8.82555 9.12815 8.70076C9.15988 8.57597 9.20626 8.40095 9.23122 8.31182C9.25618 8.22269 9.31844 7.98932 9.36956 7.79323C9.42069 7.59714 9.47368 7.39586 9.48731 7.34595C9.50094 7.29603 9.55431 7.09475 9.6059 6.89866C9.75021 6.3502 9.7775 6.24842 9.84572 6.0041C9.88056 5.87931 9.93116 5.68824 9.95815 5.5795C9.98515 5.47077 10.0133 5.38179 10.0208 5.38179C10.0283 5.38179 10.0312 5.37012 10.0274 5.35586C10.0236 5.3416 10.0266 5.32993 10.0341 5.32993C10.0415 5.32993 10.0445 5.31826 10.0407 5.304C10.0369 5.28974 10.0399 5.27807 10.0473 5.27807C10.0548 5.27807 10.0578 5.2664 10.054 5.25214C10.0502 5.23788 10.0531 5.22621 10.0606 5.22621C10.0681 5.22621 10.071 5.21455 10.0672 5.20028C10.0634 5.18602 10.0663 5.17435 10.0737 5.17435C10.0811 5.17435 10.0839 5.16598 10.0799 5.15575C10.0759 5.14551 10.0775 5.1353 10.0836 5.13306C10.0897 5.13082 10.1277 5.00063 10.1682 4.84375C10.2371 4.57671 10.3024 4.3294 10.4233 3.87692C10.4511 3.77301 10.4704 3.67931 10.4662 3.66871C10.4611 3.65567 10.3199 3.6147 10.0293 3.54191C9.16057 3.32431 8.94558 3.27007 8.75082 3.2193C8.64135 3.19078 8.4682 3.1465 8.36603 3.12092C7.78488 2.97539 7.10369 2.79813 7.09221 2.78943C7.08492 2.78389 7.06402 2.77649 7.04577 2.77298C7.02753 2.76946 6.8484 2.72444 6.64771 2.67291C5.95262 2.49447 5.5604 2.3999 5.51539 2.3999H5.47019L5.42917 2.55224ZM26.3477 5.31373C26.3446 5.31908 26.3114 5.41971 26.274 5.53737C26.0751 6.16328 26.0266 6.30951 26.0157 6.31704C26.009 6.32159 26.0077 6.33181 26.0127 6.33973C26.0177 6.34766 26.0149 6.35414 26.0064 6.35414C25.9979 6.35414 25.9943 6.3629 25.9985 6.37359C26.0027 6.38429 25.9997 6.39304 25.9919 6.39304C25.984 6.39304 25.9811 6.40179 25.9853 6.41249C25.9895 6.42318 25.9881 6.43193 25.9822 6.43193C25.9764 6.43193 25.9549 6.48881 25.9345 6.55834C25.8993 6.67789 25.8563 6.81412 25.6753 7.37836C25.5659 7.71955 25.2742 8.63957 25.217 8.82393C25.115 9.15221 25.0342 9.39501 25.0217 9.41058C25.0145 9.4195 25.0138 9.42688 25.0202 9.42698C25.0265 9.4271 25.0248 9.4315 25.0163 9.43679C25.0078 9.44207 24.9851 9.49887 24.966 9.56299C24.9468 9.62713 24.9171 9.72627 24.8999 9.78332C24.8828 9.84036 24.818 10.0446 24.7559 10.2371C24.6938 10.4296 24.624 10.6484 24.6008 10.7233C24.5776 10.7981 24.5265 10.9586 24.4874 11.0798C24.4482 11.201 24.3951 11.3673 24.3694 11.4493C24.1782 12.059 24.0424 12.4747 24.0141 12.5363C23.9999 12.5673 23.9915 12.6009 23.9954 12.6109C23.9993 12.6209 23.9961 12.6291 23.9883 12.6291C23.9804 12.6291 23.9775 12.6378 23.9817 12.6485C23.9859 12.6592 23.9829 12.668 23.975 12.668C23.9672 12.668 23.9642 12.6767 23.9684 12.6874C23.9726 12.6981 23.9696 12.7069 23.9618 12.7069C23.9539 12.7069 23.9509 12.7156 23.9551 12.7263C23.9593 12.737 23.9563 12.7458 23.9485 12.7458C23.9406 12.7458 23.9376 12.7545 23.9419 12.7652C23.946 12.7759 23.943 12.7847 23.9351 12.7847C23.9272 12.7847 23.9238 12.7963 23.9276 12.8106C23.9314 12.8248 23.9285 12.8365 23.9211 12.8365C23.9137 12.8365 23.911 12.8449 23.915 12.8551C23.919 12.8654 23.9177 12.8756 23.9122 12.8778C23.9066 12.88 23.8528 13.0365 23.7925 13.2255C23.7322 13.4144 23.6241 13.7528 23.5523 13.9774C23.4805 14.202 23.4028 14.4471 23.3796 14.5219C23.3564 14.5968 23.2791 14.8418 23.2079 15.0664C23.1367 15.2911 23.0677 15.5113 23.0545 15.5559C23.0413 15.6004 23.0249 15.6369 23.018 15.6369C23.0111 15.6369 23.0088 15.6456 23.013 15.6563C23.0172 15.667 23.0142 15.6758 23.0064 15.6758C22.9985 15.6758 22.9956 15.6845 22.9998 15.6952C23.004 15.7059 23.0009 15.7147 22.993 15.7147C22.9851 15.7147 22.9817 15.7263 22.9855 15.7406C22.9893 15.7549 22.9864 15.7665 22.979 15.7665C22.9716 15.7665 22.969 15.7753 22.9732 15.786C22.9774 15.7967 22.9744 15.8054 22.9666 15.8054C22.9587 15.8054 22.9558 15.8142 22.96 15.8249C22.9642 15.8356 22.9612 15.8443 22.9533 15.8443C22.9455 15.8443 22.9425 15.8531 22.9467 15.8638C22.9509 15.8745 22.9479 15.8832 22.9401 15.8832C22.9322 15.8832 22.9292 15.892 22.9334 15.9027C22.9376 15.9134 22.9353 15.9221 22.9282 15.9221C22.9095 15.9221 22.9125 15.9564 22.933 15.9764C22.9427 15.9859 22.9482 16.0009 22.9452 16.0097C22.9421 16.0186 22.9465 16.0258 22.9548 16.0258C22.9632 16.0258 22.9663 16.0317 22.9618 16.0388C22.9573 16.0459 22.9593 16.0518 22.9664 16.0518C22.9734 16.0518 22.9761 16.0634 22.9723 16.0777C22.9684 16.092 22.9718 16.1036 22.9797 16.1036C22.9877 16.1036 22.9907 16.1124 22.9865 16.1231C22.9823 16.1338 22.9849 16.1425 22.9923 16.1425C22.9997 16.1425 23.0026 16.1542 22.9988 16.1684C22.9948 16.1835 22.9984 16.1944 23.0075 16.1944C23.016 16.1944 23.019 16.2009 23.0139 16.2088C23.0089 16.2167 23.0102 16.2269 23.0168 16.2315C23.0454 16.2512 23.1114 16.5338 23.1624 16.8556C23.196 17.0669 23.1963 17.6909 23.163 17.9057C23.1367 18.0748 23.1048 18.2436 23.0882 18.3011C23.0821 18.3225 23.0666 18.3852 23.0539 18.4405C23.0412 18.4958 23.0251 18.541 23.0181 18.541C23.0111 18.541 23.0088 18.5497 23.013 18.5604C23.0172 18.5711 23.0142 18.5799 23.0064 18.5799C22.9985 18.5799 22.9956 18.5886 22.9998 18.5993C23.004 18.61 23.0009 18.6188 22.993 18.6188C22.9851 18.6188 22.9817 18.6304 22.9855 18.6447C22.9893 18.659 22.9864 18.6706 22.979 18.6706C22.9716 18.6706 22.969 18.6794 22.9732 18.6901C22.9774 18.7008 22.9744 18.7095 22.9666 18.7095C22.9587 18.7095 22.9558 18.7183 22.96 18.729C22.9642 18.7397 22.9615 18.7484 22.954 18.7484C22.9464 18.7484 22.944 18.7543 22.9485 18.7614C22.953 18.7685 22.9498 18.7744 22.9412 18.7744C22.9327 18.7744 22.9292 18.7831 22.9334 18.7938C22.9376 18.8045 22.9346 18.8132 22.9268 18.8132C22.9189 18.8132 22.9159 18.822 22.9202 18.8327C22.9243 18.8434 22.9232 18.8521 22.9175 18.8521C22.9119 18.8521 22.8876 18.9003 22.8635 18.9591C22.7951 19.126 22.6022 19.4931 22.5094 19.6329C22.3373 19.892 22.1464 20.1192 21.9733 20.271C21.9258 20.3126 21.8691 20.3655 21.8472 20.3886C21.7011 20.543 21.3105 20.8088 21.0223 20.95C20.9335 20.9935 20.6147 21.1181 20.4871 21.1592C19.8214 21.3737 18.9828 21.4269 18.2349 21.3019C17.6368 21.202 17.0431 20.962 16.5997 20.6407C16.541 20.5982 16.4856 20.5635 16.4765 20.5635C16.4575 20.5635 16.4326 20.6631 16.2349 21.5294C16.1877 21.7361 16.1276 21.9958 16.1014 22.1063C16.0752 22.2168 16.0469 22.3422 16.0387 22.385C16.0304 22.4278 16.018 22.4666 16.011 22.4712C16.0041 22.4759 16.0021 22.489 16.0065 22.5004C16.011 22.5118 16.0083 22.5212 16.0004 22.5212C15.9926 22.5212 15.9896 22.5299 15.9938 22.5406C15.998 22.5513 15.995 22.5601 15.987 22.5601C15.9788 22.5601 15.9754 22.574 15.979 22.5925C15.9825 22.6103 15.9795 22.6249 15.9723 22.6249C15.9652 22.6249 15.9625 22.6365 15.9663 22.6508C15.9701 22.6651 15.9671 22.6767 15.9597 22.6767C15.9522 22.6767 15.9489 22.6913 15.9524 22.7092C15.9559 22.727 15.9529 22.7416 15.9458 22.7416C15.9387 22.7416 15.9357 22.7561 15.9392 22.774C15.9427 22.7918 15.9397 22.8064 15.9327 22.8064C15.9256 22.8064 15.9231 22.8148 15.9271 22.825C15.9311 22.8352 15.9301 22.8454 15.9248 22.8477C15.9115 22.8533 15.8116 23.282 15.8106 23.3373C15.8099 23.3781 15.814 23.383 15.8563 23.3922C16.0595 23.4364 16.8677 23.6153 16.9576 23.6359C17.0816 23.6643 17.4453 23.7443 17.694 23.7978C17.7816 23.8167 17.9548 23.8551 18.0788 23.8831C18.2029 23.9112 18.394 23.9544 18.5034 23.9792C18.6129 24.0039 18.7861 24.0417 18.8882 24.0631C18.9904 24.0844 19.2711 24.1464 19.5119 24.2007C19.7527 24.2551 19.9751 24.3027 20.0061 24.3066C20.0372 24.3105 20.0625 24.3183 20.0625 24.324C20.0625 24.3297 20.0958 24.3416 20.1364 24.3505C20.2063 24.3658 20.2098 24.3685 20.202 24.4001C20.1803 24.4887 20.0154 24.979 20.0048 24.9862C19.9982 24.9908 19.9969 25.001 20.0019 25.0089C20.0069 25.0169 20.0041 25.0234 19.9956 25.0234C19.9871 25.0234 19.9834 25.0317 19.9874 25.042C19.9914 25.0522 19.9904 25.0624 19.9851 25.0646C19.9798 25.0669 19.9238 25.2321 19.8607 25.4317C19.7977 25.6314 19.7133 25.8969 19.6733 26.0216C19.4862 26.6057 19.3991 26.8881 19.3991 26.9108C19.3991 26.9318 19.4416 26.9484 19.6744 27.0185C20.239 27.1883 20.4143 27.2433 20.4208 27.2524C20.4272 27.2614 20.5207 27.2912 20.7724 27.3645C20.8381 27.3836 21.059 27.4507 21.2634 27.5135C21.4677 27.5762 21.7036 27.6479 21.7875 27.6726C21.8714 27.6974 22.1043 27.7686 22.305 27.8308C22.5057 27.8929 22.7565 27.9687 22.8623 27.999C23.1275 28.0751 23.5707 28.2148 23.5788 28.2249C23.5824 28.2295 23.6601 28.2552 23.7513 28.2821C23.8425 28.309 24.0016 28.3569 24.1049 28.3885C24.2081 28.4202 24.3007 28.446 24.3106 28.4459C24.3221 28.4458 24.347 28.3844 24.3803 28.2741C24.4373 28.0852 24.4338 28.0965 24.5405 27.7654C24.5819 27.637 24.6361 27.4679 24.661 27.3894C24.814 26.9076 24.8743 26.7191 24.9326 26.5402C24.9686 26.4297 25.0019 26.3203 25.0066 26.2971C25.0113 26.274 25.021 26.255 25.0282 26.255C25.0353 26.255 25.0378 26.2463 25.0336 26.2356C25.0294 26.2249 25.0324 26.2161 25.0402 26.2161C25.0481 26.2161 25.051 26.2074 25.0468 26.1967C25.0426 26.186 25.0456 26.1772 25.0535 26.1772C25.0613 26.1772 25.0643 26.1685 25.0601 26.1578C25.0559 26.1471 25.0589 26.1383 25.0667 26.1383C25.0746 26.1383 25.0776 26.1296 25.0734 26.1189C25.0692 26.1082 25.0722 26.0994 25.0801 26.0994C25.0881 26.0994 25.0914 26.0878 25.0876 26.0735C25.0838 26.0592 25.0867 26.0476 25.0941 26.0476C25.1015 26.0476 25.1041 26.0388 25.0999 26.0281C25.0957 26.0174 25.0987 26.0087 25.1065 26.0087C25.1144 26.0087 25.1174 25.9999 25.1132 25.9892C25.109 25.9785 25.112 25.9698 25.1198 25.9698C25.1277 25.9698 25.1307 25.961 25.1264 25.9503C25.1223 25.9396 25.1253 25.9309 25.1332 25.9309C25.1411 25.9309 25.1446 25.9195 25.1408 25.9056C25.1371 25.8917 25.1389 25.8785 25.1448 25.8764C25.1543 25.873 25.2014 25.7303 25.3857 25.1465C25.415 25.0538 25.4617 24.908 25.4894 24.8224C25.5172 24.7368 25.5639 24.591 25.5931 24.4983C25.6224 24.4056 25.6924 24.1839 25.7487 24.0056C25.8049 23.8274 25.8562 23.6759 25.8627 23.6691C25.8701 23.6613 26.0081 23.6724 26.2359 23.6991C26.4348 23.7225 26.699 23.7528 26.823 23.7665C26.9471 23.7802 27.1232 23.8002 27.2145 23.811C27.3057 23.8218 27.4818 23.8422 27.6059 23.8564C27.73 23.8705 27.8703 23.8879 27.9177 23.895C27.9652 23.9021 28.0667 23.9141 28.1433 23.9218C28.2199 23.9294 28.408 23.9502 28.5613 23.9679C28.7145 23.9856 28.9145 24.0084 29.0058 24.0187C29.6449 24.0907 29.7722 24.1053 29.908 24.1218C30.1247 24.1481 30.2265 24.158 30.2267 24.1527C30.2275 24.1389 30.2552 23.9054 30.2727 23.7658C30.2839 23.6766 30.2989 23.5512 30.306 23.487C30.3183 23.3764 30.328 23.2985 30.359 23.0592C30.3664 23.0022 30.3938 22.7746 30.42 22.5536C30.4825 22.0256 30.4993 21.8858 30.5234 21.6914C30.5692 21.3223 30.611 20.9566 30.6111 20.9233C30.6112 20.9036 30.6054 20.8876 30.5982 20.8876C30.591 20.8876 30.55 20.9137 30.5071 20.9455C30.2969 21.1017 30.0422 21.1937 29.7341 21.2247C29.3874 21.2595 29.0082 21.1591 28.7138 20.9546C28.5158 20.817 28.3079 20.5685 28.2203 20.3646C28.1694 20.2462 28.1175 20.0969 28.1171 20.0676C28.1169 20.0551 28.112 20.0449 28.1061 20.0449C28.1003 20.0449 28.098 20.0245 28.101 19.9995C28.1039 19.9746 28.101 19.9541 28.0943 19.9541C28.0877 19.9541 28.0847 19.9337 28.0877 19.9088C28.0907 19.8838 28.088 19.8634 28.0817 19.8634C28.0676 19.8634 28.0812 19.6215 28.1031 19.4822C28.1337 19.2875 28.2207 19.0745 28.3423 18.8964C28.4244 18.7762 28.6206 18.5822 28.7339 18.5092C28.7776 18.481 28.8222 18.4495 28.8329 18.4391C28.8672 18.4062 29.0618 18.3225 29.1669 18.2954C29.3237 18.2551 29.4904 18.2298 29.5997 18.2298C29.7305 18.2298 29.9415 18.2623 30.0739 18.3027C30.185 18.3366 30.399 18.4345 30.399 18.4513C30.399 18.4567 30.4214 18.4744 30.4488 18.4906C30.503 18.5229 30.7173 18.6966 30.7177 18.7086C30.7183 18.7277 30.851 18.8531 30.863 18.8459C30.8705 18.8414 30.8767 18.812 30.8767 18.7806C30.8767 18.7492 30.8827 18.681 30.89 18.629C30.9138 18.4603 30.9983 17.7602 31.011 17.627C31.0177 17.5557 31.0298 17.4847 31.0379 17.4692C31.0459 17.4538 31.0498 17.4231 31.0465 17.4011C31.0432 17.3792 31.046 17.3612 31.0527 17.3612C31.0595 17.3612 31.0629 17.332 31.0604 17.2964C31.0579 17.2607 31.061 17.2315 31.0673 17.2315C31.0736 17.2316 31.0761 17.2141 31.0729 17.1927C31.0697 17.1713 31.0725 17.1538 31.0793 17.1538C31.086 17.1538 31.0895 17.1246 31.0869 17.0889C31.0844 17.0533 31.0874 17.0241 31.0937 17.0241C31.0999 17.0241 31.1028 17.0008 31.1 16.9724C31.0972 16.9439 31.0988 16.9191 31.1035 16.9173C31.1082 16.9154 31.1251 16.8031 31.1409 16.6676C31.1567 16.5321 31.1843 16.2958 31.2022 16.1425C31.2201 15.9892 31.2466 15.7763 31.2611 15.6693C31.2757 15.5623 31.2969 15.3873 31.3082 15.2804C31.3196 15.1734 31.3341 15.0451 31.3405 14.9951C31.3469 14.9452 31.3735 14.7235 31.3996 14.5025C31.4257 14.2814 31.456 14.0306 31.4669 13.945C31.4778 13.8594 31.5018 13.6611 31.5202 13.5042C31.5387 13.3473 31.5625 13.1519 31.5732 13.0699C31.5839 12.9879 31.6106 12.7633 31.6326 12.5707C31.6545 12.3782 31.6872 12.1069 31.7052 11.9679C31.7231 11.8288 31.7441 11.6538 31.7518 11.5789C31.7595 11.5041 31.7718 11.3961 31.7791 11.3391C31.8102 11.0962 31.8612 10.6831 31.872 10.5871C31.8784 10.5301 31.8986 10.358 31.9168 10.2047C31.9351 10.0514 31.9565 9.86759 31.9643 9.79628C31.9722 9.72497 31.985 9.612 31.9927 9.54524C32.0022 9.46412 32.0024 9.41954 31.9935 9.41085C31.9862 9.40371 31.9275 9.39278 31.863 9.38657C31.7985 9.38036 31.6502 9.36371 31.5335 9.34957C31.3218 9.32394 30.7897 9.26466 30.6511 9.25128C30.5109 9.23775 30.5047 9.23512 30.5201 9.19578C30.5334 9.16166 30.6637 8.75061 30.6976 8.63594C30.7071 8.60385 30.7784 8.37924 30.8561 8.13679C30.9338 7.89435 31.0038 7.67119 31.0116 7.64089C31.0194 7.6106 31.0317 7.58579 31.0389 7.58579C31.0461 7.58579 31.0486 7.57704 31.0444 7.56635C31.0402 7.55565 31.0432 7.5469 31.0511 7.5469C31.0591 7.5469 31.0624 7.53523 31.0586 7.52097C31.0548 7.50671 31.0574 7.49504 31.0645 7.49504C31.0715 7.49504 31.0736 7.48921 31.0691 7.48208C31.0646 7.47495 31.0679 7.46911 31.0765 7.46911C31.0855 7.46911 31.0892 7.45825 31.0851 7.44318C31.0813 7.42892 31.0842 7.41725 31.0916 7.41725C31.099 7.41725 31.1016 7.4085 31.0974 7.39781C31.0932 7.38711 31.0962 7.37836 31.1041 7.37836C31.1119 7.37836 31.1149 7.36961 31.1107 7.35891C31.1065 7.34822 31.1095 7.33946 31.1173 7.33946C31.1252 7.33946 31.1282 7.33071 31.124 7.32002C31.1198 7.30932 31.1228 7.30057 31.1306 7.30057C31.1385 7.30057 31.1415 7.29182 31.1372 7.28112C31.1331 7.27043 31.1348 7.26168 31.141 7.26168C31.1473 7.26168 31.1563 7.24563 31.1611 7.22602C31.1659 7.20642 31.1964 7.1109 31.2289 7.01375C31.2614 6.91661 31.288 6.83418 31.288 6.83057C31.288 6.82032 31.2272 6.79917 31.0691 6.75448C30.9888 6.73179 30.9201 6.7089 30.9165 6.70361C30.9109 6.69545 30.6074 6.59955 30.2928 6.50654C30.2454 6.49252 30.0096 6.42087 29.7687 6.34733C29.5279 6.27379 29.2711 6.19623 29.1982 6.17497C29.1252 6.15371 28.8804 6.07988 28.6541 6.0109C28.4279 5.94192 28.1353 5.85297 28.004 5.81323C27.8726 5.77349 27.7621 5.7368 27.7585 5.73168C27.7548 5.72656 27.6265 5.68426 27.4732 5.63766C27.3199 5.59105 27.0111 5.49692 26.7868 5.42846C26.5625 5.36001 26.3733 5.304 26.3663 5.304C26.3593 5.304 26.3509 5.30838 26.3477 5.31373ZM26.8164 16.1543C26.8164 20.9247 26.8153 21.1703 26.7932 21.1662C26.7804 21.1638 26.2609 21.1614 25.6388 21.1609L24.5076 21.1599V16.1576C24.5076 13.4064 24.5116 11.1515 24.5165 11.1468C24.5213 11.142 25.0408 11.1381 25.6709 11.1381H26.8164V16.1543ZM9.64812 14.3113C9.61197 14.4413 9.40804 15.1156 9.36093 15.2609C9.34358 15.3144 9.31073 15.4223 9.28791 15.5008C9.19216 15.8298 9.01944 16.3857 8.99995 16.4275C8.98838 16.4523 8.97834 16.4887 8.97765 16.5085C8.97696 16.5282 8.97127 16.5444 8.96502 16.5444C8.95877 16.5444 8.95709 16.5532 8.96129 16.5639C8.96549 16.5746 8.9625 16.5833 8.95466 16.5833C8.94681 16.5833 8.94382 16.5921 8.94803 16.6028C8.95222 16.6135 8.94918 16.6222 8.94126 16.6222C8.93334 16.6222 8.92998 16.6339 8.9338 16.6481C8.93761 16.6624 8.93469 16.6741 8.92729 16.6741C8.91989 16.6741 8.91728 16.6828 8.92149 16.6935C8.92568 16.7042 8.9227 16.713 8.91485 16.713C8.907 16.713 8.90401 16.7217 8.90822 16.7324C8.91241 16.7431 8.90937 16.7519 8.90145 16.7519C8.89353 16.7519 8.89009 16.7632 8.89382 16.7772C8.89755 16.7911 8.89573 16.8042 8.88978 16.8063C8.88383 16.8085 8.83667 16.9502 8.78499 17.1214C8.73332 17.2925 8.67612 17.4795 8.6579 17.537C8.63968 17.5945 8.62477 17.6543 8.62477 17.6699V17.6983L8.94654 17.6984C9.12352 17.6985 9.60567 17.6987 10.018 17.699C10.697 17.6994 10.7681 17.6975 10.7722 17.6786C10.7778 17.6523 10.7152 17.432 10.5495 16.8945C10.4781 16.6627 10.3706 16.3098 10.3107 16.1101C10.2508 15.9104 10.1877 15.7033 10.1705 15.6499C10.1533 15.5964 10.1202 15.4855 10.0969 15.4035C10.0737 15.3215 10.0498 15.2526 10.0437 15.2503C10.0377 15.2481 10.036 15.2379 10.0401 15.2277C10.0441 15.2174 10.0404 15.2091 10.0319 15.2091C10.0234 15.2091 10.0205 15.2026 10.0256 15.1946C10.0306 15.1867 10.029 15.1765 10.0222 15.1719C10.0153 15.1674 9.99397 15.1112 9.97477 15.047C9.95558 14.9828 9.91856 14.8603 9.8925 14.7747C9.86646 14.6892 9.81735 14.5244 9.78339 14.4085C9.70853 14.153 9.69486 14.1432 9.64812 14.3113ZM18.7958 15.4822C18.7595 15.4881 18.7177 15.4986 18.7029 15.5056C18.6881 15.5126 18.6195 15.5335 18.5506 15.5522C18.3192 15.6149 18.0992 15.7344 17.8665 15.9239C17.6128 16.1306 17.4305 16.4121 17.3178 16.7713C17.2466 16.9983 17.2317 17.1069 17.2323 17.3936C17.2328 17.6237 17.2368 17.6705 17.2676 17.8089C17.3191 18.04 17.3637 18.1514 17.5229 18.4472C17.6464 18.6764 17.9602 18.9533 18.2668 19.1035C18.6257 19.2793 19.05 19.3308 19.4575 19.2481C19.6548 19.2081 19.8956 19.1082 20.0583 18.9989C20.1081 18.9655 20.1748 18.9209 20.2067 18.8997C20.3575 18.7996 20.5497 18.5725 20.664 18.3595C20.792 18.1209 20.8593 17.9191 20.8919 17.6763C20.9926 16.926 20.7034 16.2105 20.1426 15.8222C20.0657 15.769 19.9371 15.6944 19.8569 15.6564C19.7142 15.5889 19.5164 15.5202 19.4647 15.5202C19.4505 15.5202 19.4389 15.5151 19.4389 15.5088C19.4389 15.4752 18.9598 15.4554 18.7958 15.4822Z" fill="url(#paint0_linear_412_252245)"/><defs><linearGradient id="paint0_linear_412_252245" x1="32.0972" y1="21.4493" x2="-0.0144369" y2="21.1145" gradientUnits="userSpaceOnUse"><stop stop-color="#3E82F4"/><stop offset="1" stop-color="#93DCF7"/></linearGradient></defs></svg>',
		},
		yahoo: {
			key: 'yahoo',
			name: Loc.getMessage('MAILBOX_CONNECTOR_SERVICE_NAME_YAHOO'),
			svgContent: '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 8.52562H6.10301L9.65677 17.6172L13.2567 8.52562H19.1984L10.2513 30.0485H4.27109L6.72036 24.3453L0.000188995 8.52562H0ZM26.1175 15.7901H19.4625L25.3692 1.6001L32 1.60038L26.1175 15.7901V15.7901ZM21.2058 17.1482C23.2478 17.1482 24.903 18.8035 24.903 20.8451C24.903 22.8868 23.2478 24.5422 21.2058 24.5422C19.1641 24.5422 17.5091 22.8868 17.5091 20.8451C17.5091 18.8035 19.1643 17.1482 21.2058 17.1482Z" fill="#B070FF"/></svg>',
		},
		icloud: {
			key: 'icloud',
			name: Loc.getMessage('MAILBOX_CONNECTOR_SERVICE_NAME_ICLOUD'),
			svgContent: `<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M27.2952 21.6564C26.8719 22.6273 26.3708 23.521 25.7902 24.3427C24.9988 25.4628 24.3509 26.2381 23.8515 26.6687C23.0774 27.3754 22.248 27.7373 21.3599 27.7579C20.7223 27.7579 19.9534 27.5778 19.0583 27.2125C18.1603 26.8488 17.3351 26.6687 16.5805 26.6687C15.7891 26.6687 14.9404 26.8488 14.0325 27.2125C13.1233 27.5778 12.3909 27.7682 11.8308 27.7871C10.9792 27.8231 10.1302 27.4509 9.28288 26.6687C8.74204 26.2004 8.06557 25.3976 7.25518 24.2603C6.3857 23.0459 5.67087 21.6376 5.11086 20.032C4.5111 18.2978 4.21045 16.6185 4.21045 14.9927C4.21045 13.1303 4.61581 11.5241 5.42776 10.178C6.06587 9.09683 6.91479 8.24396 7.97728 7.61786C9.03976 6.99176 10.1878 6.6727 11.4241 6.65229C12.1006 6.65229 12.9877 6.86002 14.0901 7.26827C15.1894 7.6779 15.8952 7.88563 16.2047 7.88563C16.436 7.88563 17.2202 7.64273 18.5494 7.15849C19.8065 6.70941 20.8674 6.52347 21.7366 6.59671C24.0917 6.7854 25.8611 7.70706 27.0378 9.36752C24.9314 10.6345 23.8895 12.409 23.9103 14.6854C23.9293 16.4586 24.5772 17.9341 25.8507 19.1057C26.4278 19.6495 27.0723 20.0697 27.7894 20.3682C27.6339 20.8159 27.4697 21.2448 27.2952 21.6564ZM21.8938 0.555944C21.8938 1.94574 21.3823 3.24338 20.3629 4.44447C19.1326 5.87232 17.6445 6.6974 16.0309 6.56721C16.0103 6.40048 15.9984 6.225 15.9984 6.0406C15.9984 4.7064 16.5834 3.27854 17.6224 2.11108C18.1411 1.51997 18.8009 1.02847 19.6009 0.636394C20.3992 0.250166 21.1543 0.0365712 21.8644 0C21.8852 0.185789 21.8938 0.371613 21.8938 0.555944Z" fill="${AppTheme.colors.base1}"/></svg>`,
		},
		gmail: {
			key: 'gmail',
			name: Loc.getMessage('MAILBOX_CONNECTOR_SERVICE_NAME_GMAIL'),
			svgContent: '<svg width="33" height="32" viewBox="0 0 33 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.58227 26.5251H10.3991V14.2152L4.94873 10.1313V24.9073C4.94873 25.8026 5.68697 26.5251 6.58227 26.5251Z" fill="#4285F4"/><path d="M23.4985 26.5248H27.3154C28.2264 26.5248 28.9489 25.7865 28.9489 24.8912V10.1169L23.4985 14.2008V26.5248Z" fill="#34A853"/><path d="M23.4985 7.11594V14.1999L28.9489 10.116V7.93271C28.9489 5.90648 26.64 4.75986 25.0221 5.96931L23.4985 7.11594Z" fill="#FBBC04"/><path d="M10.3994 14.2153V7.13135L16.9493 12.0477L23.4992 7.13135V14.2153L16.9493 19.1159L10.3994 14.2153Z" fill="#EA4335"/><path d="M4.94873 7.93272V10.116L10.3991 14.1999V7.11595L8.87552 5.96933C7.25768 4.75987 4.94873 5.9222 4.94873 7.93272Z" fill="#C5221E"/></svg>',
		},
		yandex: {
			key: 'yandex',
			name: Loc.getMessage('MAILBOX_CONNECTOR_SERVICE_NAME_YANDEX'),
			svgContent: '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M13.8609 16.0496C15.3601 17.3777 16.5528 17.3055 18.1539 16.0498C21.4813 18.9253 24.6723 21.8621 27.9997 24.7377C27.9997 24.7897 27.9997 24.9038 27.9997 24.9558C19.9998 24.9571 11.9999 24.9584 4 24.9598C4 24.9137 4 24.81 4 24.764C7.32653 21.8758 10.5344 18.9377 13.8609 16.0496V16.0496Z" fill="#F2C102"/><path fill-rule="evenodd" clip-rule="evenodd" d="M13.9796 16.1562C15.4117 17.3945 16.4129 17.5682 18.0176 16.1722C21.345 13.1582 24.6723 10.1443 27.9997 7.13029C27.9997 7.10028 27.9997 7.07028 27.9997 7.04028C19.9998 7.04028 11.9999 7.04028 4 7.04028C4 7.07545 4 7.11061 4 7.1458C7.32653 10.1493 10.6531 13.1527 13.9796 16.1562V16.1562Z" fill="#EE0000"/><path fill-rule="evenodd" clip-rule="evenodd" d="M13.9797 16.1554L4 24.8198V7.14502L13.9797 16.1554Z" fill="#FFCC01"/><path fill-rule="evenodd" clip-rule="evenodd" d="M18.0186 16.1703L28.0007 7.12842V24.7969L18.0186 16.1703Z" fill="#FFCC01"/></svg>',
		},
		outlook: {
			key: 'outlook.com',
			name: Loc.getMessage('MAILBOX_CONNECTOR_SERVICE_NAME_OUTLOOK'),
			svgContent: '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7.99961 6.6626H24.0002C24.8837 6.6626 25.5999 7.35921 25.5999 8.2185V23.781C25.5999 24.6403 24.8837 25.3369 24.0002 25.3369H7.99961C7.11611 25.3369 6.3999 24.6403 6.3999 23.781V8.2185C6.3999 7.35921 7.11613 6.6626 7.99961 6.6626Z" fill="url(#paint0_linear_412_252267)"/><path d="M11.4047 13.1889C11.799 12.3718 12.4354 11.6881 13.2322 11.2255C14.1147 10.7342 15.1194 10.4892 16.1358 10.5176C17.0778 10.4977 18.0074 10.73 18.8229 11.189C19.5897 11.6338 20.2073 12.2854 20.6007 13.0649C21.0291 13.9239 21.2426 14.8691 21.2238 15.8236C21.2446 16.8212 21.0249 17.8096 20.5824 18.7097C20.1796 19.517 19.5424 20.1919 18.7496 20.6509C17.9027 21.124 16.9386 21.3624 15.9621 21.3402C15 21.3628 14.0499 21.1279 13.2157 20.6611C12.4422 20.2158 11.8169 19.5634 11.4144 18.7818C10.9834 17.9353 10.7673 17.0006 10.7843 16.0562C10.7663 15.0672 10.9784 14.087 11.4047 13.1889ZM13.3527 17.798C13.5629 18.3145 13.9194 18.7625 14.3807 19.09C14.8507 19.4094 15.4134 19.5742 15.9866 19.5602C16.5969 19.5837 17.1986 19.4133 17.7006 19.0747C18.1561 18.7483 18.5032 18.2991 18.699 17.7827C18.9178 17.2061 19.0258 16.5953 19.0175 15.9807C19.0243 15.3602 18.9228 14.7431 18.7173 14.1557C18.5358 13.6253 18.1999 13.1576 17.7503 12.8094C17.2609 12.4548 16.6609 12.275 16.0511 12.3001C15.4656 12.2854 14.8902 12.4515 14.4078 12.7746C13.9386 13.1035 13.5754 13.5554 13.3605 14.0776C12.8839 15.2746 12.8814 16.6011 13.3535 17.7997L13.3527 17.798Z" fill="white"/><defs><linearGradient id="paint0_linear_412_252267" x1="9.73533" y1="5.44685" x2="21.75" y2="26.8416" gradientUnits="userSpaceOnUse"><stop stop-color="#1784D9"/><stop offset="0.5" stop-color="#107AD5"/><stop offset="1" stop-color="#0A63C9"/></linearGradient></defs></svg>',
		},
		exchange: {
			key: 'exchange',
			name: Loc.getMessage('MAILBOX_CONNECTOR_SERVICE_NAME_EXCHANGE'),
			svgContent: '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M23.9999 6.3999H7.9999C7.11625 6.3999 6.3999 7.11625 6.3999 7.9999V23.9999C6.3999 24.8836 7.11625 25.5999 7.9999 25.5999H23.9999C24.8836 25.5999 25.5999 24.8836 25.5999 23.9999V7.9999C25.5999 7.11625 24.8836 6.3999 23.9999 6.3999Z" fill="#0078D4"/><path d="M19.1441 12.4896H14.6546V15.115H18.8685V16.7975H14.6546V19.5243H19.3833V21.1998H12.6167V10.7996H19.1441L19.1441 12.4896Z" fill="white"/></svg>',
		},
		exchangeOnline: {
			key: 'exchangeOnline',
			name: Loc.getMessage('MAILBOX_CONNECTOR_SERVICE_NAME_EXCHANGE'),
			svgContent: '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M23.9999 6.3999H7.9999C7.11625 6.3999 6.3999 7.11625 6.3999 7.9999V23.9999C6.3999 24.8836 7.11625 25.5999 7.9999 25.5999H23.9999C24.8836 25.5999 25.5999 24.8836 25.5999 23.9999V7.9999C25.5999 7.11625 24.8836 6.3999 23.9999 6.3999Z" fill="#0078D4"/><path d="M19.1441 12.4896H14.6546V15.115H18.8685V16.7975H14.6546V19.5243H19.3833V21.1998H12.6167V10.7996H19.1441L19.1441 12.4896Z" fill="white"/></svg>',
		},
		mailru: {
			key: 'mail.ru',
			name: Loc.getMessage('MAILBOX_CONNECTOR_SERVICE_NAME_MAILRU'),
			svgContent: '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M19.3086 16C19.3086 17.8244 17.8244 19.3086 16 19.3086C14.1756 19.3086 12.6914 17.8244 12.6914 16C12.6914 14.1756 14.1756 12.6914 16 12.6914C17.8244 12.6914 19.3086 14.1756 19.3086 16ZM16 5C9.93429 5 5 9.93429 5 16C5 22.0657 9.93429 27 16 27C18.222 27 20.3646 26.3384 22.1961 25.0868L22.2276 25.0648L20.7457 23.3425L20.7206 23.3582C19.311 24.2657 17.6783 24.745 16 24.745C11.1781 24.745 7.255 20.8219 7.255 16C7.255 11.1781 11.1781 7.255 16 7.255C20.8219 7.255 24.745 11.1781 24.745 16C24.745 16.6246 24.6751 17.2571 24.5391 17.8794C24.2626 19.0148 23.4674 19.3621 22.8711 19.3165C22.2708 19.2678 21.5684 18.8404 21.5636 17.7938V16.9963V16C21.5636 12.9318 19.0682 10.4364 16 10.4364C12.9318 10.4364 10.4364 12.9318 10.4364 16C10.4364 19.0682 12.9318 21.5636 16 21.5636C17.4905 21.5636 18.8883 20.9814 19.9419 19.9215C20.5548 20.8754 21.5534 21.4733 22.6904 21.5644C22.7878 21.5723 22.8876 21.5762 22.9858 21.5762C23.7864 21.5762 24.5792 21.3083 25.2188 20.8235C25.878 20.3222 26.3706 19.5986 26.6425 18.7288C26.6857 18.5881 26.7659 18.2668 26.7659 18.2644L26.7682 18.2526C26.9285 17.5549 27 16.8596 27 16C27 9.93429 22.0657 5 16 5" fill="#FF9E00"/></svg>',
		},
		office365: {
			key: 'office365',
			name: Loc.getMessage('MAILBOX_CONNECTOR_SERVICE_NAME_OFFICE365'),
			svgContent: '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.3999 22.5601V7.96942L18.8397 3.19995L25.5999 5.44356V25.085L18.8397 27.2L6.3999 22.5601L18.8397 24.1134V7.12843L10.7266 9.09267V20.5968L6.3999 22.5601Z" fill="#E43B01"/></svg>',
		},
		other: {
			key: 'other',
			name: Loc.getMessage('MAILBOX_CONNECTOR_SERVICE_NAME_IMAP_MSGVER_1'),
			svgContent: '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M15.9373 15.1656L8.02631 9.41211H23.8483L15.9373 15.1656ZM25.2866 11.1465V10.8505L25.2866 11.1464L25.2866 11.1465ZM25.2866 11.1465L15.9373 18.4475L6.58789 11.1464V21.8307C6.58789 22.5197 7.19014 23.0766 7.93251 23.0766H23.942C24.6861 23.0766 25.2866 22.5189 25.2866 21.8307V11.1465Z" fill="#8E52EC"/></svg>',
		},
	};

	function getServiceInfo(name)
	{
		return services[getServiceKeyByName(name)];
	}

	function getServiceKeyByName(name)
	{
		switch (name)
		{
			case 'aol':
				return 'aol';
			case 'gmail':
				return 'gmail';
			case 'yahoo':
				return 'yahoo';
			case 'mail.ru':
			case 'mailru':
				return 'mailru';
			case 'icloud':
				return 'icloud';
			case 'outlook.com':
			case 'outlook':
				return 'outlook';
			case 'office365':
				return 'office365';
			case 'exchangeOnline':
				return 'exchangeOnline';
			case 'yandex':
				return 'yandex';
			case 'other':
			case 'imap':
				return 'other';
			default:
				return '';
		}
	}

	function getServiceName(name)
	{
		return services[name];
	}

	class ServicesListStep extends WizardStep
	{
		constructor(props)
		{
			super();
			this.props = props;
		}

		isNextStepEnabled()
		{
			return false;
		}

		getTitle()
		{
			return Loc.getMessage('MAILBOX_CONNECTOR_SERVICES_LIST_HEADER_TITLE');
		}

		renderNumberBlock()
		{
			return new ProgressBarNumber({
				number: '1',
			});
		}

		getProgressBarSettings()
		{
			return {
				...super.getProgressBarSettings(),
				isEnabled: true,
				title: {
					text: Loc.getMessage('MAILBOX_CONNECTOR_SERVICES_LIST_TITLE'),
				},
				number: 1,
				count: 3,
			};
		}

		serviceCard(props)
		{
			const {
				id,
				key,
				svgContent,
				name,
				oauthMode,
			} = props;

			return View(
				{
					testId: `connecting-mailboxes-selecting-services-button-with-service-${key}`,
					onClick: this.setService.bind(this, key, id, oauthMode),
					style: {
						marginTop: 12,
						paddingLeft: 12,
						paddingRight: 12,
					},
				},
				View(
					{
						style: {
							borderRadius: 12,
							backgroundColor: AppTheme.colors.bgContentPrimary,
							paddingLeft: 18,
							justifyContent: 'center',
							flexDirection: 'column',
							width: '100%',
							height: 64,
						},
					},
					View(
						{
							style: {
								flexDirection: 'row',
							},
						},
						View(
							{
								style: {
									marginRight: 16,
									width: 32,
									height: 32,
								},
							},
							Image({
								svg: {
									content: svgContent,
								},
								style: {
									width: 32,
									height: 32,
								},
							}),
						),
						Text({
							style: {
								color: AppTheme.colors.base2,
								fontSize: 16,
								fontWeight: 'bold',
							},
							text: name,
						}),
					),
					View(
						{
							style: {
								right: 18,
								position: 'absolute',
							},
						},
						Image({
							style: {
								width: 18,
								height: 18,
							},

							svg: {
								content: `
									<svg width="18" height="19" viewBox="0 0 18 19" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path fill-rule="evenodd" clip-rule="evenodd" d="M6.11279 5.45643L9.50808 8.85172L10.3502 9.7071L9.50808 10.5463L6.11279 13.9416L7.31089 15.1397L12.7515 9.69904L7.31089 4.25842L6.11279 5.45643Z" fill="${AppTheme.colors.base6}"/>
									</svg>
								`,
							},
							resizeMode: 'center',
						}),
					),
				),
			);
		}

		setService(key, id, oauthMode)
		{
			if (this.props.parent)
			{
				this.props.parent.saveMailServiceKey(key);
				this.props.parent.saveMailServiceId(id);
				if (oauthMode)
				{
					this.props.parent.goToOauth();
				}
				else if (key === 'other')
				{
					this.props.parent.goToImap();
				}
				else
				{
					this.props.parent.goToLoginPassword();
				}
			}
		}

		createLayout(props)
		{
			return View(
				{},
				ScrollView(
					{
						style: {
							height: '100%',
						},
					},
					View(
						{
							style: {
								paddingBottom: 50,
							},
						},
						...this.props.parent.getServices().map((item) => {
							const key = getServiceKeyByName(item.name);
							if (services[key])
							{
								return this.serviceCard({
									id: Number(item.id),
									oauthMode: item.oauthMode,
									...services[key],
								});
							}
						}),
					),
				),
			);
		}
	}

	module.exports = {
		ServicesListStep,
		getServiceName,
		getServiceInfo,
	};
});
