/**
 * @module crm/mail/mailbox/connector/steps/connected
 */

jn.define('crm/mail/mailbox/connector/steps/connected', (require, exports, module) => {
	const { WizardStep } = require('layout/ui/wizard/step');
	const { ProgressBarNumber } = require('crm/salescenter/progress-bar-number');
	const { Loc } = require('loc');
	const { getServiceInfo } = require('crm/mail/mailbox/connector/steps/services-list');
	const IS_IOS = Application.getPlatform() === 'ios';
	const lottie = '{"v":"5.7.5","fr":100,"ip":0,"op":220.00000000000003,"w":172,"h":172,"nm":"Comp 1","ddd":0,"assets":[{"id":"1","layers":[{"ddd":0,"ind":1,"ty":4,"nm":"Path","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[10000,10000],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"hd":false,"shapes":[{"ty":"gr","hd":false,"it":[{"ty":"sh","hd":false,"d":1,"ks":{"a":0,"k":{"c":false,"v":[[40.166096,33.37780000053],[43.833896,33.37780000053],[83.423296,1.18750000053],[79.996796,0.00000327057],[79.99039599999999,5.300000000002304e-10],[4.009566,5.300000000002304e-10],[0,1.52762000053],[40.166096,33.37780000053],[40.166096,33.37780000053],[40.166096,33.37780000053]],"i":[[0,0],[-1.080199999999998,0.8295999999999992],[-13.19646666666667,10.7301],[1.538899999999998,0.00158490996],[0.002200000000001978,0],[25.32694333333333,0],[1.062506,-0.949719],[-13.38869866666667,-10.61672666666667],[0,0],[0,0]],"o":[[1.080199999999998,0.8295999999999992],[13.19646666666667,-10.7301],[-1.060999999999993,-0.9484130000000001],[-0.002100000000012869,-0.00000217985],[-25.32694333333333,0],[-1.5414300000000005,0],[13.38869866666666,10.61672666666667],[0,0],[0,0],[1.080199999999998,0.8295999999999992]]}}},{"ty":"fl","c":{"a":0,"k":[0.7843137254901961,0.9372549019607843,1],"ix":2},"o":{"a":0,"k":100,"ix":2},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":2},"e":{"a":0,"k":100,"ix":2},"o":{"a":0,"k":0,"ix":2},"m":1,"hd":false},{"ty":"tr","hd":false,"p":{"a":0,"k":[0.1665039956569672,-5.299999883412454e-10],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2},"r":{"a":0,"k":0,"ix":2},"o":{"a":0,"k":100,"ix":2},"sk":{"a":0,"k":0,"ix":2},"sa":{"a":0,"k":0,"ix":2}}]}],"ip":0,"op":220.00000000000003,"st":0,"bm":0}]},{"id":"2","layers":[{"ddd":0,"ind":3,"ty":4,"nm":"Path","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[10000,10000],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"hd":false,"shapes":[{"ty":"gr","hd":false,"it":[{"ty":"sh","hd":false,"d":1,"ks":{"a":0,"k":{"c":false,"v":[[83.69285,0],[83.87105,0.134033],[44.77435,37.308221],[39.41315,37.308221],[0,0.427002],[0.17436999999999991,0.265595],[42.13555908203125,27.74609375],[83.69285,0]],"i":[[0,0],[-0.05700000000000216,-0.05493799999999999],[13.03223333333334,-12.391396],[1.519999999999996,1.384],[13.13771666666667,12.29373966666667],[0,0],[0,0],[-0.11444091796875,0.23590087890625]],"o":[[0,0],[-13.03223333333334,12.391396],[-1.519999999999996,1.384],[-13.13771666666667,-12.29373966666667],[0.05704699999999996,-0.05493799999999993],[13.26653003692627,8.843430519104004],[0,0],[0,0]]}}},{"ty":"fl","c":{"a":0,"k":[0.4549019607843137,0.7137254901960784,0.8274509803921568],"ix":2},"o":{"a":0,"k":100,"ix":2},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":2},"e":{"a":0,"k":100,"ix":2},"o":{"a":0,"k":0,"ix":2},"m":1,"hd":false},{"ty":"tr","hd":false,"p":{"a":0,"k":[0.90625,0.1862789988517761],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2},"r":{"a":0,"k":0,"ix":2},"o":{"a":0,"k":100,"ix":2},"sk":{"a":0,"k":0,"ix":2},"sa":{"a":0,"k":0,"ix":2}}]}],"ip":0,"op":220.00000000000003,"st":0,"bm":0}]},{"id":"3","layers":[{"ddd":0,"ind":21,"ty":4,"nm":"Path","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[10000,10000],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"hd":false,"shapes":[{"ty":"gr","hd":false,"it":[{"ty":"sh","hd":false,"d":1,"ks":{"a":0,"k":{"c":false,"v":[[40.166096,33.37780000053],[43.833896,33.37780000053],[83.423296,1.18750000053],[79.996796,0.00000327057],[79.99039599999999,5.300000000002304e-10],[4.009566,5.300000000002304e-10],[0,1.52762000053],[40.166096,33.37780000053],[40.166096,33.37780000053],[40.166096,33.37780000053]],"i":[[0,0],[-1.080199999999998,0.8295999999999992],[-13.19646666666667,10.7301],[1.538899999999998,0.00158490996],[0.002200000000001978,0],[25.32694333333333,0],[1.062506,-0.949719],[-13.38869866666667,-10.61672666666667],[0,0],[0,0]],"o":[[1.080199999999998,0.8295999999999992],[13.19646666666667,-10.7301],[-1.060999999999993,-0.9484130000000001],[-0.002100000000012869,-0.00000217985],[-25.32694333333333,0],[-1.5414300000000005,0],[13.38869866666666,10.61672666666667],[0,0],[0,0],[1.080199999999998,0.8295999999999992]]}}},{"ty":"fl","c":{"a":0,"k":[0.7843137254901961,0.9372549019607843,1],"ix":2},"o":{"a":0,"k":100,"ix":2},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":2},"e":{"a":0,"k":100,"ix":2},"o":{"a":0,"k":0,"ix":2},"m":1,"hd":false},{"ty":"tr","hd":false,"p":{"a":0,"k":[0.1665039956569672,-5.299999883412454e-10],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2},"r":{"a":0,"k":0,"ix":2},"o":{"a":0,"k":100,"ix":2},"sk":{"a":0,"k":0,"ix":2},"sa":{"a":0,"k":0,"ix":2}}]}],"ip":0,"op":220.00000000000003,"st":0,"bm":0}]}],"layers":[{"ddd":0,"refId":"1","w":20000,"h":20000,"ind":2,"ty":0,"nm":"top.svg 1","sr":1,"ks":{"o":{"a":1,"k":[{"t":51,"s":[100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":97,"s":[100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":97,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":1,"k":[{"t":51,"s":[86.49846267700195,73.19999999999999],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":97,"s":[86.49846267700195,42],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"a":{"a":0,"k":[10041.878150984645,10017],"ix":2},"s":{"a":1,"k":[{"t":51,"s":[100,100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":97,"s":[100,-99.99873558060139],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2}},"ao":0,"ip":0,"op":220.00000000000003,"st":0,"bm":0,"hd":false},{"ddd":0,"refId":"2","w":20000,"h":20000,"ind":4,"ty":0,"nm":"shadow.svg 1","sr":1,"ks":{"o":{"a":1,"k":[{"t":58,"s":[100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":111,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[86.49846267700195,77],"ix":2},"a":{"a":0,"k":[10042.841773986816,10019.359390109777],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"ip":0,"op":220.00000000000003,"st":0,"bm":0,"hd":false},{"ddd":0,"ind":5,"ty":3,"nm":"","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[86.49846267700195,100],"ix":2},"a":{"a":0,"k":[41.98239898681641,14.5],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"ip":0,"op":220.00000000000003,"st":0,"bm":0,"hd":false},{"ddd":0,"ind":6,"ty":4,"nm":"Path","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"hd":false,"parent":5,"shapes":[{"ty":"gr","hd":false,"it":[{"ty":"sh","hd":false,"d":1,"ks":{"a":0,"k":{"c":false,"v":[[3.73627,29],[79.9854,29],[83.9648,27.5117],[42,0],[0,27.5],[3.73627,29],[3.73627,29],[3.73627,29]],"i":[[0,0],[-25.41637666666667,0],[-1.031199999999998,0.9101999999999997],[13.98826666666667,9.17056666666667],[14,-9.166666666666668],[-1.47619,0],[0,0],[0,0]],"o":[[25.41637666666666,0],[1.476200000000006,0],[-13.98826666666666,-9.170566666666666],[-14,9.166666666666666],[1.04715,0.8790000000000013],[0,0],[0,0],[25.41637666666666,0]]}}},{"ty":"fl","c":{"a":0,"k":[0.5137254901960784,0.796078431372549,0.9254901960784314],"ix":2},"o":{"a":0,"k":100,"ix":2},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":2},"e":{"a":0,"k":100,"ix":2},"o":{"a":0,"k":0,"ix":2},"m":1,"hd":false},{"ty":"tr","hd":false,"p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2},"r":{"a":0,"k":0,"ix":2},"o":{"a":0,"k":100,"ix":2},"sk":{"a":0,"k":0,"ix":2},"sa":{"a":0,"k":0,"ix":2}}]}],"ip":0,"op":220.00000000000003,"st":0,"bm":0},{"ddd":0,"ind":7,"ty":3,"nm":"","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[108.49846267700195,85],"ix":2},"a":{"a":0,"k":[22.00307083129883,27.84375],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"ip":0,"op":220.00000000000003,"st":0,"bm":0,"hd":false},{"ddd":0,"ind":8,"ty":4,"nm":"Path","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"hd":false,"parent":7,"shapes":[{"ty":"gr","hd":false,"it":[{"ty":"sh","hd":false,"d":1,"ks":{"a":0,"k":{"c":false,"v":[[44,50.2363],[44,4.38866],[41.657470703125,-0.03863170742988586],[0.00616455078125,27.65625],[41.957,55.3125],[44,50.2363],[44,50.2363],[44,50.2363]],"i":[[0,0],[0,15.28254666666667],[1.2655999999999992,0.9140600000000001],[13.8646,-9.270833333333336],[-13.98566666666667,-9.166666666666671],[0.08590000000000231,2.287100000000002],[0,0],[0,0]],"o":[[0,-15.28254666666666],[0,-1.54491],[-13.8646,9.270833333333332],[13.98566666666667,9.166666666666664],[1.3068999999999988,-1.0970000000000013],[0,0],[0,0],[0,-15.28254666666666]]}}},{"ty":"fl","c":{"a":0,"k":[0.6235294117647059,0.8862745098039215,1],"ix":2},"o":{"a":0,"k":100,"ix":2},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":2},"e":{"a":0,"k":100,"ix":2},"o":{"a":0,"k":0,"ix":2},"m":1,"hd":false},{"ty":"tr","hd":false,"p":{"a":0,"k":[0,0.1875],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2},"r":{"a":0,"k":0,"ix":2},"o":{"a":0,"k":100,"ix":2},"sk":{"a":0,"k":0,"ix":2},"sa":{"a":0,"k":0,"ix":2}}]}],"ip":0,"op":220.00000000000003,"st":0,"bm":0},{"ddd":0,"ind":9,"ty":3,"nm":"","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[42.49846267700195,57],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"ip":0,"op":220.00000000000003,"st":0,"bm":0,"hd":false},{"ddd":0,"ind":10,"ty":4,"nm":"Path","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"hd":false,"parent":9,"shapes":[{"ty":"gr","hd":false,"it":[{"ty":"sh","hd":false,"d":1,"ks":{"a":0,"k":{"c":false,"v":[[2,54.992188],[44,27.49609375],[2.02344,0],[0.00000235154,5.062997999999999],[0,5.068358],[0,50.915988],[2.71222e-7,50.917888],[2,54.992188],[2,54.992188],[2,54.992188]],"i":[[0,0],[-14,9.166666666666671],[13.99218666666667,9.164062666666668],[0.00161173846,-1.8340799999999993],[7.838466666666667e-7,-0.001786666666666825],[0,-15.28254333333334],[-9.040733333333334e-8,-0.0006333333333330415],[-1.306449,-1.096600000000002],[0,0],[0,0]],"o":[[14,-9.166666666666664],[-13.99218666666667,-9.164062666666666],[-1.305613,1.095918],[-7.838466666666667e-7,0.001786666666666825],[0,15.28254333333333],[9.040733333333334e-8,0.0006333333333330415],[0.000547771778,1.835500000000003],[0,0],[0,0],[14,-9.166666666666664]]}}},{"ty":"fl","c":{"a":0,"k":[0.6235294117647059,0.8862745098039215,1],"ix":2},"o":{"a":0,"k":100,"ix":2},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":2},"e":{"a":0,"k":100,"ix":2},"o":{"a":0,"k":0,"ix":2},"m":1,"hd":false},{"ty":"tr","hd":false,"p":{"a":0,"k":[0,0.5078120231628418],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2},"r":{"a":0,"k":0,"ix":2},"o":{"a":0,"k":100,"ix":2},"sk":{"a":0,"k":0,"ix":2},"sa":{"a":0,"k":0,"ix":2}}]}],"ip":0,"op":220.00000000000003,"st":0,"bm":0},{"ddd":0,"ind":11,"ty":3,"nm":"","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[86.49846267700195,72],"ix":2},"a":{"a":0,"k":[41.77831772249192,15.49713921546936],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"ip":0,"op":220.00000000000003,"st":0,"bm":0,"hd":false},{"ddd":0,"ind":12,"ty":4,"nm":"Path","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"hd":false,"parent":11,"shapes":[{"ty":"gr","hd":false,"it":[{"ty":"sh","hd":false,"d":1,"ks":{"a":0,"k":{"c":false,"v":[[83.4124777285349,0],[83.62502392067607,0.1688856956520825],[42.07109202348747,28.68293752458378],[0,0.5257649931650938],[0.2125693189289198,0.3569692612684442],[42.07109202348747,22.93079340798857],[83.4124777285349,0],[83.4124777285349,0],[83.4124777285349,0]],"i":[[0,0],[-0.06958059516633372,-0.05784372890519493],[13.8513106323962,-9.504683942977234],[14.02369734116249,9.385724177139565],[-0.0721675916830164,0.0546999405285323],[-13.95284090151952,-7.52460804890671],[-13.78046190168247,7.64359780266286],[0,0],[0,0]],"o":[[0.07208349427303391,0.0547305875221415],[-13.8513106323962,9.504683942977232],[-14.02369734116249,-9.385724177139561],[0.06952743358930237,-0.05781407052428304],[13.95284090151952,7.52460804890671],[13.78046190168247,-7.643597802662856],[0,0],[0,0],[0.07208349427303391,0.0547305875221415]]}}},{"ty":"fl","c":{"a":0,"k":[0.8627450980392157,0.8627450980392157,0.8627450980392157],"ix":2},"o":{"a":0,"k":100,"ix":2},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":2},"e":{"a":0,"k":100,"ix":2},"o":{"a":0,"k":0,"ix":2},"m":1,"hd":false},{"ty":"tr","hd":false,"p":{"a":0,"k":[-0.19537353515625,0.63037109375],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2},"r":{"a":0,"k":0,"ix":2},"o":{"a":0,"k":100,"ix":2},"sk":{"a":0,"k":0,"ix":2},"sa":{"a":0,"k":0,"ix":2}}]}],"ip":0,"op":220.00000000000003,"st":0,"bm":0},{"ddd":0,"ind":13,"ty":3,"nm":"","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":1,"k":[{"t":141,"s":[86.49846267700195,85.90945238958805],"i":{"x":[0.5],"y":[1.5]},"o":{"x":[0.8],"y":[0]}},{"t":198,"s":[86.49846267700195,55.909452389588054],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"a":{"a":0,"k":[40,25],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"ip":0,"op":220.00000000000003,"st":0,"bm":0,"hd":false},{"ddd":0,"ind":14,"ty":4,"nm":"Path","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"hd":false,"parent":13,"shapes":[{"ty":"gr","hd":false,"it":[{"ty":"sh","hd":false,"d":1,"ks":{"a":0,"k":{"c":false,"v":[[0,1.125000000000004],[1.125,3.552713678800501e-15],[38.031,3.552713678800501e-15],[39.156,1.125000000000004],[38.031,2.250000000000004],[1.125,2.250000000000004],[0,1.125000000000004],[0,1.125000000000004],[0,1.125000000000004]],"i":[[0,0],[-0.6212999999999997,0],[-12.302,0],[0,-0.6214000000000013],[0.621299999999998,0],[12.302,0],[0,0.621299999999998],[0,0],[0,0]],"o":[[0,-0.6214000000000013],[12.302,0],[0.621299999999998,0],[0,0.621299999999998],[-12.302,0],[-0.6212999999999997,0],[0,0],[0,0],[0,-0.6214000000000013]]}}},{"ty":"fl","c":{"a":0,"k":[0.8784313725490196,0.8784313725490196,0.8784313725490196],"ix":2},"o":{"a":0,"k":100,"ix":2},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":2},"e":{"a":0,"k":100,"ix":2},"o":{"a":0,"k":0,"ix":2},"m":1,"hd":false},{"ty":"tr","hd":false,"p":{"a":0,"k":[13.75,28.71439933776855],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2},"r":{"a":0,"k":0,"ix":2},"o":{"a":0,"k":100,"ix":2},"sk":{"a":0,"k":0,"ix":2},"sa":{"a":0,"k":0,"ix":2}}]}],"ip":0,"op":220.00000000000003,"st":0,"bm":0},{"ddd":0,"ind":15,"ty":4,"nm":"Path","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"hd":false,"parent":13,"shapes":[{"ty":"gr","hd":false,"it":[{"ty":"sh","hd":false,"d":1,"ks":{"a":0,"k":{"c":false,"v":[[0,1.125],[1.125,0],[41.625,0],[42.75,1.125],[41.625,2.25],[1.125,2.25],[0,1.125],[0,1.125],[0,1.125]],"i":[[0,0],[-0.6212999999999997,0],[-13.5,0],[0,-0.6214000000000013],[0.621299999999998,0],[13.5,0],[0,0.621299999999998],[0,0],[0,0]],"o":[[0,-0.6214000000000013],[13.5,0],[0.621299999999998,0],[0,0.621299999999998],[-13.5,0],[-0.6212999999999997,0],[0,0],[0,0],[0,-0.6214000000000013]]}}},{"ty":"fl","c":{"a":0,"k":[0.8784313725490196,0.8784313725490196,0.8784313725490196],"ix":2},"o":{"a":0,"k":100,"ix":2},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":2},"e":{"a":0,"k":100,"ix":2},"o":{"a":0,"k":0,"ix":2},"m":1,"hd":false},{"ty":"tr","hd":false,"p":{"a":0,"k":[13.75,23.46439933776855],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2},"r":{"a":0,"k":0,"ix":2},"o":{"a":0,"k":100,"ix":2},"sk":{"a":0,"k":0,"ix":2},"sa":{"a":0,"k":0,"ix":2}}]}],"ip":0,"op":220.00000000000003,"st":0,"bm":0},{"ddd":0,"ind":16,"ty":4,"nm":"Path","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"hd":false,"parent":13,"shapes":[{"ty":"gr","hd":false,"it":[{"ty":"sh","hd":false,"d":1,"ks":{"a":1,"k":[{"t":58,"s":[{"c":false,"v":[[0,1.125],[1.125,0],[18.563,0],[19.688,1.125],[18.563,2.250000000000002],[1.125,2.250000000000002],[0,1.125],[0,1.125],[0,1.125]],"i":[[0,0],[-0.6212999999999997,0],[-5.812666666666669,0],[0,-0.6213999999999995],[0.621299999999998,0],[5.812666666666669,0],[0,0.6212999999999997],[0,0],[0,0]],"o":[[0,-0.6213999999999995],[5.812666666666665,0],[0.621299999999998,0],[0,0.6212999999999997],[-5.812666666666665,0],[-0.6212999999999997,0],[0,0],[0,0],[0,-0.6213999999999995]]}],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[{"c":false,"v":[[0,1.125],[1.125,0],[18.563,0],[19.688,1.125],[18.563,2.250000000000002],[1.125,2.250000000000002],[0,1.125],[0,1.125],[0,1.125]],"i":[[0,0],[-0.6212999999999997,0],[-5.812666666666669,0],[0,-0.6213999999999995],[0.621299999999998,0],[5.812666666666669,0],[0,0.6212999999999997],[0,0],[0,0]],"o":[[0,-0.6213999999999995],[5.812666666666665,0],[0.621299999999998,0],[0,0.6212999999999997],[-5.812666666666665,0],[-0.6212999999999997,0],[0,0],[0,0],[0,-0.6213999999999995]]}],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2}},{"ty":"fl","c":{"a":1,"k":[{"t":58,"s":[0.8784313725490196,0.8784313725490196,0.8784313725490196],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0.8784313725490196,0.8784313725490196,0.8784313725490196],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"o":{"a":1,"k":[{"t":58,"s":[100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false},{"ty":"tm","s":{"a":1,"k":[{"t":58,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"e":{"a":1,"k":[{"t":58,"s":[100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"o":{"a":1,"k":[{"t":58,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"m":1,"hd":false},{"ty":"tr","hd":false,"p":{"a":1,"k":[{"t":58,"s":[13.75,14.46440029144287],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[13.75,14.46440029144287],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"a":{"a":1,"k":[{"t":58,"s":[0,0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0,0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"s":{"a":1,"k":[{"t":58,"s":[100,100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[100,100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"r":{"a":1,"k":[{"t":58,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"o":{"a":1,"k":[{"t":58,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":141,"s":[100],"i":{"x":[0.5],"y":[1.5]},"o":{"x":[0.8],"y":[0]}}],"ix":2},"sk":{"a":1,"k":[{"t":58,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"sa":{"a":1,"k":[{"t":58,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2}}]}],"ip":0,"op":220.00000000000003,"st":0,"bm":0},{"ddd":0,"ind":17,"ty":4,"nm":"Path","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"hd":false,"parent":13,"shapes":[{"ty":"gr","hd":false,"it":[{"ty":"sh","hd":false,"d":1,"ks":{"a":1,"k":[{"t":58,"s":[{"c":false,"v":[[0,1.125000000000002],[1.125,1.77635683940025e-15],[11.4753,1.77635683940025e-15],[12.6003,1.125000000000002],[11.4753,2.250000000000002],[1.125,2.250000000000002],[0,1.125000000000002],[0,1.125000000000002],[0,1.125000000000002]],"i":[[0,0],[-0.6212999999999997,0],[-3.450100000000003,0],[0,-0.6213200000000008],[0.621299999999998,0],[3.450099999999999,0],[0,0.6212999999999997],[0,0],[0,0]],"o":[[0,-0.6213200000000008],[3.450099999999999,0],[0.621299999999998,0],[0,0.6212999999999997],[-3.450099999999999,0],[-0.6212999999999997,0],[0,0],[0,0],[0,-0.6213200000000008]]}],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[{"c":false,"v":[[0,1.125000000000002],[1.125,1.77635683940025e-15],[11.4753,1.77635683940025e-15],[12.6003,1.125000000000002],[11.4753,2.250000000000002],[1.125,2.250000000000002],[0,1.125000000000002],[0,1.125000000000002],[0,1.125000000000002]],"i":[[0,0],[-0.6212999999999997,0],[-3.450100000000003,0],[0,-0.6213200000000008],[0.621299999999998,0],[3.450099999999999,0],[0,0.6212999999999997],[0,0],[0,0]],"o":[[0,-0.6213200000000008],[3.450099999999999,0],[0.621299999999998,0],[0,0.6212999999999997],[-3.450099999999999,0],[-0.6212999999999997,0],[0,0],[0,0],[0,-0.6213200000000008]]}],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2}},{"ty":"fl","c":{"a":1,"k":[{"t":58,"s":[0.8784313725490196,0.8784313725490196,0.8784313725490196],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0.8784313725490196,0.8784313725490196,0.8784313725490196],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"o":{"a":1,"k":[{"t":58,"s":[100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false},{"ty":"tm","s":{"a":1,"k":[{"t":58,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"e":{"a":1,"k":[{"t":58,"s":[100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"o":{"a":1,"k":[{"t":58,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"m":1,"hd":false},{"ty":"tr","hd":false,"p":{"a":1,"k":[{"t":58,"s":[13.75,9],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[13.75,9],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"a":{"a":1,"k":[{"t":58,"s":[0,0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0,0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"s":{"a":1,"k":[{"t":58,"s":[100,100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[100,100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"r":{"a":1,"k":[{"t":58,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"o":{"a":1,"k":[{"t":58,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":141,"s":[100],"i":{"x":[0.5],"y":[1.5]},"o":{"x":[0.8],"y":[0]}}],"ix":2},"sk":{"a":1,"k":[{"t":58,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"sa":{"a":1,"k":[{"t":58,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":139,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2}}]}],"ip":0,"op":220.00000000000003,"st":0,"bm":0},{"ddd":0,"ind":18,"ty":4,"nm":"Path","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"hd":false,"parent":13,"shapes":[{"ty":"gr","hd":false,"it":[{"ty":"sh","hd":false,"d":1,"ks":{"a":0,"k":{"c":false,"v":[[0,2],[2,0],[78,0],[80,2],[80,48],[78,50],[2,50],[0,48],[0,2],[0,2],[0,2]],"i":[[0,0],[-1.104569,0],[-25.33333333333334,0],[0,-1.10457],[0,-15.33333333333334],[1.104600000000005,0],[25.33333333333334,0],[0,1.104599999999998],[0,15.33333333333334],[0,0],[0,0]],"o":[[0,-1.104571],[25.33333333333333,0],[1.104600000000005,0],[0,15.33333333333333],[0,1.104599999999998],[-25.33333333333333,0],[-1.104571,0],[0,-15.33333333333333],[0,0],[0,0],[0,-1.104571]]}}},{"ty":"fl","c":{"a":0,"k":[0.9490196078431372,0.9490196078431372,0.9490196078431372],"ix":2},"o":{"a":0,"k":100,"ix":2},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":2},"e":{"a":0,"k":100,"ix":2},"o":{"a":0,"k":0,"ix":2},"m":1,"hd":false},{"ty":"tr","hd":false,"p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2},"r":{"a":0,"k":0,"ix":2},"o":{"a":0,"k":100,"ix":2},"sk":{"a":0,"k":0,"ix":2},"sa":{"a":0,"k":0,"ix":2}}]}],"ip":0,"op":220.00000000000003,"st":0,"bm":0},{"ddd":0,"ind":19,"ty":3,"nm":"","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[86.49846267700195,85],"ix":2},"a":{"a":0,"k":[44,29],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"ip":0,"op":220.00000000000003,"st":0,"bm":0,"hd":false},{"ddd":0,"ind":20,"ty":4,"nm":"Path","sr":1,"ks":{"o":{"a":0,"k":100,"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2}},"ao":0,"hd":false,"parent":19,"shapes":[{"ty":"gr","hd":false,"it":[{"ty":"sh","hd":false,"d":1,"ks":{"a":0,"k":{"c":false,"v":[[0,6],[6,0],[82,0],[88,6],[88,52],[82,58],[6,58],[0,52],[0,6],[0,6],[0,6]],"i":[[0,0],[-3.31371,0],[-25.33333333333334,0],[0,-3.31371],[0,-15.33333333333334],[3.313699999999997,0],[25.33333333333334,0],[0,3.313699999999997],[0,15.33333333333334],[0,0],[0,0]],"o":[[0,-3.31371],[25.33333333333333,0],[3.313699999999997,0],[0,15.33333333333333],[0,3.313699999999997],[-25.33333333333333,0],[-3.31371,0],[0,-15.33333333333333],[0,0],[0,0],[0,-3.31371]]}}},{"ty":"fl","c":{"a":0,"k":[0.7843137254901961,0.9372549019607843,1],"ix":2},"o":{"a":0,"k":100,"ix":2},"r":1,"bm":0,"nm":"Fill 1","mn":"ADBE Vector Graphic - Fill","hd":false},{"ty":"tm","s":{"a":0,"k":0,"ix":2},"e":{"a":0,"k":100,"ix":2},"o":{"a":0,"k":0,"ix":2},"m":1,"hd":false},{"ty":"tr","hd":false,"p":{"a":0,"k":[0,0],"ix":2},"a":{"a":0,"k":[0,0],"ix":2},"s":{"a":0,"k":[100,100],"ix":2},"r":{"a":0,"k":0,"ix":2},"o":{"a":0,"k":100,"ix":2},"sk":{"a":0,"k":0,"ix":2},"sa":{"a":0,"k":0,"ix":2}}]}],"ip":0,"op":220.00000000000003,"st":0,"bm":0},{"ddd":0,"refId":"3","w":20000,"h":20000,"ind":22,"ty":0,"nm":"top.svg 2","sr":1,"ks":{"o":{"a":1,"k":[{"t":90,"s":[0],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}},{"t":97,"s":[100],"i":{"x":[1],"y":[1]},"o":{"x":[0],"y":[0]}}],"ix":2},"r":{"a":0,"k":0,"ix":2},"p":{"a":0,"k":[86.49846267700195,42],"ix":2},"a":{"a":0,"k":[10041.878150984645,10017],"ix":2},"s":{"a":0,"k":[100,-100],"ix":2}},"ao":0,"ip":0,"op":220.00000000000003,"st":0,"bm":0,"hd":false}],"markers":[]}';
	const AppTheme = require('apptheme');

	class Connected extends WizardStep
	{
		constructor(props)
		{
			super();
			this.props = props;
		}

		get getSuccessAnimationSize()
		{
			const screenWidth = device.screen.width;
			if (screenWidth > 400)
			{
				return {
					width: 360,
					height: 288,
				};
			}

			if (screenWidth > 380)
			{
				return {
					width: 334,
					height: 270,
				};
			}

			if (screenWidth > 350)
			{
				return {
					width: 292,
					height: 236,
				};
			}

			return {
				width: 250,
				height: 202,
			};
		}

		isPrevStepEnabled()
		{
			return false;
		}

		onFinishStep()
		{
			this.props.parent.successAction(this.props.parent.getConnectedEmail());
		}

		isNextStepEnabled()
		{
			return true;
		}

		getTitle()
		{
			return Loc.getMessage('MAILBOX_CONNECTOR_CONNECTED_HEADER_TITLE');
		}

		renderNumberBlock()
		{
			return new ProgressBarNumber({
				number: '3',
			});
		}

		getProgressBarSettings()
		{
			return {
				...super.getProgressBarSettings(),
				isEnabled: true,
				title: {
					text: Loc.getMessage('MAILBOX_CONNECTOR_CONNECTED_TITLE'),
				},
				number: 3,
				count: 3,
			};
		}

		emailBlock()
		{
			const serviceKey = this.props.parent.getMailServiceKey();
			const connectedEmail = this.props.parent.getConnectedEmail();

			if (!serviceKey || !connectedEmail)
			{
				return null;
			}

			return View(
				{
					style: {
						marginBottom: 20,
						justifyContent: 'center',
						flexDirection: 'row',
					},
				},
				View(
					{
						style: {
							marginRight: 10,
							width: 32,
							height: 32,
						},
					},
					Image({
						svg: {
							content: getServiceInfo(serviceKey).svgContent,
						},
						style: {
							width: 32,
							height: 32,
						},
					}),
				),
				Text({
					ellipsize: 'end',
					numberOfLines: 1,
					style: {
						maxWidth: 200,
						textAlign: 'center',
						color: AppTheme.colors.base2,
						fontSize: 18,
						fontWeight: '400',
					},
					text: connectedEmail,
				}),
			);
		}

		createLayout(props)
		{
			return View(
				{
					style: {
						flex: 1,
						padding: 16,
						paddingBottom: IS_IOS ? (16 + device.screen.safeArea.bottom) : 16,
					},
				},
				View(
					{
						style: {
							flex: 1,
							justifyContent: 'center',
							borderRadius: 12,
							backgroundColor: AppTheme.colors.bgContentSecondary,
							paddingHorizontal: 16,
							paddingTop: 16,
							paddingBottom: 54,
						},
					},
					this.emailBlock(),
					View(
						{
							style: {
								justifyContent: 'center',
								flexDirection: 'row',
							},
						},
						LottieView(
							{
								style: {
									...this.getSuccessAnimationSize,
								},
								data: {
									content: lottie,
								},
								params: {},
								autoPlay: true,
							},
						),
					),
					Text({
						style: {
							textAlign: 'center',
							color: AppTheme.colors.base2,
							fontSize: 18,
							fontWeight: '400',
						},
						text: Loc.getMessage('MAILBOX_CONNECTOR_CONNECTED_TITLE'),
					}),
					Text({
						style: {
							paddingBottom: 5,
							textAlign: 'center',
							color: AppTheme.colors.base2,
							fontSize: 15,
							fontWeight: '400',
						},
						text: Loc.getMessage('MAILBOX_CONNECTOR_CONNECTED_TEXT_1'),
					}),
				),
			);
		}
	}

	module.exports = { Connected };
});
