<?php
namespace Bitrix\Crm\Statistics\Entity;

use Bitrix\Main;
use Bitrix\Main\Entity;
use Bitrix\Crm;

/**
 * Class ContactActivityMarkStatisticsTable
 *
 * DO NOT WRITE ANYTHING BELOW THIS
 *
 * <<< ORMENTITYANNOTATION
 * @method static EO_ContactActivityMarkStatistics_Query query()
 * @method static EO_ContactActivityMarkStatistics_Result getByPrimary($primary, array $parameters = [])
 * @method static EO_ContactActivityMarkStatistics_Result getById($id)
 * @method static EO_ContactActivityMarkStatistics_Result getList(array $parameters = [])
 * @method static EO_ContactActivityMarkStatistics_Entity getEntity()
 * @method static \Bitrix\Crm\Statistics\Entity\EO_ContactActivityMarkStatistics createObject($setDefaultValues = true)
 * @method static \Bitrix\Crm\Statistics\Entity\EO_ContactActivityMarkStatistics_Collection createCollection()
 * @method static \Bitrix\Crm\Statistics\Entity\EO_ContactActivityMarkStatistics wakeUpObject($row)
 * @method static \Bitrix\Crm\Statistics\Entity\EO_ContactActivityMarkStatistics_Collection wakeUpCollection($rows)
 */
class ContactActivityMarkStatisticsTable  extends Entity\DataManager
{
	/**
	* @return string
	*/
	public static function getTableName()
	{
		return 'b_crm_contact_act_mark_stat';
	}
	/**
	* @return array
	*/
	public static function getMap()
	{
		return array(
			'OWNER_ID' => array('data_type' => 'integer', 'required' => true, 'primary' => true),
			'DEADLINE_DATE' => array('data_type' => 'date', 'required' => true, 'primary' => true),
			'PROVIDER_ID' => array('data_type' => 'string', 'primary' => true),
			'PROVIDER_TYPE_ID' => array('data_type' => 'string', 'primary' => true),
			'SOURCE_ID' => array('data_type' => 'string', 'primary' => true),
			
			'RESPONSIBLE_ID' => array('data_type' => 'integer'),
			'NONE_QTY' => array('data_type' => 'integer'),
			'POSITIVE_QTY' => array('data_type' => 'integer'),
			'NEGATIVE_QTY' => array('data_type' => 'integer'),
			'TOTAL' => array(
				'data_type' => 'integer',
				'expression' => array( '(%s + %s + %s)', 'NONE_QTY', 'POSITIVE_QTY', 'NEGATIVE_QTY' )
			),
		);
	}
	/**
	* @return void
	*/
	public static function upsert(array $data)
	{
		$fields = array(
			'RESPONSIBLE_ID' => isset($data['RESPONSIBLE_ID']) ? (int)$data['RESPONSIBLE_ID'] : 0,
			'NONE_QTY' => isset($data['NONE_QTY']) ? (int)$data['NONE_QTY'] : 0,
			'POSITIVE_QTY' => isset($data['POSITIVE_QTY']) ? (int)$data['POSITIVE_QTY'] : 0,
			'NEGATIVE_QTY' => isset($data['NEGATIVE_QTY']) ? (int)$data['NEGATIVE_QTY'] : 0
		);

		$connection = Main\Application::getConnection();
		$queries = $connection->getSqlHelper()->prepareMerge(
			'b_crm_contact_act_mark_stat',
			array('OWNER_ID', 'DEADLINE_DATE', 'PROVIDER_ID', 'PROVIDER_TYPE_ID', 'SOURCE_ID'),
			array_merge(
				$fields,
				array(
					'OWNER_ID' => isset($data['OWNER_ID']) ? $data['OWNER_ID'] : 0,
					'DEADLINE_DATE' => isset($data['DEADLINE_DATE']) ? $data['DEADLINE_DATE'] : null,
					'PROVIDER_ID' => isset($data['PROVIDER_ID']) ? $data['PROVIDER_ID'] : null,
					'PROVIDER_TYPE_ID' => isset($data['PROVIDER_TYPE_ID']) ? $data['PROVIDER_TYPE_ID'] : null,
					'SOURCE_ID' => isset($data['SOURCE_ID']) ? $data['SOURCE_ID'] : null
				)
			),
			$fields
		);

		foreach($queries as $query)
		{
			$connection->queryExecute($query);
		}
	}
	/**
	* @return void
	*/
	public static function deleteByOwner($ownerID)
	{
		if(!is_int($ownerID))
		{
			$ownerID = (int)$ownerID;
		}

		if($ownerID <= 0)
		{
			throw new Main\ArgumentException('Owner ID must be greater than zero.', 'ownerID');
		}

		Main\Application::getConnection()->queryExecute("DELETE FROM b_crm_contact_act_mark_stat WHERE OWNER_ID = {$ownerID}");
	}
	/**
	* @return void
	*/
	public static function synchronize($ownerID, array $data)
	{
		if(!is_int($ownerID))
		{
			$ownerID = (int)$ownerID;
		}

		if($ownerID <= 0)
		{
			throw new Main\ArgumentException('Owner ID must be greater than zero.', 'ownerID');
		}

		$userID = isset($data['RESPONSIBLE_ID']) ? (int)$data['RESPONSIBLE_ID'] : 0;
		Main\Application::getConnection()->queryExecute(
			"UPDATE b_crm_contact_act_mark_stat SET RESPONSIBLE_ID = {$userID} WHERE OWNER_ID = {$ownerID}"
		);
	}
}