<?php
namespace Bitrix\Crm\RestView;

use Bitrix\Main\Result;
use Bitrix\Rest\Integration\View\Base;
use Bitrix\Rest\Integration\View\DataType;
use Bitrix\Rest\Integration\View\Attributes;

final class OrderEntity extends Base
{
	public function getFields(): array
	{
		return [
			'OWNER_ID' => [
				'TYPE' => DataType::TYPE_INT,
				'ATTRIBUTES' => [
					Attributes::IMMUTABLE,
					Attributes::REQUIRED,
				],
			],
			'OWNER_TYPE_ID' => [
				'TYPE' => DataType::TYPE_INT,
				'ATTRIBUTES' => [
					Attributes::IMMUTABLE,
					Attributes::REQUIRED,
				],
			],
			'ORDER_ID' => [
				'TYPE' => DataType::TYPE_INT,
				'ATTRIBUTES' => [
					Attributes::IMMUTABLE,
					Attributes::REQUIRED,
				],
			],
		];
	}

	public function convertKeysToSnakeCaseArguments($name, $arguments)
	{
		if ($name === 'deletebyfilter')
		{
			if (isset($arguments['fields']))
			{
				$fields = $arguments['fields'];
				if (!empty($fields))
				{
					$arguments['fields'] = $this->convertKeysToSnakeCaseFields($fields);
				}
			}
		}
		else
		{
			$arguments =  parent::convertKeysToSnakeCaseArguments($name, $arguments);
		}

		return $arguments;
	}

	public function checkArguments($name, $arguments): Result
	{
		if ($name === 'deletebyfilter')
		{
			return $this->checkFieldsAdd($arguments['fields']);
		}

		return parent::checkArguments($name, $arguments);
	}

	public function internalizeArguments($name, $arguments): array
	{
		if ($name === 'deletebyfilter')
		{
			$fields = $arguments['fields'];
			if (!empty($fields))
			{
				$arguments['fields'] = $this->internalizeFieldsAdd($fields);
			}
		}
		else
		{
			parent::internalizeArguments($name, $arguments);
		}

		return $arguments;
	}
}
