<?php

namespace Bitrix\Crm\Integration\Report\View;

use Bitrix\Report\VisualConstructor\Config\Common;
use Bitrix\Report\VisualConstructor\Fields\Valuable\Hidden;
use Bitrix\Report\VisualConstructor\Handler\BaseWidget;
use Bitrix\Report\VisualConstructor\Views\Component\Base;

class ColumnFunnel extends Base
{
	const VIEW_KEY = 'column_funnel';
	const MAX_RENDER_REPORT_COUNT = 3;
	const USE_IN_VISUAL_CONSTRUCTOR = false;

	const CLASSIC_CALCULATE_MODE = '0';
	const CONVERSION_CALCULATE_MODE = '1';

	public function __construct()
	{
		parent::__construct();

		$this->setDraggable(false);
		$this->setComponentName('bitrix:crm.report.vc.widget.content.columnfunnel');
		$this->setPreviewImageUri('/bitrix/images/report/visualconstructor/preview/graph.svg');
		$this->setCompatibleDataType(Common::MULTIPLE_REPORT_TYPE);
	}


	public function handlerFinallyBeforePassToView($calculatedPerformedData)
	{
		return parent::handlerFinallyBeforePassToView($calculatedPerformedData); // TODO: Change the autogenerated stub
	}

	/**
	 * Method to modify widget form elements.
	 *
	 * @param BaseWidget $widgetHandler Widget handler.
	 * @return void
	 */
	public function collectWidgetHandlerFormElements(BaseWidget $widgetHandler)
	{
		parent::collectWidgetHandlerFormElements($widgetHandler);

		$utilConfigurationField = new Hidden('shortMode');
		$utilConfigurationField->setDefaultValue(false);
		$widgetHandler->addFormElement($utilConfigurationField);


		$calculateModeField = new Hidden('calculateMode');
		$calculateModeField->setDefaultValue(self::CLASSIC_CALCULATE_MODE);
		$widgetHandler->addFormElement($calculateModeField);
	}
}