<?php

namespace Bitrix\Crm\Entity\MessageBuilder;

use Bitrix\Main\Localization\Loc;

Loc::loadMessages(__FILE__);

/**
 * Supported phrase codes:
 * 	CRM_PROCESS_ENTITY_LEAD_BECOME_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_DEAL_BECOME_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_RECURRING_DEAL_BECOME_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_ORDER_BECOME_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_CONTACT_BECOME_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_COMPANY_BECOME_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_SMART_INVOICE_BECOME_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_QUOTE_BECOME_RESPONSIBLE_MSGVER_1
 * 	CRM_PROCESS_ENTITY_DYNAMIC_BECOME_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_DEFAULT_BECOME_RESPONSIBLE
 *
 * 	CRM_PROCESS_ENTITY_LEAD_NO_LONGER_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_DEAL_NO_LONGER_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_RECURRING_DEAL_NO_LONGER_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_ORDER_NO_LONGER_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_CONTACT_NO_LONGER_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_COMPANY_NO_LONGER_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_SMART_INVOICE_NO_LONGER_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_QUOTE_NO_LONGER_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_DYNAMIC_NO_LONGER_RESPONSIBLE
 * 	CRM_PROCESS_ENTITY_DEFAULT_NO_LONGER_RESPONSIBLE
 */
final class ProcessEntityResponsible extends ProcessEntity
{
	public const BECOME_RESPONSIBLE = 'BECOME_RESPONSIBLE';
	public const NO_LONGER_RESPONSIBLE = 'NO_LONGER_RESPONSIBLE';

	public static function getFilePath(): string
	{
		return __FILE__;
	}
}
