<?php

namespace Bitrix\Crm\Entity\MessageBuilder;

use Bitrix\Main\Localization\Loc;

Loc::loadMessages(__FILE__);

/**
 * Supported phrase codes:
 * CRM_PROCESS_ENTITY_DEFAULT_BECOME_OBSERVER
 * CRM_PROCESS_ENTITY_LEAD_BECOME_OBSERVER
 * CRM_PROCESS_ENTITY_DEAL_BECOME_OBSERVER
 * CRM_PROCESS_ENTITY_CONTACT_BECOME_OBSERVER
 * CRM_PROCESS_ENTITY_COMPANY_BECOME_OBSERVER
 * CRM_PROCESS_ENTITY_SMART_INVOICE_BECOME_OBSERVER
 * CRM_PROCESS_ENTITY_DYNAMIC_BECOME_OBSERVER
 *
 * CRM_PROCESS_ENTITY_DEFAULT_NO_LONGER_OBSERVER
 * CRM_PROCESS_ENTITY_LEAD_NO_LONGER_OBSERVER
 * CRM_PROCESS_ENTITY_DEAL_NO_LONGER_OBSERVER
 * CRM_PROCESS_ENTITY_CONTACT_NO_LONGER_OBSERVER
 * CRM_PROCESS_ENTITY_COMPANY_NO_LONGER_OBSERVER
 * CRM_PROCESS_ENTITY_SMART_INVOICE_NO_LONGER_OBSERVER
 * CRM_PROCESS_ENTITY_DYNAMIC_NO_LONGER_OBSERVER
 */
final class ProcessEntityObserver extends ProcessEntity
{
	public const BECOME_OBSERVER = 'BECOME_OBSERVER';
	public const NO_LONGER_OBSERVER = 'NO_LONGER_OBSERVER';

	public static function getFilePath(): string
	{
		return __FILE__;
	}
}
