import ControllerManager from './controller-manager';

import { Activity } from './controllers/activity';
import { CommonContentBlocks } from './controllers/common-content-blocks';
import { OpenLines } from './controllers/openlines';
import { Modification } from './controllers/modification';
import { SignB2eDocument } from './controllers/sign-b2e-document';
import { SignDocument } from './controllers/sign-document';
import { Document } from './controllers/document';
import { Call } from './controllers/call';
import { ToDo } from './controllers/todo';
import { Helpdesk } from './controllers/helpdesk';
import { Payment } from './controllers/payment';
import { DealProductList } from './controllers/deal-product-list';
import { Email } from './controllers/email';
import { OrderCheck } from './controllers/order-check';
import { FinalSummary } from './controllers/finalsummary';
import { SalescenterApp } from './controllers/salescenter-app';
import { Delivery } from './controllers/delivery';
import { RestApp } from './controllers/rest-app';
import { Comment } from './controllers/comment';
import { Sharing } from './controllers/calendar/sharing';
import { Task } from './controllers/task';
import { TranscriptResult } from './controllers/ai/transcript-result';
import { TranscriptSummaryResult } from './controllers/ai/transcript-summary-result';
import { EntityFieldsFillingResult } from './controllers/ai/entity-fields-filling-result';
import { CallScoringResult } from './controllers/ai/call-scoring-result';
import { Visit } from './controllers/visit';
import { Zoom } from './controllers/zoom';
import { Sms } from './controllers/sms';
import { WhatsApp } from './controllers/whatsapp';
import { Bizproc } from './controllers/bizproc/bizproc';
import { Booking } from './controllers/booking';

ControllerManager.registerController(Activity);
ControllerManager.registerController(CommonContentBlocks);
ControllerManager.registerController(OpenLines);
ControllerManager.registerController(Modification);
ControllerManager.registerController(SignDocument);
ControllerManager.registerController(Document);
ControllerManager.registerController(Call);
ControllerManager.registerController(ToDo);
ControllerManager.registerController(Helpdesk);
ControllerManager.registerController(Payment);
ControllerManager.registerController(DealProductList);
ControllerManager.registerController(Email);
ControllerManager.registerController(OrderCheck);
ControllerManager.registerController(FinalSummary);
ControllerManager.registerController(SalescenterApp);
ControllerManager.registerController(Delivery);
ControllerManager.registerController(RestApp);
ControllerManager.registerController(Comment);
ControllerManager.registerController(Sharing);
ControllerManager.registerController(Task);
ControllerManager.registerController(TranscriptResult);
ControllerManager.registerController(TranscriptSummaryResult);
ControllerManager.registerController(EntityFieldsFillingResult);
ControllerManager.registerController(CallScoringResult);
ControllerManager.registerController(SignB2eDocument);
ControllerManager.registerController(Visit);
ControllerManager.registerController(Zoom);
ControllerManager.registerController(Sms);
ControllerManager.registerController(WhatsApp);
ControllerManager.registerController(Bizproc);
ControllerManager.registerController(Booking);
