import {ClientMark as ClientMarkType} from '../enums/client-mark';

export const ClientMark = {
	props: {
		mark: {
			type: String,
			required: false,
			default: ClientMarkType.POSITIVE,
		},

		text: {
			type: String,
			required: false,
			default: '',
		},

	},
	computed: {
		className(): Object {
			return {
				'crm-timeline__client-mark': true,
				'--positive-mark': this.mark === ClientMarkType.POSITIVE,
				'--neutral-mark': this.mark === ClientMarkType.NEUTRAL,
				'--negative-mark': this.mark === ClientMarkType.NEGATIVE,
			}
		},

		iconClassname() {
			return {
				'crm-timeline__client-mark_icon': true,
				'--flipped': this.mark === ClientMarkType.NEGATIVE,
			}
		},


	},
	template: `
		<div :class="className">
			<i class="crm-timeline__client-mark_icon-wrapper">
				<svg :class="iconClassname" width="11.35" height="11.36" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path fill-rule="evenodd" clip-rule="evenodd" d="M14.8367 6.7166L11.2351 6.71731C11.1314 6.71731 11.0313 6.65735 10.9925 6.56213C10.8303 6.15654 10.8366 5.69947 11.0144 5.29671C11.3127 4.42841 11.3466 3.49029 11.1124 2.60224C10.8676 1.9914 10.8028 0.875521 9.67347 0.82403C9.32009 0.876226 9.01184 1.08854 8.8341 1.39819C8.80235 1.45321 8.78895 1.5181 8.78895 1.58088C8.78895 1.58088 8.84085 2.6644 8.78895 3.41764C8.73706 4.17087 7.29571 6.08954 6.37945 7.30769C6.32161 7.38528 6.24049 7.43607 6.14456 7.45088C5.80104 7.50232 5.14581 7.58943 4.90962 7.62062C4.85434 7.62792 4.82201 7.69735 4.82201 7.72994C4.82201 9.2527 4.82201 11.5306 4.82201 14.5636C4.82201 14.5887 4.85234 14.6435 4.90623 14.6524C5.09126 14.6829 5.55408 14.7676 6.02112 14.9178C6.60798 15.1061 7.0968 15.5519 8.07513 15.882C8.12662 15.8997 8.18375 15.9088 8.23807 15.9088H12.8321C13.4253 15.803 13.8668 15.2959 13.8972 14.6872C13.9056 14.3479 13.8379 14.0121 13.699 13.7039C13.6792 13.6594 13.7053 13.6129 13.7533 13.6037C14.3422 13.4965 15.0786 12.3785 14.1715 11.4778C14.1476 11.4545 14.1518 11.4228 14.1842 11.4143C14.6843 11.2866 15.0674 10.8874 15.1844 10.3894C15.2296 10.199 15.2134 10.0022 15.1569 9.81524C15.0906 9.59235 14.9848 9.38356 14.8445 9.19735C14.8092 9.15079 14.8289 9.09013 14.8854 9.07179C15.3834 8.90321 15.7262 8.4271 15.7226 7.88538C15.7798 7.35424 15.353 6.71731 14.8367 6.7166ZM3.412 7.00439H0.808518C0.673089 7.00439 0.570107 7.1243 0.593384 7.25479L2.10567 15.7508C2.12895 15.8813 2.24392 15.9766 2.37865 15.9766H3.34146C3.49029 15.9766 3.61091 15.8588 3.61091 15.7135L3.63207 7.22023C3.63207 7.10102 3.53403 7.00439 3.412 7.00439Z"/>
				</svg>
			</i>
			<span class="crm-timeline__client-mark_text">{{ text }}</span>
		</div>
	`
}
