(function(){"use strict";BX.namespace("BX.CRM.Kanban");BX.CRM.Kanban.Item=function(t){this.grid=null;this.container=null;this.timer=null;this.popupTooltip=null;this.plannerCurrent=null;this.fieldsWrapper=null;this.badgesWrapper=null;this.footerWrapper=null;this.clientName=null;this.clientNameItems=[];this.useAnimation=false;this.isAnimationInProgress=false;this.changedInPullRequest=false;this.notChangeTotal=false;this.itemActivityZeroClass="crm-kanban-item-activity-zero";this.activityAddingPopup=null;BX.Kanban.Item.apply(this,arguments)};BX.CRM.Kanban.Item.prototype={__proto__:BX.Kanban.Item.prototype,constructor:BX.CRM.Kanban.Item,lastPosition:{columnId:null,targetId:null},checked:false,setOptions(t){if(!t){return}BX.Kanban.Item.prototype.setOptions.call(this,t);this.useAnimation=BX.type.isBoolean(t.useAnimation)?t.useAnimation:false},setDataKey(t,e){const i=this.getData();i[t]=e;this.setData(i)},getDataKey(t){const e=this.getData();return e[t]},switchClass(t,e,i){if(i){BX.addClass(t,e)}else{BX.removeClass(t,e)}},switchVisible(t,e){if(e){BX.Dom.style(t,{display:""})}else{BX.Dom.style(t,{display:"none"})}},getLastPosition(){return this.lastPosition},setLastPosition(){const t=this.getColumn();const e=t.getNextItemSibling(this);this.lastPosition={columnId:t.getId(),targetId:e?e.getId():0}},getBodyContainer(){if(!this.layout.bodyContainer){this.layout.bodyContainer=BX.Tag.render`<div class="main-kanban-item-wrapper"></div>`}return this.layout.bodyContainer},render(){const t=this.getData();const e=t.special_type??null;if(e==="import"){return this.getPreparedStartLayout()}if(e==="rest"){return this.getPreparedIndustrySolutionsLayout()}if(!this.container){this.createLayout()}if(this.isLayoutFooterEveryRender()){this.layoutFooter()}this.setBorderColor();this.setLink();this.setPriceFormattedHtml();this.date.textContent=t.date;this.setClientName();if(this.planner){this.switchPlanner()}this.prepareContactTypeElements();this.appendLastActivity(t);if(this.needRenderFields()){this.fieldsWrapper.innerHTML=null;this.layoutFields()}this.layoutBadges();return this.container},getPreparedStartLayout(){const t=this.getStartLayout();this.emitOnSpecialItemDraw(t);this.grid.ccItem=this;BX.Dom.style(this.getBodyContainer(),{background:"none"});return t},getStartLayout(){this.getCloseStartLayout();const t=this.getGridData();const e=BX.Loc.getMessage("CRM_KANBAN_EMPTY_CARD_CT_TITLE");const i=BX.Loc.getMessage(`CRM_KANBAN_EMPTY_CARD_CT_TEXT${t.entityType}`);const n=t.rights.canImport?BX.Tag.render`
					<div>
						<div class="crm-kanban-item-contact-center-title crm-kanban-item-contact-center-title-import">
							${BX.Loc.getMessage("CRM_KANBAN_EMPTY_CARD_IMPORT")}
						</div>
					</div>
				`:null;return BX.Tag.render`
			<div class="crm-kanban-item-contact-center">
				<div class="crm-kanban-sidepanel" data-url="contact_center">
					${this.getCloseStartLayout()}
					<div class="crm-kanban-item-contact-center-title">
						<div class="crm-kanban-item-contact-center-title-item">${e}</div>
						<div class="crm-kanban-item-contact-center-title-item">${i}</div>
					</div>
					<div class="crm-kanban-item-contact-center-action">
						<div class="crm-kanban-item-contact-center-action-section">
							<a 
								href="#"
								data-url="ol_chat"
								class="crm-kanban-sidepanel crm-kanban-item-contact-center-action-item crm-kanban-item-contact-center-action-item-chat"
							>
								${BX.Loc.getMessage("CRM_KANBAN_EMPTY_CARD_CT_CHAT")}
							</a>
							<a 
								href="#"
								data-url="ol_forms"
								class="crm-kanban-sidepanel crm-kanban-item-contact-center-action-item crm-kanban-item-contact-center-action-item-crm-forms"
							>
								${BX.Loc.getMessage("CRM_KANBAN_EMPTY_CARD_CT_FORMS")}
							</a>
							<a 
								href="#"
								data-url="ol_viber"
								class="crm-kanban-sidepanel crm-kanban-item-contact-center-action-item crm-kanban-item-contact-center-action-item-viber"
							>
								Viber
							</a>
						</div>
						<div class="crm-kanban-item-contact-center-action-section">
							<a 
								href="#"
								data-url="telephony"
								class="crm-kanban-sidepanel crm-kanban-item-contact-center-action-item crm-kanban-item-contact-center-action-item-call"
							>
								${BX.Loc.getMessage("CRM_KANBAN_EMPTY_CARD_CT_PHONES")}
							</a>
							<a 
								href="#"
								data-url="email"
								class="crm-kanban-sidepanel crm-kanban-item-contact-center-action-item crm-kanban-item-contact-center-action-item-mail"
							>
								${BX.Loc.getMessage("CRM_KANBAN_EMPTY_CARD_CT_EMAIL")}
							</a>
							<a 
								href="#"
								data-url="ol_telegram"
								class="crm-kanban-sidepanel crm-kanban-item-contact-center-action-item crm-kanban-item-contact-center-action-item-telegram"
							>
								Telegram
							</a>
						</div>
					</div>
				</div>
				${n}
			</div>
		`},getPreparedIndustrySolutionsLayout(){const t=this.getIndustrySolutionsLayout();this.emitOnSpecialItemDraw(t);this.grid.restItem=this;return t},getIndustrySolutionsLayout(){const t=["CRM_KANBAN_REST_DEMO_FILE_IMPORT","CRM_KANBAN_REST_DEMO_FILE_EXPORT","CRM_KANBAN_REST_DEMO_CRM_MIGRATION","CRM_KANBAN_REST_DEMO_MARKET_2","CRM_KANBAN_REST_DEMO_PUBLICATION_2"];const e=document.createDocumentFragment();t.forEach(((t,i)=>{const n=`crm-kanban-item-industry-list-item crm-kanban-item-industry-list-item-${i+1}`;const a=BX.Loc.getMessage(t);const s=BX.Tag.render`
				<div class="${n}">
					<div class="crm-kanban-item-industry-list-item-img"></div>
					<div class="crm-kanban-item-industry-list-item-text">${a}</div>
				</div>
			`;BX.Dom.append(s,e)}));return BX.Tag.render`
			<div class="crm-kanban-item-industry">
				<div class="crm-kanban-item-industry-title">
					${BX.Loc.getMessage("CRM_KANBAN_REST_DEMO_MARKET_SECTOR")}
				</div>
				<div class="crm-kanban-item-industry-list">
					${e}
				</div>
				<span class="ui-btn ui-btn-sm ui-btn-primary ui-btn-round crm-kanban-sidepanel" data-url="rest_demo">
					${BX.Loc.getMessage("CRM_KANBAN_REST_DEMO_SETUP")}
				</span>
				<div class="crm-kanban-item-industry-close" onclick="${this.onIndustryCloseButtonClick.bind(this)}"></div>
			</div>
		`},onIndustryCloseButtonClick(t){t.stopPropagation(t);this.getGrid().toggleRest();this.getGrid().registerAnalyticsSpecialItemCloseEvent(this,BX.Crm.Integration.Analytics.Dictionary.SUB_SECTION_KANBAN,BX.Crm.Integration.Analytics.Dictionary.ELEMENT_CLOSE_BUTTON,BX.Crm.Integration.Analytics.Dictionary.TYPE_ITEM_INDUSTRY)},emitOnSpecialItemDraw(t){BX.onCustomEvent("Crm.Kanban.Grid:onSpecialItemDraw",[this,t])},setBorderColor(){const t=this.getColumn().getColor();const e=BX.util.hex2rgb(t);const i=`rgba(${e.r},${e.g},${e.b},.7)`;BX.Dom.style(this.container,{"--crm-kanban-item-color":i})},setLink(){const t=this.getData();let e=this.clipTitle(t.name);if(t.isAutomationDebugItem){const t=BX.Loc.getMessage("CRM_KANBAN_ITEM_DEBUG_TITLE_MSGVER_1");e=`<span class="crm-kanban-debug-item-label">${t}</span> ${e}`}this.link.innerHTML=e;BX.Dom.attr(this.link,{href:t.link})},setPriceFormattedHtml(){const t=this.getData();if(this.totalPrice){this.totalPrice.innerHTML=t.price_formatted}},clipTitle(t){const e=" ";const i=t.split(e);const n=i.length-1;const a=`<span>${i[n]}</span>`;i.splice(n);return`${i.join(e)}${e}${a}`},setClientName(){const t=this.getData();const e=this.getGridData();this.clientNameItems=[];if(t.contactId&&t.contactName&&e.customFields.includes("CLIENT")){this.clientNameItems.push(t.contactTooltip)}if(t.companyId&&t.companyName&&e.customFields.includes("CLIENT")){this.clientNameItems.push(t.companyTooltip)}if(BX.Type.isArrayFilled(this.clientNameItems)){this.clientName.innerHTML=this.clientNameItems.join("<br>");this.switchVisible(this.clientName,true)}else{this.switchVisible(this.clientName,false)}},prepareContactTypeElements(){const t=this.getData();const e=["Phone","Email","Im"];e.forEach((e=>{const i=`contact${e}`;BX.Event.unbindAll(this[i]);const n=`crm-kanban-item-contact-${e.toLowerCase()}-disabled`;if(t[e.toLowerCase()]){BX.Event.bind(this[i],"click",(t=>{this.clickContact(e.toLowerCase(),t.target)}));this.switchClass(this[i],n,false);return}BX.Event.bind(this[i],"mouseover",(({target:t})=>{const e=BX.Dom.attr(t,"data-type");this.showTooltip(BX.Loc.getMessage(`CRM_KANBAN_NO_${e.toUpperCase()}`),t)}));BX.Event.bind(this[i],"mouseout",this.hideTooltip.bind(this));this.switchClass(this[i],n,true)}))},appendLastActivity(t){BX.Dom.clean(this.lastActivityTime);BX.Dom.clean(this.lastActivityBy);const e=t.lastActivity;if(!BX.Type.isPlainObject(e)||!BX.CRM.Kanban.Restriction.Instance.isLastActivityInfoInKanbanItemAvailable()){return}this.appendLastActivityTime(e);this.appendLastActivityUser(e)},appendLastActivityTime(t){const e=BX.Text.toInteger(t.timestamp);if(e<=0){return}const i=e-BX.Main.Timezone.Offset.USER_TO_SERVER;const n=BX.Main.Timezone.UserTime.getDate(i);const a=BX.Main.Timezone.UserTime.getDate();const s=(a.getTime()-n.getTime())/1e3;const r=s<=60?BX.Text.encode(BX.Loc.getMessage("CRM_KANBAN_JUST_NOW")):this.getFormattedLastActiveDateTime(n,a);const o=BX.Tag.render`
			<span class="crm-kanban-item-last-activity-time-ago">${r}</span>
		`;BX.Dom.append(o,this.lastActivityTime)},appendLastActivityUser(t){const e=t.user;if(!BX.Type.isPlainObject(e)){return}let i="";if(BX.Type.isStringFilled(e.picture)){const t=new BX.Uri(e.picture);const n=encodeURI(BX.Text.encode(t.toString()));i=`style="background-image: url(${n})"`}const n=BX.Type.isStringFilled(e.link)&&e.link.startsWith("/");const a=n?e.link:"#";const s=BX.Tag.render`
			<a
				class="crm-kanban-item-last-activity-by-userpic"
				href="${BX.Text.encode(a)}"
			 	bx-tooltip-user-id="${BX.Text.toInteger(e.id)}"
				${i}
			></a>
		`;BX.Dom.append(s,this.lastActivityBy)},getFormattedLastActiveDateTime(t,e){const i=t.getFullYear()===(new Date).getFullYear();const n=i?BX.Main.DateTimeFormat.getFormat("DAY_SHORT_MONTH_FORMAT"):BX.Main.DateTimeFormat.getFormat("MEDIUM_DATE_FORMAT");let a=BX.Main.DateTimeFormat.getFormat("SHORT_TIME_FORMAT");a=a.replace(/\b(a)\b/,"A");const s=BX.Main.DateTimeFormat.format([["i","idiff"],["yesterday",`yesterday, ${a}`],["today",`today ${a}`],["-",n]],t,e);return s.replaceAll("\\","").replaceAll(/(^|\s)(.)/g,(t=>t.toLocaleUpperCase()))},needRenderFields(){const t=Boolean(this.fieldsWrapper);const e=Boolean(this.getData().fields);return Boolean(t&&e)},getItemFields(){if(!this.fieldsWrapper){this.fieldsWrapper=BX.create("div",{props:{className:"crm-kanban-item-fields"}});if(this.getGrid().getTypeInfoParam("useRequiredVisibleFields")){this.switchVisible(this.link,true);this.switchVisible(this.date,true);this.switchVisible(this.clientName,true);if(this.total){this.switchVisible(this.total,true)}return this.fieldsWrapper}this.layoutFields()}return this.fieldsWrapper},layoutFields(){if(!this.fieldsWrapper){return}this.data.fields.forEach((t=>{this.layoutField(t)}))},layoutField(t){const e=t.code;if(e==="TITLE"){this.switchVisible(this.link,true);return}if(e==="DATE_CREATE"){this.switchVisible(this.date,true);return}if(e==="CLIENT"){this.switchVisible(this.clientName,true);return}if(e==="OPPORTUNITY"||e==="PRICE"){if(this.total){this.switchVisible(this.total,true)}return}let i=null;if(BX.Type.isObject(t.icon)&&BX.Type.isArrayFilled(t.icon.url)){i=BX.Tag.render`
				<div class="crm-kanban-item-fields-item-title-icon">
					<img src="${t.icon.url}" title="${t.icon.title??""}" alt="">
				</div>
			`}const n=BX.Tag.render`<div class="crm-kanban-item-fields-item-title-text"></div>`;n.innerHTML=t.title;const a=BX.Dom.create("div",this.getFieldParams(t));const s=BX.Tag.render`
			<div class="crm-kanban-item-fields-item">
				<div class="crm-kanban-item-fields-item-title">
					${i}
					${n}
				</div>
				${a}
			</div>
		`;BX.Dom.append(s,this.fieldsWrapper)},getFieldParams(t){const e=t.type??"string";let i={props:{className:"crm-kanban-item-fields-item-value"}};if(e==="user"){i={...i,...this.getUserTypeFieldParams(t)}}else if(t.type==="money"||t.html===true){const e=t.valueDelimiter??"<br>";i.html=BX.Type.isArray(t.value)?t.value.join(e):t.value;if(i.html.includes("<b>")){i.props.className=`${i.props.className} --normal-weight`}}else{i.text=BX.Type.isArray(t.value)?t.value.join(", "):t.value}return i},getUserTypeFieldParams(t){const e={};if(t.html!==true){e.text=this.getMessage("noname");return e}if(BX.Type.isPlainObject(t.value)){let i="";let n="";if(t.value.link===""){i='<span class="crm-kanban-item-fields-item-value-userpic"></span>';n=`<span class="crm-kanban-item-fields-item-value-name">${t.value.title}</span>`}else{let e="";if(t.value.picture){e=` style="background-image: url(${encodeURI(t.value.picture)})"`}i=`<a class="crm-kanban-item-fields-item-value-userpic" href="${t.value.link}"${e}></a>`;n=`<a class="crm-kanban-item-fields-item-value-name" href="${t.value.link}">${t.value.title}</a>`}e.html=`\n\t\t\t\t<div class="crm-kanban-item-fields-item-value-user">\n\t\t\t\t\t${i}\n\t\t\t\t\t${n}\n\t\t\t\t</div>\n\t\t\t`}else{e.html=BX.Type.isArray(t.value)?t.value.join(", "):t.value}return e},layoutBadges(){BX.Dom.clean(this.badgesWrapper);for(let t=0;t<this.data.badges.length;t++){const e=this.data.badges[t];const i="crm-kanban-item-badges-item-value crm-kanban-item-badges-status";const n=`\n\t\t\t\tbackground-color: ${e.backgroundColor};\n\t\t\t\tborder-color: ${e.backgroundColor};\n\t\t\t\tcolor: ${e.textColor};\n\t\t\t`;const a=BX.Tag.render`
				<div class="crm-kanban-item-badges-item">
					<div class="crm-kanban-item-badges-item-title">
						<div class="crm-kanban-item-badges-item-title-text">${e.fieldName}</div>
					</div>
					<div class="${i}" style="${n}">${e.textValue}</div>
				</div>
			`;BX.Dom.append(a,this.badgesWrapper)}},layoutFooter(){BX.Dom.clean(this.footerWrapper);const t=[{id:"planner",node:this.createPlanner()},{id:"activityBlock",node:this.createLastActivityBlock()}];const e={elements:t,item:this};BX.Event.EventEmitter.emit("BX.Crm.Kanban.Item::onBeforeFooterCreate",e);e.elements.forEach((t=>{BX.Dom.append(t.node,this.footerWrapper)}))},getCloseStartLayout(){return BX.create("div",{props:{className:"crm-kanban-item-contact-center-close"},events:{click:function(t){this.grid.toggleCC();t.stopPropagation(t)}.bind(this)}})},selectItem(){this.checked=true;BX.addClass(this.checkedButton,"crm-kanban-item-checkbox-checked");BX.addClass(this.container,"crm-kanban-item-selected")},unSelectItem(){this.checked=false;BX.removeClass(this.checkedButton,"crm-kanban-item-checkbox-checked");BX.removeClass(this.container,"crm-kanban-item-selected")},createLayout(){const t=this.createContainer();const e=[this.createTitleLink(),this.createLine(),this.createRepeated(),this.createTotalPrice(),this.createClientName(),this.createDate(),this.createCheckedButton(),this.hasFields()?this.getItemFields():null,this.createBadgesWrapper(),this.createAside(),this.createFooterWrapper(),this.createShadow()];if(!this.isLayoutFooterEveryRender()){this.layoutFooter()}e.forEach((e=>{BX.Dom.append(e,t)}))},isLayoutFooterEveryRender(){return Boolean(this.getPerformanceSettings().layoutFooterEveryItemRender==="Y")},getPerformanceSettings(){return this.getGrid().getData().performance},createContainer(){let t=this.getGrid().getTypeInfoParam("kanbanItemClassName");if(this.useAnimation){t+=` ${t}-new`}this.container=BX.Tag.render`
			<div
				class="${t}"
				onclick="${this.onContainerClick.bind(this)}"
				ondblclick="${this.onContainerDblClick.bind(this)}"
				onmouseleave="${this.onContainerMouseLeave.bind(this)}"
			></div>
		`;BX.Event.bind(this.container,"animationend",(()=>{BX.Dom.removeClass(this.layout.container,"main-kanban-item-new")}));return this.container},onContainerClick(t){const e=t.target;const i=this.container.className.replace(" ",".");const n=e.closest(`.${i}`);if(e!==this.container&&!n||n&&e.tagName==="A"||n&&e.tagName==="SPAN"&&!BX.Dom.hasClass(e,"crm-kanban-item-contact")){return}const a=this.getGrid();if(this.checked){a.unCheckItem(this);if(!BX.Type.isArrayFilled(a.getChecked())){a.resetMultiSelectMode();a.stopActionPanel()}}else{a.checkItem(this);a.onMultiSelectMode();a.startActionPanel()}a.calculateTotalCheckItems()},onContainerDblClick(){this.link.click()},onContainerMouseLeave(){this.removeHoverClass(this.container)},createTitleLink(){this.link=BX.Tag.render`<a class="crm-kanban-item-title" style="${this.getBlockStyleBasedOnFields()}"></a>`;return this.link},createLine(){return BX.Tag.render`<div class="crm-kanban-item-line"></div>`},createRepeated(){const t=this.options.data;if(!t.return&&!t.returnApproach){return null}const e=this.getGridData().entityType;const i=t.returnApproach?BX.Loc.getMessage(`CRM_KANBAN_REPEATED_APPROACH_${e}`):BX.Loc.getMessage(`CRM_KANBAN_REPEATED_${e}`);return BX.Tag.render`<div class="crm-kanban-item-repeated">${i}</div>`},createTotalPrice(){this.totalPrice=BX.Tag.render`<div class="crm-kanban-item-total-price"></div>`;this.total=BX.Tag.render`
			<div class="crm-kanban-item-total" style="${this.getBlockStyleBasedOnFields()}">${this.totalPrice}</div>
		`;return this.total},createClientName(){this.clientName=BX.Tag.render`<span class="crm-kanban-item-contact"></span>`;return this.clientName},createDate(){this.date=BX.Tag.render`
			<div class="crm-kanban-item-date" style="${this.getBlockStyleBasedOnFields()}"></div>
		`;return this.date},getBlockStyleBasedOnFields(){return this.hasFields()?"display: none":""},hasFields(){return BX.Type.isArrayFilled(this.data.fields)},createCheckedButton(){this.checkedButton=BX.Tag.render`
			<div class="crm-kanban-item-checkbox" onclick="${this.onCheckedButtonClick.bind(this)}"></div>
		`;return this.checkedButton},onCheckedButtonClick(){this.checked=!this.checked;const t="crm-kanban-item-checkbox-checked";if(this.checked){BX.Dom.addClass(this.checkedButton,t)}else{BX.Dom.removeClass(this.checkedButton,t)}},createBadgesWrapper(){this.badgesWrapper=BX.Tag.render`<div class="crm-kanban-item-badges"></div>`;return this.badgesWrapper},createAside(){const t=this.isActivityLimitIsExceeded()?BX.Tag.render`<span class="crm-kanban-item-activity">${this.getActivityCounterHtml()}</span>`:null;const e=[{id:"limitExceededIcon",node:t}];if(this.isShowActivity()){this.activityExist=BX.Tag.render`
				<span class="crm-kanban-item-activity" onclick="${this.showCurrentPlan.bind(this)}"></span>
			`;e.push({id:"activityExist",node:this.activityExist});this.activityEmpty=BX.Tag.render`
				<span class="crm-kanban-item-activity" onclick="${this.onActivityEmptyClick.bind(this)}"></span>
			`;e.push({id:"activityEmpty",node:this.activityEmpty})}this.contactPhone=this.createContactItemNode("phone");e.push({id:"contactPhone",node:this.contactPhone});this.contactEmail=this.createContactItemNode("email");e.push({id:"contactEmail",node:this.contactEmail});this.contactIm=this.createContactItemNode("im");e.push({id:"contactIm",node:this.contactIm});const i={elements:e,item:this};BX.Event.EventEmitter.emit("BX.Crm.Kanban.Item::onBeforeAsideCreate",i);const n=BX.Tag.render`<div class="crm-kanban-item-aside"></div>`;i.elements.forEach((t=>{BX.Dom.append(t.node,n)}));return n},createContactItemNode(t){return BX.Tag.render`
			<span
				class="crm-kanban-item-contact-${t} crm-kanban-item-contact-${t}-disabled"
				data-type="${t}"
			></span>
		`},onActivityEmptyClick(t){const e=this.getActivityMessage(this.getGridData().entityType);this.showTooltip(e,t.target,true)},createFooterWrapper(){this.footerWrapper=BX.Tag.render`<div class="crm-kanban-item-footer"></div>`;return this.footerWrapper},createPlanner(){if(!this.isShowActivity()){return null}this.activityPlan=BX.Tag.render`
			<span class="crm-kanban-item-plan" onclick="${this.showPlannerMenu.bind(this)}">
				+ ${BX.Loc.getMessage("CRM_KANBAN_ACTIVITY_TO_PLAN2")}
			</span>
		`;this.planner=BX.Tag.render`<div class="crm-kanban-item-planner">${this.activityPlan}</div>`;return this.planner},isShowActivity(){return this.getGridData().showActivity},createLastActivityBlock(){this.lastActivityTime=BX.Tag.render`<div class="crm-kanban-item-last-activity-time"></div>`;this.lastActivityBy=BX.Tag.render`<div class="crm-kanban-item-last-activity-by"></div>`;this.lastActivityBlock=BX.Tag.render`
			<div class="crm-kanban-item-last-activity">${this.lastActivityTime}${this.lastActivityBy}</div>
		`;return this.lastActivityBlock},isChecked(){return this.checked},isHiddenPrice(){return this.getColumn()?.isHiddenTotalSum()},getActivityMessage(t){const e=BX.create("span");const i=/DYNAMIC_(\d+)/.test(t)?"DYNAMIC":t;e.innerHTML=BX.Loc.getMessage(`CRM_KANBAN_ACTIVITY_CHANGE_${i}_MSGVER_1`)||BX.Loc.getMessage(`CRM_KANBAN_ACTIVITY_CHANGE_${i}_MSGVER_2`);const n=e.querySelector(".crm-kanban-item-activity-link");BX.bind(n,"click",(()=>{this.showPlannerMenu(this.activityPlan);this.popupTooltip.destroy()}));return e},getPreloader(){return'\t\t\t<div class="crm-kanban-preloader-wrapper">\n\t\t\t\t<div class="crm-kanban-preloader">\n\t\t\t\t\t<svg class="crm-kanban-circular" viewBox="25 25 50 50">\n\t\t\t\t\t\t<circle class="crm-kanban-path" cx="50" cy="50" r="20" fill="none" stroke-width="1" stroke-miterlimit="10"/>\n\t\t\t\t\t</svg>\n\t\t\t\t</div>\n\t\t\t</div>\t\t'},loadCurrentPlan(){this.getGrid().ajax({action:"activities",entity_id:this.getId()},(t=>{this.plannerCurrent.setContent(t);this.plannerCurrent.adjustPosition()}),(t=>{BX.Kanban.Utils.showErrorDialog(`Error: ${t}`,true)}),"html")},showCurrentPlan(t){this.plannerCurrent=BX.PopupWindowManager.create("kanban_planner_current",t.target,{closeIcon:false,autoHide:true,className:"crm-kanban-popup-plan",closeByEsc:true,contentColor:"white",angle:true,offsetLeft:15,overlay:{backgroundColor:"transparent",opacity:"0"},events:{onAfterPopupShow:this.loadCurrentPlan.bind(this),onPopupClose:()=>{this.plannerCurrent.destroy();BX.removeClass(this.container,"crm-kanban-item-hover");BX.Event.unbind(window,"scroll",this.adjustPopup)}}});this.plannerCurrent.setContent(this.getPreloader());this.plannerCurrent.show();BX.Event.bind(window,"scroll",this.adjustPopup.bind(this))},clickContact(t,e){const i=this.getContactInfo(t);let n=0;if(BX.Type.isObject(i)){if(BX.Type.isArray(i)){n=i.length}else{n=Object.values(i).reduce(((t,e)=>t+(BX.Type.isArray(e)?e.length:0)),0)}}if(n>1){this.showManyContacts(i,t,e)}else{this.showSingleContact(i,t)}},clickContactItem(t){const e=this.getData();if(t.type==="phone"&&!BX.Type.isUndefined(BXIM)){BXIM.phoneTo(t.value,{ENTITY_TYPE:t.clientType===undefined?e.contactType:t.clientType,ENTITY_ID:t.clientId===undefined?e.contactId:t.clientId})}else if(t.type==="im"&&!BX.Type.isUndefined(BXIM)){BXIM.openMessengerSlider(t.value,{RECENT:"N",MENU:"N"})}else if(t.type==="email"){const i=BX.CrmActivityEditor&&BX.CrmActivityEditor.items.kanban_activity_editor;const n=top.BX.SidePanel&&top.BX.SidePanel.Instance;if(i&&BX.CrmActivityProvider&&n){const i=this.getGridData();BX.CrmActivityEditor.items.kanban_activity_editor.addEmail({ownerType:i.entityType,ownerID:e.id,communications:[{type:"EMAIL",value:t.value,entityId:e.id,entityType:i.entityType,entityTitle:e.name}],communicationsLoaded:true})}else{top.location.href=`mailto:${t.value}`}}},showManyContacts(t,e,i){const n=[];if(Array.isArray(t)){t={0:t}}Object.keys(t).forEach((i=>{if(i==="company"||i==="contact"){n.push({delimiter:true,text:this.getMessage(i)})}const a=t[i];a.forEach((t=>{let a="";let s="";const r=this.getData();if(i==="company"){a="CRM_COMPANY";s=r.companyId}else if(i==="contact"){a="CRM_CONTACT";s=r.contactId}n.push({value:t.value,type:e,clientType:a,clientId:s,text:`${t.value} (${t.title})`,onclick:this.clickContactItem.bind(this,{value:t.value,type:e})})}))}));const a=new BX.Main.Menu(`kanban_contact_menu_${e}${this.getId()}`,i,n,{autoHide:true,zIndex:1200,offsetLeft:20,angle:true,closeByEsc:true,events:{onPopupClose:()=>{BX.Dom.removeClass(this.container,"crm-kanban-item-hover");BX.unbind(window,"scroll",BX.proxy(this.adjustPopup,this))}}});a.show();BX.bind(window,"scroll",BX.proxy(this.adjustPopup,this))},showSingleContact(t,e){let i=this.getSingleContactCategory(t);if(!Array.isArray(i)){i=[i]}this.clickContactItem({value:BX.Type.isUndefined(i[0].value)?i[0]:i[0].value,type:e})},getSingleContactCategory(t){return BX.Type.isObjectLike(t)?t[Object.keys(t)[0]]:t},getMessage(t){return BX.CRM.Kanban.Item.messages[t]||""},selectPlannerMenu(t,e){BX.onCustomEvent("Crm.Kanban:selectPlannerMenu");const i=this.getGridData();switch(e.type){case"meeting":case"call":{(new BX.Crm.Activity.Planner).showEdit({TYPE_ID:BX.CrmActivityType[e.type],OWNER_TYPE:i.entityType,OWNER_ID:this.getId()});break}case"task":{const t={UF_CRM_TASK:[`${BX.CrmOwnerTypeAbbr.resolve(i.entityType)}_${this.getId()}`],TITLE:"CRM: ",TAGS:"crm"};let e=BX.Loc.getMessage("CRM_TASK_CREATION_PATH");e=e.replace("#user_id#",BX.Loc.getMessage("USER_ID"));e=BX.util.add_url_param(e,t);if(BX.SidePanel){BX.SidePanel.Instance.open(e)}else{window.top.location.href=e}break}case"visit":{const t=i.visitParams;t.OWNER_TYPE=i.entityType;t.OWNER_ID=this.getId();BX.CrmActivityVisit.create(t).showEdit();break}default:}const n=BX.PopupMenu.getCurrentMenu();if(n){n.close()}},getPlannerMenu(){const t=this.getGrid().getData();return[{type:"call",text:BX.Loc.getMessage("CRM_KANBAN_ACTIVITY_PLAN_CALL"),onclick:BX.delegate(this.selectPlannerMenu,this)},{type:"meeting",text:BX.Loc.getMessage("CRM_KANBAN_ACTIVITY_PLAN_MEETING"),onclick:BX.delegate(this.selectPlannerMenu,this)},t.rights.canUseVisit?BX.getClass("BX.Crm.Restriction.Bitrix24")&&BX.Crm.Restriction.Bitrix24.isRestricted("visit")?{type:"visit",text:BX.Loc.getMessage("CRM_KANBAN_ACTIVITY_PLAN_VISIT"),className:"crm-tariff-lock-behind",onclick:BX.Crm.Restriction.Bitrix24.getHandler("visit")}:{type:"visit",text:BX.Loc.getMessage("CRM_KANBAN_ACTIVITY_PLAN_VISIT"),onclick:BX.delegate(this.selectPlannerMenu,this)}:null,{type:"task",text:BX.Loc.getMessage("CRM_KANBAN_ACTIVITY_PLAN_TASK"),onclick:BX.delegate(this.selectPlannerMenu,this)}]},showPlannerMenu(t,e=BX.Crm.Activity.TodoEditorMode.ADD,i=false){if(BX.CRM.Kanban.Restriction.Instance.isTodoActivityCreateAvailable()){this.prepareAndShowActivityAddingPopup(t,e,i)}else if(e===BX.Crm.Activity.TodoEditorMode.ADD){this.prepareAndShowPlannerPopup(t)}},prepareAndShowActivityAddingPopup(t,e,i){const n=this.getId();if(i){this.disabledItem()}const a=this.getData();const s=this.getGridData();const r=a.pingSettings||s.pingSettings;const o=a.colorSettings||s.colorSettings;const c=a.calendarSettings||s.calendarSettings;const l={pingSettings:r,colorSettings:o,calendarSettings:c};const d={context:this.getToDoEditorContext(),events:{onSave:()=>{void this.animate({duration:this.grid.animationDuration,draw:t=>{BX.Dom.style(this.layout.container,"opacity",`${100-t*50}%`)},useAnimation:BX.Dom.style(this.layout.container,"opacity")==="1"}).then((()=>{void this.animate({duration:this.grid.animationDuration,draw:t=>{BX.Dom.style(this.layout.container,"opacity",`${t*100}%`)},useAnimation:true})}))}}};if(!this.activityAddingPopup){this.activityAddingPopup=new BX.Crm.Activity.AddingPopup(this.getGridData().entityTypeInt,n,this.getCurrentUser(),l,d)}this.activityAddingPopup.show(e);if(i){this.unDisabledItem()}},getToDoEditorContext(){return{analytics:this.grid.getData().analytics}},prepareAndShowPlannerPopup(t){const e=this.getId();const i=`kanban_planner_menu_${e}`;const n=t.isNode?t:this.activityPlan;const a=new BX.Main.Menu(i,n,this.getPlannerMenu(),{className:"crm-kanban-planner-popup-window",autoHide:true,offsetLeft:50,angle:true,overlay:{backgroundColor:"transparent",opacity:"0"},events:{onPopupClose:()=>{BX.Dom.removeClass(this.container,"crm-kanban-item-hover");BX.Event.unbind(window,"scroll",this.adjustPopup);a.destroy()}}});BX.addCustomEvent(window,"Crm.Kanban:selectPlannerMenu",(()=>{a.destroy()}));a.show();BX.Event.bind(window,"scroll",this.adjustPopup.bind(this))},switchPlanner(){const t=this.getData();const e=this.getColumn();const i=e.getData();if(t.activityProgress>0){this.switchVisible(this.activityExist,true);this.switchVisible(this.activityEmpty,false);this.setActivityExistInnerHtml()}else{const e=this.getGrid().getData();this.switchVisible(this.activityExist,false);this.switchVisible(this.activityPlan,true);this.switchVisible(this.activityEmpty,true);let n="";if(e.reckonActivitylessItems&&e.userId===parseInt(t.assignedBy,10)){n=i.type==="PROGRESS"?this.getActivityCounterHtml(1):""}else{n=this.getActivityCounterHtml(0);BX.Dom.addClass(this.activityEmpty,this.itemActivityZeroClass)}this.activityEmpty.innerHTML=n}},setActivityExistInnerHtml(){if(BX.Type.isUndefined(this.activityExist)){return}BX.Dom.removeClass(this.activityExist,...this.activityExist.classList);BX.Dom.addClass(this.activityExist,"crm-kanban-item-activity");const t=this.getGrid().getData();const e=t.showErrorCounterByActivityResponsible||false;const i=this.getData();const n=t.userId;const a=e?this.makeCounterHtmlByActivityResponsible(i,n):this.makeCounterHtmlByEntityResponsible(i,n);if(BX.Type.isStringFilled(a)){this.activityExist.innerHTML=a}},makeCounterHtmlByActivityResponsible(t,e){let i="";const n=t.activitiesByUser[e]||{};const a=n.activityError||0;const s=n.incoming||0;const r=n.activityProgress||0;const o=n.activityCounterTotal||0;if(s>0&&a>0){i=this.getActivityCounterHtml(o,"crm-kanban-item-activity-all-counters")}else if(a>0){i=this.getActivityCounterHtml(a,"crm-kanban-item-activity-deadline-counter")}else if(s>0){i=this.getActivityCounterHtml(s,"crm-kanban-item-activity-incoming-counter")}else if(r>0){i=this.getActivityCounterHtml(0);BX.Dom.addClass(this.activityExist,this.itemActivityZeroClass);i+='<span class="crm-kanban-item-activity-indicator"></span>'}else{if(t.activityCounterTotal>0){i=this.getActivityCounterHtml(t.activityCounterTotal)}else{i=this.getActivityCounterHtml(0);i+='<span class="crm-kanban-item-activity-indicator crm-kanban-item-activity-indicator--grey"></span>'}BX.Dom.addClass(this.activityExist,this.itemActivityZeroClass)}return i},makeCounterHtmlByEntityResponsible(t,e){let i="";const n=e===BX.prop.getNumber(this.data,"assignedBy",0);const a=t.activityProgress||0;const s=t.activityError||0;const r=t.activityIncomingTotal||0;const o=t.activityCounterTotal||0;if(n){if(r>0&&s>0){i=this.getActivityCounterHtml(o,"crm-kanban-item-activity-all-counters")}else if(s>0){i=this.getActivityCounterHtml(s,"crm-kanban-item-activity-deadline-counter")}else if(r>0){i=this.getActivityCounterHtml(r,"crm-kanban-item-activity-incoming-counter")}else if(a>0){i=this.getActivityCounterHtml(0);BX.Dom.addClass(this.activityExist,this.itemActivityZeroClass);i+='<span class="crm-kanban-item-activity-indicator"></span>'}else{i=this.getActivityCounterHtml(0);BX.Dom.addClass(this.activityExist,this.itemActivityZeroClass)}return i}if(o>0){i=this.getActivityCounterHtml(t.activityCounterTotal)}else if(a>0){i=this.getActivityCounterHtml(0);i+='<span class="crm-kanban-item-activity-indicator crm-kanban-item-activity-indicator--grey"></span>'}else{i=this.getActivityCounterHtml(0)}BX.Dom.addClass(this.activityExist,this.itemActivityZeroClass);return i},getActivityCounterHtml(t,e=""){let i=null;let n=null;let a=null;if(this.isActivityLimitIsExceeded()){n="?";a=`${e} crm-kanban-item-activity-counter--limit-exceeded`;i=`title="${BX.Loc.getMessage("CRM_KANBAN_ITEM_COUNTER_LIMIT_IS_EXCEEDED")}"`}else if(t>99){n="99+";a=`${e} crm-kanban-item-activity-counter--narrow`}else{n=String(t);a=String(e)}return`\n\t\t\t<span class="crm-kanban-item-activity-counter ${a}" ${i}>\n\t\t\t\t<span class="item-activity-counter__before"></span>\n\t\t\t\t${n}\n\t\t\t\t<span class="item-activity-counter__after"></span>\n\t\t\t</span>\n\t\t`},isActivityLimitIsExceeded(){return this.getGridData().isActivityLimitIsExceeded},showTooltip(t,e,i){const n={background:"black",opacity:0};const a=i?n:null;const s=`crm-kanban-without-tooltip ${i?"crm-kanban-without-tooltip-white":"crm-kanban-tooltip-animate"}`;this.popupTooltip=BX.PopupWindowManager.create("kanban_tooltip",e,{className:s,content:t,overlay:a,offsetLeft:14,darkMode:!i,closeByEsc:true,angle:true,autoHide:true,events:{onPopupClose:()=>{BX.Event.unbind(window,"scroll",this.adjustPopup.bind(this))}}});this.popupTooltip.show();BX.Event.bind(window,"scroll",this.adjustPopup.bind(this))},hideTooltip(){this.popupTooltip.destroy()},createShadow(){return BX.Tag.render`<div class="crm-kanban-item-shadow"></div>`},removeHoverClass(t){BX.Dom.removeClass(t,"crm-kanban-item-event");BX.Dom.removeClass(t,"crm-kanban-item-hover")},adjustPopup(){const t=BX.PopupWindowManager.getCurrentPopup();if(t&&t.isShown()){t.adjustPosition()}},onDragDrop(t){this.dropChangedInPullRequest();this.hideDragTarget();const e=this.getGrid().getItemByElement(t);e.dropChangedInPullRequest();const i=new BX.Kanban.DragEvent;i.setItem(e);i.setTargetColumn(this.getColumn());i.setTargetItem(this);BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onBeforeItemMoved",[i]);if(!i.isActionAllowed()){return}void this.getGrid().moveItem(e,this.getColumn(),this,true).then((t=>{if(t&&t.status){BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onItemMoved",[e,this.getColumn(),this])}if(e.getColumn().getId()===this.getColumn().getId()){this.getGrid().resetMultiSelectMode();this.getGrid().cleanSelectedItems()}}))},onDragStart(){if(this.dragElement){return}if(!this.checked||this.grid.getChecked().length===1){this.grid.resetMultiSelectMode()}if(this.grid.getChecked().length>1){const t=this.grid.getChecked().reverse();this.dragElement=BX.create("div",{props:{className:"main-kanban-item-drag-multi"}});for(let e=0;e<t.length;e++){BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onItemDragStart",[t[e]]);const i=t[e].getContainer().cloneNode(true);BX.Dom.style(i,"width",`${t[e].getContainer().offsetWidth}px`);this.getContainer().maxHeight=`${t[0].getContainer().offsetHeight}px`;BX.Dom.append(i,this.dragElement)}for(const e of t){BX.Dom.addClass(e.getContainer(),"main-kanban-item-disabled")}BX.Dom.append(this.dragElement,document.body);return}BX.onCustomEvent(this.getGrid(),"Kanban.Grid:onItemDragStart",[this]);const t=this.getContainer();BX.Dom.addClass(t,"main-kanban-item-disabled");this.dragElement=t.cloneNode(true);BX.Dom.style(this.dragElement,{position:"absolute",width:`${this.getBodyContainer().offsetWidth}px`});BX.Dom.addClass(this.dragElement,"main-kanban-item main-kanban-item-drag");BX.Dom.append(this.dragElement,document.body)},makeDroppable(){if(!this.isDroppable()){return}const t=this.getContainer();t.onbxdestdraghover=BX.delegate(this.onDragEnter,this);t.onbxdestdraghout=BX.delegate(this.onDragLeave,this);t.onbxdestdragfinish=BX.delegate(this.onDragDrop,this);t.onbxdestdragstop=BX.delegate(this.onItemDragEnd,this);jsDD.registerDest(t,5);if(this.getGrid().getDragMode()!==BX.Kanban.DragMode.ITEM){this.disableDropping()}},getContactInfo(t){const e=this.getData();return e[t]},getStageId(){return this.getData().stageId},animate(t){const e=t.duration;const i=t.draw;const n=t.timing||function(t){return t};const a=t.useAnimation&&!this.isAnimationInProgress||false;const s=performance.now();return new Promise((t=>{if(!a){this.isAnimationInProgress=false;t();return}const r=this;r.isAnimationInProgress=true;requestAnimationFrame((function a(o){let c=(o-s)/e;if(c>1){c=1}const l=n(c);i(l);if(c<1){requestAnimationFrame(a)}if(l===1){r.isAnimationInProgress=false;t()}}))}))},setChangedInPullRequest(){this.changedInPullRequest=true},dropChangedInPullRequest(){this.changedInPullRequest=false},isChangedInPullRequest(){return this.changedInPullRequest===true},isItemMoveDisabled(){const t=this.getGrid();if(!t.options.canChangeItemStage){return true}if(t.getData().viewMode===BX.Crm.Kanban.ViewMode.MODE_ACTIVITIES&&this.getData().activityIncomingTotal>0){return true}const e=this.getColumn().getData();return t.getTypeInfoParam("disableMoveToWin")&&e.type==="WIN"},getCurrentUser(){const t=this.getGrid().getData().userId;const e=this.getGridData().currentUser;if(BX.type.isObject(e)&&t>0){e.userId=t}return e},getGrid(){return BX.Kanban.Item.prototype.getGrid.call(this)},getData(){return BX.Kanban.Item.prototype.getData.call(this)}}})();
//# sourceMappingURL=item.map.js