
CREATE TABLE b_crm_lead (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_CREATE timestamp,
  DATE_MODIFY timestamp,
  CREATED_BY_ID int8 NOT NULL,
  MODIFY_BY_ID int8 DEFAULT NULL,
  ASSIGNED_BY_ID int8 DEFAULT NULL,
  OPENED char(1) DEFAULT 'N',
  COMPANY_ID int8 DEFAULT NULL,
  CONTACT_ID int8 DEFAULT NULL,
  STATUS_ID varchar(50) DEFAULT NULL,
  STATUS_DESCRIPTION text DEFAULT NULL,
  STATUS_SEMANTIC_ID varchar(3),
  PRODUCT_ID varchar(50) DEFAULT NULL,
  OPPORTUNITY decimal DEFAULT NULL,
  CURRENCY_ID varchar(50) DEFAULT NULL,
  OPPORTUNITY_ACCOUNT decimal DEFAULT NULL,
  ACCOUNT_CURRENCY_ID varchar(50) DEFAULT NULL,
  SOURCE_ID varchar(50) DEFAULT NULL,
  SOURCE_DESCRIPTION text DEFAULT NULL,
  TITLE varchar(255) DEFAULT NULL,
  FULL_NAME varchar(100) DEFAULT NULL,
  NAME varchar(50) DEFAULT NULL,
  LAST_NAME varchar(50) DEFAULT NULL,
  SECOND_NAME varchar(50) DEFAULT NULL,
  COMPANY_TITLE varchar(255) DEFAULT NULL,
  POST varchar(255) DEFAULT NULL,
  ADDRESS text DEFAULT NULL,
  COMMENTS text DEFAULT NULL,
  EXCH_RATE decimal DEFAULT 1,
  WEBFORM_ID int8 DEFAULT NULL,
  ORIGINATOR_ID varchar(255),
  ORIGIN_ID varchar(255),
  DATE_CLOSED timestamp,
  BIRTHDATE date,
  BIRTHDAY_SORT int NOT NULL DEFAULT 1024,
  HONORIFIC varchar(128),
  HAS_PHONE char(1),
  HAS_EMAIL char(1),
  HAS_IMOL char(1) DEFAULT 'N',
  IS_RETURN_CUSTOMER char(1) NOT NULL DEFAULT 'N',
  FACE_ID int,
  SEARCH_CONTENT text,
  IS_MANUAL_OPPORTUNITY char(1) DEFAULT 'N',
  MOVED_BY_ID int8 DEFAULT NULL,
  MOVED_TIME timestamp,
  LAST_ACTIVITY_BY int8 NOT NULL DEFAULT 0,
  LAST_ACTIVITY_TIME timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_lead_full_name ON b_crm_lead (full_name);
CREATE INDEX ix_b_crm_lead_status_id_assigned_by_id ON b_crm_lead (status_id, assigned_by_id);
CREATE INDEX ix_b_crm_lead_date_modify ON b_crm_lead (date_modify);
CREATE INDEX ix_b_crm_lead_contact_id ON b_crm_lead (contact_id);
CREATE INDEX ix_b_crm_lead_company_id ON b_crm_lead (company_id);
CREATE INDEX ix_b_crm_lead_webform_id ON b_crm_lead (webform_id);
CREATE INDEX ix_b_crm_lead_face_id ON b_crm_lead (face_id);
CREATE INDEX ix_b_crm_lead_has_imol ON b_crm_lead (has_imol);
CREATE INDEX ix_b_crm_lead_status_semantic_id_status_id_opportunity_account ON b_crm_lead (status_semantic_id, status_id, opportunity_account);
CREATE INDEX ix_b_crm_lead_status_id_opportunity_account ON b_crm_lead (status_id, opportunity_account);
CREATE INDEX ix_b_crm_lead_birthday_sort_assigned_by_id ON b_crm_lead (birthday_sort, assigned_by_id);
CREATE INDEX ix_b_crm_lead_birthdate ON b_crm_lead (birthdate);
CREATE INDEX ix_b_crm_lead_has_email ON b_crm_lead (has_email);
CREATE INDEX ix_b_crm_lead_has_phone_has_email ON b_crm_lead (has_phone, has_email);
CREATE INDEX ix_b_crm_lead_status_semantic_id ON b_crm_lead (status_semantic_id);
CREATE INDEX ix_b_crm_lead_assigned_by_id_status_semantic_id ON b_crm_lead (assigned_by_id, status_semantic_id);
CREATE INDEX ix_b_crm_lead_date_create_status_semantic_id ON b_crm_lead (date_create, status_semantic_id);
CREATE INDEX ix_b_crm_lead_date_closed ON b_crm_lead (date_closed);
CREATE INDEX ix_b_crm_lead_last_activity_time ON b_crm_lead (last_activity_time);
CREATE INDEX ix_b_crm_lead_status_id_last_activity_time ON b_crm_lead (status_id, last_activity_time);
CREATE INDEX tx_b_crm_lead_search_content ON b_crm_lead USING GIN (to_tsvector('english', search_content));

CREATE TABLE b_crm_deal (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_CREATE timestamp,
  DATE_MODIFY timestamp,
  CREATED_BY_ID int8 NOT NULL,
  MODIFY_BY_ID int8 DEFAULT NULL,
  ASSIGNED_BY_ID int8 DEFAULT NULL,
  OPENED char(1) DEFAULT 'N',
  LEAD_ID int DEFAULT NULL,
  COMPANY_ID int8 DEFAULT NULL,
  CONTACT_ID int8 DEFAULT NULL,
  QUOTE_ID int8 DEFAULT NULL,
  TITLE varchar(255) DEFAULT NULL,
  PRODUCT_ID varchar(50) DEFAULT NULL,
  CATEGORY_ID int8 NOT NULL DEFAULT 0,
  STAGE_ID varchar(50) DEFAULT NULL,
  STAGE_SEMANTIC_ID varchar(3),
  IS_NEW char(1),
  IS_RECURRING char(1) DEFAULT 'N',
  IS_RETURN_CUSTOMER char(1) DEFAULT 'N',
  IS_REPEATED_APPROACH char(1) DEFAULT 'N',
  CLOSED char(1) DEFAULT 'N',
  TYPE_ID varchar(50) DEFAULT NULL,
  OPPORTUNITY decimal DEFAULT NULL,
  IS_MANUAL_OPPORTUNITY char(1) DEFAULT 'N',
  TAX_VALUE decimal DEFAULT NULL,
  CURRENCY_ID varchar(50) DEFAULT NULL,
  OPPORTUNITY_ACCOUNT decimal DEFAULT NULL,
  TAX_VALUE_ACCOUNT decimal DEFAULT NULL,
  ACCOUNT_CURRENCY_ID varchar(50) DEFAULT NULL,
  PROBABILITY smallint DEFAULT NULL,
  COMMENTS text DEFAULT NULL,
  BEGINDATE timestamp DEFAULT NULL,
  CLOSEDATE timestamp DEFAULT NULL,
  EVENT_DATE timestamp,
  EVENT_ID varchar(50),
  EVENT_DESCRIPTION text,
  EXCH_RATE decimal DEFAULT 1,
  LOCATION_ID varchar(100),
  WEBFORM_ID int8 DEFAULT NULL,
  SOURCE_ID varchar(50) DEFAULT NULL,
  SOURCE_DESCRIPTION text DEFAULT NULL,
  ORIGINATOR_ID varchar(255),
  ORIGIN_ID varchar(255),
  ADDITIONAL_INFO text,
  SEARCH_CONTENT text,
  ORDER_STAGE varchar(255) DEFAULT NULL,
  MOVED_BY_ID int8 DEFAULT NULL,
  MOVED_TIME timestamp,
  LAST_ACTIVITY_BY int8 NOT NULL DEFAULT 0,
  LAST_ACTIVITY_TIME timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_deal_stage_id_assigned_by_id ON b_crm_deal (stage_id, assigned_by_id);
CREATE INDEX ix_b_crm_deal_webform_id ON b_crm_deal (webform_id);
CREATE INDEX ix_b_crm_deal_origin_id_originator_id ON b_crm_deal (origin_id, originator_id);
CREATE INDEX ix_b_crm_deal_lead_id ON b_crm_deal (lead_id);
CREATE INDEX ix_b_crm_deal_is_new ON b_crm_deal (is_new);
CREATE INDEX ix_b_crm_deal_date_create_stage_semantic_id ON b_crm_deal (date_create, stage_semantic_id);
CREATE INDEX ix_b_crm_deal_is_return_customer_category_id ON b_crm_deal (is_return_customer, category_id);
CREATE INDEX ix_b_crm_deal_company_id_is_return_customer ON b_crm_deal (company_id, is_return_customer);
CREATE INDEX ix_b_crm_deal_contact_id_is_return_customer ON b_crm_deal (contact_id, is_return_customer);
CREATE INDEX ix_b_crm_deal_is_repeated_approach_category_id ON b_crm_deal (is_repeated_approach, category_id);
CREATE INDEX ix_b_crm_deal_stage_semantic_id_category_id_stage_id ON b_crm_deal (stage_semantic_id, category_id, stage_id);
CREATE INDEX ix_b_crm_deal_moved_time_stage_semantic_id ON b_crm_deal (moved_time, stage_semantic_id);
CREATE INDEX ix_b_crm_deal_closedate ON b_crm_deal (closedate);
CREATE INDEX ix_b_crm_deal_last_activity_time ON b_crm_deal (last_activity_time);
CREATE INDEX ix_b_crm_deal_stage_semantic_id_company_id ON b_crm_deal (stage_semantic_id, company_id);
CREATE INDEX ix_b_crm_deal_category_id_stage_id_is_recurring ON b_crm_deal (category_id, stage_id, is_recurring);
CREATE INDEX ix_b_crm_deal_category_id_stage_semantic_id_is_recurring_stage_ ON b_crm_deal (category_id, stage_semantic_id, is_recurring, stage_id, opportunity_account);
CREATE INDEX ix_b_crm_deal_stage_id_category_id_stage_semantic_id ON b_crm_deal (stage_id, category_id, stage_semantic_id);
CREATE INDEX ix_b_crm_deal_stage_id_last_activity_time ON b_crm_deal (stage_id, last_activity_time);
CREATE INDEX ix_b_crm_deal_assigned_by_id_stage_semantic_id_category_id_is_r ON b_crm_deal (assigned_by_id, stage_semantic_id, category_id, is_recurring);
CREATE INDEX tx_b_crm_deal_search_content ON b_crm_deal USING GIN (to_tsvector('english', search_content));

CREATE TABLE b_crm_contact (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_CREATE timestamp,
  DATE_MODIFY timestamp,
  CREATED_BY_ID int8 NOT NULL,
  MODIFY_BY_ID int8 DEFAULT NULL,
  ASSIGNED_BY_ID int8 DEFAULT NULL,
  OPENED char(1) DEFAULT 'N',
  COMPANY_ID int8 DEFAULT NULL,
  SOURCE_ID varchar(50) DEFAULT NULL,
  SOURCE_DESCRIPTION text DEFAULT NULL,
  FULL_NAME varchar(100) DEFAULT NULL,
  NAME varchar(50) DEFAULT NULL,
  LAST_NAME varchar(50) DEFAULT NULL,
  SECOND_NAME varchar(50) DEFAULT NULL,
  PHOTO varchar(10) DEFAULT NULL,
  POST varchar(255) DEFAULT NULL,
  ADDRESS text DEFAULT NULL,
  COMMENTS text DEFAULT NULL,
  LEAD_ID int DEFAULT NULL,
  EXPORT char(1) DEFAULT 'N',
  TYPE_ID varchar(50) DEFAULT NULL,
  WEBFORM_ID int8 DEFAULT NULL,
  ORIGINATOR_ID varchar(255),
  ORIGIN_ID varchar(255),
  ORIGIN_VERSION varchar(255),
  BIRTHDATE date DEFAULT NULL,
  BIRTHDAY_SORT int NOT NULL DEFAULT 1024,
  HONORIFIC varchar(128),
  HAS_PHONE char(1),
  HAS_EMAIL char(1),
  HAS_IMOL char(1) DEFAULT 'N',
  FACE_ID int,
  SEARCH_CONTENT text,
  CATEGORY_ID int8 NOT NULL DEFAULT 0,
  LAST_ACTIVITY_BY int8 NOT NULL DEFAULT 0,
  LAST_ACTIVITY_TIME timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_contact_name ON b_crm_contact (name);
CREATE INDEX ix_b_crm_contact_last_name ON b_crm_contact (last_name);
CREATE INDEX ix_b_crm_contact_full_name ON b_crm_contact (full_name);
CREATE INDEX ix_b_crm_contact_birthday_sort_assigned_by_id ON b_crm_contact (birthday_sort, assigned_by_id);
CREATE INDEX ix_b_crm_contact_birthdate ON b_crm_contact (birthdate);
CREATE INDEX ix_b_crm_contact_company_id ON b_crm_contact (company_id);
CREATE INDEX ix_b_crm_contact_has_email ON b_crm_contact (has_email);
CREATE INDEX ix_b_crm_contact_has_phone_has_email ON b_crm_contact (has_phone, has_email);
CREATE INDEX ix_b_crm_contact_webform_id ON b_crm_contact (webform_id);
CREATE INDEX ix_b_crm_contact_face_id ON b_crm_contact (face_id);
CREATE INDEX ix_b_crm_contact_has_imol ON b_crm_contact (has_imol);
CREATE INDEX ix_b_crm_contact_lead_id ON b_crm_contact (lead_id);
CREATE INDEX ix_b_crm_contact_last_name_name ON b_crm_contact (last_name, name);
CREATE INDEX ix_b_crm_contact_category_id ON b_crm_contact (category_id);
CREATE INDEX ix_b_crm_contact_last_activity_time ON b_crm_contact (last_activity_time);
CREATE INDEX tx_b_crm_contact_search_content ON b_crm_contact USING GIN (to_tsvector('english', search_content));

CREATE TABLE b_crm_company (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_CREATE timestamp,
  DATE_MODIFY timestamp,
  CREATED_BY_ID int8 NOT NULL,
  MODIFY_BY_ID int8 DEFAULT NULL,
  ASSIGNED_BY_ID int8 DEFAULT NULL,
  OPENED char(1) DEFAULT 'N',
  TITLE varchar(255) DEFAULT NULL,
  LOGO varchar(10) DEFAULT NULL,
  ADDRESS text DEFAULT NULL,
  ADDRESS_LEGAL text DEFAULT NULL,
  BANKING_DETAILS text DEFAULT NULL,
  COMMENTS text DEFAULT NULL,
  COMPANY_TYPE varchar(50) DEFAULT NULL,
  INDUSTRY varchar(50) DEFAULT NULL,
  REVENUE varchar(255) DEFAULT NULL,
  CURRENCY_ID varchar(50) DEFAULT NULL,
  EMPLOYEES varchar(50) DEFAULT NULL,
  LEAD_ID int DEFAULT NULL,
  WEBFORM_ID int8 DEFAULT NULL,
  ORIGINATOR_ID varchar(255),
  ORIGIN_ID varchar(255),
  ORIGIN_VERSION varchar(255),
  HAS_PHONE char(1),
  HAS_EMAIL char(1),
  HAS_IMOL char(1) DEFAULT 'N',
  IS_MY_COMPANY char(1) NOT NULL DEFAULT 'N',
  SEARCH_CONTENT text,
  CATEGORY_ID int8 NOT NULL DEFAULT 0,
  LAST_ACTIVITY_BY int8 NOT NULL DEFAULT 0,
  LAST_ACTIVITY_TIME timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_company_title ON b_crm_company (title);
CREATE INDEX ix_b_crm_company_has_email ON b_crm_company (has_email);
CREATE INDEX ix_b_crm_company_has_phone_has_email ON b_crm_company (has_phone, has_email);
CREATE INDEX ix_b_crm_company_webform_id ON b_crm_company (webform_id);
CREATE INDEX ix_b_crm_company_has_imol ON b_crm_company (has_imol);
CREATE INDEX ix_b_crm_company_lead_id ON b_crm_company (lead_id);
CREATE INDEX ix_b_crm_company_is_my_company_category_id ON b_crm_company (is_my_company, category_id);
CREATE INDEX ix_b_crm_company_last_activity_time ON b_crm_company (last_activity_time);
CREATE INDEX tx_b_crm_company_search_content ON b_crm_company USING GIN (to_tsvector('english', search_content));

CREATE TABLE b_crm_status (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_ID varchar(50) NOT NULL,
  STATUS_ID varchar(50) NOT NULL,
  NAME varchar(100) NOT NULL,
  NAME_INIT varchar(100),
  SORT int NOT NULL,
  SYSTEM char(1) NOT NULL,
  COLOR char(10),
  SEMANTICS char(1),
  CATEGORY_ID int8,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_status_status_id_entity_id ON b_crm_status (status_id, entity_id);
CREATE INDEX ix_b_crm_status_entity_id ON b_crm_status (entity_id);

CREATE TABLE b_crm_field_multi (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_ID varchar(16) NOT NULL,
  ELEMENT_ID int NOT NULL,
  TYPE_ID varchar(16) NOT NULL,
  VALUE_TYPE varchar(50) NOT NULL,
  COMPLEX_ID varchar(100) NOT NULL,
  VALUE varchar(250) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_field_multi_type_id_value_entity_id_element_id ON b_crm_field_multi (type_id, value, entity_id, element_id);
CREATE INDEX ix_b_crm_field_multi_entity_id_type_id_element_id ON b_crm_field_multi (entity_id, type_id, element_id);
CREATE INDEX ix_b_crm_field_multi_element_id_entity_id ON b_crm_field_multi (element_id, entity_id);
CREATE INDEX ix_b_crm_field_multi_value ON b_crm_field_multi (value);

CREATE TABLE IF NOT EXISTS b_crm_field_multi_phone_country (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FM_ID int8 NOT NULL,
  COUNTRY_CODE varchar(2) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_field_multi_phone_country_fm_id_country_code ON b_crm_field_multi_phone_country (fm_id, country_code);
CREATE INDEX ix_b_crm_field_multi_phone_country_country_code ON b_crm_field_multi_phone_country (country_code);

CREATE TABLE b_crm_event (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_CREATE timestamp NOT NULL,
  CREATED_BY_ID int NOT NULL,
  EVENT_ID varchar(50),
  EVENT_NAME varchar(255) NOT NULL,
  EVENT_TEXT_1 text,
  EVENT_TEXT_2 text,
  EVENT_TYPE int,
  FILES text DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_event_date_create ON b_crm_event (date_create);
CREATE INDEX ix_b_crm_event_event_type_date_create ON b_crm_event (event_type, date_create);
CREATE INDEX ix_b_crm_event_files ON b_crm_event (files);
CREATE INDEX ix_b_crm_event_event_type_event_id ON b_crm_event (event_type, event_id);
CREATE INDEX ix_b_crm_event_created_by_id ON b_crm_event (created_by_id);

CREATE TABLE b_crm_event_relations (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ASSIGNED_BY_ID int NOT NULL,
  ENTITY_TYPE varchar(50),
  ENTITY_ID int NOT NULL,
  ENTITY_FIELD varchar(255),
  EVENT_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_event_relations_entity_type_entity_id_entity_field ON b_crm_event_relations (entity_type, entity_id, entity_field);
CREATE INDEX ix_b_crm_event_relations_event_id ON b_crm_event_relations (event_id);
CREATE INDEX ix_b_crm_event_relations_entity_type_entity_id_event_id ON b_crm_event_relations (entity_type, entity_id, event_id);

CREATE TABLE b_crm_entity_lock (
  ENTITY_ID int NOT NULL,
  ENTITY_TYPE varchar(10) NOT NULL,
  DATE_LOCK timestamp DEFAULT NULL,
  LOCKED_BY varchar(32) DEFAULT NULL,
  PRIMARY KEY (ENTITY_ID)
);

CREATE TABLE b_crm_entity_perms (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY varchar(20) NOT NULL,
  ENTITY_ID int NOT NULL,
  ATTR varchar(30) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_entity_perms_entity_entity_id_attr ON b_crm_entity_perms (entity, entity_id, attr);
CREATE INDEX ix_b_crm_entity_perms_entity_attr_entity_id ON b_crm_entity_perms (entity, attr, entity_id);

CREATE TABLE b_crm_role (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) NOT NULL,
  IS_SYSTEM char(1) NOT NULL DEFAULT 'N',
  CODE varchar(64),
  GROUP_CODE varchar(64),
  PRIMARY KEY (ID)
);

CREATE TABLE b_crm_role_perms (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ROLE_ID int8 NOT NULL,
  ENTITY varchar(20) NOT NULL,
  FIELD varchar(30) DEFAULT '-',
  FIELD_VALUE varchar(255) DEFAULT NULL,
  PERM_TYPE varchar(20) NOT NULL,
  ATTR char(1) DEFAULT '',
  SETTINGS text DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_role_perms_role_id_perm_type_entity ON b_crm_role_perms (role_id, perm_type, entity);
CREATE INDEX ix_b_crm_role_perms_entity_perm_type_attr ON b_crm_role_perms (entity, perm_type, attr);

CREATE TABLE b_crm_role_relation (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ROLE_ID int8 NOT NULL,
  RELATION varchar(100) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_role_relation_role_id_relation ON b_crm_role_relation (role_id, relation);

CREATE TABLE IF NOT EXISTS b_crm_external_sale (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  DATE_CREATE timestamp NOT NULL,
  DATE_UPDATE timestamp NOT NULL,
  NAME varchar(128),
  SCHEME varchar(5) NOT NULL DEFAULT 'http',
  SERVER varchar(192) NOT NULL,
  PORT int NOT NULL DEFAULT 80,
  LOGIN varchar(64) NOT NULL,
  PASSWORD varchar(128) NOT NULL,
  MODIFICATION_LABEL int,
  IMPORT_SIZE int,
  IMPORT_PERIOD int,
  IMPORT_PROBABILITY int,
  IMPORT_RESPONSIBLE int,
  IMPORT_PUBLIC char(1),
  IMPORT_PREFIX varchar(128),
  IMPORT_ERRORS int,
  IMPORT_GROUP_ID int,
  COOKIE text,
  LAST_STATUS text,
  LAST_STATUS_DATE timestamp,
  SYNC_DATA text,
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_catalog (
  ID int NOT NULL,
  ORIGINATOR_ID varchar(255),
  ORIGIN_ID varchar(255),
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_product (
  ID int NOT NULL,
  CATALOG_ID int NOT NULL,
  CURRENCY_ID varchar(50) NOT NULL,
  PRICE decimal NOT NULL DEFAULT 0,
  ORIGINATOR_ID varchar(255),
  ORIGIN_ID varchar(255),
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_product_row (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  OWNER_ID int NOT NULL,
  OWNER_TYPE varchar(20) NOT NULL,
  PRODUCT_ID int NOT NULL,
  PRODUCT_NAME varchar(256),
  PRICE decimal NOT NULL,
  PRICE_ACCOUNT decimal NOT NULL DEFAULT 0,
  PRICE_EXCLUSIVE decimal,
  PRICE_NETTO decimal,
  PRICE_BRUTTO decimal,
  QUANTITY decimal NOT NULL,
  DISCOUNT_TYPE_ID int,
  DISCOUNT_RATE decimal,
  DISCOUNT_SUM decimal,
  TAX_RATE decimal,
  TAX_INCLUDED char(1),
  CUSTOMIZED char(1),
  MEASURE_CODE int8,
  MEASURE_NAME varchar(50),
  SORT int,
  XML_ID varchar(255) DEFAULT NULL,
  TYPE int NOT NULL DEFAULT 1,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_product_row_owner_id_owner_type_sort ON b_crm_product_row (owner_id, owner_type, sort);
CREATE INDEX ix_b_crm_product_row_product_id ON b_crm_product_row (product_id);

CREATE TABLE IF NOT EXISTS b_crm_product_row_cfg (
  OWNER_ID int NOT NULL,
  OWNER_TYPE varchar(20) NOT NULL,
  SETTINGS text,
  PRIMARY KEY (OWNER_ID, OWNER_TYPE)
);

CREATE TABLE IF NOT EXISTS b_crm_act (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TYPE_ID int NOT NULL,
  PROVIDER_ID varchar(100),
  PROVIDER_TYPE_ID varchar(100),
  PROVIDER_GROUP_ID varchar(100),
  OWNER_ID int NOT NULL,
  OWNER_TYPE_ID int NOT NULL,
  ASSOCIATED_ENTITY_ID int,
  CALENDAR_EVENT_ID int8 NOT NULL DEFAULT 0,
  SUBJECT varchar(512) NOT NULL,
  IS_HANDLEABLE char(1),
  COMPLETED char(1) NOT NULL DEFAULT 'N',
  STATUS int8 NOT NULL DEFAULT 0,
  RESPONSIBLE_ID int NOT NULL,
  PRIORITY int NOT NULL,
  NOTIFY_TYPE int NOT NULL,
  NOTIFY_VALUE int8,
  DESCRIPTION text,
  DESCRIPTION_TYPE int,
  DIRECTION int NOT NULL,
  LOCATION varchar(256),
  CREATED timestamp NOT NULL,
  LAST_UPDATED timestamp NOT NULL,
  START_TIME timestamp,
  END_TIME timestamp,
  DEADLINE timestamp,
  STORAGE_TYPE_ID int,
  STORAGE_ELEMENT_IDS text,
  PARENT_ID int8 NOT NULL DEFAULT 0,
  THREAD_ID int8 NOT NULL DEFAULT 0,
  URN varchar(64),
  SETTINGS text,
  ORIGINATOR_ID varchar(255),
  ORIGIN_ID varchar(255),
  AUTHOR_ID int8,
  EDITOR_ID int8,
  PROVIDER_PARAMS text,
  PROVIDER_DATA text,
  SEARCH_CONTENT text,
  RESULT_STATUS int NOT NULL DEFAULT 0,
  RESULT_STREAM int NOT NULL DEFAULT 0,
  RESULT_SOURCE_ID varchar(255),
  RESULT_MARK int NOT NULL DEFAULT 0,
  RESULT_VALUE decimal DEFAULT NULL,
  RESULT_SUM decimal DEFAULT NULL,
  RESULT_CURRENCY_ID char(3),
  AUTOCOMPLETE_RULE int8 NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_act_id_parent_id_owner_id_owner_type_id ON b_crm_act (id, parent_id, owner_id, owner_type_id);
CREATE INDEX ix_b_crm_act_responsible_id_completed_deadline ON b_crm_act (responsible_id, completed, deadline);
CREATE INDEX ix_b_crm_act_associated_entity_id_type_id ON b_crm_act (associated_entity_id, type_id);
CREATE INDEX ix_b_crm_act_deadline ON b_crm_act (deadline);
CREATE INDEX ix_b_crm_act_origin_id ON b_crm_act (origin_id);
CREATE INDEX ix_b_crm_act_provider_id ON b_crm_act (provider_id);
CREATE INDEX ix_b_crm_act_calendar_event_id ON b_crm_act (calendar_event_id);
CREATE INDEX ix_b_crm_act_urn ON b_crm_act (urn);
CREATE INDEX ix_b_crm_act_parent_id ON b_crm_act (parent_id);
CREATE INDEX ix_b_crm_act_thread_id ON b_crm_act (thread_id);
CREATE INDEX ix_b_crm_act_last_updated_type_id ON b_crm_act (last_updated, type_id);
CREATE INDEX ix_b_crm_act_completed_deadline ON b_crm_act (completed, deadline);
CREATE INDEX ix_b_crm_act_responsible_id_owner_type_id_owner_id ON b_crm_act (responsible_id, owner_type_id, owner_id);
CREATE INDEX ix_b_crm_act_responsible_id_completed_start_time ON b_crm_act (responsible_id, completed, start_time);
CREATE INDEX ix_b_crm_act_responsible_id_created ON b_crm_act (responsible_id, created);
CREATE INDEX ix_b_crm_act_type_id_completed_deadline ON b_crm_act (type_id, completed, deadline);
CREATE INDEX ix_b_crm_act_owner_id_owner_type_id_type_id_completed_deadline ON b_crm_act (owner_id, owner_type_id, type_id, completed, deadline);
CREATE INDEX ix_b_crm_act_originator_id ON b_crm_act (originator_id);
CREATE INDEX tx_b_crm_act_search_content ON b_crm_act USING GIN (to_tsvector('english', search_content));

CREATE TABLE IF NOT EXISTS b_crm_act_bind (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ACTIVITY_ID int NOT NULL,
  OWNER_ID int NOT NULL,
  OWNER_TYPE_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_act_bind_owner_id_owner_type_id_activity_id ON b_crm_act_bind (owner_id, owner_type_id, activity_id);
CREATE INDEX ix_b_crm_act_bind_activity_id_owner_type_id_owner_id ON b_crm_act_bind (activity_id, owner_type_id, owner_id);

CREATE TABLE IF NOT EXISTS b_crm_act_comm (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ACTIVITY_ID int8 NOT NULL,
  OWNER_ID int NOT NULL,
  OWNER_TYPE_ID int NOT NULL,
  TYPE varchar(64),
  VALUE varchar(256),
  ENTITY_ID int8 NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_SETTINGS text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_act_comm_activity_id_owner_id_owner_type_id_entity_id_ ON b_crm_act_comm (activity_id, owner_id, owner_type_id, entity_id, entity_type_id);
CREATE INDEX ix_b_crm_act_comm_owner_id_owner_type_id_type ON b_crm_act_comm (owner_id, owner_type_id, type);
CREATE INDEX ix_b_crm_act_comm_entity_id_entity_type_id ON b_crm_act_comm (entity_id, entity_type_id);

CREATE TABLE IF NOT EXISTS b_crm_act_elem (
  ACTIVITY_ID int8 NOT NULL,
  STORAGE_TYPE_ID int NOT NULL,
  ELEMENT_ID int8 NOT NULL,
  PRIMARY KEY (ACTIVITY_ID, STORAGE_TYPE_ID, ELEMENT_ID)
);
CREATE INDEX ix_b_crm_act_elem_element_id_storage_type_id ON b_crm_act_elem (element_id, storage_type_id);

CREATE TABLE b_crm_act_app_type (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  APP_ID int NOT NULL,
  TYPE_ID varchar(100) NOT NULL,
  NAME varchar(255) NOT NULL,
  ICON_ID int NOT NULL DEFAULT 0,
  IS_CONFIGURABLE_TYPE char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_usr_act (
  USER_ID int8 NOT NULL,
  OWNER_ID int NOT NULL,
  OWNER_TYPE_ID int NOT NULL,
  ACTIVITY_TIME timestamp NOT NULL,
  ACTIVITY_ID int8 NOT NULL,
  DEPARTMENT_ID int8 NOT NULL,
  SORT varchar(16),
  PRIMARY KEY (USER_ID, OWNER_ID, OWNER_TYPE_ID)
);
CREATE INDEX ix_b_crm_usr_act_user_id_owner_id_owner_type_id_activity_time_a ON b_crm_usr_act (user_id, owner_id, owner_type_id, activity_time, activity_id, department_id);
CREATE INDEX ix_b_crm_usr_act_owner_id_owner_type_id_user_id_sort ON b_crm_usr_act (owner_id, owner_type_id, user_id, sort);

CREATE TABLE IF NOT EXISTS b_crm_usr_mt (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  OWNER_ID int NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  SCOPE int NOT NULL,
  IS_ACTIVE char(1) NOT NULL DEFAULT 'N',
  TITLE varchar(128),
  EMAIL_FROM varchar(255),
  SUBJECT varchar(255),
  BODY_TYPE int,
  BODY text,
  SING_REQUIRED char(1) NOT NULL DEFAULT 'N',
  SORT int NOT NULL DEFAULT 100,
  CREATED timestamp NOT NULL,
  LAST_UPDATED timestamp NOT NULL,
  AUTHOR_ID int8 NOT NULL,
  EDITOR_ID int8 NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_usr_mt_owner_id_entity_type_id_scope_is_active ON b_crm_usr_mt (owner_id, entity_type_id, scope, is_active);

CREATE TABLE IF NOT EXISTS b_crm_user_mail_template_access (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TEMPLATE_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_TYPE smallint NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_user_mail_template_access_template_id_entity_id_entity ON b_crm_user_mail_template_access (template_id, entity_id, entity_type);
CREATE INDEX ix_b_crm_user_mail_template_access_template_id ON b_crm_user_mail_template_access (template_id);
CREATE INDEX ix_b_crm_user_mail_template_access_entity_id_entity_type ON b_crm_user_mail_template_access (entity_id, entity_type);

CREATE TABLE IF NOT EXISTS b_crm_sl_rel (
  SL_ID int NOT NULL,
  SL_EVENT_ID varchar(50) NOT NULL,
  SL_ENTITY_TYPE varchar(50) NOT NULL,
  SL_LAST_UPDATED timestamp,
  ENTITY_ID int8 NOT NULL,
  SL_PARENT_ENTITY_TYPE varchar(50) NOT NULL,
  PARENT_ENTITY_ID int8 NOT NULL,
  LVL int NOT NULL DEFAULT 1,
  TYPE_ID int NOT NULL DEFAULT 1
);
CREATE INDEX ix_b_crm_sl_rel_sl_parent_entity_type_parent_entity_id_lvl_sl_e ON b_crm_sl_rel (sl_parent_entity_type, parent_entity_id, lvl, sl_entity_type, sl_event_id, sl_id);
CREATE INDEX ix_b_crm_sl_rel_sl_entity_type_entity_id ON b_crm_sl_rel (sl_entity_type, entity_id);
CREATE INDEX ix_b_crm_sl_rel_sl_id_type_id ON b_crm_sl_rel (sl_id, type_id);
CREATE INDEX ix_b_crm_sl_rel_sl_last_updated_sl_parent_entity_type_parent_en ON b_crm_sl_rel (sl_last_updated, sl_parent_entity_type, parent_entity_id, lvl, sl_entity_type, sl_event_id, sl_id);

CREATE TABLE IF NOT EXISTS b_crm_sl_subscr (
  USER_ID int8 NOT NULL,
  SL_ENTITY_TYPE varchar(50) NOT NULL,
  ENTITY_ID int8 NOT NULL,
  TYPE_ID int NOT NULL,
  PRIMARY KEY (USER_ID, SL_ENTITY_TYPE, ENTITY_ID, TYPE_ID)
);
CREATE INDEX ix_b_crm_sl_subscr_sl_entity_type_entity_id_type_id ON b_crm_sl_subscr (sl_entity_type, entity_id, type_id);

CREATE TABLE IF NOT EXISTS b_crm_biz_type (
  CODE varchar(32) NOT NULL,
  NAME varchar(256) NOT NULL,
  LANG varchar(2),
  PRIMARY KEY (CODE)
);

CREATE TABLE IF NOT EXISTS b_crm_dp_org_mcd (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int8 NOT NULL,
  TITLE varchar(256) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_dp_org_mcd_title_entity_type_id_entity_id ON b_crm_dp_org_mcd (title, entity_type_id, entity_id);
CREATE INDEX ix_b_crm_dp_org_mcd_entity_type_id_entity_id ON b_crm_dp_org_mcd (entity_type_id, entity_id);

CREATE TABLE IF NOT EXISTS b_crm_dp_comm_mcd (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int8 NOT NULL,
  TYPE varchar(32) NOT NULL,
  VALUE varchar(256) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_dp_comm_mcd_type_value_entity_type_id_entity_id ON b_crm_dp_comm_mcd (type, value, entity_type_id, entity_id);
CREATE INDEX ix_b_crm_dp_comm_mcd_entity_type_id_entity_id_type ON b_crm_dp_comm_mcd (entity_type_id, entity_id, type);

CREATE TABLE IF NOT EXISTS b_crm_dp_prsn_mcd (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int8 NOT NULL,
  LAST_NAME varchar(64) NOT NULL,
  NAME varchar(64),
  SECOND_NAME varchar(64),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_dp_prsn_mcd_entity_type_id_last_name_name_second_name ON b_crm_dp_prsn_mcd (entity_type_id, last_name, name, second_name);
CREATE INDEX ix_b_crm_dp_prsn_mcd_last_name_name_second_name_entity_type_id_ ON b_crm_dp_prsn_mcd (last_name, name, second_name, entity_type_id, entity_id);
CREATE INDEX ix_b_crm_dp_prsn_mcd_entity_type_id_entity_id ON b_crm_dp_prsn_mcd (entity_type_id, entity_id);
CREATE INDEX ix_b_crm_dp_prsn_mcd_last_name_entity_type_id_entity_id_name_se ON b_crm_dp_prsn_mcd (last_name, entity_type_id, entity_id, name, second_name);
CREATE INDEX ix_b_crm_dp_prsn_mcd_entity_type_id_entity_id_last_name_name_se ON b_crm_dp_prsn_mcd (entity_type_id, entity_id, last_name, name, second_name);

CREATE TABLE IF NOT EXISTS b_crm_dp_rq_mcd (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int8 NOT NULL,
  RQ_COUNTRY_ID int NOT NULL DEFAULT 0,
  RQ_FIELD_NAME varchar(32) NOT NULL,
  VALUE varchar(32) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_dp_rq_mcd_rq_field_name_rq_country_id_value_entity_typ ON b_crm_dp_rq_mcd (rq_field_name, rq_country_id, value, entity_type_id, entity_id);
CREATE INDEX ix_b_crm_dp_rq_mcd_entity_type_id_entity_id_rq_field_name_rq_co ON b_crm_dp_rq_mcd (entity_type_id, entity_id, rq_field_name, rq_country_id);

CREATE TABLE IF NOT EXISTS b_crm_dp_bd_mcd (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int8 NOT NULL,
  BD_COUNTRY_ID int NOT NULL DEFAULT 0,
  BD_FIELD_NAME varchar(32) NOT NULL,
  VALUE varchar(32) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_dp_bd_mcd_bd_field_name_bd_country_id_value_entity_typ ON b_crm_dp_bd_mcd (bd_field_name, bd_country_id, value, entity_type_id, entity_id);
CREATE INDEX ix_b_crm_dp_bd_mcd_entity_type_id_entity_id_bd_field_name_bd_co ON b_crm_dp_bd_mcd (entity_type_id, entity_id, bd_field_name, bd_country_id);

CREATE TABLE IF NOT EXISTS b_crm_dp_vol_mcd (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int8 NOT NULL,
  TYPE_ID int8 NOT NULL,
  VALUE varchar(1024) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_dp_vol_mcd_type_id_value_entity_type_id_entity_id ON b_crm_dp_vol_mcd (type_id, value, entity_type_id, entity_id);
CREATE INDEX ix_b_crm_dp_vol_mcd_entity_type_id_entity_id_type_id ON b_crm_dp_vol_mcd (entity_type_id, entity_id, type_id);

CREATE TABLE IF NOT EXISTS b_crm_dp_index_type_settings (
  ID int8 NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'N',
  DESCRIPTION varchar(256) NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  STATE_ID int NOT NULL DEFAULT 0,
  FIELD_PATH varchar(255) NOT NULL,
  FIELD_NAME varchar(50) NOT NULL,
  PROGRESS_DATA text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_dp_index_type_settings_entity_type_id_field_path_field ON b_crm_dp_index_type_settings (entity_type_id, field_path, field_name);

CREATE TABLE IF NOT EXISTS b_crm_quote (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_CREATE timestamp NOT NULL,
  DATE_MODIFY timestamp NOT NULL,
  CREATED_BY_ID int8 NOT NULL,
  MODIFY_BY_ID int8 DEFAULT NULL,
  ASSIGNED_BY_ID int8 DEFAULT NULL,
  OPENED char(1) DEFAULT 'N',
  LEAD_ID int8 DEFAULT NULL,
  DEAL_ID int8 DEFAULT NULL,
  COMPANY_ID int8 DEFAULT NULL,
  CONTACT_ID int8 DEFAULT NULL,
  PERSON_TYPE_ID int NOT NULL,
  MYCOMPANY_ID int8 DEFAULT NULL,
  TITLE varchar(255) DEFAULT NULL,
  STATUS_ID varchar(50) DEFAULT NULL,
  CLOSED char(1) DEFAULT 'N',
  OPPORTUNITY decimal DEFAULT NULL,
  IS_MANUAL_OPPORTUNITY char(1) DEFAULT 'N',
  TAX_VALUE decimal DEFAULT NULL,
  CURRENCY_ID varchar(50) DEFAULT NULL,
  OPPORTUNITY_ACCOUNT decimal DEFAULT NULL,
  TAX_VALUE_ACCOUNT decimal DEFAULT NULL,
  ACCOUNT_CURRENCY_ID varchar(50) DEFAULT NULL,
  COMMENTS text DEFAULT NULL,
  COMMENTS_TYPE int,
  BEGINDATE timestamp,
  CLOSEDATE timestamp,
  EXCH_RATE decimal DEFAULT 1,
  QUOTE_NUMBER varchar(100),
  CONTENT text DEFAULT NULL,
  CONTENT_TYPE int,
  TERMS text DEFAULT NULL,
  TERMS_TYPE int,
  STORAGE_TYPE_ID int,
  STORAGE_ELEMENT_IDS text,
  LOCATION_ID varchar(100),
  WEBFORM_ID int8 DEFAULT NULL,
  ACTUAL_DATE date,
  CLIENT_TITLE varchar(255),
  CLIENT_ADDR varchar(255),
  CLIENT_CONTACT varchar(255),
  CLIENT_EMAIL varchar(255),
  CLIENT_PHONE varchar(255),
  CLIENT_TP_ID varchar(255),
  CLIENT_TPA_ID varchar(255),
  SEARCH_CONTENT text,
  LAST_ACTIVITY_BY int8 NOT NULL DEFAULT 0,
  LAST_ACTIVITY_TIME timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_quote_status_id_assigned_by_id ON b_crm_quote (status_id, assigned_by_id);
CREATE INDEX ix_b_crm_quote_company_id ON b_crm_quote (company_id);
CREATE INDEX ix_b_crm_quote_contact_id ON b_crm_quote (contact_id);
CREATE INDEX ix_b_crm_quote_deal_id ON b_crm_quote (deal_id);
CREATE INDEX ix_b_crm_quote_lead_id ON b_crm_quote (lead_id);
CREATE INDEX ix_b_crm_quote_webform_id ON b_crm_quote (webform_id);
CREATE INDEX ix_b_crm_quote_last_activity_time ON b_crm_quote (last_activity_time);
CREATE UNIQUE INDEX ux_b_crm_quote_quote_number ON b_crm_quote (quote_number);
CREATE INDEX tx_b_crm_quote_search_content ON b_crm_quote USING GIN (to_tsvector('english', search_content));

CREATE TABLE IF NOT EXISTS b_crm_quote_elem (
  QUOTE_ID int8 NOT NULL,
  STORAGE_TYPE_ID int NOT NULL,
  ELEMENT_ID int8 NOT NULL,
  PRIMARY KEY (QUOTE_ID, STORAGE_TYPE_ID, ELEMENT_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_dp_index (
  USER_ID int8 NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  TYPE_ID int8 NOT NULL,
  SCOPE varchar(6) NOT NULL DEFAULT '',
  MATCH_HASH varchar(32) NOT NULL,
  MATCHES text,
  QUANTITY int8 NOT NULL,
  ROOT_ENTITY_ID int8 NOT NULL,
  ROOT_ENTITY_NAME_FLAG char(1) NOT NULL,
  ROOT_ENTITY_NAME varchar(256) NOT NULL,
  ROOT_ENTITY_TITLE_FLAG char(1) NOT NULL,
  ROOT_ENTITY_TITLE varchar(256) NOT NULL,
  ROOT_ENTITY_PHONE_FLAG char(1) NOT NULL,
  ROOT_ENTITY_PHONE varchar(256) NOT NULL,
  ROOT_ENTITY_EMAIL_FLAG char(1) NOT NULL,
  ROOT_ENTITY_EMAIL varchar(256) NOT NULL,
  ROOT_ENTITY_RQ_INN_FLAG char(1) NOT NULL DEFAULT '1',
  ROOT_ENTITY_RQ_INN varchar(15) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_OGRN_FLAG char(1) NOT NULL DEFAULT '1',
  ROOT_ENTITY_RQ_OGRN varchar(13) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_OGRNIP_FLAG char(1) NOT NULL DEFAULT '1',
  ROOT_ENTITY_RQ_OGRNIP varchar(15) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_BIN_FLAG char(1) NOT NULL DEFAULT '1',
  ROOT_ENTITY_RQ_BIN varchar(12) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_EDRPOU_FLAG char(1) NOT NULL DEFAULT '1',
  ROOT_ENTITY_RQ_EDRPOU varchar(10) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_VAT_ID_FLAG char(1) NOT NULL DEFAULT '1',
  ROOT_ENTITY_RQ_VAT_ID varchar(20) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_ACC_NUM_FLAG char(1) NOT NULL DEFAULT '1',
  ROOT_ENTITY_RQ_ACC_NUM varchar(34) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_IBAN_FLAG char(1) NOT NULL DEFAULT '1',
  ROOT_ENTITY_RQ_IBAN varchar(34) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_IIK_FLAG char(1) NOT NULL DEFAULT '1',
  ROOT_ENTITY_RQ_IIK varchar(20) NOT NULL DEFAULT '',
  IS_JUNK char(1),
  STATUS_ID int8,
  PRIMARY KEY (USER_ID, ENTITY_TYPE_ID, TYPE_ID, MATCH_HASH, SCOPE)
);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_root_entity_name_flag_ ON b_crm_dp_index (user_id, entity_type_id, root_entity_name_flag, root_entity_name, type_id, scope);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_root_entity_title_flag ON b_crm_dp_index (user_id, entity_type_id, root_entity_title_flag, root_entity_title, type_id, scope);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_root_entity_phone_flag ON b_crm_dp_index (user_id, entity_type_id, root_entity_phone_flag, root_entity_phone, type_id, scope);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_root_entity_email_flag ON b_crm_dp_index (user_id, entity_type_id, root_entity_email_flag, root_entity_email, type_id, scope);
CREATE INDEX ix_b_crm_dp_index_match_hash_type_id_entity_type_id_scope ON b_crm_dp_index (match_hash, type_id, entity_type_id, scope);
CREATE INDEX ix_b_crm_dp_index_root_entity_id_entity_type_id_scope ON b_crm_dp_index (root_entity_id, entity_type_id, scope);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_root_entity_rq_inn_fla ON b_crm_dp_index (user_id, entity_type_id, root_entity_rq_inn_flag, root_entity_rq_inn, type_id, scope);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_root_entity_rq_ogrn_fl ON b_crm_dp_index (user_id, entity_type_id, root_entity_rq_ogrn_flag, root_entity_rq_ogrn, type_id, scope);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_root_entity_rq_ogrnip_ ON b_crm_dp_index (user_id, entity_type_id, root_entity_rq_ogrnip_flag, root_entity_rq_ogrnip, type_id, scope);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_root_entity_rq_bin_fla ON b_crm_dp_index (user_id, entity_type_id, root_entity_rq_bin_flag, root_entity_rq_bin, type_id, scope);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_root_entity_rq_edrpou_ ON b_crm_dp_index (user_id, entity_type_id, root_entity_rq_edrpou_flag, root_entity_rq_edrpou, type_id, scope);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_root_entity_rq_vat_id_ ON b_crm_dp_index (user_id, entity_type_id, root_entity_rq_vat_id_flag, root_entity_rq_vat_id, type_id, scope);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_root_entity_rq_acc_num ON b_crm_dp_index (user_id, entity_type_id, root_entity_rq_acc_num_flag, root_entity_rq_acc_num, type_id, scope);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_root_entity_rq_iban_fl ON b_crm_dp_index (user_id, entity_type_id, root_entity_rq_iban_flag, root_entity_rq_iban, type_id, scope);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_root_entity_rq_iik_fla ON b_crm_dp_index (user_id, entity_type_id, root_entity_rq_iik_flag, root_entity_rq_iik, type_id, scope);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_type_id_scope ON b_crm_dp_index (user_id, entity_type_id, type_id, scope);
CREATE INDEX ix_b_crm_dp_index_user_id_entity_type_id_type_id_status_id_root ON b_crm_dp_index (user_id, entity_type_id, type_id, status_id, root_entity_name_flag, root_entity_name);

CREATE TABLE IF NOT EXISTS b_crm_dp_index_mismatch (
  USER_ID int8 NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  TYPE_ID int8 NOT NULL,
  SCOPE varchar(6) NOT NULL DEFAULT '',
  MATCH_HASH varchar(32) NOT NULL,
  L_ENTITY_ID int8 NOT NULL,
  R_ENTITY_ID int8 NOT NULL,
  PRIMARY KEY (USER_ID, ENTITY_TYPE_ID, TYPE_ID, MATCH_HASH, L_ENTITY_ID, R_ENTITY_ID, SCOPE)
);
CREATE INDEX ix_b_crm_dp_index_mismatch_l_entity_id_entity_type_id ON b_crm_dp_index_mismatch (l_entity_id, entity_type_id);
CREATE INDEX ix_b_crm_dp_index_mismatch_r_entity_id_entity_type_id ON b_crm_dp_index_mismatch (r_entity_id, entity_type_id);

CREATE TABLE IF NOT EXISTS b_crm_dp_entity_stat (
  ENTITY_ID int8 NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  RANKING_DATA varchar(512),
  PRIMARY KEY (ENTITY_ID, ENTITY_TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_dp_entity_hash (
  ENTITY_ID int8 NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  TYPE_ID int8 NOT NULL,
  MATCH_HASH varchar(32) NOT NULL,
  SCOPE varchar(6) NOT NULL DEFAULT '',
  IS_PRIMARY char(1) NOT NULL,
  DATE_MODIFY timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (ENTITY_ID, ENTITY_TYPE_ID, TYPE_ID, MATCH_HASH, SCOPE)
);
CREATE INDEX ix_b_crm_dp_entity_hash_entity_type_id_type_id_match_hash_scope ON b_crm_dp_entity_hash (entity_type_id, type_id, match_hash, scope, entity_id, is_primary);

CREATE TABLE IF NOT EXISTS b_crm_addr (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TYPE_ID int NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int8 NOT NULL,
  ANCHOR_TYPE_ID int,
  ANCHOR_ID int8,
  ADDRESS_1 varchar(1024),
  ADDRESS_2 varchar(1024),
  CITY varchar(128),
  POSTAL_CODE varchar(16),
  REGION varchar(128),
  PROVINCE varchar(128),
  COUNTRY varchar(128),
  COUNTRY_CODE varchar(100),
  LOC_ADDR_ID int8 NOT NULL DEFAULT 0,
  IS_DEF int NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_addr_entity_type_id_type_id_address_1_entity_id ON b_crm_addr (entity_type_id, type_id, address_1, entity_id);
CREATE INDEX ix_b_crm_addr_entity_type_id_type_id_city_entity_id ON b_crm_addr (entity_type_id, type_id, city, entity_id);
CREATE INDEX ix_b_crm_addr_entity_type_id_type_id_postal_code_entity_id ON b_crm_addr (entity_type_id, type_id, postal_code, entity_id);
CREATE INDEX ix_b_crm_addr_entity_type_id_type_id_region_entity_id ON b_crm_addr (entity_type_id, type_id, region, entity_id);
CREATE INDEX ix_b_crm_addr_entity_type_id_type_id_province_entity_id ON b_crm_addr (entity_type_id, type_id, province, entity_id);
CREATE INDEX ix_b_crm_addr_entity_type_id_type_id_country_entity_id ON b_crm_addr (entity_type_id, type_id, country, entity_id);
CREATE INDEX ix_b_crm_addr_anchor_type_id_type_id_address_1_anchor_id ON b_crm_addr (anchor_type_id, type_id, address_1, anchor_id);
CREATE INDEX ix_b_crm_addr_anchor_type_id_type_id_city_anchor_id ON b_crm_addr (anchor_type_id, type_id, city, anchor_id);
CREATE INDEX ix_b_crm_addr_anchor_type_id_type_id_postal_code_anchor_id ON b_crm_addr (anchor_type_id, type_id, postal_code, anchor_id);
CREATE INDEX ix_b_crm_addr_anchor_type_id_type_id_region_anchor_id ON b_crm_addr (anchor_type_id, type_id, region, anchor_id);
CREATE INDEX ix_b_crm_addr_anchor_type_id_type_id_province_anchor_id ON b_crm_addr (anchor_type_id, type_id, province, anchor_id);
CREATE INDEX ix_b_crm_addr_anchor_type_id_type_id_country_anchor_id ON b_crm_addr (anchor_type_id, type_id, country, anchor_id);
CREATE INDEX ix_b_crm_addr_anchor_type_id_anchor_id_type_id ON b_crm_addr (anchor_type_id, anchor_id, type_id);
CREATE INDEX ix_b_crm_addr_loc_addr_id ON b_crm_addr (loc_addr_id);
CREATE INDEX ix_b_crm_addr_entity_type_id_type_id_address_2_entity_id ON b_crm_addr (entity_type_id, type_id, address_2, entity_id);
CREATE INDEX ix_b_crm_addr_anchor_type_id_type_id_address_2_anchor_id ON b_crm_addr (anchor_type_id, type_id, address_2, anchor_id);
CREATE INDEX ix_b_crm_addr_entity_id_entity_type_id ON b_crm_addr (entity_id, entity_type_id);
CREATE UNIQUE INDEX ux_b_crm_addr_type_id_entity_type_id_entity_id ON b_crm_addr (type_id, entity_type_id, entity_id);

CREATE TABLE IF NOT EXISTS b_crm_deal_stage_history (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TYPE_ID int8 NOT NULL,
  OWNER_ID int8 NOT NULL,
  CREATED_TIME timestamp NOT NULL,
  CREATED_DATE date,
  EFFECTIVE_DATE date,
  START_DATE date NOT NULL,
  END_DATE date NOT NULL,
  PERIOD_YEAR int8 NOT NULL,
  PERIOD_QUARTER int8 NOT NULL,
  PERIOD_MONTH int8 NOT NULL,
  START_PERIOD_YEAR int8 NOT NULL,
  START_PERIOD_QUARTER int8 NOT NULL,
  START_PERIOD_MONTH int8 NOT NULL,
  END_PERIOD_YEAR int8 NOT NULL,
  END_PERIOD_QUARTER int8 NOT NULL,
  END_PERIOD_MONTH int8 NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  CATEGORY_ID int8,
  STAGE_SEMANTIC_ID varchar(3),
  STAGE_ID varchar(50),
  IS_LOST char(1),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_deal_stage_history_type_id_stage_id_start_date_respons ON b_crm_deal_stage_history (type_id, stage_id, start_date, responsible_id, owner_id);
CREATE INDEX ix_b_crm_deal_stage_history_type_id_stage_id_end_date_responsib ON b_crm_deal_stage_history (type_id, stage_id, end_date, responsible_id, owner_id);
CREATE INDEX ix_b_crm_deal_stage_history_type_id_stage_id_created_time_respo ON b_crm_deal_stage_history (type_id, stage_id, created_time, responsible_id, owner_id);
CREATE INDEX ix_b_crm_deal_stage_history_period_year_period_month_responsibl ON b_crm_deal_stage_history (period_year, period_month, responsible_id, owner_id, start_date, end_date);
CREATE INDEX ix_b_crm_deal_stage_history_period_year_period_month_stage_sema ON b_crm_deal_stage_history (period_year, period_month, stage_semantic_id, responsible_id, owner_id, start_date, end_date);
CREATE INDEX ix_b_crm_deal_stage_history_period_year_period_month_owner_id_s ON b_crm_deal_stage_history (period_year, period_month, owner_id, start_date, end_date);
CREATE INDEX ix_b_crm_deal_stage_history_type_id_owner_id_end_date_start_dat ON b_crm_deal_stage_history (type_id, owner_id, end_date, start_date);
CREATE INDEX ix_b_crm_deal_stage_history_type_id_stage_id_created_date_respo ON b_crm_deal_stage_history (type_id, stage_id, created_date, responsible_id, owner_id);
CREATE INDEX ix_b_crm_deal_stage_history_category_id_type_id_stage_id_start_ ON b_crm_deal_stage_history (category_id, type_id, stage_id, start_date, responsible_id, owner_id);
CREATE INDEX ix_b_crm_deal_stage_history_category_id_type_id_stage_id_end_da ON b_crm_deal_stage_history (category_id, type_id, stage_id, end_date, responsible_id, owner_id);
CREATE INDEX ix_b_crm_deal_stage_history_category_id_type_id_stage_id_create ON b_crm_deal_stage_history (category_id, type_id, stage_id, created_date, responsible_id, owner_id);
CREATE INDEX ix_b_crm_deal_stage_history_is_lost_created_date_owner_id_respo ON b_crm_deal_stage_history (is_lost, created_date, owner_id, responsible_id);
CREATE INDEX ix_b_crm_deal_stage_history_category_id_is_lost_created_date_ow ON b_crm_deal_stage_history (category_id, is_lost, created_date, owner_id, responsible_id);
CREATE INDEX ix_b_crm_deal_stage_history_category_id_is_lost_stage_id_effect ON b_crm_deal_stage_history (category_id, is_lost, stage_id, effective_date, owner_id, responsible_id);
CREATE INDEX ix_b_crm_deal_stage_history_owner_id_type_id ON b_crm_deal_stage_history (owner_id, type_id);

CREATE TABLE IF NOT EXISTS b_crm_deal_stage_history_with_supposed (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  OWNER_ID int8 NOT NULL,
  CREATED_TIME timestamp,
  CREATED_DATE date,
  CATEGORY_ID int8,
  STAGE_SEMANTIC_ID varchar(3),
  STAGE_ID varchar(50),
  IS_LOST char(1),
  IS_SUPPOSED char(1) NOT NULL DEFAULT 'N',
  LAST_UPDATE_DATE date,
  CLOSE_DATE date NOT NULL DEFAULT '3000-12-12',
  SPENT_TIME int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_deal_stage_history_with_supposed_last_update_date_clos ON b_crm_deal_stage_history_with_supposed (last_update_date, close_date);
CREATE INDEX ix_b_crm_deal_stage_history_with_supposed_close_date_last_updat ON b_crm_deal_stage_history_with_supposed (close_date, last_update_date);
CREATE INDEX ix_b_crm_deal_stage_history_with_supposed_owner_id ON b_crm_deal_stage_history_with_supposed (owner_id);

CREATE TABLE IF NOT EXISTS b_crm_deal_sum_stat (
  OWNER_ID int8 NOT NULL,
  CREATED_DATE date NOT NULL,
  START_DATE date NOT NULL,
  END_DATE date NOT NULL,
  PERIOD_YEAR int8 NOT NULL,
  PERIOD_QUARTER int8 NOT NULL,
  PERIOD_MONTH int8 NOT NULL,
  PERIOD_DAY int8 NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  CATEGORY_ID int8,
  STAGE_SEMANTIC_ID varchar(3),
  STAGE_ID varchar(50),
  IS_LOST char(1),
  CURRENCY_ID char(3),
  SUM_TOTAL decimal,
  UF_SUM_1 decimal,
  UF_SUM_2 decimal,
  UF_SUM_3 decimal,
  UF_SUM_4 decimal,
  UF_SUM_5 decimal,
  UF_ATTR_1 int,
  PRIMARY KEY (OWNER_ID, CREATED_DATE)
);
CREATE INDEX ix_b_crm_deal_sum_stat_stage_semantic_id_owner_id_end_date_star ON b_crm_deal_sum_stat (stage_semantic_id, owner_id, end_date, start_date, created_date, responsible_id);
CREATE INDEX ix_b_crm_deal_sum_stat_is_lost_owner_id_end_date_start_date_cre ON b_crm_deal_sum_stat (is_lost, owner_id, end_date, start_date, created_date, responsible_id);
CREATE INDEX ix_b_crm_deal_sum_stat_end_date_start_date_owner_id_created_dat ON b_crm_deal_sum_stat (end_date, start_date, owner_id, created_date, responsible_id);
CREATE INDEX ix_b_crm_deal_sum_stat_category_id_end_date_start_date_owner_id ON b_crm_deal_sum_stat (category_id, end_date, start_date, owner_id, created_date, responsible_id);

CREATE TABLE IF NOT EXISTS b_crm_deal_inv_stat (
  OWNER_ID int8 NOT NULL,
  CREATED_DATE date NOT NULL,
  START_DATE date NOT NULL,
  END_DATE date NOT NULL,
  PERIOD_YEAR int8 NOT NULL,
  PERIOD_QUARTER int8 NOT NULL,
  PERIOD_MONTH int8 NOT NULL,
  PERIOD_DAY int8 NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  CATEGORY_ID int8,
  STAGE_SEMANTIC_ID varchar(3),
  STAGE_ID varchar(50),
  IS_LOST char(1),
  CURRENCY_ID char(3),
  INVOICE_SUM decimal,
  INVOICE_QTY int8,
  TOTAL_INVOICE_SUM decimal,
  TOTAL_INVOICE_QTY int8,
  TOTAL_SUM decimal,
  TOTAL_OWED decimal,
  UF_ATTR_1 int,
  PRIMARY KEY (OWNER_ID, CREATED_DATE)
);
CREATE INDEX ix_b_crm_deal_inv_stat_stage_semantic_id_owner_id_end_date_star ON b_crm_deal_inv_stat (stage_semantic_id, owner_id, end_date, start_date, created_date, responsible_id);
CREATE INDEX ix_b_crm_deal_inv_stat_is_lost_owner_id_end_date_start_date_cre ON b_crm_deal_inv_stat (is_lost, owner_id, end_date, start_date, created_date, responsible_id);
CREATE INDEX ix_b_crm_deal_inv_stat_category_id_is_lost_owner_id_end_date_st ON b_crm_deal_inv_stat (category_id, is_lost, owner_id, end_date, start_date, created_date, responsible_id);
CREATE INDEX ix_b_crm_deal_inv_stat_category_id_stage_semantic_id_owner_id_e ON b_crm_deal_inv_stat (category_id, stage_semantic_id, owner_id, end_date, start_date, created_date, responsible_id);

CREATE TABLE IF NOT EXISTS b_crm_deal_act_stat (
  OWNER_ID int8 NOT NULL,
  DEADLINE_DATE date NOT NULL,
  DEADLINE_YEAR int8 NOT NULL,
  DEADLINE_QUARTER int8 NOT NULL,
  DEADLINE_MONTH int8 NOT NULL,
  DEADLINE_DAY int8 NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  CATEGORY_ID int8,
  STAGE_SEMANTIC_ID varchar(3),
  STAGE_ID varchar(50),
  IS_LOST char(1),
  CALL_QTY int8,
  MEETING_QTY int8,
  EMAIL_QTY int8,
  UF_ATTR_1 int,
  PRIMARY KEY (OWNER_ID, DEADLINE_DATE)
);
CREATE INDEX ix_b_crm_deal_act_stat_responsible_id_deadline_date_owner_id_ca ON b_crm_deal_act_stat (responsible_id, deadline_date, owner_id, call_qty, meeting_qty, email_qty);
CREATE INDEX ix_b_crm_deal_act_stat_deadline_date_owner_id_call_qty_meeting_ ON b_crm_deal_act_stat (deadline_date, owner_id, call_qty, meeting_qty, email_qty);
CREATE INDEX ix_b_crm_deal_act_stat_is_lost_deadline_date_owner_id_responsib ON b_crm_deal_act_stat (is_lost, deadline_date, owner_id, responsible_id);
CREATE INDEX ix_b_crm_deal_act_stat_category_id_is_lost_deadline_date_owner_ ON b_crm_deal_act_stat (category_id, is_lost, deadline_date, owner_id, responsible_id);
CREATE INDEX ix_b_crm_deal_act_stat_category_id_responsible_id_deadline_date ON b_crm_deal_act_stat (category_id, responsible_id, deadline_date, owner_id, call_qty, meeting_qty, email_qty);

CREATE TABLE IF NOT EXISTS b_crm_conv_map (
  SRC_TYPE_ID int NOT NULL,
  DST_TYPE_ID int NOT NULL,
  RELATION_TYPE varchar(20) NOT NULL,
  IS_CHILDREN_LIST_ENABLED char(1) NOT NULL DEFAULT 'Y',
  LAST_UPDATED timestamp NOT NULL,
  DATA text,
  PRIMARY KEY (DST_TYPE_ID, SRC_TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_lead_status_history (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TYPE_ID int8 NOT NULL,
  OWNER_ID int8 NOT NULL,
  CREATED_TIME timestamp NOT NULL,
  CREATED_DATE date,
  PERIOD_YEAR int8 NOT NULL,
  PERIOD_QUARTER int8 NOT NULL,
  PERIOD_MONTH int8 NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  STATUS_SEMANTIC_ID varchar(3),
  STATUS_ID varchar(50),
  IS_IN_WORK char(1),
  IS_JUNK char(1),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_lead_status_history_type_id_created_date_status_id_res ON b_crm_lead_status_history (type_id, created_date, status_id, responsible_id);
CREATE INDEX ix_b_crm_lead_status_history_type_id_is_junk_created_date ON b_crm_lead_status_history (type_id, is_junk, created_date);
CREATE INDEX ix_b_crm_lead_status_history_type_id_is_junk_responsible_id_cre ON b_crm_lead_status_history (type_id, is_junk, responsible_id, created_date);
CREATE INDEX ix_b_crm_lead_status_history_is_in_work_owner_id_created_date ON b_crm_lead_status_history (is_in_work, owner_id, created_date);
CREATE INDEX ix_b_crm_lead_status_history_is_in_work_owner_id_responsible_id ON b_crm_lead_status_history (is_in_work, owner_id, responsible_id, created_date);
CREATE INDEX ix_b_crm_lead_status_history_is_junk_status_id_created_date_own ON b_crm_lead_status_history (is_junk, status_id, created_date, owner_id, responsible_id);
CREATE INDEX ix_b_crm_lead_status_history_owner_id_type_id ON b_crm_lead_status_history (owner_id, type_id);

CREATE TABLE IF NOT EXISTS b_crm_lead_status_history_with_supposed (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  OWNER_ID int8 NOT NULL,
  CREATED_TIME timestamp,
  CREATED_DATE date,
  STATUS_SEMANTIC_ID varchar(3),
  STATUS_ID varchar(50),
  IS_LOST char(1),
  IS_SUPPOSED char(1) NOT NULL DEFAULT 'N',
  LAST_UPDATE_DATE date,
  CLOSE_DATE date NOT NULL DEFAULT '3000-12-12',
  SPENT_TIME int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_lead_status_history_with_supposed_last_update_date_clo ON b_crm_lead_status_history_with_supposed (last_update_date, close_date);
CREATE INDEX ix_b_crm_lead_status_history_with_supposed_close_date_last_upda ON b_crm_lead_status_history_with_supposed (close_date, last_update_date);
CREATE INDEX ix_b_crm_lead_status_history_with_supposed_owner_id ON b_crm_lead_status_history_with_supposed (owner_id);

CREATE TABLE IF NOT EXISTS b_crm_lead_sum_stat (
  OWNER_ID int8 NOT NULL,
  CREATED_DATE date NOT NULL,
  PERIOD_YEAR int8 NOT NULL,
  PERIOD_QUARTER int8 NOT NULL,
  PERIOD_MONTH int8 NOT NULL,
  PERIOD_DAY int8 NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  STATUS_SEMANTIC_ID varchar(3),
  STATUS_ID varchar(50),
  SOURCE_ID varchar(50),
  IS_JUNK char(1),
  CURRENCY_ID char(3),
  SUM_TOTAL decimal,
  UF_SUM_1 decimal,
  UF_SUM_2 decimal,
  UF_SUM_3 decimal,
  UF_SUM_4 decimal,
  UF_SUM_5 decimal,
  UF_ATTR_1 int,
  PRIMARY KEY (OWNER_ID, CREATED_DATE)
);
CREATE INDEX ix_b_crm_lead_sum_stat_created_date_owner_id_source_id ON b_crm_lead_sum_stat (created_date, owner_id, source_id);
CREATE INDEX ix_b_crm_lead_sum_stat_source_id ON b_crm_lead_sum_stat (source_id);

CREATE TABLE IF NOT EXISTS b_crm_lead_act_stat (
  OWNER_ID int8 NOT NULL,
  DEADLINE_DATE date NOT NULL,
  DEADLINE_YEAR int8 NOT NULL,
  DEADLINE_QUARTER int8 NOT NULL,
  DEADLINE_MONTH int8 NOT NULL,
  DEADLINE_DAY int8 NOT NULL,
  CREATED_DATE date,
  RESPONSIBLE_ID int8 NOT NULL,
  STATUS_SEMANTIC_ID varchar(3),
  STATUS_ID varchar(50),
  IS_JUNK char(1),
  CALL_QTY int8,
  MEETING_QTY int8,
  EMAIL_QTY int8,
  UF_ATTR_1 int,
  PRIMARY KEY (OWNER_ID, DEADLINE_DATE)
);
CREATE INDEX ix_b_crm_lead_act_stat_responsible_id_deadline_date_owner_id_ca ON b_crm_lead_act_stat (responsible_id, deadline_date, owner_id, call_qty, meeting_qty, email_qty);
CREATE INDEX ix_b_crm_lead_act_stat_deadline_date_owner_id_call_qty_meeting_ ON b_crm_lead_act_stat (deadline_date, owner_id, call_qty, meeting_qty, email_qty);
CREATE INDEX ix_b_crm_lead_act_stat_is_junk_owner_id_responsible_id_deadline ON b_crm_lead_act_stat (is_junk, owner_id, responsible_id, deadline_date);
CREATE INDEX ix_b_crm_lead_act_stat_responsible_id_deadline_date_call_qty_me ON b_crm_lead_act_stat (responsible_id, deadline_date, call_qty, meeting_qty, email_qty);
CREATE INDEX ix_b_crm_lead_act_stat_is_junk ON b_crm_lead_act_stat (is_junk);

CREATE TABLE IF NOT EXISTS b_crm_lead_conv_stat (
  OWNER_ID int8 NOT NULL,
  ENTRY_DATE date NOT NULL,
  CREATED_DATE date,
  RESPONSIBLE_ID int8 NOT NULL,
  DEAL_QTY int8,
  CONTACT_QTY int8,
  COMPANY_QTY int8,
  TOTALS_DATE date,
  PRIMARY KEY (OWNER_ID, ENTRY_DATE)
);
CREATE INDEX ix_b_crm_lead_conv_stat_responsible_id_entry_date_owner_id_deal ON b_crm_lead_conv_stat (responsible_id, entry_date, owner_id, deal_qty, contact_qty, company_qty);
CREATE INDEX ix_b_crm_lead_conv_stat_created_date_owner_id_deal_qty_contact_ ON b_crm_lead_conv_stat (created_date, owner_id, deal_qty, contact_qty, company_qty);

CREATE TABLE IF NOT EXISTS b_crm_inv_status_history (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TYPE_ID int8 NOT NULL,
  OWNER_ID int8 NOT NULL,
  CREATED_TIME timestamp NOT NULL,
  CREATED_DATE date,
  BILL_DATE date NOT NULL,
  PAY_BEFORE_DATE date NOT NULL,
  ACTIVITY_DATE date NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  STATUS_SEMANTIC_ID varchar(3),
  STATUS_ID varchar(50),
  IS_NEW char(1),
  IS_JUNK char(1),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_inv_status_history_type_id_created_date_status_id_owne ON b_crm_inv_status_history (type_id, created_date, status_id, owner_id, responsible_id);
CREATE INDEX ix_b_crm_inv_status_history_is_junk_status_id_created_date_owne ON b_crm_inv_status_history (is_junk, status_id, created_date, owner_id, responsible_id);
CREATE INDEX ix_b_crm_inv_status_history_activity_date_owner_id ON b_crm_inv_status_history (activity_date, owner_id);
CREATE INDEX ix_b_crm_inv_status_history_status_semantic_id_activity_date_ow ON b_crm_inv_status_history (status_semantic_id, activity_date, owner_id);
CREATE INDEX ix_b_crm_inv_status_history_owner_id_activity_date ON b_crm_inv_status_history (owner_id, activity_date);

CREATE TABLE IF NOT EXISTS b_crm_invoice_sum_stat (
  OWNER_ID int8 NOT NULL,
  CREATED_DATE date NOT NULL,
  BILL_DATE date NOT NULL,
  PAY_BEFORE_DATE date NOT NULL,
  PAID_DATE date,
  IS_PAID_INTIME char(1),
  CLOSED_DATE date,
  RESPONSIBLE_ID int8 NOT NULL,
  COMPANY_ID int8,
  CONTACT_ID int8,
  STATUS_SEMANTIC_ID varchar(3),
  STATUS_ID varchar(50),
  IS_JUNK char(1),
  CURRENCY_ID char(3),
  SUM_TOTAL decimal,
  UF_SUM_1 decimal,
  UF_SUM_2 decimal,
  UF_SUM_3 decimal,
  UF_SUM_4 decimal,
  UF_SUM_5 decimal,
  UF_ATTR_1 int,
  PRIMARY KEY (OWNER_ID, CREATED_DATE)
);
CREATE INDEX ix_b_crm_invoice_sum_stat_created_date_owner_id_responsible_id ON b_crm_invoice_sum_stat (created_date, owner_id, responsible_id);
CREATE INDEX ix_b_crm_invoice_sum_stat_status_semantic_id_created_date_owner ON b_crm_invoice_sum_stat (status_semantic_id, created_date, owner_id);
CREATE INDEX ix_b_crm_invoice_sum_stat_status_semantic_id_pay_before_date ON b_crm_invoice_sum_stat (status_semantic_id, pay_before_date);
CREATE INDEX ix_b_crm_invoice_sum_stat_company_id_status_semantic_id_is_paid ON b_crm_invoice_sum_stat (company_id, status_semantic_id, is_paid_intime);
CREATE INDEX ix_b_crm_invoice_sum_stat_contact_id_status_semantic_id_is_paid ON b_crm_invoice_sum_stat (contact_id, status_semantic_id, is_paid_intime);

CREATE TABLE IF NOT EXISTS b_crm_requisite (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int8 NOT NULL,
  PRESET_ID int8 NOT NULL DEFAULT 0,
  DATE_CREATE timestamp NOT NULL,
  DATE_MODIFY timestamp,
  CREATED_BY_ID int8 NOT NULL,
  MODIFY_BY_ID int8 DEFAULT NULL,
  NAME varchar(255) NOT NULL,
  CODE varchar(45),
  XML_ID varchar(45),
  ORIGINATOR_ID varchar(255),
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  ADDRESS_ONLY char(1) NOT NULL DEFAULT 'N',
  SORT int NOT NULL DEFAULT 500,
  RQ_NAME varchar(150),
  RQ_FIRST_NAME varchar(50),
  RQ_LAST_NAME varchar(50),
  RQ_SECOND_NAME varchar(50),
  RQ_COMPANY_ID varchar(255),
  RQ_COMPANY_NAME varchar(255),
  RQ_COMPANY_FULL_NAME varchar(300),
  RQ_COMPANY_REG_DATE varchar(30),
  RQ_DIRECTOR varchar(150),
  RQ_ACCOUNTANT varchar(150),
  RQ_CEO_NAME varchar(150),
  RQ_CEO_WORK_POS varchar(150),
  RQ_CONTACT varchar(150),
  RQ_EMAIL varchar(255),
  RQ_PHONE varchar(30),
  RQ_FAX varchar(30),
  RQ_IDENT_DOC varchar(255),
  RQ_IDENT_DOC_SER varchar(25),
  RQ_IDENT_DOC_NUM varchar(25),
  RQ_IDENT_DOC_PERS_NUM varchar(25),
  RQ_IDENT_DOC_DATE varchar(30),
  RQ_IDENT_DOC_ISSUED_BY varchar(255),
  RQ_IDENT_DOC_DEP_CODE varchar(25),
  RQ_INN varchar(15),
  RQ_KPP varchar(9),
  RQ_USRLE varchar(20),
  RQ_IFNS varchar(255),
  RQ_OGRN varchar(13),
  RQ_OGRNIP varchar(15),
  RQ_OKPO varchar(12),
  RQ_OKTMO varchar(11),
  RQ_OKVED varchar(255),
  RQ_EDRPOU varchar(10),
  RQ_DRFO varchar(10),
  RQ_KBE varchar(2),
  RQ_IIN varchar(12),
  RQ_BIN varchar(12),
  RQ_ST_CERT_SER varchar(10),
  RQ_ST_CERT_NUM varchar(15),
  RQ_ST_CERT_DATE varchar(30),
  RQ_VAT_PAYER char(1) NOT NULL DEFAULT 'N',
  RQ_VAT_ID varchar(20),
  RQ_VAT_CERT_SER varchar(10),
  RQ_VAT_CERT_NUM varchar(15),
  RQ_VAT_CERT_DATE varchar(30),
  RQ_RESIDENCE_COUNTRY varchar(128),
  RQ_BASE_DOC varchar(255),
  RQ_REGON varchar(9),
  RQ_KRS varchar(10),
  RQ_PESEL varchar(11),
  RQ_LEGAL_FORM varchar(80),
  RQ_SIRET varchar(20),
  RQ_SIREN varchar(15),
  RQ_CAPITAL varchar(30),
  RQ_RCS varchar(50),
  RQ_CNPJ varchar(20),
  RQ_STATE_REG varchar(25),
  RQ_MNPL_REG varchar(20),
  RQ_CPF varchar(20),
  RQ_IDENT_TYPE varchar(50),
  RQ_SIGNATURE int,
  RQ_STAMP int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_requisite_rq_name ON b_crm_requisite (rq_name);
CREATE INDEX ix_b_crm_requisite_rq_last_name_rq_first_name_rq_second_name ON b_crm_requisite (rq_last_name, rq_first_name, rq_second_name);
CREATE INDEX ix_b_crm_requisite_rq_company_name ON b_crm_requisite (rq_company_name);
CREATE INDEX ix_b_crm_requisite_rq_director ON b_crm_requisite (rq_director);
CREATE INDEX ix_b_crm_requisite_rq_accountant ON b_crm_requisite (rq_accountant);
CREATE INDEX ix_b_crm_requisite_rq_ceo_name ON b_crm_requisite (rq_ceo_name);
CREATE INDEX ix_b_crm_requisite_rq_contact ON b_crm_requisite (rq_contact);
CREATE INDEX ix_b_crm_requisite_rq_email ON b_crm_requisite (rq_email);
CREATE INDEX ix_b_crm_requisite_rq_phone ON b_crm_requisite (rq_phone);
CREATE INDEX ix_b_crm_requisite_rq_fax ON b_crm_requisite (rq_fax);
CREATE INDEX ix_b_crm_requisite_rq_ident_doc_num_rq_ident_doc_ser ON b_crm_requisite (rq_ident_doc_num, rq_ident_doc_ser);
CREATE INDEX ix_b_crm_requisite_rq_ident_doc_dep_code ON b_crm_requisite (rq_ident_doc_dep_code);
CREATE INDEX ix_b_crm_requisite_rq_inn ON b_crm_requisite (rq_inn);
CREATE INDEX ix_b_crm_requisite_rq_kpp ON b_crm_requisite (rq_kpp);
CREATE INDEX ix_b_crm_requisite_rq_usrle ON b_crm_requisite (rq_usrle);
CREATE INDEX ix_b_crm_requisite_rq_ifns ON b_crm_requisite (rq_ifns);
CREATE INDEX ix_b_crm_requisite_rq_ogrn ON b_crm_requisite (rq_ogrn);
CREATE INDEX ix_b_crm_requisite_rq_ogrnip ON b_crm_requisite (rq_ogrnip);
CREATE INDEX ix_b_crm_requisite_rq_okpo ON b_crm_requisite (rq_okpo);
CREATE INDEX ix_b_crm_requisite_rq_oktmo ON b_crm_requisite (rq_oktmo);
CREATE INDEX ix_b_crm_requisite_rq_okved ON b_crm_requisite (rq_okved);
CREATE INDEX ix_b_crm_requisite_rq_edrpou ON b_crm_requisite (rq_edrpou);
CREATE INDEX ix_b_crm_requisite_rq_drfo ON b_crm_requisite (rq_drfo);
CREATE INDEX ix_b_crm_requisite_rq_kbe ON b_crm_requisite (rq_kbe);
CREATE INDEX ix_b_crm_requisite_rq_iin ON b_crm_requisite (rq_iin);
CREATE INDEX ix_b_crm_requisite_rq_bin ON b_crm_requisite (rq_bin);
CREATE INDEX ix_b_crm_requisite_rq_vat_payer ON b_crm_requisite (rq_vat_payer);
CREATE INDEX ix_b_crm_requisite_rq_vat_id ON b_crm_requisite (rq_vat_id);
CREATE INDEX ix_b_crm_requisite_rq_vat_cert_num_rq_vat_cert_ser ON b_crm_requisite (rq_vat_cert_num, rq_vat_cert_ser);
CREATE INDEX ix_b_crm_requisite_rq_residence_country ON b_crm_requisite (rq_residence_country);
CREATE INDEX ix_b_crm_requisite_rq_ident_doc_pers_num ON b_crm_requisite (rq_ident_doc_pers_num);
CREATE INDEX ix_b_crm_requisite_rq_st_cert_num_rq_st_cert_ser ON b_crm_requisite (rq_st_cert_num, rq_st_cert_ser);
CREATE INDEX ix_b_crm_requisite_entity_type_id_preset_id ON b_crm_requisite (entity_type_id, preset_id);
CREATE INDEX ix_b_crm_requisite_entity_type_id_entity_id_preset_id ON b_crm_requisite (entity_type_id, entity_id, preset_id);
CREATE INDEX ix_b_crm_requisite_entity_id_entity_type_id_sort ON b_crm_requisite (entity_id, entity_type_id, sort);
CREATE INDEX ix_b_crm_requisite_rq_regon ON b_crm_requisite (rq_regon);
CREATE INDEX ix_b_crm_requisite_rq_krs ON b_crm_requisite (rq_krs);
CREATE INDEX ix_b_crm_requisite_rq_pesel ON b_crm_requisite (rq_pesel);
CREATE INDEX ix_b_crm_requisite_rq_ident_type ON b_crm_requisite (rq_ident_type);
CREATE INDEX ix_b_crm_requisite_rq_company_id ON b_crm_requisite (rq_company_id);
CREATE INDEX ix_b_crm_requisite_rq_siret ON b_crm_requisite (rq_siret);
CREATE INDEX ix_b_crm_requisite_rq_siren ON b_crm_requisite (rq_siren);
CREATE INDEX ix_b_crm_requisite_rq_rcs ON b_crm_requisite (rq_rcs);
CREATE INDEX ix_b_crm_requisite_rq_cnpj ON b_crm_requisite (rq_cnpj);
CREATE INDEX ix_b_crm_requisite_rq_state_reg ON b_crm_requisite (rq_state_reg);
CREATE INDEX ix_b_crm_requisite_rq_mnpl_reg ON b_crm_requisite (rq_mnpl_reg);
CREATE INDEX ix_b_crm_requisite_rq_cpf ON b_crm_requisite (rq_cpf);
CREATE INDEX ix_b_crm_requisite_preset_id ON b_crm_requisite (preset_id);

CREATE TABLE IF NOT EXISTS b_crm_preset (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  COUNTRY_ID int NOT NULL DEFAULT 0,
  DATE_CREATE timestamp NOT NULL,
  DATE_MODIFY timestamp,
  CREATED_BY_ID int8 NOT NULL,
  MODIFY_BY_ID int8 DEFAULT NULL,
  NAME varchar(255) NOT NULL,
  XML_ID varchar(45),
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  SORT int NOT NULL DEFAULT 500,
  SETTINGS text DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_preset_country_id ON b_crm_preset (country_id);
CREATE INDEX ix_b_crm_preset_entity_type_id ON b_crm_preset (entity_type_id);

CREATE TABLE IF NOT EXISTS b_crm_requisite_cfg (
  ENTITY_ID int NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  SETTINGS text,
  PRIMARY KEY (ENTITY_ID, ENTITY_TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_requisite_link (
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int8 NOT NULL,
  REQUISITE_ID int8 NOT NULL DEFAULT 0,
  BANK_DETAIL_ID int8 NOT NULL DEFAULT 0,
  MC_REQUISITE_ID int8 NOT NULL DEFAULT 0,
  MC_BANK_DETAIL_ID int8 NOT NULL DEFAULT 0,
  PRIMARY KEY (ENTITY_TYPE_ID, ENTITY_ID)
);
CREATE INDEX ix_b_crm_requisite_link_mc_requisite_id ON b_crm_requisite_link (mc_requisite_id);
CREATE INDEX ix_b_crm_requisite_link_requisite_id_mc_requisite_id ON b_crm_requisite_link (requisite_id, mc_requisite_id);

CREATE TABLE IF NOT EXISTS b_crm_bank_detail (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int8 NOT NULL,
  COUNTRY_ID int NOT NULL DEFAULT 0,
  DATE_CREATE timestamp NOT NULL,
  DATE_MODIFY timestamp,
  CREATED_BY_ID int8 NOT NULL,
  MODIFY_BY_ID int8 DEFAULT NULL,
  NAME varchar(255) NOT NULL,
  CODE varchar(45),
  XML_ID varchar(45),
  ORIGINATOR_ID varchar(255),
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  SORT int NOT NULL DEFAULT 500,
  RQ_BANK_NAME varchar(255),
  RQ_BANK_CODE varchar(50),
  RQ_BANK_ADDR varchar(255),
  RQ_BANK_ROUTE_NUM varchar(9),
  RQ_BIK varchar(11),
  RQ_MFO varchar(6),
  RQ_ACC_NAME varchar(150),
  RQ_ACC_NUM varchar(34),
  RQ_ACC_TYPE varchar(50),
  RQ_IIK varchar(20),
  RQ_ACC_CURRENCY varchar(100),
  RQ_COR_ACC_NUM varchar(34),
  RQ_IBAN varchar(34),
  RQ_SWIFT varchar(11),
  RQ_BIC varchar(11),
  RQ_CODEB varchar(5),
  RQ_CODEG varchar(5),
  RQ_RIB varchar(2),
  RQ_AGENCY_NAME varchar(50),
  COMMENTS varchar(500),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_bank_detail_rq_bank_name ON b_crm_bank_detail (rq_bank_name);
CREATE INDEX ix_b_crm_bank_detail_rq_bank_addr ON b_crm_bank_detail (rq_bank_addr);
CREATE INDEX ix_b_crm_bank_detail_rq_bank_route_num ON b_crm_bank_detail (rq_bank_route_num);
CREATE INDEX ix_b_crm_bank_detail_rq_bik ON b_crm_bank_detail (rq_bik);
CREATE INDEX ix_b_crm_bank_detail_rq_mfo ON b_crm_bank_detail (rq_mfo);
CREATE INDEX ix_b_crm_bank_detail_rq_acc_name ON b_crm_bank_detail (rq_acc_name);
CREATE INDEX ix_b_crm_bank_detail_rq_acc_num ON b_crm_bank_detail (rq_acc_num);
CREATE INDEX ix_b_crm_bank_detail_rq_iik ON b_crm_bank_detail (rq_iik);
CREATE INDEX ix_b_crm_bank_detail_rq_acc_currency ON b_crm_bank_detail (rq_acc_currency);
CREATE INDEX ix_b_crm_bank_detail_rq_cor_acc_num ON b_crm_bank_detail (rq_cor_acc_num);
CREATE INDEX ix_b_crm_bank_detail_rq_iban ON b_crm_bank_detail (rq_iban);
CREATE INDEX ix_b_crm_bank_detail_rq_swift ON b_crm_bank_detail (rq_swift);
CREATE INDEX ix_b_crm_bank_detail_rq_bic ON b_crm_bank_detail (rq_bic);
CREATE INDEX ix_b_crm_bank_detail_entity_id_entity_type_id_sort ON b_crm_bank_detail (entity_id, entity_type_id, sort);
CREATE INDEX ix_b_crm_bank_detail_rq_codeb ON b_crm_bank_detail (rq_codeb);
CREATE INDEX ix_b_crm_bank_detail_rq_codeg ON b_crm_bank_detail (rq_codeg);

CREATE TABLE IF NOT EXISTS b_crm_contact_company (
  CONTACT_ID int8 NOT NULL,
  COMPANY_ID int8 NOT NULL,
  SORT int NOT NULL,
  ROLE_ID smallint NOT NULL,
  IS_PRIMARY char(1) NOT NULL,
  PRIMARY KEY (CONTACT_ID, COMPANY_ID)
);
CREATE INDEX ix_b_crm_contact_company_company_id_contact_id ON b_crm_contact_company (company_id, contact_id);
CREATE INDEX ix_b_crm_contact_company_contact_id_is_primary_company_id ON b_crm_contact_company (contact_id, is_primary, company_id);
CREATE INDEX ix_b_crm_contact_company_contact_id_sort_company_id ON b_crm_contact_company (contact_id, sort, company_id);

CREATE TABLE IF NOT EXISTS b_crm_deal_contact (
  DEAL_ID int8 NOT NULL,
  CONTACT_ID int8 NOT NULL,
  SORT int NOT NULL,
  ROLE_ID smallint NOT NULL,
  IS_PRIMARY char(1) NOT NULL,
  PRIMARY KEY (DEAL_ID, CONTACT_ID)
);
CREATE INDEX ix_b_crm_deal_contact_contact_id_deal_id ON b_crm_deal_contact (contact_id, deal_id);
CREATE INDEX ix_b_crm_deal_contact_deal_id_is_primary_contact_id ON b_crm_deal_contact (deal_id, is_primary, contact_id);
CREATE INDEX ix_b_crm_deal_contact_deal_id_sort_contact_id ON b_crm_deal_contact (deal_id, sort, contact_id);

CREATE TABLE IF NOT EXISTS b_crm_quote_contact (
  QUOTE_ID int8 NOT NULL,
  CONTACT_ID int8 NOT NULL,
  SORT int NOT NULL,
  ROLE_ID smallint NOT NULL,
  IS_PRIMARY char(1) NOT NULL,
  PRIMARY KEY (QUOTE_ID, CONTACT_ID)
);
CREATE INDEX ix_b_crm_quote_contact_contact_id_quote_id ON b_crm_quote_contact (contact_id, quote_id);
CREATE INDEX ix_b_crm_quote_contact_quote_id_is_primary_contact_id ON b_crm_quote_contact (quote_id, is_primary, contact_id);
CREATE INDEX ix_b_crm_quote_contact_quote_id_sort_contact_id ON b_crm_quote_contact (quote_id, sort, contact_id);

CREATE TABLE IF NOT EXISTS b_crm_entity_cfg (
  ENTITY_ID int NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  USER_ID int NOT NULL,
  SETTINGS text,
  PRIMARY KEY (ENTITY_ID, ENTITY_TYPE_ID, USER_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_webform (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LANGUAGE_ID char(2),
  TYPE_ID int NOT NULL DEFAULT 0,
  NAME varchar(255) NOT NULL,
  DESCRIPTION text DEFAULT NULL,
  BUTTON_CAPTION varchar(255) DEFAULT NULL,
  TEMPLATE_ID varchar(255) DEFAULT NULL,
  IS_PAY char(1) NOT NULL,
  GOOGLE_ANALYTICS_ID varchar(50) DEFAULT NULL,
  YANDEX_METRIC_ID varchar(50) DEFAULT NULL,
  SECURITY_CODE varchar(32) DEFAULT NULL,
  BUTTON_COLOR_FONT varchar(10) DEFAULT NULL,
  BUTTON_COLOR_BG varchar(10) DEFAULT NULL,
  CSS_PATH varchar(255) DEFAULT NULL,
  DATE_CREATE timestamp NOT NULL,
  ENTITY_SCHEME int NOT NULL,
  GOOGLE_ANALYTICS_PAGE_VIEW char(1) NOT NULL DEFAULT 'N',
  CAPTION varchar(255) DEFAULT NULL,
  RESULT_SUCCESS_TEXT varchar(255) DEFAULT NULL,
  RESULT_SUCCESS_URL varchar(500) DEFAULT NULL,
  RESULT_FAILURE_TEXT varchar(255) DEFAULT NULL,
  RESULT_FAILURE_URL varchar(500) DEFAULT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'N',
  CSS_TEXT text,
  ACTIVE_CHANGE_BY int DEFAULT NULL,
  ACTIVE_CHANGE_DATE timestamp,
  IS_SYSTEM char(1) NOT NULL DEFAULT 'N',
  COPYRIGHT_REMOVED char(1) NOT NULL DEFAULT 'N',
  USE_CAPTCHA char(1) NOT NULL DEFAULT 'N',
  BACKGROUND_IMAGE int DEFAULT NULL,
  CODE varchar(255) DEFAULT NULL,
  OPENLINE_ID int DEFAULT NULL,
  DUPLICATE_MODE varchar(20) DEFAULT NULL,
  XML_ID varchar(50) DEFAULT NULL,
  USE_LICENCE char(1) NOT NULL DEFAULT 'N',
  AGREEMENT_ID int DEFAULT NULL,
  LICENCE_TEXT text,
  LICENCE_BUTTON_CAPTION varchar(255) DEFAULT NULL,
  LICENCE_BUTTON_IS_CHECKED char(1) NOT NULL DEFAULT 'N',
  SCRIPT_INCLUDE_SETTINGS text,
  INVOICE_SETTINGS text,
  FORM_SETTINGS text,
  IS_CALLBACK_FORM char(1) NOT NULL DEFAULT 'N',
  IS_WHATSAPP_FORM char(1) NOT NULL DEFAULT 'N',
  CALL_FROM varchar(50) DEFAULT NULL,
  CALL_TEXT text,
  ASSIGNED_BY_ID int DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_webform_code ON b_crm_webform (code);

CREATE TABLE IF NOT EXISTS b_crm_webform_counter (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FORM_ID int NOT NULL,
  DATE_CREATE timestamp,
  VIEWS int DEFAULT 0,
  START_FILL int DEFAULT 0,
  END_FILL int DEFAULT 0,
  MONEY int DEFAULT 0,
  ENTITY_CONTACT int DEFAULT 0,
  ENTITY_COMPANY int DEFAULT 0,
  ENTITY_DEAL int DEFAULT 0,
  ENTITY_LEAD int DEFAULT 0,
  ENTITY_QUOTE int DEFAULT 0,
  ENTITY_INVOICE int DEFAULT 0,
  ENTITY_DYNAMIC int DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_webform_counter_form_id ON b_crm_webform_counter (form_id);

CREATE TABLE IF NOT EXISTS b_crm_webform_counter_daily (
  DATE_STAT date NOT NULL,
  FORM_ID int NOT NULL,
  VIEWS int NOT NULL DEFAULT 0,
  START_FILL int NOT NULL DEFAULT 0,
  END_FILL int NOT NULL DEFAULT 0,
  PRIMARY KEY (DATE_STAT, FORM_ID)
);

CREATE TABLE b_crm_webform_start_edit (
  FORM_ID int NOT NULL,
  DATE_CREATE timestamp
);
CREATE INDEX ix_b_crm_webform_start_edit_form_id_date_create ON b_crm_webform_start_edit (form_id, date_create);

CREATE TABLE IF NOT EXISTS b_crm_webform_field (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TYPE varchar(50) DEFAULT NULL,
  CODE varchar(255) DEFAULT NULL,
  CAPTION varchar(255) DEFAULT NULL,
  FORM_ID int NOT NULL,
  GROUP_ID int,
  SORT int NOT NULL DEFAULT '100',
  REQUIRED char(1) DEFAULT 'N',
  PLACEHOLDER varchar(255) DEFAULT NULL,
  MULTIPLE char(1) NOT NULL DEFAULT 'N',
  ITEMS text NOT NULL,
  VALUE_TYPE varchar(50) DEFAULT NULL,
  VALUE varchar(255) DEFAULT NULL,
  SETTINGS_DATA text DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_webform_field_form_id ON b_crm_webform_field (form_id);

CREATE TABLE IF NOT EXISTS b_crm_webform_field_dep (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FORM_ID int NOT NULL,
  GROUP_ID int8 NOT NULL DEFAULT 0,
  IF_FIELD_CODE varchar(255) DEFAULT NULL,
  IF_ACTION varchar(20) NOT NULL,
  IF_VALUE varchar(255) DEFAULT NULL,
  IF_VALUE_OPERATION varchar(10) DEFAULT NULL,
  DO_FIELD_CODE varchar(255) DEFAULT NULL,
  DO_ACTION varchar(20) NOT NULL,
  DO_VALUE varchar(255) DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_webform_field_dep_form_id ON b_crm_webform_field_dep (form_id);

CREATE TABLE IF NOT EXISTS b_crm_webform_field_dep_group (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FORM_ID int8 NOT NULL,
  TYPE_ID int8 NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_webform_field_dep_group_form_id ON b_crm_webform_field_dep_group (form_id);

CREATE TABLE IF NOT EXISTS b_crm_webform_field_preset (
  FORM_ID int NOT NULL,
  ENTITY_NAME varchar(25) NOT NULL,
  FIELD_NAME varchar(255) NOT NULL,
  VALUE varchar(255) DEFAULT NULL
);
CREATE INDEX ix_b_crm_webform_field_preset_form_id ON b_crm_webform_field_preset (form_id);

CREATE TABLE IF NOT EXISTS b_crm_webform_result (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  FORM_ID int NOT NULL,
  ORIGIN_ID varchar(50) DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_webform_result_form_id_origin_id ON b_crm_webform_result (form_id, origin_id);
CREATE INDEX ix_b_crm_webform_result_form_id_date_insert ON b_crm_webform_result (form_id, date_insert);

CREATE TABLE IF NOT EXISTS b_crm_webform_result_entity (
  FORM_ID int NOT NULL,
  RESULT_ID int NOT NULL,
  ENTITY_NAME varchar(20) NOT NULL,
  ITEM_ID int NOT NULL
);
CREATE INDEX ix_b_crm_webform_result_entity_result_id ON b_crm_webform_result_entity (result_id);
CREATE INDEX ix_b_crm_webform_result_entity_entity_name_item_id ON b_crm_webform_result_entity (entity_name, item_id);

CREATE TABLE IF NOT EXISTS b_crm_webform_queue (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FORM_ID int NOT NULL,
  USER_ID int NOT NULL,
  WORK_TIME char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_webform_queue_form_id ON b_crm_webform_queue (form_id);

CREATE TABLE IF NOT EXISTS b_crm_webform_agreement (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FORM_ID int8 NOT NULL,
  AGREEMENT_ID int8 NOT NULL,
  CHECKED char(1) NOT NULL DEFAULT 'N',
  REQUIRED char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_webform_agreement_form_id ON b_crm_webform_agreement (form_id);

CREATE TABLE IF NOT EXISTS b_crm_webform_landing (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FORM_ID int8 NOT NULL,
  LANDING_ID int8 NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_webform_landing_form_id ON b_crm_webform_landing (form_id);

CREATE TABLE IF NOT EXISTS b_crm_webpack (
  ENTITY_TYPE varchar(15) NOT NULL,
  ENTITY_ID int NOT NULL,
  FILE_ID int NOT NULL,
  PRIMARY KEY (ENTITY_TYPE, ENTITY_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_ads_form_link (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_INSERT timestamp,
  LINK_DIRECTION int NOT NULL DEFAULT 0,
  WEBFORM_ID int NOT NULL,
  ADS_TYPE varchar(20) NOT NULL,
  ADS_ACCOUNT_ID varchar(50) NOT NULL,
  ADS_ACCOUNT_NAME varchar(50),
  ADS_FORM_ID varchar(50) NOT NULL,
  ADS_FORM_NAME varchar(50),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_ads_form_link_webform_id_link_direction ON b_crm_ads_form_link (webform_id, link_direction);

CREATE TABLE IF NOT EXISTS b_crm_ps_rq_conv_relation (
  ENTITY_ID int8 NOT NULL,
  COMPANY_ID int8 NOT NULL DEFAULT 0,
  REQUISITE_ID int8 NOT NULL DEFAULT 0,
  BANK_DETAIL_ID int8 NOT NULL DEFAULT 0,
  PRIMARY KEY (ENTITY_ID)
);
CREATE INDEX ix_b_crm_ps_rq_conv_relation_requisite_id ON b_crm_ps_rq_conv_relation (requisite_id);

CREATE TABLE IF NOT EXISTS b_crm_act_mail_meta (
  ACTIVITY_ID int8 NOT NULL,
  MSG_ID_HASH varchar(40),
  MSG_INREPLY_HASH varchar(40),
  MSG_HEADER_HASH varchar(40),
  PRIMARY KEY (ACTIVITY_ID)
);
CREATE INDEX ix_b_crm_act_mail_meta_msg_id_hash ON b_crm_act_mail_meta (msg_id_hash);
CREATE INDEX ix_b_crm_act_mail_meta_msg_header_hash ON b_crm_act_mail_meta (msg_header_hash);
CREATE INDEX ix_b_crm_act_mail_meta_msg_inreply_hash ON b_crm_act_mail_meta (msg_inreply_hash);

CREATE TABLE IF NOT EXISTS b_crm_act_mail_body (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  BODY bytea,
  BODY_HASH varchar(40),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_act_mail_body_body_hash ON b_crm_act_mail_body (body_hash);

CREATE TABLE IF NOT EXISTS b_crm_deal_category (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CREATED_DATE date NOT NULL,
  NAME varchar(255) NOT NULL,
  IS_LOCKED char(1) NOT NULL DEFAULT 'N',
  SORT int NOT NULL,
  ORIGIN_ID varchar(255) DEFAULT NULL,
  ORIGINATOR_ID varchar(255) DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_deal_category_sort ON b_crm_deal_category (sort);
CREATE INDEX ix_b_crm_deal_category_is_locked_sort ON b_crm_deal_category (is_locked, sort);

CREATE TABLE IF NOT EXISTS b_crm_company_act_stat (
  OWNER_ID int8 NOT NULL,
  DEADLINE_DATE date NOT NULL,
  PROVIDER_ID varchar(100) NOT NULL,
  PROVIDER_TYPE_ID varchar(100) NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  TOTAL_QTY int8,
  PRIMARY KEY (OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID)
);
CREATE INDEX ix_b_crm_company_act_stat_responsible_id_deadline_date_owner_id ON b_crm_company_act_stat (responsible_id, deadline_date, owner_id, provider_id, provider_type_id, total_qty);
CREATE INDEX ix_b_crm_company_act_stat_deadline_date_owner_id_provider_id_pr ON b_crm_company_act_stat (deadline_date, owner_id, provider_id, provider_type_id, total_qty);

CREATE TABLE IF NOT EXISTS b_crm_company_act_sts_stat (
  OWNER_ID int8 NOT NULL,
  DEADLINE_DATE date NOT NULL,
  PROVIDER_ID varchar(100) NOT NULL,
  PROVIDER_TYPE_ID varchar(100) NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  ANSWERED_QTY int8,
  UNANSWERED_QTY int8,
  PRIMARY KEY (OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID)
);
CREATE INDEX ix_b_crm_company_act_sts_stat_responsible_id_deadline_date_owne ON b_crm_company_act_sts_stat (responsible_id, deadline_date, owner_id, provider_id, provider_type_id, answered_qty, unanswered_qty);
CREATE INDEX ix_b_crm_company_act_sts_stat_deadline_date_owner_id_provider_i ON b_crm_company_act_sts_stat (deadline_date, owner_id, provider_id, provider_type_id, answered_qty, unanswered_qty);

CREATE TABLE IF NOT EXISTS b_crm_company_act_mark_stat (
  OWNER_ID int8 NOT NULL,
  DEADLINE_DATE date NOT NULL,
  PROVIDER_ID varchar(100) NOT NULL,
  PROVIDER_TYPE_ID varchar(50) NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  SOURCE_ID varchar(100) NOT NULL,
  NONE_QTY int8,
  POSITIVE_QTY int8,
  NEGATIVE_QTY int8,
  PRIMARY KEY (OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID, SOURCE_ID)
);
CREATE INDEX ix_b_crm_company_act_mark_stat_responsible_id_deadline_date_own ON b_crm_company_act_mark_stat (responsible_id, deadline_date, owner_id, provider_id, provider_type_id, source_id, none_qty, positive_qty, negative_qty);
CREATE INDEX ix_b_crm_company_act_mark_stat_deadline_date_owner_id_provider_ ON b_crm_company_act_mark_stat (deadline_date, owner_id, provider_id, provider_type_id, source_id, none_qty, positive_qty, negative_qty);

CREATE TABLE IF NOT EXISTS b_crm_company_act_stm_stat (
  OWNER_ID int8 NOT NULL,
  DEADLINE_DATE date NOT NULL,
  PROVIDER_ID varchar(100) NOT NULL,
  PROVIDER_TYPE_ID varchar(100) NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  INCOMING_QTY int8,
  OUTGOING_QTY int8,
  REVERSING_QTY int8,
  MISSING_QTY int8,
  PRIMARY KEY (OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID)
);
CREATE INDEX ix_b_crm_company_act_stm_stat_responsible_id_deadline_date_owne ON b_crm_company_act_stm_stat (responsible_id, deadline_date, owner_id, provider_id, provider_type_id, incoming_qty, outgoing_qty, reversing_qty, missing_qty);
CREATE INDEX ix_b_crm_company_act_stm_stat_deadline_date_owner_id_provider_i ON b_crm_company_act_stm_stat (deadline_date, owner_id, provider_id, provider_type_id, incoming_qty, outgoing_qty, reversing_qty, missing_qty);

CREATE TABLE IF NOT EXISTS b_crm_company_act_sum_stat (
  OWNER_ID int8 NOT NULL,
  DEADLINE_DATE date NOT NULL,
  PROVIDER_ID varchar(100) NOT NULL,
  PROVIDER_TYPE_ID varchar(100) NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  CURRENCY_ID char(3),
  SUM_TOTAL decimal,
  PRIMARY KEY (OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID)
);
CREATE INDEX ix_b_crm_company_act_sum_stat_responsible_id_deadline_date_owne ON b_crm_company_act_sum_stat (responsible_id, deadline_date, owner_id, provider_id, provider_type_id);
CREATE INDEX ix_b_crm_company_act_sum_stat_deadline_date_owner_id_provider_i ON b_crm_company_act_sum_stat (deadline_date, owner_id, provider_id, provider_type_id);

CREATE TABLE IF NOT EXISTS b_crm_company_growth_stat (
  OWNER_ID int8 NOT NULL,
  CREATED_DATE date NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  PRIMARY KEY (OWNER_ID, CREATED_DATE)
);
CREATE INDEX ix_b_crm_company_growth_stat_created_date_owner_id ON b_crm_company_growth_stat (created_date, owner_id);
CREATE INDEX ix_b_crm_company_growth_stat_responsible_id_created_date_owner_ ON b_crm_company_growth_stat (responsible_id, created_date, owner_id);

CREATE TABLE IF NOT EXISTS b_crm_contact_act_stat (
  OWNER_ID int8 NOT NULL,
  DEADLINE_DATE date NOT NULL,
  PROVIDER_ID varchar(100) NOT NULL,
  PROVIDER_TYPE_ID varchar(100) NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  TOTAL_QTY int8,
  PRIMARY KEY (OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID)
);
CREATE INDEX ix_b_crm_contact_act_stat_responsible_id_deadline_date_owner_id ON b_crm_contact_act_stat (responsible_id, deadline_date, owner_id, provider_id, provider_type_id, total_qty);
CREATE INDEX ix_b_crm_contact_act_stat_deadline_date_owner_id_provider_id_pr ON b_crm_contact_act_stat (deadline_date, owner_id, provider_id, provider_type_id, total_qty);

CREATE TABLE IF NOT EXISTS b_crm_contact_act_sts_stat (
  OWNER_ID int8 NOT NULL,
  DEADLINE_DATE date NOT NULL,
  PROVIDER_ID varchar(100) NOT NULL,
  PROVIDER_TYPE_ID varchar(100) NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  ANSWERED_QTY int8,
  UNANSWERED_QTY int8,
  PRIMARY KEY (OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID)
);
CREATE INDEX ix_b_crm_contact_act_sts_stat_responsible_id_deadline_date_owne ON b_crm_contact_act_sts_stat (responsible_id, deadline_date, owner_id, provider_id, provider_type_id, answered_qty, unanswered_qty);
CREATE INDEX ix_b_crm_contact_act_sts_stat_deadline_date_owner_id_provider_i ON b_crm_contact_act_sts_stat (deadline_date, owner_id, provider_id, provider_type_id, answered_qty, unanswered_qty);

CREATE TABLE IF NOT EXISTS b_crm_contact_act_mark_stat (
  OWNER_ID int8 NOT NULL,
  DEADLINE_DATE date NOT NULL,
  PROVIDER_ID varchar(100) NOT NULL,
  PROVIDER_TYPE_ID varchar(50) NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  SOURCE_ID varchar(100) NOT NULL,
  NONE_QTY int8,
  POSITIVE_QTY int8,
  NEGATIVE_QTY int8,
  PRIMARY KEY (OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID, SOURCE_ID)
);
CREATE INDEX ix_b_crm_contact_act_mark_stat_responsible_id_deadline_date_own ON b_crm_contact_act_mark_stat (responsible_id, deadline_date, owner_id, provider_id, provider_type_id, source_id, none_qty, positive_qty, negative_qty);
CREATE INDEX ix_b_crm_contact_act_mark_stat_deadline_date_owner_id_provider_ ON b_crm_contact_act_mark_stat (deadline_date, owner_id, provider_id, provider_type_id, source_id, none_qty, positive_qty, negative_qty);

CREATE TABLE IF NOT EXISTS b_crm_contact_act_stm_stat (
  OWNER_ID int8 NOT NULL,
  DEADLINE_DATE date NOT NULL,
  PROVIDER_ID varchar(100) NOT NULL,
  PROVIDER_TYPE_ID varchar(100) NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  INCOMING_QTY int8,
  OUTGOING_QTY int8,
  REVERSING_QTY int8,
  MISSING_QTY int8,
  PRIMARY KEY (OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID)
);
CREATE INDEX ix_b_crm_contact_act_stm_stat_responsible_id_deadline_date_owne ON b_crm_contact_act_stm_stat (responsible_id, deadline_date, owner_id, provider_id, provider_type_id, incoming_qty, outgoing_qty, reversing_qty, missing_qty);
CREATE INDEX ix_b_crm_contact_act_stm_stat_deadline_date_owner_id_provider_i ON b_crm_contact_act_stm_stat (deadline_date, owner_id, provider_id, provider_type_id, incoming_qty, outgoing_qty, reversing_qty, missing_qty);

CREATE TABLE IF NOT EXISTS b_crm_contact_act_sum_stat (
  OWNER_ID int8 NOT NULL,
  DEADLINE_DATE date NOT NULL,
  PROVIDER_ID varchar(100) NOT NULL,
  PROVIDER_TYPE_ID varchar(100) NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  CURRENCY_ID char(3),
  SUM_TOTAL decimal,
  PRIMARY KEY (OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID)
);
CREATE INDEX ix_b_crm_contact_act_sum_stat_responsible_id_deadline_date_owne ON b_crm_contact_act_sum_stat (responsible_id, deadline_date, owner_id, provider_id, provider_type_id);
CREATE INDEX ix_b_crm_contact_act_sum_stat_deadline_date_owner_id_provider_i ON b_crm_contact_act_sum_stat (deadline_date, owner_id, provider_id, provider_type_id);

CREATE TABLE IF NOT EXISTS b_crm_contact_growth_stat (
  OWNER_ID int8 NOT NULL,
  CREATED_DATE date NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  PRIMARY KEY (OWNER_ID, CREATED_DATE)
);
CREATE INDEX ix_b_crm_contact_growth_stat_created_date_owner_id ON b_crm_contact_growth_stat (created_date, owner_id);
CREATE INDEX ix_b_crm_contact_growth_stat_responsible_id_created_date_owner_ ON b_crm_contact_growth_stat (responsible_id, created_date, owner_id);

CREATE TABLE IF NOT EXISTS b_crm_act_stat (
  OWNER_ID int8 NOT NULL,
  DEADLINE_DATE date NOT NULL,
  PROVIDER_ID varchar(100) NOT NULL,
  PROVIDER_TYPE_ID varchar(50) NOT NULL,
  OWNER_TYPE_ID int NOT NULL,
  RESPONSIBLE_ID int8 NOT NULL,
  COMPLETED char(1),
  STATUS_ID int8,
  MARK_ID int8,
  SOURCE_ID varchar(100) NOT NULL,
  STREAM_ID int8,
  CURRENCY_ID char(3),
  SUM_TOTAL decimal,
  PRIMARY KEY (OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID)
);
CREATE INDEX ix_b_crm_act_stat_responsible_id_deadline_date_owner_id_provide ON b_crm_act_stat (responsible_id, deadline_date, owner_id, provider_id, provider_type_id, completed);
CREATE INDEX ix_b_crm_act_stat_deadline_date_owner_id_provider_id_provider_t ON b_crm_act_stat (deadline_date, owner_id, provider_id, provider_type_id, completed);
CREATE INDEX ix_b_crm_act_stat_responsible_id_deadline_date_owner_id_provi_1 ON b_crm_act_stat (responsible_id, deadline_date, owner_id, provider_id, provider_type_id, status_id);
CREATE INDEX ix_b_crm_act_stat_deadline_date_owner_id_provider_id_provider_1 ON b_crm_act_stat (deadline_date, owner_id, provider_id, provider_type_id, status_id);
CREATE INDEX ix_b_crm_act_stat_responsible_id_deadline_date_owner_id_provi_2 ON b_crm_act_stat (responsible_id, deadline_date, owner_id, provider_id, provider_type_id, stream_id);
CREATE INDEX ix_b_crm_act_stat_deadline_date_owner_id_provider_id_provider_2 ON b_crm_act_stat (deadline_date, owner_id, provider_id, provider_type_id, stream_id);

CREATE TABLE IF NOT EXISTS b_crm_button (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_CREATE timestamp,
  CREATED_BY int DEFAULT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'N',
  ACTIVE_CHANGE_BY int DEFAULT NULL,
  ACTIVE_CHANGE_DATE timestamp,
  NAME varchar(255) NOT NULL,
  BACKGROUND_COLOR varchar(10) DEFAULT NULL,
  ICON_COLOR varchar(10) DEFAULT NULL,
  LOCATION int NOT NULL DEFAULT 1,
  DELAY int NOT NULL DEFAULT 0,
  LANGUAGE_ID char(2) DEFAULT NULL,
  ITEMS text,
  SETTINGS text,
  SECURITY_CODE varchar(32) DEFAULT NULL,
  IS_SYSTEM char(1) NOT NULL DEFAULT 'N',
  XML_ID varchar(50) DEFAULT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_button_avatar (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FILE_ID int NOT NULL,
  DATE_CREATE timestamp NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_button_guest (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  GID varchar(32) NOT NULL,
  DATE_CREATE timestamp NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_button_guest_gid ON b_crm_button_guest (gid);

CREATE TABLE IF NOT EXISTS b_crm_button_guest_entity (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  GUEST_ID int NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  DATE_CREATE timestamp NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_button_guest_entity_guest_id_entity_type_id_entity_id ON b_crm_button_guest_entity (guest_id, entity_type_id, entity_id);

CREATE TABLE b_crm_utm (
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  CODE varchar(45) NOT NULL,
  VALUE varchar(600) NOT NULL,
  PRIMARY KEY (ENTITY_TYPE_ID, ENTITY_ID, CODE)
);

CREATE TABLE IF NOT EXISTS b_crm_invoice_recur (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  INVOICE_ID int NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  NEXT_EXECUTION date,
  LAST_EXECUTION date,
  IS_LIMIT char(1) NOT NULL DEFAULT 'N',
  SEND_BILL char(1) NOT NULL DEFAULT 'N',
  EMAIL_ID int,
  LIMIT_DATE date,
  START_DATE date,
  LIMIT_REPEAT int,
  COUNTER_REPEAT int,
  PARAMS text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_recur_invoice_id ON b_crm_invoice_recur (invoice_id);
CREATE INDEX ix_b_crm_invoice_recur_next_execution ON b_crm_invoice_recur (next_execution);
CREATE INDEX ix_b_crm_invoice_recur_last_execution ON b_crm_invoice_recur (last_execution);
CREATE INDEX ix_b_crm_invoice_recur_limit_date ON b_crm_invoice_recur (limit_date);
CREATE INDEX ix_b_crm_invoice_recur_start_date ON b_crm_invoice_recur (start_date);

CREATE TABLE IF NOT EXISTS b_crm_entity_channel (
  ENTITY_ID int8 NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  TYPE_ID int NOT NULL,
  ORIGIN_ID varchar(32),
  COMPONENT_ID varchar(32),
  PRIMARY KEY (ENTITY_ID, ENTITY_TYPE_ID, TYPE_ID)
);
CREATE INDEX ix_b_crm_entity_channel_entity_id_entity_type_id_type_id_origin ON b_crm_entity_channel (entity_id, entity_type_id, type_id, origin_id, component_id);

CREATE TABLE IF NOT EXISTS b_crm_lead_channel_stat (
  OWNER_ID int8 NOT NULL,
  CREATED_DATE date NOT NULL,
  CHANNEL_TYPE_ID int NOT NULL,
  CHANNEL_ORIGIN_ID varchar(32),
  CHANNEL_COMPONENT_ID varchar(32),
  RESPONSIBLE_ID int8 NOT NULL,
  STATUS_SEMANTIC_ID varchar(3),
  PRIMARY KEY (OWNER_ID, CHANNEL_TYPE_ID)
);
CREATE INDEX ix_b_crm_lead_channel_stat_channel_type_id_channel_origin_id_ch ON b_crm_lead_channel_stat (channel_type_id, channel_origin_id, channel_component_id, status_semantic_id, created_date);

CREATE TABLE IF NOT EXISTS b_crm_deal_channel_stat (
  OWNER_ID int8 NOT NULL,
  CREATED_DATE date NOT NULL,
  START_DATE date NOT NULL,
  END_DATE date NOT NULL,
  CHANNEL_TYPE_ID int NOT NULL,
  CHANNEL_ORIGIN_ID varchar(32),
  CHANNEL_COMPONENT_ID varchar(32),
  RESPONSIBLE_ID int8 NOT NULL,
  CURRENCY_ID char(3),
  SUM_TOTAL decimal,
  STAGE_SEMANTIC_ID varchar(3),
  PRIMARY KEY (OWNER_ID, CHANNEL_TYPE_ID)
);
CREATE INDEX ix_b_crm_deal_channel_stat_channel_type_id_channel_origin_id_ch ON b_crm_deal_channel_stat (channel_type_id, channel_origin_id, channel_component_id, stage_semantic_id, start_date, end_date, sum_total);

CREATE TABLE IF NOT EXISTS b_crm_act_channel_stat (
  OWNER_ID int8 NOT NULL,
  CREATED_DATE date NOT NULL,
  CHANNEL_TYPE_ID int NOT NULL,
  CHANNEL_ORIGIN_ID varchar(32),
  CHANNEL_COMPONENT_ID varchar(32),
  RESPONSIBLE_ID int8 NOT NULL,
  COMPLETED char(1) NOT NULL DEFAULT 'N',
  DIRECTION int NOT NULL,
  PRIMARY KEY (OWNER_ID, CHANNEL_TYPE_ID)
);
CREATE INDEX ix_b_crm_act_channel_stat_channel_type_id_channel_origin_id_cha ON b_crm_act_channel_stat (channel_type_id, channel_origin_id, channel_component_id, created_date);

CREATE TABLE b_crm_ext_channel_connector (
  TYPE_ID varchar(32) NOT NULL,
  NAME varchar(32) NOT NULL,
  APP_ID varchar(128) NOT NULL,
  CHANNEL_ID varchar(64) NOT NULL,
  ORIGINATOR_ID varchar(32) NOT NULL,
  EXTERNAL_SERVER_HOST varchar(128) NOT NULL,
  PRIMARY KEY (TYPE_ID, ORIGINATOR_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_automation_template (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int DEFAULT NULL,
  ENTITY_STATUS varchar(50) NOT NULL,
  TEMPLATE_ID int NOT NULL DEFAULT 0,
  START_RULES text,
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_automation_trigger (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) NOT NULL,
  CODE varchar(30) NOT NULL,
  ENTITY_TYPE_ID int DEFAULT NULL,
  ENTITY_STATUS varchar(50) NOT NULL,
  APPLY_RULES text,
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_automation_trigger_app (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  APP_ID int,
  NAME varchar(255) NOT NULL,
  CODE varchar(30) NOT NULL,
  DATE_CREATE timestamp,
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_kanban_sort (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  PREV_ENTITY_ID int NOT NULL,
  USER_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_kanban_sort_entity_type_id_user_id ON b_crm_kanban_sort (entity_type_id, user_id);
CREATE INDEX ix_b_crm_kanban_sort_entity_id ON b_crm_kanban_sort (entity_id);

CREATE TABLE IF NOT EXISTS b_crm_kanban_supervisor (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID smallint NOT NULL,
  USER_ID int NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_call_list (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_CREATE timestamp,
  CREATED_BY_ID int NOT NULL,
  FILTERED char(1) NOT NULL DEFAULT 'N',
  GRID_ID varchar(255),
  FILTER_PARAMS text,
  ENTITY_TYPE_ID int,
  WEBFORM_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_call_list_date_create ON b_crm_call_list (date_create);

CREATE TABLE IF NOT EXISTS b_crm_call_list_item (
  LIST_ID int NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ELEMENT_ID int NOT NULL,
  STATUS_ID varchar(50) NOT NULL,
  CALL_ID int,
  WEBFORM_RESULT_ID int,
  RANK int,
  PRIMARY KEY (LIST_ID, ENTITY_TYPE_ID, ELEMENT_ID)
);
CREATE INDEX ix_b_crm_call_list_item_list_id_status_id_rank ON b_crm_call_list_item (list_id, status_id, rank);

CREATE TABLE IF NOT EXISTS b_crm_call_list_created (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LIST_ID int NOT NULL,
  ELEMENT_ID int NOT NULL,
  ENTITY_TYPE varchar(50) NOT NULL,
  ENTITY_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_call_list_created_list_id_element_id ON b_crm_call_list_created (list_id, element_id);

CREATE TABLE IF NOT EXISTS b_crm_deal_recur (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DEAL_ID int NOT NULL,
  BASED_ID int,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  NEXT_EXECUTION date,
  LAST_EXECUTION date,
  IS_LIMIT char(1) NOT NULL DEFAULT 'N',
  LIMIT_DATE date,
  START_DATE date,
  LIMIT_REPEAT int,
  COUNTER_REPEAT int,
  CATEGORY_ID int8,
  PARAMS text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_deal_recur_deal_id ON b_crm_deal_recur (deal_id);
CREATE INDEX ix_b_crm_deal_recur_based_id ON b_crm_deal_recur (based_id);
CREATE INDEX ix_b_crm_deal_recur_next_execution ON b_crm_deal_recur (next_execution);
CREATE INDEX ix_b_crm_deal_recur_last_execution ON b_crm_deal_recur (last_execution);
CREATE INDEX ix_b_crm_deal_recur_limit_date ON b_crm_deal_recur (limit_date);
CREATE INDEX ix_b_crm_deal_recur_start_date ON b_crm_deal_recur (start_date);

CREATE TABLE b_crm_timeline (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TYPE_ID int8 NOT NULL,
  TYPE_CATEGORY_ID int8,
  CREATED timestamp NOT NULL,
  AUTHOR_ID int8,
  ASSOCIATED_ENTITY_ID int,
  ASSOCIATED_ENTITY_TYPE_ID int,
  ASSOCIATED_ENTITY_CLASS_NAME varchar(128),
  COMMENT text,
  SETTINGS text,
  SOURCE_ID varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_timeline_associated_entity_id_associated_entity_type_i ON b_crm_timeline (associated_entity_id, associated_entity_type_id);
CREATE INDEX ix_b_crm_timeline_associated_entity_class_name ON b_crm_timeline (associated_entity_class_name);
CREATE INDEX ix_b_crm_timeline_created ON b_crm_timeline (created);
CREATE INDEX ix_b_crm_timeline_type_id_type_category_id ON b_crm_timeline (type_id, type_category_id);
CREATE INDEX ix_b_crm_timeline_source_id_type_id_type_category_id ON b_crm_timeline (source_id, type_id, type_category_id);
CREATE INDEX ix_b_crm_timeline_associated_entity_type_id ON b_crm_timeline (associated_entity_type_id);

CREATE TABLE b_crm_timeline_bind (
  OWNER_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  IS_FIXED char(1),
  PRIMARY KEY (OWNER_ID, ENTITY_ID, ENTITY_TYPE_ID)
);
CREATE INDEX ix_b_crm_timeline_bind_entity_id_entity_type_id_is_fixed ON b_crm_timeline_bind (entity_id, entity_type_id, is_fixed);

CREATE TABLE b_crm_timeline_search (
  OWNER_ID int NOT NULL,
  SEARCH_CONTENT text,
  PRIMARY KEY (OWNER_ID)
);
CREATE INDEX tx_b_crm_timeline_search_search_content ON b_crm_timeline_search USING GIN (to_tsvector('english', search_content));

CREATE TABLE IF NOT EXISTS b_crm_wait (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  OWNER_ID int NOT NULL,
  OWNER_TYPE_ID int NOT NULL,
  AUTHOR_ID int NOT NULL,
  START_TIME timestamp NOT NULL,
  END_TIME timestamp NOT NULL,
  CREATED timestamp NOT NULL,
  DESCRIPTION text,
  COMPLETED char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_wait_owner_id_owner_type_id_completed ON b_crm_wait (owner_id, owner_type_id, completed);

CREATE TABLE IF NOT EXISTS b_crm_widget_saletarget (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TYPE_ID varchar(15) NOT NULL,
  PERIOD_TYPE char(1) NOT NULL,
  PERIOD_YEAR int8 NOT NULL,
  PERIOD_HALF int NOT NULL DEFAULT 0,
  PERIOD_QUARTER int NOT NULL DEFAULT 0,
  PERIOD_MONTH int NOT NULL DEFAULT 0,
  TARGET_TYPE char(1) NOT NULL,
  TARGET_GOAL text NOT NULL,
  CREATED timestamp NOT NULL,
  MODIFIED timestamp NOT NULL,
  AUTHOR_ID int8,
  EDITOR_ID int8,
  LEFT_BORDER int8 NOT NULL DEFAULT 0,
  RIGHT_BORDER int8 NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);

CREATE TABLE b_crm_exclusion (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  TYPE_ID int NOT NULL,
  CODE varchar(255) NOT NULL,
  COMMENT varchar(255),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_exclusion_type_id_code ON b_crm_exclusion (type_id, code);

CREATE TABLE IF NOT EXISTS b_crm_lead_contact (
  LEAD_ID int8 NOT NULL,
  CONTACT_ID int8 NOT NULL,
  SORT int NOT NULL,
  ROLE_ID smallint NOT NULL,
  IS_PRIMARY char(1) NOT NULL,
  PRIMARY KEY (LEAD_ID, CONTACT_ID)
);
CREATE INDEX ix_b_crm_lead_contact_contact_id ON b_crm_lead_contact (contact_id);

CREATE TABLE IF NOT EXISTS b_crm_invoice_basket (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FUSER_ID int NOT NULL,
  ORDER_ID int,
  PRODUCT_ID int NOT NULL,
  PRODUCT_PRICE_ID int,
  PRICE_TYPE_ID int,
  PRICE decimal NOT NULL,
  CURRENCY char(3) NOT NULL,
  BASE_PRICE decimal,
  VAT_INCLUDED char(1) NOT NULL DEFAULT 'Y',
  DATE_INSERT timestamp NOT NULL,
  DATE_UPDATE timestamp NOT NULL,
  DATE_REFRESH timestamp,
  WEIGHT double precision,
  QUANTITY double precision NOT NULL DEFAULT '0',
  LID char(2) NOT NULL,
  DELAY char(1) NOT NULL DEFAULT 'N',
  NAME varchar(255) NOT NULL,
  CAN_BUY char(1) NOT NULL DEFAULT 'Y',
  MARKING_CODE_GROUP varchar(100),
  MODULE varchar(100),
  CALLBACK_FUNC varchar(100),
  NOTES varchar(250),
  ORDER_CALLBACK_FUNC varchar(100),
  DETAIL_PAGE_URL varchar(250),
  DISCOUNT_PRICE decimal NOT NULL,
  CANCEL_CALLBACK_FUNC varchar(100),
  PAY_CALLBACK_FUNC varchar(100),
  PRODUCT_PROVIDER_CLASS varchar(100),
  CATALOG_XML_ID varchar(100),
  PRODUCT_XML_ID varchar(100),
  DISCOUNT_NAME varchar(255),
  DISCOUNT_VALUE char(32),
  DISCOUNT_COUPON char(32),
  VAT_RATE decimal DEFAULT '0.00',
  SUBSCRIBE char(1) NOT NULL DEFAULT 'N',
  DEDUCTED char(1) NOT NULL DEFAULT 'N',
  RESERVED char(1) NOT NULL DEFAULT 'N',
  BARCODE_MULTI char(1) NOT NULL DEFAULT 'N',
  RESERVE_QUANTITY double precision,
  CUSTOM_PRICE char(1) NOT NULL DEFAULT 'N',
  DIMENSIONS varchar(255),
  TYPE int,
  SET_PARENT_ID int,
  MEASURE_CODE int,
  MEASURE_NAME varchar(50),
  RECOMMENDATION varchar(40),
  XML_ID varchar(255),
  SORT int NOT NULL DEFAULT '100',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_basket_lid ON b_crm_invoice_basket (lid);
CREATE INDEX ix_b_crm_invoice_basket_fuser_id ON b_crm_invoice_basket (fuser_id);
CREATE INDEX ix_b_crm_invoice_basket_order_id ON b_crm_invoice_basket (order_id);
CREATE INDEX ix_b_crm_invoice_basket_product_id ON b_crm_invoice_basket (product_id);
CREATE INDEX ix_b_crm_invoice_basket_product_price_id ON b_crm_invoice_basket (product_price_id);
CREATE INDEX ix_b_crm_invoice_basket_product_xml_id_catalog_xml_id ON b_crm_invoice_basket (product_xml_id, catalog_xml_id);
CREATE INDEX ix_b_crm_invoice_basket_date_insert ON b_crm_invoice_basket (date_insert);
CREATE INDEX ix_b_crm_invoice_basket_set_parent_id ON b_crm_invoice_basket (set_parent_id);

CREATE TABLE IF NOT EXISTS b_crm_invoice_basket_props (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  BASKET_ID int NOT NULL,
  NAME varchar(255) NOT NULL,
  VALUE varchar(255),
  CODE varchar(255),
  SORT int NOT NULL DEFAULT '100',
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_basket_props_basket_id ON b_crm_invoice_basket_props (basket_id);
CREATE INDEX ix_b_crm_invoice_basket_props_code ON b_crm_invoice_basket_props (code);

CREATE TABLE IF NOT EXISTS b_crm_invoice (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LID char(2) NOT NULL,
  PERSON_TYPE_ID int NOT NULL,
  PAYED char(1) NOT NULL DEFAULT 'N',
  DATE_PAYED timestamp,
  EMP_PAYED_ID int,
  CANCELED char(1) NOT NULL DEFAULT 'N',
  DATE_CANCELED timestamp,
  EMP_CANCELED_ID int,
  REASON_CANCELED varchar(255),
  STATUS_ID varchar(2) NOT NULL,
  DATE_STATUS timestamp NOT NULL,
  EMP_STATUS_ID int,
  PRICE_DELIVERY decimal NOT NULL DEFAULT '0.0000',
  PRICE_PAYMENT decimal NOT NULL DEFAULT '0.0000',
  ALLOW_DELIVERY char(1) NOT NULL DEFAULT 'N',
  DATE_ALLOW_DELIVERY timestamp,
  EMP_ALLOW_DELIVERY_ID int,
  DEDUCTED char(1) NOT NULL DEFAULT 'N',
  DATE_DEDUCTED timestamp,
  EMP_DEDUCTED_ID int,
  REASON_UNDO_DEDUCTED varchar(255),
  MARKED char(1) NOT NULL DEFAULT 'N',
  DATE_MARKED timestamp,
  EMP_MARKED_ID int,
  REASON_MARKED varchar(255),
  RESERVED char(1) NOT NULL DEFAULT 'N',
  PRICE decimal NOT NULL,
  CURRENCY char(3) NOT NULL,
  DISCOUNT_VALUE decimal NOT NULL DEFAULT '0.0000',
  USER_ID int NOT NULL,
  PAY_SYSTEM_ID int,
  DELIVERY_ID varchar(50),
  DATE_INSERT timestamp NOT NULL,
  DATE_UPDATE timestamp NOT NULL,
  USER_DESCRIPTION varchar(2000),
  ADDITIONAL_INFO varchar(255),
  PS_STATUS char(1),
  PS_STATUS_CODE char(5),
  PS_STATUS_DESCRIPTION varchar(250),
  PS_STATUS_MESSAGE varchar(250),
  PS_SUM decimal,
  PS_CURRENCY char(3),
  PS_RESPONSE_DATE timestamp,
  COMMENTS text,
  TAX_VALUE decimal NOT NULL DEFAULT '0.00',
  STAT_GID varchar(255),
  SUM_PAID decimal NOT NULL DEFAULT '0',
  IS_RECURRING char(1) NOT NULL DEFAULT 'N',
  RECURRING_ID int,
  PAY_VOUCHER_NUM varchar(20),
  PAY_VOUCHER_DATE date,
  LOCKED_BY int,
  DATE_LOCK timestamp,
  RECOUNT_FLAG char(1) NOT NULL DEFAULT 'Y',
  AFFILIATE_ID int,
  DELIVERY_DOC_NUM varchar(20),
  DELIVERY_DOC_DATE date,
  UPDATED_1C char(1) NOT NULL DEFAULT 'N',
  STORE_ID int,
  ORDER_TOPIC varchar(255),
  CREATED_BY int,
  RESPONSIBLE_ID int,
  COMPANY_ID int,
  DATE_PAY_BEFORE timestamp,
  DATE_BILL timestamp,
  ACCOUNT_NUMBER varchar(100),
  TRACKING_NUMBER varchar(255),
  XML_ID varchar(255),
  ID_1C varchar(36),
  VERSION_1C varchar(15),
  VERSION int NOT NULL DEFAULT '0',
  EXTERNAL_ORDER char(1) NOT NULL DEFAULT 'N',
  RUNNING char(1) NOT NULL DEFAULT 'N',
  BX_USER_ID varchar(32),
  SEARCH_CONTENT text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_person_type_id ON b_crm_invoice (person_type_id);
CREATE INDEX ix_b_crm_invoice_status_id ON b_crm_invoice (status_id);
CREATE INDEX ix_b_crm_invoice_recurring_id ON b_crm_invoice (recurring_id);
CREATE INDEX ix_b_crm_invoice_affiliate_id ON b_crm_invoice (affiliate_id);
CREATE INDEX ix_b_crm_invoice_updated_1c ON b_crm_invoice (updated_1c);
CREATE INDEX ix_b_crm_invoice_user_id_lid_payed_canceled ON b_crm_invoice (user_id, lid, payed, canceled);
CREATE INDEX ix_b_crm_invoice_date_update ON b_crm_invoice (date_update);
CREATE INDEX ix_b_crm_invoice_xml_id ON b_crm_invoice (xml_id);
CREATE INDEX ix_b_crm_invoice_id_1c ON b_crm_invoice (id_1c);
CREATE INDEX ix_b_crm_invoice_date_allow_delivery ON b_crm_invoice (date_allow_delivery);
CREATE INDEX ix_b_crm_invoice_allow_delivery ON b_crm_invoice (allow_delivery);
CREATE INDEX ix_b_crm_invoice_date_canceled ON b_crm_invoice (date_canceled);
CREATE INDEX ix_b_crm_invoice_canceled ON b_crm_invoice (canceled);
CREATE INDEX ix_b_crm_invoice_date_payed ON b_crm_invoice (date_payed);
CREATE INDEX ix_b_crm_invoice_date_insert ON b_crm_invoice (date_insert);
CREATE INDEX ix_b_crm_invoice_date_pay_before ON b_crm_invoice (date_pay_before);
CREATE UNIQUE INDEX ux_b_crm_invoice_account_number ON b_crm_invoice (account_number);
CREATE INDEX tx_b_crm_invoice_search_content ON b_crm_invoice USING GIN (to_tsvector('english', search_content));

CREATE TABLE IF NOT EXISTS b_crm_invoice_payment (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  ACCOUNT_NUMBER varchar(100),
  PAID char(1) NOT NULL DEFAULT 'N',
  DATE_PAID timestamp DEFAULT NULL,
  EMP_PAID_ID int DEFAULT NULL,
  PAY_SYSTEM_ID int NOT NULL,
  PS_STATUS char(1) DEFAULT NULL,
  PS_INVOICE_ID varchar(250),
  PS_STATUS_CODE varchar(255) DEFAULT NULL,
  PS_STATUS_DESCRIPTION varchar(512) DEFAULT NULL,
  PS_STATUS_MESSAGE varchar(250) DEFAULT NULL,
  PS_SUM decimal DEFAULT NULL,
  PS_CURRENCY char(3) DEFAULT NULL,
  PS_RESPONSE_DATE timestamp DEFAULT NULL,
  PS_RECURRING_TOKEN varchar(255) DEFAULT NULL,
  PS_CARD_NUMBER varchar(64) DEFAULT NULL,
  PAY_VOUCHER_NUM varchar(20) DEFAULT NULL,
  PAY_VOUCHER_DATE date DEFAULT NULL,
  DATE_PAY_BEFORE timestamp DEFAULT NULL,
  DATE_BILL timestamp DEFAULT NULL,
  XML_ID varchar(255) DEFAULT NULL,
  SUM decimal NOT NULL,
  PRICE_COD decimal NOT NULL DEFAULT 0,
  CURRENCY char(3) NOT NULL,
  PAY_SYSTEM_NAME varchar(128) NOT NULL,
  RESPONSIBLE_ID int DEFAULT NULL,
  DATE_RESPONSIBLE_ID timestamp DEFAULT NULL,
  EMP_RESPONSIBLE_ID int DEFAULT NULL,
  COMMENTS text,
  COMPANY_ID int DEFAULT NULL,
  PAY_RETURN_DATE date DEFAULT NULL,
  EMP_RETURN_ID int DEFAULT NULL,
  PAY_RETURN_NUM varchar(20) DEFAULT NULL,
  PAY_RETURN_COMMENT text,
  IS_RETURN char(1) NOT NULL DEFAULT 'N',
  MARKED char(1) DEFAULT NULL,
  DATE_MARKED timestamp DEFAULT NULL,
  EMP_MARKED_ID int DEFAULT NULL,
  REASON_MARKED varchar(255) DEFAULT NULL,
  ID_1C varchar(36) DEFAULT NULL,
  VERSION_1C varchar(15) DEFAULT NULL,
  EXTERNAL_PAYMENT char(1) NOT NULL DEFAULT 'N',
  UPDATED_1C char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_payment_order_id ON b_crm_invoice_payment (order_id);
CREATE INDEX ix_b_crm_invoice_payment_date_paid ON b_crm_invoice_payment (date_paid);
CREATE INDEX ix_b_crm_invoice_payment_paid ON b_crm_invoice_payment (paid);
CREATE UNIQUE INDEX ux_b_crm_invoice_payment_account_number ON b_crm_invoice_payment (account_number);

CREATE TABLE IF NOT EXISTS b_crm_invoice_delivery (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  ACCOUNT_NUMBER varchar(100),
  DATE_INSERT timestamp NOT NULL,
  DATE_REQUEST timestamp DEFAULT NULL,
  DATE_UPDATE timestamp DEFAULT NULL,
  DELIVERY_LOCATION varchar(50) DEFAULT NULL,
  PARAMS text,
  STATUS_ID varchar(2) NOT NULL,
  PRICE_DELIVERY decimal DEFAULT NULL,
  DISCOUNT_PRICE decimal DEFAULT NULL,
  BASE_PRICE_DELIVERY decimal DEFAULT NULL,
  CUSTOM_PRICE_DELIVERY char(1) DEFAULT NULL,
  ALLOW_DELIVERY char(1) DEFAULT 'N',
  DATE_ALLOW_DELIVERY timestamp DEFAULT NULL,
  EMP_ALLOW_DELIVERY_ID int DEFAULT NULL,
  DEDUCTED char(1) DEFAULT 'N',
  DATE_DEDUCTED timestamp DEFAULT NULL,
  EMP_DEDUCTED_ID int DEFAULT NULL,
  REASON_UNDO_DEDUCTED varchar(255) DEFAULT NULL,
  RESERVED char(1) DEFAULT NULL,
  DELIVERY_ID int NOT NULL,
  DELIVERY_DOC_NUM varchar(20) DEFAULT NULL,
  DELIVERY_DOC_DATE timestamp DEFAULT NULL,
  TRACKING_NUMBER varchar(255) DEFAULT NULL,
  XML_ID varchar(255) DEFAULT NULL,
  DELIVERY_NAME varchar(128) DEFAULT NULL,
  CANCELED char(1) DEFAULT 'N',
  DATE_CANCELED timestamp DEFAULT NULL,
  EMP_CANCELED_ID int DEFAULT NULL,
  REASON_CANCELED varchar(255) DEFAULT '',
  MARKED char(1) DEFAULT NULL,
  DATE_MARKED timestamp DEFAULT NULL,
  EMP_MARKED_ID int DEFAULT NULL,
  REASON_MARKED varchar(255) DEFAULT NULL,
  CURRENCY varchar(3) DEFAULT NULL,
  SYSTEM char(1) NOT NULL DEFAULT 'N',
  WEIGHT double precision DEFAULT 0,
  RESPONSIBLE_ID int DEFAULT NULL,
  EMP_RESPONSIBLE_ID int DEFAULT NULL,
  DATE_RESPONSIBLE_ID timestamp DEFAULT NULL,
  COMMENTS text,
  COMPANY_ID int DEFAULT NULL,
  TRACKING_STATUS int,
  TRACKING_DESCRIPTION varchar(255),
  TRACKING_LAST_CHECK timestamp,
  TRACKING_LAST_CHANGE timestamp,
  ID_1C varchar(36) DEFAULT NULL,
  VERSION_1C varchar(15) DEFAULT NULL,
  EXTERNAL_DELIVERY char(1) NOT NULL DEFAULT 'N',
  UPDATED_1C char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_delivery_order_id ON b_crm_invoice_delivery (order_id);
CREATE INDEX ix_b_crm_invoice_delivery_date_allow_delivery ON b_crm_invoice_delivery (date_allow_delivery);
CREATE INDEX ix_b_crm_invoice_delivery_allow_delivery ON b_crm_invoice_delivery (allow_delivery);
CREATE INDEX ix_b_crm_invoice_delivery_date_canceled ON b_crm_invoice_delivery (date_canceled);
CREATE INDEX ix_b_crm_invoice_delivery_canceled ON b_crm_invoice_delivery (canceled);
CREATE UNIQUE INDEX ux_b_crm_invoice_delivery_account_number ON b_crm_invoice_delivery (account_number);

CREATE TABLE IF NOT EXISTS b_crm_invoice_dlv_basket (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_DELIVERY_ID int NOT NULL,
  BASKET_ID int NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  QUANTITY decimal NOT NULL,
  RESERVED_QUANTITY decimal NOT NULL,
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_dlv_basket_order_delivery_id ON b_crm_invoice_dlv_basket (order_delivery_id);
CREATE INDEX ix_b_crm_invoice_dlv_basket_basket_id ON b_crm_invoice_dlv_basket (basket_id);

CREATE TABLE IF NOT EXISTS b_crm_invoice_props_value (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  ORDER_PROPS_ID int,
  NAME varchar(255) NOT NULL,
  VALUE varchar(500),
  CODE varchar(50),
  XML_ID varchar(255),
  ENTITY_ID int NOT NULL,
  ENTITY_TYPE varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_invoice_props_value_entity_id_entity_type_order_props_ ON b_crm_invoice_props_value (entity_id, entity_type, order_props_id);
CREATE INDEX ix_b_crm_invoice_props_value_order_id_order_props_id ON b_crm_invoice_props_value (order_id, order_props_id);

CREATE TABLE IF NOT EXISTS b_crm_order_props_match (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SALE_PROP_ID int NOT NULL,
  CRM_ENTITY_TYPE int NOT NULL,
  CRM_FIELD_TYPE int NOT NULL,
  CRM_FIELD_CODE varchar(50) NOT NULL,
  SETTINGS text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_order_props_match_sale_prop_id ON b_crm_order_props_match (sale_prop_id);
CREATE INDEX ix_b_crm_order_props_match_crm_entity_type ON b_crm_order_props_match (crm_entity_type);

CREATE TABLE IF NOT EXISTS b_crm_order_props_form_queue (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PERSON_TYPE_ID int NOT NULL,
  USER_ID int NOT NULL,
  WORK_TIME char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_order_props_form_queue_person_type_id ON b_crm_order_props_form_queue (person_type_id);

CREATE TABLE IF NOT EXISTS b_crm_order_props_form (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PERSON_TYPE_ID int NOT NULL,
  DUPLICATE_MODE varchar(20) DEFAULT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_order_contact_company (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int8 NOT NULL,
  ENTITY_ID int8 NOT NULL,
  ENTITY_TYPE_ID int8 NOT NULL,
  SORT int NOT NULL,
  ROLE_ID smallint NOT NULL,
  IS_PRIMARY char(1) NOT NULL,
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_order_contact_company_order_id_entity_id_entity_type_i ON b_crm_order_contact_company (order_id, entity_id, entity_type_id);
CREATE INDEX ix_b_crm_order_contact_company_entity_id_entity_type_id ON b_crm_order_contact_company (entity_id, entity_type_id);

CREATE TABLE IF NOT EXISTS b_crm_invoice_change (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  TYPE varchar(255) NOT NULL,
  DATA varchar(512),
  DATE_CREATE timestamp NOT NULL,
  DATE_MODIFY timestamp NOT NULL,
  USER_ID int NOT NULL,
  ENTITY varchar(50) DEFAULT NULL,
  ENTITY_ID int DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_change_order_id ON b_crm_invoice_change (order_id);
CREATE INDEX ix_b_crm_invoice_change_type ON b_crm_invoice_change (type);

CREATE TABLE IF NOT EXISTS b_crm_invoice_entity_marker (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  ENTITY_TYPE varchar(25) NOT NULL,
  ENTITY_ID int NOT NULL,
  TYPE varchar(10) NOT NULL,
  CODE varchar(255) NOT NULL,
  MESSAGE varchar(255) NOT NULL,
  COMMENT varchar(500) DEFAULT null,
  USER_ID int DEFAULT null,
  DATE_CREATE timestamp DEFAULT null,
  DATE_UPDATE timestamp DEFAULT null,
  SUCCESS char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_entity_marker_type ON b_crm_invoice_entity_marker (type);
CREATE INDEX ix_b_crm_invoice_entity_marker_entity_type ON b_crm_invoice_entity_marker (entity_type);
CREATE INDEX ix_b_crm_invoice_entity_marker_order_id ON b_crm_invoice_entity_marker (order_id);

CREATE TABLE IF NOT EXISTS b_crm_invoice_tax (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  TAX_NAME varchar(255) NOT NULL,
  VALUE decimal,
  VALUE_MONEY decimal NOT NULL,
  APPLY_ORDER int NOT NULL,
  CODE varchar(50),
  IS_PERCENT char(1) NOT NULL DEFAULT 'Y',
  IS_IN_PRICE char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_tax_order_id ON b_crm_invoice_tax (order_id);

CREATE TABLE IF NOT EXISTS b_crm_invoice_discount (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  DISCOUNT_ID int NOT NULL,
  NAME varchar(255) NOT NULL,
  DISCOUNT_HASH varchar(32) NOT NULL,
  CONDITIONS text,
  UNPACK text,
  ACTIONS text,
  APPLICATION text,
  USE_COUPONS char(1) NOT NULL,
  SORT int NOT NULL,
  PRIORITY int NOT NULL,
  LAST_DISCOUNT char(1) NOT NULL,
  ACTIONS_DESCR text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_discount_discount_hash ON b_crm_invoice_discount (discount_hash);

CREATE TABLE IF NOT EXISTS b_crm_invoice_coupons (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  ORDER_DISCOUNT_ID int NOT NULL,
  COUPON varchar(32) NOT NULL,
  TYPE int NOT NULL,
  COUPON_ID int NOT NULL,
  DATA text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_coupons_order_id ON b_crm_invoice_coupons (order_id);

CREATE TABLE IF NOT EXISTS b_crm_invoice_modules (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_DISCOUNT_ID int NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_modules_order_discount_id ON b_crm_invoice_modules (order_discount_id);

CREATE TABLE IF NOT EXISTS b_crm_invoice_rules (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  ORDER_DISCOUNT_ID int NOT NULL,
  ORDER_ID int NOT NULL,
  ENTITY_TYPE int NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_VALUE varchar(255),
  COUPON_ID int NOT NULL,
  APPLY char(1) NOT NULL,
  ACTION_BLOCK_LIST text,
  APPLY_BLOCK_COUNTER int NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_rules_order_id ON b_crm_invoice_rules (order_id);

CREATE TABLE IF NOT EXISTS b_crm_invoice_rules_descr (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  ORDER_DISCOUNT_ID int NOT NULL,
  ORDER_ID int NOT NULL,
  RULE_ID int NOT NULL,
  DESCR text NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_rules_descr_order_id ON b_crm_invoice_rules_descr (order_id);
CREATE INDEX ix_b_crm_invoice_rules_descr_rule_id ON b_crm_invoice_rules_descr (rule_id);

CREATE TABLE IF NOT EXISTS b_crm_invoice_discount_data (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  ENTITY_TYPE int NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_VALUE varchar(255),
  ENTITY_DATA text NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_discount_data_order_id_entity_type ON b_crm_invoice_discount_data (order_id, entity_type);

CREATE TABLE IF NOT EXISTS b_crm_invoice_round (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ORDER_ID int NOT NULL,
  APPLY_BLOCK_COUNTER int NOT NULL DEFAULT 0,
  ORDER_ROUND char(1) NOT NULL,
  ENTITY_TYPE int NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_VALUE varchar(255),
  APPLY char(1) NOT NULL,
  ROUND_RULE text NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_invoice_round_order_id ON b_crm_invoice_round (order_id);

CREATE TABLE b_crm_volume (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  INDICATOR_TYPE varchar(255) NOT NULL,
  OWNER_ID int NOT NULL DEFAULT 0,
  DATE_CREATE date,
  STAGE_SEMANTIC_ID varchar(3),
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  ENTITY_SIZE int8 NOT NULL DEFAULT 0,
  ENTITY_COUNT int8 NOT NULL DEFAULT 0,
  FILE_SIZE int8 NOT NULL DEFAULT 0,
  FILE_COUNT int8 NOT NULL DEFAULT 0,
  DISK_SIZE int8 NOT NULL DEFAULT 0,
  DISK_COUNT int8 NOT NULL DEFAULT 0,
  EVENT_SIZE int8 NOT NULL DEFAULT 0,
  EVENT_COUNT int8 NOT NULL DEFAULT 0,
  ACTIVITY_SIZE int8 NOT NULL DEFAULT 0,
  ACTIVITY_COUNT int8 NOT NULL DEFAULT 0,
  AGENT_LOCK smallint NOT NULL DEFAULT 0,
  DROP_ENTITY smallint NOT NULL DEFAULT 0,
  DROP_FILE smallint NOT NULL DEFAULT 0,
  DROP_EVENT smallint NOT NULL DEFAULT 0,
  DROP_ACTIVITY smallint NOT NULL DEFAULT 0,
  DROPPED_ENTITY_COUNT int8 NOT NULL DEFAULT 0,
  DROPPED_FILE_COUNT int8 NOT NULL DEFAULT 0,
  DROPPED_EVENT_COUNT int8 NOT NULL DEFAULT 0,
  DROPPED_ACTIVITY_COUNT int8 NOT NULL DEFAULT 0,
  LAST_ID int DEFAULT null,
  FAIL_COUNT int NOT NULL DEFAULT 0,
  LAST_ERROR varchar(255) DEFAULT null,
  FILTER text DEFAULT null,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_volume_owner_id_indicator_type_date_create_stage_seman ON b_crm_volume (owner_id, indicator_type, date_create, stage_semantic_id);
CREATE INDEX ix_b_crm_volume_owner_id_indicator_type_agent_lock_date_create_ ON b_crm_volume (owner_id, indicator_type, agent_lock, date_create, stage_semantic_id);

CREATE TABLE IF NOT EXISTS b_crm_field_attr (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_SCOPE varchar(32) NOT NULL,
  TYPE_ID int NOT NULL,
  FIELD_NAME varchar(64) NOT NULL,
  CREATED_TIME timestamp NOT NULL,
  START_PHASE varchar(64) NOT NULL,
  FINISH_PHASE varchar(64) NOT NULL,
  PHASE_GROUP_TYPE_ID int NOT NULL,
  IS_CUSTOM_FIELD char(1) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_field_attr_entity_type_id_entity_scope_type_id_field_n ON b_crm_field_attr (entity_type_id, entity_scope, type_id, field_name);
CREATE INDEX ix_b_crm_field_attr_entity_type_id_entity_scope_type_id_is_cust ON b_crm_field_attr (entity_type_id, entity_scope, type_id, is_custom_field);
CREATE INDEX ix_b_crm_field_attr_field_name_is_custom_field ON b_crm_field_attr (field_name, is_custom_field);

CREATE TABLE IF NOT EXISTS b_crm_observer (
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int8 NOT NULL,
  USER_ID int8 NOT NULL,
  SORT int NOT NULL DEFAULT 0,
  CREATED_TIME timestamp NOT NULL,
  LAST_UPDATED_TIME timestamp NOT NULL,
  PRIMARY KEY (USER_ID, ENTITY_ID, ENTITY_TYPE_ID)
);
CREATE INDEX ix_b_crm_observer_entity_id_entity_type_id_user_id ON b_crm_observer (entity_id, entity_type_id, user_id);
CREATE INDEX ix_b_crm_observer_user_id_entity_type_id ON b_crm_observer (user_id, entity_type_id);

CREATE TABLE IF NOT EXISTS b_crm_cleaning (
  ENTITY_ID int NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  CREATED_TIME timestamp NOT NULL,
  LAST_UPDATED_TIME timestamp NOT NULL,
  FORCE_USER_ID int,
  PRIMARY KEY (ENTITY_ID, ENTITY_TYPE_ID)
);
CREATE INDEX ix_b_crm_cleaning_created_time ON b_crm_cleaning (created_time);

CREATE TABLE IF NOT EXISTS b_crm_order_import_product (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PRODUCT_ID int NOT NULL,
  SOURCE_NAME varchar(100) NOT NULL,
  SOURCE_ID varchar(100) NOT NULL,
  SETTINGS text,
  DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
  DATE_MODIFY timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_order_import_product_product_id ON b_crm_order_import_product (product_id);
CREATE INDEX ix_b_crm_order_import_product_source_name_source_id ON b_crm_order_import_product (source_name, source_id);

CREATE TABLE IF NOT EXISTS b_crm_tracking_site (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_CREATE timestamp,
  HOST varchar(255) NOT NULL,
  ADDRESS varchar(255) NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'N',
  IS_INSTALLED char(1) NOT NULL DEFAULT 'N',
  PHONES text,
  EMAILS text,
  REPLACE_TEXT char(1) NOT NULL DEFAULT 'Y',
  ENRICH_TEXT char(1) NOT NULL DEFAULT 'Y',
  RESOLVE_DUPLICATES char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_site_b24 (
  LANDING_SITE_ID int8 NOT NULL,
  IS_SHOP char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (LANDING_SITE_ID, IS_SHOP)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_source (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_CREATE timestamp,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  CODE varchar(20),
  NAME varchar(255) NOT NULL,
  ICON_COLOR varchar(10),
  PHONE varchar(50),
  EMAIL varchar(50),
  UTM_SOURCE varchar(50),
  TAGS text,
  AD_CLIENT_ID varchar(50),
  AD_ACCOUNT_ID varchar(50),
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_pool (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_CREATE timestamp,
  TYPE_ID int8 NOT NULL,
  VALUE varchar(50) NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_phone_number (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_CREATE timestamp,
  VALUE varchar(50) NOT NULL,
  USE_CNT int8 NOT NULL DEFAULT 0,
  DATE_USE timestamp,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_tracking_phone_number_value ON b_crm_tracking_phone_number (value);

CREATE TABLE IF NOT EXISTS b_crm_tracking_source_field (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SOURCE_ID int NOT NULL DEFAULT 0,
  CODE varchar(50) NOT NULL,
  VALUE varchar(2000) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_tracking_source_field_source_id ON b_crm_tracking_source_field (source_id);

CREATE TABLE IF NOT EXISTS b_crm_tracking_expenses_pack (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_INSERT timestamp,
  SOURCE_ID int NOT NULL DEFAULT 0,
  TYPE_ID int8 NOT NULL DEFAULT 0,
  DATE_FROM date,
  DATE_TO date,
  ACTIONS int,
  EXPENSES decimal NOT NULL DEFAULT 0,
  CURRENCY_ID varchar(50) NOT NULL,
  COMMENT varchar(500),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_tracking_expenses_pack_source_id ON b_crm_tracking_expenses_pack (source_id);
CREATE INDEX ix_b_crm_tracking_expenses_pack_date_from_date_to ON b_crm_tracking_expenses_pack (date_from, date_to);

CREATE TABLE IF NOT EXISTS b_crm_tracking_source_expenses (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PACK_ID int NOT NULL DEFAULT 0,
  SOURCE_ID int NOT NULL DEFAULT 0,
  TYPE_ID int8 NOT NULL DEFAULT 0,
  DATE_STAT date,
  ACTIONS int,
  EXPENSES decimal NOT NULL DEFAULT 0,
  CURRENCY_ID varchar(50) NOT NULL,
  COMMENT varchar(500),
  SOURCE_CHILD_ID int8 NOT NULL DEFAULT 0,
  IMPRESSIONS int8 NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_tracking_source_expenses_pack_id ON b_crm_tracking_source_expenses (pack_id);
CREATE INDEX ix_b_crm_tracking_source_expenses_source_id ON b_crm_tracking_source_expenses (source_id);
CREATE INDEX ix_b_crm_tracking_source_expenses_date_stat ON b_crm_tracking_source_expenses (date_stat);

CREATE TABLE IF NOT EXISTS b_crm_tracking_trace (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_CREATE timestamp,
  SOURCE_ID int DEFAULT 0,
  GUEST_ID int,
  TAGS_RAW text,
  PAGES_RAW text,
  IS_MOBILE char(1) NOT NULL DEFAULT 'N',
  HAS_CHILD char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_tracking_trace_source_id ON b_crm_tracking_trace (source_id);
CREATE INDEX ix_b_crm_tracking_trace_date_create ON b_crm_tracking_trace (date_create);

CREATE TABLE IF NOT EXISTS b_crm_tracking_trace_tree (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CHILD_ID int8 NOT NULL,
  PARENT_ID int8 NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_tracking_trace_tree_parent_id ON b_crm_tracking_trace_tree (parent_id);

CREATE TABLE IF NOT EXISTS b_crm_tracking_trace_channel (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TRACE_ID int NOT NULL,
  CODE varchar(25) NOT NULL,
  VALUE varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_tracking_trace_channel_code ON b_crm_tracking_trace_channel (code);
CREATE INDEX ix_b_crm_tracking_trace_channel_trace_id ON b_crm_tracking_trace_channel (trace_id);

CREATE TABLE IF NOT EXISTS b_crm_tracking_trace_entity (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TRACE_ID int NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_tracking_trace_entity_entity_type_id_entity_id ON b_crm_tracking_trace_entity (entity_type_id, entity_id);
CREATE INDEX ix_b_crm_tracking_trace_entity_trace_id ON b_crm_tracking_trace_entity (trace_id);

CREATE TABLE b_crm_tracking_source_child (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PARENT_ID int8 NOT NULL DEFAULT 0,
  SOURCE_ID int8 NOT NULL,
  LEVEL int NOT NULL DEFAULT 0,
  CODE varchar(50) NOT NULL,
  TITLE varchar(250) DEFAULT NULL,
  IS_ENABLED int NOT NULL DEFAULT 1,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_tracking_source_child_source_id_parent_id_code ON b_crm_tracking_source_child (source_id, parent_id, code);

CREATE TABLE b_crm_tracking_trace_source (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TRACE_ID int NOT NULL,
  LEVEL int NOT NULL DEFAULT 0,
  CODE varchar(50) NOT NULL,
  SOURCE_CHILD_ID int8 NOT NULL DEFAULT 0,
  PROCESSED int NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_tracking_trace_source_trace_id_level ON b_crm_tracking_trace_source (trace_id, level);

CREATE TABLE IF NOT EXISTS b_crm_recycling_relation (
  SRC_ENTITY_TYPE_ID int8 NOT NULL,
  SRC_ENTITY_ID int8 NOT NULL,
  SRC_RECYCLE_BIN_ID int8 NOT NULL,
  DST_ENTITY_TYPE_ID int8 NOT NULL,
  DST_ENTITY_ID int8 NOT NULL,
  DST_RECYCLE_BIN_ID int8 NOT NULL,
  PREVIOUS_SRC_ENTITY_ID int8,
  PREVIOUS_DST_ENTITY_ID int8,
  CREATED_TIME timestamp,
  LAST_UPDATED_TIME timestamp,
  PRIMARY KEY (SRC_ENTITY_ID, SRC_ENTITY_TYPE_ID, SRC_RECYCLE_BIN_ID, DST_ENTITY_ID, DST_ENTITY_TYPE_ID, DST_RECYCLE_BIN_ID)
);
CREATE INDEX ix_b_crm_recycling_relation_dst_entity_id_dst_entity_type_id_ds ON b_crm_recycling_relation (dst_entity_id, dst_entity_type_id, dst_recycle_bin_id, src_entity_id, src_entity_type_id, src_recycle_bin_id);
CREATE INDEX ix_b_crm_recycling_relation_dst_recycle_bin_id ON b_crm_recycling_relation (dst_recycle_bin_id);
CREATE INDEX ix_b_crm_recycling_relation_src_recycle_bin_id_dst_recycle_bin_ ON b_crm_recycling_relation (src_recycle_bin_id, dst_recycle_bin_id);

CREATE TABLE IF NOT EXISTS b_crm_order_entity (
  OWNER_ID int8 NOT NULL,
  OWNER_TYPE_ID int NOT NULL,
  ORDER_ID int8 NOT NULL,
  PRIMARY KEY (OWNER_ID, OWNER_TYPE_ID, ORDER_ID)
);
CREATE UNIQUE INDEX ux_b_crm_order_entity_order_id ON b_crm_order_entity (order_id);

CREATE TABLE IF NOT EXISTS b_crm_order_sending_channels (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_ID int8 NOT NULL,
  ENTITY_TYPE varchar(10) NOT NULL,
  CHANNEL_TYPE varchar(10) NOT NULL,
  CHANNEL_NAME varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_order_sending_channels_entity_id_entity_type ON b_crm_order_sending_channels (entity_id, entity_type);

CREATE TABLE IF NOT EXISTS b_crm_ml_model_training (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MODEL_NAME varchar(64) NOT NULL,
  RECORDS_SUCCESS int NOT NULL,
  RECORDS_FAILED int NOT NULL,
  DATE_START timestamp NOT NULL,
  DATE_FINISH timestamp,
  STATE varchar(50) NOT NULL,
  AREA_UNDER_CURVE double precision,
  LAST_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_ml_model_training_model_name_date_start ON b_crm_ml_model_training (model_name, date_start);

CREATE TABLE IF NOT EXISTS b_crm_ml_prediction_history (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CREATED timestamp NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  MODEL_NAME varchar(64) NOT NULL,
  IS_PENDING varchar(1) NOT NULL DEFAULT 'N',
  ANSWER varchar(1),
  SCORE double precision,
  SCORE_DELTA double precision,
  EVENT_TYPE varchar(32),
  ASSOCIATED_ACTIVITY_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_ml_prediction_history_entity_type_id_entity_id_created ON b_crm_ml_prediction_history (entity_type_id, entity_id, created);
CREATE INDEX ix_b_crm_ml_prediction_history_associated_activity_id ON b_crm_ml_prediction_history (associated_activity_id);

CREATE TABLE IF NOT EXISTS b_crm_ml_prediction_queue (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CREATED timestamp NOT NULL,
  DELAYED_UNTIL timestamp,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  TYPE varchar(32) NOT NULL,
  ADDITIONAL_PARAMETERS text,
  STATE varchar(32) NOT NULL,
  ERROR varchar(2000),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_ml_prediction_queue_state_delayed_until ON b_crm_ml_prediction_queue (state, delayed_until);
CREATE INDEX ix_b_crm_ml_prediction_queue_entity_id_entity_type_id ON b_crm_ml_prediction_queue (entity_id, entity_type_id);

CREATE TABLE b_crm_rq_conv_log (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CREATED timestamp NOT NULL,
  MSEC int8 NOT NULL,
  TYPE varchar(20) NOT NULL,
  TAG varchar(255) NOT NULL,
  MESSAGE varchar(4095),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_rq_conv_log_created_msec ON b_crm_rq_conv_log (created, msec);
CREATE INDEX ix_b_crm_rq_conv_log_type ON b_crm_rq_conv_log (type);
CREATE INDEX ix_b_crm_rq_conv_log_tag ON b_crm_rq_conv_log (tag);

CREATE TABLE IF NOT EXISTS b_crm_dynamic_type (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  CUSTOM_SECTION_ID int,
  CODE varchar(255),
  NAME varchar(255) NOT NULL,
  TITLE varchar(255) NOT NULL,
  TABLE_NAME varchar(64) NOT NULL,
  CREATED_BY int8 NOT NULL,
  IS_CATEGORIES_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_STAGES_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_BEGIN_CLOSE_DATES_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_CLIENT_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_LINK_WITH_PRODUCTS_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_CRM_TRACKING_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_MYCOMPANY_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_DOCUMENTS_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_SOURCE_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_USE_IN_USERFIELD_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_OBSERVERS_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_RECYCLEBIN_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_AUTOMATION_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_BIZ_PROC_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_SET_OPEN_PERMISSIONS char(1) NOT NULL DEFAULT 'Y',
  IS_PAYMENTS_ENABLED char(1) NOT NULL DEFAULT 'N',
  IS_COUNTERS_ENABLED char(1) NOT NULL DEFAULT 'N',
  CREATED_TIME timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UPDATED_TIME timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UPDATED_BY int8 NOT NULL,
  IS_INITIALIZED char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_dynamic_type_custom_section_id ON b_crm_dynamic_type (custom_section_id);
CREATE INDEX ix_b_crm_dynamic_type_is_initialized ON b_crm_dynamic_type (is_initialized);
CREATE UNIQUE INDEX ux_b_crm_dynamic_type_table_name ON b_crm_dynamic_type (table_name);
CREATE UNIQUE INDEX ux_b_crm_dynamic_type_entity_type_id ON b_crm_dynamic_type (entity_type_id);

CREATE TABLE IF NOT EXISTS b_crm_item_category (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  IS_DEFAULT char(1) NOT NULL DEFAULT 'N',
  IS_SYSTEM char(1) NOT NULL DEFAULT 'N',
  CODE varchar(255) DEFAULT NULL,
  CREATED_DATE timestamp,
  NAME varchar(255) NOT NULL,
  SORT int NOT NULL,
  SETTINGS text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_item_category_code ON b_crm_item_category (code);
CREATE INDEX ix_b_crm_item_category_entity_type_id ON b_crm_item_category (entity_type_id);

CREATE TABLE IF NOT EXISTS b_crm_item_category_user_field (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int8 NOT NULL,
  CATEGORY_ID int8 NOT NULL,
  USER_FIELD_NAME varchar(50) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_item_category_user_field_entity_type_id_category_id_us ON b_crm_item_category_user_field (entity_type_id, category_id, user_field_name);
CREATE INDEX ix_b_crm_item_category_user_field_category_id ON b_crm_item_category_user_field (category_id);
CREATE INDEX ix_b_crm_item_category_user_field_entity_type_id_category_id ON b_crm_item_category_user_field (entity_type_id, category_id);

CREATE TABLE IF NOT EXISTS b_crm_assigned (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int8 NOT NULL,
  ENTITY_ID int8 NOT NULL,
  ASSIGNED_BY int8 NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_assigned_entity_type_id_entity_id ON b_crm_assigned (entity_type_id, entity_id);
CREATE INDEX ix_b_crm_assigned_assigned_by ON b_crm_assigned (assigned_by);

CREATE TABLE IF NOT EXISTS b_crm_entity_contact (
  ENTITY_TYPE_ID int8 NOT NULL,
  ENTITY_ID int8 NOT NULL,
  CONTACT_ID int8 NOT NULL,
  SORT int NOT NULL,
  ROLE_ID smallint NOT NULL,
  IS_PRIMARY char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ENTITY_TYPE_ID, ENTITY_ID, CONTACT_ID)
);
CREATE INDEX ix_b_crm_entity_contact_contact_id_entity_type_id_entity_id ON b_crm_entity_contact (contact_id, entity_type_id, entity_id);
CREATE INDEX ix_b_crm_entity_contact_entity_type_id_entity_id_is_primary_con ON b_crm_entity_contact (entity_type_id, entity_id, is_primary, contact_id);
CREATE INDEX ix_b_crm_entity_contact_entity_type_id_entity_id_sort_contact_i ON b_crm_entity_contact (entity_type_id, entity_id, sort, contact_id);

CREATE TABLE IF NOT EXISTS b_crm_entity_relation (
  SRC_ENTITY_TYPE_ID int8 NOT NULL,
  SRC_ENTITY_ID int8 NOT NULL,
  DST_ENTITY_TYPE_ID int8 NOT NULL,
  DST_ENTITY_ID int8 NOT NULL,
  RELATION_TYPE varchar(20) NOT NULL,
  PRIMARY KEY (SRC_ENTITY_TYPE_ID, SRC_ENTITY_ID, DST_ENTITY_TYPE_ID, DST_ENTITY_ID)
);
CREATE INDEX ix_b_crm_entity_relation_dst_entity_id ON b_crm_entity_relation (dst_entity_id);

CREATE TABLE b_crm_company_index (
  COMPANY_ID int NOT NULL,
  SEARCH_CONTENT text,
  PRIMARY KEY (COMPANY_ID)
);
CREATE INDEX tx_b_crm_company_index_search_content ON b_crm_company_index USING GIN (to_tsvector('english', search_content));

CREATE TABLE b_crm_contact_index (
  CONTACT_ID int NOT NULL,
  SEARCH_CONTENT text,
  PRIMARY KEY (CONTACT_ID)
);
CREATE INDEX tx_b_crm_contact_index_search_content ON b_crm_contact_index USING GIN (to_tsvector('english', search_content));

CREATE TABLE b_crm_lead_index (
  LEAD_ID int NOT NULL,
  SEARCH_CONTENT text,
  PRIMARY KEY (LEAD_ID)
);
CREATE INDEX tx_b_crm_lead_index_search_content ON b_crm_lead_index USING GIN (to_tsvector('english', search_content));

CREATE TABLE b_crm_deal_index (
  DEAL_ID int NOT NULL,
  SEARCH_CONTENT text,
  PRIMARY KEY (DEAL_ID)
);
CREATE INDEX tx_b_crm_deal_index_search_content ON b_crm_deal_index USING GIN (to_tsvector('english', search_content));

CREATE TABLE b_crm_dp_autosearch_user_settings (
  USER_ID int8 NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  STATUS_ID int NOT NULL DEFAULT 0,
  EXEC_INTERVAL int NOT NULL DEFAULT 0,
  LAST_EXEC_TIME timestamp,
  NEXT_EXEC_TIME timestamp,
  PROGRESS_DATA text,
  IS_MERGE_ENABLED char(1) NOT NULL DEFAULT 'N',
  CHECK_CHANGED_ONLY char(1) NOT NULL DEFAULT 'N',
  MERGE_ID varchar(8) DEFAULT NULL,
  MERGE_ACTIVITY_DATE timestamp DEFAULT NULL,
  PRIMARY KEY (USER_ID, ENTITY_TYPE_ID)
);

CREATE TABLE b_crm_dp_automatic_index (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int8 NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  TYPE_ID int8 NOT NULL,
  MATCH_HASH varchar(32) NOT NULL,
  MATCHES text,
  QUANTITY int8 NOT NULL,
  SCOPE varchar(6) NOT NULL DEFAULT '',
  STATUS_ID int8,
  IS_DIRTY char(1) NOT NULL DEFAULT 'N',
  ROOT_ENTITY_ID int8 NOT NULL,
  ROOT_ENTITY_NAME varchar(256) NOT NULL,
  ROOT_ENTITY_TITLE varchar(256) NOT NULL,
  ROOT_ENTITY_PHONE varchar(256) NOT NULL,
  ROOT_ENTITY_EMAIL varchar(256) NOT NULL,
  ROOT_ENTITY_RQ_INN varchar(15) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_OGRN varchar(13) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_OGRNIP varchar(15) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_BIN varchar(12) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_EDRPOU varchar(10),
  ROOT_ENTITY_RQ_VAT_ID varchar(20) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_ACC_NUM varchar(34) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_IBAN varchar(34) NOT NULL DEFAULT '',
  ROOT_ENTITY_RQ_IIK varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_dp_automatic_index_match_hash_user_id_entity_type_id_t ON b_crm_dp_automatic_index (match_hash, user_id, entity_type_id, type_id, scope);
CREATE INDEX ix_b_crm_dp_automatic_index_user_id_entity_type_id_type_id_scop ON b_crm_dp_automatic_index (user_id, entity_type_id, type_id, scope);
CREATE INDEX ix_b_crm_dp_automatic_index_entity_type_id_root_entity_id ON b_crm_dp_automatic_index (entity_type_id, root_entity_id);

CREATE TABLE b_crm_originator (
  ORIGINATOR_ID varchar(255) NOT NULL,
  ICON_ID int,
  PRIMARY KEY (ORIGINATOR_ID)
);

CREATE TABLE b_crm_order_payment_stage (
  PAYMENT_ID int NOT NULL,
  STAGE varchar(255) NOT NULL,
  UPDATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (PAYMENT_ID)
);

CREATE TABLE b_crm_workflow_entity_stage (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_ID int NOT NULL,
  WORKFLOW_CODE varchar(255) NOT NULL,
  STAGE varchar(255) NOT NULL,
  UPDATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UPDATED_BY int DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_workflow_entity_stage_entity_id_workflow_code ON b_crm_workflow_entity_stage (entity_id, workflow_code);

CREATE TABLE IF NOT EXISTS b_crm_access_attr_lead (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_ID int8 NOT NULL,
  CATEGORY_ID int8 NOT NULL,
  USER_ID int8 NOT NULL,
  IS_OPENED char(1) NOT NULL,
  IS_ALWAYS_READABLE char(1) NOT NULL,
  PROGRESS_STEP varchar(50) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_access_attr_lead_entity_id_user_id_is_opened_is_always ON b_crm_access_attr_lead (entity_id, user_id, is_opened, is_always_readable, progress_step);
CREATE INDEX ix_b_crm_access_attr_lead_user_id_entity_id ON b_crm_access_attr_lead (user_id, entity_id);
CREATE INDEX ix_b_crm_access_attr_lead_is_opened_entity_id ON b_crm_access_attr_lead (is_opened, entity_id);
CREATE INDEX ix_b_crm_access_attr_lead_entity_id_is_opened ON b_crm_access_attr_lead (entity_id, is_opened);
CREATE INDEX ix_b_crm_access_attr_lead_is_always_readable_entity_id ON b_crm_access_attr_lead (is_always_readable, entity_id);
CREATE INDEX ix_b_crm_access_attr_lead_entity_id_is_always_readable ON b_crm_access_attr_lead (entity_id, is_always_readable);
CREATE INDEX ix_b_crm_access_attr_lead_category_id_entity_id ON b_crm_access_attr_lead (category_id, entity_id);
CREATE INDEX ix_b_crm_access_attr_lead_entity_id_category_id_user_id ON b_crm_access_attr_lead (entity_id, category_id, user_id);
CREATE INDEX ix_b_crm_access_attr_lead_category_id_user_id_entity_id ON b_crm_access_attr_lead (category_id, user_id, entity_id);

CREATE TABLE IF NOT EXISTS b_crm_access_attr_deal (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_ID int8 NOT NULL,
  CATEGORY_ID int8 NOT NULL,
  USER_ID int8 NOT NULL,
  IS_OPENED char(1) NOT NULL,
  IS_ALWAYS_READABLE char(1) NOT NULL,
  PROGRESS_STEP varchar(50) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_access_attr_deal_entity_id_user_id_is_opened_is_always ON b_crm_access_attr_deal (entity_id, user_id, is_opened, is_always_readable, progress_step);
CREATE INDEX ix_b_crm_access_attr_deal_user_id_entity_id ON b_crm_access_attr_deal (user_id, entity_id);
CREATE INDEX ix_b_crm_access_attr_deal_is_opened_entity_id ON b_crm_access_attr_deal (is_opened, entity_id);
CREATE INDEX ix_b_crm_access_attr_deal_entity_id_is_opened ON b_crm_access_attr_deal (entity_id, is_opened);
CREATE INDEX ix_b_crm_access_attr_deal_is_always_readable_entity_id ON b_crm_access_attr_deal (is_always_readable, entity_id);
CREATE INDEX ix_b_crm_access_attr_deal_entity_id_is_always_readable ON b_crm_access_attr_deal (entity_id, is_always_readable);
CREATE INDEX ix_b_crm_access_attr_deal_category_id_entity_id ON b_crm_access_attr_deal (category_id, entity_id);
CREATE INDEX ix_b_crm_access_attr_deal_entity_id_category_id_user_id ON b_crm_access_attr_deal (entity_id, category_id, user_id);
CREATE INDEX ix_b_crm_access_attr_deal_category_id_user_id_entity_id ON b_crm_access_attr_deal (category_id, user_id, entity_id);

CREATE TABLE IF NOT EXISTS b_crm_access_attr_contact (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_ID int8 NOT NULL,
  CATEGORY_ID int8 NOT NULL,
  USER_ID int8 NOT NULL,
  IS_OPENED char(1) NOT NULL,
  IS_ALWAYS_READABLE char(1) NOT NULL,
  PROGRESS_STEP varchar(50) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_access_attr_contact_entity_id_user_id_is_opened_is_alw ON b_crm_access_attr_contact (entity_id, user_id, is_opened, is_always_readable, progress_step);
CREATE INDEX ix_b_crm_access_attr_contact_user_id_entity_id ON b_crm_access_attr_contact (user_id, entity_id);
CREATE INDEX ix_b_crm_access_attr_contact_is_opened_entity_id ON b_crm_access_attr_contact (is_opened, entity_id);
CREATE INDEX ix_b_crm_access_attr_contact_entity_id_is_opened ON b_crm_access_attr_contact (entity_id, is_opened);
CREATE INDEX ix_b_crm_access_attr_contact_is_always_readable_entity_id ON b_crm_access_attr_contact (is_always_readable, entity_id);
CREATE INDEX ix_b_crm_access_attr_contact_entity_id_is_always_readable ON b_crm_access_attr_contact (entity_id, is_always_readable);
CREATE INDEX ix_b_crm_access_attr_contact_category_id_entity_id ON b_crm_access_attr_contact (category_id, entity_id);
CREATE INDEX ix_b_crm_access_attr_contact_entity_id_category_id_user_id ON b_crm_access_attr_contact (entity_id, category_id, user_id);
CREATE INDEX ix_b_crm_access_attr_contact_category_id_user_id_entity_id ON b_crm_access_attr_contact (category_id, user_id, entity_id);

CREATE TABLE IF NOT EXISTS b_crm_access_attr_company (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_ID int8 NOT NULL,
  CATEGORY_ID int8 NOT NULL,
  USER_ID int8 NOT NULL,
  IS_OPENED char(1) NOT NULL,
  IS_ALWAYS_READABLE char(1) NOT NULL,
  PROGRESS_STEP varchar(50) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_access_attr_company_entity_id_user_id_is_opened_is_alw ON b_crm_access_attr_company (entity_id, user_id, is_opened, is_always_readable, progress_step);
CREATE INDEX ix_b_crm_access_attr_company_user_id_entity_id ON b_crm_access_attr_company (user_id, entity_id);
CREATE INDEX ix_b_crm_access_attr_company_is_opened_entity_id ON b_crm_access_attr_company (is_opened, entity_id);
CREATE INDEX ix_b_crm_access_attr_company_entity_id_is_opened ON b_crm_access_attr_company (entity_id, is_opened);
CREATE INDEX ix_b_crm_access_attr_company_is_always_readable_entity_id ON b_crm_access_attr_company (is_always_readable, entity_id);
CREATE INDEX ix_b_crm_access_attr_company_entity_id_is_always_readable ON b_crm_access_attr_company (entity_id, is_always_readable);
CREATE INDEX ix_b_crm_access_attr_company_category_id_entity_id ON b_crm_access_attr_company (category_id, entity_id);
CREATE INDEX ix_b_crm_access_attr_company_entity_id_category_id_user_id ON b_crm_access_attr_company (entity_id, category_id, user_id);
CREATE INDEX ix_b_crm_access_attr_company_category_id_user_id_entity_id ON b_crm_access_attr_company (category_id, user_id, entity_id);

CREATE TABLE b_crm_webform_ads_field_mapping (
  FORM_LINK_ID int NOT NULL,
  CRM_FIELD_KEY varchar(255) NOT NULL,
  ADS_FIELD_KEY varchar(64) NOT NULL,
  ITEMS text NOT NULL
);
CREATE INDEX ix_b_crm_webform_ads_field_mapping_form_link_id ON b_crm_webform_ads_field_mapping (form_link_id);

CREATE TABLE IF NOT EXISTS b_crm_shipment_realization (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SHIPMENT_ID int8 NOT NULL,
  IS_REALIZATION char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_shipment_realization_shipment_id ON b_crm_shipment_realization (shipment_id);

CREATE TABLE IF NOT EXISTS b_crm_product_reservation_map (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PRODUCT_ROW_ID int8 NOT NULL,
  BASKET_RESERVATION_ID int8 NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_product_reservation_map_product_row_id ON b_crm_product_reservation_map (product_row_id);
CREATE INDEX ix_b_crm_product_reservation_map_basket_reservation_id ON b_crm_product_reservation_map (basket_reservation_id);

CREATE TABLE IF NOT EXISTS b_crm_product_row_reservation (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ROW_ID int8 NOT NULL,
  RESERVE_QUANTITY double precision,
  DATE_RESERVE_END timestamp,
  STORE_ID int8,
  IS_AUTO char(1),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_product_row_reservation_row_id ON b_crm_product_row_reservation (row_id);

CREATE TABLE IF NOT EXISTS b_crm_act_incoming_channel (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ACTIVITY_ID int8 NOT NULL,
  RESPONSIBLE_ID int NOT NULL,
  COMPLETED char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_act_incoming_channel_responsible_id_completed ON b_crm_act_incoming_channel (responsible_id, completed);
CREATE UNIQUE INDEX ux_b_crm_act_incoming_channel_activity_id ON b_crm_act_incoming_channel (activity_id);

CREATE TABLE b_crm_entity_uncompleted_act (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  ACTIVITY_ID int8 NOT NULL,
  RESPONSIBLE_ID int NOT NULL,
  MIN_DEADLINE timestamp NOT NULL,
  IS_INCOMING_CHANNEL char(1) NOT NULL DEFAULT 'N',
  HAS_ANY_INCOMING_CHANEL char(1) NOT NULL DEFAULT 'N',
  MIN_LIGHT_COUNTER_AT timestamp,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_entity_uncompleted_act_entity_id_entity_type_id_respon ON b_crm_entity_uncompleted_act (entity_id, entity_type_id, responsible_id, is_incoming_channel, min_deadline);
CREATE INDEX ix_b_crm_entity_uncompleted_act_responsible_id_entity_type_id_i ON b_crm_entity_uncompleted_act (responsible_id, entity_type_id, is_incoming_channel, min_deadline);
CREATE INDEX ix_b_crm_entity_uncompleted_act_responsible_id_entity_type_id_h ON b_crm_entity_uncompleted_act (responsible_id, entity_type_id, has_any_incoming_chanel, min_deadline);
CREATE INDEX ix_b_crm_entity_uncompleted_act_entity_type_id_has_any_incoming ON b_crm_entity_uncompleted_act (entity_type_id, has_any_incoming_chanel, min_deadline);

CREATE TABLE IF NOT EXISTS b_crm_automation_qr (
  ID varchar(32) NOT NULL,
  OWNER_ID varchar(128) NOT NULL,
  ENTITY_TYPE_ID int8 NOT NULL,
  ENTITY_ID int8 NOT NULL,
  DESCRIPTION text,
  COMPLETE_ACTION_LABEL text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_automation_qr_entity_type_id_entity_id ON b_crm_automation_qr (entity_type_id, entity_id);
CREATE INDEX ix_b_crm_automation_qr_owner_id ON b_crm_automation_qr (owner_id);

CREATE TABLE IF NOT EXISTS b_crm_field_set (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  CLIENT_ENTITY_TYPE_ID int NOT NULL,
  RQ_PRESET_ID int8 NOT NULL,
  FIELDS text,
  CODE varchar(25) NOT NULL DEFAULT '',
  TITLE varchar(25) NOT NULL DEFAULT '',
  IS_SYSTEM int NOT NULL DEFAULT '0',
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_item_badge (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CREATED_DATE timestamp NOT NULL,
  TYPE varchar(30) NOT NULL,
  VALUE varchar(30) NOT NULL,
  ENTITY_TYPE_ID int8 NOT NULL,
  ENTITY_ID int8 NOT NULL,
  SOURCE_PROVIDER_ID varchar(30) NOT NULL,
  SOURCE_ENTITY_TYPE_ID int8 NOT NULL,
  SOURCE_ENTITY_ID int8 NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_item_badge_entity_type_id_entity_id ON b_crm_item_badge (entity_type_id, entity_id);
CREATE INDEX ix_b_crm_item_badge_source_provider_id_source_entity_type_id_so ON b_crm_item_badge (source_provider_id, source_entity_type_id, source_entity_id);

CREATE TABLE IF NOT EXISTS b_crm_counter_calculated_time (
  USER_ID int NOT NULL,
  CODE varchar(255) NOT NULL,
  CALCULATED_AT timestamp NOT NULL,
  IS_CALCULATING char(1) NOT NULL DEFAULT 'N',
  CALCULATION_STARTED_AT timestamp,
  PRIMARY KEY (USER_ID, CODE)
);

CREATE TABLE IF NOT EXISTS b_crm_store_document_contractor (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DOCUMENT_ID int8 NOT NULL,
  ENTITY_ID int8 NOT NULL,
  ENTITY_TYPE_ID int8 NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_store_document_contractor_document_id_entity_id_entity ON b_crm_store_document_contractor (document_id, entity_id, entity_type_id);
CREATE INDEX ix_b_crm_store_document_contractor_document_id ON b_crm_store_document_contractor (document_id);
CREATE INDEX ix_b_crm_store_document_contractor_entity_id_entity_type_id ON b_crm_store_document_contractor (entity_id, entity_type_id);

CREATE TABLE IF NOT EXISTS b_crm_contractor_conversion (
  CONTRACTOR_ID int NOT NULL,
  ENTITY_ID int8 DEFAULT NULL,
  ENTITY_TYPE_ID int8 DEFAULT NULL,
  SUCCESS char(1) DEFAULT NULL,
  ERRORS text,
  PRIMARY KEY (CONTRACTOR_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_act_ping_offsets (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ACTIVITY_ID int8 NOT NULL,
  "offset" int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_act_ping_offsets_activity_id ON b_crm_act_ping_offsets (activity_id);

CREATE TABLE IF NOT EXISTS b_crm_act_ping_queue (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ACTIVITY_ID int8 NOT NULL,
  PING_DATETIME timestamp NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_act_ping_queue_activity_id ON b_crm_act_ping_queue (activity_id);

CREATE TABLE IF NOT EXISTS b_crm_timeline_note (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ITEM_ID int8 NOT NULL,
  ITEM_TYPE int NOT NULL,
  TEXT text NOT NULL,
  CREATED_BY_ID int8 NOT NULL,
  CREATED_TIME timestamp NOT NULL,
  UPDATED_BY_ID int8 NOT NULL,
  UPDATED_TIME timestamp NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_timeline_note_item_id_item_type ON b_crm_timeline_note (item_id, item_type);

CREATE TABLE b_crm_entity_countable_act (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_ASSIGNED_BY_ID int NOT NULL,
  ACTIVITY_ID int8 NOT NULL,
  ACTIVITY_RESPONSIBLE_ID int NOT NULL,
  ACTIVITY_DEADLINE timestamp NOT NULL,
  ACTIVITY_IS_INCOMING_CHANNEL char(1) NOT NULL DEFAULT 'N',
  LIGHT_COUNTER_AT timestamp,
  DEADLINE_EXPIRED_AT timestamp,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_entity_countable_act_entity_id_entity_type_id_activity ON b_crm_entity_countable_act (entity_id, entity_type_id, activity_id);
CREATE INDEX ix_b_crm_entity_countable_act_activity_responsible_id_entity_ty ON b_crm_entity_countable_act (activity_responsible_id, entity_type_id, activity_is_incoming_channel, activity_deadline, entity_id);
CREATE INDEX ix_b_crm_entity_countable_act_entity_assigned_by_id_entity_type ON b_crm_entity_countable_act (entity_assigned_by_id, entity_type_id, activity_is_incoming_channel, activity_deadline, entity_id);
CREATE INDEX ix_b_crm_entity_countable_act_entity_type_id_activity_is_incomi ON b_crm_entity_countable_act (entity_type_id, activity_is_incoming_channel, activity_deadline, entity_id);
CREATE INDEX ix_b_crm_entity_countable_act_activity_id ON b_crm_entity_countable_act (activity_id);
CREATE INDEX ix_b_crm_entity_countable_act_light_counter_at ON b_crm_entity_countable_act (light_counter_at);

CREATE TABLE IF NOT EXISTS b_crm_custom_badge (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE varchar(255) NOT NULL,
  TITLE varchar(4000) NOT NULL,
  VALUE varchar(4000) NOT NULL,
  TYPE varchar(20) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_custom_badge_code ON b_crm_custom_badge (code);
CREATE INDEX ix_b_crm_custom_badge_type ON b_crm_custom_badge (type);

CREATE TABLE IF NOT EXISTS b_crm_timeline_custom_icon (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE varchar(255) NOT NULL,
  FILE_ID int8 NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_timeline_custom_icon_code ON b_crm_timeline_custom_icon (code);

CREATE TABLE IF NOT EXISTS b_crm_timeline_custom_logo (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE varchar(255) NOT NULL,
  FILE_ID int8 NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_timeline_custom_logo_code ON b_crm_timeline_custom_logo (code);

CREATE TABLE IF NOT EXISTS b_crm_field_content_type (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int8 NOT NULL,
  ENTITY_ID int8 NOT NULL,
  FIELD_NAME varchar(255) NOT NULL,
  CONTENT_TYPE_ID int8 NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_field_content_type_entity_type_id_entity_id_field_name ON b_crm_field_content_type (entity_type_id, entity_id, field_name);

CREATE TABLE IF NOT EXISTS b_crm_act_counter_light (
  ACTIVITY_ID int8 NOT NULL,
  LIGHT_COUNTER_AT timestamp NOT NULL,
  IS_LIGHT_COUNTER_NOTIFIED char(1) DEFAULT 'N',
  PRIMARY KEY (ACTIVITY_ID)
);
CREATE INDEX ix_b_crm_act_counter_light_is_light_counter_notified_light_coun ON b_crm_act_counter_light (is_light_counter_notified, light_counter_at);
CREATE INDEX ix_b_crm_act_counter_light_light_counter_at ON b_crm_act_counter_light (light_counter_at);

CREATE TABLE IF NOT EXISTS b_crm_webform_limit (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_STAT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  TYPE varchar(25) NOT NULL,
  CODE varchar(25) NOT NULL,
  VALUE int NOT NULL DEFAULT 0,
  NOTIFIED smallint NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_webform_limit_date_stat_type_code ON b_crm_webform_limit (date_stat, type, code);

CREATE TABLE IF NOT EXISTS b_crm_agent_contract_contractor (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CONTRACT_ID int8 NOT NULL,
  ENTITY_ID int8 NOT NULL,
  ENTITY_TYPE_ID int8 NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_agent_contract_contractor_contract_id_entity_id_entity ON b_crm_agent_contract_contractor (contract_id, entity_id, entity_type_id);
CREATE INDEX ix_b_crm_agent_contract_contractor_contract_id ON b_crm_agent_contract_contractor (contract_id);
CREATE INDEX ix_b_crm_agent_contract_contractor_entity_id_entity_type_id ON b_crm_agent_contract_contractor (entity_id, entity_type_id);

CREATE TABLE b_crm_act_fastsearch (
  ACTIVITY_ID int8 NOT NULL,
  CREATED timestamp NOT NULL,
  DEADLINE timestamp,
  RESPONSIBLE_ID int NOT NULL,
  COMPLETED char(1) NOT NULL,
  ACTIVITY_TYPE varchar(210) NOT NULL,
  ACTIVITY_KIND smallint NOT NULL,
  AUTHOR_ID int8 NOT NULL DEFAULT 0,
  PRIMARY KEY (ACTIVITY_ID)
);
CREATE INDEX ix_b_crm_act_fastsearch_created ON b_crm_act_fastsearch (created);

CREATE TABLE b_crm_lead_fields_context (
  LEAD_ID int8 NOT NULL,
  FIELD_NAME varchar(50) NOT NULL,
  VALUE_ID varchar(20) NOT NULL,
  CONTEXT int NOT NULL,
  PRIMARY KEY (LEAD_ID, FIELD_NAME, VALUE_ID)
);
CREATE INDEX ix_b_crm_lead_fields_context_field_name ON b_crm_lead_fields_context (field_name);

CREATE TABLE IF NOT EXISTS b_crm_deal_fields_context (
  DEAL_ID int8 NOT NULL,
  FIELD_NAME varchar(50) NOT NULL,
  VALUE_ID varchar(20) NOT NULL,
  CONTEXT int NOT NULL,
  PRIMARY KEY (DEAL_ID, FIELD_NAME, VALUE_ID)
);
CREATE INDEX ix_b_crm_deal_fields_context_field_name ON b_crm_deal_fields_context (field_name);

CREATE TABLE IF NOT EXISTS b_crm_contact_fields_context (
  CONTACT_ID int8 NOT NULL,
  FIELD_NAME varchar(50) NOT NULL,
  VALUE_ID varchar(20) NOT NULL,
  CONTEXT int NOT NULL,
  PRIMARY KEY (CONTACT_ID, FIELD_NAME, VALUE_ID)
);
CREATE INDEX ix_b_crm_contact_fields_context_field_name ON b_crm_contact_fields_context (field_name);

CREATE TABLE IF NOT EXISTS b_crm_company_fields_context (
  COMPANY_ID int8 NOT NULL,
  FIELD_NAME varchar(50) NOT NULL,
  VALUE_ID varchar(20) NOT NULL,
  CONTEXT int NOT NULL,
  PRIMARY KEY (COMPANY_ID, FIELD_NAME, VALUE_ID)
);
CREATE INDEX ix_b_crm_company_fields_context_field_name ON b_crm_company_fields_context (field_name);

CREATE TABLE IF NOT EXISTS b_crm_quote_fields_context (
  QUOTE_ID int8 NOT NULL,
  FIELD_NAME varchar(50) NOT NULL,
  VALUE_ID varchar(20) NOT NULL,
  CONTEXT int NOT NULL,
  PRIMARY KEY (QUOTE_ID, FIELD_NAME, VALUE_ID)
);
CREATE INDEX ix_b_crm_quote_fields_context_field_name ON b_crm_quote_fields_context (field_name);

CREATE TABLE IF NOT EXISTS b_crm_ai_queue (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int NOT NULL,
  ENTITY_ID int8 NOT NULL,
  HASH varchar(32) NOT NULL,
  TYPE_ID int NOT NULL,
  PARENT_ID int8 NOT NULL DEFAULT 0,
  STORAGE_TYPE_ID int NOT NULL DEFAULT 0,
  STORAGE_ELEMENT_ID int8 NOT NULL DEFAULT 0,
  USER_ID int8 NOT NULL DEFAULT 0,
  EXECUTION_STATUS varchar(255) NOT NULL,
  ERROR_CODE varchar(255),
  ERROR_MESSAGE text,
  RETRY_COUNT int NOT NULL DEFAULT 0,
  OPERATION_STATUS varchar(255),
  RESULT text,
  IS_FEEDBACK_CONSENT_GRANTED char(1) NOT NULL DEFAULT 'N',
  IS_FEEDBACK_SENT char(1) NOT NULL DEFAULT 'N',
  IS_MANUAL_LAUNCH char(1) NOT NULL DEFAULT 'Y',
  CREATED_TIME timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  FINISHED_TIME timestamp,
  LANGUAGE_ID char(2),
  ENGINE_ID int8 NOT NULL DEFAULT 0,
  NEXT_TYPE_ID int,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_ai_queue_hash ON b_crm_ai_queue (hash);
CREATE INDEX ix_b_crm_ai_queue_entity_type_id_entity_id_type_id ON b_crm_ai_queue (entity_type_id, entity_id, type_id);
CREATE INDEX ix_b_crm_ai_queue_parent_id ON b_crm_ai_queue (parent_id);
CREATE INDEX ix_b_crm_ai_queue_user_id ON b_crm_ai_queue (user_id);

CREATE TABLE IF NOT EXISTS b_crm_ai_quality_assessment (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CREATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UPDATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  ACTIVITY_TYPE smallint NOT NULL,
  ACTIVITY_ID int8 NOT NULL,
  ASSESSMENT_SETTING_ID int8 NOT NULL,
  JOB_ID int8 NOT NULL,
  PROMPT text NOT NULL,
  ASSESSMENT int NOT NULL DEFAULT 0,
  ASSESSMENT_AVG int NOT NULL DEFAULT 0,
  USE_IN_RATING char(1) NOT NULL DEFAULT 'Y',
  RATED_USER_ID int8 NOT NULL DEFAULT 0,
  MANAGER_USER_ID int8 NOT NULL DEFAULT 0,
  RATED_USER_CHAT_ID int8 NOT NULL DEFAULT 0,
  MANAGER_USER_CHAT_ID int8 NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_ai_quality_assessment_rated_user_id ON b_crm_ai_quality_assessment (rated_user_id);
CREATE INDEX ix_b_crm_ai_quality_assessment_manager_user_id ON b_crm_ai_quality_assessment (manager_user_id);

CREATE TABLE IF NOT EXISTS b_crm_terminal_payment (
  PAYMENT_ID int NOT NULL,
  PRIMARY KEY (PAYMENT_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_act_sms_placeholder (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID int8 NOT NULL,
  ENTITY_CATEGORY_ID smallint,
  TEMPLATE_ID int8 NOT NULL,
  PLACEHOLDER_ID varchar(255) NOT NULL,
  FIELD_NAME varchar(255),
  FIELD_ENTITY_TYPE varchar(255),
  FIELD_VALUE varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_act_sms_placeholder_entity_type_id_entity_category_id_ ON b_crm_act_sms_placeholder (entity_type_id, entity_category_id, template_id);
CREATE INDEX ix_b_crm_act_sms_placeholder_entity_type_id_entity_category_i_1 ON b_crm_act_sms_placeholder (entity_type_id, entity_category_id, template_id, placeholder_id);

CREATE TABLE IF NOT EXISTS b_crm_automated_solution (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  INTRANET_CUSTOM_SECTION_ID int8,
  TITLE varchar(255) NOT NULL,
  CODE varchar(255) NOT NULL,
  SORT int NOT NULL,
  CREATED_TIME timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UPDATED_TIME timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CREATED_BY int8 NOT NULL,
  UPDATED_BY int8 NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_automated_solution_code ON b_crm_automated_solution (code);
CREATE INDEX ix_b_crm_automated_solution_intranet_custom_section_id ON b_crm_automated_solution (intranet_custom_section_id);

CREATE TABLE IF NOT EXISTS b_crm_multi_value_store (
  TYPE_KEY varchar(255) NOT NULL,
  VALUE varchar(255) NOT NULL,
  CREATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (TYPE_KEY, VALUE)
);
CREATE INDEX ix_b_crm_multi_value_store_type_key_created_at ON b_crm_multi_value_store (type_key, created_at);

CREATE TABLE b_crm_timeline_rest_app_layout_blocks (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ITEM_TYPE int NOT NULL,
  ITEM_ID int8 NOT NULL,
  CLIENT_ID varchar(128) NOT NULL,
  LAYOUT text NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_timeline_rest_app_layout_blocks_client_id ON b_crm_timeline_rest_app_layout_blocks (client_id);
CREATE INDEX ix_b_crm_timeline_rest_app_layout_blocks_item_type_item_id ON b_crm_timeline_rest_app_layout_blocks (item_type, item_id);
CREATE INDEX ix_b_crm_timeline_rest_app_layout_blocks_item_type_item_id_clie ON b_crm_timeline_rest_app_layout_blocks (item_type, item_id, client_id);

CREATE TABLE b_crm_sequences (
  SEQUENCE_NAME varchar(50) NOT NULL,
  SEQUENCE_VALUE int NOT NULL DEFAULT 0,
  PRIMARY KEY (SEQUENCE_NAME)
);

CREATE TABLE IF NOT EXISTS b_crm_webpack_file_log (
  FILE_ID int NOT NULL,
  ENTITY_TYPE varchar(15) NOT NULL,
  ENTITY_ID int NOT NULL,
  PRIMARY KEY (FILE_ID)
);
CREATE INDEX ix_b_crm_webpack_file_log_entity_type_entity_id ON b_crm_webpack_file_log (entity_type, entity_id);

CREATE TABLE IF NOT EXISTS b_crm_copilot_call_assessment (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TITLE varchar(255) NOT NULL,
  PROMPT text NOT NULL,
  GIST text,
  CALL_TYPE smallint NOT NULL,
  AUTO_CHECK_TYPE smallint NOT NULL,
  IS_ENABLED char(1) NOT NULL DEFAULT 'Y',
  IS_DEFAULT char(1) NOT NULL DEFAULT 'Y',
  JOB_ID int8 NOT NULL DEFAULT 0,
  STATUS varchar(100) NOT NULL DEFAULT '',
  CODE varchar(30),
  LOW_BORDER smallint NOT NULL DEFAULT 30,
  HIGH_BORDER smallint NOT NULL DEFAULT 70,
  CREATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UPDATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CREATED_BY_ID int NOT NULL DEFAULT 0,
  UPDATED_BY_ID int NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_copilot_call_assessment_is_default ON b_crm_copilot_call_assessment (is_default);
CREATE INDEX ix_b_crm_copilot_call_assessment_is_enabled_updated_at ON b_crm_copilot_call_assessment (is_enabled, updated_at);

CREATE TABLE IF NOT EXISTS b_crm_copilot_call_assessment_client_type (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ASSESSMENT_ID int NOT NULL,
  CLIENT_TYPE_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_copilot_call_assessment_client_type_assessment_id ON b_crm_copilot_call_assessment_client_type (assessment_id);
CREATE INDEX ix_b_crm_copilot_call_assessment_client_type_client_type_id ON b_crm_copilot_call_assessment_client_type (client_type_id);

CREATE TABLE b_crm_communication_category (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MODULE_ID varchar(64) NOT NULL,
  CODE varchar(50) NOT NULL,
  SORT int DEFAULT 100,
  HANDLER_CLASS varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_communication_category_module_id_code ON b_crm_communication_category (module_id, code);

CREATE TABLE IF NOT EXISTS b_crm_communication_channel (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CATEGORY_ID int NOT NULL,
  MODULE_ID varchar(64) NOT NULL,
  CODE varchar(128) NOT NULL,
  HANDLER_CLASS varchar(256) NOT NULL,
  CREATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UPDATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CREATED_BY_ID int NOT NULL DEFAULT 0,
  UPDATED_BY_ID int NOT NULL DEFAULT 0,
  SORT int NOT NULL DEFAULT 0,
  IS_ENABLED char(1) DEFAULT 'Y',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_crm_communication_channel_module_id_code ON b_crm_communication_channel (module_id, code);

CREATE TABLE b_crm_communication_channel_rule (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TITLE varchar(255) NOT NULL,
  CHANNEL_ID int NOT NULL,
  QUEUE_CONFIG_ID int NOT NULL DEFAULT 0,
  SORT int NOT NULL DEFAULT 0,
  SEARCH_TARGETS text,
  RULES text NOT NULL,
  ENTITIES text NOT NULL,
  SETTINGS text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_communication_channel_rule_channel_id ON b_crm_communication_channel_rule (channel_id);
CREATE INDEX ix_b_crm_communication_channel_rule_queue_config_id ON b_crm_communication_channel_rule (queue_config_id);

CREATE TABLE b_crm_communication_channel_event (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  EVENT_ID varchar(255) NOT NULL,
  USER_ID int,
  MODULE_ID varchar(64) NOT NULL,
  DATA text NOT NULL,
  CREATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UPDATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_communication_channel_event_module_id_event_id ON b_crm_communication_channel_event (module_id, event_id);

CREATE TABLE b_crm_responsible_queue_config (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TITLE varchar(255) NOT NULL,
  TYPE varchar(64) NOT NULL,
  CREATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UPDATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  SETTINGS text,
  PRIMARY KEY (ID)
);

CREATE TABLE b_crm_responsible_queue_config_members (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SORT int NOT NULL DEFAULT 0,
  QUEUE_CONFIG_ID int NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_TYPE varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_responsible_queue_config_members_queue_config_id ON b_crm_responsible_queue_config_members (queue_config_id);

CREATE TABLE b_crm_responsible_queue (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SORT int NOT NULL DEFAULT 0,
  CONFIG_ID int NOT NULL,
  USER_ID int NOT NULL,
  DEPARTMENT_ID int NOT NULL DEFAULT 0,
  LAST_ACTIVITY_DATE timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  LAST_ACTIVITY_DATE_EXACT int8,
  CREATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UPDATED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  SETTINGS text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_responsible_queue_config_id_last_activity_date ON b_crm_responsible_queue (config_id, last_activity_date);
CREATE INDEX ix_b_crm_responsible_queue_user_id ON b_crm_responsible_queue (user_id);

CREATE TABLE b_crm_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LOGGER_ID varchar(100) NOT NULL,
  CREATED_TIME timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  VALID_TO timestamp NOT NULL,
  LOG_LEVEL varchar(32) NOT NULL,
  MESSAGE text NOT NULL,
  CONTEXT text NOT NULL,
  URL varchar(2048) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_crm_log_valid_to ON b_crm_log (valid_to);
