CREATE TABLE b_crm_lead
(
	ID INT (18) UNSIGNED NOT NULL AUTO_INCREMENT,
	DATE_CREATE DATETIME NULL,
	DATE_MODIFY DATETIME NULL,
	CREATED_BY_ID INT (18) UNSIGNED NOT NULL,
	MODIFY_BY_ID INT (18) UNSIGNED DEFAULT NULL,
	ASSIGNED_BY_ID INT (18) UNSIGNED DEFAULT NULL,
	OPENED CHAR(1) DEFAULT 'N',
	COMPANY_ID INT (18) UNSIGNED DEFAULT NULL,
	CONTACT_ID INT (18) UNSIGNED DEFAULT NULL,
	STATUS_ID VARCHAR (50) DEFAULT NULL,
	STATUS_DESCRIPTION TEXT DEFAULT NULL,
	STATUS_SEMANTIC_ID VARCHAR(3) NULL,
	PRODUCT_ID VARCHAR (50) DEFAULT NULL,
	OPPORTUNITY DECIMAL(18,2) DEFAULT NULL,
	CURRENCY_ID VARCHAR (50) DEFAULT NULL,
	OPPORTUNITY_ACCOUNT DECIMAL(18,2) DEFAULT NULL,
	ACCOUNT_CURRENCY_ID VARCHAR (50) DEFAULT NULL,
	SOURCE_ID VARCHAR (50) DEFAULT NULL,
	SOURCE_DESCRIPTION TEXT DEFAULT NULL,
	TITLE VARCHAR (255) DEFAULT NULL,
	FULL_NAME VARCHAR (100) DEFAULT NULL,
	NAME VARCHAR (50) DEFAULT NULL,
	LAST_NAME VARCHAR (50) DEFAULT NULL,
	SECOND_NAME VARCHAR (50) DEFAULT NULL,
	COMPANY_TITLE VARCHAR (255) DEFAULT NULL,
	POST VARCHAR (255) DEFAULT NULL,
	ADDRESS TEXT DEFAULT NULL,
	COMMENTS TEXT DEFAULT NULL,
	EXCH_RATE DECIMAL(20,4) DEFAULT 1,
	WEBFORM_ID INT (18) UNSIGNED DEFAULT NULL,
	ORIGINATOR_ID VARCHAR(255) NULL,
	ORIGIN_ID VARCHAR(255) NULL,
	DATE_CLOSED DATETIME NULL,
	BIRTHDATE DATE NULL,
	BIRTHDAY_SORT INT(1) NOT NULL DEFAULT 1024,
	HONORIFIC VARCHAR(128) NULL,
	HAS_PHONE CHAR(1) NULL,
	HAS_EMAIL CHAR(1) NULL,
	HAS_IMOL CHAR(1) DEFAULT 'N',
	IS_RETURN_CUSTOMER CHAR(1) NOT NULL DEFAULT 'N',
	FACE_ID INT(18) NULL,
	SEARCH_CONTENT MEDIUMTEXT NULL,
    IS_MANUAL_OPPORTUNITY CHAR(1) DEFAULT 'N',
	MOVED_BY_ID INT UNSIGNED DEFAULT NULL,
	MOVED_TIME DATETIME NULL,
	LAST_ACTIVITY_BY INT UNSIGNED NOT NULL DEFAULT 0,
	LAST_ACTIVITY_TIME DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID),
	INDEX IX_LEAD_FULL_NAME (FULL_NAME),
	INDEX IX_LEAD_1 (STATUS_ID, ASSIGNED_BY_ID),
	INDEX IX_LEAD_2 (DATE_MODIFY),
	INDEX IX_LEAD_3 (CONTACT_ID),
	INDEX IX_LEAD_4 (COMPANY_ID),
	INDEX IX_LEAD_12 (WEBFORM_ID),
	INDEX IX_LEAD_13 (FACE_ID),
	INDEX IX_LEAD_14 (HAS_IMOL),
	INDEX IX_LEAD_15 (STATUS_SEMANTIC_ID, STATUS_ID, OPPORTUNITY_ACCOUNT),
	INDEX IX_LEAD_16 (STATUS_ID, OPPORTUNITY_ACCOUNT),
	INDEX IX_LEAD_17 (BIRTHDAY_SORT, ASSIGNED_BY_ID),
	INDEX IX_LEAD_18 (BIRTHDATE),
	INDEX IX_LEAD_20 (HAS_EMAIL),
	INDEX IX_LEAD_21 (HAS_PHONE, HAS_EMAIL),
	INDEX IX_LEAD_22 (STATUS_SEMANTIC_ID),
	INDEX IX_LEAD_23 (ASSIGNED_BY_ID, STATUS_SEMANTIC_ID),
	INDEX IX_LEAD_24 (DATE_CREATE, STATUS_SEMANTIC_ID),
	INDEX IX_LEAD_25 (DATE_CLOSED),
	INDEX IX_LEAD_26 (LAST_ACTIVITY_TIME),
	INDEX IX_LEAD_27 (STATUS_ID, LAST_ACTIVITY_TIME),
	FULLTEXT INDEX IX_B_CRM_LEAD_SEARCH (SEARCH_CONTENT)
);

CREATE TABLE b_crm_deal
(
	ID INT (18) UNSIGNED NOT NULL AUTO_INCREMENT,
	DATE_CREATE DATETIME NULL,
	DATE_MODIFY DATETIME NULL,
	CREATED_BY_ID INT (18) UNSIGNED NOT NULL,
	MODIFY_BY_ID INT (18) UNSIGNED DEFAULT NULL,
	ASSIGNED_BY_ID INT (18) UNSIGNED DEFAULT NULL,
	OPENED CHAR(1) DEFAULT 'N',
	LEAD_ID INT (18) DEFAULT NULL,
	COMPANY_ID INT (18) UNSIGNED DEFAULT NULL,
	CONTACT_ID INT (18) UNSIGNED DEFAULT NULL,
	QUOTE_ID INT(1) UNSIGNED DEFAULT NULL,
	TITLE VARCHAR (255) DEFAULT NULL,
	PRODUCT_ID VARCHAR (50) DEFAULT NULL,
	CATEGORY_ID INT (18) UNSIGNED NOT NULL DEFAULT 0,
	STAGE_ID VARCHAR (50) DEFAULT NULL,
	STAGE_SEMANTIC_ID VARCHAR(3) NULL,
	IS_NEW CHAR(1) NULL,
	IS_RECURRING CHAR(1) DEFAULT 'N',
	IS_RETURN_CUSTOMER CHAR(1) DEFAULT 'N',
	IS_REPEATED_APPROACH CHAR(1) DEFAULT 'N',
	CLOSED CHAR (1) DEFAULT 'N',
	TYPE_ID VARCHAR (50) DEFAULT NULL,
	OPPORTUNITY DECIMAL(18,2) DEFAULT NULL,
	IS_MANUAL_OPPORTUNITY CHAR(1) DEFAULT 'N',
	TAX_VALUE DECIMAL(18,2) DEFAULT NULL,
	CURRENCY_ID VARCHAR (50) DEFAULT NULL,
	OPPORTUNITY_ACCOUNT DECIMAL(18,2) DEFAULT NULL,
	TAX_VALUE_ACCOUNT DECIMAL(18,2) DEFAULT NULL,
	ACCOUNT_CURRENCY_ID VARCHAR (50) DEFAULT NULL,
	PROBABILITY TINYINT (3) DEFAULT NULL,
	COMMENTS TEXT DEFAULT NULL,
	BEGINDATE DATETIME DEFAULT NULL,
	CLOSEDATE DATETIME DEFAULT NULL,
	EVENT_DATE DATETIME NULL,
	EVENT_ID VARCHAR(50) NULL,
	EVENT_DESCRIPTION text NULL,
	EXCH_RATE DECIMAL(20,4) DEFAULT 1,
	LOCATION_ID VARCHAR(100) NULL,
	WEBFORM_ID INT (18) UNSIGNED DEFAULT NULL,
	SOURCE_ID VARCHAR (50) DEFAULT NULL,
	SOURCE_DESCRIPTION TEXT DEFAULT NULL,
	ORIGINATOR_ID VARCHAR(255) NULL,
	ORIGIN_ID VARCHAR(255) NULL,
	ADDITIONAL_INFO TEXT NULL,
	SEARCH_CONTENT MEDIUMTEXT NULL,
	ORDER_STAGE VARCHAR(255)DEFAULT NULL,
	MOVED_BY_ID INT UNSIGNED DEFAULT NULL,
	MOVED_TIME DATETIME NULL,
	LAST_ACTIVITY_BY INT UNSIGNED NOT NULL DEFAULT 0,
	LAST_ACTIVITY_TIME DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID),
	INDEX IX_DEAL_1 (STAGE_ID, ASSIGNED_BY_ID),
	INDEX IX_DEAL_8 (WEBFORM_ID),
	INDEX IX_DEAL_10 (ORIGIN_ID(155), ORIGINATOR_ID(155)),
	INDEX IX_DEAL_15 (LEAD_ID),
	INDEX IX_DEAL_18 (IS_NEW),
	INDEX IX_DEAL_20 (DATE_CREATE, STAGE_SEMANTIC_ID),
	INDEX IX_DEAL_21 (IS_RETURN_CUSTOMER, CATEGORY_ID),
	INDEX IX_DEAL_22 (COMPANY_ID, IS_RETURN_CUSTOMER),
	INDEX IX_DEAL_23 (CONTACT_ID, IS_RETURN_CUSTOMER),
	INDEX IX_DEAL_24 (IS_REPEATED_APPROACH, CATEGORY_ID),
	INDEX IX_DEAL_26 (STAGE_SEMANTIC_ID, CATEGORY_ID, STAGE_ID),
	INDEX IX_DEAL_27 (MOVED_TIME, STAGE_SEMANTIC_ID),
	INDEX IX_DEAL_28 (CLOSEDATE),
	INDEX IX_DEAL_29 (LAST_ACTIVITY_TIME),
	INDEX IX_DEAL_30 (STAGE_SEMANTIC_ID, COMPANY_ID),
	INDEX IX_DEAL_31 (CATEGORY_ID, STAGE_ID, IS_RECURRING),
	INDEX IX_DEAL_32 (CATEGORY_ID, STAGE_SEMANTIC_ID, IS_RECURRING, STAGE_ID, OPPORTUNITY_ACCOUNT),
	INDEX IX_DEAL_33 (STAGE_ID, CATEGORY_ID, STAGE_SEMANTIC_ID),
	INDEX IX_DEAL_34 (STAGE_ID, LAST_ACTIVITY_TIME),
	INDEX IX_DEAL_35 (ASSIGNED_BY_ID, STAGE_SEMANTIC_ID, CATEGORY_ID, IS_RECURRING),
	FULLTEXT INDEX IX_B_CRM_DEAL_SEARCH (SEARCH_CONTENT)
);

CREATE TABLE b_crm_contact
(
	ID INT (18) UNSIGNED NOT NULL AUTO_INCREMENT,
	DATE_CREATE DATETIME NULL,
	DATE_MODIFY DATETIME NULL,
	CREATED_BY_ID INT (18) UNSIGNED NOT NULL,
	MODIFY_BY_ID INT (18) UNSIGNED DEFAULT NULL,
	ASSIGNED_BY_ID INT (18) UNSIGNED DEFAULT NULL,
	OPENED CHAR(1) DEFAULT 'N',
	COMPANY_ID INT (18) UNSIGNED DEFAULT NULL,
	SOURCE_ID VARCHAR (50) DEFAULT NULL,
	SOURCE_DESCRIPTION TEXT DEFAULT NULL,
	FULL_NAME VARCHAR (100) DEFAULT NULL,
	NAME VARCHAR (50) DEFAULT NULL,
	LAST_NAME VARCHAR (50) DEFAULT NULL,
	SECOND_NAME VARCHAR (50) DEFAULT NULL,
	PHOTO VARCHAR (10) DEFAULT NULL,
	POST VARCHAR (255) DEFAULT NULL,
	ADDRESS TEXT DEFAULT NULL,
	COMMENTS TEXT DEFAULT NULL,
	LEAD_ID INT (18) DEFAULT NULL,
	EXPORT CHAR (1) DEFAULT 'N',
	TYPE_ID VARCHAR (50) DEFAULT NULL,
	WEBFORM_ID INT (18) UNSIGNED DEFAULT NULL,
	ORIGINATOR_ID VARCHAR(255) NULL,
	ORIGIN_ID VARCHAR(255) NULL,
	ORIGIN_VERSION VARCHAR(255) NULL,
	BIRTHDATE DATE DEFAULT NULL,
	BIRTHDAY_SORT INT(1) NOT NULL DEFAULT 1024,
	HONORIFIC VARCHAR(128) NULL,
	HAS_PHONE CHAR(1) NULL,
	HAS_EMAIL CHAR(1) NULL,
	HAS_IMOL CHAR(1) DEFAULT 'N',
	FACE_ID INT(18) NULL,
	SEARCH_CONTENT MEDIUMTEXT NULL,
	CATEGORY_ID INT UNSIGNED NOT NULL DEFAULT 0,
	LAST_ACTIVITY_BY INT UNSIGNED NOT NULL DEFAULT 0,
	LAST_ACTIVITY_TIME DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID),
	INDEX IX_CONTACT_LAST_NAME (NAME),
	INDEX IX_CONTACT_NAME (LAST_NAME),
	INDEX IX_CONTACT_FULL_NAME (FULL_NAME),
	INDEX IX_CONTACT_BDAY_2 (BIRTHDAY_SORT, ASSIGNED_BY_ID),
	INDEX IX_CONTACT_BDATE_2 (BIRTHDATE),
	INDEX IX_CONTACT_COMPANY_2 (COMPANY_ID),
	INDEX IX_CONTACT_EMAIL_2 (HAS_EMAIL),
	INDEX IX_CONTACT_COMM_2 (HAS_PHONE, HAS_EMAIL),
	INDEX IX_CONTACT_WFORM (WEBFORM_ID),
	INDEX IX_CONTACT_FACE (FACE_ID),
	INDEX IX_CONTACT_IMOL (HAS_IMOL),
	INDEX IX_CONTACT_LEAD (LEAD_ID),
	INDEX IX_CONTACT_LAST_NAME_AND_NAME (LAST_NAME, NAME),
	INDEX IX_CONTACT_CATEGORY (CATEGORY_ID),
	INDEX IX_CONTACT_LAST_ACTIVITY_TIME (LAST_ACTIVITY_TIME),
	FULLTEXT INDEX IX_B_CRM_CONTACT_SEARCH (SEARCH_CONTENT)
);

CREATE TABLE b_crm_company
(
	ID INT (18) UNSIGNED NOT NULL AUTO_INCREMENT,
	DATE_CREATE DATETIME NULL,
	DATE_MODIFY DATETIME NULL,
	CREATED_BY_ID INT (18) UNSIGNED NOT NULL,
	MODIFY_BY_ID INT (18) UNSIGNED DEFAULT NULL,
	ASSIGNED_BY_ID INT (1) UNSIGNED DEFAULT NULL,
	OPENED CHAR(1) DEFAULT 'N',
	TITLE varchar(255) DEFAULT NULL,
	LOGO VARCHAR (10) DEFAULT NULL,
	ADDRESS text DEFAULT NULL,
	ADDRESS_LEGAL text DEFAULT NULL,
	BANKING_DETAILS text DEFAULT NULL,
	COMMENTS text DEFAULT NULL,
	COMPANY_TYPE varchar(50) DEFAULT NULL,
	INDUSTRY varchar(50) DEFAULT NULL,
	REVENUE varchar(255) DEFAULT NULL,
	CURRENCY_ID varchar(50) DEFAULT NULL,
	EMPLOYEES varchar(50) DEFAULT NULL,
	LEAD_ID int(18) DEFAULT NULL,
	WEBFORM_ID INT (18) UNSIGNED DEFAULT NULL,
	ORIGINATOR_ID VARCHAR(255) NULL,
	ORIGIN_ID VARCHAR(255) NULL,
	ORIGIN_VERSION VARCHAR(255) NULL,
	HAS_PHONE CHAR(1) NULL,
	HAS_EMAIL CHAR(1) NULL,
	HAS_IMOL CHAR(1) DEFAULT 'N',
	IS_MY_COMPANY CHAR(1) NOT NULL DEFAULT 'N',
	SEARCH_CONTENT MEDIUMTEXT NULL,
	CATEGORY_ID INT UNSIGNED NOT NULL DEFAULT 0,
	LAST_ACTIVITY_BY INT UNSIGNED NOT NULL DEFAULT 0,
	LAST_ACTIVITY_TIME DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY  (ID),
	KEY IX_COMPANY_TITLE (TITLE),
	INDEX IX_COMPANY_EMAIL_2 (HAS_EMAIL),
	INDEX IX_COMPANY_COMM_2 (HAS_PHONE, HAS_EMAIL),
	INDEX IX_COMPANY_WFORM (WEBFORM_ID),
	INDEX IX_COMPANY_IMOL (HAS_IMOL),
	INDEX IX_COMPANY_LEAD (LEAD_ID),
	INDEX IX_B_CRM_COMPANY_1 (IS_MY_COMPANY, CATEGORY_ID),
	INDEX IX_COMPANY_LAST_ACTIVITY_TIME (LAST_ACTIVITY_TIME),
	FULLTEXT INDEX IX_B_CRM_COMPANY_SEARCH (SEARCH_CONTENT)
);

CREATE TABLE b_crm_status
(
	ID INT (18) NOT NULL AUTO_INCREMENT,
	ENTITY_ID VARCHAR (50) NOT NULL,
	STATUS_ID VARCHAR (50) NOT NULL,
	NAME VARCHAR (100) NOT NULL,
	NAME_INIT VARCHAR (100) NULL,
	SORT INT (18) NOT NULL,
	`SYSTEM` CHAR (1) NOT NULL,
	COLOR CHAR (10) NULL,
	SEMANTICS CHAR (1) NULL,
	CATEGORY_ID INT (18) UNSIGNED NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_STATUS (STATUS_ID, ENTITY_ID),
	INDEX IX_B_CRM_STATUS_2 (ENTITY_ID)
);

CREATE TABLE b_crm_field_multi
(
	ID int(18) NOT NULL auto_increment,
	ENTITY_ID VARCHAR (16) NOT NULL,
	ELEMENT_ID int(18) NOT NULL,
	TYPE_ID VARCHAR (16) NOT NULL,
	VALUE_TYPE VARCHAR (50) NOT NULL,
	COMPLEX_ID  VARCHAR(100) NOT NULL,
	VALUE VARCHAR (250) NOT NULL,
	PRIMARY KEY  (ID),
	KEY IX_B_CRM_FM_3 (TYPE_ID, VALUE, ENTITY_ID, ELEMENT_ID),
    KEY IX_B_CRM_FM_4 (ENTITY_ID, TYPE_ID, ELEMENT_ID),
    KEY IX_B_CRM_FM_5 (ELEMENT_ID, ENTITY_ID),
    KEY IX_B_CRM_FM_6 (VALUE(20))
);

CREATE TABLE IF NOT EXISTS b_crm_field_multi_phone_country
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	FM_ID INT UNSIGNED NOT NULL,
	COUNTRY_CODE VARCHAR(2) NOT NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_FIELD_MULTI_PHONE_COUNTRY_1 (FM_ID, COUNTRY_CODE),
	INDEX IX_B_CRM_FIELD_MULTI_PHONE_COUNTRY_2 (COUNTRY_CODE)
);

CREATE TABLE b_crm_event
(
	ID int(18) NOT NULL auto_increment,
	DATE_CREATE datetime NOT NULL,
	CREATED_BY_ID int(18) NOT NULL,
	EVENT_ID varchar(50) NULL,
	EVENT_NAME varchar(255) NOT NULL,
	EVENT_TEXT_1 text NULL,
	EVENT_TEXT_2 text NULL,
	EVENT_TYPE int(11) NULL,
	FILES text DEFAULT NULL,
	PRIMARY KEY  (ID),
	INDEX IX_EVENT_1 (DATE_CREATE),
	INDEX IX_B_CRM_EVENT_4 (EVENT_TYPE, DATE_CREATE),
	INDEX IX_B_CRM_EVENT_5 (FILES (8)),
    INDEX IX_B_CRM_EVENT_6 (EVENT_TYPE, EVENT_ID),
    INDEX IX_B_CRM_EVENT_7 (CREATED_BY_ID)
);

CREATE TABLE b_crm_event_relations
(
	ID int(18) NOT NULL auto_increment,
	ASSIGNED_BY_ID int(18) NOT NULL,
	ENTITY_TYPE varchar(50) NULL,
	ENTITY_ID int(11) NOT NULL,
	ENTITY_FIELD varchar(255) NULL,
	EVENT_ID int(18) NOT NULL,
	PRIMARY KEY  (ID),
	KEY IX_EVENT_REL_ENTITY (ENTITY_TYPE, ENTITY_ID, ENTITY_FIELD),
	INDEX IX_EVENT_REL_1 (EVENT_ID),
	INDEX IX_EVENT_REL_2 (ENTITY_TYPE, ENTITY_ID, EVENT_ID)
);

CREATE TABLE b_crm_entity_lock
(
	ENTITY_ID INT (11) NOT NULL,
	ENTITY_TYPE VARCHAR (10) NOT NULL,
	DATE_LOCK DATETIME DEFAULT NULL,
	LOCKED_BY VARCHAR (32) DEFAULT NULL,
	PRIMARY KEY (ENTITY_ID)
);

CREATE TABLE b_crm_entity_perms
(
	ID INT(18) UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY VARCHAR(20) NOT NULL,
	ENTITY_ID INT(18) NOT NULL,
	ATTR VARCHAR(30) NOT NULL,
	PRIMARY KEY (ID),
	INDEX IX_ENTITY_ATTR (ENTITY, ENTITY_ID, ATTR),
	INDEX IX_ENTITY_ATTR_1(ENTITY, ATTR, ENTITY_ID)
);

CREATE TABLE b_crm_role
(
	ID INT(18) UNSIGNED NOT NULL AUTO_INCREMENT,
	NAME VARCHAR(255) NOT NULL,
	IS_SYSTEM CHAR(1) DEFAULT 'N' NOT NULL,
	`CODE` VARCHAR(64),
	`GROUP_CODE` VARCHAR(64),
	PRIMARY KEY (ID)
);

CREATE TABLE b_crm_role_perms
(
	ID INT(18) UNSIGNED NOT NULL AUTO_INCREMENT,
	ROLE_ID INT(18) UNSIGNED NOT NULL,
	ENTITY VARCHAR(20) NOT NULL,
	FIELD VARCHAR(30) DEFAULT '-',
	FIELD_VALUE VARCHAR(255) DEFAULT NULL,
	PERM_TYPE VARCHAR(20) NOT NULL,
	ATTR CHAR(1) DEFAULT '',
	SETTINGS TEXT DEFAULT NULL,
	PRIMARY KEY (ID),
	INDEX IX_ROLE_PERMS_1 (ROLE_ID, PERM_TYPE, ENTITY),
	INDEX IX_ROLE_PERMS_2 (ENTITY,PERM_TYPE,ATTR)
);

CREATE TABLE b_crm_role_relation
(
	ID INT(18) NOT NULL AUTO_INCREMENT,
	ROLE_ID INT(18) UNSIGNED NOT NULL,
	RELATION VARCHAR(100) NOT NULL,
	PRIMARY KEY (ID),
	INDEX IX_ROLE_RELATION (ROLE_ID, RELATION)
);

CREATE TABLE IF NOT EXISTS b_crm_external_sale
(
	ID INT(18) NOT NULL AUTO_INCREMENT,
	ACTIVE CHAR(1) NOT NULL DEFAULT 'Y',
	DATE_CREATE datetime NOT NULL,
	DATE_UPDATE datetime NOT NULL,
	NAME VARCHAR(128) NULL,
	SCHEME VARCHAR(5) NOT NULL DEFAULT 'http',
	SERVER VARCHAR(192) NOT NULL,
	PORT INT(18) NOT NULL DEFAULT 80,
	LOGIN VARCHAR(64) NOT NULL,
	PASSWORD VARCHAR(128) NOT NULL,
	MODIFICATION_LABEL INT(18) NULL,
	IMPORT_SIZE INT(18) NULL,
	IMPORT_PERIOD INT(18) NULL,
	IMPORT_PROBABILITY INT(18) NULL,
	IMPORT_RESPONSIBLE INT(18) NULL,
	IMPORT_PUBLIC char(1) NULL,
	IMPORT_PREFIX VARCHAR(128) NULL,
	IMPORT_ERRORS INT(18) NULL,
	IMPORT_GROUP_ID INT(18) NULL,
	COOKIE TEXT NULL,
	LAST_STATUS TEXT NULL,
	LAST_STATUS_DATE datetime NULL,
	SYNC_DATA TEXT NULL,
	PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_catalog
(
	ID INT(1) NOT NULL,
	ORIGINATOR_ID VARCHAR(255) NULL,
	ORIGIN_ID VARCHAR(255) NULL,
	PRIMARY KEY(ID)
);

CREATE TABLE IF NOT EXISTS b_crm_product
(
	ID INT(1) NOT NULL,
	CATALOG_ID INT(1) NOT NULL,
	CURRENCY_ID VARCHAR(50) NOT NULL,
	PRICE DECIMAL(18,2) NOT NULL DEFAULT 0,
	ORIGINATOR_ID VARCHAR(255) NULL,
	ORIGIN_ID VARCHAR(255) NULL,
	PRIMARY KEY(ID)
);

CREATE TABLE IF NOT EXISTS b_crm_product_row
(
	ID INT(18) UNSIGNED NOT NULL AUTO_INCREMENT,
	OWNER_ID INT(1) NOT NULL,
	OWNER_TYPE VARCHAR(20) NOT NULL,
	PRODUCT_ID INT(1) NOT NULL,
	PRODUCT_NAME VARCHAR(256) NULL,
	PRICE DECIMAL(18,2) NOT NULL,
	PRICE_ACCOUNT DECIMAL(18,2) NOT NULL DEFAULT 0,
	PRICE_EXCLUSIVE DECIMAL(18,2) NULL,
	PRICE_NETTO DECIMAL(18,2) NULL,
	PRICE_BRUTTO DECIMAL(18,2) NULL,
	QUANTITY DECIMAL(18,4) NOT NULL,
	DISCOUNT_TYPE_ID TINYINT(1) UNSIGNED NULL,
	DISCOUNT_RATE DECIMAL(18,2) NULL,
	DISCOUNT_SUM DECIMAL(18,2) NULL,
	TAX_RATE DECIMAL(18,2) NULL,
	TAX_INCLUDED CHAR(1) NULL,
	CUSTOMIZED CHAR(1) NULL,
	MEASURE_CODE INT(1) UNSIGNED NULL,
	MEASURE_NAME VARCHAR(50) NULL,
	SORT INT(1) NULL,
	XML_ID varchar(255) DEFAULT NULL,
	TYPE INT NOT NULL DEFAULT 1,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_PROD_ROW_2(OWNER_ID, OWNER_TYPE, SORT),
	INDEX IX_B_CRM_PROD_PRODUCT(PRODUCT_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_product_row_cfg(
	OWNER_ID INT(1) NOT NULL,
	OWNER_TYPE VARCHAR(20) NOT NULL,
	SETTINGS TEXT,
	PRIMARY KEY(OWNER_ID, OWNER_TYPE)
);

CREATE TABLE IF NOT EXISTS b_crm_act(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	TYPE_ID TINYINT(1) UNSIGNED NOT NULL,
	PROVIDER_ID varchar(100) NULL,
	PROVIDER_TYPE_ID varchar(100) NULL,
	PROVIDER_GROUP_ID varchar(100) NULL,
	OWNER_ID INT(1) NOT NULL,
	OWNER_TYPE_ID INT(1) NOT NULL,
	ASSOCIATED_ENTITY_ID INT(1),
	CALENDAR_EVENT_ID INT(1) UNSIGNED NOT NULL DEFAULT 0,
	SUBJECT VARCHAR(512) NOT NULL,
	IS_HANDLEABLE CHAR(1) NULL,
	COMPLETED CHAR(1) NOT NULL DEFAULT 'N',
	STATUS INT(1) UNSIGNED NOT NULL DEFAULT 0,
	RESPONSIBLE_ID INT(1) NOT NULL,
	PRIORITY INT(1) NOT NULL,
	NOTIFY_TYPE INT(1) NOT NULL,
	NOTIFY_VALUE INT(1) UNSIGNED,
	DESCRIPTION LONGTEXT NULL,
	DESCRIPTION_TYPE TINYINT(1) UNSIGNED NULL,
	DIRECTION TINYINT(1) UNSIGNED NOT NULL,
	LOCATION VARCHAR(256),
	CREATED DATETIME NOT NULL,
	LAST_UPDATED DATETIME NOT NULL,
	START_TIME DATETIME,
	END_TIME DATETIME,
	DEADLINE DATETIME,
	STORAGE_TYPE_ID TINYINT(1) UNSIGNED NULL,
	STORAGE_ELEMENT_IDS TEXT NULL,
	PARENT_ID INT(1) UNSIGNED NOT NULL DEFAULT 0,
	THREAD_ID INT(1) UNSIGNED NOT NULL DEFAULT 0,
	URN VARCHAR(64) NULL,
	SETTINGS TEXT NULL,
	ORIGINATOR_ID VARCHAR(255) NULL,
	ORIGIN_ID VARCHAR(255) NULL,
	AUTHOR_ID INT(1) UNSIGNED NULL,
	EDITOR_ID INT(1) UNSIGNED NULL,
	PROVIDER_PARAMS LONGTEXT NULL,
	PROVIDER_DATA LONGTEXT NULL,
	SEARCH_CONTENT MEDIUMTEXT NULL,
	RESULT_STATUS INT(1) NOT NULL DEFAULT 0,
	RESULT_STREAM INT(1) NOT NULL DEFAULT 0,
	RESULT_SOURCE_ID VARCHAR(255) NULL,
	RESULT_MARK INT(1) NOT NULL DEFAULT 0,
	RESULT_VALUE DECIMAL(18,4) DEFAULT NULL,
	RESULT_SUM DECIMAL(18,4) DEFAULT NULL,
	RESULT_CURRENCY_ID CHAR(3) NULL,
	AUTOCOMPLETE_RULE INT(1) UNSIGNED NOT NULL DEFAULT 0,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_ACT(ID, PARENT_ID, OWNER_ID, OWNER_TYPE_ID),
	INDEX IX_B_CRM_ACT_1(RESPONSIBLE_ID, COMPLETED, DEADLINE),
	INDEX IX_B_CRM_ACT_2 (ASSOCIATED_ENTITY_ID, TYPE_ID),
	INDEX IX_B_CRM_ACT_4 (DEADLINE),
	INDEX IX_B_CRM_ACT_5 (ORIGIN_ID),
	INDEX IX_B_CRM_ACT_8 (PROVIDER_ID),
	INDEX IX_B_CRM_ACT_9 (CALENDAR_EVENT_ID),
	INDEX IX_B_CRM_ACT_10 (URN),
	INDEX IX_B_CRM_ACT_11 (PARENT_ID),
	INDEX IX_B_CRM_ACT_12 (THREAD_ID),
	INDEX IX_B_CRM_ACT_14 (LAST_UPDATED, TYPE_ID),
	INDEX IX_B_CRM_ACT_15 (COMPLETED, DEADLINE),
	INDEX IX_B_CRM_ACT_16 (RESPONSIBLE_ID, OWNER_TYPE_ID, OWNER_ID),
	INDEX IX_B_CRM_ACT_17 (RESPONSIBLE_ID, COMPLETED, START_TIME),
	INDEX IX_B_CRM_ACT_18 (RESPONSIBLE_ID, CREATED),
	INDEX IX_B_CRM_ACT_19 (TYPE_ID, COMPLETED, DEADLINE),
	INDEX IX_B_CRM_ACT_20 (OWNER_ID, OWNER_TYPE_ID, TYPE_ID, COMPLETED, DEADLINE),
	INDEX IX_B_CRM_ACT_21 (ORIGINATOR_ID),
	FULLTEXT INDEX IX_B_CRM_ACT_SEARCH (SEARCH_CONTENT)
);

CREATE TABLE IF NOT EXISTS b_crm_act_bind(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	ACTIVITY_ID INT(1) NOT NULL,
	OWNER_ID INT(1) NOT NULL,
	OWNER_TYPE_ID INT(1) NOT NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_ACT_BIND_2(OWNER_ID, OWNER_TYPE_ID, ACTIVITY_ID),
	INDEX IX_B_CRM_ACT_BIND_3(ACTIVITY_ID, OWNER_TYPE_ID, OWNER_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_act_comm(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	ACTIVITY_ID INT(1) UNSIGNED NOT NULL,
	OWNER_ID INT(1) NOT NULL,
	OWNER_TYPE_ID INT(1) NOT NULL,
	TYPE VARCHAR(64),
	VALUE VARCHAR(256),
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	ENTITY_SETTINGS TEXT,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_ACT_COMM(ACTIVITY_ID, OWNER_ID, OWNER_TYPE_ID, ENTITY_ID, ENTITY_TYPE_ID),
	INDEX IX_B_CRM_ACT_COMM_3(OWNER_ID, OWNER_TYPE_ID, TYPE),
	INDEX IX_B_CRM_ACT_COMM_4(ENTITY_ID, ENTITY_TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_act_elem(
	ACTIVITY_ID INT(1) UNSIGNED NOT NULL,
	STORAGE_TYPE_ID TINYINT(1) UNSIGNED NOT NULL,
	ELEMENT_ID INT(1) UNSIGNED NOT NULL,
	PRIMARY KEY(ACTIVITY_ID, STORAGE_TYPE_ID, ELEMENT_ID),
	INDEX IX_B_CRM_ACT_ELEM_1(ELEMENT_ID, STORAGE_TYPE_ID)
);

CREATE TABLE b_crm_act_app_type(
   ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
   APP_ID INT NOT NULL,
   TYPE_ID VARCHAR(100) NOT NULL,
   NAME VARCHAR(255) NOT NULL,
   ICON_ID INT NOT NULL DEFAULT 0,
   IS_CONFIGURABLE_TYPE CHAR(1) NOT NULL DEFAULT 'N',
   PRIMARY KEY(ID)
);

CREATE TABLE IF NOT EXISTS b_crm_usr_act(
	USER_ID INT(1) UNSIGNED NOT NULL,
	OWNER_ID INT(1) NOT NULL,
	OWNER_TYPE_ID INT(1) NOT NULL,
	ACTIVITY_TIME DATETIME NOT NULL,
	ACTIVITY_ID INT(1) UNSIGNED NOT NULL,
	DEPARTMENT_ID INT(1) UNSIGNED NOT NULL,
	SORT VARCHAR(16) NULL,
	PRIMARY KEY(USER_ID, OWNER_ID, OWNER_TYPE_ID),
	INDEX IX_B_CRM_USR_ACT(USER_ID, OWNER_ID, OWNER_TYPE_ID, ACTIVITY_TIME, ACTIVITY_ID, DEPARTMENT_ID),
	INDEX IX_B_CRM_USR_ACT_2 (OWNER_ID ASC, OWNER_TYPE_ID ASC, USER_ID DESC, SORT DESC)
);

CREATE TABLE IF NOT EXISTS b_crm_usr_mt(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	OWNER_ID INT(1) NOT NULL,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	SCOPE TINYINT(1) UNSIGNED NOT NULL,
	IS_ACTIVE CHAR(1) NOT NULL DEFAULT 'N',
	TITLE VARCHAR(128),
	EMAIL_FROM VARCHAR(255),
	SUBJECT VARCHAR(255),
	BODY_TYPE TINYINT(1) UNSIGNED NULL,
	BODY TEXT,
	SING_REQUIRED CHAR(1) NOT NULL DEFAULT 'N',
	SORT INT(1) NOT NULL DEFAULT 100,
	CREATED DATETIME NOT NULL,
	LAST_UPDATED DATETIME NOT NULL,
	AUTHOR_ID INT(1) UNSIGNED NOT NULL,
	EDITOR_ID INT(1) UNSIGNED NOT NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_USR_MT(OWNER_ID, ENTITY_TYPE_ID, SCOPE, IS_ACTIVE)
);

CREATE TABLE IF NOT EXISTS b_crm_user_mail_template_access(
    ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
    TEMPLATE_ID INT(1) NOT NULL,
    ENTITY_ID INT(1) NOT NULL,
    ENTITY_TYPE TINYINT(1) NOT NULL,
    PRIMARY KEY(ID),
    UNIQUE IX_MAIL_TEMPLATE_ACCESS_1 (TEMPLATE_ID, ENTITY_ID, ENTITY_TYPE),
    INDEX IX_MAIL_TEMPLATE_ACCESS_2 (TEMPLATE_ID),
    INDEX IX_MAIL_TEMPLATE_ACCESS_3 (ENTITY_ID, ENTITY_TYPE)
);

CREATE TABLE IF NOT EXISTS b_crm_sl_rel(
	SL_ID INT NOT NULL,
	SL_EVENT_ID VARCHAR(50) NOT NULL,
	SL_ENTITY_TYPE VARCHAR(50) NOT NULL,
	SL_LAST_UPDATED DATETIME,
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	SL_PARENT_ENTITY_TYPE VARCHAR(50) NOT NULL,
	PARENT_ENTITY_ID INT(1) UNSIGNED NOT NULL,
	LVL TINYINT(1) UNSIGNED NOT NULL DEFAULT 1,
	TYPE_ID TINYINT(1) UNSIGNED NOT NULL DEFAULT 1,
	INDEX IX_B_CRM_SL_REL_1(SL_PARENT_ENTITY_TYPE, PARENT_ENTITY_ID, LVL, SL_ENTITY_TYPE, SL_EVENT_ID, SL_ID),
	INDEX IX_B_CRM_SL_REL_2(SL_ENTITY_TYPE, ENTITY_ID),
	INDEX IX_B_CRM_SL_REL_3(SL_ID, TYPE_ID),
	INDEX IX_B_CRM_SL_REL_4(SL_LAST_UPDATED, SL_PARENT_ENTITY_TYPE, PARENT_ENTITY_ID, LVL, SL_ENTITY_TYPE, SL_EVENT_ID, SL_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_sl_subscr(
	USER_ID INT(1) UNSIGNED NOT NULL,
	SL_ENTITY_TYPE VARCHAR(50) NOT NULL,
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	TYPE_ID TINYINT(1) UNSIGNED NOT NULL,
	PRIMARY KEY(USER_ID, SL_ENTITY_TYPE, ENTITY_ID, TYPE_ID),
	INDEX IX_B_CRM_SL_SUBSCR_1(SL_ENTITY_TYPE, ENTITY_ID, TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_biz_type(
	CODE VARCHAR(32) NOT NULL,
	NAME VARCHAR(256) NOT NULL,
	LANG VARCHAR(2),
	PRIMARY KEY(CODE)
);

CREATE TABLE IF NOT EXISTS b_crm_dp_org_mcd(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	TITLE VARCHAR(256) NOT NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_DP_ORG_MCD_3(TITLE, ENTITY_TYPE_ID, ENTITY_ID),
	INDEX IX_B_CRM_DP_ORG_MCD_4(ENTITY_TYPE_ID, ENTITY_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_dp_comm_mcd(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	TYPE VARCHAR(32) NOT NULL,
	VALUE VARCHAR(256) NOT NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_DP_COMM_MCD_3(TYPE, VALUE, ENTITY_TYPE_ID, ENTITY_ID),
	INDEX IX_B_CRM_DP_COMM_MCD_4(ENTITY_TYPE_ID, ENTITY_ID, TYPE)
);

CREATE TABLE IF NOT EXISTS b_crm_dp_prsn_mcd(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	LAST_NAME VARCHAR (64) NOT NULL,
	NAME VARCHAR (64),
	SECOND_NAME VARCHAR (64),
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_DP_PRSN_MCD_5(ENTITY_TYPE_ID, LAST_NAME, NAME, SECOND_NAME),
	INDEX IX_B_CRM_DP_PRSN_MCD_6(LAST_NAME, NAME, SECOND_NAME, ENTITY_TYPE_ID, ENTITY_ID),
	INDEX IX_B_CRM_DP_PRSN_MCD_7(ENTITY_TYPE_ID, ENTITY_ID),
	INDEX IX_B_CRM_DP_PRSN_MCD_8(LAST_NAME, ENTITY_TYPE_ID, ENTITY_ID, NAME, SECOND_NAME),
	INDEX IX_B_CRM_DP_PRSN_MCD_9(ENTITY_TYPE_ID, ENTITY_ID, LAST_NAME, NAME, SECOND_NAME)
);

CREATE TABLE IF NOT EXISTS b_crm_dp_rq_mcd(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	RQ_COUNTRY_ID INT(1) NOT NULL DEFAULT 0,
	RQ_FIELD_NAME VARCHAR(32) NOT NULL,
	VALUE VARCHAR(32) NOT NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_DP_RQ_MCD_3(RQ_FIELD_NAME, RQ_COUNTRY_ID, VALUE, ENTITY_TYPE_ID, ENTITY_ID),
	INDEX IX_B_CRM_DP_RQ_MCD_4(ENTITY_TYPE_ID, ENTITY_ID, RQ_FIELD_NAME, RQ_COUNTRY_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_dp_bd_mcd(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	BD_COUNTRY_ID INT(1) NOT NULL DEFAULT 0,
	BD_FIELD_NAME VARCHAR(32) NOT NULL,
	VALUE VARCHAR(32) NOT NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_DP_BD_MCD_3(BD_FIELD_NAME, BD_COUNTRY_ID, VALUE, ENTITY_TYPE_ID, ENTITY_ID),
	INDEX IX_B_CRM_DP_BD_MCD_4(ENTITY_TYPE_ID, ENTITY_ID, BD_FIELD_NAME, BD_COUNTRY_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_dp_vol_mcd(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	TYPE_ID INT(1) UNSIGNED NOT NULL,
	VALUE VARCHAR(1024) NOT NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_DP_VOL_MCD_1(TYPE_ID, VALUE(255), ENTITY_TYPE_ID, ENTITY_ID),
	INDEX IX_B_CRM_DP_VOL_MCD_2(ENTITY_TYPE_ID, ENTITY_ID, TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_dp_index_type_settings(
	ID INT(1) UNSIGNED NOT NULL,
	ACTIVE CHAR(1) NOT NULL DEFAULT 'N',
	DESCRIPTION VARCHAR(256) NOT NULL,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	STATE_ID TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
	FIELD_PATH VARCHAR(255) NOT NULL,
	FIELD_NAME VARCHAR(50) NOT NULL,
	PROGRESS_DATA MEDIUMTEXT,
	PRIMARY KEY (ID),
	UNIQUE UK_B_CRM_DP_IDX_TYP_STGS_1 (ENTITY_TYPE_ID, FIELD_PATH, FIELD_NAME)
);

CREATE TABLE IF NOT EXISTS b_crm_quote
(
	ID INT(18) UNSIGNED NOT NULL AUTO_INCREMENT,
	DATE_CREATE DATETIME NOT NULL,
	DATE_MODIFY DATETIME NOT NULL,
	CREATED_BY_ID INT(18) UNSIGNED NOT NULL,
	MODIFY_BY_ID INT(18) UNSIGNED DEFAULT NULL,
	ASSIGNED_BY_ID INT(18) UNSIGNED DEFAULT NULL,
	OPENED CHAR(1) DEFAULT 'N',
	LEAD_ID INT(18) UNSIGNED DEFAULT NULL,
	DEAL_ID INT(18) UNSIGNED DEFAULT NULL,
	COMPANY_ID INT(18) UNSIGNED DEFAULT NULL,
	CONTACT_ID INT(18) UNSIGNED DEFAULT NULL,
	PERSON_TYPE_ID INT NOT NULL,
	MYCOMPANY_ID INT(18) UNSIGNED DEFAULT NULL,
	TITLE VARCHAR(255) DEFAULT NULL,
	STATUS_ID VARCHAR(50) DEFAULT NULL,
	CLOSED CHAR(1) DEFAULT 'N',
	OPPORTUNITY DECIMAL(18,2) DEFAULT NULL,
	IS_MANUAL_OPPORTUNITY CHAR(1) DEFAULT 'N',
	TAX_VALUE DECIMAL(18,2) DEFAULT NULL,
	CURRENCY_ID VARCHAR(50) DEFAULT NULL,
	OPPORTUNITY_ACCOUNT DECIMAL(18,2) DEFAULT NULL,
	TAX_VALUE_ACCOUNT DECIMAL(18,2) DEFAULT NULL,
	ACCOUNT_CURRENCY_ID VARCHAR(50) DEFAULT NULL,
	COMMENTS TEXT DEFAULT NULL,
	COMMENTS_TYPE TINYINT(1) UNSIGNED NULL,
	BEGINDATE DATETIME,
	CLOSEDATE DATETIME,
	EXCH_RATE DECIMAL(20,4) DEFAULT 1,
	QUOTE_NUMBER VARCHAR(100) null,
	CONTENT TEXT DEFAULT NULL,
	CONTENT_TYPE TINYINT(1) UNSIGNED NULL,
	TERMS TEXT DEFAULT NULL,
	TERMS_TYPE TINYINT(1) UNSIGNED NULL,
	STORAGE_TYPE_ID TINYINT(1) UNSIGNED NULL,
	STORAGE_ELEMENT_IDS TEXT NULL,
	LOCATION_ID varchar(100) NULL,
	WEBFORM_ID INT (18) UNSIGNED DEFAULT NULL,
    ACTUAL_DATE DATE NULL,
	CLIENT_TITLE VARCHAR(255) NULL,
	CLIENT_ADDR VARCHAR(255) NULL,
	CLIENT_CONTACT VARCHAR(255) NULL,
	CLIENT_EMAIL VARCHAR(255) NULL,
	CLIENT_PHONE VARCHAR(255) NULL,
	CLIENT_TP_ID VARCHAR(255) NULL,
	CLIENT_TPA_ID VARCHAR(255) NULL,
	SEARCH_CONTENT MEDIUMTEXT NULL,
	LAST_ACTIVITY_BY INT UNSIGNED NOT NULL DEFAULT 0,
	LAST_ACTIVITY_TIME DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID),
	INDEX IX_QUOTE_1 (STATUS_ID, ASSIGNED_BY_ID),
	INDEX IX_QUOTE_2 (COMPANY_ID),
	INDEX IX_QUOTE_3 (CONTACT_ID),
	INDEX IX_QUOTE_4 (DEAL_ID),
	INDEX IX_QUOTE_5 (LEAD_ID),
	INDEX IX_QUOTE_6 (WEBFORM_ID),
	INDEX IX_QUOTE_7 (LAST_ACTIVITY_TIME),
	UNIQUE IXS_QUOTE_NUMBER(QUOTE_NUMBER),
	FULLTEXT INDEX IX_B_CRM_QUOTE_SEARCH (SEARCH_CONTENT)
);

CREATE TABLE IF NOT EXISTS b_crm_quote_elem(
	QUOTE_ID INT(1) UNSIGNED NOT NULL,
	STORAGE_TYPE_ID TINYINT(1) UNSIGNED NOT NULL,
	ELEMENT_ID INT(1) UNSIGNED NOT NULL,
	PRIMARY KEY(QUOTE_ID, STORAGE_TYPE_ID, ELEMENT_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_dp_index(
	USER_ID INT(1) UNSIGNED NOT NULL,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	TYPE_ID INT UNSIGNED NOT NULL,
	SCOPE VARCHAR(6) NOT NULL DEFAULT '',
	MATCH_HASH VARCHAR(32) NOT NULL,
	MATCHES TEXT NULL,
	QUANTITY INT(1) UNSIGNED NOT NULL,
	ROOT_ENTITY_ID INT(1) UNSIGNED NOT NULL,
	ROOT_ENTITY_NAME_FLAG CHAR(1) NOT NULL,
	ROOT_ENTITY_NAME VARCHAR(256) NOT NULL,
	ROOT_ENTITY_TITLE_FLAG CHAR(1) NOT NULL,
	ROOT_ENTITY_TITLE VARCHAR(256) NOT NULL,
	ROOT_ENTITY_PHONE_FLAG CHAR(1) NOT NULL,
	ROOT_ENTITY_PHONE VARCHAR(256) NOT NULL,
	ROOT_ENTITY_EMAIL_FLAG CHAR(1) NOT NULL,
	ROOT_ENTITY_EMAIL VARCHAR(256) NOT NULL,
	ROOT_ENTITY_RQ_INN_FLAG CHAR(1) NOT NULL DEFAULT '1',
	ROOT_ENTITY_RQ_INN VARCHAR(15) NOT NULL DEFAULT '',
	ROOT_ENTITY_RQ_OGRN_FLAG CHAR(1) NOT NULL DEFAULT '1',
	ROOT_ENTITY_RQ_OGRN VARCHAR(13) NOT NULL DEFAULT '',
	ROOT_ENTITY_RQ_OGRNIP_FLAG CHAR(1) NOT NULL DEFAULT '1',
	ROOT_ENTITY_RQ_OGRNIP VARCHAR(15) NOT NULL DEFAULT '',
	ROOT_ENTITY_RQ_BIN_FLAG CHAR(1) NOT NULL DEFAULT '1',
	ROOT_ENTITY_RQ_BIN VARCHAR(12) NOT NULL DEFAULT '',
	ROOT_ENTITY_RQ_EDRPOU_FLAG CHAR(1) NOT NULL DEFAULT '1',
	ROOT_ENTITY_RQ_EDRPOU VARCHAR(10) NOT NULL DEFAULT '',
	ROOT_ENTITY_RQ_VAT_ID_FLAG CHAR(1) NOT NULL DEFAULT '1',
	ROOT_ENTITY_RQ_VAT_ID VARCHAR(20) NOT NULL DEFAULT '',
	ROOT_ENTITY_RQ_ACC_NUM_FLAG CHAR(1) NOT NULL DEFAULT '1',
	ROOT_ENTITY_RQ_ACC_NUM VARCHAR(34) NOT NULL DEFAULT '',
	ROOT_ENTITY_RQ_IBAN_FLAG CHAR(1) NOT NULL DEFAULT '1',
	ROOT_ENTITY_RQ_IBAN VARCHAR(34) NOT NULL DEFAULT '',
	ROOT_ENTITY_RQ_IIK_FLAG CHAR(1) NOT NULL DEFAULT '1',
	ROOT_ENTITY_RQ_IIK VARCHAR(20) NOT NULL DEFAULT '',
	IS_JUNK CHAR(1) NULL,
	STATUS_ID INT UNSIGNED NULL,
	PRIMARY KEY(USER_ID, ENTITY_TYPE_ID, TYPE_ID, MATCH_HASH, SCOPE),
	INDEX IX_B_CRM_DP_IND_1(USER_ID, ENTITY_TYPE_ID, ROOT_ENTITY_NAME_FLAG, ROOT_ENTITY_NAME(255), TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_2(USER_ID, ENTITY_TYPE_ID, ROOT_ENTITY_TITLE_FLAG, ROOT_ENTITY_TITLE(255), TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_3(USER_ID, ENTITY_TYPE_ID, ROOT_ENTITY_PHONE_FLAG, ROOT_ENTITY_PHONE(255), TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_4(USER_ID, ENTITY_TYPE_ID, ROOT_ENTITY_EMAIL_FLAG, ROOT_ENTITY_EMAIL(255), TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_5(MATCH_HASH, TYPE_ID, ENTITY_TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_6(ROOT_ENTITY_ID, ENTITY_TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_7(USER_ID, ENTITY_TYPE_ID, ROOT_ENTITY_RQ_INN_FLAG, ROOT_ENTITY_RQ_INN(15), TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_8(USER_ID, ENTITY_TYPE_ID, ROOT_ENTITY_RQ_OGRN_FLAG, ROOT_ENTITY_RQ_OGRN(13), TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_9(USER_ID, ENTITY_TYPE_ID, ROOT_ENTITY_RQ_OGRNIP_FLAG, ROOT_ENTITY_RQ_OGRNIP(15), TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_10(USER_ID, ENTITY_TYPE_ID, ROOT_ENTITY_RQ_BIN_FLAG, ROOT_ENTITY_RQ_BIN(12), TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_11(USER_ID, ENTITY_TYPE_ID, ROOT_ENTITY_RQ_EDRPOU_FLAG, ROOT_ENTITY_RQ_EDRPOU(10), TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_12(USER_ID, ENTITY_TYPE_ID, ROOT_ENTITY_RQ_VAT_ID_FLAG, ROOT_ENTITY_RQ_VAT_ID(20), TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_13(USER_ID, ENTITY_TYPE_ID, ROOT_ENTITY_RQ_ACC_NUM_FLAG, ROOT_ENTITY_RQ_ACC_NUM(34), TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_14(USER_ID, ENTITY_TYPE_ID, ROOT_ENTITY_RQ_IBAN_FLAG, ROOT_ENTITY_RQ_IBAN(34), TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_15(USER_ID, ENTITY_TYPE_ID, ROOT_ENTITY_RQ_IIK_FLAG, ROOT_ENTITY_RQ_IIK(20), TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_16(USER_ID, ENTITY_TYPE_ID, TYPE_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_17(USER_ID, ENTITY_TYPE_ID, TYPE_ID, STATUS_ID, ROOT_ENTITY_NAME_FLAG, ROOT_ENTITY_NAME(255))
);

CREATE TABLE IF NOT EXISTS b_crm_dp_index_mismatch(
	USER_ID INT(1) UNSIGNED NOT NULL,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	TYPE_ID INT UNSIGNED NOT NULL,
	SCOPE VARCHAR(6) NOT NULL DEFAULT '',
	MATCH_HASH VARCHAR(32) NOT NULL,
	L_ENTITY_ID INT(1) UNSIGNED NOT NULL,
	R_ENTITY_ID INT(1) UNSIGNED NOT NULL,
	PRIMARY KEY(USER_ID, ENTITY_TYPE_ID, TYPE_ID, MATCH_HASH, L_ENTITY_ID, R_ENTITY_ID, SCOPE),
	INDEX IX_B_CRM_DP_IND_MISM_1(L_ENTITY_ID, ENTITY_TYPE_ID),
	INDEX IX_B_CRM_DP_IND_MISM_2(R_ENTITY_ID, ENTITY_TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_dp_entity_stat(
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	RANKING_DATA VARCHAR(512) NULL,
	PRIMARY KEY(ENTITY_ID, ENTITY_TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_dp_entity_hash(
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	TYPE_ID INT UNSIGNED NOT NULL,
	MATCH_HASH VARCHAR(32) NOT NULL,
	SCOPE VARCHAR(6) NOT NULL DEFAULT '',
	IS_PRIMARY CHAR(1) NOT NULL,
	DATE_MODIFY DATETIME DEFAULT CURRENT_TIMESTAMP NULL,
	PRIMARY KEY(ENTITY_ID, ENTITY_TYPE_ID, TYPE_ID, MATCH_HASH, SCOPE),
	INDEX IX_B_CRM_DP_ENT_HASH_1(ENTITY_TYPE_ID, TYPE_ID, MATCH_HASH, SCOPE, ENTITY_ID, IS_PRIMARY)
);

CREATE TABLE IF NOT EXISTS b_crm_addr(
	ID BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
	TYPE_ID TINYINT(1) UNSIGNED NOT NULL,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	ANCHOR_TYPE_ID TINYINT(1) UNSIGNED,
	ANCHOR_ID INT(1) UNSIGNED,
	ADDRESS_1 VARCHAR(1024),
	ADDRESS_2 VARCHAR(1024),
	CITY VARCHAR(128),
	POSTAL_CODE VARCHAR(16),
	REGION VARCHAR(128),
	PROVINCE VARCHAR(128),
	COUNTRY VARCHAR(128),
	COUNTRY_CODE VARCHAR(100),
	LOC_ADDR_ID INT(1) UNSIGNED NOT NULL DEFAULT 0,
	IS_DEF TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_ADDR_1(ENTITY_TYPE_ID, TYPE_ID, ADDRESS_1(255), ENTITY_ID),
	INDEX IX_B_CRM_ADDR_3(ENTITY_TYPE_ID, TYPE_ID, CITY, ENTITY_ID),
	INDEX IX_B_CRM_ADDR_4(ENTITY_TYPE_ID, TYPE_ID, POSTAL_CODE, ENTITY_ID),
	INDEX IX_B_CRM_ADDR_5(ENTITY_TYPE_ID, TYPE_ID, REGION, ENTITY_ID),
	INDEX IX_B_CRM_ADDR_6(ENTITY_TYPE_ID, TYPE_ID, PROVINCE, ENTITY_ID),
	INDEX IX_B_CRM_ADDR_7(ENTITY_TYPE_ID, TYPE_ID, COUNTRY, ENTITY_ID),
	INDEX IX_B_CRM_ADDR_8(ANCHOR_TYPE_ID, TYPE_ID, ADDRESS_1(255), ANCHOR_ID),
	INDEX IX_B_CRM_ADDR_10(ANCHOR_TYPE_ID, TYPE_ID, CITY, ANCHOR_ID),
	INDEX IX_B_CRM_ADDR_11(ANCHOR_TYPE_ID, TYPE_ID, POSTAL_CODE, ANCHOR_ID),
	INDEX IX_B_CRM_ADDR_12(ANCHOR_TYPE_ID, TYPE_ID, REGION, ANCHOR_ID),
	INDEX IX_B_CRM_ADDR_13(ANCHOR_TYPE_ID, TYPE_ID, PROVINCE, ANCHOR_ID),
	INDEX IX_B_CRM_ADDR_14(ANCHOR_TYPE_ID, TYPE_ID, COUNTRY, ANCHOR_ID),
	INDEX IX_B_CRM_ADDR_15(ANCHOR_TYPE_ID, ANCHOR_ID, TYPE_ID),
	INDEX IX_B_CRM_ADDR_16 (LOC_ADDR_ID),
    INDEX IX_B_CRM_ADDR_17(ENTITY_TYPE_ID, TYPE_ID, ADDRESS_2(255), ENTITY_ID),
    INDEX IX_B_CRM_ADDR_18(ANCHOR_TYPE_ID, TYPE_ID, ADDRESS_2(255), ANCHOR_ID),
    INDEX IX_B_CRM_ADDR_19(ENTITY_ID, ENTITY_TYPE_ID),
	UNIQUE IX_B_CRM_ADDR_20 (TYPE_ID, ENTITY_TYPE_ID, ENTITY_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_deal_stage_history(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	TYPE_ID INT(1) UNSIGNED NOT NULL,
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	CREATED_TIME DATETIME NOT NULL,
	CREATED_DATE DATE NULL,
	EFFECTIVE_DATE DATE NULL,
	START_DATE DATE NOT NULL,
	END_DATE DATE NOT NULL,
	PERIOD_YEAR INT(1) UNSIGNED NOT NULL,
	PERIOD_QUARTER INT(1) UNSIGNED NOT NULL,
	PERIOD_MONTH INT(1) UNSIGNED NOT NULL,
	START_PERIOD_YEAR INT(1) UNSIGNED NOT NULL,
	START_PERIOD_QUARTER INT(1) UNSIGNED NOT NULL,
	START_PERIOD_MONTH INT(1) UNSIGNED NOT NULL,
	END_PERIOD_YEAR INT(1) UNSIGNED NOT NULL,
	END_PERIOD_QUARTER INT(1) UNSIGNED NOT NULL,
	END_PERIOD_MONTH INT(1) UNSIGNED NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	CATEGORY_ID INT (18) UNSIGNED NULL,
	STAGE_SEMANTIC_ID VARCHAR(3) NULL,
	STAGE_ID VARCHAR(50) NULL,
	IS_LOST CHAR(1) NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_DEAL_SHX_2(TYPE_ID, STAGE_ID, START_DATE, RESPONSIBLE_ID, OWNER_ID),
	INDEX IX_B_CRM_DEAL_SHX_3(TYPE_ID, STAGE_ID, END_DATE, RESPONSIBLE_ID, OWNER_ID),
	INDEX IX_B_CRM_DEAL_SHX_4(TYPE_ID, STAGE_ID, CREATED_TIME, RESPONSIBLE_ID, OWNER_ID),
	INDEX IX_B_CRM_DEAL_SHX_5(PERIOD_YEAR, PERIOD_MONTH, RESPONSIBLE_ID, OWNER_ID, START_DATE, END_DATE),
	INDEX IX_B_CRM_DEAL_SHX_6(PERIOD_YEAR, PERIOD_MONTH, STAGE_SEMANTIC_ID, RESPONSIBLE_ID, OWNER_ID, START_DATE, END_DATE),
	INDEX IX_B_CRM_DEAL_SHX_7(PERIOD_YEAR, PERIOD_MONTH, OWNER_ID, START_DATE, END_DATE),
	INDEX IX_B_CRM_DEAL_SHX_8(TYPE_ID, OWNER_ID, END_DATE, START_DATE),
	INDEX IX_B_CRM_DEAL_SHX_9(TYPE_ID, STAGE_ID, CREATED_DATE, RESPONSIBLE_ID, OWNER_ID),
	INDEX IX_B_CRM_DEAL_SHX_10(CATEGORY_ID, TYPE_ID, STAGE_ID, START_DATE, RESPONSIBLE_ID, OWNER_ID),
	INDEX IX_B_CRM_DEAL_SHX_11(CATEGORY_ID, TYPE_ID, STAGE_ID, END_DATE, RESPONSIBLE_ID, OWNER_ID),
	INDEX IX_B_CRM_DEAL_SHX_12(CATEGORY_ID, TYPE_ID, STAGE_ID, CREATED_DATE, RESPONSIBLE_ID, OWNER_ID),
	INDEX IX_B_CRM_DEAL_SHX_13(IS_LOST, CREATED_DATE, OWNER_ID, RESPONSIBLE_ID),
	INDEX IX_B_CRM_DEAL_SHX_14(CATEGORY_ID, IS_LOST, CREATED_DATE, OWNER_ID, RESPONSIBLE_ID),
	INDEX IX_B_CRM_DEAL_SHX_15(CATEGORY_ID, IS_LOST, STAGE_ID, EFFECTIVE_DATE, OWNER_ID, RESPONSIBLE_ID),
	INDEX IX_B_CRM_DEAL_SHX_16(OWNER_ID, TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_deal_stage_history_with_supposed (
		ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
		OWNER_ID INT(1) UNSIGNED NOT NULL,
		CREATED_TIME DATETIME NULL,
		CREATED_DATE DATE NULL,
		CATEGORY_ID INT(18) UNSIGNED NULL,
		STAGE_SEMANTIC_ID VARCHAR(3) NULL,
		STAGE_ID VARCHAR(50) NULL,
		IS_LOST CHAR(1) NULL,
		IS_SUPPOSED CHAR(1) NOT NULL DEFAULT 'N',
		LAST_UPDATE_DATE DATE NULL,
		CLOSE_DATE DATE NOT NULL DEFAULT '3000-12-12',
		SPENT_TIME INT NULL,
		PRIMARY KEY (ID),
		INDEX IX_B_CRM_HISTORY_WITH_SUPPOSED_DATES_1 (LAST_UPDATE_DATE, CLOSE_DATE),
		INDEX IX_B_CRM_HISTORY_WITH_SUPPOSED_DATES_2 (CLOSE_DATE, LAST_UPDATE_DATE),
		INDEX IX_B_CRM_HISTORY_WITH_SUPPOSED_OWNER_ID (OWNER_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_deal_sum_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	CREATED_DATE DATE NOT NULL,
	START_DATE DATE NOT NULL,
	END_DATE DATE NOT NULL,
	PERIOD_YEAR INT(1) UNSIGNED NOT NULL,
	PERIOD_QUARTER INT(1) UNSIGNED NOT NULL,
	PERIOD_MONTH INT(1) UNSIGNED NOT NULL,
	PERIOD_DAY INT(1) UNSIGNED NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	CATEGORY_ID INT(1) UNSIGNED NULL,
	STAGE_SEMANTIC_ID VARCHAR(3) NULL,
	STAGE_ID VARCHAR(50) NULL,
	IS_LOST CHAR(1) NULL,
	CURRENCY_ID CHAR(3) NULL,
	SUM_TOTAL DECIMAL(18,2) NULL,
	UF_SUM_1 DECIMAL(18,2) NULL,
	UF_SUM_2 DECIMAL(18,2) NULL,
	UF_SUM_3 DECIMAL(18,2) NULL,
	UF_SUM_4 DECIMAL(18,2) NULL,
	UF_SUM_5 DECIMAL(18,2) NULL,
	UF_ATTR_1 INT NULL,
	PRIMARY KEY(OWNER_ID, CREATED_DATE),
	INDEX IX_B_CRM_DEAL_SSTAT_1(STAGE_SEMANTIC_ID, OWNER_ID, END_DATE, START_DATE, CREATED_DATE, RESPONSIBLE_ID),
	INDEX IX_B_CRM_DEAL_SSTAT_2(IS_LOST, OWNER_ID, END_DATE, START_DATE, CREATED_DATE, RESPONSIBLE_ID),
	INDEX IX_B_CRM_DEAL_SSTAT_3(END_DATE, START_DATE, OWNER_ID, CREATED_DATE, RESPONSIBLE_ID),
	INDEX IX_B_CRM_DEAL_SSTAT_4(CATEGORY_ID, END_DATE, START_DATE, OWNER_ID, CREATED_DATE, RESPONSIBLE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_deal_inv_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	CREATED_DATE DATE NOT NULL,
	START_DATE DATE NOT NULL,
	END_DATE DATE NOT NULL,
	PERIOD_YEAR INT(1) UNSIGNED NOT NULL,
	PERIOD_QUARTER INT(1) UNSIGNED NOT NULL,
	PERIOD_MONTH INT(1) UNSIGNED NOT NULL,
	PERIOD_DAY INT(1) UNSIGNED NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	CATEGORY_ID INT(1) UNSIGNED NULL,
	STAGE_SEMANTIC_ID VARCHAR(3) NULL,
	STAGE_ID VARCHAR(50) NULL,
	IS_LOST CHAR(1) NULL,
	CURRENCY_ID CHAR(3) NULL,
	INVOICE_SUM DECIMAL(18,2) NULL,
	INVOICE_QTY INT(1) UNSIGNED NULL,
	TOTAL_INVOICE_SUM DECIMAL(18,2) NULL,
	TOTAL_INVOICE_QTY INT(1) UNSIGNED NULL,
	TOTAL_SUM DECIMAL(18,2) NULL,
	TOTAL_OWED DECIMAL(18,2) NULL,
	UF_ATTR_1 INT NULL,
	PRIMARY KEY(OWNER_ID, CREATED_DATE),
	INDEX IX_B_CRM_DEAL_ISTAT_1(STAGE_SEMANTIC_ID, OWNER_ID, END_DATE, START_DATE, CREATED_DATE, RESPONSIBLE_ID),
	INDEX IX_B_CRM_DEAL_ISTAT_2(IS_LOST, OWNER_ID, END_DATE, START_DATE, CREATED_DATE, RESPONSIBLE_ID),
	INDEX IX_B_CRM_DEAL_ISTAT_3(CATEGORY_ID, IS_LOST, OWNER_ID, END_DATE, START_DATE, CREATED_DATE, RESPONSIBLE_ID),
	INDEX IX_B_CRM_DEAL_ISTAT_4(CATEGORY_ID, STAGE_SEMANTIC_ID, OWNER_ID, END_DATE, START_DATE, CREATED_DATE, RESPONSIBLE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_deal_act_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	DEADLINE_DATE DATE NOT NULL,
	DEADLINE_YEAR INT(1) UNSIGNED NOT NULL,
	DEADLINE_QUARTER INT(1) UNSIGNED NOT NULL,
	DEADLINE_MONTH INT(1) UNSIGNED NOT NULL,
	DEADLINE_DAY INT(1) UNSIGNED NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	CATEGORY_ID INT(1) UNSIGNED NULL,
	STAGE_SEMANTIC_ID VARCHAR(3) NULL,
	STAGE_ID VARCHAR(50) NULL,
	IS_LOST CHAR(1) NULL,
	CALL_QTY INT(1) UNSIGNED NULL,
	MEETING_QTY INT(1) UNSIGNED NULL,
	EMAIL_QTY INT(1) UNSIGNED NULL,
	UF_ATTR_1 INT NULL,
	PRIMARY KEY(OWNER_ID, DEADLINE_DATE),
	INDEX IX_B_CRM_DEAL_ASTAT_1(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, CALL_QTY, MEETING_QTY, EMAIL_QTY),
	INDEX IX_B_CRM_DEAL_ASTAT_2(DEADLINE_DATE, OWNER_ID, CALL_QTY, MEETING_QTY, EMAIL_QTY),
	INDEX IX_B_CRM_DEAL_ASTAT_3(IS_LOST, DEADLINE_DATE, OWNER_ID, RESPONSIBLE_ID),
	INDEX IX_B_CRM_DEAL_ASTAT_4(CATEGORY_ID, IS_LOST, DEADLINE_DATE, OWNER_ID, RESPONSIBLE_ID),
	INDEX IX_B_CRM_DEAL_ASTAT_5(CATEGORY_ID, RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, CALL_QTY, MEETING_QTY, EMAIL_QTY)
);

CREATE TABLE IF NOT EXISTS b_crm_conv_map(
	SRC_TYPE_ID INT(1) NOT NULL,
	DST_TYPE_ID INT(1) NOT NULL,
	`RELATION_TYPE` varchar(20) NOT NULL,
	`IS_CHILDREN_LIST_ENABLED` char(1) NOT NULL DEFAULT 'Y',
	LAST_UPDATED DATETIME NOT NULL,
	DATA LONGTEXT NULL,
	PRIMARY KEY(DST_TYPE_ID, SRC_TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_lead_status_history(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	TYPE_ID INT(1) UNSIGNED NOT NULL,
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	CREATED_TIME DATETIME NOT NULL,
	CREATED_DATE DATE NULL,
	PERIOD_YEAR INT(1) UNSIGNED NOT NULL,
	PERIOD_QUARTER INT(1) UNSIGNED NOT NULL,
	PERIOD_MONTH INT(1) UNSIGNED NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	STATUS_SEMANTIC_ID VARCHAR(3) NULL,
	STATUS_ID VARCHAR(50) NULL,
	IS_IN_WORK CHAR(1) NULL,
	IS_JUNK CHAR(1) NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_LEAD_SHX_2(TYPE_ID, CREATED_DATE, STATUS_ID, RESPONSIBLE_ID),
	INDEX IX_B_CRM_LEAD_SHX_3(TYPE_ID, IS_JUNK, CREATED_DATE),
	INDEX IX_B_CRM_LEAD_SHX_4(TYPE_ID, IS_JUNK, RESPONSIBLE_ID, CREATED_DATE),
	INDEX IX_B_CRM_LEAD_SHX_5(IS_IN_WORK, OWNER_ID, CREATED_DATE),
	INDEX IX_B_CRM_LEAD_SHX_6(IS_IN_WORK, OWNER_ID, RESPONSIBLE_ID, CREATED_DATE),
	INDEX IX_B_CRM_LEAD_SHX_7(IS_JUNK, STATUS_ID, CREATED_DATE, OWNER_ID, RESPONSIBLE_ID),
	INDEX IX_B_CRM_LEAD_SHX_8(OWNER_ID, TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_lead_status_history_with_supposed(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	CREATED_TIME DATETIME NULL,
	CREATED_DATE DATE NULL,
	STATUS_SEMANTIC_ID VARCHAR(3) NULL,
	STATUS_ID VARCHAR(50) NULL,
	IS_LOST CHAR(1) NULL,
	IS_SUPPOSED CHAR(1) NOT NULL DEFAULT 'N',
	LAST_UPDATE_DATE DATE NULL,
	CLOSE_DATE DATE NOT NULL DEFAULT '3000-12-12',
	SPENT_TIME INT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_LEAD_STATUS_HISTORY_WITH_SUPPOSED_1 (LAST_UPDATE_DATE, CLOSE_DATE),
	INDEX IX_B_CRM_LEAD_STATUS_HISTORY_WITH_SUPPOSED_2 (CLOSE_DATE, LAST_UPDATE_DATE),
	INDEX IX_B_CRM_LEAD_STATUS_HISTORY_WITH_SUPPOSED_3 (OWNER_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_lead_sum_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	CREATED_DATE DATE NOT NULL,
	PERIOD_YEAR INT(1) UNSIGNED NOT NULL,
	PERIOD_QUARTER INT(1) UNSIGNED NOT NULL,
	PERIOD_MONTH INT(1) UNSIGNED NOT NULL,
	PERIOD_DAY INT(1) UNSIGNED NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	STATUS_SEMANTIC_ID VARCHAR(3) NULL,
	STATUS_ID VARCHAR(50) NULL,
	SOURCE_ID VARCHAR(50) NULL,
	IS_JUNK CHAR(1) NULL,
	CURRENCY_ID CHAR(3) NULL,
	SUM_TOTAL DECIMAL(18,2) NULL,
	UF_SUM_1 DECIMAL(18,2) NULL,
	UF_SUM_2 DECIMAL(18,2) NULL,
	UF_SUM_3 DECIMAL(18,2) NULL,
	UF_SUM_4 DECIMAL(18,2) NULL,
	UF_SUM_5 DECIMAL(18,2) NULL,
	UF_ATTR_1 INT NULL,
	PRIMARY KEY(OWNER_ID, CREATED_DATE),
	INDEX IX_B_CRM_LEAD_SSTAT_1(CREATED_DATE, OWNER_ID, SOURCE_ID),
	INDEX IX_B_CRM_LEAD_SSTAT_3(SOURCE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_lead_act_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	DEADLINE_DATE DATE NOT NULL,
	DEADLINE_YEAR INT(1) UNSIGNED NOT NULL,
	DEADLINE_QUARTER INT(1) UNSIGNED NOT NULL,
	DEADLINE_MONTH INT(1) UNSIGNED NOT NULL,
	DEADLINE_DAY INT(1) UNSIGNED NOT NULL,
	CREATED_DATE DATE NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	STATUS_SEMANTIC_ID VARCHAR(3) NULL,
	STATUS_ID VARCHAR(50) NULL,
	IS_JUNK CHAR(1) NULL,
	CALL_QTY INT(1) UNSIGNED NULL,
	MEETING_QTY INT(1) UNSIGNED NULL,
	EMAIL_QTY INT(1) UNSIGNED NULL,
	UF_ATTR_1 INT NULL,
	PRIMARY KEY(OWNER_ID, DEADLINE_DATE),
	INDEX IX_B_CRM_LEAD_ASTAT_1(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, CALL_QTY, MEETING_QTY, EMAIL_QTY),
	INDEX IX_B_CRM_LEAD_ASTAT_2(DEADLINE_DATE, OWNER_ID, CALL_QTY, MEETING_QTY, EMAIL_QTY),
	INDEX IX_B_CRM_LEAD_ASTAT_4(IS_JUNK, OWNER_ID, RESPONSIBLE_ID, DEADLINE_DATE),
	INDEX IX_B_CRM_LEAD_ASTAT_5(RESPONSIBLE_ID, DEADLINE_DATE, CALL_QTY, MEETING_QTY, EMAIL_QTY),
	INDEX IX_B_CRM_LEAD_ASTAT_6(IS_JUNK)
);

CREATE TABLE IF NOT EXISTS b_crm_lead_conv_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	ENTRY_DATE DATE NOT NULL,
	CREATED_DATE DATE NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	DEAL_QTY INT(1) UNSIGNED NULL,
	CONTACT_QTY INT(1) UNSIGNED NULL,
	COMPANY_QTY INT(1) UNSIGNED NULL,
	TOTALS_DATE DATE NULL,
	PRIMARY KEY(OWNER_ID, ENTRY_DATE),
	INDEX IX_B_CRM_LEAD_CSTAT_1(RESPONSIBLE_ID, ENTRY_DATE, OWNER_ID, DEAL_QTY, CONTACT_QTY, COMPANY_QTY),
	INDEX IX_B_CRM_LEAD_CSTAT_2(CREATED_DATE, OWNER_ID, DEAL_QTY, CONTACT_QTY, COMPANY_QTY)
);

CREATE TABLE IF NOT EXISTS b_crm_inv_status_history(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	TYPE_ID INT(1) UNSIGNED NOT NULL,
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	CREATED_TIME DATETIME NOT NULL,
	CREATED_DATE DATE NULL,
	BILL_DATE DATE NOT NULL,
	PAY_BEFORE_DATE DATE NOT NULL,
	ACTIVITY_DATE DATE NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	STATUS_SEMANTIC_ID VARCHAR(3) NULL,
	STATUS_ID VARCHAR(50) NULL,
	IS_NEW CHAR(1) NULL,
	IS_JUNK CHAR(1) NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_INV_SHX_2(TYPE_ID, CREATED_DATE, STATUS_ID, OWNER_ID, RESPONSIBLE_ID),
	INDEX IX_B_CRM_INV_SHX_4(IS_JUNK, STATUS_ID, CREATED_DATE, OWNER_ID, RESPONSIBLE_ID),
	INDEX IX_B_CRM_INV_SHX_5(ACTIVITY_DATE, OWNER_ID),
	INDEX IX_B_CRM_INV_SHX_6(STATUS_SEMANTIC_ID, ACTIVITY_DATE, OWNER_ID),
	INDEX IX_B_CRM_INV_SHX_7(OWNER_ID, ACTIVITY_DATE)
);

CREATE TABLE IF NOT EXISTS b_crm_invoice_sum_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	CREATED_DATE DATE NOT NULL,
	BILL_DATE DATE NOT NULL,
	PAY_BEFORE_DATE DATE NOT NULL,
	PAID_DATE DATE NULL,
	IS_PAID_INTIME CHAR(1) NULL,
	CLOSED_DATE DATE NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	COMPANY_ID INT(1) UNSIGNED NULL,
	CONTACT_ID INT(1) UNSIGNED NULL,
	STATUS_SEMANTIC_ID VARCHAR(3) NULL,
	STATUS_ID VARCHAR(50) NULL,
	IS_JUNK CHAR(1) NULL,
	CURRENCY_ID CHAR(3) NULL,
	SUM_TOTAL DECIMAL(18,2) NULL,
	UF_SUM_1 DECIMAL(18,2) NULL,
	UF_SUM_2 DECIMAL(18,2) NULL,
	UF_SUM_3 DECIMAL(18,2) NULL,
	UF_SUM_4 DECIMAL(18,2) NULL,
	UF_SUM_5 DECIMAL(18,2) NULL,
	UF_ATTR_1 INT NULL,
	PRIMARY KEY(OWNER_ID, CREATED_DATE),
	INDEX IX_B_CRM_INV_SSTAT_1(CREATED_DATE, OWNER_ID, RESPONSIBLE_ID),
	INDEX IX_B_CRM_INV_SSTAT_2(STATUS_SEMANTIC_ID, CREATED_DATE, OWNER_ID),
	INDEX IX_B_CRM_INV_SSTAT_6(STATUS_SEMANTIC_ID, PAY_BEFORE_DATE),
	INDEX IX_B_CRM_INV_SSTAT_7(COMPANY_ID, STATUS_SEMANTIC_ID, IS_PAID_INTIME),
	INDEX IX_B_CRM_INV_SSTAT_8(CONTACT_ID, STATUS_SEMANTIC_ID, IS_PAID_INTIME)
);

CREATE TABLE IF NOT EXISTS b_crm_requisite(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	PRESET_ID INT(1) UNSIGNED NOT NULL DEFAULT 0,
	DATE_CREATE DATETIME NOT NULL,
	DATE_MODIFY DATETIME NULL,
	CREATED_BY_ID INT UNSIGNED NOT NULL,
	MODIFY_BY_ID INT UNSIGNED DEFAULT NULL,
	NAME VARCHAR(255) NOT NULL,
	CODE VARCHAR(45) NULL,
	XML_ID VARCHAR(45) NULL,
	ORIGINATOR_ID VARCHAR(255) NULL,
	ACTIVE CHAR(1) NOT NULL DEFAULT 'Y',
    ADDRESS_ONLY CHAR(1) NOT NULL DEFAULT 'N',
	SORT INT NOT NULL DEFAULT 500,
	RQ_NAME VARCHAR(150) NULL,
	RQ_FIRST_NAME VARCHAR(50) NULL,
	RQ_LAST_NAME VARCHAR(50) NULL,
	RQ_SECOND_NAME VARCHAR(50) NULL,
	RQ_COMPANY_ID VARCHAR(255) NULL,
	RQ_COMPANY_NAME VARCHAR(255) NULL,
	RQ_COMPANY_FULL_NAME VARCHAR(300) NULL,
	RQ_COMPANY_REG_DATE VARCHAR(30) NULL,
	RQ_DIRECTOR VARCHAR(150) NULL,
	RQ_ACCOUNTANT VARCHAR(150) NULL,
	RQ_CEO_NAME VARCHAR(150) NULL,
	RQ_CEO_WORK_POS VARCHAR(150) NULL,
	RQ_CONTACT VARCHAR(150) NULL,
	RQ_EMAIL VARCHAR(255) NULL,
	RQ_PHONE VARCHAR(30) NULL,
	RQ_FAX VARCHAR(30) NULL,
	RQ_IDENT_DOC VARCHAR(255) NULL,
	RQ_IDENT_DOC_SER VARCHAR(25) NULL,
	RQ_IDENT_DOC_NUM VARCHAR(25) NULL,
	RQ_IDENT_DOC_PERS_NUM VARCHAR(25) NULL,
	RQ_IDENT_DOC_DATE VARCHAR(30) NULL,
	RQ_IDENT_DOC_ISSUED_BY VARCHAR(255) NULL,
	RQ_IDENT_DOC_DEP_CODE VARCHAR(25) NULL,
	RQ_INN VARCHAR(15) NULL,
	RQ_KPP VARCHAR(9) NULL,
	RQ_USRLE VARCHAR(20) NULL,
	RQ_IFNS VARCHAR(255) NULL,
	RQ_OGRN VARCHAR(13) NULL,
	RQ_OGRNIP VARCHAR(15) NULL,
	RQ_OKPO VARCHAR(12) NULL,
	RQ_OKTMO VARCHAR(11) NULL,
	RQ_OKVED VARCHAR(255) NULL,
	RQ_EDRPOU VARCHAR(10) NULL,
	RQ_DRFO VARCHAR(10) NULL,
	RQ_KBE VARCHAR(2) NULL,
	RQ_IIN VARCHAR(12) NULL,
	RQ_BIN VARCHAR(12) NULL,
	RQ_ST_CERT_SER VARCHAR(10) NULL,
	RQ_ST_CERT_NUM VARCHAR(15) NULL,
	RQ_ST_CERT_DATE VARCHAR(30) NULL,
	RQ_VAT_PAYER CHAR(1) NOT NULL DEFAULT 'N',
	RQ_VAT_ID VARCHAR(20) NULL,
	RQ_VAT_CERT_SER VARCHAR(10) NULL,
	RQ_VAT_CERT_NUM VARCHAR(15) NULL,
	RQ_VAT_CERT_DATE VARCHAR(30) NULL,
	RQ_RESIDENCE_COUNTRY VARCHAR(128) NULL,
	RQ_BASE_DOC VARCHAR(255) NULL,
	RQ_REGON VARCHAR(9) NULL,
	RQ_KRS VARCHAR(10) NULL,
	RQ_PESEL VARCHAR(11) NULL,
	RQ_LEGAL_FORM VARCHAR(80) NULL,
	RQ_SIRET VARCHAR(20) NULL,
	RQ_SIREN VARCHAR(15) NULL,
	RQ_CAPITAL VARCHAR(30) NULL,
	RQ_RCS VARCHAR(50) NULL,
	RQ_CNPJ VARCHAR(20) NULL,
	RQ_STATE_REG VARCHAR(25) NULL,
	RQ_MNPL_REG VARCHAR(20) NULL,
	RQ_CPF VARCHAR(20) NULL,
	RQ_IDENT_TYPE VARCHAR(50) NULL,
	RQ_SIGNATURE INT NULL,
	RQ_STAMP INT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_REQUISITE_2 (RQ_NAME),
	INDEX IX_B_CRM_REQUISITE_3 (RQ_LAST_NAME,RQ_FIRST_NAME,RQ_SECOND_NAME),
	INDEX IX_B_CRM_REQUISITE_4 (RQ_COMPANY_NAME),
	INDEX IX_B_CRM_REQUISITE_5 (RQ_DIRECTOR),
	INDEX IX_B_CRM_REQUISITE_6 (RQ_ACCOUNTANT),
	INDEX IX_B_CRM_REQUISITE_7 (RQ_CEO_NAME),
	INDEX IX_B_CRM_REQUISITE_8 (RQ_CONTACT),
	INDEX IX_B_CRM_REQUISITE_9 (RQ_EMAIL),
	INDEX IX_B_CRM_REQUISITE_10 (RQ_PHONE),
	INDEX IX_B_CRM_REQUISITE_11 (RQ_FAX),
	INDEX IX_B_CRM_REQUISITE_12 (RQ_IDENT_DOC_NUM,RQ_IDENT_DOC_SER),
	INDEX IX_B_CRM_REQUISITE_13 (RQ_IDENT_DOC_DEP_CODE),
	INDEX IX_B_CRM_REQUISITE_14 (RQ_INN),
	INDEX IX_B_CRM_REQUISITE_15 (RQ_KPP),
	INDEX IX_B_CRM_REQUISITE_16 (RQ_USRLE),
	INDEX IX_B_CRM_REQUISITE_17 (RQ_IFNS),
	INDEX IX_B_CRM_REQUISITE_18 (RQ_OGRN),
	INDEX IX_B_CRM_REQUISITE_19 (RQ_OGRNIP),
	INDEX IX_B_CRM_REQUISITE_20 (RQ_OKPO),
	INDEX IX_B_CRM_REQUISITE_21 (RQ_OKTMO),
	INDEX IX_B_CRM_REQUISITE_22 (RQ_OKVED),
	INDEX IX_B_CRM_REQUISITE_23 (RQ_EDRPOU),
	INDEX IX_B_CRM_REQUISITE_24 (RQ_DRFO),
	INDEX IX_B_CRM_REQUISITE_25 (RQ_KBE),
	INDEX IX_B_CRM_REQUISITE_26 (RQ_IIN),
	INDEX IX_B_CRM_REQUISITE_27 (RQ_BIN),
	INDEX IX_B_CRM_REQUISITE_28 (RQ_VAT_PAYER),
	INDEX IX_B_CRM_REQUISITE_29 (RQ_VAT_ID),
	INDEX IX_B_CRM_REQUISITE_30 (RQ_VAT_CERT_NUM,RQ_VAT_CERT_SER),
	INDEX IX_B_CRM_REQUISITE_31 (RQ_RESIDENCE_COUNTRY),
	INDEX IX_B_CRM_REQUISITE_32 (RQ_IDENT_DOC_PERS_NUM),
	INDEX IX_B_CRM_REQUISITE_33 (RQ_ST_CERT_NUM,RQ_ST_CERT_SER),
	INDEX IX_B_CRM_REQUISITE_34 (ENTITY_TYPE_ID, PRESET_ID),
	INDEX IX_B_CRM_REQUISITE_35 (ENTITY_TYPE_ID, ENTITY_ID, PRESET_ID),
	INDEX IX_B_CRM_REQUISITE_36 (ENTITY_ID, ENTITY_TYPE_ID, SORT),
	INDEX IX_B_CRM_REQUISITE_37 (RQ_REGON),
	INDEX IX_B_CRM_REQUISITE_38 (RQ_KRS),
	INDEX IX_B_CRM_REQUISITE_39 (RQ_PESEL),
	INDEX IX_B_CRM_REQUISITE_40 (RQ_IDENT_TYPE),
	INDEX IX_B_CRM_REQUISITE_41 (RQ_COMPANY_ID),
	INDEX IX_B_CRM_REQUISITE_42 (RQ_SIRET),
	INDEX IX_B_CRM_REQUISITE_43 (RQ_SIREN),
	INDEX IX_B_CRM_REQUISITE_44 (RQ_RCS),
	INDEX IX_B_CRM_REQUISITE_45 (RQ_CNPJ),
	INDEX IX_B_CRM_REQUISITE_46 (RQ_STATE_REG),
	INDEX IX_B_CRM_REQUISITE_47 (RQ_MNPL_REG),
	INDEX IX_B_CRM_REQUISITE_48 (RQ_CPF),
	INDEX IX_B_CRM_REQUISITE_49 (PRESET_ID)
);
CREATE TABLE IF NOT EXISTS b_crm_preset(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	COUNTRY_ID INT NOT NULL DEFAULT 0,
	DATE_CREATE DATETIME NOT NULL,
	DATE_MODIFY DATETIME NULL,
	CREATED_BY_ID INT UNSIGNED NOT NULL,
	MODIFY_BY_ID INT UNSIGNED DEFAULT NULL,
	NAME VARCHAR(255) NOT NULL,
	XML_ID VARCHAR(45) NULL,
	ACTIVE CHAR(1) NOT NULL DEFAULT 'Y',
	SORT INT NOT NULL DEFAULT 500,
	SETTINGS TEXT DEFAULT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_PRESET_2 (COUNTRY_ID),
	INDEX IX_B_CRM_PRESET_3 (ENTITY_TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_requisite_cfg(
	ENTITY_ID INT(1) NOT NULL,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	SETTINGS TEXT,
	PRIMARY KEY(ENTITY_ID, ENTITY_TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_requisite_link(
	ENTITY_TYPE_ID INT(1) NOT NULL,
	ENTITY_ID      INT(1) UNSIGNED     NOT NULL,
	REQUISITE_ID      INT(1)     UNSIGNED NOT NULL DEFAULT 0,
	BANK_DETAIL_ID INT(1) UNSIGNED     NOT NULL DEFAULT 0,
	MC_REQUISITE_ID   INT(1)     UNSIGNED NOT NULL DEFAULT 0,
	MC_BANK_DETAIL_ID INT(1)     UNSIGNED NOT NULL DEFAULT 0,
	PRIMARY KEY (ENTITY_TYPE_ID, ENTITY_ID),
	INDEX IX_CRM_REQUISITE_LINK_2 (MC_REQUISITE_ID),
	INDEX IX_CRM_REQUISITE_LINK_3 (REQUISITE_ID, MC_REQUISITE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_bank_detail(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	COUNTRY_ID INT NOT NULL DEFAULT 0,
	DATE_CREATE DATETIME NOT NULL,
	DATE_MODIFY DATETIME NULL,
	CREATED_BY_ID INT UNSIGNED NOT NULL,
	MODIFY_BY_ID INT UNSIGNED DEFAULT NULL,
	NAME VARCHAR(255) NOT NULL,
	CODE VARCHAR(45) NULL,
	XML_ID VARCHAR(45) NULL,
	ORIGINATOR_ID VARCHAR(255) NULL,
	ACTIVE CHAR(1) NOT NULL DEFAULT 'Y',
	SORT INT NOT NULL DEFAULT 500,
	RQ_BANK_NAME VARCHAR(255) NULL,
	RQ_BANK_CODE VARCHAR(50) NULL,
	RQ_BANK_ADDR VARCHAR(255) NULL,
	RQ_BANK_ROUTE_NUM VARCHAR(9) NULL,
	RQ_BIK VARCHAR(11) NULL,
	RQ_MFO VARCHAR(6) NULL,
	RQ_ACC_NAME VARCHAR(150) NULL,
	RQ_ACC_NUM VARCHAR(34) NULL,
	RQ_ACC_TYPE VARCHAR(50) NULL,
	RQ_IIK VARCHAR(20) NULL,
	RQ_ACC_CURRENCY VARCHAR(100) NULL,
	RQ_COR_ACC_NUM VARCHAR(34) NULL,
	RQ_IBAN VARCHAR(34) NULL,
	RQ_SWIFT VARCHAR(11) NULL,
	RQ_BIC VARCHAR(11) NULL,
	RQ_CODEB VARCHAR(5) NULL,
	RQ_CODEG VARCHAR(5) NULL,
	RQ_RIB VARCHAR(2) NULL,
	RQ_AGENCY_NAME VARCHAR(50) NULL,
	COMMENTS VARCHAR(500) NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_BANK_DETAIL_2 (RQ_BANK_NAME),
	INDEX IX_B_CRM_BANK_DETAIL_3 (RQ_BANK_ADDR),
	INDEX IX_B_CRM_BANK_DETAIL_4 (RQ_BANK_ROUTE_NUM),
	INDEX IX_B_CRM_BANK_DETAIL_5 (RQ_BIK),
	INDEX IX_B_CRM_BANK_DETAIL_6 (RQ_MFO),
	INDEX IX_B_CRM_BANK_DETAIL_7 (RQ_ACC_NAME),
	INDEX IX_B_CRM_BANK_DETAIL_8 (RQ_ACC_NUM),
	INDEX IX_B_CRM_BANK_DETAIL_9 (RQ_IIK),
	INDEX IX_B_CRM_BANK_DETAIL_10 (RQ_ACC_CURRENCY),
	INDEX IX_B_CRM_BANK_DETAIL_11 (RQ_COR_ACC_NUM),
	INDEX IX_B_CRM_BANK_DETAIL_12 (RQ_IBAN),
	INDEX IX_B_CRM_BANK_DETAIL_13 (RQ_SWIFT),
	INDEX IX_B_CRM_BANK_DETAIL_14 (RQ_BIC),
	INDEX IX_B_CRM_BANK_DETAIL_15 (ENTITY_ID, ENTITY_TYPE_ID, SORT),
	INDEX IX_B_CRM_BANK_DETAIL_16 (RQ_CODEB),
	INDEX IX_B_CRM_BANK_DETAIL_17 (RQ_CODEG)
);

CREATE TABLE IF NOT EXISTS b_crm_contact_company(
	CONTACT_ID INT(1) UNSIGNED NOT NULL,
	COMPANY_ID INT(1) UNSIGNED NOT NULL,
	SORT INT NOT NULL,
	ROLE_ID TINYINT(1) NOT NULL,
	IS_PRIMARY CHAR(1) NOT NULL,
	PRIMARY KEY (CONTACT_ID, COMPANY_ID),
	INDEX IX_B_CRM_CONTACT_COMPANY_1(COMPANY_ID, CONTACT_ID),
	INDEX IX_B_CRM_CONTACT_COMPANY_2(CONTACT_ID, IS_PRIMARY, COMPANY_ID),
	INDEX IX_B_CRM_CONTACT_COMPANY_3(CONTACT_ID, SORT, COMPANY_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_deal_contact(
	DEAL_ID INT(1) UNSIGNED NOT NULL,
	CONTACT_ID INT(1) UNSIGNED NOT NULL,
	SORT INT NOT NULL,
	ROLE_ID TINYINT(1) NOT NULL,
	IS_PRIMARY CHAR(1) NOT NULL,
	PRIMARY KEY (DEAL_ID, CONTACT_ID),
	INDEX IX_B_CRM_DEAL_CONTACT_1(CONTACT_ID, DEAL_ID),
	INDEX IX_B_CRM_DEAL_CONTACT_2(DEAL_ID, IS_PRIMARY, CONTACT_ID),
	INDEX IX_B_CRM_DEAL_CONTACT_3(DEAL_ID, SORT, CONTACT_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_quote_contact(
	QUOTE_ID INT(1) UNSIGNED NOT NULL,
	CONTACT_ID INT(1) UNSIGNED NOT NULL,
	SORT INT NOT NULL,
	ROLE_ID TINYINT(1) NOT NULL,
	IS_PRIMARY CHAR(1) NOT NULL,
	PRIMARY KEY (QUOTE_ID, CONTACT_ID),
	INDEX IX_B_CRM_QUOTE_CONTACT_1(CONTACT_ID, QUOTE_ID),
	INDEX IX_B_CRM_QUOTE_CONTACT_2(QUOTE_ID, IS_PRIMARY, CONTACT_ID),
	INDEX IX_B_CRM_QUOTE_CONTACT_3(QUOTE_ID, SORT, CONTACT_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_entity_cfg(
	ENTITY_ID INT(1) NOT NULL,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	USER_ID INT(1) NOT NULL,
	SETTINGS TEXT NULL,
	PRIMARY KEY(ENTITY_ID, ENTITY_TYPE_ID, USER_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_webform (
	ID int(18) NOT NULL AUTO_INCREMENT,
	LANGUAGE_ID CHAR(2) NULL,
	TYPE_ID TINYINT UNSIGNED NOT NULL DEFAULT 0,
	NAME varchar(255) NOT NULL,
	DESCRIPTION text DEFAULT NULL,
	BUTTON_CAPTION varchar(255) DEFAULT NULL,
	TEMPLATE_ID varchar(255) DEFAULT NULL,
	IS_PAY char(1) NOT NULL,
	GOOGLE_ANALYTICS_ID varchar(50) DEFAULT NULL,
	YANDEX_METRIC_ID varchar(50) DEFAULT NULL,
	SECURITY_CODE varchar(32) DEFAULT NULL,
	BUTTON_COLOR_FONT varchar(10) DEFAULT NULL,
	BUTTON_COLOR_BG varchar(10) DEFAULT NULL,
	CSS_PATH varchar(255) DEFAULT NULL,
	DATE_CREATE datetime NOT NULL,
	ENTITY_SCHEME int(18) NOT NULL,
	GOOGLE_ANALYTICS_PAGE_VIEW char(1) NOT NULL DEFAULT 'N',
	CAPTION varchar(255) DEFAULT NULL,
	RESULT_SUCCESS_TEXT varchar(255) DEFAULT NULL,
	RESULT_SUCCESS_URL varchar(500) DEFAULT NULL,
	RESULT_FAILURE_TEXT varchar(255) DEFAULT NULL,
	RESULT_FAILURE_URL varchar(500) DEFAULT NULL,
	ACTIVE char(1) NOT NULL DEFAULT 'N',
	CSS_TEXT longtext,
	ACTIVE_CHANGE_BY int(18) DEFAULT NULL,
	ACTIVE_CHANGE_DATE datetime NULL,
	IS_SYSTEM char(1) NOT NULL DEFAULT 'N',
	COPYRIGHT_REMOVED char(1) NOT NULL DEFAULT 'N',
	USE_CAPTCHA char(1) NOT NULL DEFAULT 'N',
	BACKGROUND_IMAGE int(18) DEFAULT NULL,
	CODE varchar(255) DEFAULT NULL,
	OPENLINE_ID int(18) DEFAULT NULL,
	DUPLICATE_MODE varchar(20) DEFAULT NULL,
	XML_ID varchar(50) DEFAULT NULL,
	USE_LICENCE char(1) NOT NULL DEFAULT 'N',
	AGREEMENT_ID int(18) DEFAULT NULL,
	LICENCE_TEXT longtext,
	LICENCE_BUTTON_CAPTION varchar(255) DEFAULT NULL,
	LICENCE_BUTTON_IS_CHECKED char(1) NOT NULL DEFAULT 'N',
	SCRIPT_INCLUDE_SETTINGS text,
	INVOICE_SETTINGS text,
	FORM_SETTINGS text,
	IS_CALLBACK_FORM char(1) NOT NULL DEFAULT 'N',
	IS_WHATSAPP_FORM char(1) NOT NULL DEFAULT 'N',
	CALL_FROM varchar(50) DEFAULT NULL,
	CALL_TEXT text,
	ASSIGNED_BY_ID int(18) DEFAULT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_WEBFORM (CODE)
);

CREATE TABLE IF NOT EXISTS b_crm_webform_counter (
	ID int(18) NOT NULL AUTO_INCREMENT,
	FORM_ID int(18) NOT NULL,
	DATE_CREATE datetime NULL,
	VIEWS int(18) DEFAULT 0,
	START_FILL int(18) DEFAULT 0,
	END_FILL int(18) DEFAULT 0,
	MONEY int(18) DEFAULT 0,
	ENTITY_CONTACT int(18) DEFAULT 0,
	ENTITY_COMPANY int(18) DEFAULT 0,
	ENTITY_DEAL int(18) DEFAULT 0,
	ENTITY_LEAD int(18) DEFAULT 0,
	ENTITY_QUOTE int(18) DEFAULT 0,
	ENTITY_INVOICE int(18) DEFAULT 0,
	ENTITY_DYNAMIC int DEFAULT 0,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_WEBFORM_COUNTER (FORM_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_webform_counter_daily (
	DATE_STAT date NOT NULL,
	FORM_ID int(18) NOT NULL,
	VIEWS int NOT NULL DEFAULT 0,
	START_FILL int NOT NULL DEFAULT 0,
	END_FILL int NOT NULL DEFAULT 0,
	PRIMARY KEY (DATE_STAT, FORM_ID)
);

CREATE TABLE b_crm_webform_start_edit (
	FORM_ID int(18) NOT NULL,
	DATE_CREATE datetime NULL,
	INDEX IX_B_CRM_WEBFORM_STEDIT_FID_DC (FORM_ID, DATE_CREATE)
);

CREATE TABLE IF NOT EXISTS b_crm_webform_field (
	ID int(18) NOT NULL AUTO_INCREMENT,
	TYPE varchar(50) DEFAULT NULL,
	CODE varchar(255) DEFAULT NULL,
	CAPTION varchar(255) DEFAULT NULL,
	FORM_ID int(18) NOT NULL,
	GROUP_ID int(18) NULL,
	SORT int(18) NOT NULL DEFAULT '100',
	REQUIRED char(1) DEFAULT 'N',
	PLACEHOLDER varchar(255) DEFAULT NULL,
	MULTIPLE char(1) NOT NULL DEFAULT 'N',
	ITEMS longtext NOT NULL,
	VALUE_TYPE varchar(50) DEFAULT NULL,
	VALUE varchar(255) DEFAULT NULL,
	SETTINGS_DATA longtext DEFAULT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_WEBFORM_FIELD (FORM_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_webform_field_dep (
	ID int(18) NOT NULL AUTO_INCREMENT,
	FORM_ID int(18) NOT NULL,
	GROUP_ID int UNSIGNED NOT NULL DEFAULT 0,
	IF_FIELD_CODE varchar(255) DEFAULT NULL,
	IF_ACTION varchar(20) NOT NULL,
	IF_VALUE varchar(255) DEFAULT NULL,
	IF_VALUE_OPERATION varchar(10) DEFAULT NULL,
	DO_FIELD_CODE varchar(255) DEFAULT NULL,
	DO_ACTION varchar(20) NOT NULL,
	DO_VALUE varchar(255) DEFAULT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_WEBFORM_FIELD_DEP (FORM_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_webform_field_dep_group (
	ID int UNSIGNED NOT NULL AUTO_INCREMENT,
	FORM_ID int UNSIGNED NOT NULL,
	TYPE_ID int UNSIGNED NOT NULL DEFAULT 0,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_WEBFORM_FIELD_DEP_GR (FORM_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_webform_field_preset (
	FORM_ID int(18) NOT NULL,
	ENTITY_NAME varchar(25) NOT NULL,
	FIELD_NAME varchar(255) NOT NULL,
	VALUE varchar(255) DEFAULT NULL,
	INDEX IX_B_CRM_WEBFORM_FIELD_PRST (FORM_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_webform_result (
	ID int(18) NOT NULL AUTO_INCREMENT,
	DATE_INSERT datetime NOT NULL,
	FORM_ID int(18) NOT NULL,
	ORIGIN_ID VARCHAR(50) DEFAULT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_WEBFORM_ORIGIN_ID (FORM_ID, ORIGIN_ID),
	INDEX IX_B_CRM_WEBFORM_RESULT_FID_DI (FORM_ID, DATE_INSERT)
);

CREATE TABLE IF NOT EXISTS b_crm_webform_result_entity (
	FORM_ID int(18) NOT NULL,
	RESULT_ID int(18) NOT NULL,
	ENTITY_NAME varchar(20) NOT NULL,
	ITEM_ID int(18) NOT NULL,
	INDEX IX_B_CRM_WEBFORM_RESULT_ENT (RESULT_ID),
	INDEX IX_B_CRM_WEBFORM_RESULT_ENTITY_NAME_ITEM (ENTITY_NAME, ITEM_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_webform_queue (
	ID INT (18) UNSIGNED NOT NULL AUTO_INCREMENT,
	FORM_ID INT (18) NOT NULL,
	USER_ID INT(18) NOT NULL,
	WORK_TIME CHAR(1) NOT NULL DEFAULT 'N',
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_WEBFORM_QUEUE_FORM (FORM_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_webform_agreement (
	ID BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
	FORM_ID BIGINT UNSIGNED NOT NULL,
	AGREEMENT_ID BIGINT UNSIGNED NOT NULL,
	CHECKED CHAR(1) NOT NULL DEFAULT 'N',
	REQUIRED CHAR(1) NOT NULL DEFAULT 'Y',
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_WEBFORM_AG_FORM (FORM_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_webform_landing(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	FORM_ID INT UNSIGNED NOT NULL,
	LANDING_ID INT UNSIGNED NOT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_WEBFORM_LANDING_1(FORM_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_webpack
(
	ENTITY_TYPE varchar(15) NOT NULL,
	ENTITY_ID int(11) NOT NULL,
	FILE_ID  int(11) NOT NULL,
	PRIMARY KEY PK_CRM_WEBPACK_ENTITY (ENTITY_TYPE, ENTITY_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_ads_form_link (
	ID               INT(11)     NOT NULL AUTO_INCREMENT,
	DATE_INSERT      DATETIME    NULL,
	LINK_DIRECTION   INT(1)      NOT NULL DEFAULT 0,
	WEBFORM_ID       INT(18)     NOT NULL,
	ADS_TYPE         VARCHAR(20) NOT NULL,
	ADS_ACCOUNT_ID   VARCHAR(50) NOT NULL,
	ADS_ACCOUNT_NAME VARCHAR(50) NULL,
	ADS_FORM_ID      VARCHAR(50) NOT NULL,
	ADS_FORM_NAME    VARCHAR(50) NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_ADS_FORM_LINK_WI_LD (WEBFORM_ID, LINK_DIRECTION)
);

CREATE TABLE IF NOT EXISTS b_crm_ps_rq_conv_relation(
	ENTITY_ID       INT(1)  UNSIGNED NOT NULL,
	COMPANY_ID      INT(1)  UNSIGNED NOT NULL DEFAULT 0,
	REQUISITE_ID    INT(1)  UNSIGNED NOT NULL DEFAULT 0,
	BANK_DETAIL_ID  INT(1)  UNSIGNED NOT NULL DEFAULT 0,
	PRIMARY KEY (ENTITY_ID),
	INDEX IX_CRM_PS_RQ_CONV_RELATION_1 (REQUISITE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_act_mail_meta(
	ACTIVITY_ID INT UNSIGNED NOT NULL,
	MSG_ID_HASH VARCHAR(40) NULL,
	MSG_INREPLY_HASH VARCHAR(40) NULL,
	MSG_HEADER_HASH VARCHAR(40) NULL,
	PRIMARY KEY (ACTIVITY_ID),
	INDEX IX_B_CRM_ACT_MAIL_META_1 (MSG_ID_HASH),
	INDEX IX_B_CRM_ACT_MAIL_META_2 (MSG_HEADER_HASH),
	INDEX IX_B_CRM_ACT_MAIL_META_3 (MSG_INREPLY_HASH)
);

CREATE TABLE IF NOT EXISTS b_crm_act_mail_body (
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	BODY MEDIUMBLOB NULL,
	BODY_HASH VARCHAR(40) NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_ACT_MAIL_BODY_1 (BODY_HASH)
);

CREATE TABLE IF NOT EXISTS b_crm_deal_category(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	CREATED_DATE DATE NOT NULL,
	NAME VARCHAR(255) NOT NULL,
	IS_LOCKED CHAR(1) NOT NULL DEFAULT 'N',
	SORT INT NOT NULL,
	ORIGIN_ID VARCHAR(255) DEFAULT NULL,
	ORIGINATOR_ID VARCHAR(255) DEFAULT NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_DEAL_CAT_3(SORT),
	INDEX IX_B_CRM_DEAL_CAT_4(IS_LOCKED, SORT)
);

CREATE TABLE IF NOT EXISTS b_crm_company_act_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	DEADLINE_DATE DATE NOT NULL,
	PROVIDER_ID varchar(100) NOT NULL,
	PROVIDER_TYPE_ID varchar(100) NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	TOTAL_QTY INT(1) UNSIGNED NULL,
	PRIMARY KEY(OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID),
	INDEX IX_B_CRM_COMPANY_ASTAT_1(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, TOTAL_QTY),
	INDEX IX_B_CRM_COMPANY_ASTAT_2(DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, TOTAL_QTY)
);
CREATE TABLE IF NOT EXISTS b_crm_company_act_sts_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	DEADLINE_DATE DATE NOT NULL,
	PROVIDER_ID varchar(100) NOT NULL,
	PROVIDER_TYPE_ID varchar(100) NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	ANSWERED_QTY INT(1) UNSIGNED NULL,
	UNANSWERED_QTY INT(1) UNSIGNED NULL,
	PRIMARY KEY(OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID),
	INDEX IX_B_CRM_COMPANY_ASTS_1(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, ANSWERED_QTY, UNANSWERED_QTY),
	INDEX IX_B_CRM_COMPANY_ASTS_2(DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, ANSWERED_QTY, UNANSWERED_QTY)
);
CREATE TABLE IF NOT EXISTS b_crm_company_act_mark_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	DEADLINE_DATE DATE NOT NULL,
	PROVIDER_ID varchar(100) NOT NULL,
	PROVIDER_TYPE_ID varchar(50) NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	SOURCE_ID VARCHAR(100) NOT NULL,
	NONE_QTY INT(1) UNSIGNED NULL,
	POSITIVE_QTY INT(1) UNSIGNED NULL,
	NEGATIVE_QTY INT(1) UNSIGNED NULL,
	PRIMARY KEY(OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID, SOURCE_ID),
	INDEX IX_B_CRM_COMPANY_AMRS_1(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, SOURCE_ID, NONE_QTY, POSITIVE_QTY, NEGATIVE_QTY),
	INDEX IX_B_CRM_COMPANY_AMRS_2(DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, SOURCE_ID, NONE_QTY, POSITIVE_QTY, NEGATIVE_QTY)
);
CREATE TABLE IF NOT EXISTS b_crm_company_act_stm_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	DEADLINE_DATE DATE NOT NULL,
	PROVIDER_ID varchar(100) NOT NULL,
	PROVIDER_TYPE_ID varchar(100) NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	INCOMING_QTY INT(1) UNSIGNED NULL,
	OUTGOING_QTY INT(1) UNSIGNED NULL,
	REVERSING_QTY INT(1) UNSIGNED NULL,
	MISSING_QTY INT(1) UNSIGNED NULL,
	PRIMARY KEY(OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID),
	INDEX IX_B_CRM_COMPANY_ASTM_1(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, INCOMING_QTY, OUTGOING_QTY, REVERSING_QTY, MISSING_QTY),
	INDEX IX_B_CRM_COMPANY_ASTM_2(DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, INCOMING_QTY, OUTGOING_QTY, REVERSING_QTY, MISSING_QTY)
);
CREATE TABLE IF NOT EXISTS b_crm_company_act_sum_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	DEADLINE_DATE DATE NOT NULL,
	PROVIDER_ID varchar(100) NOT NULL,
	PROVIDER_TYPE_ID varchar(100) NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	CURRENCY_ID CHAR(3) NULL,
	SUM_TOTAL DECIMAL(18,4) NULL,
	PRIMARY KEY(OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID),
	INDEX IX_B_CRM_COMPANY_ASUM_1(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID),
	INDEX IX_B_CRM_COMPANY_ASUM_2(DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID)
);
CREATE TABLE IF NOT EXISTS b_crm_company_growth_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	CREATED_DATE DATE NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	PRIMARY KEY(OWNER_ID, CREATED_DATE),
	INDEX IX_B_CRM_COMPANY_GRTH_1(CREATED_DATE, OWNER_ID),
	INDEX IX_B_CRM_COMPANY_GRTH_2(RESPONSIBLE_ID, CREATED_DATE, OWNER_ID)
);
CREATE TABLE IF NOT EXISTS b_crm_contact_act_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	DEADLINE_DATE DATE NOT NULL,
	PROVIDER_ID varchar(100) NOT NULL,
	PROVIDER_TYPE_ID varchar(100) NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	TOTAL_QTY INT(1) UNSIGNED NULL,
	PRIMARY KEY(OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID),
	INDEX IX_B_CRM_CONTACT_ASTAT_1(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, TOTAL_QTY),
	INDEX IX_B_CRM_CONTACT_ASTAT_2(DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, TOTAL_QTY)
);
CREATE TABLE IF NOT EXISTS b_crm_contact_act_sts_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	DEADLINE_DATE DATE NOT NULL,
	PROVIDER_ID varchar(100) NOT NULL,
	PROVIDER_TYPE_ID varchar(100) NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	ANSWERED_QTY INT(1) UNSIGNED NULL,
	UNANSWERED_QTY INT(1) UNSIGNED NULL,
	PRIMARY KEY(OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID),
	INDEX IX_B_CRM_CONTACT_ASTS_1(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, ANSWERED_QTY, UNANSWERED_QTY),
	INDEX IX_B_CRM_CONTACT_ASTS_2(DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, ANSWERED_QTY, UNANSWERED_QTY)
);
CREATE TABLE IF NOT EXISTS b_crm_contact_act_mark_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	DEADLINE_DATE DATE NOT NULL,
	PROVIDER_ID varchar(100) NOT NULL,
	PROVIDER_TYPE_ID varchar(50) NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	SOURCE_ID VARCHAR(100) NOT NULL,
	NONE_QTY INT(1) UNSIGNED NULL,
	POSITIVE_QTY INT(1) UNSIGNED NULL,
	NEGATIVE_QTY INT(1) UNSIGNED NULL,
	PRIMARY KEY(OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID, SOURCE_ID),
	INDEX IX_B_CRM_CONTACT_AMRS_1(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, SOURCE_ID, NONE_QTY, POSITIVE_QTY, NEGATIVE_QTY),
	INDEX IX_B_CRM_CONTACT_AMRS_2(DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, SOURCE_ID, NONE_QTY, POSITIVE_QTY, NEGATIVE_QTY)
);
CREATE TABLE IF NOT EXISTS b_crm_contact_act_stm_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	DEADLINE_DATE DATE NOT NULL,
	PROVIDER_ID varchar(100) NOT NULL,
	PROVIDER_TYPE_ID varchar(100) NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	INCOMING_QTY INT(1) UNSIGNED NULL,
	OUTGOING_QTY INT(1) UNSIGNED NULL,
	REVERSING_QTY INT(1) UNSIGNED NULL,
	MISSING_QTY INT(1) UNSIGNED NULL,
	PRIMARY KEY(OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID),
	INDEX IX_B_CRM_CONTACT_ASTM_1(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, INCOMING_QTY, OUTGOING_QTY, REVERSING_QTY, MISSING_QTY),
	INDEX IX_B_CRM_CONTACT_ASTM_2(DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, INCOMING_QTY, OUTGOING_QTY, REVERSING_QTY, MISSING_QTY)
);
CREATE TABLE IF NOT EXISTS b_crm_contact_act_sum_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	DEADLINE_DATE DATE NOT NULL,
	PROVIDER_ID varchar(100) NOT NULL,
	PROVIDER_TYPE_ID varchar(100) NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	CURRENCY_ID CHAR(3) NULL,
	SUM_TOTAL DECIMAL(18,4) NULL,
	PRIMARY KEY(OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID),
	INDEX IX_B_CRM_CONTACT_ASUM_1(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID),
	INDEX IX_B_CRM_CONTACT_ASUM_2(DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID)
);
CREATE TABLE IF NOT EXISTS b_crm_contact_growth_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	CREATED_DATE DATE NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	PRIMARY KEY(OWNER_ID, CREATED_DATE),
	INDEX IX_B_CRM_CONTACT_GRTH_1(CREATED_DATE, OWNER_ID),
	INDEX IX_B_CRM_CONTACT_GRTH_2(RESPONSIBLE_ID, CREATED_DATE, OWNER_ID)
);
CREATE TABLE IF NOT EXISTS b_crm_act_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	DEADLINE_DATE DATE NOT NULL,
	PROVIDER_ID VARCHAR(100) NOT NULL,
	PROVIDER_TYPE_ID VARCHAR(50) NOT NULL,
	OWNER_TYPE_ID INT(1) NOT NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	COMPLETED CHAR(1) NULL,
	STATUS_ID INT(1) UNSIGNED NULL,
	MARK_ID INT(1) UNSIGNED NULL,
	SOURCE_ID VARCHAR(100) NOT NULL,
	STREAM_ID INT(1) UNSIGNED NULL,
	CURRENCY_ID CHAR(3) NULL,
	SUM_TOTAL DECIMAL(18,4) NULL,
	PRIMARY KEY(OWNER_ID, DEADLINE_DATE, PROVIDER_ID, PROVIDER_TYPE_ID),
	INDEX IX_B_CRM_ACT_STAT_1(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, COMPLETED),
	INDEX IX_B_CRM_ACT_STAT_2(DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, COMPLETED),
	INDEX IX_B_CRM_ACT_STAT_5(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, STATUS_ID),
	INDEX IX_B_CRM_ACT_STAT_6(DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, STATUS_ID),
	INDEX IX_B_CRM_ACT_STAT_7(RESPONSIBLE_ID, DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, STREAM_ID),
	INDEX IX_B_CRM_ACT_STAT_8(DEADLINE_DATE, OWNER_ID, PROVIDER_ID, PROVIDER_TYPE_ID, STREAM_ID)
);
CREATE TABLE IF NOT EXISTS b_crm_button (
	ID int(18) NOT NULL AUTO_INCREMENT,
	DATE_CREATE datetime NULL,
	CREATED_BY int(18) DEFAULT NULL,
	ACTIVE char(1) NOT NULL DEFAULT 'N',
	ACTIVE_CHANGE_BY int(18) DEFAULT NULL,
	ACTIVE_CHANGE_DATE datetime NULL,
	NAME varchar(255) NOT NULL,
	BACKGROUND_COLOR varchar(10) DEFAULT NULL,
	ICON_COLOR varchar(10) DEFAULT NULL,
	LOCATION int(3) NOT NULL DEFAULT 1,
	DELAY int(3) NOT NULL DEFAULT 0,
	LANGUAGE_ID char(2) DEFAULT NULL,
	ITEMS text,
	SETTINGS longtext,
	SECURITY_CODE varchar(32) DEFAULT NULL,
	IS_SYSTEM char(1) NOT NULL DEFAULT 'N',
	XML_ID varchar(50) DEFAULT NULL,
	PRIMARY KEY (ID)
);
CREATE TABLE IF NOT EXISTS b_crm_button_avatar (
	ID INT (18) UNSIGNED NOT NULL AUTO_INCREMENT,
	FILE_ID INT(18) NOT NULL,
	DATE_CREATE DATETIME NOT NULL,
	PRIMARY KEY (ID)
);
CREATE TABLE IF NOT EXISTS b_crm_button_guest (
	ID INT (18) UNSIGNED NOT NULL AUTO_INCREMENT,
	GID VARCHAR(32) NOT NULL,
	DATE_CREATE DATETIME NOT NULL,
	PRIMARY KEY (ID),
	UNIQUE IX_B_CRM_BUTTON_GUEST_GID (GID)
);
CREATE TABLE IF NOT EXISTS b_crm_button_guest_entity (
	ID INT (18) UNSIGNED NOT NULL AUTO_INCREMENT,
	GUEST_ID INT(18) NOT NULL,
	ENTITY_TYPE_ID INT(3) NOT NULL,
	ENTITY_ID INT(18) NOT NULL,
	DATE_CREATE DATETIME NOT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_BUTTON_GUEST_ENT_1 (GUEST_ID, ENTITY_TYPE_ID, ENTITY_ID)
);
CREATE TABLE b_crm_utm (
	ENTITY_TYPE_ID int(18) NOT NULL,
	ENTITY_ID int(18) NOT NULL,
	CODE varchar(45) NOT NULL,
	VALUE varchar(600) NOT NULL,
	PRIMARY KEY (ENTITY_TYPE_ID, ENTITY_ID, CODE)
);
create table if not exists b_crm_invoice_recur (
	ID int(11) NOT NULL AUTO_INCREMENT,
	INVOICE_ID int NOT NULL,
	ACTIVE char(1) NOT NULL DEFAULT 'Y',
	NEXT_EXECUTION date NULL,
	LAST_EXECUTION date NULL,
	IS_LIMIT char(1) NOT NULL default 'N',
	SEND_BILL char(1) NOT NULL default 'N',
	EMAIL_ID int(18) NULL,
	LIMIT_DATE date NULL,
	START_DATE date NULL,
	LIMIT_REPEAT int(18) NULL,
	COUNTER_REPEAT int(18) NULL,
	PARAMS text null,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_RECUR_PARAMS_INVOICE_ID (INVOICE_ID),
	INDEX IX_B_CRM_RECUR_PARAMS_NEXT_EXECUTION (NEXT_EXECUTION),
	INDEX IX_B_CRM_RECUR_PARAMS_LAST_EXECUTION (LAST_EXECUTION),
	INDEX IX_B_CRM_RECUR_PARAMS_LIMIT_DATE (LIMIT_DATE),
	INDEX IX_B_CRM_RECUR_PARAMS_START_DATE (START_DATE)
);

CREATE TABLE IF NOT EXISTS b_crm_entity_channel(
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	TYPE_ID TINYINT(1) UNSIGNED NOT NULL,
	ORIGIN_ID VARCHAR(32) NULL,
	COMPONENT_ID VARCHAR(32) NULL,
	PRIMARY KEY(ENTITY_ID, ENTITY_TYPE_ID, TYPE_ID),
	INDEX IX_B_CRM_ENT_CHANNEL_1(ENTITY_ID, ENTITY_TYPE_ID, TYPE_ID, ORIGIN_ID, COMPONENT_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_lead_channel_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	CREATED_DATE DATE NOT NULL,
	CHANNEL_TYPE_ID TINYINT(1) UNSIGNED NOT NULL,
	CHANNEL_ORIGIN_ID VARCHAR(32) NULL,
	CHANNEL_COMPONENT_ID VARCHAR(32) NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	STATUS_SEMANTIC_ID VARCHAR(3) NULL,
	PRIMARY KEY(OWNER_ID, CHANNEL_TYPE_ID),
	INDEX IX_B_CRM_LEAD_CHANNEL_STAT_1(CHANNEL_TYPE_ID, CHANNEL_ORIGIN_ID, CHANNEL_COMPONENT_ID, STATUS_SEMANTIC_ID, CREATED_DATE)
);

CREATE TABLE IF NOT EXISTS b_crm_deal_channel_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	CREATED_DATE DATE NOT NULL,
	START_DATE DATE NOT NULL,
	END_DATE DATE NOT NULL,
	CHANNEL_TYPE_ID TINYINT(1) UNSIGNED NOT NULL,
	CHANNEL_ORIGIN_ID VARCHAR(32) NULL,
	CHANNEL_COMPONENT_ID VARCHAR(32) NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	CURRENCY_ID CHAR(3) NULL,
	SUM_TOTAL DECIMAL(18,2) NULL,
	STAGE_SEMANTIC_ID VARCHAR(3) NULL,
	PRIMARY KEY(OWNER_ID, CHANNEL_TYPE_ID),
	INDEX IX_B_CRM_DEAL_CHANNEL_STAT_1(CHANNEL_TYPE_ID, CHANNEL_ORIGIN_ID, CHANNEL_COMPONENT_ID, STAGE_SEMANTIC_ID, START_DATE, END_DATE, SUM_TOTAL)
);

CREATE TABLE IF NOT EXISTS b_crm_act_channel_stat(
	OWNER_ID INT(1) UNSIGNED NOT NULL,
	CREATED_DATE DATE NOT NULL,
	CHANNEL_TYPE_ID TINYINT(1) UNSIGNED NOT NULL,
	CHANNEL_ORIGIN_ID VARCHAR(32) NULL,
	CHANNEL_COMPONENT_ID VARCHAR(32) NULL,
	RESPONSIBLE_ID INT(1) UNSIGNED NOT NULL,
	COMPLETED CHAR(1) NOT NULL DEFAULT 'N',
	DIRECTION TINYINT(1) UNSIGNED NOT NULL,
	PRIMARY KEY(OWNER_ID, CHANNEL_TYPE_ID),
	INDEX IX_B_CRM_ACT_CHANNEL_STAT_1(CHANNEL_TYPE_ID, CHANNEL_ORIGIN_ID, CHANNEL_COMPONENT_ID, CREATED_DATE)
);

CREATE TABLE b_crm_ext_channel_connector(
	TYPE_ID VARCHAR(32) NOT NULL,
	NAME VARCHAR(32) NOT NULL,
	APP_ID VARCHAR(128) NOT NULL,
	CHANNEL_ID VARCHAR(64) NOT NULL,
	ORIGINATOR_ID VARCHAR(32) NOT NULL,
	EXTERNAL_SERVER_HOST VARCHAR(128) NOT NULL,
	PRIMARY KEY(TYPE_ID, ORIGINATOR_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_automation_template (
	ID int(18) NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID int(18) DEFAULT NULL,
	ENTITY_STATUS varchar(50) NOT NULL,
	TEMPLATE_ID int(11) NOT NULL DEFAULT 0,
	START_RULES text,
	PRIMARY KEY (ID)
);
CREATE TABLE IF NOT EXISTS b_crm_automation_trigger (
	ID int(18) NOT NULL AUTO_INCREMENT,
	NAME varchar(255) NOT NULL,
	CODE varchar(30) NOT NULL,
	ENTITY_TYPE_ID int(18) DEFAULT NULL,
	ENTITY_STATUS varchar(50) NOT NULL,
	APPLY_RULES text,
	PRIMARY KEY (ID)
);
CREATE TABLE IF NOT EXISTS b_crm_automation_trigger_app (
	ID int(18) NOT NULL AUTO_INCREMENT,
	APP_ID INT(11) NULL,
	NAME varchar(255) NOT NULL,
	CODE varchar(30) NOT NULL,
	DATE_CREATE DATETIME NULL,
	PRIMARY KEY (ID)
);
CREATE TABLE IF NOT EXISTS b_crm_kanban_sort (
        ID INT (18) UNSIGNED NOT NULL AUTO_INCREMENT,
        ENTITY_TYPE_ID INT(1) NOT NULL,
        ENTITY_ID INT(18) NOT NULL,
        PREV_ENTITY_ID INT(18) NOT NULL,
        USER_ID INT(18) NOT NULL,
        PRIMARY KEY (`ID`),
        KEY IX_KANBAN_1 (ENTITY_TYPE_ID, USER_ID),
		INDEX IX_B_CRM_KANBAN_SORT_1(ENTITY_ID)
);
CREATE TABLE IF NOT EXISTS b_crm_kanban_supervisor (
        ID INT (18) UNSIGNED NOT NULL AUTO_INCREMENT,
        ENTITY_TYPE_ID TINYINT(1) NOT NULL,
        USER_ID INT(18) NOT NULL,
        PRIMARY KEY (`ID`)
);

CREATE TABLE IF NOT EXISTS b_crm_call_list(
	ID INT(18) NOT NULL AUTO_INCREMENT,
	DATE_CREATE DATETIME,
	CREATED_BY_ID INT(18) NOT NULL,
	FILTERED CHAR(1) NOT NULL DEFAULT 'N',
	GRID_ID VARCHAR(255) NULL,
	FILTER_PARAMS TEXT,
	ENTITY_TYPE_ID INT(1) NULL,
	WEBFORM_ID INT(18) NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_CALL_LIST_1(DATE_CREATE)
);

CREATE TABLE IF NOT EXISTS b_crm_call_list_item(
	LIST_ID INT(18) NOT NULL,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	ELEMENT_ID INT(18) NOT NULL,
	STATUS_ID VARCHAR(50) NOT NULL,
	CALL_ID INT(18) NULL,
	WEBFORM_RESULT_ID INT(18) NULL,
	`RANK` INT(18) NULL,
	PRIMARY KEY (LIST_ID, ENTITY_TYPE_ID, ELEMENT_ID),
	INDEX IX_B_CALL_LIST_ITEM_1(LIST_ID, STATUS_ID, `RANK`)
);

CREATE TABLE IF NOT EXISTS b_crm_call_list_created(
	ID INT(18) NOT NULL AUTO_INCREMENT,
	LIST_ID INT(18) NOT NULL,
	ELEMENT_ID INT(18) NOT NULL,
	ENTITY_TYPE VARCHAR(50) NOT NULL,
	ENTITY_ID INT(18) NOT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CALL_LIST_CREATED_1 (LIST_ID, ELEMENT_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_deal_recur (
	ID int(11) NOT NULL AUTO_INCREMENT,
	DEAL_ID int(18) NOT NULL,
	BASED_ID int(18) NULL,
	ACTIVE char(1) NOT NULL DEFAULT 'Y',
	NEXT_EXECUTION date NULL,
	LAST_EXECUTION date NULL,
	IS_LIMIT char(1) NOT NULL default 'N',
	LIMIT_DATE date NULL,
	START_DATE date NULL,
	LIMIT_REPEAT int(18) NULL,
	COUNTER_REPEAT int(18) NULL,
	CATEGORY_ID INT (18) UNSIGNED NULL,
	PARAMS text null,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_RECUR_PARAMS_DEAL_ID (DEAL_ID),
	INDEX IX_B_CRM_RECUR_PARAMS_BASED_ID (BASED_ID),
	INDEX IX_B_CRM_RECUR_PARAMS_NEXT_EXECUTION (NEXT_EXECUTION),
	INDEX IX_B_CRM_RECUR_PARAMS_LAST_EXECUTION (LAST_EXECUTION),
	INDEX IX_B_CRM_RECUR_PARAMS_LIMIT_DATE (LIMIT_DATE),
	INDEX IX_B_CRM_RECUR_PARAMS_START_DATE (START_DATE)
);

CREATE TABLE b_crm_timeline(
	ID INT(18) NOT NULL AUTO_INCREMENT,
	TYPE_ID INT UNSIGNED NOT NULL,
	TYPE_CATEGORY_ID INT UNSIGNED,
	CREATED DATETIME NOT NULL,
	AUTHOR_ID INT(1) UNSIGNED NULL,
	ASSOCIATED_ENTITY_ID INT(1),
	ASSOCIATED_ENTITY_TYPE_ID INT(1),
	ASSOCIATED_ENTITY_CLASS_NAME VARCHAR(128) NULL,
	COMMENT TEXT NULL,
	SETTINGS TEXT NULL,
	SOURCE_ID VARCHAR(100) NOT NULL DEFAULT '',
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_TIMELINE_2(ASSOCIATED_ENTITY_ID, ASSOCIATED_ENTITY_TYPE_ID),
	INDEX IX_B_CRM_TIMELINE_4(ASSOCIATED_ENTITY_CLASS_NAME),
	INDEX IX_B_CRM_TIMELINE_5(CREATED),
	INDEX IX_B_CRM_TIMELINE_7(TYPE_ID, TYPE_CATEGORY_ID),
	INDEX IX_B_CRM_TIMELINE_9 (SOURCE_ID, TYPE_ID, TYPE_CATEGORY_ID),
	INDEX IX_B_CRM_TIMELINE_10(ASSOCIATED_ENTITY_TYPE_ID)
);

CREATE TABLE b_crm_timeline_bind(
	OWNER_ID INT(1) NOT NULL,
	ENTITY_ID INT(1) NOT NULL,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	IS_FIXED CHAR(1) NULL,
	PRIMARY KEY (OWNER_ID, ENTITY_ID, ENTITY_TYPE_ID),
	INDEX IX_B_CRM_TIMELINE_BIND_2(ENTITY_ID, ENTITY_TYPE_ID, IS_FIXED)
);

CREATE TABLE b_crm_timeline_search(
	OWNER_ID INT(1) NOT NULL,
	SEARCH_CONTENT MEDIUMTEXT NULL,
	PRIMARY KEY(OWNER_ID),
	FULLTEXT INDEX IX_B_CRM_TIMELINE_SEARCH (SEARCH_CONTENT)
);

CREATE TABLE IF NOT EXISTS b_crm_wait (
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	OWNER_ID INT(1) NOT NULL,
	OWNER_TYPE_ID INT(1) NOT NULL,
	AUTHOR_ID INT(1) NOT NULL,
	START_TIME DATETIME NOT NULL,
	END_TIME DATETIME NOT NULL,
	CREATED DATETIME NOT NULL,
	DESCRIPTION TEXT NULL,
	COMPLETED CHAR(1) NOT NULL DEFAULT 'N',
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_WAIT_2(OWNER_ID, OWNER_TYPE_ID, COMPLETED)
);

CREATE TABLE IF NOT EXISTS b_crm_widget_saletarget (
	ID INT(18) NOT NULL AUTO_INCREMENT,
	TYPE_ID VARCHAR(15) NOT NULL,
	PERIOD_TYPE CHAR(1) NOT NULL,
	PERIOD_YEAR INT(18) UNSIGNED NOT NULL,
	PERIOD_HALF TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
	PERIOD_QUARTER TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
	PERIOD_MONTH TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
	TARGET_TYPE CHAR(1) NOT NULL,
	TARGET_GOAL TEXT NOT NULL,
	CREATED DATETIME NOT NULL,
	MODIFIED DATETIME NOT NULL,
	AUTHOR_ID INT(1) UNSIGNED NULL,
	EDITOR_ID INT(1) UNSIGNED NULL,
	LEFT_BORDER INT(18) UNSIGNED NOT NULL DEFAULT 0,
	RIGHT_BORDER INT(18) UNSIGNED NOT NULL DEFAULT 0,
	PRIMARY KEY (ID)
);

CREATE TABLE b_crm_exclusion (
	ID INT NOT NULL AUTO_INCREMENT,
	DATE_INSERT DATETIME NOT NULL,
	TYPE_ID INT NOT NULL,
	CODE VARCHAR(255) NOT NULL,
	COMMENT VARCHAR(255) NULL,
	PRIMARY KEY (ID),
	UNIQUE UK_B_CRM_EXCLUSION_TYPE_CODE (TYPE_ID, CODE)
);

CREATE TABLE IF NOT EXISTS b_crm_lead_contact(
	LEAD_ID INT(1) UNSIGNED NOT NULL,
	CONTACT_ID INT(1) UNSIGNED NOT NULL,
	SORT INT NOT NULL,
	ROLE_ID TINYINT(1) NOT NULL,
	IS_PRIMARY CHAR(1) NOT NULL,
	PRIMARY KEY (LEAD_ID, CONTACT_ID),
	index IX_B_CRM_LEAD_CONTACT_1(CONTACT_ID)
);

create table if not exists b_crm_invoice_basket
(
	ID int not null auto_increment,
	FUSER_ID int not null,
	ORDER_ID int null,
	PRODUCT_ID int not null,
	PRODUCT_PRICE_ID int null,
	PRICE_TYPE_ID int null,
	PRICE decimal(18, 4) not null,
	CURRENCY char(3) not null,
	BASE_PRICE decimal(18, 4) null,
	VAT_INCLUDED char(1) not null default 'Y',
	DATE_INSERT datetime not null,
	DATE_UPDATE datetime not null,
	DATE_REFRESH datetime null,
	WEIGHT double(18, 2) null,
	QUANTITY double(18, 4) not null default '0',
	LID char(2) not null,
	DELAY char(1) not null default 'N',
	NAME varchar(255) not null,
	CAN_BUY char(1) not null default 'Y',
	MARKING_CODE_GROUP varchar(100) null,
	MODULE varchar(100) null,
	CALLBACK_FUNC varchar(100) null,
	NOTES varchar(250) null,
	ORDER_CALLBACK_FUNC varchar(100) null,
	DETAIL_PAGE_URL varchar(250) null,
	DISCOUNT_PRICE decimal(18,4) not null,
	CANCEL_CALLBACK_FUNC varchar(100) null,
	PAY_CALLBACK_FUNC varchar(100) null,
	PRODUCT_PROVIDER_CLASS varchar(100) null,
	CATALOG_XML_ID varchar(100) null,
	PRODUCT_XML_ID varchar(100) null,
	DISCOUNT_NAME varchar(255) null,
	DISCOUNT_VALUE char(32) null,
	DISCOUNT_COUPON char(32) null,
	VAT_RATE DECIMAL(18, 4) NULL default '0.00',
	SUBSCRIBE char(1) not null default 'N',
	DEDUCTED char(1) not null default 'N',
	RESERVED char(1) not null default 'N',
	BARCODE_MULTI char(1) not null default 'N',
	RESERVE_QUANTITY double null,
	CUSTOM_PRICE char(1) not null default 'N',
	DIMENSIONS varchar(255) null,
	TYPE int(11) null,
	SET_PARENT_ID int(11) null,
	MEASURE_CODE INT(11) NULL,
	MEASURE_NAME varchar(50) null,
	RECOMMENDATION varchar(40) null,
	XML_ID varchar(255) null,
	SORT INT(11) not null default '100',
	primary key (ID),
	index IXS_BASKET_LID(LID),
	index IXS_BASKET_USER_ID(FUSER_ID),
	index IXS_BASKET_ORDER_ID(ORDER_ID),
	index IXS_BASKET_PRODUCT_ID(PRODUCT_ID),
	index IXS_BASKET_PRODUCT_PRICE_ID(PRODUCT_PRICE_ID),
	index IXS_SBAS_XML_ID(PRODUCT_XML_ID, CATALOG_XML_ID),
	index IXS_BASKET_DATE_INSERT(DATE_INSERT),
	index IXS_BASKET_SET_PARENT_ID(SET_PARENT_ID)
);

create table if not exists b_crm_invoice_basket_props
(
	ID int not null auto_increment,
	BASKET_ID int not null,
	NAME varchar(255) not null,
	VALUE varchar(255) null,
	CODE varchar(255) null,
	SORT int not null default '100',
	XML_ID varchar(255) null,
	primary key (ID),
	index IXS_BASKET_PROPS_BASKET(BASKET_ID),
	index IXS_BASKET_PROPS_CODE(CODE)
);

create table if not exists b_crm_invoice
(
	ID int not null auto_increment,
	LID char(2) not null,
	PERSON_TYPE_ID int not null,
	PAYED char(1) not null default 'N',
	DATE_PAYED datetime null,
	EMP_PAYED_ID int null,
	CANCELED char(1) not null default 'N',
	DATE_CANCELED datetime null,
	EMP_CANCELED_ID int null,
	REASON_CANCELED varchar(255) null,
	STATUS_ID varchar(2) not null,
	DATE_STATUS datetime not null,
	EMP_STATUS_ID int null,
	PRICE_DELIVERY decimal(18,4) NOT NULL DEFAULT '0.0000',
	PRICE_PAYMENT decimal(18,4) NOT NULL DEFAULT '0.0000',
	ALLOW_DELIVERY char(1) not null default 'N',
	DATE_ALLOW_DELIVERY datetime null,
	EMP_ALLOW_DELIVERY_ID int null,
	DEDUCTED char(1) not null default 'N',
	DATE_DEDUCTED datetime null,
	EMP_DEDUCTED_ID int null,
	REASON_UNDO_DEDUCTED varchar(255) null,
	MARKED char(1) not null default 'N',
	DATE_MARKED datetime null,
	EMP_MARKED_ID int null,
	REASON_MARKED varchar(255) null,
	RESERVED char(1) not null default 'N',
	PRICE decimal(18, 4) not null,
	CURRENCY char(3) not null,
	DISCOUNT_VALUE decimal(18,4) NOT NULL DEFAULT '0.0000',
	USER_ID int not null,
	PAY_SYSTEM_ID int null,
	DELIVERY_ID varchar(50) null,
	DATE_INSERT datetime not null,
	DATE_UPDATE datetime not null,
	USER_DESCRIPTION varchar(2000) null,
	ADDITIONAL_INFO varchar(255) null,
	PS_STATUS char(1) null,
	PS_STATUS_CODE char(5) null,
	PS_STATUS_DESCRIPTION varchar(250) null,
	PS_STATUS_MESSAGE varchar(250) null,
	PS_SUM decimal(18,2) null,
	PS_CURRENCY char(3) null,
	PS_RESPONSE_DATE datetime null,
	COMMENTS text null,
	TAX_VALUE decimal(18,2) not null default '0.00',
	STAT_GID varchar(255) null,
	SUM_PAID decimal(18,2) not null default '0',
	IS_RECURRING char(1) not null default 'N',
	RECURRING_ID int null,
	PAY_VOUCHER_NUM varchar(20) null,
	PAY_VOUCHER_DATE date null,
	LOCKED_BY int null,
	DATE_LOCK datetime null,
	RECOUNT_FLAG char(1) not null default 'Y',
	AFFILIATE_ID int null,
	DELIVERY_DOC_NUM varchar(20) null,
	DELIVERY_DOC_DATE date null,
	UPDATED_1C CHAR(1) NOT NULL DEFAULT 'N',
	STORE_ID int null,
	ORDER_TOPIC varchar(255) null,
	CREATED_BY int(11) null,
	RESPONSIBLE_ID int(11) null,
	COMPANY_ID int(11) null,
	DATE_PAY_BEFORE datetime null,
	DATE_BILL datetime null,
	ACCOUNT_NUMBER varchar(100) null,
	TRACKING_NUMBER varchar(255) NULL,
	XML_ID varchar(255) null,
	ID_1C varchar(36) null,
	VERSION_1C varchar(15) null,
	VERSION INT(11) not null default '0',
	EXTERNAL_ORDER char(1) not null default 'N',
	RUNNING char(1) not null default 'N',
	BX_USER_ID varchar(32) null,
	SEARCH_CONTENT MEDIUMTEXT NULL,
	primary key (ID),
	index IXS_ORDER_PERSON_TYPE_ID(PERSON_TYPE_ID),
	index IXS_ORDER_STATUS_ID(STATUS_ID),
	index IXS_ORDER_REC_ID(RECURRING_ID),
	index IX_SOO_AFFILIATE_ID(AFFILIATE_ID),
	index IXS_ORDER_UPDATED_1C(UPDATED_1C),
	index IXS_SALE_COUNT(USER_ID,LID,PAYED,CANCELED),
	index IXS_DATE_UPDATE(DATE_UPDATE),
	index IXS_XML_ID(XML_ID),
	index IXS_ID_1C(ID_1C),
	index IX_BSO_DATE_ALLOW_DELIVERY(DATE_ALLOW_DELIVERY),
	index IX_BSO_ALLOW_DELIVERY(ALLOW_DELIVERY),
	index IX_BSO_DATE_CANCELED(DATE_CANCELED),
	index IX_BSO_CANCELED(CANCELED),
	index IX_BSO_DATE_PAYED(DATE_PAYED),
	index IX_BSO_DATE_INSERT(DATE_INSERT),
	index IX_BSO_DATE_PAY_BEFORE(DATE_PAY_BEFORE),
	unique IXS_ACCOUNT_NUMBER(ACCOUNT_NUMBER),
	FULLTEXT INDEX IX_B_CRM_INVOICE_SEARCH (SEARCH_CONTENT)
);

create table if not exists b_crm_invoice_payment(
	ID INT(11) NOT NULL AUTO_INCREMENT,
	ORDER_ID INT(11) NOT NULL,
	ACCOUNT_NUMBER varchar(100) null,
	PAID CHAR(1) NOT NULL DEFAULT 'N',
	DATE_PAID DATETIME NULL DEFAULT NULL,
	EMP_PAID_ID INT(11) NULL DEFAULT NULL,
	PAY_SYSTEM_ID INT(11) NOT NULL,
	PS_STATUS CHAR(1) NULL DEFAULT NULL,
	PS_INVOICE_ID VARCHAR(250) NULL,
	PS_STATUS_CODE VARCHAR(255) NULL DEFAULT NULL,
	PS_STATUS_DESCRIPTION VARCHAR(512) NULL DEFAULT NULL,
	PS_STATUS_MESSAGE VARCHAR(250) NULL DEFAULT NULL,
	PS_SUM DECIMAL(18,4) NULL DEFAULT NULL,
	PS_CURRENCY CHAR(3) NULL DEFAULT NULL,
	PS_RESPONSE_DATE DATETIME NULL DEFAULT NULL,
	PS_RECURRING_TOKEN VARCHAR(255) NULL DEFAULT NULL,
    PS_CARD_NUMBER VARCHAR(64) NULL DEFAULT NULL,
	PAY_VOUCHER_NUM VARCHAR(20) NULL DEFAULT NULL,
	PAY_VOUCHER_DATE DATE NULL DEFAULT NULL,
	DATE_PAY_BEFORE DATETIME NULL DEFAULT NULL,
	DATE_BILL DATETIME NULL DEFAULT NULL,
	XML_ID VARCHAR(255) NULL DEFAULT NULL,
	SUM DECIMAL(18,4) NOT NULL,
	PRICE_COD DECIMAL(18,4) NOT NULL DEFAULT 0,
	CURRENCY CHAR(3) NOT NULL,
	PAY_SYSTEM_NAME VARCHAR(128) NOT NULL,
	RESPONSIBLE_ID int(11) DEFAULT NULL,
	DATE_RESPONSIBLE_ID datetime DEFAULT NULL,
	EMP_RESPONSIBLE_ID int(11) DEFAULT NULL,
	COMMENTS text,
	COMPANY_ID int(11) DEFAULT NULL,
	PAY_RETURN_DATE date DEFAULT NULL,
	EMP_RETURN_ID INT(11) NULL DEFAULT NULL,
	PAY_RETURN_NUM VARCHAR(20) DEFAULT NULL,
	PAY_RETURN_COMMENT text,
	IS_RETURN CHAR(1) NOT NULL DEFAULT 'N',
	MARKED CHAR(1) NULL DEFAULT NULL,
	DATE_MARKED DATETIME NULL DEFAULT NULL,
	EMP_MARKED_ID INT(11) NULL DEFAULT NULL,
	REASON_MARKED VARCHAR(255) NULL DEFAULT NULL,
	ID_1C VARCHAR(36) NULL DEFAULT NULL,
	VERSION_1C VARCHAR(15) NULL DEFAULT NULL,
	EXTERNAL_PAYMENT CHAR(1) NOT NULL DEFAULT 'N',
	UPDATED_1C CHAR(1) NOT NULL DEFAULT 'N',
	PRIMARY KEY (ID),
	INDEX IX_BSOP_ORDER_ID (ORDER_ID),
	INDEX IX_BSOP_DATE_PAID (DATE_PAID),
	INDEX IX_BSOP_PAID (PAID),
	unique IXS_PAY_ACCOUNT_NUMBER(ACCOUNT_NUMBER)
);

create table if not exists b_crm_invoice_delivery (
	ID INT(11) NOT NULL AUTO_INCREMENT,
	ORDER_ID INT(11) NOT NULL,
	ACCOUNT_NUMBER varchar(100) null,
	DATE_INSERT DATETIME NOT NULL,
	DATE_REQUEST DATETIME NULL DEFAULT NULL,
	DATE_UPDATE DATETIME NULL DEFAULT NULL,
	DELIVERY_LOCATION VARCHAR(50) NULL DEFAULT NULL,
	PARAMS TEXT NULL,
	STATUS_ID VARCHAR(2) NOT NULL,
	PRICE_DELIVERY DECIMAL(18,4) NULL DEFAULT NULL,
	DISCOUNT_PRICE DECIMAL(18,4) NULL DEFAULT NULL,
	BASE_PRICE_DELIVERY DECIMAL(18,4) NULL DEFAULT NULL,
	CUSTOM_PRICE_DELIVERY CHAR(1) NULL DEFAULT NULL,
	ALLOW_DELIVERY CHAR(1) NULL DEFAULT 'N',
	DATE_ALLOW_DELIVERY DATETIME NULL DEFAULT NULL,
	EMP_ALLOW_DELIVERY_ID INT(11) NULL DEFAULT NULL,
	DEDUCTED CHAR(1) NULL DEFAULT 'N',
	DATE_DEDUCTED DATETIME NULL DEFAULT NULL,
	EMP_DEDUCTED_ID INT(11) NULL DEFAULT NULL,
	REASON_UNDO_DEDUCTED VARCHAR(255) NULL DEFAULT NULL,
	RESERVED CHAR(1) NULL DEFAULT NULL,
	DELIVERY_ID INT(11) NOT NULL,
	DELIVERY_DOC_NUM VARCHAR(20) NULL DEFAULT NULL,
	DELIVERY_DOC_DATE DATETIME NULL DEFAULT NULL,
	TRACKING_NUMBER VARCHAR(255) NULL DEFAULT NULL,
	XML_ID VARCHAR(255) NULL DEFAULT NULL,
	DELIVERY_NAME VARCHAR(128) NULL DEFAULT NULL,
	CANCELED CHAR(1) NULL DEFAULT 'N',
	DATE_CANCELED DATETIME NULL DEFAULT NULL,
	EMP_CANCELED_ID INT(11) NULL DEFAULT NULL,
	REASON_CANCELED VARCHAR(255) NULL DEFAULT '',
	MARKED CHAR(1) NULL DEFAULT NULL,
	DATE_MARKED DATETIME NULL DEFAULT NULL,
	EMP_MARKED_ID INT(11) NULL DEFAULT NULL,
	REASON_MARKED VARCHAR(255) NULL DEFAULT NULL,
	CURRENCY VARCHAR(3) NULL DEFAULT NULL,
	`SYSTEM` CHAR(1) NOT NULL DEFAULT 'N',
	WEIGHT double(18, 4) default 0,
	RESPONSIBLE_ID int(11) DEFAULT NULL,
	EMP_RESPONSIBLE_ID int(11) DEFAULT NULL,
	DATE_RESPONSIBLE_ID datetime DEFAULT NULL,
	COMMENTS text,
	COMPANY_ID int(11) DEFAULT NULL,
	TRACKING_STATUS INT(11) NULL,
	TRACKING_DESCRIPTION VARCHAR(255) NULL,
	TRACKING_LAST_CHECK DATETIME NULL,
	TRACKING_LAST_CHANGE DATETIME NULL,
	ID_1C VARCHAR(36) NULL DEFAULT NULL,
	VERSION_1C VARCHAR(15) NULL DEFAULT NULL,
	EXTERNAL_DELIVERY CHAR(1) NOT NULL DEFAULT 'N',
	UPDATED_1C CHAR(1) NOT NULL DEFAULT 'N',
	PRIMARY KEY (ID),
	INDEX IX_BSOD_ORDER_ID (ORDER_ID),
	INDEX IX_BSOD_DATE_ALLOW_DELIVERY (DATE_ALLOW_DELIVERY),
	INDEX IX_BSOD_ALLOW_DELIVERY (ALLOW_DELIVERY),
	INDEX IX_BSOD_DATE_CANCELED (DATE_CANCELED),
	INDEX IX_BSOD_CANCELED (CANCELED),
	unique IXS_DLV_ACCOUNT_NUMBER(ACCOUNT_NUMBER)
);

create table if not exists b_crm_invoice_dlv_basket(
	ID INT(11) NOT NULL AUTO_INCREMENT,
	ORDER_DELIVERY_ID INT(11) NOT NULL,
	BASKET_ID INT(11) NOT NULL,
	DATE_INSERT DATETIME NOT NULL,
	QUANTITY DECIMAL(18,4) NOT NULL,
	RESERVED_QUANTITY DECIMAL(18,4) NOT NULL,
	XML_ID varchar(255) null,
	PRIMARY KEY (ID),
	INDEX IX_BSODB_ORDER_DELIVERY_ID (ORDER_DELIVERY_ID),
	INDEX IX_S_O_DB_BASKET_ID (BASKET_ID)
);

create table if not exists b_crm_invoice_props_value
(
	ID int not null auto_increment,
	ORDER_ID int not null,
	ORDER_PROPS_ID int null,
	NAME varchar(255) not null,
	VALUE varchar(500) null,
	CODE varchar(50) null,
	XML_ID varchar(255) null,
	ENTITY_ID int not null,
	ENTITY_TYPE varchar(255) not null,
	primary key (ID),
	unique IX_SOPV_ORD_PROP_UNI(ENTITY_ID, ENTITY_TYPE(200), ORDER_PROPS_ID),
	INDEX IX_SOPV_ORD_PROP_UNI_OLD(ORDER_ID, ORDER_PROPS_ID)
);

create table if not exists b_crm_order_props_match
(
	ID INT NOT NULL AUTO_INCREMENT,
	SALE_PROP_ID INT NOT NULL,
	CRM_ENTITY_TYPE INT NOT NULL,
	CRM_FIELD_TYPE INT NOT NULL,
	CRM_FIELD_CODE VARCHAR (50) NOT NULL,
	SETTINGS TEXT NULL,
	primary key (ID),
	INDEX IX_BCOPM_SALE_PROP_ID (SALE_PROP_ID),
	INDEX IX_BCOPM_CRM_ENTITY_TYPE (CRM_ENTITY_TYPE)
);

create table if not exists b_crm_order_props_form_queue
(
	ID INT (18) UNSIGNED NOT NULL AUTO_INCREMENT,
	PERSON_TYPE_ID INT (18) NOT NULL,
	USER_ID INT(18) NOT NULL,
	WORK_TIME CHAR(1) NOT NULL DEFAULT 'N',
	PRIMARY KEY (ID),
	INDEX IX_BCOPFQ_PERSON_TYPE_ID (PERSON_TYPE_ID)
);

create table if not exists b_crm_order_props_form
(
	ID INT (18) UNSIGNED NOT NULL AUTO_INCREMENT,
	PERSON_TYPE_ID INT (18) NOT NULL,
	DUPLICATE_MODE varchar(20) DEFAULT NULL,
	PRIMARY KEY (ID)
);

create table if not exists b_crm_order_contact_company
(
	ID INT NOT NULL AUTO_INCREMENT,
	ORDER_ID INT(1) UNSIGNED NOT NULL,
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	ENTITY_TYPE_ID INT(1) UNSIGNED NOT NULL,
	SORT INT NOT NULL,
	ROLE_ID TINYINT(1) NOT NULL,
	IS_PRIMARY CHAR(1) NOT NULL,
	XML_ID VARCHAR(255) NULL,
	PRIMARY KEY (ID),
	UNIQUE IX_C_OCC_ENTITY(ORDER_ID, ENTITY_ID, ENTITY_TYPE_ID),
	INDEX IX_C_OCC_1 (ENTITY_ID, ENTITY_TYPE_ID)
);

create table if not exists b_crm_invoice_change
(
	ID INT NOT NULL AUTO_INCREMENT,
	ORDER_ID INT NOT NULL,
	TYPE VARCHAR(255) NOT NULL,
	DATA VARCHAR(512) NULL,
	DATE_CREATE datetime NOT NULL,
	DATE_MODIFY datetime NOT NULL,
	USER_ID INT NOT NULL,
	ENTITY VARCHAR(50) NULL DEFAULT NULL,
	ENTITY_ID INT(11) NULL DEFAULT NULL,
	PRIMARY KEY (ID),
	index `IXC_ORDER_ID_CHANGE` (`ORDER_ID`),
	index `IXC_TYPE_CHANGE` (`TYPE`)
);

create table if not exists b_crm_invoice_entity_marker (
	ID int(11) not null auto_increment,
	ORDER_ID int(11) not null,
	ENTITY_TYPE varchar(25) not null,
	ENTITY_ID int(11) not null,
	TYPE varchar(10) not null,
	CODE varchar(255) not null,
	MESSAGE varchar(255) not null,
	COMMENT varchar(500) null default null,
	USER_ID int(11) null default null,
	DATE_CREATE datetime null default null,
	DATE_UPDATE datetime null default null,
	SUCCESS char(1) not null default 'N',
	primary key (ID),
	index IX_BSEM_TYPE (TYPE),
	index IX_BSEM_ENTITY_TYPE (ENTITY_TYPE),
	index IX_BSEM_ORDER_ID (ORDER_ID)
);

create table if not exists b_crm_invoice_tax
(
	ID int not null auto_increment,
	ORDER_ID int not null,
	TAX_NAME varchar(255) not null,
	VALUE decimal(18,4) null,
	VALUE_MONEY decimal(18,4) not null,
	APPLY_ORDER int not null,
	CODE varchar(50) null,
	IS_PERCENT char(1) not null default 'Y',
	IS_IN_PRICE char(1) not null default 'N',
	primary key (ID),
	index ixs_cit_order_id(ORDER_ID)
);

create table if not exists b_crm_invoice_discount
(
	ID int not null auto_increment,
	MODULE_ID varchar(50) not null,
	DISCOUNT_ID int not null,
	NAME varchar(255) not null,
	DISCOUNT_HASH varchar(32) not null,
	CONDITIONS mediumtext null,
	UNPACK mediumtext null,
	ACTIONS mediumtext null,
	APPLICATION mediumtext null,
	USE_COUPONS char(1) not null,
	SORT int not null,
	PRIORITY int not null,
	LAST_DISCOUNT char(1) not null,
	ACTIONS_DESCR mediumtext null,
	primary key (ID),
	index IX_CRM_INVOICE_DSC_HASH(DISCOUNT_HASH)
);

create table if not exists b_crm_invoice_coupons
(
	ID int not null auto_increment,
	ORDER_ID int not null,
	ORDER_DISCOUNT_ID int not null,
	COUPON varchar(32) not null,
	TYPE int not null,
	COUPON_ID int not null,
	DATA text null,
	primary key (ID),
	index IX_CRM_INVOICE_CPN_ORDER(ORDER_ID)
);

create table if not exists b_crm_invoice_modules
(
	ID int not null auto_increment,
	ORDER_DISCOUNT_ID int not null,
	MODULE_ID varchar(50) not null,
	primary key (ID),
	index IX_CRM_INVOICE_MDL_DSC(ORDER_DISCOUNT_ID)
);

create table if not exists b_crm_invoice_rules
(
	ID int not null auto_increment,
	MODULE_ID varchar(50) not null,
	ORDER_DISCOUNT_ID int not null,
	ORDER_ID int not null,
	ENTITY_TYPE int not null,
	ENTITY_ID int not null,
	ENTITY_VALUE varchar(255) null,
	COUPON_ID int not null,
	APPLY char(1) not null,
	ACTION_BLOCK_LIST text null,
	APPLY_BLOCK_COUNTER int not null default 0,
	primary key (ID),
	index IX_CRM_INVOICE_RULES_ORD(ORDER_ID)
);

create table if not exists b_crm_invoice_rules_descr
(
	ID int not null auto_increment,
	MODULE_ID varchar(50) not null,
	ORDER_DISCOUNT_ID int not null,
	ORDER_ID int not null,
	RULE_ID int not null,
	DESCR text not null,
	primary key (ID),
	index IX_CRM_INVOICE_RULES_DS_ORD(ORDER_ID),
	index IX_CRM_INVOICE_RULES_DS_RULE(RULE_ID)
);

create table if not exists b_crm_invoice_discount_data
(
	ID int not null auto_increment,
	ORDER_ID int not null,
	ENTITY_TYPE int not null,
	ENTITY_ID int not null,
	ENTITY_VALUE varchar(255) null,
	ENTITY_DATA mediumtext not null,
	primary key (ID),
	index IX_CRM_DSC_DATA_CMX(ORDER_ID, ENTITY_TYPE)
);

create table if not exists b_crm_invoice_round
(
	ID int not null auto_increment,
	ORDER_ID int not null,
	APPLY_BLOCK_COUNTER int not null default 0,
	ORDER_ROUND char(1) not null,
	ENTITY_TYPE int not null,
	ENTITY_ID int not null,
	ENTITY_VALUE varchar(255) null,
	APPLY char(1) not null,
	ROUND_RULE mediumtext not null,
	primary key (ID),
	index IX_CRM_INVOICE_ROUND_ORD(ORDER_ID)
);


CREATE TABLE b_crm_volume
(
	ID int(11) not null auto_increment,
	INDICATOR_TYPE varchar(255) not null,
	OWNER_ID int(11) not null default 0,
	DATE_CREATE DATE NULL,
	STAGE_SEMANTIC_ID VARCHAR(3) NULL,
	TIMESTAMP_X TIMESTAMP not null default CURRENT_TIMESTAMP,
	ENTITY_SIZE BIGINT not null default 0,
	ENTITY_COUNT BIGINT not null default 0,
	FILE_SIZE BIGINT not null default 0,
	FILE_COUNT BIGINT not null default 0,
	DISK_SIZE BIGINT not null default 0,
	DISK_COUNT BIGINT not null default 0,
	EVENT_SIZE BIGINT not null default 0,
	EVENT_COUNT BIGINT not null default 0,
	ACTIVITY_SIZE BIGINT not null default 0,
	ACTIVITY_COUNT BIGINT not null default 0,
	AGENT_LOCK tinyint(1) not null default 0,
	DROP_ENTITY tinyint(1) not null default 0,
	DROP_FILE tinyint(1) not null default 0,
	DROP_EVENT tinyint(1) not null default 0,
	DROP_ACTIVITY tinyint(1) not null default 0,
	DROPPED_ENTITY_COUNT BIGINT not null default 0,
	DROPPED_FILE_COUNT BIGINT not null default 0,
	DROPPED_EVENT_COUNT BIGINT not null default 0,
	DROPPED_ACTIVITY_COUNT BIGINT not null default 0,
	LAST_ID int(11) null default null,
	FAIL_COUNT int(11) not null default 0,
	LAST_ERROR varchar(255) null default null,
	FILTER TEXT null default null,
	PRIMARY KEY (ID),
	UNIQUE INDEX UX_CRM_VL_1 (OWNER_ID, INDICATOR_TYPE, DATE_CREATE, STAGE_SEMANTIC_ID),
	KEY IX_CRM_VL_4 (OWNER_ID, INDICATOR_TYPE, AGENT_LOCK, DATE_CREATE, STAGE_SEMANTIC_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_field_attr(
		ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
		ENTITY_TYPE_ID INT(1) NOT NULL,
		ENTITY_SCOPE VARCHAR(32) NOT NULL,
		TYPE_ID TINYINT(1) UNSIGNED NOT NULL,
		FIELD_NAME VARCHAR(64) NOT NULL,
		CREATED_TIME DATETIME NOT NULL,
		START_PHASE VARCHAR(64) NOT NULL,
		FINISH_PHASE VARCHAR(64) NOT NULL,
		PHASE_GROUP_TYPE_ID TINYINT(1) UNSIGNED NOT NULL,
		IS_CUSTOM_FIELD CHAR(1) NOT NULL,
		PRIMARY KEY(ID),
		INDEX IX_B_CRM_FIELD_ATTR_1(ENTITY_TYPE_ID, ENTITY_SCOPE, TYPE_ID, FIELD_NAME),
		INDEX IX_B_CRM_FIELD_ATTR_2(ENTITY_TYPE_ID, ENTITY_SCOPE, TYPE_ID, IS_CUSTOM_FIELD),
		INDEX IX_B_CRM_FIELD_ATTR_3(FIELD_NAME, IS_CUSTOM_FIELD)
);

CREATE TABLE IF NOT EXISTS b_crm_observer(
	ENTITY_TYPE_ID INT(1) NOT NULL,
	ENTITY_ID INT(1) UNSIGNED NOT NULL,
	USER_ID INT(1) UNSIGNED NOT NULL,
	SORT INT(1) NOT NULL DEFAULT 0,
	CREATED_TIME DATETIME NOT NULL,
	LAST_UPDATED_TIME DATETIME NOT NULL,
	PRIMARY KEY(USER_ID, ENTITY_ID, ENTITY_TYPE_ID),
	INDEX IX_B_CRM_OBSERVER_1(ENTITY_ID, ENTITY_TYPE_ID, USER_ID),
	INDEX IX_B_CRM_OBSERVER_2(USER_ID, ENTITY_TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_cleaning (
	ENTITY_ID INT(1) NOT NULL,
	ENTITY_TYPE_ID INT(1) NOT NULL,
	CREATED_TIME DATETIME NOT NULL,
	LAST_UPDATED_TIME DATETIME NOT NULL,
	FORCE_USER_ID INT,
	PRIMARY KEY(ENTITY_ID, ENTITY_TYPE_ID),
	INDEX IX_B_CRM_CLEANING_1(CREATED_TIME)
);

CREATE TABLE IF NOT EXISTS b_crm_order_import_product
(
	ID INT NOT NULL AUTO_INCREMENT,
	PRODUCT_ID INT NOT NULL,
	SOURCE_NAME VARCHAR (100) NOT NULL,
	SOURCE_ID VARCHAR (100) NOT NULL,
	SETTINGS TEXT NULL,
	DATE_CREATE TIMESTAMP NULL,
	DATE_MODIFY TIMESTAMP NULL ON UPDATE NOW(),
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_OIP_PROD(PRODUCT_ID),
	INDEX IX_B_CRM_OIP_SRC(SOURCE_NAME, SOURCE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_site
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	DATE_CREATE DATETIME NULL,
	HOST VARCHAR(255) NOT NULL,
	ADDRESS VARCHAR(255) NOT NULL,
	ACTIVE CHAR(1) NOT NULL DEFAULT 'N',
	IS_INSTALLED CHAR(1) NOT NULL DEFAULT 'N',
	PHONES TEXT NULL,
	EMAILS TEXT NULL,
	REPLACE_TEXT CHAR(1) NOT NULL DEFAULT 'Y',
	ENRICH_TEXT CHAR(1) NOT NULL DEFAULT 'Y',
	RESOLVE_DUPLICATES CHAR(1) NOT NULL DEFAULT 'Y',
	PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_site_b24
(
	LANDING_SITE_ID INT UNSIGNED NOT NULL,
	IS_SHOP CHAR(1) NOT NULL DEFAULT 'N',
	PRIMARY KEY (LANDING_SITE_ID, IS_SHOP)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_source
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	DATE_CREATE DATETIME NULL,
	ACTIVE CHAR(1) NOT NULL DEFAULT 'Y',
	CODE VARCHAR(20) NULL,
	NAME VARCHAR(255) NOT NULL,
	ICON_COLOR VARCHAR(10) NULL,
	PHONE VARCHAR(50) NULL,
	EMAIL VARCHAR(50) NULL,
	UTM_SOURCE VARCHAR(50) NULL,
	TAGS TEXT NULL,
	AD_CLIENT_ID VARCHAR(50) NULL,
	AD_ACCOUNT_ID VARCHAR(50) NULL,
	PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_pool
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	DATE_CREATE DATETIME NULL,
	TYPE_ID INT(2) UNSIGNED NOT NULL,
	VALUE VARCHAR(50) NOT NULL,
	PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_phone_number
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	DATE_CREATE DATETIME NULL,
	VALUE VARCHAR(50) NOT NULL,
	USE_CNT INT UNSIGNED NOT NULL DEFAULT 0,
	DATE_USE DATETIME NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_TRACKING_PHONE_NUMBER_VALUE(VALUE)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_source_field
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	SOURCE_ID INT NOT NULL DEFAULT 0,
	CODE VARCHAR(50) NOT NULL,
	VALUE VARCHAR(2000) NOT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_TRACKING_SRC_FLD_SID(SOURCE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_expenses_pack
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	DATE_INSERT DATETIME NULL,
	SOURCE_ID INT NOT NULL DEFAULT 0,
	TYPE_ID INT(2) UNSIGNED NOT NULL DEFAULT 0,
	DATE_FROM DATE NULL,
	DATE_TO DATE NULL,
	ACTIONS INT NULL,
	EXPENSES DECIMAL(18, 2) NOT NULL DEFAULT 0,
	CURRENCY_ID VARCHAR (50) NOT NULL,
	COMMENT VARCHAR (500) NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_TRACKING_SRC_EXP_SID(SOURCE_ID),
	INDEX IX_B_CRM_TRACKING_SRC_EXP_DATE(DATE_FROM, DATE_TO)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_source_expenses
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	PACK_ID INT NOT NULL DEFAULT 0,
	SOURCE_ID INT NOT NULL DEFAULT 0,
	TYPE_ID INT(2) UNSIGNED NOT NULL DEFAULT 0,
	DATE_STAT DATE NULL,
	ACTIONS INT NULL,
	EXPENSES DECIMAL(18, 2) NOT NULL DEFAULT 0,
	CURRENCY_ID VARCHAR (50) NOT NULL,
	COMMENT VARCHAR (500) NULL,
	SOURCE_CHILD_ID BIGINT(20) UNSIGNED NOT NULL DEFAULT 0,
	IMPRESSIONS BIGINT(20) UNSIGNED NOT NULL DEFAULT 0,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_TRACKING_SRC_EXP_PID(PACK_ID),
	INDEX IX_B_CRM_TRACKING_SRC_EXP_SID(SOURCE_ID),
	INDEX IX_B_CRM_TRACKING_SRC_EXP_DST(DATE_STAT)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_trace
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	DATE_CREATE DATETIME NULL,
	SOURCE_ID INT NULL DEFAULT 0,
	GUEST_ID INT NULL,
	TAGS_RAW TEXT NULL,
	PAGES_RAW TEXT NULL,
	IS_MOBILE CHAR(1) NOT NULL DEFAULT 'N',
	HAS_CHILD CHAR(1) NOT NULL DEFAULT 'N',
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_TRACKING_TR_SO(SOURCE_ID),
	INDEX IX_B_CRM_TRACKING_TR_DC(DATE_CREATE)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_trace_tree
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	CHILD_ID INT UNSIGNED NOT NULL,
	PARENT_ID INT UNSIGNED NOT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_TRACKING_TREE_PID(PARENT_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_trace_channel
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	TRACE_ID INT NOT NULL,
	CODE VARCHAR(25) NOT NULL,
	VALUE VARCHAR(255) NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_TRACKING_TR_CH_CH(CODE),
	INDEX IX_CRM_TRACKING_TRACE_CHANNEL_TRACE_ID (TRACE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_tracking_trace_entity
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	TRACE_ID INT NOT NULL,
	ENTITY_TYPE_ID INT NOT NULL,
	ENTITY_ID INT NOT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_TRACKING_TR_EN_EN(ENTITY_TYPE_ID, ENTITY_ID),
	INDEX IX_B_CRM_TRACKING_TR_EN_TR(TRACE_ID)
);

CREATE TABLE b_crm_tracking_source_child (
	ID BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
	PARENT_ID BIGINT(20) UNSIGNED NOT NULL DEFAULT 0,
	SOURCE_ID BIGINT(20) UNSIGNED NOT NULL,
	LEVEL TINYINT(3) UNSIGNED NOT NULL DEFAULT 0,
	CODE VARCHAR(50) NOT NULL,
	TITLE VARCHAR(250) NULL DEFAULT NULL,
	IS_ENABLED TINYINT(3) UNSIGNED NOT NULL DEFAULT 1,
	PRIMARY KEY (ID),
	UNIQUE INDEX UQ_CRM_TRACKING_SOURCE_CHILD (SOURCE_ID, PARENT_ID, CODE)
);

CREATE TABLE b_crm_tracking_trace_source (
   ID BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
   TRACE_ID INT(11) NOT NULL,
   LEVEL TINYINT(3) UNSIGNED NOT NULL DEFAULT 0,
   CODE VARCHAR(50) NOT NULL,
   SOURCE_CHILD_ID BIGINT(20) UNSIGNED NOT NULL DEFAULT 0,
   PROCESSED TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
   PRIMARY KEY (ID),
   UNIQUE INDEX UQ_CRM_TRACKING_TRACE_SRC (TRACE_ID, LEVEL)
);

CREATE TABLE IF NOT EXISTS b_crm_recycling_relation
(
	SRC_ENTITY_TYPE_ID INT UNSIGNED NOT NULL,
	SRC_ENTITY_ID INT UNSIGNED NOT NULL,
	SRC_RECYCLE_BIN_ID INT UNSIGNED NOT NULL,
	DST_ENTITY_TYPE_ID INT UNSIGNED NOT NULL,
	DST_ENTITY_ID INT UNSIGNED NOT NULL,
	DST_RECYCLE_BIN_ID INT UNSIGNED NOT NULL,
	PREVIOUS_SRC_ENTITY_ID INT UNSIGNED NULL,
	PREVIOUS_DST_ENTITY_ID INT UNSIGNED NULL,
	CREATED_TIME DATETIME NULL,
	LAST_UPDATED_TIME DATETIME NULL,
	PRIMARY KEY(SRC_ENTITY_ID, SRC_ENTITY_TYPE_ID, SRC_RECYCLE_BIN_ID, DST_ENTITY_ID, DST_ENTITY_TYPE_ID, DST_RECYCLE_BIN_ID),
	INDEX IX_B_CRM_RECYCLING_REL_1(DST_ENTITY_ID, DST_ENTITY_TYPE_ID, DST_RECYCLE_BIN_ID, SRC_ENTITY_ID, SRC_ENTITY_TYPE_ID, SRC_RECYCLE_BIN_ID),
	INDEX IX_B_CRM_RECYCLING_REL_3(DST_RECYCLE_BIN_ID),
	INDEX IX_B_CRM_RECYCLING_REL_4(SRC_RECYCLE_BIN_ID, DST_RECYCLE_BIN_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_order_entity
(
	OWNER_ID INT UNSIGNED NOT NULL,
	OWNER_TYPE_ID INT(1) NOT NULL,
	ORDER_ID INT UNSIGNED NOT NULL,
	PRIMARY KEY(OWNER_ID, OWNER_TYPE_ID, ORDER_ID),
	UNIQUE IX_ORDER_DEAL_ID(ORDER_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_order_sending_channels
(
	ID int unsigned not null auto_increment,
	ENTITY_ID int unsigned not null,
	ENTITY_TYPE varchar(10) not null,
	CHANNEL_TYPE varchar(10) not null,
	CHANNEL_NAME varchar(50) not null default '',
	PRIMARY KEY(ID),
	UNIQUE IX_ORDER_SENDING_CHANNEL(ENTITY_ID, ENTITY_TYPE)
);

CREATE TABLE IF NOT EXISTS b_crm_ml_model_training
(
	ID int not null auto_increment,
	MODEL_NAME varchar(64) not null,
	RECORDS_SUCCESS int not null,
	RECORDS_FAILED int not null,
	DATE_START datetime not null,
	DATE_FINISH datetime,
	STATE varchar(50) not null,
	AREA_UNDER_CURVE double,
	LAST_ID int,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_ML_MODEL_TRAIN_1(MODEL_NAME, DATE_START)
);

CREATE TABLE IF NOT EXISTS b_crm_ml_prediction_history
(
	ID int NOT NULL AUTO_INCREMENT,
	CREATED datetime NOT NULL,
	ENTITY_TYPE_ID int NOT NULL,
	ENTITY_ID int NOT NULL,
	MODEL_NAME varchar(64) NOT NULL,
	IS_PENDING varchar(1) NOT NULL default 'N',
	ANSWER varchar(1),
	SCORE double,
	SCORE_DELTA double,
	EVENT_TYPE varchar(32) NULL,
	ASSOCIATED_ACTIVITY_ID int,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_ML_PREDICTION_HISTORY_1(ENTITY_TYPE_ID, ENTITY_ID, CREATED),
	INDEX IX_B_CRM_ML_PREDICTION_HISTORY_2(ASSOCIATED_ACTIVITY_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_ml_prediction_queue
(
	ID int NOT NULL AUTO_INCREMENT,
	CREATED datetime NOT NULL,
	DELAYED_UNTIL datetime,
	ENTITY_TYPE_ID int NOT NULL,
	ENTITY_ID int NOT NULL,
	TYPE varchar(32) NOT NULL,
	ADDITIONAL_PARAMETERS mediumtext,
	STATE varchar(32) NOT NULL,
	ERROR varchar(2000),
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_ML_PREDICTION_QUEUE_1(STATE, DELAYED_UNTIL),
	INDEX IX_B_CRM_ML_PREDICTION_QUEUE_2(ENTITY_ID,ENTITY_TYPE_ID)
);
CREATE TABLE b_crm_rq_conv_log
(
	ID INT(1) UNSIGNED NOT NULL AUTO_INCREMENT,
	CREATED datetime NOT NULL,
	MSEC INT(1) UNSIGNED NOT NULL,
	TYPE varchar(20) NOT NULL,
	TAG varchar(255) NOT NULL,
	MESSAGE varchar(4095),
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_RQ_CONV_LOG_1(CREATED, MSEC),
	INDEX IX_B_CRM_RQ_CONV_LOG_2(TYPE),
	INDEX IX_B_CRM_RQ_CONV_LOG_3(TAG)
);

CREATE TABLE IF NOT EXISTS `b_crm_dynamic_type` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ENTITY_TYPE_ID` int NOT NULL,
  `CUSTOM_SECTION_ID` int,
  `CODE` varchar(255) NULL,
  `NAME` varchar(255) NOT NULL,
  `TITLE` varchar(255) NOT NULL,
  `TABLE_NAME` varchar(64) NOT NULL,
  `CREATED_BY` int(11) unsigned NOT NULL,
  `IS_CATEGORIES_ENABLED` char(1) NOT NULL DEFAULT 'N',
  `IS_STAGES_ENABLED` char(1) NOT NULL DEFAULT 'N',
  `IS_BEGIN_CLOSE_DATES_ENABLED` CHAR(1) NOT NULL DEFAULT 'N',
  `IS_CLIENT_ENABLED` CHAR(1) NOT NULL DEFAULT 'N',
  `IS_LINK_WITH_PRODUCTS_ENABLED` CHAR(1) NOT NULL DEFAULT 'N',
  `IS_CRM_TRACKING_ENABLED` CHAR(1) NOT NULL DEFAULT 'N',
  `IS_MYCOMPANY_ENABLED` CHAR(1) NOT NULL DEFAULT 'N',
  `IS_DOCUMENTS_ENABLED` CHAR(1) NOT NULL DEFAULT 'N',
  `IS_SOURCE_ENABLED` CHAR(1) NOT NULL DEFAULT 'N',
  `IS_USE_IN_USERFIELD_ENABLED` CHAR(1) NOT NULL DEFAULT 'N',
  `IS_OBSERVERS_ENABLED` CHAR(1) NOT NULL DEFAULT 'N',
  `IS_RECYCLEBIN_ENABLED` CHAR(1) NOT NULL DEFAULT 'N',
  `IS_AUTOMATION_ENABLED` CHAR(1) NOT NULL DEFAULT 'N',
  `IS_BIZ_PROC_ENABLED` CHAR(1) NOT NULL DEFAULT 'N',
  `IS_SET_OPEN_PERMISSIONS` CHAR(1) NOT NULL DEFAULT 'Y',
  `IS_PAYMENTS_ENABLED` CHAR(1) NOT NULL DEFAULT 'N',
  `IS_COUNTERS_ENABLED` CHAR(1) NOT NULL DEFAULT 'N',
  `CREATED_TIME` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `UPDATED_TIME` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `UPDATED_BY` INT(11) UNSIGNED NOT NULL,
  `IS_INITIALIZED` CHAR(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (ID),
  INDEX IX_B_CRM_TYPE_CSI(CUSTOM_SECTION_ID),
  INDEX IX_B_CRM_TYPE_IS_INITIALIZED(IS_INITIALIZED),
  UNIQUE ux_crm_type_table(TABLE_NAME),
  UNIQUE ux_b_crm_dynamic_type_entity_type_id(ENTITY_TYPE_ID)
);

CREATE TABLE IF NOT EXISTS `b_crm_item_category` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ENTITY_TYPE_ID` int NOT NULL,
  `IS_DEFAULT` char(1) NOT NULL DEFAULT 'N',
  `IS_SYSTEM` char(1) NOT NULL DEFAULT 'N',
  `CODE` varchar(255) DEFAULT NULL,
  `CREATED_DATE` DATETIME NULL,
  `NAME` varchar(255) NOT NULL,
  `SORT` int(18) NOT NULL,
  `SETTINGS` TEXT NULL,
  PRIMARY KEY (ID),
  UNIQUE KEY IX_B_CRM_ITEM_CATEGORY_CODE (CODE),
  INDEX IX_B_CRM_ITEM_CATEGORY_ETD(ENTITY_TYPE_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_item_category_user_field
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID INT UNSIGNED NOT NULL,
	CATEGORY_ID INT UNSIGNED NOT NULL,
	USER_FIELD_NAME VARCHAR(50) NOT NULL,
	PRIMARY KEY(ID),
	UNIQUE KEY (ENTITY_TYPE_ID, CATEGORY_ID, USER_FIELD_NAME),
	INDEX IX_B_CRM_ITEM_CATEGORY_USER_FIELD_CID (CATEGORY_ID),
	INDEX IX_B_CRM_ITEM_CATEGORY_USER_FIELD_ETID_CID (ENTITY_TYPE_ID, CATEGORY_ID)
);

CREATE TABLE IF NOT EXISTS `b_crm_assigned` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ENTITY_TYPE_ID` int(10) unsigned NOT NULL,
  `ENTITY_ID` int(10) unsigned NOT NULL,
  `ASSIGNED_BY` int(10) unsigned NOT NULL,
  PRIMARY KEY (ID),
  INDEX IX_B_CRM_ASSIGNED_ENTITY(ENTITY_TYPE_ID, ENTITY_ID),
  INDEX IX_B_CRM_ASSIGNED_ASSIGNED_BY(ASSIGNED_BY)
);

CREATE TABLE IF NOT EXISTS `b_crm_entity_contact` (
	`ENTITY_TYPE_ID` int(10) unsigned NOT NULL,
	`ENTITY_ID` int(10) unsigned NOT NULL,
	`CONTACT_ID` int(10) unsigned NOT NULL,
	`SORT` int(18) NOT NULL,
	`ROLE_ID` tinyint(1) NOT NULL,
	`IS_PRIMARY` char(1) NOT NULL DEFAULT 'N',
	PRIMARY KEY (ENTITY_TYPE_ID, ENTITY_ID, CONTACT_ID),
	INDEX IX_B_CRM_ENTITY_CONTACT_1(CONTACT_ID, ENTITY_TYPE_ID, ENTITY_ID),
	INDEX IX_B_CRM_ENTITY_CONTACT_2(ENTITY_TYPE_ID, ENTITY_ID, IS_PRIMARY, CONTACT_ID),
	INDEX IX_B_CRM_ENTITY_CONTACT_3(ENTITY_TYPE_ID, ENTITY_ID, SORT, CONTACT_ID)
);

CREATE TABLE IF NOT EXISTS `b_crm_entity_relation` (
	`SRC_ENTITY_TYPE_ID` int(10) unsigned NOT NULL,
	`SRC_ENTITY_ID` int(10) unsigned NOT NULL,
	`DST_ENTITY_TYPE_ID` int(10) unsigned NOT NULL,
	`DST_ENTITY_ID` int(10) unsigned NOT NULL,
	`RELATION_TYPE` varchar(20) NOT NULL,
	PRIMARY KEY (SRC_ENTITY_TYPE_ID, SRC_ENTITY_ID, DST_ENTITY_TYPE_ID, DST_ENTITY_ID),
    INDEX IX_B_CRM_ENT_REL_DST_ENT_ID (DST_ENTITY_ID)
);

CREATE TABLE b_crm_company_index
(
	COMPANY_ID int not null,
	SEARCH_CONTENT text null,
	primary key (COMPANY_ID),
	fulltext index ixf_b_crm_company_index_1(SEARCH_CONTENT)
);

CREATE TABLE b_crm_contact_index
(
	CONTACT_ID int not null,
	SEARCH_CONTENT text null,
	primary key (CONTACT_ID),
	fulltext index ixf_b_crm_contact_index_1(SEARCH_CONTENT)
);

CREATE TABLE b_crm_lead_index
(
	LEAD_ID int not null,
	SEARCH_CONTENT text null,
	primary key (LEAD_ID),
	fulltext index ixf_b_crm_lead_index_1(SEARCH_CONTENT)
);

CREATE TABLE b_crm_deal_index
(
	DEAL_ID int not null,
	SEARCH_CONTENT text null,
	primary key (DEAL_ID),
	fulltext index ixf_b_crm_deal_index_1(SEARCH_CONTENT)
);

CREATE TABLE b_crm_dp_autosearch_user_settings
(
    USER_ID INT(18) UNSIGNED NOT NULL,
    ENTITY_TYPE_ID INT(1) NOT NULL,
    STATUS_ID INT(1) DEFAULT 0 NOT NULL,
    EXEC_INTERVAL INT DEFAULT 0 NOT NULL,
    LAST_EXEC_TIME DATETIME,
    NEXT_EXEC_TIME DATETIME,
    PROGRESS_DATA TEXT,
    IS_MERGE_ENABLED CHAR(1) DEFAULT 'N' NOT NULL,
    CHECK_CHANGED_ONLY CHAR(1) DEFAULT "N" NOT NULL,
    MERGE_ID VARCHAR(8) DEFAULT NULL,
    MERGE_ACTIVITY_DATE DATETIME DEFAULT NULL,
    PRIMARY KEY (USER_ID,ENTITY_TYPE_ID)
);

CREATE TABLE b_crm_dp_automatic_index
(
    ID int unsigned not null auto_increment,
    USER_ID int unsigned not null,
    ENTITY_TYPE_ID int not null,
    TYPE_ID int unsigned not null,
    MATCH_HASH varchar(32) not null,
    MATCHES text null,
    QUANTITY int unsigned not null,
    `SCOPE` varchar(6) default '' not null,
    STATUS_ID int unsigned null,
    IS_DIRTY char(1) default 'N' not null,
    ROOT_ENTITY_ID int unsigned not null,
    ROOT_ENTITY_NAME varchar(256) not null,
    ROOT_ENTITY_TITLE varchar(256) not null,
    ROOT_ENTITY_PHONE varchar(256) not null,
    ROOT_ENTITY_EMAIL varchar(256) not null,
    ROOT_ENTITY_RQ_INN varchar(15) default '' not null,
    ROOT_ENTITY_RQ_OGRN varchar(13) default '' not null,
    ROOT_ENTITY_RQ_OGRNIP varchar(15) default '' not null,
    ROOT_ENTITY_RQ_BIN varchar(12) default '' not null,
    ROOT_ENTITY_RQ_EDRPOU varchar(10)  null,
    ROOT_ENTITY_RQ_VAT_ID varchar(20) default '' not null,
    ROOT_ENTITY_RQ_ACC_NUM varchar(34) default '' not null,
    ROOT_ENTITY_RQ_IBAN varchar(34) default '' not null,
    ROOT_ENTITY_RQ_IIK varchar(20) default '' not null,
    PRIMARY KEY (ID),
    INDEX IX_CRM_DP_AUTOMATIC_INDEX_1 (MATCH_HASH, USER_ID, ENTITY_TYPE_ID, TYPE_ID, `SCOPE`),
    INDEX IX_CRM_DP_AUTOMATIC_INDEX_2 (USER_ID, ENTITY_TYPE_ID, TYPE_ID, `SCOPE`),
    INDEX IX_CRM_DP_AUTOMATIC_INDEX_3 (ENTITY_TYPE_ID, ROOT_ENTITY_ID)
);

CREATE TABLE b_crm_originator
(
	ORIGINATOR_ID VARCHAR(255) NOT NULL,
	ICON_ID INT(18),
	PRIMARY KEY (ORIGINATOR_ID)
);

CREATE TABLE b_crm_order_payment_stage
(
	PAYMENT_ID INT(11) NOT NULL,
	STAGE VARCHAR(255) NOT NULL,
	UPDATED_AT DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY(PAYMENT_ID)
);
CREATE TABLE b_crm_workflow_entity_stage
(
	ID INT(11) NOT NULL AUTO_INCREMENT,
	ENTITY_ID INT(11) NOT NULL,
	WORKFLOW_CODE VARCHAR(255) NOT NULL,
	STAGE VARCHAR(255) NOT NULL,
	UPDATED_AT DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	UPDATED_BY INT(11) NULL DEFAULT NULL,
	PRIMARY KEY (ID),
	UNIQUE INDEX UX_ENTITY_ID_WORKFLOW_CODE (ENTITY_ID, WORKFLOW_CODE)
);

CREATE TABLE IF NOT EXISTS b_crm_access_attr_lead
(
	ID BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_ID INT UNSIGNED NOT NULL,
	CATEGORY_ID INT UNSIGNED NOT NULL,
	USER_ID INT UNSIGNED NOT NULL,
	IS_OPENED CHAR(1) NOT NULL,
    IS_ALWAYS_READABLE CHAR(1) NOT NULL,
	PROGRESS_STEP VARCHAR(50) NOT NULL,
	PRIMARY KEY(ID),
	UNIQUE KEY IX_ACC_ATTR_LEAD_1(ENTITY_ID, USER_ID, IS_OPENED, IS_ALWAYS_READABLE, PROGRESS_STEP),
	KEY IX_ACC_ATTR_LEAD_2 (USER_ID, ENTITY_ID),
	KEY IX_ACC_ATTR_LEAD_3 (IS_OPENED, ENTITY_ID),
	KEY IX_ACC_ATTR_LEAD_4 (ENTITY_ID, IS_OPENED),
	KEY IX_ACC_ATTR_LEAD_5 (IS_ALWAYS_READABLE, ENTITY_ID),
	KEY IX_ACC_ATTR_LEAD_6 (ENTITY_ID, IS_ALWAYS_READABLE),
	KEY IX_ACC_ATTR_LEAD_7 (CATEGORY_ID, ENTITY_ID),
	KEY IX_ACC_ATTR_LEAD_8 (ENTITY_ID, CATEGORY_ID, USER_ID),
	KEY IX_ACC_ATTR_LEAD_9 (CATEGORY_ID, USER_ID, ENTITY_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_access_attr_deal
(
	ID BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_ID INT UNSIGNED NOT NULL,
	CATEGORY_ID INT UNSIGNED NOT NULL,
	USER_ID INT UNSIGNED NOT NULL,
	IS_OPENED CHAR(1) NOT NULL,
    IS_ALWAYS_READABLE CHAR(1) NOT NULL,
	PROGRESS_STEP VARCHAR(50) NOT NULL,
	PRIMARY KEY(ID),
	UNIQUE KEY IX_ACC_ATTR_DEAL_1 (ENTITY_ID, USER_ID, IS_OPENED, IS_ALWAYS_READABLE, PROGRESS_STEP),
	KEY IX_ACC_ATTR_DEAL_2 (USER_ID, ENTITY_ID),
	KEY IX_ACC_ATTR_DEAL_3 (IS_OPENED, ENTITY_ID),
	KEY IX_ACC_ATTR_DEAL_4 (ENTITY_ID, IS_OPENED),
	KEY IX_ACC_ATTR_DEAL_5 (IS_ALWAYS_READABLE, ENTITY_ID),
	KEY IX_ACC_ATTR_DEAL_6 (ENTITY_ID, IS_ALWAYS_READABLE),
	KEY IX_ACC_ATTR_DEAL_7 (CATEGORY_ID, ENTITY_ID),
	KEY IX_ACC_ATTR_DEAL_8 (ENTITY_ID, CATEGORY_ID, USER_ID),
	KEY IX_ACC_ATTR_DEAL_9 (CATEGORY_ID, USER_ID, ENTITY_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_access_attr_contact
(
	ID BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_ID INT UNSIGNED NOT NULL,
	CATEGORY_ID INT UNSIGNED NOT NULL,
	USER_ID INT UNSIGNED NOT NULL,
	IS_OPENED CHAR(1) NOT NULL,
    IS_ALWAYS_READABLE CHAR(1) NOT NULL,
	PROGRESS_STEP VARCHAR(50) NOT NULL,
	PRIMARY KEY(ID),
	UNIQUE KEY IX_ACC_ATTR_CONTACT_1 (ENTITY_ID, USER_ID, IS_OPENED, IS_ALWAYS_READABLE, PROGRESS_STEP),
	KEY IX_ACC_ATTR_CONTACT_2 (USER_ID, ENTITY_ID),
	KEY IX_ACC_ATTR_CONTACT_3 (IS_OPENED, ENTITY_ID),
	KEY IX_ACC_ATTR_CONTACT_4 (ENTITY_ID, IS_OPENED),
	KEY IX_ACC_ATTR_CONTACT_5 (IS_ALWAYS_READABLE, ENTITY_ID),
	KEY IX_ACC_ATTR_CONTACT_6 (ENTITY_ID, IS_ALWAYS_READABLE),
	KEY IX_ACC_ATTR_CONTACT_7 (CATEGORY_ID, ENTITY_ID),
	KEY IX_ACC_ATTR_CONTACT_8 (ENTITY_ID, CATEGORY_ID, USER_ID),
	KEY IX_ACC_ATTR_CONTACT_9 (CATEGORY_ID, USER_ID, ENTITY_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_access_attr_company
(
	ID BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_ID INT UNSIGNED NOT NULL,
	CATEGORY_ID INT UNSIGNED NOT NULL,
	USER_ID INT UNSIGNED NOT NULL,
	IS_OPENED CHAR(1) NOT NULL,
    IS_ALWAYS_READABLE CHAR(1) NOT NULL,
	PROGRESS_STEP VARCHAR(50) NOT NULL,
	PRIMARY KEY(ID),
	UNIQUE KEY IX_ACC_ATTR_COMPANY_1 (ENTITY_ID, USER_ID, IS_OPENED, IS_ALWAYS_READABLE, PROGRESS_STEP),
	KEY IX_ACC_ATTR_COMPANY_2 (USER_ID, ENTITY_ID),
	KEY IX_ACC_ATTR_COMPANY_3 (IS_OPENED, ENTITY_ID),
	KEY IX_ACC_ATTR_COMPANY_4 (ENTITY_ID, IS_OPENED),
	KEY IX_ACC_ATTR_COMPANY_5 (IS_ALWAYS_READABLE, ENTITY_ID),
	KEY IX_ACC_ATTR_COMPANY_6 (ENTITY_ID, IS_ALWAYS_READABLE),
	KEY IX_ACC_ATTR_COMPANY_7 (CATEGORY_ID, ENTITY_ID),
	KEY IX_ACC_ATTR_COMPANY_8 (ENTITY_ID, CATEGORY_ID, USER_ID),
	KEY IX_ACC_ATTR_COMPANY_9 (CATEGORY_ID, USER_ID, ENTITY_ID)
);

CREATE TABLE b_crm_webform_ads_field_mapping
(
	FORM_LINK_ID INT NOT NULL,
	CRM_FIELD_KEY VARCHAR(255) NOT NULL,
	ADS_FIELD_KEY VARCHAR(64) NOT NULL,
	ITEMS longtext NOT NULL,
	INDEX IX_B_CRM_WEBFORM_ADS_FIELD_MAPPING (FORM_LINK_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_shipment_realization
(
	ID BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
	SHIPMENT_ID INT UNSIGNED NOT NULL,
	IS_REALIZATION CHAR(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY(ID),
	UNIQUE IX_B_CRM_SHIPMENT_REALIZATION_SHIPMENT_ID (SHIPMENT_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_product_reservation_map
(
	ID BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
	PRODUCT_ROW_ID INT UNSIGNED NOT NULL,
	BASKET_RESERVATION_ID INT UNSIGNED NOT NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_PRODUCT_RESERVATION_MAP_PRODUCT_ROW_ID (PRODUCT_ROW_ID),
  	INDEX IX_B_CRM_PRODUCT_RESERVATION_MAP_BASKET_RESERVATION_ID (BASKET_RESERVATION_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_product_row_reservation
(
	ID BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
	ROW_ID INT UNSIGNED NOT NULL,
	RESERVE_QUANTITY DOUBLE NULL,
	DATE_RESERVE_END DATETIME NULL,
	STORE_ID INT UNSIGNED NULL,
	IS_AUTO CHAR(1) NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_PRODUCT_ROW_ID (ROW_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_act_incoming_channel
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	ACTIVITY_ID INT UNSIGNED NOT NULL,
	RESPONSIBLE_ID INT NOT NULL,
	COMPLETED CHAR(1) NOT NULL DEFAULT 'N',
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_ACT_INCOMING_1 (RESPONSIBLE_ID, COMPLETED),
	UNIQUE INDEX IX_B_CRM_ACT_INCOMING_2 (ACTIVITY_ID)
);

CREATE TABLE b_crm_entity_uncompleted_act (
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID INT NOT NULL,
	ENTITY_ID INT NOT NULL,
	ACTIVITY_ID INT UNSIGNED NOT NULL,
	RESPONSIBLE_ID INT NOT NULL,
	MIN_DEADLINE DATETIME NOT NULL,
	IS_INCOMING_CHANNEL CHAR(1) NOT NULL DEFAULT 'N',
	HAS_ANY_INCOMING_CHANEL CHAR(1) DEFAULT 'N' NOT NULL,
	MIN_LIGHT_COUNTER_AT DATETIME,
	PRIMARY KEY(ID),
	UNIQUE INDEX IX_B_CRM_UNCOMPLETED_ACT_1 (ENTITY_ID, ENTITY_TYPE_ID, RESPONSIBLE_ID, IS_INCOMING_CHANNEL, MIN_DEADLINE),
	INDEX IX_B_CRM_UNCOMPLETED_ACT_2 (RESPONSIBLE_ID, ENTITY_TYPE_ID, IS_INCOMING_CHANNEL, MIN_DEADLINE),
	INDEX IX_B_CRM_UNCOMPLETED_ACT_3 (RESPONSIBLE_ID, ENTITY_TYPE_ID, HAS_ANY_INCOMING_CHANEL, MIN_DEADLINE),
	INDEX IX_B_CRM_UNCOMPLETED_ACT_4 (ENTITY_TYPE_ID, HAS_ANY_INCOMING_CHANEL, MIN_DEADLINE)
);
CREATE TABLE IF NOT EXISTS b_crm_automation_qr (
	ID varchar(32) NOT NULL,
	OWNER_ID varchar(128) NOT NULL,
	ENTITY_TYPE_ID int UNSIGNED NOT NULL,
	ENTITY_ID int UNSIGNED NOT NULL,
	DESCRIPTION text,
	COMPLETE_ACTION_LABEL text,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_ATM_QR_1 (ENTITY_TYPE_ID, ENTITY_ID),
	INDEX IX_B_CRM_ATM_QR_2 (OWNER_ID)
);

CREATE TABLE IF NOT EXISTS `b_crm_field_set` (
	`ID` INT UNSIGNED NOT NULL AUTO_INCREMENT,
	`ENTITY_TYPE_ID` SMALLINT UNSIGNED NOT NULL,
	`CLIENT_ENTITY_TYPE_ID` SMALLINT UNSIGNED NOT NULL,
	`RQ_PRESET_ID` INT UNSIGNED NOT NULL,
	`FIELDS` TEXT NULL,
	`CODE` VARCHAR(25) NOT NULL DEFAULT '',
	`TITLE` VARCHAR(25) NOT NULL DEFAULT '',
	`IS_SYSTEM` TINYINT(3) UNSIGNED NOT NULL DEFAULT '0',
	PRIMARY KEY (`ID`)
);

CREATE TABLE IF NOT EXISTS b_crm_item_badge(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	CREATED_DATE DATETIME NOT NULL,
	TYPE VARCHAR(30) NOT NULL,
	VALUE VARCHAR(30) NOT NULL,
	ENTITY_TYPE_ID INT UNSIGNED NOT NULL,
	ENTITY_ID INT UNSIGNED NOT NULL,
	SOURCE_PROVIDER_ID VARCHAR(30) NOT NULL,
	SOURCE_ENTITY_TYPE_ID INT UNSIGNED NOT NULL,
	SOURCE_ENTITY_ID INT UNSIGNED NOT NULL,
	PRIMARY KEY(ID),
	INDEX IX_B_CRM_ITEM_BADGE_ETID_EID (ENTITY_TYPE_ID, ENTITY_ID),
	INDEX IX_B_CRM_ITEM_BADGE_SPID_SETID_SEID (SOURCE_PROVIDER_ID, SOURCE_ENTITY_TYPE_ID, SOURCE_ENTITY_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_counter_calculated_time  (
	USER_ID INT NOT NULL,
	CODE VARCHAR(255) NOT NULL,
	CALCULATED_AT DATETIME NOT NULL,
	IS_CALCULATING CHAR(1) DEFAULT 'N' NOT NULL,
	CALCULATION_STARTED_AT DATETIME NULL,
	PRIMARY KEY(USER_ID, CODE)
);

CREATE TABLE IF NOT EXISTS `b_crm_store_document_contractor` (
	`ID` int NOT NULL AUTO_INCREMENT,
	`DOCUMENT_ID` int unsigned NOT NULL,
	`ENTITY_ID` int unsigned NOT NULL,
	`ENTITY_TYPE_ID` int unsigned NOT NULL,
	PRIMARY KEY (`ID`),
	UNIQUE `IX_DOCUMENT_ENTITY`(`DOCUMENT_ID`, `ENTITY_ID`, `ENTITY_TYPE_ID`),
	KEY `IX_DOCUMENT_ID` (`DOCUMENT_ID`),
	KEY `IX_ENTITY` (`ENTITY_ID`, `ENTITY_TYPE_ID`)
);

CREATE TABLE IF NOT EXISTS `b_crm_contractor_conversion` (
	`CONTRACTOR_ID` int NOT NULL,
	`ENTITY_ID` int unsigned DEFAULT NULL,
	`ENTITY_TYPE_ID` int unsigned DEFAULT NULL,
	`SUCCESS` char(1) DEFAULT NULL,
	`ERRORS` text,
	PRIMARY KEY (`CONTRACTOR_ID`)
);

CREATE TABLE IF NOT EXISTS `b_crm_act_ping_offsets` (
	`ID` INT UNSIGNED NOT NULL AUTO_INCREMENT,
	`ACTIVITY_ID` INT UNSIGNED NOT NULL,
	`OFFSET` INT NOT NULL,
	PRIMARY KEY(`ID`),
	INDEX `IX_B_CRM_ACT_PO_1` (`ACTIVITY_ID`)
);

CREATE TABLE IF NOT EXISTS `b_crm_act_ping_queue` (
	`ID` INT UNSIGNED NOT NULL AUTO_INCREMENT,
	`ACTIVITY_ID` INT UNSIGNED NOT NULL,
	`PING_DATETIME` DATETIME NOT NULL,
	PRIMARY KEY(`ID`),
	INDEX `IX_B_CRM_ACT_PQ_1` (`ACTIVITY_ID`)
);

CREATE TABLE IF NOT EXISTS `b_crm_timeline_note` (
	`ID` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
	`ITEM_ID` BIGINT UNSIGNED NOT NULL,
	`ITEM_TYPE` TINYINT UNSIGNED NOT NULL,
	`TEXT` TEXT NOT NULL,
	`CREATED_BY_ID` INT UNSIGNED NOT NULL,
	`CREATED_TIME` DATETIME NOT NULL,
	`UPDATED_BY_ID` INT UNSIGNED NOT NULL,
	`UPDATED_TIME` DATETIME NOT NULL,
	UNIQUE(`ITEM_ID`, `ITEM_TYPE`)
);
CREATE TABLE b_crm_entity_countable_act
(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID INT NOT NULL,
	ENTITY_ID INT NOT NULL,
	ENTITY_ASSIGNED_BY_ID INT NOT NULL,
	ACTIVITY_ID INT UNSIGNED NOT NULL,
	ACTIVITY_RESPONSIBLE_ID INT NOT NULL,
	ACTIVITY_DEADLINE DATETIME NOT NULL,
	ACTIVITY_IS_INCOMING_CHANNEL CHAR(1) NOT NULL DEFAULT 'N',
	LIGHT_COUNTER_AT DATETIME,
	DEADLINE_EXPIRED_AT DATETIME,
	PRIMARY KEY(ID),
	UNIQUE IX_B_CRM_COUNTABLE_ACT_ID (ENTITY_ID, ENTITY_TYPE_ID, ACTIVITY_ID),
	INDEX IX_B_CRM_COUNTABLE_ACT_1 (ACTIVITY_RESPONSIBLE_ID, ENTITY_TYPE_ID, ACTIVITY_IS_INCOMING_CHANNEL, ACTIVITY_DEADLINE, ENTITY_ID),
	INDEX IX_B_CRM_COUNTABLE_ACT_2 (ENTITY_ASSIGNED_BY_ID, ENTITY_TYPE_ID, ACTIVITY_IS_INCOMING_CHANNEL, ACTIVITY_DEADLINE, ENTITY_ID),
	INDEX IX_B_CRM_COUNTABLE_ACT_3 (ENTITY_TYPE_ID, ACTIVITY_IS_INCOMING_CHANNEL, ACTIVITY_DEADLINE, ENTITY_ID),
	INDEX IX_B_CRM_COUNTABLE_ACT_4 (ACTIVITY_ID),
	INDEX IX_B_CRM_COUNTABLE_ACT_5 (LIGHT_COUNTER_AT)
);
CREATE TABLE IF NOT EXISTS b_crm_custom_badge (
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	CODE VARCHAR(255) NOT NULL,
	TITLE VARCHAR(4000) NOT NULL,
	VALUE VARCHAR(4000) NOT NULL,
	TYPE VARCHAR(20) NOT NULL,
	PRIMARY KEY (ID),
	UNIQUE IX_B_CRM_CUSTOM_BADGE_CODE(CODE),
	KEY IX_B_CRM_CUSTOM_BADGE_TYPE(TYPE)
);
CREATE TABLE IF NOT EXISTS b_crm_timeline_custom_icon (
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	CODE VARCHAR(255) NOT NULL,
	FILE_ID INT UNSIGNED NOT NULL,
	PRIMARY KEY (ID),
	UNIQUE IX_B_CRM_TIMELINE_CUSTOM_ICON_CODE(CODE)
);
CREATE TABLE IF NOT EXISTS b_crm_timeline_custom_logo (
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	CODE VARCHAR(255) NOT NULL,
	FILE_ID INT UNSIGNED NOT NULL,
	PRIMARY KEY (ID),
	UNIQUE IX_B_CRM_TIMELINE_CUSTOM_LOGO_CODE(CODE)
);
CREATE TABLE IF NOT EXISTS b_crm_field_content_type (
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID INT UNSIGNED NOT NULL,
	ENTITY_ID INT UNSIGNED NOT NULL,
	FIELD_NAME VARCHAR(255) NOT NULL,
	CONTENT_TYPE_ID INT UNSIGNED NOT NULL,
	PRIMARY KEY (ID),
	UNIQUE IX_B_CRM_FIELD_CONTENT_TYPE_ENTITY(ENTITY_TYPE_ID, ENTITY_ID, FIELD_NAME)
);
CREATE TABLE IF NOT EXISTS b_crm_act_counter_light
(
	ACTIVITY_ID int unsigned not null,
	LIGHT_COUNTER_AT datetime not null,
	IS_LIGHT_COUNTER_NOTIFIED char(1) default 'N' null,
	PRIMARY KEY(ACTIVITY_ID),
	INDEX IX_B_CRM_ACT_COUNTER_LIGHT_2 (IS_LIGHT_COUNTER_NOTIFIED, LIGHT_COUNTER_AT),
	INDEX IX_B_CRM_ACT_COUNTER_LIGHT_3 (LIGHT_COUNTER_AT)
);

CREATE TABLE IF NOT EXISTS b_crm_webform_limit
(
	ID bigint unsigned not null auto_increment,
	DATE_STAT timestamp not null,
	TYPE varchar(25) not null,
	CODE varchar(25) not null,
	VALUE int(31) not null default 0,
	NOTIFIED tinyint(1) not null default 0,
	PRIMARY KEY (ID),
	UNIQUE INDEX (DATE_STAT, TYPE, CODE)
);

CREATE TABLE IF NOT EXISTS b_crm_agent_contract_contractor (
	ID int NOT NULL AUTO_INCREMENT,
	CONTRACT_ID int unsigned NOT NULL,
	ENTITY_ID int unsigned NOT NULL,
	ENTITY_TYPE_ID int unsigned NOT NULL,
	PRIMARY KEY (ID),
	UNIQUE IX_DOCUMENT_ENTITY(CONTRACT_ID, ENTITY_ID, ENTITY_TYPE_ID),
	KEY IX_CONTRACT_ID (CONTRACT_ID),
	KEY IX_ENTITY (ENTITY_ID, ENTITY_TYPE_ID)
);

CREATE TABLE b_crm_act_fastsearch
(
	ACTIVITY_ID INT UNSIGNED NOT NULL,
	CREATED DATETIME NOT NULL,
	DEADLINE DATETIME,
	RESPONSIBLE_ID INT NOT NULL,
	COMPLETED CHAR(1) NOT NULL,
	ACTIVITY_TYPE VARCHAR(210) NOT NULL,
	ACTIVITY_KIND TINYINT NOT NULL,
	AUTHOR_ID INT UNSIGNED NOT NULL DEFAULT 0,
	PRIMARY KEY (ACTIVITY_ID),
	INDEX IX_B_CRM_ACT_FASTSEARCH_1 (CREATED)
);

CREATE TABLE b_crm_lead_fields_context
(
	LEAD_ID INT(10) UNSIGNED NOT NULL,
	FIELD_NAME VARCHAR(50) NOT NULL,
	VALUE_ID VARCHAR(20) NOT NULL,
	CONTEXT TINYINT(1) UNSIGNED NOT NULL,
	PRIMARY KEY (LEAD_ID, FIELD_NAME, VALUE_ID),
	INDEX IX_B_CRM_LEAD_FIELDS_CONTEXT_FIELD_NAME (FIELD_NAME)
);

CREATE TABLE IF NOT EXISTS b_crm_deal_fields_context(
	DEAL_ID INT(10) UNSIGNED NOT NULL,
	FIELD_NAME VARCHAR(50) NOT NULL,
	VALUE_ID VARCHAR(20) NOT NULL,
	CONTEXT TINYINT(1) UNSIGNED NOT NULL,
	PRIMARY KEY( DEAL_ID, FIELD_NAME, VALUE_ID),
	INDEX IX_B_CRM_DEAL_FIELDS_CONTEXT_FIELD_NAME (FIELD_NAME)
);

CREATE TABLE IF NOT EXISTS b_crm_contact_fields_context(
	CONTACT_ID INT(10) UNSIGNED NOT NULL,
	FIELD_NAME VARCHAR(50) NOT NULL,
	VALUE_ID VARCHAR(20) NOT NULL,
	CONTEXT TINYINT(1) UNSIGNED NOT NULL,
	PRIMARY KEY (CONTACT_ID, FIELD_NAME, VALUE_ID),
	INDEX IX_B_CRM_CONTACT_FIELDS_CONTEXT_FIELD_NAME (FIELD_NAME)
);

CREATE TABLE IF NOT EXISTS b_crm_company_fields_context(
	COMPANY_ID INT(10) UNSIGNED NOT NULL,
	FIELD_NAME VARCHAR(50) NOT NULL,
	VALUE_ID VARCHAR(20) NOT NULL,
	CONTEXT TINYINT(1) UNSIGNED NOT NULL,
	PRIMARY KEY (COMPANY_ID, FIELD_NAME, VALUE_ID),
	INDEX IX_B_CRM_COMPANY_FIELDS_CONTEXT_FIELD_NAME (FIELD_NAME)
);

CREATE TABLE IF NOT EXISTS b_crm_quote_fields_context(
	QUOTE_ID INT(10) UNSIGNED NOT NULL,
	FIELD_NAME VARCHAR(50) NOT NULL,
	VALUE_ID VARCHAR(20) NOT NULL,
	CONTEXT TINYINT(1) UNSIGNED NOT NULL,
	PRIMARY KEY (QUOTE_ID, FIELD_NAME, VALUE_ID),
	INDEX IX_B_CRM_QUOTE_FIELDS_CONTEXT_FIELD_NAME (FIELD_NAME)
);

CREATE TABLE IF NOT EXISTS b_crm_ai_queue
(
	ID bigint NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID int NOT NULL,
	ENTITY_ID bigint NOT NULL,
	HASH varchar(32) NOT NULL,
	TYPE_ID int NOT NULL,
	PARENT_ID bigint NOT NULL DEFAULT 0,
	STORAGE_TYPE_ID int NOT NULL DEFAULT 0,
	STORAGE_ELEMENT_ID bigint NOT NULL DEFAULT 0,
	USER_ID bigint NOT NULL DEFAULT 0,
	EXECUTION_STATUS varchar(255) NOT NULL,
	ERROR_CODE varchar(255),
	ERROR_MESSAGE text,
	RETRY_COUNT int NOT NULL DEFAULT 0,
	OPERATION_STATUS varchar(255),
	RESULT longtext,
	IS_FEEDBACK_CONSENT_GRANTED char(1) NOT NULL DEFAULT 'N',
	IS_FEEDBACK_SENT char(1) NOT NULL DEFAULT 'N',
	IS_MANUAL_LAUNCH char(1) NOT NULL DEFAULT 'Y',
	CREATED_TIME DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	FINISHED_TIME DATETIME,
	LANGUAGE_ID char(2),
	ENGINE_ID bigint NOT NULL DEFAULT 0,
	NEXT_TYPE_ID int NULL,
	PRIMARY KEY (ID),
	UNIQUE IX_CRM_AI_QUEUE_HASH(HASH),
	INDEX IX_CRM_AI_QUEUE_ENTITY_AND_TYPE(ENTITY_TYPE_ID, ENTITY_ID, TYPE_ID),
	INDEX IX_CRM_AI_QUEUE_PARENT(PARENT_ID),
	INDEX IX_CRM_AI_QUEUE_USER(USER_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_ai_quality_assessment
(
	ID bigint NOT NULL AUTO_INCREMENT,
	CREATED_AT datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
	UPDATED_AT datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
	ACTIVITY_TYPE tinyint(1) NOT NULL,
	ACTIVITY_ID bigint NOT NULL,
	ASSESSMENT_SETTING_ID bigint NOT NULL,
	JOB_ID bigint NOT NULL,
	PROMPT text NOT NULL,
	ASSESSMENT int(3) NOT NULL DEFAULT 0,
	ASSESSMENT_AVG int(3) NOT NULL DEFAULT 0,
	USE_IN_RATING char(1) NOT NULL DEFAULT 'Y',
	RATED_USER_ID bigint NOT NULL DEFAULT 0,
	MANAGER_USER_ID bigint NOT NULL DEFAULT 0,
	RATED_USER_CHAT_ID bigint NOT NULL DEFAULT 0,
	MANAGER_USER_CHAT_ID bigint NOT NULL DEFAULT 0,
	PRIMARY KEY (ID),
	INDEX IX_CRM_AI_QA_RATED_USER(RATED_USER_ID),
	INDEX IX_CRM_AI_QA_MANAGER_USER(MANAGER_USER_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_terminal_payment (
	PAYMENT_ID INT NOT NULL,
	PRIMARY KEY (PAYMENT_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_act_sms_placeholder (
	ID bigint NOT NULL AUTO_INCREMENT,
	ENTITY_TYPE_ID int unsigned NOT NULL,
	ENTITY_CATEGORY_ID smallint,
	TEMPLATE_ID int unsigned NOT NULL,
	PLACEHOLDER_ID varchar(255) NOT NULL,
	FIELD_NAME varchar(255),
	FIELD_ENTITY_TYPE varchar(255),
	FIELD_VALUE varchar(255),
	PRIMARY KEY (ID),
	INDEX IX_CRM_ACT_SMS_PLACEHOLDER_ETI_ECI_TI(ENTITY_TYPE_ID, ENTITY_CATEGORY_ID, TEMPLATE_ID),
	INDEX IX_CRM_ACT_SMS_PLACEHOLDER_ETI_ECI_TI_PI(ENTITY_TYPE_ID, ENTITY_CATEGORY_ID, TEMPLATE_ID, PLACEHOLDER_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_automated_solution (
	ID int UNSIGNED NOT NULL AUTO_INCREMENT,
	INTRANET_CUSTOM_SECTION_ID int UNSIGNED,
	TITLE VARCHAR(255) NOT NULL,
	CODE VARCHAR(255) NOT NULL,
	SORT INT NOT NULL,
	CREATED_TIME DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	UPDATED_TIME  DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	CREATED_BY INT UNSIGNED NOT NULL,
	UPDATED_BY INT UNSIGNED NOT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_AUTOMATED_SOLUTION_CODE(CODE),
	INDEX IX_B_CRM_AUTOMATED_SOLUTION_ICSI(INTRANET_CUSTOM_SECTION_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_multi_value_store (
	TYPE_KEY varchar(255) NOT NULL,
	VALUE varchar(255) NOT NULL,
	CREATED_AT DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (TYPE_KEY, VALUE),
	INDEX IX_CRM_MULTI_VALUE_STORE_TK_CA(TYPE_KEY, CREATED_AT)
);

CREATE TABLE b_crm_timeline_rest_app_layout_blocks(
	ID INT UNSIGNED NOT NULL AUTO_INCREMENT,
	ITEM_TYPE SMALLINT UNSIGNED NOT NULL,
	ITEM_ID INT UNSIGNED NOT NULL,
	CLIENT_ID VARCHAR(128) NOT NULL,
	LAYOUT TEXT NOT NULL,
	PRIMARY KEY (ID),
	INDEX IX_B_CRM_TIMELINE_REST_APP_LAYOUT_BLOCKS_CLIENT_ID(CLIENT_ID),
	INDEX IX_B_CRM_TIMELINE_REST_APP_LAYOUT_BLOCKS_BINDINGS(ITEM_TYPE, ITEM_ID),
	INDEX IX_B_CRM_TIMELINE_REST_APP_LAYOUT_BLOCKS_BINDINGS_WITH_CLIENT_ID(ITEM_TYPE, ITEM_ID, CLIENT_ID)
);

CREATE TABLE b_crm_sequences(
	`SEQUENCE_NAME` VARCHAR(50) NOT NULL,
	`SEQUENCE_VALUE` INT NOT NULL DEFAULT 0,
	PRIMARY KEY(`SEQUENCE_NAME`)
);

CREATE TABLE IF NOT EXISTS b_crm_webpack_file_log
(
	`FILE_ID` INT NOT NULL,
	`ENTITY_TYPE` VARCHAR(15) NOT NULL,
	`ENTITY_ID` INT NOT NULL,
	PRIMARY KEY (`FILE_ID`),
	INDEX IX_B_CRM_WEBPACK_FILE_LOG_ENTITY_ID_ENTITY_TYPE (ENTITY_TYPE, ENTITY_ID)
);

CREATE TABLE IF NOT EXISTS b_crm_copilot_call_assessment (
	ID INT NOT NULL AUTO_INCREMENT,
	TITLE VARCHAR(255) NOT NULL,
	PROMPT TEXT NOT NULL,
	GIST TEXT,
	CALL_TYPE TINYINT(1) NOT NULL,
	AUTO_CHECK_TYPE TINYINT(1) NOT NULL,
	IS_ENABLED CHAR(1) NOT NULL DEFAULT 'Y',
	IS_DEFAULT CHAR(1) NOT NULL DEFAULT 'Y',
	JOB_ID bigint NOT NULL DEFAULT 0,
	STATUS VARCHAR(100) NOT NULL DEFAULT '',
	CODE VARCHAR(30),
	LOW_BORDER TINYINT NOT NULL DEFAULT 30,
	HIGH_BORDER TINYINT NOT NULL DEFAULT 70,
	CREATED_AT DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	UPDATED_AT DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	CREATED_BY_ID INT NOT NULL DEFAULT 0,
	UPDATED_BY_ID INT NOT NULL DEFAULT 0,
	PRIMARY KEY (ID),
	INDEX IX_CRM_COPILOT_CALL_ASSESSMENT_IS_DEFAULT(IS_DEFAULT),
	INDEX IX_B_CRM_COPILOT_CALL_ASSESSMENT_IS_ENABLED_UPDATED_AT(IS_ENABLED, UPDATED_AT)
);

CREATE TABLE IF NOT EXISTS b_crm_copilot_call_assessment_client_type (
	ID INT NOT NULL AUTO_INCREMENT,
	ASSESSMENT_ID INT NOT NULL,
	CLIENT_TYPE_ID INT NOT NULL,
	PRIMARY KEY (ID),
	INDEX IX_CRM_COPILOT_CALL_ASSESSMENT_CLIENT_TYPE_AI(ASSESSMENT_ID),
	INDEX IX_CRM_COPILOT_CALL_ASSESSMENT_CLIENT_TYPE_CTI(CLIENT_TYPE_ID)
);

CREATE TABLE b_crm_communication_category(
	ID INT NOT NULL AUTO_INCREMENT,
	MODULE_ID varchar(64) NOT NULL,
	CODE VARCHAR(50) NOT NULL,
	SORT INT DEFAULT 100,
	HANDLER_CLASS VARCHAR(255) NOT NULL,
	PRIMARY KEY (ID),
	UNIQUE IX_B_CRM_COMM_CATEGORY_MI_C(MODULE_ID, CODE)
);

CREATE TABLE IF NOT EXISTS b_crm_communication_channel(
	`ID` INT NOT NULL AUTO_INCREMENT,
	`CATEGORY_ID` INT NOT NULL,
	`MODULE_ID` VARCHAR(64) NOT NULL,
	`CODE` VARCHAR(128) NOT NULL,
	`HANDLER_CLASS` VARCHAR(256) NOT NULL,
	`CREATED_AT` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`UPDATED_AT` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`CREATED_BY_ID` INT NOT NULL DEFAULT 0,
	`UPDATED_BY_ID` INT NOT NULL DEFAULT 0,
	`SORT` INT NOT NULL DEFAULT 0,
	`IS_ENABLED` CHAR(1) DEFAULT 'Y',
	PRIMARY KEY (`ID`),
	UNIQUE KEY IX_B_CRM_COMMUNICATION_CHANNEL_MI_C(`MODULE_ID`, `CODE`)
);

CREATE TABLE b_crm_communication_channel_rule(
	`ID` INT NOT NULL AUTO_INCREMENT,
	`TITLE` VARCHAR(255) NOT NULL,
	`CHANNEL_ID` INT NOT NULL,
	`QUEUE_CONFIG_ID` INT NOT NULL DEFAULT 0,
	`SORT` INT NOT NULL DEFAULT 0,
	`SEARCH_TARGETS` TEXT NULL,
	`RULES` MEDIUMTEXT NOT NULL,
	`ENTITIES` TEXT NOT NULL,
	`SETTINGS` TEXT,
	PRIMARY KEY (`ID`),
	INDEX IX_B_CRM_COMM_CHANNEL_RULE_1(`CHANNEL_ID`),
	INDEX IX_B_CRM_COMM_CHANNEL_RULE_2(`QUEUE_CONFIG_ID`)
);

CREATE TABLE b_crm_communication_channel_event(
	`ID` INT NOT NULL AUTO_INCREMENT,
	`EVENT_ID` VARCHAR(255) NOT NULL,
	`USER_ID` INT,
	`MODULE_ID` VARCHAR(64) NOT NULL,
	`DATA` MEDIUMTEXT NOT NULL,
	`CREATED_AT` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`UPDATED_AT` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`ID`),
	INDEX IX_B_CRM_COMM_CHANNEL_EVENT(`MODULE_ID`, `EVENT_ID`)
);

CREATE TABLE b_crm_responsible_queue_config(
	`ID` INT NOT NULL AUTO_INCREMENT,
	`TITLE` VARCHAR(255) NOT NULL,
	`TYPE` VARCHAR(64) NOT NULL,
	`CREATED_AT` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`UPDATED_AT` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`SETTINGS` TEXT,
	PRIMARY KEY (`ID`)
);

CREATE TABLE b_crm_responsible_queue_config_members(
	`ID` INT NOT NULL AUTO_INCREMENT,
	`SORT` INT NOT NULL DEFAULT 0,
	`QUEUE_CONFIG_ID` INT NOT NULL,
	`ENTITY_ID` INT NOT NULL,
	`ENTITY_TYPE` VARCHAR(255) NOT NULL,
	PRIMARY KEY (`ID`),
	INDEX IX_B_CRM_QUEUE_CONFIG_MEMBERS_1(`QUEUE_CONFIG_ID`)
);

CREATE TABLE b_crm_responsible_queue(
	`ID` INT NOT NULL AUTO_INCREMENT,
	`SORT` INT NOT NULL DEFAULT 0,
	`CONFIG_ID` INT NOT NULL,
	`USER_ID` INT NOT NULL,
	`DEPARTMENT_ID` INT NOT NULL DEFAULT 0,
	`LAST_ACTIVITY_DATE` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`LAST_ACTIVITY_DATE_EXACT` BIGINT NULL,
	`CREATED_AT` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`UPDATED_AT` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`SETTINGS` TEXT,
	PRIMARY KEY (`ID`),
	KEY IX_B_CRM_QUEUE_1 (CONFIG_ID, LAST_ACTIVITY_DATE),
	KEY IX_B_CRM_QUEUE_2 (USER_ID)
);

CREATE TABLE b_crm_log
(
	ID INT NOT NULL AUTO_INCREMENT,
	LOGGER_ID VARCHAR(100) NOT NULL,
	CREATED_TIME DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL,
	VALID_TO DATETIME NOT NULL,
	LOG_LEVEL VARCHAR(32) NOT NULL,
	`MESSAGE` TEXT NOT NULL,
	CONTEXT TEXT NOT NULL,
	URL varchar(2048) NOT NULL,
	PRIMARY KEY (ID),
	KEY IX_B_CRM_LOG_1 (VALID_TO)
);
