(function(){"use strict";var t=BX.namespace("BX.Crm.Tracking");if(t.Site){return}function i(){BX.bind(window,"message",this.onMessage.bind(this));BX.bind(window,"beforeunload",this.onWindowClose.bind(this));BX.bind(window,"blur",this.onWindowBlur.bind(this));if(BX.SidePanel&&BX.SidePanel.Instance){BX.addCustomEvent("SidePanel.Slider:onClose",this.onWindowClose.bind(this))}this.timeout=20;this.debug=false}i.prototype.parameterName="b24_tracker_checking_origin";i.prototype.editParameterName="b24_tracker_edit_enabled";i.prototype.running=false;i.prototype.setDebug=function(t,i){this.debug=!!t;if(this.debug){this.timeout=i||1e3}};i.prototype.log=function(t){if(this.debug&&window.console&&"log"in console){console.log("BX.Crm.Tracking.Site[checking]:",t)}};i.prototype.edit=function(i){if(this.editingWindow){this.editingWindow.close()}var e=document.createElement("a");e.href=i;var s=e.hostname;var n=e.protocol+"//"+e.hostname+(e.port?":"+e.port:"");this.editingWindow=window.open(i+"?utm_source=&"+this.editParameterName+"="+"y","editingWindow");this.connector=new window.b24Tracker.Connector({addressee:n,responders:{"tracking.editor.getData":function(){return t.Site.getData(s)}.bind(this)}})};i.prototype.isRunning=function(){return this.running};i.prototype.start=function(t){if(this.running){this.end()}var i=document.createElement("a");i.href=t.url;this.domain=i.href;this.bar=t.bar;var e=t.url+"?utm_source=&"+this.parameterName+"="+encodeURIComponent(window.location.origin);if(this.debug){e+="&bx_debug=y"}this.checkingWindow=window.open(e,"checkingWindow","height=300,width=450");this.log("Open window "+e);this.promise=new BX.Promise;this.timer=setTimeout(this.onError.bind(this),this.timeout*1e3);if(!this.debug){this.updateBar()}this.running=true;return this.promise};i.prototype.updateBar=function(t){if(!this.timer){return}t=t||0;this.bar.update(t*10/this.timeout);setTimeout(this.updateBar.bind(this,t+1),100)};i.prototype.onError=function(){if(this.promise){this.promise.cancelAutoResolve();this.promise.reject()}this.end()};i.prototype.end=function(){if(this.timer){clearTimeout(this.timer)}this.log("End. Close window");if(this.checkingWindow&&!this.debug){this.checkingWindow.close()}this.checkingWindow=null;this.timer=null;this.domain=null;this.promise=null;this.running=false};i.prototype.onWindowClose=function(){this.end();if(this.editingWindow){this.editingWindow.close()}this.editingWindow=null};i.prototype.onWindowBlur=function(){if(!this.editingWindow){return}this.connector.request(this.editingWindow,"b24.portal.refresh")};i.prototype.onMessage=function(t){if(!this.promise){return}if(!this.domain||this.domain.indexOf(t.origin)!==0){this.log("Domains not equal `"+this.domain+"` & `"+t.origin+"`");return}if(!this.checkingWindow||this.checkingWindow!==t.source){this.log("Checking window not equals for event.source");return}this.log("Data received "+t.data);var i;try{i=JSON.parse(t.data||"");this.log(i)}catch(t){this.log("Data parse error "+t.message);return}if(i.source!=="b24Tracker"){this.log("Wrong data source "+i.source);return}this.promise.fulfill(i);this.end()};function e(){this.context=null;this.editor=null}e.prototype.init=function(t){};function s(){this.context=null;this.editor=null;this.checkTimeout=5}s.prototype.init=function(t){this.context=BX(t.containerId);this.isInstalled=t.isInstalled||false;this.isSaved=t.isSaved||false;this.sources=t.sources||[];this.mess=t.mess||{};this.resultContainer=BX("result-container");this.siteDomain=BX("ADDRESS");this.btnCheck=BX("site-btn-check");BX.bind(this.btnCheck,"click",this.checkSite.bind(this));this.btnConnect=BX("site-btn-connect");BX.bind(this.btnConnect,"click",this.checkSite.bind(this));this.btnDisconnect=BX("site-btn-disconnect");BX.bind(this.btnDisconnect,"click",this.disconnect.bind(this));this.btnEdit=BX("site-btn-edit");BX.bind(this.btnEdit,"click",this.editSite.bind(this));this.scriptBlockBtn=BX("crm-tracking-site-code-header-title");this.scriptBlock=BX("crm-tracking-site-hidden");BX.bind(this.scriptBlockBtn,"click",this.showScriptText.bind(this));BX.clipboard.bindCopyClick(BX("script-copy-btn"),{text:BX("script-text")});this.status=BX("site-status");this.statusBar=BX("site-status-bar");this.statusBarController=new BX.UI.ProgressBar({maxValue:100,value:0,statusType:BX.UI.ProgressBar.Status.PERCENT});this.statusBar.appendChild(this.statusBarController.getContainer());this.checking=new i;this.selectorPhone=BX.UI.TileSelector.getById("available-phone-list");this.selectorEmail=BX.UI.TileSelector.getById("available-email-list");this.additionalBlock=BX("crm-analytics-channel-addition-options");BX.bind(BX("crm-analytics-channel-addition-btn"),"click",BX.proxy(function(){BX.toggleClass(this.additionalBlock,"crm-analytics-channel-addition-options-open")},this));if(this.isInstalled){this.connect()}var e=BX("crm-tracking-phone-add");var s=BX("crm-tracking-email-add");BX.bind(e,"click",this.showAddItemDialog.bind(this,true,e));BX.bind(s,"click",this.showAddItemDialog.bind(this,false,s));var n=BX("crm-tracking-site-remove");if(n){BX.bind(n,"click",function(){BX.addClass(n,"ui-btn-wait");BX("crm-tracking-site-remove-input").value="Y";BX.submit(BX("crm-tracking-site-form"))})}};s.prototype.checkBrowser=function(){if(!BX.browser.IsIE11()&&!BX.browser.IsIE10()){return true}alert(this.mess.oldBrowser);return false};s.prototype.editSite=function(){if(!this.checkBrowser()){return}var t=this.siteDomain.value;if(!t){return}this.checking.edit(t)};s.prototype.connect=function(){BX("DISCONNECTED").style.display="none";BX("CONNECTED").style.display="";BX("IS_INSTALLED").value="Y";var t=document.createElement("a");t.href=this.siteDomain.value;var i=t.protocol+"//"+t.hostname;var e=BX("SITE_NAME");e.textContent=i;e.href=i;e.target="_blank";this.showStatus(true)};s.prototype.disconnect=function(){BX("CONNECTED").style.display="none";BX("DISCONNECTED").style.display="";BX("IS_INSTALLED").value="N";this.showStatus();this.selectorPhone.removeTiles();this.selectorEmail.removeTiles()};s.prototype.checkSite=function(){if(!this.checkBrowser()){return}var t=this.siteDomain.value;if(!t||this.checking.isRunning()){return}this.showStatus(null);this.checking.start({url:t,bar:this.statusBarController}).then(this.onFound.bind(this),this.showStatus.bind(this,false))};s.prototype.getData=function(t){return{enabled:true,sources:this.sources,sites:[{host:t,replaceText:BX("REPLACE_TEXT").checked,enrichText:BX("ENRICH_TEXT").checked,resolveDup:BX("RESOLVE_DUPLICATES").checked,replacement:[].concat(this.selectorPhone.getTiles().map(function(t){return{type:"phone",value:t.id}}),this.selectorEmail.getTiles().map(function(t){return{type:"email",value:t.id}}))}]}};s.prototype.onFound=function(t){var i=this.selectorPhone.getTiles().length>0;var e=this.selectorEmail.getTiles().length>0;if(!i){this.selectorPhone.removeTiles()}if(!e){this.selectorEmail.removeTiles()}t.items.forEach(function(t){switch(t.type){case"phone":if(!i){this.selectorPhone.addTile(t.value,{},t.value)}break;case"email":if(!e){this.selectorEmail.addTile(t.value,{},t.value)}break}},this);this.connect()};s.prototype.showScriptText=function(t){var i="crm-tracking-site-hidden-closed";if(t===true){this.scriptBlock.classList.remove(i)}else if(t===false){this.scriptBlock.classList.add(i)}else{this.scriptBlock.classList.toggle(i)}};s.prototype.showResult=function(t){this.resultContainer.style.display=t?"":"none"};s.prototype.showStatus=function(t){this.status.classList.remove("crm-tracking-site-code-status-value-wait");this.status.classList.remove("crm-tracking-site-code-status-value-error");this.status.classList.remove("crm-tracking-site-code-status-value-success");this.statusBar.style.display="none";if(t===null){BX.addClass(this.btnConnect,"ui-btn-wait");BX.addClass(this.btnCheck,"ui-btn-wait");this.status.textContent=this.mess.statusProcess;this.status.classList.add("crm-tracking-site-code-status-value-wait");this.statusBar.style.display="";this.showScriptText(false);return}this.btnConnect.classList.remove("ui-btn-wait");this.btnCheck.classList.remove("ui-btn-wait");if(t){BX.addClass(this.status,"crm-tracking-site-code-status-value-success");this.showScriptText(false);this.showResult(true);this.status.textContent=this.mess.statusSuccess}else if(t===false){BX.addClass(this.status,"crm-tracking-site-code-status-value-error");this.showScriptText(true);this.showResult(false);this.status.textContent=this.mess.statusError}else{this.showScriptText(false);this.showResult(false);this.status.textContent=this.mess.statusNone}};s.prototype.showAddItemDialog=function(t,i){if(!this.itemDialog){this.itemDialog=new BX.PopupWindow("crm-tracking-phone-add",i,{content:BX("crm-tracking-dialog-add"),minWidth:300});this.itemDialogName=BX("item-add-name");var e=BX("item-add-name-btn-add");BX.bind(e,"click",function(){this.itemDialog.close();var t=this.itemDialogName.value.trim();if(!t){return}if(this.itemDialogIsPhone){this.selectorPhone.addTile(t,{},t)}else{this.selectorEmail.addTile(t,{},t)}}.bind(this));BX.bind(BX("item-add-name-btn-close"),"click",function(){this.itemDialog.close()}.bind(this))}this.itemDialogIsPhone=t;this.itemDialogName.placeholder=t?this.itemDialogName.getAttribute("data-placeholder-phone"):this.itemDialogName.getAttribute("data-placeholder-email");if(this.itemDialog.isShown()){this.itemDialog.close()}else{this.itemDialogName.value="";this.itemDialog.show();this.itemDialogName.focus()}};t.Site=new s;t.SiteChecker=i})();
//# sourceMappingURL=script.map.js