(function(){"use strict";BX.namespace("BX.Crm.Scoring");BX.Crm.Scoring.ModelList=function(e){this.container=e.container;this.trainingList=e.trainingList||{};this.trainingErrors=e.trainingErrors||{};this.models=this.createModels(Object.values(e.models||{}));this.scoringEnabled=e.scoringEnabled;this.trainingStepTimeout=0;this.init();this.render()};BX.Crm.Scoring.ModelList.prototype={init:function(){for(var e in this.trainingErrors){if(!this.trainingErrors.hasOwnProperty(e)){continue}this.getModelByName(e).trainingError=this.trainingErrors[e]}this.scheduleContinueTraining();BX.addCustomEvent("onPullEvent-crm",this.onPullEvent.bind(this))},createModels:function(e){if(!BX.type.isArray(e)){return[]}return e.map(function(e){var t=e.name;var n=this.trainingList[t];return new BX.Crm.Scoring.ModelList.Model({modelFields:e,currentTraining:n,parent:this})}.bind(this))},getRunningTrainings:function(){var e={};for(var t=0;t<this.models.length;t++){var n=this.models[t];if(n.shouldContinueTraining()){e[n.modelFields.name]=n.currentTraining}}return e},render:function(){BX.clean(this.container);BX.adjust(this.container,{children:this.models.map(function(e){return e.render()})})},scheduleContinueTraining:function(){clearTimeout(this.trainingStepTimeout);if(Object.keys(this.getRunningTrainings()).length>0){this.trainingStepTimeout=setTimeout(this.continueTraining.bind(this),1e3)}},continueTraining:function(){clearTimeout(this.trainingStepTimeout);this.trainingStepTimeout=0;var e=this.getRunningTrainings();if(Object.keys(e).length===0){return}var t=Object.keys(e)[0];BX.ajax.runComponentAction("bitrix:crm.ml.entity.detail","continueTraining",{data:{modelName:t}}).then(function(){this.scheduleContinueTraining()}.bind(this)).catch(function(e){if(e.errors){console.error(e.errors.map(function(e){return e.message}).join("; "))}else{console.error(e)}})},getModelByName:function(e){for(var t=0;t<this.models.length;t++){if(this.models[t].modelFields.name===e){return this.models[t]}}return null},onPullEvent:function(e,t){var n=this.getModelByName(t.model.name);if(!n){return}switch(e){case"trainingProgress":n.onTrainingProgress(t);break;default:break}},showHelp:function(){top.BX.Helper.show("redirect=detail&code=9578357")},showFeedbackForm:function(){}};BX.Crm.Scoring.ModelList.Model=function(e){this.modelFields=e.modelFields;this.currentTraining=e.currentTraining;this.parent=e.parent;this.entityType=e.modelFields.name.substr(4,4).toLowerCase();this.trainingError=false;this.progressBar=new BX.UI.ProgressBar({value:this.calcProgress(),statusType:BX.UI.ProgressBar.Status.NONE,column:true});this.roundProgress=new BX.UI.ProgressRound({width:53,lineSize:2,value:this.calcProgress()});this.deleteModelPopup=null;this.elements={container:null,header:null,description:null,buttons:null,startTrainingButton:null}};BX.Crm.Scoring.ModelList.Model.prototype={inTraining:function(){return["pending_creation","gathering","training","evaluating"].indexOf(this.currentTraining.STATE)!=-1},shouldContinueTraining:function(){return["pending_creation","gathering"].indexOf(this.currentTraining.STATE)!=-1},render:function(){var e;switch(this.modelFields.state){case"new":case"training":case"evaluating":e="crm-ml-model-block-process";break;case"ready":e="crm-ml-model-block-default";break;default:if(this.inTraining()){e="crm-ml-model-block-process"}else{e=this.trainingError?"crm-ml-model-block-unprepared":"crm-ml-model-block-prepared"}}this.elements.container=BX.create("div",{props:{className:"crm-ml-model-block "+e},children:[BX.create("div",{props:{className:"crm-ml-model-block-inner"},children:[BX.create("div",{props:{className:"crm-ml-model-progress-container"},children:[this.inTraining()?this.roundProgress.getContainer():null]}),this.renderHeader(),this.renderDescription(),this.renderButtons(),this.inTraining()?BX.create("div",{props:{className:"crm-ml-model-progress"},children:[this.progressBar.getContainer()]}):null]})]});return this.elements.container},renderHeader:function(){this.elements.header=BX.create("div",{props:{className:"crm-ml-model-header"},children:[BX.create("span",{props:{className:"crm-ml-model-title"},text:this.modelFields.title})]});return this.elements.header},renderButtons:function(){var e=this.entityType==="lead";var t=[];if(!this.modelFields.state&&!this.inTraining()&&!this.trainingError){this.elements.startTrainingButton=BX.create("button",{props:{className:"ui-btn ui-btn-primary ui-btn-sm ui-btn-round"},text:BX.message("CRM_ML_MODEL_LIST_BUTTON_TRAIN_FREE_OF_CHARGE"),events:{click:this.onStartTrainingButtonClick.bind(this)}});t.push(this.elements.startTrainingButton)}else if(this.modelFields.state==="ready"){this.elements.deleteModelButton=BX.create("button",{props:{className:"ui-btn ui-btn-danger ui-btn-sm ui-btn-round"},text:e?BX.message("CRM_ML_MODEL_LIST_LEAD_SCORING_DISABLE"):BX.message("CRM_ML_MODEL_LIST_DEAL_SCORING_DISABLE"),events:{click:this.onDeleteModelButtonClick.bind(this)}});t.push(this.elements.deleteModelButton)}if(t.length>0){this.elements.buttons=BX.create("div",{props:{className:"crm-ml-model-btn"},children:t})}else{this.elements.buttons=null}return this.elements.buttons},renderDescription:function(){var e=BX.create("div",{props:{className:"crm-ml-model-description"}});if(!this.modelFields.state||this.modelFields.state!=="ready"){if(this.inTraining()){e.appendChild(document.createTextNode(BX.message("CRM_ML_MODEL_LIST_SCORING_TRAINING_IN_PROCESS").replace("#PROGRESS#",this.calcProgress())))}else{if(!this.trainingError){e.appendChild(document.createTextNode(BX.message("CRM_ML_MODEL_LIST_SCORING_ENOUGH_DATA")))}else if(this.trainingError.code=="too_soon"){e.appendChild(document.createTextNode(BX.message("CRM_ML_MODEL_LIST_SCORING_ERROR_TOO_SOON_2").replace("#DATE#",this.formatDate(this.currentTraining["NEXT_DATE"]))))}else if(this.trainingError.code=="not_enough_data"){var t=/(.*)#LINK_START#(.*)#LINK_END#(.*)/.exec(BX.message("CRM_ML_MODEL_LIST_SCORING_NOT_ENOUGH_DATA"));e.appendChild(document.createTextNode(t[1]));e.appendChild(BX.create("a",{text:t[2],attrs:{href:"#"},events:{click:function(e){this.parent.showHelp();e.preventDefault()}.bind(this)}}));e.appendChild(document.createTextNode(t[3]))}}}else{var n=Math.round(this.currentTraining["AREA_UNDER_CURVE"]*100).toString(10);e.appendChild(document.createTextNode(BX.message("CRM_ML_MODEL_LIST_SCORING_MODEL_READY")));e.appendChild(BX.create("br"));e.appendChild(document.createTextNode(BX.message("CRM_ML_MODEL_LIST_SCORING_MODEL_QUALITY").replace("#QUALITY#",n)+" "+BX.message("CRM_ML_MODEL_LIST_SCORING_MODEL_TRAINING_DATE").replace("#TRAINING_DATE#",this.formatDate(this.currentTraining["DATE_START"]))))}return e},updateLayout:function(){var e=this.elements.container;this.render();e.parentElement.replaceChild(this.elements.container,e);this.roundProgress.update(this.calcProgress());this.progressBar.update(this.calcProgress())},onDeleteModelButtonClick:function(){this.confirmScoringDisable().then(function(e){if(!e){this.deleteModelPopup.close();return}BX.ajax.runComponentAction("bitrix:crm.ml.entity.detail","disableScoring",{data:{modelName:this.modelFields.name}}).then(function(e){var t=e.data;this.modelFields=t.model;this.currentTraining=t.currentTraining;this.trainingError={code:"too_soon"};this.updateLayout();this.deleteModelPopup.close()}.bind(this)).catch(function(e){this.deleteModelPopup.close();var t=e.errors.map(function(e){return e.message}).join("; ");alert(t)}.bind(this))}.bind(this))},onStartTrainingButtonClick:function(){if(!this.parent.scoringEnabled){BX.UI.InfoHelper.show("limit_AI_scoring");return}this.elements.startTrainingButton.classList.add("ui-btn-wait");BX.ajax.runComponentAction("bitrix:crm.ml.entity.detail","startModelTraining",{data:{modelName:this.modelFields["name"]}}).then(function(e){var t=e.data;this.modelFields=t.model;this.currentTraining=t.currentTraining;this.parent.scheduleContinueTraining();this.updateLayout()}.bind(this)).catch(function(e){if(e.errors){var t=e.errors;var n=t.map(function(e){return e.message}).join("<br>");alert(n)}else{console.error(e)}this.elements.startTrainingButton.classList.remove("ui-btn-wait")}.bind(this))},onTrainingProgress:function(e){this.modelFields=e.model;this.currentTraining=e.currentTraining;this.updateLayout()},calcProgress:function(){if(this.modelFields["state"]==="ready"){return 100}else if(this.modelFields["state"]==="evaluating"){return 86}else if(this.modelFields["state"]==="training"){return 66}else if(this.modelFields["state"]===false){return 0}else{var e=this.modelFields["recordsFailed"]+this.modelFields["recordsSuccess"];var t=(parseInt(this.currentTraining["RECORDS_SUCCESS"],10)+parseInt(this.currentTraining["RECORDS_FAILED"],10))/e;return isNaN(t)?0:Math.floor(t*66)}},confirmScoringDisable:function(){var e=this.entityType=="lead";return new Promise(function(t){var n=BX.create("div",{children:[BX.create("p",{text:e?BX.message("CRM_ML_MODEL_LIST_DISABLE_LEAD_SCORING"):BX.message("CRM_ML_MODEL_LIST_DISABLE_DEAL_SCORING")})]});if(this.currentTraining){n.appendChild(BX.create("p",{text:BX.message("CRM_ML_MODEL_LIST_SCORING_REENABLE_WARNING").replace("#DATE#",this.formatDate(this.currentTraining["NEXT_DATE"]))}))}this.deleteModelPopup=new BX.PopupWindow("delete-scoring-model",null,{titleBar:BX.message("CRM_ML_MODEL_LIST_CONFIRMATION"),content:n,buttons:[new BX.PopupWindowCustomButton({id:"button-continue",text:BX.message("CRM_ML_MODEL_LIST_BUTTON_DISABLE"),className:"ui-btn ui-btn-sm ui-btn-primary",events:{click:function(){this.buttonNode.classList.add("ui-btn-wait");t(true)}}}),new BX.PopupWindowCustomButton({id:"button-cancel",text:BX.message("CRM_ML_MODEL_LIST_BUTTON_CANCEL"),className:"ui-btn ui-btn-sm ui-btn-link",events:{click:function(){t(false)}}})],events:{onPopupClose:function(){this.destroy()},onPopupDestroy:function(){this.deleteModelPopup=null}.bind(this)}});this.deleteModelPopup.show()}.bind(this))},formatDate:function(e){if(typeof e==="string"){e=new Date(e)}else if(!(e instanceof Date)){BX.debug("date should be instance of Date");return""}var t=BX.date.convertBitrixFormat(BX.message("FORMAT_DATE"));return BX.date.format(t,e)}}})();
//# sourceMappingURL=script.map.js