(function(){"use strict";BX.namespace("BX.Crm.Scoring");var e={Idle:"idle",Training:"training",Ready:"ready",Error:"error"};var t={NotEnoughData:"not_enough_data",TooSoon:"too_soon"};BX.Crm.MlEntityDetail=function(t){this.model=BX.prop.getObject(t,"model",{});this.mlModelExists=BX.prop.getBoolean(t,"mlModelExists",false);this.scoringEnabled=BX.prop.getBoolean(t,"scoringEnabled",false);this.canStartTraining=BX.prop.getBoolean(t,"canStartTraining",false);this.trainingError=BX.prop.getObject(t,"trainingError",{});this.entity=t.entity;this.predictionHistory=BX.prop.getArray(t,"predictionHistory",[]);this.trainingHistory=BX.prop.getArray(t,"trainingHistory",[]);this.errors=BX.prop.getArray(t,"errors",[]);this.currentTraining=t.currentTraining?this.prepareTrainingModel(t.currentTraining):null;this.associatedEvents=BX.prop.getArray(t,"associatedEvents",[]);this.currentAssociatedEvent=this.associatedEvents.length>0?this.associatedEvents.length-1:0;this.node=t.node;this.settingsButtonId=t.settingsButtonId;this.feedbackParams=BX.prop.getObject(t,"feedbackParams",{});this.feedbackForm=new BX.UI.Feedback.Form(this.feedbackParams);this.modelProgress=null;this.currentPrediction=this.predictionHistory.length>0?this.predictionHistory[this.predictionHistory.length-1]:null;this.state="";if(this.errors.length>0){this.state=e.Error}else if(!this.mlModelExists){this.state=e.Idle}else if(this.model["state"]==="ready"){this.state=e.Ready}else{this.state=e.Training}this.elements={progressWrapper:null,predictionChart:null,modelQualityChart:null,assocEventWrap:null,scoringTextBlock:null,scoringDescBlock:null,startTrainingButton:null};this.modelQualityChart=null;this.predictionChart=null;this.trainingStepTimeout=null;this.disableConfirmationPopup=null;this.init()};BX.Crm.MlEntityDetail.prototype={init:function(){BX.addCustomEvent("onPullEvent-crm",this.onPullEvent.bind(this));if(this.currentTraining&&this.currentTraining["STATE"]==="gathering"){this.scheduleContinueTraining()}},onPullEvent:function(e,t){switch(e){case"trainingProgress":this.onTrainingProgress(t);break;case"mlModelUpdate":this.onMlModelUpdate(t);break;default:break}},onTrainingProgress:function(e){this.model=e.model;this.currentTraining=this.prepareTrainingModel(e.currentTraining);if(this.currentTraining["state"]=="finished"){}else{if(this.modelProgress){this.modelProgress.setProgress(this.calcProgress())}}},onMlModelUpdate:function(e){this.model=e.model;if(this.model["state"]==="ready"){this.updateState("ready")}else{if(this.modelProgress){this.modelProgress.setProgress(this.calcProgress())}}},prepareTrainingModel:function(e){var t=e;t["RECORDS_SUCCESS"]=parseInt(t["RECORDS_SUCCESS"]);t["RECORDS_SUCCESS_DELTA"]=parseInt(t["RECORDS_SUCCESS_DELTA"]);t["RECORDS_FAILED"]=parseInt(t["RECORDS_FAILED"]);t["RECORDS_FAILED_DELTA"]=parseInt(t["RECORDS_FAILED_DELTA"]);t["DAYS_TO_TRAIN"]=parseInt(t["DAYS_TO_TRAIN"]);t["NEXT_DATE"]=t["NEXT_DATE"];t["DATE_START"]=t["DATE_START"]?new Date(t["DATE_START"]):null;t["DATE_FINISH"]=t["DATE_FINISH"]?new Date(t["DATE_FINISH"]):null;return t},calcProgress:function(){if(this.model["state"]==="ready"){return 100}else if(this.model["state"]==="evaluating"){return 86}else if(this.model["state"]==="training"){return 66}else if(this.model["state"]===false){return 0}else{var e=this.model["recordsFailed"]+this.model["recordsSuccess"];var t=(parseInt(this.currentTraining["RECORDS_SUCCESS"],10)+parseInt(this.currentTraining["RECORDS_FAILED"],10))/e;return isNaN(t)?0:Math.floor(t*66)}},scheduleContinueTraining:function(){clearTimeout(this.trainingStepTimeout);this.trainingStepTimeout=setTimeout(this.continueTraining.bind(this),1)},continueTraining:function(){clearTimeout(this.trainingStepTimeout);this.trainingStepTimeout=0;BX.ajax.runComponentAction("bitrix:crm.ml.entity.detail","continueTraining",{data:{modelName:this.model["name"]}}).then(function(e){var t=e.data;var r=t.currentTraining;if(r["STATE"]==="gathering"){this.scheduleContinueTraining()}}.bind(this)).catch((function(e){console.error(e.errors.map((function(e){return e.message})).join("; "))}))},makeChart:function(e,t){return window.AmCharts.makeChart(e,{type:"serial",theme:"light",dataProvider:t,valueAxes:[{gridColor:"#E0E0E0",gridAlpha:0,labelFrequency:2,axisColor:"#E0E0E0",color:"#808992",gridPosition:"start",minimum:0,maximum:100,gridCount:1,fontSize:10}],gridAboveGraphs:false,startDuration:1,graphs:[{balloonFunction:function(e){var t=e.dataContext;var r=BX.date.convertBitrixFormat(BX.message("FORMAT_DATETIME")).replace(/:?\s*s/,"");var s=BX.date.format(r,t.date);var i=t.score+"%";return BX.message("CRM_ML_SCORE_BALLOON").replace("#DATE#",s).replace("#SCORE#",i)},fillColorsField:"color",fillAlphas:1,lineAlpha:1,lineColorField:"color",type:"column",valueField:"score",columnWidth:1}],categoryField:"date",categoryAxis:{labelFunction:function(e){return""},gridPosition:"start",gridAlpha:.1,axisColor:"#E0E0E0"},guides:[{}],export:{enabled:false}})},renderTraining:function(){return BX.create("div",{props:{className:"crm-ml-entity-content"},children:[this.elements.progressWrapper=BX.create("div",{props:{className:"crm-ml-entity-content-img-block"}}),this.renderDescription()]})},renderDescription:function(){var r=this.entity["ENTITY_TYPE"].toLowerCase()=="lead";this.elements.scoringTextBlock=BX.create("div",{props:{className:"crm-ml-entity-content-text-block"},children:[BX.create("div",{props:{className:"crm-ml-entity-content-text"},text:BX.message("CRM_ML_SCORING_DESCRIPTION_TITLE_2")}),this.elements.scoringDescBlock=BX.create("div",{props:{className:"crm-ml-entity-content-decs-block"}})]});if(this.state==e.Idle){this.elements.scoringDescBlock.appendChild(BX.create("div",{props:{className:"crm-ml-entity-content-desc"},text:BX.message("CRM_ML_SCORING_DESCRIPTION_P1")}));this.elements.scoringDescBlock.appendChild(BX.create("div",{props:{className:"crm-ml-entity-content-desc"},text:BX.message("CRM_ML_SCORING_DESCRIPTION_P2_2")}));if(this.canStartTraining){this.elements.scoringDescBlock.appendChild(BX.create("div",{props:{className:"crm-ml-entity-content-desc"},text:BX.message("CRM_ML_SCORING_CAN_START_TRAINING")}));this.elements.startTrainingButton=BX.create("button",{props:{className:"ui-btn ui-btn-success ui-btn-md"},text:BX.message("CRM_ML_SCORING_TRAIN_FREE_OF_CHARGE"),events:{click:this.onStartTrainingButtonClick.bind(this)}});this.elements.scoringTextBlock.appendChild(this.elements.startTrainingButton)}else{switch(this.trainingError.code){case t.NotEnoughData:this.elements.scoringDescBlock.appendChild(BX.create("div",{props:{className:"crm-ml-entity-content-desc"},text:BX.message("CRM_ML_SCORING_NOT_ENOUGH_DATA")}));break;case t.TooSoon:const e=BX.message("CRM_ML_SCORING_ERROR_TOO_SOON_2");this.elements.scoringDescBlock.appendChild(BX.create("div",{props:{className:"crm-ml-entity-content-desc"},text:BX.Type.isPlainObject(this.currentTraining)&&this.currentTraining["NEXT_DATE"]?e.replace("#DATE#",this.currentTraining["NEXT_DATE"]):e.substring(0,e.indexOf(".")+1)}))}}}if(this.state==e.Training){this.elements.scoringTextBlock.appendChild(BX.create("div",{props:{className:"crm-ml-entity-content-text"},text:r?BX.message("CRM_ML_MODEL_TRAINING_LEADS"):BX.message("CRM_ML_MODEL_TRAINING_DEALS")}));this.elements.scoringTextBlock.appendChild(BX.create("div",{props:{className:"crm-ml-entity-content-text-notice"},text:r?BX.message("CRM_ML_MODEL_FUTURE_LEAD_FORECAST"):BX.message("CRM_ML_MODEL_FUTURE_DEAL_FORECAST")}))}return this.elements.scoringTextBlock},renderPredictionReport:function(){var e="",t="",r="",s="",i="",n="",a="",o="",l;if(this.currentPrediction){if(this.currentPrediction["SCORE"]<.5){t=BX.message("CRM_ML_SUCCESS_PROBABILITY_LOW");e="crm-ml-entity-report-title-fail"}else if(this.currentPrediction["SCORE"]<.75){t=BX.message("CRM_ML_SUCCESS_PROBABILITY_MEDIUM");e="crm-ml-entity-report-title-middle"}else{t=BX.message("CRM_ML_SUCCESS_PROBABILITY_HIGH");e="crm-ml-entity-report-title-success"}}if(this.currentTraining){if(this.currentTraining["AREA_UNDER_CURVE"]<.5){n=BX.message("CRM_ML_MODEL_QUALITY_LOW");i="crm-ml-entity-report-title-fail"}else if(this.currentTraining["AREA_UNDER_CURVE"]<.75){n=BX.message("CRM_ML_MODEL_QUALITY_MEDIUM");i="crm-ml-entity-report-title-middle"}else{n=BX.message("CRM_ML_MODEL_QUALITY_HIGH");i="crm-ml-entity-report-title-success"}}if(this.entity["ENTITY_TYPE"].toLowerCase()==="lead"){l=true;r=BX.message("CRM_ML_LEAD_SUCCESS_PROBABILITY");s=BX.message("CRM_ML_LEAD_FORECAST");a=BX.message("CRM_ML_MODEL_SUCCESSFUL_LEADS_IN_TRAINING");o=BX.message("CRM_ML_MODEL_FAILED_LEADS_IN_TRAINING")}else{l=false;r=BX.message("CRM_ML_DEAL_SUCCESS_PROBABILITY");s=BX.message("CRM_ML_DEAL_FORECAST");a=BX.message("CRM_ML_MODEL_SUCCESSFUL_DEALS_IN_TRAINING");o=BX.message("CRM_ML_MODEL_FAILED_DEALS_IN_TRAINING")}return BX.create("div",{props:{className:"crm-ml-entity-report"},children:[BX.create("div",{props:{className:"crm-ml-entity-report-block crm-ml-entity-report-block-result"},children:[BX.create("div",{props:{className:"crm-ml-entity-report-title "+e},children:[BX.create("span",{props:{className:"crm-ml-entity-report-title-text"},text:r}),BX.create("span",{props:{className:"crm-ml-entity-report-title-result"},text:this.currentPrediction?Math.round(this.currentPrediction["SCORE"]*100):""}),BX.create("span",{props:{className:"crm-ml-entity-report-title-icon"}}),BX.create("span",{props:{className:"crm-ml-entity-report-title-mark"},text:t}),BX.create("span",{dataset:{hint:BX.message("CRM_ML_SCORING_PREDICTION_HINT")},events:{click:function(){this.showHelp()}.bind(this)}})]})]}),BX.create("div",{props:{className:"crm-ml-entity-report-block crm-ml-entity-report-block-chart"},children:[BX.create("div",{props:{className:"crm-ml-entity-report-title"},children:[BX.create("span",{props:{className:"crm-ml-entity-report-subtitle"},text:BX.message("CRM_ML_FORECAST_DYNAMICS")})]}),this.elements.predictionChart=BX.create("div",{props:{className:"crm-ml-entity-chart"}})]}),BX.create("div",{props:{className:"crm-ml-entity-report-block crm-ml-entity-report-block-event"},children:[BX.create("div",{props:{className:"crm-ml-entity-report-title"},children:[BX.create("span",{props:{className:"crm-ml-entity-report-subtitle"},text:BX.message("CRM_ML_INFLUENCING_EVENT")})]}),this.elements.assocEventWrap=BX.create("div",{props:{className:"crm-ml-entity-report-event"},children:this.renderAssociatedEvents()})]}),BX.create("div",{props:{className:"crm-ml-entity-report-block crm-ml-entity-report-block-stat"},children:[BX.create("div",{props:{className:"crm-ml-entity-report-title with-border "+i},children:[BX.create("span",{props:{className:"crm-ml-entity-report-title-text"},text:BX.message("CRM_ML_MODEL_QUALITY")}),BX.create("span",{props:{className:"crm-ml-entity-report-title-result"},text:Math.round(this.currentTraining["AREA_UNDER_CURVE"]*100)}),BX.create("span",{props:{className:"crm-ml-entity-report-title-icon"}}),BX.create("span",{props:{className:"crm-ml-entity-report-title-mark"},text:n}),BX.create("span",{dataset:{hint:BX.message("CRM_ML_SCORING_MODEL_QUALITY_HINT")},events:{click:function(){this.showHelp()}.bind(this)}})]}),BX.create("div",{props:{className:"crm-ml-entity-report-stat"},children:[BX.create("div",{props:{className:"crm-ml-entity-report-info"},children:[BX.create("div",{props:{className:"crm-ml-entity-report-info-item"},children:[BX.create("div",{props:{className:"crm-ml-entity-report-info-text"},text:BX.message("CRM_ML_MODEL_MODEL_WILL_BE_TRAINED_AGAIN")}),BX.create("div",{props:{className:"crm-ml-entity-report-info-detail"},children:[BX.create("span",{props:{className:"crm-ml-entity-report-info-days"},html:BX.message("CRM_ML_MODEL_MODEL_WILL_BE_TRAINED_IN_DAYS").replace("#DAYS#",'<span class="crm-ml-entity-report-info-value">'+this.currentTraining["DAYS_TO_TRAIN"]+"</span>")})]})]}),BX.create("div",{props:{className:"crm-ml-entity-report-info-item crm-ml-separator-left"},children:[BX.create("div",{props:{className:"crm-ml-entity-report-info-text"},text:a}),BX.create("div",{props:{className:"crm-ml-entity-report-info-detail"},children:[BX.create("span",{props:{className:"crm-ml-entity-report-info-value"},text:this.currentTraining["RECORDS_SUCCESS"]}),this.currentTraining["RECORDS_SUCCESS_DELTA"]!=0?BX.create("span",{props:{className:this.currentTraining["RECORDS_SUCCESS_DELTA"]>0?"crm-ml-entity-report-info-dif-green":"crm-ml-entity-report-info-dif-red"},text:(this.currentTraining["RECORDS_SUCCESS_DELTA"]>0?"+ ":"")+this.currentTraining["RECORDS_SUCCESS_DELTA"]}):null]})]}),BX.create("div",{props:{className:"crm-ml-entity-report-info-item crm-ml-separator-left"},children:[BX.create("div",{props:{className:"crm-ml-entity-report-info-text"},text:o}),BX.create("div",{props:{className:"crm-ml-entity-report-info-detail"},children:[BX.create("span",{props:{className:"crm-ml-entity-report-info-value"},text:this.currentTraining["RECORDS_FAILED"]}),this.currentTraining["RECORDS_FAILED_DELTA"]!=0?BX.create("span",{props:{className:this.currentTraining["RECORDS_FAILED_DELTA"]>0?"crm-ml-entity-report-info-dif-green":"crm-ml-entity-report-info-dif-red"},text:(this.currentTraining["RECORDS_FAILED_DELTA"]>0?"+ ":"")+this.currentTraining["RECORDS_FAILED_DELTA"]}):null]})]})]}),this.elements.modelQualityChart=BX.create("div",{props:{className:"crm-ml-entity-chart"}})]})]})]})},renderAssociatedEvents:function(){var e=this.entity["ENTITY_TYPE"].toLowerCase()==="lead";if(this.associatedEvents.length>0){return this.associatedEvents.map(this.renderAssociatedEvent.bind(this))}else{return[BX.create("span",{props:{className:"crm-ml-entity-report-event-name"},text:e?BX.message("CRM_ML_MODEL_NO_EVENTS_YET_LEAD"):BX.message("CRM_ML_MODEL_NO_EVENTS_YET_DEAL")})]}},renderAssociatedEvent:function(e){var t=this.entity["ENTITY_TYPE"].toLowerCase()==="lead";if(e["EVENT_TYPE"]=="update"){return BX.create("span",{props:{className:"crm-ml-entity-report-event-name"},text:(t?BX.message("CRM_ML_MODEL_EVENT_UPDATE_LEAD"):BX.message("CRM_ML_MODEL_EVENT_UPDATE_DEAL"))+": "+this.formatPercent(e["SCORE_DELTA"])})}else if(e["EVENT_TYPE"]=="activity"){return BX.create("span",{props:{className:"crm-ml-entity-report-event-name"},children:[BX.create("a",{props:{className:"crm-ml-entity-report-act-link"},text:e["ACTIVITY"]["SUBJECT"],events:{click:function(){(new BX.Crm.Activity.Planner).showEdit({ID:e["ACTIVITY"]["ID"]})}.bind(this)}}),BX.create("span",{text:": "+this.formatPercent(e["SCORE_DELTA"])})]})}},setCurrentAssociatedEvent:function(e){if(e==this.currentAssociatedEvent){return}this.currentAssociatedEvent=e;BX.cleanNode(this.elements.assocEventWrap);this.elements.assocEventWrap.appendChild(this.renderAssociatedEvent())},formatPercent:function(e){return(e>0?"+":"")+Math.floor(e*100)+"%"},getScoreColor:function(e){if(e===0){return""}else if(e<.5){return"#F65C2F"}else if(e<.75){return"#FFC238"}else{return"#9DCF00"}},renderPredictionChart:function(){var e;var t=[];if(this.predictionHistory.length<6){for(e=6;e>this.predictionHistory.length;e--){t.push({date:null,score:0,color:""})}}for(e=0;e<this.predictionHistory.length;e++){t.push({date:new Date(this.predictionHistory[e]["CREATED"]),score:Math.round(this.predictionHistory[e]["SCORE"]*100),color:this.getScoreColor(this.predictionHistory[e]["SCORE"])})}this.predictionChart=this.makeChart(this.elements.predictionChart,t)},renderModelQualityChart:function(){var e;var t=[];if(this.trainingHistory.length<5){for(e=5;e>this.trainingHistory.length;e--){t.push({date:null,score:0,color:""})}}for(e=0;e<this.trainingHistory.length;e++){t.push({date:new Date(this.trainingHistory[e]["DATE_FINISH"]),score:Math.round(this.trainingHistory[e]["AREA_UNDER_CURVE"]*100),color:this.getScoreColor(this.trainingHistory[e]["AREA_UNDER_CURVE"])})}this.modelQualityChart=this.makeChart(this.elements.modelQualityChart,t)},renderErrors:function(){return BX.create("div",{props:{className:"crm-ml-entity-content"},children:[this.elements.progressWrapper=BX.create("div",{props:{className:"crm-ml-entity-content-img-block"}}),BX.create("div",{props:{className:"crm-ml-entity-content-text-block"},children:this.errors.map((function(e){return BX.create("div",{props:{className:"ui-alert ui-alert-danger"},children:[BX.create("span",{props:{className:"ui-alert-message"},text:e.message})]})}))})]})},show:function(){if(this.state===e.Error){this.node.appendChild(this.renderErrors());this.modelProgress=new s({domNode:this.elements.progressWrapper,width:132,progress:0});this.modelProgress.show()}else if(this.state===e.Idle){this.node.appendChild(this.renderTraining());this.modelProgress=new s({domNode:this.elements.progressWrapper,width:132,showProgress:false,animation:r.Start});this.modelProgress.show()}else if(this.state===e.Training){this.node.appendChild(this.renderTraining());this.modelProgress=new s({domNode:this.elements.progressWrapper,width:132,progress:this.calcProgress()});this.modelProgress.show()}else{this.node.appendChild(this.renderPredictionReport());this.renderPredictionChart();this.renderModelQualityChart();this.showSettingsButton()}BX.UI.Hint.init(this.node)},showHelp:function(){top.BX.Helper.show("redirect=detail&code=9578357")},showFeedbackForm:function(){this.feedbackForm.openPanel()},showSettingsButton:function(){var e=BX.UI.ButtonManager.getByUniqid(this.settingsButtonId);if(!e){return}e.removeClass("crm-ml-button-hidden")},confirmScoringDisable:function(){var e=this.entity["ENTITY_TYPE"].toLowerCase()=="lead";return new Promise(function(t){var r=BX.create("div",{children:[BX.create("p",{text:e?BX.message("CRM_ML_DISABLE_LEAD_SCORING"):BX.message("CRM_ML_DISABLE_DEAL_SCORING")})]});if(this.currentTraining){r.appendChild(BX.create("p",{text:BX.message("CRM_ML_SCORING_REENABLE_WARNING").replace("#DATE#",BX.Type.isPlainObject(this.currentTraining)&&this.currentTraining["NEXT_DATE"]?this.currentTraining["NEXT_DATE"]:"")}))}this.disableConfirmationPopup=new BX.PopupWindow("disable-scoring",null,{titleBar:BX.message("CRM_ML_CONFIRMATION"),content:r,buttons:[new BX.PopupWindowCustomButton({id:"button-continue",text:BX.message("CRM_ML_BUTTON_DISABLE"),className:"ui-btn ui-btn-sm ui-btn-primary",events:{click:function(){this.buttonNode.classList.add("ui-btn-wait");t(true)}}}),new BX.PopupWindowCustomButton({id:"button-cancel",text:BX.message("CRM_ML_BUTTON_CANCEL"),className:"ui-btn ui-btn-sm ui-btn-link",events:{click:function(){t(false)}}})],events:{onPopupClose:function(){this.destroy()},onPopupDestroy:function(){this.disableConfirmationPopup=null}.bind(this)}});this.disableConfirmationPopup.show()}.bind(this))},onDisableScoringClick:function(e,t){t.getMenuWindow().close();this.confirmScoringDisable().then(function(e){if(!e){this.disableConfirmationPopup.close();return}BX.ajax.runComponentAction("bitrix:crm.ml.entity.detail","disableScoring",{data:{modelName:this.model["name"]}}).then(function(){this.disableConfirmationPopup.close();BX.SidePanel.Instance.close()}.bind(this)).catch(function(e){this.disableConfirmationPopup.close();var t=e.errors.map((function(e){return e.message})).join("; ");alert(t)}.bind(this))}.bind(this))},updateState:function(t){if(this.state==t){return}this.state=t;if(this.state===e.Ready){this.updateData().then(function(){return this.fadeOut()}.bind(this)).then(function(){this.fadeIn()}.bind(this))}else if(this.state===e.Training){BX.clean(this.node);this.show();this.scheduleContinueTraining()}},updateData:function(){var e=new BX.Promise;BX.ajax.runComponentAction("bitrix:crm.ml.entity.detail","getResult",{data:{entityType:this.entity["ENTITY_TYPE"],entityId:this.entity["ENTITY_ID"]}}).then(function(t){var r=t.data;this.model=BX.prop.getObject(r,"model",{});this.entity=r.entity;this.predictionHistory=BX.prop.getArray(r,"predictionHistory",[]);this.trainingHistory=BX.prop.getArray(r,"trainingHistory",[]);this.errors=BX.prop.getArray(r,"errors",[]);this.currentTraining=r.currentTraining?this.prepareTrainingModel(r.currentTraining):null;e.resolve()}.bind(this));return e},fadeOut:function(){var e=new BX.Promise;this.node.classList.add("crm-ml-entity-wrapper-animation-hide");setTimeout(function(){BX.clean(this.node);this.node.classList.remove("crm-ml-entity-wrapper-animation-hide");this.elements.progressWrapper=null;this.elements.predictionChart=null;this.elements.modelQualityChar=null;e.resolve()}.bind(this),300);return e},fadeIn:function(){var e=new BX.Promise;this.node.classList.add("crm-ml-entity-wrapper-animation-show");this.show();setTimeout(function(){this.node.classList.remove("crm-ml-entity-wrapper-animation-show");e.resolve()}.bind(this),300);return e},onLeftArrowClick:function(){if(this.currentAssociatedEvent===0){return}this.setCurrentAssociatedEvent(this.currentAssociatedEvent-1)},onRightArrowClick:function(){if(this.associatedEvents.length===0||this.currentAssociatedEvent===this.associatedEvents.length-1){return}this.setCurrentAssociatedEvent(this.currentAssociatedEvent+1)},onStartTrainingButtonClick:function(){if(!this.scoringEnabled){BX.UI.InfoHelper.show("limit_AI_scoring");return}this.elements.startTrainingButton.classList.add("ui-btn-wait");BX.ajax.runComponentAction("bitrix:crm.ml.entity.detail","startModelTraining",{data:{modelName:this.model["name"]}}).then(function(t){var r=t.data;this.model=BX.prop.getObject(r,"model",{});this.currentTraining=r.currentTraining?this.prepareTrainingModel(r.currentTraining):null;this.updateState(e.Training)}.bind(this)).catch((function(e){}))}};var r={Start:"start",Progress:"progress"};var s=function(e){this.domNode=e.domNode;this.perimetr=e.width;this.radius=e.width/2;this.progress=Number(e.progress)>100?100:e.progress;this.showProgress=e.showProgress!==false;this.animation=e.animation||r.Progress;this.elements={svg:null,progressWrapper:null,progressBg:null,progressMove:null,number:null}};s.prototype={getCircumFerence:function(){return(this.radius-10)*2*Math.PI},getCircumProgress:function(){return this.getCircumFerence()-this.getCircumFerence()/100*this.progress},createCircle:function(){this.elements.svg=document.createElementNS("http://www.w3.org/2000/svg","svg");this.elements.svg.setAttributeNS(null,"class","crm-ml-entity-progress-circle-bar");this.elements.svg.setAttributeNS(null,"viewport","0 0 "+this.radius+" "+this.radius);this.elements.svg.setAttributeNS(null,"width",this.perimetr);this.elements.svg.setAttributeNS(null,"height",this.perimetr);this.elements.progressBg=document.createElementNS("http://www.w3.org/2000/svg","circle");this.elements.progressBg.setAttributeNS(null,"r",this.radius-10);this.elements.progressBg.setAttributeNS(null,"cx",this.radius);this.elements.progressBg.setAttributeNS(null,"cy",this.radius);this.elements.progressBg.setAttributeNS(null,"class","crm-ml-entity-progress-circle-bar-bg");this.elements.progressMove=document.createElementNS("http://www.w3.org/2000/svg","circle");this.elements.progressMove.setAttributeNS(null,"r",this.radius-10);this.elements.progressMove.setAttributeNS(null,"cx",this.radius);this.elements.progressMove.setAttributeNS(null,"cy",this.radius);this.elements.progressMove.setAttributeNS(null,"stroke-dasharray",this.getCircumFerence());this.elements.progressMove.setAttributeNS(null,"stroke-dashoffset",this.getCircumFerence());this.elements.progressMove.setAttributeNS(null,"class","crm-ml-entity-progress-circle-bar-progress");this.elements.svg.appendChild(this.elements.progressBg);this.elements.svg.appendChild(this.elements.progressMove);return this.elements.svg},render:function(){if(this.showProgress){this.createCircle();this.elements.number=BX.create("div",{attrs:{className:"crm-ml-entity-progress-circle-number","data-progress":this.progress}})}return BX.createFragment([BX.create("div",{props:{className:"crm-ml-entity-content-img"}}),this.elements.progressWrapper=BX.create("div",{props:{className:"crm-ml-entity-progress"},children:[this.graph=BX.create("div",{attrs:{className:"crm-ml-entity-progress-circle-wrapper"},children:[this.elements.svg,this.elements.number]})]}),BX.create("div",{props:{className:this.animation==r.Start?"crm-ml-entity-content-circle-start":"crm-ml-entity-content-circle"}})])},addWrapperClass:function(){this.graph.classList.add("crm-ml-entity-progress-circle-wrapper-animate")},animateProgress:function(){if(!this.showProgress){return}this.elements.svg.setAttributeNS(null,"class","crm-ml-entity-progress-circle-bar crm-ml-entity-progress-circle-bar-animate");if(this.progress>0){this.elements.progressMove.setAttributeNS(null,"stroke-dashoffset",this.getCircumProgress())}},animateNumber:function(e,t){if(!this.showProgress){return}if(t<=0){this.elements.number.innerHTML="0"+" <span>%</span>";return}var r=e;var s=1e3/Math.abs(t-e);var i=setInterval(function(){r=t>e?r+1:r-1;this.elements.number.innerHTML=r+" <span>%</span>";if(r===this.progress){clearInterval(i)}}.bind(this),s)},setProgress:function(e){var t=this.progress;this.progress=Number(e);if(this.progress==t){return}this.elements.progressMove.setAttributeNS(null,"stroke-dashoffset",this.getCircumProgress());this.animateNumber(t,this.progress)},show:function(){this.domNode.appendChild(this.render());setTimeout(function(){this.addWrapperClass();this.animateNumber(0,this.progress);this.animateProgress()}.bind(this),100)}}})();
//# sourceMappingURL=script.map.js