<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED!==true)die();
CJSCore::Init(["popup"]);
?>

<style>
	.crm-lead-popup-container{
		margin: -20px;
		padding: 18px;
		border: 1px solid #d7e0e4;
		-webkit-border-radius: 1px;
		border-radius: var(--ui-border-radius-sm, 1px);
	}

	.crm-lead-popup-content {
		font-family: var(--ui-font-family-primary, var(--ui-font-family-helvetica));
		font-size:16px;
		min-width:500px;
		color:#000;
		border-radius:2px;
		background-color:#edf1f3;
	}

	.crm-lead-info-descript {
		font-size: 14px;
		margin-top: 23px;
		text-align: center;
	}

	.crm-lead-info-descript-text {
		color: #535c69;
		font-size: 12px;
		text-align: center;
	}

	.crm-lead-info-descript-text-info {
		display: block;
		overflow: hidden;
		color: #535c69;
		font-size: 13px;
		padding: 20px 0 0 0;
		border-top: 1px solid #dee3e6;
		margin: 15px 0 0 0;
	}

	.crm-lead-info-descript-text-info:before {
		content: '';
		display: inline-block;
		vertical-align: middle;
		margin: 0 7px 4px 0;
		width: 18px;
		height: 14px;
		background: url('data:image/svg+xml;charset=US-ASCII,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20width%3D%2218%22%20height%3D%2214%22%20viewBox%3D%220%200%2018%2014%22%3E%0A%20%20%3Cpath%20fill%3D%22%2331C5F5%22%20fill-rule%3D%22evenodd%22%20d%3D%22M9%2C0%20L0%2C14%20L18%2C14%20L9%2C0%20Z%20M8.169%2C4.645%20L9.913%2C4.645%20L9.913%2C9.258%20L8.169%2C9.258%20L8.169%2C4.645%20Z%20M8.169%2C12.378%20L8.178%2C10.598%20L9.922%2C10.598%20L9.913%2C12.378%20L8.169%2C12.378%20Z%22/%3E%0A%3C/svg%3E%0A') center center no-repeat;

	}

	.crm-lead-info-descript-img {
		border: none;
		display: block;
		margin: 19px auto 0;
	}

	.crm-lead-info-popup-cont-title {
		color: #535c69;
		font-size: 18px;
		line-height: 25px;
		text-align: center;
	}

	.crm-lead-info-popup-btn-wrap {
		display: -webkit-box;
		display: -ms-flexbox;
		display: flex;
		margin-top: 20px;
	}

	.crm-lead-info-popup-btn-wrap-text {
		display: block;
		overflow: hidden;
		color: #535c69;
		font-size: 13px;
		padding: 13px;
	}

	.crm-lead-info-popup-btn-wrap-half {
		-webkit-box-flex: 1;
		-ms-flex: 1;
		flex: 1;
		-webkit-box-ordinal-group: 2;
		-ms-flex-order: 1;
		order: 1;
		max-width: 280px;
	}

	.crm-lead-info-popup-btn-wrap-half:last-child {
		-webkit-box-ordinal-group: 4;
		-ms-flex-order: 3;
		order: 3;
	}

	.crm-lead-info-popup-btn-wrap:before {
		content: '';
		-webkit-box-flex: 1;
		-ms-flex: 1;
		flex: 1;
		max-width: 10px;
		-webkit-box-ordinal-group: 3;
		-ms-flex-order: 2;
		order: 2;
	}

	.crm-lead-info-popup-btn {
		-webkit-box-shadow: 0 0 0 1px transparent;
		box-shadow: 0 0 0 1px transparent;
		background: #f7f9fa;
		cursor: pointer;
		display: block;
		border-radius: var(--ui-border-radius-xs, 2px);
		padding: 21px;
		position: relative;
		-webkit-transition: .2s;
		transition: .2s;
	}

	.crm-lead-info-popup-btn:before {
		content: '';
		width: 20px;
		height: 20px;
		position: absolute;
		top: 13px;
		right: 10px;
		background-image: url('data:image/svg+xml;charset=US-ASCII,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20width%3D%2220%22%20height%3D%2220%22%20viewBox%3D%220%200%2020%2020%22%3E%0A%20%20%3Crect%20class%3D%22cls-1%22%20fill%3D%22%23fff%22%20stroke%3D%22%23a5acaf%22%20x%3D%222%22%20y%3D%222%22%20width%3D%2216%22%20height%3D%2216%22%20rx%3D%222%22%20ry%3D%222%22/%3E%0A%3C/svg%3E%0A');
		-webkit-transition: .2s;
		transition: .2s;
	}

	.crm-lead-info-popup-btn-active:before {
		background-image: url('data:image/svg+xml;charset=US-ASCII,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20width%3D%2220%22%20height%3D%2220%22%20viewBox%3D%220%200%2020%2020%22%3E%0A%20%20%3Crect%20class%3D%22cls-1%22%20fill%3D%22%23fff%22%20stroke%3D%22%23189ec8%22%20x%3D%222%22%20y%3D%222%22%20width%3D%2216%22%20height%3D%2216%22%20rx%3D%222%22%20ry%3D%222%22/%3E%0A%20%20%3Cpath%20d%3D%22M6.006%2C9.13L7.255%2C7.763l5.167%2C4.926-1.477%2C1.45Z%22/%3E%0A%20%20%3Cpath%20d%3D%22M18.594%2C2.875L20%2C4%2C11.306%2C14.395%2C9.844%2C12.688Z%22/%3E%0A%3C/svg%3E%0A');
	}

	.crm-lead-info-popup-btn:hover {
		-webkit-box-shadow: 0 0 0 2px #bdc3c8;
		box-shadow: 0 0 0 2px #bdc3c8;
	}

	.crm-lead-info-popup-btn-active,
	.crm-lead-info-popup-btn-active:hover {
		background-color: #e2f1f8;
		-webkit-box-shadow: 0 0 0 2px #3285d0;
		box-shadow: 0 0 0 2px #3285d0;
	}

	.crm-lead-info-popup-btn-active.crm-lead-info-popup-btn:after {
		opacity: 1;
		-webkit-transition: opacity 0.25s linear;
		transition: opacity 0.25s linear;
	}

	.crm-lead-info-popup-btn-text {
		display: block;
		font-size: 16px;
		font-weight: bold;
		position: relative;
		color: #535c69;
	}

	.crm-lead-info-popup-btn-text:before {
		content: '';
		display: inline-block;
		vertical-align: middle;
		margin: 0 16px 0 0;
		height: 30px;
		width: 40px;
		background: no-repeat top center;
		-webkit-transition: .2s;
		transition: .2s;
	}

	.crm-lead-info-popup-btn-local .crm-lead-info-popup-btn-text:before {
		background-image: url('data:image/svg+xml;charset=US-ASCII,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20width%3D%2236%22%20height%3D%2226%22%20viewBox%3D%220%200%2036%2026%22%3E%0A%20%20%3Cpath%20fill%3D%22%23737981%22%20d%3D%22M64.4242109%2C271.613416%20C64.277623%2C271.546184%2064.1222178%2C271.509812%2063.9624039%2C271.509812%20C63.8003858%2C271.509812%2063.6493892%2C271.545082%2063.4994948%2C271.613416%20C63.3484983%2C271.682852%2063.2217494%2C271.774332%2063.1104308%2C271.892263%20C63.0002143%2C272.009093%2062.9120411%2C272.145761%2062.8470134%2C272.296758%20C62.7808836%2C272.448857%2062.7489208%2C272.600955%2062.7489208%2C272.762973%20C62.7489208%2C272.924992%2062.7819857%2C273.082601%2062.8470134%2C273.235802%20C62.910939%2C273.389003%2063.0002143%2C273.524569%2063.1093286%2C273.639194%20C63.2206472%2C273.753819%2063.3484983%2C273.844197%2063.4983927%2C273.912531%20C63.7992836%2C274.049199%2064.1277286%2C274.048097%2064.4242109%2C273.912531%20C64.5752074%2C273.844197%2064.706365%2C273.751615%2064.8154793%2C273.639194%20C64.9245936%2C273.525671%2065.0127667%2C273.389003%2065.0777944%2C273.235802%20C65.14172%2C273.082601%2065.1747849%2C272.923889%2065.1747849%2C272.762973%20C65.1747849%2C272.602057%2065.1428222%2C272.448857%2065.0777944%2C272.296758%20C65.0127667%2C272.145761%2064.9234914%2C272.009093%2064.8143771%2C271.892263%20C64.7052628%2C271.776536%2064.5741053%2C271.682852%2064.4242109%2C271.613416%20Z%20M77.8805376%2C286.033034%20L53.5469491%2C286.033034%20L53.5469491%2C282.574442%20L71.1121452%2C282.574442%20C71.5508067%2C282.574442%2072.1316474%2C281.994703%2072.1316474%2C281.55494%20L72.1316474%2C270.487004%20L77.8805376%2C270.487004%20L77.8805376%2C286.033034%20Z%20M49.5780547%2C278.220892%20C48.6511343%2C278.161375%2047.7231118%2C278.080917%2046.8325628%2C277.798763%20C46.6628295%2C277.746961%2046.5030156%2C277.666503%2046.3409975%2C277.593761%20C46.1999204%2C277.529835%2046.1315862%2C277.427334%2046.1547317%2C277.26752%20C46.2197594%2C276.832165%2046.2451091%2C276.389095%2046.3465083%2C275.962557%20C46.4864832%2C275.369593%2046.8744451%2C274.977222%2047.4817377%2C274.766709%20C48.2775005%2C274.493372%2049.0622417%2C274.190276%2049.8469828%2C273.889386%20C50.3165049%2C273.709733%2050.6129872%2C273.30083%2050.6008634%2C272.875394%20C50.5997612%2C272.80706%2050.5689006%2C272.724398%2050.5226097%2C272.6748%20C49.9505863%2C272.064201%2049.5901785%2C271.358816%2049.4689404%2C270.542112%20C49.3642348%2C269.835624%2049.3576218%2C269.126933%2049.586872%2C268.43808%20C49.8701283%2C267.5828%2050.4697058%2C267.066987%2051.3922175%2C266.902765%20C51.9598322%2C266.800263%2052.514221%2C266.832226%2053.0509751%2C267.030616%20C53.8313076%2C267.319383%2054.249028%2C267.904632%2054.4374981%2C268.664024%20C54.5807795%2C269.243762%2054.5741665%2C269.824603%2054.5047301%2C270.414261%20C54.4154548%2C271.149405%2054.1443223%2C271.806295%2053.6792089%2C272.38934%20C53.6207942%2C272.464287%2053.5656859%2C272.545847%2053.4940452%2C272.605364%20C53.3661942%2C272.712274%2053.3353336%2C272.835716%2053.3882375%2C272.982304%20C53.4499587%2C273.154242%2053.5138842%2C273.325077%2053.5866271%2C273.491504%20C53.6549613%2C273.644705%2053.7750972%2C273.751615%2053.9371154%2C273.812234%20C54.6832808%2C274.094388%2055.428344%2C274.374338%2056.1723051%2C274.660901%20C56.4368245%2C274.7623%2056.7101613%2C274.854882%2056.9515354%2C274.997061%20C57.3615406%2C275.239537%2057.558828%2C275.640725%2057.6447969%2C276.079386%20C57.726357%2C276.492698%2057.7517068%2C276.915929%2057.8057129%2C277.33365%20C57.8167345%2C277.426232%2057.7748523%2C277.478033%2057.6999051%2C277.529835%20C57.3968098%2C277.73594%2057.0485259%2C277.843952%2056.694731%2C277.90898%20C56.1105838%2C278.014787%2055.522028%2C278.116187%2054.93237%2C278.162477%20C53.9437284%2C278.240731%2052.9506781%2C278.271592%2052.1879803%2C278.310167%20C51.1629673%2C278.277103%2050.3694088%2C278.27049%2049.5780547%2C278.220892%20Z%20M60.2238619%2C268.94728%20L60.3406913%2C268.834859%20C60.8432783%2C268.351009%2061.4395493%2C267.965251%2062.1151762%2C267.688608%20C62.790803%2C267.410862%2063.5325598%2C267.270888%2064.3195053%2C267.270888%20C65.0458317%2C267.270888%2065.731378%2C267.393228%2066.3563053%2C267.634602%20C66.9845391%2C267.875976%2067.5367235%2C268.213238%2067.9985304%2C268.634265%20C68.4603374%2C269.057496%2068.8295625%2C269.561185%2069.0951842%2C270.131005%20C69.3597036%2C270.70413%2069.4941677%2C271.321342%2069.4941677%2C271.969415%20C69.4941677%2C272.516089%2069.4247313%2C273.023084%2069.2858586%2C273.476074%20C69.1458837%2C273.933472%2068.9430854%2C274.332456%2068.6851789%2C274.663105%20C68.4250681%2C274.994857%2068.1076447%2C275.257172%2067.7406239%2C275.441233%20C67.3747053%2C275.624193%2066.9580871%2C275.716774%2066.501791%2C275.716774%20C66.2427824%2C275.716774%2066.0069191%2C275.64844%2065.8008144%2C275.513976%20C65.6321832%2C275.404862%2065.4800845%2C275.26158%2065.3478248%2C275.086336%20C65.0777944%2C275.338732%2064.813275%2C275.501852%2064.5619814%2C275.573493%20C63.955791%2C275.747635%2063.4377736%2C275.732205%2062.8646481%2C275.4754%20C62.5505312%2C275.334323%2062.2595597%2C275.132627%2061.9994489%2C274.878027%20C61.7393381%2C274.622325%2061.5211095%2C274.313719%2061.350274%2C273.962128%20C61.176132%2C273.605027%2061.0879589%2C273.206044%2061.0879589%2C272.776199%20C61.0879589%2C272.356275%2061.1706212%2C271.965006%2061.3359459%2C271.612314%20C61.5012706%2C271.259621%2061.718397%2C270.954321%2061.9829164%2C270.706334%20C62.2452316%2C270.455041%2062.5527355%2C270.259958%2062.8966108%2C270.122187%20C63.2382818%2C269.984417%2063.594281%2C269.91498%2063.949178%2C269.91498%20C64.3426507%2C269.91498%2064.6942412%2C269.992132%2064.9918256%2C270.145333%20C65.1979304%2C270.25114%2065.3676637%2C270.3834%2065.4999235%2C270.537703%20L65.5891988%2C270.034014%20L67.0220127%2C270.034014%20L67.0076845%2C270.157456%20L66.6120075%2C273.450724%20C66.5855555%2C273.654624%2066.5723295%2C273.862934%2066.5723295%2C274.073447%20C66.5723295%2C274.135168%2066.5855555%2C274.180357%2066.6131096%2C274.21232%20C66.6417659%2C274.248691%2066.6671157%2C274.254202%2066.6869547%2C274.254202%20C66.8655053%2C274.254202%2067.0275235%2C274.195787%2067.1818265%2C274.077856%20C67.3416404%2C273.955515%2067.4827174%2C273.789089%2067.6028534%2C273.580779%20C67.7251936%2C273.370266%2067.821082%2C273.125586%2067.8894162%2C272.855555%20C67.9577504%2C272.586627%2067.9919175%2C272.302269%2067.9919175%2C272.009093%20C67.9919175%2C271.525243%2067.8971313%2C271.078866%2067.7108655%2C270.679882%20C67.5245997%2C270.282001%2067.265591%2C269.939228%2066.9393503%2C269.66038%20C66.6120075%2C269.379328%2066.2207391%2C269.158895%2065.7787711%2C269.005695%20C65.3323945%2C268.851391%2064.8452377%2C268.773138%2064.3327312%2C268.773138%20C63.7397667%2C268.773138%2063.1864801%2C268.875639%2062.6871996%2C269.076233%20C62.1879191%2C269.276827%2061.7503597%2C269.55347%2061.3877476%2C269.89955%20C61.0251355%2C270.244527%2060.7374705%2C270.662248%2060.5313658%2C271.139485%20C60.3274653%2C271.620029%2060.2227597%2C272.139148%2060.2227597%2C272.683618%20C60.2227597%2C273.298625%2060.3362826%2C273.857423%2060.5578177%2C274.345682%20C60.7804549%2C274.830634%2061.0835502%2C275.245048%2061.4615926%2C275.576799%20C61.8418394%2C275.909653%2062.2915225%2C276.166457%2062.8007225%2C276.341702%20C63.3110247%2C276.518048%2063.862107%2C276.607323%2064.438539%2C276.607323%20C64.7824144%2C276.607323%2065.0855096%2C276.596302%2065.3423139%2C276.574258%20C65.5980161%2C276.553317%2065.8426966%2C276.512537%2066.0708447%2C276.45302%20C66.3011971%2C276.391299%2066.5205278%2C276.308637%2066.7233261%2C276.20834%20C66.9338395%2C276.105838%2067.1686006%2C275.970272%2067.4198941%2C275.804947%20L67.5190889%2C275.73992%20L68.3060344%2C277.156201%20L68.216759%2C277.212412%20C67.6733919%2C277.550776%2067.0958577%2C277.805376%2066.5028932%2C277.972905%20C65.9330741%2C278.129412%2065.1858066%2C278.21979%2064.451765%2C278.21979%20C63.5314576%2C278.21979%2062.6475217%2C278.067691%2061.9652818%2C277.789946%20C61.263203%2C277.503383%2060.6581147%2C277.107706%2060.164345%2C276.613936%20C59.6132627%2C276.063956%2059.2352203%2C275.311178%2059.0147874%2C274.775526%20C58.7469614%2C274.123044%2058.6113952%2C273.419863%2058.6113952%2C272.683618%20C58.6113952%2C271.855892%2058.9034688%2C270.898111%2059.1525579%2C270.329394%20C59.4203839%2C269.716591%2059.7752809%2C269.378226%2060.2238619%2C268.94728%20Z%20M72.1316474%2C268.389585%20L72.1316474%2C264.019502%20C72.1316474%2C263.579739%2071.5508067%2C263%2071.1121452%2C263%20L45.0206044%2C263%20C44.5808407%2C263%2044%2C263.579739%2044%2C264.019502%20L44%2C281.55494%20C44%2C281.994703%2044.5808407%2C282.574442%2045.0206044%2C282.574442%20L51.5377032%2C282.574442%20L51.5377032%2C287.027187%20C51.5377032%2C287.468053%2052.1174418%2C288.047791%2052.5583076%2C288.047791%20L78.9804978%2C287.938677%20C79.4202615%2C287.938677%2080%2C287.577167%2080%2C286.918072%20L80%2C269.382635%20C80%2C269.162202%2079.4202615%2C268.36203%2078.9804978%2C268.36203%20L72.1316474%2C268.389585%20Z%22%20transform%3D%22translate%28-44%20-263%29%22/%3E%0A%3C/svg%3E%0A');
	}

	.crm-lead-info-popup-btn-active.crm-lead-info-popup-btn-local .crm-lead-info-popup-btn-text:before {
		background-image: url('data:image/svg+xml;charset=US-ASCII,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20width%3D%2236%22%20height%3D%2226%22%20viewBox%3D%220%200%2036%2026%22%3E%0A%20%20%3Cpath%20fill%3D%22%230b66c3%22%20d%3D%22M64.4242109%2C271.613416%20C64.277623%2C271.546184%2064.1222178%2C271.509812%2063.9624039%2C271.509812%20C63.8003858%2C271.509812%2063.6493892%2C271.545082%2063.4994948%2C271.613416%20C63.3484983%2C271.682852%2063.2217494%2C271.774332%2063.1104308%2C271.892263%20C63.0002143%2C272.009093%2062.9120411%2C272.145761%2062.8470134%2C272.296758%20C62.7808836%2C272.448857%2062.7489208%2C272.600955%2062.7489208%2C272.762973%20C62.7489208%2C272.924992%2062.7819857%2C273.082601%2062.8470134%2C273.235802%20C62.910939%2C273.389003%2063.0002143%2C273.524569%2063.1093286%2C273.639194%20C63.2206472%2C273.753819%2063.3484983%2C273.844197%2063.4983927%2C273.912531%20C63.7992836%2C274.049199%2064.1277286%2C274.048097%2064.4242109%2C273.912531%20C64.5752074%2C273.844197%2064.706365%2C273.751615%2064.8154793%2C273.639194%20C64.9245936%2C273.525671%2065.0127667%2C273.389003%2065.0777944%2C273.235802%20C65.14172%2C273.082601%2065.1747849%2C272.923889%2065.1747849%2C272.762973%20C65.1747849%2C272.602057%2065.1428222%2C272.448857%2065.0777944%2C272.296758%20C65.0127667%2C272.145761%2064.9234914%2C272.009093%2064.8143771%2C271.892263%20C64.7052628%2C271.776536%2064.5741053%2C271.682852%2064.4242109%2C271.613416%20Z%20M77.8805376%2C286.033034%20L53.5469491%2C286.033034%20L53.5469491%2C282.574442%20L71.1121452%2C282.574442%20C71.5508067%2C282.574442%2072.1316474%2C281.994703%2072.1316474%2C281.55494%20L72.1316474%2C270.487004%20L77.8805376%2C270.487004%20L77.8805376%2C286.033034%20Z%20M49.5780547%2C278.220892%20C48.6511343%2C278.161375%2047.7231118%2C278.080917%2046.8325628%2C277.798763%20C46.6628295%2C277.746961%2046.5030156%2C277.666503%2046.3409975%2C277.593761%20C46.1999204%2C277.529835%2046.1315862%2C277.427334%2046.1547317%2C277.26752%20C46.2197594%2C276.832165%2046.2451091%2C276.389095%2046.3465083%2C275.962557%20C46.4864832%2C275.369593%2046.8744451%2C274.977222%2047.4817377%2C274.766709%20C48.2775005%2C274.493372%2049.0622417%2C274.190276%2049.8469828%2C273.889386%20C50.3165049%2C273.709733%2050.6129872%2C273.30083%2050.6008634%2C272.875394%20C50.5997612%2C272.80706%2050.5689006%2C272.724398%2050.5226097%2C272.6748%20C49.9505863%2C272.064201%2049.5901785%2C271.358816%2049.4689404%2C270.542112%20C49.3642348%2C269.835624%2049.3576218%2C269.126933%2049.586872%2C268.43808%20C49.8701283%2C267.5828%2050.4697058%2C267.066987%2051.3922175%2C266.902765%20C51.9598322%2C266.800263%2052.514221%2C266.832226%2053.0509751%2C267.030616%20C53.8313076%2C267.319383%2054.249028%2C267.904632%2054.4374981%2C268.664024%20C54.5807795%2C269.243762%2054.5741665%2C269.824603%2054.5047301%2C270.414261%20C54.4154548%2C271.149405%2054.1443223%2C271.806295%2053.6792089%2C272.38934%20C53.6207942%2C272.464287%2053.5656859%2C272.545847%2053.4940452%2C272.605364%20C53.3661942%2C272.712274%2053.3353336%2C272.835716%2053.3882375%2C272.982304%20C53.4499587%2C273.154242%2053.5138842%2C273.325077%2053.5866271%2C273.491504%20C53.6549613%2C273.644705%2053.7750972%2C273.751615%2053.9371154%2C273.812234%20C54.6832808%2C274.094388%2055.428344%2C274.374338%2056.1723051%2C274.660901%20C56.4368245%2C274.7623%2056.7101613%2C274.854882%2056.9515354%2C274.997061%20C57.3615406%2C275.239537%2057.558828%2C275.640725%2057.6447969%2C276.079386%20C57.726357%2C276.492698%2057.7517068%2C276.915929%2057.8057129%2C277.33365%20C57.8167345%2C277.426232%2057.7748523%2C277.478033%2057.6999051%2C277.529835%20C57.3968098%2C277.73594%2057.0485259%2C277.843952%2056.694731%2C277.90898%20C56.1105838%2C278.014787%2055.522028%2C278.116187%2054.93237%2C278.162477%20C53.9437284%2C278.240731%2052.9506781%2C278.271592%2052.1879803%2C278.310167%20C51.1629673%2C278.277103%2050.3694088%2C278.27049%2049.5780547%2C278.220892%20Z%20M60.2238619%2C268.94728%20L60.3406913%2C268.834859%20C60.8432783%2C268.351009%2061.4395493%2C267.965251%2062.1151762%2C267.688608%20C62.790803%2C267.410862%2063.5325598%2C267.270888%2064.3195053%2C267.270888%20C65.0458317%2C267.270888%2065.731378%2C267.393228%2066.3563053%2C267.634602%20C66.9845391%2C267.875976%2067.5367235%2C268.213238%2067.9985304%2C268.634265%20C68.4603374%2C269.057496%2068.8295625%2C269.561185%2069.0951842%2C270.131005%20C69.3597036%2C270.70413%2069.4941677%2C271.321342%2069.4941677%2C271.969415%20C69.4941677%2C272.516089%2069.4247313%2C273.023084%2069.2858586%2C273.476074%20C69.1458837%2C273.933472%2068.9430854%2C274.332456%2068.6851789%2C274.663105%20C68.4250681%2C274.994857%2068.1076447%2C275.257172%2067.7406239%2C275.441233%20C67.3747053%2C275.624193%2066.9580871%2C275.716774%2066.501791%2C275.716774%20C66.2427824%2C275.716774%2066.0069191%2C275.64844%2065.8008144%2C275.513976%20C65.6321832%2C275.404862%2065.4800845%2C275.26158%2065.3478248%2C275.086336%20C65.0777944%2C275.338732%2064.813275%2C275.501852%2064.5619814%2C275.573493%20C63.955791%2C275.747635%2063.4377736%2C275.732205%2062.8646481%2C275.4754%20C62.5505312%2C275.334323%2062.2595597%2C275.132627%2061.9994489%2C274.878027%20C61.7393381%2C274.622325%2061.5211095%2C274.313719%2061.350274%2C273.962128%20C61.176132%2C273.605027%2061.0879589%2C273.206044%2061.0879589%2C272.776199%20C61.0879589%2C272.356275%2061.1706212%2C271.965006%2061.3359459%2C271.612314%20C61.5012706%2C271.259621%2061.718397%2C270.954321%2061.9829164%2C270.706334%20C62.2452316%2C270.455041%2062.5527355%2C270.259958%2062.8966108%2C270.122187%20C63.2382818%2C269.984417%2063.594281%2C269.91498%2063.949178%2C269.91498%20C64.3426507%2C269.91498%2064.6942412%2C269.992132%2064.9918256%2C270.145333%20C65.1979304%2C270.25114%2065.3676637%2C270.3834%2065.4999235%2C270.537703%20L65.5891988%2C270.034014%20L67.0220127%2C270.034014%20L67.0076845%2C270.157456%20L66.6120075%2C273.450724%20C66.5855555%2C273.654624%2066.5723295%2C273.862934%2066.5723295%2C274.073447%20C66.5723295%2C274.135168%2066.5855555%2C274.180357%2066.6131096%2C274.21232%20C66.6417659%2C274.248691%2066.6671157%2C274.254202%2066.6869547%2C274.254202%20C66.8655053%2C274.254202%2067.0275235%2C274.195787%2067.1818265%2C274.077856%20C67.3416404%2C273.955515%2067.4827174%2C273.789089%2067.6028534%2C273.580779%20C67.7251936%2C273.370266%2067.821082%2C273.125586%2067.8894162%2C272.855555%20C67.9577504%2C272.586627%2067.9919175%2C272.302269%2067.9919175%2C272.009093%20C67.9919175%2C271.525243%2067.8971313%2C271.078866%2067.7108655%2C270.679882%20C67.5245997%2C270.282001%2067.265591%2C269.939228%2066.9393503%2C269.66038%20C66.6120075%2C269.379328%2066.2207391%2C269.158895%2065.7787711%2C269.005695%20C65.3323945%2C268.851391%2064.8452377%2C268.773138%2064.3327312%2C268.773138%20C63.7397667%2C268.773138%2063.1864801%2C268.875639%2062.6871996%2C269.076233%20C62.1879191%2C269.276827%2061.7503597%2C269.55347%2061.3877476%2C269.89955%20C61.0251355%2C270.244527%2060.7374705%2C270.662248%2060.5313658%2C271.139485%20C60.3274653%2C271.620029%2060.2227597%2C272.139148%2060.2227597%2C272.683618%20C60.2227597%2C273.298625%2060.3362826%2C273.857423%2060.5578177%2C274.345682%20C60.7804549%2C274.830634%2061.0835502%2C275.245048%2061.4615926%2C275.576799%20C61.8418394%2C275.909653%2062.2915225%2C276.166457%2062.8007225%2C276.341702%20C63.3110247%2C276.518048%2063.862107%2C276.607323%2064.438539%2C276.607323%20C64.7824144%2C276.607323%2065.0855096%2C276.596302%2065.3423139%2C276.574258%20C65.5980161%2C276.553317%2065.8426966%2C276.512537%2066.0708447%2C276.45302%20C66.3011971%2C276.391299%2066.5205278%2C276.308637%2066.7233261%2C276.20834%20C66.9338395%2C276.105838%2067.1686006%2C275.970272%2067.4198941%2C275.804947%20L67.5190889%2C275.73992%20L68.3060344%2C277.156201%20L68.216759%2C277.212412%20C67.6733919%2C277.550776%2067.0958577%2C277.805376%2066.5028932%2C277.972905%20C65.9330741%2C278.129412%2065.1858066%2C278.21979%2064.451765%2C278.21979%20C63.5314576%2C278.21979%2062.6475217%2C278.067691%2061.9652818%2C277.789946%20C61.263203%2C277.503383%2060.6581147%2C277.107706%2060.164345%2C276.613936%20C59.6132627%2C276.063956%2059.2352203%2C275.311178%2059.0147874%2C274.775526%20C58.7469614%2C274.123044%2058.6113952%2C273.419863%2058.6113952%2C272.683618%20C58.6113952%2C271.855892%2058.9034688%2C270.898111%2059.1525579%2C270.329394%20C59.4203839%2C269.716591%2059.7752809%2C269.378226%2060.2238619%2C268.94728%20Z%20M72.1316474%2C268.389585%20L72.1316474%2C264.019502%20C72.1316474%2C263.579739%2071.5508067%2C263%2071.1121452%2C263%20L45.0206044%2C263%20C44.5808407%2C263%2044%2C263.579739%2044%2C264.019502%20L44%2C281.55494%20C44%2C281.994703%2044.5808407%2C282.574442%2045.0206044%2C282.574442%20L51.5377032%2C282.574442%20L51.5377032%2C287.027187%20C51.5377032%2C287.468053%2052.1174418%2C288.047791%2052.5583076%2C288.047791%20L78.9804978%2C287.938677%20C79.4202615%2C287.938677%2080%2C287.577167%2080%2C286.918072%20L80%2C269.382635%20C80%2C269.162202%2079.4202615%2C268.36203%2078.9804978%2C268.36203%20L72.1316474%2C268.389585%20Z%22%20transform%3D%22translate%28-44%20-263%29%22/%3E%0A%3C/svg%3E%0A')
	}

	.crm-lead-info-popup-btn-cloud .crm-lead-info-popup-btn-text:before {
		background-image: url('data:image/svg+xml;charset=US-ASCII,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20width%3D%2236%22%20height%3D%2225%22%20viewBox%3D%220%200%2036%2025%22%3E%0A%20%20%3Cg%20fill%3D%22%23535C6A%22%20fill-rule%3D%22evenodd%22%3E%0A%20%20%20%20%3Cpolygon%20points%3D%220%200%2036%200%2034%205%202%205%22/%3E%0A%20%20%20%20%3Cpolygon%20points%3D%225%2010%2032%2010%2030%2015%207%2015%22/%3E%0A%20%20%20%20%3Cpolygon%20points%3D%2210%2020%2027%2020%2025%2025%2012%2025%22/%3E%0A%20%20%3C/g%3E%0A%3C/svg%3E%0A');
	}

	.crm-lead-info-popup-btn-active.crm-lead-info-popup-btn-cloud .crm-lead-info-popup-btn-text:before {
		background-image: url('data:image/svg+xml;charset=US-ASCII,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20width%3D%2236%22%20height%3D%2225%22%20viewBox%3D%220%200%2036%2025%22%3E%0A%20%20%3Cg%20fill%3D%22%230b66c3%22%20fill-rule%3D%22evenodd%22%3E%0A%20%20%20%20%3Cpolygon%20points%3D%220%200%2036%200%2034%205%202%205%22/%3E%0A%20%20%20%20%3Cpolygon%20points%3D%225%2010%2032%2010%2030%2015%207%2015%22/%3E%0A%20%20%20%20%3Cpolygon%20points%3D%2210%2020%2027%2020%2025%2025%2012%2025%22/%3E%0A%20%20%3C/g%3E%0A%3C/svg%3E%0A');
	}

	.crm-lead-info-popup-btn-active .crm-lead-info-popup-btn-text:before {
		opacity: 1;
	}

	.crm-lead-info-popup-btn-active .crm-lead-info-popup-btn-text {
		color: #0b66c3;
	}

	.crm-lead-info-popup-btn-descript {
		color: #535c69;
		display: block;
		margin: 20px 0 0 0;
		font-size: 14px;
		font-weight: bold;
	}

	.crm-lead-info-popup-readmore {
		text-align: center;
		padding: 3px 0 6px 0;
	}

	.crm-lead-info-popup-readmore-link:hover,
	.crm-lead-info-popup-readmore-link {
		display: inline-block;
		font-size: 13px;
		text-decoration: none;
		border-bottom: 1px solid #1b70c7;
		color: #1b70c7;
		cursor: pointer;
	}

	.crm-lead-info-popup-deal-block {
		border-top: 1px solid #d7e0e4;
		padding-top: 16px; margin-top: 20px;
	}
	.crm-lead-info-popup-deal-link {
		color: #1b70c7;
		cursor: pointer;
		text-decoration: none;
	}
</style>

<div class="crm-lead-popup-container" id="leadFirstPopupHtml" style="/*display: none*/">
	<div class="crm-lead-popup-content">
		<div class="crm-lead-info-popup-cont-title"><?=$arResult["IS_LEAD_ENABLED"] ? GetMessage("CRM_TYPE_POPUP_TITLE") : GetMessage("CRM_TYPE_POPUP_TITLE_LEADS_DISABLED")?></div>
		<div class="crm-lead-info-popup-btn-wrap">
			<div class="crm-lead-info-popup-btn-wrap-half js-bx-lead-type-block" data-crm-type="simple">
				<span id="crm-lead-info-popup-btn-local" class="crm-lead-info-popup-btn crm-lead-info-popup-btn-local<?if (!$arResult["IS_LEAD_ENABLED"]):?> crm-lead-info-popup-btn-active<?endif?>">
					<span class="crm-lead-info-popup-btn-text"><?=GetMessage("CRM_TYPE_SIMPLE")?></span>
					<span class="crm-lead-info-popup-btn-descript"><?=GetMessage("CRM_TYPE_SIMPLE_DESC")?></span>
				</span>
				<span class="crm-lead-info-popup-btn-wrap-text"><?=GetMessage("CRM_TYPE_SIMPLE_DESC2")?></span>
			</div>
			<div class="crm-lead-info-popup-btn-wrap-half js-bx-lead-type-block" data-crm-type="classic">
				<span id="crm-lead-info-popup-btn-cloud" class="crm-lead-info-popup-btn crm-lead-info-popup-btn-cloud <?if ($arResult["IS_LEAD_ENABLED"]):?> crm-lead-info-popup-btn-active<?endif?>">
					<span class="crm-lead-info-popup-btn-text"><?=GetMessage("CRM_TYPE_CLASSIC")?></span>
					<span class="crm-lead-info-popup-btn-descript"><?=GetMessage("CRM_TYPE_CLASSIC_DESC")?></span>
				</span>
				<span class="crm-lead-info-popup-btn-wrap-text"><?=GetMessage("CRM_TYPE_CLASSIC_DESC2")?></span>
			</div>
		</div>
		<div class="crm-lead-info-popup-readmore">
			<a href="javascript:void(0)" class="crm-lead-info-popup-readmore-link" onclick="BX.Helper.show('redirect=detail&code=17611420');"><?=GetMessage("CRM_TYPE_MORE")?></a>
		</div>
		<div class="crm-lead-info-descript">
			<div class="crm-lead-info-descript-text"><?=GetMessage("CRM_TYPE_CHANGE")?></div>
			<img class="crm-lead-info-descript-img" src="<?=$this->GetFolder()?>/images/<?=$arResult["CURRENT_LANG"]?>.png" alt="">
			<?if (!$arResult["IS_CRM_ADMIN"]):?>
			<div class="crm-lead-info-descript-text crm-lead-info-descript-text-info"><?=GetMessage("CRM_RIGTHS_INFO")?></div>
			<?endif?>
		</div>
	</div>
	<?if ($arResult["IS_CRM_ADMIN"]):?>
	<div class="crm-lead-info-popup-deal-block">
		<?=GetMessage("CRM_DEAL_SETTINGS", array(
			"#LINK_START#" => "<span class=\"crm-lead-info-popup-deal-link js-bx-converter-config\">",
			"#LINK_END#" => "</span>")
		);?>
	</div>
	<?endif?>
</div>

<script>
	BX.message({
		"CRM_TYPE_TITLE" : "<?=GetMessage("CRM_TYPE_TITLE")?>",
		"CRM_TYPE_SAVE" : "<?=GetMessage("CRM_TYPE_SAVE")?>",
		"CRM_TYPE_CANCEL" : "<?=GetMessage("CRM_TYPE_CANCEL")?>"
	});
</script>
