<?php

if(!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED!==true)die();

use Bitrix\Crm\Component\EntityDetails\FactoryBased;
use Bitrix\Crm\Item;
use Bitrix\Crm\Service\EditorAdapter;
use Bitrix\Main\Loader;
use Bitrix\Main\Localization\Loc;
use Bitrix\Main\Web\Uri;

Loader::includeModule('crm');

class CrmSmartDocumentDetailsComponent extends FactoryBased
{
	public function getEditorEntityConfig(): array
	{
		$sections = [];

		$sectionMain = [
			'name' => 'main',
			'title' => Loc::getMessage('CRM_COMPONENT_FACTORYBASED_EDITOR_MAIN_SECTION_TITLE'),
			'type' => 'section',
			'elements' => [
				['name' => Item::FIELD_NAME_TITLE],
				['name' =>  Item\SmartB2eDocument::FIELD_NAME_NUMBER],
			],
		];

		$sections[] = $sectionMain;

		$elements = [
			['name' => Item::FIELD_NAME_MYCOMPANY_ID],
			['name' => Item::FIELD_NAME_ASSIGNED],
		];

		if ($this->getEntityTypeID() !== CCrmOwnerType::SmartB2eDocument)
		{
			$elements[] = ['name' => EditorAdapter::FIELD_CLIENT];
		}

		$sectionAdditional = [
			'name' => 'additional',
			'title' => Loc::getMessage('CRM_TYPE_ITEM_EDITOR_SECTION_ADDITIONAL'),
			'type' => 'section',
			'elements' => $elements,
		];

		$sections[] = $sectionAdditional;

		return $sections;
	}

	public function getInlineEditorEntityConfig(): array
	{
		$sections = [];
		$sections[] = [
			'name' => 'myCompany',
			'title' => Loc::getMessage('CRM_COMPONENTS_DOCUMENT_DETAILS_MY_COMPANY_SECTION_TITLE'),
			'type' => 'section',
			'elements' => [
				['name' => \Bitrix\Crm\Item::FIELD_NAME_MYCOMPANY_ID],
			],
		];
		if ($this->getEntityTypeID() === CCrmOwnerType::SmartB2eDocument)
		{
			return $sections;
		}

		$sections[] = [
			'name' => 'client',
			'title' => Loc::getMessage('CRM_COMPONENTS_DOCUMENT_DETAILS_CLIENT_SECTION_TITLE'),
			'type' => 'section',
			'elements' => [
				['name' => EditorAdapter::FIELD_CLIENT],
			],
		];

		return $sections;
	}

	public function executeComponent()
	{
		$this->init();

		if($this->getErrors())
		{
			$this->includeComponentTemplate();
			return;
		}

		$this->executeBaseLogic();

		$this->setBizprocStarterConfig();

		$this->includeComponentTemplate();
	}

	protected function getTabs(): array
	{
		$tabs = [];

		if ($this->arParams['ENTITY_TYPE_ID'] === \CCrmOwnerType::SmartB2eDocument)
		{
			$uri = '/bitrix/components/bitrix/sign.document.list/slider.php';

			$tabs[] = [
				'id' => 'tab_sign',
				'name' => \Bitrix\Main\Localization\Loc::getMessage('CRM_COMPONENTS_DOCUMENT_DETAILS_SIGN_PROCESS_BUTTON'),
				'slider' => [
					'uri' => $uri,
					'params' => [
						'site_id' => SITE_ID,
						'sessid' => bitrix_sessid_get(),
						'type' => 'document',
						'entity_id' => $this->arParams['ENTITY_ID'],
					],
					'sliderParams' => [
						'width' => 1000,
						'loader' => 'intranet:crm',
					]
				],
			];
			$tabs[] = $this->getDefaultTabInfoByCode(static::TAB_NAME_AUTOMATION);
			$tabs[] = $this->getDefaultTabInfoByCode(static::TAB_NAME_TREE);
			$tabs[] = $this->getDefaultTabInfoByCode(static::TAB_NAME_EVENT);
		}
		else
		{
			$tabs = parent::getTabs();
		}

		return $tabs;
	}

	protected function getEntityDetailsParams(): array
	{
		$detailParams =  parent::getEntityDetailsParams(); // TODO: Change the autogenerated stub
		if ($this->arParams['ENTITY_TYPE_ID'] === \CCrmOwnerType::SmartB2eDocument)
		{
			$detailParams['REST_USE'] = 'N';
		}

		return $detailParams;
	}
}
