BX.namespace("BX.Crm.Automation");if(!BX.Crm.Automation.Runtime)BX.Crm.Automation=function(t){"use strict";var e=function(e){if(!t.type.isDomNode(e))throw"baseNode must be Dom Node Element";this.node=e};e.ViewMode={View:1,Edit:2};e.LogStatus={Waiting:0,Running:1,Completed:2,AutoCompleted:3};e.idIncrement=0;e.generateUniqueId=function(){++e.idIncrement;return"crm-automation-cmp-"+e.idIncrement};e.prototype={init:function(i,a){var s=this;this.viewMode=a||e.ViewMode.View;if(typeof i==="undefined")i={};this.data=i;this.initData();this.initTracker();this.initTriggerManager();this.initTemplateManager();this.initButtons();this.initButtonsPosition();this.initHelpTips();this.setTitle();this.fixTitleColors();window.onbeforeunload=function(){if(s.templateManager.needSave()||s.triggerManager.needSave()){return t.message("CRM_AUTOMATION_CMP_NEED_SAVE")}};t.addCustomEvent("CrmProgressControlAfterSaveSucces",this.onStatusChange.bind(this));t.addCustomEvent("Crm.EntityProgress.Change",this.onEntityProgressChange.bind(this))},initData:function(){this.entityTypeId=this.data.ENTITY_TYPE_ID;this.entityId=this.data.ENTITY_ID;this.entityCategoryId=this.data.ENTITY_CATEGORY_ID;this.bizprocEditorUrl=this.data.BIZPROC_EDITOR_URL;this.entityStatuses=this.data.ENTITY_STATUSES;this.statusesSort=[];for(var e=0;e<this.entityStatuses.length;++e){this.statusesSort.push(this.entityStatuses[e]["STATUS_ID"])}this.setEntityStatus(this.data.ENTITY_STATUS);this.userOptions={};if(t.type.isPlainObject(this.data.USER_OPTIONS)){this.userOptions=this.data.USER_OPTIONS}this.frameMode=t.type.isBoolean(this.data.FRAME_MODE)?this.data.FRAME_MODE:false},setEntityStatus:function(t){this.entityStatus=t;this.currentStatusIndex=-1;for(var e=0;e<this.statusesSort.length;++e){if(this.statusesSort[e]==t){this.currentStatusIndex=e;break}}return this},isPreviousEntityStatus:function(t){var e=0;for(var i=0;i<this.statusesSort.length;++i){if(t==this.statusesSort[i])e=i}return this.currentStatusIndex>-1&&e<this.currentStatusIndex},isCurrentEntityStatus:function(t){return t==this.entityStatus},isNextEntityStatus:function(t){var e=0;for(var i=0;i<this.statusesSort.length;++i){if(t==this.statusesSort[i])e=i}return this.currentStatusIndex>-1&&e>this.currentStatusIndex},initTriggerManager:function(){this.triggerManager=new o(this);this.triggerManager.init(this.data,this.viewMode)},reInitTriggerManager:function(e){if(t.type.isArray(e))this.data.TRIGGERS=e;this.triggerManager.reInit(this.data,this.viewMode)},initTemplateManager:function(){this.templateManager=new i(this);this.templateManager.init(this.data,this.viewMode)},reInitTemplateManager:function(e){if(t.type.isArray(e))this.data.TEMPLATES=e;this.templateManager.reInit(this.data,this.viewMode)},initButtons:function(){var i=this.node.querySelector('[data-role="automation-buttons"]');if(i){if(this.viewMode===e.ViewMode.View){t.hide(i)}}this.bindSaveButton();this.bindCancelButton();this.bindChangeViewButton()},initButtonsPosition:function(){var e=this.node.querySelector('[data-role="automation-buttons"]');var i=t.create("span",{attrs:{className:"crm-lead-header-contact-btn crm-automation-pin-btn crm-lead-header-contact-btn-pin"},events:{click:function(){this.classList.toggle("crm-lead-header-contact-btn-unpin");e.classList.toggle("crm-automation-buttons-fixed")}}});if(e){e.appendChild(i);if(this.frameMode){t.addClass(e,"crm-automation-buttons-fixed-slider")}}},initHelpTips:function(){var t=this.node.querySelectorAll('[data-role="automation-help-tips"]');for(var e=0;e<t.length;++e){C.bindToNode(t[e])}},reInitButtons:function(){var i=this.node.querySelector('[data-role="automation-buttons"]');if(i&&this.viewMode===e.ViewMode.View){t.hide(i)}else if(i&&this.viewMode===e.ViewMode.Edit){t.show(i)}var a=this.node.querySelector('[data-role="automation-btn-change-view"]');if(a){a.innerHTML=a.getAttribute("data-label-"+(this.viewMode===e.ViewMode.View?"edit":"view"))}},setTitle:function(){var t=this.node.querySelector('[data-role="automation-title"]');if(t){t.innerHTML=t.getAttribute("data-title-"+(this.viewMode===e.ViewMode.View?"view":"edit"))}},fixTitleColors:function(){var t,e,i=this.node.querySelectorAll('[data-role="automation-status-title"]');for(t=0;t<i.length;++t){e=i[t].getAttribute("data-bgcolor");if(e){var a=parseInt(e,16);var s=a>>16&255;var o=a>>8&255;var n=a&255;var r=.21*s+.72*o+.07*n;if(r<145){i[t].style.color="white"}}}},initTracker:function(){this.tracker=new r(this);this.tracker.init(this.data.LOG)},bindSaveButton:function(){var e=this,i=this.node.querySelector('[data-role="automation-btn-save"]');if(i){t.bind(i,"click",function(t){t.preventDefault();e.saveAutomation()})}},bindCancelButton:function(){var i=this,a=this.node.querySelector('[data-role="automation-btn-cancel"]');if(a){t.bind(a,"click",function(t){t.preventDefault();i.changeViewMode(e.ViewMode.View,true)})}},bindChangeViewButton:function(){var i=this,a=this.node.querySelector('[data-role="automation-btn-change-view"]');if(a){a.innerHTML=a.getAttribute("data-label-"+(this.viewMode===e.ViewMode.View?"edit":"view"));t.bind(a,"click",function(t){t.preventDefault();var a=i.viewMode===e.ViewMode.Edit?e.ViewMode.View:e.ViewMode.Edit;i.changeViewMode(a)})}},getAjaxUrl:function(){return t.util.add_url_param(this.data.AJAX_URL,{site_id:t.message("SITE_ID"),sessid:t.bitrix_sessid()})},saveAutomation:function(i){var a=this,s={ajax_action:"save_automation",entity_type_id:this.entityTypeId,triggers:this.triggerManager.serialize(),templates:this.templateManager.serialize()};return t.ajax({method:"POST",dataType:"json",url:this.getAjaxUrl(),data:s,onsuccess:function(t){if(t.SUCCESS){a.reInitTemplateManager(t.DATA.templates);a.reInitTriggerManager(t.DATA.triggers);a.changeViewMode(e.ViewMode.View);if(i){i(t.DATA)}}else alert(t.ERRORS[0])}})},changeViewMode:function(i,a){if(!a&&(this.templateManager.needSave()||this.triggerManager.needSave())){alert(t.message("CRM_AUTOMATION_CMP_NEED_SAVE"));return}if(i!==e.ViewMode.View&&i!==e.ViewMode.Edit)throw"Unknown view mode";this.viewMode=i;this.reInitTriggerManager();this.reInitTemplateManager();this.reInitButtons();this.setTitle()},canEdit:function(){return this.data["CAN_EDIT"]},onStatusChange:function(t,e){if(e&&e["VALUE"]){this.setEntityStatus(e["VALUE"]);this.updateTracker()}},onEntityProgressChange:function(t,e){if(e.entityTypeId===this.entityTypeId&&e.entityId===this.entityId&&e.currentStepId){this.setEntityStatus(e.currentStepId);setTimeout(this.updateTracker.bind(this),300)}},updateTracker:function(){var i=this;t.ajax({method:"POST",dataType:"json",url:this.getAjaxUrl(),data:{ajax_action:"get_log",entity_type_id:this.entityTypeId,entity_id:this.entityId},onsuccess:function(t){if(t.DATA&&t.DATA.LOG){i.tracker.reInit(t.DATA.LOG);if(i.viewMode===e.ViewMode.View){i.templateManager.reInit()}}}})},onGlobalHelpClick:function(e){e.preventDefault();if(this.data["B24_TARIF_ZONE"]==="en"){window.open("https://helpdesk.bitrix24.com/open/4781101/")}else if(this.data["B24_TARIF_ZONE"]==="de"){window.open("https://helpdesk.bitrix24.de/open/4781105/")}else if(this.data["B24_TARIF_ZONE"]==="es"){window.open("https://helpdesk.bitrix24.es/open/5859003/")}else if(t.Helper&&t.Helper.frameOpenUrl.indexOf("//helpdesk.bitrix24.ru/")>0){t.Helper.show("redirect=detail&HD_ID=5265469")}else{window.open("https://helpdesk.bitrix24.ru/open/5265469/")}},getUserOption:function(t,e,i){var a=i;if(this.userOptions[t]&&this.userOptions[t][e]){a=this.userOptions[t][e]}return a},setUserOption:function(e,i,a){if(!t.type.isPlainObject(this.userOptions[e])){this.userOptions[e]={}}var s=this.userOptions[e][i];if(s!==a){this.userOptions[e][i]=a;t.userOptions.save("crm.automation",e,i,a,false)}return this}};var i=function(t){this.component=t};i.prototype={init:function(i,a){if(!t.type.isPlainObject(i))i={};this.viewMode=a||e.ViewMode.View;this.availableRobots=t.type.isArray(i.AVAILABLE_ROBOTS)?i.AVAILABLE_ROBOTS:[];this.availableRobotsMap={};for(var s=0;s<this.availableRobots.length;++s){this.availableRobotsMap[this.availableRobots[s]["CLASS"]]=this.availableRobots[s]}this.templatesData=t.type.isArray(i.TEMPLATES)?i.TEMPLATES:[];this.initTemplates()},reInit:function(i,a){if(!t.type.isPlainObject(i))i={};this.viewMode=a||e.ViewMode.View;if(t.type.isArray(i.TEMPLATES))this.templatesData=i.TEMPLATES;this.reInitTemplates(this.templatesData)},initTemplates:function(){this.templates=[];this.templatesMap={};for(var t=0;t<this.templatesData.length;++t){var e=new a(this);e.init(this.templatesData[t],this.viewMode);this.templates.push(e);this.templatesMap[e.getStatusId()]=e}},reInitTemplates:function(t){for(var e=0;e<this.templates.length;++e){if(t[e]){this.templates[e].reInit(t[e],this.viewMode)}}},getAvailableRobots:function(){return this.availableRobots},getRobotDescription:function(t){return this.availableRobotsMap[t]||null},serialize:function(){var t=[];for(var e=0;e<this.templates.length;++e){t.push(this.templates[e].serialize())}return t},getTemplateByColumnNode:function(t){var e=t.getAttribute("data-status-id");return this.getTemplateByStatusId(e)},getTemplateByStatusId:function(t){return this.templatesMap[t]||null},needSave:function(){var t=false;for(var e=0;e<this.templates.length;++e){if(this.templates[e].isModified()){t=true;break}}return t}};var a=function(t){this.manager=t;this.component=t.component;this.data={}};a.prototype={init:function(i,a){if(t.type.isPlainObject(i))this.data=i;this.viewMode=a||e.ViewMode.View;this.node=this.component.node.querySelector('[data-role="automation-template"][data-status-id="'+this.getStatusId()+'"]');this.listNode=this.node.querySelector('[data-role="robot-list"]');this.buttonsNode=this.node.querySelector('[data-role="buttons"]');this.initRobots();this.initButtons();this.modified=false;if(!this.isExternalModified()){jsDD.registerDest(this.node,10)}},reInit:function(e,i){t.cleanNode(this.listNode);t.cleanNode(this.buttonsNode);this.init(e,i)},initRobots:function(){this.robots=[];this.robotsMap={};if(t.type.isArray(this.data.ROBOTS)){for(var e=0;e<this.data.ROBOTS.length;++e){var i=new s(this);i.init(this.data.ROBOTS[e],this.viewMode);this.insertRobotNode(i.node);this.robots.push(i);this.robotsMap[i.getId()]=i}}},getStatusId:function(){return this.data.ENTITY_STATUS},getTemplateId:function(){var t=parseInt(this.data.TEMPLATE_ID);return!isNaN(t)?t:0},initButtons:function(){if(this.isExternalModified()){this.createExternalLocker()}else if(this.viewMode===e.ViewMode.Edit){if(!this.isExternalModified())this.createAddButton();if(this.getTemplateId()>0)this.createExternalEditTemplateButton()}if(this.viewMode===e.ViewMode.View&&this.component.canEdit()){this.createEditButton()}},createAddButton:function(){var e=this,i=t.create("a",{text:t.message("CRM_AUTOMATION_CMP_ADD"),props:{href:"#"},events:{click:function(t){t.preventDefault();e.onAddButtonClick(this)}},attrs:{className:"crm-automation-robot-btn-add"}});this.buttonsNode.appendChild(i)},createEditButton:function(){var i=this,a=t.create("a",{text:t.message("CRM_AUTOMATION_CMP_AUTOMATION_EDIT"),props:{href:"#"},events:{click:function(t){t.preventDefault();i.manager.component.changeViewMode(e.ViewMode.Edit)}},attrs:{className:"crm-automation-robot-btn-set"}});this.buttonsNode.appendChild(a)},createExternalEditTemplateButton:function(){var e=this,i=t.create("a",{text:t.message("CRM_AUTOMATION_CMP_EXTERNAL_EDIT"),props:{href:"#"},events:{click:function(t){t.preventDefault();e.onExternalEditTemplateButtonClick(this)}},attrs:{className:"crm-automation-robot-btn-set"}});if(!this.manager.component.bizprocEditorUrl.length){t.addClass(i,"crm-automation-robot-btn-set-locked")}this.buttonsNode.appendChild(i)},createExternalLocker:function(){var i=this,a=t.create("div",{attrs:{className:"crm-automation-robot-container"},children:[t.create("div",{attrs:{className:"crm-automation-robot-container-wrapper crm-automation-robot-container-wrapper-lock"},children:[t.create("div",{attrs:{className:"crm-automation-robot-deadline"}}),t.create("div",{attrs:{className:"crm-automation-robot-title"},text:t.message("CRM_AUTOMATION_CMP_EXTERNAL_EDIT_TEXT")})]})]});if(this.viewMode===e.ViewMode.Edit){var s=t.create("div",{attrs:{className:"crm-automation-robot-btn-settings"},text:t.message("CRM_AUTOMATION_CMP_EDIT")});t.bind(a,"click",function(t){i.onExternalEditTemplateButtonClick(this)});a.appendChild(s);t.addClass(a.firstChild,"crm-automation-robot-container-wrapper-border");var o=t.create("SPAN",{attrs:{className:"crm-automation-robot-btn-delete"}});t.bind(o,"click",function(t){t.stopPropagation();i.onUnsetExternalModifiedClick(this)});a.lastChild.appendChild(o)}this.listNode.appendChild(a)},onAddButtonClick:function(i){var a=this,s,o,n={employee:[],client:[],ads:[],other:[]};var r,l,d,p=this.manager.getAvailableRobots();var u=function(e,i){if(!i.isDemo){var s=t.clone(i.robotData);if(s["ROBOT_SETTINGS"]&&s["ROBOT_SETTINGS"]["TITLE_CATEGORY"]&&s["ROBOT_SETTINGS"]["TITLE_CATEGORY"][i.category]){s["NAME"]=s["ROBOT_SETTINGS"]["TITLE_CATEGORY"][i.category]}else if(s["ROBOT_SETTINGS"]&&s["ROBOT_SETTINGS"]["TITLE"]){s["NAME"]=s["ROBOT_SETTINGS"]["TITLE"]}a.addRobot(s,function(t){a.openRobotSettingsDialog(t,{ADD_MENU_CATEGORY:i.category})})}};for(s=0;s<p.length;++s){if(p[s]["EXCLUDED"])continue;l=t.type.isPlainObject(p[s]["ROBOT_SETTINGS"])?p[s]["ROBOT_SETTINGS"]:{};r=p[s].NAME;if(l["TITLE"])r=l["TITLE"];var c=l["IS_DEMO"];if(window.location.search.indexOf("disable_demo")>=0)c=false;if(c)r+=" "+t.message("CRM_AUTOMATION_CMP_IS_DEMO");d=[];if(l["CATEGORY"]){d=t.type.isArray(l["CATEGORY"])?l["CATEGORY"]:[l["CATEGORY"]]}if(!d.length){d.push("other")}for(o=0;o<d.length;++o){if(!n[d[o]])continue;n[d[o]].push({text:r,robotData:p[s],isDemo:c,category:d[o],className:c?"crm-automation-menu-item-disabled menu-popup-no-icon":"",onclick:u})}}if(n["other"].length>0){n["other"].push({delimiter:true})}n["other"].push({text:t.message("CRM_AUTOMATION_ROBOT_CATEGORY_OTHER_MARKETPLACE"),href:"/marketplace/category/crm_bots/",target:"_blank"});var h=i.getAttribute("data-menu-id");if(!h){h=e.generateUniqueId();i.setAttribute("data-menu-id",h)}t.PopupMenu.show(h,i,[{text:t.message("CRM_AUTOMATION_ROBOT_CATEGORY_EMPLOYEE"),items:n["employee"]},{text:t.message("CRM_AUTOMATION_ROBOT_CATEGORY_CLIENT"),items:n["client"]},{text:t.message("CRM_AUTOMATION_ROBOT_CATEGORY_ADS"),items:n["ads"]},{text:t.message("CRM_AUTOMATION_ROBOT_CATEGORY_OTHER"),items:n["other"]}],{autoHide:true,offsetLeft:t.pos(i)["width"]/2,angle:{position:"top",offset:0}})},onExternalEditTemplateButtonClick:function(e){if(!this.manager.component.bizprocEditorUrl.length){if(t.getClass("B24.licenseInfoPopup")){B24.licenseInfoPopup.show("crm_automation_designer",t.message("CRM_AUTOMATION_CMP_EXTERNAL_EDIT"),t.message("CRM_AUTOMATION_CMP_EXTERNAL_EDIT_LOCKED"))}return}var i=this.getTemplateId();if(i>0)this.openBizprocEditor(i)},onUnsetExternalModifiedClick:function(t){this.data["IS_EXTERNAL_MODIFIED"]=false;this.data["UNSET_EXTERNAL_MODIFIED"]=true;this.reInit(null,this.viewMode)},openBizprocEditor:function(t){var e=this.manager.component.bizprocEditorUrl.replace("#ID#",t);top.window.location.href=e},addRobot:function(t,e){var i=new s(this);var a={Type:t["CLASS"],Properties:{Title:t["NAME"]}};if(this.robots.length>0){var o=this.robots[this.robots.length-1];if(!o.delay.isNow()||o.isExecuteAfterPrevious()){a["Delay"]=o.delay.serialize();a["ExecuteAfterPrevious"]=1}}i.init(a,this.viewMode);i.draft=true;if(e)e(i)},insertRobot:function(t,e){if(e){for(var i=0;i<this.robots.length;++i){if(this.robots[i]!==e)continue;this.robots.splice(i,0,t);break}}else{this.robots.push(t)}this.modified=true},deleteRobot:function(t,e){for(var i=0;i<this.robots.length;++i){if(this.robots[i]===t){this.robots.splice(i,1);break}}if(e)e(t);this.modified=true},insertRobotNode:function(t,e){if(e){this.listNode.insertBefore(t,e)}else{this.listNode.appendChild(t)}},openRobotSettingsDialog:function(e,i){if(f.getRobotSettingsDialog())return;var a=this,s="crm_automation_robot_dialog";var o=t.create("form",{props:{name:s}});o.appendChild(a.renderDelaySettings(e));o.appendChild(a.renderConditionSettings(e));var n=t.create("div",{attrs:{className:"crm-automation-robot-help"},events:{click:t.delegate(this.component.onGlobalHelpClick,this.component)}});o.appendChild(n);if(!t.type.isPlainObject(i))i={};i["ENTITY_TYPE_ID"]=this.manager.component.entityTypeId;i["ENTITY_CATEGORY_ID"]=this.manager.component.entityCategoryId;i["TEMPLATE_STATUS"]=this.getStatusId();f.setRobotSettingsDialog({template:this,entityTypeId:this.data.ENTITY_TYPE_ID,entityStatus:this.data.ENTITY_STATUS,context:i,robot:e,sendAjaxRequest:this.getRobotAjaxResponse,form:o});t.ajax({method:"POST",dataType:"html",url:this.manager.component.getAjaxUrl(),data:{ajax_action:"get_robot_dialog",entity_type_id:this.data.ENTITY_TYPE_ID,document_status:this.data.ENTITY_STATUS,context:i,robot:e.serialize(),form_name:s},onsuccess:function(i){if(i){var s=t.create("div",{html:i});o.appendChild(s)}a.showRobotSettingsPopup(e,o)}})},getRobotAjaxResponse:function(e,i){if(!t.type.isPlainObject(e))e={};e.ajax_action="get_robot_ajax_response";e.entity_type_id=this.entityTypeId;e.document_status=this.entityStatus;e.context=this.context;e.robot=this.robot.serialize();t.ajax({method:"POST",dataType:"json",url:this.template.manager.component.getAjaxUrl(),data:e,onsuccess:function(e){if(t.type.isFunction(i))i(e["DATA"])}})},showRobotSettingsPopup:function(i,a){t.addClass(this.component.node,"automation-base-blocked");this.initRobotSettingsControls(i,a);var s=parseInt(this.component.getUserOption("defaults","robot_settings_popup_width",580));var o=580;if(i.data.Type==="CrmSendEmailActivity"){o+=124;if(s<o){s=o}}var n=this,r=new t.PopupWindow(e.generateUniqueId(),null,{titleBar:i.getProperty("Title"),content:a,closeIcon:true,width:s,resizable:{minWidth:o,minHeight:100},offsetLeft:0,offsetTop:0,closeByEsc:true,draggable:{restrict:false},overlay:false,events:{onPopupClose:function(e){n.currentRobot=null;f.setRobotSettingsDialog(null);n.destroyRobotSettingsControls();e.destroy();t.removeClass(n.component.node,"automation-base-blocked")},onPopupResize:function(){n.onResizeRobotSettings()},onPopupResizeEnd:function(){n.component.setUserOption("defaults","robot_settings_popup_width",this.getWidth())}},buttons:[new t.PopupWindowButton({text:t.message("JS_CORE_WINDOW_SAVE"),className:"popup-window-button-accept",events:{click:function(){n.saveRobotSettings(a,i,t.delegate(function(){this.popupWindow.close()},this))}}}),new t.PopupWindowButtonLink({text:t.message("JS_CORE_WINDOW_CANCEL"),className:"popup-window-button-link-cancel",events:{click:function(){this.popupWindow.close()}}})]});n.currentRobot=i;f.getRobotSettingsDialog().popup=r;r.show()},initRobotSettingsControls:function(e,i){if(!t.type.isArray(this.robotSettingsControls))this.robotSettingsControls=[];var a,s=i.querySelectorAll('[data-role="user-selector"]');for(a=0;a<s.length;++a){this.robotSettingsControls.push(new l(this.manager.component,s[a]))}var o=i.querySelectorAll('[data-role="file-selector"]');for(a=0;a<o.length;++a){this.robotSettingsControls.push(new d(this.manager.component,o[a]))}var n=i.querySelectorAll('[data-role="inline-selector-target"]');for(a=0;a<n.length;++a){this.robotSettingsControls.push(new p(this.manager.component,n[a]))}var r=i.querySelectorAll('[data-role="inline-selector-html"]');for(a=0;a<r.length;++a){this.robotSettingsControls.push(new u(this.manager.component,r[a]))}var m=i.querySelectorAll('[data-role="time-selector"]');for(a=0;a<m.length;++a){this.robotSettingsControls.push(new c(m[a]))}var f=i.querySelectorAll('[data-role="save-state-checkbox"]');for(a=0;a<f.length;++a){this.robotSettingsControls.push(new h(f[a],e))}var g=i.querySelectorAll('[data-role="automation-help-tip"]');for(a=0;a<g.length;++a){C.bindToNode(g[a])}},destroyRobotSettingsControls:function(){if(t.type.isArray(this.robotSettingsControls)){for(var e=0;e<this.robotSettingsControls.length;++e){if(t.type.isFunction(this.robotSettingsControls[e].destroy))this.robotSettingsControls[e].destroy()}}this.robotSettingsControls=null},onBeforeSaveRobotSettings:function(){if(t.type.isArray(this.robotSettingsControls)){for(var e=0;e<this.robotSettingsControls.length;++e){if(t.type.isFunction(this.robotSettingsControls[e].onBeforeSave))this.robotSettingsControls[e].onBeforeSave()}}},onResizeRobotSettings:function(){if(t.type.isArray(this.robotSettingsControls)){for(var e=0;e<this.robotSettingsControls.length;++e){if(t.type.isFunction(this.robotSettingsControls[e].onPopupResize))this.robotSettingsControls[e].onPopupResize()}}},renderDelaySettings:function(i){var a=t.clone(i.getDelayInterval());var s=i.isExecuteAfterPrevious();var o=e.generateUniqueId();var n=t.create("input",{attrs:{type:"checkbox",id:"param-group-3-1"+o,name:"execute_after_previous",value:"1",style:"vertical-align: middle"}});var r=t.create("input",{attrs:{type:"hidden",name:"delay_type",value:a.type}});var l=t.create("input",{attrs:{type:"hidden",name:"delay_value",value:a.value}});var d=t.create("input",{attrs:{type:"hidden",name:"delay_value_type",value:a.valueType}});var p=t.create("input",{attrs:{type:"hidden",name:"delay_basis",value:a.basis}});var u=t.create("input",{attrs:{type:"hidden",name:"delay_worktime",value:a.workTime?1:0}});if(s){n.setAttribute("checked","checked")}var c=t.create("span",{attrs:{className:"crm-automation-popup-settings-link crm-automation-delay-interval-basis"}});var h=[];if(t.type.isArray(this.component.data["ENTITY_FIELDS"])){var f,g;for(f=0;f<this.component.data["ENTITY_FIELDS"].length;++f){g=this.component.data["ENTITY_FIELDS"][f];if(g["Type"]=="date"||g["Type"]=="datetime"||g["Type"]=="UF:date")h.push(g)}}var T=new m({labelNode:c,onchange:function(t){r.value=t.type;l.value=t.value;d.value=t.valueType;p.value=t.basis;u.value=t.workTime?1:0},basisFields:h});var v=t.create("div",{attrs:{className:"crm-automation-popup-settings crm-automation-popup-settings-flex"},children:[t.create("div",{attrs:{className:"crm-automation-popup-settings-block crm-automation-popup-settings-block-flex"},children:[t.create("span",{attrs:{className:"crm-automation-popup-settings-title-wrapper"},children:[r,l,d,p,u,t.create("span",{attrs:{className:"crm-automation-popup-settings-title crm-automation-popup-settings-title-left"},text:t.message("CRM_AUTOMATION_CMP_TO_EXECUTE")+":"}),c]})]}),t.create("div",{attrs:{className:"crm-automation-popup-settings-block"},children:[n,t.create("label",{attrs:{for:"param-group-3-1"+o,style:"color: #535C69"},text:t.message("CRM_AUTOMATION_CMP_AFTER_PREVIOUS_WIDE")})]})]});T.init(a);return v},setDelaySettingsFromForm:function(t,e){var i=new g;i.setType(t["delay_type"]);i.setValue(t["delay_value"]);i.setValueType(t["delay_value_type"]);i.setBasis(t["delay_basis"]);i.setWorkTime(t["delay_worktime"]==="1");var a=t["execute_after_previous"]&&t["execute_after_previous"]==="1";e.setDelayInterval(i);e.setExecuteAfterPrevious(a);return this},renderConditionSettings:function(e){var i=t.clone(e.getCondition());var a=new _(i,{fields:this.component.data["ENTITY_FIELDS"]});return t.create("div",{attrs:{className:"crm-automation-popup-settings"},children:[t.create("div",{attrs:{className:"crm-automation-popup-settings-block"},children:[t.create("span",{attrs:{className:"crm-automation-popup-settings-title"},text:t.message("CRM_AUTOMATION_ROBOT_CONDITION")+":"}),a.createNode()]})]})},setConditionSettingsFromForm:function(e,i){var a,s=new v;if(t.type.isArray(e["condition_field"])){for(a=0;a<e["condition_field"].length;++a){if(e["condition_field"][a]===""){continue}var o=new T;o.setField(e["condition_field"][a]);o.setOperator(e["condition_operator"][a]);o.setValue(e["condition_value"][a]);var n=v.Joiner.And;if(e["condition_joiner"]&&e["condition_joiner"][a]===v.Joiner.Or){n=v.Joiner.Or}s.addItem(o,n)}}i.setCondition(s);return this},saveRobotSettings:function(e,i,a){this.onBeforeSaveRobotSettings();var s=this,o=t.ajax.prepareForm(e);t.ajax({method:"POST",dataType:"json",url:this.manager.component.getAjaxUrl(),data:{ajax_action:"save_robot_settings",entity_type_id:this.data.ENTITY_TYPE_ID,robot:i.serialize(),form_data:o["data"]},onsuccess:function(t){if(t.SUCCESS){i.updateData(t.DATA.robot);s.setDelaySettingsFromForm(o["data"],i);s.setConditionSettingsFromForm(o["data"],i);if(i.draft){s.robots.push(i);s.insertRobotNode(i.node)}delete i.draft;i.reInit();s.modified=true;if(a){a(t.DATA)}}else alert(t.ERRORS[0])}})},serialize:function(){var t=this.data;t["ROBOTS"]=[];for(var e=0;e<this.robots.length;++e){t["ROBOTS"].push(this.robots[e].serialize())}return t},isExternalModified:function(){return this.data["IS_EXTERNAL_MODIFIED"]===true},getRobotById:function(t){return this.robotsMap[t]||null},isModified:function(){return this.modified}};var s=function(t){this.template=t;this.templateManager=t.manager;this.component=this.templateManager.component;this.tracker=t.manager.component.tracker};s.generateName=function(){return"A"+parseInt(Math.random()*1e5)+"_"+parseInt(Math.random()*1e5)+"_"+parseInt(Math.random()*1e5)+"_"+parseInt(Math.random()*1e5)};s.prototype={init:function(t,i){if(t)this.data=t;if(!this.data.Name){this.data.Name=s.generateName()}this.delay=new g(this.data.Delay);this.condition=new v(this.data.Condition);this.viewMode=i||e.ViewMode.View;this.node=this.createNode()},reInit:function(t,e){var i=this.node;this.node=this.createNode();if(i.parentNode)i.parentNode.replaceChild(this.node,i)},getProperty:function(t){return this.data.Properties[t]||null},setProperty:function(t,e){this.data.Properties[t]=e;return this},getId:function(){return this.data.Name||null},getLogStatus:function(){var t=e.LogStatus.Waiting;var i=this.tracker.getRobotLog(this.getId());if(i){t=parseInt(i["STATUS"])}else if(this.data.DelayName){i=this.tracker.getRobotLog(this.data.DelayName);if(i&&parseInt(i["STATUS"])>e.LogStatus.Waiting)t=e.LogStatus.Running}return t},getLogErrors:function(){var t=[],e=this.tracker.getRobotLog(this.getId());if(e&&e.ERRORS){t=e.ERRORS}return t},createNode:function(){var i=this,a=this.getLogStatus(),s;var o=this.getDescriptionSettings();var n="crm-automation-robot-container-wrapper";if(this.viewMode===e.ViewMode.Edit){n+=" crm-automation-robot-container-wrapper-draggable"}var r=t.message("CRM_AUTOMATION_CMP_TO");var l=t.create("a",{attrs:{className:"crm-automation-robot-settings-name",title:t.message("CRM_AUTOMATION_CMP_AUTOMATICALLY")}});if(o["IS_AUTO"]){l.textContent=t.message("CRM_AUTOMATION_CMP_AUTOMATICALLY")}else if(t.type.isPlainObject(this.data.viewData)){var d=this.data.viewData.responsibleLabel.replace("{=Document:ASSIGNED_BY_ID}",t.message("CRM_AUTOMATION_CMP_RESPONSIBLE")).replace("author",t.message("CRM_AUTOMATION_CMP_RESPONSIBLE"));if(d.indexOf("{=Document")>=0&&t.type.isArray(this.component.data["ENTITY_FIELDS"])){var p,u;for(p=0;p<this.component.data["ENTITY_FIELDS"].length;++p){u=this.component.data["ENTITY_FIELDS"][p];d=d.replace(u["SystemExpression"],u["Name"])}}l.textContent=d;l.setAttribute("title",d);if(this.data.viewData.responsibleUrl){l.href=this.data.viewData.responsibleUrl;if(this.component.frameMode){l.setAttribute("target","_blank")}}if(parseInt(this.data.viewData.responsibleId)>0){t.tooltip(this.data.viewData.responsibleId,l)}}var c=b(this.getDelayInterval(),t.message("CRM_AUTOMATION_CMP_AT_ONCE"),this.component.data["ENTITY_FIELDS"]);if(this.isExecuteAfterPrevious()){c=c!==t.message("CRM_AUTOMATION_CMP_AT_ONCE")?c+", ":"";c+=t.message("CRM_AUTOMATION_CMP_AFTER_PREVIOUS")}if(this.getCondition().items.length>0){c+=", "+t.message("CRM_AUTOMATION_CMP_BY_CONDITION")}var h;if(this.viewMode===e.ViewMode.Edit){h=t.create("a",{attrs:{className:"crm-automation-robot-link",title:c},text:c})}else{h=t.create("span",{attrs:{className:"crm-automation-robot-text"},text:c})}if(this.viewMode===e.ViewMode.View){switch(a){case e.LogStatus.Running:if(this.component.isCurrentEntityStatus(this.template.getStatusId())){s=t.create("div",{attrs:{className:"crm-automation-robot-loader"}})}break;case e.LogStatus.Completed:case e.LogStatus.AutoCompleted:n+=" crm-automation-robot-container-wrapper-complete";break}var m=this.getLogErrors();if(m.length>0){s=t.create("div",{attrs:{className:"crm-automation-robot-errors","data-text":m.join("\n")}});C.bindToNode(s)}}var f="crm-automation-robot-title-text";if(this.viewMode===e.ViewMode.Edit){f+=" crm-automation-robot-title-text-editable"}var g=t.create("div",{attrs:{className:"crm-automation-robot-container","data-role":"robot-container","data-type":"item-robot","data-id":this.getId()},children:[t.create("div",{attrs:{className:n},children:[t.create("div",{attrs:{className:"crm-automation-robot-deadline"},children:[h]}),t.create("div",{attrs:{className:"crm-automation-robot-title"},children:[t.create("div",{attrs:{className:f},html:this.clipTitle(this.getProperty("Title")),events:{click:this.viewMode===e.ViewMode.Edit?this.onTitleEditClick.bind(this):null}})]}),t.create("div",{attrs:{className:"crm-automation-robot-settings"},children:[t.create("div",{attrs:{className:"crm-automation-robot-settings-title"},text:r+":"}),l]}),s]})]});if(this.viewMode===e.ViewMode.Edit){this.registerItem(g);var T=t.create("SPAN",{attrs:{className:"crm-automation-robot-btn-delete"}});t.bind(T,"click",function(t){t.preventDefault();t.stopPropagation();i.onDeleteButtonClick(this)});g.lastChild.appendChild(T);var v=t.create("div",{attrs:{className:"crm-automation-robot-btn-settings"},text:t.message("CRM_AUTOMATION_CMP_EDIT")});t.bind(g,"click",function(t){i.onSettingsButtonClick(this)});g.appendChild(v);t.addClass(g.firstChild,"crm-automation-robot-container-wrapper-border")}return g},onDeleteButtonClick:function(e){t.remove(this.node);this.template.deleteRobot(this)},onSettingsButtonClick:function(t){this.template.openRobotSettingsDialog(this)},onTitleEditClick:function(i){i.preventDefault();i.stopPropagation();var a=this,s="crm_automation_robot_title_dialog";var o=t.create("form",{props:{name:s},style:{"min-width":"540px"}});var n=this.getProperty("Title");o.appendChild(t.create("span",{attrs:{className:"crm-automation-popup-settings-title crm-automation-popup-settings-title-autocomplete"},text:t.message("CRM_AUTOMATION_CMP_ROBOT_NAME")+":"}));o.appendChild(t.create("div",{attrs:{className:"crm-automation-popup-settings"},children:[t.create("input",{attrs:{className:"crm-automation-popup-input",type:"text",name:"name",value:n}})]}));t.addClass(this.component.node,"automation-base-blocked");var r=new t.PopupWindow(e.generateUniqueId(),null,{titleBar:t.message("CRM_AUTOMATION_CMP_ROBOT_NAME"),content:o,closeIcon:true,zIndex:-100,offsetLeft:0,offsetTop:0,closeByEsc:true,draggable:{restrict:false},overlay:false,events:{onPopupClose:function(e){e.destroy();t.removeClass(a.component.node,"automation-base-blocked")}},buttons:[new t.PopupWindowButton({text:t.message("JS_CORE_WINDOW_SAVE"),className:"popup-window-button-accept",events:{click:function(){var t=o.elements.name;a.setProperty("Title",t.value);a.reInit();a.template.modified=true;this.popupWindow.close()}}}),new t.PopupWindowButtonLink({text:t.message("JS_CORE_WINDOW_CANCEL"),className:"popup-window-button-link-cancel",events:{click:function(){this.popupWindow.close()}}})]});r.show()},clipTitle:function(t){var e=t;var i=e.split(" ");var a="<span>"+i[i.length-1]+"</span>";i.splice(i.length-1);e=i.join(" ")+" "+a;return e},updateData:function(e){if(t.type.isPlainObject(e)){this.data=e}else throw"Invalid data"},serialize:function(){var e=t.clone(this.data);var i=function(e){for(var a in e){if(e.hasOwnProperty(a)){if(typeof e[a]==="boolean"){e[a]=e[a]?1:0}else if(e[a]===null){e[a]=""}else if(t.type.isPlainObject(e[a])){i(e[a])}}}};if(t.type.isPlainObject(e.Properties)){i(e.Properties)}e.Delay=this.delay.serialize();e.Condition=this.condition.serialize();return e},getDelayInterval:function(){return this.delay},setDelayInterval:function(t){this.delay=t;return this},getCondition:function(){return this.condition},setCondition:function(t){this.condition=t;return this},setExecuteAfterPrevious:function(t){this.data.ExecuteAfterPrevious=t?1:0;return this},isExecuteAfterPrevious:function(){return this.data.ExecuteAfterPrevious===1},registerItem:function(e){e.onbxdragstart=t.proxy(this.dragStart,this);e.onbxdrag=t.proxy(this.dragMove,this);e.onbxdragstop=t.proxy(this.dragStop,this);e.onbxdraghover=t.proxy(this.dragOver,this);jsDD.registerObject(e);jsDD.registerDest(e,1)},dragStart:function(){this.draggableItem=t.proxy_context;this.draggableItem.className="crm-automation-robot-container";if(!this.draggableItem){jsDD.stopCurrentDrag();return}if(!this.stub){var e=this.draggableItem.offsetWidth;this.stub=this.draggableItem.cloneNode(true);this.stub.style.position="absolute";this.stub.className="crm-automation-robot-container crm-automation-robot-container-drag";this.stub.style.width=e+"px";document.body.appendChild(this.stub)}},dragMove:function(t,e){this.stub.style.left=t+"px";this.stub.style.top=e+"px"},dragOver:function(t,e,i){if(this.droppableItem){this.droppableItem.className="crm-automation-robot-container"}if(this.droppableColumn){this.droppableColumn.className="crm-automation-robot-list"}var a=t.getAttribute("data-type");if(a==="item-robot"){this.droppableItem=t;this.droppableColumn=null}if(a==="column-robot"){this.droppableColumn=t.children[0];this.droppableItem=null}if(this.droppableItem){this.droppableItem.className="crm-automation-robot-container crm-automation-robot-container-pre"}if(this.droppableColumn){this.droppableColumn.className="crm-automation-robot-list crm-automation-robot-list-pre"}},dragStop:function(){var t=window.event.ctrlKey;var e,i;if(this.draggableItem){if(this.droppableItem){this.droppableItem.className="crm-automation-robot-container";e=this.templateManager.getTemplateByColumnNode(this.droppableItem.parentNode);if(e){i=e.getRobotById(this.droppableItem.getAttribute("data-id"));if(t){this.copyTo(e,i)}else if(this!==i)this.moveTo(e,i)}}else if(this.droppableColumn){this.droppableColumn.className="crm-automation-robot-list";e=this.templateManager.getTemplateByColumnNode(this.droppableColumn);if(e){t?this.copyTo(e):this.moveTo(e)}}}this.stub.parentNode.removeChild(this.stub);this.stub=null;this.draggableItem=null;this.droppableItem=null},moveTo:function(e,i){t.remove(this.node);this.template.deleteRobot(this);this.template=e;this.template.insertRobot(this,i);this.node=this.createNode();this.template.insertRobotNode(this.node,i?i.node:null)},copyTo:function(t,e){var i=new s(t);var a=this.serialize();delete a["Name"];i.init(a,this.viewMode);t.insertRobot(i,e);t.insertRobotNode(i.node,e?e.node:null)},getDescriptionSettings:function(){var t={};var e=this.templateManager.getRobotDescription(this.data["Type"]);if(e&&e["ROBOT_SETTINGS"]){t=e["ROBOT_SETTINGS"]}return t}};var o=function(t){this.component=t};o.prototype={init:function(i,a){if(!t.type.isPlainObject(i))i={};this.viewMode=a||e.ViewMode.View;this.availableTriggers=t.type.isArray(i.AVAILABLE_TRIGGERS)?i.AVAILABLE_TRIGGERS:[];this.triggersData=t.type.isArray(i.TRIGGERS)?i.TRIGGERS:[];this.columnNodes=document.querySelectorAll('[data-type="column-trigger"]');this.listNodes=this.component.node.querySelectorAll('[data-role="trigger-list"]');this.buttonsNodes=this.component.node.querySelectorAll('[data-role="trigger-buttons"]');this.initButtons();this.initTriggers();this.modified=false;for(var s=0;s<this.columnNodes.length;s++){jsDD.registerDest(this.columnNodes[s],10)}top.BX.addCustomEvent(top,"Rest:AppLayout:ApplicationInstall",this.onRestAppInstall.bind(this))},reInit:function(i,a){if(!t.type.isPlainObject(i))i={};var s;this.viewMode=a||e.ViewMode.View;for(s=0;s<this.listNodes.length;++s){t.cleanNode(this.listNodes[s])}for(s=0;s<this.buttonsNodes.length;++s){t.cleanNode(this.buttonsNodes[s])}this.triggersData=t.type.isArray(i.TRIGGERS)?i.TRIGGERS:[];this.initTriggers();this.initButtons();this.modified=false},initTriggers:function(){this.triggers=[];for(var t=0;t<this.triggersData.length;++t){var e=new n(this);e.init(this.triggersData[t],this.viewMode);this.insertTriggerNode(e.getStatusId(),e.node);this.triggers.push(e)}},initButtons:function(){if(this.viewMode===e.ViewMode.Edit){for(var t=0;t<this.buttonsNodes.length;++t){this.createAddButton(this.buttonsNodes[t])}}},createAddButton:function(e){var i=this,a=t.create("a",{text:t.message("CRM_AUTOMATION_CMP_ADD"),props:{href:"#"},events:{click:function(t){t.preventDefault();i.onAddButtonClick(this)}},attrs:{className:"crm-automation-btn-add","data-status-id":e.getAttribute("data-status-id")}});e.appendChild(a)},onAddButtonClick:function(i){var a=this,s,o=[];var n=function(t,e){a.addTrigger(e.triggerData,function(t){a.openTriggerSettingsDialog(t)});this.popupWindow.close()};for(s=0;s<this.availableTriggers.length;++s){if(this.availableTriggers[s].CODE==="APP"){o.push(this.createAppTriggerMenuItem(i.getAttribute("data-status-id"),this.availableTriggers[s]));continue}o.push({text:this.availableTriggers[s].NAME,triggerData:{ENTITY_STATUS:i.getAttribute("data-status-id"),CODE:this.availableTriggers[s].CODE},onclick:n})}t.PopupMenu.show(e.generateUniqueId(),i,o,{autoHide:true,offsetLeft:t.pos(i)["width"]/2,angle:{position:"top",offset:0},events:{onPopupClose:function(){this.destroy()}}})},createAppTriggerMenuItem:function(e,i){var a=this,s=[];var o=function(t,e){a.addTrigger(e.triggerData,function(t){a.openTriggerSettingsDialog(t)});this.popupWindow.close()};for(var n=0;n<i["APP_LIST"].length;++n){var r=i["APP_LIST"][n];var l="["+r["APP_NAME"]+"] "+r["NAME"];s.push({text:t.util.htmlspecialchars(l),triggerData:{ENTITY_STATUS:e,NAME:l,CODE:i.CODE,APPLY_RULES:{APP_ID:r["APP_ID"],CODE:r["CODE"]}},onclick:o})}if(t.getClass("BX.rest.Marketplace")){if(s.length)s.push({delimiter:true});s.push({text:t.message("CRM_AUTOMATION_ROBOT_CATEGORY_OTHER_MARKETPLACE"),onclick:function(){t.rest.Marketplace.open({PLACEMENT:"CRM_ROBOT_TRIGGERS"})}})}return{text:i.NAME,items:s}},addTrigger:function(t,e){var i=new n(this);i.init(t,this.viewMode);i.draft=true;if(e)e(i)},deleteTrigger:function(t,e){if(t.getId()>0){t.markDeleted()}else{for(var i=0;i<this.triggers.length;++i){if(this.triggers[i]===t)this.triggers.splice(i,1)}}if(e)e(t);this.modified=true},insertTriggerNode:function(t,e){var i=this.component.node.querySelector('[data-role="trigger-list"][data-status-id="'+t+'"]');i.appendChild(e)},serialize:function(){var t=[];for(var e=0;e<this.triggers.length;++e){t.push(this.triggers[e].serialize())}return t},getTriggerName:function(t){for(var e=0;e<this.availableTriggers.length;++e){if(t==this.availableTriggers[e]["CODE"])return this.availableTriggers[e]["NAME"]}return t},needSave:function(){return this.modified},openTriggerSettingsDialog:function(i){var a=this,s="crm_automation_trigger_dialog";var o=t.create("form",{props:{name:s},style:{"min-width":"540px"}});o.appendChild(a.renderConditionSettings(i));var n=t.create("div",{attrs:{className:"crm-automation-robot-help"},events:{click:t.delegate(this.component.onGlobalHelpClick,this.component)}});o.appendChild(n);var r=this.getTriggerName(i.data["CODE"]);o.appendChild(t.create("span",{attrs:{className:"crm-automation-popup-settings-title crm-automation-popup-settings-title-autocomplete"},text:t.message("CRM_AUTOMATION_CMP_TRIGGER_NAME")+":"}));o.appendChild(t.create("div",{attrs:{className:"crm-automation-popup-settings"},children:[t.create("input",{attrs:{className:"crm-automation-popup-input",type:"text",name:"name",value:i.data["NAME"]||r}})]}));if(i.data["CODE"]=="WEBHOOK"){if(!t.type.isPlainObject(i.data["APPLY_RULES"]))i.data["APPLY_RULES"]={};if(!i.data["APPLY_RULES"]["code"])i.data["APPLY_RULES"]["code"]=t.util.getRandomString(5);o.appendChild(t.create("span",{attrs:{className:"crm-automation-popup-settings-title crm-automation-popup-settings-title-autocomplete"},text:"URL:"}));o.appendChild(t.create("input",{props:{type:"hidden",value:i.data["APPLY_RULES"]["code"],name:"code"}}));var l=t.create("textarea",{attrs:{className:"crm-automation-popup-textarea",placeholder:"...",readonly:"readonly",name:"webhook_handler"},events:{click:function(t){this.select()}}});o.appendChild(t.create("div",{attrs:{className:"crm-automation-popup-settings"},children:[l]}));o.appendChild(t.create("span",{attrs:{className:"crm-automation-popup-settings-title crm-automation-popup-settings-title-autocomplete"},text:t.message("CRM_AUTOMATION_CMP_WEBHOOK_ID")}));t.ajax({method:"POST",dataType:"json",url:this.component.getAjaxUrl(),data:{ajax_action:"get_webhook_handler",entity_type_id:this.component.entityTypeId},onsuccess:function(e){if(e["DATA"]["HANDLER"]){var a=window.location.protocol+"//"+window.location.host+e["DATA"]["HANDLER"];a=t.util.add_url_param(a,{code:i.data["APPLY_RULES"]["code"]});l.value=a}}})}else if(i.data["CODE"]=="WEBFORM"){t.ajax({method:"POST",dataType:"json",url:this.component.getAjaxUrl(),data:{ajax_action:"get_webform_forms"},onsuccess:function(e){if(e["DATA"]["forms"]){var a=t.create("select",{attrs:{className:"crm-automation-popup-settings-dropdown"},props:{name:"form_id",value:""},children:[t.create("option",{props:{value:""},text:t.message("CRM_AUTOMATION_TRIGGER_WEBFORM_ANY")})]});for(var s=0;s<e["DATA"]["forms"].length;++s){var n=e["DATA"]["forms"][s];a.appendChild(t.create("option",{props:{value:n["ID"]},text:n["NAME"]}))}if(t.type.isPlainObject(i.data["APPLY_RULES"])&&i.data["APPLY_RULES"]["form_id"]){a.value=i.data["APPLY_RULES"]["form_id"]}var r=t.create("div",{attrs:{className:"crm-automation-popup-settings"},children:[t.create("span",{attrs:{className:"crm-automation-popup-settings-title"},text:t.message("CRM_AUTOMATION_TRIGGER_WEBFORM_LABEL")+":"}),a]});o.appendChild(r)}}})}else if(i.data["CODE"]=="OPENLINE"){t.ajax({method:"POST",dataType:"json",url:this.component.getAjaxUrl(),data:{ajax_action:"get_openline_configs"},onsuccess:function(e){if(e["DATA"]["configs"]){var a=t.create("select",{attrs:{className:"crm-automation-popup-settings-dropdown"},props:{name:"config_id",value:""},children:[t.create("option",{props:{value:""},text:t.message("CRM_AUTOMATION_TRIGGER_WEBFORM_ANY")})]});for(var s=0;s<e["DATA"]["configs"].length;++s){var n=e["DATA"]["configs"][s];a.appendChild(t.create("option",{props:{value:n["ID"]},text:n["NAME"]}))}if(t.type.isPlainObject(i.data["APPLY_RULES"])&&i.data["APPLY_RULES"]["config_id"]){a.value=i.data["APPLY_RULES"]["config_id"]}var r=t.create("div",{attrs:{className:"crm-automation-popup-settings"},children:[t.create("span",{attrs:{className:"crm-automation-popup-settings-title"},text:t.message("CRM_AUTOMATION_TRIGGER_OPENLINE_LABEL")+":"}),a]});o.appendChild(r)}}})}t.addClass(this.component.node,"automation-base-blocked");var d=new t.PopupWindow(e.generateUniqueId(),null,{titleBar:r,content:o,closeIcon:true,zIndex:-100,offsetLeft:0,offsetTop:0,closeByEsc:true,draggable:{restrict:false},overlay:false,events:{onPopupClose:function(e){e.destroy();t.removeClass(a.component.node,"automation-base-blocked")}},buttons:[new t.PopupWindowButton({text:t.message("JS_CORE_WINDOW_SAVE"),className:"popup-window-button-accept",events:{click:function(){var e=t.ajax.prepareForm(o);i.data["NAME"]=e["data"]["name"];if(i.data["CODE"]=="WEBFORM"){i.data["APPLY_RULES"]={form_id:e["data"]["form_id"]}}if(i.data["CODE"]=="OPENLINE"){i.data["APPLY_RULES"]={config_id:e["data"]["config_id"]}}if(i.data["CODE"]=="WEBHOOK"){i.data["APPLY_RULES"]={code:e["data"]["code"]}}a.setConditionSettingsFromForm(e["data"],i);if(i.draft){a.triggers.push(i);a.insertTriggerNode(i.getStatusId(),i.node)}delete i.draft;i.reInit();a.modified=true;this.popupWindow.close()}}}),new t.PopupWindowButtonLink({text:t.message("JS_CORE_WINDOW_CANCEL"),className:"popup-window-button-link-cancel",events:{click:function(){this.popupWindow.close()}}})]});d.show()},renderConditionSettings:function(e){var i=t.clone(e.getCondition());var a=new _(i,{fields:this.component.data["ENTITY_FIELDS"]});return t.create("div",{attrs:{className:"crm-automation-popup-settings"},children:[t.create("div",{attrs:{className:"crm-automation-popup-settings-block"},children:[t.create("span",{attrs:{className:"crm-automation-popup-settings-title"},text:t.message("CRM_AUTOMATION_ROBOT_CONDITION")+":"}),a.createNode()]})]})},setConditionSettingsFromForm:function(e,i){var a,s=new v;if(t.type.isArray(e["condition_field"])){for(a=0;a<e["condition_field"].length;++a){if(e["condition_field"][a]===""){continue}var o=new T;o.setField(e["condition_field"][a]);o.setOperator(e["condition_operator"][a]);o.setValue(e["condition_value"][a]);var n=v.Joiner.And;if(e["condition_joiner"]&&e["condition_joiner"][a]===v.Joiner.Or){n=v.Joiner.Or}s.addItem(o,n)}}i.setCondition(s);return this},onRestAppInstall:function(e,i){i.redirect=false;var a=this;setTimeout(function(){t.ajax({method:"POST",dataType:"json",url:a.component.getAjaxUrl(),data:{ajax_action:"get_available_triggers",entity_type_id:a.component.entityTypeId},onsuccess:function(e){if(t.type.isArray(e["DATA"])){a.availableTriggers=e["DATA"]}}})},1500)}};var n=function(t){this.manager=t;this.component=t.component;this.tracker=t.component.tracker;this.data={};this.deleted=false;this.draggableItem=null;this.droppableItem=null;this.droppableColumn=null;this.stub=null;this.column=null};n.prototype={init:function(t,i){if(t)this.data=t;if(this.data&&this.data.APPLY_RULES&&this.data.APPLY_RULES.Condition){this.condition=new v(this.data.APPLY_RULES.Condition)}else{this.condition=new v}this.viewMode=i||e.ViewMode.View;this.node=this.createNode()},reInit:function(t,e){var i=this.node;this.node=this.createNode();if(i.parentNode)i.parentNode.replaceChild(this.node,i)},getId:function(){return this.data["ID"]||0},getStatusId:function(){return this.data["ENTITY_STATUS"]||""},getLogStatus:function(){var t=this.tracker.getTriggerLog(this.getId());return t?parseInt(t["STATUS"]):null},getCondition:function(){return this.condition},setCondition:function(t){this.condition=t;return this},createNode:function(){var i=this,a=this.getLogStatus();var s="crm-automation-trigger-item-wrapper";if(this.viewMode===e.ViewMode.Edit){s+=" crm-automation-trigger-item-wrapper-draggable";var o=t.create("div",{attrs:{className:"crm-automation-trigger-item-wrapper-edit",style:"border-color: "+"#acf2fa"},text:t.message("CRM_AUTOMATION_CMP_EDIT")})}else{if(a==e.LogStatus.Completed){s+=" crm-automation-trigger-item-wrapper-complete"}else if(this.component.isPreviousEntityStatus(this.getStatusId())){s+=" crm-automation-trigger-item-wrapper-complete-light"}}var n=this.data["NAME"];if(!n){n=this.manager.getTriggerName(this.data["CODE"])}var r=t.create("DIV",{attrs:{"data-role":"trigger-container",className:"crm-automation-trigger-item","data-type":"item-trigger"},children:[t.create("div",{attrs:{className:s,style:"border-color: "+"#acf2fa"},children:[t.create("div",{attrs:{className:"crm-automation-trigger-item-wrapper-text"},text:n})]}),o]});if(this.viewMode===e.ViewMode.Edit){this.registerItem(r);var l=t.create("SPAN",{attrs:{"data-role":"btn-delete-trigger",className:"crm-automation-trigger-btn-delete"}});t.bind(l,"click",function(t){t.preventDefault();t.stopPropagation();i.onDeleteButtonClick(this)});r.appendChild(l);t.addClass(r.firstChild,"crm-automation-trigger-item-wrapper-border")}if(this.viewMode===e.ViewMode.Edit){t.bind(r,"click",function(t){i.onSettingsButtonClick(this)})}return r},onSettingsButtonClick:function(t){this.manager.openTriggerSettingsDialog(this)},registerItem:function(e){e.onbxdragstart=t.proxy(this.dragStart,this);e.onbxdrag=t.proxy(this.dragMove,this);e.onbxdragstop=t.proxy(this.dragStop,this);e.onbxdraghover=t.proxy(this.dragOver,this);jsDD.registerObject(e);jsDD.registerDest(e,1)},dragStart:function(){this.draggableItem=t.proxy_context;this.draggableItem.className="crm-automation-trigger-item";if(!this.draggableItem){jsDD.stopCurrentDrag();return}if(!this.stub){var e=this.draggableItem.offsetWidth;this.stub=this.draggableItem.cloneNode(true);this.stub.style.position="absolute";this.stub.className="crm-automation-trigger-item crm-automation-trigger-item-drag";this.stub.style.width=e+"px";document.body.appendChild(this.stub)}},dragMove:function(t,e){this.stub.style.left=t+"px";this.stub.style.top=e+"px"},dragOver:function(t,e,i){if(this.droppableItem){this.droppableItem.className="crm-automation-trigger-item"}if(this.droppableColumn){this.droppableColumn.className="crm-automation-trigger-list"}var a=t.getAttribute("data-type");if(a==="item-trigger"){this.droppableItem=t;this.droppableColumn=null}if(a==="column-trigger"){this.droppableColumn=t.children[0];this.droppableItem=null}if(this.droppableItem){this.droppableItem.className="crm-automation-trigger-item crm-automation-trigger-item-pre"}if(this.droppableColumn){this.droppableColumn.className="crm-automation-trigger-list crm-automation-trigger-list-pre"}},dragStop:function(){var t,e=window.event.ctrlKey;var i=function(t,e){var i=new n(t.manager);var a=t.serialize();delete a["ID"];if(a["CODE"]==="WEBHOOK"){a["APPLY_RULES"]={}}a["ENTITY_STATUS"]=e;i.init(a,t.viewMode);return i};if(this.draggableItem){if(this.droppableItem){this.droppableItem.className="crm-automation-trigger-item";var a=this.droppableItem.parentNode;if(!e){a.insertBefore(this.draggableItem,this.droppableItem);this.moveTo(a.getAttribute("data-status-id"))}else{t=i(this,a.getAttribute("data-status-id"));a.insertBefore(t.node,this.droppableItem)}}else if(this.droppableColumn){this.droppableColumn.className="crm-automation-trigger-list";if(!e){this.droppableColumn.appendChild(this.draggableItem);this.moveTo(this.droppableColumn.getAttribute("data-status-id"))}else{t=i(this,this.droppableColumn.getAttribute("data-status-id"));this.droppableColumn.appendChild(t.node)}}if(t){this.manager.triggers.push(t);this.manager.modified=true}}this.stub.parentNode.removeChild(this.stub);this.stub=null;this.draggableItem=null;this.droppableItem=null},onDeleteButtonClick:function(e){t.remove(e.parentNode);this.manager.deleteTrigger(this)},updateData:function(e){if(t.type.isPlainObject(e)){this.data=e}else throw"Invalid data"},markDeleted:function(){this.deleted=true;return this},serialize:function(){var e=t.clone(this.data);if(this.deleted){e["DELETED"]="Y"}if(!t.type.isPlainObject(e.APPLY_RULES)){e.APPLY_RULES={}}if(!this.condition.items.length){delete e.APPLY_RULES.Condition}else{e.APPLY_RULES.Condition=this.condition.serialize()}return e},moveTo:function(t){this.data["ENTITY_STATUS"]=t;this.manager.modified=true}};var r=function(t){this.component=t};r.prototype={init:function(e){if(!t.type.isPlainObject(e))e={};this.log=e;this.triggers={};this.robots={};for(var i in e){if(!e.hasOwnProperty(i))continue;if(e[i]["trigger"]){this.triggers[e[i]["trigger"]["ID"]]=e[i]["trigger"]}if(e[i]["robots"]){for(var a in e[i]["robots"]){if(!e[i]["robots"].hasOwnProperty(a))continue;this.robots[a]=e[i]["robots"][a]}}}},reInit:function(t){this.init(t)},getRobotLog:function(t){return this.robots[t]||null},getTriggerLog:function(t){return this.triggers[t]||null}};var l=function(i,a){var s=this;var o,n=a.getAttribute("data-config");if(n){o=t.parseJSON(n)}if(!t.type.isPlainObject(o))o={};this.container=a;this.itemsNode=t.create("span");this.inputBoxNode=t.create("span",{attrs:{className:"feed-add-destination-input-box"}});this.inputNode=t.create("input",{props:{type:"text"},attrs:{className:"feed-add-destination-inp"}});this.inputBoxNode.appendChild(this.inputNode);this.tagNode=t.create("a",{attrs:{className:"feed-add-destination-link"}});t.addClass(a,"crm-automation-popup-autocomplete");a.appendChild(this.itemsNode);a.appendChild(this.inputBoxNode);a.appendChild(this.tagNode);this.component=i;this.itemTpl=o.itemTpl;this.data=null;this.dialogId=e.generateUniqueId();this.createValueNode(o.valueInputName||"");this.selected=o.selected?t.clone(o.selected):[];this.selectOne=!o.multiple;this.required=o.required||false;this.additionalFields=t.type.isArray(o.additionalFields)?o.additionalFields:[];t.bind(this.tagNode,"focus",function(t){t.preventDefault();s.openDialog({bByFocusEvent:true})});t.bind(this.container,"click",function(t){t.preventDefault();s.openDialog()});this.addItems(this.selected);this.tagNode.innerHTML=this.selected.length<=0?t.message("CRM_AUTOMATION_CMP_CHOOSE"):t.message("CRM_AUTOMATION_CMP_EDIT")};l.prototype={getData:function(e){var i=this;if(i.ajaxProgress)return;i.ajaxProgress=true;t.ajax({method:"POST",dataType:"json",url:i.component.getAjaxUrl(),data:{ajax_action:"get_destination_data",entity_type_id:i.component.entityTypeId},onsuccess:function(t){i.data=t.DATA||{};i.ajaxProgress=false;i.initDialog(e)}})},initDialog:function(e){var i,a=this,s=this.data;if(!s){a.getData(e);return}var o={};for(i=0;i<a.selected.length;++i){o[a.selected[i].id]=a.selected[i].entityType}var n={users:s.USERS||{},department:s.DEPARTMENT||{},departmentRelation:s.DEPARTMENT_RELATION||{},bpuserroles:s.ROLES||{}};var r={users:s.LAST.USERS||{},bpuserroles:s.LAST.ROLES||{}};for(i=0;i<this.additionalFields.length;++i){n.bpuserroles[this.additionalFields[i]["id"]]=this.additionalFields[i]}if(!n["departmentRelation"]){n["departmentRelation"]=t.SocNetLogDestination.buildDepartmentRelation(n["department"])}if(!a.inited){a.inited=true;var l=a.inputNode;l.id=a.dialogId+"input";var d=a.inputBoxNode;d.id=a.dialogId+"input-box";var p=this.tagNode;p.id=this.dialogId+"tag";var u=a.itemsNode;t.SocNetLogDestination.init({name:a.dialogId,searchInput:l,extranetUser:false,bindMainPopup:{node:a.container,offsetTop:"5px",offsetLeft:"15px"},bindSearchPopup:{node:a.container,offsetTop:"5px",offsetLeft:"15px"},departmentSelectDisable:true,sendAjaxSearch:true,callback:{select:function(e,i,s,o){a.addItem(e,i);if(a.selectOne)t.SocNetLogDestination.closeDialog()},unSelect:function(e){if(a.selectOne)return;a.unsetValue(e.entityId);t.SocNetLogDestination.BXfpUnSelectCallback.call({formName:a.dialogId,inputContainerName:u,inputName:l.id,tagInputName:p.id,tagLink1:t.message("CRM_AUTOMATION_CMP_CHOOSE"),tagLink2:t.message("CRM_AUTOMATION_CMP_EDIT")},e)},openDialog:t.delegate(t.SocNetLogDestination.BXfpOpenDialogCallback,{inputBoxName:d.id,inputName:l.id,tagInputName:p.id}),closeDialog:t.delegate(t.SocNetLogDestination.BXfpCloseDialogCallback,{inputBoxName:d.id,inputName:l.id,tagInputName:p.id}),openSearch:t.delegate(t.SocNetLogDestination.BXfpOpenDialogCallback,{inputBoxName:d.id,inputName:l.id,tagInputName:p.id}),closeSearch:t.delegate(t.SocNetLogDestination.BXfpCloseSearchCallback,{inputBoxName:d.id,inputName:l.id,tagInputName:p.id})},items:n,itemsLast:r,itemsSelected:o,useClientDatabase:false,destSort:s.DEST_SORT||{},allowAddUser:false});t.onCustomEvent(t.SocNetLogDestination,"onTabsAdd",[a.dialogId,{id:"bpuserrole",name:t.message("CRM_AUTOMATION_CMP_USER_SELECTOR_TAB"),itemType:"bpuserroles",dialogGroup:{groupCode:"bpuserroles",title:t.message("CRM_AUTOMATION_CMP_USER_SELECTOR_TAB")}}]);t.bind(l,"keyup",t.delegate(t.SocNetLogDestination.BXfpSearch,{formName:a.dialogId,inputName:l.id,tagInputName:p.id}));t.bind(l,"keydown",t.delegate(t.SocNetLogDestination.BXfpSearchBefore,{formName:a.dialogId,inputName:l.id}));t.SocNetLogDestination.BXfpSetLinkName({formName:a.dialogId,tagInputName:p.id,tagLink1:t.message("CRM_AUTOMATION_CMP_CHOOSE"),tagLink2:t.message("CRM_AUTOMATION_CMP_EDIT")})}e()},addItem:function(e,i){var a=this;var s=this.inputNode;var o=this.tagNode;var n=this.itemsNode;if(!t.findChild(n,{attr:{"data-id":e.id}},false,false)){if(a.selectOne&&a.inited){var r=[];for(var l=0;l<n.childNodes.length;++l){r.push({itemId:n.childNodes[l].getAttribute("data-id"),itemType:n.childNodes[l].getAttribute("data-type")})}a.initDialog(function(){for(var e=0;e<r.length;++e){t.SocNetLogDestination.deleteItem(r[e].itemId,r[e].itemType,a.dialogId)}});t.cleanNode(n);a.cleanValue()}var d=this.createItemNode({text:e.name,deleteEvents:{click:function(s){if(a.selectOne&&a.required){a.openDialog()}else{a.initDialog(function(){t.SocNetLogDestination.deleteItem(e.id,i,a.dialogId);t.remove(d);a.unsetValue(e.entityId)})}s.preventDefault()}}});this.setValue(e.entityId);d.setAttribute("data-id",e.id);d.setAttribute("data-type",i);n.appendChild(d);if(!e.entityType)e.entityType=i}s.value="";o.innerHTML=t.message("CRM_AUTOMATION_CMP_EDIT")},addItems:function(t){for(var e=0;e<t.length;++e){this.addItem(t[e],t[e].entityType)}},openDialog:function(e){var i=this;this.initDialog(function(){t.SocNetLogDestination.openDialog(i.dialogId,e)})},destroy:function(){if(this.inited){if(t.SocNetLogDestination.isOpenDialog()){t.SocNetLogDestination.closeDialog()}t.SocNetLogDestination.closeSearch()}},createItemNode:function(e){return t.create("span",{attrs:{className:"crm-automation-popup-autocomplete-item"},children:[t.create("span",{attrs:{className:"crm-automation-popup-autocomplete-name"},html:e.text||""}),t.create("span",{attrs:{className:"crm-automation-popup-autocomplete-delete"},events:e.deleteEvents})]})},createValueNode:function(e){this.valueNode=t.create("input",{props:{type:"hidden",name:e}});this.container.appendChild(this.valueNode)},setValue:function(t){if(/^\d+$/.test(t))t="["+t+"]";if(this.selectOne)this.valueNode.value=t;else{var e,i=[],a=this.valueNode.value.split(";");for(e=0;e<a.length;++e){if(!a[e]||t==a[e])continue;i.push(a[e])}i.push(t);this.valueNode.value=i.join(";")}},unsetValue:function(t){if(/^\d+$/.test(t))t="["+t+"]";if(this.selectOne)this.valueNode.value="";else{var e,i=[],a=this.valueNode.value.split(";");for(e=0;e<a.length;++e){if(!a[e]||t==a[e])continue;i.push(a[e])}this.valueNode.value=i.join(";")}},cleanValue:function(){this.valueNode.value=""}};var d=function(e,i){var a,s=i.getAttribute("data-config");if(s){a=t.parseJSON(s)}if(!t.type.isPlainObject(a))a={};this.container=i;this.type=a.type||d.Type.File;if(a.selected&&!a.selected.length){this.type=d.Type.None}this.multiple=a.multiple||false;this.required=a.required||false;this.valueInputName=a.valueInputName||"";this.typeInputName=a.typeInputName||"";this.useDisk=a.useDisk||false;this.label=a.label||"Attachment";this.labelFile=a.labelFile||"File";this.labelDisk=a.labelDisk||"Disk";this.setFileFields(e.data["ENTITY_FIELDS"]);this.createDom();if(a.selected&&a.selected.length>0){this.addItems(t.clone(a.selected))}};d.Type={None:"",Disk:"disk",File:"file"};d.prototype={setFileFields:function(t){var e=[];for(var i=0;i<t.length;++i){if(t[i]["Type"]==="file"){e.push(t[i])}}this.fileFields=e;return this},createDom:function(){this.container.appendChild(this.createBaseNode());this.showTypeControllerLayout(this.type)},createBaseNode:function(){var i=e.generateUniqueId();var a=null;if(this.fileFields.length>0){a=t.create("input",{attrs:{className:"crm-automation-popup-select-input",type:"radio",id:"type-1"+i,name:this.typeInputName,value:d.Type.File}});if(this.type===d.Type.File){a.setAttribute("checked","checked")}}var s=t.create("input",{attrs:{className:"crm-automation-popup-select-input",type:"radio",id:"type-2"+i,name:this.typeInputName,value:d.Type.Disk}});if(this.type===d.Type.Disk){s.setAttribute("checked","checked")}var o=[t.create("span",{attrs:{className:"crm-automation-popup-settings-title"},text:this.label+":"})];if(a){o.push(a,t.create("label",{attrs:{className:"crm-automation-popup-settings-link",for:"type-1"+i},text:this.labelFile,events:{click:this.onTypeChange.bind(this,d.Type.File)}}))}o.push(s,t.create("label",{attrs:{className:"crm-automation-popup-settings-link",for:"type-2"+i},text:this.labelDisk,events:{click:this.onTypeChange.bind(this,d.Type.Disk)}}));return t.create("div",{attrs:{className:"crm-automation-popup-settings"},children:[t.create("div",{attrs:{className:"crm-automation-popup-settings-block"},children:o})]})},showTypeControllerLayout:function(t){if(t===d.Type.Disk){this.hideFileControllerLayout();this.showDiskControllerLayout()}else if(t===d.Type.File){this.hideDiskControllerLayout();this.showFileControllerLayout()}else{this.hideFileControllerLayout();this.hideDiskControllerLayout()}},showDiskControllerLayout:function(){if(!this.diskControllerNode){this.diskControllerNode=t.create("div");this.container.appendChild(this.diskControllerNode);var e=this.getDiskUploader();e.layout(this.diskControllerNode);e.show(true)}else{t.show(this.diskControllerNode)}},hideDiskControllerLayout:function(){if(this.diskControllerNode){t.hide(this.diskControllerNode)}},showFileControllerLayout:function(){if(!this.fileControllerNode){this.fileItemsNode=t.create("span");this.fileControllerNode=t.create("div",{children:[this.fileItemsNode]});this.container.appendChild(this.fileControllerNode);var e=t.create("a",{attrs:{className:"crm-automation-popup-settings-link crm-automation-popup-settings-link-thin"},text:t.message("CRM_AUTOMATION_CMP_ADD")});this.fileControllerNode.appendChild(e);t.bind(e,"click",this.onFileFieldAddClick.bind(this,e))}else{t.show(this.fileControllerNode)}},hideFileControllerLayout:function(){if(this.fileControllerNode){t.hide(this.fileControllerNode)}},getDiskUploader:function(){if(!this.diskUploader){this.diskUploader=t.CrmDiskUploader.create("",{msg:{diskAttachFiles:t.message("CRM_AUTOMATION_CMP_DISK_ATTACH_FILE"),diskAttachedFiles:t.message("CRM_AUTOMATION_CMP_DISK_ATTACHED_FILES"),diskSelectFile:t.message("CRM_AUTOMATION_CMP_DISK_SELECT_FILE"),diskSelectFileLegend:t.message("CRM_AUTOMATION_CMP_DISK_SELECT_FILE_LEGEND"),diskUploadFile:t.message("CRM_AUTOMATION_CMP_DISK_UPLOAD_FILE"),diskUploadFileLegend:t.message("CRM_AUTOMATION_CMP_DISK_UPLOAD_FILE_LEGEND")}});this.diskUploader.setMode(1)}return this.diskUploader},onTypeChange:function(t){if(this.type!==t){this.type=t;this.showTypeControllerLayout(this.type)}},isFileItemSelected:function(t){var e=this.fileItemsNode.querySelector('[data-file-id="'+t.id+'"]');return!!e},addFileItem:function(e){if(this.isFileItemSelected(e)){return false}var i=this.createFileItemNode(e);if(!this.multiple){t.cleanNode(this.fileItemsNode)}this.fileItemsNode.appendChild(i)},addItems:function(t){if(this.type===d.Type.File){for(var e=0;e<t.length;++e){this.addFileItem(t[e])}}else{this.getDiskUploader().setValues(this.convertToDiskItems(t))}},convertToDiskItems:function(t){var e=[];for(var i=0;i<t.length;++i){var a=t[i];e.push({ID:a["id"],NAME:a["name"],SIZE:a["size"],VIEW_URL:""})}return e},removeFileItem:function(t){var e=this.fileItemsNode.querySelector('[data-file-id="'+t.id+'"]');if(e){this.fileItemsNode.removeChild(e)}},onFileFieldAddClick:function(i,a){var s=this,o,n=[];var r=this.fileFields;for(o=0;o<r.length;++o){n.push({text:r[o]["Name"],field:r[o],onclick:function(t,e){this.popupWindow.close();s.onFieldSelect(e.field)}})}if(!this.menuId){this.menuId=e.generateUniqueId()}t.PopupMenu.show(this.menuId,i,n,{zIndex:200,autoHide:true,offsetLeft:t.pos(i)["width"]/2,angle:{position:"top",offset:0}});this.menu=t.PopupMenu.currentItem;a.preventDefault()},onFieldSelect:function(t){this.addFileItem({id:t.Expression,name:t.Name,type:d.Type.File})},destroy:function(){if(this.menu){this.menu.popupWindow.close()}},createFileItemNode:function(e){return t.create("span",{attrs:{className:"crm-automation-popup-autocomplete-item","data-file-id":e.id},children:[t.create("span",{attrs:{className:"crm-automation-popup-autocomplete-name"},text:e.name||""}),t.create("span",{attrs:{className:"crm-automation-popup-autocomplete-delete"},events:{click:this.removeFileItem.bind(this,e)}})]})},onBeforeSave:function(){var e=[];if(this.type===d.Type.Disk){e=this.getDiskUploader().getValues()}else if(this.type===d.Type.File){this.fileItemsNode.childNodes.forEach(function(t){var i=t.getAttribute("data-file-id");if(i!==""){e.push(i)}})}for(var i=0;i<e.length;++i){this.container.appendChild(t.create("input",{props:{type:"hidden",name:this.valueInputName+(this.multiple?"[]":""),value:e[i]}}))}}};var p=function(e,i){var a=this;this.component=e;this.entityFields=this.component.data["ENTITY_FIELDS"];this.targetInput=t.clone(i);this.menuButton=t.create("span",{attrs:{className:"crm-automation-popup-select-dotted"},events:{click:t.delegate(a.openMenu,this)}});var s=t.create("div",{attrs:{className:"crm-automation-popup-select"},children:[this.targetInput,this.menuButton]});i.parentNode.replaceChild(s,i);t.bind(this.targetInput,"keydown",function(t){a.onKeyDown(this,t)});this.targetInput.setAttribute("autocomplete","off");var o=this.targetInput.getAttribute("data-selector-type");if(o==="date"||o==="UF:date"||o==="datetime"){this.initDateTimeControl(o)}this.replaceOnWrite=this.targetInput.getAttribute("data-selector-write-mode")==="replace"};p.prototype={onKeyDown:function(t,e){if(e.keyCode==45&&e.altKey===false&&e.ctrlKey===false&&e.shiftKey===false){this.openMenu(e);e.preventDefault()}},openMenu:function(i){var a=this,s,o=[];var n=this.entityFields;for(s=0;s<n.length;++s){o.push({text:n[s]["Name"],field:n[s],onclick:function(t,e){this.popupWindow.close();a.onFieldSelect(e.field||e.options.field)}})}var r=this.menuButton.getAttribute("data-selector-id");if(!r){r=e.generateUniqueId();this.menuButton.setAttribute("data-selector-id",r)}t.PopupMenu.show(r,this.menuButton,o,{zIndex:200,autoHide:true,offsetLeft:t.pos(this.menuButton)["width"]/2,angle:{position:"top",offset:0},className:"crm-automation-inline-selector-menu"});this.menu=t.PopupMenu.currentItem},onFieldSelect:function(e){if(this.replaceOnWrite){this.targetInput.value="{{"+e["Name"]+"}}";this.targetInput.selectionEnd=this.targetInput.value.length}else{var i=this.targetInput.value.substr(0,this.targetInput.selectionEnd),a="{{"+e["Name"]+"}}",s=this.targetInput.value.substr(this.targetInput.selectionEnd);this.targetInput.value=i+a+s;this.targetInput.selectionEnd=i.length+a.length}t.fireEvent(this.targetInput,"change")},destroy:function(){if(this.menu)this.menu.popupWindow.close()},initDateTimeControl:function(e){this.targetInput.setAttribute("readonly","readonly");var i=[];if(t.type.isArray(this.component.data["ENTITY_FIELDS"])){var a,s;for(a=0;a<this.component.data["ENTITY_FIELDS"].length;++a){s=this.component.data["ENTITY_FIELDS"][a];if(s["Type"]=="date"||s["Type"]=="datetime"||s["Type"]=="UF:date")i.push(s)}}this.entityFields=i;var o=new m({labelNode:this.targetInput,basisFields:i,useAfterBasis:true,onchange:function(t){this.targetInput.value=t.toExpression(i)}.bind(this)});o.init(g.fromString(this.targetInput.value,i))}};var u=function(e,i){var a=this;this.component=e;this.entityFields=this.component.data["ENTITY_FIELDS"];this.editorNode=i.firstElementChild.firstElementChild;this.menuButton=t.create("span",{attrs:{className:"crm-automation-popup-select-dotted"},events:{click:t.delegate(a.openMenu,this)}});i.firstElementChild.appendChild(this.menuButton);this.bindEvents()};t.extend(u,p);u.prototype.getEditor=function(){var t;if(this.editorNode){var e=this.editorNode.id.split("-");t=BXHtmlEditor.Get(e[e.length-1])}return t};u.prototype.bindEvents=function(){this.editorInitFunction=this.bindEditorHooks.bind(this);t.addCustomEvent("OnEditorInitedAfter",this.editorInitFunction)};u.prototype.unBindEvents=function(){t.removeCustomEvent("OnEditorInitedAfter",this.editorInitFunction)};u.prototype.bindEditorHooks=function(e){var i="",a="";if(e.dom.cont!==this.editorNode){return false}t.addCustomEvent(e,"OnParse",function(t){if(!t){var e=this.content;e=e.replace(/(^[\s\S]*?)(<body.*?>)/i,function(t){i=t;return""});e=e.replace(/(<\/body>[\s\S]*?$)/i,function(t){a=t;return""});this.content=e}});t.addCustomEvent(e,"OnAfterParse",function(t){if(t){var e=this.content;e=e.replace(/^[\s\S]*?<body.*?>/i,"");e=e.replace(/<\/body>[\s\S]*?$/i,"");if(i!==""&&a!==""){e=i+e+a}this.content=e}})};u.prototype.onFieldSelect=function(t){var e="{{"+t["Name"]+"}}";var i=this.getEditor();if(i&&i.InsertHtml){i.InsertHtml(e)}};u.prototype.destroy=function(){if(this.menu)this.menu.popupWindow.close();this.unBindEvents()};u.prototype.onBeforeSave=function(){var t=this.getEditor();if(t&&t.SaveContent){t.SaveContent()}};u.prototype.onPopupResize=function(){var t=this.getEditor();if(t&&t.ResizeSceleton){t.ResizeSceleton()}};var c=function(e){this.targetInput=e;var i=new Date,a=this.unFormatTime(e.value);i.setHours(0,0,0,0);i.setTime(i.getTime()+a*1e3);e.value=this.formatTime(i);t.bind(e,"click",t.delegate(this.showClock,this))};c.prototype={showClock:function(e){if(!this.clockInstance){this.clockInstance=new t.CClockSelector({start_time:this.unFormatTime(this.targetInput.value),node:this.targetInput,callback:t.delegate(this.onTimeSelect,this),zIndex:200})}this.clockInstance.Show()},onTimeSelect:function(e){this.targetInput.value=e;t.fireEvent(this.targetInput,"change");this.clockInstance.closeWnd()},unFormatTime:function(t){var e=t.split(/[\s:]+/);if(e.length==3){var i=e[2];if(i=="pm"&&e[0]<12)e[0]=parseInt(e[0],10)+12;if(i=="am"&&e[0]==12)e[0]=0}return parseInt(e[0],10)*3600+parseInt(e[1],10)*60},formatTime:function(e){var i=t.date.convertBitrixFormat(t.message("FORMAT_DATE")).replace(/:?\s*s/,""),a=t.date.convertBitrixFormat(t.message("FORMAT_DATETIME")).replace(/:?\s*s/,""),s=t.date.format(i,e),o=t.date.format(a,e);return t.util.trim(o.replace(s,""))},destroy:function(){if(this.clockInstance)this.clockInstance.closeWnd()}};var h=function(t,e){this.checkbox=t;this.robot=e;this.needSync=e.draft;if(this.needSync){var i=this.getKey();var a=e.component.getUserOption("save_state_checkboxes",i,"N");if(a==="Y"){t.checked=true}}};h.prototype={getKey:function(){return this.checkbox.getAttribute("data-save-state-key")},destroy:function(){if(this.needSync){var t=this.getKey();var e=this.checkbox.checked?"Y":"N";this.robot.component.setUserOption("save_state_checkboxes",t,e)}}};var m=function(e){this.basisFields=[];this.onchange=null;if(t.type.isPlainObject(e)){this.labelNode=e.labelNode;this.useAfterBasis=e.useAfterBasis;if(t.type.isArray(e.basisFields))this.basisFields=e.basisFields;this.onchange=e.onchange}};m.prototype={init:function(t){this.delay=t;this.setLabelText();this.bindLabelNode();this.prepareBasisFields()},setLabelText:function(){if(this.delay&&this.labelNode){this.labelNode.textContent=b(this.delay,t.message("CRM_AUTOMATION_CMP_AT_ONCE"),this.basisFields)}},bindLabelNode:function(){if(this.labelNode){t.bind(this.labelNode,"click",t.delegate(this.onLabelClick,this))}},onLabelClick:function(t){this.showDelayIntervalPopup();t.preventDefault()},showDelayIntervalPopup:function(){var i=this,a=this.delay;var s=e.generateUniqueId();var o=t.create("form",{attrs:{className:"crm-automation-popup-select-block"}});var n=t.create("input",{attrs:{className:"crm-automation-popup-select-input",id:s+"now",type:"radio",value:"now",name:"type"}});if(a.isNow())n.setAttribute("checked","checked");var r=t.create("label",{attrs:{className:"crm-automation-popup-select-wrapper",for:s+"now"},children:[t.create("span",{attrs:{className:"crm-automation-popup-settings-title"},text:t.message(this.useAfterBasis?"CRM_AUTOMATION_CMP_BASIS_NOW":"CRM_AUTOMATION_CMP_AT_ONCE_2")})]});var l=t.create("span",{attrs:{className:"crm-automation-status-help crm-automation-status-help-right","data-text":t.message(this.useAfterBasis?"CRM_AUTOMATION_CMP_DELAY_NOW_HELP_2":"CRM_AUTOMATION_CMP_DELAY_NOW_HELP")},text:"?"});C.bindToNode(l);r.appendChild(l);o.appendChild(t.create("div",{attrs:{className:"crm-automation-popup-select-item"},children:[n,r]}));o.appendChild(this.createAfterControlNode());if(this.basisFields.length>0){o.appendChild(this.createBeforeControlNode());o.appendChild(this.createInControlNode())}var d=t.create("input",{attrs:{type:"checkbox",id:s+"worktime",name:"worktime",value:"1",style:"vertical-align: middle"},props:{checked:a.workTime}});var p=t.create("span",{attrs:{className:"crm-automation-status-help crm-automation-status-help-right","data-text":t.message("CRM_AUTOMATION_CMP_DELAY_WORKTIME_HELP")},text:"?"});C.bindToNode(p);o.appendChild(t.create("div",{attrs:{className:"crm-automation-popup-settings-title"},children:[d,t.create("label",{attrs:{className:"crm-automation-popup-settings-lbl",for:s+"worktime"},text:t.message("CRM_AUTOMATION_CMP_WORK_TIME")}),p]}));var u=new t.PopupWindow("crm-automation-popup-set",this.labelNode,{autoHide:true,closeByEsc:true,closeIcon:false,titleBar:false,zIndex:0,angle:true,offsetLeft:20,content:o,buttons:[new t.PopupWindowButton({text:t.message("CRM_AUTOMATION_CMP_CHOOSE"),className:"webform-button webform-button-create crm-automation-button-left",events:{click:function(){var e=t.ajax.prepareForm(o);i.saveFormData(e["data"]);if(i.fieldsMenu)i.fieldsMenu.popupWindow.close();this.popupWindow.close()}}})],overlay:{backgroundColor:"transparent"}});u.show()},saveFormData:function(t){if(t["type"]==="now"){this.delay.setNow()}else if(t["type"]===g.Type.In){this.delay.setType(g.Type.In);this.delay.setValue(0);this.delay.setValueType("i");this.delay.setBasis(t["basis_in"])}else{this.delay.setType(t["type"]);this.delay.setValue(t["value_"+t["type"]]);this.delay.setValueType(t["value_type_"+t["type"]]);if(t["type"]===g.Type.After){if(this.useAfterBasis)this.delay.setBasis(t["basis_after"]);else this.delay.setBasis(g.Basis.CurrentDateTime)}else this.delay.setBasis(t["basis_before"])}this.delay.setWorkTime(t["worktime"]);this.setLabelText();if(this.onchange){this.onchange(this.delay)}},createAfterControlNode:function(){var i=this,a=this.delay;var s=e.generateUniqueId();var o=t.create("input",{attrs:{className:"crm-automation-popup-select-input",id:s,type:"radio",value:g.Type.After,name:"type"}});if(a.type===g.Type.After&&a.value>0)o.setAttribute("checked","checked");var n=t.create("input",{attrs:{type:"text",name:"value_after",className:"crm-automation-popup-settings-input"},props:{value:a.type===g.Type.After&&a.value?a.value:"5"}});var r=t.create("label",{attrs:{className:"crm-automation-popup-select-wrapper",for:s},children:[t.create("span",{attrs:{className:"crm-automation-popup-settings-title"},text:t.message("CRM_AUTOMATION_CMP_THROUGH_2")}),n,this.createValueTypeSelector("value_type_after")]});if(this.useAfterBasis){r.appendChild(t.create("span",{attrs:{className:"crm-automation-popup-settings-title crm-automation-popup-settings-title-auto-width"},text:t.message("CRM_AUTOMATION_CMP_AFTER")}));var l=this.getBasisField(a.basis,true);var d=a.basis;if(!l){l=this.getBasisField(g.Basis.CurrentDateTime,true);d=l.SystemExpression}var p=t.create("input",{attrs:{type:"hidden",name:"basis_after",value:d}});var u=t.create("span",{attrs:{className:"crm-automation-popup-settings-link crm-automation-delay-interval-basis"},text:l?l.Name:t.message("CRM_AUTOMATION_CMP_CHOOSE_DATE_FIELD"),events:{click:function(t){i.onBasisClick(t,this,function(t){u.textContent=t.Name;p.value=t.SystemExpression},g.Type.After)}}});r.appendChild(p);r.appendChild(u)}if(!this.useAfterBasis){var c=t.create("span",{attrs:{className:"crm-automation-status-help crm-automation-status-help-right","data-text":t.message("CRM_AUTOMATION_CMP_DELAY_AFTER_HELP")},text:"?"});C.bindToNode(c);r.appendChild(c)}return t.create("div",{attrs:{className:"crm-automation-popup-select-item"},children:[o,r]})},createBeforeControlNode:function(){var i=this,a=this.delay;var s=e.generateUniqueId();var o=t.create("input",{attrs:{className:"crm-automation-popup-select-input",id:s,type:"radio",value:g.Type.Before,name:"type"}});if(a.type===g.Type.Before)o.setAttribute("checked","checked");var n=t.create("input",{attrs:{type:"text",name:"value_before",className:"crm-automation-popup-settings-input"},props:{value:a.type===g.Type.Before&&a.value?a.value:"5"}});var r=t.create("label",{attrs:{className:"crm-automation-popup-select-wrapper",for:s},children:[t.create("span",{attrs:{className:"crm-automation-popup-settings-title"},text:t.message("CRM_AUTOMATION_CMP_FOR_TIME_2")}),n,this.createValueTypeSelector("value_type_before"),t.create("span",{attrs:{className:"crm-automation-popup-settings-title crm-automation-popup-settings-title-auto-width"},text:t.message("CRM_AUTOMATION_CMP_BEFORE")})]});var l=this.getBasisField(a.basis);var d=a.basis;if(!l){l=this.basisFields[0];d=l.SystemExpression}var p=t.create("input",{attrs:{type:"hidden",name:"basis_before",value:d}});var u=t.create("span",{attrs:{className:"crm-automation-popup-settings-link crm-automation-delay-interval-basis"},text:l?l.Name:t.message("CRM_AUTOMATION_CMP_CHOOSE_DATE_FIELD"),events:{click:function(t){i.onBasisClick(t,this,function(t){u.textContent=t.Name;p.value=t.SystemExpression})}}});r.appendChild(p);r.appendChild(u);if(!this.useAfterBasis){var c=t.create("span",{attrs:{className:"crm-automation-status-help crm-automation-status-help-right","data-text":t.message("CRM_AUTOMATION_CMP_DELAY_BEFORE_HELP")},text:"?"});C.bindToNode(c);r.appendChild(c)}return t.create("div",{attrs:{className:"crm-automation-popup-select-item"},children:[o,r]})},createInControlNode:function(){var i=this,a=this.delay;var s=e.generateUniqueId();var o=t.create("input",{attrs:{className:"crm-automation-popup-select-input",id:s,type:"radio",value:g.Type.In,name:"type"}});if(a.type===g.Type.In)o.setAttribute("checked","checked");var n=t.create("label",{attrs:{className:"crm-automation-popup-select-wrapper",for:s},children:[t.create("span",{attrs:{className:"crm-automation-popup-settings-title"},text:t.message("CRM_AUTOMATION_CMP_IN_TIME_2")})]});var r=this.getBasisField(a.basis);var l=a.basis;if(!r){r=this.basisFields[0];l=r.SystemExpression}var d=t.create("input",{attrs:{type:"hidden",name:"basis_in",value:l}});var p=t.create("span",{attrs:{className:"crm-automation-popup-settings-link crm-automation-delay-interval-basis"},text:r?r.Name:t.message("CRM_AUTOMATION_CMP_CHOOSE_DATE_FIELD"),events:{click:function(t){i.onBasisClick(t,this,function(t){p.textContent=t.Name;d.value=t.SystemExpression})}}});n.appendChild(d);n.appendChild(p);if(!this.useAfterBasis){var u=t.create("span",{attrs:{className:"crm-automation-status-help crm-automation-status-help-right","data-text":t.message("CRM_AUTOMATION_CMP_DELAY_IN_HELP")},text:"?"});C.bindToNode(u);n.appendChild(u)}return t.create("div",{attrs:{className:"crm-automation-popup-select-item"},children:[o,n]})},createValueTypeSelector:function(e){var i=this.delay;var a={i:t.message("CRM_AUTOMATION_CMP_INTERVAL_M"),h:t.message("CRM_AUTOMATION_CMP_INTERVAL_H"),d:t.message("CRM_AUTOMATION_CMP_INTERVAL_D")};var s=t.create("label",{attrs:{className:"crm-automation-popup-settings-link"},text:a[i.valueType]});var o=t.create("input",{attrs:{type:"hidden",name:e},props:{value:i.valueType}});t.bind(s,"click",this.onValueTypeSelectorClick.bind(this,s,o));return t.create("span",{children:[s,o]})},onValueTypeSelectorClick:function(i,a){var s=e.generateUniqueId();var o=function(t,e){this.popupWindow.close();a.value=e.valueId;i.textContent=e.text};var n=[{text:t.message("CRM_AUTOMATION_CMP_INTERVAL_M"),valueId:"i",onclick:o},{text:t.message("CRM_AUTOMATION_CMP_INTERVAL_H"),valueId:"h",onclick:o},{text:t.message("CRM_AUTOMATION_CMP_INTERVAL_D"),valueId:"d",onclick:o}];t.PopupMenu.show(s,i,n,{autoHide:true,offsetLeft:25,angle:{position:"top"},zIndex:200,events:{onPopupClose:function(){this.destroy()}}})},onBasisClick:function(i,a,s,o){var n=this,r,l=[];if(o===g.Type.After){l.push({text:t.message("CRM_AUTOMATION_CMP_BASIS_NOW"),field:{Name:t.message("CRM_AUTOMATION_CMP_BASIS_NOW"),SystemExpression:g.Basis.CurrentDateTime},onclick:function(t,e){if(s)s(e.field);this.popupWindow.close()}},{text:t.message("CRM_AUTOMATION_CMP_BASIS_DATE"),field:{Name:t.message("CRM_AUTOMATION_CMP_BASIS_DATE"),SystemExpression:g.Basis.CurrentDate},onclick:function(t,e){if(s)s(e.field);this.popupWindow.close()}},{delimiter:true})}for(r=0;r<this.basisFields.length;++r){l.push({text:this.basisFields[r].Name,field:this.basisFields[r],onclick:function(t,e){if(s)s(e.field||e.options.field);this.popupWindow.close()}})}var d=a.getAttribute("data-menu-id");if(!d){d=e.generateUniqueId();a.setAttribute("data-menu-id",d)}t.PopupMenu.show(d,a,l,{zIndex:200,autoHide:true,offsetLeft:t.pos(a)["width"]/2,angle:{position:"top",offset:0}});this.fieldsMenu=t.PopupMenu.currentItem},getBasisField:function(e,i){if(i&&e===g.Basis.CurrentDateTime)return{Name:t.message("CRM_AUTOMATION_CMP_BASIS_NOW"),SystemExpression:g.Basis.CurrentDateTime};if(i&&e===g.Basis.CurrentDate)return{Name:t.message("CRM_AUTOMATION_CMP_BASIS_DATE"),SystemExpression:g.Basis.CurrentDate};var a=null;for(var s=0;s<this.basisFields.length;++s){if(e===this.basisFields[s].SystemExpression)a=this.basisFields[s]}return a},prepareBasisFields:function(){var t,e,i=[];for(t=0;t<this.basisFields.length;++t){e=this.basisFields[t];if(e["Id"]!=="DATE_CREATE"&&e["Id"]!=="DATE_MODIFY"&&e["Id"]!=="EVENT_DATE"&&e["Id"]!=="BIRTHDATE")i.push(e)}this.basisFields=i}};var f={setRobotSettingsDialog:function(t){this.robotSettingsDialog=t},getRobotSettingsDialog:function(){return this.robotSettingsDialog}};var g=function(e){this.basis=g.Basis.CurrentDateTime;this.type=g.Type.After;this.value=0;this.valueType="i";this.workTime=false;if(t.type.isPlainObject(e)){if(e["type"])this.setType(e["type"]);if(e["value"])this.setValue(e["value"]);if(e["valueType"])this.setValueType(e["valueType"]);if(e["basis"])this.setBasis(e["basis"]);if(e["workTime"])this.setWorkTime(e["workTime"])}};g.Type={After:"after",Before:"before",In:"in"};g.Basis={CurrentDate:"{=System:Date}",CurrentDateTime:"{=System:Now}"};g.fromString=function(e,i){e=e.toString();var a={basis:g.Basis.CurrentDateTime,i:0,h:0,d:0,workTime:false};if(e.indexOf("=dateadd(")===0||e.indexOf("=workdateadd(")===0){if(e.indexOf("=workdateadd(")===0){e=e.substr(13);a["workTime"]=true}else{e=e.substr(9)}var s=e.split(",");a["basis"]=s[0].trim();s[1]=s[1].replace(/['")]+/g,"");a["type"]=s[1].indexOf("-")===0?g.Type.Before:g.Type.After;var o,n=/s*([\d]+)\s*(i|h|d)\s*/gi;while(o=n.exec(s[1])){a[o[2]]=parseInt(o[1])}}else{a["basis"]=e}if(a["basis"]!==g.Basis.CurrentDateTime&&a["basis"]!==g.Basis.CurrentDate&&t.type.isArray(i)){var r=false;for(var l=0,d=i.length;l<d;++l){if(a["basis"]===i[l].SystemExpression||a["basis"]===i[l].Expression){a["basis"]=i[l].SystemExpression;r=true;break}}if(!r){a["basis"]=g.Basis.CurrentDateTime}}var p=a["i"]+a["h"]*60+a["d"]*60*24;if(p%1440===0){a["value"]=p/1440;a["valueType"]="d"}else if(p%60===0){a["value"]=p/60;a["valueType"]="h"}else{a["value"]=p;a["valueType"]="i"}if(!a["value"]&&a["basis"]!==g.Basis.CurrentDateTime&&a["basis"]){a["type"]=g.Type.In}return new g(a)};g.prototype={setType:function(t){if(t!==g.Type.After&&t!==g.Type.Before&&t!==g.Type.In){t=g.Type.After}this.type=t},setValue:function(t){t=parseInt(t);this.value=t>=0?t:0},setValueType:function(t){if(t!=="i"&&t!=="h"&&t!=="d")t="i";this.valueType=t},setBasis:function(e){if(t.type.isNotEmptyString(e))this.basis=e},setWorkTime:function(t){this.workTime=!!t},isNow:function(){return this.type===g.Type.After&&this.basis===g.Basis.CurrentDateTime&&!this.value},setNow:function(){this.setType(g.Type.After);this.setValue(0);this.setValueType("i");this.setBasis(g.Basis.CurrentDateTime)},serialize:function(){return{type:this.type,value:this.value,valueType:this.valueType,basis:this.basis,workTime:this.workTime?1:0}},toExpression:function(e){var i=this.basis?this.basis:g.Basis.CurrentDate;if(i!==g.Basis.CurrentDateTime&&i!==g.Basis.CurrentDate&&t.type.isArray(e)){for(var a=0,s=e.length;a<s;++a){if(i===e[a].SystemExpression){i=e[a].Expression;break}}}if(!this.workTime&&(this.type===g.Type.In||this.isNow())){return i}var o=0,n=0,r=0;switch(this.valueType){case"i":r=this.value;break;case"h":n=this.value;break;case"d":o=this.value;break}var l="";if(this.type===g.Type.Before)l="-";if(o>0)l+=o+"d";if(n>0)l+=n+"h";if(r>0)l+=r+"i";var d=this.workTime?"workdateadd":"dateadd";if(d==="workdateadd"&&l===""){l="0d"}return"="+d+"("+i+',"'+l+'")'}};var T=function(e){this.field="";this.operator="!empty";this.value="";if(t.type.isPlainObject(e)){if(e["field"]){this.setField(e["field"])}if(e["operator"]){this.setOperator(e["operator"])}if("value"in e){this.setValue(e["value"])}}};T.prototype={setField:function(e){if(t.type.isNotEmptyString(e)){this.field=e}},setOperator:function(t){if(!t){t="="}this.operator=t},setValue:function(t){this.value=t;if(this.operator==="="&&this.value===""){this.operator="empty"}else if(this.operator==="!="&&this.value===""){this.operator="!empty"}},serialize:function(){var t=this.operator;var e=this.value;if(this.operator==="empty"){t="=";e=""}else if(this.operator==="!empty"){t="!=";e=""}return{field:this.field,operator:t,value:e}}};var v=function(e){this.type=v.Type.Field;this.items=[];if(t.type.isPlainObject(e)){if(e["type"]){this.type=e["type"]}if(t.type.isArray(e["items"])){var i=this;e["items"].forEach(function(t){var e=new T(t[0]);i.addItem(e,t[1])})}}};v.Type={Field:"field"};v.Joiner={And:"AND",Or:"OR"};v.prototype={addItem:function(t,e){this.items.push([t,e])},serialize:function(){var t=[];this.items.forEach(function(e){t.push([e[0].serialize(),e[1]])});return{type:this.type,items:t}}};var _=function(e,i){this.conditionGroup=e;this.fields=[];if(t.type.isPlainObject(i)){if(t.type.isArray(i.fields)){this.fields=i.fields}}};_.prototype={createNode:function(){var e=this,i=[],a=this.fields;this.conditionGroup.items.forEach(function(t){var e=new N(t[0],{fields:a});i.push(e.createNode())});i.push(t.create("span",{attrs:{className:"crm-automation-popup-settings-link"},text:"[+]",events:{click:function(){e.addItem(this)}}}));var s=t.create("span",{attrs:{className:"crm-automation-popup-settings-link-wrapper"},children:i});return s},addItem:function(t){var e=new N(new T,{fields:this.fields});t.parentNode.insertBefore(e.createNode(),t)}};var N=function(e,i){this.condition=e;this.fields=[];if(t.type.isPlainObject(i)){if(t.type.isArray(i.fields)){this.fields=i.fields}}};N.prototype={createNode:function(){var e=this.fieldNode=t.create("input",{attrs:{type:"hidden",name:"condition_field[]",value:this.condition.field}});var i=this.operatorNode=t.create("input",{attrs:{type:"hidden",name:"condition_operator[]",value:this.condition.operator}});var a=this.valueNode=t.create("input",{attrs:{type:"hidden",name:"condition_value[]",value:this.condition.value}});var s=t.create("input",{attrs:{type:"hidden",name:"condition_joiner[]",value:v.Joiner.And}});var o=this.labelNode=t.create("span",{attrs:{className:"crm-automation-popup-settings-link-wrapper"}});this.setLabelText();this.bindLabelNode();var n=t.create("span",{attrs:{className:"crm-automation-popup-settings-link-remove"},events:{click:this.removeCondition.bind(this)}});this.node=t.create("span",{attrs:{className:"crm-automation-popup-settings-link-wrapper"},children:[e,i,a,s,o,n]});return this.node},init:function(t){this.condition=t;this.setLabelText();this.bindLabelNode()},setLabelText:function(){if(!this.labelNode||!this.condition)return;t.cleanNode(this.labelNode);if(this.condition.field!==""){var e=this.getField(this.condition.field)||"?";var i=this.condition.value;if(i&&e["Type"]==="bool"){i=t.message(this.condition.value==="Y"?"CRM_AUTOMATION_YES":"CRM_AUTOMATION_NO")}else if(i&&e["Type"]==="select"&&e["Options"][this.condition.value]){i=e["Options"][this.condition.value]}this.labelNode.appendChild(t.create("span",{attrs:{className:"crm-automation-popup-settings-link"},text:e.Name}));this.labelNode.appendChild(t.create("span",{attrs:{className:"crm-automation-popup-settings-link"},text:this.getOperatorLabel(this.condition.operator)}));if(i){this.labelNode.appendChild(t.create("span",{attrs:{className:"crm-automation-popup-settings-link"},text:i}))}}else{this.labelNode.appendChild(t.create("span",{attrs:{className:"crm-automation-popup-settings-link"},text:t.message("CRM_AUTOMATION_ROBOT_CONDITION_EMPTY")}))}},bindLabelNode:function(){if(this.labelNode){t.bind(this.labelNode,"click",t.delegate(this.onLabelClick,this))}},onLabelClick:function(t){this.showPopup()},showPopup:function(){var e=this,i=this.filterFields();var a=t.create("select",{attrs:{className:"crm-automation-popup-settings-dropdown"}});for(var s=0;s<i.length;++s){a.appendChild(t.create("option",{props:{value:i[s]["Id"]},text:i[s]["Name"]}))}var o=this.getField(this.condition.field);if(!o)o=i[0];var n=this.condition.operator.indexOf("empty")<0?this.createValueNode(o):null;var r=t.create("div",{attrs:{className:"crm-automation-popup-settings"},children:[n]});var l=this.createOperatorNode(o,r);var d=t.create("div",{attrs:{className:"crm-automation-popup-settings"},children:[l]});if(this.condition.field!==""){a.value=this.condition.field;l.value=this.condition.operator;if(n){n.value=this.condition.value}}var p=t.create("form",{attrs:{className:"crm-automation-popup-select-block"},children:[t.create("div",{attrs:{className:"crm-automation-popup-settings"},children:[a]}),d,r]});t.bind(a,"change",this.onFieldChange.bind(this,a,d,r));var u=new t.PopupWindow("crm-automation-popup-set",this.labelNode,{className:"crm-automation-popup-set",autoHide:true,closeByEsc:true,closeIcon:false,titleBar:false,zIndex:0,angle:true,offsetLeft:45,content:p,buttons:[new t.PopupWindowButton({text:t.message("CRM_AUTOMATION_CMP_CHOOSE"),className:"webform-button webform-button-create",events:{click:function(){e.condition.setField(a.value);e.condition.setOperator(d.firstChild.value);if(r.firstChild){e.condition.setValue(r.firstChild.value)}else{e.condition.setValue("")}e.setLabelText();e.updateValueNodes();this.popupWindow.close()}}})],overlay:{backgroundColor:"transparent"}});u.show()},updateValueNodes:function(){if(this.condition){if(this.fieldNode){this.fieldNode.value=this.condition.field}if(this.operatorNode){this.operatorNode.value=this.condition.operator}if(this.valueNode){this.valueNode.value=this.condition.value}}},onFieldChange:function(t,e,i){var a=this.getField(t.value);var s=this.createOperatorNode(a,i);e.replaceChild(s,e.firstChild);this.onOperatorChange(s,a,i)},onOperatorChange:function(e,i,a){t.cleanNode(a);if(e.value.indexOf("empty")<0){var s=this.createValueNode(i);a.appendChild(s)}},getField:function(t){var e=null;for(var i=0;i<this.fields.length;++i){if(t===this.fields[i].Id){e=this.fields[i]}}return e},getOperators:function(e){var i;switch(e){case"bool":case"select":i={"!empty":t.message("CRM_AUTOMATION_ROBOT_CONDITION_NOT_EMPTY"),empty:t.message("CRM_AUTOMATION_ROBOT_CONDITION_EMPTY"),"=":t.message("CRM_AUTOMATION_ROBOT_CONDITION_EQ"),"!=":t.message("CRM_AUTOMATION_ROBOT_CONDITION_NE")};break;default:i={"!empty":t.message("CRM_AUTOMATION_ROBOT_CONDITION_NOT_EMPTY"),empty:t.message("CRM_AUTOMATION_ROBOT_CONDITION_EMPTY"),"=":t.message("CRM_AUTOMATION_ROBOT_CONDITION_EQ"),">":t.message("CRM_AUTOMATION_ROBOT_CONDITION_GT"),">=":t.message("CRM_AUTOMATION_ROBOT_CONDITION_GTE"),"<":t.message("CRM_AUTOMATION_ROBOT_CONDITION_LT"),"<=":t.message("CRM_AUTOMATION_ROBOT_CONDITION_LTE"),"!=":t.message("CRM_AUTOMATION_ROBOT_CONDITION_NE"),in:t.message("CRM_AUTOMATION_ROBOT_CONDITION_IN"),contain:t.message("CRM_AUTOMATION_ROBOT_CONDITION_CONTAIN")}}return i},getOperatorLabel:function(t){return this.getOperators()[t]},filterFields:function(){var t,e,i=[];for(t=0;t<this.fields.length;++t){e=this.fields[t]["Type"];if(e=="bool"||e=="double"||e=="int"||e=="select"||e=="string"||e=="text"){i.push(this.fields[t])}}return i},createValueNode:function(e){var i;switch(e["Type"]){case"bool":i=t.create("select",{attrs:{className:"crm-automation-popup-settings-dropdown"},children:[t.create("option",{props:{value:"Y"},text:t.message("CRM_AUTOMATION_YES")}),t.create("option",{props:{value:"N"},text:t.message("CRM_AUTOMATION_NO")})]});break;case"select":i=t.create("select",{attrs:{className:"crm-automation-popup-settings-dropdown"}});var a=e["Options"];for(var s in a){if(!a.hasOwnProperty(s))continue;i.appendChild(t.create("option",{props:{value:s},text:a[s]}))}break;default:i=t.create("input",{attrs:{className:"crm-automation-popup-input",type:"text"}})}return i},createOperatorNode:function(e,i){var a=t.create("select",{attrs:{className:"crm-automation-popup-settings-dropdown"}});var s=this.getOperators(e["Type"]);for(var o in s){if(!s.hasOwnProperty(o))continue;a.appendChild(t.create("option",{props:{value:o},text:s[o]}))}t.bind(a,"change",this.onOperatorChange.bind(this,a,e,i));return a},removeCondition:function(e){this.condition=null;t.remove(this.node);this.labelNode=this.fieldNode=this.operatorNode=this.valueNode=this.node=null;e.stopPropagation()}};var b=function(e,i,a){var s=i,o;if(e.type==g.Type.In){s=t.message("CRM_AUTOMATION_CMP_IN_TIME");if(t.type.isArray(a)){for(var n=0;n<a.length;++n){if(e.basis==a[n].SystemExpression){s+=" "+a[n].Name;break}}}}else if(e.value){o=e.type==g.Type.After?t.message("CRM_AUTOMATION_CMP_THROUGH"):t.message("CRM_AUTOMATION_CMP_FOR_TIME");s=o+" "+A(e.value,e.valueType);if(t.type.isArray(a)){for(var n=0;n<a.length;++n){if(e.basis==a[n].SystemExpression){s+=" "+t.message("CRM_AUTOMATION_CMP_BEFORE")+" "+a[n].Name;break}}}}if(e.workTime){s+=", "+t.message("CRM_AUTOMATION_CMP_IN_WORKTIME")}return s};var I=function(e){var i=[];if(e==="i")i=[t.message("CRM_AUTOMATION_CMP_MIN1"),t.message("CRM_AUTOMATION_CMP_MIN2"),t.message("CRM_AUTOMATION_CMP_MIN3")];else if(e==="h")i=[t.message("CRM_AUTOMATION_CMP_HOUR1"),t.message("CRM_AUTOMATION_CMP_HOUR2"),t.message("CRM_AUTOMATION_CMP_HOUR3")];else if(e==="d")i=[t.message("CRM_AUTOMATION_CMP_DAY1"),t.message("CRM_AUTOMATION_CMP_DAY2"),t.message("CRM_AUTOMATION_CMP_DAY3")];return i};var A=function(t,e){var i=t+" ";var a=0;if(t>20)t=t%10;if(t==1)a=0;else if(t>1&&t<5)a=1;else a=2;var s=I(e);return i+(s?s[a]:"")};var C={popupHint:null,bindToNode:function(e){t.bind(e,"mouseover",t.proxy(function(){this.showHint(t.proxy_context)},this));t.bind(e,"mouseout",t.delegate(this.hideHint,this))},showHint:function(e){var i=e.getAttribute("data-text");if(!i)return;var a=t.util.htmlspecialchars(i);a=t.util.nl2br(a);if(!t.type.isNotEmptyString(a))return;this.popupHint=new t.PopupWindow("crm-automation-help-tip",e,{lightShadow:true,autoHide:false,darkMode:true,offsetLeft:0,offsetTop:2,bindOptions:{position:"top"},zIndex:1100,events:{onPopupClose:function(){this.destroy()}},content:t.create("div",{attrs:{style:"padding-right: 5px; width: 250px;"},html:a})});this.popupHint.setAngle({offset:32,position:"bottom"});this.popupHint.show();return true},hideHint:function(){if(this.popupHint)this.popupHint.close();this.popupHint=null}};return{Component:e,TriggerManager:o,TemplateManager:i,Template:a,Robot:s,Trigger:n,Tracker:r,Runtime:f}}(window.BX||window.top.BX);