<?php

require_once($_SERVER["DOCUMENT_ROOT"]."/bitrix/modules/catalog/general/vat.php");

class CCatalogVat extends CAllCatalogVat
{
	public static function GetListEx($arOrder = array(), $arFilter = array(), $arGroupBy = false, $arNavStartParams = false, $arSelectFields = array())
	{
		global $DB;

		if (empty($arSelectFields) || !is_array($arSelectFields))
		{
			$arSelectFields = [
				'ID',
				'TIMESTAMP_X',
				'ACTIVE',
				'C_SORT',
				'NAME',
				'RATE',
				'EXCLUDE_VAT',
				'XML_ID',
			];
		}

		$arFields = [
			'ID' => ["FIELD" => "CV.ID", "TYPE" => "int"],
			'TIMESTAMP_X' => ["FIELD" => "CV.TIMESTAMP_X", "TYPE" => "datetime"],
			'ACTIVE' => ["FIELD" => "CV.ACTIVE", "TYPE" => "char"],
			'C_SORT' => ["FIELD" => "CV.C_SORT", "TYPE" => "int"],
			'SORT' => ["FIELD" => "CV.C_SORT", "TYPE" => "int"],
			'NAME' => ["FIELD" => "CV.NAME", "TYPE" => "string"],
			'RATE' => ["FIELD" => "CV.RATE", "TYPE" => "double"],
			'EXCLUDE_VAT' => ["FIELD" => "CV.EXCLUDE_VAT", "TYPE" => "char"],
			'XML_ID' => ["FIELD" => "CV.XML_ID", "TYPE" => "string"],
		];

		$arSqls = CCatalog::PrepareSql($arFields, $arOrder, $arFilter, $arGroupBy, $arSelectFields);

		$arSqls["SELECT"] = str_replace("%%_DISTINCT_%%", "", $arSqls["SELECT"]);

		if (empty($arGroupBy) && is_array($arGroupBy))
		{
			$strSql = "SELECT ".$arSqls["SELECT"]." FROM b_catalog_vat CV ".$arSqls["FROM"];
			if (!empty($arSqls["WHERE"]))
				$strSql .= " WHERE ".$arSqls["WHERE"];
			if (!empty($arSqls["GROUPBY"]))
				$strSql .= " GROUP BY ".$arSqls["GROUPBY"];

			$dbRes = $DB->Query($strSql);
			if ($arRes = $dbRes->Fetch())
				return $arRes["CNT"];
			else
				return false;
		}

		$strSql = "SELECT ".$arSqls["SELECT"]." FROM b_catalog_vat CV ".$arSqls["FROM"];
		if (!empty($arSqls["WHERE"]))
			$strSql .= " WHERE ".$arSqls["WHERE"];
		if (!empty($arSqls["GROUPBY"]))
			$strSql .= " GROUP BY ".$arSqls["GROUPBY"];
		if (!empty($arSqls["ORDERBY"]))
			$strSql .= " ORDER BY ".$arSqls["ORDERBY"];

		$intTopCount = 0;
		$boolNavStartParams = (!empty($arNavStartParams) && is_array($arNavStartParams));
		if ($boolNavStartParams && array_key_exists('nTopCount', $arNavStartParams))
		{
			$intTopCount = intval($arNavStartParams["nTopCount"]);
		}
		if ($boolNavStartParams && 0 >= $intTopCount)
		{
			$strSql_tmp = "SELECT COUNT('x') as CNT FROM b_catalog_vat CV ".$arSqls["FROM"];
			if (!empty($arSqls["WHERE"]))
				$strSql_tmp .= " WHERE ".$arSqls["WHERE"];
			if (!empty($arSqls["GROUPBY"]))
				$strSql_tmp .= " GROUP BY ".$arSqls["GROUPBY"];

			$dbRes = $DB->Query($strSql_tmp);
			$cnt = 0;
			if (empty($arSqls["GROUPBY"]))
			{
				if ($arRes = $dbRes->Fetch())
					$cnt = $arRes["CNT"];
			}
			else
			{
				$cnt = $dbRes->SelectedRowsCount();
			}

			$dbRes = new CDBResult();

			$dbRes->NavQuery($strSql, $cnt, $arNavStartParams);
		}
		else
		{
			if ($boolNavStartParams && 0 < $intTopCount)
			{
				$strSql .= " LIMIT ".$intTopCount;
			}
			$dbRes = $DB->Query($strSql);
		}

		return $dbRes;
	}
}
