
CREATE TABLE b_catalog_iblock (
  IBLOCK_ID int NOT NULL,
  YANDEX_EXPORT char(1) NOT NULL DEFAULT 'N',
  SUBSCRIPTION char(1) NOT NULL DEFAULT 'N',
  VAT_ID int DEFAULT '0',
  PRODUCT_IBLOCK_ID int NOT NULL DEFAULT '0',
  SKU_PROPERTY_ID int NOT NULL DEFAULT '0',
  PRIMARY KEY (IBLOCK_ID)
);
CREATE INDEX ix_b_catalog_iblock_product_iblock_id ON b_catalog_iblock (product_iblock_id);
CREATE INDEX ix_b_catalog_iblock_sku_property_id ON b_catalog_iblock (sku_property_id);

CREATE TABLE b_catalog_price (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PRODUCT_ID int NOT NULL,
  EXTRA_ID int,
  CATALOG_GROUP_ID int NOT NULL,
  PRICE decimal NOT NULL,
  CURRENCY char(3) NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  QUANTITY_FROM int,
  QUANTITY_TO int,
  TMP_ID varchar(40),
  PRICE_SCALE decimal,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_price_product_id_catalog_group_id ON b_catalog_price (product_id, catalog_group_id);
CREATE INDEX ix_b_catalog_price_catalog_group_id ON b_catalog_price (catalog_group_id);
CREATE INDEX ix_b_catalog_price_price_scale ON b_catalog_price (price_scale);

CREATE TABLE b_catalog_product (
  ID int NOT NULL,
  QUANTITY double precision NOT NULL,
  QUANTITY_TRACE char(1) NOT NULL DEFAULT 'N',
  WEIGHT double precision NOT NULL DEFAULT '0',
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRICE_TYPE char(1) NOT NULL DEFAULT 'S',
  RECUR_SCHEME_LENGTH int,
  RECUR_SCHEME_TYPE char(1) NOT NULL DEFAULT 'D',
  TRIAL_PRICE_ID int,
  WITHOUT_ORDER char(1) NOT NULL DEFAULT 'N',
  SELECT_BEST_PRICE char(1) NOT NULL DEFAULT 'Y',
  VAT_ID int DEFAULT '0',
  VAT_INCLUDED char(1) DEFAULT 'Y',
  CAN_BUY_ZERO char(1) NOT NULL DEFAULT 'N',
  NEGATIVE_AMOUNT_TRACE char(1) NOT NULL DEFAULT 'D',
  TMP_ID varchar(40),
  PURCHASING_PRICE decimal,
  PURCHASING_CURRENCY char(3),
  BARCODE_MULTI char(1) NOT NULL DEFAULT 'N',
  QUANTITY_RESERVED double precision DEFAULT '0',
  SUBSCRIBE char(1),
  WIDTH double precision,
  LENGTH double precision,
  HEIGHT double precision,
  MEASURE int,
  TYPE int,
  AVAILABLE char(1),
  BUNDLE char(1),
  PRIMARY KEY (ID)
);

CREATE TABLE b_catalog_product2group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PRODUCT_ID int NOT NULL,
  GROUP_ID int NOT NULL,
  ACCESS_LENGTH int NOT NULL,
  ACCESS_LENGTH_TYPE char(1) NOT NULL DEFAULT 'D',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_catalog_product2group_product_id_group_id ON b_catalog_product2group (product_id, group_id);

CREATE TABLE b_catalog_extra (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(50) NOT NULL,
  PERCENTAGE decimal NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_catalog_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(100) NOT NULL,
  BASE char(1) NOT NULL DEFAULT 'N',
  SORT int NOT NULL DEFAULT '100',
  XML_ID varchar(255),
  TIMESTAMP_X timestamp,
  MODIFIED_BY int,
  DATE_CREATE timestamp,
  CREATED_BY int,
  PRIMARY KEY (ID)
);

CREATE TABLE b_catalog_group_lang (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CATALOG_GROUP_ID int NOT NULL,
  LANG char(2) NOT NULL,
  NAME varchar(100),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_catalog_group_lang_catalog_group_id_lang ON b_catalog_group_lang (catalog_group_id, lang);

CREATE TABLE b_catalog_group2group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CATALOG_GROUP_ID int NOT NULL,
  GROUP_ID int NOT NULL,
  BUY char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_catalog_group2group_catalog_group_id_group_id_buy ON b_catalog_group2group (catalog_group_id, group_id, buy);

CREATE TABLE b_catalog_load (
  NAME varchar(250) NOT NULL,
  VALUE text NOT NULL,
  TYPE char(1) NOT NULL DEFAULT 'I',
  LAST_USED char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (NAME, TYPE)
);

CREATE TABLE b_catalog_export (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FILE_NAME varchar(100) NOT NULL,
  NAME varchar(250) NOT NULL,
  DEFAULT_PROFILE char(1) NOT NULL DEFAULT 'N',
  IN_MENU char(1) NOT NULL DEFAULT 'N',
  IN_AGENT char(1) NOT NULL DEFAULT 'N',
  IN_CRON char(1) NOT NULL DEFAULT 'N',
  SETUP_VARS text,
  LAST_USE timestamp,
  IS_EXPORT char(1) NOT NULL DEFAULT 'Y',
  NEED_EDIT char(1) NOT NULL DEFAULT 'N',
  TIMESTAMP_X timestamp,
  MODIFIED_BY int,
  DATE_CREATE timestamp,
  CREATED_BY int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_export_file_name ON b_catalog_export (file_name);
CREATE INDEX ix_b_catalog_export_is_export ON b_catalog_export (is_export);

CREATE TABLE b_catalog_discount (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  XML_ID varchar(255),
  SITE_ID char(2) NOT NULL,
  TYPE int NOT NULL DEFAULT '0',
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  ACTIVE_FROM timestamp,
  ACTIVE_TO timestamp,
  RENEWAL char(1) NOT NULL DEFAULT 'N',
  NAME varchar(255),
  MAX_USES int NOT NULL DEFAULT '0',
  COUNT_USES int NOT NULL DEFAULT '0',
  COUPON varchar(20),
  SORT int NOT NULL DEFAULT '100',
  MAX_DISCOUNT decimal,
  VALUE_TYPE char(1) NOT NULL DEFAULT 'P',
  VALUE decimal NOT NULL DEFAULT '0.0',
  CURRENCY char(3) NOT NULL,
  MIN_ORDER_SUM decimal DEFAULT '0.0',
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  COUNT_PERIOD char(1) NOT NULL DEFAULT 'U',
  COUNT_SIZE int NOT NULL DEFAULT '0',
  COUNT_TYPE char(1) NOT NULL DEFAULT 'Y',
  COUNT_FROM timestamp,
  COUNT_TO timestamp,
  ACTION_SIZE int NOT NULL DEFAULT '0',
  ACTION_TYPE char(1) NOT NULL DEFAULT 'Y',
  MODIFIED_BY int,
  DATE_CREATE timestamp,
  CREATED_BY int,
  PRIORITY int NOT NULL DEFAULT 1,
  LAST_DISCOUNT char(1) NOT NULL DEFAULT 'Y',
  VERSION int NOT NULL DEFAULT 1,
  NOTES varchar(255),
  CONDITIONS text,
  UNPACK text,
  USE_COUPONS char(1) NOT NULL DEFAULT 'N',
  SALE_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_discount_active_active_from_active_to ON b_catalog_discount (active, active_from, active_to);
CREATE INDEX ix_b_catalog_discount_site_id_renewal_active_active_from_active ON b_catalog_discount (site_id, renewal, active, active_from, active_to);
CREATE INDEX ix_b_catalog_discount_use_coupons ON b_catalog_discount (use_coupons);

CREATE TABLE b_catalog_discount_cond (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  ACTIVE char(1),
  USER_GROUP_ID int NOT NULL DEFAULT -1,
  PRICE_TYPE_ID int NOT NULL DEFAULT -1,
  PRIMARY KEY (ID)
);

CREATE TABLE b_catalog_discount_module (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_discount_module_discount_id ON b_catalog_discount_module (discount_id);

CREATE TABLE b_catalog_discount_entity (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  MODULE_ID varchar(50) NOT NULL,
  ENTITY varchar(255) NOT NULL,
  ENTITY_ID int,
  ENTITY_VALUE varchar(255),
  FIELD_ENTITY varchar(255) NOT NULL,
  FIELD_TABLE varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_discount_entity_discount_id_module_id_entity ON b_catalog_discount_entity (discount_id, module_id, entity);

CREATE TABLE b_catalog_discount2product (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  PRODUCT_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_catalog_discount2product_product_id_discount_id ON b_catalog_discount2product (product_id, discount_id);
CREATE UNIQUE INDEX ux_b_catalog_discount2product_discount_id_product_id ON b_catalog_discount2product (discount_id, product_id);

CREATE TABLE b_catalog_discount2group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  GROUP_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_catalog_discount2group_group_id_discount_id ON b_catalog_discount2group (group_id, discount_id);
CREATE UNIQUE INDEX ux_b_catalog_discount2group_discount_id_group_id ON b_catalog_discount2group (discount_id, group_id);

CREATE TABLE b_catalog_discount2cat (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  CATALOG_GROUP_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_catalog_discount2cat_catalog_group_id_discount_id ON b_catalog_discount2cat (catalog_group_id, discount_id);
CREATE UNIQUE INDEX ux_b_catalog_discount2cat_discount_id_catalog_group_id ON b_catalog_discount2cat (discount_id, catalog_group_id);

CREATE TABLE b_catalog_discount2section (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  SECTION_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_catalog_discount2section_section_id_discount_id ON b_catalog_discount2section (section_id, discount_id);
CREATE UNIQUE INDEX ux_b_catalog_discount2section_discount_id_section_id ON b_catalog_discount2section (discount_id, section_id);

CREATE TABLE b_catalog_discount2iblock (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  IBLOCK_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_catalog_discount2iblock_iblock_id_discount_id ON b_catalog_discount2iblock (iblock_id, discount_id);
CREATE UNIQUE INDEX ux_b_catalog_discount2iblock_discount_id_iblock_id ON b_catalog_discount2iblock (discount_id, iblock_id);

CREATE TABLE b_catalog_discount_coupon (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  COUPON varchar(32) NOT NULL,
  DATE_APPLY timestamp,
  ONE_TIME char(1) NOT NULL DEFAULT 'Y',
  TIMESTAMP_X timestamp,
  MODIFIED_BY int,
  DATE_CREATE timestamp,
  CREATED_BY int,
  DESCRIPTION text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_catalog_discount_coupon_discount_id_coupon ON b_catalog_discount_coupon (discount_id, coupon);
CREATE INDEX ix_b_catalog_discount_coupon_coupon_active ON b_catalog_discount_coupon (coupon, active);

CREATE TABLE b_catalog_vat (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  C_SORT int NOT NULL DEFAULT 100,
  NAME varchar(50) NOT NULL DEFAULT '',
  RATE decimal DEFAULT '0.00',
  EXCLUDE_VAT char(1) NOT NULL DEFAULT 'N',
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_vat_active ON b_catalog_vat (active);

CREATE TABLE b_catalog_disc_save_range (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  RANGE_FROM double precision NOT NULL,
  TYPE char(1) NOT NULL DEFAULT 'P',
  VALUE double precision NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_disc_save_range_discount_id_range_from ON b_catalog_disc_save_range (discount_id, range_from);

CREATE TABLE b_catalog_disc_save_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  GROUP_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_disc_save_group_discount_id ON b_catalog_disc_save_group (discount_id);
CREATE INDEX ix_b_catalog_disc_save_group_group_id ON b_catalog_disc_save_group (group_id);

CREATE TABLE b_catalog_disc_save_user (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DISCOUNT_ID int NOT NULL,
  USER_ID int NOT NULL,
  ACTIVE_FROM timestamp NOT NULL,
  ACTIVE_TO timestamp NOT NULL,
  RANGE_FROM double precision NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_disc_save_user_discount_id_user_id ON b_catalog_disc_save_user (discount_id, user_id);

CREATE TABLE b_catalog_store (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TITLE varchar(75),
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  ADDRESS varchar(245) NOT NULL,
  DESCRIPTION text,
  GPS_N varchar(15) DEFAULT 0,
  GPS_S varchar(15) DEFAULT 0,
  IMAGE_ID int,
  LOCATION_ID int,
  DATE_MODIFY timestamp DEFAULT CURRENT_TIMESTAMP,
  DATE_CREATE timestamp,
  USER_ID int,
  MODIFIED_BY int,
  PHONE varchar(45),
  SCHEDULE varchar(255),
  XML_ID varchar(255),
  SORT int NOT NULL DEFAULT '100',
  EMAIL varchar(255),
  ISSUING_CENTER char(1) NOT NULL DEFAULT 'Y',
  SHIPPING_CENTER char(1) NOT NULL DEFAULT 'Y',
  SITE_ID char(2),
  CODE varchar(255),
  IS_DEFAULT char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);

CREATE TABLE b_catalog_store_product (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PRODUCT_ID int NOT NULL,
  AMOUNT double precision NOT NULL DEFAULT 0,
  STORE_ID int NOT NULL,
  QUANTITY_RESERVED double precision NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_store_product_store_id ON b_catalog_store_product (store_id);
CREATE UNIQUE INDEX ux_b_catalog_store_product_product_id_store_id ON b_catalog_store_product (product_id, store_id);

CREATE TABLE b_catalog_store_barcode (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PRODUCT_ID int NOT NULL,
  BARCODE varchar(100),
  STORE_ID int,
  ORDER_ID int,
  DATE_MODIFY timestamp,
  DATE_CREATE timestamp,
  CREATED_BY int,
  MODIFIED_BY int,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_catalog_store_barcode_barcode ON b_catalog_store_barcode (barcode);
CREATE INDEX ix_b_catalog_store_barcode_product_id ON b_catalog_store_barcode (product_id);

CREATE TABLE b_catalog_contractor (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PERSON_TYPE char(1) NOT NULL,
  PERSON_NAME varchar(100),
  PERSON_LASTNAME varchar(100),
  PERSON_MIDDLENAME varchar(100),
  EMAIL varchar(100),
  PHONE varchar(45),
  POST_INDEX varchar(45),
  COUNTRY varchar(45),
  CITY varchar(45),
  COMPANY varchar(145),
  INN varchar(145),
  KPP varchar(145),
  ADDRESS varchar(255),
  DATE_MODIFY timestamp DEFAULT CURRENT_TIMESTAMP,
  DATE_CREATE timestamp,
  CREATED_BY int,
  MODIFIED_BY int,
  PRIMARY KEY (ID)
);

CREATE TABLE b_catalog_store_docs (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DOC_TYPE char(1) NOT NULL,
  SITE_ID char(2),
  CONTRACTOR_ID int,
  DATE_MODIFY timestamp,
  DATE_CREATE timestamp,
  CREATED_BY int,
  MODIFIED_BY int,
  CURRENCY char(3),
  STATUS char(1) NOT NULL DEFAULT 'N',
  DATE_STATUS timestamp,
  DATE_DOCUMENT timestamp,
  STATUS_BY int,
  TOTAL double precision,
  COMMENTARY varchar(1000),
  TITLE varchar(255),
  RESPONSIBLE_ID int,
  ITEMS_ORDER_DATE timestamp,
  ITEMS_RECEIVED_DATE timestamp,
  DOC_NUMBER varchar(64),
  WAS_CANCELLED char(1) DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_store_docs_mobile ON b_catalog_store_docs (doc_type, date_modify);

CREATE TABLE b_catalog_store_document_file (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DOCUMENT_ID int NOT NULL,
  FILE_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_store_document_file_document_id ON b_catalog_store_document_file (document_id);

CREATE TABLE b_catalog_docs_element (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DOC_ID int NOT NULL,
  STORE_FROM int,
  STORE_TO int,
  ELEMENT_ID int,
  AMOUNT double precision,
  PURCHASING_PRICE double precision,
  BASE_PRICE decimal,
  BASE_PRICE_EXTRA decimal,
  BASE_PRICE_EXTRA_RATE int,
  COMMENT text DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_docs_element_doc_id ON b_catalog_docs_element (doc_id);
CREATE INDEX ix_b_catalog_docs_element_element_id ON b_catalog_docs_element (element_id);
CREATE INDEX ix_b_catalog_docs_element_store_from ON b_catalog_docs_element (store_from);
CREATE INDEX ix_b_catalog_docs_element_store_to ON b_catalog_docs_element (store_to);

CREATE TABLE b_catalog_docs_barcode (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DOC_ID int NOT NULL,
  DOC_ELEMENT_ID int NOT NULL,
  BARCODE varchar(100) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_docs_barcode_doc_element_id ON b_catalog_docs_barcode (doc_element_id);
CREATE INDEX ix_b_catalog_docs_barcode_doc_id ON b_catalog_docs_barcode (doc_id);

CREATE TABLE b_catalog_measure (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE int NOT NULL,
  MEASURE_TITLE varchar(500),
  SYMBOL_RUS varchar(20),
  SYMBOL_INTL varchar(20),
  SYMBOL_LETTER_INTL varchar(20),
  IS_DEFAULT char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_catalog_measure_code ON b_catalog_measure (code);

CREATE TABLE b_catalog_measure_ratio (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PRODUCT_ID int NOT NULL,
  RATIO double precision NOT NULL DEFAULT '1',
  IS_DEFAULT char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_catalog_measure_ratio_product_id_ratio ON b_catalog_measure_ratio (product_id, ratio);

CREATE TABLE b_catalog_product_sets (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TYPE int NOT NULL,
  SET_ID int NOT NULL,
  ACTIVE char(1) NOT NULL,
  OWNER_ID int NOT NULL,
  ITEM_ID int NOT NULL,
  QUANTITY double precision,
  MEASURE int,
  DISCOUNT_PERCENT double precision,
  SORT int NOT NULL DEFAULT 100,
  CREATED_BY int,
  DATE_CREATE timestamp,
  MODIFIED_BY int,
  TIMESTAMP_X timestamp,
  XML_ID varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_product_sets_type ON b_catalog_product_sets (type);
CREATE INDEX ix_b_catalog_product_sets_owner_id ON b_catalog_product_sets (owner_id);
CREATE INDEX ix_b_catalog_product_sets_set_id ON b_catalog_product_sets (set_id);
CREATE INDEX ix_b_catalog_product_sets_item_id ON b_catalog_product_sets (item_id);

CREATE TABLE b_catalog_viewed_product (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FUSER_ID int NOT NULL,
  DATE_VISIT timestamp NOT NULL,
  PRODUCT_ID int NOT NULL,
  ELEMENT_ID int NOT NULL DEFAULT 0,
  SITE_ID char(2) NOT NULL,
  VIEW_COUNT int NOT NULL DEFAULT 1,
  RECOMMENDATION varchar(40),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_viewed_product_fuser_id_site_id_date_visit ON b_catalog_viewed_product (fuser_id, site_id, date_visit);
CREATE INDEX ix_b_catalog_viewed_product_fuser_id_site_id_element_id ON b_catalog_viewed_product (fuser_id, site_id, element_id);
CREATE INDEX ix_b_catalog_viewed_product_element_id_date_visit ON b_catalog_viewed_product (element_id, date_visit);

CREATE TABLE b_catalog_subscribe (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_FROM timestamp NOT NULL,
  DATE_TO timestamp,
  USER_CONTACT varchar(255) NOT NULL,
  CONTACT_TYPE int NOT NULL,
  USER_ID int8,
  ITEM_ID int8 NOT NULL,
  NEED_SENDING char(1) NOT NULL DEFAULT 'N',
  SITE_ID char(2) NOT NULL,
  LANDING_SITE_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_subscribe_user_contact ON b_catalog_subscribe (user_contact);
CREATE INDEX ix_b_catalog_subscribe_user_id ON b_catalog_subscribe (user_id);
CREATE INDEX ix_b_catalog_subscribe_item_id ON b_catalog_subscribe (item_id);

CREATE TABLE b_catalog_subscribe_access (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_FROM timestamp NOT NULL,
  USER_CONTACT varchar(255) NOT NULL,
  TOKEN char(6) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_subscribe_access_user_contact ON b_catalog_subscribe_access (user_contact);

CREATE TABLE b_catalog_rounding (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CATALOG_GROUP_ID int NOT NULL,
  PRICE decimal NOT NULL,
  ROUND_TYPE int NOT NULL,
  ROUND_PRECISION decimal NOT NULL,
  CREATED_BY int,
  DATE_CREATE timestamp,
  MODIFIED_BY int,
  DATE_MODIFY timestamp,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_rounding_catalog_group_id ON b_catalog_rounding (catalog_group_id);

CREATE TABLE b_catalog_product_compilation (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DEAL_ID int NOT NULL,
  PRODUCT_IDS text NOT NULL,
  CREATION_DATE timestamp NOT NULL,
  CHAT_ID int,
  QUEUE_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_product_compilation_deal_id ON b_catalog_product_compilation (deal_id);

CREATE TABLE b_catalog_exported_product (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PRODUCT_ID int NOT NULL,
  SERVICE_ID varchar(100) NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  ERROR text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_exported_product_product_id_service_id ON b_catalog_exported_product (product_id, service_id);

CREATE TABLE b_catalog_exported_product_queue (
  QUEUE_ID int NOT NULL,
  PRODUCT_IDS text NOT NULL,
  PRIMARY KEY (QUEUE_ID)
);

CREATE TABLE b_catalog_role (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(250) NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_catalog_role_relation (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ROLE_ID int8 NOT NULL,
  RELATION varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_role_relation_role_id ON b_catalog_role_relation (role_id);
CREATE INDEX ix_b_catalog_role_relation_relation ON b_catalog_role_relation (relation);

CREATE TABLE b_catalog_permission (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ROLE_ID int8 NOT NULL,
  PERMISSION_ID varchar(32) NOT NULL DEFAULT '0',
  VALUE int NOT NULL DEFAULT '0',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_permission_role_id ON b_catalog_permission (role_id);
CREATE INDEX ix_b_catalog_permission_permission_id ON b_catalog_permission (permission_id);

CREATE TABLE b_catalog_store_batch (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ELEMENT_ID int NOT NULL,
  STORE_ID int NOT NULL,
  AVAILABLE_AMOUNT double precision,
  PURCHASING_PRICE decimal,
  PURCHASING_CURRENCY char(3),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_store_batch_element_id ON b_catalog_store_batch (element_id);
CREATE INDEX ix_b_catalog_store_batch_store_id ON b_catalog_store_batch (store_id);

CREATE TABLE b_catalog_store_batch_docs_element (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DOCUMENT_ELEMENT_ID int,
  SHIPMENT_ITEM_STORE_ID int,
  AMOUNT double precision NOT NULL,
  PRODUCT_BATCH_ID int NOT NULL,
  BATCH_PRICE decimal,
  BATCH_CURRENCY char(3),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_store_batch_docs_element_shipment_item_store_id ON b_catalog_store_batch_docs_element (shipment_item_store_id);
CREATE INDEX ix_b_catalog_store_batch_docs_element_document_element_id ON b_catalog_store_batch_docs_element (document_element_id);
CREATE INDEX ix_b_catalog_store_batch_docs_element_product_batch_id ON b_catalog_store_batch_docs_element (product_batch_id);

CREATE TABLE b_catalog_agent_contract (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TITLE varchar(255) NOT NULL,
  CONTRACTOR_ID int8,
  DATE_MODIFY timestamp,
  DATE_CREATE timestamp,
  MODIFIED_BY int,
  CREATED_BY int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_agent_contract_contractor_id ON b_catalog_agent_contract (contractor_id);

CREATE TABLE b_catalog_agent_product (
  ID int8 GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CONTRACT_ID int8 NOT NULL,
  PRODUCT_ID int8 NOT NULL,
  PRODUCT_TYPE varchar(8) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_agent_product_contract_id ON b_catalog_agent_product (contract_id);
CREATE INDEX ix_b_catalog_agent_product_product_id ON b_catalog_agent_product (product_id);

CREATE TABLE b_catalog_agent_contract_file (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CONTRACT_ID int NOT NULL,
  FILE_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_catalog_agent_contract_file_contract_id ON b_catalog_agent_contract_file (contract_id);
