/* eslint-disable */
this.BX = this.BX || {};
(function (exports,im_lib_utils,im_v2_lib_promo,ui_switcher,ui_dialogs_messagebox,ui_buttons,im_v2_lib_desktopApi,im_v2_const,intranet_desktopDownload,main_core_events,im_v2_lib_utils,main_core,main_popup,call_lib_analytics,call_component_userListPopup,call_component_userList,loader,resize_observer,webrtc_adapter,im_lib_localstorage) {
	'use strict';

	// screensharing workaround
	function applyHacks() {
	  if (window["BXDesktopSystem"]) {
	    navigator['getDisplayMedia'] = function () {
	      var mediaParams = {
	        audio: false,
	        video: {
	          mandatory: {
	            chromeMediaSource: 'desktop',
	            maxWidth: screen.width > 1920 ? screen.width : 1920,
	            maxHeight: screen.height > 1080 ? screen.height : 1080
	          },
	          optional: [{
	            googTemporalLayeredScreencast: true
	          }]
	        }
	      };
	      return navigator.mediaDevices.getUserMedia(mediaParams);
	    };
	  }
	}

	var BackgroundDialog = /*#__PURE__*/function () {
	  function BackgroundDialog() {
	    babelHelpers.classCallCheck(this, BackgroundDialog);
	  }
	  babelHelpers.createClass(BackgroundDialog, null, [{
	    key: "isAvailable",
	    value: function isAvailable() {
	      return im_lib_utils.Utils.platform.getDesktopVersion() >= 52;
	    }
	  }, {
	    key: "isMaskAvailable",
	    value: function isMaskAvailable() {
	      return im_lib_utils.Utils.platform.isDesktopFeatureEnabled('mask');
	    }
	  }, {
	    key: "open",
	    value: function open(options) {
	      var _this = this;
	      options = main_core.Type.isPlainObject(options) ? options : {};
	      var tab = main_core.Type.isStringFilled(options.tab) ? options.tab : 'background'; // mask, background

	      if (!this.isAvailable()) {
	        if (window.BX.Helper) {
	          window.BX.Helper.show("redirect=detail&code=12398124");
	        }
	        return false;
	      }
	      var html = "<div id=\"bx-desktop-loader\" class=\"bx-desktop-loader-wrap\">\n\t\t\t\t<div class=\"bx-desktop-loader\">\n\t\t\t\t\t<svg class=\"bx-desktop-loader-circular\" viewBox=\"25 25 50 50\">\n\t\t\t\t\t\t<circle class=\"bx-desktop-loader-path\" cx=\"50\" cy=\"50\" r=\"20\" fill=\"none\" stroke-miterlimit=\"10\"/>\n\t\t\t\t\t</svg>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div id=\"placeholder\"></div>";
	      var js = "BX.Runtime.loadExtension(\"im.v2.component.call-background\").then(function(exports) {\n\t\t\t\tBX.Vue3.BitrixVue.createApp({\n\t\t\t\t\tcomponents: {CallBackground: exports.CallBackground},\n\t\t\t\t\ttemplate: '<CallBackground tab=\"".concat(tab, "\"/>',\n\t\t\t\t}).mount(\"#placeholder\");\n\t\t\t});");
	      im_v2_lib_desktopApi.DesktopApi.createWindow("callBackground", function (controller) {
	        var title = _this.isMaskAvailable() ? BX.message('BXD_CALL_BG_MASK_TITLE') : BX.message('BXD_CALL_BG_TITLE');
	        controller.SetProperty("title", title);
	        controller.SetProperty("clientSize", {
	          Width: 943,
	          Height: 670
	        });
	        controller.SetProperty("minClientSize", {
	          Width: 943,
	          Height: 670
	        });
	        controller.SetProperty("backgroundColor", "#2B3038");
	        controller.ExecuteCommand("center");
	        controller.ExecuteCommand("html.load", im_v2_lib_desktopApi.DesktopApi.prepareHtml(html, js));
	      });
	      return true;
	    }
	  }]);
	  return BackgroundDialog;
	}();

	var Logger = /*#__PURE__*/function () {
	  function Logger(serviceUrl, token) {
	    babelHelpers.classCallCheck(this, Logger);
	    this.serviceUrl = serviceUrl;
	    this.token = token;
	    this.socket = null;
	    this.attempt = 0;
	    this.reconnectTimeout = null;
	    this.unsentMessages = [];
	    this.onSocketOpenHandler = this.onSocketOpen.bind(this);
	    this.onSocketCloseHandler = this.onSocketClose.bind(this);
	    this.onSocketErrorHandler = this.onSocketError.bind(this);
	    this.connect();
	  }
	  babelHelpers.createClass(Logger, [{
	    key: "log",
	    value: function log(message) {
	      if (typeof message != 'string') {
	        console.error("Message should be string");
	        return;
	      }
	      if (this.isConnected) {
	        this.socket.send(JSON.stringify({
	          action: 'log',
	          message: message
	        }));
	      } else {
	        this.unsentMessages.push(message);
	      }
	    }
	  }, {
	    key: "sendStat",
	    value: function sendStat(statRecord) {
	      if (babelHelpers["typeof"](statRecord) == 'object') {
	        statRecord = JSON.stringify(statRecord);
	      }
	      if (this.isConnected) {
	        this.socket.send(JSON.stringify({
	          action: 'stat',
	          message: statRecord
	        }));
	      }
	    }
	  }, {
	    key: "connect",
	    value: function connect() {
	      if (this.socket) {
	        return;
	      }
	      if (!this.serviceUrl) {
	        console.error('Logging service url is empty');
	        return;
	      }
	      if (!this.serviceUrl.startsWith('ws://') && !this.serviceUrl.startsWith('wss://')) {
	        console.error('Logging service url should start with ws:// or wss://');
	        return;
	      }
	      if (!this.token) {
	        console.error('Logging token is empty');
	        return;
	      }
	      this.attempt++;
	      this.socket = new WebSocket(this.serviceUrl + '?token=' + this.token);
	      this.bindSocketEvents();
	    }
	  }, {
	    key: "scheduleReconnect",
	    value: function scheduleReconnect() {
	      clearTimeout(this.reconnectTimeout);
	      if (this.attempt > 3) {
	        console.error("Could not connect to the logging service, giving up");
	        return;
	      }
	      this.reconnectTimeout = setTimeout(this.connect.bind(this), this.getConnectionDelay(this.attempt) * 1000);
	    }
	  }, {
	    key: "getConnectionDelay",
	    value: function getConnectionDelay(attempt) {
	      switch (attempt) {
	        case 0:
	        case 1:
	          return 15;
	        case 2:
	          return 30;
	        default:
	          return 60;
	      }
	    }
	  }, {
	    key: "disconnect",
	    value: function disconnect() {
	      clearTimeout(this.reconnectTimeout);
	      if (this.socket) {
	        this.removeSocketEvents();
	        this.socket.close(1000);
	        this.socket = null;
	      }
	    }
	  }, {
	    key: "bindSocketEvents",
	    value: function bindSocketEvents() {
	      this.socket.addEventListener('open', this.onSocketOpenHandler);
	      this.socket.addEventListener('close', this.onSocketCloseHandler);
	      this.socket.addEventListener('error', this.onSocketErrorHandler);
	    }
	  }, {
	    key: "removeSocketEvents",
	    value: function removeSocketEvents() {
	      this.socket.removeEventListener('open', this.onSocketOpenHandler);
	      this.socket.removeEventListener('close', this.onSocketCloseHandler);
	      this.socket.removeEventListener('error', this.onSocketErrorHandler);
	    }
	  }, {
	    key: "onSocketOpen",
	    value: function onSocketOpen() {
	      this.attempt = 0;
	      for (var i = 0; i < this.unsentMessages.length; i++) {
	        this.socket.send(JSON.stringify({
	          action: 'log',
	          message: this.unsentMessages[i]
	        }));
	      }
	      this.unsentMessages = [];
	    }
	  }, {
	    key: "onSocketClose",
	    value: function onSocketClose() {
	      this.socket = null;
	      this.scheduleReconnect();
	    }
	  }, {
	    key: "onSocketError",
	    value: function onSocketError() {
	      this.socket = null;
	      this.scheduleReconnect();
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.disconnect();
	      this.unsentMessages = null;
	    }
	  }, {
	    key: "isConnected",
	    get: function get() {
	      return this.socket && this.socket.readyState === 1;
	    }
	  }]);
	  return Logger;
	}();

	var lsKey = {
	  defaultMicrophone: 'bx-im-settings-default-microphone',
	  defaultCamera: 'bx-im-settings-default-camera',
	  defaultSpeaker: 'bx-im-settings-default-speaker',
	  enableMicAutoParameters: 'bx-im-settings-enable-mic-auto-parameters',
	  preferHd: 'bx-im-settings-camera-prefer-hd',
	  enableMirroring: 'bx-im-settings-camera-enable-mirroring'
	};
	var Events = {
	  initialized: "initialized",
	  deviceChanged: "deviceChange",
	  onChangeMirroringVideo: "onChangeMirroringVideo",
	  onChangeMicrophoneMuted: "onChangeMicrophoneMuted",
	  onChangeCameraOn: "onChangeCameraOn"
	};
	var HardwareManager = /*#__PURE__*/function (_EventEmitter) {
	  babelHelpers.inherits(HardwareManager, _EventEmitter);
	  function HardwareManager() {
	    var _this;
	    babelHelpers.classCallCheck(this, HardwareManager);
	    _this = babelHelpers.possibleConstructorReturn(this, babelHelpers.getPrototypeOf(HardwareManager).call(this));
	    babelHelpers.defineProperty(babelHelpers.assertThisInitialized(_this), "Events", Events);
	    _this.setEventNamespace('BX.Call.HardwareManager');
	    _this.initialized = false;
	    _this._currentDeviceList = [];
	    _this.updating = false;
	    _this._isCameraOn = false;
	    _this._isMicrophoneMuted = false;
	    return _this;
	  }
	  babelHelpers.createClass(HardwareManager, [{
	    key: "init",
	    value: function init() {
	      var _this2 = this;
	      if (this.initialized) {
	        return Promise.resolve();
	      }
	      if (this.initPromise) {
	        return this.initPromise;
	      }
	      this.initPromise = new Promise(function (resolve, reject) {
	        _this2.enumerateDevices().then(function (deviceList) {
	          _this2._currentDeviceList = _this2.filterDeviceList(deviceList);
	          navigator.mediaDevices.addEventListener('devicechange', BX.debounce(_this2.onNavigatorDeviceChanged.bind(_this2), 500));
	          _this2.initialized = true;
	          _this2.initPromise = null;
	          _this2.emit(Events.initialized, {});
	          resolve();
	        })["catch"](function (e) {
	          _this2.initPromise = null;
	          reject(e);
	        });
	      });
	      return this.initPromise;
	    }
	  }, {
	    key: "enumerateDevices",
	    value: function enumerateDevices() {
	      return new Promise(function (resolve, reject) {
	        if (!navigator.mediaDevices || !navigator.mediaDevices.enumerateDevices) {
	          return reject("NO_WEBRTC");
	        }
	        navigator.mediaDevices.enumerateDevices().then(function (devices) {
	          return resolve(devices);
	        });
	      });
	    }
	  }, {
	    key: "hasCamera",
	    value: function hasCamera() {
	      if (!this.initialized) {
	        throw new Error("HardwareManager is not initialized yet");
	      }
	      return Object.keys(this.cameraList).length > 0;
	    }
	  }, {
	    key: "getMicrophoneList",
	    value: function getMicrophoneList() {
	      if (!this.initialized) {
	        throw new Error("HardwareManager is not initialized yet");
	      }
	      return Object.values(this._currentDeviceList).filter(function (deviceInfo) {
	        return deviceInfo.kind === "audioinput" && deviceInfo.deviceId !== 'default';
	      });
	    }
	  }, {
	    key: "getCameraList",
	    value: function getCameraList() {
	      if (!this.initialized) {
	        throw new Error("HardwareManager is not initialized yet");
	      }
	      return Object.values(this._currentDeviceList).filter(function (deviceInfo) {
	        return deviceInfo.kind == "videoinput";
	      });
	    }
	  }, {
	    key: "getSpeakerList",
	    value: function getSpeakerList() {
	      if (!this.initialized) {
	        throw new Error("HardwareManager is not initialized yet");
	      }
	      return Object.values(this._currentDeviceList).filter(function (deviceInfo) {
	        return deviceInfo.kind === "audiooutput" && deviceInfo.deviceId !== 'default';
	      });
	    }
	  }, {
	    key: "canSelectSpeaker",
	    value: function canSelectSpeaker() {
	      return 'setSinkId' in HTMLMediaElement.prototype;
	    }
	  }, {
	    key: "updateDeviceList",
	    value: function updateDeviceList(e) {
	      var _this3 = this;
	      if (this.updating) {
	        return;
	      }
	      this.updating = true;
	      var removedDevices = this._currentDeviceList;
	      var addedDevices = [];
	      var shouldSkipDeviceChangedEvent = this._currentDeviceList.every(function (deviceInfo) {
	        return deviceInfo.deviceId == "" && deviceInfo.label == "";
	      });
	      navigator.mediaDevices.enumerateDevices().then(function (devices) {
	        devices = _this3.filterDeviceList(devices);
	        devices.forEach(function (deviceInfo) {
	          var index = removedDevices.findIndex(function (dev) {
	            return dev.kind === deviceInfo.kind && dev.deviceId === deviceInfo.deviceId && dev.groupId === deviceInfo.groupId;
	          });
	          if (index != -1) {
	            // device found in previous version
	            removedDevices.splice(index, 1);
	          } else {
	            addedDevices.push(deviceInfo);
	          }
	        });
	        if (!shouldSkipDeviceChangedEvent) {
	          _this3.emit(Events.deviceChanged, {
	            added: addedDevices,
	            removed: removedDevices
	          });
	        }
	        _this3._currentDeviceList = devices;
	        _this3.updating = false;
	      });
	    }
	  }, {
	    key: "filterDeviceList",
	    value: function filterDeviceList(browserDeviceList) {
	      var _this4 = this;
	      return browserDeviceList.filter(function (device) {
	        switch (device.kind) {
	          case "audioinput":
	            return device.deviceId !== "communications" && !_this4.isDeviceInBlackList(device);
	          case "audiooutput":
	            return device.deviceId !== "communications" && !_this4.isDeviceInBlackList(device);
	          default:
	            return true;
	        }
	      });
	    }
	  }, {
	    key: "isDeviceInBlackList",
	    value: function isDeviceInBlackList(device) {
	      var deviceBlackList = ['(virtual)', 'zoomaudiodevice', 'microsoft teams audio', 'bitrixaudio'];
	      var result = false;
	      deviceBlackList.forEach(function (item) {
	        if (device.label.toLowerCase().includes(item)) {
	          result = true;
	          return false;
	        }
	      });
	      return result;
	    }
	  }, {
	    key: "onNavigatorDeviceChanged",
	    value: function onNavigatorDeviceChanged(e) {
	      if (!this.initialized) {
	        return;
	      }
	      this.updateDeviceList();
	    }
	  }, {
	    key: "_getDeviceMap",
	    value: function _getDeviceMap(deviceKind) {
	      var result = {};
	      if (!this.initialized) {
	        throw new Error("HardwareManager is not initialized yet");
	      }
	      for (var i = 0; i < this._currentDeviceList.length; i++) {
	        if (this._currentDeviceList[i].kind == deviceKind) {
	          result[this._currentDeviceList[i].deviceId] = this._currentDeviceList[i].label;
	        }
	      }
	      return result;
	    }
	  }, {
	    key: "getDefaultDeviceIdByGroupId",
	    value: function getDefaultDeviceIdByGroupId(groupId, deviceKind) {
	      var deviceId;
	      this._currentDeviceList.forEach(function (device) {
	        if (device.groupId === groupId && device.deviceId !== 'default' && device.kind === deviceKind) {
	          deviceId = device.deviceId;
	          return false;
	        }
	      });
	      return deviceId;
	    }
	  }, {
	    key: "getDeviceGroupIdByDeviceId",
	    value: function getDeviceGroupIdByDeviceId(deviceId, deviceKind) {
	      var groupId;
	      this._currentDeviceList.forEach(function (device) {
	        if (device.deviceId === deviceId && device.kind === deviceKind) {
	          groupId = device.groupId;
	          return false;
	        }
	      });
	      return groupId;
	    }
	  }, {
	    key: "removeDevicesByDefaultGroup",
	    value: function removeDevicesByDefaultGroup(devices) {
	      var resultDeviceList = devices;
	      devices.forEach(function (device) {
	        if (device.deviceId === 'default') {
	          resultDeviceList = resultDeviceList.filter(function (item) {
	            return item.kind !== device.kind || item.groupId !== device.groupId;
	          });
	        }
	      });
	      return resultDeviceList;
	    }
	  }, {
	    key: "getCurrentDeviceList",
	    value: function getCurrentDeviceList() {
	      var _this5 = this;
	      return new Promise(function (resolve, reject) {
	        _this5.enumerateDevices().then(function (deviceList) {
	          _this5._currentDeviceList = _this5.filterDeviceList(deviceList);
	          resolve();
	        });
	      });
	    }
	  }, {
	    key: "getRemovedUsedDevices",
	    value: function getRemovedUsedDevices(devices, currentDevices) {
	      return devices.filter(function (device) {
	        switch (device.kind) {
	          case "audioinput":
	            return device.deviceId === currentDevices.microphoneId;
	          case "audiooutput":
	            return device.deviceId === currentDevices.speakerId;
	          case "videoinput":
	            return device.deviceId === currentDevices.cameraId;
	          default:
	            return false;
	        }
	      });
	    }
	  }, {
	    key: "cameraList",
	    get: function get() {
	      return this._getDeviceMap("videoinput");
	    }
	  }, {
	    key: "microphoneList",
	    get: function get() {
	      return this._getDeviceMap("audioinput");
	    }
	  }, {
	    key: "audioOutputList",
	    get: function get() {
	      return this._getDeviceMap("audiooutput");
	    }
	  }, {
	    key: "defaultMicrophone",
	    get: function get() {
	      var microphoneId = localStorage ? localStorage.getItem(lsKey.defaultMicrophone) : '';
	      if ((!microphoneId || !this.microphoneList[microphoneId]) && Object.keys(this.microphoneList).length) {
	        // previous solution with ternary operator
	        // has been replaced with two separate conditions
	        // because some systems / browsers don't create a duplicate for the default audio device
	        if (Object.keys(this.microphoneList).includes('default')) {
	          microphoneId = this.getDefaultDeviceIdByGroupId(this.getDeviceGroupIdByDeviceId('default', 'audioinput'), 'audioinput');
	        }
	        if (!microphoneId) {
	          microphoneId = Object.keys(this.microphoneList)[0];
	        }
	        return microphoneId;
	      }
	      return this.microphoneList[microphoneId] ? microphoneId : '';
	    },
	    set: function set(microphoneId) {
	      if (localStorage) {
	        localStorage.setItem(lsKey.defaultMicrophone, microphoneId);
	      }
	    }
	  }, {
	    key: "defaultCamera",
	    get: function get() {
	      var cameraId = localStorage ? localStorage.getItem(lsKey.defaultCamera) : '';
	      if ((!cameraId || !this.cameraList[cameraId]) && Object.keys(this.cameraList).length) {
	        return Object.keys(this.cameraList)[0];
	      }
	      return this.cameraList[cameraId] ? cameraId : '';
	    },
	    set: function set(cameraId) {
	      if (localStorage) {
	        localStorage.setItem(lsKey.defaultCamera, cameraId);
	      }
	    }
	  }, {
	    key: "defaultSpeaker",
	    get: function get() {
	      var speakerId = localStorage ? localStorage.getItem(lsKey.defaultSpeaker) : '';
	      if ((!speakerId || this.audioOutputList[speakerId]) && Object.keys(this.audioOutputList).length) {
	        speakerId = Object.keys(this.audioOutputList).includes('default') ? this.getDefaultDeviceIdByGroupId(this.getDeviceGroupIdByDeviceId('default', 'audiooutput'), 'audiooutput') : Object.keys(this.audioOutputList)[0];
	        return speakerId;
	      }
	      return this.audioOutputList[speakerId] ? speakerId : '';
	    },
	    set: function set(speakerId) {
	      if (localStorage) {
	        localStorage.setItem(lsKey.defaultSpeaker, speakerId);
	      }
	    }
	  }, {
	    key: "enableMicAutoParameters",
	    get: function get() {
	      return localStorage ? localStorage.getItem(lsKey.enableMicAutoParameters) !== 'N' : true;
	    },
	    set: function set(enableMicAutoParameters) {
	      if (localStorage) {
	        localStorage.setItem(lsKey.enableMicAutoParameters, enableMicAutoParameters ? 'Y' : 'N');
	      }
	    }
	  }, {
	    key: "preferHdQuality",
	    get: function get() {
	      return localStorage ? localStorage.getItem(lsKey.preferHd) !== 'N' : true;
	    },
	    set: function set(preferHdQuality) {
	      if (localStorage) {
	        localStorage.setItem(lsKey.preferHd, preferHdQuality ? 'Y' : 'N');
	      }
	    }
	  }, {
	    key: "enableMirroring",
	    get: function get() {
	      return localStorage ? localStorage.getItem(lsKey.enableMirroring) !== 'N' : true;
	    },
	    set: function set(enableMirroring) {
	      if (this.enableMirroring !== enableMirroring) {
	        this.emit(Events.onChangeMirroringVideo, {
	          enableMirroring: enableMirroring
	        });
	        if (im_v2_lib_desktopApi.DesktopApi.isDesktop()) {
	          im_v2_lib_desktopApi.DesktopApi.emit(Events.onChangeMirroringVideo, [enableMirroring]);
	        }
	        if (localStorage) {
	          localStorage.setItem(lsKey.enableMirroring, enableMirroring ? 'Y' : 'N');
	        }
	      }
	    }
	  }, {
	    key: "isCameraOn",
	    get: function get() {
	      return this._isCameraOn;
	    },
	    set: function set(isCameraOn) {
	      if (this._isCameraOn !== isCameraOn) {
	        this._isCameraOn = isCameraOn;
	        this.emit(Events.onChangeCameraOn, {
	          isCameraOn: this._isCameraOn
	        });
	      }
	    }
	  }, {
	    key: "isMicrophoneMuted",
	    get: function get() {
	      return this._isMicrophoneMuted;
	    },
	    set: function set(isMicrophoneMuted) {
	      if (this._isMicrophoneMuted !== isMicrophoneMuted) {
	        this._isMicrophoneMuted = isMicrophoneMuted;
	        this.emit(Events.onChangeMicrophoneMuted, {
	          isMicrophoneMuted: this._isMicrophoneMuted
	        });
	      }
	    }
	  }]);
	  return HardwareManager;
	}(main_core_events.EventEmitter);
	var Hardware = new HardwareManager();

	/**
	 * Abstract call class
	 * Public methods:
	 * - inviteUsers
	 * - cancel
	 * - answer
	 * - decline
	 * - hangup
	 *
	 * Events:
	 * - onJoin
	 * - onLeave
	 * - onUserStateChanged
	 * - onStreamReceived
	 * - onStreamRemoved
	 * - onCallFailure
	 * - onDestroy
	 */
	var AbstractCall = /*#__PURE__*/function () {
	  function AbstractCall(params) {
	    var _this = this;
	    babelHelpers.classCallCheck(this, AbstractCall);
	    this.id = params.id;
	    this.instanceId = params.instanceId;
	    this.parentId = params.parentId || null;
	    this.direction = params.direction;
	    this.type = BX.prop.getInteger(params, "type", CallType.Instant); // @see {BX.Call.Type}
	    this.state = BX.prop.getString(params, "state", CallState.Idle);
	    this.ready = false;
	    this.userId = CallEngine.getCurrentUserId();
	    this.initiatorId = params.initiatorId || '';
	    this.users = main_core.Type.isArray(params.users) ? params.users.filter(function (userId) {
	      return userId != _this.userId;
	    }) : [];
	    this.associatedEntity = main_core.Type.isPlainObject(params.associatedEntity) ? params.associatedEntity : {};
	    this.startDate = new Date(BX.prop.getString(params, "startDate", ""));

	    // media constraints
	    this.videoEnabled = Hardware.isCameraOn;
	    this.videoHd = params.videoHd === true;
	    this.cameraId = params.cameraId || '';
	    this.microphoneId = params.microphoneId || '';
	    this.muted = Hardware.isMicrophoneMuted;
	    this.wasConnected = false;
	    this.logToken = params.logToken || '';
	    if (CallEngine.getLogService() && this.logToken) {
	      this.logger = new Logger(CallEngine.getLogService(), this.logToken);
	    }
	    this.localStreams = {
	      main: null,
	      screen: null
	    };
	    this.eventListeners = {};
	    if (main_core.Type.isPlainObject(params.events)) {
	      this.initEventListeners(params.events);
	    }
	    this.connectionData = params.connectionData;
	    this._microphoneLevel = 0;
	  }
	  babelHelpers.createClass(AbstractCall, [{
	    key: "initEventListeners",
	    value: function initEventListeners(eventListeners) {
	      for (var eventName in eventListeners) {
	        this.addEventListener(eventName, eventListeners[eventName]);
	      }
	    }
	  }, {
	    key: "addEventListener",
	    value: function addEventListener(eventName, listener) {
	      if (!main_core.Type.isArray(this.eventListeners[eventName])) {
	        this.eventListeners[eventName] = [];
	      }
	      if (main_core.Type.isFunction(listener)) {
	        this.eventListeners[eventName].push(listener);
	      }
	    }
	  }, {
	    key: "removeEventListener",
	    value: function removeEventListener(eventName, listener) {
	      if (main_core.Type.isArray(this.eventListeners[eventName]) && this.eventListeners[eventName].indexOf(listener) >= 0) {
	        var listenerIndex = this.eventListeners[eventName].indexOf(listener);
	        if (listenerIndex >= 0) {
	          this.eventListeners[eventName].splice(listenerIndex, 1);
	        }
	      }
	    }
	  }, {
	    key: "runCallback",
	    value: function runCallback(eventName, eventFields) {
	      //console.log(eventName, eventFields);
	      if (main_core.Type.isArray(this.eventListeners[eventName]) && this.eventListeners[eventName].length > 0) {
	        if (eventName === null || babelHelpers["typeof"](eventFields) !== "object") {
	          eventFields = {};
	        }
	        eventFields.call = this;
	        for (var i = 0; i < this.eventListeners[eventName].length; i++) {
	          try {
	            this.eventListeners[eventName][i].call(this, eventFields);
	          } catch (err) {
	            console.error(eventName + " callback error: ", err);
	            this.log(eventName + " callback error: ", err);
	          }
	        }
	      }
	    }
	  }, {
	    key: "getLocalStream",
	    value: function getLocalStream(tag) {
	      return this.localStreams[tag];
	    }
	  }, {
	    key: "setLocalStream",
	    value: function setLocalStream(mediaStream, tag) {
	      tag = tag || "main";
	      this.localStreams[tag] = mediaStream;
	    }
	  }, {
	    key: "isAnyoneParticipating",
	    value: function isAnyoneParticipating() {
	      throw new Error("isAnyoneParticipating should be implemented");
	    }
	  }, {
	    key: "__onPullEvent",
	    value: function __onPullEvent(command, params) {
	      throw new Error("__onPullEvent should be implemented");
	    }
	  }, {
	    key: "inviteUsers",
	    value: function inviteUsers() {
	      throw new Error("inviteUsers is not implemented");
	    }
	  }, {
	    key: "cancel",
	    value: function cancel() {
	      throw new Error("cancel is not implemented");
	    }
	  }, {
	    key: "answer",
	    value: function answer() {
	      throw new Error("answer is not implemented");
	    }
	  }, {
	    key: "decline",
	    value: function decline(code, reason) {
	      throw new Error("decline is not implemented");
	    }
	  }, {
	    key: "hangup",
	    value: function hangup() {
	      throw new Error("hangup is not implemented");
	    }
	  }, {
	    key: "log",
	    value: function log() {
	      var text = Util.getLogMessage.apply(null, arguments);
	      if (im_v2_lib_desktopApi.DesktopApi.isDesktop()) {
	        im_v2_lib_desktopApi.DesktopApi.writeToLogFile(BX.message('USER_ID') + '.video.log', text.substr(3));
	      }
	      if (CallEngine.debugFlag && console) {
	        var a = ['Call log [' + Util.getTimeForLog() + ']: '];
	        console.log.apply(this, a.concat(Array.prototype.slice.call(arguments)));
	      }
	      if (this.logger) {
	        this.logger.log(text);
	      }
	      if (BX.MessengerDebug) {
	        BX.MessengerDebug.addLog(this.id, text);
	      }
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      if (this.logger) {
	        this.logger.destroy();
	        this.logger = null;
	      }
	      this.state = CallState.Finished;
	      this.runCallback(CallEvent.onDestroy);
	    }
	  }, {
	    key: "provider",
	    get: function get() {
	      throw new Error("must be overwritten");
	    }
	  }, {
	    key: "microphoneLevel",
	    get: function get() {
	      return this._microphoneLevel;
	    },
	    set: function set(level) {
	      if (level != this._microphoneLevel) {
	        this._microphoneLevel = level;
	        this.runCallback(CallEvent.onMicrophoneLevel, {
	          level: level
	        });
	      }
	    }
	  }]);
	  return AbstractCall;
	}();

	var CopilotNotifyType = {
	  COPILOT_ENABLED: 'COPILOT_ENABLED',
	  COPILOT_DISABLED: 'COPILOT_DISABLED',
	  COPILOT_RESULT: 'COPILOT_RESULT',
	  AI_UNAVAILABLE_ERROR: 'AI_UNAVAILABLE_ERROR',
	  AI_SETTINGS_ERROR: 'AI_SETTINGS_ERROR',
	  AI_AGREEMENT_ERROR: 'AI_AGREEMENT_ERROR',
	  AI_NOT_ENOUGH_BAAS_ERROR: 'AI_NOT_ENOUGH_BAAS_ERROR'
	};
	var CopilotNotify = /*#__PURE__*/function () {
	  function CopilotNotify(config) {
	    babelHelpers.classCallCheck(this, CopilotNotify);
	    this.callId = config.callId || 0;
	    this.type = config.type || '';
	    this.popup = null;
	    this.notifyText = '';
	    this.promoId = '';
	    this.popupTemplate = null;
	    this.bindElement = config.bindElement;
	    this.notifyColor = '';
	    this.callbacks = {
	      onClose: BX.type.isFunction(config.onClose) ? config.onClose : BX.DoNothing
	    };
	  }
	  babelHelpers.createClass(CopilotNotify, [{
	    key: "getPopupTemplate",
	    value: function getPopupTemplate() {
	      var _this = this;
	      this.setAdditionalInformation();
	      if (!this.notifyText) {
	        this.popupTemplate = null;
	      }
	      this.popupTemplate = main_core.Dom.create("div", {
	        props: {
	          className: 'bx-call-copilot-notify__content'
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: 'bx-call-copilot-notify__icon'
	          }
	        }), main_core.Dom.create("div", {
	          props: {
	            className: 'bx-call-copilot-notify__message'
	          },
	          text: this.notifyText
	        }), main_core.Dom.create("button", {
	          props: {
	            className: 'bx-call-copilot-notify__close-btn'
	          },
	          events: {
	            click: function click() {
	              _this.close();
	            }
	          }
	        })]
	      });
	    }
	  }, {
	    key: "setAdditionalInformation",
	    value: function setAdditionalInformation() {
	      switch (this.type) {
	        case CopilotNotifyType.COPILOT_ENABLED:
	          this.notifyText = BX.message('CALL_POPUP_WARNING_ENABLED');
	          this.promoId = 'call:copilot-notify-warning:21112024:all';
	          this.notifyColor = '#8E52EC';
	          break;
	        case CopilotNotifyType.COPILOT_DISABLED:
	          this.notifyText = BX.message('CALL_POPUP_PROMO_ENABLED');
	          this.promoId = 'call:copilot-notify-promo:21112024:all';
	          this.notifyColor = '#8E52EC';
	          break;
	        case CopilotNotifyType.COPILOT_RESULT:
	          this.notifyText = BX.message('CALL_POPUP_RESULT_WARNING');
	          this.promoId = 'call:copilot-notify-result:24112024:all';
	          this.notifyColor = '#8E52EC';
	          break;
	        case CopilotNotifyType.AI_UNAVAILABLE_ERROR:
	          this.notifyText = BX.message('CALL_POPUP_AI_UNAVAILABLE_ERROR');
	          this.notifyColor = '#FF5752';
	          break;
	        case CopilotNotifyType.AI_SETTINGS_ERROR:
	          this.notifyText = BX.message('CALL_POPUP_AI_SETTINGS_ERROR');
	          this.notifyColor = '#FF5752';
	          break;
	        case CopilotNotifyType.AI_AGREEMENT_ERROR:
	          this.notifyText = BX.message('CALL_POPUP_AI_AGREEMENT_ERROR');
	          this.notifyColor = '#FF5752';
	          break;
	        case CopilotNotifyType.AI_NOT_ENOUGH_BAAS_ERROR:
	          this.notifyText = BX.message('CALL_POPUP_AI_NOT_ENOUGH_BAAS_ERROR');
	          this.notifyColor = '#FF5752';
	          break;
	        default:
	          this.notifyText = main_core.Loc.getMessage('CALL_POPUP_AI_DEFAULT_TEXT');
	          this.notifyColor = '#FF5752';
	          break;
	      }
	    }
	  }, {
	    key: "create",
	    value: function create() {
	      var _this2 = this;
	      var self = this;
	      this.getPopupTemplate();
	      if (!this.bindElement || !this.popupTemplate) {
	        return;
	      }
	      this.popup = new main_popup.Popup({
	        className: "bx-call-copilot-notify",
	        bindElement: this.bindElement,
	        targetContainer: document.body,
	        content: this.popupTemplate,
	        bindOptions: {
	          position: "top"
	        },
	        padding: 0,
	        contentBorderRadius: '1024px',
	        background: this.notifyColor,
	        contentBackground: this.notifyColor,
	        darkMode: true,
	        contentNoPaddings: true,
	        animation: "fading",
	        autoHide: true,
	        events: {
	          onPopupClose: function onPopupClose() {
	            self.callbacks.onClose();
	            this.destroy();
	          },
	          onPopupDestroy: function onPopupDestroy() {
	            self.popup = null;
	          },
	          onShow: function onShow() {
	            var popupWidth = _this2.popup.getPopupContainer().offsetWidth;
	            var elementWidth = _this2.popup.bindElement.offsetWidth;
	            var offsetFix = 7;
	            _this2.popup.setOffset({
	              offsetLeft: elementWidth - offsetFix - popupWidth / 2
	            });
	            _this2.popup.setAngle({
	              offset: popupWidth / 2,
	              position: 'bottom'
	            });
	            _this2.popup.adjustPosition();
	          },
	          onClose: function onClose() {
	            if (!_this2.promoId) {
	              return;
	            }
	            im_v2_lib_promo.PromoManager.getInstance().markAsWatched(_this2.promoId);
	          }
	        }
	      });
	    }
	  }, {
	    key: "show",
	    value: function show() {
	      this.close();
	      this.create();
	      if (!this.canShowCopilotNotify()) {
	        return;
	      }
	      if (this.type === CopilotNotifyType.COPILOT_ENABLED || this.type === CopilotNotifyType.COPILOT_DISABLED) {
	        call_lib_analytics.Analytics.getInstance().copilot.onCopilotNotifyShow({
	          isCopilotActive: this.type === CopilotNotifyType.COPILOT_ENABLED,
	          callId: this.callId
	        });
	      }
	      if (this.popup) {
	        this.popup.show();
	      }
	    }
	  }, {
	    key: "close",
	    value: function close() {
	      if (this.popup) {
	        this.popup.close();
	      }
	    }
	  }, {
	    key: "canShowCopilotNotify",
	    value: function canShowCopilotNotify() {
	      if (!this.promoId) {
	        return true;
	      }
	      return im_v2_lib_promo.PromoManager.getInstance().needToShow(this.promoId);
	    }
	  }]);
	  return CopilotNotify;
	}();

	var UserModel = /*#__PURE__*/function () {
	  function UserModel(config) {
	    babelHelpers.classCallCheck(this, UserModel);
	    this.data = {
	      id: BX.prop.getInteger(config, "id", 0),
	      name: BX.prop.getString(config, "name", ""),
	      avatar: BX.prop.getString(config, "avatar", ""),
	      gender: BX.prop.getString(config, "gender", ""),
	      state: BX.prop.getString(config, "state", UserState.Idle),
	      talking: BX.prop.getBoolean(config, "talking", false),
	      cameraState: BX.prop.getBoolean(config, "cameraState", true),
	      prevCameraState: BX.prop.getBoolean(config, "cameraState", true),
	      microphoneState: BX.prop.getBoolean(config, "microphoneState", true),
	      screenState: BX.prop.getBoolean(config, "screenState", false),
	      videoPaused: BX.prop.getBoolean(config, "videoPaused", false),
	      floorRequestState: BX.prop.getBoolean(config, "floorRequestState", false),
	      localUser: BX.prop.getBoolean(config, "localUser", false),
	      centralUser: BX.prop.getBoolean(config, "centralUser", false),
	      pinned: BX.prop.getBoolean(config, "pinned", false),
	      presenter: BX.prop.getBoolean(config, "presenter", false),
	      order: BX.prop.getInteger(config, "order", false),
	      prevOrder: BX.prop.getInteger(config, "prevOrder", false),
	      allowRename: BX.prop.getBoolean(config, "allowRename", false),
	      wasRenamed: BX.prop.getBoolean(config, "wasRenamed", false),
	      renameRequested: BX.prop.getBoolean(config, "renameRequested", false),
	      direction: BX.prop.getString(config, "direction", EndpointDirection.SendRecv)
	    };
	    for (var fieldName in this.data) {
	      if (this.data.hasOwnProperty(fieldName)) {
	        Object.defineProperty(this, fieldName, {
	          get: this._getField(fieldName).bind(this),
	          set: this._setField(fieldName).bind(this)
	        });
	      }
	    }
	    this.onUpdate = {
	      talking: this._onUpdateTalking.bind(this),
	      state: this._onUpdateState.bind(this)
	    };
	    this.talkingStop = null;
	    this.eventEmitter = new main_core_events.EventEmitter(this, 'UserModel');
	  }
	  babelHelpers.createClass(UserModel, [{
	    key: "_getField",
	    value: function _getField(fieldName) {
	      return function () {
	        return this.data[fieldName];
	      };
	    }
	  }, {
	    key: "_setField",
	    value: function _setField(fieldName) {
	      return function (newValue) {
	        var oldValue = this.data[fieldName];
	        if (oldValue == newValue) {
	          return;
	        }
	        this.data[fieldName] = newValue;
	        if (this.onUpdate.hasOwnProperty(fieldName)) {
	          this.onUpdate[fieldName](newValue, oldValue);
	        }
	        this.eventEmitter.emit("changed", {
	          user: this,
	          fieldName: fieldName,
	          oldValue: oldValue,
	          newValue: newValue
	        });
	      };
	    }
	  }, {
	    key: "_onUpdateTalking",
	    value: function _onUpdateTalking(talking) {
	      if (talking) {
	        this.floorRequestState = false;
	      } else {
	        this.talkingStop = new Date().getTime();
	      }
	    }
	  }, {
	    key: "_onUpdateState",
	    value: function _onUpdateState(newValue) {
	      if (newValue != UserState.Connected) {
	        this.talking = false;
	        this.screenState = false;
	      }
	    }
	  }, {
	    key: "wasTalkingAgo",
	    value: function wasTalkingAgo() {
	      if (this.state != UserState.Connected) {
	        return +Infinity;
	      }
	      if (this.talking) {
	        return 0;
	      }
	      if (!this.talkingStop) {
	        return +Infinity;
	      }
	      return new Date().getTime() - this.talkingStop;
	    }
	  }, {
	    key: "subscribe",
	    value: function subscribe(event, handler) {
	      this.eventEmitter.subscribe(event, handler);
	    }
	  }, {
	    key: "unsubscribe",
	    value: function unsubscribe(event, handler) {
	      this.eventEmitter.unsubscribe(event, handler);
	    }
	  }]);
	  return UserModel;
	}();
	var UserRegistry = /*#__PURE__*/function (_EventEmitter) {
	  babelHelpers.inherits(UserRegistry, _EventEmitter);
	  function UserRegistry() {
	    var _this;
	    var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	    babelHelpers.classCallCheck(this, UserRegistry);
	    _this = babelHelpers.possibleConstructorReturn(this, babelHelpers.getPrototypeOf(UserRegistry).call(this));
	    _this.setEventNamespace('BX.Call.UserRegistry');
	    _this.users = main_core.Type.isArray(config.users) ? config.users : [];
	    _this._sort();
	    return _this;
	  }
	  babelHelpers.createClass(UserRegistry, [{
	    key: "get",
	    /**
	     *
	     * @param {int} userId
	     * @returns {UserModel|null}
	     */
	    value: function get(userId) {
	      for (var i = 0; i < this.users.length; i++) {
	        if (this.users[i].id == userId) {
	          return this.users[i];
	        }
	      }
	      return null;
	    }
	  }, {
	    key: "push",
	    value: function push(user) {
	      if (!(user instanceof UserModel)) {
	        throw Error("user should be instance of UserModel");
	      }
	      this.users.push(user);
	      this._sort();
	      user.subscribe("changed", this._onUserChanged.bind(this));
	      this.emit("userAdded", {
	        user: user
	      });
	    }
	  }, {
	    key: "_onUserChanged",
	    value: function _onUserChanged(event) {
	      if (event.data.fieldName === 'order') {
	        this._sort();
	      }
	      this.emit("userChanged", event.data);
	    }
	  }, {
	    key: "_sort",
	    value: function _sort() {
	      this.users = this.users.sort(function (a, b) {
	        return a.order - b.order;
	      });
	    }
	  }]);
	  return UserRegistry;
	}(main_core_events.EventEmitter);

	function createSVG(elementName, config) {
	  var element = document.createElementNS('http://www.w3.org/2000/svg', elementName);
	  if ("attrNS" in config && main_core.Type.isObject(config.attrNS)) {
	    for (var key in config.attrNS) {
	      if (config.attrNS.hasOwnProperty(key)) {
	        element.setAttributeNS(null, key, config.attrNS[key]);
	      }
	    }
	  }
	  main_core.Dom.adjust(element, config);
	  return element;
	}

	var TitleButton = /*#__PURE__*/function () {
	  function TitleButton(config) {
	    babelHelpers.classCallCheck(this, TitleButton);
	    this.elements = {
	      root: null
	    };
	    this.text = main_core.Type.isStringFilled(config.text) ? config.text : '';
	    this.isGroupCall = config.isGroupCall;
	  }
	  babelHelpers.createClass(TitleButton, [{
	    key: "render",
	    value: function render() {
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-panel-title"
	        },
	        html: this.getTitle()
	      });
	      return this.elements.root;
	    }
	  }, {
	    key: "getTitle",
	    value: function getTitle() {
	      var prettyName = '<span class="bx-messenger-videocall-panel-title-name">' + main_core.Text.encode(this.text) + '</span>';
	      if (this.isGroupCall) {
	        return BX.message("IM_M_GROUP_CALL_WITH").replace("#CHAT_NAME#", prettyName);
	      } else {
	        return BX.message("IM_M_CALL_WITH").replace("#USER_NAME#", prettyName);
	      }
	    }
	  }]);
	  return TitleButton;
	}();
	var SimpleButton = /*#__PURE__*/function () {
	  function SimpleButton(config) {
	    babelHelpers.classCallCheck(this, SimpleButton);
	    this["class"] = config["class"];
	    this.backgroundClass = BX.prop.getString(config, "backgroundClass", "");
	    this.backgroundClass = "bx-messenger-videocall-panel-icon-background" + (this.backgroundClass ? " " : "") + this.backgroundClass;
	    this.blocked = config.blocked === true;
	    this.text = BX.prop.getString(config, "text", "");
	    this.isActive = false;
	    this.counter = BX.prop.getInteger(config, "counter", 0);
	    this.isComingSoon = config.isComingSoon || false;
	    this.elements = {
	      root: null,
	      counter: null,
	      comingSoon: null
	    };
	    this.callbacks = {
	      onClick: BX.prop.getFunction(config, "onClick", BX.DoNothing),
	      onMouseOver: BX.prop.getFunction(config, "onMouseOver", BX.DoNothing),
	      onMouseOut: BX.prop.getFunction(config, "onMouseOut", BX.DoNothing)
	    };
	  }
	  babelHelpers.createClass(SimpleButton, [{
	    key: "render",
	    value: function render() {
	      if (this.elements.root) {
	        return this.elements.root;
	      }
	      var textNode;
	      if (this.text !== '') {
	        textNode = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-panel-text"
	          },
	          text: this.text
	        });
	      } else {
	        textNode = null;
	      }
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-panel-item" + (this.blocked ? " blocked" : "")
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: this.backgroundClass
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-panel-icon bx-messenger-videocall-panel-icon-" + this["class"]
	            },
	            children: [this.elements.counter = main_core.Dom.create("span", {
	              props: {
	                className: "bx-messenger-videocall-panel-item-counter"
	              },
	              text: 0,
	              dataset: {
	                counter: 0,
	                counterType: 'digits'
	              }
	            }), this.elements.comingSoon = main_core.Dom.create("span", {
	              props: {
	                className: "bx-messenger-videocall-panel-item-coming-soon"
	              },
	              text: BX.message('CALL_FEATURES_COMING_SOON'),
	              dataset: {
	                visible: this.isComingSoon ? 'Y' : 'N'
	              }
	            })]
	          })]
	        }), textNode, main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-panel-item-bottom-spacer"
	          }
	        })],
	        events: {
	          click: this.callbacks.onClick,
	          mouseover: this.callbacks.onMouseOver,
	          mouseout: this.callbacks.onMouseOut
	        }
	      });
	      if (this.isActive) {
	        this.elements.root.classList.add("active");
	      }
	      return this.elements.root;
	    }
	  }, {
	    key: "setActive",
	    value: function setActive(isActive) {
	      if (this.isActive == isActive) {
	        return;
	      }
	      this.isActive = isActive;
	      if (!this.elements.root) {
	        return;
	      }
	      if (this.isActive) {
	        this.elements.root.classList.add("active");
	      } else {
	        this.elements.root.classList.remove("active");
	      }
	    }
	  }, {
	    key: "setBlocked",
	    value: function setBlocked(isBlocked) {
	      if (this.blocked == isBlocked) {
	        return;
	      }
	      this.blocked = isBlocked;
	      if (this.blocked) {
	        this.elements.root.classList.add("blocked");
	      } else {
	        this.elements.root.classList.remove("blocked");
	      }
	    }
	  }, {
	    key: "setCounter",
	    value: function setCounter(counter) {
	      this.counter = parseInt(counter, 10);
	      var counterLabel = this.counter;
	      if (counterLabel > 999) {
	        counterLabel = 999;
	      }
	      var counterType = 'digits';
	      if (counterLabel.toString().length === 2) {
	        counterType = 'dozens';
	      } else if (counterLabel.toString().length > 2) {
	        counterType = 'hundreds';
	      }
	      this.elements.counter.dataset.counter = counterLabel;
	      this.elements.counter.dataset.counterType = counterType;
	      this.elements.counter.innerText = counterLabel;
	    }
	  }, {
	    key: "setIsComingSoon",
	    value: function setIsComingSoon(isActive) {
	      this.isComingSoon = isActive;
	      this.isComingSoon ? this.elements.comingSoon.dataset.visible = 'Y' : this.elements.comingSoon.dataset.visible = 'N';
	    }
	  }]);
	  return SimpleButton;
	}();
	var DeviceButton = /*#__PURE__*/function () {
	  function DeviceButton(config) {
	    babelHelpers.classCallCheck(this, DeviceButton);
	    this["class"] = config["class"];
	    this.text = config.text;
	    this.enabled = config.enabled === true;
	    this.arrowEnabled = config.arrowEnabled === true;
	    this.arrowHidden = config.arrowHidden === true;
	    this.blocked = config.blocked === true;
	    this.showLevel = config.showLevel === true;
	    this.level = config.level || 0;
	    this.sideIcon = BX.prop.getString(config, "sideIcon", "");
	    this.elements = {
	      root: null,
	      iconContainer: null,
	      icon: null,
	      arrow: null,
	      levelMeter: null,
	      pointer: null,
	      ellipsis: null
	    };
	    this.callbacks = {
	      onClick: BX.prop.getFunction(config, "onClick", BX.DoNothing),
	      onArrowClick: BX.prop.getFunction(config, "onArrowClick", BX.DoNothing),
	      onSideIconClick: BX.prop.getFunction(config, "onSideIconClick", BX.DoNothing),
	      onMouseOver: BX.prop.getFunction(config, "onMouseOver", BX.DoNothing),
	      onMouseOut: BX.prop.getFunction(config, "onMouseOut", BX.DoNothing)
	    };
	  }
	  babelHelpers.createClass(DeviceButton, [{
	    key: "render",
	    value: function render() {
	      if (this.elements.root) {
	        return this.elements.root;
	      }
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          id: "bx-messenger-videocall-panel-item-with-arrow-" + this["class"],
	          className: "bx-messenger-videocall-panel-item-with-arrow" + (this.blocked ? " blocked" : "")
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-panel-item-with-arrow-left"
	          },
	          children: [this.elements.iconContainer = main_core.Dom.create("div", {
	            props: {
	              className: this.getIconContainerClass()
	            },
	            children: [this.elements.icon = main_core.Dom.create("div", {
	              props: {
	                className: this.getIconClass()
	              }
	            })]
	          }), main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-panel-text"
	            },
	            text: this.text
	          })]
	        })],
	        events: {
	          click: this.callbacks.onClick,
	          mouseover: this.callbacks.onMouseOver,
	          mouseout: this.callbacks.onMouseOut
	        }
	      });
	      this.elements.arrow = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-panel-item-with-arrow-right"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-panel-item-with-arrow-right-icon"
	          }
	        })],
	        events: {
	          click: function (e) {
	            this.callbacks.onArrowClick.apply(this, arguments);
	            e.stopPropagation();
	          }.bind(this)
	        }
	      });
	      if (!this.arrowHidden) {
	        this.elements.icon.appendChild(this.elements.arrow);
	      }
	      if (this.showLevel) {
	        this.elements.icon.appendChild(createSVG("svg", {
	          attrNS: {
	            "class": "bx-messenger-videocall-panel-item-level-meter-container",
	            width: "28",
	            height: "28",
	            viewBox: "0 0 28 28",
	            fill: "none"
	          },
	          children: [createSVG("defs", {
	            children: [createSVG("linearGradient", {
	              attrNS: {
	                id: "volumeGradient",
	                x1: "0%",
	                y1: "100%",
	                x2: "0%",
	                y2: "0%"
	              },
	              children: [this.elements.gradientStop1 = createSVG("stop", {
	                attrNS: {
	                  offset: "0",
	                  "stop-color": "#2FC6F6",
	                  id: "gradientStop1"
	                }
	              }), this.elements.gradientStop2 = createSVG("stop", {
	                attrNS: {
	                  offset: "0",
	                  "stop-color": "transparent",
	                  id: "gradientStop2"
	                }
	              })]
	            })]
	          }), createSVG("path", {
	            attrNS: {
	              "fill-rule": "evenodd",
	              "clip-rule": "evenodd",
	              d: "M20.4012 13.5741C20.9948 13.5614 21.4862 14.0351 21.4988 14.6321C21.5567 17.3753 19.5475 20.5964 15.6554 21.1285L15.6546 22.5504L16.1204 22.5507C16.6554 22.5507 17.0891 22.9869 17.0891 23.525C17.0891 24.0631 16.6554 24.4993 16.1204 24.4993H12.879C12.344 24.4993 11.9103 24.0631 11.9103 23.525C11.9103 22.9869 12.344 22.5507 12.879 22.5507L13.3433 22.5504L13.3432 21.1275C9.45683 20.5997 7.47015 17.4555 7.50034 14.6434C7.50675 14.0463 7.99323 13.5674 8.58692 13.5738C9.14103 13.5799 9.59269 14.0065 9.64523 14.5489L9.65028 14.6667C9.64425 15.2277 9.95576 16.3048 10.5307 17.1425C11.3561 18.3452 12.625 19.0421 14.5111 19.0421C16.3868 19.0421 17.6512 18.3317 18.4781 17.1059C19.0061 16.3232 19.3137 15.3287 19.3465 14.7932L19.3492 14.678C19.3366 14.081 19.8076 13.5867 20.4012 13.5741ZM14.4996 4.66602C16.2557 4.66602 17.6793 6.0193 17.6793 7.68867V14.0608C17.6793 15.7301 16.2557 17.0834 14.4996 17.0834C12.7435 17.0834 11.32 15.7301 11.32 14.0608L11.32 7.68867C11.32 6.0193 12.7435 4.66602 14.4996 4.66602Z",
	              fill: "url(#volumeGradient)"
	            }
	          })]
	        }));
	      } else if (this.showLevel) {
	        this.elements.icon.appendChild(createSVG("svg", {
	          attrNS: {
	            "class": "bx-messenger-videocall-panel-item-level-meter-container",
	            width: 3,
	            height: 20
	          },
	          children: [createSVG("g", {
	            attrNS: {
	              fill: "#30B1DC"
	            },
	            children: [createSVG("rect", {
	              attrNS: {
	                x: 0,
	                y: 0,
	                width: 3,
	                height: 20,
	                rx: 1.5,
	                opacity: .1
	              }
	            }), this.elements.levelMeter = createSVG("rect", {
	              attrNS: {
	                x: 0,
	                y: 20,
	                width: 3,
	                height: 20,
	                rx: 1.5
	              }
	            })]
	          })]
	        }));
	      }
	      this.elements.ellipsis = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-panel-icon-ellipsis"
	        },
	        events: {
	          click: this.callbacks.onSideIconClick
	        }
	      });
	      this.elements.pointer = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-panel-icon-pointer"
	        },
	        events: {
	          click: this.callbacks.onSideIconClick
	        }
	      });
	      if (this.sideIcon == "pointer") {
	        BX.Dom.insertAfter(this.elements.pointer, this.elements.icon);
	      } else if (this.sideIcon == "ellipsis") {
	        BX.Dom.insertAfter(this.elements.ellipsis, this.elements.icon);
	      }
	      return this.elements.root;
	    }
	  }, {
	    key: "getIconClass",
	    value: function getIconClass() {
	      return "bx-messenger-videocall-panel-item-with-arrow-icon bx-messenger-videocall-panel-item-with-arrow-icon-" + this["class"] + (this.enabled ? "" : "-off");
	    }
	  }, {
	    key: "getIconContainerClass",
	    value: function getIconContainerClass() {
	      return "bx-messenger-videocall-panel-item-with-arrow-icon-container" + " bx-messenger-videocall-panel-item-with-arrow-icon-container-" + this["class"] + (this.enabled ? "" : "-off");
	    }
	  }, {
	    key: "enable",
	    value: function enable() {
	      if (this.enabled) {
	        return;
	      }
	      this.enabled = true;
	      this.elements.iconContainer.className = this.getIconContainerClass();
	      this.elements.icon.className = this.getIconClass();
	      if (this.elements.gradientStop1 && this.elements.gradientStop2) {
	        this.elements.gradientStop1.setAttribute('offset', '0%');
	        this.elements.gradientStop2.setAttribute('offset', '0%');
	      } else if (this.elements.levelMeter) {
	        this.elements.levelMeter.setAttribute('y', Math.round((1 - this.level) * 20));
	      }
	    }
	  }, {
	    key: "disable",
	    value: function disable() {
	      if (!this.enabled) {
	        return;
	      }
	      this.enabled = false;
	      this.elements.iconContainer.className = this.getIconContainerClass();
	      this.elements.icon.className = this.getIconClass();
	      if (this.elements.gradientStop1 && this.elements.gradientStop2) {
	        this.elements.gradientStop1.setAttribute('offset', '0%');
	        this.elements.gradientStop2.setAttribute('offset', '0%');
	      } else if (this.elements.levelMeter) {
	        this.elements.levelMeter.setAttribute('y', Math.round((1 - this.level) * 20));
	      }
	    }
	  }, {
	    key: "setBlocked",
	    value: function setBlocked(blocked) {
	      if (this.blocked == blocked) {
	        return;
	      }
	      this.blocked = blocked;
	      this.elements.iconContainer.className = this.getIconContainerClass();
	      this.elements.icon.className = this.getIconClass();
	      if (this.blocked) {
	        this.elements.root.classList.add("blocked");
	      } else {
	        this.elements.root.classList.remove("blocked");
	      }
	    }
	  }, {
	    key: "setSideIcon",
	    value: function setSideIcon(sideIcon) {
	      if (this.sideIcon == sideIcon) {
	        return;
	      }
	      this.sideIcon = sideIcon;
	      BX.Dom.remove(this.elements.pointer);
	      BX.Dom.remove(this.elements.ellipsis);
	      if (this.sideIcon == "pointer") {
	        BX.Dom.insertAfter(this.elements.pointer, this.elements.icon);
	      } else if (this.sideIcon == "ellipsis") {
	        BX.Dom.insertAfter(this.elements.ellipsis, this.elements.icon);
	      }
	    }
	  }, {
	    key: "showArrow",
	    value: function showArrow() {
	      if (!this.arrowHidden) {
	        return;
	      }
	      this.arrowHidden = false;
	      this.elements.root.appendChild(this.elements.arrow);
	    }
	  }, {
	    key: "hideArrow",
	    value: function hideArrow() {
	      if (this.arrowHidden) {
	        return;
	      }
	      this.arrowHidden = false;
	      this.elements.root.removeChild(this.elements.arrow);
	    }
	  }, {
	    key: "setLevel",
	    value: function setLevel(level) {
	      this.level = Math.log(level * 100) / 4.6;
	      if (this.showLevel && this.enabled) {
	        var offset = "".concat(100 - Math.round((1 - this.level) * 100), "%");
	        this.elements.gradientStop1.setAttribute('offset', offset);
	        this.elements.gradientStop2.setAttribute('offset', offset);
	      }
	    }
	  }]);
	  return DeviceButton;
	}();
	var WaterMarkButton = /*#__PURE__*/function () {
	  function WaterMarkButton(config) {
	    babelHelpers.classCallCheck(this, WaterMarkButton);
	    this.language = config.language;
	  }
	  babelHelpers.createClass(WaterMarkButton, [{
	    key: "render",
	    value: function render() {
	      return main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-watermark"
	        },
	        children: [main_core.Dom.create("img", {
	          props: {
	            className: "bx-messenger-videocall-watermark-img",
	            src: this.getWatermarkUrl(this.language)
	          }
	        })]
	      });
	    }
	  }, {
	    key: "getWatermarkUrl",
	    value: function getWatermarkUrl(language) {
	      switch (language) {
	        case 'ru':
	        case 'kz':
	        case 'by':
	          return '/bitrix/js/call/images/new-logo-white-ru.svg';
	        default:
	          return '/bitrix/js/call/images/new-logo-white-en.svg';
	      }
	    }
	  }]);
	  return WaterMarkButton;
	}();
	var TopButton = /*#__PURE__*/function () {
	  function TopButton(config) {
	    babelHelpers.classCallCheck(this, TopButton);
	    this.iconClass = BX.prop.getString(config, "iconClass", "");
	    this.text = BX.prop.getString(config, "text", "");
	    this.callbacks = {
	      onClick: BX.prop.getFunction(config, "onClick", BX.DoNothing),
	      onMouseOver: BX.prop.getFunction(config, "onMouseOver", BX.DoNothing),
	      onMouseOut: BX.prop.getFunction(config, "onMouseOut", BX.DoNothing)
	    };
	  }
	  babelHelpers.createClass(TopButton, [{
	    key: "render",
	    value: function render() {
	      return main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-top-button"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-top-button-icon " + this.iconClass
	          }
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-top-button-text " + this.iconClass
	          },
	          text: this.text
	        })],
	        events: {
	          click: this.callbacks.onClick,
	          mouseover: this.callbacks.onMouseOver,
	          mouseout: this.callbacks.onMouseOut
	        }
	      });
	    }
	  }]);
	  return TopButton;
	}();
	var TopFramelessButton = /*#__PURE__*/function () {
	  function TopFramelessButton(config) {
	    babelHelpers.classCallCheck(this, TopFramelessButton);
	    this.iconClass = BX.prop.getString(config, "iconClass", "");
	    this.textClass = BX.prop.getString(config, "textClass", "");
	    this.text = BX.prop.getString(config, "text", "");
	    this.callbacks = {
	      onClick: BX.prop.getFunction(config, "onClick", BX.DoNothing),
	      onMouseOver: BX.prop.getFunction(config, "onMouseOver", BX.DoNothing),
	      onMouseOut: BX.prop.getFunction(config, "onMouseOut", BX.DoNothing)
	    };
	  }
	  babelHelpers.createClass(TopFramelessButton, [{
	    key: "render",
	    value: function render() {
	      return main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-top-button-frameless"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-top-button-icon " + this.iconClass
	          }
	        }), this.text != "" ? main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-top-button-text " + this.textClass
	          },
	          text: this.text
	        }) : null],
	        events: {
	          click: this.callbacks.onClick,
	          mouseover: this.callbacks.onMouseOver,
	          mouseout: this.callbacks.onMouseOut
	        }
	      });
	    }
	  }]);
	  return TopFramelessButton;
	}();
	var ParticipantsButton = /*#__PURE__*/function () {
	  function ParticipantsButton(config) {
	    babelHelpers.classCallCheck(this, ParticipantsButton);
	    this.count = BX.prop.getInteger(config, "count", 0);
	    this.foldButtonState = BX.prop.getString(config, "foldButtonState", ParticipantsButton.FoldButtonState.Hidden);
	    this.allowAdding = BX.prop.getBoolean(config, "allowAdding", false);
	    this.elements = {
	      root: null,
	      leftContainer: null,
	      rightContainer: null,
	      foldIcon: null,
	      count: null,
	      separator: null
	    };
	    this.callbacks = {
	      onListClick: BX.prop.getFunction(config, "onListClick", BX.DoNothing),
	      onAddClick: BX.prop.getFunction(config, "onAddClick", BX.DoNothing)
	    };
	  }
	  babelHelpers.createClass(ParticipantsButton, [{
	    key: "render",
	    value: function render() {
	      if (this.elements.root) {
	        return this.elements.root;
	      }
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-top-participants"
	        },
	        children: [this.elements.leftContainer = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-top-participants-inner left" + (this.foldButtonState != ParticipantsButton.FoldButtonState.Hidden ? " active" : "")
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-top-button-icon participants"
	            }
	          }), this.elements.count = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-top-participants-text-count"
	            },
	            text: this.count
	          }), this.elements.foldIcon = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-top-participants-fold-icon " + this.foldButtonState
	            }
	          })],
	          events: {
	            click: this.callbacks.onListClick
	          }
	        })]
	      });
	      this.elements.separator = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-top-participants-separator"
	        }
	      });
	      this.elements.rightContainer = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-top-participants-inner active"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-top-participants-text"
	          },
	          text: BX.message("IM_M_CALL_BTN_ADD")
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-top-button-icon add"
	          }
	        })],
	        events: {
	          click: this.callbacks.onAddClick
	        }
	      });
	      if (this.allowAdding) {
	        this.elements.root.appendChild(this.elements.separator);
	        this.elements.root.appendChild(this.elements.rightContainer);
	      }
	      return this.elements.root;
	    }
	  }, {
	    key: "update",
	    value: function update(config) {
	      this.count = BX.prop.getInteger(config, "count", this.count);
	      this.foldButtonState = BX.prop.getString(config, "foldButtonState", this.foldButtonState);
	      this.allowAdding = BX.prop.getBoolean(config, "allowAdding", this.allowAdding);
	      this.elements.count.innerText = this.count;
	      this.elements.foldIcon.className = "bx-messenger-videocall-top-participants-fold-icon " + this.foldButtonState;
	      if (this.foldButtonState == ParticipantsButton.FoldButtonState.Hidden) {
	        this.elements.leftContainer.classList.remove("active");
	      } else {
	        this.elements.leftContainer.classList.add("active");
	      }
	      if (this.allowAdding && !this.elements.separator.parentElement) {
	        this.elements.root.appendChild(this.elements.separator);
	        this.elements.root.appendChild(this.elements.rightContainer);
	      }
	      if (!this.allowAdding && this.elements.separator.parentElement) {
	        BX.remove(this.elements.separator);
	        BX.remove(this.elements.rightContainer);
	      }
	    }
	  }]);
	  return ParticipantsButton;
	}();
	babelHelpers.defineProperty(ParticipantsButton, "FoldButtonState", {
	  Active: "active",
	  Fold: "fold",
	  Unfold: "unfold",
	  Hidden: "hidden"
	});
	var ParticipantsButtonMobile = /*#__PURE__*/function () {
	  function ParticipantsButtonMobile(config) {
	    babelHelpers.classCallCheck(this, ParticipantsButtonMobile);
	    this.count = BX.prop.getInteger(config, "count", 0);
	    this.elements = {
	      root: null,
	      icon: null,
	      text: null,
	      arrow: null
	    };
	    this.callbacks = {
	      onClick: BX.prop.getFunction(config, "onClick", BX.DoNothing)
	    };
	  }
	  babelHelpers.createClass(ParticipantsButtonMobile, [{
	    key: "render",
	    value: function render() {
	      if (this.elements.root) {
	        return this.elements.root;
	      }
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-top-participants-mobile"
	        },
	        children: [this.elements.icon = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-top-participants-mobile-icon"
	          }
	        }), this.elements.text = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-top-participants-mobile-text"
	          },
	          text: BX.message("IM_M_CALL_PARTICIPANTS").replace("#COUNT#", this.count)
	        }), this.elements.arrow = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-top-participants-mobile-arrow"
	          }
	        })],
	        events: {
	          click: this.callbacks.onClick
	        }
	      });
	      return this.elements.root;
	    }
	  }, {
	    key: "setCount",
	    value: function setCount(count) {
	      if (this.count == count) {
	        return;
	      }
	      this.count = count;
	      this.elements.text.innerText = BX.message("IM_M_CALL_PARTICIPANTS").replace("#COUNT#", this.count);
	    }
	  }]);
	  return ParticipantsButtonMobile;
	}();
	var RecordStatusButton = /*#__PURE__*/function () {
	  function RecordStatusButton(config) {
	    babelHelpers.classCallCheck(this, RecordStatusButton);
	    this.userId = config.userId;
	    this.recordState = config.recordState;
	    this.updateViewInterval = null;
	    this.elements = {
	      root: null,
	      timeText: null,
	      stateText: null
	    };
	    this.callbacks = {
	      onPauseClick: BX.prop.getFunction(config, "onPauseClick", BX.DoNothing),
	      onStopClick: BX.prop.getFunction(config, "onStopClick", BX.DoNothing),
	      onMouseOver: BX.prop.getFunction(config, "onMouseOver", BX.DoNothing),
	      onMouseOut: BX.prop.getFunction(config, "onMouseOut", BX.DoNothing)
	    };
	  }
	  babelHelpers.createClass(RecordStatusButton, [{
	    key: "render",
	    value: function render() {
	      if (this.elements.root) {
	        return this.elements.root;
	      }
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-top-recordstatus record-status-" + this.recordState.state + " " + (this.recordState.userId == this.userId ? '' : 'record-user-viewer')
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-top-recordstatus-status"
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-top-button-icon record-status"
	            }
	          })]
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-top-recordstatus-time"
	          },
	          children: [this.elements.timeText = main_core.Dom.create("span", {
	            props: {
	              className: "bx-messenger-videocall-top-recordstatus-time-text"
	            },
	            text: Util.getRecordTimeText(this.recordState)
	          })]
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-top-recordstatus-separator"
	          }
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-top-recordstatus-buttons"
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-top-recordstatus-button"
	            },
	            children: [main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-top-button-icon record-pause"
	              }
	            })],
	            events: {
	              click: this.callbacks.onPauseClick
	            }
	          })]
	        })],
	        events: {
	          mouseover: this.callbacks.onMouseOver,
	          mouseout: this.callbacks.onMouseOut
	        }
	      });
	      return this.elements.root;
	    }
	  }, {
	    key: "update",
	    value: function update(recordState) {
	      if (this.recordState.state !== recordState.state) {
	        clearInterval(this.updateViewInterval);
	        if (recordState.state === View.RecordState.Started) {
	          this.updateViewInterval = setInterval(this.updateView.bind(this), 1000);
	        }
	      }
	      this.recordState = recordState;
	      this.updateView();
	    }
	  }, {
	    key: "updateView",
	    value: function updateView() {
	      var timeText = Util.getRecordTimeText(this.recordState);
	      if (this.elements.timeText.innerText !== timeText) {
	        this.elements.timeText.innerText = Util.getRecordTimeText(this.recordState);
	      }
	      if (!this.elements.root.classList.contains("record-status-" + this.recordState.state)) {
	        this.elements.root.className = "bx-messenger-videocall-top-recordstatus record-status-" + this.recordState.state + ' ' + (this.recordState.userId == this.userId ? '' : 'record-user-viewer');
	      }
	    }
	  }, {
	    key: "stopViewUpdate",
	    value: function stopViewUpdate() {
	      if (this.updateViewInterval) {
	        clearInterval(this.updateViewInterval);
	        this.updateViewInterval = null;
	      }
	    }
	  }]);
	  return RecordStatusButton;
	}();

	var CallUserMobile = /*#__PURE__*/function () {
	  function CallUserMobile(config) {
	    babelHelpers.classCallCheck(this, CallUserMobile);
	    this.userModel = config.userModel;
	    this.elements = {
	      root: null,
	      avatar: null,
	      avatarOutline: null,
	      userName: null,
	      userStatus: null,
	      menuArrow: null,
	      floorRequest: null,
	      mic: null,
	      cam: null
	    };
	    this._onUserFieldChangeHandler = this._onUserFieldChange.bind(this);
	    this.userModel.subscribe("changed", this._onUserFieldChangeHandler);
	    this.callbacks = {
	      onClick: BX.prop.getFunction(config, "onClick", BX.DoNothing)
	    };
	    this.avatarBackground = Util.getAvatarBackground();
	  }
	  babelHelpers.createClass(CallUserMobile, [{
	    key: "render",
	    value: function render() {
	      if (this.elements.root) {
	        return this.elements.root;
	      }
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-user-mobile"
	        },
	        children: [this.elements.avatar = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-mobile-avatar" + (this.userModel.talking ? " talking" : "")
	          },
	          children: [this.elements.floorRequest = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-user-mobile-floor-request bx-messenger-videocall-floor-request-icon"
	            }
	          })]
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-mobile-body"
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-user-mobile-text"
	            },
	            children: [this.elements.mic = main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-user-mobile-icon" + (this.userModel.microphoneState ? "" : " bx-call-view-icon-red-microphone-off")
	              }
	            }), this.elements.cam = main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-user-mobile-icon" + (this.userModel.cameraState ? "" : " bx-call-view-icon-red-camera-off")
	              }
	            }), this.elements.userName = main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-user-mobile-username"
	              },
	              text: this.userModel.name
	            }), main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-user-mobile-menu-arrow"
	              }
	            })]
	          }), this.elements.userStatus = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-user-mobile-user-status"
	            },
	            text: this.userModel.pinned ? BX.message("IM_M_CALL_PINNED_USER") : BX.message("IM_M_CALL_CURRENT_PRESENTER")
	          })]
	        })],
	        events: {
	          click: this.callbacks.onClick
	        }
	      });
	      return this.elements.root;
	    }
	  }, {
	    key: "update",
	    value: function update() {
	      if (!this.elements.root) {
	        return;
	      }
	      this.elements.userName.innerText = this.userModel.name;
	      if (this.userModel.avatar !== '') {
	        this.elements.root.style.setProperty("--avatar", "url('" + this.userModel.avatar + "')");
	        this.elements.avatar.innerText = '';
	        this.elements.root.style.removeProperty("--avatar-background");
	      } else {
	        this.elements.root.style.removeProperty("--avatar");
	        this.elements.root.style.setProperty("--avatar-background", this.avatarBackground);
	        this.elements.avatar.innerText = im_v2_lib_utils.Utils.text.getFirstLetters(this.userModel.name).toUpperCase();
	      }
	      this.elements.avatar.classList.toggle("talking", this.userModel.talking);
	      this.elements.floorRequest.classList.toggle("active", this.userModel.floorRequestState);
	      this.elements.mic.classList.toggle("bx-call-view-icon-red-microphone-off", !this.userModel.microphoneState);
	      this.elements.cam.classList.toggle("bx-call-view-icon-red-camera-off", !this.userModel.cameraState);
	      this.elements.userStatus.innerText = this.userModel.pinned ? BX.message("IM_M_CALL_PINNED_USER") : BX.message("IM_M_CALL_CURRENT_PRESENTER");
	    }
	  }, {
	    key: "mount",
	    value: function mount(parentElement) {
	      parentElement.appendChild(this.render());
	    }
	  }, {
	    key: "dismount",
	    value: function dismount() {
	      if (!this.elements.root) {
	        return;
	      }
	      main_core.Dom.remove(this.elements.root);
	    }
	  }, {
	    key: "setUserModel",
	    value: function setUserModel(userModel) {
	      this.userModel.unsubscribe("changed", this._onUserFieldChangeHandler);
	      this.userModel = userModel;
	      this.userModel.subscribe("changed", this._onUserFieldChangeHandler);
	      this.update();
	    }
	  }, {
	    key: "_onUserFieldChange",
	    value: function _onUserFieldChange(event) {
	      this.update();
	    }
	  }]);
	  return CallUserMobile;
	}();
	var UserSelectorMobile = /*#__PURE__*/function () {
	  function UserSelectorMobile(config) {
	    babelHelpers.classCallCheck(this, UserSelectorMobile);
	    this.userRegistry = config.userRegistry;
	    this.userRegistry.subscribe("userAdded", this._onUserAdded.bind(this));
	    this.userRegistry.subscribe("userChanged", this._onUserChanged.bind(this));
	    this.elements = {
	      root: null,
	      users: {}
	    };
	  }
	  babelHelpers.createClass(UserSelectorMobile, [{
	    key: "render",
	    value: function render() {
	      if (this.elements.root) {
	        return this.elements.root;
	      }
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-user-selector-mobile"
	        }
	      });
	      this.updateUsers();
	      return this.elements.root;
	    }
	  }, {
	    key: "renderUser",
	    value: function renderUser(userFields) {
	      return createSVG("svg", {
	        attrNS: {
	          width: 14.5,
	          height: 11.6
	        },
	        style: {
	          order: userFields.order
	        },
	        children: [createSVG("circle", {
	          attrNS: {
	            "class": "bx-messenger-videocall-user-selector-mobile-border" + (userFields.talking ? " talking" : ""),
	            cx: 7.25,
	            cy: 5.8,
	            r: 4.6
	          }
	        }), createSVG("circle", {
	          attrNS: {
	            "class": "bx-messenger-videocall-user-selector-mobile-dot" + (userFields.centralUser ? " pinned" : ""),
	            cx: 7.25,
	            cy: 5.8,
	            r: 3.3
	          }
	        })]
	      });
	    }
	  }, {
	    key: "updateUsers",
	    value: function updateUsers() {
	      this.userRegistry.users.forEach(function (userFields) {
	        if (userFields.localUser || userFields.state != UserState.Connected) {
	          if (this.elements.users[userFields.id]) {
	            BX.remove(this.elements.users[userFields.id]);
	            this.elements.users[userFields.id] = null;
	          }
	        } else {
	          var newNode = this.renderUser(userFields);
	          if (this.elements.users[userFields.id]) {
	            BX.replace(this.elements.users[userFields.id], newNode);
	          } else {
	            this.elements.root.appendChild(newNode);
	          }
	          this.elements.users[userFields.id] = newNode;
	        }
	      }, this);
	    }
	  }, {
	    key: "_onUserAdded",
	    value: function _onUserAdded(event) {
	      this.updateUsers();
	    }
	  }, {
	    key: "_onUserChanged",
	    value: function _onUserChanged(event) {
	      this.updateUsers();
	    }
	  }, {
	    key: "mount",
	    value: function mount(parentElement) {
	      parentElement.appendChild(this.render());
	    }
	  }, {
	    key: "dismount",
	    value: function dismount() {
	      if (!this.elements.root) {
	        return;
	      }
	      BX.remove(this.elements.root);
	    }
	  }]);
	  return UserSelectorMobile;
	}();
	var MobileSlider = /*#__PURE__*/function () {
	  function MobileSlider(config) {
	    babelHelpers.classCallCheck(this, MobileSlider);
	    this.parent = config.parent || null;
	    this.content = config.content || null;
	    this.elements = {
	      background: null,
	      root: null,
	      handle: null,
	      body: null
	    };
	    this.callbacks = {
	      onClose: BX.prop.getFunction(config, "onClose", BX.DoNothing),
	      onDestroy: BX.prop.getFunction(config, "onDestroy", BX.DoNothing)
	    };
	    this.touchStartY = 0;
	    this.processedTouchId = 0;
	  }
	  babelHelpers.createClass(MobileSlider, [{
	    key: "render",
	    value: function render() {
	      if (this.elements.root) {
	        return this.elements.root;
	      }
	      this.elements.background = main_core.Dom.create("div", {
	        props: {
	          className: "bx-videocall-mobile-menu-background"
	        },
	        events: {
	          click: this._onBackgroundClick.bind(this)
	        }
	      });
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-videocall-mobile-menu-container"
	        },
	        children: [this.elements.handle = main_core.Dom.create("div", {
	          props: {
	            className: "bx-videocall-mobile-menu-handle"
	          }
	        }), this.elements.body = main_core.Dom.create("div", {
	          props: {
	            className: "bx-videocall-mobile-menu"
	          },
	          children: [this.content]
	        })],
	        events: {
	          touchstart: this._onTouchStart.bind(this),
	          touchmove: this._onTouchMove.bind(this),
	          touchend: this._onTouchEnd.bind(this)
	        }
	      });
	      return this.elements.root;
	    }
	  }, {
	    key: "show",
	    value: function show() {
	      if (this.parent) {
	        this.render();
	        this.parent.appendChild(this.elements.root);
	        this.parent.appendChild(this.elements.background);
	      }
	    }
	  }, {
	    key: "close",
	    value: function close() {
	      BX.remove(this.elements.root);
	      BX.remove(this.elements.background);
	      this.callbacks.onClose();
	    }
	  }, {
	    key: "closeWithAnimation",
	    value: function closeWithAnimation() {
	      if (!this.elements.root) {
	        return;
	      }
	      this.elements.root.classList.add("closing");
	      this.elements.background.classList.add("closing");
	      this.elements.root.addEventListener("animationend", function () {
	        this.close();
	      }.bind(this));
	    }
	  }, {
	    key: "_onTouchStart",
	    value: function _onTouchStart(e) {
	      this.touchStartY = e.pageY;
	      if (this.processedTouchId || e.touches.length > 1) {
	        return;
	      }
	      if (e.target == this.elements.header || e.target == this.elements.root || this.elements.body.scrollTop === 0) {
	        this.processedTouchId = e.touches[0].identifier;
	      }
	    }
	  }, {
	    key: "_onTouchMove",
	    value: function _onTouchMove(e) {
	      if (e.touches.length > 1) {
	        return;
	      }
	      if (e.touches[0].identifier != this.processedTouchId) {
	        return;
	      }
	      var delta = this.touchStartY - e.pageY;
	      if (delta > 0) {
	        delta = 0;
	      }
	      this.elements.root.style.bottom = delta + "px";
	      if (delta) {
	        e.preventDefault();
	      }
	    }
	  }, {
	    key: "_onTouchEnd",
	    value: function _onTouchEnd(e) {
	      var allowProcessing = false;
	      for (var i = 0; i < e.changedTouches.length; i++) {
	        if (e.changedTouches[i].identifier == this.processedTouchId) {
	          allowProcessing = true;
	          break;
	        }
	      }
	      if (!allowProcessing) {
	        return;
	      }
	      var delta = e.pageY - this.touchStartY;
	      if (delta > 100) {
	        this.closeWithAnimation();
	        e.preventDefault();
	      } else {
	        this.elements.root.style.removeProperty("bottom");
	      }
	      this.processedTouchId = 0;
	      this.touchStartY = 0;
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.callbacks.onDestroy();
	      this.elements = {};
	      this.callbacks = {};
	      this.parent = null;
	    }
	  }, {
	    key: "_onBackgroundClick",
	    value: function _onBackgroundClick() {
	      this.closeWithAnimation();
	    }
	  }]);
	  return MobileSlider;
	}();
	var MobileMenu = /*#__PURE__*/function () {
	  function MobileMenu(config) {
	    babelHelpers.classCallCheck(this, MobileMenu);
	    this.parent = config.parent || null;
	    this.header = BX.prop.getString(config, "header", "");
	    this.largeIcons = BX.prop.getBoolean(config, "largeIcons", false);
	    this.slider = null;
	    var items = BX.prop.getArray(config, "items", []);
	    if (items.length === 0) {
	      throw Error("Items array should not be empty");
	    }
	    this.items = items.filter(function (item) {
	      return babelHelpers["typeof"](item) === "object" && !!item;
	    }).map(function (item) {
	      return new MobileMenuItem(item);
	    });
	    this.elements = {
	      root: null,
	      header: null,
	      body: null
	    };
	    this.callbacks = {
	      onClose: BX.prop.getFunction(config, "onClose", BX.DoNothing),
	      onDestroy: BX.prop.getFunction(config, "onDestroy", BX.DoNothing)
	    };
	  }
	  babelHelpers.createClass(MobileMenu, [{
	    key: "render",
	    value: function render() {
	      var _this = this;
	      this.elements.header = main_core.Dom.create("div", {
	        props: {
	          className: "bx-videocall-mobile-menu-header"
	        },
	        text: this.header
	      });
	      this.elements.body = main_core.Dom.create("div", {
	        props: {
	          className: "bx-videocall-mobile-menu-body" + (this.largeIcons ? " bx-videocall-mobile-menu-large" : "")
	        }
	      });
	      this.items.forEach(function (item) {
	        if (item) {
	          _this.elements.body.appendChild(item.render());
	        }
	      });
	      return BX.createFragment([this.elements.header, this.elements.body]);
	    }
	  }, {
	    key: "setHeader",
	    value: function setHeader(header) {
	      this.header = header;
	      if (this.elements.header) {
	        this.elements.header.innerText = header;
	      }
	    }
	  }, {
	    key: "show",
	    value: function show() {
	      if (!this.slider) {
	        this.slider = new MobileSlider({
	          parent: this.parent,
	          content: this.render(),
	          onClose: this.onSliderClose.bind(this),
	          onDestroy: this.onSliderDestroy.bind(this)
	        });
	      }
	      this.slider.show();
	    }
	  }, {
	    key: "close",
	    value: function close() {
	      if (this.slider) {
	        this.slider.close();
	      }
	    }
	  }, {
	    key: "onSliderClose",
	    value: function onSliderClose() {
	      this.slider.destroy();
	    }
	  }, {
	    key: "onSliderDestroy",
	    value: function onSliderDestroy() {
	      this.slider = null;
	      this.destroy();
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      if (this.slider) {
	        this.slider.destroy();
	      }
	      this.slider = null;
	      this.items.forEach(function (item) {
	        item.destroy();
	      });
	      this.items = [];
	      this.callbacks.onDestroy();
	      this.elements = {};
	      this.callbacks = {};
	      this.parent = null;
	    }
	  }]);
	  return MobileMenu;
	}();
	var MobileMenuItem = /*#__PURE__*/function () {
	  function MobileMenuItem(config) {
	    babelHelpers.classCallCheck(this, MobileMenuItem);
	    this.id = BX.prop.getString(config, "id", Util.getUuidv4());
	    this.icon = BX.prop.getString(config, "icon", "");
	    this.iconClass = BX.prop.getString(config, "iconClass", "");
	    this.text = BX.prop.getString(config, "text", "");
	    this.showSubMenu = BX.prop.getBoolean(config, "showSubMenu", false);
	    this.separator = BX.prop.getBoolean(config, "separator", false);
	    this.enabled = BX.prop.getBoolean(config, "enabled", true);
	    this.userModel = BX.prop.get(config, "userModel", null);
	    this.avatarBackground = Util.getAvatarBackground();
	    if (this.userModel) {
	      this._userChangeHandler = this._onUserChange.bind(this);
	      this.subscribeUserEvents();
	      this.text = this.userModel.name;
	      this.icon = this.userModel.avatar;
	      this.iconClass = "user-avatar";
	      this.iconText = im_v2_lib_utils.Utils.text.getFirstLetters(this.userModel.name);
	      this.iconBackground = Util.getAvatarBackground();
	    }
	    this.elements = {
	      root: null,
	      icon: null,
	      content: null,
	      submenu: null,
	      separator: null,
	      mic: null,
	      cam: null
	    };
	    this.callbacks = {
	      click: BX.prop.getFunction(config, "onClick", BX.DoNothing),
	      clickSubMenu: BX.prop.getFunction(config, "onClickSubMenu", BX.DoNothing)
	    };
	  }
	  babelHelpers.createClass(MobileMenuItem, [{
	    key: "render",
	    value: function render() {
	      if (this.elements.root) {
	        return this.elements.root;
	      }
	      if (this.separator) {
	        this.elements.root = main_core.Dom.create("hr", {
	          props: {
	            className: "bx-videocall-mobile-menu-item-separator"
	          }
	        });
	      } else {
	        this.elements.root = main_core.Dom.create("div", {
	          props: {
	            className: "bx-videocall-mobile-menu-item" + (this.enabled ? "" : " disabled")
	          },
	          children: [this.elements.icon = main_core.Dom.create("div", {
	            props: {
	              className: "bx-videocall-mobile-menu-item-icon " + this.iconClass
	            }
	          }), this.elements.content = main_core.Dom.create("div", {
	            props: {
	              className: "bx-videocall-mobile-menu-item-content"
	            },
	            children: [main_core.Dom.create("span", {
	              text: this.text
	            })]
	          })],
	          events: {
	            click: this.callbacks.click
	          }
	        });
	        if (this.icon != "") {
	          this.elements.icon.style.backgroundImage = "url(\"" + this.icon + "\")";
	          this.elements.icon.innerText = '';
	        } else if (this.iconText) {
	          this.elements.icon.innerText = this.iconText;
	          this.elements.root.style.setProperty("--avatar-background", this.avatarBackground);
	        }
	        if (this.showSubMenu) {
	          this.elements.submenu = main_core.Dom.create("div", {
	            props: {
	              className: "bx-videocall-mobile-menu-item-submenu-icon"
	            }
	          });
	          this.elements.root.appendChild(this.elements.submenu);
	        }
	        if (this.userModel) {
	          this.elements.mic = main_core.Dom.create("div", {
	            props: {
	              className: "bx-videocall-mobile-menu-icon-user bx-call-view-icon-red-microphone-off"
	            }
	          });
	          this.elements.cam = main_core.Dom.create("div", {
	            props: {
	              className: "bx-videocall-mobile-menu-icon-user bx-call-view-icon-red-camera-off"
	            }
	          });
	          if (!this.userModel.cameraState) {
	            this.elements.content.prepend(this.elements.cam);
	          }
	          if (!this.userModel.microphoneState) {
	            this.elements.content.prepend(this.elements.mic);
	          }
	        }
	      }
	      return this.elements.root;
	    }
	  }, {
	    key: "updateUserIcons",
	    value: function updateUserIcons() {
	      if (!this.userModel) {
	        return;
	      }
	      if (this.userModel.microphoneState) {
	        BX.remove(this.elements.mic);
	      } else {
	        this.elements.content.prepend(this.elements.mic);
	      }
	      if (this.userModel.cameraState) {
	        BX.remove(this.elements.cam);
	      } else {
	        this.elements.content.prepend(this.elements.cam);
	      }
	    }
	  }, {
	    key: "subscribeUserEvents",
	    value: function subscribeUserEvents() {
	      this.userModel.subscribe("changed", this._userChangeHandler);
	    }
	  }, {
	    key: "_onUserChange",
	    value: function _onUserChange(event) {
	      this.updateUserIcons();
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      if (this.userModel) {
	        this.userModel.unsubscribe("changed", this._userChangeHandler);
	        this.userModel = null;
	      }
	      this.callbacks = null;
	      this.elements = null;
	    }
	  }]);
	  return MobileMenuItem;
	}();

	function logPlaybackError(error) {
	  console.error("Playback start error: ", error);
	}

	function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
	function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
	function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
	function _regeneratorRuntime() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, defineProperty = Object.defineProperty || function (obj, key, desc) { obj[key] = desc.value; }, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return defineProperty(generator, "_invoke", { value: makeInvokeMethod(innerFn, self, context) }), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == babelHelpers["typeof"](value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; defineProperty(this, "_invoke", { value: function value(method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; } function maybeInvokeDelegate(delegate, context) { var methodName = context.method, method = delegate.iterator[methodName]; if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel; var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), defineProperty(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (val) { var object = Object(val), keys = []; for (var key in object) keys.push(key); return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, "catch": function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }
	function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
	function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { babelHelpers.defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
	function _classPrivateMethodInitSpec(obj, privateSet) { _checkPrivateRedeclaration(obj, privateSet); privateSet.add(obj); }
	function _classPrivateFieldInitSpec(obj, privateMap, value) { _checkPrivateRedeclaration(obj, privateMap); privateMap.set(obj, value); }
	function _checkPrivateRedeclaration(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }
	function _classPrivateMethodGet(receiver, privateSet, fn) { if (!privateSet.has(receiver)) { throw new TypeError("attempted to get private field on non-instance"); } return fn; }
	var MediaStreamsKinds = {
	  Camera: 1,
	  Microphone: 2,
	  Screen: 3,
	  ScreenAudio: 4
	};
	var Track = function Track(id, track) {
	  babelHelpers.classCallCheck(this, Track);
	  babelHelpers.defineProperty(this, "id", null);
	  babelHelpers.defineProperty(this, "source", '');
	  babelHelpers.defineProperty(this, "track", {});
	  this.id = id;
	  this.source = track.source;
	  this.track = track;
	};
	var Message = function Message(message) {
	  babelHelpers.classCallCheck(this, Message);
	  this.text = message.message;
	  this.from = message.senderSid;
	  this.timestamp = Math.floor(Date.now() / 1000);
	};
	var STREAM_QUALITY = {
	  HIGH: 2,
	  MEDIUM: 1,
	  LOW: 0
	};
	var CALL_STATE = {
	  CONNECTED: 'Connected',
	  PROGRESSING: 'Progressing',
	  TERMINATED: 'Terminated'
	};
	var VIDEO_QUEUE = {
	  INITIAL: '',
	  ENABLE: 'enable',
	  DISABLE: 'disable'
	};
	var LOG_LEVEL = {
	  INFO: 'INFO',
	  WARNING: 'WARNING',
	  ERROR: 'ERROR'
	};
	var MONITORING_EVENTS_NAME_LIST = {
	  TRACK_SUBSCRIPTION_FAILED: 3,
	  TRACK_SUBSCRIPTION_DELAY: 4,
	  HIGH_PACKET_LOSS_SEND: 7,
	  HIGH_PACKET_LOSS_RECEIVE: 8,
	  CPU_ISSUES: 9,
	  NETWORK_ISSUES: 10,
	  PEER_CONNECTION_REFUSED: 11,
	  PEER_CONNECTION_ISSUES: 12,
	  USER_CAMERA_DISABLED: 14,
	  USER_RECONNECTED: 15,
	  LOCAL_VIDEO_STREAM_RECEIVING_FAILED: 18,
	  LOCAL_MICROPHONE_STREAM_RECEIVING_FAILED: 19,
	  LOCAL_SCREEN_STREAM_RECEIVING_FAILED: 20,
	  LOCAL_VIDEO_STREAM_PUBLICATION_FAILED: 21,
	  LOCAL_MICROPHONE_STREAM_PUBLICATION_FAILED: 22,
	  LOCAL_SCREEN_STREAM_PUBLICATION_FAILED: 23
	};
	var MONITORING_EVENTS_LIST = {
	  metrics: {
	    PACKET_LOST_SEND: [],
	    PACKET_LOST_RECEIVE: [],
	    COUNT_TRACKS: {
	      video: 0,
	      audio: 0
	    },
	    BITRATE_IN: [],
	    BITRATE_OUT: [],
	    CONN_SCORE_CURRENT: [],
	    JITTER: [],
	    TOTAL_FREEZE_DURATION: [],
	    FREEZE_COUNT: [],
	    FRAMES_DECODED: [],
	    FRAMES_DROPPED: [],
	    FRAMES_RECEIVED: [],
	    FRAMES_LOSS: []
	  },
	  startTimestamp: 0,
	  events: []
	};
	var ReconnectionReason = {
	  NetworkError: 'NetworkError',
	  PingPongMissed: 'PingPongMissed',
	  PeerConnectionFailed: 'PeerConnectionFailed',
	  WsTransportClosed: 'WsTransportClosed',
	  LeaveCommand: 'LeaveCommand',
	  JoinResponseError: 'JoinResponseError'
	};
	var ErrorPreventingReconnection = {
	  InputError: 2,
	  AccessDenied: 3,
	  RoomNotFound: 5,
	  MalfunctioningSignaling: 7
	};
	var _privateProperties = /*#__PURE__*/new WeakMap();
	var _reconnect = /*#__PURE__*/new WeakSet();
	var _beforeDisconnect = /*#__PURE__*/new WeakSet();
	var _resetPingTimeout = /*#__PURE__*/new WeakSet();
	var _clearPingTimeout = /*#__PURE__*/new WeakSet();
	var _startPingInterval = /*#__PURE__*/new WeakSet();
	var _clearPingInterval = /*#__PURE__*/new WeakSet();
	var _sendPing = /*#__PURE__*/new WeakSet();
	var _addPendingPublication = /*#__PURE__*/new WeakSet();
	var _addPendingSubscription = /*#__PURE__*/new WeakSet();
	var _getMaxEncodingsByVideoWidth = /*#__PURE__*/new WeakSet();
	var _getEncodingsFromVideoWidth = /*#__PURE__*/new WeakSet();
	var _getLayersFromEncodings = /*#__PURE__*/new WeakSet();
	var _updateVideoEncodings = /*#__PURE__*/new WeakSet();
	var _changeSubscriptionToTrack = /*#__PURE__*/new WeakSet();
	var _pauseRemoteTrack = /*#__PURE__*/new WeakSet();
	var _calculateVideoQualityForUser = /*#__PURE__*/new WeakSet();
	var _changeRoomStreamsQuality = /*#__PURE__*/new WeakSet();
	var _toggleRemoteParticipantVideo = /*#__PURE__*/new WeakSet();
	var _processVideoQueue = /*#__PURE__*/new WeakSet();
	var _getUserMedia = /*#__PURE__*/new WeakSet();
	var _getDisplayMedia = /*#__PURE__*/new WeakSet();
	var _addTrackMuteHandlers = /*#__PURE__*/new WeakSet();
	var _sendLog = /*#__PURE__*/new WeakSet();
	var _removeUdpFromSdp = /*#__PURE__*/new WeakSet();
	var _answerHandler = /*#__PURE__*/new WeakSet();
	var _offerHandler = /*#__PURE__*/new WeakSet();
	var _addIceCandidate = /*#__PURE__*/new WeakSet();
	var _setRemoteParticipant = /*#__PURE__*/new WeakSet();
	var _createRemoteTrack = /*#__PURE__*/new WeakSet();
	var _speakerChangedHandler = /*#__PURE__*/new WeakSet();
	var _createPeerConnection = /*#__PURE__*/new WeakSet();
	var _destroyPeerConnection = /*#__PURE__*/new WeakSet();
	var _releaseStream = /*#__PURE__*/new WeakSet();
	var _getSender = /*#__PURE__*/new WeakSet();
	var _sendSignal = /*#__PURE__*/new WeakSet();
	var _sendLeave = /*#__PURE__*/new WeakSet();
	var Call = /*#__PURE__*/function () {
	  function Call() {
	    babelHelpers.classCallCheck(this, Call);
	    _classPrivateMethodInitSpec(this, _sendLeave);
	    _classPrivateMethodInitSpec(this, _sendSignal);
	    _classPrivateMethodInitSpec(this, _getSender);
	    _classPrivateMethodInitSpec(this, _releaseStream);
	    _classPrivateMethodInitSpec(this, _destroyPeerConnection);
	    _classPrivateMethodInitSpec(this, _createPeerConnection);
	    _classPrivateMethodInitSpec(this, _speakerChangedHandler);
	    _classPrivateMethodInitSpec(this, _createRemoteTrack);
	    _classPrivateMethodInitSpec(this, _setRemoteParticipant);
	    _classPrivateMethodInitSpec(this, _addIceCandidate);
	    _classPrivateMethodInitSpec(this, _offerHandler);
	    _classPrivateMethodInitSpec(this, _answerHandler);
	    _classPrivateMethodInitSpec(this, _removeUdpFromSdp);
	    _classPrivateMethodInitSpec(this, _sendLog);
	    _classPrivateMethodInitSpec(this, _addTrackMuteHandlers);
	    _classPrivateMethodInitSpec(this, _getDisplayMedia);
	    _classPrivateMethodInitSpec(this, _getUserMedia);
	    _classPrivateMethodInitSpec(this, _processVideoQueue);
	    _classPrivateMethodInitSpec(this, _toggleRemoteParticipantVideo);
	    _classPrivateMethodInitSpec(this, _changeRoomStreamsQuality);
	    _classPrivateMethodInitSpec(this, _calculateVideoQualityForUser);
	    _classPrivateMethodInitSpec(this, _pauseRemoteTrack);
	    _classPrivateMethodInitSpec(this, _changeSubscriptionToTrack);
	    _classPrivateMethodInitSpec(this, _updateVideoEncodings);
	    _classPrivateMethodInitSpec(this, _getLayersFromEncodings);
	    _classPrivateMethodInitSpec(this, _getEncodingsFromVideoWidth);
	    _classPrivateMethodInitSpec(this, _getMaxEncodingsByVideoWidth);
	    _classPrivateMethodInitSpec(this, _addPendingSubscription);
	    _classPrivateMethodInitSpec(this, _addPendingPublication);
	    _classPrivateMethodInitSpec(this, _sendPing);
	    _classPrivateMethodInitSpec(this, _clearPingInterval);
	    _classPrivateMethodInitSpec(this, _startPingInterval);
	    _classPrivateMethodInitSpec(this, _clearPingTimeout);
	    _classPrivateMethodInitSpec(this, _resetPingTimeout);
	    _classPrivateMethodInitSpec(this, _beforeDisconnect);
	    _classPrivateMethodInitSpec(this, _reconnect);
	    babelHelpers.defineProperty(this, "sender", null);
	    babelHelpers.defineProperty(this, "recipient", null);
	    _classPrivateFieldInitSpec(this, _privateProperties, {
	      writable: true,
	      value: {
	        clientVersion: '1.0.0',
	        clientPlatform: 'web',
	        codec: 'vp8',
	        canReconnect: true,
	        logs: {},
	        isloggingEnable: true,
	        loggerCallback: null,
	        abortController: new AbortController(),
	        isWaitAnswer: false,
	        reportsForIncomingTracks: {},
	        reportsForOutgoingTracks: {},
	        prevParticipantsWithLargeDataLoss: new Set(),
	        tracksDataFromSocket: {},
	        realTracksIds: {},
	        // todo: check why track ids are different in a stream and in the track itself
	        url: null,
	        roomId: null,
	        token: null,
	        endpoint: null,
	        jwt: null,
	        options: null,
	        iceServers: null,
	        socketConnect: null,
	        peerConnectionFailed: false,
	        pendingCandidates: {
	          recipient: [],
	          sender: []
	        },
	        pendingPublications: {},
	        pendingSubscriptions: {},
	        publicationTimeout: 10000,
	        subscriptionTimeout: 1500,
	        subscriptionTries: 5,
	        cameraStream: null,
	        microphoneStream: null,
	        screenStream: null,
	        mediaMutedBySystem: false,
	        needToEnableAudioAfterSystemMuted: false,
	        needToDisableAudioAfterPublish: false,
	        localTracks: {},
	        localConnectionQuality: 0,
	        minimalConnectionQuality: 2,
	        rtt: 0,
	        pingIntervalDuration: 0,
	        pingTimeoutDuration: 0,
	        ontrackData: {},
	        remoteTracks: {},
	        remoteParticipants: {},
	        mainStream: {},
	        pingPongTimeout: null,
	        pingPongInterval: null,
	        userId: '',
	        localParticipantSid: '',
	        defaultVideoResolution: {
	          width: 1280,
	          height: 720
	        },
	        defaultSimulcastBitrate: {
	          q: 120000,
	          h: 300000,
	          f: 1000000
	        },
	        defaultRemoteStreamsQuality: STREAM_QUALITY.MEDIUM,
	        audioBitrate: 70000,
	        videoBitrate: 1500000,
	        screenBitrate: 1500000,
	        videoSimulcast: true,
	        screenSimulcast: false,
	        events: new Map(),
	        offersStack: 0,
	        audioDeviceId: '',
	        switchActiveAudioDeviceInProgress: null,
	        switchActiveAudioDevicePending: null,
	        videoDeviceId: '',
	        switchActiveVideoDeviceInProgress: null,
	        switchActiveVideoDevicePending: null,
	        isReconnecting: false,
	        reconnectionAttempt: 0,
	        reconnectionTimeout: null,
	        lastReconnectionReason: null,
	        fastReconnectionDelay: 1000,
	        reconnectionDelay: 5000,
	        callStatsInterval: null,
	        callState: '',
	        wasConnected: false,
	        packetLostThreshold: 7,
	        statsTimeout: 3000,
	        videoQueue: VIDEO_QUEUE.INITIAL,
	        videoStreamSetupErrorList: {}
	      }
	    });
	    this.sendLeaveBound = _classPrivateMethodGet(this, _sendLeave, _sendLeave2).bind(this);
	    this.beforeDisconnectBound = _classPrivateMethodGet(this, _beforeDisconnect, _beforeDisconnect2).bind(this);
	    this.monitoringEvents = [];
	    this.monitoringDelayTime = 60000;
	    this.monitoringIntervalTime = 10000;
	    this.countMetricsInMetricsInterval = this.monitoringDelayTime / babelHelpers.classPrivateFieldGet(this, _privateProperties).statsTimeout;
	    this.monitoringInterval = null;
	    this.currentMonitoringEventsObject = JSON.parse(JSON.stringify(MONITORING_EVENTS_LIST));
	    this.startTimestampGrabMetrics = null;
	    this.prevInboundRtpStatsSum = {
	      freezeCount: 0,
	      totalFreezesDuration: 0,
	      jitter: 0,
	      framesDecoded: 0,
	      framesDropped: 0,
	      framesReceived: 0
	    };
	  }
	  babelHelpers.createClass(Call, [{
	    key: "checkQosFeatureAndExecutionCallback",
	    value: function checkQosFeatureAndExecutionCallback(callback) {
	      if (typeof callback === 'function' && Util.isNewQOSEnabled()) {
	        callback();
	      }
	    }
	  }, {
	    key: "clearMonitoringEvents",
	    value: function clearMonitoringEvents() {
	      this.monitoringEvents = [];
	    }
	  }, {
	    key: "addMonitoringEvents",
	    value: function addMonitoringEvents(_ref) {
	      var name = _ref.name,
	        _ref$value = _ref.value,
	        value = _ref$value === void 0 ? undefined : _ref$value,
	        _ref$withCounter = _ref.withCounter,
	        withCounter = _ref$withCounter === void 0 ? false : _ref$withCounter;
	      var currentEventIndex = this.currentMonitoringEventsObject.events.findIndex(function (evt) {
	        return evt.name === name;
	      });
	      var lastTimestamp = Date.now();
	      if (withCounter && currentEventIndex !== -1) {
	        this.currentMonitoringEventsObject.events[currentEventIndex].lastTimestamp = lastTimestamp;
	        this.currentMonitoringEventsObject.events[currentEventIndex].value += 1;
	        return;
	      }
	      if (withCounter && currentEventIndex === -1) {
	        this.currentMonitoringEventsObject.events.push({
	          name: name,
	          value: 1,
	          lastTimestamp: lastTimestamp
	        });
	        return;
	      }
	      this.currentMonitoringEventsObject.events.push({
	        name: name,
	        value: value,
	        lastTimestamp: lastTimestamp
	      });
	    }
	  }, {
	    key: "setClearValuesForCurrentMonitoringEventsObject",
	    value: function setClearValuesForCurrentMonitoringEventsObject() {
	      this.currentMonitoringEventsObject = JSON.parse(JSON.stringify(MONITORING_EVENTS_LIST));
	    }
	  }, {
	    key: "getCountRemoteTracks",
	    value: function getCountRemoteTracks() {
	      var countVideoTracks = 0;
	      var countAudioTracks = 0;
	      Object.values(babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants).forEach(function (participant) {
	        if (participant.getTrack(MediaStreamsKinds.Camera) && !participant.isMutedVideo && !participant.isLocalVideoMute) {
	          countVideoTracks += 1;
	        }
	        if (participant.getTrack(MediaStreamsKinds.Microphone) && !participant.isMutedAudio) {
	          countAudioTracks += 1;
	        }
	        if (participant.getTrack(MediaStreamsKinds.Screen)) {
	          countVideoTracks += 1;
	        }
	        if (participant.getTrack(MediaStreamsKinds.ScreenAudio)) {
	          countAudioTracks += 1;
	        }
	      });
	      return {
	        countVideoTracks: countVideoTracks,
	        countAudioTracks: countAudioTracks
	      };
	    }
	  }, {
	    key: "startAggregateMonitoringEvents",
	    value: function startAggregateMonitoringEvents() {
	      var _this = this;
	      this.startTimestampGrabMetrics = Date.now();
	      this.currentMonitoringEventsObject.startTimestamp = this.startTimestampGrabMetrics;
	      this.monitoringInterval = setInterval(function () {
	        var _this$getCountRemoteT = _this.getCountRemoteTracks(),
	          countVideoTracks = _this$getCountRemoteT.countVideoTracks,
	          countAudioTracks = _this$getCountRemoteT.countAudioTracks;
	        _this.currentMonitoringEventsObject.metrics.COUNT_TRACKS = {
	          video: countVideoTracks,
	          audio: countAudioTracks
	        };
	      }, this.monitoringIntervalTime);
	      this.monitoringTimeout = setTimeout(function () {
	        clearTimeout(_this.monitoringTimeout);
	        _this.monitoringTimeout = null;
	        if (babelHelpers.classPrivateFieldGet(_this, _privateProperties).isReconnecting) {
	          return;
	        }
	        _this.sendMonitoringEvents();
	      }, this.monitoringDelayTime);
	    }
	  }, {
	    key: "sendMonitoringEvents",
	    value: function sendMonitoringEvents() {
	      var withRestart = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
	      var eventsToSend = [];
	      var eventsToLog = [];
	      this.currentMonitoringEventsObject.events.forEach(function (evt) {
	        var eventName = '';
	        var eventList = Object.entries(MONITORING_EVENTS_NAME_LIST);
	        for (var i = 0; i < eventList.length; i++) {
	          if (eventList[i][1] === evt.name) {
	            eventName = eventList[i][0];
	            break;
	          }
	        }
	        var eventData = {
	          mediaServerId: 0,
	          // TODO: should be replaced with real value for large rooms; 0 - only for small rooms
	          message: '',
	          value: JSON.stringify(evt.value),
	          eventTime: Math.round(evt.lastTimestamp / 1000)
	        };
	        eventsToSend.push(_objectSpread({
	          eventTypeId: evt.name
	        }, eventData));
	        eventsToLog.push(_objectSpread({
	          eventTypeId: eventName
	        }, eventData));
	      });
	      var objForSend = {
	        audioSubscribed: this.currentMonitoringEventsObject.metrics.COUNT_TRACKS.audio,
	        videoSubscribed: this.currentMonitoringEventsObject.metrics.COUNT_TRACKS.video,
	        packetLoss: this.currentMonitoringEventsObject.metrics.PACKET_LOST_RECEIVE,
	        bitrateIn: this.currentMonitoringEventsObject.metrics.BITRATE_IN,
	        bitrateOut: this.currentMonitoringEventsObject.metrics.BITRATE_OUT,
	        connScore: this.currentMonitoringEventsObject.metrics.CONN_SCORE_CURRENT,
	        framesLoss: this.currentMonitoringEventsObject.metrics.FRAMES_LOSS,
	        freezeCount: this.currentMonitoringEventsObject.metrics.FREEZE_COUNT,
	        totalFreezesDuration: this.currentMonitoringEventsObject.metrics.TOTAL_FREEZE_DURATION,
	        jitter: this.currentMonitoringEventsObject.metrics.JITTER,
	        events: eventsToSend
	      };
	      objForSend.events = eventsToSend;
	      _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	        sendQoS: objForSend
	      });
	      clearInterval(this.monitoringInterval);
	      this.monitoringInterval = null;
	      clearTimeout(this.monitoringTimeout);
	      this.monitoringTimeout = null;
	      this.setClearValuesForCurrentMonitoringEventsObject();
	      if (withRestart) {
	        this.startAggregateMonitoringEvents();
	      }
	    }
	  }, {
	    key: "onPublishFailed",
	    value: function onPublishFailed(kind) {
	      var _this2 = this;
	      this.triggerEvents('PublishFailed', [kind]);
	      var eventName;
	      if (kind === MediaStreamsKinds.Camera) {
	        eventName = MONITORING_EVENTS_NAME_LIST.LOCAL_VIDEO_STREAM_PUBLICATION_FAILED;
	      } else if (kind === MediaStreamsKinds.Microphone) {
	        eventName = MONITORING_EVENTS_NAME_LIST.LOCAL_MICROPHONE_STREAM_PUBLICATION_FAILED;
	      } else if (kind === MediaStreamsKinds.Screen) {
	        eventName = MONITORING_EVENTS_NAME_LIST.LOCAL_SCREEN_STREAM_PUBLICATION_FAILED;
	      }
	      this.checkQosFeatureAndExecutionCallback(function () {
	        _this2.addMonitoringEvents({
	          name: eventName,
	          withCounter: true
	        });
	      });
	    }
	  }, {
	    key: "connect",
	    value: function () {
	      var _connect = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(options) {
	        var _this3 = this;
	        var key, mediaServerInfo;
	        return _regeneratorRuntime().wrap(function _callee$(_context) {
	          while (1) switch (_context.prev = _context.next) {
	            case 0:
	              this.setLog("Connecting to the call (desktop: ".concat(Util.isDesktop(), ")"), LOG_LEVEL.INFO);
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).callState = CALL_STATE.PROGRESSING;
	              for (key in options) {
	                babelHelpers.classPrivateFieldGet(this, _privateProperties)["".concat(key)] = options[key];
	              }
	              if (babelHelpers.classPrivateFieldGet(this, _privateProperties).endpoint) {
	                _context.next = 7;
	                break;
	              }
	              this.setLog("Missing required param 'endpoint' from backend, disconnecting", LOG_LEVEL.ERROR);
	              this.triggerEvents('Failed', [{
	                name: 'AUTHORIZE_ERROR',
	                message: "Missing required param 'endpoint'"
	              }]);
	              return _context.abrupt("return");
	            case 7:
	              if (babelHelpers.classPrivateFieldGet(this, _privateProperties).jwt) {
	                _context.next = 11;
	                break;
	              }
	              this.setLog("Missing required param 'jwt' from backend, disconnecting", LOG_LEVEL.ERROR);
	              this.triggerEvents('Failed', [{
	                name: 'AUTHORIZE_ERROR',
	                message: "Missing required param 'jwt'"
	              }]);
	              return _context.abrupt("return");
	            case 11:
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).endpoint = babelHelpers.classPrivateFieldGet(this, _privateProperties).endpoint.replace(/\/+$/, '');
	              _context.prev = 12;
	              _context.next = 15;
	              return this.getMediaServerInfo();
	            case 15:
	              mediaServerInfo = _context.sent;
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).url = mediaServerInfo.url;
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).token = mediaServerInfo.token;
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).data = mediaServerInfo.data;
	              _context.next = 25;
	              break;
	            case 21:
	              _context.prev = 21;
	              _context.t0 = _context["catch"](12);
	              if (_context.t0.name !== 'AbortError' && !babelHelpers.classPrivateFieldGet(this, _privateProperties).abortController.signal.aborted) {
	                _classPrivateMethodGet(this, _reconnect, _reconnect2).call(this);
	              } else if (babelHelpers.classPrivateFieldGet(this, _privateProperties).abortController.signal.aborted) {
	                this.triggerEvents('Failed', [_context.t0]);
	              }
	              return _context.abrupt("return");
	            case 25:
	              if (!babelHelpers.classPrivateFieldGet(this, _privateProperties).abortController.signal.aborted) {
	                _context.next = 28;
	                break;
	              }
	              _classPrivateMethodGet(this, _beforeDisconnect, _beforeDisconnect2).call(this);
	              return _context.abrupt("return");
	            case 28:
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).abortController.signal.addEventListener('abort', this.beforeDisconnectBound);
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect = new WebSocket("".concat(babelHelpers.classPrivateFieldGet(this, _privateProperties).url, "?access_token=").concat(babelHelpers.classPrivateFieldGet(this, _privateProperties).token, "&auto_subscribe=1&sdk=js&version=1.6.7&protocol=8&roomData=").concat(babelHelpers.classPrivateFieldGet(this, _privateProperties).data));
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect.onmessage = function (e) {
	                return _this3.socketOnMessageHandler(e);
	              };
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect.onopen = function () {
	                return _this3.socketOnOpenHandler();
	              };
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect.onerror = function () {
	                return _this3.socketOnErrorHandler();
	              };
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect.onclose = function (e) {
	                return _this3.socketOnCloseHandler(e);
	              };
	            case 34:
	            case "end":
	              return _context.stop();
	          }
	        }, _callee, this, [[12, 21]]);
	      }));
	      function connect(_x) {
	        return _connect.apply(this, arguments);
	      }
	      return connect;
	    }()
	  }, {
	    key: "getMediaServerInfo",
	    value: function getMediaServerInfo() {
	      var _this4 = this;
	      return new Promise( /*#__PURE__*/function () {
	        var _ref2 = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2(resolve, reject) {
	          var _data$result, _data$result2, _data$result3;
	          var url, response, data, _data, _data$error, _data2, _data2$error, _data3, _data3$error, _data4, _data4$error;
	          return _regeneratorRuntime().wrap(function _callee2$(_context2) {
	            while (1) switch (_context2.prev = _context2.next) {
	              case 0:
	                url = "".concat(babelHelpers.classPrivateFieldGet(_this4, _privateProperties).endpoint, "/join");
	                url += "?token=".concat(babelHelpers.classPrivateFieldGet(_this4, _privateProperties).jwt);
	                url += "&clientVersion=".concat(babelHelpers.classPrivateFieldGet(_this4, _privateProperties).clientVersion);
	                url += "&clientPlatform=".concat(babelHelpers.classPrivateFieldGet(_this4, _privateProperties).clientPlatform);
	                _context2.prev = 4;
	                _context2.next = 7;
	                return fetch(url, {
	                  method: 'GET',
	                  signal: babelHelpers.classPrivateFieldGet(_this4, _privateProperties).abortController.signal
	                });
	              case 7:
	                response = _context2.sent;
	                if (response.ok) {
	                  _context2.next = 10;
	                  break;
	                }
	                throw new Error("Got response code ".concat(response.status));
	              case 10:
	                _context2.next = 16;
	                break;
	              case 12:
	                _context2.prev = 12;
	                _context2.t0 = _context2["catch"](4);
	                if (_context2.t0.name === 'AbortError') {
	                  reject(_context2.t0);
	                } else {
	                  babelHelpers.classPrivateFieldGet(_this4, _privateProperties).lastReconnectionReason = ReconnectionReason.NetworkError;
	                  reject({
	                    name: 'MEDIASERVER_UNREACHABLE',
	                    message: _context2.t0.message
	                  });
	                }
	                return _context2.abrupt("return");
	              case 16:
	                _context2.prev = 16;
	                _context2.next = 19;
	                return response.json();
	              case 19:
	                data = _context2.sent;
	                _context2.next = 27;
	                break;
	              case 22:
	                _context2.prev = 22;
	                _context2.t1 = _context2["catch"](16);
	                babelHelpers.classPrivateFieldGet(_this4, _privateProperties).lastReconnectionReason = ReconnectionReason.JoinResponseError;
	                reject({
	                  name: 'MEDIASERVER_UNEXPECTED_ANSWER',
	                  message: _context2.t1.message
	                });
	                return _context2.abrupt("return");
	              case 27:
	                if ((_data$result = data.result) !== null && _data$result !== void 0 && _data$result.mediaServerUrl && (_data$result2 = data.result) !== null && _data$result2 !== void 0 && _data$result2.tokenToAccessMediaServer && (_data$result3 = data.result) !== null && _data$result3 !== void 0 && _data$result3.roomData) {
	                  resolve({
	                    url: data.result.mediaServerUrl,
	                    token: data.result.tokenToAccessMediaServer,
	                    data: data.result.roomData
	                  });
	                } else {
	                  if (((_data = data) === null || _data === void 0 ? void 0 : (_data$error = _data.error) === null || _data$error === void 0 ? void 0 : _data$error.code) === ErrorPreventingReconnection.InputError || ((_data2 = data) === null || _data2 === void 0 ? void 0 : (_data2$error = _data2.error) === null || _data2$error === void 0 ? void 0 : _data2$error.code) === ErrorPreventingReconnection.AccessDenied || ((_data3 = data) === null || _data3 === void 0 ? void 0 : (_data3$error = _data3.error) === null || _data3$error === void 0 ? void 0 : _data3$error.code) === ErrorPreventingReconnection.RoomNotFound || ((_data4 = data) === null || _data4 === void 0 ? void 0 : (_data4$error = _data4.error) === null || _data4$error === void 0 ? void 0 : _data4$error.code) === ErrorPreventingReconnection.MalfunctioningSignaling) {
	                    babelHelpers.classPrivateFieldGet(_this4, _privateProperties).abortController.abort();
	                    reject(data.error);
	                  } else {
	                    babelHelpers.classPrivateFieldGet(_this4, _privateProperties).lastReconnectionReason = ReconnectionReason.JoinResponseError;
	                    reject({
	                      name: 'MEDIASERVER_MISSING_PARAMS',
	                      message: "Incorrect signaling response"
	                    });
	                  }
	                }
	              case 28:
	              case "end":
	                return _context2.stop();
	            }
	          }, _callee2, null, [[4, 12], [16, 22]]);
	        }));
	        return function (_x2, _x3) {
	          return _ref2.apply(this, arguments);
	        };
	      }());
	    }
	  }, {
	    key: "sendOffer",
	    value: function () {
	      var _sendOffer = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee3() {
	        var offer;
	        return _regeneratorRuntime().wrap(function _callee3$(_context3) {
	          while (1) switch (_context3.prev = _context3.next) {
	            case 0:
	              if (!(babelHelpers.classPrivateFieldGet(this, _privateProperties).offersStack > 0 && !babelHelpers.classPrivateFieldGet(this, _privateProperties).isWaitAnswer)) {
	                _context3.next = 20;
	                break;
	              }
	              this.setLog('Start sending an offer', LOG_LEVEL.INFO);
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).isWaitAnswer = true;
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).offersStack--;
	              _context3.prev = 4;
	              _context3.next = 7;
	              return this.sender.createOffer();
	            case 7:
	              offer = _context3.sent;
	              if (Util.useTcpSdp()) {
	                offer = {
	                  type: offer.type,
	                  sdp: _classPrivateMethodGet(this, _removeUdpFromSdp, _removeUdpFromSdp2).call(this, offer.sdp)
	                };
	              }
	              _context3.next = 11;
	              return this.sender.setLocalDescription(offer);
	            case 11:
	              _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	                offer: offer
	              });
	              this.setLog('Sending an offer succeeded', LOG_LEVEL.INFO);
	              _context3.next = 20;
	              break;
	            case 15:
	              _context3.prev = 15;
	              _context3.t0 = _context3["catch"](4);
	              this.setLog("Sending an offer failed: ".concat(_context3.t0), LOG_LEVEL.ERROR);
	              _classPrivateMethodGet(this, _beforeDisconnect, _beforeDisconnect2).call(this);
	              _classPrivateMethodGet(this, _reconnect, _reconnect2).call(this);
	            case 20:
	            case "end":
	              return _context3.stop();
	          }
	        }, _callee3, this, [[4, 15]]);
	      }));
	      function sendOffer() {
	        return _sendOffer.apply(this, arguments);
	      }
	      return sendOffer;
	    }()
	  }, {
	    key: "startStream",
	    value: function () {
	      var _startStream = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee4() {
	        var videoTrack, audioTrack;
	        return _regeneratorRuntime().wrap(function _callee4$(_context4) {
	          while (1) switch (_context4.prev = _context4.next) {
	            case 0:
	              _context4.next = 2;
	              return this.getLocalVideo();
	            case 2:
	              videoTrack = _context4.sent;
	              if (!videoTrack) {
	                _context4.next = 8;
	                break;
	              }
	              _context4.next = 6;
	              return this.publishTrack(MediaStreamsKinds.Camera, videoTrack);
	            case 6:
	              _context4.next = 10;
	              break;
	            case 8:
	              _classPrivateMethodGet(this, _releaseStream, _releaseStream2).call(this, MediaStreamsKinds.Camera);
	              this.onPublishFailed(MediaStreamsKinds.Camera);
	            case 10:
	              _context4.next = 12;
	              return this.getLocalAudio();
	            case 12:
	              audioTrack = _context4.sent;
	              if (!audioTrack) {
	                _context4.next = 18;
	                break;
	              }
	              _context4.next = 16;
	              return this.publishTrack(MediaStreamsKinds.Microphone, audioTrack);
	            case 16:
	              _context4.next = 20;
	              break;
	            case 18:
	              _classPrivateMethodGet(this, _releaseStream, _releaseStream2).call(this, MediaStreamsKinds.Microphone);
	              this.onPublishFailed(MediaStreamsKinds.Microphone);
	            case 20:
	            case "end":
	              return _context4.stop();
	          }
	        }, _callee4, this);
	      }));
	      function startStream() {
	        return _startStream.apply(this, arguments);
	      }
	      return startStream;
	    }()
	  }, {
	    key: "socketOnMessageHandler",
	    value: function () {
	      var _socketOnMessageHandler = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee5(event) {
	        var _data5,
	          _data6,
	          _data7,
	          _this5 = this,
	          _data8,
	          _data9,
	          _data10,
	          _data11,
	          _data12,
	          _data13,
	          _data14,
	          _data15,
	          _data16,
	          _data17,
	          _data18;
	        var data, connectedEvent, participantsToDelete, userId, participant, _participantId, _participant, pendingSubscriptions, _trackId, _participantId2, cid, track, _trackId2, timeout, _participant2, ontrackData, _babelHelpers$classPr, _Object$values, _participantId3, _trackId3, pendingSubscription, _participant3, _track, _Object$values3, _participant4, _trackId4, _Object$values2, _track2, _track3, awaitedTrack, eventName, _eventName, message, _participant5, participants, participantsToUpdate;
	        return _regeneratorRuntime().wrap(function _callee5$(_context5) {
	          while (1) switch (_context5.prev = _context5.next) {
	            case 0:
	              if (!(typeof event.data !== 'string')) {
	                _context5.next = 2;
	                break;
	              }
	              return _context5.abrupt("return");
	            case 2:
	              _context5.prev = 2;
	              data = JSON.parse(event.data);
	              _context5.next = 10;
	              break;
	            case 6:
	              _context5.prev = 6;
	              _context5.t0 = _context5["catch"](2);
	              this.setLog("Could not parse a socket message: ".concat(event.data), LOG_LEVEL.WARNING);
	              return _context5.abrupt("return");
	            case 10:
	              if (!((_data5 = data) !== null && _data5 !== void 0 && _data5.answer)) {
	                _context5.next = 15;
	                break;
	              }
	              _context5.next = 13;
	              return _classPrivateMethodGet(this, _answerHandler, _answerHandler2).call(this, data);
	            case 13:
	              _context5.next = 174;
	              break;
	            case 15:
	              if (!((_data6 = data) !== null && _data6 !== void 0 && _data6.offer)) {
	                _context5.next = 20;
	                break;
	              }
	              _context5.next = 18;
	              return _classPrivateMethodGet(this, _offerHandler, _offerHandler2).call(this, data);
	            case 18:
	              _context5.next = 174;
	              break;
	            case 20:
	              if (!((_data7 = data) !== null && _data7 !== void 0 && _data7.joinResponse)) {
	                _context5.next = 41;
	                break;
	              }
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).abortController.signal.removeEventListener('abort', this.beforeDisconnectBound);
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).iceServers = data.joinResponse.iceServers;
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).localParticipantSid = data.joinResponse.localParticipant.sid;
	              _classPrivateMethodGet(this, _createPeerConnection, _createPeerConnection2).call(this);
	              connectedEvent = babelHelpers.classPrivateFieldGet(this, _privateProperties).isReconnecting && this.wasConnected ? 'Reconnected' : 'Connected';
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).callState = CALL_STATE.CONNECTED;
	              this.wasConnected = true;
	              this.setLog("".concat(connectedEvent, " to the call ").concat(babelHelpers.classPrivateFieldGet(this, _privateProperties).roomId, " on the mediaserver after ").concat(babelHelpers.classPrivateFieldGet(this, _privateProperties).reconnectionAttempt, " attempts"), LOG_LEVEL.INFO);
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).isReconnecting = false;
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).reconnectionAttempt = 0;
	              this.triggerEvents(connectedEvent);
	              this.checkQosFeatureAndExecutionCallback(function () {
	                if (connectedEvent === 'Reconnected' && _this5.monitoringEvents.length) {
	                  _this5.sendMonitoringEvents();
	                }
	              });
	              participantsToDelete = _objectSpread({}, babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants);
	              Object.values(data.joinResponse.otherParticipants).forEach(function (p) {
	                if (participantsToDelete[p.userId]) {
	                  delete participantsToDelete[p.userId];
	                }
	                _this5.setLog("Adding an early connected participant with id ".concat(p.userId, " (sid: ").concat(p.sid, ")"), LOG_LEVEL.INFO);
	                _classPrivateMethodGet(_this5, _setRemoteParticipant, _setRemoteParticipant2).call(_this5, p);
	              });
	              for (userId in participantsToDelete) {
	                participant = babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[userId];
	                this.setLog("Deleting a missing participant with id ".concat(participant.userId, " (sid: ").concat(participant.sid, ")"), LOG_LEVEL.INFO);
	                this.triggerEvents('ParticipantLeaved', [participant]);
	                delete babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteTracks[userId];
	                delete babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[userId];
	              }
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).pingIntervalDuration = data.joinResponse.pingInterval * 1000;
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).pingTimeoutDuration = babelHelpers.classPrivateFieldGet(this, _privateProperties).pingIntervalDuration * 2;
	              _classPrivateMethodGet(this, _startPingInterval, _startPingInterval2).call(this);
	              _context5.next = 174;
	              break;
	            case 41:
	              if (!((_data8 = data) !== null && _data8 !== void 0 && _data8.participantJoined)) {
	                _context5.next = 46;
	                break;
	              }
	              this.setLog("Adding a new participant with id ".concat(data.participantJoined.participant.userId, " (sid: ").concat(data.participantJoined.participant.sid, ")"), LOG_LEVEL.INFO);
	              _classPrivateMethodGet(this, _setRemoteParticipant, _setRemoteParticipant2).call(this, data.participantJoined.participant);
	              _context5.next = 174;
	              break;
	            case 46:
	              if (!((_data9 = data) !== null && _data9 !== void 0 && _data9.participantLeft)) {
	                _context5.next = 54;
	                break;
	              }
	              _participantId = data.participantLeft.userId;
	              _participant = babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[_participantId];
	              pendingSubscriptions = babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions[_participantId];
	              if (pendingSubscriptions) {
	                for (_trackId in pendingSubscriptions) {
	                  clearTimeout(pendingSubscriptions[_trackId].timeout);
	                  this.setLog("A participant with id ".concat(_participantId, " (sid: ").concat(data.participantLeft.sid, ") left during subscription attempt, cancel it"), LOG_LEVEL.WARNING);
	                }
	                delete babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions[_participantId];
	              }
	              if (_participant) {
	                this.setLog("Deleting a participant with id ".concat(_participant.userId, " (sid: ").concat(_participant.sid, ")"), LOG_LEVEL.INFO);
	                this.triggerEvents('ParticipantLeaved', [_participant]);
	                delete babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteTracks[_participantId];
	                delete babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[_participantId];
	              } else {
	                this.setLog("Got participantLeft signal for a non-existent participant with id ".concat(_participantId, " (sid: ").concat(data.participantLeft.sid, ")"), LOG_LEVEL.WARNING);
	              }
	              _context5.next = 174;
	              break;
	            case 54:
	              if (!((_data10 = data) !== null && _data10 !== void 0 && _data10.trackCreated)) {
	                _context5.next = 94;
	                break;
	              }
	              _participantId2 = data.trackCreated.userId;
	              cid = data.trackCreated.cid;
	              track = data.trackCreated.track;
	              _trackId2 = track.sid;
	              track.userId = _participantId2;
	              if (!(_participantId2 == babelHelpers.classPrivateFieldGet(this, _privateProperties).userId)) {
	                _context5.next = 73;
	                break;
	              }
	              timeout = babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingPublications[cid];
	              if (!timeout) {
	                _context5.next = 70;
	                break;
	              }
	              clearTimeout(babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingPublications[cid]);
	              delete babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingPublications[cid];
	              this.setLog("Publishing a local track with kind ".concat(track.source, " (sid: ").concat(_trackId2, ") succeeded"), LOG_LEVEL.INFO);
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[track.source] = track;
	              this.triggerEvents('PublishSucceed', [track.source]);
	              if (track.source === MediaStreamsKinds.Microphone && babelHelpers.classPrivateFieldGet(this, _privateProperties).needToDisableAudioAfterPublish) {
	                babelHelpers.classPrivateFieldGet(this, _privateProperties).needToDisableAudioAfterPublish = false;
	                this.disableAudio();
	              } else if (track.source === MediaStreamsKinds.Camera && babelHelpers.classPrivateFieldGet(this, _privateProperties).videoQueue) {
	                _classPrivateMethodGet(this, _processVideoQueue, _processVideoQueue2).call(this);
	              }
	              return _context5.abrupt("return");
	            case 70:
	              this.setLog("Got trackCreated signal for a non-existent local track with kind ".concat(track.source, " (sid: ").concat(_trackId2, ")"), LOG_LEVEL.WARNING);
	              _context5.next = 92;
	              break;
	            case 73:
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).tracksDataFromSocket[_trackId2] = track;
	              _participant2 = babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[_participantId2];
	              if (!_participant2) {
	                _context5.next = 91;
	                break;
	              }
	              this.setLog("Got a track info with kind ".concat(track.source, " (sid: ").concat(data.trackCreated.track.sid, ") for a participant with id ").concat(_participantId2, " (sid: ").concat(_participant2.sid, "), waiting for it"), LOG_LEVEL.INFO);
	              _context5.t1 = track.source;
	              _context5.next = _context5.t1 === MediaStreamsKinds.Camera ? 80 : _context5.t1 === MediaStreamsKinds.Microphone ? 82 : _context5.t1 === MediaStreamsKinds.Screen ? 84 : 86;
	              break;
	            case 80:
	              _participant2.videoEnabled = true;
	              return _context5.abrupt("break", 86);
	            case 82:
	              _participant2.audioEnabled = true;
	              return _context5.abrupt("break", 86);
	            case 84:
	              _participant2.screenSharingEnabled = true;
	              return _context5.abrupt("break", 86);
	            case 86:
	              ontrackData = babelHelpers.classPrivateFieldGet(this, _privateProperties).ontrackData[_trackId2];
	              delete babelHelpers.classPrivateFieldGet(this, _privateProperties).ontrackData[_trackId2];
	              if (ontrackData) {
	                _classPrivateMethodGet(this, _createRemoteTrack, _createRemoteTrack2).call(this, _trackId2, ontrackData);
	              } else {
	                _classPrivateMethodGet(this, _addPendingSubscription, _addPendingSubscription2).call(this, _participant2, track);
	              }
	              _context5.next = 92;
	              break;
	            case 91:
	              this.setLog("Got a track info with kind ".concat(track.source, " (sid: ").concat(data.trackCreated.track.sid, ") for a non-existent participant with id ").concat(_participantId2), LOG_LEVEL.WARNING);
	            case 92:
	              _context5.next = 174;
	              break;
	            case 94:
	              if (!((_data11 = data) !== null && _data11 !== void 0 && _data11.trackDeleted)) {
	                _context5.next = 117;
	                break;
	              }
	              _context5.prev = 95;
	              _participantId3 = data.trackDeleted.publisher;
	              _trackId3 = data.trackDeleted.shortId;
	              pendingSubscription = (_babelHelpers$classPr = babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions[_participantId3]) === null || _babelHelpers$classPr === void 0 ? void 0 : _babelHelpers$classPr[_trackId3];
	              if (pendingSubscription) {
	                clearTimeout(pendingSubscription.timeout);
	                delete babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions[_participantId3][_trackId3];
	                this.setLog("Track with id ".concat(_trackId3, " was deleted during subscription attempt, cancel it"), LOG_LEVEL.WARNING);
	              }
	              if (!(_participantId3 == babelHelpers.classPrivateFieldGet(this, _privateProperties).userId)) {
	                _context5.next = 102;
	                break;
	              }
	              return _context5.abrupt("return");
	            case 102:
	              this.setLog("Start deleting a track with id ".concat(_trackId3, " from a participant with id ").concat(_participantId3, " "), LOG_LEVEL.INFO);
	              _participant3 = babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[_participantId3];
	              if (_participant3) {
	                _context5.next = 107;
	                break;
	              }
	              this.setLog("Deleting a track with id ".concat(_trackId3, " failed: can't find a participant with id ").concat(_participantId3), LOG_LEVEL.WARNING);
	              return _context5.abrupt("return");
	            case 107:
	              _track = (_Object$values = Object.values(_participant3.tracks)) === null || _Object$values === void 0 ? void 0 : _Object$values.find(function (track) {
	                return (track === null || track === void 0 ? void 0 : track.id) === _trackId3;
	              });
	              delete babelHelpers.classPrivateFieldGet(this, _privateProperties).tracksDataFromSocket[_trackId3];
	              if (_track) {
	                if (_track.source === MediaStreamsKinds.Microphone) {
	                  _participant3.audioEnabled = false;
	                } else if (_track.source === MediaStreamsKinds.Camera) {
	                  _participant3.videoEnabled = false;
	                } else if (_track.source === MediaStreamsKinds.Screen) {
	                  _participant3.screenSharingEnabled = false;
	                }
	                _participant3.removeTrack(_track.source);
	                this.setLog("Deleting a track with id ".concat(_trackId3, " from a participant with id ").concat(_participantId3, " (sid: ").concat(_participant3.sid, ") succeeded"), LOG_LEVEL.INFO);
	                this.triggerEvents('RemoteMediaRemoved', [_participant3, _track]);
	              } else {
	                this.setLog("Deleting a track with id ".concat(_trackId3, " from a participant with id ").concat(_participantId3, " (sid: ").concat(_participant3.sid, ") failed: can't find a track"), LOG_LEVEL.WARNING);
	              }
	              _context5.next = 115;
	              break;
	            case 112:
	              _context5.prev = 112;
	              _context5.t2 = _context5["catch"](95);
	              this.setLog("Deleting a track with id ".concat(trackId, " from a participant with id ").concat(participantId, " failed: ").concat(_context5.t2), LOG_LEVEL.ERROR);
	            case 115:
	              _context5.next = 174;
	              break;
	            case 117:
	              if (!((_data12 = data) !== null && _data12 !== void 0 && _data12.trackMuted)) {
	                _context5.next = 141;
	                break;
	              }
	              _participant4 = babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[data.trackMuted.track.publisher];
	              _trackId4 = data.trackMuted.track.shortId;
	              if (!(data.trackMuted.track.publisher == babelHelpers.classPrivateFieldGet(this, _privateProperties).userId)) {
	                _context5.next = 124;
	                break;
	              }
	              _track2 = (_Object$values2 = Object.values(babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks)) === null || _Object$values2 === void 0 ? void 0 : _Object$values2.find(function (track) {
	                return (track === null || track === void 0 ? void 0 : track.sid) === _trackId4;
	              });
	              if (_track2) {
	                if (_track2.source === MediaStreamsKinds.Camera) {
	                  if (!data.trackMuted.muted && _track2.muted && !babelHelpers.classPrivateFieldGet(this, _privateProperties).mediaMutedBySystem) {
	                    this.triggerEvents('PublishSucceed', [_track2.source]);
	                  } else if (!babelHelpers.classPrivateFieldGet(this, _privateProperties).mediaMutedBySystem) {
	                    this.triggerEvents('PublishPaused', [_track2.source]);
	                  }
	                  if (babelHelpers.classPrivateFieldGet(this, _privateProperties).videoQueue) {
	                    _classPrivateMethodGet(this, _processVideoQueue, _processVideoQueue2).call(this);
	                  }
	                } else if (_track2.source === MediaStreamsKinds.Microphone) {
	                  this.triggerEvents('PublishPaused', [_track2.source, data.trackMuted.muted]);
	                }
	              }
	              return _context5.abrupt("return");
	            case 124:
	              if (_participant4) {
	                _context5.next = 127;
	                break;
	              }
	              if (data.trackMuted.track.publisher != babelHelpers.classPrivateFieldGet(this, _privateProperties).userId) {
	                this.setLog("Got mute signal (".concat(data.trackMuted.muted, ") for a non-existent participant with id ").concat(data.trackMuted.track.publisher), LOG_LEVEL.WARNING);
	              }
	              return _context5.abrupt("return");
	            case 127:
	              _track3 = (_Object$values3 = Object.values(_participant4.tracks)) === null || _Object$values3 === void 0 ? void 0 : _Object$values3.find(function (track) {
	                return (track === null || track === void 0 ? void 0 : track.id) === _trackId4;
	              });
	              awaitedTrack = babelHelpers.classPrivateFieldGet(this, _privateProperties).tracksDataFromSocket[_trackId4];
	              if (!(awaitedTrack && !_track3)) {
	                _context5.next = 135;
	                break;
	              }
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).tracksDataFromSocket[_trackId4].muted = data.trackMuted.muted;
	              this.setLog("Got mute signal (".concat(data.trackMuted.muted, ") for a non-received track with id ").concat(_trackId4), LOG_LEVEL.WARNING);
	              return _context5.abrupt("return");
	            case 135:
	              if (_track3) {
	                _context5.next = 138;
	                break;
	              }
	              this.setLog("Got mute signal (".concat(data.trackMuted.muted, ") for a non-existent track with id ").concat(_trackId4), LOG_LEVEL.WARNING);
	              return _context5.abrupt("return");
	            case 138:
	              if (_track3.source === MediaStreamsKinds.Microphone) {
	                _participant4.isMutedAudio = data.trackMuted.muted;
	                eventName = data.trackMuted.muted ? 'RemoteMediaMuted' : 'RemoteMediaUnmuted';
	                this.setLog("Got mute signal (".concat(data.trackMuted.muted, ") for audio from a participant with id ").concat(_participant4.userId, " (sid: ").concat(_participant4.sid, ")"), LOG_LEVEL.INFO);
	                this.triggerEvents(eventName, [_participant4, _track3]);
	              } else if (_track3.source === MediaStreamsKinds.Camera) {
	                _participant4.isMutedVideo = data.trackMuted.muted;
	                _eventName = data.trackMuted.muted ? 'RemoteMediaRemoved' : 'RemoteMediaAdded';
	                this.setLog("Got mute signal (".concat(data.trackMuted.muted, ") for video from a participant with id ").concat(_participant4.userId, " (sid: ").concat(_participant4.sid, ")"), LOG_LEVEL.INFO);
	                this.triggerEvents(_eventName, [_participant4, _track3]);
	              }
	              _context5.next = 174;
	              break;
	            case 141:
	              if (!((_data13 = data) !== null && _data13 !== void 0 && _data13.trickle)) {
	                _context5.next = 145;
	                break;
	              }
	              _classPrivateMethodGet(this, _addIceCandidate, _addIceCandidate2).call(this, data.trickle);
	              _context5.next = 174;
	              break;
	            case 145:
	              if (!((_data14 = data) !== null && _data14 !== void 0 && _data14.newMessage)) {
	                _context5.next = 150;
	                break;
	              }
	              message = new Message(data.newMessage);
	              this.triggerEvents('MessageReceived', [message]);
	              _context5.next = 174;
	              break;
	            case 150:
	              if (!((_data15 = data) !== null && _data15 !== void 0 && _data15.handRaised)) {
	                _context5.next = 155;
	                break;
	              }
	              _participant5 = babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[data.handRaised.participantId];
	              if (_participant5) {
	                _participant5.isHandRaised = data.handRaised.isHandRaised;
	                this.triggerEvents('HandRaised', [_participant5]);
	              }
	              _context5.next = 174;
	              break;
	            case 155:
	              if (!((_data16 = data) !== null && _data16 !== void 0 && _data16.speakersChanged)) {
	                _context5.next = 159;
	                break;
	              }
	              _classPrivateMethodGet(this, _speakerChangedHandler, _speakerChangedHandler2).call(this, data);
	              _context5.next = 174;
	              break;
	            case 159:
	              if (!((_data17 = data) !== null && _data17 !== void 0 && _data17.subscribedQualityUpdate)) {
	                _context5.next = 163;
	                break;
	              }
	              console.log(data);
	              _context5.next = 174;
	              break;
	            case 163:
	              if (!((_data18 = data) !== null && _data18 !== void 0 && _data18.connectionQuality)) {
	                _context5.next = 173;
	                break;
	              }
	              console.log(data);
	              if (data.connectionQuality.updates) {
	                _context5.next = 167;
	                break;
	              }
	              return _context5.abrupt("return");
	            case 167:
	              participants = {};
	              participantsToUpdate = _objectSpread({}, babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants);
	              data.connectionQuality.updates.forEach(function (participant) {
	                Object.values(participantsToUpdate).forEach(function (remoteParticipant) {
	                  var hasGoodQuality = participant.score > babelHelpers.classPrivateFieldGet(_this5, _privateProperties).minimalConnectionQuality;
	                  if (participant.participantSid === remoteParticipant.sid && (!remoteParticipant.isMutedVideo || !remoteParticipant.connectionQuality) && !remoteParticipant.screenSharingEnabled) {
	                    participants[remoteParticipant.userId] = participant.score;
	                    _this5.setLog("Quality of connection with a participant with id ".concat(remoteParticipant.userId, " (sid: ").concat(remoteParticipant.sid, ") changed to ").concat(participant.score), hasGoodQuality ? LOG_LEVEL.INFO : LOG_LEVEL.WARNING);
	                    babelHelpers.classPrivateFieldGet(_this5, _privateProperties).remoteParticipants[remoteParticipant.userId].connectionQuality = participant.score;
	                  }
	                  var isLocalVideoMuted = babelHelpers.classPrivateFieldGet(_this5, _privateProperties).localTracks[MediaStreamsKinds.Camera] && babelHelpers.classPrivateFieldGet(_this5, _privateProperties).localTracks[MediaStreamsKinds.Camera].muted;
	                  _this5.checkQosFeatureAndExecutionCallback(function () {
	                    if (participant.participantSid === babelHelpers.classPrivateFieldGet(_this5, _privateProperties).localParticipantSid) {
	                      _this5.currentMonitoringEventsObject.metrics.CONN_SCORE_CURRENT.push(participant.score);
	                    }
	                  });
	                  if (participant.participantSid === babelHelpers.classPrivateFieldGet(_this5, _privateProperties).localParticipantSid && (!isLocalVideoMuted || !babelHelpers.classPrivateFieldGet(_this5, _privateProperties).localConnectionQuality) && !babelHelpers.classPrivateFieldGet(_this5, _privateProperties).localTracks[MediaStreamsKinds.Screen]) {
	                    participants[babelHelpers.classPrivateFieldGet(_this5, _privateProperties).userId] = participant.score;
	                    babelHelpers.classPrivateFieldGet(_this5, _privateProperties).localConnectionQuality = participant.score;
	                    _this5.setLog("Quality of connection with a mediaserver changed to ".concat(participant.score), hasGoodQuality ? LOG_LEVEL.INFO : LOG_LEVEL.WARNING);
	                    // this.#toggleRemoteParticipantVideo(Object.keys(participantsToUpdate), hasGoodQuality);
	                  }
	                });
	              });

	              this.triggerEvents('ConnectionQualityChanged', [participants]);
	              _context5.next = 174;
	              break;
	            case 173:
	              if (data.pongResp) {
	                babelHelpers.classPrivateFieldGet(this, _privateProperties).rtt = Date.now() - data.pongResp.lastPingTimestamp;
	                _classPrivateMethodGet(this, _resetPingTimeout, _resetPingTimeout2).call(this);
	              } else if (data.leave) {
	                this.setLog("Got leave signal with ".concat(data.leave.reason, " reason"), LOG_LEVEL.WARNING);
	                _classPrivateMethodGet(this, _beforeDisconnect, _beforeDisconnect2).call(this);
	                if ((data.leave.canReconnect || data.leave.reason === 'CHANGING_MEDIA_SERVER') && data.leave.reason !== "SIGNALING_DUPLICATE_PARTICIPANT") {
	                  babelHelpers.classPrivateFieldGet(this, _privateProperties).lastReconnectionReason = ReconnectionReason.LeaveCommand;
	                  _classPrivateMethodGet(this, _reconnect, _reconnect2).call(this);
	                } else {
	                  babelHelpers.classPrivateFieldGet(this, _privateProperties).canReconnect = false;
	                  this.triggerEvents('Failed', [{
	                    name: data.leave.reason,
	                    leaveInformation: {
	                      code: data.leave.code,
	                      reason: data.leave.reason
	                    }
	                  }]);
	                }
	              }
	            case 174:
	            case "end":
	              return _context5.stop();
	          }
	        }, _callee5, this, [[2, 6], [95, 112]]);
	      }));
	      function socketOnMessageHandler(_x4) {
	        return _socketOnMessageHandler.apply(this, arguments);
	      }
	      return socketOnMessageHandler;
	    }()
	  }, {
	    key: "socketOnOpenHandler",
	    value: function socketOnOpenHandler() {
	      window.addEventListener('unload', this.sendLeaveBound);
	    }
	  }, {
	    key: "socketOnCloseHandler",
	    value: function socketOnCloseHandler(e) {
	      _classPrivateMethodGet(this, _beforeDisconnect, _beforeDisconnect2).call(this);
	      if (e !== null && e !== void 0 && e.code && (e === null || e === void 0 ? void 0 : e.code) !== 1005) {
	        this.setLog("Socket closed with a code ".concat(e.code, ", reconnecting"), LOG_LEVEL.ERROR);
	        babelHelpers.classPrivateFieldGet(this, _privateProperties).lastReconnectionReason = ReconnectionReason.WsTransportClosed;
	        _classPrivateMethodGet(this, _reconnect, _reconnect2).call(this);
	      } else {
	        this.setLog("Socket closed with a code ".concat(e.code), LOG_LEVEL.ERROR);
	      }
	    }
	  }, {
	    key: "socketOnErrorHandler",
	    value: function socketOnErrorHandler() {
	      this.setLog("Got a socket error", LOG_LEVEL.ERROR);
	    }
	  }, {
	    key: "onIceCandidate",
	    value: function () {
	      var _onIceCandidate = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee6(target, event) {
	        var _event$candidate, _event$candidate2, _event$candidate3;
	        var trickle;
	        return _regeneratorRuntime().wrap(function _callee6$(_context6) {
	          while (1) switch (_context6.prev = _context6.next) {
	            case 0:
	              if (event.candidate) {
	                _context6.next = 2;
	                break;
	              }
	              return _context6.abrupt("return");
	            case 2:
	              if (!(Util.useTcpSdp() && event.candidate.protocol !== 'tcp')) {
	                _context6.next = 4;
	                break;
	              }
	              return _context6.abrupt("return");
	            case 4:
	              trickle = {
	                candidateInit: JSON.stringify({
	                  candidate: event.candidate.candidate,
	                  sdpMid: (_event$candidate = event.candidate) === null || _event$candidate === void 0 ? void 0 : _event$candidate.sdpMid,
	                  sdpMLineIndex: (_event$candidate2 = event.candidate) === null || _event$candidate2 === void 0 ? void 0 : _event$candidate2.sdpMLineIndex,
	                  usernameFragment: (_event$candidate3 = event.candidate) === null || _event$candidate3 === void 0 ? void 0 : _event$candidate3.usernameFragment
	                })
	              };
	              if (target) {
	                trickle.target = target;
	              }
	              _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	                trickle: trickle
	              });
	            case 7:
	            case "end":
	              return _context6.stop();
	          }
	        }, _callee6, this);
	      }));
	      function onIceCandidate(_x5, _x6) {
	        return _onIceCandidate.apply(this, arguments);
	      }
	      return onIceCandidate;
	    }()
	  }, {
	    key: "onConnectionStateChange",
	    value: function onConnectionStateChange(subscriber) {
	      var _this6 = this;
	      var state = subscriber ? this.recipient.connectionState : this.sender.connectionState;
	      if (state === 'failed' && !babelHelpers.classPrivateFieldGet(this, _privateProperties).isReconnecting) {
	        this.setLog("State of ".concat(subscriber ? 'recipient' : 'sender', " peer connection changed to ").concat(state, ", reconnecting"), LOG_LEVEL.WARNING);
	        if (babelHelpers.classPrivateFieldGet(this, _privateProperties).peerConnectionFailed) {
	          return;
	        }
	        babelHelpers.classPrivateFieldGet(this, _privateProperties).peerConnectionFailed = true;
	        this.checkQosFeatureAndExecutionCallback(function () {
	          _this6.addMonitoringEvents({
	            name: MONITORING_EVENTS_NAME_LIST.PEER_CONNECTION_REFUSED,
	            withCounter: true
	          });
	        });
	        _classPrivateMethodGet(this, _beforeDisconnect, _beforeDisconnect2).call(this);
	        if (babelHelpers.classPrivateFieldGet(this, _privateProperties).canReconnect) {
	          babelHelpers.classPrivateFieldGet(this, _privateProperties).lastReconnectionReason = ReconnectionReason.PeerConnectionFailed;
	          _classPrivateMethodGet(this, _reconnect, _reconnect2).call(this);
	        }
	      }
	    }
	  }, {
	    key: "on",
	    value: function on(eventType, handler) {
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).events.set(eventType, handler);
	      return this;
	    }
	  }, {
	    key: "off",
	    value: function off(eventType) {
	      if (babelHelpers.classPrivateFieldGet(this, _privateProperties).events.has(eventType)) {
	        return babelHelpers.classPrivateFieldGet(this, _privateProperties).events["delete"](eventType);
	      }
	      return this;
	    }
	  }, {
	    key: "triggerEvents",
	    value: function triggerEvents(eventType, args) {
	      if (babelHelpers.classPrivateFieldGet(this, _privateProperties).events.has(eventType)) {
	        var event = babelHelpers.classPrivateFieldGet(this, _privateProperties).events.get(eventType);
	        if (args) {
	          event.apply(void 0, babelHelpers.toConsumableArray(args));
	        } else {
	          event();
	        }
	      }
	    }
	  }, {
	    key: "isRecordable",
	    value: function isRecordable() {
	      console.log('isRecordable');
	    }
	  }, {
	    key: "setBitrate",
	    value: function setBitrate(bitrate, MediaStreamKind) {
	      var _this7 = this;
	      this.setLog('Start setting bitrate', LOG_LEVEL.INFO);
	      var track;
	      var isSimulcast;
	      switch (MediaStreamKind) {
	        case MediaStreamsKinds.Camera:
	          track = babelHelpers.classPrivateFieldGet(this, _privateProperties).cameraStream.getVideoTracks[0];
	          isSimulcast = babelHelpers.classPrivateFieldGet(this, _privateProperties).videoSimulcast;
	          break;
	        case MediaStreamsKinds.Microphone:
	          track = babelHelpers.classPrivateFieldGet(this, _privateProperties).microphoneStream.getAudioTracks[0];
	          break;
	        case MediaStreamsKinds.Screen:
	          track = babelHelpers.classPrivateFieldGet(this, _privateProperties).screenStream.getVideoTracks[0];
	          break;
	      }
	      var senders = this.sender.getSenders();
	      senders.forEach(function (sender) {
	        var params = sender.getParameters();
	        if (!params || !params.encodings || params.encodings.length === 0) {
	          _this7.setLog('Setting bitrate failed: has no encodings in the sender parameters', LOG_LEVEL.WARNING);
	        } else {
	          params.encodings.forEach(function (encoding) {
	            if (isSimulcast) {
	              encoding.maxBitrate = bitrate < babelHelpers.classPrivateFieldGet(_this7, _privateProperties).defaultSimulcastBitrate[encoding.rid] ? bitrate : babelHelpers.classPrivateFieldGet(_this7, _privateProperties).defaultSimulcastBitrate[encoding.rid];
	            } else {
	              encoding.maxBitrate = bitrate;
	            }
	          });
	          sender.setParameters(params);
	          _this7.setLog('Setting bitrate succeeded', LOG_LEVEL.INFO);
	        }
	      });
	    }
	  }, {
	    key: "setCodec",
	    value: function setCodec(transceiver) {
	      var _this8 = this;
	      if (!('getCapabilities' in RTCRtpReceiver)) {
	        return;
	      }
	      var cap = RTCRtpReceiver.getCapabilities('video');
	      if (!cap) return;
	      var matched = [];
	      var partialMatched = [];
	      var unmatched = [];
	      cap.codecs.forEach(function (c) {
	        var codec = c.mimeType.toLowerCase();
	        if (codec === 'audio/opus') {
	          matched.push(c);
	          return;
	        }
	        var matchesVideoCodec = codec === "video/".concat(babelHelpers.classPrivateFieldGet(_this8, _privateProperties).codec);
	        if (!matchesVideoCodec) {
	          unmatched.push(c);
	          return;
	        }
	        // for h264 codecs that have sdpFmtpLine available, use only if the
	        // profile-level-id is 42e01f for cross-browser compatibility
	        if (babelHelpers.classPrivateFieldGet(_this8, _privateProperties).codec === 'h264') {
	          if (c.sdpFmtpLine && c.sdpFmtpLine.includes('profile-level-id=42e01f')) {
	            matched.push(c);
	          } else {
	            partialMatched.push(c);
	          }
	          return;
	        }
	        matched.push(c);
	      });
	      if ('setCodecPreferences' in transceiver) {
	        // console.log('setCodecPreferences', this.#privateProperties.codec, matched, partialMatched, unmatched);
	        transceiver.setCodecPreferences(matched.concat(partialMatched, unmatched));
	      }
	    }
	  }, {
	    key: "publishTrack",
	    value: function () {
	      var _publishTrack = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee7(MediaStreamKind, MediaStreamTrack) {
	        var StreamQualityOptions,
	          keys,
	          source,
	          width,
	          height,
	          sender,
	          encodings,
	          transceiver,
	          _sender,
	          _width,
	          _height,
	          _sender2,
	          _width2,
	          _height2,
	          _args7 = arguments;
	        return _regeneratorRuntime().wrap(function _callee7$(_context7) {
	          while (1) switch (_context7.prev = _context7.next) {
	            case 0:
	              StreamQualityOptions = _args7.length > 2 && _args7[2] !== undefined ? _args7[2] : {};
	              if (this.sender) {
	                _context7.next = 4;
	                break;
	              }
	              this.setLog("Publishing a track before a peer connection was created, ignoring", LOG_LEVEL.WARNING);
	              return _context7.abrupt("return");
	            case 4:
	              this.setLog("Start publishing a track with kind ".concat(MediaStreamKind), LOG_LEVEL.INFO);
	              _context7.prev = 5;
	              for (keys in StreamQualityOptions) {
	                babelHelpers.classPrivateFieldGet(this, _privateProperties)["".concat(keys)] = StreamQualityOptions[keys];
	              }
	              source = MediaStreamKind;
	              MediaStreamTrack.source = source;
	              if (!(source === MediaStreamsKinds.Camera)) {
	                _context7.next = 47;
	                break;
	              }
	              if (!babelHelpers.classPrivateFieldGet(this, _privateProperties).videoSimulcast) {
	                _context7.next = 30;
	                break;
	              }
	              width = MediaStreamTrack.getSettings().width;
	              height = MediaStreamTrack.getSettings().height;
	              sender = _classPrivateMethodGet(this, _getSender, _getSender2).call(this, MediaStreamsKinds.Camera);
	              if (!sender) {
	                _context7.next = 23;
	                break;
	              }
	              _context7.next = 17;
	              return sender.replaceTrack(MediaStreamTrack);
	            case 17:
	              _classPrivateMethodGet(this, _updateVideoEncodings, _updateVideoEncodings2).call(this, sender, MediaStreamTrack);
	              this.setLog("Publishing a track with kind ".concat(MediaStreamKind, " via replace track succeeded"), LOG_LEVEL.INFO);
	              this.triggerEvents('PublishSucceed', [MediaStreamsKinds.Camera]);
	              return _context7.abrupt("return");
	            case 23:
	              encodings = _classPrivateMethodGet(this, _getEncodingsFromVideoWidth, _getEncodingsFromVideoWidth2).call(this, width);
	              transceiver = this.sender.addTransceiver(MediaStreamTrack, {
	                direction: 'sendonly',
	                streams: [babelHelpers.classPrivateFieldGet(this, _privateProperties).cameraStream],
	                sendEncodings: MediaStreamTrack.sendEncodings || encodings
	              });
	              this.setCodec(transceiver);
	              _classPrivateMethodGet(this, _addPendingPublication, _addPendingPublication2).call(this, MediaStreamTrack.id, source);
	              _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	                "addTrack": {
	                  "cid": MediaStreamTrack.id,
	                  "type": "VIDEO",
	                  "width": width,
	                  "height": height,
	                  "source": source,
	                  "layers": _classPrivateMethodGet(this, _getLayersFromEncodings, _getLayersFromEncodings2).call(this, width, height, encodings)
	                }
	              });
	            case 28:
	              _context7.next = 45;
	              break;
	            case 30:
	              _sender = _classPrivateMethodGet(this, _getSender, _getSender2).call(this, MediaStreamsKinds.Camera);
	              if (!_sender) {
	                _context7.next = 39;
	                break;
	              }
	              _context7.next = 34;
	              return _sender.replaceTrack(MediaStreamTrack);
	            case 34:
	              this.setLog("Publishing a track with kind ".concat(MediaStreamKind, " via replace track succeeded"), LOG_LEVEL.INFO);
	              this.triggerEvents('PublishSucceed', [MediaStreamsKinds.Camera]);
	              return _context7.abrupt("return");
	            case 39:
	              this.sender.addTransceiver(MediaStreamTrack, {
	                direction: 'sendonly'
	              });
	              this.setBitrate(babelHelpers.classPrivateFieldGet(this, _privateProperties).videoBitrate, MediaStreamsKinds.Camera);
	              _width = MediaStreamTrack.getSettings().width;
	              _height = MediaStreamTrack.getSettings().height;
	              _classPrivateMethodGet(this, _addPendingPublication, _addPendingPublication2).call(this, MediaStreamTrack.id, source);
	              _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	                "addTrack": {
	                  "cid": MediaStreamTrack.id,
	                  "type": "VIDEO",
	                  "width": _width,
	                  "height": _height,
	                  "source": source
	                }
	              });
	            case 45:
	              _context7.next = 63;
	              break;
	            case 47:
	              if (!(source === MediaStreamsKinds.Microphone)) {
	                _context7.next = 62;
	                break;
	              }
	              _sender2 = _classPrivateMethodGet(this, _getSender, _getSender2).call(this, MediaStreamsKinds.Microphone);
	              if (!_sender2) {
	                _context7.next = 57;
	                break;
	              }
	              _context7.next = 52;
	              return _sender2.replaceTrack(MediaStreamTrack);
	            case 52:
	              this.setLog("Publishing a track with kind ".concat(MediaStreamKind, " via replace track succeeded"), LOG_LEVEL.INFO);
	              this.triggerEvents('PublishSucceed', [MediaStreamsKinds.Microphone]);
	              return _context7.abrupt("return");
	            case 57:
	              this.sender.addTransceiver(MediaStreamTrack, {
	                direction: 'sendonly'
	              });
	              _classPrivateMethodGet(this, _addPendingPublication, _addPendingPublication2).call(this, MediaStreamTrack.id, source);
	              _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	                "addTrack": {
	                  "cid": MediaStreamTrack.id,
	                  "source": source
	                }
	              });
	            case 60:
	              _context7.next = 63;
	              break;
	            case 62:
	              if (source === MediaStreamsKinds.Screen) {
	                this.sender.addTransceiver(MediaStreamTrack, {
	                  direction: 'sendonly'
	                });
	                _width2 = MediaStreamTrack.getSettings().width;
	                _height2 = MediaStreamTrack.getSettings().height;
	                _classPrivateMethodGet(this, _addPendingPublication, _addPendingPublication2).call(this, MediaStreamTrack.id, source);
	                _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	                  "addTrack": {
	                    "cid": MediaStreamTrack.id,
	                    "type": "VIDEO",
	                    "width": _width2,
	                    "height": _height2,
	                    "source": source
	                  }
	                });
	              } else if (source === MediaStreamsKinds.ScreenAudio) {
	                this.sender.addTransceiver(MediaStreamTrack, {
	                  direction: 'sendonly'
	                });
	                this.sender.addTransceiver(MediaStreamTrack, {
	                  direction: 'sendonly'
	                });
	                _classPrivateMethodGet(this, _addPendingPublication, _addPendingPublication2).call(this, MediaStreamTrack.id, source);
	                _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	                  "addTrack": {
	                    "cid": MediaStreamTrack.id,
	                    "source": source
	                  }
	                });
	              }
	            case 63:
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).offersStack++;
	              _context7.next = 66;
	              return this.sendOffer();
	            case 66:
	              _context7.next = 74;
	              break;
	            case 68:
	              _context7.prev = 68;
	              _context7.t0 = _context7["catch"](5);
	              if (MediaStreamKind === MediaStreamsKinds.Microphone) {
	                babelHelpers.classPrivateFieldGet(this, _privateProperties).needToDisableAudioAfterPublish = false;
	              }
	              this.setLog("Publishing a track with kind ".concat(MediaStreamKind, " failed: ").concat(_context7.t0), LOG_LEVEL.ERROR);
	              _classPrivateMethodGet(this, _releaseStream, _releaseStream2).call(this, MediaStreamKind);
	              this.onPublishFailed(MediaStreamKind);
	            case 74:
	            case "end":
	              return _context7.stop();
	          }
	        }, _callee7, this, [[5, 68]]);
	      }));
	      function publishTrack(_x7, _x8) {
	        return _publishTrack.apply(this, arguments);
	      }
	      return publishTrack;
	    }()
	  }, {
	    key: "changeStreamQuality",
	    value: function () {
	      var _changeStreamQuality = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee8(StreamQualityOptions) {
	        var key, kind, _kind;
	        return _regeneratorRuntime().wrap(function _callee8$(_context8) {
	          while (1) switch (_context8.prev = _context8.next) {
	            case 0:
	              _context8.t0 = _regeneratorRuntime().keys(StreamQualityOptions);
	            case 1:
	              if ((_context8.t1 = _context8.t0()).done) {
	                _context8.next = 18;
	                break;
	              }
	              key = _context8.t1.value;
	              if (!(babelHelpers.classPrivateFieldGet(this, _privateProperties)["".concat(key)] !== StreamQualityOptions[key])) {
	                _context8.next = 16;
	                break;
	              }
	              babelHelpers.classPrivateFieldGet(this, _privateProperties)["".concat(key)] = StreamQualityOptions[key];
	              if (!(key === 'videoSimulcast' || key === 'screenSimulcast' && babelHelpers.classPrivateFieldGet(this, _privateProperties).screenStream)) {
	                _context8.next = 12;
	                break;
	              }
	              kind = key === 'videoSimulcast' ? MediaStreamsKinds.Camera : MediaStreamsKinds.Screen;
	              if (!_classPrivateMethodGet(this, _getSender, _getSender2).call(this, kind)) {
	                _context8.next = 10;
	                break;
	              }
	              _context8.next = 10;
	              return this.republishTrack(kind);
	            case 10:
	              _context8.next = 16;
	              break;
	            case 12:
	              if (!['videoBitrate', 'audioBitrate', 'screenBitrate'].includes(key)) {
	                _context8.next = 16;
	                break;
	              }
	              _kind = key === 'videoBitrate' ? MediaStreamsKinds.Camera : key === 'screenBitrate' ? MediaStreamsKinds.Screen : MediaStreamsKinds.Microphone;
	              _context8.next = 16;
	              return this.setBitrate(StreamQualityOptions[key], _kind);
	            case 16:
	              _context8.next = 1;
	              break;
	            case 18:
	            case "end":
	              return _context8.stop();
	          }
	        }, _callee8, this);
	      }));
	      function changeStreamQuality(_x9) {
	        return _changeStreamQuality.apply(this, arguments);
	      }
	      return changeStreamQuality;
	    }()
	  }, {
	    key: "republishTrack",
	    value: function () {
	      var _republishTrack = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee9(MediaStreamKind) {
	        var track;
	        return _regeneratorRuntime().wrap(function _callee9$(_context9) {
	          while (1) switch (_context9.prev = _context9.next) {
	            case 0:
	              this.setLog("Start republishing a track with kind ".concat(MediaStreamKind), LOG_LEVEL.INFO);
	              _context9.next = 3;
	              return this.unpublishTrack(MediaStreamKind);
	            case 3:
	              _context9.next = 5;
	              return this.getTrack(MediaStreamKind);
	            case 5:
	              track = _context9.sent;
	              if (!track) {
	                _context9.next = 11;
	                break;
	              }
	              _context9.next = 9;
	              return this.publishTrack(MediaStreamKind, track);
	            case 9:
	              _context9.next = 14;
	              break;
	            case 11:
	              this.setLog("Republishing a track with kind ".concat(MediaStreamKind, " failed: ").concat(error), LOG_LEVEL.ERROR);
	              _classPrivateMethodGet(this, _releaseStream, _releaseStream2).call(this, MediaStreamKind);
	              this.triggerEvents('PublishFailed', [MediaStreamKind]);
	            case 14:
	            case "end":
	              return _context9.stop();
	          }
	        }, _callee9, this);
	      }));
	      function republishTrack(_x10) {
	        return _republishTrack.apply(this, arguments);
	      }
	      return republishTrack;
	    }()
	  }, {
	    key: "unpublishTrack",
	    value: function () {
	      var _unpublishTrack = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee10(MediaStreamKind) {
	        var sender;
	        return _regeneratorRuntime().wrap(function _callee10$(_context10) {
	          while (1) switch (_context10.prev = _context10.next) {
	            case 0:
	              this.setLog("Start unpublishing a track with kind ".concat(MediaStreamKind), LOG_LEVEL.INFO);
	              sender = _classPrivateMethodGet(this, _getSender, _getSender2).call(this, MediaStreamKind);
	              if (!sender) {
	                _context10.next = 10;
	                break;
	              }
	              this.sender.removeTrack(sender);
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).offersStack++;
	              _context10.next = 7;
	              return this.sendOffer();
	            case 7:
	              this.setLog("Unpublishing a track with kind ".concat(MediaStreamKind, " succeeded"), LOG_LEVEL.INFO);
	              _context10.next = 11;
	              break;
	            case 10:
	              this.setLog("Unpublishing a track with kind ".concat(MediaStreamKind, " failed: has no sender for a track"), LOG_LEVEL.ERROR);
	            case 11:
	            case "end":
	              return _context10.stop();
	          }
	        }, _callee10, this);
	      }));
	      function unpublishTrack(_x11) {
	        return _unpublishTrack.apply(this, arguments);
	      }
	      return unpublishTrack;
	    }()
	  }, {
	    key: "toggleRemoteParticipantVideo",
	    value: function toggleRemoteParticipantVideo(participantIds, showVideo) {
	      var isPaginateToggle = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      _classPrivateMethodGet(this, _toggleRemoteParticipantVideo, _toggleRemoteParticipantVideo2).call(this, participantIds, showVideo, isPaginateToggle);
	    }
	  }, {
	    key: "hangup",
	    value: function hangup() {
	      if (babelHelpers.classPrivateFieldGet(this, _privateProperties).callState === CALL_STATE.TERMINATED) {
	        return;
	      }
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).abortController.abort();
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).callState = CALL_STATE.TERMINATED;
	      this.setLog("Disconnecting from the call", LOG_LEVEL.INFO);
	      _classPrivateMethodGet(this, _sendLeave, _sendLeave2).call(this);
	      _classPrivateMethodGet(this, _beforeDisconnect, _beforeDisconnect2).call(this);
	      _classPrivateMethodGet(this, _destroyPeerConnection, _destroyPeerConnection2).call(this);
	      clearTimeout(babelHelpers.classPrivateFieldGet(this, _privateProperties).reconnectionTimeout);
	      for (var _trackId5 in babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingPublications) {
	        clearTimeout(babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingPublications[_trackId5]);
	      }
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingPublications = {};
	      for (var userId in babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions) {
	        for (var _trackId6 in babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions[userId]) {
	          clearTimeout(babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions[userId][_trackId6].timeout);
	        }
	      }
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions = {};
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).url = null;
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).token = null;
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).endpoint = null;
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).jwt = null;
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).options = null;
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).iceServers = null;
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).lastReconnectionReason = null;
	      _classPrivateMethodGet(this, _releaseStream, _releaseStream2).call(this, MediaStreamsKinds.Camera);
	      _classPrivateMethodGet(this, _releaseStream, _releaseStream2).call(this, MediaStreamsKinds.Microphone);
	      _classPrivateMethodGet(this, _releaseStream, _releaseStream2).call(this, MediaStreamsKinds.Screen);
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).rtt = 0;
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteTracks = {};
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).isReconnecting = false;
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).reconnectionAttempt = 0;
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).mainStream = {};
	      this.triggerEvents('Disconnected');
	    }
	  }, {
	    key: "isConnected",
	    value: function isConnected() {
	      return babelHelpers.classPrivateFieldGet(this, _privateProperties).callState === CALL_STATE.CONNECTED;
	    }
	  }, {
	    key: "setVideoStreamSetupErrorList",
	    value: function setVideoStreamSetupErrorList(userId, kind) {
	      var errorInVideoStreamSetupErrorList = babelHelpers.classPrivateFieldGet(this, _privateProperties).videoStreamSetupErrorList[userId];
	      var kindInListKinds = !!errorInVideoStreamSetupErrorList && errorInVideoStreamSetupErrorList.includes(kind);
	      var kindsArray = errorInVideoStreamSetupErrorList || [];
	      if (!kindInListKinds) {
	        babelHelpers.classPrivateFieldGet(this, _privateProperties).videoStreamSetupErrorList[userId] = [kind].concat(babelHelpers.toConsumableArray(kindsArray));
	      }
	    }
	  }, {
	    key: "setMainStream",
	    value: function setMainStream(userId, kind) {
	      // userId always exists, check in bitrix_call
	      if (!babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[userId]) {
	        this.setVideoStreamSetupErrorList(userId, kind);
	        this.setLog("Setting main stream error (No remoteParticipant with ID - ".concat(userId, " in list)"), LOG_LEVEL.ERROR);
	        return;
	      }
	      this.setLog("Setting main stream for a participant width id ".concat(userId, " (sid: ").concat(babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[userId].sid, ")"), LOG_LEVEL.INFO);
	      _classPrivateMethodGet(this, _changeRoomStreamsQuality, _changeRoomStreamsQuality2).call(this, userId, kind);
	    }
	  }, {
	    key: "resetMainStream",
	    value: function resetMainStream() {
	      this.setLog("Resetting main stream", LOG_LEVEL.INFO);
	      _classPrivateMethodGet(this, _changeRoomStreamsQuality, _changeRoomStreamsQuality2).call(this);
	    }
	  }, {
	    key: "removeTrack",
	    value: function removeTrack(mediaStreamKind) {
	      var _babelHelpers$classPr2;
	      var trackSid = (_babelHelpers$classPr2 = babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[mediaStreamKind]) === null || _babelHelpers$classPr2 === void 0 ? void 0 : _babelHelpers$classPr2.sid;
	      if (trackSid) {
	        this.setLog("Sending removeTrack signal for a track with kind ".concat(mediaStreamKind, " (sid: ").concat(trackSid, ")"), LOG_LEVEL.INFO);
	        delete babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[mediaStreamKind];
	        _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	          removeTrack: {
	            sid: trackSid
	          }
	        });
	      } else {
	        this.setLog("Sending removeTrack signal for a non-existent track with kind ".concat(mediaStreamKind), LOG_LEVEL.WARNING);
	      }
	    }
	  }, {
	    key: "pauseTrack",
	    value: function pauseTrack(mediaStreamKind, keepTrack) {
	      var _babelHelpers$classPr3;
	      var trackSid = (_babelHelpers$classPr3 = babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[mediaStreamKind]) === null || _babelHelpers$classPr3 === void 0 ? void 0 : _babelHelpers$classPr3.sid;
	      if (trackSid) {
	        this.setLog("Sending pause signal (keep: ".concat(keepTrack, ") for a track with kind ").concat(mediaStreamKind, " (sid: ").concat(trackSid, ")"), LOG_LEVEL.INFO);
	        if (!keepTrack) {
	          delete babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[mediaStreamKind];
	        }
	        _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	          mute: {
	            sid: trackSid,
	            muted: true
	          }
	        });
	      } else {
	        this.setLog("Sending pause signal for a non-existent track with kind ".concat(mediaStreamKind), LOG_LEVEL.WARNING);
	      }
	    }
	  }, {
	    key: "unpauseTrack",
	    value: function unpauseTrack(mediaStreamKind) {
	      var _babelHelpers$classPr4;
	      var trackSid = (_babelHelpers$classPr4 = babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[mediaStreamKind]) === null || _babelHelpers$classPr4 === void 0 ? void 0 : _babelHelpers$classPr4.sid;
	      if (trackSid) {
	        this.setLog("Sending unpause signal for a track with kind ".concat(mediaStreamKind, " (sid: ").concat(trackSid, ")"), LOG_LEVEL.INFO);
	        _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	          mute: {
	            sid: trackSid,
	            muted: false
	          }
	        });
	      } else {
	        this.setLog("Sending unpause signal for a non-existent track with kind ".concat(mediaStreamKind), LOG_LEVEL.WARNING);
	      }
	    }
	  }, {
	    key: "disableAudio",
	    value: function disableAudio() {
	      var _babelHelpers$classPr5;
	      var bySystem = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
	      if (babelHelpers.classPrivateFieldGet(this, _privateProperties).mediaMutedBySystem) {
	        return;
	      }
	      this.setLog('Start disabling audio', LOG_LEVEL.INFO);
	      var track = (_babelHelpers$classPr5 = babelHelpers.classPrivateFieldGet(this, _privateProperties).microphoneStream) === null || _babelHelpers$classPr5 === void 0 ? void 0 : _babelHelpers$classPr5.getAudioTracks()[0];
	      if (track) {
	        babelHelpers.classPrivateFieldGet(this, _privateProperties).needToEnableAudioAfterSystemMuted = bySystem ? track.enabled : false;
	        track.enabled = false;
	        this.pauseTrack(MediaStreamsKinds.Microphone, true);
	      } else {
	        this.setLog('Disabling audio failed: has no track', LOG_LEVEL.ERROR);
	      }
	    }
	  }, {
	    key: "enableAudio",
	    value: function () {
	      var _enableAudio = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee11() {
	        var _babelHelpers$classPr6, _track4;
	        var disabled,
	          track,
	          canUseUnpauseSignal,
	          needToGetNewTrack,
	          _args11 = arguments;
	        return _regeneratorRuntime().wrap(function _callee11$(_context11) {
	          while (1) switch (_context11.prev = _context11.next) {
	            case 0:
	              disabled = _args11.length > 0 && _args11[0] !== undefined ? _args11[0] : false;
	              this.setLog('Start enabling audio', LOG_LEVEL.INFO);
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).needToEnableAudioAfterSystemMuted = false;
	              if (!babelHelpers.classPrivateFieldGet(this, _privateProperties).switchActiveAudioDeviceInProgress) {
	                _context11.next = 12;
	                break;
	              }
	              _context11.prev = 4;
	              _context11.next = 7;
	              return babelHelpers.classPrivateFieldGet(this, _privateProperties).switchActiveAudioDeviceInProgress;
	            case 7:
	              _context11.next = 12;
	              break;
	            case 9:
	              _context11.prev = 9;
	              _context11.t0 = _context11["catch"](4);
	              this.onPublishFailed(MediaStreamsKinds.Microphone);
	            case 12:
	              track = (_babelHelpers$classPr6 = babelHelpers.classPrivateFieldGet(this, _privateProperties).microphoneStream) === null || _babelHelpers$classPr6 === void 0 ? void 0 : _babelHelpers$classPr6.getAudioTracks()[0];
	              canUseUnpauseSignal = track && babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[MediaStreamsKinds.Microphone];
	              needToGetNewTrack = ((_track4 = track) === null || _track4 === void 0 ? void 0 : _track4.readyState) !== 'live';
	              if (!needToGetNewTrack) {
	                _context11.next = 19;
	                break;
	              }
	              _context11.next = 18;
	              return this.getLocalAudio();
	            case 18:
	              track = _context11.sent;
	            case 19:
	              if (!track) {
	                this.setLog('Enabling audio failed: has no track', LOG_LEVEL.ERROR);
	                _classPrivateMethodGet(this, _releaseStream, _releaseStream2).call(this, MediaStreamsKinds.Microphone);
	                this.triggerEvents('PublishFailed', [MediaStreamsKinds.Microphone]);
	              }
	              if (!canUseUnpauseSignal) {
	                _context11.next = 28;
	                break;
	              }
	              this.setLog('Enabling audio via unpause signal', LOG_LEVEL.INFO);
	              track.enabled = true;
	              _context11.next = 25;
	              return this.publishTrack(MediaStreamsKinds.Microphone, track);
	            case 25:
	              this.unpauseTrack(MediaStreamsKinds.Microphone);
	              _context11.next = 33;
	              break;
	            case 28:
	              this.setLog('Enabling audio via publish', LOG_LEVEL.INFO);
	              track.enabled = !disabled;
	              if (disabled) {
	                babelHelpers.classPrivateFieldGet(this, _privateProperties).needToDisableAudioAfterPublish = true;
	              }
	              _context11.next = 33;
	              return this.publishTrack(MediaStreamsKinds.Microphone, track);
	            case 33:
	            case "end":
	              return _context11.stop();
	          }
	        }, _callee11, this, [[4, 9]]);
	      }));
	      function enableAudio() {
	        return _enableAudio.apply(this, arguments);
	      }
	      return enableAudio;
	    }()
	  }, {
	    key: "disableVideo",
	    value: function () {
	      var _disableVideo = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee12() {
	        var _babelHelpers$classPr7,
	          _this9 = this;
	        var bySystem,
	          hasQueue,
	          track,
	          _args12 = arguments;
	        return _regeneratorRuntime().wrap(function _callee12$(_context12) {
	          while (1) switch (_context12.prev = _context12.next) {
	            case 0:
	              bySystem = _args12.length > 0 && _args12[0] !== undefined ? _args12[0] : false;
	              if (!babelHelpers.classPrivateFieldGet(this, _privateProperties).isReconnecting) {
	                _context12.next = 3;
	                break;
	              }
	              return _context12.abrupt("return");
	            case 3:
	              hasQueue = babelHelpers.classPrivateFieldGet(this, _privateProperties).videoQueue !== VIDEO_QUEUE.INITIAL;
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).videoQueue = VIDEO_QUEUE.DISABLE;
	              if (!hasQueue) {
	                _context12.next = 7;
	                break;
	              }
	              return _context12.abrupt("return");
	            case 7:
	              this.setLog('Start disabling video', LOG_LEVEL.INFO);
	              track = (_babelHelpers$classPr7 = babelHelpers.classPrivateFieldGet(this, _privateProperties).cameraStream) === null || _babelHelpers$classPr7 === void 0 ? void 0 : _babelHelpers$classPr7.getVideoTracks()[0];
	              if (!(track && babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[MediaStreamsKinds.Camera])) {
	                _context12.next = 23;
	                break;
	              }
	              if (!babelHelpers.classPrivateFieldGet(this, _privateProperties).mediaMutedBySystem) {
	                _context12.next = 18;
	                break;
	              }
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).videoQueue = VIDEO_QUEUE.INITIAL;
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).mediaMutedBySystem = false;
	              track.stop();
	              this.checkQosFeatureAndExecutionCallback(function () {
	                _this9.addMonitoringEvents({
	                  name: MONITORING_EVENTS_NAME_LIST.USER_CAMERA_DISABLED,
	                  withCounter: true
	                });
	              });
	              this.triggerEvents('MediaMutedBySystem', [false]);
	              this.triggerEvents('PublishEnded', [MediaStreamsKinds.Camera]);
	              return _context12.abrupt("return");
	            case 18:
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[MediaStreamsKinds.Camera].muted = true;
	              this.pauseTrack(MediaStreamsKinds.Camera, true);
	              if (!bySystem) {
	                babelHelpers.classPrivateFieldGet(this, _privateProperties).videoQueue = VIDEO_QUEUE.INITIAL;
	                track.stop();
	                this.checkQosFeatureAndExecutionCallback(function () {
	                  _this9.addMonitoringEvents({
	                    name: MONITORING_EVENTS_NAME_LIST.USER_CAMERA_DISABLED,
	                    withCounter: true
	                  });
	                });
	                this.triggerEvents('PublishEnded', [MediaStreamsKinds.Camera]);
	              }
	              _context12.next = 25;
	              break;
	            case 23:
	              this.setLog('Disabling video failed: has no track', LOG_LEVEL.ERROR);
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).videoQueue = VIDEO_QUEUE.INITIAL;
	            case 25:
	            case "end":
	              return _context12.stop();
	          }
	        }, _callee12, this);
	      }));
	      function disableVideo() {
	        return _disableVideo.apply(this, arguments);
	      }
	      return disableVideo;
	    }()
	  }, {
	    key: "enableVideo",
	    value: function () {
	      var _enableVideo = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee13() {
	        var _babelHelpers$classPr8;
	        var skipUnpause,
	          hasQueue,
	          hasTrack,
	          track,
	          _args13 = arguments;
	        return _regeneratorRuntime().wrap(function _callee13$(_context13) {
	          while (1) switch (_context13.prev = _context13.next) {
	            case 0:
	              skipUnpause = _args13.length > 0 && _args13[0] !== undefined ? _args13[0] : false;
	              if (!babelHelpers.classPrivateFieldGet(this, _privateProperties).isReconnecting) {
	                _context13.next = 3;
	                break;
	              }
	              return _context13.abrupt("return");
	            case 3:
	              hasQueue = babelHelpers.classPrivateFieldGet(this, _privateProperties).videoQueue !== VIDEO_QUEUE.INITIAL;
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).videoQueue = VIDEO_QUEUE.ENABLE;
	              if (!hasQueue) {
	                _context13.next = 7;
	                break;
	              }
	              return _context13.abrupt("return");
	            case 7:
	              if (!babelHelpers.classPrivateFieldGet(this, _privateProperties).switchActiveVideoDeviceInProgress) {
	                _context13.next = 16;
	                break;
	              }
	              _context13.prev = 8;
	              _context13.next = 11;
	              return babelHelpers.classPrivateFieldGet(this, _privateProperties).switchActiveVideoDeviceInProgress;
	            case 11:
	              _context13.next = 16;
	              break;
	            case 13:
	              _context13.prev = 13;
	              _context13.t0 = _context13["catch"](8);
	              this.onPublishFailed(MediaStreamsKinds.Camera);
	            case 16:
	              this.setLog('Start enabling video', LOG_LEVEL.INFO);
	              hasTrack = !!((_babelHelpers$classPr8 = babelHelpers.classPrivateFieldGet(this, _privateProperties).cameraStream) !== null && _babelHelpers$classPr8 !== void 0 && _babelHelpers$classPr8.getVideoTracks()[0]);
	              _context13.next = 20;
	              return this.getLocalVideo();
	            case 20:
	              track = _context13.sent;
	              if (!(track && hasTrack && babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[MediaStreamsKinds.Camera])) {
	                _context13.next = 30;
	                break;
	              }
	              if (babelHelpers.classPrivateFieldGet(this, _privateProperties).mediaMutedBySystem) {
	                babelHelpers.classPrivateFieldGet(this, _privateProperties).mediaMutedBySystem = false;
	                this.triggerEvents('MediaMutedBySystem', [false]);
	              }
	              if (skipUnpause) {
	                this.setLog('Re-enabling video after automatic camera change', LOG_LEVEL.INFO);
	              } else {
	                this.setLog('Enabling video via unpause signal', LOG_LEVEL.INFO);
	              }
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[MediaStreamsKinds.Camera].muted = false;
	              _context13.next = 27;
	              return this.publishTrack(MediaStreamsKinds.Camera, track);
	            case 27:
	              if (skipUnpause) {
	                babelHelpers.classPrivateFieldGet(this, _privateProperties).videoQueue = VIDEO_QUEUE.INITIAL;
	              } else {
	                this.unpauseTrack(MediaStreamsKinds.Camera);
	              }
	              _context13.next = 40;
	              break;
	            case 30:
	              if (!track) {
	                _context13.next = 36;
	                break;
	              }
	              this.setLog('Enabling video via publish', LOG_LEVEL.INFO);
	              _context13.next = 34;
	              return this.publishTrack(MediaStreamsKinds.Camera, track);
	            case 34:
	              _context13.next = 40;
	              break;
	            case 36:
	              this.setLog('Enabling video failed: has no track', LOG_LEVEL.ERROR);
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).videoQueue = VIDEO_QUEUE.INITIAL;
	              _classPrivateMethodGet(this, _releaseStream, _releaseStream2).call(this, MediaStreamsKinds.Camera);
	              this.triggerEvents('PublishFailed', [MediaStreamsKinds.Camera]);
	            case 40:
	            case "end":
	              return _context13.stop();
	          }
	        }, _callee13, this, [[8, 13]]);
	      }));
	      function enableVideo() {
	        return _enableVideo.apply(this, arguments);
	      }
	      return enableVideo;
	    }()
	  }, {
	    key: "startScreenShare",
	    value: function () {
	      var _startScreenShare = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee14() {
	        var tracks, videoTrack, audioTrack;
	        return _regeneratorRuntime().wrap(function _callee14$(_context14) {
	          while (1) switch (_context14.prev = _context14.next) {
	            case 0:
	              this.setLog('Start enabling screen sharing', LOG_LEVEL.INFO);
	              _context14.next = 3;
	              return this.getLocalScreen();
	            case 3:
	              tracks = _context14.sent;
	              videoTrack = tracks === null || tracks === void 0 ? void 0 : tracks.video;
	              audioTrack = tracks === null || tracks === void 0 ? void 0 : tracks.audio;
	              if (videoTrack) {
	                _context14.next = 12;
	                break;
	              }
	              this.setLog('Enabling screen sharing failed: has no track', LOG_LEVEL.ERROR);
	              _classPrivateMethodGet(this, _releaseStream, _releaseStream2).call(this, MediaStreamsKinds.Screen);
	              this.onPublishFailed(MediaStreamsKinds.Screen);
	              this.onPublishFailed(MediaStreamsKinds.ScreenAudio);
	              return _context14.abrupt("return");
	            case 12:
	              _context14.next = 14;
	              return this.publishTrack(MediaStreamsKinds.Screen, videoTrack);
	            case 14:
	              if (!audioTrack) {
	                _context14.next = 17;
	                break;
	              }
	              _context14.next = 17;
	              return this.publishTrack(MediaStreamsKinds.ScreenAudio, audioTrack);
	            case 17:
	            case "end":
	              return _context14.stop();
	          }
	        }, _callee14, this);
	      }));
	      function startScreenShare() {
	        return _startScreenShare.apply(this, arguments);
	      }
	      return startScreenShare;
	    }()
	  }, {
	    key: "stopScreenShare",
	    value: function () {
	      var _stopScreenShare = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee15() {
	        return _regeneratorRuntime().wrap(function _callee15$(_context15) {
	          while (1) switch (_context15.prev = _context15.next) {
	            case 0:
	              this.setLog('Start disabling screen sharing', LOG_LEVEL.INFO);
	              _classPrivateMethodGet(this, _releaseStream, _releaseStream2).call(this, MediaStreamsKinds.Screen);
	              this.removeTrack(MediaStreamsKinds.Screen);
	              this.removeTrack(MediaStreamsKinds.ScreenAudio);
	              _context15.next = 6;
	              return this.unpublishTrack(MediaStreamsKinds.Screen);
	            case 6:
	              _context15.next = 8;
	              return this.unpublishTrack(MediaStreamsKinds.ScreenAudio);
	            case 8:
	            case "end":
	              return _context15.stop();
	          }
	        }, _callee15, this);
	      }));
	      function stopScreenShare() {
	        return _stopScreenShare.apply(this, arguments);
	      }
	      return stopScreenShare;
	    }()
	  }, {
	    key: "sendMessage",
	    value: function sendMessage(message) {
	      _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	        sendMessage: {
	          message: message
	        }
	      });
	    }
	  }, {
	    key: "raiseHand",
	    value: function raiseHand(raised) {
	      _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	        raiseHand: {
	          raised: raised
	        }
	      });
	    }
	  }, {
	    key: "getLocalVideo",
	    value: function () {
	      var _getLocalVideo = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee16() {
	        var _babelHelpers$classPr9, _babelHelpers$classPr10;
	        return _regeneratorRuntime().wrap(function _callee16$(_context16) {
	          while (1) switch (_context16.prev = _context16.next) {
	            case 0:
	              if (!(((_babelHelpers$classPr9 = babelHelpers.classPrivateFieldGet(this, _privateProperties).cameraStream) === null || _babelHelpers$classPr9 === void 0 ? void 0 : _babelHelpers$classPr9.getVideoTracks()[0].readyState) !== 'live')) {
	                _context16.next = 3;
	                break;
	              }
	              _context16.next = 3;
	              return this.getTrack(MediaStreamsKinds.Camera);
	            case 3:
	              return _context16.abrupt("return", (_babelHelpers$classPr10 = babelHelpers.classPrivateFieldGet(this, _privateProperties).cameraStream) === null || _babelHelpers$classPr10 === void 0 ? void 0 : _babelHelpers$classPr10.getVideoTracks()[0]);
	            case 4:
	            case "end":
	              return _context16.stop();
	          }
	        }, _callee16, this);
	      }));
	      function getLocalVideo() {
	        return _getLocalVideo.apply(this, arguments);
	      }
	      return getLocalVideo;
	    }()
	  }, {
	    key: "getLocalAudio",
	    value: function () {
	      var _getLocalAudio = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee17() {
	        var _babelHelpers$classPr11;
	        return _regeneratorRuntime().wrap(function _callee17$(_context17) {
	          while (1) switch (_context17.prev = _context17.next) {
	            case 0:
	              if (babelHelpers.classPrivateFieldGet(this, _privateProperties).microphoneStream) {
	                _context17.next = 3;
	                break;
	              }
	              _context17.next = 3;
	              return this.getTrack(MediaStreamsKinds.Microphone);
	            case 3:
	              return _context17.abrupt("return", (_babelHelpers$classPr11 = babelHelpers.classPrivateFieldGet(this, _privateProperties).microphoneStream) === null || _babelHelpers$classPr11 === void 0 ? void 0 : _babelHelpers$classPr11.getAudioTracks()[0]);
	            case 4:
	            case "end":
	              return _context17.stop();
	          }
	        }, _callee17, this);
	      }));
	      function getLocalAudio() {
	        return _getLocalAudio.apply(this, arguments);
	      }
	      return getLocalAudio;
	    }()
	  }, {
	    key: "getLocalScreen",
	    value: function () {
	      var _getLocalScreen = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee18() {
	        var _babelHelpers$classPr12, _babelHelpers$classPr13;
	        return _regeneratorRuntime().wrap(function _callee18$(_context18) {
	          while (1) switch (_context18.prev = _context18.next) {
	            case 0:
	              if (babelHelpers.classPrivateFieldGet(this, _privateProperties).screenStream) {
	                _context18.next = 3;
	                break;
	              }
	              _context18.next = 3;
	              return this.getTrack(MediaStreamsKinds.Screen);
	            case 3:
	              return _context18.abrupt("return", {
	                video: (_babelHelpers$classPr12 = babelHelpers.classPrivateFieldGet(this, _privateProperties).screenStream) === null || _babelHelpers$classPr12 === void 0 ? void 0 : _babelHelpers$classPr12.getVideoTracks()[0],
	                audio: (_babelHelpers$classPr13 = babelHelpers.classPrivateFieldGet(this, _privateProperties).screenStream) === null || _babelHelpers$classPr13 === void 0 ? void 0 : _babelHelpers$classPr13.getAudioTracks()[0]
	              });
	            case 4:
	            case "end":
	              return _context18.stop();
	          }
	        }, _callee18, this);
	      }));
	      function getLocalScreen() {
	        return _getLocalScreen.apply(this, arguments);
	      }
	      return getLocalScreen;
	    }()
	  }, {
	    key: "getTrack",
	    value: function () {
	      var _getTrack = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee19(MediaStreamKind) {
	        var _babelHelpers$classPr14,
	          _this10 = this;
	        var track, _babelHelpers$classPr15, _babelHelpers$classPr16, _babelHelpers$classPr17, interrupted;
	        return _regeneratorRuntime().wrap(function _callee19$(_context19) {
	          while (1) switch (_context19.prev = _context19.next) {
	            case 0:
	              if (!(MediaStreamKind === MediaStreamsKinds.Camera && ((_babelHelpers$classPr14 = babelHelpers.classPrivateFieldGet(this, _privateProperties).cameraStream) === null || _babelHelpers$classPr14 === void 0 ? void 0 : _babelHelpers$classPr14.getVideoTracks().readyState) !== 'live')) {
	                _context19.next = 6;
	                break;
	              }
	              _context19.next = 3;
	              return _classPrivateMethodGet(this, _getUserMedia, _getUserMedia2).call(this, {
	                video: true
	              });
	            case 3:
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).cameraStream = _context19.sent;
	              _context19.next = 16;
	              break;
	            case 6:
	              if (!(MediaStreamKind === MediaStreamsKinds.Microphone && !babelHelpers.classPrivateFieldGet(this, _privateProperties).microphoneStream)) {
	                _context19.next = 12;
	                break;
	              }
	              _context19.next = 9;
	              return _classPrivateMethodGet(this, _getUserMedia, _getUserMedia2).call(this, {
	                audio: true
	              });
	            case 9:
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).microphoneStream = _context19.sent;
	              _context19.next = 16;
	              break;
	            case 12:
	              if (!(MediaStreamKind === MediaStreamsKinds.Screen && !babelHelpers.classPrivateFieldGet(this, _privateProperties).screenStream)) {
	                _context19.next = 16;
	                break;
	              }
	              _context19.next = 15;
	              return _classPrivateMethodGet(this, _getDisplayMedia, _getDisplayMedia2).call(this);
	            case 15:
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).screenStream = _context19.sent;
	            case 16:
	              if (!babelHelpers.classPrivateFieldGet(this, _privateProperties).abortController.signal.aborted) {
	                _context19.next = 19;
	                break;
	              }
	              _classPrivateMethodGet(this, _releaseStream, _releaseStream2).call(this, MediaStreamKind);
	              return _context19.abrupt("return");
	            case 19:
	              if (MediaStreamKind === MediaStreamsKinds.Screen) {
	                track = (_babelHelpers$classPr15 = babelHelpers.classPrivateFieldGet(this, _privateProperties).screenStream) === null || _babelHelpers$classPr15 === void 0 ? void 0 : _babelHelpers$classPr15.getVideoTracks()[0];
	                if (track && track.readyState !== 'live') {
	                  babelHelpers.classPrivateFieldGet(this, _privateProperties).screenStream = null;
	                  track = this.getLocalScreen();
	                }
	              } else if (MediaStreamKind === MediaStreamsKinds.Camera) {
	                track = (_babelHelpers$classPr16 = babelHelpers.classPrivateFieldGet(this, _privateProperties).cameraStream) === null || _babelHelpers$classPr16 === void 0 ? void 0 : _babelHelpers$classPr16.getVideoTracks()[0];
	                if (track && track.readyState !== 'live') {
	                  babelHelpers.classPrivateFieldGet(this, _privateProperties).cameraStream = null;
	                  track = this.getLocalVideo();
	                }
	              } else if (MediaStreamKind === MediaStreamsKinds.Microphone) {
	                track = (_babelHelpers$classPr17 = babelHelpers.classPrivateFieldGet(this, _privateProperties).microphoneStream) === null || _babelHelpers$classPr17 === void 0 ? void 0 : _babelHelpers$classPr17.getAudioTracks()[0];
	                if (track && track.readyState !== 'live') {
	                  babelHelpers.classPrivateFieldGet(this, _privateProperties).microphoneStream = null;
	                  track = this.getLocalAudio();
	                }
	              }
	              if (track && !track.onended) {
	                interrupted = MediaStreamKind === MediaStreamsKinds.Microphone || MediaStreamKind === MediaStreamsKinds.Camera;
	                track.onended = function () {
	                  if (babelHelpers.classPrivateFieldGet(_this10, _privateProperties).localTracks[MediaStreamKind]) {
	                    babelHelpers.classPrivateFieldGet(_this10, _privateProperties).localTracks[MediaStreamKind].muted = true;
	                  }
	                  _this10.triggerEvents('PublishEnded', [MediaStreamKind, interrupted]);
	                };
	              }
	              return _context19.abrupt("return", track);
	            case 22:
	            case "end":
	              return _context19.stop();
	          }
	        }, _callee19, this);
	      }));
	      function getTrack(_x12) {
	        return _getTrack.apply(this, arguments);
	      }
	      return getTrack;
	    }()
	  }, {
	    key: "switchActiveAudioDevice",
	    value: function () {
	      var _switchActiveAudioDevice = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee21(deviceId, force) {
	        var _this11 = this;
	        var error, fulfilled, promise;
	        return _regeneratorRuntime().wrap(function _callee21$(_context21) {
	          while (1) switch (_context21.prev = _context21.next) {
	            case 0:
	              if (!(babelHelpers.classPrivateFieldGet(this, _privateProperties).switchActiveAudioDeviceInProgress && !force)) {
	                _context21.next = 4;
	                break;
	              }
	              this.setLog("Got another request to switch an audio device to ".concat(deviceId, ", saving it"), LOG_LEVEL.INFO);
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).switchActiveAudioDevicePending = deviceId;
	              return _context21.abrupt("return");
	            case 4:
	              fulfilled = false;
	              this.setLog("Start switching an audio device to ".concat(deviceId), LOG_LEVEL.INFO);
	              promise = new Promise( /*#__PURE__*/function () {
	                var _ref3 = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee20(resolve, reject) {
	                  var prevStream, _babelHelpers$classPr18, prevTrack, prevTrackEnabledState, prevTrackId, audioTrack, sender, _deviceId;
	                  return _regeneratorRuntime().wrap(function _callee20$(_context20) {
	                    while (1) switch (_context20.prev = _context20.next) {
	                      case 0:
	                        babelHelpers.classPrivateFieldGet(_this11, _privateProperties).audioDeviceId = deviceId;
	                        prevStream = babelHelpers.classPrivateFieldGet(_this11, _privateProperties).microphoneStream;
	                        _context20.prev = 2;
	                        prevTrack = (_babelHelpers$classPr18 = babelHelpers.classPrivateFieldGet(_this11, _privateProperties).microphoneStream) === null || _babelHelpers$classPr18 === void 0 ? void 0 : _babelHelpers$classPr18.getAudioTracks()[0];
	                        babelHelpers.classPrivateFieldGet(_this11, _privateProperties).microphoneStream = null;
	                        prevTrackEnabledState = true;
	                        prevTrackId = '';
	                        if (prevTrack) {
	                          prevTrackEnabledState = prevTrack.enabled;
	                          prevTrackId = prevTrack.id;
	                          prevTrack.stop();
	                        }
	                        _context20.next = 10;
	                        return _this11.getLocalAudio();
	                      case 10:
	                        audioTrack = _context20.sent;
	                        audioTrack.source = MediaStreamsKinds.Microphone;
	                        audioTrack.enabled = prevTrackEnabledState;
	                        sender = _classPrivateMethodGet(_this11, _getSender, _getSender2).call(_this11, MediaStreamsKinds.Microphone);
	                        if (!(sender && (_this11.isAudioPublished() || sender.track.id !== audioTrack.id || audioTrack.id !== prevTrackId))) {
	                          _context20.next = 18;
	                          break;
	                        }
	                        _this11.setLog('Have sender for audio, start replacing track', LOG_LEVEL.INFO);
	                        _context20.next = 18;
	                        return sender.replaceTrack(audioTrack);
	                      case 18:
	                        _this11.setLog('Switching an audio device succeeded', LOG_LEVEL.INFO);
	                        _context20.next = 26;
	                        break;
	                      case 21:
	                        _context20.prev = 21;
	                        _context20.t0 = _context20["catch"](2);
	                        error = _context20.t0;
	                        _this11.setLog("Switching an audio device failed: ".concat(_context20.t0), LOG_LEVEL.ERROR);
	                        if (!babelHelpers.classPrivateFieldGet(_this11, _privateProperties).microphoneStream) {
	                          babelHelpers.classPrivateFieldGet(_this11, _privateProperties).microphoneStream = prevStream;
	                        }
	                      case 26:
	                        _context20.prev = 26;
	                        if (!babelHelpers.classPrivateFieldGet(_this11, _privateProperties).switchActiveAudioDevicePending) {
	                          _context20.next = 33;
	                          break;
	                        }
	                        _deviceId = babelHelpers.classPrivateFieldGet(_this11, _privateProperties).switchActiveAudioDevicePending;
	                        babelHelpers.classPrivateFieldGet(_this11, _privateProperties).switchActiveAudioDevicePending = null;
	                        resolve(_this11.switchActiveAudioDevice(_deviceId, true));
	                        _context20.next = 36;
	                        break;
	                      case 33:
	                        fulfilled = true;
	                        babelHelpers.classPrivateFieldGet(_this11, _privateProperties).switchActiveAudioDeviceInProgress = null;
	                        return _context20.abrupt("return", error ? reject(error) : resolve());
	                      case 36:
	                        return _context20.finish(26);
	                      case 37:
	                      case "end":
	                        return _context20.stop();
	                    }
	                  }, _callee20, null, [[2, 21, 26, 37]]);
	                }));
	                return function (_x15, _x16) {
	                  return _ref3.apply(this, arguments);
	                };
	              }());
	              if (!force && !fulfilled) {
	                babelHelpers.classPrivateFieldGet(this, _privateProperties).switchActiveAudioDeviceInProgress = promise;
	              }
	              return _context21.abrupt("return", promise);
	            case 9:
	            case "end":
	              return _context21.stop();
	          }
	        }, _callee21, this);
	      }));
	      function switchActiveAudioDevice(_x13, _x14) {
	        return _switchActiveAudioDevice.apply(this, arguments);
	      }
	      return switchActiveAudioDevice;
	    }()
	  }, {
	    key: "switchActiveVideoDevice",
	    value: function () {
	      var _switchActiveVideoDevice = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee23(deviceId, force) {
	        var _this12 = this;
	        var error, fulfilled, promise;
	        return _regeneratorRuntime().wrap(function _callee23$(_context23) {
	          while (1) switch (_context23.prev = _context23.next) {
	            case 0:
	              if (!(babelHelpers.classPrivateFieldGet(this, _privateProperties).switchActiveVideoDeviceInProgress && !force)) {
	                _context23.next = 4;
	                break;
	              }
	              this.setLog("Got another request to switch a video device to ".concat(deviceId, ", saving it"), LOG_LEVEL.INFO);
	              babelHelpers.classPrivateFieldGet(this, _privateProperties).switchActiveVideoDevicePending = deviceId;
	              return _context23.abrupt("return");
	            case 4:
	              fulfilled = false;
	              this.setLog("Start switching a video device to ".concat(deviceId), LOG_LEVEL.INFO);
	              promise = new Promise( /*#__PURE__*/function () {
	                var _ref4 = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee22(resolve, reject) {
	                  var prevStream, sender, _babelHelpers$classPr19, videoTrack, _deviceId2;
	                  return _regeneratorRuntime().wrap(function _callee22$(_context22) {
	                    while (1) switch (_context22.prev = _context22.next) {
	                      case 0:
	                        babelHelpers.classPrivateFieldGet(_this12, _privateProperties).videoDeviceId = deviceId;
	                        prevStream = babelHelpers.classPrivateFieldGet(_this12, _privateProperties).cameraStream;
	                        _context22.prev = 2;
	                        sender = _classPrivateMethodGet(_this12, _getSender, _getSender2).call(_this12, MediaStreamsKinds.Camera);
	                        if (!(sender && _this12.isVideoPublished())) {
	                          _context22.next = 15;
	                          break;
	                        }
	                        _this12.setLog('Have sender for video, start replacing track', LOG_LEVEL.INFO);
	                        (_babelHelpers$classPr19 = babelHelpers.classPrivateFieldGet(_this12, _privateProperties).cameraStream) === null || _babelHelpers$classPr19 === void 0 ? void 0 : _babelHelpers$classPr19.getVideoTracks()[0].stop();
	                        babelHelpers.classPrivateFieldGet(_this12, _privateProperties).cameraStream = null;
	                        _context22.next = 10;
	                        return _this12.getLocalVideo();
	                      case 10:
	                        videoTrack = _context22.sent;
	                        videoTrack.source = MediaStreamsKinds.Camera;
	                        _context22.next = 14;
	                        return sender.replaceTrack(videoTrack);
	                      case 14:
	                        _classPrivateMethodGet(_this12, _updateVideoEncodings, _updateVideoEncodings2).call(_this12, sender, videoTrack);
	                      case 15:
	                        _this12.setLog('Switching a video device succeeded', LOG_LEVEL.INFO);
	                        _context22.next = 23;
	                        break;
	                      case 18:
	                        _context22.prev = 18;
	                        _context22.t0 = _context22["catch"](2);
	                        error = _context22.t0;
	                        _this12.setLog("Switching a video device failed: ".concat(_context22.t0), LOG_LEVEL.ERROR);
	                        if (!babelHelpers.classPrivateFieldGet(_this12, _privateProperties).cameraStream) {
	                          babelHelpers.classPrivateFieldGet(_this12, _privateProperties).cameraStream = prevStream;
	                        }
	                      case 23:
	                        _context22.prev = 23;
	                        if (!babelHelpers.classPrivateFieldGet(_this12, _privateProperties).switchActiveVideoDevicePending) {
	                          _context22.next = 30;
	                          break;
	                        }
	                        _deviceId2 = babelHelpers.classPrivateFieldGet(_this12, _privateProperties).switchActiveVideoDevicePending;
	                        babelHelpers.classPrivateFieldGet(_this12, _privateProperties).switchActiveVideoDevicePending = null;
	                        resolve(_this12.switchActiveVideoDevice(_deviceId2, true));
	                        _context22.next = 33;
	                        break;
	                      case 30:
	                        fulfilled = true;
	                        babelHelpers.classPrivateFieldGet(_this12, _privateProperties).switchActiveVideoDeviceInProgress = null;
	                        return _context22.abrupt("return", error ? reject(error) : resolve());
	                      case 33:
	                        return _context22.finish(23);
	                      case 34:
	                      case "end":
	                        return _context22.stop();
	                    }
	                  }, _callee22, null, [[2, 18, 23, 34]]);
	                }));
	                return function (_x19, _x20) {
	                  return _ref4.apply(this, arguments);
	                };
	              }());
	              if (!force && !fulfilled) {
	                babelHelpers.classPrivateFieldGet(this, _privateProperties).switchActiveVideoDeviceInProgress = promise;
	              }
	              return _context23.abrupt("return", promise);
	            case 9:
	            case "end":
	              return _context23.stop();
	          }
	        }, _callee23, this);
	      }));
	      function switchActiveVideoDevice(_x17, _x18) {
	        return _switchActiveVideoDevice.apply(this, arguments);
	      }
	      return switchActiveVideoDevice;
	    }()
	  }, {
	    key: "isAudioPublished",
	    value: function isAudioPublished() {
	      var _babelHelpers$classPr20;
	      return babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[MediaStreamsKinds.Microphone] && ((_babelHelpers$classPr20 = babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[MediaStreamsKinds.Microphone]) === null || _babelHelpers$classPr20 === void 0 ? void 0 : _babelHelpers$classPr20.muted) !== true;
	    }
	  }, {
	    key: "isVideoPublished",
	    value: function isVideoPublished() {
	      var _babelHelpers$classPr21;
	      return babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[MediaStreamsKinds.Camera] && ((_babelHelpers$classPr21 = babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks[MediaStreamsKinds.Camera]) === null || _babelHelpers$classPr21 === void 0 ? void 0 : _babelHelpers$classPr21.muted) !== true;
	    }
	  }, {
	    key: "getParticipants",
	    value: function getParticipants() {
	      return babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants;
	    }
	  }, {
	    key: "getState",
	    value: function getState() {
	      return babelHelpers.classPrivateFieldGet(this, _privateProperties).callState;
	    }
	  }, {
	    key: "setLog",
	    value: function setLog(log, level) {
	      level = LOG_LEVEL[level] || LOG_LEVEL.info;
	      if (babelHelpers.classPrivateFieldGet(this, _privateProperties).isloggingEnable) {
	        var _window$BXDesktopSyst, _window$BXDesktopSyst2;
	        var desktopVersion = (_window$BXDesktopSyst = window['BXDesktopSystem']) === null || _window$BXDesktopSyst === void 0 ? void 0 : (_window$BXDesktopSyst2 = _window$BXDesktopSyst.ApiVersion) === null || _window$BXDesktopSyst2 === void 0 ? void 0 : _window$BXDesktopSyst2.call(_window$BXDesktopSyst);
	        var version = babelHelpers.classPrivateFieldGet(this, _privateProperties).clientVersion + (desktopVersion ? " (desktopApi: ".concat(desktopVersion, ")") : '');
	        var data = {
	          timestamp: Math.floor(Date.now() / 1000),
	          event: log,
	          client: babelHelpers.classPrivateFieldGet(this, _privateProperties).clientPlatform,
	          appVersion: version
	        };
	        var logLength = Object.values(babelHelpers.classPrivateFieldGet(this, _privateProperties).logs).length;
	        babelHelpers.classPrivateFieldGet(this, _privateProperties).logs[logLength] = {
	          level: level,
	          data: data
	        };
	        var lastSentLog = 0;
	        for (var index in babelHelpers.classPrivateFieldGet(this, _privateProperties).logs) {
	          if (!_classPrivateMethodGet(this, _sendLog, _sendLog2).call(this, babelHelpers.classPrivateFieldGet(this, _privateProperties).logs[index].data, babelHelpers.classPrivateFieldGet(this, _privateProperties).logs[index].level)) {
	            break;
	          }
	          lastSentLog = index;
	        }
	        if (lastSentLog) {
	          babelHelpers.classPrivateFieldGet(this, _privateProperties).logs = Object.values(babelHelpers.classPrivateFieldGet(this, _privateProperties).logs).slice(lastSentLog + 1);
	        }
	        if (babelHelpers.classPrivateFieldGet(this, _privateProperties).loggerCallback) {
	          babelHelpers.classPrivateFieldGet(this, _privateProperties).loggerCallback();
	        }
	      }
	    }
	  }, {
	    key: "setLoggerCallback",
	    value: function setLoggerCallback(callback) {
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).loggerCallback = callback;
	    }
	  }, {
	    key: "enableSilentLogging",
	    value: function enableSilentLogging(enable) {
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).isloggingEnable = enable;
	    }
	  }, {
	    key: "isMediaMutedBySystem",
	    get: function get() {
	      return babelHelpers.classPrivateFieldGet(this, _privateProperties).mediaMutedBySystem;
	    }
	  }]);
	  return Call;
	}();
	function _reconnect2() {
	  var _this13 = this;
	  babelHelpers.classPrivateFieldGet(this, _privateProperties).isReconnecting = true;
	  babelHelpers.classPrivateFieldGet(this, _privateProperties).videoQueue = VIDEO_QUEUE.INITIAL;
	  var reconnect = function reconnect() {
	    var reconnectionDelay = babelHelpers.classPrivateFieldGet(_this13, _privateProperties).lastReconnectionReason !== ReconnectionReason.JoinResponseError ? babelHelpers.classPrivateFieldGet(_this13, _privateProperties).fastReconnectionDelay : babelHelpers.classPrivateFieldGet(_this13, _privateProperties).reconnectionDelay;
	    _this13.setLog("Reconnecting attempt: ".concat(++babelHelpers.classPrivateFieldGet(_this13, _privateProperties).reconnectionAttempt), LOG_LEVEL.WARNING);
	    babelHelpers.classPrivateFieldGet(_this13, _privateProperties).reconnectionTimeout = setTimeout(_this13.connect.bind(_this13), reconnectionDelay);
	  };
	  reconnect();
	  this.checkQosFeatureAndExecutionCallback(function () {
	    _this13.addMonitoringEvents({
	      name: MONITORING_EVENTS_NAME_LIST.USER_RECONNECTED,
	      withCounter: true
	    });
	  });
	  this.triggerEvents('Reconnecting');
	}
	function _beforeDisconnect2() {
	  window.removeEventListener('unload', this.sendLeaveBound);
	  _classPrivateMethodGet(this, _clearPingInterval, _clearPingInterval2).call(this);
	  _classPrivateMethodGet(this, _clearPingTimeout, _clearPingTimeout2).call(this);
	  clearInterval(babelHelpers.classPrivateFieldGet(this, _privateProperties).callStatsInterval);
	  babelHelpers.classPrivateFieldGet(this, _privateProperties).localTracks = {};
	  babelHelpers.classPrivateFieldGet(this, _privateProperties).isWaitAnswer = false;
	  if (babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect) {
	    babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect.onmessage = null;
	    babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect.onopen = null;
	    babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect.onerror = null;
	    babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect.onclose = null;
	    babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect.close();
	    babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect = null;
	  }
	}
	function _resetPingTimeout2() {
	  var _this14 = this;
	  _classPrivateMethodGet(this, _clearPingTimeout, _clearPingTimeout2).call(this);
	  if (!babelHelpers.classPrivateFieldGet(this, _privateProperties).pingTimeoutDuration) {
	    return;
	  }
	  babelHelpers.classPrivateFieldGet(this, _privateProperties).pingTimeout = setTimeout(function () {
	    _this14.setLog('Ping signal was not received, reconnecting', LOG_LEVEL.WARNING);
	    _classPrivateMethodGet(_this14, _beforeDisconnect, _beforeDisconnect2).call(_this14);
	    babelHelpers.classPrivateFieldGet(_this14, _privateProperties).lastReconnectionReason = ReconnectionReason.PingPongMissed;
	    _classPrivateMethodGet(_this14, _reconnect, _reconnect2).call(_this14);
	  }, babelHelpers.classPrivateFieldGet(this, _privateProperties).pingTimeoutDuration);
	}
	function _clearPingTimeout2() {
	  if (babelHelpers.classPrivateFieldGet(this, _privateProperties).pingTimeout) {
	    clearTimeout(babelHelpers.classPrivateFieldGet(this, _privateProperties).pingTimeout);
	  }
	}
	function _startPingInterval2() {
	  var _this15 = this;
	  _classPrivateMethodGet(this, _clearPingInterval, _clearPingInterval2).call(this);
	  _classPrivateMethodGet(this, _resetPingTimeout, _resetPingTimeout2).call(this);
	  if (!babelHelpers.classPrivateFieldGet(this, _privateProperties).pingIntervalDuration) {
	    return;
	  }
	  babelHelpers.classPrivateFieldGet(this, _privateProperties).pingPongInterval = setInterval(function () {
	    _classPrivateMethodGet(_this15, _sendPing, _sendPing2).call(_this15);
	  }, babelHelpers.classPrivateFieldGet(this, _privateProperties).pingIntervalDuration);
	}
	function _clearPingInterval2() {
	  _classPrivateMethodGet(this, _clearPingTimeout, _clearPingTimeout2).call(this);
	  if (babelHelpers.classPrivateFieldGet(this, _privateProperties).pingPongInterval) {
	    clearInterval(babelHelpers.classPrivateFieldGet(this, _privateProperties).pingPongInterval);
	  }
	}
	function _sendPing2() {
	  _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	    pingReq: {
	      timestamp: Date.now(),
	      rtt: babelHelpers.classPrivateFieldGet(this, _privateProperties).rtt
	    }
	  });
	}
	function _addPendingPublication2(trackId, source) {
	  var _this16 = this;
	  babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingPublications[trackId] = setTimeout(function () {
	    delete babelHelpers.classPrivateFieldGet(_this16, _privateProperties).pendingPublications[trackId];
	    _this16.onPublishFailed(source);
	  }, babelHelpers.classPrivateFieldGet(this, _privateProperties).publicationTimeout);
	}
	function _addPendingSubscription2(participant, track, tries) {
	  var _babelHelpers$classPr22,
	    _babelHelpers$classPr23,
	    _this17 = this;
	  clearTimeout((_babelHelpers$classPr22 = babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions[participant.userId]) === null || _babelHelpers$classPr22 === void 0 ? void 0 : (_babelHelpers$classPr23 = _babelHelpers$classPr22[track.sid]) === null || _babelHelpers$classPr23 === void 0 ? void 0 : _babelHelpers$classPr23.timeout);
	  if (!babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions[participant.userId]) {
	    babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions[participant.userId] = {};
	  }
	  if (tries === undefined) {
	    tries = babelHelpers.classPrivateFieldGet(this, _privateProperties).subscriptionTries;
	  }
	  var timeout = setTimeout(function () {
	    _this17.setLog("Track ".concat(track.sid, " with kind ").concat(track.source, " for a participant with id ").concat(participant.userId, " (sid: ").concat(participant.sid, ") was not received, trying to subscribe to it"), LOG_LEVEL.WARNING);
	    _this17.checkQosFeatureAndExecutionCallback(function () {
	      _this17.addMonitoringEvents({
	        name: MONITORING_EVENTS_NAME_LIST.TRACK_SUBSCRIPTION_DELAY,
	        withCounter: true
	      });
	    });
	    if (tries) {
	      _classPrivateMethodGet(_this17, _addPendingSubscription, _addPendingSubscription2).call(_this17, participant, track, tries - 1);
	      _classPrivateMethodGet(_this17, _changeSubscriptionToTrack, _changeSubscriptionToTrack2).call(_this17, track.sid, participant.sid, true);
	    } else {
	      _this17.setLog("Subscription to track ".concat(track.sid, " with kind ").concat(track.source, " for a participant with id ").concat(participant.userId, " (sid: ").concat(participant.sid, ") failed"), LOG_LEVEL.ERROR);
	      _this17.checkQosFeatureAndExecutionCallback(function () {
	        _this17.addMonitoringEvents({
	          name: MONITORING_EVENTS_NAME_LIST.TRACK_SUBSCRIPTION_FAILED,
	          withCounter: true
	        });
	      });
	    }
	  }, babelHelpers.classPrivateFieldGet(this, _privateProperties).subscriptionTimeout);
	  babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions[participant.userId][track.sid] = {
	    timeout: timeout,
	    tries: tries
	  };
	}
	function _getMaxEncodingsByVideoWidth2(width) {
	  // https://source.chromium.org/chromium/chromium/src/+/main:third_party/webrtc/video/config/simulcast.cc;l=76;
	  if (width >= 960) {
	    return 3;
	  } else if (width >= 480) {
	    return 2;
	  }
	  return 1;
	}
	function _getEncodingsFromVideoWidth2(width) {
	  var maxEncodings = _classPrivateMethodGet(this, _getMaxEncodingsByVideoWidth, _getMaxEncodingsByVideoWidth2).call(this, width);
	  var rids = ['q', 'h', 'f'];
	  var encodings = [];
	  for (var i = 0; i < 3; i++) {
	    var rid = rids[i];
	    encodings.push({
	      rid: rid,
	      active: i < maxEncodings,
	      maxBitrate: babelHelpers.classPrivateFieldGet(this, _privateProperties).defaultSimulcastBitrate[rid],
	      scaleResolutionDownBy: Math.pow(2, Math.max(0, maxEncodings - 1 - i))
	    });
	  }
	  return encodings;
	}
	function _getLayersFromEncodings2(width, height, encodings) {
	  var _this18 = this;
	  return encodings.map(function (encoding, index) {
	    return {
	      quality: index,
	      width: width / encoding.scaleResolutionDownBy,
	      height: height / encoding.scaleResolutionDownBy,
	      bitrate: babelHelpers.classPrivateFieldGet(_this18, _privateProperties).defaultSimulcastBitrate[encoding.rid]
	    };
	  });
	}
	function _updateVideoEncodings2(sender, track) {
	  var params = sender.getParameters();
	  var width = track.getSettings().width;
	  var encodings = _classPrivateMethodGet(this, _getEncodingsFromVideoWidth, _getEncodingsFromVideoWidth2).call(this, width);
	  if (params && params.encodings && params.encodings.length) {
	    params.encodings.forEach(function (encoding) {
	      var encodingByRid = encodings.find(function (el) {
	        return el.rid === encoding.rid;
	      });
	      if (encodingByRid) {
	        encoding.active = encodingByRid.active;
	        encoding.maxBitrate = encodingByRid.maxBitrate;
	        encoding.scaleResolutionDownBy = encodingByRid.scaleResolutionDownBy;
	      }
	    });
	    sender.setParameters(params);
	  }
	}
	function _changeSubscriptionToTrack2(trackId, participantId, subscribe) {
	  _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	    subscription: {
	      trackSids: [trackId],
	      subscribe: subscribe,
	      participantTracks: [{
	        participantSid: participantId,
	        trackSids: [trackId]
	      }]
	    }
	  });
	}
	function _pauseRemoteTrack2(userId, trackId, trackSource, pause) {
	  var participant = babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[userId];
	  if (!participant) {
	    this.setLog("Trying to pause a track with kind ".concat(trackSource, " (sid: ").concat(trackId, ") for a non-existent participant with id ").concat(userId), LOG_LEVEL.WARNING);
	    return;
	  }
	  participant.videoPaused = pause;
	  _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	    trackSetting: {
	      trackSids: [trackId],
	      disabled: pause,
	      quality: _classPrivateMethodGet(this, _calculateVideoQualityForUser, _calculateVideoQualityForUser2).call(this, userId, trackSource)
	    }
	  });
	}
	function _calculateVideoQualityForUser2(userId, source) {
	  var participant = babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[userId];
	  var exactUser = babelHelpers.classPrivateFieldGet(this, _privateProperties).mainStream.userId == userId;
	  var exactTrack = babelHelpers.classPrivateFieldGet(this, _privateProperties).mainStream.kind === source;
	  var quality = STREAM_QUALITY.LOW;
	  if (exactUser && (exactTrack || !participant.screenSharingEnabled)) {
	    quality = STREAM_QUALITY.HIGH;
	  } else if (!babelHelpers.classPrivateFieldGet(this, _privateProperties).mainStream.userId) {
	    quality = babelHelpers.classPrivateFieldGet(this, _privateProperties).defaultRemoteStreamsQuality;
	  }
	  return quality;
	}
	function _changeRoomStreamsQuality2(userId, kind) {
	  var _this19 = this;
	  this.setLog("Start changing a streams quality", LOG_LEVEL.INFO);
	  Object.values(this.getParticipants()).forEach(function (p) {
	    var quality = babelHelpers.classPrivateFieldGet(_this19, _privateProperties).defaultRemoteStreamsQuality;
	    if (userId) {
	      var exactUser = userId == p.userId;
	      quality = exactUser && kind === MediaStreamsKinds.Camera ? STREAM_QUALITY.HIGH : STREAM_QUALITY.MEDIUM;
	      if (exactUser) {
	        babelHelpers.classPrivateFieldGet(_this19, _privateProperties).mainStream = {
	          userId: userId,
	          kind: kind
	        };
	      }
	    } else {
	      babelHelpers.classPrivateFieldGet(_this19, _privateProperties).mainStream = {};
	    }
	    p.setStreamQuality(quality);
	    _this19.setLog("Quality of video for a participant with id ".concat(p.userId, " (sid: ").concat(p.sid, ") was changed to ").concat(quality), LOG_LEVEL.INFO);
	  });
	}
	function _toggleRemoteParticipantVideo2(participantIds, showVideo) {
	  var _this20 = this;
	  var isPaginateToggle = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	  participantIds.forEach(function (participantId) {
	    var remoteParticipant = babelHelpers.classPrivateFieldGet(_this20, _privateProperties).remoteParticipants[participantId];
	    if (remoteParticipant && remoteParticipant.tracks[MediaStreamsKinds.Camera] && remoteParticipant.isLocalVideoMute === showVideo) {
	      remoteParticipant.isLocalVideoMute = !showVideo;
	      if (remoteParticipant.isMutedVideo) {
	        return;
	      }
	      _classPrivateMethodGet(_this20, _pauseRemoteTrack, _pauseRemoteTrack2).call(_this20, remoteParticipant.userId, remoteParticipant.tracks[MediaStreamsKinds.Camera].id, remoteParticipant.tracks[MediaStreamsKinds.Camera].source, remoteParticipant.isLocalVideoMute);
	    }
	  });
	  if (!isPaginateToggle) {
	    this.triggerEvents('ToggleRemoteParticipantVideo', [showVideo]);
	  }
	}
	function _processVideoQueue2() {
	  var _babelHelpers$classPr24, _babelHelpers$classPr25;
	  var videoQueue = babelHelpers.classPrivateFieldGet(this, _privateProperties).videoQueue;
	  babelHelpers.classPrivateFieldGet(this, _privateProperties).videoQueue = VIDEO_QUEUE.INITIAL;
	  if (videoQueue === VIDEO_QUEUE.ENABLE && ((_babelHelpers$classPr24 = babelHelpers.classPrivateFieldGet(this, _privateProperties).cameraStream) === null || _babelHelpers$classPr24 === void 0 ? void 0 : _babelHelpers$classPr24.getVideoTracks()[0].readyState) !== 'live') {
	    this.enableVideo();
	  } else if (videoQueue === VIDEO_QUEUE.DISABLE && ((_babelHelpers$classPr25 = babelHelpers.classPrivateFieldGet(this, _privateProperties).cameraStream) === null || _babelHelpers$classPr25 === void 0 ? void 0 : _babelHelpers$classPr25.getVideoTracks()[0].readyState) === 'live' && !babelHelpers.classPrivateFieldGet(this, _privateProperties).mediaMutedBySystem) {
	    this.disableVideo();
	  }
	}
	function _getUserMedia2(_x21) {
	  return _getUserMedia3.apply(this, arguments);
	}
	function _getUserMedia3() {
	  _getUserMedia3 = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee26(options) {
	    var _this28 = this;
	    var fallbackMode,
	      constraints,
	      stream,
	      _args26 = arguments;
	    return _regeneratorRuntime().wrap(function _callee26$(_context26) {
	      while (1) switch (_context26.prev = _context26.next) {
	        case 0:
	          fallbackMode = _args26.length > 1 && _args26[1] !== undefined ? _args26[1] : false;
	          this.triggerEvents('GetUserMediaStarted', [options]);
	          this.setLog("Start getting user media with options: ".concat(JSON.stringify(options)), LOG_LEVEL.INFO);
	          constraints = {
	            audio: false,
	            video: false
	          };
	          stream = null;
	          _context26.prev = 5;
	          if (options.video) {
	            constraints.video = {};
	            if (!fallbackMode) {
	              constraints.video.width = {
	                ideal: babelHelpers.classPrivateFieldGet(this, _privateProperties).defaultVideoResolution.width
	              };
	              constraints.video.height = {
	                ideal: babelHelpers.classPrivateFieldGet(this, _privateProperties).defaultVideoResolution.height
	              };
	            }
	            if (babelHelpers.classPrivateFieldGet(this, _privateProperties).videoDeviceId) {
	              constraints.video.deviceId = {
	                exact: babelHelpers.classPrivateFieldGet(this, _privateProperties).videoDeviceId
	              };
	            }
	          } else if (options.audio) {
	            if (babelHelpers.classPrivateFieldGet(this, _privateProperties).audioDeviceId) {
	              constraints.audio = {
	                deviceId: {
	                  exact: babelHelpers.classPrivateFieldGet(this, _privateProperties).audioDeviceId
	                }
	              };
	            } else {
	              constraints.audio = true;
	            }
	          }
	          _context26.next = 9;
	          return navigator.mediaDevices.getUserMedia(constraints);
	        case 9:
	          stream = _context26.sent;
	          if (options.video && stream.getVideoTracks()[0]) {
	            this.triggerEvents('GetUserMediaSuccess', [{
	              video: true
	            }]);
	          }
	          if (options.audio && stream.getAudioTracks()[0]) {
	            this.triggerEvents('GetUserMediaSuccess', [{
	              audio: true
	            }]);
	          }
	          if (options.video) {
	            _classPrivateMethodGet(this, _addTrackMuteHandlers, _addTrackMuteHandlers2).call(this, stream.getVideoTracks()[0]);
	          }
	          this.setLog("Getting user media with constraints: ".concat(JSON.stringify(constraints), " succeeded"), LOG_LEVEL.INFO);
	          _context26.next = 28;
	          break;
	        case 16:
	          _context26.prev = 16;
	          _context26.t0 = _context26["catch"](5);
	          if (!options.video) {
	            _context26.next = 25;
	            break;
	          }
	          this.setLog("Getting user media with constraints: ".concat(JSON.stringify(constraints), " failed (fallbackMode: ").concat(fallbackMode, "): ").concat(_context26.t0), LOG_LEVEL.ERROR);
	          if (fallbackMode) {
	            _context26.next = 25;
	            break;
	          }
	          this.checkQosFeatureAndExecutionCallback(function () {
	            _this28.addMonitoringEvents({
	              name: MONITORING_EVENTS_NAME_LIST.LOCAL_VIDEO_STREAM_RECEIVING_FAILED,
	              withCounter: true
	            });
	          });
	          _context26.next = 24;
	          return _classPrivateMethodGet(this, _getUserMedia, _getUserMedia2).call(this, options, true);
	        case 24:
	          stream = _context26.sent;
	        case 25:
	          if (options.audio) {
	            this.checkQosFeatureAndExecutionCallback(function () {
	              _this28.addMonitoringEvents({
	                name: MONITORING_EVENTS_NAME_LIST.LOCAL_MICROPHONE_STREAM_RECEIVING_FAILED,
	                withCounter: true
	              });
	            });
	          }
	          this.setLog("Getting user media with constraints: ".concat(JSON.stringify(constraints), " failed: ").concat(_context26.t0), LOG_LEVEL.ERROR);
	          this.checkQosFeatureAndExecutionCallback(function () {
	            _this28.addMonitoringEvents({
	              name: MONITORING_EVENTS_NAME_LIST.GET_LOCAL_TRACK_ERROR,
	              value: {
	                type: 'main'
	              }
	            });
	          });
	        case 28:
	          _context26.prev = 28;
	          this.triggerEvents('GetUserMediaEnded');
	          return _context26.abrupt("return", stream);
	        case 32:
	        case "end":
	          return _context26.stop();
	      }
	    }, _callee26, this, [[5, 16, 28, 32]]);
	  }));
	  return _getUserMedia3.apply(this, arguments);
	}
	function _getDisplayMedia2() {
	  return _getDisplayMedia3.apply(this, arguments);
	}
	function _getDisplayMedia3() {
	  _getDisplayMedia3 = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee27() {
	    var _this29 = this;
	    var stream;
	    return _regeneratorRuntime().wrap(function _callee27$(_context27) {
	      while (1) switch (_context27.prev = _context27.next) {
	        case 0:
	          this.setLog('Start getting display media', LOG_LEVEL.INFO);
	          stream = null;
	          _context27.prev = 2;
	          if (!(window["BXDesktopSystem"] && window["BXDesktopSystem"].GetProperty('versionParts')[3] < 78)) {
	            _context27.next = 9;
	            break;
	          }
	          _context27.next = 6;
	          return navigator.mediaDevices.getUserMedia({
	            video: {
	              mandatory: {
	                chromeMediaSource: 'screen',
	                maxWidth: 1920,
	                maxHeight: 1080,
	                maxFrameRate: 5
	              }
	            }
	          });
	        case 6:
	          stream = _context27.sent;
	          _context27.next = 12;
	          break;
	        case 9:
	          _context27.next = 11;
	          return navigator.mediaDevices.getDisplayMedia({
	            video: {
	              cursor: 'always',
	              width: {
	                ideal: 1920
	              },
	              height: {
	                ideal: 1080
	              }
	            },
	            systemAudio: "include",
	            audio: true
	          });
	        case 11:
	          stream = _context27.sent;
	        case 12:
	          this.setLog('Getting display media succeeded', LOG_LEVEL.INFO);
	          _context27.next = 19;
	          break;
	        case 15:
	          _context27.prev = 15;
	          _context27.t0 = _context27["catch"](2);
	          this.setLog("Getting display media failed: ".concat(_context27.t0), LOG_LEVEL.ERROR);
	          this.checkQosFeatureAndExecutionCallback(function () {
	            _this29.addMonitoringEvents({
	              name: MONITORING_EVENTS_NAME_LIST.LOCAL_SCREEN_STREAM_RECEIVING_FAILED,
	              withCounter: true
	            });
	          });
	        case 19:
	          _context27.prev = 19;
	          return _context27.abrupt("return", stream);
	        case 22:
	        case "end":
	          return _context27.stop();
	      }
	    }, _callee27, this, [[2, 15, 19, 22]]);
	  }));
	  return _getDisplayMedia3.apply(this, arguments);
	}
	function _addTrackMuteHandlers2(track) {
	  var _this21 = this;
	  track.onmute = function (event) {
	    babelHelpers.classPrivateFieldGet(_this21, _privateProperties).mediaMutedBySystem = false;
	    _this21.disableVideo(true);
	    _this21.disableAudio(true);
	    babelHelpers.classPrivateFieldGet(_this21, _privateProperties).mediaMutedBySystem = true;
	    _this21.triggerEvents('MediaMutedBySystem', [true]);
	  };
	  track.onunmute = function (event) {
	    if (babelHelpers.classPrivateFieldGet(_this21, _privateProperties).mediaMutedBySystem) {
	      babelHelpers.classPrivateFieldGet(_this21, _privateProperties).mediaMutedBySystem = false;
	      _this21.triggerEvents('MediaMutedBySystem', [false]);
	    }
	    _this21.enableVideo();
	    if (babelHelpers.classPrivateFieldGet(_this21, _privateProperties).needToEnableAudioAfterSystemMuted) {
	      _this21.enableAudio();
	    }
	  };
	}
	function _sendLog2(log, level) {
	  var signal = {
	    sendLog: {
	      userName: "".concat(babelHelpers.classPrivateFieldGet(this, _privateProperties).userId),
	      data: JSON.stringify(log),
	      msgLevel: level
	    }
	  };
	  return this.isConnected() ? _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, signal) : false;
	}
	function _removeUdpFromSdp2(sdp) {
	  var updatedSdp = [];
	  sdp.split(/(\r\n|\r|\n)/).filter(RegExp.prototype.test.bind(/^([a-z])=(.*)/)).forEach(function (el) {
	    if (!el.startsWith('a=candidate') || el.includes('tcp')) {
	      updatedSdp.push(el);
	    }
	  });
	  sdp = updatedSdp.join('\r\n') + '\r\n';
	  return sdp;
	}
	function _answerHandler2(_x22) {
	  return _answerHandler3.apply(this, arguments);
	}
	function _answerHandler3() {
	  _answerHandler3 = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee28(data) {
	    var _this30 = this;
	    var hasError;
	    return _regeneratorRuntime().wrap(function _callee28$(_context28) {
	      while (1) switch (_context28.prev = _context28.next) {
	        case 0:
	          this.setLog('Start handling a remote answer', LOG_LEVEL.INFO);
	          hasError = false;
	          _context28.prev = 2;
	          if (Util.useTcpSdp()) {
	            data.answer.sdp = _classPrivateMethodGet(this, _removeUdpFromSdp, _removeUdpFromSdp2).call(this, data.answer.sdp);
	          }
	          _context28.next = 6;
	          return this.sender.setRemoteDescription(data.answer);
	        case 6:
	          babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingCandidates.sender.forEach(function (candidate) {
	            _this30.sender.addIceCandidate(candidate);
	            _this30.setLog('Added a deferred ICE candidate', LOG_LEVEL.INFO);
	          });
	          babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingCandidates.sender = [];
	          _context28.next = 17;
	          break;
	        case 10:
	          _context28.prev = 10;
	          _context28.t0 = _context28["catch"](2);
	          this.setLog("Handling a remote answer failed: ".concat(_context28.t0), LOG_LEVEL.ERROR);
	          hasError = true;
	          _classPrivateMethodGet(this, _beforeDisconnect, _beforeDisconnect2).call(this);
	          _classPrivateMethodGet(this, _reconnect, _reconnect2).call(this);
	          this.checkQosFeatureAndExecutionCallback(function () {
	            _this30.addMonitoringEvents({
	              name: MONITORING_EVENTS_NAME_LIST.PEER_CONNECTION_ISSUES,
	              value: 1
	            });
	          });
	        case 17:
	          _context28.prev = 17;
	          if (hasError) {
	            _context28.next = 23;
	            break;
	          }
	          this.setLog('Handling a remote answer succeeded', LOG_LEVEL.INFO);
	          babelHelpers.classPrivateFieldGet(this, _privateProperties).isWaitAnswer = false;
	          _context28.next = 23;
	          return this.sendOffer();
	        case 23:
	          return _context28.finish(17);
	        case 24:
	        case "end":
	          return _context28.stop();
	      }
	    }, _callee28, this, [[2, 10, 17, 24]]);
	  }));
	  return _answerHandler3.apply(this, arguments);
	}
	function _offerHandler2(_x23) {
	  return _offerHandler3.apply(this, arguments);
	}
	function _offerHandler3() {
	  _offerHandler3 = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee29(data) {
	    var _this31 = this;
	    var answer;
	    return _regeneratorRuntime().wrap(function _callee29$(_context29) {
	      while (1) switch (_context29.prev = _context29.next) {
	        case 0:
	          this.setLog('Handling a remote offer', LOG_LEVEL.INFO);
	          _context29.prev = 1;
	          if (Util.useTcpSdp()) {
	            data.offer.sdp = _classPrivateMethodGet(this, _removeUdpFromSdp, _removeUdpFromSdp2).call(this, data.offer.sdp);
	          }
	          _context29.next = 5;
	          return this.recipient.setRemoteDescription(data.offer);
	        case 5:
	          babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingCandidates.recipient.forEach(function (candidate) {
	            _this31.recipient.addIceCandidate(candidate);
	            _this31.setLog('Added a deferred ICE candidate', LOG_LEVEL.INFO);
	          });
	          babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingCandidates.recipient = [];
	          _context29.next = 9;
	          return this.recipient.createAnswer();
	        case 9:
	          answer = _context29.sent;
	          if (Util.useTcpSdp()) {
	            answer = {
	              type: answer.type,
	              sdp: _classPrivateMethodGet(this, _removeUdpFromSdp, _removeUdpFromSdp2).call(this, answer.sdp)
	            };
	          }
	          _context29.next = 13;
	          return this.recipient.setLocalDescription(answer);
	        case 13:
	          _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	            answer: answer
	          });
	          this.setLog('Handling a remote offer succeeded', LOG_LEVEL.INFO);
	          _context29.next = 23;
	          break;
	        case 17:
	          _context29.prev = 17;
	          _context29.t0 = _context29["catch"](1);
	          this.setLog("Handling a remote offer failed: ".concat(_context29.t0), LOG_LEVEL.ERROR);
	          _classPrivateMethodGet(this, _beforeDisconnect, _beforeDisconnect2).call(this);
	          _classPrivateMethodGet(this, _reconnect, _reconnect2).call(this);
	          this.checkQosFeatureAndExecutionCallback(function () {
	            _this31.addMonitoringEvents({
	              name: MONITORING_EVENTS_NAME_LIST.PEER_CONNECTION_ISSUES,
	              value: 2
	            });
	          });
	        case 23:
	        case "end":
	          return _context29.stop();
	      }
	    }, _callee29, this, [[1, 17]]);
	  }));
	  return _offerHandler3.apply(this, arguments);
	}
	function _addIceCandidate2(trickle) {
	  var _this22 = this;
	  this.setLog('Start adding an ICE candidate', LOG_LEVEL.INFO);
	  try {
	    var candidate = JSON.parse(trickle.candidateInit);
	    if (Util.useTcpSdp() && !candidate.candidate.includes('tcp')) {
	      return;
	    }
	    if (trickle.target) {
	      if (this.recipient.remoteDescription) {
	        this.recipient.addIceCandidate(candidate);
	        this.setLog('Adding an ICE candidate succeeded', LOG_LEVEL.INFO);
	        return;
	      }
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingCandidates.recipient.push(candidate);
	      this.setLog('Adding an ICE candidate deferred: has no remote description', LOG_LEVEL.INFO);
	    } else {
	      if (this.sender.remoteDescription) {
	        this.sender.addIceCandidate(candidate);
	        this.setLog('Adding an ICE candidate succeeded', LOG_LEVEL.INFO);
	        return;
	      }
	      babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingCandidates.sender.push(candidate);
	      this.setLog('Adding an ICE candidate deferred: has no remote description', LOG_LEVEL.INFO);
	    }
	  } catch (e) {
	    this.setLog("Adding an ICE candidate failed: ".concat(e), LOG_LEVEL.ERROR);
	    this.checkQosFeatureAndExecutionCallback(function () {
	      _this22.addMonitoringEvents({
	        name: MONITORING_EVENTS_NAME_LIST.PEER_CONNECTION_ISSUES,
	        value: 3
	      });
	    });
	  }
	}
	function _setRemoteParticipant2(participant) {
	  var _this23 = this;
	  var userId = participant.userId;
	  var participantEvent = babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[userId] ? 'ParticipantStateUpdated' : 'ParticipantJoined';
	  var remoteParticipant = new Participant(participant, babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect);
	  babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[userId] = remoteParticipant;
	  this.triggerEvents(participantEvent, [remoteParticipant]);
	  if (participant.participantTracks) {
	    Object.values(participant.participantTracks).forEach(function (track) {
	      track.userId = userId;
	      babelHelpers.classPrivateFieldGet(_this23, _privateProperties).tracksDataFromSocket[track.sid] = track;
	      if (track.muted && track.source === MediaStreamsKinds.Microphone) {
	        remoteParticipant.isMutedAudio = true;
	      }
	      if (track.muted && track.source === MediaStreamsKinds.Camera) {
	        remoteParticipant.isMutedVideo = true;
	      }
	      switch (track.source) {
	        case MediaStreamsKinds.Camera:
	          remoteParticipant.videoEnabled = true;
	          break;
	        case MediaStreamsKinds.Microphone:
	          remoteParticipant.audioEnabled = true;
	          break;
	        case MediaStreamsKinds.Screen:
	          remoteParticipant.screenSharingEnabled = true;
	          break;
	      }
	      _this23.setLog("A participant with id ".concat(userId, " (sid: ").concat(participant.sid, ") has a track info with kind ").concat(track.source, " (sid: ").concat(track.sid, ", waiting for it"), LOG_LEVEL.INFO);
	      var ontrackData = babelHelpers.classPrivateFieldGet(_this23, _privateProperties).ontrackData[track.sid];
	      delete babelHelpers.classPrivateFieldGet(_this23, _privateProperties).ontrackData[track.sid];
	      if (ontrackData) {
	        _classPrivateMethodGet(_this23, _createRemoteTrack, _createRemoteTrack2).call(_this23, track.sid, ontrackData);
	      } else {
	        _classPrivateMethodGet(_this23, _addPendingSubscription, _addPendingSubscription2).call(_this23, participant, track);
	      }
	    });
	  }
	  if (babelHelpers.classPrivateFieldGet(this, _privateProperties).videoStreamSetupErrorList[userId]) {
	    var kindArray = babelHelpers.toConsumableArray(babelHelpers.classPrivateFieldGet(this, _privateProperties).videoStreamSetupErrorList[userId]);
	    delete babelHelpers.classPrivateFieldGet(this, _privateProperties).videoStreamSetupErrorList[userId];
	    kindArray.forEach(function (kind) {
	      _this23.setMainStream(userId, kind);
	    });
	  }
	}
	function _createRemoteTrack2(trackId, ontrackData) {
	  var _babelHelpers$classPr26,
	    _babelHelpers$classPr27,
	    _babelHelpers$classPr28,
	    _this24 = this;
	  var trackData = babelHelpers.classPrivateFieldGet(this, _privateProperties).tracksDataFromSocket[trackId];
	  var userId = trackData.userId;
	  var participant = babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteParticipants[userId];
	  var track = ontrackData.track;
	  var trackMuted = !!trackData.muted;
	  babelHelpers.classPrivateFieldGet(this, _privateProperties).realTracksIds[track.id] = trackId;
	  track.source = trackData.source;
	  track.layers = trackData.layers || null;
	  if (!((_babelHelpers$classPr26 = babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteTracks) !== null && _babelHelpers$classPr26 !== void 0 && _babelHelpers$classPr26[userId])) {
	    babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteTracks[userId] = {};
	  }
	  var remoteTrack = new Track(trackId, track);
	  babelHelpers.classPrivateFieldGet(this, _privateProperties).remoteTracks[userId][trackId] = remoteTrack;
	  if (remoteTrack.source === MediaStreamsKinds.Camera) {
	    participant.isMutedVideo = trackMuted;
	  } else if (remoteTrack.source === MediaStreamsKinds.Microphone) {
	    participant.isMutedAudio = trackMuted;
	    if (trackMuted) {
	      this.setLog("Trigger mute signal (".concat(trackMuted, ") for received audio from a participant with id ").concat(participant.userId, " (sid: ").concat(participant.sid, ")"), LOG_LEVEL.INFO);
	      this.triggerEvents('RemoteMediaMuted', [participant, remoteTrack]);
	    }
	  }
	  if ((_babelHelpers$classPr27 = babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions[userId]) !== null && _babelHelpers$classPr27 !== void 0 && (_babelHelpers$classPr28 = _babelHelpers$classPr27[trackId]) !== null && _babelHelpers$classPr28 !== void 0 && _babelHelpers$classPr28.timeout) {
	    clearTimeout(babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions[userId][trackId].timeout);
	    delete babelHelpers.classPrivateFieldGet(this, _privateProperties).pendingSubscriptions[userId][trackId];
	  }
	  this.setLog("Got an expected track with kind ".concat(remoteTrack.source, " (sid: ").concat(trackId, ") for a participant with id ").concat(participant.userId, " (sid: ").concat(participant.sid, ")"), LOG_LEVEL.INFO);
	  participant.addTrack(remoteTrack.source, remoteTrack);
	  if (remoteTrack.source !== MediaStreamsKinds.Camera || !participant.isMutedVideo) {
	    this.triggerEvents('RemoteMediaAdded', [participant, remoteTrack]);
	  }
	  if (remoteTrack.source === MediaStreamsKinds.Camera) {
	    var quality = _classPrivateMethodGet(this, _calculateVideoQualityForUser, _calculateVideoQualityForUser2).call(this, userId, remoteTrack.source);
	    this.setLog("Quality of video for a participant with id ".concat(participant.userId, " (sid: ").concat(participant.sid, ") was changed to ").concat(quality, " after receiving"), LOG_LEVEL.INFO);
	    participant.setStreamQuality(quality);
	  }
	  if (track.kind === 'video') {
	    var streamRemovingId = Util.getUuidv4();
	    participant.streamRemovingId = streamRemovingId;
	    ontrackData.streams[0].onremovetrack = function () {
	      // we need to check if a participant is still exists
	      // otherwise tracks were deleted when participant left room
	      var participant = babelHelpers.classPrivateFieldGet(_this24, _privateProperties).remoteParticipants[userId];
	      if ((participant === null || participant === void 0 ? void 0 : participant.streamRemovingId) === streamRemovingId) {
	        _this24.setLog("Track with kind ".concat(track.source, " (sid: ").concat(track.id, ") for a participant with id ").concat(userId, " (sid: ").concat(participant.sid || 'unknown', ") was removed from peer connection"), LOG_LEVEL.WARNING);
	        _this24.triggerEvents('RemoteMediaRemoved', [participant, remoteTrack]);
	      } else {
	        _this24.setLog("Track with kind ".concat(track.source, " (sid: ").concat(track.id, ") was removed from a disconnected participant with id ").concat(userId, " (sid: unknown) before it was removed from peer connection"), LOG_LEVEL.WARNING);
	      }
	    };
	  }
	}
	function _speakerChangedHandler2(data) {
	  var _this25 = this;
	  data.speakersChanged.speakers.forEach(function (speaker) {
	    var participant = Object.values(babelHelpers.classPrivateFieldGet(_this25, _privateProperties).remoteParticipants).find(function (p) {
	      return p.sid === speaker.sid;
	    });
	    if (participant && (participant === null || participant === void 0 ? void 0 : participant.userId) != babelHelpers.classPrivateFieldGet(_this25, _privateProperties).userId) {
	      participant.isSpeaking = (speaker === null || speaker === void 0 ? void 0 : speaker.active) || false;
	      if (speaker !== null && speaker !== void 0 && speaker.active) {
	        _this25.triggerEvents('VoiceStarted', [participant]);
	      } else {
	        _this25.triggerEvents('VoiceEnded', [participant]);
	      }
	    }
	  });
	}
	function _createPeerConnection2() {
	  var _this26 = this;
	  _classPrivateMethodGet(this, _destroyPeerConnection, _destroyPeerConnection2).call(this);
	  var config = {};
	  if (babelHelpers.classPrivateFieldGet(this, _privateProperties).iceServers) {
	    config.iceServers = babelHelpers.classPrivateFieldGet(this, _privateProperties).iceServers;
	  }
	  this.sender = new RTCPeerConnection(config);
	  this.sender.addEventListener('icecandidate', function (e) {
	    return _this26.onIceCandidate(null, e);
	  });
	  this.sender.addEventListener('connectionstatechange', function (e) {
	    return _this26.onConnectionStateChange();
	  });
	  this.recipient = new RTCPeerConnection(config);
	  this.recipient.ontrack = function (event) {
	    var _babelHelpers$classPr29;
	    var ids = event.streams[0].id.split('|');
	    var trackId = ids[1];
	    var userId = (_babelHelpers$classPr29 = babelHelpers.classPrivateFieldGet(_this26, _privateProperties).tracksDataFromSocket[trackId]) === null || _babelHelpers$classPr29 === void 0 ? void 0 : _babelHelpers$classPr29.userId;
	    if (babelHelpers.classPrivateFieldGet(_this26, _privateProperties).remoteParticipants[userId] && babelHelpers.classPrivateFieldGet(_this26, _privateProperties).tracksDataFromSocket[trackId]) {
	      _classPrivateMethodGet(_this26, _createRemoteTrack, _createRemoteTrack2).call(_this26, trackId, event);
	    } else {
	      _this26.setLog("Got a track with kind ".concat(event.track.kind, " (sid: ").concat(trackId, ") without a participant, saving it"), LOG_LEVEL.WARNING);
	      babelHelpers.classPrivateFieldGet(_this26, _privateProperties).ontrackData[trackId] = event;
	    }
	  };
	  this.recipient.addEventListener('icecandidate', function (e) {
	    return _this26.onIceCandidate('SUBSCRIBER', e);
	  });
	  this.recipient.addEventListener('connectionstatechange', function (e) {
	    return _this26.onConnectionStateChange(true);
	  });
	  var getStatsHandle = /*#__PURE__*/function () {
	    var _ref5 = babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee24() {
	      var statsAll, packetLostEventAdded;
	      return _regeneratorRuntime().wrap(function _callee24$(_context24) {
	        while (1) switch (_context24.prev = _context24.next) {
	          case 0:
	            _context24.prev = 0;
	            statsAll = {};
	            packetLostEventAdded = false;
	            _context24.next = 5;
	            return _this26.sender.getStats(null).then(function (stats) {
	              var statsOutput = [];
	              var codecs = {};
	              var reportsWithoutCodecs = {};
	              var remoteReports = {};
	              var reportsWithoutRemoteInfo = {};
	              var isQualityLimitationSent = false;
	              var totalBitrateOut = 0;
	              stats.forEach(function (report) {
	                statsOutput.push(report);
	                if (report.type === 'codec') {
	                  Util.processReportsWithoutCodecs(report, codecs, reportsWithoutCodecs);
	                }
	                if (report.type === 'remote-inbound-rtp') {
	                  var reportId = report.localId;
	                  if (reportsWithoutRemoteInfo[reportId]) {
	                    var packetsLostData = Util.calcLocalPacketsLost(reportsWithoutRemoteInfo[reportId], babelHelpers.classPrivateFieldGet(_this26, _privateProperties).reportsForOutgoingTracks[reportId], report);
	                    var currentPercentPacketLost = packetsLostData.currentPercentPacketLost;
	                    _this26.checkQosFeatureAndExecutionCallback(function () {
	                      _this26.currentMonitoringEventsObject.metrics.PACKET_LOST_SEND.push(currentPercentPacketLost);
	                    });
	                    if (!packetLostEventAdded && currentPercentPacketLost > babelHelpers.classPrivateFieldGet(_this26, _privateProperties).packetLostThreshold) {
	                      packetLostEventAdded = true;
	                      _this26.checkQosFeatureAndExecutionCallback(function () {
	                        _this26.addMonitoringEvents({
	                          name: MONITORING_EVENTS_NAME_LIST.HIGH_PACKET_LOSS_SEND,
	                          withCounter: true
	                        });
	                      });
	                    }
	                    reportsWithoutRemoteInfo[reportId].packetsLostData = packetsLostData;
	                    reportsWithoutRemoteInfo[reportId].packetsLost = packetsLostData.totalPacketsLost;
	                    reportsWithoutRemoteInfo[reportId].packetsLostExtended = Util.formatPacketsLostData(packetsLostData);
	                    babelHelpers.classPrivateFieldGet(_this26, _privateProperties).reportsForOutgoingTracks[reportId] = reportsWithoutRemoteInfo[reportId];
	                    delete reportsWithoutRemoteInfo[reportId];
	                    return;
	                  }
	                  remoteReports[report.localId] = report;
	                }
	                if (report.type === 'outbound-rtp') {
	                  report.bitrate = Util.calcBitrate(report, babelHelpers.classPrivateFieldGet(_this26, _privateProperties).reportsForOutgoingTracks[report.id], true);
	                  report.userId = babelHelpers.classPrivateFieldGet(_this26, _privateProperties).userId;
	                  if (report.kind === 'audio') {
	                    report.source = MediaStreamsKinds.Microphone;
	                  } else if (report.kind === 'video') {
	                    report.source = report.contentType === 'screenshare' ? MediaStreamsKinds.Screen : MediaStreamsKinds.Camera;
	                  }
	                  totalBitrateOut += report.bitrate;
	                  if (report.qualityLimitationReason && report.qualityLimitationReason !== 'none' && !isQualityLimitationSent) {
	                    _this26.checkQosFeatureAndExecutionCallback(function () {
	                      if (report.qualityLimitationReason === 'cpu') {
	                        _this26.addMonitoringEvents({
	                          name: MONITORING_EVENTS_NAME_LIST.CPU_ISSUES,
	                          withCounter: true
	                        });
	                      }
	                      if (report.qualityLimitationReason === 'bandwidth') {
	                        _this26.addMonitoringEvents({
	                          name: MONITORING_EVENTS_NAME_LIST.NETWORK_ISSUES,
	                          withCounter: true
	                        });
	                      }
	                    });
	                    isQualityLimitationSent = true;
	                    _this26.setLog("Local user have problems with sending video: ".concat(report.qualityLimitationReason, " (").concat(Object.entries(report.qualityLimitationDurations).reduce(function (accumulator, value, index) {
	                      return accumulator + "".concat(index ? ', ' : '') + "".concat(value[0], ": ").concat(value[1]);
	                    }, ''), ")"), LOG_LEVEL.WARNING);
	                  }
	                  if (!Util.setCodecToReport(report, codecs, reportsWithoutCodecs)) {
	                    Util.saveReportWithoutCodecs(report, reportsWithoutCodecs);
	                  }
	                  if (Util.setLocalPacketsLostOrSaveReport(report, remoteReports, reportsWithoutRemoteInfo)) {
	                    babelHelpers.classPrivateFieldGet(_this26, _privateProperties).reportsForOutgoingTracks[report.id] = report;
	                  }
	                }
	              });
	              _this26.checkQosFeatureAndExecutionCallback(function () {
	                var formattedBitrateOut = Number.parseFloat((totalBitrateOut / 1000000).toFixed(2));
	                if (_this26.currentMonitoringEventsObject.metrics.BITRATE_OUT.length < _this26.countMetricsInMetricsInterval) {
	                  _this26.currentMonitoringEventsObject.metrics.BITRATE_OUT.push(formattedBitrateOut);
	                }
	              });
	              statsAll.sender = statsOutput;
	            });
	          case 5:
	            _context24.next = 7;
	            return _this26.recipient.getStats(null).then(function (stats) {
	              var statsOutput = [];
	              var participantsWithLargeDataLoss = new Map();
	              var codecs = {};
	              var reportsWithoutCodecs = {};
	              var totalBitrateIn = 0;
	              var currentPacketLostReceiveCount = 0;
	              var inboundRtpStatsArray = {
	                freezeCount: [],
	                totalFreezesDuration: [],
	                jitter: [],
	                framesDecoded: [],
	                framesDropped: [],
	                framesReceived: [],
	                framesLoss: []
	              };
	              stats.forEach(function (report) {
	                if (report.type === 'inbound-rtp' && report.kind === 'video') {
	                  var freezeCount = report.freezeCount,
	                    totalFreezesDuration = report.totalFreezesDuration,
	                    jitter = report.jitter,
	                    framesDecoded = report.framesDecoded,
	                    framesDropped = report.framesDropped,
	                    framesReceived = report.framesReceived;
	                  inboundRtpStatsArray.jitter.push(jitter);
	                  inboundRtpStatsArray.totalFreezesDuration.push(totalFreezesDuration);
	                  inboundRtpStatsArray.freezeCount.push(freezeCount);
	                  inboundRtpStatsArray.framesDecoded.push(framesDecoded);
	                  inboundRtpStatsArray.framesDropped.push(framesDropped);
	                  inboundRtpStatsArray.framesReceived.push(framesReceived);
	                  inboundRtpStatsArray.framesLoss.push(framesDropped / framesReceived * 100);
	                }
	                statsOutput.push(report);
	                var needCheckPacketLosts = (report === null || report === void 0 ? void 0 : report.trackIdentifier) && report.hasOwnProperty('packetsLost') && report.hasOwnProperty('packetsReceived');
	                if (needCheckPacketLosts) {
	                  var packetsLostData = Util.calcRemotePacketsLost(report, babelHelpers.classPrivateFieldGet(_this26, _privateProperties).reportsForIncomingTracks[report.trackIdentifier]);
	                  report.packetsLostExtended = Util.formatPacketsLostData(packetsLostData);
	                  babelHelpers.classPrivateFieldGet(_this26, _privateProperties).reportsForIncomingTracks[report.trackIdentifier] = report;
	                  var realTrackId = babelHelpers.classPrivateFieldGet(_this26, _privateProperties).realTracksIds[report.trackIdentifier];
	                  var track = babelHelpers.classPrivateFieldGet(_this26, _privateProperties).tracksDataFromSocket[realTrackId];
	                  if (track) {
	                    var prevReport = track.report || {};
	                    track.report = report;
	                    report.bitrate = Util.calcBitrate(report, prevReport);
	                    report.userId = track.userId;
	                    report.source = track.source;
	                    var currentPercentPacketLost = packetsLostData.currentPercentPacketLost;
	                    if (track.source === MediaStreamsKinds.Camera) {
	                      currentPacketLostReceiveCount = currentPercentPacketLost;
	                    }
	                    totalBitrateIn += report.bitrate;
	                    if (!Util.setCodecToReport(report, codecs, reportsWithoutCodecs)) {
	                      Util.saveReportWithoutCodecs(report, reportsWithoutCodecs);
	                    }
	                  }
	                  if (packetsLostData.currentPercentPacketLost > babelHelpers.classPrivateFieldGet(_this26, _privateProperties).packetLostThreshold) {
	                    var participant = Object.values(babelHelpers.classPrivateFieldGet(_this26, _privateProperties).remoteParticipants).find(function (p) {
	                      var _p$tracks, _p$tracks$MediaStream, _p$tracks$MediaStream2;
	                      return (p === null || p === void 0 ? void 0 : (_p$tracks = p.tracks) === null || _p$tracks === void 0 ? void 0 : (_p$tracks$MediaStream = _p$tracks[MediaStreamsKinds.Camera]) === null || _p$tracks$MediaStream === void 0 ? void 0 : (_p$tracks$MediaStream2 = _p$tracks$MediaStream.track) === null || _p$tracks$MediaStream2 === void 0 ? void 0 : _p$tracks$MediaStream2.id) === report.trackIdentifier;
	                    });
	                    if (participant && participant.userId != babelHelpers.classPrivateFieldGet(_this26, _privateProperties).userId) {
	                      participantsWithLargeDataLoss.set(participant.userId, "userId: ".concat(participant.userId, " (").concat(packetsLostData.currentPercentPacketLost, "%)"));
	                      babelHelpers.classPrivateFieldGet(_this26, _privateProperties).prevParticipantsWithLargeDataLoss["delete"](participant.userId);
	                    }
	                  }
	                }
	                if (report.type === 'codec') {
	                  Util.processReportsWithoutCodecs(report, codecs, reportsWithoutCodecs);
	                }
	              });
	              _this26.checkQosFeatureAndExecutionCallback(function () {
	                var _this26$getCountRemot = _this26.getCountRemoteTracks(),
	                  countVideoTracks = _this26$getCountRemot.countVideoTracks,
	                  countAudioTracks = _this26$getCountRemot.countAudioTracks;
	                var round = function round(number, decimal) {
	                  return Math.round(number * Math.pow(10, decimal)) / Math.pow(10, decimal);
	                };
	                var addValueInboundRTCStatsToMetrics = function addValueInboundRTCStatsToMetrics(_ref6) {
	                  var key = _ref6.key,
	                    metricsKey = _ref6.metricsKey,
	                    isSum = _ref6.isSum,
	                    _ref6$decimal = _ref6.decimal,
	                    decimal = _ref6$decimal === void 0 ? 0 : _ref6$decimal,
	                    interval = _ref6.interval;
	                  if (_this26.currentMonitoringEventsObject.metrics[metricsKey].length >= _this26.countMetricsInMetricsInterval) {
	                    return;
	                  }
	                  var inboundRtpStatsArraySumByKey = inboundRtpStatsArray[key].reduce(function (acc, number) {
	                    return acc + number;
	                  }, 0) / (interval ? babelHelpers.classPrivateFieldGet(_this26, _privateProperties).statsTimeout / 1000 : 1);
	                  var prevInboundRtpStatsArraySumByKey = _this26.prevInboundRtpStatsSum[key];
	                  var diffInboundRtpStatsArraySumByKey = prevInboundRtpStatsArraySumByKey && !!isSum ? inboundRtpStatsArraySumByKey - prevInboundRtpStatsArraySumByKey : inboundRtpStatsArraySumByKey;
	                  var metricValue = !!countVideoTracks ? diffInboundRtpStatsArraySumByKey / countVideoTracks : 0;
	                  _this26.currentMonitoringEventsObject.metrics[metricsKey].push(round(metricValue, decimal));
	                  _this26.prevInboundRtpStatsSum[key] = inboundRtpStatsArraySumByKey;
	                };
	                addValueInboundRTCStatsToMetrics({
	                  key: 'jitter',
	                  metricsKey: 'JITTER',
	                  isSum: false,
	                  decimal: 3
	                });
	                addValueInboundRTCStatsToMetrics({
	                  key: 'freezeCount',
	                  metricsKey: 'FREEZE_COUNT',
	                  isSum: true,
	                  interval: true
	                });
	                addValueInboundRTCStatsToMetrics({
	                  key: 'totalFreezesDuration',
	                  metricsKey: 'TOTAL_FREEZE_DURATION',
	                  isSum: true,
	                  decimal: 3,
	                  interval: true
	                });
	                addValueInboundRTCStatsToMetrics({
	                  key: 'framesDecoded',
	                  metricsKey: 'FRAMES_DECODED',
	                  isSum: true,
	                  interval: true
	                });
	                addValueInboundRTCStatsToMetrics({
	                  key: 'framesDropped',
	                  metricsKey: 'FRAMES_DROPPED',
	                  isSum: true,
	                  interval: true
	                });
	                // addValueInboundRTCStatsToMetrics({ key: 'framesLoss', metricsKey: 'FRAMES_LOSS', isSum: true });

	                if (_this26.currentMonitoringEventsObject.metrics.FRAMES_LOSS.length < _this26.countMetricsInMetricsInterval) {
	                  var currentFramesReceived = _this26.currentMonitoringEventsObject.metrics.FRAMES_RECEIVED.slice(-1)[0];
	                  var currentFramesDropped = _this26.currentMonitoringEventsObject.metrics.FRAMES_DROPPED.slice(-1)[0];
	                  var currentFramesLoss = !!currentFramesReceived ? currentFramesDropped / currentFramesReceived : 0;
	                  _this26.currentMonitoringEventsObject.metrics.FRAMES_LOSS.push(currentFramesLoss > 0 ? round(currentFramesLoss * 100, 0) : 0);
	                }
	                var formattedBitrateIn = Number.parseFloat((totalBitrateIn / 1000000).toFixed(2));
	                if (_this26.currentMonitoringEventsObject.metrics.BITRATE_IN.length < _this26.countMetricsInMetricsInterval) {
	                  _this26.currentMonitoringEventsObject.metrics.BITRATE_IN.push(formattedBitrateIn);
	                }
	                if (_this26.currentMonitoringEventsObject.metrics.PACKET_LOST_RECEIVE.length < _this26.countMetricsInMetricsInterval) {
	                  _this26.currentMonitoringEventsObject.metrics.PACKET_LOST_RECEIVE.push(currentPacketLostReceiveCount);
	                }
	                if (currentPacketLostReceiveCount > babelHelpers.classPrivateFieldGet(_this26, _privateProperties).packetLostThreshold) {
	                  _this26.addMonitoringEvents({
	                    name: MONITORING_EVENTS_NAME_LIST.HIGH_PACKET_LOSS_RECEIVE,
	                    withCounter: true
	                  });
	                }
	              });
	              statsAll.recipient = statsOutput;
	              if (participantsWithLargeDataLoss.size || babelHelpers.classPrivateFieldGet(_this26, _privateProperties).prevParticipantsWithLargeDataLoss.size) {
	                if (participantsWithLargeDataLoss.size) {
	                  _this26.setLog("Have high packetsLost on users: ".concat(babelHelpers.toConsumableArray(participantsWithLargeDataLoss.values())), LOG_LEVEL.WARNING);
	                }
	                _this26.triggerEvents('UpdatePacketLoss', [babelHelpers.toConsumableArray(participantsWithLargeDataLoss.keys())]);
	              }
	              babelHelpers.classPrivateFieldGet(_this26, _privateProperties).prevParticipantsWithLargeDataLoss = participantsWithLargeDataLoss;
	            });
	          case 7:
	            _this26.triggerEvents('CallStatsReceived', [statsAll]);
	            _context24.next = 12;
	            break;
	          case 10:
	            _context24.prev = 10;
	            _context24.t0 = _context24["catch"](0);
	          case 12:
	          case "end":
	            return _context24.stop();
	        }
	      }, _callee24, null, [[0, 10]]);
	    }));
	    return function getStatsHandle() {
	      return _ref5.apply(this, arguments);
	    };
	  }();
	  getStatsHandle()["finally"](function () {
	    _this26.checkQosFeatureAndExecutionCallback(function () {
	      _this26.startAggregateMonitoringEvents();
	    });
	    babelHelpers.classPrivateFieldGet(_this26, _privateProperties).callStatsInterval = setInterval( /*#__PURE__*/babelHelpers.asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee25() {
	      return _regeneratorRuntime().wrap(function _callee25$(_context25) {
	        while (1) switch (_context25.prev = _context25.next) {
	          case 0:
	            _context25.next = 2;
	            return getStatsHandle();
	          case 2:
	          case "end":
	            return _context25.stop();
	        }
	      }, _callee25);
	    })), babelHelpers.classPrivateFieldGet(_this26, _privateProperties).statsTimeout);
	  });
	}
	function _destroyPeerConnection2() {
	  if (this.sender) {
	    this.sender.close();
	    this.sender = null;
	  }
	  if (this.recipient) {
	    this.recipient.close();
	    this.recipient = null;
	  }
	  babelHelpers.classPrivateFieldGet(this, _privateProperties).peerConnectionFailed = false;
	}
	function _releaseStream2(kind) {
	  var streamType;
	  switch (kind) {
	    case MediaStreamsKinds.Camera:
	      streamType = 'cameraStream';
	      break;
	    case MediaStreamsKinds.Microphone:
	      streamType = 'microphoneStream';
	      break;
	    case MediaStreamsKinds.Screen:
	      streamType = 'screenStream';
	      break;
	  }
	  if (streamType) {
	    var _babelHelpers$classPr30, _babelHelpers$classPr31, _babelHelpers$classPr32;
	    (_babelHelpers$classPr30 = babelHelpers.classPrivateFieldGet(this, _privateProperties)[streamType]) === null || _babelHelpers$classPr30 === void 0 ? void 0 : (_babelHelpers$classPr31 = _babelHelpers$classPr30.getTracks) === null || _babelHelpers$classPr31 === void 0 ? void 0 : (_babelHelpers$classPr32 = _babelHelpers$classPr31.call(_babelHelpers$classPr30)) === null || _babelHelpers$classPr32 === void 0 ? void 0 : _babelHelpers$classPr32.forEach(function (track) {
	      track.onended = null;
	      track.stop();
	    });
	    babelHelpers.classPrivateFieldGet(this, _privateProperties)[streamType] = null;
	  }
	}
	function _getSender2(kind) {
	  var _this$sender, _this$sender$getSende;
	  var senders = (_this$sender = this.sender) === null || _this$sender === void 0 ? void 0 : (_this$sender$getSende = _this$sender.getSenders) === null || _this$sender$getSende === void 0 ? void 0 : _this$sender$getSende.call(_this$sender);
	  var sender = null;
	  if ((senders === null || senders === void 0 ? void 0 : senders.length) > 0) {
	    var _iterator = _createForOfIteratorHelper(senders),
	      _step;
	    try {
	      for (_iterator.s(); !(_step = _iterator.n()).done;) {
	        var _s$track;
	        var s = _step.value;
	        if (((_s$track = s.track) === null || _s$track === void 0 ? void 0 : _s$track.source) === kind) {
	          sender = s;
	          break;
	        }
	      }
	    } catch (err) {
	      _iterator.e(err);
	    } finally {
	      _iterator.f();
	    }
	  }
	  return sender;
	}
	function _sendSignal2(signal) {
	  var _babelHelpers$classPr33;
	  if (((_babelHelpers$classPr33 = babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect) === null || _babelHelpers$classPr33 === void 0 ? void 0 : _babelHelpers$classPr33.readyState) === 1) {
	    babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect.send(JSON.stringify(signal));
	    return true;
	  }
	  return false;
	}
	function _sendLeave2() {
	  var _babelHelpers$classPr34,
	    _this27 = this;
	  if (((_babelHelpers$classPr34 = babelHelpers.classPrivateFieldGet(this, _privateProperties).socketConnect) === null || _babelHelpers$classPr34 === void 0 ? void 0 : _babelHelpers$classPr34.readyState) === 1) {
	    _classPrivateMethodGet(this, _sendSignal, _sendSignal2).call(this, {
	      leave: {
	        reason: 'CLIENT_INITIATED'
	      }
	    });
	    this.checkQosFeatureAndExecutionCallback(function () {
	      _this27.sendMonitoringEvents(false);
	    });
	  }
	}
	var _socketConnect = /*#__PURE__*/new WeakMap();
	var Participant = /*#__PURE__*/function () {
	  function Participant(participant, socket) {
	    babelHelpers.classCallCheck(this, Participant);
	    _classPrivateFieldInitSpec(this, _socketConnect, {
	      writable: true,
	      value: void 0
	    });
	    babelHelpers.defineProperty(this, "name", '');
	    babelHelpers.defineProperty(this, "image", '');
	    babelHelpers.defineProperty(this, "userId", '');
	    babelHelpers.defineProperty(this, "videoEnabled", false);
	    babelHelpers.defineProperty(this, "audioEnabled", false);
	    babelHelpers.defineProperty(this, "screenSharingEnabled", false);
	    babelHelpers.defineProperty(this, "isSpeaking", false);
	    babelHelpers.defineProperty(this, "tracks", {});
	    babelHelpers.defineProperty(this, "sid", '');
	    babelHelpers.defineProperty(this, "isMutedVideo", false);
	    babelHelpers.defineProperty(this, "isMutedAudio", false);
	    babelHelpers.defineProperty(this, "isHandRaised", false);
	    babelHelpers.defineProperty(this, "videoPaused", false);
	    babelHelpers.defineProperty(this, "isLocalVideoMute", false);
	    babelHelpers.defineProperty(this, "streamRemovingId", '');
	    this.name = (participant === null || participant === void 0 ? void 0 : participant.name) || '';
	    this.image = (participant === null || participant === void 0 ? void 0 : participant.image) || '';
	    this.userId = (participant === null || participant === void 0 ? void 0 : participant.userId) || '';
	    this.sid = (participant === null || participant === void 0 ? void 0 : participant.sid) || '';
	    this.videoEnabled = (participant === null || participant === void 0 ? void 0 : participant.videoEnabled) || false;
	    this.audioEnabled = (participant === null || participant === void 0 ? void 0 : participant.audioEnabled) || false;
	    this.screenSharingEnabled = (participant === null || participant === void 0 ? void 0 : participant.screenSharingEnabled) || false;
	    this.isSpeaking = (participant === null || participant === void 0 ? void 0 : participant.isSpeaking) || false;
	    this.isHandRaised = (participant === null || participant === void 0 ? void 0 : participant.isHandRaised) || false;
	    babelHelpers.classPrivateFieldSet(this, _socketConnect, socket);
	  }
	  babelHelpers.createClass(Participant, [{
	    key: "subscribeTrack",
	    value: function subscribeTrack(MediaStreamKind) {}
	  }, {
	    key: "unsubscribeTrack",
	    value: function unsubscribeTrack(MediaStreamKind) {}
	  }, {
	    key: "attachTrack",
	    value: function attachTrack(MediaStreamKind) {}
	  }, {
	    key: "detachTrack",
	    value: function detachTrack(MediaStreamKind) {}
	  }, {
	    key: "disableAudio",
	    value: function disableAudio() {
	      this.tracks[MediaStreamsKinds.Microphone].track.enabled = false;
	      this.isMutedAudio = true;
	    }
	  }, {
	    key: "enableAudio",
	    value: function enableAudio() {
	      this.tracks[MediaStreamsKinds.Microphone].track.enabled = true;
	      this.isMutedAudio = false;
	    }
	  }, {
	    key: "disableVideo",
	    value: function disableVideo() {
	      this.tracks[MediaStreamsKinds.Camera].track.enabled = false;
	      this.isMutedVideo = true;
	    }
	  }, {
	    key: "enableVideo",
	    value: function enableVideo() {
	      this.tracks[MediaStreamsKinds.Camera].track.enabled = true;
	      this.isMutedVideo = false;
	    }
	  }, {
	    key: "addTrack",
	    value: function addTrack(MediaStreamKind, Track) {
	      this.tracks[MediaStreamKind] = Track;
	    }
	  }, {
	    key: "removeTrack",
	    value: function removeTrack(MediaStreamKind, Track) {
	      delete this.tracks[MediaStreamKind];
	    }
	  }, {
	    key: "getTrack",
	    value: function getTrack(MediaStreamKind) {
	      var _this$tracks;
	      return (_this$tracks = this.tracks) === null || _this$tracks === void 0 ? void 0 : _this$tracks[MediaStreamKind];
	    }
	  }, {
	    key: "setStreamQuality",
	    value: function setStreamQuality(quality) {
	      var _this$tracks2;
	      if (this.cameraStreamQuality === quality || this.videoPaused) {
	        return;
	      }
	      if ((_this$tracks2 = this.tracks) !== null && _this$tracks2 !== void 0 && _this$tracks2[MediaStreamsKinds.Camera]) {
	        this.cameraStreamQuality = quality;
	        var _trackId7 = this.tracks[MediaStreamsKinds.Camera].id;
	        this.tracks[MediaStreamsKinds.Camera].track.currentVideoQuality = quality;
	        var signal = {
	          trackSetting: {
	            trackSids: [_trackId7],
	            quality: quality
	          }
	        };
	        babelHelpers.classPrivateFieldGet(this, _socketConnect).send(JSON.stringify(signal));
	      }
	    }
	  }]);
	  return Participant;
	}();

	var CallUser = /*#__PURE__*/function () {
	  function CallUser() {
	    var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	    babelHelpers.classCallCheck(this, CallUser);
	    babelHelpers.defineProperty(this, "elements", {});
	    this.userModel = config.userModel;
	    this.userModel.subscribe("changed", this._onUserFieldChanged.bind(this));
	    this.parentContainer = config.parentContainer;
	    this.screenSharingUser = main_core.Type.isBoolean(config.screenSharingUser) ? config.screenSharingUser : false;
	    this.allowBackgroundItem = main_core.Type.isBoolean(config.allowBackgroundItem) ? config.allowBackgroundItem : true;
	    this.allowMaskItem = main_core.Type.isBoolean(config.allowMaskItem) ? config.allowMaskItem : true;
	    this._allowPinButton = main_core.Type.isBoolean(config.allowPinButton) ? config.allowPinButton : true;
	    this._visible = true;
	    this._audioTrack = config.audioTrack;
	    this._screenAudioTrack = config.screenAudioTrack;
	    this._audioStream = this._audioTrack ? new MediaStream([this._audioTrack]) : null;
	    this._screenAudioStream = this._screenAudioTrack ? new MediaStream([this._screenAudioTrack]) : null;
	    this._videoTrack = config.videoTrack;
	    this._stream = this._videoTrack ? new MediaStream([this._videoTrack]) : null;
	    this._videoRenderer = null;
	    this._previewRenderer = null;
	    this._flipVideo = false;
	    this.hidden = false;
	    this.videoBlurState = false;
	    this.isChangingName = false;
	    this._badNetworkIndicator = false;
	    this.incomingVideoConstraints = {
	      width: 0,
	      height: 0
	    };
	    if (config.audioElement) {
	      this.elements.audio = config.audioElement;
	    }
	    if (config.screenAudioElement) {
	      this.elements.screenAudio = config.screenAudioElement;
	    }
	    this.callBacks = {
	      onClick: main_core.Type.isFunction(config.onClick) ? config.onClick : BX.DoNothing,
	      onUserRename: main_core.Type.isFunction(config.onUserRename) ? config.onUserRename : BX.DoNothing,
	      onUserRenameInputFocus: main_core.Type.isFunction(config.onUserRenameInputFocus) ? config.onUserRenameInputFocus : BX.DoNothing,
	      onUserRenameInputBlur: main_core.Type.isFunction(config.onUserRenameInputBlur) ? config.onUserRenameInputBlur : BX.DoNothing,
	      onPin: main_core.Type.isFunction(config.onPin) ? config.onPin : BX.DoNothing,
	      onUnPin: main_core.Type.isFunction(config.onUnPin) ? config.onUnPin : BX.DoNothing
	    };
	    this.checkAspectInterval = setInterval(this.checkVideoAspect.bind(this), 500);
	    this.hintManager = BX.UI.Hint.createInstance({
	      popupParameters: {
	        targetContainer: document.body,
	        className: "bx-messenger-videocall-panel-item-hotkey-hint ".concat(this.userModel.id),
	        bindOptions: {
	          forceBindPosition: true
	        }
	      }
	    });
	    this.connectionStats = {};
	    this.connectionStatsVisible = false;
	    this.avatarBackground = Util.getAvatarBackground();
	    this.removeAvatarPulseTimer = null;
	    this.hideUserNameTimer = null;
	    this.init();
	  }
	  babelHelpers.createClass(CallUser, [{
	    key: "init",
	    value: function init() {
	      this.onMouseMoveHandler = this.showUserName.bind(this);
	      document.addEventListener('mousemove', this.onMouseMoveHandler);
	    }
	  }, {
	    key: "isVisibleMediaStateIcon",
	    value: function isVisibleMediaStateIcon(isActive) {
	      return !isActive && this.userModel.state === UserState.Connected;
	    }
	  }, {
	    key: "isVisibleCameraStateIcon",
	    value: function isVisibleCameraStateIcon() {
	      return this.isVisibleMediaStateIcon(this.userModel.cameraState);
	    }
	  }, {
	    key: "isVisibleMicStateIcon",
	    value: function isVisibleMicStateIcon() {
	      return this.isVisibleMediaStateIcon(this.userModel.microphoneState);
	    }
	  }, {
	    key: "showStats",
	    value: function showStats(stats) {
	      this.connectionStats = stats;
	      if (this.elements.statsOverlay && this.connectionStatsVisible) {
	        this.showConnectionStats();
	      }
	    }
	  }, {
	    key: "render",
	    value: function render() {
	      var _this = this;
	      if (this.elements.root) {
	        return this.elements.root;
	      }
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-user"
	        },
	        dataset: {
	          userId: this.userModel.id,
	          order: this.userModel.order
	        },
	        children: [this.elements.videoBorder = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-border"
	          }
	        }), this.elements.container = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-inner"
	          },
	          children: [this.elements.avatarContainer = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-user-avatar-border"
	            },
	            children: [this.elements.avatar = main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-user-avatar"
	              },
	              text: ''
	            }), main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-user-avatar-overlay-border"
	              }
	            }), main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-user-avatar-pulse-element",
	                style: "animation-delay: -2s;"
	              }
	            }), main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-user-avatar-pulse-element",
	                style: "animation-delay: -1.5s;"
	              }
	            }), main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-user-avatar-pulse-element",
	                style: "animation-delay: -1s;"
	              }
	            }), main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-user-avatar-pulse-element",
	                style: "animation-delay: -0.5s;"
	              }
	            })]
	          }), this.elements.panel = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-user-panel"
	            }
	          }), this.elements.state = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-user-status-text"
	            },
	            text: this.getStateMessage(this.userModel.state)
	          }), this.elements.userBottomContainer = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-user-bottom"
	            },
	            children: [this.elements.nameContainer = main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-user-name-container" + (this.userModel.allowRename && !this.userModel.wasRenamed ? " hidden" : "")
	              },
	              children: [this.elements.name = main_core.Dom.create("span", {
	                props: {
	                  className: "bx-messenger-videocall-user-name",
	                  title: this.screenSharingUser ? BX.message('IM_CALL_USERS_SCREEN').replace("#NAME#", this.userModel.name) : this.userModel.name
	                },
	                text: this.screenSharingUser ? BX.message('IM_CALL_USERS_SCREEN').replace("#NAME#", this.userModel.name) : this.userModel.name
	              }), this.elements.changeNameIcon = main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-user-name-icon bx-messenger-videocall-user-change-name-icon hidden"
	                }
	              })],
	              events: {
	                click: this.toggleNameInput.bind(this)
	              }
	            }), this.elements.changeNameContainer = main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-user-change-name-container hidden"
	              },
	              children: [this.elements.changeNameCancel = main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-user-change-name-cancel"
	                },
	                events: {
	                  click: this.toggleNameInput.bind(this)
	                }
	              }), this.elements.changeNameInput = main_core.Dom.create("input", {
	                props: {
	                  className: "bx-messenger-videocall-user-change-name-input"
	                },
	                attrs: {
	                  type: 'text',
	                  value: this.userModel.name
	                },
	                events: {
	                  keydown: this.onNameInputKeyDown.bind(this),
	                  focus: this.callBacks.onUserRenameInputFocus,
	                  blur: this.callBacks.onUserRenameInputBlur,
	                  click: function click(event) {
	                    event.stopPropagation();
	                  }
	                }
	              }), this.elements.changeNameConfirm = main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-user-change-name-confirm"
	                },
	                events: {
	                  click: this.changeName.bind(this)
	                }
	              }), this.elements.changeNameLoader = main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-user-change-name-loader hidden"
	                },
	                children: [main_core.Dom.create("div", {
	                  props: {
	                    className: "bx-messenger-videocall-user-change-name-loader-icon"
	                  }
	                })]
	              })]
	            }), this.elements.introduceYourselfContainer = main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-user-introduce-yourself-container" + (!this.userModel.allowRename || this.userModel.wasRenamed ? " hidden" : "")
	              },
	              children: [main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-user-introduce-yourself-text"
	                },
	                text: BX.message('IM_CALL_GUEST_INTRODUCE_YOURSELF')
	              })],
	              events: {
	                click: this.toggleNameInput.bind(this)
	              }
	            })]
	          }), this.elements.floorRequest = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-user-floor-request bx-messenger-videocall-floor-request-icon"
	            }
	          }), this.elements.statsOverlay = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-user-stats-overlay"
	            }
	          })]
	        })],
	        style: {
	          order: this.userModel.order
	        },
	        events: {
	          click: function (e) {
	            e.stopPropagation();
	            this.callBacks.onClick({
	              userId: this.id
	            });
	          }.bind(this)
	        }
	      });
	      if (this.userModel.talking) {
	        this.updateAvatarPulseState();
	      }
	      this.elements.debugPanel = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-user-debug-panel"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-debug-panel-button connection-stats"
	          },
	          children: [this.elements.connectionQualityIcon = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-user-debug-panel-button-icon connection-quality-icon",
	              title: BX.message("IM_M_CALL_CONNECTION_QUALITY_HINT")
	            }
	          })],
	          events: {
	            click: function click(e) {
	              e.stopPropagation();
	              _this.connectionStatsVisible = !_this.connectionStatsVisible;
	              if (_this.connectionStatsVisible) {
	                _this.showConnectionStats();
	                _this.elements.statsOverlay.classList.add('stats-overlay-visble');
	              } else {
	                _this.elements.statsOverlay.classList.remove('stats-overlay-visble');
	              }
	            }
	          }
	        }), this.elements.connectionProblem = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-debug-panel-button connection-problem"
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-user-debug-panel-button-icon connection-problem-icon"
	            },
	            events: {
	              mouseover: function mouseover(e) {
	                _this.hintManager.show(e.currentTarget, BX.message("IM_M_CALL_POOR_CONNECTION_WITH_USER"));
	              },
	              mouseout: function mouseout(e) {
	                _this.hintManager.hide();
	              }
	            }
	          })]
	        })]
	      });
	      if (this.userModel.localUser) {
	        this.elements.root.classList.add("bx-messenger-videocall-user-self");
	      }
	      if (this.userModel.avatar !== '') {
	        this.elements.root.style.setProperty("--avatar", "url('" + this.userModel.avatar + "')");
	        this.elements.avatar.innerText = '';
	        this.elements.root.style.removeProperty("--avatar-background");
	      } else {
	        this.elements.root.style.removeProperty("--avatar");
	        this.elements.root.style.setProperty("--avatar-background", this.avatarBackground);
	        this.elements.avatar.innerText = this.getAvatarInnerText();
	      }
	      this.elements.videoContainer = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-video-container"
	        },
	        children: [this.elements.video = main_core.Dom.create("video", {
	          props: {
	            className: "bx-messenger-videocall-video",
	            volume: 0,
	            autoplay: true
	          },
	          attrs: {
	            playsinline: true,
	            muted: true
	          }
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-preview"
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-preview-container"
	            },
	            children: [this.elements.preview = main_core.Dom.create("video", {
	              props: {
	                className: "bx-messenger-videocall-preview-video",
	                volume: 0,
	                autoplay: true
	              },
	              attrs: {
	                playsinline: true,
	                muted: true
	              }
	            })]
	          })]
	        })]
	      });
	      this.elements.container.appendChild(this.elements.videoContainer);
	      if (this.stream && this.stream.active) {
	        this.elements.video.srcObject = this.stream;
	      }
	      if (this.flipVideo) {
	        this.elements.video.classList.add("bx-messenger-videocall-video-flipped");
	      }
	      if (this.userModel.screenState) {
	        this.elements.video.classList.add("bx-messenger-videocall-video-contain");
	      }
	      if (this.isVisibleCameraStateIcon() && this.isVisibleMicStateIcon()) {
	        this.elements.nameContainer.classList.add("extra-padding");
	      }

	      //this.elements.nameContainer.appendChild(this.elements.micState);

	      // todo: show button only if user have the permission to remove user
	      /*this.elements.removeButton = Dom.create("div", {
	      	props: {className: "bx-messenger-videocall-user-close"}
	      });
	      	this.elements.container.appendChild(this.elements.removeButton);*/

	      this.elements.buttonBackground = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-user-panel-button"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-panel-button-icon background"
	          }
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-panel-button-text"
	          },
	          text: BX.message("IM_CALL_CHANGE_BACKGROUND")
	        })],
	        events: {
	          click: function click(e) {
	            e.stopPropagation();
	            BackgroundDialog.open();
	          }
	        }
	      });
	      this.elements.buttonMenu = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-user-panel-button"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-panel-button-icon menu"
	          }
	        })],
	        events: {
	          click: function click(e) {
	            e.stopPropagation();
	            _this.showMenu();
	          }
	        }
	      });
	      this.elements.buttonPin = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-user-panel-button"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-panel-button-icon pin"
	          }
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-panel-button-text"
	          },
	          text: BX.message("IM_CALL_PIN")
	        })],
	        events: {
	          click: function click(e) {
	            e.stopPropagation();
	            _this.callBacks.onPin({
	              userId: _this.userModel.id
	            });
	          }
	        }
	      });
	      this.elements.buttonUnPin = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-user-panel-button"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-panel-button-icon unpin"
	          }
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-panel-button-text"
	          },
	          text: BX.message("IM_CALL_UNPIN")
	        })],
	        events: {
	          click: function click(e) {
	            e.stopPropagation();
	            _this.callBacks.onUnPin();
	          }
	        }
	      });
	      this.elements.userBottomContainer.appendChild(main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-user-device-state-container"
	        },
	        children: [this.elements.cameraState = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-name-icon bx-messenger-videocall-user-device-state camera" + (!this.isVisibleCameraStateIcon() ? " hidden" : "")
	          }
	        }), this.elements.micState = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-name-icon bx-messenger-videocall-user-device-state mic" + (!this.isVisibleMicStateIcon() ? " hidden" : "")
	          }
	        })]
	      }));
	      this.updatePanelDeferred();
	      return this.elements.root;
	    }
	  }, {
	    key: "showConnectionStats",
	    value: function showConnectionStats() {
	      var _this$connectionStats, _this$connectionStats2, _this$connectionStats3;
	      if (!this.elements.statsOverlay) {
	        return;
	      }
	      var statsString = '';
	      var cameraStats = (_this$connectionStats = this.connectionStats) === null || _this$connectionStats === void 0 ? void 0 : _this$connectionStats[MediaStreamsKinds.Camera];
	      var screenStats = (_this$connectionStats2 = this.connectionStats) === null || _this$connectionStats2 === void 0 ? void 0 : _this$connectionStats2[MediaStreamsKinds.Screen];
	      var audioStats = (_this$connectionStats3 = this.connectionStats) === null || _this$connectionStats3 === void 0 ? void 0 : _this$connectionStats3[MediaStreamsKinds.Microphone];
	      if (cameraStats || !screenStats) {
	        statsString += "Video stats:\n";
	        statsString += this._formatVideoStats(cameraStats);
	      }
	      if (screenStats) {
	        if (screenStats) {
	          statsString += "\n\n";
	        }
	        statsString += "Screen share stats:\n";
	        statsString += this._formatVideoStats(screenStats);
	      }
	      if (audioStats) {
	        if (cameraStats || screenStats) {
	          statsString += "\n\n";
	        }
	        statsString += "Audio stats:\n";
	        statsString += "Bitrate: ".concat((audioStats === null || audioStats === void 0 ? void 0 : audioStats.bitrate) || 0, "\n");
	        statsString += "PacketsLost: ".concat((audioStats === null || audioStats === void 0 ? void 0 : audioStats.packetsLostExtended) || 0, "\n");
	        statsString += "Codec: ".concat((audioStats === null || audioStats === void 0 ? void 0 : audioStats.codecName) || '-');
	      }
	      this.elements.statsOverlay.innerText = statsString;
	    }
	  }, {
	    key: "setIncomingVideoConstraints",
	    value: function setIncomingVideoConstraints(width, height) {
	      this.incomingVideoConstraints.width = typeof width === "undefined" ? this.incomingVideoConstraints.width : width;
	      this.incomingVideoConstraints.height = typeof height === "undefined" ? this.incomingVideoConstraints.height : height;
	      if (!this.videoRenderer) {
	        return;
	      }

	      // vox low quality temporary workaround
	      // (disabled to test quality)
	      // if (this.incomingVideoConstraints.width >= 320 && this.incomingVideoConstraints.width <= 640)
	      // {
	      // 	this.incomingVideoConstraints.width = 640;
	      // }
	      // if (this.incomingVideoConstraints.height >= 180 && this.incomingVideoConstraints.height <= 360)
	      // {
	      // 	this.incomingVideoConstraints.height = 360;
	      // }

	      this.videoRenderer.requestVideoSize(this.incomingVideoConstraints.width, this.incomingVideoConstraints.height);
	    }
	  }, {
	    key: "updateRendererState",
	    value: function updateRendererState() {
	      /*if (this.videoRenderer)
	      {
	      	if (this.visible)
	      	{
	      		this.videoRenderer.enable();
	      	}
	      	else
	      	{
	      		this.videoRenderer.disable();
	      	}
	      }*/

	      /*if (this.elements.video && this.elements.video.srcObject)
	      {
	      	if (this.visible)
	      	{
	      		this.elements.video.play();
	      	}
	      	else
	      	{
	      		this.elements.video.pause();
	      	}
	      }*/
	    }
	  }, {
	    key: "_onUserFieldChanged",
	    value: function _onUserFieldChanged(event) {
	      var eventData = event.data;
	      switch (eventData.fieldName) {
	        case "id":
	          return this.updateId();
	        case "name":
	          return this.updateName();
	        case "avatar":
	          return this.updateAvatar();
	        case "state":
	          return this.updateState();
	        case "talking":
	          return this.updateTalking();
	        case "microphoneState":
	          return this.updateMicrophoneState();
	        case "cameraState":
	          return this.updateCameraState();
	        case "videoPaused":
	          return this.updateVideoPaused();
	        case "floorRequestState":
	          return this.updateFloorRequestState();
	        case "screenState":
	          return this.updateScreenState();
	        case "pinned":
	          return this.updatePanel();
	        case "allowRename":
	          return this.updateRenameAllowed();
	        case "wasRenamed":
	          return this.updateWasRenamed();
	        case "renameRequested":
	          return this.updateRenameRequested();
	        case "order":
	          return this.updateOrder();
	      }
	    }
	  }, {
	    key: "toggleRenameIcon",
	    value: function toggleRenameIcon() {
	      if (!this.userModel.allowRename) {
	        return;
	      }
	      this.elements.changeNameIcon.classList.toggle('hidden');
	    }
	  }, {
	    key: "toggleNameInput",
	    value: function toggleNameInput(event) {
	      if (!this.userModel.allowRename || !this.elements.root) {
	        return;
	      }
	      event.stopPropagation();
	      if (this.isChangingName) {
	        this.isChangingName = false;
	        if (!this.userModel.wasRenamed) {
	          this.elements.introduceYourselfContainer.classList.remove('hidden');
	          this.elements.changeNameContainer.classList.add('hidden');
	        } else {
	          this.elements.changeNameContainer.classList.add('hidden');
	          this.elements.nameContainer.classList.remove('hidden');
	        }
	      } else {
	        if (!this.userModel.wasRenamed) {
	          this.elements.introduceYourselfContainer.classList.add('hidden');
	        }
	        this.isChangingName = true;
	        this.elements.nameContainer.classList.add('hidden');
	        this.elements.changeNameContainer.classList.remove('hidden');
	        this.elements.changeNameInput.value = this.userModel.name;
	        this.elements.changeNameInput.focus();
	        this.elements.changeNameInput.select();
	      }
	    }
	  }, {
	    key: "onNameInputKeyDown",
	    value: function onNameInputKeyDown(event) {
	      if (!this.userModel.allowRename) {
	        return;
	      }

	      //enter
	      if (event.keyCode === 13) {
	        this.changeName(event);
	      }
	      //escape
	      else if (event.keyCode === 27) {
	        this.toggleNameInput(event);
	      }
	    }
	  }, {
	    key: "onNameInputFocus",
	    value: function onNameInputFocus(event) {}
	  }, {
	    key: "onNameInputBlur",
	    value: function onNameInputBlur(event) {}
	  }, {
	    key: "changeName",
	    value: function changeName(event) {
	      event.stopPropagation();
	      var inputValue = this.elements.changeNameInput.value;
	      var newName = inputValue.trim();
	      var needToUpdate = true;
	      if (newName === this.userModel.name || newName === '') {
	        needToUpdate = false;
	      }
	      if (needToUpdate) {
	        this.elements.changeNameConfirm.classList.toggle('hidden');
	        this.elements.changeNameLoader.classList.toggle('hidden');
	        this.callBacks.onUserRename(newName);
	      } else {
	        this.toggleNameInput(event);
	      }
	    }
	  }, {
	    key: "showMenu",
	    value: function showMenu() {
	      var _this2 = this;
	      var menuItems = [];
	      if (this.userModel.localUser && this.allowBackgroundItem) {
	        menuItems.push({
	          text: this.allowMaskItem ? BX.message("IM_CALL_CHANGE_BG_MASK") : BX.message("IM_CALL_CHANGE_BACKGROUND"),
	          onclick: function onclick() {
	            _this2.menu.close();
	            BackgroundDialog.open();
	          }
	        });
	      }
	      if (menuItems.length === 0) {
	        return;
	      }
	      var rect = main_core.Dom.getRelativePosition(this.elements.buttonMenu, this.parentContainer);
	      this.menu = new main_popup.Menu({
	        id: 'call-view-user-menu-' + this.userModel.id,
	        bindElement: {
	          left: rect.left,
	          top: rect.top,
	          bottom: rect.bottom
	        },
	        items: menuItems,
	        targetContainer: this.parentContainer,
	        autoHide: true,
	        closeByEsc: true,
	        offsetTop: 0,
	        offsetLeft: 0,
	        bindOptions: {
	          position: 'bottom'
	        },
	        angle: true,
	        overlay: {
	          backgroundColor: 'white',
	          opacity: 0
	        },
	        cacheable: false,
	        events: {
	          onPopupDestroy: function onPopupDestroy() {
	            return _this2.menu = null;
	          }
	        }
	      });
	      this.menu.show();
	    }
	  }, {
	    key: "updateAvatar",
	    value: function updateAvatar() {
	      if (this.elements.root) {
	        if (this.userModel.avatar !== '') {
	          this.elements.root.style.setProperty("--avatar", "url('" + this.userModel.avatar + "')");
	          this.elements.avatar.innerText = '';
	          this.elements.root.style.removeProperty("--avatar-background");
	        } else {
	          this.elements.root.style.removeProperty("--avatar");
	          this.elements.root.style.setProperty("--avatar-background", this.avatarBackground);
	          this.elements.avatar.innerText = this.getAvatarInnerText();
	        }
	      }
	    }
	  }, {
	    key: "updateId",
	    value: function updateId() {
	      if (this.elements.root) {
	        this.elements.root.dataset.userId = this.userModel.id;
	      }
	    }
	  }, {
	    key: "updateName",
	    value: function updateName() {
	      if (this.isChangingName) {
	        this.isChangingName = false;
	        this.elements.changeNameConfirm.classList.toggle('hidden');
	        this.elements.changeNameLoader.classList.toggle('hidden');
	        this.elements.changeNameContainer.classList.add('hidden');
	        this.elements.nameContainer.classList.remove('hidden');
	      }
	      if (this.elements.name) {
	        this.elements.name.innerText = this.screenSharingUser ? BX.message('IM_CALL_USERS_SCREEN').replace("#NAME#", this.userModel.name) : this.userModel.name;
	      }
	      if (this.userModel.avatar === '' && this.elements.avatar) {
	        this.elements.avatar.innerText = this.getAvatarInnerText();
	      }
	    }
	  }, {
	    key: "getAvatarInnerText",
	    value: function getAvatarInnerText() {
	      return im_v2_lib_utils.Utils.text.getFirstLetters(this.userModel.name).toUpperCase();
	    }
	  }, {
	    key: "updateRenameAllowed",
	    value: function updateRenameAllowed() {
	      if (this.userModel.allowRename && this.elements.nameContainer && this.elements.introduceYourselfContainer) {
	        this.elements.nameContainer.classList.add('hidden');
	        this.elements.introduceYourselfContainer.classList.remove('hidden');
	      }
	    }
	  }, {
	    key: "updateWasRenamed",
	    value: function updateWasRenamed() {
	      if (!this.elements.root) {
	        return;
	      }
	      if (this.userModel.allowRename) {
	        this.elements.introduceYourselfContainer.classList.add('hidden');
	        this.elements.changeNameIcon.classList.remove('hidden');
	        if (this.elements.changeNameContainer.classList.contains('hidden')) {
	          this.elements.nameContainer.classList.remove('hidden');
	        }
	      }
	    }
	  }, {
	    key: "updateRenameRequested",
	    value: function updateRenameRequested() {
	      if (this.userModel.allowRename) {
	        this.elements.introduceYourselfContainer.classList.add('hidden');
	      }
	    }
	  }, {
	    key: "updateOrder",
	    value: function updateOrder() {
	      if (this.elements.root) {
	        this.elements.root.dataset.order = this.userModel.order;
	        this.elements.root.style.order = this.userModel.order;
	      }
	    }
	  }, {
	    key: "updatePanelDeferred",
	    value: function updatePanelDeferred() {
	      setTimeout(this.updatePanel.bind(this), 0);
	    }
	  }, {
	    key: "updatePanel",
	    value: function updatePanel() {
	      if (!this.isMounted()) {
	        return;
	      }
	      var width = this.elements.root.offsetWidth;
	      main_core.Dom.clean(this.elements.panel);
	      if (this.userModel.localUser && this.allowBackgroundItem) {
	        if (width > 300) {
	          this.elements.panel.appendChild(this.elements.buttonBackground);
	        } else {
	          this.elements.panel.appendChild(this.elements.buttonMenu);
	        }
	      }
	      if (this.allowPinButton) {
	        if (this.userModel.pinned) {
	          this.elements.panel.appendChild(this.elements.buttonUnPin);
	        } else {
	          this.elements.panel.appendChild(this.elements.buttonPin);
	        }
	        if (width > 250) {
	          this.elements.buttonPin.classList.remove("no-text");
	          this.elements.buttonUnPin.classList.remove("no-text");
	        } else {
	          this.elements.buttonPin.classList.add("no-text");
	          this.elements.buttonUnPin.classList.add("no-text");
	        }
	      }
	    }
	  }, {
	    key: "playVideoElements",
	    value: function playVideoElements(videoElement) {
	      var _this3 = this;
	      var hasVideoEl = !!videoElement;
	      var isCanPlaying = hasVideoEl && !!videoElement.srcObject;
	      var isPaused = hasVideoEl && videoElement.paused;
	      var isReadyPlaying = hasVideoEl && videoElement.readyState >= videoElement.HAVE_CURRENT_DATA;
	      var isEnded = hasVideoEl && videoElement.ended;
	      if (hasVideoEl && !isPaused) {
	        videoElement.pause();
	      }
	      if (isCanPlaying && isReadyPlaying && !isEnded) {
	        videoElement.play()["catch"](logPlaybackError);
	      }
	      if (isCanPlaying && isEnded) {
	        videoElement.load();
	      }
	      if (isCanPlaying && !isReadyPlaying && !isEnded && !videoElement.onloadeddata) {
	        videoElement.onloadeddata = function () {
	          _this3.playVideoElements(videoElement);
	        };
	      }
	    }
	  }, {
	    key: "update",
	    value: function update() {
	      if (!this.elements.root) {
	        return;
	      }
	      if (this.hasVideo() /* && this.visible*/) {
	        var _this$videoRenderer, _this$videoRenderer2;
	        if (this.visible) {
	          var _this$elements$video$, _this$stream;
	          if (this.videoRenderer) {
	            this.videoRenderer.render(this.elements.video);
	            this.playVideoElements(this.elements.video);
	            if (this._previewRenderer) {
	              this._previewRenderer.render(this.elements.preview);
	            } else {
	              this.elements.preview.srcObject = null;
	            }
	          } else if (this.stream && ((_this$elements$video$ = this.elements.video.srcObject) === null || _this$elements$video$ === void 0 ? void 0 : _this$elements$video$.id) !== ((_this$stream = this.stream) === null || _this$stream === void 0 ? void 0 : _this$stream.id)) {
	            this.elements.video.srcObject = this.stream;
	            this.playVideoElements(this.elements.video);
	          }
	          if (this.elements.avatarContainer) {
	            this.elements.avatarContainer.classList.add('bx-messenger-videocall-hidden-avatar');
	          }
	        }
	        if (((_this$videoRenderer = this.videoRenderer) === null || _this$videoRenderer === void 0 ? void 0 : _this$videoRenderer.kind) === 'video' && this.flipVideo) {
	          this.elements.video.classList.toggle("bx-messenger-videocall-video-flipped", this.flipVideo);
	          this.elements.preview.classList.toggle("bx-messenger-videocall-video-flipped", !this.flipVideo);
	        } else if (((_this$videoRenderer2 = this.videoRenderer) === null || _this$videoRenderer2 === void 0 ? void 0 : _this$videoRenderer2.kind) === 'sharing' && this.flipVideo) {
	          this.elements.video.classList.toggle("bx-messenger-videocall-video-flipped", !this.flipVideo);
	          this.elements.preview.classList.toggle("bx-messenger-videocall-video-flipped", this.flipVideo);
	        } else {
	          this.elements.video.classList.toggle("bx-messenger-videocall-video-flipped", this.flipVideo);
	        }
	        this.elements.video.classList.toggle("bx-messenger-videocall-video-contain", this.userModel.screenState);
	      } else {
	        this.elements.video.srcObject = null;
	        this.elements.preview.srcObject = null;
	        if (this.elements.avatarContainer) {
	          this.elements.avatarContainer.classList.remove('bx-messenger-videocall-hidden-avatar');
	        }
	      }
	      if (Util.isCallServerAllowed() && this.userModel.state === UserState.Connected && !this.elements.debugPanel.parentElement && !this.screenSharingUser) {
	        this.elements.container.appendChild(this.elements.debugPanel);
	      }
	      this.updatePanelDeferred();
	    }
	  }, {
	    key: "playAudio",
	    value: function playAudio() {
	      if (!this.audioStream) {
	        this.elements.audio.srcObject = null;
	        return;
	      }
	      if (this.speakerId && main_core.Type.isFunction(this.elements.audio.setSinkId)) {
	        this.elements.audio.setSinkId(this.speakerId).then(function () {
	          this.elements.audio.srcObject = this.audioStream;
	          this.elements.audio.play()["catch"](logPlaybackError);
	        }.bind(this))["catch"](console.error);
	      } else {
	        this.elements.audio.srcObject = this.audioStream;
	        this.elements.audio.play()["catch"](logPlaybackError);
	      }
	    }
	  }, {
	    key: "playScreenAudio",
	    value: function playScreenAudio() {
	      if (!this.screenAudioStream) {
	        this.elements.screenAudio.srcObject = null;
	        return;
	      }
	      this.elements.screenAudio.srcObject = this.screenAudioStream;
	      this.elements.screenAudio.play()["catch"](logPlaybackError);
	    }
	  }, {
	    key: "playVideo",
	    value: function playVideo() {
	      this.playVideoElements(this.elements.video);
	      this.playVideoElements(this.elements.preview);
	    }
	  }, {
	    key: "blurVideo",
	    value: function blurVideo(blurState) {
	      blurState = !!blurState;
	      if (this.videoBlurState == blurState) {
	        return;
	      }
	      this.videoBlurState = blurState;
	      if (this.elements.video) {
	        this.elements.video.classList.toggle('bx-messenger-videocall-video-blurred');
	      }
	    }
	  }, {
	    key: "getStateMessage",
	    value: function getStateMessage(userState, videoPaused) {
	      switch (userState) {
	        case UserState.Idle:
	          return "";
	        case UserState.Calling:
	          return BX.message("IM_M_CALL_STATUS_WAIT_ANSWER");
	        case UserState.Declined:
	          return BX.message("IM_M_CALL_STATUS_DECLINED");
	        case UserState.Ready:
	        case UserState.Connecting:
	          return BX.message("IM_M_CALL_STATUS_WAIT_CONNECT");
	        case UserState.Connected:
	          return videoPaused ? BX.message("IM_M_CALL_STATUS_VIDEO_PAUSED") : "";
	        case UserState.Failed:
	          return BX.message("IM_M_CALL_STATUS_CONNECTION_ERROR");
	        case UserState.Unavailable:
	          return BX.message("IM_M_CALL_STATUS_UNAVAILABLE");
	        default:
	          return "";
	      }
	    }
	  }, {
	    key: "mount",
	    value: function mount(parent, force) {
	      force = force === true;
	      if (!this.elements.root) {
	        this.render();
	      }
	      if (this.isMounted() && this.elements.root.parentElement == parent && !force) {
	        this.updatePanelDeferred();
	        return false;
	      }
	      parent.appendChild(this.elements.root);
	      this.update();
	    }
	  }, {
	    key: "dismount",
	    value: function dismount() {
	      // this.visible = false;
	      if (!this.isMounted()) {
	        return false;
	      }
	      this.elements.video.srcObject = null;
	      this.elements.preview.srcObject = null;
	      main_core.Dom.remove(this.elements.root);
	    }
	  }, {
	    key: "isMounted",
	    value: function isMounted() {
	      return !!(this.elements.root && this.elements.root.parentElement);
	    }
	  }, {
	    key: "updateState",
	    value: function updateState() {
	      if (!this.elements.root) {
	        return;
	      }
	      if (this.userModel.state == UserState.Calling || this.userModel.state == UserState.Connecting) {
	        this.updateAvatarPulseState();
	      } else {
	        this.addAvatarPulseTimer();
	      }
	      if (this.userModel.state == UserState.Idle) {
	        this._videoRenderer = null;
	        this._previewRenderer = null;
	        this._audioTrack = null;
	        this._audioStream = null;
	      }
	      this.elements.state.innerText = this.getStateMessage(this.userModel.state, this.userModel.videoPaused);
	      this.updateMicrophoneState();
	      this.updateCameraState();
	      this.update();
	    }
	  }, {
	    key: "updateTalking",
	    value: function updateTalking() {
	      if (!this.elements.root) {
	        return;
	      }
	      if (this.userModel.talking) {
	        this.updateAvatarPulseState();
	      } else {
	        this.addAvatarPulseTimer();
	      }
	    }
	  }, {
	    key: "updateMicrophoneState",
	    value: function updateMicrophoneState() {
	      if (!this.elements.root) {
	        return;
	      }
	      if (!this.isVisibleMicStateIcon()) {
	        this.elements.micState.classList.add("hidden");
	      } else {
	        this.elements.micState.classList.remove("hidden");
	        this.clearAvatarPulseTimer();
	      }
	      if (this.isVisibleCameraStateIcon() && this.isVisibleMicStateIcon()) {
	        this.elements.nameContainer.classList.add("extra-padding");
	      } else {
	        this.elements.nameContainer.classList.remove("extra-padding");
	      }
	    }
	  }, {
	    key: "updateCameraState",
	    value: function updateCameraState() {
	      if (!this.elements.root) {
	        return;
	      }
	      if (!this.isVisibleCameraStateIcon()) {
	        this.elements.cameraState.classList.add("hidden");
	      } else {
	        this.elements.cameraState.classList.remove("hidden");
	      }
	      if (this.isVisibleCameraStateIcon() && this.isVisibleMicStateIcon()) {
	        this.elements.nameContainer.classList.add("extra-padding");
	      } else {
	        this.elements.nameContainer.classList.remove("extra-padding");
	      }
	    }
	  }, {
	    key: "updateVideoPaused",
	    value: function updateVideoPaused() {
	      if (!this.elements.root) {
	        return;
	      }
	      if (this.stream && this.hasVideo()) {
	        this.blurVideo(this.userModel.videoPaused);
	      }
	      this.updateState();
	    }
	  }, {
	    key: "updateFloorRequestState",
	    value: function updateFloorRequestState() {
	      if (!this.elements.floorRequest) {
	        return;
	      }
	      if (this.userModel.floorRequestState) {
	        this.elements.floorRequest.classList.add("active");
	      } else {
	        this.elements.floorRequest.classList.remove("active");
	      }
	    }
	  }, {
	    key: "updateScreenState",
	    value: function updateScreenState() {
	      if (!this.elements.video) {
	        return;
	      }
	      if (this.userModel.screenState) {
	        this.elements.video.classList.add("bx-messenger-videocall-video-contain");
	      } else {
	        this.elements.video.classList.remove("bx-messenger-videocall-video-contain");
	      }
	    }
	  }, {
	    key: "hide",
	    value: function hide() {
	      if (!this.elements.root) {
	        return;
	      }
	      this.elements.root.dataset.hidden = 1;
	    }
	  }, {
	    key: "show",
	    value: function show() {
	      if (!this.elements.root) {
	        return;
	      }
	      delete this.elements.root.dataset.hidden;
	    }
	  }, {
	    key: "hasVideo",
	    value: function hasVideo() {
	      return this.userModel.state == UserState.Connected && (!!this._videoTrack || !!this._videoRenderer);
	    }
	  }, {
	    key: "hasCameraVideo",
	    value: function hasCameraVideo() {
	      var _this$_videoRenderer, _this$_previewRendere;
	      return this.userModel.state == UserState.Connected && (!!this._videoTrack || ((_this$_videoRenderer = this._videoRenderer) === null || _this$_videoRenderer === void 0 ? void 0 : _this$_videoRenderer.kind) === 'video' || ((_this$_previewRendere = this._previewRenderer) === null || _this$_previewRendere === void 0 ? void 0 : _this$_previewRendere.kind) === 'video');
	    }
	  }, {
	    key: "checkVideoAspect",
	    value: function checkVideoAspect() {
	      if (!this.elements.video) {
	        return;
	      }
	      if (this.elements.video.videoHeight > this.elements.video.videoWidth) {
	        this.elements.video.classList.add("bx-messenger-videocall-video-vertical");
	      } else {
	        this.elements.video.classList.remove("bx-messenger-videocall-video-vertical");
	      }
	    }
	  }, {
	    key: "releaseStream",
	    value: function releaseStream() {
	      if (this._videoRenderer && !this._previewRenderer) {
	        if (this.elements.video) {
	          this.elements.video.srcObject = null;
	        }
	        this._videoRenderer = null;
	      } else {
	        if (this.elements.video) {
	          this.elements.video.srcObject = null;
	        }
	        this.videoTrack = null;
	      }
	    }
	  }, {
	    key: "_getVideoStats",
	    value: function _getVideoStats(videoStats) {
	      var resultString = '';
	      var limitationsString = '';
	      resultString += "Bitrate: ".concat((videoStats === null || videoStats === void 0 ? void 0 : videoStats.bitrate) || 0, "\n");
	      resultString += "PacketsLost: ".concat((videoStats === null || videoStats === void 0 ? void 0 : videoStats.packetsLostExtended) || 0, "\n");
	      resultString += "Codec: ".concat((videoStats === null || videoStats === void 0 ? void 0 : videoStats.codecName) || '-', "\n");
	      resultString += "Resolution: ".concat((videoStats === null || videoStats === void 0 ? void 0 : videoStats.frameWidth) || 0, "x").concat((videoStats === null || videoStats === void 0 ? void 0 : videoStats.frameHeight) || 0, " ");
	      if (videoStats !== null && videoStats !== void 0 && videoStats.qualityLimitationReason) {
	        resultString += "(changes:".concat(videoStats.qualityLimitationResolutionChanges, ", FPS: ").concat((videoStats === null || videoStats === void 0 ? void 0 : videoStats.framesPerSecond) || 0, ")");
	        limitationsString = "Limitation: ".concat(videoStats.qualityLimitationReason);
	        limitationsString += " (duration: ".concat(Object.entries(videoStats.qualityLimitationDurations || {}).reduce(function (accumulator, value, index) {
	          return accumulator + "".concat(index ? ', ' : '') + "".concat(value[0], ": ").concat(value[1]);
	        }, ''), ")");
	      } else {
	        resultString += "(".concat((videoStats === null || videoStats === void 0 ? void 0 : videoStats.framesPerSecond) || 0, " FPS)");
	      }
	      return {
	        resultString: resultString,
	        limitationsString: limitationsString
	      };
	    }
	  }, {
	    key: "_formatVideoStats",
	    value: function _formatVideoStats(videoStats) {
	      var _this4 = this;
	      var result = '';
	      var limitations = '';
	      if (main_core.Type.isArray(videoStats)) {
	        videoStats.forEach(function (stats, trackIndex) {
	          if (trackIndex) {
	            result += "\n\n";
	          }
	          if (videoStats.length > 1) {
	            result += "Track ".concat(trackIndex + 1, "\n");
	          }
	          var _this4$_getVideoStats = _this4._getVideoStats(stats),
	            resultString = _this4$_getVideoStats.resultString,
	            limitationsString = _this4$_getVideoStats.limitationsString;
	          if (resultString) {
	            result += resultString;
	          }
	          if (limitationsString) {
	            limitations = limitationsString;
	          }
	        });
	      } else {
	        var _this$_getVideoStats = this._getVideoStats(videoStats),
	          resultString = _this$_getVideoStats.resultString,
	          limitationsString = _this$_getVideoStats.limitationsString;
	        if (resultString) {
	          result += resultString;
	        }
	        if (limitationsString) {
	          limitations = limitationsString;
	        }
	      }
	      return limitations ? "".concat(limitations, "\n\n").concat(result) : result;
	    }
	  }, {
	    key: "showUserName",
	    value: function showUserName() {
	      var _this5 = this;
	      if (this.hideUserNameTimer) {
	        clearTimeout(this.hideUserNameTimer);
	        this.hideUserNameTimer = null;
	      }
	      if (this.elements.nameContainer) {
	        this.elements.nameContainer.classList.add('active');
	        this.hideUserNameTimer = setTimeout(function () {
	          _this5.elements.nameContainer.classList.remove('active');
	        }, 5000);
	      }
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      if (this.hintManager) {
	        this.hintManager.hide();
	        this.hintManager = null;
	      }
	      this.releaseStream();
	      clearInterval(this.checkAspectInterval);
	      document.removeEventListener('mousemove', this.onMouseMoveHandler);
	    }
	  }, {
	    key: "addAvatarPulseTimer",
	    value: function addAvatarPulseTimer() {
	      var _this6 = this;
	      if (this.removeAvatarPulseTimer) {
	        clearTimeout(this.removeAvatarPulseTimer);
	        this.removeAvatarPulseTimer = null;
	      }
	      this.removeAvatarPulseTimer = setTimeout(function () {
	        _this6.elements.avatarContainer.classList.remove("bx-messenger-videocall-user-avatar-pulse");
	        _this6.elements.root.classList.remove("bx-messenger-videocall-user-talking");
	      }, 1000);
	    }
	  }, {
	    key: "clearAvatarPulseTimer",
	    value: function clearAvatarPulseTimer() {
	      if (this.removeAvatarPulseTimer) {
	        clearTimeout(this.removeAvatarPulseTimer);
	        this.removeAvatarPulseTimer = null;
	      }
	      this.elements.avatarContainer.classList.remove("bx-messenger-videocall-user-avatar-pulse");
	      this.elements.root.classList.remove("bx-messenger-videocall-user-talking");
	    }
	  }, {
	    key: "updateAvatarPulseState",
	    value: function updateAvatarPulseState() {
	      if (this.removeAvatarPulseTimer) {
	        clearTimeout(this.removeAvatarPulseTimer);
	        this.removeAvatarPulseTimer = null;
	      }
	      this.elements.avatarContainer.classList.add("bx-messenger-videocall-user-avatar-pulse");
	      if (this.userModel.talking) {
	        this.elements.root.classList.add("bx-messenger-videocall-user-talking");
	      }
	    }
	  }, {
	    key: "id",
	    get: function get() {
	      return this.userModel.id;
	    }
	  }, {
	    key: "allowPinButton",
	    get: function get() {
	      return this._allowPinButton;
	    },
	    set: function set(allowPinButton) {
	      if (this._allowPinButton == allowPinButton) {
	        return;
	      }
	      this._allowPinButton = allowPinButton;
	      this.update();
	    }
	  }, {
	    key: "audioTrack",
	    get: function get() {
	      return this._audioTrack;
	    },
	    set: function set(audioTrack) {
	      if (this._audioTrack === audioTrack) {
	        return;
	      }
	      this._audioTrack = audioTrack;
	      this._audioStream = this._audioTrack ? new MediaStream([this._audioTrack]) : null;
	      this.playAudio();
	    }
	  }, {
	    key: "audioStream",
	    get: function get() {
	      return this._audioStream;
	    }
	  }, {
	    key: "screenAudioTrack",
	    get: function get() {
	      return this._screenAudioTrack;
	    },
	    set: function set(screenAudioTrack) {
	      if (this._screenAudioTrack === screenAudioTrack) {
	        return;
	      }
	      this._screenAudioTrack = screenAudioTrack;
	      this._screenAudioStream = this._screenAudioTrack ? new MediaStream([this._screenAudioTrack]) : null;
	      this.playScreenAudio();
	    }
	  }, {
	    key: "screenAudioStream",
	    get: function get() {
	      return this._screenAudioStream;
	    }
	  }, {
	    key: "flipVideo",
	    get: function get() {
	      return this._flipVideo;
	    },
	    set: function set(flipVideo) {
	      this._flipVideo = flipVideo;
	      this.update();
	    }
	  }, {
	    key: "stream",
	    get: function get() {
	      return this._stream;
	    }
	  }, {
	    key: "visible",
	    get: function get() {
	      return this._visible;
	    },
	    set: function set(visible) {
	      if (this._visible !== visible) {
	        this._visible = visible;
	        this.update();
	        this.updateRendererState();
	      }
	    }
	  }, {
	    key: "videoRenderer",
	    get: function get() {
	      return this._videoRenderer;
	    },
	    set: function set(videoRenderer) {
	      // we should to reset old video track after switching from a plain call
	      // in order to properly check the camera video in hasCameraVideo
	      if (this._videoTrack) {
	        this._videoTrack = null;
	      }
	      if (this._badNetworkIndicator) {
	        // Voximplant calls logic with support of streams disabling
	        if (videoRenderer.stream) {
	          this._tempVideoRenderer = videoRenderer;
	          this._videoRenderer = null;
	        } else {
	          this._tempVideoRenderer = this._videoRenderer = null;
	        }
	      } else {
	        var _this$_videoRenderer2;
	        // Bitrix calls logic with support of preview
	        this._tempVideoRenderer = null;
	        var currentVideoRendererKind = (_this$_videoRenderer2 = this._videoRenderer) === null || _this$_videoRenderer2 === void 0 ? void 0 : _this$_videoRenderer2.kind;
	        var newVideoRendererKind = videoRenderer === null || videoRenderer === void 0 ? void 0 : videoRenderer.kind;
	        if (videoRenderer.stream) {
	          if (newVideoRendererKind === 'sharing' && currentVideoRendererKind === 'video') {
	            this._previewRenderer = this._videoRenderer;
	            this._videoRenderer = videoRenderer;
	          } else if (newVideoRendererKind === 'video' && currentVideoRendererKind === 'sharing') {
	            this._previewRenderer = videoRenderer;
	          } else {
	            this._videoRenderer = videoRenderer;
	          }
	        } else {
	          if (newVideoRendererKind === 'sharing') {
	            if (currentVideoRendererKind === 'sharing') {
	              this._videoRenderer = this._previewRenderer;
	            }
	            this._previewRenderer = null;
	            delete this.connectionStats[MediaStreamsKinds.Screen];
	          } else if (newVideoRendererKind === 'video') {
	            if (currentVideoRendererKind === 'sharing') {
	              this._previewRenderer = null;
	            } else {
	              this._videoRenderer = null;
	            }
	            delete this.connectionStats[MediaStreamsKinds.Camera];
	          }
	          this.showConnectionStats();
	        }
	      }
	      this.update();
	      this.updateRendererState();
	    }
	  }, {
	    key: "previewRenderer",
	    get: function get() {
	      return this._previewRenderer;
	    }
	  }, {
	    key: "videoTrack",
	    get: function get() {
	      return this._videoTrack;
	    },
	    set: function set(videoTrack) {
	      if (this._videoTrack === videoTrack) {
	        return;
	      }
	      this._videoTrack = videoTrack;
	      if (this._videoTrack && this._stream) {
	        this._stream.removeTrack(this._stream.getVideoTracks()[0]);
	        this._stream.addTrack(this._videoTrack);
	      } else {
	        this._stream = this._videoTrack ? new MediaStream([this._videoTrack]) : null;
	      }
	      this.update();
	    }
	  }, {
	    key: "badNetworkIndicator",
	    set: function set(badNetworkIndicator) {
	      if (this._badNetworkIndicator === badNetworkIndicator) {
	        return;
	      }
	      this._badNetworkIndicator = badNetworkIndicator;
	      if (this._badNetworkIndicator) {
	        if (this._videoRenderer) {
	          this._tempVideoRenderer = this._videoRenderer;
	          this._videoRenderer = null;
	        }
	      } else {
	        if (this._tempVideoRenderer) {
	          this._videoRenderer = this._tempVideoRenderer;
	          this._tempVideoRenderer = null;
	        }
	      }
	      this.update();
	    }
	  }, {
	    key: "hasConnectionProblem",
	    set: function set(hasConnectionProblem) {
	      this._hasConnectionProblem = hasConnectionProblem;
	      if (this._hasConnectionProblem) {
	        this.elements.connectionProblem.classList.add("connection-problem-visible");
	      } else {
	        this.elements.connectionProblem.classList.remove("connection-problem-visible");
	      }
	    }
	  }, {
	    key: "connectionQuality",
	    set: function set(connectionQuality) {
	      this._connectionQuality = connectionQuality;
	      var connectionQualityIcons = {
	        excellent: '--excellent-quality-icon',
	        good: '--good-quality-icon',
	        poor: '--poor-quality-icon',
	        bad: '--bad-quality-icon'
	      };
	      if (this._connectionQuality !== undefined && this.elements.connectionQualityIcon) {
	        var resultIcon = connectionQualityIcons.bad;
	        if (this._connectionQuality >= 4) {
	          resultIcon = connectionQualityIcons.excellent;
	        }
	        if (this._connectionQuality >= 3 && this._connectionQuality < 4) {
	          resultIcon = connectionQualityIcons.good;
	        }
	        if (this._connectionQuality >= 2 && this._connectionQuality < 3) {
	          resultIcon = connectionQualityIcons.poor;
	        }
	        if (this._connectionQuality < 2) {
	          resultIcon = connectionQualityIcons.bad;
	        }
	        this.elements.connectionQualityIcon.style.setProperty('--connection-quality-icon', "var(".concat(resultIcon, ")"));
	      }
	    }
	  }]);
	  return CallUser;
	}();

	var FloorRequest = /*#__PURE__*/function (_EventEmitter) {
	  babelHelpers.inherits(FloorRequest, _EventEmitter);
	  function FloorRequest(config) {
	    var _this;
	    babelHelpers.classCallCheck(this, FloorRequest);
	    _this = babelHelpers.possibleConstructorReturn(this, babelHelpers.getPrototypeOf(FloorRequest).call(this));
	    _this.setEventNamespace("BX.Call.FloorRequest");
	    _this.hideTime = BX.prop.getInteger(config, "hideTime", 10);
	    _this.userModel = config.userModel;
	    _this.elements = {
	      root: null,
	      avatar: null
	    };
	    _this._hideTimeout = null;
	    _this._onUserModelChangedHandler = _this._onUserModelChanged.bind(babelHelpers.assertThisInitialized(_this));
	    _this.userModel.subscribe("changed", _this._onUserModelChangedHandler);
	    return _this;
	  }
	  babelHelpers.createClass(FloorRequest, [{
	    key: "mount",
	    value: function mount(container) {
	      container.appendChild(this.render());
	      this.scheduleDismount();
	    }
	  }, {
	    key: "dismount",
	    value: function dismount() {
	      BX.remove(this.elements.root);
	      this.destroy();
	    }
	  }, {
	    key: "dismountWithAnimation",
	    value: function dismountWithAnimation() {
	      var _this2 = this;
	      if (!this.elements.root) {
	        return;
	      }
	      this.elements.root.classList.add("closing");
	      this.elements.root.addEventListener("animationend", function () {
	        return _this2.dismount();
	      });
	    }
	  }, {
	    key: "render",
	    value: function render() {
	      if (this.elements.root) {
	        return this.elements.root;
	      }
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-call-view-floor-request-notification"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-call-view-floor-request-notification-icon-container"
	          },
	          children: [this.elements.avatar = main_core.Dom.create("div", {
	            props: {
	              className: "bx-call-view-floor-request-notification-avatar"
	            },
	            text: ''
	          }), main_core.Dom.create("div", {
	            props: {
	              className: "bx-call-view-floor-request-notification-icon bx-messenger-videocall-floor-request-icon"
	            }
	          })]
	        }), this.elements.name = main_core.Dom.create("span", {
	          props: {
	            className: "bx-call-view-floor-request-notification-text-container"
	          },
	          html: BX.message("IM_CALL_WANTS_TO_SAY_" + (this.userModel.gender == "F" ? "F" : "M")).replace("#NAME#", '<span class ="bx-call-view-floor-request-notification-text-name">' + BX.util.htmlspecialchars(this.userModel.name) + '</span>')
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-call-view-floor-request-notification-close"
	          },
	          events: {
	            click: this.dismount.bind(this)
	          }
	        })]
	      });
	      if (this.userModel.avatar) {
	        this.elements.avatar.style.setProperty("--avatar", "url('" + this.userModel.avatar + "')");
	        this.elements.avatar.innerText = '';
	      } else {
	        this.elements.avatar.innerText = im_v2_lib_utils.Utils.text.getFirstLetters(this.userModel.name).toUpperCase();
	      }
	      return this.elements.root;
	    }
	  }, {
	    key: "scheduleDismount",
	    value: function scheduleDismount() {
	      return;
	      this._hideTimeout = setTimeout(this.dismountWithAnimation.bind(this), this.hideTime * 1000);
	    }
	  }, {
	    key: "_onUserModelChanged",
	    value: function _onUserModelChanged(event) {
	      var eventData = event.data;
	      if (eventData.fieldName == "floorRequestState" && !this.userModel.floorRequestState) {
	        this.dismountWithAnimation();
	      }
	      if (this.userModel.avatar === '' && this.elements.avatar) {
	        this.elements.avatar.innerText = im_v2_lib_utils.Utils.text.getFirstLetters(this.userModel.name).toUpperCase();
	      }
	      if (this.elements.name) {
	        this.elements.name.innerHtml = BX.message("IM_CALL_WANTS_TO_SAY_" + (this.userModel.gender == "F" ? "F" : "M")).replace("#NAME#", '<span class ="bx-call-view-floor-request-notification-text-name">' + BX.util.htmlspecialchars(this.userModel.name) + '</span>');
	      }
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      clearTimeout(this._hideTimeout);
	      this._hideTimeout = null;
	      this.elements = null;
	      if (this.userModel) {
	        this.userModel.unsubscribe("changed", this._onUserModelChangedHandler);
	        this.userModel = null;
	      }
	      this.emit("onDestroy", {});
	    }
	  }], [{
	    key: "create",
	    value: function create(config) {
	      return new FloorRequest(config);
	    }
	  }]);
	  return FloorRequest;
	}(main_core_events.EventEmitter);

	var maximumNotifications = 5;
	var instance;
	var NotificationManager = /*#__PURE__*/function () {
	  function NotificationManager() {
	    babelHelpers.classCallCheck(this, NotificationManager);
	    this.maxNotification = maximumNotifications;
	    this.notifications = [];
	  }
	  babelHelpers.createClass(NotificationManager, [{
	    key: "addNotification",
	    value: function addNotification(notification) {
	      var _this = this;
	      notification.subscribe("onDestroy", function () {
	        return _this.onNotificationDestroy(notification);
	      });
	      this.notifications.push(notification);
	      if (this.notifications.length > this.maxNotification) {
	        var firstNotification = this.notifications.shift();
	        firstNotification.dismount();
	      }
	    }
	  }, {
	    key: "onNotificationDestroy",
	    value: function onNotificationDestroy(notification) {
	      var index = this.notifications.indexOf(notification);
	      if (index != -1) {
	        this.notifications.splice(index, 1);
	      }
	    }
	  }], [{
	    key: "Instance",
	    get: function get() {
	      if (!instance) {
	        instance = new NotificationManager();
	      }
	      return instance;
	    }
	  }]);
	  return NotificationManager;
	}();

	var DeviceSelectorEvents = {
	  onMicrophoneSelect: "onMicrophoneSelect",
	  onMicrophoneSwitch: "onMicrophoneSwitch",
	  onCameraSelect: "onCameraSelect",
	  onCameraSwitch: "onCameraSwitch",
	  onSpeakerSelect: "onSpeakerSelect",
	  onSpeakerSwitch: "onSpeakerSwitch",
	  onChangeHdVideo: "onChangeHdVideo",
	  onChangeMicAutoParams: "onChangeMicAutoParams",
	  onChangeFaceImprove: "onChangeFaceImprove",
	  onAdvancedSettingsClick: "onOpenAdvancedSettingsClick",
	  onShow: "onShow",
	  onDestroy: "onDestroy"
	};

	/**
	 * @param config
	 * @param {Node} config.parentElement
	 * @param {boolean} config.cameraEnabled
	 * @param {boolean} config.microphoneEnabled
	 * @param {boolean} config.speakerEnabled
	 * @param {boolean} config.allowHdVideo
	 * @param {boolean} config.faceImproveEnabled
	 * @param {object} config.events

	 * @returns {DeviceSelector}
	 */

	/**
	 * @param config
	 * @param {Node} config.parentElement
	 * @param {number} config.zIndex
	 * @param {boolean} config.cameraEnabled
	 * @param {boolean} config.microphoneEnabled
	 * @param {boolean} config.speakerEnabled
	 * @param {boolean} config.allowHdVideo
	 * @param {boolean} config.faceImproveEnabled
	 * @constructor
	 */
	var DeviceSelector = /*#__PURE__*/function () {
	  function DeviceSelector(config) {
	    var _this = this;
	    babelHelpers.classCallCheck(this, DeviceSelector);
	    this.viewElement = config.viewElement || null;
	    this.parentElement = config.parentElement;
	    this.zIndex = config.zIndex;
	    this.cameraEnabled = BX.prop.getBoolean(config, "cameraEnabled", false);
	    this.cameraId = BX.prop.getString(config, "cameraId", false);
	    this.microphoneEnabled = BX.prop.getBoolean(config, "microphoneEnabled", false);
	    this.microphoneId = BX.prop.getString(config, "microphoneId", false);
	    this.speakerEnabled = BX.prop.getBoolean(config, "speakerEnabled", false);
	    this.speakerId = BX.prop.getString(config, "speakerId", false);
	    this.allowHdVideo = BX.prop.getBoolean(config, "allowHdVideo", false);
	    this.faceImproveEnabled = BX.prop.getBoolean(config, "faceImproveEnabled", false);
	    this.allowFaceImprove = BX.prop.getBoolean(config, "allowFaceImprove", false);
	    this.allowBackground = BX.prop.getBoolean(config, "allowBackground", true);
	    this.allowMask = BX.prop.getBoolean(config, "allowMask", true);
	    this.allowAdvancedSettings = BX.prop.getBoolean(config, "allowAdvancedSettings", false);
	    this.switchCameraBlocked = config.switchCameraBlocked || false;
	    this.switchMicrophoneBlocked = config.switchMicrophoneBlocked || false;
	    this.isDestroying = false;
	    this.popup = null;
	    this.eventEmitter = new BX.Event.EventEmitter(this, "DeviceSelector");
	    this.elements = {
	      root: null,
	      micContainer: null,
	      cameraContainer: null,
	      speakerContainer: null
	    };
	    var eventListeners = BX.prop.getObject(config, "events", {});
	    Object.values(DeviceSelectorEvents).forEach(function (eventName) {
	      if (eventListeners[eventName]) {
	        _this.eventEmitter.subscribe(eventName, eventListeners[eventName]);
	      }
	    });
	  }
	  babelHelpers.createClass(DeviceSelector, [{
	    key: "show",
	    // static create(config)
	    // {
	    // 	return new DeviceSelector(config);
	    // };
	    value: function show() {
	      var _this2 = this;
	      if (this.popup) {
	        this.popup.show();
	        return;
	      }
	      this.popup = new main_popup.Popup({
	        id: 'call-view-device-selector',
	        bindElement: this.parentElement,
	        targetContainer: this.viewElement,
	        autoHide: true,
	        zIndex: this.zIndex,
	        closeByEsc: true,
	        offsetTop: 20,
	        offsetLeft: -20,
	        bindOptions: {
	          position: 'top'
	        },
	        angle: false,
	        background: '#22272B',
	        overlay: {
	          backgroundColor: '#22272B',
	          opacity: 0
	        },
	        content: this.render(),
	        events: {
	          onPopupClose: function onPopupClose() {
	            return _this2.popup.destroy();
	          },
	          onPopupDestroy: function onPopupDestroy() {
	            return _this2.destroy();
	          }
	        }
	      });
	      this.popup.show();
	      this.eventEmitter.emit(DeviceSelectorEvents.onShow, {});
	    }
	  }, {
	    key: "render",
	    value: function render() {
	      var _this3 = this;
	      if (this.elements.root) {
	        return this.elements.root;
	      }
	      return main_core.Dom.create("div", {
	        props: {
	          className: "bx-call-view-device-selector"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-call-view-device-selector-top"
	          },
	          children: [(this.microphoneContainer = DeviceMenu.create({
	            blocked: this.switchMicrophoneBlocked,
	            deviceLabel: BX.message("IM_M_CALL_BTN_MIC"),
	            deviceList: Hardware.getMicrophoneList(),
	            selectedDevice: this.microphoneId,
	            deviceEnabled: this.microphoneEnabled,
	            icons: ["microphone", "microphone-off"],
	            events: {
	              onSwitch: this.onMicrophoneSwitch.bind(this),
	              onSelect: this.onMicrophoneSelect.bind(this)
	            }
	          })).render(), (this.cameraContainer = DeviceMenu.create({
	            blocked: this.switchCameraBlocked,
	            deviceLabel: BX.message("IM_M_CALL_BTN_CAMERA"),
	            deviceList: Hardware.getCameraList(),
	            selectedDevice: this.cameraId,
	            deviceEnabled: this.cameraEnabled,
	            icons: ["camera", "camera-off"],
	            events: {
	              onSwitch: this.onCameraSwitch.bind(this),
	              onSelect: this.onCameraSelect.bind(this)
	            }
	          })).render(), Hardware.canSelectSpeaker() ? DeviceMenu.create({
	            deviceLabel: BX.message("IM_M_CALL_BTN_SPEAKER"),
	            deviceList: Hardware.getSpeakerList(),
	            selectedDevice: this.speakerId,
	            deviceEnabled: this.speakerEnabled,
	            icons: ["speaker", "speaker-off"],
	            events: {
	              onSwitch: this.onSpeakerSwitch.bind(this),
	              onSelect: this.onSpeakerSelect.bind(this)
	            }
	          }).render() : null]
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-call-view-device-selector-bottom"
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-call-view-device-selector-bottom-item"
	            },
	            children: [main_core.Dom.create("input", {
	              props: {
	                id: "device-selector-hd-video",
	                className: "bx-call-view-device-selector-bottom-item-checkbox"
	              },
	              attrs: {
	                type: "checkbox",
	                checked: this.allowHdVideo
	              },
	              events: {
	                change: this.onAllowHdVideoChange.bind(this)
	              }
	            }), main_core.Dom.create("label", {
	              props: {
	                className: "bx-call-view-device-selector-bottom-item-label"
	              },
	              attrs: {
	                "for": "device-selector-hd-video"
	              },
	              text: BX.message("IM_M_CALL_HD_VIDEO")
	            })]
	          }), this.allowFaceImprove ? main_core.Dom.create("div", {
	            props: {
	              className: "bx-call-view-device-selector-bottom-item"
	            },
	            children: [main_core.Dom.create("input", {
	              props: {
	                id: "device-selector-mic-auto-params",
	                className: "bx-call-view-device-selector-bottom-item-checkbox"
	              },
	              attrs: {
	                type: "checkbox",
	                checked: this.faceImproveEnabled
	              },
	              events: {
	                change: this.onFaceImproveChange.bind(this)
	              }
	            }), main_core.Dom.create("label", {
	              props: {
	                className: "bx-call-view-device-selector-bottom-item-label"
	              },
	              attrs: {
	                "for": "device-selector-mic-auto-params"
	              },
	              text: BX.message("IM_SETTINGS_HARDWARE_CAMERA_FACE_IMPROVE")
	            })]
	          }) : null, this.allowBackground ? main_core.Dom.create("div", {
	            props: {
	              className: "bx-call-view-device-selector-bottom-item"
	            },
	            children: [main_core.Dom.create("span", {
	              props: {
	                className: "bx-call-view-device-selector-bottom-item-action"
	              },
	              text: this.allowMask ? BX.message("IM_M_CALL_BG_MASK_CHANGE") : BX.message("IM_M_CALL_BACKGROUND_CHANGE"),
	              events: {
	                click: function click() {
	                  BackgroundDialog.open();
	                  _this3.popup.close();
	                }
	              }
	            })]
	          }) : null, main_core.Dom.create("div", {
	            props: {
	              className: "bx-call-view-device-selector-bottom-item"
	            },
	            children: [main_core.Dom.create("span", {
	              props: {
	                className: "bx-call-view-device-selector-bottom-item-action"
	              },
	              text: BX.message("CALL_RUN_SELF_TEST"),
	              events: {
	                click: function click() {
	                  Util.startSelfTest();
	                  _this3.popup.close();
	                }
	              }
	            })]
	          }), this.allowAdvancedSettings && !!BX.MessengerCommon ? main_core.Dom.create("div", {
	            props: {
	              className: "bx-call-view-device-selector-bottom-item"
	            },
	            children: [main_core.Dom.create("span", {
	              props: {
	                className: "bx-call-view-device-selector-bottom-item-action"
	              },
	              text: BX.message("IM_M_CALL_ADVANCED_SETTINGS"),
	              events: {
	                click: function click(e) {
	                  // to prevent BX.IM.autoHide
	                  e.stopPropagation();
	                  _this3.eventEmitter.emit(DeviceSelectorEvents.onAdvancedSettingsClick);
	                  _this3.popup.close();
	                }
	              }
	            })]
	          }) : null]
	        })]
	      });
	    }
	  }, {
	    key: "toggleCameraAvailability",
	    value: function toggleCameraAvailability(available) {
	      if (available) {
	        this.cameraContainer.unblock();
	        return;
	      }
	      this.cameraContainer.block();
	    }
	  }, {
	    key: "toggleMicrophoneAvailability",
	    value: function toggleMicrophoneAvailability(available) {
	      if (available) {
	        this.microphoneContainer.unblock();
	        return;
	      }
	      this.microphoneContainer.block();
	    }
	  }, {
	    key: "onMicrophoneSwitch",
	    value: function onMicrophoneSwitch() {
	      this.microphoneEnabled = !this.microphoneEnabled;
	      this.eventEmitter.emit(DeviceSelectorEvents.onMicrophoneSwitch, {
	        microphoneEnabled: this.microphoneEnabled
	      });
	    }
	  }, {
	    key: "onMicrophoneSelect",
	    value: function onMicrophoneSelect(e) {
	      this.eventEmitter.emit(DeviceSelectorEvents.onMicrophoneSelect, {
	        deviceId: e.data.deviceId
	      });
	    }
	  }, {
	    key: "onCameraSwitch",
	    value: function onCameraSwitch() {
	      this.cameraEnabled = !this.cameraEnabled;
	      this.eventEmitter.emit(DeviceSelectorEvents.onCameraSwitch, {
	        cameraEnabled: this.cameraEnabled
	      });
	    }
	  }, {
	    key: "onCameraSelect",
	    value: function onCameraSelect(e) {
	      this.eventEmitter.emit(DeviceSelectorEvents.onCameraSelect, {
	        deviceId: e.data.deviceId
	      });
	    }
	  }, {
	    key: "onSpeakerSwitch",
	    value: function onSpeakerSwitch() {
	      this.speakerEnabled = !this.speakerEnabled;
	      this.eventEmitter.emit(DeviceSelectorEvents.onSpeakerSwitch, {
	        speakerEnabled: this.speakerEnabled
	      });
	    }
	  }, {
	    key: "onSpeakerSelect",
	    value: function onSpeakerSelect(e) {
	      this.eventEmitter.emit(DeviceSelectorEvents.onSpeakerSelect, {
	        deviceId: e.data.deviceId
	      });
	    }
	  }, {
	    key: "onAllowHdVideoChange",
	    value: function onAllowHdVideoChange(e) {
	      this.allowHdVideo = e.currentTarget.checked;
	      this.eventEmitter.emit(DeviceSelectorEvents.onChangeHdVideo, {
	        allowHdVideo: this.allowHdVideo
	      });
	    }
	  }, {
	    key: "onAllowMirroringVideoChange",
	    value: function onAllowMirroringVideoChange(e) {
	      Hardware.enableMirroring = e.target.checked;
	    }
	  }, {
	    key: "onFaceImproveChange",
	    value: function onFaceImproveChange(e) {
	      this.faceImproveEnabled = e.currentTarget.checked;
	      this.eventEmitter.emit(DeviceSelectorEvents.onChangeFaceImprove, {
	        faceImproveEnabled: this.faceImproveEnabled
	      });
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      if (this.isDestroying) {
	        return;
	      }
	      this.isDestroying = true;
	      if (this.popup) {
	        this.popup.destroy();
	        this.popup = null;
	      }
	      this.eventEmitter.emit(DeviceSelectorEvents.onDestroy, {});
	    }
	  }]);
	  return DeviceSelector;
	}();
	babelHelpers.defineProperty(DeviceSelector, "Events", DeviceSelectorEvents);
	var DeviceMenuEvents = {
	  onSelect: "onSelect",
	  onSwitch: "onSwitch"
	};
	var DeviceMenu = /*#__PURE__*/function () {
	  function DeviceMenu(config) {
	    babelHelpers.classCallCheck(this, DeviceMenu);
	    config = BX.type.isObject(config) ? config : {};
	    this.menuBlocked = config.blocked || false;
	    this.deviceList = BX.prop.getArray(config, "deviceList", []);
	    this.selectedDevice = BX.prop.getString(config, "selectedDevice", "");
	    this.deviceEnabled = BX.prop.getBoolean(config, "deviceEnabled", false);
	    this.deviceLabel = BX.prop.getString(config, "deviceLabel", "");
	    this.icons = BX.prop.getArray(config, "icons", []);
	    this.eventEmitter = new main_core_events.EventEmitter(this, 'DeviceMenu');
	    this.elements = {
	      root: null,
	      switchIcon: null,
	      menuInner: null,
	      menuItems: {} // deviceId => {root: element, icon: element}
	    };

	    var events = BX.prop.getObject(config, "events", {});
	    for (var eventName in events) {
	      if (!events.hasOwnProperty(eventName)) {
	        continue;
	      }
	      this.eventEmitter.subscribe(eventName, events[eventName]);
	    }
	  }
	  babelHelpers.createClass(DeviceMenu, [{
	    key: "render",
	    value: function render() {
	      if (this.elements.root) {
	        return this.elements.root;
	      }
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-call-view-device-selector-menu-container"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-call-view-device-selector-switch-wrapper"
	          },
	          children: [this.elements.switchIcon = main_core.Dom.create("div", {
	            props: {
	              className: "bx-call-view-device-selector-device-icon " + this.getDeviceIconClass()
	            }
	          }), main_core.Dom.create("span", {
	            props: {
	              className: "bx-call-view-device-selector-device-text"
	            },
	            text: this.deviceLabel
	          }), main_core.Dom.create("div", {
	            props: {
	              className: "bx-call-view-device-selector-device-switch"
	            },
	            children: [new BX.UI.Switcher({
	              size: 'small',
	              checked: this.deviceEnabled,
	              handlers: {
	                toggled: this.onSwitchToggled.bind(this)
	              },
	              disabled: this.menuBlocked
	            }).getNode()]
	          })]
	        }), this.elements.menuInner = main_core.Dom.create("div", {
	          props: {
	            className: "bx-call-view-device-selector-menu-inner" + (this.menuBlocked ? ' inactive' : '')
	          },
	          children: this.deviceList.map(this.renderDevice.bind(this))
	        })]
	      });
	      return this.elements.root;
	    }
	  }, {
	    key: "renderDevice",
	    value: function renderDevice(deviceInfo) {
	      var iconClass = this.selectedDevice === deviceInfo.deviceId ? "selected" : "";
	      var deviceElements = {};
	      deviceElements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-call-view-device-selector-menu-item"
	        },
	        dataset: {
	          deviceId: deviceInfo.deviceId
	        },
	        children: [deviceElements.icon = main_core.Dom.create("div", {
	          props: {
	            className: "bx-call-view-device-selector-menu-item-icon " + iconClass
	          }
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-call-view-device-selector-menu-item-text"
	          },
	          text: deviceInfo.label || "(" + BX.message("IM_M_CALL_DEVICE_NO_NAME") + ")"
	        })],
	        events: {
	          click: this.onMenuItemClick.bind(this)
	        }
	      });
	      this.elements.menuItems[deviceInfo.deviceId] = deviceElements;
	      return deviceElements.root;
	    }
	  }, {
	    key: "block",
	    value: function block() {
	      this.menuBlocked = true;
	      this.elements.root.classList.add("bx-call-view-device-selector-menu-container-blocked");
	    }
	  }, {
	    key: "unblock",
	    value: function unblock() {
	      this.menuBlocked = false;
	      this.elements.root.classList.remove("bx-call-view-device-selector-menu-container-blocked");
	    }
	  }, {
	    key: "getDeviceIconClass",
	    value: function getDeviceIconClass() {
	      var result = "";
	      if (this.deviceEnabled && this.icons.length > 0) {
	        result = this.icons[0];
	      } else if (!this.deviceEnabled && this.icons.length > 1) {
	        result = this.icons[1];
	      }
	      return result;
	    }
	  }, {
	    key: "onSwitchToggled",
	    value: function onSwitchToggled() {
	      if (this.menuBlocked) {
	        return;
	      }
	      this.deviceEnabled = !this.deviceEnabled;
	      this.elements.switchIcon.className = "bx-call-view-device-selector-device-icon " + this.getDeviceIconClass();
	      this.eventEmitter.emit(DeviceMenuEvents.onSwitch, {
	        deviceEnabled: this.deviceEnabled
	      });
	    }
	  }, {
	    key: "onMenuItemClick",
	    value: function onMenuItemClick(e) {
	      var currentDevice = this.selectedDevice;
	      var selectedDevice = e.currentTarget.dataset.deviceId;
	      this.selectedDevice = selectedDevice;
	      if (this.elements.menuItems[currentDevice]) {
	        this.elements.menuItems[currentDevice]['icon'].classList.remove('selected');
	      }
	      if (this.elements.menuItems[this.selectedDevice]) {
	        this.elements.menuItems[this.selectedDevice]['icon'].classList.add('selected');
	      }
	      this.eventEmitter.emit(DeviceMenuEvents.onSelect, {
	        deviceId: this.selectedDevice
	      });
	    }
	  }], [{
	    key: "create",
	    value: function create(config) {
	      return new DeviceMenu(config);
	    }
	  }]);
	  return DeviceMenu;
	}();

	var CallAiError = {
	  AI_UNAVAILABLE_ERROR: 'AI_UNAVAILABLE_ERROR',
	  AI_SETTINGS_ERROR: 'AI_SETTINGS_ERROR',
	  AI_AGREEMENT_ERROR: 'AI_AGREEMENT_ERROR',
	  AI_NOT_ENOUGH_BAAS_ERROR: 'AI_NOT_ENOUGH_BAAS_ERROR'
	};
	var CallAi = /*#__PURE__*/function () {
	  function CallAi() {
	    babelHelpers.classCallCheck(this, CallAi);
	    this.serviceEnabled = false;
	    this.settingsEnabled = false;
	    this.recordingMinUsers = 1000;
	    this.agreementAccepted = false;
	    this.tariffAvailable = false;
	    this.baasAvailable = false;
	    this.feedBackLink = '';
	    this.baasPromoSlider = '';
	    this.helpSlider = '';
	    if (main_core.Extension.getSettings('call.core').ai) {
	      this.setup(main_core.Extension.getSettings('call.core').ai);
	    }
	  }
	  babelHelpers.createClass(CallAi, [{
	    key: "setup",
	    value: function setup(options) {
	      if (options.serviceEnabled !== undefined) {
	        this.serviceEnabled = options.serviceEnabled;
	      }
	      if (options.settingsEnabled !== undefined) {
	        this.settingsEnabled = options.settingsEnabled;
	      }
	      if (options.recordingMinUsers) {
	        this.recordingMinUsers = options.recordingMinUsers;
	      }
	      if (options.agreementAccepted !== undefined) {
	        this.agreementAccepted = options.agreementAccepted;
	      }
	      if (options.tariffAvailable !== undefined) {
	        this.tariffAvailable = options.tariffAvailable;
	      }
	      if (options.baasAvailable !== undefined) {
	        this.baasAvailable = options.baasAvailable;
	      }
	      if (options.feedBackLink) {
	        this.feedBackLink = options.feedBackLink;
	      }
	      if (options.baasPromoSlider) {
	        this.baasPromoSlider = options.baasPromoSlider;
	      }
	      if (options.helpSlider) {
	        this.helpSlider = options.helpSlider;
	      }
	    }
	  }, {
	    key: "handleCopilotError",
	    value: function handleCopilotError(errorType) {
	      switch (errorType) {
	        case CallAiError.AI_UNAVAILABLE_ERROR:
	          this.tariffAvailable = false;
	          break;
	        case CallAiError.AI_SETTINGS_ERROR:
	          this.settingsEnabled = false;
	          break;
	        case CallAiError.AI_AGREEMENT_ERROR:
	          this.agreementAccepted = false;
	          break;
	        case CallAiError.AI_NOT_ENOUGH_BAAS_ERROR:
	          this.baasAvailable = false;
	          break;
	        default:
	          console.error('there are no such errorTypes');
	          break;
	      }
	    }
	  }, {
	    key: "serviceEnabled",
	    get: function get() {
	      return this._serviceEnabled;
	    },
	    set: function set(flag) {
	      this._serviceEnabled = flag;
	    }
	  }, {
	    key: "settingsEnabled",
	    get: function get() {
	      return this._settingsEnabled;
	    },
	    set: function set(flag) {
	      this._settingsEnabled = flag;
	    }
	  }, {
	    key: "recordingMinUsers",
	    get: function get() {
	      return this._recordingMinUsers;
	    },
	    set: function set(value) {
	      this._recordingMinUsers = value;
	    }
	  }, {
	    key: "agreementAccepted",
	    get: function get() {
	      return this._agreementAccepted;
	    },
	    set: function set(flag) {
	      this._agreementAccepted = flag;
	    }
	  }, {
	    key: "tariffAvailable",
	    get: function get() {
	      return this._tariffAvailable;
	    },
	    set: function set(flag) {
	      this._tariffAvailable = flag;
	    }
	  }, {
	    key: "baasAvailable",
	    get: function get() {
	      return this._baasAvailable;
	    },
	    set: function set(flag) {
	      this._baasAvailable = flag;
	    }
	  }, {
	    key: "feedBackLink",
	    get: function get() {
	      return this._feedBackLink;
	    },
	    set: function set(value) {
	      this._feedBackLink = value;
	    }
	  }, {
	    key: "baasPromoSlider",
	    get: function get() {
	      return this._baasPromoSlider;
	    },
	    set: function set(value) {
	      this._baasPromoSlider = value;
	    }
	  }, {
	    key: "helpSlider",
	    get: function get() {
	      return this._helpSlider;
	    },
	    set: function set(value) {
	      this._helpSlider = value;
	    }
	  }]);
	  return CallAi;
	}();
	var CallAI = new CallAi();

	var UserSelector = /*#__PURE__*/function () {
	  function UserSelector(config) {
	    babelHelpers.classCallCheck(this, UserSelector);
	    this.userList = config.userList;
	    this.current = config.current;
	    this.parentElement = config.parentElement;
	    this.zIndex = config.zIndex;
	    this.menu = null;
	    this.callbacks = {
	      onSelect: main_core.Type.isFunction(config.onSelect) ? config.onSelect : BX.DoNothing
	    };
	  }
	  babelHelpers.createClass(UserSelector, [{
	    key: "show",
	    value: function show() {
	      var _this = this;
	      var menuItems = [];
	      this.userList.forEach(function (user) {
	        menuItems.push({
	          id: user.id,
	          text: user.name || "unknown (" + user.id + ")",
	          className: _this.current == user.id ? "menu-popup-item-accept" : "device-selector-empty",
	          onclick: function onclick() {
	            _this.menu.close();
	            _this.callbacks.onSelect(user.id);
	          }
	        });
	      });
	      this.menu = new main_popup.Menu({
	        id: 'call-view-select-user',
	        bindElement: this.parentElement,
	        items: menuItems,
	        autoHide: true,
	        zIndex: this.zIndex,
	        closeByEsc: true,
	        offsetTop: 0,
	        offsetLeft: 0,
	        bindOptions: {
	          position: 'bottom'
	        },
	        angle: false,
	        overlay: {
	          backgroundColor: 'white',
	          opacity: 0
	        },
	        events: {
	          onPopupClose: function onPopupClose() {
	            _this.menu.popupWindow.destroy();
	            main_popup.MenuManager.destroy('call-view-select-device');
	          },
	          onPopupDestroy: function onPopupDestroy() {
	            _this.menu = null;
	          }
	        }
	      });
	      this.menu.popupWindow.show();
	    }
	  }], [{
	    key: "create",
	    value: function create(config) {
	      return new UserSelector(config);
	    }
	  }]);
	  return UserSelector;
	}();

	var Layouts = {
	  Grid: 1,
	  Centered: 2,
	  Mobile: 3
	};
	var RerenderReason = {
	  VideoEnabled: 'videoEnabled',
	  VideoDisabled: 'videoDisabled',
	  UserDisconnected: 'userDisconnected'
	};
	var SwapType = {
	  Direct: 'direct',
	  Replace: 'replace'
	};
	var UiState = {
	  Preparing: 1,
	  Initializing: 2,
	  Calling: 3,
	  Connected: 4,
	  Error: 5
	};
	var Size = {
	  Folded: 'folded',
	  Full: 'full'
	};
	var RecordState = {
	  Started: 'started',
	  Resumed: 'resumed',
	  Paused: 'paused',
	  Stopped: 'stopped'
	};
	var RecordType = {
	  None: 'none',
	  Video: 'video',
	  Audio: 'audio'
	};
	var RoomState = {
	  None: 1,
	  Speaker: 2,
	  NonSpeaker: 3
	};
	var EventName = {
	  onShow: 'onShow',
	  onClose: 'onClose',
	  onDestroy: 'onDestroy',
	  onButtonClick: 'onButtonClick',
	  onBodyClick: 'onBodyClick',
	  onReplaceCamera: 'onReplaceCamera',
	  onReplaceMicrophone: 'onReplaceMicrophone',
	  onReplaceSpeaker: 'onReplaceSpeaker',
	  onSetCentralUser: 'onSetCentralUser',
	  onLayoutChange: 'onLayoutChange',
	  onChangeHdVideo: 'onChangeHdVideo',
	  onChangeMicAutoParams: 'onChangeMicAutoParams',
	  onChangeFaceImprove: 'onChangeFaceImprove',
	  onUserClick: 'onUserClick',
	  onUserRename: 'onUserRename',
	  onUserPinned: 'onUserPinned',
	  onDeviceSelectorShow: 'onDeviceSelectorShow',
	  onOpenAdvancedSettings: 'onOpenAdvancedSettings',
	  onHasMainStream: 'onHasMainStream',
	  onToggleSubscribe: 'onToggleSubscribe'
	};
	var beginingPosition = -1;
	var newUserPosition = 999;
	var addButtonPosition = 1001;
	var MIN_WIDTH = 250;
	var SIDE_USER_WIDTH = 160; // keep in sync with .bx-messenger-videocall-user-block .bx-messenger-videocall-user width
	var SIDE_USER_HEIGHT = 90; // keep in sync with .bx-messenger-videocall-user height

	var MAX_USERS_PER_PAGE = 19;
	var MIN_GRID_USER_WIDTH = 180;
	var MIN_GRID_USER_HEIGHT = 100;
	var CHANGE_VIDEO_RERENDER_DELAY = 3000;
	var WAITING_VIDEO_DELAY = 3000;
	var View = /*#__PURE__*/function () {
	  function View(config) {
	    var _this = this;
	    babelHelpers.classCallCheck(this, View);
	    babelHelpers.defineProperty(this, "setCameraState", function (event) {
	      if (_this.isCameraOn == event.data.isCameraOn) {
	        return;
	      }
	      _this.isCameraOn = event.data.isCameraOn;
	      if (_this.buttons.camera) {
	        if (_this.isCameraOn) {
	          _this.buttons.camera.enable();
	        } else {
	          _this.buttons.camera.disable();
	        }
	      }
	    });
	    babelHelpers.defineProperty(this, "setMuted", function (event) {
	      if (_this.isMuted == event.data.isMicrophoneMuted) {
	        return;
	      }
	      _this.isMuted = event.data.isMicrophoneMuted;
	      if (_this.buttons.microphone) {
	        if (_this.isMuted) {
	          _this.buttons.microphone.disable();
	        } else {
	          _this.buttons.microphone.enable();
	        }
	      }
	      _this.userRegistry.get(_this.userId).microphoneState = !_this.isMuted;
	    });
	    this.title = config.title;
	    this.container = config.container;
	    this.baseZIndex = config.baseZIndex;
	    this.cameraId = config.cameraId;
	    this.microphoneId = config.microphoneId;
	    this.speakerId = '';
	    this.speakerMuted = false;
	    this.showChatButtons = config.showChatButtons === true;
	    this.showUsersButton = config.showUsersButton === true;
	    this.showShareButton = config.showShareButton !== false;
	    this.showRecordButton = config.showRecordButton !== false;
	    this.showDocumentButton = config.showDocumentButton !== false;
	    this.showCopilotButton = config.showCopilotButton !== false;
	    this.showButtonPanel = config.showButtonPanel !== false;
	    this.showAddUserButtonInList = config.showAddUserButtonInList || false;
	    this.limitation = null;
	    this.inactiveUsers = [];
	    this.activeUsers = [];
	    this.rerenderTimeout = null;
	    this.waitingForUserMediaTimeouts = new Map();
	    this.rerenderQueue = new Map();
	    this.shelvedRerenderQueue = new Map();
	    this.broadcastingMode = BX.prop.getBoolean(config, "broadcastingMode", false);
	    this.broadcastingPresenters = BX.prop.getArray(config, "broadcastingPresenters", []);
	    this.currentPage = 1;
	    this.pagesCount = 1;
	    this.usersPerPage = 0; // initializes after rendering and on resize

	    this.language = config.language || '';
	    this.lastPosition = 1;
	    this.userData = {};
	    if (config.userData) {
	      this.updateUserData(config.userData);
	    }
	    this.userLimit = config.userLimit || 1;
	    this.userId = BX.message('USER_ID');
	    this.isIntranetOrExtranet = BX.prop.getBoolean(config, "isIntranetOrExtranet", true);
	    this.users = {}; // Call participants. The key is the user id.
	    this.screenUsers = {}; // Screen sharing participants. The key is the user id.
	    this.userRegistry = new UserRegistry();
	    var localUserModel = new UserModel({
	      id: this.userId,
	      state: BX.prop.getString(config, "localUserState", UserState.Connected),
	      localUser: true,
	      order: beginingPosition,
	      name: this.userData[this.userId] ? this.userData[this.userId].name : '',
	      avatar: this.userData[this.userId] ? this.userData[this.userId].avatar_hr : ''
	    });
	    this.userRegistry.push(localUserModel);
	    this.localUser = new CallUser({
	      parentContainer: this.container,
	      userModel: localUserModel,
	      allowBackgroundItem: BackgroundDialog.isAvailable() && this.isIntranetOrExtranet,
	      allowMaskItem: BackgroundDialog.isMaskAvailable() && this.isIntranetOrExtranet,
	      onUserRename: this._onUserRename.bind(this),
	      onUserRenameInputFocus: this._onUserRenameInputFocus.bind(this),
	      onUserRenameInputBlur: this._onUserRenameInputBlur.bind(this),
	      onClick: this._onUserClick.bind(this),
	      onPin: this._onUserPin.bind(this),
	      onUnPin: this._onUserUnPin.bind(this)
	    });
	    this.centralUser = this.localUser; //show local user until someone is connected
	    this.centralUserMobile = null;
	    this.pinnedUser = null;
	    this.presenterId = null;
	    this.returnToGridAfterScreenStopped = false;
	    this.mediaSelectionBlocked = config.mediaSelectionBlocked === true;
	    this.visible = false;
	    this.elements = {
	      root: null,
	      wrap: null,
	      watermark: null,
	      container: null,
	      overlay: null,
	      topPanel: null,
	      bottom: null,
	      notificationPanel: null,
	      panel: null,
	      audioContainer: null,
	      screenAudioContainer: null,
	      audio: {
	        // userId: <audio> for this user's stream
	      },
	      screenAudio: {
	        // userId: <audio> for this user's stream
	      },
	      center: null,
	      localUserMobile: null,
	      userBlock: null,
	      ear: {
	        left: null,
	        right: null
	      },
	      userList: {
	        container: null,
	        addButton: null
	      },
	      userSelectorContainer: null,
	      pinnedUserContainer: null,
	      renameSlider: {
	        input: null,
	        button: null
	      },
	      pageNavigatorLeft: null,
	      pageNavigatorLeftCounter: null,
	      pageNavigatorRight: null,
	      pageNavigatorRightCounter: null
	    };
	    this.buttons = {
	      title: null,
	      grid: null,
	      add: null,
	      share: null,
	      record: null,
	      document: null,
	      copilot: null,
	      microphone: null,
	      camera: null,
	      speaker: null,
	      screen: null,
	      mobileMenu: null,
	      chat: null,
	      users: null,
	      history: null,
	      hangup: null,
	      fullscreen: null,
	      overlay: null,
	      status: null,
	      returnToCall: null,
	      recordStatus: null,
	      participants: null,
	      participantsMobile: null,
	      watermark: null,
	      hd: null,
	      "protected": null,
	      more: null,
	      hangupOptions: null
	    };
	    this.size = Size.Full;
	    this.maxWidth = null;
	    this.isMuted = Hardware.isMicrophoneMuted;
	    this.isCameraOn = Hardware.isCameraOn;
	    this.isFullScreen = false;
	    this.isUserBlockFolded = false;
	    this.recordState = this.getDefaultRecordState();
	    this.blockedButtons = {};
	    var configBlockedButtons = BX.prop.getArray(config, "blockedButtons", []);
	    configBlockedButtons.forEach(function (buttonCode) {
	      return _this.blockedButtons[buttonCode] = true;
	    });
	    this.hiddenButtons = {};
	    this.overflownButtons = {};
	    if (!this.showUsersButton) {
	      this.hiddenButtons['users'] = true;
	    }
	    var configHiddenButtons = BX.prop.getArray(config, "hiddenButtons", []);
	    configHiddenButtons.forEach(function (buttonCode) {
	      return _this.hiddenButtons[buttonCode] = true;
	    });
	    this.hiddenTopButtons = {};
	    var configHiddenTopButtons = BX.prop.getArray(config, "hiddenTopButtons", []);
	    configHiddenTopButtons.forEach(function (buttonCode) {
	      return _this.hiddenTopButtons[buttonCode] = true;
	    });
	    this.uiState = config.uiState || UiState.Calling;
	    this.layout = config.layout || Layouts.Centered;
	    this.whiteSpaceInUserGrid = 0;
	    this.roomState = RoomState.None;
	    this.eventEmitter = new main_core_events.EventEmitter(this, 'BX.Call.View');
	    this.scrollInterval = 0;

	    // Event handlers
	    this._onFullScreenChangeHandler = this._onFullScreenChange.bind(this);
	    //this._onResizeHandler = BX.throttle(this._onResize.bind(this), 500);
	    this._onResizeHandler = this._onResize.bind(this);
	    this._onOrientationChangeHandler = BX.debounce(this._onOrientationChange.bind(this), 500);
	    this._onKeyDownHandler = this._onKeyDown.bind(this);
	    this._onKeyUpHandler = this._onKeyUp.bind(this);
	    this.resizeObserver = new BX.ResizeObserver(this._onResizeHandler);
	    this.intersectionObserver = null;

	    // timers
	    this.switchPresenterTimeout = 0;
	    this.deviceSelector = null;
	    this.userSelector = null;
	    this.pinnedUserContainer = null;
	    this.renameSlider = null;
	    this.userSize = {
	      width: 0,
	      height: 0
	    };
	    this.hintManager = BX.UI.Hint.createInstance({
	      popupParameters: {
	        targetContainer: document.body,
	        className: 'bx-messenger-videocall-panel-item-hotkey-hint',
	        bindOptions: {
	          forceBindPosition: true
	        },
	        angle: false
	      }
	    });
	    this.hotKey = {
	      all: Util.isDesktop(),
	      microphone: true,
	      microphoneSpace: true,
	      camera: true,
	      screen: true,
	      record: true,
	      speaker: true,
	      chat: true,
	      users: true,
	      floorRequest: true,
	      muteSpeaker: true,
	      grid: true
	    };
	    this.hotKeyTemporaryBlock = 0;
	    this._isPreparing = false;
	    this._videoRerenderDelay = 0;
	    this.init();
	    this.subscribeEvents(config);
	    if (main_core.Type.isPlainObject(config.userStates)) {
	      this.appendUsers(config.userStates);
	    }

	    /*this.resizeCalled = 0;
	    this.reportResizeCalled = BX.debounce(function()
	    {
	    	console.log('resizeCalled ' + this.resizeCalled + ' times');
	    	this.resizeCalled = 0;
	    }.bind(this), 100)*/

	    this.hideEarTimer = null;
	    this.isCopilotFeaturesEnabled = config.isCopilotFeaturesEnabled || false;
	    this.isCopilotActive = config.isCopilotActive || false;
	    this.copilotNotify = null;
	  }
	  babelHelpers.createClass(View, [{
	    key: "openArticle",
	    value: function openArticle(articleCode) {
	      var infoHelper = BX.UI.InfoHelper;
	      if (infoHelper.isOpen()) {
	        infoHelper.close();
	      }
	      infoHelper.show(articleCode);
	    }
	  }, {
	    key: "onClickButtonWithLimit",
	    value: function onClickButtonWithLimit(limitObj, handle) {
	      var enabled = limitObj.enabled,
	        articleCode = limitObj.articleCode;
	      if (enabled && typeof handle === "function") {
	        handle();
	        return;
	      }
	      if (!enabled && articleCode) {
	        this.openArticle(articleCode);
	      }
	    }
	  }, {
	    key: "getLimitation",
	    value: function getLimitation() {
	      this.limitation = Util.getCallFeatures();
	    }
	  }, {
	    key: "getLimitationByType",
	    value: function getLimitationByType(type) {
	      var _this$limitation;
	      var defaultLimitation = {
	        enable: true
	      };
	      var currentLimitation = (_this$limitation = this.limitation) === null || _this$limitation === void 0 ? void 0 : _this$limitation["call_".concat(type)];
	      if (!currentLimitation) {
	        return defaultLimitation;
	      }
	      return {
	        enabled: currentLimitation.enable,
	        articleCode: currentLimitation.articleCode
	      };
	    }
	  }, {
	    key: "getBackgroundLimitation",
	    value: function getBackgroundLimitation() {
	      return this.getLimitationByType('background');
	    }
	  }, {
	    key: "getBackgroundBlurLimitation",
	    value: function getBackgroundBlurLimitation() {
	      return this.getLimitationByType('background_blur');
	    }
	  }, {
	    key: "getRecordLimitation",
	    value: function getRecordLimitation() {
	      return this.getLimitationByType('record');
	    }
	  }, {
	    key: "getScreenSharingLimitation",
	    value: function getScreenSharingLimitation() {
	      return this.getLimitationByType('screen_sharing');
	    }
	  }, {
	    key: "isDesktopCall",
	    value: function isDesktopCall() {
	      return im_v2_lib_desktopApi.DesktopApi.isDesktop();
	    }
	  }, {
	    key: "checkAvailableBackgroundImage",
	    value: function checkAvailableBackgroundImage() {
	      if (!this.isDesktopCall()) {
	        return;
	      }
	      var _DesktopApi$getBackgr = im_v2_lib_desktopApi.DesktopApi.getBackgroundImage(),
	        backgroundId = _DesktopApi$getBackgr.id;
	      if (!backgroundId || backgroundId === 'none') {
	        im_v2_lib_desktopApi.DesktopApi.setCallBackground('none', 'none');
	      }
	    }
	  }, {
	    key: "toggleVisibilityEar",
	    value: function toggleVisibilityEar() {
	      var _this$elements$ear$to,
	        _this$elements$ear$bo,
	        _this$elements$pageNa,
	        _this$elements$pageNa2,
	        _this2 = this;
	      if (this.hideEarTimer) {
	        clearTimeout(this.hideEarTimer);
	        this.hideEarTimer = null;
	      }
	      (_this$elements$ear$to = this.elements.ear.top) === null || _this$elements$ear$to === void 0 ? void 0 : _this$elements$ear$to.classList.add("force-visible");
	      (_this$elements$ear$bo = this.elements.ear.bottom) === null || _this$elements$ear$bo === void 0 ? void 0 : _this$elements$ear$bo.classList.add("force-visible");
	      (_this$elements$pageNa = this.elements.pageNavigatorLeft) === null || _this$elements$pageNa === void 0 ? void 0 : _this$elements$pageNa.classList.add("force-visible");
	      (_this$elements$pageNa2 = this.elements.pageNavigatorRight) === null || _this$elements$pageNa2 === void 0 ? void 0 : _this$elements$pageNa2.classList.add("force-visible");
	      this.hideEarTimer = setTimeout(function () {
	        var _this2$elements$ear$t, _this2$elements$ear$b, _this2$elements$pageN, _this2$elements$pageN2;
	        (_this2$elements$ear$t = _this2.elements.ear.top) === null || _this2$elements$ear$t === void 0 ? void 0 : _this2$elements$ear$t.classList.remove("force-visible");
	        (_this2$elements$ear$b = _this2.elements.ear.bottom) === null || _this2$elements$ear$b === void 0 ? void 0 : _this2$elements$ear$b.classList.remove("force-visible");
	        (_this2$elements$pageN = _this2.elements.pageNavigatorLeft) === null || _this2$elements$pageN === void 0 ? void 0 : _this2$elements$pageN.classList.remove("force-visible");
	        (_this2$elements$pageN2 = _this2.elements.pageNavigatorRight) === null || _this2$elements$pageN2 === void 0 ? void 0 : _this2$elements$pageN2.classList.remove("force-visible");
	      }, 5000);
	    }
	  }, {
	    key: "init",
	    value: function init() {
	      this.getLimitation();
	      this.checkAvailableBackgroundImage();
	      if (this.isFullScreenSupported()) {
	        if (main_core.Browser.isChrome() || main_core.Browser.isSafari()) {
	          window.addEventListener("fullscreenchange", this._onFullScreenChangeHandler);
	          window.addEventListener("webkitfullscreenchange", this._onFullScreenChangeHandler);
	        } else if (main_core.Browser.isFirefox()) {
	          window.addEventListener("mozfullscreenchange", this._onFullScreenChangeHandler);
	        }
	      }
	      if (main_core.Browser.isMobile()) {
	        document.documentElement.style.setProperty('--view-height', window.innerHeight + 'px');
	        window.addEventListener("orientationchange", this._onOrientationChangeHandler);
	      }
	      this.elements.audioContainer = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-audio-container"
	        }
	      });
	      this.elements.screenAudioContainer = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-audio-container"
	        }
	      });
	      if (Hardware.initialized) {
	        this.setSpeakerId(Hardware.defaultSpeaker);
	      } else {
	        Hardware.subscribe(Hardware.Events.initialized, function () {
	          this.setSpeakerId(Hardware.defaultSpeaker);
	        }.bind(this));
	      }
	      Hardware.subscribe(Hardware.Events.onChangeMicrophoneMuted, this.setMuted);
	      Hardware.subscribe(Hardware.Events.onChangeCameraOn, this.setCameraState);
	      window.addEventListener("keydown", this._onKeyDownHandler);
	      window.addEventListener("keyup", this._onKeyUpHandler);
	      this.onMouseMoveHandler = this.toggleVisibilityEar.bind(this);
	      document.addEventListener('mousemove', this.onMouseMoveHandler);
	      if (main_core.Browser.isMac()) {
	        this.keyModifier = '&#8984; + Shift';
	      } else {
	        this.keyModifier = 'Ctrl + Shift';
	      }
	      this.container.appendChild(this.elements.audioContainer);
	      this.container.appendChild(this.elements.screenAudioContainer);
	    }
	  }, {
	    key: "subscribeEvents",
	    value: function subscribeEvents(config) {
	      for (var _event in EventName) {
	        if (EventName.hasOwnProperty(_event) && main_core.Type.isFunction(config[_event])) {
	          this.setCallback(_event, config[_event]);
	        }
	      }
	    }
	  }, {
	    key: "setCallback",
	    value: function setCallback(name, cb) {
	      if (main_core.Type.isFunction(cb) && EventName.hasOwnProperty(name)) {
	        this.eventEmitter.subscribe(name, function (event) {
	          cb(event.data);
	        });
	      }
	    }
	  }, {
	    key: "subscribe",
	    value: function subscribe(eventName, listener) {
	      return this.eventEmitter.subscribe(eventName, listener);
	    }
	  }, {
	    key: "unsubscribe",
	    value: function unsubscribe(eventName, listener) {
	      return this.eventEmitter.unsubscribe(eventName, listener);
	    }
	  }, {
	    key: "getNextPosition",
	    value: function getNextPosition() {
	      return this.lastPosition++;
	    }
	  }, {
	    key: "appendUsers",
	    /**
	     * @param {object} userStates {userId -> state}
	     */
	    value: function appendUsers(userStates) {
	      if (!main_core.Type.isPlainObject(userStates)) {
	        return;
	      }
	      var userIds = Object.keys(userStates);
	      for (var i = 0; i < userIds.length; i++) {
	        var userId = userIds[i];
	        this.addUser(userId, userStates[userId] ? userStates[userId] : UserState.Idle);
	      }
	    }
	  }, {
	    key: "setCentralUser",
	    value: function setCentralUser(userId) {
	      var _this3 = this;
	      if (this.centralUser.id == userId) {
	        return;
	      }
	      if (!this.users[userId] && userId != this.userId) {
	        return;
	      }
	      var previousCentralUser = this.centralUser;
	      this.centralUser = userId == this.userId ? this.localUser : this.users[userId];
	      if (this.layout == Layouts.Centered || this.layout == Layouts.Mobile) {
	        if (this.layout == Layouts.Mobile) {
	          previousCentralUser.dismount();
	        }
	        this.updateUserList();
	      }
	      if (this.layout == Layouts.Mobile) {
	        if (this.centralUserMobile) {
	          this.centralUserMobile.setUserModel(this.userRegistry.get(userId));
	        } else {
	          this.centralUserMobile = new CallUserMobile({
	            userModel: this.userRegistry.get(userId),
	            onClick: function onClick() {
	              return _this3.showUserMenu(_this3.centralUser.id);
	            }
	          });
	          this.centralUserMobile.mount(this.elements.pinnedUserContainer);
	        }
	      }
	      this.userRegistry.users.forEach(function (userModel) {
	        return userModel.centralUser = userModel.id == userId;
	      });
	      this.eventEmitter.emit(EventName.onSetCentralUser, {
	        userId: userId,
	        stream: userId == this.userId ? this.localUser.stream : this.users[userId].stream
	      });
	    }
	  }, {
	    key: "getLeftUser",
	    value: function getLeftUser(userId) {
	      var candidateUserId = null;
	      for (var i = 0; i < this.userRegistry.users.length; i++) {
	        var userModel = this.userRegistry.users[i];
	        if (userModel.id == userId && candidateUserId) {
	          return candidateUserId;
	        }
	        if (!userModel.localUser && userModel.state == UserState.Connected) {
	          candidateUserId = userModel.id;
	        }
	      }
	      return candidateUserId;
	    }
	  }, {
	    key: "getRightUser",
	    value: function getRightUser(userId) {
	      var candidateUserId = null;
	      for (var i = this.userRegistry.users.length - 1; i >= 0; i--) {
	        var userModel = this.userRegistry.users[i];
	        if (userModel.id == userId && candidateUserId) {
	          return candidateUserId;
	        }
	        if (!userModel.localUser && userModel.state == UserState.Connected) {
	          candidateUserId = userModel.id;
	        }
	      }
	      return candidateUserId;
	    }
	  }, {
	    key: "getUserCount",
	    value: function getUserCount() {
	      return Object.keys(this.users).length;
	    }
	  }, {
	    key: "getConnectedUserCount",
	    value: function getConnectedUserCount(withYou) {
	      var count = this.getConnectedUsers().length;
	      if (withYou) {
	        var userId = parseInt(this.userId);
	        if (!this.broadcastingMode || this.broadcastingPresenters.includes(userId)) {
	          count += 1;
	        }
	      }
	      return count;
	    }
	  }, {
	    key: "getUsersWithVideo",
	    value: function getUsersWithVideo() {
	      var result = [];
	      for (var userId in this.users) {
	        if (this.users[userId].hasVideo()) {
	          result.push(userId);
	        }
	      }
	      return result;
	    }
	  }, {
	    key: "getConnectedUsers",
	    value: function getConnectedUsers() {
	      var result = [];
	      for (var i = 0; i < this.userRegistry.users.length; i++) {
	        var userModel = this.userRegistry.users[i];
	        if (userModel.id != this.userId && userModel.state == UserState.Connected) {
	          result.push(userModel.id);
	        }
	      }
	      return result;
	    }
	  }, {
	    key: "getDisplayedUsers",
	    value: function getDisplayedUsers() {
	      var result = [];
	      for (var i = 0; i < this.userRegistry.users.length; i++) {
	        var userModel = this.userRegistry.users[i];
	        if (userModel.id != this.userId && (userModel.id != this.centralUser.id && this.layout === Layouts.Centered || this.layout !== Layouts.Centered) && (userModel.state == UserState.Connected || userModel.state == UserState.Connecting || userModel.state == UserState.Calling)) {
	          result.push(userModel.id);
	        }
	      }
	      return result;
	    }
	  }, {
	    key: "getActiveUsers",
	    value: function getActiveUsers() {
	      var result = [];
	      for (var i = 0; i < this.userRegistry.users.length; i++) {
	        var userModel = this.userRegistry.users[i];
	        if (this.isUserHasActiveState(userModel) && this.users.hasOwnProperty(userModel.id)) {
	          result.push(userModel.id);
	        }
	      }
	      return result;
	    }
	  }, {
	    key: "getUsersWithCamera",
	    value: function getUsersWithCamera() {
	      var _this4 = this;
	      // since we don't receive streams from inactive pages
	      // we can't use this.getUsersWithVideo() to get number of users with video
	      return this.userRegistry.users.filter(function (el) {
	        return el.id != _this4.userId && el.cameraState && _this4.isUserHasActiveState(el) && el.state !== UserState.Calling;
	      });
	    }
	  }, {
	    key: "hasUserWithScreenSharing",
	    value: function hasUserWithScreenSharing() {
	      return this.userRegistry.users.some(function (userModel) {
	        return userModel.screenState;
	      });
	    }
	  }, {
	    key: "hasCurrentUserScreenSharing",
	    value: function hasCurrentUserScreenSharing() {
	      var currentUser = this.userRegistry.get(this.userId);
	      if (currentUser) {
	        return currentUser.screenState;
	      }
	      return false;
	    }
	  }, {
	    key: "getPresenterUserId",
	    value: function getPresenterUserId() {
	      var currentPresenterId = this.presenterId || 0;
	      if (currentPresenterId == this.localUser.id) {
	        currentPresenterId = 0;
	      }
	      var userId; // for usage in iterators

	      var currentPresenterModel = this.userRegistry.get(currentPresenterId);

	      // 1. Current user, who is sharing screen has top priority
	      if (currentPresenterModel && currentPresenterModel.screenState === true) {
	        return currentPresenterId;
	      }

	      // 2. If current user is not sharing screen, but someone is sharing - he should become presenter
	      for (userId in this.users) {
	        if (this.users.hasOwnProperty(userId) && this.userRegistry.get(userId).screenState === true) {
	          return parseInt(userId);
	        }
	      }

	      // 3. If current user is talking, or stopped talking less then one second ago - he should stay presenter
	      if (currentPresenterModel && currentPresenterModel.wasTalkingAgo() < 1000) {
	        return currentPresenterId;
	      }

	      // 4. Return currently talking user
	      var minTalkingAgo = 0;
	      var minTalkingAgoUserId = 0;
	      for (userId in this.users) {
	        if (!this.users.hasOwnProperty(userId)) {
	          continue;
	        }
	        var userWasTalkingAgo = this.userRegistry.get(userId).wasTalkingAgo();
	        if (userWasTalkingAgo < 1000) {
	          return parseInt(userId);
	        }
	        if (userWasTalkingAgo < minTalkingAgo) {
	          minTalkingAgoUserId = parseInt(userId);
	        }
	      }

	      // 5. Return last talking user
	      if (minTalkingAgoUserId) {
	        return minTalkingAgoUserId;
	      }

	      // return current user in center
	      return this.centralUser.id;
	    }
	  }, {
	    key: "switchPresenter",
	    value: function switchPresenter() {
	      var _this5 = this;
	      var currentPresenterId = this.presenterId || 0;
	      var newPresenterId = this.getPresenterUserId();
	      if (!newPresenterId) {
	        return;
	      }
	      this.presenterId = newPresenterId;
	      this.userRegistry.users.forEach(function (userModel) {
	        return userModel.presenter = userModel.id == _this5.presenterId;
	      });
	      if (this.pinnedUser === null) {
	        this.setCentralUser(newPresenterId);
	        if (this.layout == Layouts.Centered && currentPresenterId !== newPresenterId) {
	          this.eventEmitter.emit(EventName.onHasMainStream, {
	            userId: this.centralUser.id
	          });
	        }
	      } else if (currentPresenterId !== newPresenterId) {
	        this.eventEmitter.emit(EventName.onHasMainStream, {
	          userId: this.centralUser.id
	        });
	      }
	    }
	  }, {
	    key: "switchPresenterDeferred",
	    value: function switchPresenterDeferred() {
	      clearTimeout(this.switchPresenterTimeout);
	      this.switchPresenterTimeout = setTimeout(this.switchPresenter.bind(this), 1000);
	    }
	  }, {
	    key: "cancelSwitchPresenter",
	    value: function cancelSwitchPresenter() {
	      clearTimeout(this.switchPresenterTimeout);
	    }
	  }, {
	    key: "setUiState",
	    value: function setUiState(uiState) {
	      if (this.uiState == uiState) {
	        return;
	      }
	      this.uiState = uiState;
	      if (this.uiState == UiState.Error && this.elements.container) {
	        main_core.Dom.clean(this.elements.container);
	        this.elements.container.appendChild(this.elements.overlay);
	      }
	      if (!this.elements.root) {
	        return;
	      }
	      this.updateButtons();
	    }
	  }, {
	    key: "setLayout",
	    value: function setLayout(newLayout) {
	      if (newLayout == this.layout) {
	        return;
	      }
	      var useShelvedRerenderQueue = this.layout === Layouts.Centered && newLayout === Layouts.Grid;
	      this.layout = newLayout;
	      if (this.layout == Layouts.Centered || this.layout == Layouts.Mobile) {
	        this.elements.root.classList.remove("bx-messenger-videocall-grid");
	        this.elements.root.classList.add("bx-messenger-videocall-centered");
	        this.centralUser.mount(this.elements.center);
	        this.elements.container.appendChild(this.elements.userBlock);
	        if (this.layout != Layouts.Mobile) {
	          this.elements.userBlock.appendChild(this.elements.userList.container);
	        }
	        this.centralUser.playVideo();
	        //this.centralUser.updateAvatarWidth();
	      }

	      if (this.layout == Layouts.Grid) {
	        this.elements.root.classList.remove("bx-messenger-videocall-centered");
	        this.elements.root.classList.add("bx-messenger-videocall-grid");
	        this.elements.container.appendChild(this.elements.userList.container);
	        this.elements.container.removeChild(this.elements.userBlock);
	        if (this.isFullScreen && this.buttons.participants) {
	          this.buttons.participants.update({
	            foldButtonState: ParticipantsButton.FoldButtonState.Hidden
	          });
	        }
	        this.unpinUser();
	        this.eventEmitter.emit(EventName.onHasMainStream, {
	          userId: null
	        });
	      }
	      if (this.layout == Layouts.Centered && this.isFullScreen) {
	        this.setUserBlockFolded(true);
	      }
	      this.elements.root.classList.toggle("bx-messenger-videocall-fullscreen-mobile", this.layout == Layouts.Mobile);
	      this.updateUserList(useShelvedRerenderQueue);
	      this.toggleEars();
	      this.updateButtons();
	      this.eventEmitter.emit(EventName.onLayoutChange, {
	        layout: this.layout
	      });
	    }
	  }, {
	    key: "setRoomState",
	    value: function setRoomState(roomState) {
	      if (this.roomState === roomState) {
	        return;
	      }
	      this.roomState = roomState;
	      if (this.buttons.microphone) {
	        this.buttons.microphone.setSideIcon(this.getMicrophoneSideIcon(this.roomState));
	      }
	    }
	  }, {
	    key: "getMicrophoneSideIcon",
	    value: function getMicrophoneSideIcon(roomState) {
	      switch (roomState) {
	        case RoomState.Speaker:
	          return 'ellipsis';
	        case RoomState.NonSpeaker:
	          return 'pointer';
	        case RoomState.None:
	        default:
	          return null;
	      }
	    }
	  }, {
	    key: "setCurrentPage",
	    value: function setCurrentPage(pageNumber) {
	      if (pageNumber < 1 || pageNumber > this.pagesCount || pageNumber == this.currentPage) {
	        return;
	      }
	      this.currentPage = pageNumber;
	      this.recalculateUsersPerPage();
	      if (this.elements.root) {
	        this.elements.pageNavigatorLeftCounter.innerHTML = this.currentPage - 1 + '&nbsp;/&nbsp;' + this.pagesCount;
	        this.elements.pageNavigatorRightCounter.innerHTML = this.currentPage + 1 + '&nbsp;/&nbsp;' + this.pagesCount;
	      }
	      if (!(this.layout === Layouts.Grid || this.layout === Layouts.Centered)) {
	        return;
	      }
	      this.renderUserList(true);
	      this.toggleEars();
	    }
	  }, {
	    key: "calculateUsersPerPage",
	    value: function calculateUsersPerPage() {
	      if (!this.elements.userList) {
	        return 1000;
	      }
	      var containerSize = this.elements.userList.container.getBoundingClientRect();
	      var columns = Math.floor(containerSize.width / MIN_GRID_USER_WIDTH) || 1;
	      var rows = Math.floor(containerSize.height / MIN_GRID_USER_HEIGHT) || 1;
	      if (this.layout === Layouts.Centered) {
	        var rowsWithoutGap = Math.floor(containerSize.height / SIDE_USER_HEIGHT) || 1;
	        var rowGap = 6;
	        this.whiteSpaceInUserGrid = containerSize.height - rowsWithoutGap * SIDE_USER_HEIGHT + (rowsWithoutGap - 1) * rowGap;
	        columns = 1;
	        rows = this.whiteSpaceInUserGrid < 0 ? rowsWithoutGap - 1 : rowsWithoutGap;
	      }
	      var usersPerPage = columns * rows - 1;
	      if (this.userId == this.centralUser.id && this.layout === Layouts.Centered) {
	        usersPerPage += 1;
	      }
	      if (!usersPerPage) {
	        return 1000;
	      }
	      if (usersPerPage <= MAX_USERS_PER_PAGE) {
	        return usersPerPage;
	      } else {
	        // check if the last row should be filled up
	        var elementSize = Util.findBestElementSize(containerSize.width, containerSize.height, MAX_USERS_PER_PAGE + 1, MIN_GRID_USER_WIDTH, MIN_GRID_USER_HEIGHT);
	        // console.log('Optimal element size: width '+elementSize.width+' height '+elementSize.height);
	        columns = Math.floor(containerSize.width / elementSize.width);
	        rows = Math.floor(containerSize.height / elementSize.height);
	        return columns * rows - 1;
	      }
	    }
	  }, {
	    key: "calculatePagesCount",
	    value: function calculatePagesCount(usersPerPage) {
	      var pages = Math.ceil(this.getDisplayedUsers().length / usersPerPage);
	      return pages > 0 ? pages : 1;
	    }
	  }, {
	    key: "recalculateUsersPerPage",
	    value: function recalculateUsersPerPage() {
	      this.usersPerPage = this.calculateUsersPerPage();
	      if (this.currentPage < this.pagesCount && this.layout === Layouts.Centered && this.whiteSpaceInUserGrid > 0) {
	        this.usersPerPage = this.usersPerPage + 1;
	      }
	    }
	  }, {
	    key: "recalculatePages",
	    value: function recalculatePages() {
	      this.usersPerPage = this.calculateUsersPerPage();
	      this.pagesCount = this.calculatePagesCount(this.usersPerPage);
	      if (this.currentPage > this.pagesCount) {
	        this.currentPage = this.pagesCount;
	      }
	      this.recalculateUsersPerPage();
	      if (this.elements.root) {
	        this.elements.pageNavigatorLeftCounter.innerHTML = this.currentPage - 1 + '&nbsp;/&nbsp;' + this.pagesCount;
	        this.elements.pageNavigatorRightCounter.innerHTML = this.currentPage + 1 + '&nbsp;/&nbsp;' + this.pagesCount;
	      }
	    }
	  }, {
	    key: "findUsersPage",
	    /**
	     * Returns page number, where the user is displayed, or 0 if user is not found
	     * @param {int} userId Id of the user
	     * @return {int}
	     */
	    value: function findUsersPage(userId) {
	      if (userId == this.userId || this.usersPerPage === 0) {
	        return 0;
	      }
	      var displayedUsers = this.getDisplayedUsers();
	      var userPosition = 0;
	      for (var i = 0; i < displayedUsers.length; i++) {
	        if (displayedUsers[i] == userId) {
	          userPosition = i + 1;
	          break;
	        }
	      }
	      return userPosition ? Math.ceil(userPosition / this.usersPerPage) : 0;
	    }
	  }, {
	    key: "setCameraId",
	    value: function setCameraId(cameraId) {
	      if (this.cameraId == cameraId) {
	        return;
	      }
	      if (this.localUser.stream && this.localUser.stream.getVideoTracks().length > 0) {
	        throw new Error("Can not set camera id while having active stream");
	      }
	      this.cameraId = cameraId;
	    }
	  }, {
	    key: "setMicrophoneId",
	    value: function setMicrophoneId(microphoneId) {
	      if (this.microphoneId == microphoneId) {
	        return;
	      }
	      if (this.localUser.stream && this.localUser.stream.getAudioTracks().length > 0) {
	        throw new Error("Can not set microphone id while having active stream");
	      }
	      this.microphoneId = microphoneId;
	    }
	  }, {
	    key: "setMicrophoneLevel",
	    value: function setMicrophoneLevel(level) {
	      var _this$buttons$microph;
	      this.microphoneLevel = level;
	      (_this$buttons$microph = this.buttons.microphone) === null || _this$buttons$microph === void 0 ? void 0 : _this$buttons$microph.setLevel(level);
	    }
	  }, {
	    key: "setLocalUserId",
	    value: function setLocalUserId(userId) {
	      if (userId == this.userId) {
	        return;
	      }
	      this.userId = parseInt(userId);
	      this.localUser.userModel.id = this.userId;
	      this.localUser.userModel.name = this.userData[this.userId] ? this.userData[this.userId].name : '';
	      this.localUser.userModel.avatar = this.userData[this.userId] ? this.userData[this.userId].avatar_hr : '';
	    }
	  }, {
	    key: "setUserBlockFolded",
	    value: function setUserBlockFolded(isUserBlockFolded) {
	      var _this$elements$userBl, _this$elements$root;
	      this.isUserBlockFolded = isUserBlockFolded;
	      (_this$elements$userBl = this.elements.userBlock) === null || _this$elements$userBl === void 0 ? void 0 : _this$elements$userBl.classList.toggle("folded", this.isUserBlockFolded);
	      (_this$elements$root = this.elements.root) === null || _this$elements$root === void 0 ? void 0 : _this$elements$root.classList.toggle("bx-messenger-videocall-userblock-folded", this.isUserBlockFolded);
	      if (this.isUserBlockFolded) {
	        if (this.buttons.participants && this.layout == Layouts.Centered) {
	          this.buttons.participants.update({
	            foldButtonState: ParticipantsButton.FoldButtonState.Unfold
	          });
	        }
	      } else {
	        if (this.buttons.participants) {
	          this.buttons.participants.update({
	            foldButtonState: this.isFullScreen && this.layout == Layouts.Centered ? ParticipantsButton.FoldButtonState.Fold : ParticipantsButton.FoldButtonState.Hidden
	          });
	        }
	      }
	    }
	  }, {
	    key: "addUser",
	    value: function addUser(userId, state, direction) {
	      userId = Number(userId);
	      if (this.users[userId]) {
	        return;
	      }
	      state = state || UserState.Idle;
	      if (!direction) {
	        if (this.broadcastingPresenters.length > 0 && !this.broadcastingPresenters.includes(userId)) {
	          direction = EndpointDirection.RecvOnly;
	        } else {
	          direction = EndpointDirection.SendRecv;
	        }
	      }
	      var userModel = new UserModel({
	        id: userId,
	        name: this.userData[userId] ? this.userData[userId].name : '',
	        avatar: this.userData[userId] ? this.userData[userId].avatar_hr : '',
	        state: state,
	        order: state == UserState.Connected ? this.getNextPosition() : newUserPosition,
	        direction: direction
	      });
	      this.userRegistry.push(userModel);
	      if (!this.elements.audio[userId]) {
	        this.elements.audio[userId] = main_core.Dom.create("audio");
	        this.elements.audioContainer.appendChild(this.elements.audio[userId]);
	      }
	      if (!this.elements.screenAudio[userId]) {
	        this.elements.screenAudio[userId] = main_core.Dom.create("audio");
	        this.elements.screenAudioContainer.appendChild(this.elements.audio[userId]);
	      }
	      this.users[userId] = new CallUser({
	        parentContainer: this.container,
	        userModel: userModel,
	        audioElement: this.elements.audio[userId],
	        screenAudioElement: this.elements.screenAudio[userId],
	        allowPinButton: this.getConnectedUserCount() > 1,
	        onClick: this._onUserClick.bind(this),
	        onPin: this._onUserPin.bind(this),
	        onUnPin: this._onUserUnPin.bind(this)
	      });
	      this.screenUsers[userId] = new CallUser({
	        parentContainer: this.container,
	        userModel: userModel,
	        allowPinButton: false,
	        screenSharingUser: true
	      });
	      if (this.elements.root) {
	        this.updateUserList();
	        this.updateButtons();
	        this.updateUserButtons();
	        this.muteSpeaker(this.speakerMuted);
	      }
	    }
	  }, {
	    key: "setUserDirection",
	    value: function setUserDirection(userId, direction) {
	      var user = this.userRegistry.get(userId);
	      if (!user || user.direction == direction) {
	        return;
	      }
	      user.direction = direction;
	      this.updateUserList();
	    }
	  }, {
	    key: "setLocalUserDirection",
	    value: function setLocalUserDirection(direction) {
	      if (this.localUser.userModel.direction != direction) {
	        this.localUser.userModel.direction = direction;
	        this.updateUserList();
	      }
	    }
	  }, {
	    key: "setUserState",
	    value: function setUserState(userId, newState) {
	      var _this6 = this;
	      var user = this.userRegistry.get(userId);
	      if (!user) {
	        return;
	      }
	      if (newState === UserState.Connected && this.uiState === UiState.Calling) {
	        this.setUiState(UiState.Connected);
	      }
	      user.state = newState;

	      // maybe switch central user
	      if (this.centralUser.id == this.userId && newState == UserState.Connected) {
	        this.setCentralUser(userId);
	      } else if (userId == this.centralUser.id) {
	        if (newState == UserState.Connecting || newState == UserState.Failed) {
	          this.centralUser.blurVideo();
	        } else if (newState == UserState.Connected) {
	          this.centralUser.blurVideo(false);
	        } else if (newState == UserState.Idle) {
	          var usersWithVideo = this.getUsersWithVideo();
	          var connectedUsers = this.getConnectedUsers();
	          if (connectedUsers.length === 0) {
	            this.setCentralUser(this.userId);
	          } else if (usersWithVideo.length > 0) {
	            this.setCentralUser(usersWithVideo[0]);
	          } else
	            //if (connectedUsers.length > 0)
	            {
	              this.setCentralUser(connectedUsers[0]);
	            }
	        }
	      }
	      if (newState === UserState.Connected) {
	        var timer = setTimeout(function () {
	          _this6.waitingForUserMediaTimeouts["delete"](userId);
	        }, WAITING_VIDEO_DELAY);
	        this.waitingForUserMediaTimeouts.set(userId, timer);
	      } else if (newState === UserState.Idle) {
	        clearTimeout(this.waitingForUserMediaTimeouts.get(userId));
	        this.waitingForUserMediaTimeouts["delete"](userId);
	        this.rerenderQueue.set(userId, {
	          userId: userId,
	          reason: RerenderReason.UserDisconnected
	        });
	      }
	      if (newState == UserState.Connected && user.order == newUserPosition) {
	        user.order = this.getNextPosition();
	      } else if (newState == UserState.Idle) {
	        this.setUserFloorRequestState(userId, false);
	        // reset user position to add them in the end after they reconnect
	        user.prevOrder = user.order;
	        user.order = newUserPosition;
	        user.prevCameraState = user.cameraState;
	        user.cameraState = false;
	      }
	      if (userId == this.localUser.id) {
	        this.localUser.userModel.cameraState = this.localUser.hasCameraVideo();
	      }
	      var skippedElementsList = userId === this.localUser.id ? [] : ['panel'];
	      this.updateUserList();
	      this.updateButtons(skippedElementsList);
	      this.updateUserButtons();
	    }
	  }, {
	    key: "setTitle",
	    value: function setTitle(title) {
	      this.title = title;
	    }
	  }, {
	    key: "getUserTalking",
	    value: function getUserTalking(userId) {
	      var user = this.userRegistry.get(userId);
	      if (!user) {
	        return false;
	      }
	      return !!user.talking;
	    }
	  }, {
	    key: "setUserTalking",
	    value: function setUserTalking(userId, talking) {
	      var user = this.userRegistry.get(userId);
	      if (user) {
	        user.talking = talking;
	      }
	      if (userId == this.userId) {
	        return;
	      }
	      if (userId == this.presenterId && !talking) {
	        this.switchPresenterDeferred();
	      } else {
	        this.switchPresenter();
	      }
	    }
	  }, {
	    key: "setUserStats",
	    value: function setUserStats(userId, stats) {
	      if (this.users[userId]) {
	        this.users[userId].showStats(stats);
	      }
	      if (this.screenUsers[userId]) {
	        this.screenUsers[userId].showStats(stats);
	      }
	      if (userId == this.localUser.id) {
	        this.localUser.showStats(stats);
	      }
	    }
	  }, {
	    key: "setUserMicrophoneState",
	    value: function setUserMicrophoneState(userId, isMicrophoneOn) {
	      var user = this.userRegistry.get(userId);
	      if (user) {
	        user.microphoneState = isMicrophoneOn;
	      }
	    }
	  }, {
	    key: "setUserCameraState",
	    value: function setUserCameraState(userId, cameraState) {
	      var user = this.userRegistry.get(userId);
	      if (user) {
	        user.cameraState = cameraState;
	      }
	    }
	  }, {
	    key: "setUserVideoPaused",
	    value: function setUserVideoPaused(userId, videoPaused) {
	      var user = this.userRegistry.get(userId);
	      if (user) {
	        user.videoPaused = videoPaused;
	        user.cameraState = !videoPaused;
	        if (!user.videoPaused !== videoPaused) {
	          return;
	        }
	        videoPaused ? this.updateRerenderQueue(userId, RerenderReason.VideoDisabled) : this.updateRerenderQueue(userId, RerenderReason.VideoEnabled);
	      }
	    }
	  }, {
	    key: "getUserFloorRequestState",
	    value: function getUserFloorRequestState(userId) {
	      var user = this.userRegistry.get(userId);
	      return user && user.floorRequestState;
	    }
	  }, {
	    key: "setUserFloorRequestState",
	    value: function setUserFloorRequestState(userId, userFloorRequestState) {
	      var user = this.userRegistry.get(userId);
	      if (!user) {
	        return;
	      }
	      if (user.floorRequestState != userFloorRequestState) {
	        var userState = user === null || user === void 0 ? void 0 : user.state;
	        var userActive = userState !== UserState.Idle && userState !== UserState.Declined && userState !== UserState.Unavailable && userState !== UserState.Busy;
	        if (userFloorRequestState && !userActive) {
	          return;
	        }
	        user.floorRequestState = userFloorRequestState;
	        if (userId != this.localUser.id && userFloorRequestState) {
	          this.showFloorRequestNotification(userId);
	        }
	      }
	      if (userId == this.userId) {
	        this.setButtonActive('floorRequest', userFloorRequestState);
	      }
	    }
	  }, {
	    key: "pinUser",
	    value: function pinUser(userId) {
	      if (!(userId in this.users) && userId !== Number(this.userId)) {
	        console.error("User " + userId + " is not known");
	        return;
	      }
	      this.pinnedUser = !this.users[userId] ? this.localUser : this.users[userId];
	      this.userRegistry.users.forEach(function (userModel) {
	        return userModel.pinned = userModel.id == userId;
	      });
	      this.setCentralUser(userId);
	      this.eventEmitter.emit(EventName.onUserPinned, {
	        userId: userId
	      });
	      this.eventEmitter.emit(EventName.onHasMainStream, {
	        userId: this.centralUser.id
	      });
	    }
	  }, {
	    key: "unpinUser",
	    value: function unpinUser() {
	      this.pinnedUser = null;
	      this.userRegistry.users.forEach(function (userModel) {
	        return userModel.pinned = false;
	      });
	      this.eventEmitter.emit(EventName.onUserPinned, {
	        userId: null
	      });
	      this.switchPresenterDeferred();
	    }
	  }, {
	    key: "showFloorRequestNotification",
	    value: function showFloorRequestNotification(userId) {
	      var userModel = this.userRegistry.get(userId);
	      if (!userModel) {
	        return;
	      }
	      var notification = FloorRequest.create({
	        userModel: userModel
	      });
	      notification.mount(this.elements.notificationPanel);
	      NotificationManager.Instance.addNotification(notification);
	    }
	  }, {
	    key: "setUserScreenState",
	    value: function setUserScreenState(userId, screenState) {
	      var user = this.userRegistry.get(userId);
	      if (!user) {
	        return;
	      }
	      user.screenState = screenState;
	      if (userId != this.userId) {
	        if (screenState === true && this.layout === View.Layout.Grid) {
	          this.setLayout(Layouts.Centered);
	          this.returnToGridAfterScreenStopped = true;
	        }
	        if (screenState === false && this.layout === Layouts.Centered && !this.hasUserWithScreenSharing() && !this.pinnedUser && this.returnToGridAfterScreenStopped) {
	          this.returnToGridAfterScreenStopped = false;
	          this.setLayout(Layouts.Grid);
	        }
	        this.switchPresenter();
	      }
	    }
	  }, {
	    key: "flipLocalVideo",
	    value: function flipLocalVideo(flipVideo) {
	      this.localUser.flipVideo = !!flipVideo;
	    }
	  }, {
	    key: "setLocalStream",
	    value: function setLocalStream(streamData) {
	      var mediaRenderer = streamData.mediaRenderer;
	      var mediaStream = streamData.stream;
	      var removed = streamData.removed;
	      var flipVideo = streamData.flipVideo;
	      if (removed) {
	        mediaRenderer.stream = null;
	      }
	      if (mediaRenderer)
	        // for Bitrix calls
	        {
	          this.localUser.videoRenderer = mediaRenderer;
	        } else {
	        this.localUser.videoTrack = mediaStream.getVideoTracks().length > 0 ? mediaStream.getVideoTracks()[0] : null;
	      }
	      if (!main_core.Type.isUndefined(flipVideo)) {
	        this.flipLocalVideo(flipVideo);
	      }
	      this.localUser.userModel.cameraState = this.localUser.hasCameraVideo();
	      var videoTracks = mediaStream.getVideoTracks();
	      if (videoTracks.length > 0) {
	        var videoTrackSettings = videoTracks[0].getSettings();
	        this.cameraId = videoTrackSettings.deviceId || '';
	      } else if (!mediaRenderer) {
	        this.cameraId = '';
	      }
	      var audioTracks = mediaStream.getAudioTracks();
	      if (audioTracks.length > 0) {
	        var audioTrackSettings = audioTracks[0].getSettings();
	        this.microphoneId = audioTrackSettings.deviceId || '';
	      }

	      /*if(!this.localUser.hasVideo())
	      {
	      	return false;
	      }*/

	      if (this.layout !== Layouts.Grid && this.centralUser.id == this.userId) {
	        if (mediaRenderer)
	          // for Bitrix ca;ls
	          {
	            this.centralUser.videoRenderer = mediaRenderer;
	          } else if (videoTracks.length > 0 || Object.keys(this.users).length === 0) {
	          this.centralUser.videoTrack = videoTracks[0];
	        } else {
	          this.setCentralUser(Object.keys(this.users)[0]);
	        }
	      } else {
	        this.updateUserList();
	      }
	    }
	  }, {
	    key: "setSpeakerId",
	    value: function setSpeakerId(speakerId) {
	      if (this.speakerId == speakerId) {
	        return;
	      }
	      if (!('setSinkId' in HTMLMediaElement.prototype)) {
	        console.error("Speaker selection is not supported");
	      }
	      this.speakerId = speakerId;
	      for (var userId in this.elements.audio) {
	        this.elements.audio[userId].setSinkId(this.speakerId);
	      }
	    }
	  }, {
	    key: "muteSpeaker",
	    value: function muteSpeaker(mute) {
	      this.speakerMuted = !!mute;
	      for (var userId in this.elements.audio) {
	        this.elements.audio[userId].volume = this.speakerMuted ? 0 : 1;
	      }
	      if (!this.buttons.speaker) {
	        return;
	      }
	      if (this.speakerMuted) {
	        this.buttons.speaker.disable();
	        this.buttons.speaker.hideArrow();
	      } else {
	        this.buttons.speaker.enable();
	        if (Hardware.canSelectSpeaker()) {
	          this.buttons.speaker.showArrow();
	        }
	      }
	    }
	  }, {
	    key: "updateRerenderQueue",
	    value: function updateRerenderQueue(userId, reason) {
	      var _this7 = this;
	      if (!this.users[userId]) {
	        throw Error("User " + userId + " is not a part of this call");
	      }
	      if (reason === RerenderReason.VideoEnabled) {
	        var _this$rerenderQueue$g;
	        if (((_this$rerenderQueue$g = this.rerenderQueue.get(userId)) === null || _this$rerenderQueue$g === void 0 ? void 0 : _this$rerenderQueue$g.reason) === RerenderReason.VideoDisabled) {
	          this.rerenderQueue["delete"](userId);
	          if (!this.rerenderQueue.size) {
	            clearTimeout(this.rerenderTimeout);
	            this.rerenderTimeout = null;
	          }
	        } else {
	          if (this.waitingForUserMediaTimeouts.has(userId)) {
	            clearTimeout(this.waitingForUserMediaTimeouts.get(userId));
	            this.waitingForUserMediaTimeouts["delete"](userId);
	            this.rerenderQueue.set(userId, {
	              userId: userId,
	              reason: RerenderReason.VideoEnabled
	            });
	            this.renderUserList();
	          } else {
	            if (!this.rerenderTimeout) {
	              this.rerenderTimeout = setTimeout(function () {
	                _this7.renderUserList();
	              }, this.videoRerenderDelay);
	            }
	            this.rerenderQueue.set(userId, {
	              userId: userId,
	              reason: RerenderReason.VideoEnabled
	            });
	          }
	        }
	      } else if (reason === RerenderReason.VideoDisabled) {
	        var _this$rerenderQueue$g2;
	        if (((_this$rerenderQueue$g2 = this.rerenderQueue.get(userId)) === null || _this$rerenderQueue$g2 === void 0 ? void 0 : _this$rerenderQueue$g2.reason) === RerenderReason.VideoEnabled) {
	          this.rerenderQueue["delete"](userId);
	          if (!this.rerenderQueue.size) {
	            clearTimeout(this.rerenderTimeout);
	            this.rerenderTimeout = null;
	          }
	        } else {
	          if (!this.rerenderTimeout) {
	            this.rerenderTimeout = setTimeout(function () {
	              _this7.renderUserList();
	            }, this.videoRerenderDelay);
	          }
	          this.rerenderQueue.set(userId, {
	            userId: userId,
	            reason: RerenderReason.VideoDisabled
	          });
	        }
	      }
	    }
	  }, {
	    key: "setVideoRenderer",
	    value: function setVideoRenderer(userId, mediaRenderer) {
	      var user = this.users[userId];
	      if (!user) {
	        throw Error("User " + userId + " is not a part of this call");
	      }
	      if (mediaRenderer === null) {
	        if (user.hasCameraVideo()) {
	          this.updateRerenderQueue(userId, RerenderReason.VideoDisabled);
	        }
	        user.videoRenderer = null;
	        return;
	      }
	      if (!("render" in mediaRenderer) || !main_core.Type.isFunction(mediaRenderer.render)) {
	        throw Error("mediaRenderer should have method render");
	      }
	      if (!("kind" in mediaRenderer) || mediaRenderer.kind !== "video" && mediaRenderer.kind !== "sharing") {
	        throw Error("mediaRenderer should be of video kind");
	      }
	      var userHasCameraVideo = user.hasCameraVideo();
	      user.videoRenderer = mediaRenderer;
	      if (mediaRenderer.stream && mediaRenderer.kind === 'video') {
	        this.updateRerenderQueue(userId, RerenderReason.VideoEnabled);
	      } else if (mediaRenderer.kind === 'video') {
	        if (!userHasCameraVideo) {
	          return;
	        }
	        this.updateRerenderQueue(userId, RerenderReason.VideoDisabled);
	      }
	    }
	  }, {
	    key: "setUserMedia",
	    value: function setUserMedia(userId, kind, track) {
	      if (kind === 'audio') {
	        this.users[userId].audioTrack = track;
	      }
	      if (kind === 'sharingAudio') {
	        this.users[userId].screenAudioTrack = track;
	      }
	      if (kind === 'video') {
	        this.users[userId].videoTrack = track;
	      }
	      if (kind === 'screen') {
	        this.screenUsers[userId].videoTrack = track;
	        this.updateUserList();
	        this.setUserScreenState(userId, track !== null);
	      }
	    }
	  }, {
	    key: "removeScreenUsers",
	    value: function removeScreenUsers() {
	      for (var userId in this.screenUsers) {
	        this.screenUsers[userId].videoTrack = null;
	      }
	      this.updateUserList();
	    }
	  }, {
	    key: "setBadNetworkIndicator",
	    value: function setBadNetworkIndicator(userId, badNetworkIndicator) {
	      if (this.users[userId]) {
	        this.users[userId].badNetworkIndicator = badNetworkIndicator;
	      }
	    }
	  }, {
	    key: "setUserHasConnectionProblem",
	    value: function setUserHasConnectionProblem(userId, hasConnectionProblem) {
	      if (this.users[userId]) {
	        this.users[userId].hasConnectionProblem = hasConnectionProblem;
	      }
	    }
	  }, {
	    key: "setUserConnectionQuality",
	    value: function setUserConnectionQuality(userId, connectionQuality) {
	      if (this.users[userId]) {
	        this.users[userId].connectionQuality = connectionQuality;
	      }
	      if (this.localUser.id === userId) {
	        this.localUser.connectionQuality = connectionQuality;
	      }
	    }
	  }, {
	    key: "applyIncomingVideoConstraints",
	    value: function applyIncomingVideoConstraints() {
	      var userId;
	      var user;
	      if (this.layout === Layouts.Grid) {
	        for (userId in this.users) {
	          user = this.users[userId];
	          user.setIncomingVideoConstraints(this.userSize.width, this.userSize.height);
	        }
	      } else if (this.layout === Layouts.Centered) {
	        for (userId in this.users) {
	          user = this.users[userId];
	          if (userId == this.centralUser.id) {
	            var containerSize = this.elements.center.getBoundingClientRect();
	            user.setIncomingVideoConstraints(Math.floor(containerSize.width), Math.floor(containerSize.height));
	          } else {
	            user.setIncomingVideoConstraints(SIDE_USER_WIDTH, SIDE_USER_HEIGHT);
	          }
	        }
	      }
	    }
	  }, {
	    key: "getDefaultRecordState",
	    value: function getDefaultRecordState() {
	      return {
	        state: RecordState.Stopped,
	        userId: 0,
	        date: {
	          start: null,
	          pause: []
	        }
	      };
	    }
	  }, {
	    key: "setRecordState",
	    value: function setRecordState(recordState) {
	      this.recordState = recordState;
	      if (this.buttons.recordStatus) {
	        this.buttons.recordStatus.update(this.recordState);
	      }
	      if (this.recordState.userId != this.userId) {
	        if (this.recordState.state === RecordState.Stopped) {
	          this.unblockButtons(['record']);
	        } else {
	          this.blockButtons(['record']);
	        }
	      }
	      if (this.elements.topPanel) {
	        if (this.recordState.state === RecordState.Stopped) {
	          delete this.elements.topPanel.dataset.recordState;
	        } else {
	          this.elements.topPanel.dataset.recordState = recordState.state;
	        }
	      }
	    }
	  }, {
	    key: "show",
	    value: function show() {
	      if (!this.elements.root) {
	        this.render();
	      }
	      this.container.appendChild(this.elements.root);
	      if (this.layout !== Layouts.Mobile) {
	        this.startIntersectionObserver();
	      }
	      this.updateButtons();
	      this.updateUserList();
	      this.resumeVideo();
	      this.toggleEars();
	      this.visible = true;
	      this.eventEmitter.emit(EventName.onShow);

	      // We specifically disable the face improve feature to improve call quality.
	      this.disableFaceImprove();
	      this.checkPanelOverflow();
	    }
	  }, {
	    key: "hide",
	    value: function hide() {
	      this.closeCopilotNotify();
	      if (this.overflownButtonsPopup) {
	        this.overflownButtonsPopup.close();
	      }
	      main_core.Dom.remove(this.elements.root);
	      this.visible = false;
	    }
	  }, {
	    key: "startIntersectionObserver",
	    value: function startIntersectionObserver() {
	      if (!('IntersectionObserver' in window)) {
	        return;
	      }
	      this.intersectionObserver = new IntersectionObserver(this._onIntersectionChange.bind(this), {
	        root: this.elements.userList.container,
	        threshold: 0.5
	      });
	    }
	  }, {
	    key: "observeIntersections",
	    /**
	     * @param {CallUser} callUser
	     */
	    value: function observeIntersections(callUser) {
	      if (this.intersectionObserver && callUser.elements.root) {
	        this.intersectionObserver.observe(callUser.elements.root);
	      }
	    }
	  }, {
	    key: "unobserveIntersections",
	    /**
	     * @param {CallUser} callUser
	     */
	    value: function unobserveIntersections(callUser) {
	      if (this.intersectionObserver && callUser.elements.root) {
	        this.intersectionObserver.unobserve(callUser.elements.root);
	      }
	    }
	  }, {
	    key: "showDeviceSelector",
	    value: function showDeviceSelector(bindElement) {
	      var _this8 = this,
	        _events;
	      if (this.deviceSelector) {
	        return;
	      }
	      this.deviceSelector = new DeviceSelector({
	        viewElement: this.container,
	        parentElement: bindElement,
	        zIndex: this.baseZIndex + 500,
	        microphoneEnabled: !Hardware.isMicrophoneMuted,
	        microphoneId: this.microphoneId || Hardware.defaultMicrophone,
	        cameraEnabled: Hardware.isCameraOn,
	        cameraId: this.cameraId,
	        speakerEnabled: !this.speakerMuted,
	        speakerId: this.speakerId,
	        allowHdVideo: Hardware.preferHdQuality,
	        faceImproveEnabled: Util.isDesktop() && im_v2_lib_desktopApi.DesktopApi.isDesktop() && im_v2_lib_desktopApi.DesktopApi.getCameraSmoothingStatus(),
	        allowFaceImprove: false,
	        allowBackground: BackgroundDialog.isAvailable() && this.isIntranetOrExtranet,
	        allowMask: BackgroundDialog.isMaskAvailable() && this.isIntranetOrExtranet,
	        allowAdvancedSettings: typeof BXIM !== 'undefined' && this.isIntranetOrExtranet,
	        switchCameraBlocked: this.blockedButtons['camera'],
	        switchMicrophoneBlocked: this.blockedButtons['microphone'],
	        events: (_events = {}, babelHelpers.defineProperty(_events, DeviceSelector.Events.onMicrophoneSelect, this._onMicrophoneSelected.bind(this)), babelHelpers.defineProperty(_events, DeviceSelector.Events.onMicrophoneSwitch, this._onMicrophoneButtonClick.bind(this)), babelHelpers.defineProperty(_events, DeviceSelector.Events.onCameraSelect, this._onCameraSelected.bind(this)), babelHelpers.defineProperty(_events, DeviceSelector.Events.onCameraSwitch, this._onCameraButtonClick.bind(this)), babelHelpers.defineProperty(_events, DeviceSelector.Events.onSpeakerSelect, this._onSpeakerSelected.bind(this)), babelHelpers.defineProperty(_events, DeviceSelector.Events.onSpeakerSwitch, this._onSpeakerButtonClick.bind(this)), babelHelpers.defineProperty(_events, DeviceSelector.Events.onChangeHdVideo, this._onChangeHdVideo.bind(this)), babelHelpers.defineProperty(_events, DeviceSelector.Events.onChangeMicAutoParams, this._onChangeMicAutoParams.bind(this)), babelHelpers.defineProperty(_events, DeviceSelector.Events.onChangeFaceImprove, this._onChangeFaceImprove.bind(this)), babelHelpers.defineProperty(_events, DeviceSelector.Events.onAdvancedSettingsClick, function () {
	          return _this8.eventEmitter.emit(EventName.onOpenAdvancedSettings);
	        }), babelHelpers.defineProperty(_events, DeviceSelector.Events.onDestroy, function () {
	          return _this8.deviceSelector = null;
	        }), babelHelpers.defineProperty(_events, DeviceSelector.Events.onShow, function () {
	          return _this8.eventEmitter.emit(EventName.onDeviceSelectorShow, {});
	        }), _events)
	      });
	      this.deviceSelector.show();
	    }
	  }, {
	    key: "showCallMenu",
	    value: function showCallMenu() {
	      var _this9 = this;
	      var menuItems = [{
	        text: BX.message("IM_M_CALL_BTN_WANT_TO_SAY"),
	        iconClass: "hand",
	        onClick: this._onMobileCallMenuFloorRequestClick.bind(this)
	      }, {
	        text: BX.message("IM_M_CALL_MOBILE_MENU_PARTICIPANTS_LIST"),
	        iconClass: "participants",
	        onClick: this._onMobileCallMenShowParticipantsClick.bind(this)
	      },
	      // TODO:
	      /*{
	      	text: "Add participant",
	      	iconClass: "add-participant",
	      	onClick: function() {}
	      },*/

	      /*{ //DEBUG: mobile audio
	      	text: "Enable audio",
	      	iconClass: "",
	      	onClick: function() {
	      		for (var userId in this.elements.audio)
	      		{
	      			if (this.users[userId].stream)
	      			{
	      				console.log('user ' + userId + ' stream found, trying to play');
	      				this.elements.audio[userId].srcObject = this.users[userId].stream;
	      				this.elements.audio[userId].play();
	      			}
	      		}
	      		this.callMenu.close();
	      	}.bind(this)
	      },*/
	      {
	        text: BX.message("IM_M_CALL_MOBILE_MENU_COPY_INVITE"),
	        iconClass: "add-participant",
	        onClick: this._onMobileCallMenuCopyInviteClick.bind(this)
	      }, !this.isIntranetOrExtranet ? {
	        text: BX.message("IM_M_CALL_MOBILE_MENU_CHANGE_MY_NAME"),
	        iconClass: "change-name",
	        onClick: function onClick() {
	          _this9.callMenu.close();
	          setTimeout(_this9.showRenameSlider.bind(_this9), 100);
	        }
	      } : null, {
	        separator: true
	      }, {
	        text: BX.message("IM_M_CALL_MOBILE_MENU_CANCEL"),
	        enabled: false,
	        onClick: this._onMobileCallMenuCancelClick.bind(this)
	      }];
	      this.callMenu = new MobileMenu({
	        parent: this.elements.root,
	        items: menuItems,
	        onClose: function onClose() {
	          return _this9.callMenu.destroy();
	        },
	        onDestroy: function onDestroy() {
	          return _this9.callMenu = null;
	        }
	      });
	      this.callMenu.show();
	    }
	  }, {
	    key: "showUserMenu",
	    value: function showUserMenu(userId) {
	      var _this10 = this;
	      var userModel = this.userRegistry.get(userId);
	      if (!userModel) {
	        return false;
	      }
	      var pinItem = null;
	      if (this.pinnedUser && this.pinnedUser.id == userId) {
	        pinItem = {
	          text: BX.message("IM_M_CALL_MOBILE_MENU_UNPIN"),
	          iconClass: "unpin",
	          onClick: function onClick() {
	            _this10.userMenu.close();
	            _this10.unpinUser();
	          }
	        };
	      } else if (this.userId != userId) {
	        pinItem = {
	          text: BX.message("IM_M_CALL_MOBILE_MENU_PIN"),
	          iconClass: "pin",
	          onClick: function onClick() {
	            _this10.userMenu.close();
	            _this10.pinUser(userId);
	          }
	        };
	      }
	      var menuItems = [{
	        userModel: userModel,
	        enabled: false
	      }, {
	        separator: true
	      }, pinItem, this.userId == userId && !this.isIntranetOrExtranet ? {
	        text: BX.message("IM_M_CALL_MOBILE_MENU_CHANGE_MY_NAME"),
	        iconClass: "change-name",
	        onClick: function onClick() {
	          _this10.userMenu.close();
	          setTimeout(_this10.showRenameSlider.bind(_this10), 100);
	        }
	      } : null,
	      /*{
	      	text: BX.message("IM_M_CALL_MOBILE_MENU_WRITE_TO_PRIVATE_CHAT"),
	      	iconClass: "private-chat",
	      	onClick: function()
	      	{
	      		this.userMenu.close();
	      		this.eventEmitter.emit(EventName.onButtonClick, {
	      			})
	      	}.bind(this)
	      },*/
	      /*{
	      	// TODO:
	      	text: "Remove user",
	      	iconClass: "remove-user"
	      },*/
	      {
	        separator: true
	      }, {
	        text: BX.message("IM_M_CALL_MOBILE_MENU_CANCEL"),
	        enabled: false,
	        onClick: function onClick() {
	          return _this10.userMenu.close();
	        }
	      }];
	      this.userMenu = new MobileMenu({
	        parent: this.elements.root,
	        items: menuItems,
	        onClose: function onClose() {
	          return _this10.userMenu.destroy();
	        },
	        onDestroy: function onDestroy() {
	          return _this10.userMenu = null;
	        }
	      });
	      this.userMenu.show();
	    }
	  }, {
	    key: "showParticipantsMenu",
	    value: function showParticipantsMenu() {
	      var _this11 = this;
	      if (this.participantsMenu) {
	        return;
	      }
	      var menuItems = [];
	      menuItems.push({
	        userModel: this.localUser.userModel,
	        showSubMenu: true,
	        onClick: function () {
	          this.participantsMenu.close();
	          this.showUserMenu(this.localUser.userModel.id);
	        }.bind(this)
	      });
	      this.userRegistry.users.forEach(function (userModel) {
	        if (userModel.localUser || userModel.state != UserState.Connected) {
	          return;
	        }
	        if (menuItems.length > 0) {
	          menuItems.push({
	            separator: true
	          });
	        }
	        menuItems.push({
	          userModel: userModel,
	          showSubMenu: true,
	          onClick: function onClick() {
	            _this11.participantsMenu.close();
	            _this11.showUserMenu(userModel.id);
	          }
	        });
	      });
	      if (menuItems.length === 0) {
	        return false;
	      }
	      this.participantsMenu = new MobileMenu({
	        parent: this.elements.root,
	        items: menuItems,
	        header: BX.message("IM_M_CALL_PARTICIPANTS").replace("#COUNT#", this.getConnectedUserCount(true)),
	        largeIcons: true,
	        onClose: function () {
	          this.participantsMenu.destroy();
	        }.bind(this),
	        onDestroy: function () {
	          this.participantsMenu = null;
	        }.bind(this)
	      });
	      this.participantsMenu.show();
	      return true;
	    }
	  }, {
	    key: "showMessage",
	    /**
	     * @param {Object} params
	     * @param {string} params.text
	     * @param {string} [params.subText]
	     */
	    value: function showMessage(params) {
	      if (!this.elements.root) {
	        this.render();
	        this.container.appendChild(this.elements.root);
	      }
	      var statusNode = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-user-status bx-messenger-videocall-user-status-wide"
	        }
	      });
	      if (main_core.Type.isStringFilled(params.text)) {
	        var textNode = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-status-text"
	          },
	          text: params.text
	        });
	        statusNode.appendChild(textNode);
	      }
	      if (this.elements.overlay.childElementCount) {
	        main_core.Dom.clean(this.elements.overlay);
	      }
	      this.elements.overlay.appendChild(statusNode);
	    }
	  }, {
	    key: "hideMessage",
	    value: function hideMessage() {
	      this.elements.overlay.textContent = '';
	    }
	  }, {
	    key: "renderErrorCallLayout",
	    value: function renderErrorCallLayout() {
	      if (!this.elements.root) {
	        this.render();
	        this.container.appendChild(this.elements.root);
	      }
	      var errorContainer = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-error-container"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-error-container-icon-alert"
	          }
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-error-message"
	          },
	          text: BX.message("CALL_CONNECTED_ERROR")
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-error-button-self-test"
	          },
	          text: BX.message("CALL_RUN_SELF_TEST"),
	          events: {
	            click: function click() {
	              Util.startSelfTest();
	            }
	          }
	        })]
	      });
	      if (this.elements.overlay.childElementCount) {
	        main_core.Dom.clean(this.elements.overlay);
	      }
	      this.elements.overlay.appendChild(errorContainer);
	    }
	    /**
	     * @param {Object} params
	     * @param {string} params.text
	     * @param {string} [params.subText]
	     */
	  }, {
	    key: "showFatalError",
	    value: function showFatalError(params) {
	      this.renderErrorCallLayout();
	      this.setUiState(UiState.Error);
	      // in some cases video elements may still be shown on the error screen, let's hide them
	      this.elements.userList.container.style.display = 'none';
	    }
	  }, {
	    key: "close",
	    value: function close() {
	      if (this.buttons.recordStatus) {
	        this.buttons.recordStatus.stopViewUpdate();
	      }
	      this.recordState = this.getDefaultRecordState();
	      if (this.elements.root) {
	        BX.remove(this.elements.root);
	      }
	      this.visible = false;
	      this.eventEmitter.emit(EventName.onClose);
	    }
	  }, {
	    key: "setSize",
	    value: function setSize(size) {
	      if (this.size == size) {
	        return;
	      }
	      this.size = size;
	      if (this.size == Size.Folded) {
	        if (this.overflownButtonsPopup) {
	          this.overflownButtonsPopup.close();
	        }
	        if (this.elements.panel) {
	          this.elements.panel.classList.add('bx-messenger-videocall-panel-folded');
	        }
	        main_core.Dom.remove(this.elements.container);
	        main_core.Dom.remove(this.elements.topPanel);
	        this.elements.root.style.removeProperty('max-width');
	        this.updateButtons();
	      } else {
	        if (this.elements.panel) {
	          this.elements.panel.classList.remove('bx-messenger-videocall-panel-folded');
	        }
	        this.elements.wrap.appendChild(this.elements.topPanel);
	        this.elements.wrap.appendChild(this.elements.container);
	        if (this.maxWidth > 0) {
	          this.elements.root.style.maxWidth = Math.max(this.maxWidth, MIN_WIDTH) + 'px';
	        }
	        this.updateButtons();
	        this.updateUserList();
	        this.resumeVideo();
	      }
	    }
	  }, {
	    key: "isButtonBlocked",
	    value: function isButtonBlocked(buttonName) {
	      switch (buttonName) {
	        case 'camera':
	          return this.uiState !== UiState.Preparing && this.uiState !== UiState.Connected || this.blockedButtons[buttonName] === true;
	        case 'chat':
	          return !this.showChatButtons || this.blockedButtons[buttonName] === true;
	        case 'floorRequest':
	          return this.uiState !== UiState.Connected || this.blockedButtons[buttonName] === true;
	        case 'screen':
	          return !this.showShareButton || !this.isScreenSharingSupported() || this.isFullScreen || this.blockedButtons[buttonName] === true;
	        case 'users':
	          return !this.showUsersButton || this.blockedButtons[buttonName] === true;
	        case 'record':
	          return !this.showRecordButton || this.blockedButtons[buttonName] === true;
	        case 'document':
	          return !this.showDocumentButton || this.blockedButtons[buttonName] === true;
	        case 'copilot':
	          return !this.showCopilotButton || this.blockedButtons[buttonName] === true;
	        default:
	          return this.blockedButtons[buttonName] === true;
	      }
	    }
	  }, {
	    key: "isButtonHidden",
	    value: function isButtonHidden(buttonName) {
	      return this.hiddenButtons[buttonName] === true;
	    }
	  }, {
	    key: "showButton",
	    value: function showButton(buttonCode) {
	      this.showButtons([buttonCode]);
	    }
	  }, {
	    key: "hideButton",
	    value: function hideButton(buttonCode) {
	      this.hideButtons([buttonCode]);
	    }
	  }, {
	    key: "checkPanelOverflow",
	    /**
	     * @return {bool} Returns true if buttons update is required
	     */
	    value: function checkPanelOverflow() {
	      var delta = this.elements.panel.scrollWidth - this.elements.panel.offsetWidth;
	      var mediumButtonMinWidth = 60; // todo: move to constants maybe? or maybe even calculate dynamically somehow?
	      if (delta > 0) {
	        var countOfButtonsToHide = Math.ceil(delta / mediumButtonMinWidth);
	        if (Object.keys(this.overflownButtons).length === 0) {
	          countOfButtonsToHide += 1;
	        }
	        var buttons = this.getButtonList();
	        for (var i = buttons.length - 1; i > 0; i--) {
	          if (buttons[i] === 'hangupOptions' || buttons[i] === 'hangup' || buttons[i] === 'close' || buttons[i] === 'more') {
	            continue;
	          }
	          this.overflownButtons[buttons[i]] = true;
	          countOfButtonsToHide -= 1;
	          if (!countOfButtonsToHide) {
	            break;
	          }
	        }
	        return true;
	      } else {
	        var hiddenButtonsCount = Object.keys(this.overflownButtons).length;
	        if (hiddenButtonsCount > 0) {
	          var unusedPanelSpace = this.calculateUnusedPanelSpace();
	          if (unusedPanelSpace > 320) {
	            var countOfButtonsToShow = Math.min(Math.floor(unusedPanelSpace / mediumButtonMinWidth), hiddenButtonsCount);
	            var buttonsLeftHidden = hiddenButtonsCount - countOfButtonsToShow;
	            if (buttonsLeftHidden === 1) {
	              countOfButtonsToShow += 1;
	            }
	            if (countOfButtonsToShow == hiddenButtonsCount) {
	              // show all buttons;
	              this.overflownButtons = {};
	            } else {
	              for (var _i = 0; _i < countOfButtonsToShow; _i++) {
	                delete this.overflownButtons[Object.keys(this.overflownButtons)[0]];
	              }
	            }
	            return true;
	          }
	        }
	      }
	      return false;
	    }
	  }, {
	    key: "showButtons",
	    /**
	     * @param {string[]} buttons Array of buttons names to show
	     */
	    value: function showButtons(buttons) {
	      var _this12 = this;
	      if (!main_core.Type.isArray(buttons)) {
	        console.error("buttons should be array");
	      }
	      buttons.forEach(function (buttonName) {
	        if (_this12.hiddenButtons.hasOwnProperty(buttonName)) {
	          delete _this12.hiddenButtons[buttonName];
	        }
	      });
	      this.updateButtons();
	    }
	  }, {
	    key: "hideButtons",
	    /**
	     * @param {string[]} buttons Array of buttons names to hide
	     */
	    value: function hideButtons(buttons) {
	      var _this13 = this;
	      if (!main_core.Type.isArray(buttons)) {
	        console.error("buttons should be array");
	      }
	      buttons.forEach(function (buttonName) {
	        return _this13.hiddenButtons[buttonName] = true;
	      });
	      this.updateButtons();
	    }
	  }, {
	    key: "blockAddUser",
	    value: function blockAddUser() {
	      this.blockedButtons['add'] = true;
	      if (this.elements.userList.addButton) {
	        main_core.Dom.remove(this.elements.userList.addButton);
	      }
	    }
	  }, {
	    key: "unblockAddUser",
	    value: function unblockAddUser() {
	      this.blockedButtons['add'] = false;
	      this.updateButtons();
	    }
	  }, {
	    key: "blockSwitchCamera",
	    value: function blockSwitchCamera() {
	      this.blockedButtons['camera'] = true;
	      if (this.deviceSelector) {
	        this.deviceSelector.toggleCameraAvailability(false);
	      }
	    }
	  }, {
	    key: "unblockSwitchCamera",
	    value: function unblockSwitchCamera() {
	      delete this.blockedButtons['camera'];
	      if (this.deviceSelector) {
	        this.deviceSelector.toggleCameraAvailability(true);
	      }
	    }
	  }, {
	    key: "blockSwitchMicrophone",
	    value: function blockSwitchMicrophone() {
	      this.blockedButtons['microphone'] = true;
	      if (this.deviceSelector) {
	        this.deviceSelector.toggleMicrophoneAvailability(false);
	      }
	    }
	  }, {
	    key: "unblockSwitchMicrophone",
	    value: function unblockSwitchMicrophone() {
	      delete this.blockedButtons['microphone'];
	      if (this.deviceSelector) {
	        this.deviceSelector.toggleMicrophoneAvailability(true);
	      }
	    }
	  }, {
	    key: "blockScreenSharing",
	    value: function blockScreenSharing() {
	      this.blockedButtons['screen'] = true;
	    }
	  }, {
	    key: "blockHistoryButton",
	    value: function blockHistoryButton() {
	      this.blockedButtons['history'] = true;
	    }
	  }, {
	    key: "blockButtons",
	    /**
	     * @param {string[]} buttons Array of buttons names to block
	     */
	    value: function blockButtons(buttons) {
	      var _this14 = this;
	      if (!main_core.Type.isArray(buttons)) {
	        console.error("buttons should be array ");
	      }
	      buttons.forEach(function (buttonName) {
	        _this14.blockedButtons[buttonName] = true;
	        if (_this14.buttons[buttonName]) {
	          _this14.buttons[buttonName].setBlocked(true);
	        }
	      });
	    }
	  }, {
	    key: "unblockButtons",
	    /**
	     * @param {string[]} buttons Array of buttons names to unblock
	     */
	    value: function unblockButtons(buttons) {
	      var _this15 = this;
	      if (!main_core.Type.isArray(buttons)) {
	        console.error("buttons should be array");
	      }
	      buttons.forEach(function (buttonName) {
	        delete _this15.blockedButtons[buttonName];
	        if (_this15.buttons[buttonName]) {
	          _this15.buttons[buttonName].setBlocked(_this15.isButtonBlocked(buttonName));
	        }
	      });
	    }
	  }, {
	    key: "disableMediaSelection",
	    value: function disableMediaSelection() {
	      this.mediaSelectionBlocked = true;
	    }
	  }, {
	    key: "enableMediaSelection",
	    value: function enableMediaSelection() {
	      this.mediaSelectionBlocked = false;
	      if (this.buttons.microphone && this.isMediaSelectionAllowed()) {
	        this.buttons.microphone.showArrow();
	      }
	      if (this.buttons.camera && this.isMediaSelectionAllowed()) {
	        this.buttons.camera.showArrow();
	      }
	    }
	  }, {
	    key: "isMediaSelectionAllowed",
	    value: function isMediaSelectionAllowed() {
	      return this.layout != Layouts.Mobile && (this.uiState == UiState.Preparing || this.uiState == UiState.Connected) && !this.mediaSelectionBlocked && !this.isFullScreen;
	    }
	  }, {
	    key: "getButtonList",
	    value: function getButtonList() {
	      var _this16 = this;
	      if (this.uiState == UiState.Error) {
	        return ['close'];
	      }
	      if (this.uiState == UiState.Initializing) {
	        return ['hangup'];
	      }
	      if (this.size == Size.Folded) {
	        return ['title', 'spacer', 'returnToCall', 'hangup'];
	      }
	      var result = [];
	      result.push('microphone');
	      result.push('camera');
	      if (this.layout != Layouts.Mobile) {
	        result.push('speaker');
	      } else {
	        result.push('mobileMenu');
	      }
	      result.push('chat');
	      result.push('users');
	      if (this.layout != Layouts.Mobile) {
	        result.push('floorRequest');
	        result.push('screen');
	        result.push('record');
	        result.push('document');
	      }
	      if (this.layout !== Layouts.Mobile && CallAI.serviceEnabled) {
	        result.push('copilot');
	      }
	      result = result.filter(function (buttonCode) {
	        return !_this16.hiddenButtons.hasOwnProperty(buttonCode) && !_this16.overflownButtons.hasOwnProperty(buttonCode);
	      });
	      if (Object.keys(this.overflownButtons).length > 0) {
	        result.push('more');
	      }
	      if (this.uiState == UiState.Preparing) {
	        result.push('close');
	      } else {
	        result.push('hangup');
	      }
	      if (!this.hiddenButtons.hasOwnProperty('hangupOptions') && this.isIntranetOrExtranet) {
	        result.push('hangupOptions');
	      }
	      return result;
	    }
	  }, {
	    key: "getTopButtonList",
	    value: function getTopButtonList() {
	      var _this17 = this;
	      var result = [];
	      if (this.layout == Layouts.Mobile) {
	        return ['participantsMobile'];
	      }
	      result.push('watermark');
	      result.push('protected');
	      result.push('recordStatus');
	      result.push('spacer');
	      if (this.uiState === UiState.Connected && this.layout != Layouts.Mobile) {
	        result.push('grid');
	      }
	      if (this.uiState != UiState.Preparing && this.isFullScreenSupported() && this.layout != Layouts.Mobile) {
	        result.push('fullscreen');
	      }
	      if (this.uiState === UiState.Connected && this.layout != Layouts.Mobile) {
	        result.push('feedback');
	      }
	      if (this.uiState != UiState.Preparing) {
	        result.push('participants');
	      }
	      var previousButtonCode = '';
	      result = result.filter(function (buttonCode) {
	        if (previousButtonCode === 'spacer' && buttonCode === 'separator') {
	          return true;
	        }
	        previousButtonCode = buttonCode;
	        return !_this17.hiddenTopButtons.hasOwnProperty(buttonCode);
	      });
	      return result;
	    }
	  }, {
	    key: "render",
	    value: function render() {
	      var _this18 = this;
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall"
	        },
	        children: [this.elements.wrap = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-wrap ".concat(this.isCopilotActive ? 'bx-messenger-videocall-wrap-with-copilot' : '')
	          },
	          children: [this.elements.container = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-inner"
	            },
	            children: [this.elements.center = main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-central-user"
	              },
	              events: {
	                touchstart: this._onCenterTouchStart.bind(this),
	                touchend: this._onCenterTouchEnd.bind(this)
	              }
	            }), this.elements.pageNavigatorLeft = main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-page-navigator left"
	              },
	              children: [this.elements.pageNavigatorLeftCounter = main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-page-navigator-counter left"
	                },
	                html: this.currentPage - 1 + '&nbsp;/&nbsp;' + this.pagesCount
	              }), main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-page-navigator-icon left"
	                }
	              })],
	              events: {
	                click: this._onLeftPageNavigatorClick.bind(this)
	              }
	            }), this.elements.pageNavigatorRight = main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-page-navigator right"
	              },
	              children: [this.elements.pageNavigatorRightCounter = main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-page-navigator-counter right"
	                },
	                html: this.currentPage + 1 + '&nbsp;/&nbsp;' + this.pagesCount
	              }), main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-page-navigator-icon right"
	                }
	              })],
	              events: {
	                click: this._onRightPageNavigatorClick.bind(this)
	              }
	            })]
	          }), this.elements.topPanel = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-top-panel"
	            }
	          }), this.elements.notificationPanel = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-notification-panel"
	            }
	          }), this.elements.bottom = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-bottom"
	            },
	            children: [this.elements.userSelectorContainer = main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-bottom-user-selector-container"
	              }
	            }), this.elements.pinnedUserContainer = main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-bottom-pinned-user-container"
	              }
	            })]
	          })]
	        })],
	        events: {
	          click: this._onBodyClick.bind(this)
	        }
	      });
	      if (this.showButtonPanel) {
	        this.elements.panel = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-panel"
	          }
	        });
	        this.elements.bottom.appendChild(this.elements.panel);
	      } else {
	        this.elements.root.classList.add("bx-messenger-videocall-no-button-panel");
	      }
	      if (this.layout == Layouts.Mobile) {
	        this.userSelector = new UserSelectorMobile({
	          userRegistry: this.userRegistry
	        });
	        this.userSelector.mount(this.elements.userSelectorContainer);
	        this.elements.ear.left = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-mobile-ear left"
	          },
	          events: {
	            click: this._onLeftEarClick.bind(this)
	          }
	        });
	        this.elements.ear.right = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-mobile-ear right"
	          },
	          events: {
	            click: this._onRightEarClick.bind(this)
	          }
	        });
	        this.elements.localUserMobile = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-local-user-mobile"
	          }
	        });
	        if (window.innerHeight < window.innerWidth) {
	          this.elements.root.classList.add("orientation-landscape");
	        }
	        this.elements.wrap.appendChild(this.elements.ear.left);
	        this.elements.wrap.appendChild(this.elements.ear.right);
	        this.elements.wrap.appendChild(this.elements.localUserMobile);
	      }
	      this.centralUser.mount(this.elements.center);
	      this.elements.overlay = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-overlay"
	        }
	      });
	      this.elements.userBlock = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-user-block"
	        },
	        children: [this.elements.ear.top = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-ear bx-messenger-videocall-ear-top"
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-ear-icon"
	            }
	          })],
	          events: {
	            click: this._onTopPageNavigatorClick.bind(this)
	          }
	        }), this.elements.ear.bottom = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-ear bx-messenger-videocall-ear-bottom"
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-videocall-ear-icon"
	            }
	          })],
	          events: {
	            click: this._onBottomPageNavigatorClick.bind(this)
	          }
	        })]
	      });
	      this.elements.userList.container = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-user-list"
	        },
	        events: {
	          scroll: main_core.Runtime.debounce(this.toggleEars.bind(this), 300),
	          wheel: function wheel(e) {
	            return _this18.elements.userList.container.scrollTop += e.deltaY;
	          }
	        }
	      });
	      this.elements.userList.addButton = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-user-add"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-user-add-inner"
	          }
	        })],
	        style: {
	          order: addButtonPosition
	        },
	        events: {
	          click: this._onAddButtonClick.bind(this)
	        }
	      });
	      if (this.layout == Layouts.Centered || this.layout == Layouts.Mobile) {
	        this.centralUser.mount(this.elements.center);
	        this.eventEmitter.emit(EventName.onHasMainStream, {
	          userId: this.centralUser.id
	        });
	        this.elements.root.classList.add("bx-messenger-videocall-centered");
	        if (this.layout != Layouts.Mobile) {
	          this.elements.container.appendChild(this.elements.userBlock);
	        }
	      }
	      if (this.layout == Layouts.Grid) {
	        this.elements.root.classList.add("bx-messenger-videocall-grid");
	      }
	      if (this.layout == Layouts.Mobile) {
	        this.elements.root.classList.add("bx-messenger-videocall-fullscreen-mobile");
	      }
	      this.resizeObserver.observe(this.elements.root);
	      this.resizeObserver.observe(this.container);
	      return this.elements.root;
	    }
	  }, {
	    key: "toggleSubscribingVideoInRenderUserList",
	    value: function toggleSubscribingVideoInRenderUserList(participantIds, showVideo) {
	      if (!!participantIds.length) {
	        this.eventEmitter.emit(EventName.onToggleSubscribe, {
	          participantIds: participantIds,
	          showVideo: showVideo
	        });
	      }
	    }
	  }, {
	    key: "getOrderingRules",
	    value: function getOrderingRules() {
	      var _this19 = this;
	      var rules = {
	        videoEnabled: [],
	        videoDisabled: [],
	        userDisconnected: null
	      };
	      this.rerenderQueue.forEach(function (el) {
	        if (el.reason === RerenderReason.UserDisconnected) {
	          rules.userDisconnected = {
	            id: el.userId,
	            order: _this19.userRegistry.get(el.userId).prevOrder
	          };
	        } else if (el.reason === RerenderReason.VideoEnabled) {
	          rules.videoEnabled.push({
	            id: el.userId,
	            order: _this19.userRegistry.get(el.userId).order
	          });
	        } else if (el.reason === RerenderReason.VideoDisabled) {
	          rules.videoDisabled.push({
	            id: el.userId,
	            order: _this19.userRegistry.get(el.userId).order
	          });
	        }
	      });
	      this.rerenderQueue.clear();
	      rules.videoEnabled.sort(function (a, b) {
	        return a.order - b.order;
	      });
	      rules.videoDisabled.sort(function (a, b) {
	        return a.order - b.order;
	      });
	      return rules;
	    }
	  }, {
	    key: "applyOrderChanges",
	    value: function applyOrderChanges(changes) {
	      if (!main_core.Type.isArray(changes)) {
	        return;
	      }
	      changes.forEach(function (change) {
	        if (change.type === SwapType.Direct) {
	          change.to.userModel.order = change.to.order;
	        } else if (change.type === SwapType.Replace && change.to && change.from) {
	          change.to.userModel.order = change.from.order;
	          change.to.userModel.prevOrder = 0;
	          change.from.userModel.order = change.to.order;
	        }
	      });
	    }
	  }, {
	    key: "isUserHasActiveState",
	    value: function isUserHasActiveState(userModel) {
	      return userModel.state !== UserState.Idle && userModel.state !== UserState.Declined && userModel.state !== UserState.Unavailable && userModel.state !== UserState.Busy && userModel.direction !== EndpointDirection.RecvOnly;
	    }
	  }, {
	    key: "processVideoRules",
	    value: function processVideoRules(rules, params) {
	      var _this20 = this;
	      var diffBetweenChanges = rules.videoEnabled.length - rules.videoDisabled.length;
	      var lessChangesField = diffBetweenChanges > 0 ? 'videoDisabled' : 'videoEnabled';
	      var moreChangesField = diffBetweenChanges > 0 ? 'videoEnabled' : 'videoDisabled';
	      if (rules.videoEnabled.length && rules.videoDisabled.length) {
	        rules[lessChangesField].forEach(function (el, index) {
	          var toUser = _this20.userRegistry.get(el.id);
	          var fromUser = _this20.userRegistry.get(rules[moreChangesField][index].id);
	          params.orderChanges.push({
	            type: SwapType.Replace,
	            to: {
	              userModel: fromUser,
	              order: fromUser.order
	            },
	            from: {
	              userModel: toUser,
	              order: toUser.order
	            }
	          });
	        });
	      }
	      this.applyOrderChanges(params.orderChanges);
	      params.orderChanges.length = 0;
	      if (diffBetweenChanges !== 0) {
	        rules[moreChangesField].splice(0, rules[moreChangesField].length - Math.abs(diffBetweenChanges));
	        rules[lessChangesField].length = 0;
	        if (moreChangesField === 'videoEnabled') {
	          rules.videoEnabled.forEach(function (el) {
	            params.orderChanges.push({
	              type: SwapType.Replace,
	              from: {
	                userModel: _this20.userRegistry.get(el.id),
	                order: _this20.userRegistry.get(el.id).order
	              }
	            });
	            params.incompleteSwaps.push(params.orderChanges.length);
	          });
	        }
	      } else {
	        rules.videoEnabled.length = 0;
	        rules.videoDisabled.length = 0;
	      }
	    }
	  }, {
	    key: "processDisconnectRules",
	    value: function processDisconnectRules(rules, params) {
	      if (!rules.userDisconnected) {
	        return;
	      }
	      var userModel = this.userRegistry.get(rules.userDisconnected.id);
	      if (userModel.prevCameraState) {
	        params.disconnectedUserHadVideo = true;
	      }
	    }
	  }, {
	    key: "completeVideoEnableSwap",
	    value: function completeVideoEnableSwap(userModel, rules, params) {
	      var swapRemains = params.incompleteSwaps.length;
	      if (userModel.state === UserState.Calling) {
	        return;
	      } else if (params.usersWithEnabledVideo.includes(userModel.id)) {
	        params.incompleteSwaps.pop();
	        params.usersWithEnabledVideo.splice(params.usersWithEnabledVideo.indexOf(userModel.id), 1);
	        params.usersToKeepActive.push(userModel.id);
	      } else if (!userModel.cameraState) {
	        var _params$possibleActiv, _params$possibleActiv2;
	        var index = params.incompleteSwaps[swapRemains - 1] - 1;
	        var userEnabledVideo = params.orderChanges[index].from;
	        var currenUserFromCurrentPage = (_params$possibleActiv = params.possibleActiveUsers) === null || _params$possibleActiv === void 0 ? void 0 : _params$possibleActiv.includes(userModel.id);
	        var changedUserFromCurrentPage = (_params$possibleActiv2 = params.possibleActiveUsers) === null || _params$possibleActiv2 === void 0 ? void 0 : _params$possibleActiv2.includes(userEnabledVideo.userModel.id);
	        var skipDeactivation = changedUserFromCurrentPage || currenUserFromCurrentPage && changedUserFromCurrentPage;
	        params.orderChanges[index].to = {
	          userModel: userModel,
	          order: userModel.order
	        };
	        if (!skipDeactivation) {
	          params.currentPageUsers.pop();
	          params.usersToDeactivate++;
	        } else if (changedUserFromCurrentPage && !currenUserFromCurrentPage) {
	          params.usersToForceDeactivation.push(userEnabledVideo.userModel.id);
	        } else if (currenUserFromCurrentPage && changedUserFromCurrentPage) {
	          params.usersToKeepActive.push(userModel.id);
	        }
	        params.incompleteSwaps.pop();
	      }
	    }
	  }, {
	    key: "completeVideoDisabledSwap",
	    value: function completeVideoDisabledSwap(rules, params) {
	      var _this21 = this;
	      var usersProceed = 0;
	      rules.videoDisabled.forEach(function (el, index) {
	        var userWithoutVideo = _this21.userRegistry.get(el.id);
	        var userWithoutVideoIndex = params.activeUsers.indexOf(el.id);
	        var userWithoutVideoPage = Math.ceil((userWithoutVideoIndex + 1) / _this21.usersPerPage);
	        var skipUsers = (userWithoutVideoPage - 1) * _this21.usersPerPage;
	        var numberOfUsersWithVideoForSwap = params.usersWithVideo.length - skipUsers;
	        var userToSwap = params.usersWithVideo[params.usersWithVideo.length - 1 - index];
	        var canCompleteVideoSwap = userToSwap && userToSwap.order > el.order;
	        if (canCompleteVideoSwap && numberOfUsersWithVideoForSwap - usersProceed >= rules.videoDisabled.length - index) {
	          usersProceed++;
	          params.orderChanges.push({
	            type: SwapType.Replace,
	            to: {
	              userModel: userWithoutVideo,
	              order: userWithoutVideo.order
	            },
	            from: {
	              userModel: userToSwap,
	              order: userToSwap.order
	            }
	          });
	          var userToSwapIndex = params.activeUsers.indexOf(userToSwap.id);
	          var userToSwapPage = Math.ceil((userToSwapIndex + 1) / _this21.usersPerPage);
	          if (userWithoutVideoPage === _this21.currentPage && userToSwapPage > _this21.currentPage) {
	            params.usersToKeepActive.push(userToSwap.id);
	            params.usersToForceDeactivation.push(el.id);
	            params.usersToDeactivate++;
	          } else if (userToSwapPage === _this21.currentPage && userToSwapPage > userWithoutVideoPage) {
	            params.usersToKeepActive.push(el.id);
	            params.usersToForceDeactivation.push(userToSwap.id);
	            params.usersToDeactivate++;
	          }
	        }
	      });
	    }
	  }, {
	    key: "calculateUserActive",
	    value: function calculateUserActive(userModel, status, userSkipped, params) {
	      if (params.usersWithEnabledVideo.includes(userModel.id) && !userSkipped && !params.possibleActiveUsers.includes(userModel.id)) {
	        params.currentPageUsers.push(userModel);
	        params.usersToDeactivate--;
	        status = true;
	      } else if (params.currentPageUsers.length + params.usersToDeactivate > this.usersPerPage) {
	        params.currentPageUsers.pop();
	        status = false;
	      }
	      return status;
	    }
	  }, {
	    key: "completeDisconnectSwap",
	    value: function completeDisconnectSwap(rules, params) {
	      var _this$userRegistry$ge, _this$userRegistry$ge2;
	      var lowerOrderOnCurrentPage = (_this$userRegistry$ge = this.userRegistry.get(params.possibleActiveUsers[0])) === null || _this$userRegistry$ge === void 0 ? void 0 : _this$userRegistry$ge.order;
	      var higherOrderOnCurrentPage = (_this$userRegistry$ge2 = this.userRegistry.get(params.possibleActiveUsers[params.possibleActiveUsers.length - 1])) === null || _this$userRegistry$ge2 === void 0 ? void 0 : _this$userRegistry$ge2.order;
	      var disconnectedUserFromCurrentPage = false;
	      if (this.currentPage === 1) {
	        disconnectedUserFromCurrentPage = rules.userDisconnected.order < lowerOrderOnCurrentPage || rules.userDisconnected.order > lowerOrderOnCurrentPage && rules.userDisconnected.order < higherOrderOnCurrentPage;
	      } else {
	        var skipUsers = this.currentPage > 1 ? (this.currentPage - 2) * this.usersPerPage : 0;
	        var activeUsersFromPreviousPage = params.activeUsers.slice(skipUsers, skipUsers + this.usersPerPage);
	        var lastActiveUserFromPreviousPage = this.userRegistry.get(activeUsersFromPreviousPage[activeUsersFromPreviousPage.length - 1]);
	        disconnectedUserFromCurrentPage = rules.userDisconnected.order > lowerOrderOnCurrentPage && rules.userDisconnected.order < higherOrderOnCurrentPage || rules.userDisconnected.order < lowerOrderOnCurrentPage && rules.userDisconnected.order > (lastActiveUserFromPreviousPage === null || lastActiveUserFromPreviousPage === void 0 ? void 0 : lastActiveUserFromPreviousPage.order);
	      }
	      var userToSwap = params.disconnectedUserHadVideo ? params.usersWithVideo[params.usersWithVideo.length - 1] : this.userRegistry.get(params.activeUsers[params.activeUsers.length - 1]);
	      if (!userToSwap || userToSwap.order <= rules.userDisconnected.order) {
	        return;
	      }
	      params.orderChanges.push({
	        type: SwapType.Direct,
	        to: {
	          userModel: userToSwap,
	          order: rules.userDisconnected.order
	        }
	      });
	      if (this.currentPage !== this.pagesCount && disconnectedUserFromCurrentPage && !params.possibleActiveUsers.includes(userToSwap.id)) {
	        params.usersToKeepActive.push(userToSwap.id);
	        params.usersToDeactivate++;
	      }
	    }
	  }, {
	    key: "renderAddUserButtonInList",
	    value: function renderAddUserButtonInList() {
	      var showAdd = this.showAddUserButtonInList && this.layout == Layouts.Centered && this.uiState === UiState.Connected && !this.isButtonBlocked("add") && this.getConnectedUserCount() < this.userLimit - 1 && !this.isFullScreen && this.elements.userList.addButton;
	      if (showAdd) {
	        this.elements.userList.container.appendChild(this.elements.userList.addButton);
	        return;
	      }
	      main_core.Dom.remove(this.elements.userList.addButton);
	    }
	  }, {
	    key: "renderUserList",
	    value: function renderUserList(pageChange) {
	      var _this22 = this;
	      clearTimeout(this.rerenderTimeout);
	      this.rerenderTimeout = null;
	      this.activeUsers = [];
	      this.inactiveUsers = [];
	      var showLocalUser = this.shouldShowLocalUser();
	      var userCount = 0;
	      var skipUsers = 0;
	      var skippedUsers = 0;
	      var renderedUsers = 0;
	      var orderingRules = this.getOrderingRules();
	      var orderingParams = {
	        usersWithVideo: [],
	        usersWithEnabledVideo: [],
	        usersWithDisabledVideo: [],
	        possibleActiveUsers: null,
	        usersToKeepActive: [],
	        usersToForceDeactivation: [],
	        currentPageUsers: [],
	        orderChanges: [],
	        incompleteSwaps: [],
	        disconnectedUserHadVideo: false,
	        usersToDeactivate: 0,
	        videoDisabledProceed: false
	      };
	      if ((this.layout === Layouts.Grid || this.layout === Layouts.Centered) && this.pagesCount > 1) {
	        skipUsers = (this.currentPage - 1) * this.usersPerPage;
	      }
	      if (this.layout === Layouts.Grid) {
	        this.processVideoRules(orderingRules, orderingParams);
	        this.processDisconnectRules(orderingRules, orderingParams);
	        orderingParams.usersWithEnabledVideo = orderingRules.videoEnabled.map(function (el) {
	          return el.id;
	        });
	        orderingParams.usersWithDisabledVideo = orderingRules.videoDisabled.map(function (el) {
	          return el.id;
	        });
	        orderingParams.activeUsers = this.getActiveUsers();
	        orderingParams.possibleActiveUsers = orderingParams.activeUsers.slice(skipUsers, skipUsers + this.usersPerPage);
	        orderingParams.usersWithVideo = this.getUsersWithCamera();
	        this.completeVideoDisabledSwap(orderingRules, orderingParams);
	        if (orderingRules.userDisconnected) {
	          this.completeDisconnectSwap(orderingRules, orderingParams);
	        }
	      } else if (this.layout === Layouts.Centered) {
	        // new grid logic is applied only in the Layouts.Grid layout
	        // so we need to save some rules for later
	        orderingRules.videoEnabled.forEach(function (user) {
	          return _this22.shelvedRerenderQueue.set(user.id, {
	            userId: user.id,
	            reason: RerenderReason.VideoEnabled
	          });
	        });
	        orderingRules.videoDisabled.forEach(function (user) {
	          return _this22.shelvedRerenderQueue.set(user.id, {
	            userId: user.id,
	            reason: RerenderReason.VideoDisabled
	          });
	        });
	      }
	      for (var i = 0; i < this.userRegistry.users.length; i++) {
	        var userModel = this.userRegistry.users[i];
	        var userId = userModel.id;
	        if (!this.users.hasOwnProperty(userId)) {
	          continue;
	        }
	        var user = this.users[userId];
	        var screenUser = this.screenUsers[userId];
	        if (userId == this.centralUser.id && (this.layout == Layouts.Centered || this.layout == Layouts.Mobile)) {
	          if (this.layout == Layouts.Centered) {
	            this.activeUsers.push(userId);
	          }
	          this.unobserveIntersections(user);
	          if (screenUser.hasVideo()) {
	            screenUser.mount(this.elements.center);
	            screenUser.visible = true;
	            user.mount(this.elements.userList.container);
	          } else {
	            user.visible = true;
	            user.mount(this.elements.center);
	            screenUser.dismount();
	          }
	          continue;
	        }
	        var userActive = this.isUserHasActiveState(userModel);
	        var userSkipped = false;
	        if (userActive && skipUsers > 0 && skippedUsers < skipUsers) {
	          // skip users on previous pages
	          skippedUsers++;
	          userActive = false;
	          userSkipped = true;
	        }
	        if (userActive && this.layout === Layouts.Grid && this.usersPerPage > 0 && renderedUsers < this.usersPerPage) {
	          orderingParams.currentPageUsers.push(userModel);
	        }
	        if (this.layout === Layouts.Grid) {
	          if (orderingRules.videoEnabled.length) {
	            if ((userActive || userSkipped) && orderingParams.incompleteSwaps.length) {
	              var _orderingParams$possi, _orderingParams$possi2;
	              var previousIncompleteSwaps = orderingParams.incompleteSwaps.length;
	              var index = orderingParams.incompleteSwaps[0] - 1;
	              var userEnabledVideo = orderingParams.orderChanges[index].from;
	              var currentUserFromCurrentPage = (_orderingParams$possi = orderingParams.possibleActiveUsers) === null || _orderingParams$possi === void 0 ? void 0 : _orderingParams$possi.includes(userModel.id);
	              var changedUserFromCurrentPage = (_orderingParams$possi2 = orderingParams.possibleActiveUsers) === null || _orderingParams$possi2 === void 0 ? void 0 : _orderingParams$possi2.includes(userEnabledVideo.userModel.id);
	              var currentUserFromNextPage = userModel.order > orderingParams.possibleActiveUsers[orderingParams.possibleActiveUsers.length - 1].order;
	              this.completeVideoEnableSwap(userModel, orderingRules, orderingParams);
	              var swapCompleted = previousIncompleteSwaps !== orderingParams.incompleteSwaps.length;
	              if (swapCompleted && userActive && !changedUserFromCurrentPage && !orderingParams.usersToKeepActive.includes(userModel.id)) {
	                userActive = false;
	              } else if (swapCompleted && (!userSkipped && !currentUserFromCurrentPage || userSkipped && changedUserFromCurrentPage)) {
	                userActive = true;
	              }
	            }
	            if (orderingParams.usersToDeactivate) {
	              userActive = this.calculateUserActive(userModel, userActive, userSkipped, orderingParams);
	            }
	            if (orderingParams.usersToForceDeactivation.includes(userModel.id)) {
	              userActive = false;
	            }
	          } else if (orderingRules.videoDisabled.length) {
	            if (orderingParams.usersToKeepActive.includes(userModel.id)) {
	              userActive = true;
	              orderingParams.usersToDeactivate--;
	            } else if (orderingParams.usersToForceDeactivation.includes(userModel.id) || orderingParams.currentPageUsers.length + orderingParams.usersToDeactivate > this.usersPerPage) {
	              userActive = false;
	              orderingParams.currentPageUsers.pop();
	            }
	          } else if (orderingRules.userDisconnected) {
	            if (orderingParams.usersToKeepActive.includes(userModel.id)) {
	              userActive = true;
	              orderingParams.usersToDeactivate--;
	            } else if (orderingParams.currentPageUsers.length + orderingParams.usersToDeactivate > this.usersPerPage) {
	              userActive = false;
	              orderingParams.currentPageUsers.pop();
	            }
	          }
	        }
	        if (userActive && (this.layout === Layouts.Grid || this.layout === Layouts.Centered) && this.usersPerPage > 0 && renderedUsers >= this.usersPerPage) {
	          // skip users on following pages
	          userActive = false;
	        }
	        if (userActive) {
	          this.activeUsers.push(userId);
	        } else {
	          this.inactiveUsers.push(userId);
	        }
	        if (!userActive) {
	          user.dismount();
	          this.unobserveIntersections(user);
	          screenUser.dismount();
	          continue;
	        }
	        if (screenUser.hasVideo()) {
	          screenUser.mount(this.elements.userList.container);
	          userCount++;
	        } else {
	          screenUser.dismount();
	        }
	        user.mount(this.elements.userList.container);
	        if (!this.isPreparing) {
	          this.observeIntersections(user);
	        }
	        renderedUsers++;
	        userCount++;
	      }
	      this.applyOrderChanges(orderingParams.orderChanges);
	      if (showLocalUser) {
	        if (this.layout == Layouts.Centered && this.userId == this.centralUser.id || this.layout == Layouts.Mobile) {
	          // this.unobserveIntersections(this.localUser);
	          this.localUser.mount(this.elements.center, true);
	          this.localUser.visible = true;
	        } else {
	          // using force true to always move self to the end of the list
	          this.localUser.mount(this.elements.userList.container);
	          if (this.layout == Layouts.Centered && this.intersectionObserver) ; else {
	            this.localUser.visible = true;
	          }
	        }
	        userCount++;
	      } else {
	        this.localUser.dismount();
	        // this.unobserveIntersections(this.localUser);
	      }

	      if (this.layout == Layouts.Grid) {
	        this.updateGridUserSize(userCount);
	      } else {
	        this.elements.userList.container.classList.add("bx-messenger-videocall-user-list-small");
	        this.elements.userList.container.style.removeProperty('--avatar-size');
	        this.elements.userList.container.style.removeProperty('--avatar-text-size');
	        this.updateCentralUserAvatarSize();
	      }
	      this.applyIncomingVideoConstraints();
	      this.renderAddUserButtonInList();
	      this.elements.root.classList.toggle("bx-messenger-videocall-user-list-empty", this.elements.userList.container.childElementCount === 0);
	      this.localUser.updatePanelDeferred();
	      this.toggleSubscribingVideoInRenderUserList(this.activeUsers, true);
	      this.toggleSubscribingVideoInRenderUserList(this.inactiveUsers, false);
	    }
	  }, {
	    key: "shouldShowLocalUser",
	    value: function shouldShowLocalUser() {
	      return this.localUser.userModel.state != UserState.Idle && this.localUser.userModel.direction != EndpointDirection.RecvOnly;
	    }
	  }, {
	    key: "updateGridUserSize",
	    value: function updateGridUserSize(userCount) {
	      var containerSize = this.elements.userList.container.getBoundingClientRect();
	      this.userSize = Util.findBestElementSize(containerSize.width, containerSize.height, userCount, MIN_GRID_USER_WIDTH, MIN_GRID_USER_HEIGHT);

	      //Change the size to make it possible to make indents between users
	      var rows = Math.floor(containerSize.height / MIN_GRID_USER_HEIGHT) || 1;
	      this.userSize.width -= 5 * rows;
	      this.userSize.height -= 2.75 * rows;
	      var avatarSize = Math.round(this.userSize.height * 0.45);
	      var avatarTextSize = Math.round(avatarSize * 0.45);
	      this.elements.userList.container.style.setProperty('--grid-user-width', this.userSize.width + 'px');
	      this.elements.userList.container.style.setProperty('--grid-user-height', this.userSize.height + 'px');
	      this.elements.userList.container.style.setProperty('--avatar-size', avatarSize + 'px');
	      this.elements.userList.container.style.setProperty('--avatar-text-size', avatarTextSize + 'px');
	      if (this.userSize.width < 220) {
	        this.elements.userList.container.classList.add("bx-messenger-videocall-user-list-small");
	      } else {
	        this.elements.userList.container.classList.remove("bx-messenger-videocall-user-list-small");
	      }
	    }
	  }, {
	    key: "updateCentralUserAvatarSize",
	    value: function updateCentralUserAvatarSize() {
	      var containerSize;
	      var avatarSize;
	      if (this.layout == Layouts.Mobile) {
	        containerSize = this.elements.root.getBoundingClientRect();
	        avatarSize = Math.round(containerSize.width * 0.55);
	      } else if (this.layout == Layouts.Centered) {
	        containerSize = this.elements.center.getBoundingClientRect();
	        avatarSize = Math.min(Math.round(containerSize.height * 0.45), Math.round(containerSize.width * 0.45));
	        this.centralUser.setIncomingVideoConstraints(Math.floor(containerSize.width), Math.floor(containerSize.height));
	      }
	      var avatarTextSize = Math.round(avatarSize * 0.45);
	      this.elements.center.style.setProperty('--avatar-size', avatarSize + 'px');
	      this.elements.center.style.setProperty('--avatar-text-size', avatarTextSize + 'px');
	    }
	  }, {
	    key: "renderButtons",
	    value: function renderButtons(buttons) {
	      var _this23 = this;
	      var panelInner, left, center, right;
	      panelInner = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-videocall-panel-inner"
	        }
	      });
	      if (this.layout === Layouts.Mobile || this.size === Size.Folded) {
	        left = panelInner;
	        center = panelInner;
	        right = panelInner;
	      } else {
	        left = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-panel-inner-left"
	          }
	        });
	        center = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-panel-inner-center"
	          }
	        });
	        right = main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-videocall-panel-inner-right"
	          }
	        });
	        panelInner.appendChild(left);
	        panelInner.appendChild(center);
	        panelInner.appendChild(right);
	      }
	      for (var i = 0; i < buttons.length; i++) {
	        switch (buttons[i]) {
	          case "title":
	            this.buttons.title = new TitleButton({
	              text: this.title,
	              isGroupCall: Object.keys(this.users).length > 1
	            });
	            left.appendChild(this.buttons.title.render());
	            break;
	          /*case "grid":
	          	this.buttons.grid = new SimpleButton({
	          		class: "grid",
	          		text: BX.message("IM_M_CALL_BTN_GRID"),
	          		onClick: this._onGridButtonClick.bind(this)
	          	});
	          	panelInner.appendChild(this.buttons.grid.render());
	          	break;*/
	          /*case "add":
	          	this.buttons.add = new SimpleButton({
	          		class: "add",
	          		text: BX.message("IM_M_CALL_BTN_ADD"),
	          		onClick: this._onAddButtonClick.bind(this)
	          	});
	          	leftSubPanel.appendChild(this.buttons.add.render());
	          	break;*/
	          case "share":
	            this.buttons.share = new SimpleButton({
	              "class": "share",
	              text: BX.message("IM_M_CALL_BTN_LINK"),
	              onClick: this._onShareButtonClick.bind(this)
	            });
	            center.appendChild(this.buttons.share.render());
	            break;
	          case "microphone":
	            this.buttons.microphone = new DeviceButton({
	              "class": "microphone",
	              text: BX.message("IM_M_CALL_BTN_MIC"),
	              enabled: !Hardware.isMicrophoneMuted,
	              arrowHidden: this.layout == Layouts.Mobile,
	              arrowEnabled: this.isMediaSelectionAllowed(),
	              showPointer: true,
	              //todo
	              blocked: this.isButtonBlocked("microphone"),
	              showLevel: true,
	              sideIcon: this.getMicrophoneSideIcon(this.roomState),
	              onClick: function onClick(e) {
	                _this23._onMicrophoneButtonClick(e);
	                _this23._showMicrophoneHint(e);
	              },
	              onArrowClick: this._onMicrophoneArrowClick.bind(this),
	              onMouseOver: this._showMicrophoneHint.bind(this),
	              onMouseOut: function onMouseOut() {
	                return _this23._destroyHotKeyHint();
	              },
	              onSideIconClick: this._onMicrophoneSideIconClick.bind(this)
	            });
	            left.appendChild(this.buttons.microphone.render());
	            break;
	          case "camera":
	            this.buttons.camera = new DeviceButton({
	              "class": "camera",
	              text: BX.message("IM_M_CALL_BTN_CAMERA"),
	              enabled: Hardware.isCameraOn,
	              arrowHidden: this.layout == Layouts.Mobile,
	              arrowEnabled: this.isMediaSelectionAllowed(),
	              blocked: this.isButtonBlocked("camera"),
	              onClick: this._onCameraButtonClick.bind(this),
	              onArrowClick: this._onCameraArrowClick.bind(this),
	              onMouseOver: function onMouseOver(e) {
	                _this23._showHotKeyHint(e.currentTarget.firstChild, "camera", _this23.keyModifier + " + V");
	              },
	              onMouseOut: function onMouseOut() {
	                _this23._destroyHotKeyHint();
	              }
	            });
	            left.appendChild(this.buttons.camera.render());
	            break;
	          case "screen":
	            if (!this.buttons.screen) {
	              this.buttons.screen = new SimpleButton({
	                "class": "screen",
	                backgroundClass: "bx-messenger-videocall-panel-background-screen",
	                text: BX.message("IM_M_CALL_BTN_SCREEN"),
	                blocked: this.isButtonBlocked("screen"),
	                onClick: this._onScreenButtonClick.bind(this),
	                onMouseOver: function onMouseOver(e) {
	                  _this23._showHotKeyHint(e.currentTarget, "screen", _this23.keyModifier + " + S");
	                },
	                onMouseOut: function onMouseOut() {
	                  _this23._destroyHotKeyHint();
	                }
	              });
	            } else {
	              this.buttons.screen.setBlocked(this.isButtonBlocked("screen"));
	            }
	            center.appendChild(this.buttons.screen.render());
	            break;
	          case "record":
	            if (!this.buttons.record) {
	              this.buttons.record = new SimpleButton({
	                "class": "record",
	                backgroundClass: "bx-messenger-videocall-panel-background-record",
	                text: this.recordState.state === View.RecordState.Started || this.recordState.state === View.RecordState.Resumed ? BX.message("CALL_M_BTN_TITLE_STOP_RECORD") : BX.message("IM_M_CALL_BTN_RECORD"),
	                blocked: this.isButtonBlocked("record"),
	                onClick: this._onRecordToggleClick.bind(this),
	                onMouseOver: function onMouseOver(e) {
	                  if (_this23.isRecordingHotKeySupported()) {
	                    _this23._showHotKeyHint(e.currentTarget, "record", _this23.keyModifier + " + R");
	                  }
	                },
	                onMouseOut: function onMouseOut() {
	                  if (_this23.isRecordingHotKeySupported()) {
	                    _this23._destroyHotKeyHint();
	                  }
	                }
	              });
	            } else {
	              this.buttons.record.setBlocked(this.isButtonBlocked('record'));
	            }
	            center.appendChild(this.buttons.record.render());
	            break;
	          case "document":
	            if (!this.buttons.document) {
	              this.buttons.document = new SimpleButton({
	                "class": "document",
	                backgroundClass: "bx-messenger-videocall-panel-background-document",
	                text: BX.message("IM_M_CALL_BTN_DOCUMENT"),
	                blocked: this.isButtonBlocked("document"),
	                onClick: this._onDocumentButtonClick.bind(this)
	              });
	            } else {
	              this.buttons.document.setBlocked(this.isButtonBlocked('document'));
	            }
	            center.appendChild(this.buttons.document.render());
	            break;
	          case "copilot":
	            if (!this.buttons.copilot) {
	              this.buttons.copilot = new SimpleButton({
	                "class": "copilot",
	                backgroundClass: "bx-messenger-videocall-panel-background-copilot",
	                text: BX.message("CALL_BUTTON_COPILOT_TITLE"),
	                blocked: this.isButtonBlocked("copilot"),
	                onClick: this._onCopilotButtonClick.bind(this),
	                isComingSoon: !this.isCopilotFeaturesEnabled
	              });
	            } else {
	              this.buttons.copilot.setBlocked(this.isButtonBlocked('copilot'));
	            }
	            if (this.isCopilotActive) {
	              this.buttons.copilot.setActive(true);
	            }
	            center.appendChild(this.buttons.copilot.render());
	            break;
	          case "returnToCall":
	            this.buttons.returnToCall = new SimpleButton({
	              "class": "returnToCall",
	              text: BX.message("IM_M_CALL_BTN_RETURN_TO_CALL"),
	              onClick: this._onBodyClick.bind(this)
	            });
	            right.appendChild(this.buttons.returnToCall.render());
	            break;
	          case "hangup":
	            this.buttons.hangup = new SimpleButton({
	              "class": "hangup",
	              backgroundClass: "bx-messenger-videocall-panel-icon-background-hangup",
	              text: Object.keys(this.users).length > 1 ? BX.message("IM_M_CALL_BTN_DISCONNECT") : BX.message("IM_M_CALL_BTN_HANGUP"),
	              onClick: this._onHangupButtonClick.bind(this)
	            });
	            right.appendChild(this.buttons.hangup.render());
	            break;
	          case "hangupOptions":
	            this.buttons.hangupOptions = new SimpleButton({
	              "class": "hangup-options",
	              backgroundClass: "bx-messenger-videocall-panel-icon-background-hangup-options",
	              onClick: this._onHangupOptionsButtonClick.bind(this)
	            });
	            right.appendChild(this.buttons.hangupOptions.render());
	            break;
	          case "close":
	            this.buttons.close = new SimpleButton({
	              "class": "close",
	              backgroundClass: "bx-messenger-videocall-panel-icon-background-hangup",
	              text: BX.message("IM_M_CALL_BTN_CLOSE"),
	              onClick: this._onCloseButtonClick.bind(this)
	            });
	            right.appendChild(this.buttons.close.render());
	            break;
	          case "speaker":
	            /*this.buttons.speaker = new Buttons.DeviceButton({
	            	class: "speaker",
	            	text: BX.message("IM_M_CALL_BTN_SPEAKER"),
	            	enabled: !this.speakerMuted,
	            	arrowEnabled: Hardware.canSelectSpeaker() && this.isMediaSelectionAllowed(),
	            	onClick: this._onSpeakerButtonClick.bind(this),
	            	onArrowClick: this._onSpeakerArrowClick.bind(this)
	            });
	            rightSubPanel.appendChild(this.buttons.speaker.render());*/
	            break;
	          case "mobileMenu":
	            if (!this.buttons.mobileMenu) {
	              this.buttons.mobileMenu = new SimpleButton({
	                "class": "sandwich",
	                text: BX.message("IM_M_CALL_BTN_MENU"),
	                onClick: this._onMobileMenuButtonClick.bind(this)
	              });
	            }
	            center.appendChild(this.buttons.mobileMenu.render());
	            break;
	          case "chat":
	            if (!this.buttons.chat) {
	              this.buttons.chat = new SimpleButton({
	                "class": "chat",
	                backgroundClass: "bx-messenger-videocall-panel-background-chat",
	                text: BX.message("IM_M_CALL_BTN_CHAT"),
	                blocked: this.isButtonBlocked("chat"),
	                onClick: this._onChatButtonClick.bind(this),
	                onMouseOver: function onMouseOver(e) {
	                  _this23._showHotKeyHint(e.currentTarget, "chat", _this23.keyModifier + " + C");
	                },
	                onMouseOut: function onMouseOut() {
	                  _this23._destroyHotKeyHint();
	                }
	              });
	            } else {
	              this.buttons.chat.setBlocked(this.isButtonBlocked('chat'));
	            }
	            center.appendChild(this.buttons.chat.render());
	            break;
	          case "floorRequest":
	            if (!this.buttons.floorRequest) {
	              this.buttons.floorRequest = new SimpleButton({
	                "class": "floor-request",
	                backgroundClass: "bx-messenger-videocall-panel-background-floor-request",
	                text: BX.message("IM_M_CALL_BTN_WANT_TO_SAY"),
	                blocked: this.isButtonBlocked("floorRequest"),
	                onClick: this._onFloorRequestButtonClick.bind(this),
	                onMouseOver: function onMouseOver(e) {
	                  _this23._showHotKeyHint(e.currentTarget, "floorRequest", _this23.keyModifier + " + H");
	                },
	                onMouseOut: function onMouseOut() {
	                  return _this23._destroyHotKeyHint();
	                }
	              });
	            } else {
	              this.buttons.floorRequest.setBlocked(this.isButtonBlocked('floorRequest'));
	            }
	            center.appendChild(this.buttons.floorRequest.render());
	            break;
	          case "more":
	            if (!this.buttons.more) {
	              this.buttons.more = new SimpleButton({
	                "class": "more",
	                onClick: this._onMoreButtonClick.bind(this)
	              });
	            }
	            center.appendChild(this.buttons.more.render());
	            break;
	          case "spacer":
	            panelInner.appendChild(main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-panel-spacer"
	              }
	            }));
	            break;
	          /*case "history":
	          	this.buttons.history = new Buttons.SimpleButton({
	          		class: "history",
	          		text: BX.message("IM_M_CALL_BTN_HISTORY"),
	          		onClick: this._onHistoryButtonClick.bind(this)
	          	});
	          	rightSubPanel.appendChild(this.buttons.history.render());
	          	break;*/
	        }
	      }

	      return panelInner;
	    }
	  }, {
	    key: "renderTopButtons",
	    value: function renderTopButtons(buttons) {
	      var _this24 = this;
	      var result = BX.createFragment();
	      for (var i = 0; i < buttons.length; i++) {
	        switch (buttons[i]) {
	          case "watermark":
	            this.buttons.waterMark = new WaterMarkButton({
	              language: this.language
	            });
	            result.appendChild(this.buttons.waterMark.render());
	            break;
	          case "protected":
	            this.buttons["protected"] = new TopFramelessButton({
	              iconClass: "protected",
	              textClass: "protected",
	              text: BX.message("IM_M_CALL_PROTECTED").toLowerCase(),
	              onMouseOver: function onMouseOver(e) {
	                _this24.hintManager.popupParameters.events = null;
	                _this24.hintManager.show(e.currentTarget, BX.message("IM_M_CALL_PROTECTED_HINT"));
	              },
	              onMouseOut: function onMouseOut() {
	                _this24.hintManager.hide();
	              }
	            });
	            result.appendChild(this.buttons["protected"].render());
	            break;
	          case "recordStatus":
	            if (this.buttons.recordStatus) {
	              this.buttons.recordStatus.updateView();
	            } else {
	              this.buttons.recordStatus = new RecordStatusButton({
	                userId: this.userId,
	                recordState: this.recordState,
	                onPauseClick: this._onRecordPauseClick.bind(this),
	                onStopClick: this._onRecordStopClick.bind(this),
	                onMouseOver: this._onRecordMouseOver.bind(this),
	                onMouseOut: this._onRecordMouseOut.bind(this)
	              });
	            }
	            result.appendChild(this.buttons.recordStatus.render());
	            break;
	          case "grid":
	            this.buttons.grid = new TopButton({
	              iconClass: this.layout == Layouts.Grid ? "speaker" : "grid",
	              text: this.layout == Layouts.Grid ? BX.message("IM_M_CALL_SPEAKER_MODE") : BX.message("IM_M_CALL_GRID_MODE"),
	              onClick: this._onGridButtonClick.bind(this),
	              onMouseOver: function onMouseOver(e) {
	                _this24._showHotKeyHint(e.currentTarget, "grid", _this24.keyModifier + " + W", {
	                  position: "bottom"
	                });
	              },
	              onMouseOut: function onMouseOut() {
	                _this24._destroyHotKeyHint();
	              }
	            });
	            result.appendChild(this.buttons.grid.render());
	            break;
	          case "fullscreen":
	            this.buttons.fullscreen = new TopButton({
	              iconClass: this.isFullScreen ? "fullscreen-leave" : "fullscreen-enter",
	              text: this.isFullScreen ? BX.message("IM_M_CALL_WINDOW_MODE") : BX.message("IM_M_CALL_FULLSCREEN_MODE"),
	              onClick: this._onFullScreenButtonClick.bind(this)
	            });
	            result.appendChild(this.buttons.fullscreen.render());
	            break;
	          case "feedback":
	            this.buttons.feedback = new TopButton({
	              iconClass: 'feedback',
	              text: BX.message('IM_OL_COMMENT_HEAD_BUTTON_VOTE'),
	              onClick: this._onFeedbackButtonClick.bind(this)
	            });
	            result.appendChild(this.buttons.feedback.render());
	            break;
	          case "participants":
	            var foldButtonState = void 0;
	            if (this.isFullScreen && this.layout == Layouts.Centered) {
	              foldButtonState = this.isUserBlockFolded ? ParticipantsButton.FoldButtonState.Unfold : ParticipantsButton.FoldButtonState.Fold;
	            } else if (this.showUsersButton) {
	              foldButtonState = ParticipantsButton.FoldButtonState.Active;
	            } else {
	              foldButtonState = ParticipantsButton.FoldButtonState.Hidden;
	            }
	            if (this.buttons.participants) {
	              this.buttons.participants.update({
	                foldButtonState: foldButtonState,
	                allowAdding: !this.isButtonBlocked("add"),
	                count: this.getConnectedUserCount(true)
	              });
	            } else {
	              this.buttons.participants = new ParticipantsButton({
	                foldButtonState: foldButtonState,
	                allowAdding: !this.isButtonBlocked("add"),
	                count: this.getConnectedUserCount(true),
	                onListClick: this._onParticipantsButtonListClick.bind(this),
	                onAddClick: this._onAddButtonClick.bind(this)
	              });
	            }
	            result.appendChild(this.buttons.participants.render());
	            break;
	          case "participantsMobile":
	            this.buttons.participantsMobile = new ParticipantsButtonMobile({
	              count: this.getConnectedUserCount(true),
	              onClick: this._onParticipantsButtonMobileListClick.bind(this)
	            });
	            result.appendChild(this.buttons.participantsMobile.render());
	            break;
	          case "separator":
	            result.appendChild(main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-top-separator"
	              }
	            }));
	            break;
	          case "spacer":
	            result.appendChild(main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-videocall-top-panel-spacer"
	              }
	            }));
	            break;
	        }
	      }
	      return result;
	    }
	  }, {
	    key: "updateCopilotState",
	    value: function updateCopilotState(isActive) {
	      this.isCopilotActive = isActive;
	      this.setButtonActive('copilot', this.isCopilotActive);
	      if (this.elements.wrap) {
	        this.elements.wrap.classList[this.isCopilotActive ? 'add' : 'remove']('bx-messenger-videocall-wrap-with-copilot');
	      }
	    }
	  }, {
	    key: "updateCopilotFeatureState",
	    value: function updateCopilotFeatureState(isEnabled) {
	      this.isCopilotFeaturesEnabled = isEnabled;
	      if (!this.buttons.copilot) {
	        return;
	      }
	      this.buttons.copilot.setIsComingSoon(!this.isCopilotFeaturesEnabled);
	    }
	  }, {
	    key: "showCopilotNotify",
	    value: function showCopilotNotify() {
	      var callId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
	      var errorCode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
	      var notifyType = '';
	      if (!errorCode) {
	        notifyType = CopilotNotifyType[this.isCopilotActive ? 'COPILOT_ENABLED' : 'COPILOT_DISABLED'];
	      }
	      this.copilotNotify = this.createCopilotNotify(notifyType, callId);
	      if (this.copilotNotify) {
	        this.copilotNotify.show();
	      }
	    }
	  }, {
	    key: "closeCopilotNotify",
	    value: function closeCopilotNotify() {
	      if (this.copilotNotify) {
	        this.copilotNotify.close();
	      }
	    }
	  }, {
	    key: "showCopilotResultNotify",
	    value: function showCopilotResultNotify() {
	      this.copilotNotify = this.createCopilotNotify(CopilotNotifyType.COPILOT_RESULT);
	      if (this.copilotNotify) {
	        this.copilotNotify.show();
	      }
	    }
	  }, {
	    key: "showCopilotErrorNotify",
	    value: function showCopilotErrorNotify(errorType) {
	      this.copilotNotify = this.createCopilotNotify(CopilotNotifyType[errorType]);
	      if (this.copilotNotify) {
	        this.copilotNotify.show();
	      }
	    }
	  }, {
	    key: "createCopilotNotify",
	    value: function createCopilotNotify(notifyType, callId) {
	      var _this25 = this;
	      if (!this.buttons.copilot) {
	        return null;
	      }
	      return new CopilotNotify({
	        type: notifyType,
	        bindElement: this.buttons.copilot.elements.root,
	        onClose: function onClose() {
	          _this25.copilotNotify = null;
	        },
	        callId: callId
	      });
	    }
	  }, {
	    key: "calculateUnusedPanelSpace",
	    value: function calculateUnusedPanelSpace(buttonList) {
	      if (!buttonList) {
	        buttonList = this.getButtonList();
	      }
	      var totalButtonWidth = 0;
	      for (var i = 0; i < buttonList.length; i++) {
	        var button = this.buttons[buttonList[i]];
	        if (!button) {
	          continue;
	        }
	        var buttonWidth = button.elements.root ? button.elements.root.getBoundingClientRect().width : 0;
	        totalButtonWidth += buttonWidth;
	      }
	      return this.elements.panel.scrollWidth - totalButtonWidth - 32;
	    }
	  }, {
	    key: "setButtonActive",
	    value: function setButtonActive(buttonName, isActive) {
	      if (!this.buttons[buttonName]) {
	        return;
	      }
	      this.buttons[buttonName].setActive(isActive);
	    }
	  }, {
	    key: "getButtonActive",
	    value: function getButtonActive(buttonName) {
	      if (!this.buttons[buttonName]) {
	        return false;
	      }
	      return this.buttons[buttonName].isActive;
	    }
	  }, {
	    key: "setButtonCounter",
	    value: function setButtonCounter(buttonName, counter) {
	      if (!this.buttons[buttonName]) {
	        return;
	      }
	      this.buttons[buttonName].setCounter(counter);
	    }
	  }, {
	    key: "updateUserList",
	    value: function updateUserList(useShelvedRerenderQueue) {
	      var _this26 = this;
	      if (this.layout == Layouts.Mobile) {
	        if (this.localUser != this.centralUser) {
	          if (this.localUser.hasVideo()) {
	            this.localUser.mount(this.elements.localUserMobile);
	            this.localUser.visible = true;
	          } else {
	            this.localUser.dismount();
	          }
	          this.centralUser.mount(this.elements.center);
	          this.eventEmitter.emit(EventName.onHasMainStream, {
	            userId: this.centralUser.id
	          });
	          this.centralUser.visible = true;
	        }
	        return;
	      }
	      /* if (this.layout == Layouts.Grid && this.size == Size.Full)
	      {
	      	this.recalculatePages();
	      } */

	      if ((this.layout == Layouts.Grid || this.layout == Layouts.Centered) && this.size == Size.Full) {
	        this.recalculatePages();
	      }
	      if (useShelvedRerenderQueue) {
	        this.shelvedRerenderQueue.forEach(function (el) {
	          if (el.reason === RerenderReason.VideoEnabled) {
	            _this26.updateRerenderQueue(el.userId, el.reason);
	          } else if (el.reason === RerenderReason.VideoDisabled) {
	            _this26.updateRerenderQueue(el.userId, el.reason);
	          }
	        });
	        this.shelvedRerenderQueue.clear();
	      }
	      this.renderUserList();
	      if (this.layout == Layouts.Centered) {
	        if (!this.elements.userList.container.parentElement) {
	          this.elements.userBlock.appendChild(this.elements.userList.container);
	        }
	        //this.centralUser.setFullSize(this.elements.userList.container.childElementCount === 0);
	      } else if (this.layout == Layouts.Grid) {
	        if (!this.elements.userList.container.parentElement) {
	          this.elements.container.appendChild(this.elements.userList.container);
	        }
	      }
	      this.toggleEars();
	    }
	  }, {
	    key: "showOverflownButtonsPopup",
	    value: function showOverflownButtonsPopup() {
	      var _this27 = this;
	      if (this.overflownButtonsPopup) {
	        this.overflownButtonsPopup.show();
	        return;
	      }
	      var bindElement = this.buttons.more && this.buttons.more.elements.root ? this.buttons.more.elements.root : this.elements.panel;
	      this.overflownButtonsPopup = new main_popup.Popup({
	        id: 'bx-call-buttons-popup',
	        bindElement: bindElement,
	        targetContainer: this.container,
	        content: this.renderButtons(Object.keys(this.overflownButtons)),
	        cacheable: false,
	        closeIcon: false,
	        autoHide: true,
	        overlay: {
	          backgroundColor: 'white',
	          opacity: 0
	        },
	        bindOptions: {
	          position: 'top'
	        },
	        angle: {
	          position: 'bottom',
	          offset: 49
	        },
	        className: 'bx-call-buttons-popup',
	        contentBackground: 'unset',
	        events: {
	          onPopupDestroy: function onPopupDestroy() {
	            _this27.overflownButtonsPopup = null;
	            _this27.buttons.more.setActive(false);
	          }
	        }
	      });
	      this.overflownButtonsPopup.show();
	    }
	  }, {
	    key: "resumeVideo",
	    value: function resumeVideo() {
	      for (var userId in this.users) {
	        var user = this.users[userId];
	        user.playVideo();
	        var screenUser = this.screenUsers[userId];
	        screenUser.playVideo();
	      }
	      this.localUser.playVideo();
	    }
	  }, {
	    key: "updateUserButtons",
	    value: function updateUserButtons() {
	      for (var userId in this.users) {
	        if (this.users.hasOwnProperty(userId)) {
	          this.users[userId].allowPinButton = this.getConnectedUserCount() > 1;
	        }
	      }
	    }
	  }, {
	    key: "updateButtons",
	    value: function updateButtons() {
	      var skippedElementsList = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
	      if (!this.elements.panel) {
	        return;
	      }
	      if (!skippedElementsList.includes('panel')) {
	        main_core.Dom.clean(this.elements.panel);
	        this.elements.panel.appendChild(this.renderButtons(this.getButtonList()));
	      }
	      main_core.Dom.clean(this.elements.topPanel);
	      if (this.elements.topPanel) {
	        this.elements.topPanel.appendChild(this.renderTopButtons(this.getTopButtonList()));
	      }
	      if (this.buttons.participantsMobile) {
	        this.buttons.participantsMobile.setCount(this.getConnectedUserCount(true));
	      }
	      this.renderAddUserButtonInList();
	    }
	  }, {
	    key: "updateUserData",
	    value: function updateUserData(userData) {
	      for (var userId in userData) {
	        if (!this.userData[userId]) {
	          this.userData[userId] = {
	            name: '',
	            avatar_hr: '',
	            gender: 'M'
	          };
	        }
	        if (userData[userId].name) {
	          this.userData[userId].name = userData[userId].name;
	        }
	        if (userData[userId].avatar_hr) {
	          this.userData[userId].avatar_hr = Util.isAvatarBlank(userData[userId].avatar_hr) ? '' : userData[userId].avatar_hr;
	        } else if (userData[userId].avatar) {
	          this.userData[userId].avatar_hr = Util.isAvatarBlank(userData[userId].avatar) ? '' : userData[userId].avatar;
	        }
	        if (userData[userId].gender) {
	          this.userData[userId].gender = userData[userId].gender === 'F' ? 'F' : 'M';
	        }
	        var userModel = this.userRegistry.get(userId);
	        if (userModel) {
	          userModel.name = this.userData[userId].name;
	          userModel.avatar = this.userData[userId].avatar_hr;
	        }
	      }
	    }
	  }, {
	    key: "isScreenSharingSupported",
	    value: function isScreenSharingSupported() {
	      return navigator.mediaDevices && typeof navigator.mediaDevices.getDisplayMedia === "function" || typeof BXDesktopSystem !== "undefined";
	    }
	  }, {
	    key: "isRecordingHotKeySupported",
	    value: function isRecordingHotKeySupported() {
	      return typeof BXDesktopSystem !== "undefined" && BXDesktopSystem.ApiVersion() >= 60;
	    }
	  }, {
	    key: "isFullScreenSupported",
	    value: function isFullScreenSupported() {
	      if (BX.browser.IsChrome() || BX.browser.IsSafari()) {
	        return document.webkitFullscreenEnabled === true;
	      } else if (BX.browser.IsFirefox()) {
	        return document.fullscreenEnabled === true;
	      } else {
	        return false;
	      }
	    }
	  }, {
	    key: "toggleEars",
	    value: function toggleEars() {
	      this.toggleTopEar();
	      this.toggleBottomEar();
	      if (this.layout == Layouts.Grid && this.pagesCount > 1 && this.currentPage > 1) {
	        this.elements.pageNavigatorLeft.classList.add("active");
	      } else {
	        this.elements.pageNavigatorLeft.classList.remove("active");
	      }
	      if (this.layout == Layouts.Grid && this.pagesCount > 1 && this.currentPage < this.pagesCount) {
	        this.elements.pageNavigatorRight.classList.add("active");
	      } else {
	        this.elements.pageNavigatorRight.classList.remove("active");
	      }
	    }
	  }, {
	    key: "toggleTopEar",
	    value: function toggleTopEar() {
	      if (this.layout !== Layouts.Grid && this.pagesCount > 1) {
	        this.elements.ear.top.classList.add("active");
	      } else {
	        this.elements.ear.top.classList.remove("active");
	      }
	    }
	  }, {
	    key: "toggleBottomEar",
	    value: function toggleBottomEar() {
	      if (this.layout !== Layouts.Grid && this.pagesCount > 1) {
	        this.elements.ear.bottom.classList.add("active");
	      } else {
	        this.elements.ear.bottom.classList.remove("active");
	      }
	    }
	  }, {
	    key: "scrollUserListUp",
	    value: function scrollUserListUp() {
	      var _this28 = this;
	      this.stopScroll();
	      this.scrollInterval = setInterval(function () {
	        return _this28.elements.userList.container.scrollTop -= 10;
	      }, 20);
	    }
	  }, {
	    key: "scrollUserListDown",
	    value: function scrollUserListDown() {
	      var _this29 = this;
	      this.stopScroll();
	      this.scrollInterval = setInterval(function () {
	        return _this29.elements.userList.container.scrollTop += 10;
	      }, 20);
	    }
	  }, {
	    key: "stopScroll",
	    value: function stopScroll() {
	      if (this.scrollInterval) {
	        clearInterval(this.scrollInterval);
	        this.scrollInterval = 0;
	      }
	    }
	  }, {
	    key: "toggleRenameSliderInputLoader",
	    value: function toggleRenameSliderInputLoader() {
	      this.elements.renameSlider.button.classList.add('ui-btn-wait');
	    }
	  }, {
	    key: "setHotKeyTemporaryBlock",
	    value: function setHotKeyTemporaryBlock(isActive, force) {
	      if (!!isActive) {
	        this.hotKeyTemporaryBlock++;
	      } else {
	        this.hotKeyTemporaryBlock--;
	        if (this.hotKeyTemporaryBlock < 0 || force) {
	          this.hotKeyTemporaryBlock = 0;
	        }
	      }
	    }
	  }, {
	    key: "setHotKeyActive",
	    value: function setHotKeyActive(name, isActive) {
	      if (typeof this.hotKey[name] === 'undefined') {
	        return;
	      }
	      this.hotKey[name] = !!isActive;
	    }
	  }, {
	    key: "isHotKeyActive",
	    value: function isHotKeyActive(name) {
	      if (!this.hotKey['all']) {
	        return false;
	      }
	      if (this.hotKeyTemporaryBlock > 0) {
	        return false;
	      }
	      if (this.isButtonHidden(name)) {
	        return false;
	      }
	      if (this.isButtonBlocked(name)) {
	        return false;
	      }
	      return !!this.hotKey[name];
	    } // event handlers
	  }, {
	    key: "_onBodyClick",
	    value: function _onBodyClick() {
	      this.eventEmitter.emit(EventName.onBodyClick);
	    }
	  }, {
	    key: "_onCenterTouchStart",
	    value: function _onCenterTouchStart(e) {
	      this.centerTouchX = e.pageX;
	    }
	  }, {
	    key: "_onCenterTouchEnd",
	    value: function _onCenterTouchEnd(e) {
	      var delta = e.pageX - this.centerTouchX;
	      if (delta > 100) {
	        this.pinUser(this.getRightUser(this.centralUser.id));
	        e.preventDefault();
	      }
	      if (delta < -100) {
	        this.pinUser(this.getLeftUser(this.centralUser.id));
	        e.preventDefault();
	      }
	    }
	  }, {
	    key: "_onFullScreenChange",
	    value: function _onFullScreenChange() {
	      if ("webkitFullscreenElement" in document) {
	        this.isFullScreen = !!document.webkitFullscreenElement;
	      } else if ("fullscreenElement" in document) {
	        this.isFullScreen = !!document.fullscreenElement;
	      } else {
	        return;
	      }

	      // safari workaround
	      setTimeout(function () {
	        if (!this.elements.root) {
	          return;
	        }
	        if (this.isFullScreen) {
	          this.elements.root.classList.add("bx-messenger-videocall-fullscreen");
	        } else {
	          this.elements.root.classList.remove("bx-messenger-videocall-fullscreen");
	        }
	        this.updateUserList();
	        this.updateButtons();
	        this.setUserBlockFolded(this.isFullScreen);
	      }.bind(this), 0);
	    }
	  }, {
	    key: "_onIntersectionChange",
	    value: function _onIntersectionChange(entries) {
	      var t = {};
	      entries.forEach(function (intersectionEntry) {
	        t[intersectionEntry.target.dataset.userId] = intersectionEntry.isIntersecting;
	      });
	      for (var userId in t) {
	        if (this.users[userId]) {
	          this.users[userId].visible = t[userId];
	        }
	        if (userId == this.localUser.id) {
	          this.localUser.visible = t[userId];
	        }
	      }
	    }
	  }, {
	    key: "_onResize",
	    value: function _onResize() {
	      // this.resizeCalled++;
	      // this.reportResizeCalled();

	      if (!this.elements.root) {
	        return;
	      }
	      if (this.centralUser) ;
	      if (BX.browser.IsMobile()) {
	        document.documentElement.style.setProperty('--view-height', window.innerHeight + 'px');
	      }
	      if (this.layout == Layouts.Grid || this.layout == Layouts.Centered) {
	        this.updateUserList();
	      } else {
	        this.updateCentralUserAvatarSize();
	        this.toggleEars();
	      }
	      var rootDimensions = this.elements.root.getBoundingClientRect();
	      this.elements.root.classList.toggle("bx-messenger-videocall-width-lt-450", rootDimensions.width < 450);
	      this.elements.root.classList.toggle("bx-messenger-videocall-width-lt-550", rootDimensions.width < 550);
	      this.elements.root.classList.toggle("bx-messenger-videocall-width-lt-650", rootDimensions.width < 650);
	      this.elements.root.classList.toggle("bx-messenger-videocall-width-lt-700", rootDimensions.width < 700);
	      this.elements.root.classList.toggle("bx-messenger-videocall-width-lt-850", rootDimensions.width < 850);
	      this.elements.root.classList.toggle("bx-messenger-videocall-width-lt-900", rootDimensions.width < 900);

	      /*if (this.maxWidth === 0)
	      {
	      	this.elements.root.style.maxWidth = this.container.clientWidth + 'px';
	      }*/

	      if (this.checkPanelOverflow()) {
	        this.updateButtons();
	        if (this.overflownButtonsPopup && !Object.keys(this.overflownButtons).length) {
	          this.overflownButtonsPopup.close();
	        }
	      }
	    }
	  }, {
	    key: "_onOrientationChange",
	    value: function _onOrientationChange() {
	      if (!this.elements.root) {
	        return;
	      }
	      if (window.innerHeight > window.innerWidth) {
	        this.elements.root.classList.remove("orientation-landscape");
	      } else {
	        this.elements.root.classList.add("orientation-landscape");
	      }
	    }
	  }, {
	    key: "_showHotKeyHint",
	    value: function _showHotKeyHint(targetNode, name, text, options) {
	      var existingHint = BX.PopupWindowManager.getPopupById('ui-hint-popup');
	      if (existingHint) {
	        existingHint.destroy();
	      }
	      if (!this.isHotKeyActive(name)) {
	        return;
	      }
	      options = options || {};
	      this.hintManager.popupParameters.events = {
	        onShow: function onShow(event) {
	          var _options;
	          var popup = event.getTarget();
	          var offsetLeft = targetNode.offsetWidth / 2 - popup.getPopupContainer().offsetWidth / 2 + 23;
	          if ((_options = options) !== null && _options !== void 0 && _options.additionalOffsetLeft) {
	            offsetLeft += options.additionalOffsetLeft;
	          }
	          // hack to get hint sizes
	          popup.getPopupContainer().style.display = 'block';
	          if (options.position === 'bottom') {
	            popup.setOffset({
	              offsetTop: 10,
	              offsetLeft: offsetLeft
	            });
	          } else {
	            popup.setOffset({
	              offsetLeft: offsetLeft
	            });
	          }
	        }
	      };
	      this.hintManager.show(targetNode, text);
	    }
	  }, {
	    key: "_destroyHotKeyHint",
	    value: function _destroyHotKeyHint() {
	      if (!Util.isDesktop()) {
	        return;
	      }
	      if (!this.hintManager.popup) {
	        return;
	      }

	      // we need to destroy, not .hide for onShow event handler (see method _showHotKeyHint).
	      this.hintManager.popup.destroy();
	      this.hintManager.popup = null;
	    }
	  }, {
	    key: "_showMicrophoneHint",
	    value: function _showMicrophoneHint(e) {
	      this.hintManager.hide();
	      if (!this.isHotKeyActive("microphone")) {
	        return;
	      }
	      var micHotkeys = '';
	      var additionalOffsetLeft = 0;
	      if (Hardware.isMicrophoneMuted && this.isHotKeyActive("microphoneSpace")) {
	        micHotkeys = BX.message("IM_SPACE_HOTKEY") + '<br>';
	        additionalOffsetLeft = 20;
	      }
	      micHotkeys += this.keyModifier + ' + A';
	      this._showHotKeyHint(e.currentTarget.firstChild, "microphone", micHotkeys, {
	        additionalOffsetLeft: additionalOffsetLeft
	      });
	    }
	  }, {
	    key: "_onKeyDown",
	    value: function _onKeyDown(e) {
	      if (!Util.isDesktop()) {
	        return;
	      }
	      if (!(e.shiftKey && (e.ctrlKey || e.metaKey)) && !(e.code === 'Space')) {
	        return;
	      }
	      if (event.repeat) {
	        return;
	      }
	      var callMinimized = this.size === View.Size.Folded;
	      if (e.code === 'KeyA' && this.isHotKeyActive('microphone')) {
	        e.preventDefault();
	        if (this.deviceSelector) {
	          this.deviceSelector.destroy();
	        }
	        this._onMicrophoneButtonClick(e);
	      } else if (e.code === 'Space' && Hardware.isMicrophoneMuted && this.isHotKeyActive('microphoneSpace')) {
	        if (!callMinimized) {
	          e.preventDefault();
	          this.pushToTalk = true;
	          this.microphoneHotkeyTimerId = setTimeout(function () {
	            if (this.deviceSelector) {
	              this.deviceSelector.destroy();
	            }
	            this._onMicrophoneButtonClick(e);
	          }.bind(this), 100);
	        }
	      } else if (e.code === 'KeyS' && this.isHotKeyActive('screen')) {
	        e.preventDefault();
	        this._onScreenButtonClick(e);
	      } else if (e.code === 'KeyV' && this.isHotKeyActive('camera')) {
	        e.preventDefault();
	        if (this.deviceSelector) {
	          this.deviceSelector.destroy();
	        }
	        this._onCameraButtonClick(e);
	      } else if (e.code === 'KeyU' && this.isHotKeyActive('users')) {
	        e.preventDefault();
	        this._onUsersButtonClick(e);
	      } else if (e.code === 'KeyR' && this.isRecordingHotKeySupported() && this.isHotKeyActive('record')) {
	        e.preventDefault();
	        this._onForceRecordToggleClick(e);
	      } else if (e.code === 'KeyH' && this.isHotKeyActive('floorRequest')) {
	        e.preventDefault();
	        this._onFloorRequestButtonClick(e);
	      } else if (e.code === 'KeyC' && this.isHotKeyActive('chat')) {
	        e.preventDefault();
	        if (callMinimized) {
	          this._onBodyClick(e);
	        } else {
	          this._onChatButtonClick(e);
	          this._destroyHotKeyHint();
	        }
	      } else if (e.code === 'KeyM' && this.isHotKeyActive('muteSpeaker')) {
	        e.preventDefault();
	        this.eventEmitter.emit(EventName.onButtonClick, {
	          buttonName: "toggleSpeaker",
	          speakerMuted: this.speakerMuted,
	          fromHotKey: true
	        });
	      } else if (e.code === 'KeyW' && this.isHotKeyActive('grid')) {
	        e.preventDefault();
	        this.setLayout(this.layout == Layouts.Centered ? Layouts.Grid : Layouts.Centered);
	      }
	    }
	  }, {
	    key: "_onKeyUp",
	    value: function _onKeyUp(e) {
	      if (!Util.isDesktop()) {
	        return;
	      }
	      clearTimeout(this.microphoneHotkeyTimerId);
	      if (this.pushToTalk && !Hardware.isMicrophoneMuted && e.code === 'Space') {
	        e.preventDefault();
	        this.pushToTalk = false;
	        if (this.deviceSelector) {
	          this.deviceSelector.destroy();
	        }
	        this._onMicrophoneButtonClick(e);
	      }
	    }
	  }, {
	    key: "_onUserClick",
	    value: function _onUserClick(e) {
	      var userId = e.userId;
	      if (userId == this.centralUser.id && this.layout != Layouts.Grid) {
	        this.elements.root.classList.toggle("bx-messenger-videocall-hidden-panels");
	      }
	      if (this.layout == Layouts.Centered && userId != this.centralUser.id) {
	        this.pinUser(userId);
	      } else {
	        this.pinnedUser && this.pinnedUser.id === userId ? this._onUserUnPin() : this._onUserPin({
	          userId: userId
	        });
	      }
	      this.eventEmitter.emit(EventName.onUserClick, {
	        userId: userId,
	        stream: userId == this.userId ? this.localUser.stream : this.users[userId].stream,
	        layout: this.layout
	      });
	    }
	  }, {
	    key: "_onUserRename",
	    value: function _onUserRename(newName) {
	      this.eventEmitter.emit(EventName.onUserRename, {
	        newName: newName
	      });
	    }
	  }, {
	    key: "_onUserRenameInputFocus",
	    value: function _onUserRenameInputFocus() {
	      this.setHotKeyTemporaryBlock(true);
	    }
	  }, {
	    key: "_onUserRenameInputBlur",
	    value: function _onUserRenameInputBlur() {
	      this.setHotKeyTemporaryBlock(false);
	    }
	  }, {
	    key: "_onUserPin",
	    value: function _onUserPin(e) {
	      if (this.layout == Layouts.Grid) {
	        this.setLayout(Layouts.Centered);
	      }
	      this.pinUser(e.userId);
	    }
	  }, {
	    key: "_onUserUnPin",
	    value: function _onUserUnPin() {
	      if (this.layout == Layouts.Centered) {
	        this.setLayout(Layouts.Grid);
	      }
	      this.unpinUser();
	    }
	  }, {
	    key: "_onRecordToggleClick",
	    value: function _onRecordToggleClick(e) {
	      var _this30 = this;
	      var limitObj = this.getRecordLimitation();
	      this.onClickButtonWithLimit(limitObj, function () {
	        if (_this30.recordState.state === View.RecordState.Stopped) {
	          _this30._onRecordStartClick(e);
	        } else {
	          _this30._onRecordStopClick(e);
	        }
	      });
	    }
	  }, {
	    key: "_onForceRecordToggleClick",
	    value: function _onForceRecordToggleClick(e) {
	      var _this31 = this;
	      var limitObj = this.getRecordLimitation();
	      this.onClickButtonWithLimit(limitObj, function () {
	        if (_this31.recordState.state === View.RecordState.Stopped) {
	          _this31._onForceRecordStartClick(View.RecordType.Video);
	        } else {
	          _this31._onRecordStopClick(e);
	        }
	      });
	    }
	  }, {
	    key: "_onForceRecordStartClick",
	    value: function _onForceRecordStartClick(recordType) {
	      if (typeof recordType === 'undefined') {
	        recordType = View.RecordType.None;
	      }
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: "record",
	        recordState: View.RecordState.Started,
	        forceRecord: recordType,
	        // none, video, audio
	        node: null
	      });
	    }
	  }, {
	    key: "_onRecordStartClick",
	    value: function _onRecordStartClick(e) {
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: "record",
	        recordState: View.RecordState.Started,
	        node: e.currentTarget
	      });
	    }
	  }, {
	    key: "_onRecordPauseClick",
	    value: function _onRecordPauseClick(e) {
	      var recordState;
	      if (this.recordState.state === View.RecordState.Paused) {
	        this.recordState.state = View.RecordState.Started;
	        recordState = View.RecordState.Resumed;
	      } else {
	        this.recordState.state = View.RecordState.Paused;
	        recordState = this.recordState.state;
	      }
	      this.buttons.recordStatus.update(this.recordState);
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: "record",
	        recordState: recordState,
	        node: e.currentTarget
	      });
	    }
	  }, {
	    key: "_onRecordStopClick",
	    value: function _onRecordStopClick(e) {
	      this.recordState.state = View.RecordState.Stopped;
	      this.buttons.recordStatus.update(this.recordState);
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: "record",
	        recordState: this.recordState.state,
	        node: e.currentTarget
	      });
	    }
	  }, {
	    key: "_onRecordMouseOver",
	    value: function _onRecordMouseOver(e) {
	      if (this.recordState.userId == this.userId || !this.userData[this.recordState.userId]) {
	        return;
	      }
	      var recordingUserName = main_core.Text.encode(this.userData[this.recordState.userId].name);
	      this.hintManager.show(e.currentTarget, BX.message("IM_M_CALL_RECORD_HINT").replace("#USER_NAME#", recordingUserName));
	    }
	  }, {
	    key: "_onRecordMouseOut",
	    value: function _onRecordMouseOut() {
	      this.hintManager.hide();
	    }
	  }, {
	    key: "_onDocumentButtonClick",
	    value: function _onDocumentButtonClick(e) {
	      e.stopPropagation();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: 'document',
	        node: e.target
	      });
	    }
	  }, {
	    key: "_onCopilotButtonClick",
	    value: function _onCopilotButtonClick(e) {
	      e.stopPropagation();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: 'copilot',
	        node: e.target
	      });
	    }
	  }, {
	    key: "_onGridButtonClick",
	    value: function _onGridButtonClick() {
	      this.setLayout(this.layout == Layouts.Centered ? Layouts.Grid : Layouts.Centered);
	      if (this.layout == Layouts.Centered && this.localUser.id !== this.centralUser.id) {
	        this.eventEmitter.emit(EventName.onHasMainStream, {
	          userId: this.centralUser.id
	        });
	      }
	    }
	  }, {
	    key: "_onAddButtonClick",
	    value: function _onAddButtonClick(e) {
	      e.stopPropagation();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: "inviteUser",
	        node: e.currentTarget
	      });
	    }
	  }, {
	    key: "_onShareButtonClick",
	    value: function _onShareButtonClick(e) {
	      e.stopPropagation();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: "share",
	        node: e.currentTarget
	      });
	    }
	  }, {
	    key: "_onMicrophoneButtonClick",
	    value: function _onMicrophoneButtonClick(e) {
	      if ("stopPropagation" in e) {
	        e.stopPropagation();
	      }
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: "toggleMute",
	        muted: !Hardware.isMicrophoneMuted
	      });
	    }
	  }, {
	    key: "_onMicrophoneArrowClick",
	    value: function _onMicrophoneArrowClick(e) {
	      e.stopPropagation();
	      this.showDeviceSelector(e.currentTarget);
	    }
	  }, {
	    key: "_onMicrophoneSideIconClick",
	    value: function _onMicrophoneSideIconClick(e) {
	      e.stopPropagation();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: "microphoneSideIcon"
	      });
	    }
	  }, {
	    key: "_onMicrophoneSelected",
	    value: function _onMicrophoneSelected(e) {
	      this.eventEmitter.emit(EventName.onReplaceMicrophone, {
	        deviceId: e.data.deviceId
	      });
	    }
	  }, {
	    key: "_onCameraButtonClick",
	    value: function _onCameraButtonClick(e) {
	      if ("stopPropagation" in e) {
	        e.stopPropagation();
	      }
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: "toggleVideo",
	        video: !Hardware.isCameraOn
	      });
	    }
	  }, {
	    key: "_onCameraArrowClick",
	    value: function _onCameraArrowClick(e) {
	      e.stopPropagation();
	      this.showDeviceSelector(e.currentTarget);
	    }
	  }, {
	    key: "_onCameraSelected",
	    value: function _onCameraSelected(e) {
	      this.eventEmitter.emit(EventName.onReplaceCamera, {
	        deviceId: e.data.deviceId
	      });
	    }
	  }, {
	    key: "_onSpeakerButtonClick",
	    value: function _onSpeakerButtonClick() {
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: "toggleSpeaker",
	        speakerMuted: this.speakerMuted
	      });
	    }
	  }, {
	    key: "_onChangeHdVideo",
	    value: function _onChangeHdVideo(e) {
	      this.eventEmitter.emit(EventName.onChangeHdVideo, e.data);
	    }
	  }, {
	    key: "_onChangeMicAutoParams",
	    value: function _onChangeMicAutoParams(e) {
	      this.eventEmitter.emit(EventName.onChangeMicAutoParams, e.data);
	    }
	  }, {
	    key: "_onChangeFaceImprove",
	    value: function _onChangeFaceImprove(e) {
	      this.eventEmitter.emit(EventName.onChangeFaceImprove, e.data);
	    }
	  }, {
	    key: "disableFaceImprove",
	    value: function disableFaceImprove() {
	      if (Util.isDesktop() && im_v2_lib_desktopApi.DesktopApi.isDesktop() && im_v2_lib_desktopApi.DesktopApi.getCameraSmoothingStatus()) {
	        this.eventEmitter.emit(EventName.onChangeFaceImprove, {
	          faceImproveEnabled: false
	        });
	      }
	    }
	  }, {
	    key: "_onSpeakerSelected",
	    value: function _onSpeakerSelected(e) {
	      this.setSpeakerId(e.data.deviceId);
	      this.eventEmitter.emit(EventName.onReplaceSpeaker, {
	        deviceId: e.data.deviceId
	      });
	    }
	  }, {
	    key: "_onScreenButtonClick",
	    value: function _onScreenButtonClick(e) {
	      var _this32 = this;
	      e.stopPropagation();
	      var limitObj = this.getScreenSharingLimitation();
	      this.onClickButtonWithLimit(limitObj, function () {
	        _this32.eventEmitter.emit(EventName.onButtonClick, {
	          buttonName: 'toggleScreenSharing',
	          node: e.target
	        });
	      });
	    }
	  }, {
	    key: "_onChatButtonClick",
	    value: function _onChatButtonClick(e) {
	      this.hintManager.hide();
	      e.stopPropagation();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: 'showChat',
	        node: e.target
	      });
	    }
	  }, {
	    key: "_onUsersButtonClick",
	    value: function _onUsersButtonClick(e) {
	      this.hintManager.hide();
	      e.stopPropagation();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: 'toggleUsers',
	        node: e.target
	      });
	    }
	  }, {
	    key: "_onMobileMenuButtonClick",
	    value: function _onMobileMenuButtonClick(e) {
	      e.stopPropagation();
	      this.showCallMenu();
	    }
	  }, {
	    key: "_onFloorRequestButtonClick",
	    value: function _onFloorRequestButtonClick(e) {
	      e.stopPropagation();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: 'floorRequest',
	        node: e.target
	      });
	    }
	  }, {
	    key: "_onMoreButtonClick",
	    value: function _onMoreButtonClick(e) {
	      e.stopPropagation();
	      if (this.overflownButtonsPopup) {
	        this.overflownButtonsPopup.close();
	        this.buttons.more.setActive(false);
	      } else {
	        this.showOverflownButtonsPopup();
	        this.buttons.more.setActive(true);
	      }
	    }
	  }, {
	    key: "_onHistoryButtonClick",
	    value: function _onHistoryButtonClick(e) {
	      e.stopPropagation();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: 'showHistory',
	        node: e.target
	      });
	    }
	  }, {
	    key: "_onHangupButtonClick",
	    value: function _onHangupButtonClick(e) {
	      e.stopPropagation();
	      this.clearNewLogicRules();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: 'hangup',
	        node: e.target
	      });
	    }
	  }, {
	    key: "_onHangupOptionsButtonClick",
	    value: function _onHangupOptionsButtonClick(e) {
	      e.stopPropagation();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: 'hangupOptions',
	        node: e.target
	      });
	    }
	  }, {
	    key: "_onCloseButtonClick",
	    value: function _onCloseButtonClick(e) {
	      e.stopPropagation();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: 'close',
	        node: e.target
	      });
	    }
	  }, {
	    key: "_onFullScreenButtonClick",
	    value: function _onFullScreenButtonClick(e) {
	      e.stopPropagation();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: 'fullscreen',
	        node: e.target
	      });
	    }
	  }, {
	    key: "_onFeedbackButtonClick",
	    value: function _onFeedbackButtonClick(e) {
	      e.stopPropagation();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: 'feedback',
	        node: e.target
	      });
	    }
	  }, {
	    key: "_onParticipantsButtonListClick",
	    value: function _onParticipantsButtonListClick(event) {
	      if (!this.isButtonBlocked('users')) {
	        this._onUsersButtonClick(event);
	        return;
	      }
	      if (!this.isFullScreen) {
	        return;
	      }
	      this.setUserBlockFolded(!this.isUserBlockFolded);
	    }
	  }, {
	    key: "_onParticipantsListButtonClick",
	    value: function _onParticipantsListButtonClick(e) {
	      var _this33 = this;
	      e.stopPropagation();
	      var viewEvent = new main_core_events.BaseEvent({
	        data: {
	          buttonName: 'participantsList',
	          node: e.target
	        },
	        compatData: ['participantsList', e.target]
	      });
	      this.eventEmitter.emit(EventName.onButtonClick, viewEvent);
	      if (viewEvent.isDefaultPrevented()) {
	        return;
	      }
	      UserSelector.create({
	        parentElement: e.currentTarget,
	        zIndex: this.baseZIndex + 500,
	        userList: Object.values(this.users),
	        current: this.centralUser.id,
	        onSelect: function onSelect(userId) {
	          return _this33.setCentralUser(userId);
	        }
	      }).show();
	    }
	  }, {
	    key: "_onParticipantsButtonMobileListClick",
	    value: function _onParticipantsButtonMobileListClick() {
	      this.showParticipantsMenu();
	    }
	  }, {
	    key: "_onMobileCallMenuFloorRequestClick",
	    value: function _onMobileCallMenuFloorRequestClick() {
	      this.callMenu.close();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: 'floorRequest'
	      });
	    }
	  }, {
	    key: "_onMobileCallMenShowParticipantsClick",
	    value: function _onMobileCallMenShowParticipantsClick() {
	      this.callMenu.close();
	      this.showParticipantsMenu();
	    }
	  }, {
	    key: "_onMobileCallMenuCopyInviteClick",
	    value: function _onMobileCallMenuCopyInviteClick() {
	      this.callMenu.close();
	      this.eventEmitter.emit(EventName.onButtonClick, {
	        buttonName: "share",
	        node: null
	      });
	    }
	  }, {
	    key: "showRenameSlider",
	    value: function showRenameSlider() {
	      var _this34 = this;
	      if (!this.renameSlider) {
	        this.renameSlider = new MobileSlider({
	          parent: this.elements.root,
	          content: this.renderRenameSlider(),
	          onClose: function onClose() {
	            return _this34.renameSlider.destroy();
	          },
	          onDestroy: function onDestroy() {
	            return _this34.renameSlider = null;
	          }
	        });
	      }
	      this.renameSlider.show();
	      setTimeout(function () {
	        _this34.elements.renameSlider.input.focus();
	        _this34.elements.renameSlider.input.select();
	      }, 400);
	    }
	  }, {
	    key: "renderRenameSlider",
	    value: function renderRenameSlider() {
	      return main_core.Dom.create("div", {
	        props: {
	          className: "bx-videocall-mobile-rename-slider-wrap"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-videocall-mobile-rename-slider-title"
	          },
	          text: BX.message("IM_M_CALL_MOBILE_MENU_CHANGE_MY_NAME")
	        }), this.elements.renameSlider.input = main_core.Dom.create("input", {
	          props: {
	            className: "bx-videocall-mobile-rename-slider-input"
	          },
	          attrs: {
	            type: "text",
	            value: this.localUser.userModel.name
	          }
	        }), this.elements.renameSlider.button = main_core.Dom.create("button", {
	          props: {
	            className: "bx-videocall-mobile-rename-slider-button ui-btn ui-btn-md ui-btn-primary"
	          },
	          text: BX.message("IM_M_CALL_MOBILE_RENAME_CONFIRM"),
	          events: {
	            click: this._onMobileUserRename.bind(this)
	          }
	        })]
	      });
	    }
	  }, {
	    key: "_onMobileUserRename",
	    value: function _onMobileUserRename(event) {
	      event.stopPropagation();
	      var inputValue = this.elements.renameSlider.input.value;
	      var newName = inputValue.trim();
	      var needToUpdate = true;
	      if (newName === this.localUser.userModel.name || newName === '') {
	        needToUpdate = false;
	      }
	      if (needToUpdate) {
	        this.toggleRenameSliderInputLoader();
	        this._onUserRename(newName);
	      } else {
	        this.renameSlider.close();
	      }
	    }
	  }, {
	    key: "_onMobileCallMenuCancelClick",
	    value: function _onMobileCallMenuCancelClick() {
	      this.callMenu.close();
	    }
	  }, {
	    key: "_onLeftEarClick",
	    value: function _onLeftEarClick() {
	      this.pinUser(this.getLeftUser(this.centralUser.id));
	    }
	  }, {
	    key: "_onRightEarClick",
	    value: function _onRightEarClick() {
	      this.pinUser(this.getRightUser(this.centralUser.id));
	    }
	  }, {
	    key: "_onLeftPageNavigatorClick",
	    value: function _onLeftPageNavigatorClick(e) {
	      e.stopPropagation();
	      this.setCurrentPage(this.currentPage - 1);
	    }
	  }, {
	    key: "_onRightPageNavigatorClick",
	    value: function _onRightPageNavigatorClick(e) {
	      e.stopPropagation();
	      this.setCurrentPage(this.currentPage + 1);
	    }
	  }, {
	    key: "_onTopPageNavigatorClick",
	    value: function _onTopPageNavigatorClick(e) {
	      e.stopPropagation();
	      this.setCurrentPage(this.currentPage !== 1 ? this.currentPage - 1 : this.pagesCount);
	    }
	  }, {
	    key: "_onBottomPageNavigatorClick",
	    value: function _onBottomPageNavigatorClick(e) {
	      e.stopPropagation();
	      this.setCurrentPage(this.currentPage !== this.pagesCount ? this.currentPage + 1 : 1);
	    }
	  }, {
	    key: "setMaxWidth",
	    value: function setMaxWidth(maxWidth) {
	      if (this.maxWidth !== maxWidth) {
	        var MAX_WIDTH_SPEAKER_MODE = 650;
	        if (maxWidth < MAX_WIDTH_SPEAKER_MODE && (!this.maxWidth || this.maxWidth > MAX_WIDTH_SPEAKER_MODE) && this.layout === Layouts.Centered) {
	          this.setLayout(Layouts.Grid);
	        }
	        var animateUnsetProperty = this.maxWidth === null;
	        this.maxWidth = maxWidth;
	        if (this.size !== View.Size.Folded) {
	          this._applyMaxWidth(animateUnsetProperty);
	        }
	      }
	    }
	  }, {
	    key: "removeMaxWidth",
	    value: function removeMaxWidth() {
	      this.setMaxWidth(null);
	    }
	  }, {
	    key: "_applyMaxWidth",
	    value: function _applyMaxWidth(animateUnsetProperty) {
	      var _this35 = this;
	      var containerDimensions = this.container.getBoundingClientRect();
	      if (this.maxWidth !== null) {
	        if (!this.elements.root.style.maxWidth && animateUnsetProperty) {
	          this.elements.root.style.maxWidth = containerDimensions.width + 'px';
	        }
	        setTimeout(function () {
	          return _this35.elements.root.style.maxWidth = Math.max(_this35.maxWidth, MIN_WIDTH) + 'px';
	        }, 0);
	      } else {
	        this.elements.root.style.maxWidth = containerDimensions.width + 'px';
	        this.elements.root.addEventListener('transitionend', function () {
	          return _this35.elements.root.style.removeProperty('max-width');
	        }, {
	          once: true
	        });
	      }
	    }
	  }, {
	    key: "releaseLocalMedia",
	    value: function releaseLocalMedia() {
	      if (!this.hasCurrentUserScreenSharing()) {
	        this.localUser.releaseStream();
	      }
	      if (this.centralUser.id == this.userId) {
	        this.centralUser.releaseStream();
	      }
	    }
	  }, {
	    key: "clearNewLogicRules",
	    value: function clearNewLogicRules() {
	      clearTimeout(this.rerenderTimeout);
	      this.rerenderTimeout = null;
	      this.waitingForUserMediaTimeouts.forEach(function (timeout) {
	        return clearTimeout(timeout);
	      });
	      this.waitingForUserMediaTimeouts.clear();
	      this.rerenderQueue.clear();
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.closeCopilotNotify();
	      if (this.overflownButtonsPopup) {
	        this.overflownButtonsPopup.close();
	      }
	      if (this.elements.root) {
	        main_core.Dom.remove(this.elements.root);
	        this.elements.root = null;
	      }
	      this.visible = false;
	      this.clearNewLogicRules();
	      window.removeEventListener("webkitfullscreenchange", this._onFullScreenChangeHandler);
	      window.removeEventListener("mozfullscreenchange", this._onFullScreenChangeHandler);
	      window.removeEventListener("orientationchange", this._onOrientationChangeHandler);
	      window.removeEventListener("keydown", this._onKeyDownHandler);
	      window.removeEventListener("keyup", this._onKeyUpHandler);
	      document.removeEventListener('mousemove', this.onMouseMoveHandler);
	      this.resizeObserver.disconnect();
	      this.resizeObserver = null;
	      if (this.intersectionObserver) {
	        this.intersectionObserver.disconnect();
	        this.intersectionObserver = null;
	      }
	      for (var userId in this.users) {
	        if (this.users.hasOwnProperty(userId)) {
	          this.users[userId].destroy();
	        }
	      }
	      this.userData = null;
	      this.centralUser.destroy();
	      this.hintManager.hide();
	      this.hintManager = null;
	      clearTimeout(this.switchPresenterTimeout);
	      if (this.buttons.recordStatus) {
	        this.buttons.recordStatus.stopViewUpdate();
	      }
	      this.recordState = this.getDefaultRecordState();
	      this.buttons = null;
	      this.eventEmitter.emit(EventName.onDestroy);
	      this.eventEmitter.unsubscribeAll();
	      Hardware.unsubscribe(Hardware.Events.onChangeMicrophoneMuted, this.setMuted);
	      Hardware.unsubscribe(Hardware.Events.onChangeCameraOn, this.setCameraState);
	    }
	  }, {
	    key: "isPreparing",
	    get: function get() {
	      return this._isPreparing;
	    },
	    set: function set(isPreparing) {
	      this._isPreparing = !!isPreparing;
	    }
	  }, {
	    key: "videoRerenderDelay",
	    // for testing different delay values
	    get: function get() {
	      return this._videoRerenderDelay > 0 ? this._videoRerenderDelay : CHANGE_VIDEO_RERENDER_DELAY;
	    },
	    set: function set(videoRerenderDelay) {
	      this._videoRerenderDelay = videoRerenderDelay;
	    }
	  }]);
	  return View;
	}();
	babelHelpers.defineProperty(View, "Layout", Layouts);
	babelHelpers.defineProperty(View, "Size", Size);
	babelHelpers.defineProperty(View, "RecordState", RecordState);
	babelHelpers.defineProperty(View, "RecordType", RecordType);
	babelHelpers.defineProperty(View, "RecordSource", {
	  Chat: 'BXCLIENT_CHAT'
	});
	babelHelpers.defineProperty(View, "UiState", UiState);
	babelHelpers.defineProperty(View, "Event", EventName);
	babelHelpers.defineProperty(View, "RoomState", RoomState);
	babelHelpers.defineProperty(View, "DeviceSelector", DeviceSelector);
	babelHelpers.defineProperty(View, "NotificationManager", NotificationManager);
	babelHelpers.defineProperty(View, "MIN_WIDTH", MIN_WIDTH);

	var VOLUME_THRESHOLD = 0.02;
	var INACTIVITY_TIME = 2000;
	var AVERAGING_COEFFICIENT = 0.6; // from 0 to 1;

	/**
	 * Naive voice activity detection
	 * @param {object} config
	 * @param {MediaStream} config.mediaStream
	 * @param {function} config.onVoiceStarted
	 * @param {function} config.onVoiceStopped
	 * @constructor
	 */
	var SimpleVAD = /*#__PURE__*/function () {
	  function SimpleVAD(config) {
	    babelHelpers.classCallCheck(this, SimpleVAD);
	    if (!(config.mediaStream instanceof MediaStream)) {
	      throw new Error("config.mediaStream should be instance of MediaStream");
	    }
	    if (config.mediaStream.getAudioTracks().length === 0) {
	      throw new Error("config.mediaStream should contain audio track");
	    }
	    this.mediaStream = new MediaStream();
	    this.mediaStream.addTrack(config.mediaStream.getAudioTracks()[0].clone());
	    this.audioContext = null;
	    this.mediaStreamNode = null;
	    this.analyserNode = null;
	    this.audioTimeDomainData = null;
	    this.voiceState = false;
	    this.measureInterval = 0;
	    this.inactivityTimeout = 0;
	    this.currentVolume = 0;
	    this.callbacks = {
	      voiceStarted: main_core.Type.isFunction(config.onVoiceStarted) ? config.onVoiceStarted : BX.DoNothing,
	      voiceStopped: main_core.Type.isFunction(config.onVoiceStopped) ? config.onVoiceStopped : BX.DoNothing
	    };
	    if (SimpleVAD.isSupported()) {
	      this.init();
	    }
	  }
	  babelHelpers.createClass(SimpleVAD, [{
	    key: "init",
	    value: function init() {
	      this.audioContext = new (window.AudioContext || window.webkitAudioContext)();
	      this.analyserNode = this.audioContext.createAnalyser();
	      this.analyserNode.fftSize = 128;
	      this.mediaStreamNode = this.audioContext.createMediaStreamSource(this.mediaStream);
	      this.mediaStreamNode.connect(this.analyserNode);
	      this.audioTimeDomainData = new Float32Array(this.analyserNode.fftSize);
	      this.measureInterval = setInterval(this.analyzeAudioStream.bind(this), 100);
	    }
	  }, {
	    key: "analyzeAudioStream",
	    value: function analyzeAudioStream() {
	      this.analyserNode.getFloatTimeDomainData(this.audioTimeDomainData);
	      this.updateCurrentVolume(this.audioTimeDomainData);
	      this.setVoiceState(this.currentVolume >= VOLUME_THRESHOLD);
	    }
	  }, {
	    key: "setVoiceState",
	    value: function setVoiceState(voiceState) {
	      if (this.voiceState == voiceState) {
	        return;
	      }
	      if (voiceState) {
	        this.callbacks.voiceStarted();
	        clearTimeout(this.inactivityTimeout);
	        this.inactivityTimeout = 0;
	        this.voiceState = true;
	      } else {
	        if (!this.inactivityTimeout) {
	          this.inactivityTimeout = setTimeout(this.onInactivityTimeout.bind(this), INACTIVITY_TIME);
	        }
	      }
	    }
	  }, {
	    key: "onInactivityTimeout",
	    value: function onInactivityTimeout() {
	      this.inactivityTimeout = 0;
	      this.voiceState = false;
	      this.callbacks.voiceStopped();
	    }
	  }, {
	    key: "updateCurrentVolume",
	    value: function updateCurrentVolume(audioTimeDomainData) {
	      var sum = 0;
	      for (var i = 0; i < audioTimeDomainData.length; i++) {
	        sum += audioTimeDomainData[i] * audioTimeDomainData[i];
	      }
	      var rms = Math.sqrt(sum / audioTimeDomainData.length);
	      this.currentVolume = Math.max(rms, this.currentVolume * AVERAGING_COEFFICIENT);
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      if (this.analyserNode) {
	        this.analyserNode.disconnect();
	      }
	      if (this.mediaStreamNode) {
	        this.mediaStreamNode.disconnect();
	      }
	      if (this.audioContext) {
	        this.audioContext.close();
	      }
	      if (this.mediaStream) {
	        this.mediaStream.getTracks().forEach(function (track) {
	          return track.stop();
	        });
	        this.mediaStream = null;
	      }
	      clearInterval(this.measureInterval);
	      this.analyserNode = null;
	      this.mediaStreamNode = null;
	      this.audioContext = null;
	      this.callbacks = {
	        voiceStarted: BX.DoNothing,
	        voiceStopped: BX.DoNothing
	      };
	    }
	  }], [{
	    key: "isSupported",
	    value: function isSupported() {
	      return (window.AudioContext || window.webkitAudioContext) && window.AnalyserNode && typeof window.AnalyserNode.prototype['getFloatTimeDomainData'] === "function";
	    }
	  }]);
	  return SimpleVAD;
	}();

	function _classPrivateMethodInitSpec$1(obj, privateSet) { _checkPrivateRedeclaration$1(obj, privateSet); privateSet.add(obj); }
	function _checkPrivateRedeclaration$1(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }
	function _classPrivateMethodGet$1(receiver, privateSet, fn) { if (!privateSet.has(receiver)) { throw new TypeError("attempted to get private field on non-instance"); } return fn; }
	var ajaxActions = {
	  invite: 'im.call.invite',
	  cancel: 'im.call.cancel',
	  answer: 'im.call.answer',
	  decline: 'im.call.decline',
	  hangup: 'im.call.hangup',
	  ping: 'im.call.ping',
	  negotiationNeeded: 'im.call.negotiationNeeded',
	  connectionOffer: 'im.call.connectionOffer',
	  connectionAnswer: 'im.call.connectionAnswer',
	  iceCandidate: 'im.call.iceCandidate'
	};
	var pullEvents = {
	  ping: 'Call::ping',
	  answer: 'Call::answer',
	  negotiationNeeded: 'Call::negotiationNeeded',
	  connectionOffer: 'Call::connectionOffer',
	  connectionAnswer: 'Call::connectionAnswer',
	  iceCandidate: 'Call::iceCandidate',
	  voiceStarted: 'Call::voiceStarted',
	  voiceStopped: 'Call::voiceStopped',
	  recordState: 'Call::recordState',
	  microphoneState: 'Call::microphoneState',
	  cameraState: 'Call::cameraState',
	  videoPaused: 'Call::videoPaused',
	  customMessage: 'Call::customMessage',
	  hangup: 'Call::hangup',
	  userInviteTimeout: 'Call::userInviteTimeout'
	};
	var defaultConnectionOptions = {
	  offerToReceiveVideo: true,
	  offerToReceiveAudio: true
	};
	var signalingConnectionRefreshPeriod = 30000;
	var signalingWaitReplyPeriod = 10000;
	//var signalingWaitReplyPeriod = 5000;
	var pingPeriod = 5000;
	var backendPingPeriod = 25000;
	var reinvitePeriod = 5500;

	/**
	 * Implements Call interface
	 * Public methods:
	 * - inviteUsers
	 * - cancel
	 * - answer
	 * - decline
	 * - hangup
	 * - setMuted
	 * - setVideoEnabled
	 * - setCameraId
	 * - setMicrophoneId
	 *
	 * Events:
	 * - onCallStateChanged //not sure about this.
	 * - onUserStateChanged
	 * - onUserVoiceStarted
	 * - onUserVoiceStopped
	 * - onLocalMediaReceived
	 * - onLocalMediaStopped
	 * - onLocalMediaError
	 * - onDeviceListUpdated
	 * - onDestroy
	 */
	var _changeRecordState = /*#__PURE__*/new WeakSet();
	var _onPullEventUsersJoined = /*#__PURE__*/new WeakSet();
	var _onPullEventUsersInvited = /*#__PURE__*/new WeakSet();
	var _onPullEventUserInviteTimeout = /*#__PURE__*/new WeakSet();
	var _onPullEventAnswer = /*#__PURE__*/new WeakSet();
	var _onPullEventAnswerSelf = /*#__PURE__*/new WeakSet();
	var _onPullEventHangup = /*#__PURE__*/new WeakSet();
	var _onPullEventPing = /*#__PURE__*/new WeakSet();
	var _onPullEventNegotiationNeeded = /*#__PURE__*/new WeakSet();
	var _onPullEventConnectionOffer = /*#__PURE__*/new WeakSet();
	var _onPullEventConnectionAnswer = /*#__PURE__*/new WeakSet();
	var _onPullEventIceCandidate = /*#__PURE__*/new WeakSet();
	var _onPullEventVoiceStarted = /*#__PURE__*/new WeakSet();
	var _onPullEventVoiceStopped = /*#__PURE__*/new WeakSet();
	var _onPullEventMicrophoneState = /*#__PURE__*/new WeakSet();
	var _onPullEventCameraState = /*#__PURE__*/new WeakSet();
	var _onPullEventVideoPaused = /*#__PURE__*/new WeakSet();
	var _onPullEventRecordState = /*#__PURE__*/new WeakSet();
	var _onPullEventAssociatedEntityReplaced = /*#__PURE__*/new WeakSet();
	var _onPullEventFinish = /*#__PURE__*/new WeakSet();
	var _onPullEventRepeatAnswer = /*#__PURE__*/new WeakSet();
	var _onPullEventCallCustomMessage = /*#__PURE__*/new WeakSet();
	var _onPeerStateChanged = /*#__PURE__*/new WeakSet();
	var _onPeerInviteTimeout = /*#__PURE__*/new WeakSet();
	var _onPeerRTCStatsReceived = /*#__PURE__*/new WeakSet();
	var _onPeerRTCQualityChanged = /*#__PURE__*/new WeakSet();
	var _onUnload = /*#__PURE__*/new WeakSet();
	var _beforeLeaveCall = /*#__PURE__*/new WeakSet();
	var PlainCall = /*#__PURE__*/function (_AbstractCall) {
	  babelHelpers.inherits(PlainCall, _AbstractCall);
	  function PlainCall(_params) {
	    var _this;
	    babelHelpers.classCallCheck(this, PlainCall);
	    _this = babelHelpers.possibleConstructorReturn(this, babelHelpers.getPrototypeOf(PlainCall).call(this, _params));
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _beforeLeaveCall);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onUnload);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPeerRTCQualityChanged);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPeerRTCStatsReceived);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPeerInviteTimeout);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPeerStateChanged);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventCallCustomMessage);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventRepeatAnswer);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventFinish);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventAssociatedEntityReplaced);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventRecordState);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventVideoPaused);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventCameraState);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventMicrophoneState);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventVoiceStopped);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventVoiceStarted);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventIceCandidate);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventConnectionAnswer);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventConnectionOffer);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventNegotiationNeeded);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventPing);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventHangup);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventAnswerSelf);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventAnswer);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventUserInviteTimeout);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventUsersInvited);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventUsersJoined);
	    _classPrivateMethodInitSpec$1(babelHelpers.assertThisInitialized(_this), _changeRecordState);
	    babelHelpers.defineProperty(babelHelpers.assertThisInitialized(_this), "setVideoEnabled", function (event) {
	      if (_this.videoEnabled == event.data.isCameraOn) {
	        return;
	      }
	      _this.videoEnabled = event.data.isCameraOn;
	      var hasVideoTracks = _this.localStreams['main'] && _this.localStreams['main'].getVideoTracks().length > 0;
	      if (_this.ready && hasVideoTracks !== _this.videoEnabled) {
	        _this.replaceLocalMediaStream().then(function () {
	          _this.signaling.sendCameraState(_this.users, _this.videoEnabled);
	        })["catch"](function () {
	          _this.runCallback(CallEvent.onLocalMediaReceived, {
	            tag: 'main',
	            stream: _this.localStreams['main'] || new MediaStream()
	          });
	        });
	      }
	    });
	    babelHelpers.defineProperty(babelHelpers.assertThisInitialized(_this), "setMuted", function (event) {
	      if (_this.muted == event.data.isMicrophoneMuted) {
	        return;
	      }
	      _this.muted = event.data.isMicrophoneMuted;
	      if (_this.localStreams["main"]) {
	        var audioTracks = _this.localStreams["main"].getAudioTracks();
	        if (audioTracks[0]) {
	          audioTracks[0].enabled = !_this.muted;
	        }
	      }
	      _this.signaling.sendMicrophoneState(_this.users, !_this.muted);
	      _this.sendTalkingState();
	    });
	    _this.callFromMobile = _params.callFromMobile;
	    _this.state = _params.state || '';
	    _this.peers = _this.initPeers(_this.users);
	    _this.signaling = new Signaling({
	      call: babelHelpers.assertThisInitialized(_this)
	    });
	    _this.recordState = {
	      state: 'stopped',
	      userId: 0,
	      date: {
	        start: null,
	        pause: []
	      }
	    };
	    _this.deviceList = [];
	    _this.turnServer = (main_core.Browser.isFirefox() ? BX.message('turn_server_firefox') : BX.message('turn_server')) || 'turn.calls.bitrix24.com';
	    _this.turnServerLogin = BX.message('turn_server_login') || 'bitrix';
	    _this.turnServerPassword = BX.message('turn_server_password') || 'bitrix';
	    _this.pingUsersInterval = setInterval(_this.pingUsers.bind(babelHelpers.assertThisInitialized(_this)), pingPeriod);
	    _this.pingBackendInterval = setInterval(_this.pingBackend.bind(babelHelpers.assertThisInitialized(_this)), backendPingPeriod);
	    _this.reinviteTimeout = null;
	    _this.userData = _params.userData;
	    _this._onUnloadHandler = _classPrivateMethodGet$1(babelHelpers.assertThisInitialized(_this), _onUnload, _onUnload2).bind(babelHelpers.assertThisInitialized(_this));
	    _this.enableMicAutoParameters = _params.enableMicAutoParameters !== false;
	    _this.microphoneLevelInterval = null;
	    _this.mediaMutedBySystem = false;
	    _this._reconnectionEventCount = 0;
	    _this._isCopilotActive = false;
	    _this._isCopilotFeaturesEnabled = false;
	    _this._isRecordWhenCopilotActivePopupAlreadyShow = null;
	    _this._isBoostExpired = false;
	    window.addEventListener("unload", _this._onUnloadHandler);
	    return _this;
	  }
	  babelHelpers.createClass(PlainCall, [{
	    key: "initPeers",
	    value: function initPeers(userIds) {
	      var peers = {};
	      for (var i = 0; i < userIds.length; i++) {
	        var userId = Number(userIds[i]);
	        if (userId == this.userId) {
	          continue;
	        }
	        peers[userId] = this.createPeer(userId);
	      }
	      return peers;
	    }
	  }, {
	    key: "createPeer",
	    value: function createPeer(userId) {
	      var _this2 = this;
	      return new Peer({
	        call: this,
	        userId: userId,
	        ready: userId == this.initiatorId,
	        signalingConnected: userId == this.initiatorId,
	        isLegacyMobile: userId == this.initiatorId && this.callFromMobile,
	        onMediaReceived: function onMediaReceived(e) {
	          _this2.runCallback(CallEvent.onRemoteMediaReceived, e);
	        },
	        onMediaStopped: function onMediaStopped(e) {
	          _this2.runCallback(CallEvent.onRemoteMediaStopped, e);
	        },
	        onStateChanged: _classPrivateMethodGet$1(this, _onPeerStateChanged, _onPeerStateChanged2).bind(this),
	        onInviteTimeout: _classPrivateMethodGet$1(this, _onPeerInviteTimeout, _onPeerInviteTimeout2).bind(this),
	        onRTCStatsReceived: _classPrivateMethodGet$1(this, _onPeerRTCStatsReceived, _onPeerRTCStatsReceived2).bind(this),
	        onRTCQualityChanged: _classPrivateMethodGet$1(this, _onPeerRTCQualityChanged, _onPeerRTCQualityChanged2).bind(this),
	        onNetworkProblem: function onNetworkProblem(e) {
	          _this2.runCallback(CallEvent.onNetworkProblem, e);
	        },
	        onReconnecting: function onReconnecting() {
	          _this2._reconnectionEventCount++;
	          _this2.runCallback(CallEvent.onReconnecting, {
	            reconnectionEventCount: _this2._reconnectionEventCount
	          });
	        },
	        onReconnected: function onReconnected() {
	          _this2._reconnectionEventCount = 0;
	          _this2.runCallback(CallEvent.onReconnected);
	        },
	        onUpdateLastUsedCameraId: function onUpdateLastUsedCameraId() {
	          _this2.runCallback(CallEvent.onUpdateLastUsedCameraId);
	        }
	      });
	    }
	  }, {
	    key: "getUsers",
	    /**
	     * Returns call participants and their states
	     * @return {object} userId => user state
	     */
	    value: function getUsers() {
	      var result = {};
	      for (var userId in this.peers) {
	        result[userId] = this.peers[userId].calculatedState;
	      }
	      return result;
	    }
	  }, {
	    key: "isReady",
	    value: function isReady() {
	      return this.ready;
	    }
	  }, {
	    key: "canChangeMediaDevices",
	    value: function canChangeMediaDevices() {
	      return !this.mediaMutedBySystem;
	    }
	  }, {
	    key: "setCameraId",
	    value: function setCameraId(cameraId) {
	      if (this.cameraId == cameraId) {
	        return;
	      }
	      this.cameraId = cameraId;
	      if (this.ready && this.mediaMutedBySystem) {
	        this.runCallback(CallEvent.onNeedResetMediaDevicesState);
	        this.changedMediaMutedBySystem(false);
	      } else if (this.ready && Hardware.isCameraOn) {
	        this.runCallback('onUpdateLastUsedCameraId');
	        main_core.Runtime.debounce(this.replaceLocalMediaStream, 100, this)();
	      }
	    }
	  }, {
	    key: "setMicrophoneId",
	    value: function setMicrophoneId(microphoneId) {
	      if (this.microphoneId == microphoneId) {
	        return;
	      }
	      this.microphoneId = microphoneId;
	      if (this.ready) {
	        if (this.mediaMutedBySystem) {
	          return;
	        }
	        main_core.Runtime.debounce(this.replaceLocalAudioStream, 100, this)();
	      }
	    }
	  }, {
	    key: "getCurrentMicrophoneId",
	    value: function getCurrentMicrophoneId() {
	      if (!this.localStreams['main']) {
	        return this.microphoneId;
	      }
	      var audioTracks = this.localStreams['main'].getAudioTracks();
	      if (audioTracks.length > 0) {
	        var audioTrackSettings = audioTracks[0].getSettings();
	        return audioTrackSettings.deviceId;
	      } else {
	        return this.microphoneId;
	      }
	    }
	  }, {
	    key: "useHdVideo",
	    value: function useHdVideo(flag) {
	      this.videoHd = flag === true;
	    }
	  }, {
	    key: "sendRecordState",
	    value: function sendRecordState(recordState) {
	      recordState.senderId = this.userId;
	      if (!_classPrivateMethodGet$1(this, _changeRecordState, _changeRecordState2).call(this, recordState)) {
	        return false;
	      }
	      var users = [this.userId].concat(this.users);
	      this.signaling.sendRecordState(users, this.recordState);
	    }
	  }, {
	    key: "stopSendingStream",
	    value: function stopSendingStream(tag) {
	      //todo: implement
	    }
	  }, {
	    key: "allowVideoFrom",
	    value: function allowVideoFrom(userList) {
	      //todo: implement
	    }
	  }, {
	    key: "inviteUsers",
	    /**
	     * Invites users to participate in the call.
	     **/
	    value: function inviteUsers() {
	      var _this3 = this;
	      var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      var users = main_core.Type.isArray(config.users) ? config.users : Object.keys(this.peers);
	      this.ready = true;
	      if (config.localStream instanceof MediaStream && !this.localStreams["main"]) {
	        this.localStreams["main"] = config.localStream;
	      }
	      this.getLocalMediaStream("main", true).then(function () {
	        if (!_this3.ready) {
	          _classPrivateMethodGet$1(_this3, _beforeLeaveCall, _beforeLeaveCall2).call(_this3);
	          return;
	        }
	        _this3.subscribeHardwareChanges();
	        return _this3.signaling.inviteUsers({
	          userIds: users,
	          video: Hardware.isCameraOn ? 'Y' : 'N'
	        });
	      }).then(function () {
	        _this3.state = CallState.Connected;
	        _this3.runCallback(CallEvent.onJoin, {
	          local: true
	        });
	        for (var i = 0; i < users.length; i++) {
	          var userId = Number(users[i]);
	          if (!_this3.peers[userId]) {
	            _this3.peers[userId] = _this3.createPeer(userId);
	            _this3.runCallback(CallEvent.onUserInvited, {
	              userId: userId
	            });
	          }
	          _this3.peers[userId].onInvited();
	          _this3.scheduleRepeatInvite();
	        }
	      })["catch"](function (e) {
	        console.error(e);
	        _this3.unsubscribeHardwareChanges();
	        _this3.runCallback(CallEvent.onCallFailure, e);
	      });
	    }
	  }, {
	    key: "scheduleRepeatInvite",
	    value: function scheduleRepeatInvite() {
	      clearTimeout(this.reinviteTimeout);
	      this.reinviteTimeout = setTimeout(this.repeatInviteUsers.bind(this), reinvitePeriod);
	    }
	  }, {
	    key: "repeatInviteUsers",
	    value: function repeatInviteUsers() {
	      var _this4 = this;
	      clearTimeout(this.reinviteTimeout);
	      if (!this.ready) {
	        return;
	      }
	      var usersToRepeatInvite = [];
	      for (var userId in this.peers) {
	        if (this.peers.hasOwnProperty(userId) && this.peers[userId].calculatedState === UserState.Calling) {
	          usersToRepeatInvite.push(userId);
	        }
	      }
	      if (usersToRepeatInvite.length === 0) {
	        return;
	      }
	      this.signaling.inviteUsers({
	        userIds: usersToRepeatInvite,
	        video: Hardware.isCameraOn ? 'Y' : 'N',
	        repeated: 'Y'
	      }).then(function () {
	        return _this4.scheduleRepeatInvite();
	      });
	    }
	  }, {
	    key: "subscribeHardwareChanges",
	    value: function subscribeHardwareChanges() {
	      Hardware.subscribe(Hardware.Events.onChangeMicrophoneMuted, this.setMuted);
	      Hardware.subscribe(Hardware.Events.onChangeCameraOn, this.setVideoEnabled);
	    }
	  }, {
	    key: "unsubscribeHardwareChanges",
	    value: function unsubscribeHardwareChanges() {
	      Hardware.unsubscribe(Hardware.Events.onChangeMicrophoneMuted, this.setMuted);
	      Hardware.unsubscribe(Hardware.Events.onChangeCameraOn, this.setVideoEnabled);
	    }
	  }, {
	    key: "getMediaConstraints",
	    value: function getMediaConstraints() {
	      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      var audio = {};
	      var video = options.videoEnabled ? {} : false;
	      var hdVideo = !!options.hdVideo;
	      var supportedConstraints = navigator.mediaDevices.getSupportedConstraints ? navigator.mediaDevices.getSupportedConstraints() : {};
	      if (this.microphoneId) {
	        audio.deviceId = {
	          ideal: this.microphoneId
	        };
	      }
	      if (!this.enableMicAutoParameters) {
	        if (supportedConstraints.echoCancellation) {
	          audio.echoCancellation = false;
	        }
	        if (supportedConstraints.noiseSuppression) {
	          audio.noiseSuppression = false;
	        }
	        if (supportedConstraints.autoGainControl) {
	          audio.autoGainControl = false;
	        }
	      }
	      if (video) {
	        //video.aspectRatio = 1.7777777778;
	        if (this.cameraId) {
	          video.deviceId = {
	            exact: this.cameraId
	          };
	        }
	        if (hdVideo) {
	          video.width = {
	            ideal: 1280
	          };
	          video.height = {
	            ideal: 720
	          };
	        }
	      }
	      return {
	        audio: audio,
	        video: video
	      };
	    }
	  }, {
	    key: "getUserMedia",
	    /**
	     * Recursively tries to get user media stream with array of constraints
	     *
	     * @param constraintsArray array of constraints objects
	     * @returns {Promise}
	     */
	    value: function getUserMedia(constraintsArray) {
	      return new Promise(function (resolve, reject) {
	        var currentConstraints = constraintsArray[0];
	        navigator.mediaDevices.getUserMedia(currentConstraints).then(function (stream) {
	          resolve(stream);
	        }, function (error) {
	          this.log("getUserMedia error: ", error);
	          this.log("Current constraints", currentConstraints);
	          if (constraintsArray.length > 1) {
	            this.getUserMedia(constraintsArray.slice(1)).then(function (stream) {
	              resolve(stream);
	            }, function (error) {
	              reject(error);
	            });
	          } else {
	            this.log("Last fallback constraints used, failing");
	            reject(error);
	          }
	        }.bind(this));
	      }.bind(this));
	    }
	  }, {
	    key: "getLocalMediaStream",
	    value: function getLocalMediaStream(tag, fallbackToAudio) {
	      var _this5 = this;
	      if (!main_core.Type.isStringFilled(tag)) {
	        tag = 'main';
	      }
	      if (this.localStreams[tag]) {
	        this.runCallback(CallEvent.onLocalMediaReceived, {
	          tag: tag,
	          stream: this.localStreams[tag]
	        });
	        return Promise.resolve(this.localStreams[tag]);
	      }
	      this.log("Requesting access to media devices");
	      return new Promise(function (resolve, reject) {
	        var constraintsArray = [];
	        if (Hardware.isCameraOn) {
	          constraintsArray.push(_this5.getMediaConstraints({
	            videoEnabled: true,
	            hdVideo: true
	          }));
	          constraintsArray.push(_this5.getMediaConstraints({
	            videoEnabled: true,
	            hdVideo: false
	          }));
	          if (fallbackToAudio) {
	            constraintsArray.push(_this5.getMediaConstraints({
	              videoEnabled: false
	            }));
	          }
	        } else {
	          constraintsArray.push(_this5.getMediaConstraints({
	            videoEnabled: false
	          }));
	        }
	        _this5.getUserMedia(constraintsArray).then(function (stream) {
	          _this5.log("Local media stream received");
	          _this5.localStreams[tag] = stream;
	          stream.getVideoTracks().forEach(function (track) {
	            track.addEventListener("ended", function () {
	              return _this5.onLocalVideoTrackEnded();
	            });
	            track.addEventListener("mute", function () {
	              return _this5.onLocalVideoTrackMute();
	            });
	            track.addEventListener("unmute", function () {
	              return _this5.onLocalVideoTrackUnmute();
	            });
	          });
	          stream.getAudioTracks().forEach(function (track) {
	            track.addEventListener("ended", function () {
	              return _this5.onLocalAudioTrackEnded();
	            });
	          });
	          _this5.runCallback(CallEvent.onLocalMediaReceived, {
	            tag: tag,
	            stream: stream
	          });
	          _this5.setPublishingState(MediaStreamsKinds.Camera, true);
	          if (tag === 'main') {
	            _this5.attachVoiceDetection();
	            if (Hardware.isMicrophoneMuted) {
	              var audioTracks = stream.getAudioTracks();
	              if (audioTracks[0]) {
	                audioTracks[0].enabled = false;
	              }
	            }
	          }
	          if (_this5.deviceList.length === 0) {
	            navigator.mediaDevices.enumerateDevices().then(function (deviceList) {
	              _this5.deviceList = deviceList;
	              _this5.runCallback(CallEvent.onDeviceListUpdated, {
	                deviceList: _this5.deviceList
	              });
	            });
	          }
	          resolve(_this5.localStreams[tag]);
	        })["catch"](function (e) {
	          _this5.log("Could not get local media stream.", e);
	          _this5.log("Request constraints: .", constraintsArray);
	          _this5.runCallback("onLocalMediaError", {
	            tag: tag,
	            error: e
	          });
	          reject(e);
	        });
	      });
	    }
	  }, {
	    key: "getLocalAudioStream",
	    value: function getLocalAudioStream(tag, fallbackToAudio) {
	      var _this6 = this;
	      if (!main_core.Type.isStringFilled(tag)) {
	        tag = 'main';
	      }
	      if (this.localStreams[tag] && this.localStreams[tag].getAudioTracks().length) {
	        return Promise.resolve(this.localStreams[tag]);
	      }
	      this.log("Requesting access to audio devices");
	      return new Promise(function (resolve, reject) {
	        var constraintsArray = [_this6.getMediaConstraints({
	          videoEnabled: false
	        })];
	        _this6.getUserMedia(constraintsArray).then(function (stream) {
	          _this6.log("Local audio stream received");
	          if (!_this6.localStreams[tag]) {
	            _this6.localStreams[tag] = new MediaStream();
	          }
	          _this6.localStreams[tag].addTrack(stream.getAudioTracks()[0]);
	          stream.getAudioTracks().forEach(function (track) {
	            track.addEventListener("ended", function () {
	              return _this6.onLocalAudioTrackEnded();
	            });
	          });
	          if (tag === 'main') {
	            _this6.attachVoiceDetection();
	            if (_this6.muted) {
	              var audioTracks = stream.getAudioTracks();
	              if (audioTracks[0]) {
	                audioTracks[0].enabled = false;
	              }
	            }
	          }
	          if (_this6.deviceList.length === 0) {
	            navigator.mediaDevices.enumerateDevices().then(function (deviceList) {
	              _this6.deviceList = deviceList;
	              _this6.runCallback(CallEvent.onDeviceListUpdated, {
	                deviceList: _this6.deviceList
	              });
	            });
	          }
	          resolve(_this6.localStreams[tag]);
	        })["catch"](function (e) {
	          _this6.log("Could not get local audio stream.", e);
	          _this6.log("Request constraints: .", constraintsArray);
	          _this6.runCallback("onLocalMediaError", {
	            tag: tag,
	            error: e
	          });
	          reject(e);
	        });
	      });
	    }
	  }, {
	    key: "setPublishingState",
	    value: function setPublishingState(deviceType, publishing) {
	      if (deviceType === MediaStreamsKinds.Camera) {
	        this.runCallback(CallEvent.onCameraPublishing, {
	          publishing: publishing
	        });
	      } else if (deviceType === MediaStreamsKinds.Microphone) {
	        this.runCallback(CallEvent.onMicrophonePublishing, {
	          publishing: publishing
	        });
	      }
	    }
	  }, {
	    key: "startMediaCapture",
	    value: function startMediaCapture() {
	      return this.getLocalMediaStream();
	    }
	  }, {
	    key: "attachVoiceDetection",
	    value: function attachVoiceDetection() {
	      if (this.voiceDetection) {
	        this.voiceDetection.destroy();
	      }
	      if (this.microphoneLevelInterval) {
	        clearInterval(this.microphoneLevelInterval);
	      }
	      try {
	        this.voiceDetection = new SimpleVAD({
	          mediaStream: this.localStreams['main'],
	          onVoiceStarted: this.onLocalVoiceStarted.bind(this),
	          onVoiceStopped: this.onLocalVoiceStopped.bind(this)
	        });
	        this.microphoneLevelInterval = setInterval(function () {
	          this.microphoneLevel = this.voiceDetection.currentVolume;
	        }.bind(this), 200);
	      } catch (e) {
	        this.log('Could not attach voice detection to media stream');
	      }
	    }
	  }, {
	    key: "getDisplayMedia",
	    value: function getDisplayMedia() {
	      return new Promise(function (resolve, reject) {
	        if (window["BXDesktopSystem"] && window["BXDesktopSystem"].GetProperty('versionParts')[3] < 78) {
	          navigator.mediaDevices.getUserMedia({
	            video: {
	              mandatory: {
	                chromeMediaSource: 'screen',
	                maxWidth: 1920,
	                maxHeight: 1080,
	                maxFrameRate: 5
	              }
	            }
	          }).then(function (stream) {
	            resolve(stream);
	          }, function (error) {
	            reject(error);
	          });
	        } else if (navigator.mediaDevices.getDisplayMedia) {
	          navigator.mediaDevices.getDisplayMedia({
	            video: {
	              cursor: 'always',
	              width: {
	                ideal: 1920
	              },
	              height: {
	                ideal: 1080
	              }
	            },
	            systemAudio: "include",
	            audio: true
	          }).then(function (stream) {
	            resolve(stream);
	          }, function (error) {
	            reject(error);
	          });
	        } else {
	          console.error("Screen sharing is not supported");
	          reject("Screen sharing is not supported");
	        }
	      });
	    }
	  }, {
	    key: "startScreenSharing",
	    value: function startScreenSharing(changeSource) {
	      var _this7 = this;
	      changeSource = !!changeSource;
	      if (this.localStreams["screen"] && !changeSource) {
	        return;
	      }
	      this.getDisplayMedia().then(function (stream) {
	        _this7.localStreams["screen"] = stream;
	        stream.getVideoTracks().forEach(function (track) {
	          track.addEventListener("ended", function () {
	            return _this7.stopScreenSharing();
	          });
	        });
	        _this7.runCallback(CallEvent.onUserScreenState, {
	          userId: _this7.userId,
	          screenState: true
	        });
	        if (_this7.ready) {
	          for (var userId in _this7.peers) {
	            if (_this7.peers[userId].calculatedState === UserState.Connected) {
	              _this7.peers[userId].sendMedia();
	            }
	          }
	        }
	      })["catch"](function (e) {
	        _this7.log(e);
	      });
	    }
	  }, {
	    key: "onLocalVideoTrackEnded",
	    value: function onLocalVideoTrackEnded() {
	      if (!this.localStreams["main"]) {
	        return;
	      }
	      Util.stopMediaStreamVideoTracks(this.localStreams["main"]);
	      this.runCallback(CallEvent.onLocalMediaReceived, {
	        tag: 'main',
	        stream: this.localStreams["main"]
	      });
	      if (!this.localStreams["main"].getAudioTracks().length) {
	        this.localStreams["main"] = null;
	      }
	      for (var userId in this.peers) {
	        if (this.peers[userId].calculatedState === UserState.Connected) {
	          this.peers[userId].sendMedia();
	        }
	      }
	    }
	  }, {
	    key: "onLocalAudioTrackEnded",
	    value: function onLocalAudioTrackEnded() {
	      if (!this.localStreams["main"]) {
	        return;
	      }
	      Util.stopMediaStreamAudioTracks(this.localStreams["main"]);
	      this.runCallback(CallEvent.onLocalMediaReceived, {
	        tag: 'main',
	        stream: this.localStreams["main"]
	      });
	      if (!this.localStreams["main"].getVideoTracks().length) {
	        this.localStreams["main"] = null;
	      }
	      for (var userId in this.peers) {
	        if (this.peers[userId].calculatedState === UserState.Connected) {
	          this.peers[userId].sendMedia();
	        }
	      }
	    }
	  }, {
	    key: "onLocalVideoTrackMute",
	    value: function onLocalVideoTrackMute() {
	      this.changedMediaMutedBySystem(true);
	      this.prevMainStream = this.localStreams['main'];
	      if (this.ready) {
	        this.localStreams['main'] = null;
	        for (var userId in this.peers) {
	          if (this.peers[userId].isReady()) {
	            this.peers[userId].replaceMediaStream('main');
	          }
	        }
	      }
	    }
	  }, {
	    key: "onLocalVideoTrackUnmute",
	    value: function onLocalVideoTrackUnmute() {
	      var _this8 = this;
	      this.changedMediaMutedBySystem(false);
	      if (this.prevMainStream) {
	        Util.stopMediaStream(this.prevMainStream);
	        this.prevMainStream = null;
	      }
	      this.replaceLocalMediaStream()["catch"](function () {
	        _this8.runCallback(CallEvent.onLocalMediaReceived, {
	          tag: 'main',
	          stream: _this8.localStreams['main'] || new MediaStream()
	        });
	      });
	    }
	  }, {
	    key: "changedMediaMutedBySystem",
	    value: function changedMediaMutedBySystem(muted) {
	      this.mediaMutedBySystem = muted;
	      var microphoneState = muted ? false : !Hardware.isMicrophoneMuted;
	      var cameraState = muted ? false : Hardware.isCameraOn;
	      this.signaling.sendMicrophoneState(this.users, microphoneState);
	      this.signaling.sendCameraState(this.users, cameraState);
	    }
	  }, {
	    key: "stopScreenSharing",
	    value: function stopScreenSharing() {
	      if (!this.localStreams["screen"]) {
	        return;
	      }
	      Util.stopMediaStream(this.localStreams["screen"]);
	      this.localStreams["screen"] = null;
	      this.runCallback(CallEvent.onUserScreenState, {
	        userId: this.userId,
	        screenState: false
	      });
	      for (var userId in this.peers) {
	        if (this.peers[userId].calculatedState === UserState.Connected) {
	          this.peers[userId].sendMedia();
	        }
	      }
	    }
	  }, {
	    key: "isScreenSharingStarted",
	    value: function isScreenSharingStarted() {
	      return this.localStreams["screen"] instanceof MediaStream;
	    }
	  }, {
	    key: "onLocalVoiceStarted",
	    value: function onLocalVoiceStarted() {
	      this.talking = true;
	      this.sendTalkingState();
	    }
	  }, {
	    key: "onLocalVoiceStopped",
	    value: function onLocalVoiceStopped() {
	      this.talking = false;
	      this.sendTalkingState();
	    }
	  }, {
	    key: "sendTalkingState",
	    value: function sendTalkingState() {
	      if (this.talking && !Hardware.isMicrophoneMuted) {
	        this.runCallback(CallEvent.onUserVoiceStarted, {
	          userId: this.userId,
	          local: true
	        });
	        this.signaling.sendVoiceStarted({
	          userId: this.users
	        });
	      } else {
	        this.runCallback(CallEvent.onUserVoiceStopped, {
	          userId: this.userId,
	          local: true
	        });
	        this.signaling.sendVoiceStopped({
	          userId: this.users
	        });
	      }
	    }
	  }, {
	    key: "sendCustomMessage",
	    value: function sendCustomMessage(message) {
	      this.signaling.sendCustomMessage({
	        userId: this.users,
	        message: message
	      });
	    }
	    /**
	     * @param {Object} config
	     * @param {bool} [config.useVideo]
	     * @param {bool} [config.enableMicAutoParameters]
	     * @param {MediaStream} [config.localStream]
	     */
	  }, {
	    key: "answer",
	    value: function answer(config) {
	      var _this9 = this;
	      if (!main_core.Type.isPlainObject(config)) {
	        config = {};
	      }
	      /*if(this.direction !== Direction.Incoming)
	      {
	      	throw new Error('Only incoming call could be answered');
	      }*/

	      this.ready = true;
	      this.videoEnabled = Hardware.isCameraOn;
	      this.muted = Hardware.isMicrophoneMuted;
	      this.enableMicAutoParameters = config.enableMicAutoParameters !== false;
	      if (config.localStream instanceof MediaStream) {
	        this.localStreams["main"] = config.localStream;
	      }
	      return new Promise(function (resolve, reject) {
	        _this9.getLocalMediaStream("main", true).then(function () {
	          if (!_this9.ready) {
	            _classPrivateMethodGet$1(_this9, _beforeLeaveCall, _beforeLeaveCall2).call(_this9);
	            return;
	          }
	          _this9.subscribeHardwareChanges();
	          _this9.state = CallState.Connected;
	          _this9.runCallback(CallEvent.onJoin, {
	            local: true
	          });
	          return _this9.sendAnswer();
	        }).then(function () {
	          return resolve();
	        })["catch"](function (e) {
	          _this9.runCallback(CallEvent.onCallFailure, e);
	          reject(e);
	        });
	      });
	    }
	  }, {
	    key: "sendAnswer",
	    value: function sendAnswer() {
	      this.signaling.sendAnswer();
	    }
	  }, {
	    key: "decline",
	    value: function decline(code, reason) {
	      var _this10 = this;
	      this.ready = false;
	      var data = {
	        callId: this.id,
	        callInstanceId: this.instanceId
	      };
	      if (typeof code != 'undefined') {
	        data.code = code;
	      }
	      if (typeof reason != 'undefined') {
	        data.reason = reason;
	      }
	      CallEngine.getRestClient().callMethod(ajaxActions.decline, data).then(function () {
	        _this10.destroy();
	      });
	    }
	  }, {
	    key: "hangup",
	    value: function hangup() {
	      var _this11 = this;
	      var force = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
	      if (!this.ready && !force) {
	        var error = new Error("Hangup in wrong state");
	        this.log(error);
	        return Promise.reject(error);
	      }
	      var tempError = new Error();
	      tempError.name = "Call stack:";
	      this.log("Hangup received \n" + tempError.stack);
	      this.ready = false;
	      this.state = CallState.Proceeding;
	      return new Promise(function (resolve, reject) {
	        for (var userId in _this11.peers) {
	          _this11.peers[userId].disconnect();
	        }
	        _classPrivateMethodGet$1(_this11, _beforeLeaveCall, _beforeLeaveCall2).call(_this11);
	        _this11.runCallback(CallEvent.onLeave, {
	          local: true
	        });
	        _this11.signaling.sendHangup({
	          userId: _this11.users
	        }).then(function () {
	          return resolve();
	        })["catch"](function (e) {
	          return reject(e);
	        });
	      });
	    }
	  }, {
	    key: "pingUsers",
	    value: function pingUsers() {
	      if (this.ready) {
	        this.signaling.sendPingToUsers({
	          userId: this.users.concat(this.userId)
	        });
	      }
	    }
	  }, {
	    key: "pingBackend",
	    value: function pingBackend() {
	      if (this.ready) {
	        this.signaling.sendPingToBackend();
	      }
	    }
	  }, {
	    key: "getState",
	    value: function getState() {}
	  }, {
	    key: "replaceLocalMediaStream",
	    value: function replaceLocalMediaStream() {
	      var _this12 = this;
	      var tag = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "main";
	      this.setPublishingState(MediaStreamsKinds.Camera, true);
	      if (this.localStreams[tag]) {
	        Util.stopMediaStream(this.localStreams[tag]);
	        this.localStreams[tag] = null;
	      }
	      return new Promise(function (resolve, reject) {
	        _this12.getLocalMediaStream(tag).then(function () {
	          if (_this12.ready) {
	            for (var userId in _this12.peers) {
	              if (_this12.peers[userId].isReady()) {
	                _this12.peers[userId].replaceMediaStream(tag);
	                if (_this12.mediaMutedBySystem) {
	                  _this12.changedMediaMutedBySystem(false);
	                }
	              }
	            }
	          }
	          resolve();
	        })["catch"](function (e) {
	          console.error('Could not get access to hardware; don\'t really know what to do. error:', e);
	          reject(e);
	        });
	      });
	    }
	  }, {
	    key: "replaceLocalAudioStream",
	    value: function replaceLocalAudioStream() {
	      var _this13 = this;
	      var tag = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "main";
	      if (this.localStreams[tag]) {
	        Util.stopMediaStreamAudioTracks(this.localStreams[tag]);
	      }
	      return new Promise(function (resolve, reject) {
	        _this13.getLocalAudioStream(tag).then(function () {
	          if (_this13.ready) {
	            for (var userId in _this13.peers) {
	              if (_this13.peers[userId].isReady()) {
	                _this13.peers[userId].replaceMediaStream(tag);
	              }
	            }
	          }
	          resolve();
	        })["catch"](function (e) {
	          console.error('Could not get access to hardware; don\'t really know what to do. error:', e);
	          reject(e);
	        });
	      });
	    }
	  }, {
	    key: "sendAllStreams",
	    value: function sendAllStreams(userId) {
	      if (!this.peers[userId]) {
	        return;
	      }
	      if (!this.peers[userId].isReady()) {
	        return;
	      }
	      for (var tag in this.localStreams) {
	        if (this.localStreams[tag]) {
	          this.peers[userId].sendMedia();
	        }
	      }
	    }
	  }, {
	    key: "isAnyoneParticipating",
	    value: function isAnyoneParticipating() {
	      for (var userId in this.peers) {
	        if (this.peers[userId].isParticipating()) {
	          return true;
	        }
	      }
	      return false;
	    }
	  }, {
	    key: "getParticipatingUsers",
	    value: function getParticipatingUsers() {
	      var result = [];
	      for (var userId in this.peers) {
	        if (this.peers[userId].isParticipating()) {
	          result.push(userId);
	        }
	      }
	      return result;
	    }
	  }, {
	    key: "addJoinedUsers",
	    /**
	     * Adds users, invited by you or someone else
	     * @param {Number[]} users
	     */
	    value: function addJoinedUsers(users) {
	      for (var i = 0; i < users.length; i++) {
	        var userId = Number(users[i]);
	        if (userId == this.userId || this.peers[userId]) {
	          continue;
	        }
	        this.peers[userId] = this.createPeer(userId);
	        if (!this.users.includes(userId)) {
	          this.users.push(userId);
	        }
	      }
	    }
	  }, {
	    key: "addInvitedUsers",
	    /**
	     * Adds users, invited by you or someone else
	     * @param {Number[]} users
	     */
	    value: function addInvitedUsers(users) {
	      for (var i = 0; i < users.length; i++) {
	        var userId = Number(users[i]);
	        if (userId == this.userId) {
	          continue;
	        }
	        if (!this.peers[userId]) {
	          this.peers[userId] = this.createPeer(userId);
	          this.runCallback(CallEvent.onUserInvited, {
	            userId: userId
	          });
	        }
	        if (this.peers[userId].calculatedState !== UserState.Calling) {
	          this.peers[userId].onInvited();
	        }
	        if (!this.users.includes(userId)) {
	          this.users.push(userId);
	        }
	      }
	    }
	  }, {
	    key: "__onPullEvent",
	    value: function __onPullEvent(command, params, extra) {
	      var handlers = {
	        'Call::answer': _classPrivateMethodGet$1(this, _onPullEventAnswer, _onPullEventAnswer2).bind(this),
	        'Call::hangup': _classPrivateMethodGet$1(this, _onPullEventHangup, _onPullEventHangup2).bind(this),
	        'Call::ping': _classPrivateMethodGet$1(this, _onPullEventPing, _onPullEventPing2).bind(this),
	        'Call::negotiationNeeded': _classPrivateMethodGet$1(this, _onPullEventNegotiationNeeded, _onPullEventNegotiationNeeded2).bind(this),
	        'Call::connectionOffer': _classPrivateMethodGet$1(this, _onPullEventConnectionOffer, _onPullEventConnectionOffer2).bind(this),
	        'Call::connectionAnswer': _classPrivateMethodGet$1(this, _onPullEventConnectionAnswer, _onPullEventConnectionAnswer2).bind(this),
	        'Call::iceCandidate': _classPrivateMethodGet$1(this, _onPullEventIceCandidate, _onPullEventIceCandidate2).bind(this),
	        'Call::voiceStarted': _classPrivateMethodGet$1(this, _onPullEventVoiceStarted, _onPullEventVoiceStarted2).bind(this),
	        'Call::voiceStopped': _classPrivateMethodGet$1(this, _onPullEventVoiceStopped, _onPullEventVoiceStopped2).bind(this),
	        'Call::microphoneState': _classPrivateMethodGet$1(this, _onPullEventMicrophoneState, _onPullEventMicrophoneState2).bind(this),
	        'Call::cameraState': _classPrivateMethodGet$1(this, _onPullEventCameraState, _onPullEventCameraState2).bind(this),
	        'Call::videoPaused': _classPrivateMethodGet$1(this, _onPullEventVideoPaused, _onPullEventVideoPaused2).bind(this),
	        'Call::recordState': _classPrivateMethodGet$1(this, _onPullEventRecordState, _onPullEventRecordState2).bind(this),
	        'Call::usersJoined': _classPrivateMethodGet$1(this, _onPullEventUsersJoined, _onPullEventUsersJoined2).bind(this),
	        'Call::usersInvited': _classPrivateMethodGet$1(this, _onPullEventUsersInvited, _onPullEventUsersInvited2).bind(this),
	        'Call::userInviteTimeout': _classPrivateMethodGet$1(this, _onPullEventUserInviteTimeout, _onPullEventUserInviteTimeout2).bind(this),
	        'Call::associatedEntityReplaced': _classPrivateMethodGet$1(this, _onPullEventAssociatedEntityReplaced, _onPullEventAssociatedEntityReplaced2).bind(this),
	        'Call::finish': _classPrivateMethodGet$1(this, _onPullEventFinish, _onPullEventFinish2).bind(this),
	        'Call::repeatAnswer': _classPrivateMethodGet$1(this, _onPullEventRepeatAnswer, _onPullEventRepeatAnswer2).bind(this),
	        'Call::customMessage': _classPrivateMethodGet$1(this, _onPullEventCallCustomMessage, _onPullEventCallCustomMessage2).bind(this)
	      };
	      if (handlers[command]) {
	        if (command === 'Call::ping') {
	          if (params.senderId != this.userId || params.instanceId != this.instanceId) {
	            this.log("Signaling: ping from user " + params.senderId);
	          }
	        } else {
	          this.log("Signaling: " + command + "; Parameters: " + JSON.stringify(params));
	        }
	        handlers[command].call(this, params);
	      }
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.ready = false;
	      var tempError = new Error();
	      tempError.name = "Call stack:";
	      this.log("Call destroy \n" + tempError.stack);

	      // stop sending media streams
	      for (var userId in this.peers) {
	        if (this.peers[userId]) {
	          this.peers[userId].destroy();
	        }
	      }
	      _classPrivateMethodGet$1(this, _beforeLeaveCall, _beforeLeaveCall2).call(this);
	      return babelHelpers.get(babelHelpers.getPrototypeOf(PlainCall.prototype), "destroy", this).call(this);
	    }
	  }, {
	    key: "provider",
	    get: function get() {
	      return Provider.Plain;
	    }
	  }, {
	    key: "isCopilotActive",
	    get: function get() {
	      return this._isCopilotActive;
	    },
	    set: function set(isCopilotActive) {
	      if (isCopilotActive !== this._isCopilotActive) {
	        this._isCopilotActive = isCopilotActive;
	      }
	    }
	  }, {
	    key: "isBoostExpired",
	    get: function get() {
	      return this._isBoostExpired;
	    },
	    set: function set(isBoostExpired) {
	      if (isBoostExpired !== this._isBoostExpired) {
	        this._isBoostExpired = isBoostExpired;
	      }
	    }
	  }, {
	    key: "isCopilotFeaturesEnabled",
	    get: function get() {
	      return this._isCopilotFeaturesEnabled;
	    },
	    set: function set(isCopilotFeaturesEnabled) {
	      if (isCopilotFeaturesEnabled !== this._isCopilotFeaturesEnabled) {
	        this._isCopilotFeaturesEnabled = isCopilotFeaturesEnabled;
	      }
	    }
	  }, {
	    key: "isRecordWhenCopilotActivePopupAlreadyShow",
	    get: function get() {
	      return this._isRecordWhenCopilotActivePopupAlreadyShow;
	    },
	    set: function set(isRecordWhenCopilotActivePopupAlreadyShow) {
	      if (isRecordWhenCopilotActivePopupAlreadyShow !== this._isRecordWhenCopilotActivePopupAlreadyShow) {
	        this._isRecordWhenCopilotActivePopupAlreadyShow = isRecordWhenCopilotActivePopupAlreadyShow;
	      }
	    }
	  }]);
	  return PlainCall;
	}(AbstractCall);
	function _changeRecordState2(params) {
	  if (params.action !== View.RecordState.Started && this.recordState.userId != params.senderId) {
	    return false;
	  }
	  if (params.action === View.RecordState.Started) {
	    if (this.recordState.state !== View.RecordState.Stopped) {
	      return false;
	    }
	    this.recordState.state = View.RecordState.Started;
	    this.recordState.userId = params.senderId;
	    this.recordState.date.start = params.date;
	    this.recordState.date.pause = [];
	  } else if (params.action === View.RecordState.Paused) {
	    if (this.recordState.state !== View.RecordState.Started) {
	      return false;
	    }
	    this.recordState.state = View.RecordState.Paused;
	    this.recordState.date.pause.push({
	      start: params.date,
	      finish: null
	    });
	  } else if (params.action === View.RecordState.Resumed) {
	    if (this.recordState.state !== View.RecordState.Paused) {
	      return false;
	    }
	    this.recordState.state = View.RecordState.Started;
	    var pauseElement = this.recordState.date.pause.find(function (element) {
	      return element.finish === null;
	    });
	    if (pauseElement) {
	      pauseElement.finish = params.date;
	    }
	  } else if (params.action === View.RecordState.Stopped) {
	    this.recordState.state = View.RecordState.Stopped;
	    this.recordState.userId = 0;
	    this.recordState.date.start = null;
	    this.recordState.date.pause = [];
	  }
	  return true;
	}
	function _onPullEventUsersJoined2(params) {
	  if (!this.ready) {
	    return;
	  }
	  var users = params.users;
	  this.addJoinedUsers(users);
	}
	function _onPullEventUsersInvited2(params) {
	  if (!this.ready) {
	    return;
	  }
	  var users = params.users;
	  this.addInvitedUsers(users);
	}
	function _onPullEventUserInviteTimeout2(params) {
	  this.log('__onPullEventUserInviteTimeout', params);
	  var failedUserId = params.failedUserId;
	  if (this.peers[failedUserId]) {
	    this.peers[failedUserId].onInviteTimeout(false);
	  }
	}
	function _onPullEventAnswer2(params) {
	  var senderId = Number(params.senderId);
	  if (senderId == this.userId) {
	    return _classPrivateMethodGet$1(this, _onPullEventAnswerSelf, _onPullEventAnswerSelf2).call(this, params);
	  }
	  if (!this.ready) {
	    return;
	  }
	  if (!this.peers[senderId]) {
	    return;
	  }
	  if (this.peers[senderId].isReady()) {
	    this.log("Received answer for user " + senderId + " in ready state, ignoring");
	    return;
	  }
	  this.peers[senderId].setSignalingConnected(true);
	  this.peers[senderId].setReady(true);
	  this.peers[senderId].isLegacyMobile = params.isLegacyMobile === true;
	  if (this.ready) {
	    this.sendAllStreams(senderId);
	  }
	}
	function _onPullEventAnswerSelf2(params) {
	  this.runCallback('onGetUserMediaEnded', {});
	  if (params.callInstanceId === this.instanceId) {
	    return;
	  }
	  if (this.ready) {
	    this.log("Received remote self-answer in ready state, ignoring");
	    return;
	  }

	  // call was answered elsewhere
	  this.log("Call was answered elsewhere");
	  this.runCallback(CallEvent.onJoin, {
	    local: false
	  });
	}
	function _onPullEventHangup2(params) {
	  var senderId = params.senderId;
	  if (this.userId == senderId) {
	    if (this.instanceId != params.callInstanceId) {
	      // self hangup elsewhere
	      this.runCallback(CallEvent.onLeave, {
	        local: false
	      });
	    }
	    return;
	  }
	  if (!this.peers[senderId]) {
	    return;
	  }
	  this.peers[senderId].disconnect(params.code);
	  this.peers[senderId].setReady(false);
	  if (params.code == 603) {
	    this.peers[senderId].setDeclined(true);
	  }
	  if (!this.isAnyoneParticipating() && this.ready) {
	    this.hangup();
	  }
	}
	function _onPullEventPing2(params) {
	  if (params.callInstanceId == this.instanceId) {
	    // ignore self ping
	    return;
	  }
	  var peer = this.peers[params.senderId];
	  if (!peer) {
	    return;
	  }
	  peer.setSignalingConnected(true);
	}
	function _onPullEventNegotiationNeeded2(params) {
	  if (!this.ready) {
	    return;
	  }
	  var peer = this.peers[params.senderId];
	  if (!peer) {
	    return;
	  }
	  peer.setReady(true);
	  if (params.restart) {
	    peer.reconnect();
	  } else {
	    peer.onNegotiationNeeded();
	  }
	}
	function _onPullEventConnectionOffer2(params) {
	  if (!this.ready) {
	    return;
	  }
	  var peer = this.peers[params.senderId];
	  if (!peer) {
	    return;
	  }
	  peer.setReady(true);
	  peer.setUserAgent(params.userAgent);
	  peer.setConnectionOffer(params.connectionId, params.sdp, params.tracks);
	}
	function _onPullEventConnectionAnswer2(params) {
	  if (!this.ready) {
	    return;
	  }
	  var peer = this.peers[params.senderId];
	  if (!peer) {
	    return;
	  }
	  var connectionId = params.connectionId;
	  peer.setUserAgent(params.userAgent);
	  peer.setConnectionAnswer(connectionId, params.sdp, params.tracks);
	}
	function _onPullEventIceCandidate2(params) {
	  if (!this.ready) {
	    return;
	  }
	  var peer = this.peers[params.senderId];
	  var candidates;
	  if (!peer) {
	    return;
	  }
	  try {
	    candidates = params.candidates;
	    for (var i = 0; i < candidates.length; i++) {
	      peer.addIceCandidate(params.connectionId, candidates[i]);
	    }
	  } catch (e) {
	    this.log('Error parsing serialized candidate: ', e);
	  }
	}
	function _onPullEventVoiceStarted2(params) {
	  this.runCallback(CallEvent.onUserVoiceStarted, {
	    userId: params.senderId
	  });
	}
	function _onPullEventVoiceStopped2(params) {
	  this.runCallback(CallEvent.onUserVoiceStopped, {
	    userId: params.senderId
	  });
	}
	function _onPullEventMicrophoneState2(params) {
	  this.runCallback(CallEvent.onUserMicrophoneState, {
	    userId: params.senderId,
	    microphoneState: params.microphoneState
	  });
	}
	function _onPullEventCameraState2(params) {
	  this.runCallback(CallEvent.onUserCameraState, {
	    userId: params.senderId,
	    cameraState: params.cameraState
	  });
	}
	function _onPullEventVideoPaused2(params) {
	  var peer = this.peers[params.senderId];
	  if (!peer) {
	    return;
	  }
	  this.runCallback(CallEvent.onUserVideoPaused, {
	    userId: params.senderId,
	    videoPaused: params.videoPaused
	  });
	  peer.holdOutgoingVideo(!!params.videoPaused);
	}
	function _onPullEventRecordState2(params) {
	  this.runCallback(CallEvent.onUserRecordState, {
	    userId: params.senderId,
	    recordState: params.recordState
	  });
	}
	function _onPullEventAssociatedEntityReplaced2(params) {
	  if (params.call && params.call.ASSOCIATED_ENTITY) {
	    this.associatedEntity = params.call.ASSOCIATED_ENTITY;
	  }
	}
	function _onPullEventFinish2() {
	  this.destroy();
	}
	function _onPullEventRepeatAnswer2() {
	  if (this.ready) {
	    this.signaling.sendAnswer({
	      userId: this.userId
	    }, true);
	  }
	}
	function _onPullEventCallCustomMessage2(params) {
	  this.runCallback(CallEvent.onCustomMessage, {
	    message: params.message
	  });
	}
	function _onPeerStateChanged2(e) {
	  var _this22 = this;
	  this.runCallback(CallEvent.onUserStateChanged, e);
	  if (e.state == UserState.Failed || e.state == UserState.Unavailable) {
	    if (!this.isAnyoneParticipating()) {
	      this.hangup().then(this.destroy.bind(this))["catch"](function () {
	        //this.runCallback(Event.onCallFailure, e);
	        _this22.destroy();
	      });
	    }
	  } else if (e.state == UserState.Connected) {
	    this.signaling.sendMicrophoneState(e.userId, !Hardware.isMicrophoneMuted);
	    this.signaling.sendCameraState(e.userId, Hardware.isCameraOn);
	    this.wasConnected = true;
	  }
	}
	function _onPeerInviteTimeout2(e) {
	  if (!this.ready) {
	    return;
	  }
	  this.signaling.sendUserInviteTimeout({
	    userId: this.users,
	    failedUserId: e.userId
	  });
	}
	function _onPeerRTCStatsReceived2(e) {
	  var remoteReportsToShow = {};
	  var localReportsToShow = {};
	  e.stats.forEach(function (report) {
	    if (report.type === 'inbound-rtp' && (report.kind === 'video' || report.kind === 'audio') && report.source) {
	      remoteReportsToShow[report.source] = report;
	    }
	    if (report.type === 'outbound-rtp' && (report.kind === 'video' || report.kind === 'audio') && report.source) {
	      localReportsToShow[report.source] = report;
	    }
	  });
	  this.runCallback(CallEvent.onUserStatsReceived, {
	    userId: e.userId,
	    report: remoteReportsToShow
	  });
	  this.runCallback(CallEvent.onUserStatsReceived, {
	    userId: this.userId,
	    report: localReportsToShow
	  });
	  this.runCallback(CallEvent.onRTCStatsReceived, e);
	}
	function _onPeerRTCQualityChanged2(e) {
	  this.runCallback(CallEvent.onConnectionQualityChanged, {
	    userId: e.userId,
	    score: e.score
	  });
	}
	function _onUnload2() {
	  if (!this.ready) {
	    return;
	  }
	  CallEngine.getRestClient().callMethod(ajaxActions.hangup, {
	    callId: this.id,
	    callInstanceId: this.instanceId
	  });
	  for (var userId in this.peers) {
	    this.peers[userId].disconnect();
	  }
	}
	function _beforeLeaveCall2() {
	  // stop media streams
	  this.unsubscribeHardwareChanges();
	  for (var tag in this.localStreams) {
	    if (this.localStreams[tag]) {
	      Util.stopMediaStream(this.localStreams[tag]);
	      this.localStreams[tag] = null;
	    }
	  }
	  if (this.prevMainStream) {
	    Util.stopMediaStream(this.prevMainStream);
	    this.prevMainStream = null;
	  }
	  if (this.voiceDetection) {
	    this.voiceDetection.destroy();
	    this.voiceDetection = null;
	  }

	  // remove all event listeners
	  window.removeEventListener("unload", this._onUnloadHandler);
	  clearInterval(this.statsInterval);
	  clearInterval(this.pingUsersInterval);
	  clearInterval(this.pingBackendInterval);
	  clearInterval(this.microphoneLevelInterval);
	  clearTimeout(this.reinviteTimeout);
	}
	var _sendPullEvent = /*#__PURE__*/new WeakSet();
	var _runRestAction = /*#__PURE__*/new WeakSet();
	var Signaling = /*#__PURE__*/function () {
	  function Signaling(params) {
	    babelHelpers.classCallCheck(this, Signaling);
	    _classPrivateMethodInitSpec$1(this, _runRestAction);
	    _classPrivateMethodInitSpec$1(this, _sendPullEvent);
	    this.call = params.call;
	  }
	  babelHelpers.createClass(Signaling, [{
	    key: "isIceTricklingAllowed",
	    value: function isIceTricklingAllowed() {
	      return CallEngine.getPullClient().isPublishingSupported();
	    }
	  }, {
	    key: "inviteUsers",
	    value: function inviteUsers(data) {
	      return _classPrivateMethodGet$1(this, _runRestAction, _runRestAction2).call(this, ajaxActions.invite, data);
	    }
	  }, {
	    key: "sendAnswer",
	    value: function sendAnswer(data, repeated) {
	      if (repeated && CallEngine.getPullClient().isPublishingSupported()) {
	        return _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.answer, data);
	      } else {
	        return _classPrivateMethodGet$1(this, _runRestAction, _runRestAction2).call(this, ajaxActions.answer, data);
	      }
	    }
	  }, {
	    key: "sendConnectionOffer",
	    value: function sendConnectionOffer(data) {
	      if (CallEngine.getPullClient().isPublishingSupported()) {
	        return _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.connectionOffer, data);
	      } else {
	        return _classPrivateMethodGet$1(this, _runRestAction, _runRestAction2).call(this, ajaxActions.connectionOffer, data);
	      }
	    }
	  }, {
	    key: "sendConnectionAnswer",
	    value: function sendConnectionAnswer(data) {
	      if (CallEngine.getPullClient().isPublishingSupported()) {
	        return _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.connectionAnswer, data);
	      } else {
	        return _classPrivateMethodGet$1(this, _runRestAction, _runRestAction2).call(this, ajaxActions.connectionAnswer, data);
	      }
	    }
	  }, {
	    key: "sendIceCandidate",
	    value: function sendIceCandidate(data) {
	      if (CallEngine.getPullClient().isPublishingSupported()) {
	        return _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.iceCandidate, data);
	      } else {
	        return _classPrivateMethodGet$1(this, _runRestAction, _runRestAction2).call(this, ajaxActions.iceCandidate, data);
	      }
	    }
	  }, {
	    key: "sendNegotiationNeeded",
	    value: function sendNegotiationNeeded(data) {
	      if (CallEngine.getPullClient().isPublishingSupported()) {
	        return _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.negotiationNeeded, data);
	      } else {
	        return _classPrivateMethodGet$1(this, _runRestAction, _runRestAction2).call(this, ajaxActions.negotiationNeeded, data);
	      }
	    }
	  }, {
	    key: "sendVoiceStarted",
	    value: function sendVoiceStarted(data) {
	      if (CallEngine.getPullClient().isPublishingSupported()) {
	        return _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.voiceStarted, data);
	      }
	    }
	  }, {
	    key: "sendVoiceStopped",
	    value: function sendVoiceStopped(data) {
	      if (CallEngine.getPullClient().isPublishingSupported()) {
	        return _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.voiceStopped, data);
	      }
	    }
	  }, {
	    key: "sendMicrophoneState",
	    value: function sendMicrophoneState(users, microphoneState) {
	      if (CallEngine.getPullClient().isPublishingSupported()) {
	        return _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.microphoneState, {
	          userId: users,
	          microphoneState: microphoneState
	        }, 0);
	      }
	    }
	  }, {
	    key: "sendCameraState",
	    value: function sendCameraState(users, cameraState) {
	      if (CallEngine.getPullClient().isPublishingSupported()) {
	        return _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.cameraState, {
	          userId: users,
	          cameraState: cameraState
	        }, 0);
	      }
	    }
	  }, {
	    key: "sendVideoPaused",
	    value: function sendVideoPaused(users, videoPaused) {
	      if (CallEngine.getPullClient().isPublishingSupported()) {
	        return _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.videoPaused, {
	          userId: users,
	          videoPaused: videoPaused
	        }, 0);
	      }
	    }
	  }, {
	    key: "sendRecordState",
	    value: function sendRecordState(users, recordState) {
	      if (CallEngine.getPullClient().isPublishingSupported()) {
	        return _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.recordState, {
	          userId: users,
	          recordState: recordState
	        }, 0);
	      }
	    }
	  }, {
	    key: "sendPingToUsers",
	    value: function sendPingToUsers(data) {
	      if (CallEngine.getPullClient().isPublishingEnabled()) {
	        _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.ping, data, 5);
	      }
	    }
	  }, {
	    key: "sendCustomMessage",
	    value: function sendCustomMessage(data) {
	      if (CallEngine.getPullClient().isPublishingEnabled()) {
	        _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.customMessage, data, 5);
	      }
	    }
	  }, {
	    key: "sendPingToBackend",
	    value: function sendPingToBackend() {
	      var retransmit = !CallEngine.getPullClient().isPublishingEnabled();
	      _classPrivateMethodGet$1(this, _runRestAction, _runRestAction2).call(this, ajaxActions.ping, {
	        retransmit: retransmit
	      });
	    }
	  }, {
	    key: "sendUserInviteTimeout",
	    value: function sendUserInviteTimeout(data) {
	      if (CallEngine.getPullClient().isPublishingEnabled()) {
	        _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.userInviteTimeout, data, 0);
	      }
	    }
	  }, {
	    key: "sendHangup",
	    value: function sendHangup(data) {
	      if (CallEngine.getPullClient().isPublishingSupported()) {
	        _classPrivateMethodGet$1(this, _sendPullEvent, _sendPullEvent2).call(this, pullEvents.hangup, data, 3600);
	        data.retransmit = false;
	        return _classPrivateMethodGet$1(this, _runRestAction, _runRestAction2).call(this, ajaxActions.hangup, data);
	      } else {
	        data.retransmit = true;
	        return _classPrivateMethodGet$1(this, _runRestAction, _runRestAction2).call(this, ajaxActions.hangup, data);
	      }
	    }
	  }]);
	  return Signaling;
	}();
	function _sendPullEvent2(eventName, data, expiry) {
	  expiry = expiry || 5;
	  if (!data.userId) {
	    throw new Error('userId is not found in data');
	  }
	  if (!main_core.Type.isArray(data.userId)) {
	    data.userId = [data.userId];
	  }
	  data.callInstanceId = this.call.instanceId;
	  data.senderId = this.call.userId;
	  data.callId = this.call.id;
	  data.requestId = Util.getUuidv4();
	  if (eventName == 'Call::ping') {
	    this.call.log('Sending p2p signaling event ' + eventName);
	  } else {
	    this.call.log('Sending p2p signaling event ' + eventName + '; ' + JSON.stringify(data));
	  }
	  CallEngine.getPullClient().sendMessage(data.userId, 'im', eventName, data, expiry);
	}
	function _runRestAction2(signalName, data) {
	  if (!main_core.Type.isPlainObject(data)) {
	    data = {};
	  }
	  data.callId = this.call.id;
	  data.callInstanceId = this.call.instanceId;
	  data.requestId = Util.getUuidv4();
	  if (signalName == 'Call::ping') {
	    this.call.log('Sending ajax-based signaling event ' + signalName);
	  } else {
	    this.call.log('Sending ajax-based signaling event ' + signalName + '; ' + JSON.stringify(data));
	  }
	  return CallEngine.getRestClient().callMethod(signalName, data)["catch"](function (e) {
	    console.error(e);
	  });
	}
	var _createPeerConnection$1 = /*#__PURE__*/new WeakSet();
	var _onPeerConnectionConnectionStateChange = /*#__PURE__*/new WeakSet();
	var _onPeerConnectionIceGatheringStateChange = /*#__PURE__*/new WeakSet();
	var _onPeerConnectionSignalingStateChange = /*#__PURE__*/new WeakSet();
	var _onPeerConnectionNegotiationNeeded = /*#__PURE__*/new WeakSet();
	var _onPeerConnectionTrack = /*#__PURE__*/new WeakSet();
	var _onPeerConnectionRemoveStream = /*#__PURE__*/new WeakSet();
	var _onVideoTrackMuted = /*#__PURE__*/new WeakSet();
	var _onVideoTrackUnMuted = /*#__PURE__*/new WeakSet();
	var _onVideoTrackEnded = /*#__PURE__*/new WeakSet();
	var _updateTracks = /*#__PURE__*/new WeakSet();
	var _onLostSignalingConnection = /*#__PURE__*/new WeakSet();
	var Peer = /*#__PURE__*/function () {
	  function Peer(params) {
	    babelHelpers.classCallCheck(this, Peer);
	    _classPrivateMethodInitSpec$1(this, _onLostSignalingConnection);
	    _classPrivateMethodInitSpec$1(this, _updateTracks);
	    _classPrivateMethodInitSpec$1(this, _onVideoTrackEnded);
	    _classPrivateMethodInitSpec$1(this, _onVideoTrackUnMuted);
	    _classPrivateMethodInitSpec$1(this, _onVideoTrackMuted);
	    _classPrivateMethodInitSpec$1(this, _onPeerConnectionRemoveStream);
	    _classPrivateMethodInitSpec$1(this, _onPeerConnectionTrack);
	    _classPrivateMethodInitSpec$1(this, _onPeerConnectionNegotiationNeeded);
	    _classPrivateMethodInitSpec$1(this, _onPeerConnectionSignalingStateChange);
	    _classPrivateMethodInitSpec$1(this, _onPeerConnectionIceGatheringStateChange);
	    _classPrivateMethodInitSpec$1(this, _onPeerConnectionConnectionStateChange);
	    _classPrivateMethodInitSpec$1(this, _createPeerConnection$1);
	    this.call = params.call;
	    this.userId = params.userId;
	    this.ready = params.ready === true;
	    this.calling = false;
	    this.inviteTimeout = false;
	    this.declined = false;
	    this.busy = false;
	    this.signalingConnected = params.signalingConnected === true;
	    this.failureReason = '';
	    this.userAgent = '';
	    this.isFirefox = false;
	    this.isChrome = false;
	    this.isLegacyMobile = params.isLegacyMobile === true;

	    /*sums up from signaling, ready and connection states*/
	    this.calculatedState = this.calculateState();
	    this.localStreams = {
	      main: null,
	      screen: null
	    };
	    this.pendingIceCandidates = {};
	    this.localIceCandidates = [];
	    this.trackList = {};
	    this.callbacks = {
	      onStateChanged: main_core.Type.isFunction(params.onStateChanged) ? params.onStateChanged : BX.DoNothing,
	      onInviteTimeout: main_core.Type.isFunction(params.onInviteTimeout) ? params.onInviteTimeout : BX.DoNothing,
	      onMediaReceived: main_core.Type.isFunction(params.onMediaReceived) ? params.onMediaReceived : BX.DoNothing,
	      onMediaStopped: main_core.Type.isFunction(params.onMediaStopped) ? params.onMediaStopped : BX.DoNothing,
	      onRTCStatsReceived: main_core.Type.isFunction(params.onRTCStatsReceived) ? params.onRTCStatsReceived : BX.DoNothing,
	      onRTCQualityChanged: main_core.Type.isFunction(params.onRTCQualityChanged) ? params.onRTCQualityChanged : BX.DoNothing,
	      onNetworkProblem: main_core.Type.isFunction(params.onNetworkProblem) ? params.onNetworkProblem : BX.DoNothing,
	      onReconnecting: main_core.Type.isFunction(params.onReconnecting) ? params.onReconnecting : BX.DoNothing,
	      onReconnected: main_core.Type.isFunction(params.onReconnected) ? params.onReconnected : BX.DoNothing,
	      onUpdateLastUsedCameraId: main_core.Type.isFunction(params.onUpdateLastUsedCameraId) ? params.onUpdateLastUsedCameraId : BX.DoNothing
	    };

	    // intervals and timeouts
	    this.answerTimeout = null;
	    this.callingTimeout = null;
	    this.connectionTimeout = null;
	    this.signalingConnectionTimeout = null;
	    this.candidatesTimeout = null;
	    this.statsInterval = null;
	    this.connectionOfferReplyTimeout = null;
	    this.negotiationNeededReplyTimeout = null;
	    this.reconnectAfterDisconnectTimeout = null;
	    this.connectionAttempt = 0;
	    this.hasStun = false;
	    this.hasTurn = false;
	    this._outgoingVideoTrack = null;
	    Object.defineProperty(this, 'outgoingVideoTrack', {
	      get: function get() {
	        return this._outgoingVideoTrack;
	      },
	      set: function set(track) {
	        if (this._outgoingVideoTrack) {
	          this._outgoingVideoTrack.stop();
	        }
	        this._outgoingVideoTrack = track;
	        if (this._outgoingVideoTrack) {
	          this._outgoingVideoTrack.enabled = !this.outgoingVideoHoldState;
	        }
	      }
	    });
	    this._outgoingScreenTrack = null;
	    Object.defineProperty(this, 'outgoingScreenTrack', {
	      get: function get() {
	        return this._outgoingScreenTrack;
	      },
	      set: function set(track) {
	        if (this._outgoingScreenTrack) {
	          this._outgoingScreenTrack.stop();
	        }
	        this._outgoingScreenTrack = track;
	        if (this._outgoingScreenTrack) {
	          this._outgoingScreenTrack.enabled = !this.outgoingVideoHoldState;
	        }
	      }
	    });
	    this._incomingAudioTrack = null;
	    this._incomingScreenAudioTrack = null;
	    this._incomingVideoTrack = null;
	    this._incomingScreenTrack = null;
	    Object.defineProperty(this, 'incomingAudioTrack', {
	      get: this._mediaGetter('_incomingAudioTrack'),
	      set: this._mediaSetter('_incomingAudioTrack', 'audio')
	    });
	    Object.defineProperty(this, 'incomingVideoTrack', {
	      get: this._mediaGetter('_incomingVideoTrack'),
	      set: this._mediaSetter('_incomingVideoTrack', 'video')
	    });
	    Object.defineProperty(this, 'incomingScreenTrack', {
	      get: this._mediaGetter('_incomingScreenTrack'),
	      set: this._mediaSetter('_incomingScreenTrack', 'screen')
	    });
	    Object.defineProperty(this, 'incomingScreenAudioTrack', {
	      get: this._mediaGetter('_incomingScreenAudioTrack'),
	      set: this._mediaSetter('_incomingScreenAudioTrack', 'sharingAudio')
	    });
	    this.outgoingVideoHoldState = false;

	    // event handlers
	    this._onPeerConnectionIceCandidateHandler = this._onPeerConnectionIceCandidate.bind(this);
	    this._onPeerConnectionConnectionStateChangeHandler = _classPrivateMethodGet$1(this, _onPeerConnectionConnectionStateChange, _onPeerConnectionConnectionStateChange2).bind(this);
	    this._onPeerConnectionIceGatheringStateChangeHandler = _classPrivateMethodGet$1(this, _onPeerConnectionIceGatheringStateChange, _onPeerConnectionIceGatheringStateChange2).bind(this);
	    this._onPeerConnectionSignalingStateChangeHandler = _classPrivateMethodGet$1(this, _onPeerConnectionSignalingStateChange, _onPeerConnectionSignalingStateChange2).bind(this);
	    //this._onPeerConnectionNegotiationNeededHandler = this._onPeerConnectionNegotiationNeeded.bind(this);
	    this._onPeerConnectionTrackHandler = _classPrivateMethodGet$1(this, _onPeerConnectionTrack, _onPeerConnectionTrack2).bind(this);
	    this._onPeerConnectionRemoveStreamHandler = _classPrivateMethodGet$1(this, _onPeerConnectionRemoveStream, _onPeerConnectionRemoveStream2).bind(this);
	    this._updateTracksDebounced = main_core.Runtime.debounce(_classPrivateMethodGet$1(this, _updateTracks, _updateTracks2).bind(this), 50);
	    this._waitTurnCandidatesTimeout = null;
	    this.prevPercentPacketLostList = {
	      incomingPacketLost: [],
	      outgoingPacketLost: []
	    };
	    this.reportsForIncomingTracks = {};
	    this.reportsForOutgoingTracks = {};
	    this.packetLostThreshold = 7;
	    this.videoBitrate = 1000000;
	    this.screenShareBitrate = 1500000;
	    this.maxConnectionScore = 5;
	    this.incomingConnectionScore = 0;
	    this.outgoingConnectionScore = 0;
	  }
	  babelHelpers.createClass(Peer, [{
	    key: "_mediaGetter",
	    value: function _mediaGetter(trackVariable) {
	      return function () {
	        return this[trackVariable];
	      }.bind(this);
	    }
	  }, {
	    key: "_mediaSetter",
	    value: function _mediaSetter(trackVariable, kind) {
	      return function (track) {
	        if (this[trackVariable] != track) {
	          this[trackVariable] = track;
	          if (track) {
	            this.callbacks.onMediaReceived({
	              userId: this.userId,
	              kind: kind,
	              track: track
	            });
	          } else {
	            this.callbacks.onMediaStopped({
	              userId: this.userId,
	              kind: kind
	            });
	          }
	        }
	      }.bind(this);
	    }
	  }, {
	    key: "sendMedia",
	    value: function sendMedia(skipOffer) {
	      if (!this.peerConnection) {
	        if (!this.isInitiator()) {
	          this.log('waiting for the other side to send connection offer');
	          this.sendNegotiationNeeded(false);
	          return;
	        }
	      }
	      if (!this.peerConnection) {
	        var connectionId = Util.getUuidv4();
	        _classPrivateMethodGet$1(this, _createPeerConnection$1, _createPeerConnection2$1).call(this, connectionId);
	      }
	      this.updateOutgoingTracks();
	      if (!skipOffer) {
	        this.applyResolutionScale();
	        this.createAndSendOffer();
	      }
	    }
	  }, {
	    key: "updateOutgoingTracks",
	    value: function updateOutgoingTracks() {
	      var _this$call$localStrea, _this$call$localStrea2;
	      if (!this.peerConnection) {
	        return;
	      }
	      var audioTrack;
	      var videoTrack;
	      var screenTrack;
	      var screenAudioTrack;
	      if (this.call.localStreams["main"] && this.call.localStreams["main"].getAudioTracks().length > 0 && ((_this$call$localStrea = this.call.localStreams["main"].getAudioTracks()[0]) === null || _this$call$localStrea === void 0 ? void 0 : _this$call$localStrea.readyState) === 'live') {
	        audioTrack = this.call.localStreams["main"].getAudioTracks()[0];
	      }
	      if (this.call.localStreams["screen"] && this.call.localStreams["screen"].getVideoTracks().length > 0) {
	        screenTrack = this.call.localStreams["screen"].getVideoTracks()[0];
	      }
	      if (this.call.localStreams["screen"] && this.call.localStreams["screen"].getAudioTracks().length > 0) {
	        screenAudioTrack = this.call.localStreams["screen"].getAudioTracks()[0];
	      }
	      if (this.call.localStreams["main"] && this.call.localStreams["main"].getVideoTracks().length > 0 && ((_this$call$localStrea2 = this.call.localStreams["main"].getVideoTracks()[0]) === null || _this$call$localStrea2 === void 0 ? void 0 : _this$call$localStrea2.readyState) === 'live') {
	        videoTrack = this.call.localStreams["main"].getVideoTracks()[0];
	      }
	      this.outgoingVideoTrack = videoTrack ? videoTrack.clone() : null;
	      this.outgoingScreenTrack = screenTrack ? screenTrack.clone() : null;
	      var tracksToSend = [];
	      if (audioTrack) {
	        tracksToSend.push(audioTrack.id + ' (audio)');
	      }
	      if (screenAudioTrack) {
	        tracksToSend.push(screenAudioTrack.id + ' (sharingAudio)');
	      }
	      if (videoTrack) {
	        tracksToSend.push(videoTrack.id + ' (' + videoTrack.kind + ')');
	      }
	      if (screenTrack) {
	        tracksToSend.push(screenTrack.id + ' (' + screenTrack.kind + ')');
	      }
	      console.log("User: " + this.userId + '; Sending media streams. Tracks: ' + tracksToSend.join('; '));

	      // if video sender found - replace track
	      // if not found - add track
	      if (this.videoSender && this.outgoingVideoTrack) {
	        this.videoSender.replaceTrack(this.outgoingVideoTrack);
	      }
	      if (!this.videoSender && this.outgoingVideoTrack) {
	        this.videoSender = this.peerConnection.addTrack(this.outgoingVideoTrack);
	      }
	      if (this.videoSender && !this.outgoingVideoTrack) {
	        this.peerConnection.removeTrack(this.videoSender);
	        this.videoSender = null;
	      }

	      // if screen sender found - replace track
	      // if not found - add track
	      if (this.screenSender && this.outgoingScreenTrack) {
	        this.screenSender.replaceTrack(this.outgoingScreenTrack);
	      }
	      if (!this.screenSender && this.outgoingScreenTrack) {
	        this.screenSender = this.peerConnection.addTrack(this.outgoingScreenTrack);
	      }
	      if (this.screenSender && !this.outgoingScreenTrack) {
	        this.peerConnection.removeTrack(this.screenSender);
	        this.screenSender = null;
	      }

	      // if screen sender audio found - replace track
	      // if not found - add track
	      if (this.screenAudioSender && screenAudioTrack) {
	        this.screenAudioSender.replaceTrack(screenAudioTrack);
	      }
	      if (!this.screenAudioSender && screenAudioTrack) {
	        this.screenAudioSender = this.peerConnection.addTrack(screenAudioTrack);
	      }
	      if (this.screenAudioSender && !screenAudioTrack) {
	        this.peerConnection.removeTrack(this.screenAudioSender);
	        this.screenAudioSender = null;
	      }

	      // if audio sender found - replace track
	      // if not found - add track
	      if (this.audioSender && audioTrack) {
	        this.audioSender.replaceTrack(audioTrack);
	      }
	      if (!this.audioSender && audioTrack) {
	        this.audioSender = this.peerConnection.addTrack(audioTrack);
	      }
	      if (this.audioSender && !audioTrack) {
	        this.peerConnection.removeTrack(this.audioSender);
	        this.audioSender = null;
	      }
	    }
	  }, {
	    key: "getSenderMid",
	    value: function getSenderMid(rtpSender) {
	      if (!rtpSender || !this.peerConnection) {
	        return null;
	      }
	      var transceiver = this.peerConnection.getTransceivers().find(function (transceiver) {
	        if (transceiver.sender.track && rtpSender.track) {
	          return transceiver.sender.track.id === rtpSender.track.id;
	        }
	        return false;
	      });
	      return transceiver ? transceiver.mid : null;
	    }
	  }, {
	    key: "applyResolutionScale",
	    value: function applyResolutionScale(factor) {
	      if (this.videoSender) {
	        var scaleFactor = factor || (this.screenSender ? 2 : 1);
	        var rate = this.videoBitrate / scaleFactor;
	        var videoParams = this.videoSender.getParameters();
	        if (videoParams.encodings && videoParams.encodings.length > 0) {
	          videoParams.encodings[0].scaleResolutionDownBy = scaleFactor;
	          videoParams.encodings[0].maxBitrate = rate;
	          this.videoSender.setParameters(videoParams);
	        }
	      }
	      if (this.screenSender) {
	        var screenParams = this.screenSender.getParameters();
	        if (screenParams.encodings && screenParams.encodings.length > 0) {
	          screenParams.encodings[0].maxBitrate = this.screenShareBitrate;
	          this.screenSender.setParameters(screenParams);
	        }
	      }
	    }
	  }, {
	    key: "replaceMediaStream",
	    value: function replaceMediaStream(tag) {
	      if (this.isRenegotiationSupported()) {
	        this.sendMedia();
	      } else {
	        this.localStreams[tag] = this.call.getLocalStream(tag);
	        this.reconnect();
	      }
	    }
	  }, {
	    key: "holdOutgoingVideo",
	    value: function holdOutgoingVideo(holdState) {
	      if (this.outgoingVideoHoldState == holdState) {
	        return;
	      }
	      this.outgoingVideoHoldState = holdState;
	      if (this._outgoingVideoTrack) {
	        this._outgoingVideoTrack.enabled = !this.outgoingVideoHoldState;
	      }
	    }
	  }, {
	    key: "isInitiator",
	    value: function isInitiator() {
	      return this.call.userId < this.userId;
	    }
	  }, {
	    key: "isRenegotiationSupported",
	    value: function isRenegotiationSupported() {
	      return true;
	      // return (Browser.isChrome() && this.isChrome);
	    }
	  }, {
	    key: "setReady",
	    value: function setReady(ready) {
	      this.ready = ready;
	      if (this.ready) {
	        this.declined = false;
	        this.busy = false;
	      }
	      if (this.calling) {
	        clearTimeout(this.callingTimeout);
	        this.calling = false;
	      }
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "isReady",
	    value: function isReady() {
	      return this.ready;
	    }
	  }, {
	    key: "onInvited",
	    value: function onInvited() {
	      this.ready = false;
	      this.inviteTimeout = false;
	      this.declined = false;
	      this.calling = true;
	      if (this.callingTimeout) {
	        clearTimeout(this.callingTimeout);
	      }
	      this.callingTimeout = setTimeout(function () {
	        this.onInviteTimeout(true);
	      }.bind(this), 30000);
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "onInviteTimeout",
	    value: function onInviteTimeout(internal) {
	      clearTimeout(this.callingTimeout);
	      this.calling = false;
	      this.inviteTimeout = true;
	      if (internal) {
	        this.callbacks.onInviteTimeout({
	          userId: this.userId
	        });
	      }
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "setUserAgent",
	    value: function setUserAgent(userAgent) {
	      this.userAgent = userAgent;
	      this.isFirefox = userAgent.toLowerCase().indexOf('firefox') != -1;
	      this.isChrome = userAgent.toLowerCase().indexOf('chrome') != -1;
	      this.isLegacyMobile = userAgent === 'Bitrix Legacy Mobile';
	    }
	  }, {
	    key: "getUserAgent",
	    value: function getUserAgent() {
	      return this.userAgent;
	    }
	  }, {
	    key: "isParticipating",
	    value: function isParticipating() {
	      if (this.calling) {
	        return true;
	      }
	      if (this.declined || this.busy) {
	        return false;
	      }
	      if (this.peerConnection) {
	        // todo: maybe we should check iceConnectionState as well.
	        var iceConnectionState = this.peerConnection.iceConnectionState;
	        if (iceConnectionState == 'checking' || iceConnectionState == 'connected' || iceConnectionState == 'completed') {
	          return true;
	        }
	      }
	      return false;
	    }
	  }, {
	    key: "setSignalingConnected",
	    value: function setSignalingConnected(signalingConnected) {
	      this.signalingConnected = signalingConnected;
	      this.updateCalculatedState();
	      if (this.signalingConnected) {
	        this.refreshSignalingTimeout();
	      } else {
	        this.stopSignalingTimeout();
	      }
	    }
	  }, {
	    key: "isSignalingConnected",
	    value: function isSignalingConnected() {
	      return this.signalingConnected;
	    }
	  }, {
	    key: "setDeclined",
	    value: function setDeclined(declined) {
	      this.declined = declined;
	      if (this.calling) {
	        clearTimeout(this.callingTimeout);
	        this.calling = false;
	      }
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "setBusy",
	    value: function setBusy(busy) {
	      this.busy = busy;
	      if (this.calling) {
	        clearTimeout(this.callingTimeout);
	        this.calling = false;
	      }
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "isDeclined",
	    value: function isDeclined() {
	      return this.declined;
	    }
	  }, {
	    key: "updateCalculatedState",
	    value: function updateCalculatedState() {
	      var calculatedState = this.calculateState();
	      if (this.calculatedState != calculatedState) {
	        this.callbacks.onStateChanged({
	          userId: this.userId,
	          state: calculatedState,
	          previousState: this.calculatedState,
	          isLegacyMobile: this.isLegacyMobile,
	          networkProblem: !this.hasStun || !this.hasTurn
	        });
	        this.calculatedState = calculatedState;
	      }
	    }
	  }, {
	    key: "calculateState",
	    value: function calculateState() {
	      if (this.peerConnection) {
	        if (this.failureReason !== '') {
	          return UserState.Failed;
	        }
	        if (this.peerConnection.iceConnectionState === 'connected' || this.peerConnection.iceConnectionState === 'completed') {
	          return UserState.Connected;
	        }
	        return UserState.Connecting;
	      }
	      if (this.calling) {
	        return UserState.Calling;
	      }
	      if (this.inviteTimeout) {
	        return UserState.Unavailable;
	      }
	      if (this.declined) {
	        return UserState.Declined;
	      }
	      if (this.busy) {
	        return UserState.Busy;
	      }
	      if (this.ready) {
	        return UserState.Ready;
	      }
	      return UserState.Idle;
	    }
	  }, {
	    key: "getSignaling",
	    value: function getSignaling() {
	      return this.call.signaling;
	    }
	  }, {
	    key: "startStatisticsGathering",
	    value: function startStatisticsGathering() {
	      clearInterval(this.statsInterval);
	      this.statsInterval = setInterval(function () {
	        if (!this.peerConnection) {
	          return false;
	        }
	        this.peerConnection.getStats().then(function (stats) {
	          var _this14 = this;
	          // stats gathering in new format like in the Bitrix24 calls
	          var statsOutput = [];
	          var codecs = {};
	          var reportsWithoutCodecs = {};
	          var remoteReports = {};
	          var reportsWithoutRemoteInfo = {};
	          var incomingDataLoss = 0;
	          var outgoingDataLoss = 0;
	          stats.forEach(function (report) {
	            statsOutput.push(report);
	            var needCheckInputPacketLost = (report === null || report === void 0 ? void 0 : report.trackIdentifier) && (report === null || report === void 0 ? void 0 : report.type) === 'inbound-rtp' && report.hasOwnProperty('packetsLost') && report.hasOwnProperty('packetsReceived');
	            if (needCheckInputPacketLost || report.type === 'outbound-rtp') {
	              switch (_this14.trackList[report.mid]) {
	                case 'video':
	                  report.source = MediaStreamsKinds.Camera;
	                  break;
	                case 'screen':
	                  report.source = MediaStreamsKinds.Screen;
	                  break;
	                case 'audio':
	                  report.source = MediaStreamsKinds.Microphone;
	                  break;
	                default:
	                  return;
	              }
	            }
	            if (needCheckInputPacketLost) {
	              report.bitrate = Util.calcBitrate(report, _this14.reportsForIncomingTracks[report.source]);
	              var packetsLostData = Util.calcRemotePacketsLost(report, _this14.reportsForIncomingTracks[report.source]);
	              report.packetsLostExtended = Util.formatPacketsLostData(packetsLostData);
	              if (!Util.setCodecToReport(report, codecs, reportsWithoutCodecs)) {
	                Util.saveReportWithoutCodecs(report, reportsWithoutCodecs);
	              }
	              _this14.reportsForIncomingTracks[report.source] = report;
	              if (report.source === MediaStreamsKinds.Camera) {
	                incomingDataLoss = packetsLostData.currentPercentPacketLost;
	              }
	            }
	            if (report.type === 'codec') {
	              Util.processReportsWithoutCodecs(report, codecs, reportsWithoutCodecs);
	            }
	            if (report.type === 'remote-inbound-rtp') {
	              var reportId = report.localId;
	              if (reportsWithoutRemoteInfo[reportId]) {
	                var _packetsLostData = Util.calcLocalPacketsLost(reportsWithoutRemoteInfo[reportId], _this14.reportsForOutgoingTracks[reportId], report);
	                reportsWithoutRemoteInfo[reportId].packetsLostData = _packetsLostData;
	                reportsWithoutRemoteInfo[reportId].packetsLost = _packetsLostData.totalPacketsLost;
	                reportsWithoutRemoteInfo[reportId].packetsLostExtended = Util.formatPacketsLostData(_packetsLostData);
	                _this14.reportsForOutgoingTracks[reportId] = reportsWithoutRemoteInfo[reportId];
	                delete reportsWithoutRemoteInfo[reportId];
	                if (_this14.reportsForOutgoingTracks[reportId].source === MediaStreamsKinds.Camera) {
	                  outgoingDataLoss = report.packetsLost;
	                }
	                return;
	              }
	              remoteReports[reportId] = report;
	            }
	            if (report.type === 'outbound-rtp') {
	              report.bitrate = Util.calcBitrate(report, _this14.reportsForOutgoingTracks[report.id], true);
	              report.userId = _this14.call.userId;
	              if (!Util.setCodecToReport(report, codecs, reportsWithoutCodecs)) {
	                Util.saveReportWithoutCodecs(report, reportsWithoutCodecs);
	              }
	              if (Util.setLocalPacketsLostOrSaveReport(report, remoteReports, reportsWithoutRemoteInfo)) {
	                _this14.reportsForOutgoingTracks[report.id] = report;
	                if (report.source === MediaStreamsKinds.Camera) {
	                  outgoingDataLoss = report.packetsLostData.currentPercentPacketLost;
	                }
	              }
	            }
	          });
	          if (this.prevPercentPacketLostList.incomingPacketLost.push(incomingDataLoss) > 10) {
	            this.prevPercentPacketLostList.incomingPacketLost.shift();
	          }
	          var newIncomingConnectionDataLoss = this.prevPercentPacketLostList.incomingPacketLost.reduce(function (acc, number) {
	            return acc + number;
	          }, 0) / this.prevPercentPacketLostList.incomingPacketLost.length;
	          var newIncomingConnectionScore = this.calcNewConnectionScore(newIncomingConnectionDataLoss);
	          if (!this.incomingConnectionScore || this.incomingConnectionScore !== newIncomingConnectionScore) {
	            this.incomingConnectionScore = newIncomingConnectionScore;
	            this.callbacks.onRTCQualityChanged({
	              userId: this.userId,
	              score: this.incomingConnectionScore
	            });
	          }
	          if (this.prevPercentPacketLostList.outgoingPacketLost.push(outgoingDataLoss) > 10) {
	            this.prevPercentPacketLostList.outgoingPacketLost.shift();
	          }
	          var newOutgoingConnectionDataLoss = this.prevPercentPacketLostList.outgoingPacketLost.reduce(function (acc, number) {
	            return acc + number;
	          }, 0) / this.prevPercentPacketLostList.outgoingPacketLost.length;
	          var newOutgoingConnectionScore = this.calcNewConnectionScore(newOutgoingConnectionDataLoss);
	          if (!this.outgoingConnectionScore || this.outgoingConnectionScore !== newOutgoingConnectionScore) {
	            this.outgoingConnectionScore = newOutgoingConnectionScore;
	            this.callbacks.onRTCQualityChanged({
	              userId: this.call.userId,
	              score: this.outgoingConnectionScore
	            });
	          }
	          this.callbacks.onRTCStatsReceived({
	            userId: this.userId,
	            stats: statsOutput
	          });
	        }.bind(this));
	      }.bind(this), 1000);
	    }
	  }, {
	    key: "calcNewConnectionScore",
	    value: function calcNewConnectionScore(dataLoss) {
	      var connectionQuality;
	      if (dataLoss < 10) {
	        connectionQuality = 4;
	      }
	      if (dataLoss > 10 && dataLoss <= 20) {
	        connectionQuality = 3;
	      }
	      if (dataLoss > 20 && dataLoss <= 30) {
	        connectionQuality = 2;
	      }
	      if (dataLoss > 30) {
	        connectionQuality = 1;
	      }
	      return connectionQuality;
	    }
	  }, {
	    key: "stopStatisticsGathering",
	    value: function stopStatisticsGathering() {
	      clearInterval(this.statsInterval);
	      this.statsInterval = null;
	    }
	  }, {
	    key: "updateCandidatesTimeout",
	    value: function updateCandidatesTimeout() {
	      if (this.candidatesTimeout) {
	        clearTimeout(this.candidatesTimeout);
	      }
	      this.candidatesTimeout = setTimeout(this.sendIceCandidates.bind(this), 500);
	    }
	  }, {
	    key: "sendIceCandidates",
	    value: function sendIceCandidates() {
	      this.log("User " + this.userId + ": sending ICE candidates due to the timeout");
	      this.candidatesTimeout = null;
	      if (this.localIceCandidates.length > 0) {
	        this.getSignaling().sendIceCandidate({
	          userId: this.userId,
	          connectionId: this.peerConnectionId,
	          candidates: this.localIceCandidates
	        });
	        this.localIceCandidates = [];
	      } else {
	        this.log("User " + this.userId + ": ICE candidates pool is empty");
	      }
	    }
	  }, {
	    key: "_destroyPeerConnection",
	    value: function _destroyPeerConnection() {
	      if (!this.peerConnection) {
	        return;
	      }
	      clearTimeout(this.reconnectAfterDisconnectTimeout);
	      this.log("User " + this.userId + ": Destroying peer connection " + this.peerConnectionId);
	      this.stopStatisticsGathering();
	      this.peerConnection.removeEventListener("icecandidate", this._onPeerConnectionIceCandidateHandler);
	      this.peerConnection.removeEventListener("connectionstatechange", this._onPeerConnectionConnectionStateChangeHandler);
	      this.peerConnection.removeEventListener("icegatheringstatechange", this._onPeerConnectionIceGatheringStateChangeHandler);
	      this.peerConnection.removeEventListener("signalingstatechange", this._onPeerConnectionSignalingStateChangeHandler);
	      // this.peerConnection.removeEventListener("negotiationneeded", this._onPeerConnectionNegotiationNeededHandler);
	      this.peerConnection.removeEventListener("track", this._onPeerConnectionTrackHandler);
	      this.peerConnection.removeEventListener("removestream", this._onPeerConnectionRemoveStreamHandler);
	      this.localIceCandidates = [];
	      if (this.pendingIceCandidates[this.peerConnectionId]) {
	        delete this.pendingIceCandidates[this.peerConnectionId];
	      }
	      this.peerConnection.close();
	      this.peerConnection = null;
	      this.peerConnectionId = null;
	      this.videoSender = null;
	      this.screenSender = null;
	      this.audioSender = null;
	      this.incomingAudioTrack = null;
	      this.incomingScreenAudioTrack = null;
	      this.incomingVideoTrack = null;
	      this.incomingScreenTrack = null;
	    }
	  }, {
	    key: "_onPeerConnectionIceCandidate",
	    value: function _onPeerConnectionIceCandidate(e) {
	      var candidate = e.candidate;
	      this.log("User " + this.userId + ": ICE candidate discovered. Candidate: " + (candidate ? candidate.candidate : candidate));
	      if (candidate) {
	        if (this.getSignaling().isIceTricklingAllowed()) {
	          this.getSignaling().sendIceCandidate({
	            userId: this.userId,
	            connectionId: this.peerConnectionId,
	            candidates: [candidate.toJSON()]
	          });
	        } else {
	          this.localIceCandidates.push(candidate.toJSON());
	          this.updateCandidatesTimeout();
	        }
	        var match = candidate.candidate.match(/typ\s(\w+)?/);
	        if (match) {
	          var type = match[1];
	          if (type == "srflx") {
	            this.hasStun = true;
	          } else if (type == "relay") {
	            this.hasTurn = true;
	          }
	        }
	      }
	    }
	  }, {
	    key: "stopSignalingTimeout",
	    value: function stopSignalingTimeout() {
	      clearTimeout(this.signalingConnectionTimeout);
	    }
	  }, {
	    key: "refreshSignalingTimeout",
	    value: function refreshSignalingTimeout() {
	      clearTimeout(this.signalingConnectionTimeout);
	      this.signalingConnectionTimeout = setTimeout(_classPrivateMethodGet$1(this, _onLostSignalingConnection, _onLostSignalingConnection2).bind(this), signalingConnectionRefreshPeriod);
	    }
	  }, {
	    key: "_onConnectionOfferReplyTimeout",
	    value: function _onConnectionOfferReplyTimeout(connectionId) {
	      this.log("did not receive connection answer for connection " + connectionId);
	      this.call.setPublishingState(MediaStreamsKinds.Camera, false);
	      this.reconnect();
	    }
	  }, {
	    key: "_onNegotiationNeededReplyTimeout",
	    value: function _onNegotiationNeededReplyTimeout() {
	      this.log("did not receive connection offer in time");
	      this.reconnect();
	    }
	  }, {
	    key: "setConnectionOffer",
	    value: function setConnectionOffer(connectionId, sdp, trackList) {
	      this.log("User " + this.userId + ": applying connection offer for connection " + connectionId);
	      clearTimeout(this.negotiationNeededReplyTimeout);
	      this.negotiationNeededReplyTimeout = null;
	      if (!this.call.isReady()) {
	        return;
	      }
	      if (!this.isReady()) {
	        return;
	      }
	      if (trackList) {
	        this.trackList = BX.util.array_flip(trackList);
	      }
	      if (this.peerConnection) {
	        if (this.peerConnectionId !== connectionId) {
	          this._destroyPeerConnection();
	          _classPrivateMethodGet$1(this, _createPeerConnection$1, _createPeerConnection2$1).call(this, connectionId);
	        }
	      } else {
	        _classPrivateMethodGet$1(this, _createPeerConnection$1, _createPeerConnection2$1).call(this, connectionId);
	      }
	      this.applyOfferAndSendAnswer(sdp);
	    }
	  }, {
	    key: "createAndSendOffer",
	    value: function createAndSendOffer(config) {
	      var _this15 = this;
	      var connectionConfig = defaultConnectionOptions;
	      for (var _key in config) {
	        connectionConfig[_key] = config[_key];
	      }
	      this.peerConnection.createOffer(connectionConfig).then(function (offer) {
	        _this15.log("User " + _this15.userId + ": Created connection offer.");
	        _this15.log("Applying local description");
	        return _this15.peerConnection.setLocalDescription(offer);
	      }).then(function () {
	        _this15.sendOffer();
	      });
	    }
	  }, {
	    key: "sendOffer",
	    value: function sendOffer() {
	      var _this16 = this;
	      clearTimeout(this.connectionOfferReplyTimeout);
	      this.connectionOfferReplyTimeout = setTimeout(function () {
	        return _this16._onConnectionOfferReplyTimeout(_this16.peerConnectionId);
	      }, signalingWaitReplyPeriod);
	      this.getSignaling().sendConnectionOffer({
	        userId: this.userId,
	        connectionId: this.peerConnectionId,
	        sdp: this.peerConnection.localDescription.sdp,
	        tracks: {
	          audio: this.getSenderMid(this.audioSender),
	          video: this.getSenderMid(this.videoSender),
	          screen: this.getSenderMid(this.screenSender),
	          sharingAudio: this.getSenderMid(this.screenAudioSender)
	        },
	        userAgent: navigator.userAgent
	      });
	    }
	  }, {
	    key: "sendNegotiationNeeded",
	    value: function sendNegotiationNeeded(restart) {
	      var _this17 = this;
	      restart = restart === true;
	      clearTimeout(this.negotiationNeededReplyTimeout);
	      this.negotiationNeededReplyTimeout = setTimeout(function () {
	        return _this17._onNegotiationNeededReplyTimeout();
	      }, signalingWaitReplyPeriod);
	      var params = {
	        userId: this.userId
	      };
	      if (restart) {
	        params.restart = true;
	      }
	      this.getSignaling().sendNegotiationNeeded(params);
	    }
	  }, {
	    key: "applyOfferAndSendAnswer",
	    value: function applyOfferAndSendAnswer(sdp) {
	      var _this18 = this;
	      var sessionDescription = new RTCSessionDescription({
	        type: "offer",
	        sdp: sdp
	      });
	      if (this.pendingRemoteSdpDelay) {
	        this.pendingRemoteSdp = sdp;
	        return;
	      }
	      this.log("User: " + this.userId + "; Applying remote offer");
	      this.log("User: " + this.userId + "; Peer ice connection state ", this.peerConnection.iceConnectionState);
	      this.pendingRemoteSdpDelay = true;
	      this.peerConnection.setRemoteDescription(sessionDescription).then(function () {
	        if (_this18.peerConnection.iceConnectionState === 'new') {
	          _this18.sendMedia(true);
	        }
	        return _this18.peerConnection.createAnswer();
	      }).then(function (answer) {
	        _this18.log("Created connection answer.");
	        _this18.log("Applying local description.");
	        return _this18.peerConnection.setLocalDescription(answer);
	      }).then(function () {
	        _this18.applyResolutionScale();
	        _this18.applyPendingIceCandidates();
	        _this18.getSignaling().sendConnectionAnswer({
	          userId: _this18.userId,
	          connectionId: _this18.peerConnectionId,
	          sdp: _this18.peerConnection.localDescription.sdp,
	          tracks: {
	            audio: _this18.getSenderMid(_this18.audioSender),
	            video: _this18.getSenderMid(_this18.videoSender),
	            screen: _this18.getSenderMid(_this18.screenSender),
	            sharingAudio: _this18.getSenderMid(_this18.screenAudioSender)
	          },
	          userAgent: navigator.userAgent
	        });
	      })["catch"](function (e) {
	        _this18.failureReason = e.toString();
	        _this18.updateCalculatedState();
	        _this18.log("Could not apply remote offer", e);
	        console.error("Could not apply remote offer", e);
	      })["finally"](function () {
	        _this18.pendingRemoteSdpDelay = false;
	        if (_this18.pendingRemoteSdp) {
	          _this18.applyOfferAndSendAnswer(_this18.pendingRemoteSdp);
	          _this18.pendingRemoteSdp = null;
	        }
	      });
	    }
	  }, {
	    key: "setConnectionAnswer",
	    value: function setConnectionAnswer(connectionId, sdp, trackList) {
	      var _this19 = this;
	      if (!this.peerConnection || this.peerConnectionId != connectionId) {
	        this.log("Could not apply answer, for unknown connection " + connectionId);
	        return;
	      }
	      if (this.peerConnection.signalingState !== 'have-local-offer') {
	        this.log("Could not apply answer, wrong peer connection signaling state " + this.peerConnection.signalingState);
	        return;
	      }
	      if (trackList) {
	        this.trackList = BX.util.array_flip(trackList);
	      }
	      var sessionDescription = new RTCSessionDescription({
	        type: "answer",
	        sdp: sdp
	      });
	      clearTimeout(this.connectionOfferReplyTimeout);
	      this.log("User: " + this.userId + "; Applying remote answer");
	      this.peerConnection.setRemoteDescription(sessionDescription).then(function () {
	        _this19.applyPendingIceCandidates();
	      })["catch"](function (e) {
	        _this19.failureReason = e.toString();
	        _this19.updateCalculatedState();
	        _this19.log(e);
	      })["finally"](function () {
	        _this19.call.setPublishingState(MediaStreamsKinds.Camera, false);
	      });
	    }
	  }, {
	    key: "addIceCandidate",
	    value: function addIceCandidate(connectionId, candidate) {
	      var _this20 = this;
	      if (!this.peerConnection) {
	        return;
	      }
	      if (this.peerConnectionId != connectionId) {
	        this.log("Error: Candidate for unknown connection " + connectionId);
	        return;
	      }
	      if (this.peerConnection.remoteDescription && this.peerConnection.remoteDescription.type) {
	        this.peerConnection.addIceCandidate(candidate).then(function () {
	          _this20.log("User: " + _this20.userId + "; Added remote ICE candidate: " + (candidate ? candidate.candidate : candidate));
	        })["catch"](function (e) {
	          _this20.log(e);
	        });
	      } else {
	        if (!this.pendingIceCandidates[connectionId]) {
	          this.pendingIceCandidates[connectionId] = [];
	        }
	        this.pendingIceCandidates[connectionId].push(candidate);
	      }
	    }
	  }, {
	    key: "applyPendingIceCandidates",
	    value: function applyPendingIceCandidates() {
	      var _this21 = this;
	      if (!this.peerConnection || !this.peerConnection.remoteDescription.type) {
	        return;
	      }
	      if (main_core.Type.isArray(this.pendingIceCandidates[this.peerConnectionId])) {
	        this.pendingIceCandidates[this.peerConnectionId].forEach(function (candidate) {
	          _this21.peerConnection.addIceCandidate(candidate).then(function () {
	            _this21.log("User: " + _this21.userId + "; Added remote ICE candidate: " + (candidate ? candidate.candidate : candidate));
	          });
	        });
	        this.pendingIceCandidates[this.peerConnectionId] = [];
	      }
	    }
	  }, {
	    key: "onNegotiationNeeded",
	    value: function onNegotiationNeeded() {
	      if (this.peerConnection) {
	        if (this.peerConnection.signalingState == "have-local-offer") {
	          this.sendOffer();
	        } else {
	          this.createAndSendOffer({
	            iceRestart: true
	          });
	        }
	      } else {
	        this.sendMedia();
	      }
	    }
	  }, {
	    key: "reconnect",
	    value: function reconnect() {
	      clearTimeout(this.reconnectAfterDisconnectTimeout);
	      this.connectionAttempt++;
	      if (this.connectionAttempt > 3) {
	        this.log("Error: Too many reconnection attempts, giving up");
	        this.failureReason = "Could not connect to user in time";
	        this.updateCalculatedState();
	        return;
	      }
	      this.callbacks.onReconnecting();
	      this.log("Trying to restore ICE connection. Attempt " + this.connectionAttempt);
	      if (this.isInitiator()) {
	        this._destroyPeerConnection();
	        this.sendMedia();
	      } else {
	        this.sendNegotiationNeeded(true);
	      }
	    }
	  }, {
	    key: "disconnect",
	    value: function disconnect() {
	      this._destroyPeerConnection();
	      this.outgoingVideoTrack = null;
	      this.outgoingScreenTrack = null;
	      this.outgoingVideoHoldState = false;
	      this.incomingAudioTrack = null;
	      this.incomingScreenAudioTrack = null;
	      this.incomingVideoTrack = null;
	      this.incomingScreenTrack = null;
	    }
	  }, {
	    key: "log",
	    value: function log() {
	      this.call.log.apply(this.call, arguments);
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.disconnect();
	      if (this.voiceDetection) {
	        this.voiceDetection.destroy();
	        this.voiceDetection = null;
	      }
	      for (var tag in this.localStreams) {
	        this.localStreams[tag] = null;
	      }
	      clearTimeout(this.answerTimeout);
	      this.answerTimeout = null;
	      clearTimeout(this.connectionTimeout);
	      this.connectionTimeout = null;
	      clearTimeout(this.signalingConnectionTimeout);
	      this.signalingConnectionTimeout = null;
	      this.callbacks.onStateChanged = BX.DoNothing;
	      this.callbacks.onMediaReceived = BX.DoNothing;
	      this.callbacks.onMediaStopped = BX.DoNothing;
	    }
	  }]);
	  return Peer;
	}();
	function _createPeerConnection2$1(id) {
	  this.log("User " + this.userId + ": Creating peer connection");
	  var connectionConfig = {
	    "iceServers": [{
	      urls: "stun:" + this.call.turnServer
	    }, {
	      urls: "turn:" + this.call.turnServer,
	      username: this.call.turnServerLogin,
	      credential: this.call.turnServerPassword
	    }]
	    // iceTransportPolicy: 'relay'
	  };

	  this.localIceCandidates = [];
	  this.peerConnection = new RTCPeerConnection(connectionConfig);
	  this.peerConnectionId = id;
	  this.peerConnection.addEventListener("icecandidate", this._onPeerConnectionIceCandidateHandler);
	  this.peerConnection.addEventListener("connectionstatechange", this._onPeerConnectionConnectionStateChangeHandler);
	  this.peerConnection.addEventListener("icegatheringstatechange", this._onPeerConnectionIceGatheringStateChangeHandler);
	  this.peerConnection.addEventListener("signalingstatechange", this._onPeerConnectionSignalingStateChangeHandler);
	  // this.peerConnection.addEventListener("negotiationneeded", this._onPeerConnectionNegotiationNeededHandler);
	  this.peerConnection.addEventListener("track", this._onPeerConnectionTrackHandler);
	  this.peerConnection.addEventListener("removestream", this._onPeerConnectionRemoveStreamHandler);
	  this.failureReason = '';
	  this.hasStun = false;
	  this.hasTurn = false;
	  this.updateCalculatedState();
	  this.startStatisticsGathering();
	}
	function _onPeerConnectionConnectionStateChange2() {
	  this.log("User " + this.userId + ": peer connection state changed. New state: " + this.peerConnection.connectionState);
	  if (this.peerConnection.connectionState === "connected" || this.peerConnection.connectionState === "completed") {
	    this.connectionAttempt = 0;
	    this.callbacks.onReconnected();
	    clearTimeout(this.reconnectAfterDisconnectTimeout);
	    this._updateTracksDebounced();
	  } else if (this.peerConnection.connectionState === "failed") {
	    this.log("peer connection failed. Trying to restore connection immediately");
	    this.reconnect();
	  }
	  // else if (this.peerConnection.connectionState === "disconnected")
	  // {
	  // 	// we can ignore a 'disconnected' state because it can provoke frequent reconnects,
	  // 	// besides that, iceConnectionState can can be changed back to 'connected' state by itself
	  // 	this.log("peer connection lost. Waiting 5 seconds before trying to restore it");
	  // 	clearTimeout(this.reconnectAfterDisconnectTimeout);
	  // 	this.reconnectAfterDisconnectTimeout = setTimeout(() => this.reconnect(), 5000);
	  // }

	  this.updateCalculatedState();
	}
	function _onPeerConnectionIceGatheringStateChange2(e) {
	  var connection = e.target;
	  this.log("User " + this.userId + ": ICE gathering state changed to : " + connection.iceGatheringState);
	  if (connection.iceGatheringState === 'complete') {
	    this.log("User " + this.userId + ": ICE gathering complete");
	    if (!this.hasStun || !this.hasTurn) {
	      var s = [];
	      if (!this.hasTurn) {
	        s.push("TURN");
	      }
	      if (!this.hasStun) {
	        s.push("STUN");
	      }
	      this.log("Connectivity problem detected: no ICE candidates from " + s.join(" and ") + " servers");
	      console.error("Connectivity problem detected: no ICE candidates from " + s.join(" and ") + " servers");
	      this.callbacks.onNetworkProblem();
	    }
	    if (!this.hasTurn && !this.hasStun) ;
	    if (!this.getSignaling().isIceTricklingAllowed()) {
	      if (this.localIceCandidates.length > 0) {
	        this.getSignaling().sendIceCandidate({
	          userId: this.userId,
	          connectionId: this.peerConnectionId,
	          candidates: this.localIceCandidates
	        });
	        this.localIceCandidates = [];
	      } else {
	        this.log("User " + this.userId + ": ICE candidates already sent");
	      }
	    }
	  }
	}
	function _onPeerConnectionSignalingStateChange2() {
	  this.log("User " + this.userId + " PC signalingState: " + this.peerConnection.signalingState);
	  if (this.peerConnection.signalingState === "stable") {
	    this._updateTracksDebounced();
	  }
	}
	function _onPeerConnectionTrack2(e) {
	  this.log("User " + this.userId + ": media track received: ", e.track.id + " (" + e.track.kind + ")");
	  if (e.track.kind === "video") {
	    e.track.addEventListener("mute", _classPrivateMethodGet$1(this, _onVideoTrackMuted, _onVideoTrackMuted2).bind(this));
	    e.track.addEventListener("unmute", _classPrivateMethodGet$1(this, _onVideoTrackUnMuted, _onVideoTrackUnMuted2).bind(this));
	    e.track.addEventListener("ended", _classPrivateMethodGet$1(this, _onVideoTrackEnded, _onVideoTrackEnded2).bind(this));
	    if (this.trackList[e.track.id] === 'screen') {
	      this.incomingScreenTrack = e.track;
	    } else {
	      this.incomingVideoTrack = e.track;
	    }
	  } else if (e.track.kind === 'audio') {
	    // this.incomingAudioTrack = e.track;
	    if (this.trackList[e.track.id] === 'screenAudio') {
	      this.incomingScreenAudioTrack = e.track;
	    } else {
	      this.incomingAudioTrack = e.track;
	    }
	  }
	}
	function _onPeerConnectionRemoveStream2(e) {
	  this.log("User: " + this.userId + "_onPeerConnectionRemoveStream: ", e);
	}
	function _onVideoTrackMuted2() {
	  console.log("Video track muted");
	  //this._updateTracksDebounced();
	}
	function _onVideoTrackUnMuted2() {
	  console.log("Video track unmuted");
	  //this._updateTracksDebounced();
	}
	function _onVideoTrackEnded2() {
	  console.log("Video track ended");
	}
	function _updateTracks2() {
	  var _this23 = this;
	  if (!this.peerConnection) {
	    return null;
	  }
	  var audioTrack = null;
	  var videoTrack = null;
	  var screenTrack = null;
	  var screenAudioTrack = null;
	  this.peerConnection.getTransceivers().forEach(function (tr) {
	    _this23.call.log("[debug] tr direction: " + tr.direction + " currentDirection: " + tr.currentDirection);
	    if (tr.currentDirection === "sendrecv" || tr.currentDirection === "recvonly") {
	      if (tr.receiver && tr.receiver.track) {
	        var track = tr.receiver.track;
	        if (track.kind === 'audio') {
	          if (_this23.trackList[tr.mid] === 'sharingAudio') {
	            screenAudioTrack = track;
	          } else {
	            audioTrack = track;
	          }
	        } else if (track.kind === 'video') {
	          if (_this23.trackList[tr.mid] === 'screen') {
	            screenTrack = track;
	          } else {
	            videoTrack = track;
	          }
	        }
	      }
	    }
	  });
	  this.incomingAudioTrack = audioTrack;
	  this.incomingVideoTrack = videoTrack;
	  this.incomingScreenTrack = screenTrack;
	  this.incomingScreenAudioTrack = screenAudioTrack;
	}
	function _onLostSignalingConnection2() {
	  this.setSignalingConnected(false);
	}

	var _MediaKinds;
	function ownKeys$1(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
	function _objectSpread$1(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys$1(Object(source), !0).forEach(function (key) { babelHelpers.defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys$1(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
	function _classPrivateFieldInitSpec$1(obj, privateMap, value) { _checkPrivateRedeclaration$2(obj, privateMap); privateMap.set(obj, value); }
	function _classPrivateMethodInitSpec$2(obj, privateSet) { _checkPrivateRedeclaration$2(obj, privateSet); privateSet.add(obj); }
	function _checkPrivateRedeclaration$2(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }
	function _classPrivateMethodGet$2(receiver, privateSet, fn) { if (!privateSet.has(receiver)) { throw new TypeError("attempted to get private field on non-instance"); } return fn; }

	/**
	 * Implements Call interface
	 * Public methods:
	 * - inviteUsers
	 * - answer
	 * - decline
	 * - hangup
	 *
	 * Events:
	 * - onCallStateChanged //not sure about this.
	 * - onUserStateChanged
	 * - onStreamReceived
	 * - onStreamRemoved
	 * - onDestroy
	 */

	var ajaxActions$1 = {
	  invite: 'im.call.invite',
	  answer: 'im.call.answer',
	  decline: 'im.call.decline',
	  hangup: 'im.call.hangup',
	  ping: 'im.call.ping',
	  finish: 'im.call.finish'
	};
	var pullEvents$1 = {
	  ping: 'Call::ping',
	  answer: 'Call::answer',
	  hangup: 'Call::hangup',
	  userInviteTimeout: 'Call::userInviteTimeout',
	  repeatAnswer: 'Call::repeatAnswer'
	};
	var clientEvents = {
	  voiceStarted: 'Call::voiceStarted',
	  voiceStopped: 'Call::voiceStopped',
	  microphoneState: 'Call::microphoneState',
	  cameraState: 'Call::cameraState',
	  videoPaused: 'Call::videoPaused',
	  screenState: 'Call::screenState',
	  recordState: 'Call::recordState',
	  emotion: 'Call::emotion',
	  customMessage: 'Call::customMessage',
	  showUsers: 'Call::showUsers',
	  showAll: 'Call::showAll',
	  hideAll: 'Call::hideAll'
	};
	var scenarioEvents = {
	  viewerJoined: 'Call::viewerJoined',
	  viewerLeft: 'Call::viewerLeft'
	};
	var BitrixCallEvent = {
	  onCallConference: 'BitrixCall::onCallConference'
	};
	var MediaKinds = (_MediaKinds = {}, babelHelpers.defineProperty(_MediaKinds, MediaStreamsKinds.Camera, 'video'), babelHelpers.defineProperty(_MediaKinds, MediaStreamsKinds.Microphone, 'audio'), babelHelpers.defineProperty(_MediaKinds, MediaStreamsKinds.Screen, 'sharing'), babelHelpers.defineProperty(_MediaKinds, MediaStreamsKinds.ScreenAudio, 'sharingAudio'), _MediaKinds);
	var pingPeriod$1 = 5000;
	var backendPingPeriod$1 = 25000;
	var reinvitePeriod$1 = 5500;

	// const MAX_USERS_WITHOUT_SIMULCAST = 6;
	var _setPublishingState = /*#__PURE__*/new WeakSet();
	var _onCallConnected = /*#__PURE__*/new WeakSet();
	var _onCallFailed = /*#__PURE__*/new WeakSet();
	var _onPeerStateChanged$1 = /*#__PURE__*/new WeakMap();
	var _onPeerInviteTimeout$1 = /*#__PURE__*/new WeakMap();
	var _changeRecordState$1 = /*#__PURE__*/new WeakSet();
	var _onPullEventAnswer$1 = /*#__PURE__*/new WeakMap();
	var _onPullEventHangup$1 = /*#__PURE__*/new WeakMap();
	var _onPullEventUsersJoined$1 = /*#__PURE__*/new WeakMap();
	var _onPullEventUsersInvited$1 = /*#__PURE__*/new WeakMap();
	var _onPullEventUserInviteTimeout$1 = /*#__PURE__*/new WeakMap();
	var _onPullEventPing$1 = /*#__PURE__*/new WeakMap();
	var _onNoPingsReceived = /*#__PURE__*/new WeakMap();
	var _onNoSelfPingsReceived = /*#__PURE__*/new WeakMap();
	var _onPullEventFinish$1 = /*#__PURE__*/new WeakMap();
	var _onPullEventRepeatAnswer$1 = /*#__PURE__*/new WeakMap();
	var _onPullEventSwitchTrackRecordStatus = /*#__PURE__*/new WeakMap();
	var _onLocalMediaRendererAdded = /*#__PURE__*/new WeakMap();
	var _onLocalMediaRendererMuteToggled = /*#__PURE__*/new WeakMap();
	var _onMediaMutedBySystem = /*#__PURE__*/new WeakMap();
	var _onLocalMediaRendererEnded = /*#__PURE__*/new WeakMap();
	var _onGetUserMediaStarted = /*#__PURE__*/new WeakMap();
	var _onGetUserMediaSuccess = /*#__PURE__*/new WeakMap();
	var _onGetUserMediaEnded = /*#__PURE__*/new WeakMap();
	var _onBeforeLocalMediaRendererRemoved = /*#__PURE__*/new WeakMap();
	var _onRemoteMediaAdded = /*#__PURE__*/new WeakMap();
	var _onRemoteMediaRemoved = /*#__PURE__*/new WeakMap();
	var _onRemoteMediaMuteToggled = /*#__PURE__*/new WeakMap();
	var _onParticipantJoined = /*#__PURE__*/new WeakMap();
	var _onParticipantLeaved = /*#__PURE__*/new WeakMap();
	var _onMicAccessResult = /*#__PURE__*/new WeakMap();
	var _onCallReconnecting = /*#__PURE__*/new WeakMap();
	var _onCallReconnected = /*#__PURE__*/new WeakMap();
	var _onCallDisconnected = /*#__PURE__*/new WeakMap();
	var _onWindowUnload = /*#__PURE__*/new WeakMap();
	var _onFatalError = /*#__PURE__*/new WeakMap();
	var _onCallStatsReceived = /*#__PURE__*/new WeakMap();
	var _onUpdatePacketLoss = /*#__PURE__*/new WeakMap();
	var _onConnectionQualityChanged = /*#__PURE__*/new WeakMap();
	var _onToggleRemoteParticipantVideo = /*#__PURE__*/new WeakMap();
	var _onCallMessageReceived = /*#__PURE__*/new WeakMap();
	var _onCallHandRaised = /*#__PURE__*/new WeakMap();
	var _onEndpointVoiceStart = /*#__PURE__*/new WeakMap();
	var _onEndpointVoiceEnd = /*#__PURE__*/new WeakMap();
	var BitrixCall = /*#__PURE__*/function (_AbstractCall) {
	  babelHelpers.inherits(BitrixCall, _AbstractCall);
	  function BitrixCall(config) {
	    var _this;
	    babelHelpers.classCallCheck(this, BitrixCall);
	    _this = babelHelpers.possibleConstructorReturn(this, babelHelpers.getPrototypeOf(BitrixCall).call(this, config));
	    _classPrivateMethodInitSpec$2(babelHelpers.assertThisInitialized(_this), _changeRecordState$1);
	    _classPrivateMethodInitSpec$2(babelHelpers.assertThisInitialized(_this), _onCallFailed);
	    _classPrivateMethodInitSpec$2(babelHelpers.assertThisInitialized(_this), _onCallConnected);
	    _classPrivateMethodInitSpec$2(babelHelpers.assertThisInitialized(_this), _setPublishingState);
	    babelHelpers.defineProperty(babelHelpers.assertThisInitialized(_this), "setMuted", function (event) {
	      if (_this.muted === event.data.isMicrophoneMuted) {
	        return;
	      }
	      _this.muted = event.data.isMicrophoneMuted;
	      if (_this.BitrixCall) {
	        _this.signaling.sendMicrophoneState(!_this.muted);
	        if (_this.muted) {
	          _this.BitrixCall.disableAudio();
	        } else {
	          if (!_this.BitrixCall.isAudioPublished()) {
	            _classPrivateMethodGet$2(babelHelpers.assertThisInitialized(_this), _setPublishingState, _setPublishingState2).call(babelHelpers.assertThisInitialized(_this), MediaStreamsKinds.Microphone, true);
	          }
	          _this.BitrixCall.enableAudio();
	        }
	      }
	    });
	    babelHelpers.defineProperty(babelHelpers.assertThisInitialized(_this), "setVideoEnabled", function (event) {
	      if (_this.videoEnabled === event.data.isCameraOn) {
	        return;
	      }
	      _this.videoEnabled = event.data.isCameraOn;
	      if (_this.BitrixCall) {
	        _this.signaling.sendCameraState(_this.videoEnabled);
	        if (_this.videoEnabled) {
	          if (!_this.BitrixCall.isVideoPublished()) {
	            _classPrivateMethodGet$2(babelHelpers.assertThisInitialized(_this), _setPublishingState, _setPublishingState2).call(babelHelpers.assertThisInitialized(_this), MediaStreamsKinds.Camera, true);
	          }
	          _this.localVideoShown = true;
	          _this.BitrixCall.enableVideo();
	        } else {
	          if (_this.localVideoShown) {
	            _this.localVideoShown = false;
	            _this.BitrixCall.disableVideo();
	          }
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPeerStateChanged$1, {
	      writable: true,
	      value: function value(e) {
	        _this.runCallback(CallEvent.onUserStateChanged, e);
	        if (!_this.ready) {
	          return;
	        }
	        if (e.state === UserState.Failed || e.state === UserState.Unavailable || e.state === UserState.Declined || e.state === UserState.Idle) {
	          if (_this.type == CallType.Instant && !_this.isAnyoneParticipating()) {
	            _this.hangup();
	          }
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPeerInviteTimeout$1, {
	      writable: true,
	      value: function value(e) {
	        if (!_this.ready) {
	          return;
	        }
	        _this.signaling.sendUserInviteTimeout({
	          userId: _this.users,
	          failedUserId: e.userId
	        });
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventAnswer$1, {
	      writable: true,
	      value: function value(params) {
	        var senderId = Number(params.senderId);
	        if (senderId == _this.userId) {
	          return _this.__onPullEventAnswerSelf(params);
	        }
	        if (!_this.peers[senderId]) {
	          _this.peers[senderId] = _this.createPeer(senderId);
	          _this.runCallback(CallEvent.onUserInvited, {
	            userId: senderId
	          });
	        }
	        if (!_this.users.includes(senderId)) {
	          _this.users.push(senderId);
	        }
	        _this.peers[senderId].setReady(true);
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventHangup$1, {
	      writable: true,
	      value: function value(params) {
	        var senderId = params.senderId;
	        if (_this.userId === senderId && params.callInstanceId && _this.instanceId !== params.callInstanceId) {
	          // Call declined by the same user elsewhere
	          _this.runCallback(CallEvent.onLeave, {
	            local: false
	          });
	          return;
	        }
	        if (!_this.peers[senderId]) {
	          return;
	        }
	        _this.peers[senderId].participant = null;
	        _this.peers[senderId].setReady(false);
	        if (params.code == 603) {
	          _this.peers[senderId].setDeclined(true);
	        } else if (params.code == 486) {
	          _this.peers[senderId].setBusy(true);
	          console.error("user " + senderId + " is busy");
	        }
	        if (_this.ready && _this.type == CallType.Instant && !_this.isAnyoneParticipating()) {
	          _this.hangup();
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventUsersJoined$1, {
	      writable: true,
	      value: function value(params) {
	        _this.log('__onPullEventUsersJoined', params);
	        var users = params.users;
	        _this.addJoinedUsers(users);
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventUsersInvited$1, {
	      writable: true,
	      value: function value(params) {
	        _this.log('__onPullEventUsersInvited', params);
	        var users = params.users;
	        var show = params.show;
	        if (_this.type === CallType.Instant) {
	          _this.addInvitedUsers(users, show);
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventUserInviteTimeout$1, {
	      writable: true,
	      value: function value(params) {
	        _this.log('__onPullEventUserInviteTimeout', params);
	        var failedUserId = params.failedUserId;
	        if (_this.peers[failedUserId]) {
	          _this.peers[failedUserId].onInviteTimeout(false);
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventPing$1, {
	      writable: true,
	      value: function value(params) {
	        if (params.callInstanceId === _this.instanceId) {
	          // ignore self ping
	          return;
	        }
	        var senderId = Number(params.senderId);
	        if (senderId == _this.userId) {
	          if (!_this.joinedElsewhere) {
	            _this.runCallback(CallEvent.onJoin, {
	              local: false
	            });
	            _this.joinedElsewhere = true;
	          }
	          clearTimeout(_this.lastSelfPingReceivedTimeout);
	          _this.lastSelfPingReceivedTimeout = setTimeout(babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onNoSelfPingsReceived), pingPeriod$1 * 2.1);
	        }
	        clearTimeout(_this.lastPingReceivedTimeout);
	        _this.lastPingReceivedTimeout = setTimeout(babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onNoPingsReceived), pingPeriod$1 * 2.1);
	        if (_this.peers[senderId]) {
	          _this.peers[senderId].setReady(true);
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onNoPingsReceived, {
	      writable: true,
	      value: function value() {
	        if (!_this.ready) {
	          _this.destroy();
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onNoSelfPingsReceived, {
	      writable: true,
	      value: function value() {
	        _this.runCallback(CallEvent.onLeave, {
	          local: false
	        });
	        _this.joinedElsewhere = false;
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventFinish$1, {
	      writable: true,
	      value: function value() {
	        _this.destroy();
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventRepeatAnswer$1, {
	      writable: true,
	      value: function value() {
	        if (_this.ready) {
	          _this.signaling.sendAnswer({
	            userId: _this.userId
	          }, true);
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onPullEventSwitchTrackRecordStatus, {
	      writable: true,
	      value: function value(e) {
	        _this.runCallback(CallEvent.onSwitchTrackRecordStatus, {
	          isTrackRecordOn: e.isTrackRecordOn,
	          errorCode: e.errorCode
	        });
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onLocalMediaRendererAdded, {
	      writable: true,
	      value: function value(e) {
	        var kind = MediaKinds[e];
	        if (!kind) {
	          _this.log("Wrong kind for local mediaRenderer: ".concat(e));
	          return;
	        }
	        _this.log('__onLocalMediaRendererAdded', kind);
	        switch (e) {
	          case MediaStreamsKinds.Camera:
	            _this.BitrixCall.getLocalVideo().then(function (track) {
	              if (!_this.videoEnabled) {
	                return;
	              }
	              var mediaRenderer = new MediaRenderer({
	                kind: kind,
	                track: track
	              });
	              _this.runCallback(CallEvent.onLocalMediaReceived, {
	                mediaRenderer: mediaRenderer,
	                tag: 'main',
	                stream: mediaRenderer.stream
	              });
	            });
	            break;
	          case MediaStreamsKinds.Screen:
	            _this.log("Screen shared");
	            _this.screenShared = true;
	            _this.waitingLocalScreenShare = false;
	            _this.BitrixCall.getLocalScreen().then(function (tracks) {
	              var mediaRenderer = new MediaRenderer({
	                kind: kind,
	                track: tracks.video
	              });
	              _this.runCallback(CallEvent.onLocalMediaReceived, {
	                mediaRenderer: mediaRenderer,
	                tag: 'screen',
	                stream: new MediaStream()
	              });
	            });
	            break;
	          case MediaStreamsKinds.Microphone:
	            _this.BitrixCall.getLocalAudio().then(function (track) {
	              _classPrivateMethodGet$2(babelHelpers.assertThisInitialized(_this), _setPublishingState, _setPublishingState2).call(babelHelpers.assertThisInitialized(_this), MediaStreamsKinds.Microphone, false);
	              babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onMicAccessResult).call(babelHelpers.assertThisInitialized(_this), {
	                result: true,
	                stream: new MediaStream([track])
	              });
	            });
	            break;
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onLocalMediaRendererMuteToggled, {
	      writable: true,
	      value: function value(e) {
	        if (e === MediaStreamsKinds.Microphone) {
	          _classPrivateMethodGet$2(babelHelpers.assertThisInitialized(_this), _setPublishingState, _setPublishingState2).call(babelHelpers.assertThisInitialized(_this), MediaStreamsKinds.Microphone, false);
	        } else if (e === MediaStreamsKinds.Camera) {
	          _classPrivateMethodGet$2(babelHelpers.assertThisInitialized(_this), _setPublishingState, _setPublishingState2).call(babelHelpers.assertThisInitialized(_this), MediaStreamsKinds.Camera, false);
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onMediaMutedBySystem, {
	      writable: true,
	      value: function value(muted) {
	        var microphoneState = muted ? false : !Hardware.isMicrophoneMuted;
	        var cameraState = muted ? false : Hardware.isCameraOn;
	        _this.signaling.sendMicrophoneState(microphoneState);
	        _this.signaling.sendCameraState(cameraState);
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onLocalMediaRendererEnded, {
	      writable: true,
	      value: function value(e, interrupted) {
	        var kind = MediaKinds[e];
	        if (!kind) {
	          _this.log("Wrong kind for mediaRenderer: ".concat(e));
	          return;
	        }
	        if (!_this.BitrixCall) {
	          return;
	        }
	        switch (e) {
	          case MediaStreamsKinds.Camera:
	          case MediaStreamsKinds.Microphone:
	            if (!interrupted) {
	              babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onBeforeLocalMediaRendererRemoved).call(babelHelpers.assertThisInitialized(_this), e);
	            }
	            break;
	          case MediaStreamsKinds.Screen:
	            babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onBeforeLocalMediaRendererRemoved).call(babelHelpers.assertThisInitialized(_this), e);
	            break;
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onGetUserMediaStarted, {
	      writable: true,
	      value: function value(options) {
	        _this.getUserMediaFulfilled = false;
	        if (options.video) {
	          _this.signaling.sendCameraState(false);
	        }
	        if (options.audio) {
	          _this.signaling.sendMicrophoneState(false);
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onGetUserMediaSuccess, {
	      writable: true,
	      value: function value(options) {
	        if (options.video) {
	          _this.signaling.sendCameraState(true);
	        }
	        if (options.audio) {
	          _this.signaling.sendMicrophoneState(true);
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onGetUserMediaEnded, {
	      writable: true,
	      value: function value() {
	        _this.getUserMediaFulfilled = true;
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onBeforeLocalMediaRendererRemoved, {
	      writable: true,
	      value: function value(e) {
	        var kind = MediaKinds[e];
	        if (!kind) {
	          _this.log("Wrong kind for mediaRenderer: ".concat(e));
	          return;
	        }
	        if (!_this.BitrixCall) {
	          return;
	        }
	        _this.log("__onBeforeLocalMediaRendererRemoved", kind);
	        var mediaRenderer = new MediaRenderer({
	          kind: kind
	        });
	        switch (e) {
	          case MediaStreamsKinds.Camera:
	            _this.runCallback(CallEvent.onLocalMediaReceived, {
	              mediaRenderer: mediaRenderer,
	              tag: 'main',
	              stream: new MediaStream(),
	              removed: true
	            });
	            break;
	          case MediaStreamsKinds.Microphone:
	            _classPrivateMethodGet$2(babelHelpers.assertThisInitialized(_this), _setPublishingState, _setPublishingState2).call(babelHelpers.assertThisInitialized(_this), MediaStreamsKinds.Microphone, false);
	            _this.signaling.sendMicrophoneState(false);
	            break;
	          case MediaStreamsKinds.Screen:
	            _this.BitrixCall.stopScreenShare();
	            _this.log("Screen is no longer shared");
	            _this.runCallback(CallEvent.onUserScreenState, {
	              userId: _this.userId,
	              screenState: false
	            });
	            _this.screenShared = false;
	            _this.waitingLocalScreenShare = false;
	            _this.runCallback(CallEvent.onLocalMediaReceived, {
	              mediaRenderer: mediaRenderer,
	              tag: 'screen',
	              stream: new MediaStream(),
	              removed: true
	            });
	            break;
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onRemoteMediaAdded, {
	      writable: true,
	      value: function value(p, t) {
	        var kind = MediaKinds[t.source];
	        if (!kind) {
	          _this.log("Wrong kind for mediaRenderer: ".concat(t.source));
	          return;
	        }
	        var e = {
	          mediaRenderer: new MediaRenderer({
	            kind: kind,
	            track: t.track
	          })
	        };
	        var peer = _this.peers[p.userId];
	        if (peer) {
	          peer.addMediaRenderer(e.mediaRenderer);
	          // temporary solution to play new streams
	          // todo: need to find what cause the problem itself
	          if (!peer.participant) {
	            peer.participant = p;
	            peer.updateCalculatedState();
	          }
	        }
	        switch (t.source) {
	          case MediaStreamsKinds.Camera:
	            _this.runCallback(CallEvent.onUserCameraState, {
	              userId: p.userId,
	              cameraState: !p.isMutedVideo
	            });
	            break;
	          case MediaStreamsKinds.Microphone:
	            _this.runCallback(CallEvent.onUserMicrophoneState, {
	              userId: p.userId,
	              microphoneState: !p.isMutedAudio
	            });
	            break;
	        }
	        console.log("[RemoteMediaAdded]: UserId: ".concat(p.userId, ", source: ").concat(MediaKinds[t.source]));
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onRemoteMediaRemoved, {
	      writable: true,
	      value: function value(p, t) {
	        var kind = MediaKinds[t.source];
	        if (!kind) {
	          _this.log("Wrong kind for mediaRenderer: ".concat(t.source));
	          return;
	        }
	        var e = {
	          mediaRenderer: new MediaRenderer({
	            kind: kind,
	            track: t.track
	          })
	        };
	        var peer = _this.peers[p.userId];
	        if (peer) {
	          peer.removeMediaRenderer(e.mediaRenderer);
	        }
	        console.log("[RemoteMediaRemoved]: UserId: ".concat(p.userId, ", source: ").concat(MediaKinds[t.source]));
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onRemoteMediaMuteToggled, {
	      writable: true,
	      value: function value(p, t) {
	        if (t.source === MediaStreamsKinds.Microphone) {
	          _this.runCallback(CallEvent.onUserMicrophoneState, {
	            userId: p.userId,
	            microphoneState: !p.isMutedAudio
	          });
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onParticipantJoined, {
	      writable: true,
	      value: function value(p) {
	        var peer = _this.peers[p.userId];
	        if (peer) {
	          if (!p.audioEnabled || p.isMutedAudio) {
	            _this.runCallback(CallEvent.onUserMicrophoneState, {
	              userId: p.userId,
	              microphoneState: false
	            });
	          }
	          if (!p.videoEnabled || p.isMutedVideo) {
	            _this.runCallback(CallEvent.onUserCameraState, {
	              userId: p.userId,
	              cameraState: false
	            });
	          }
	          if (p.isHandRaised) {
	            _this.runCallback(CallEvent.onUserFloorRequest, {
	              userId: p.userId,
	              requestActive: p.isHandRaised
	            });
	          }
	          peer.participant = p;
	          peer.updateCalculatedState();
	          if (_this.recordState.state !== View.RecordState.Stopped && _this.recordState.userId === _this.userId) {
	            _this.signaling.sendRecordState(_this.userId, _this.recordState);
	          }
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onParticipantLeaved, {
	      writable: true,
	      value: function value(p) {
	        var peer = _this.peers[p.userId];
	        if (peer) {
	          peer.participant = null;
	          for (var type in MediaStreamsKinds) {
	            var source = MediaStreamsKinds[type];
	            var kind = MediaKinds[source];
	            var e = {
	              mediaRenderer: new MediaRenderer({
	                kind: kind
	              })
	            };
	            peer.removeMediaRenderer(e.mediaRenderer);
	          }
	          peer.updateCalculatedState();
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onMicAccessResult, {
	      writable: true,
	      value: function value(e) {
	        if (e.result) {
	          if (e.stream.getAudioTracks().length > 0) {
	            if (_this.localVAD) {
	              _this.localVAD.destroy();
	            }
	            _this.localVAD = new SimpleVAD({
	              mediaStream: e.stream,
	              onVoiceStarted: function onVoiceStarted() {
	                if (!Hardware.isMicrophoneMuted) {
	                  _this.requestFloor(false);
	                }
	                babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onEndpointVoiceStart).call(babelHelpers.assertThisInitialized(_this), {
	                  userId: _this.userId
	                });
	              },
	              onVoiceStopped: function onVoiceStopped() {
	                babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onEndpointVoiceEnd).call(babelHelpers.assertThisInitialized(_this), {
	                  userId: _this.userId
	                });
	              }
	            });
	            clearInterval(_this.microphoneLevelInterval);
	            _this.microphoneLevelInterval = setInterval(function () {
	              return _this.microphoneLevel = _this.localVAD.currentVolume;
	            }, 200);
	          }
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onCallReconnecting, {
	      writable: true,
	      value: function value() {
	        if (_this.reconnectionEventCount++) {
	          return;
	        }
	        for (var userId in _this.peers) {
	          if (userId !== _this.userId && _this.peers.hasOwnProperty(userId) && _this.peers[userId].calculatedState === UserState.Connected) {
	            for (var type in MediaStreamsKinds) {
	              var source = MediaStreamsKinds[type];
	              var kind = MediaKinds[source];
	              var e = {
	                mediaRenderer: new MediaRenderer({
	                  kind: kind
	                })
	              };
	              _this.peers[userId].removeMediaRenderer(e.mediaRenderer);
	            }
	          }
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onCallReconnected, {
	      writable: true,
	      value: function value() {
	        _this.reconnectionEventCount = 0;
	        _this.log("Call reconnected");
	        _this.sendTelemetryEvent("reconnect");
	        _this.localUserState = UserState.Connected;
	        _this.signaling.sendMicrophoneState(!Hardware.isMicrophoneMuted);
	        if (!_this.BitrixCall.isAudioPublished()) {
	          _classPrivateMethodGet$2(babelHelpers.assertThisInitialized(_this), _setPublishingState, _setPublishingState2).call(babelHelpers.assertThisInitialized(_this), MediaStreamsKinds.Microphone, true);
	        }
	        _this.BitrixCall.enableAudio(Hardware.isMicrophoneMuted);
	        _this.signaling.sendCameraState(Hardware.isCameraOn);
	        if (Hardware.isCameraOn) {
	          if (!_this.BitrixCall.isVideoPublished()) {
	            _classPrivateMethodGet$2(babelHelpers.assertThisInitialized(_this), _setPublishingState, _setPublishingState2).call(babelHelpers.assertThisInitialized(_this), MediaStreamsKinds.Camera, true);
	          }
	          _this.BitrixCall.enableVideo();
	        }
	        if (_this.screenShared || _this.waitingLocalScreenShare) {
	          _this.BitrixCall.startScreenShare();
	        }
	        if (_this.videoAllowedFrom == UserMnemonic.none) {
	          _this.signaling.sendHideAll();
	        } else if (main_core.Type.isArray(_this.videoAllowedFrom)) {
	          _this.signaling.sendShowUsers(_this.videoAllowedFrom);
	        }
	        _this.BitrixCall.raiseHand(_this.floorRequestActive);
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onCallDisconnected, {
	      writable: true,
	      value: function value(e) {
	        var logData = {};
	        var evt = e && babelHelpers["typeof"](e) === 'object' ? e : {};
	        var headers = evt.headers,
	          leaveInformation = evt.leaveInformation;
	        if (headers) {
	          logData = _objectSpread$1(_objectSpread$1({}, logData), {}, {
	            headers: headers
	          });
	        }
	        if (leaveInformation) {
	          logData = _objectSpread$1(_objectSpread$1({}, logData), {}, {
	            leaveInformation: leaveInformation
	          });
	        }
	        _this.log("__onCallDisconnected", Object.keys(logData).length ? logData : null);
	        if (_this.ready && leaveInformation) {
	          _this.hangup(leaveInformation.code, leaveInformation.reason);
	        }
	        _this.sendTelemetryEvent("disconnect");
	        _this.localUserState = UserState.Idle;
	        _this.ready = false;
	        _this.joinedAsViewer = false;
	        _this.reinitPeers();
	        _this.localVideoShown = false;
	        _this.removeCallEvents();
	        _this.unsubscribeHardwareChanges();
	        _this.state = CallState.Proceeding;
	        _this.runCallback(CallEvent.onLeave, {
	          local: true
	        });
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onWindowUnload, {
	      writable: true,
	      value: function value() {
	        if (_this.ready && _this.BitrixCall) {
	          _this.signaling.sendHangup({
	            userId: _this.users
	          });
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onFatalError, {
	      writable: true,
	      value: function value(error) {
	        if (error && error.call) {
	          delete error.call;
	        }
	        _this.log("onFatalError", error);
	        _this.ready = false;
	        _this.localUserState = UserState.Failed;
	        _this.reinitPeers();
	        _this.localVideoShown = false;
	        if (_this.BitrixCall) {
	          _this.removeCallEvents();
	          _this.unsubscribeHardwareChanges();
	          try {
	            _this.BitrixCall.hangup({
	              'X-Reason': 'Fatal error',
	              'X-Error': typeof error === 'string' ? error : error.code || error.name
	            });
	          } catch (e) {
	            _this.log("Bitrix hangup error: ", e);
	            console.error("Bitrix hangup error: ", e);
	          }
	          _this.BitrixCall = null;
	        }
	        if (typeof error === "string") {
	          _this.runCallback(CallEvent.onCallFailure, {
	            name: error
	          });
	        } else if (error.name) {
	          _this.runCallback(CallEvent.onCallFailure, error);
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onCallStatsReceived, {
	      writable: true,
	      value: function value(stats) {
	        var usersToSendReports = {};
	        // to order local stats by track quality
	        var statsIndexByRid = {
	          f: 2,
	          h: 1,
	          q: 0
	        };
	        stats.sender.forEach(function (report) {
	          if (report.userId && (report.kind === 'video' || report.kind === 'audio')) {
	            if (!usersToSendReports[report.userId]) {
	              usersToSendReports[report.userId] = {};
	            }
	            if (report.kind === 'video') {
	              if (!usersToSendReports[report.userId][report.source]) {
	                usersToSendReports[report.userId][report.source] = [];
	              }
	              var index = statsIndexByRid[report.rid] || 0;
	              usersToSendReports[report.userId][report.source][index] = report;
	            } else if (report.kind === 'audio') {
	              usersToSendReports[report.userId][report.source] = report;
	            }
	          }
	        });
	        stats.recipient.forEach(function (report) {
	          if (report.userId && (report.kind === 'video' || report.kind === 'audio')) {
	            if (!usersToSendReports[report.userId]) {
	              usersToSendReports[report.userId] = {};
	            }
	            usersToSendReports[report.userId][report.source] = report;
	          }
	        });
	        for (var userId in usersToSendReports) {
	          _this.runCallback(CallEvent.onUserStatsReceived, {
	            userId: userId,
	            report: usersToSendReports[userId]
	          });
	        }

	        // todo: need to correct stats format
	        // if (this.logger)
	        // {
	        // 	this.logger.sendStat(transformVoxStats(e.stats, this.BitrixCall));
	        // }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onUpdatePacketLoss, {
	      writable: true,
	      value: function value(participants) {
	        var prevPeersWithBadConnection = new Set(babelHelpers.toConsumableArray(_this.peersWithBadConnection.values()));
	        participants.forEach(function (userId) {
	          var peer = _this.peers[userId];
	          if (peer) {
	            if (!prevPeersWithBadConnection.has(userId)) {
	              _this.peersWithBadConnection.add(userId);
	            } else {
	              prevPeersWithBadConnection["delete"](userId);
	            }
	          }
	        });
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onConnectionQualityChanged, {
	      writable: true,
	      value: function value(participants) {
	        Object.keys(participants).forEach(function (participantId) {
	          _this.runCallback(CallEvent.onConnectionQualityChanged, {
	            userId: Number(participantId),
	            score: participants[participantId]
	          });
	        });
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onToggleRemoteParticipantVideo, {
	      writable: true,
	      value: function value(isVideoShown) {
	        _this.runCallback(CallEvent.onToggleRemoteParticipantVideo, {
	          isVideoShown: isVideoShown
	        });
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onCallMessageReceived, {
	      writable: true,
	      value: function value(e) {
	        var message;
	        var peer;
	        try {
	          message = JSON.parse(e.text);
	        } catch (err) {
	          _this.log("Could not parse scenario message.", err);
	          return;
	        }
	        var eventName = message.eventName;
	        if (eventName === clientEvents.cameraState) {
	          _this.runCallback(CallEvent.onUserCameraState, {
	            userId: message.senderId,
	            cameraState: message.cameraState === "Y"
	          });
	        } else if (eventName === clientEvents.videoPaused) {
	          if (message.senderId === _this.userId) {
	            return;
	          }
	          _this.runCallback(CallEvent.onUserVideoPaused, {
	            userId: message.senderId,
	            videoPaused: message.videoPaused === "Y"
	          });
	        } else if (eventName === clientEvents.screenState) {
	          _this.runCallback(CallEvent.onUserScreenState, {
	            userId: message.senderId,
	            screenState: message.screenState === "Y"
	          });
	        } else if (eventName === clientEvents.recordState) {
	          _this.runCallback(CallEvent.onUserRecordState, {
	            userId: message.senderId,
	            recordState: message.recordState
	          });
	        } else if (eventName === clientEvents.emotion) {
	          _this.runCallback(CallEvent.onUserEmotion, {
	            userId: message.senderId,
	            toUserId: message.toUserId,
	            emotion: message.emotion
	          });
	        } else if (eventName === clientEvents.customMessage) {
	          _this.runCallback(CallEvent.onCustomMessage, {
	            message: message.message
	          });
	        } else if (eventName === scenarioEvents.viewerJoined) {
	          console.log("viewer " + message.senderId + " joined");
	          peer = _this.peers[message.senderId];
	          if (peer) {
	            peer.setDirection(EndpointDirection.RecvOnly);
	            peer.setReady(true);
	          }
	        } else if (eventName === scenarioEvents.viewerLeft) {
	          console.log("viewer " + message.senderId + " left");
	          peer = _this.peers[message.senderId];
	          if (peer) {
	            peer.setReady(false);
	          }
	        } else {
	          _this.log("Unknown scenario event " + eventName);
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onCallHandRaised, {
	      writable: true,
	      value: function value(p) {
	        _this.runCallback(CallEvent.onUserFloorRequest, {
	          userId: p.userId,
	          requestActive: p.isHandRaised
	        });
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onEndpointVoiceStart, {
	      writable: true,
	      value: function value(p) {
	        // for local user we need to send extra signal to show unmute hint
	        if (p.userId === _this.userId) {
	          _this.runCallback(CallEvent.onUserVoiceStarted, {
	            userId: p.userId,
	            local: true
	          });
	          if (Hardware.isMicrophoneMuted) {
	            return;
	          }
	        }
	        _this.runCallback(CallEvent.onUserVoiceStarted, {
	          userId: p.userId
	        });
	      }
	    });
	    _classPrivateFieldInitSpec$1(babelHelpers.assertThisInitialized(_this), _onEndpointVoiceEnd, {
	      writable: true,
	      value: function value(p) {
	        _this.runCallback(CallEvent.onUserVoiceStopped, {
	          userId: p.userId
	        });
	      }
	    });
	    _this.videoQuality = Quality.VeryHigh; // initial video quality. will drop on new peers connecting

	    _this.BitrixCall = null;
	    _this.signaling = new Signaling$1({
	      call: babelHelpers.assertThisInitialized(_this)
	    });
	    _this.peers = {};
	    _this.peersWithBadConnection = new Set();
	    _this.joinedElsewhere = false;
	    _this.joinedAsViewer = false;
	    _this.localVideoShown = false;
	    _this._localUserState = UserState.Idle;
	    _this.clientEventsBound = false;
	    _this._screenShared = false;
	    _this.videoAllowedFrom = UserMnemonic.all;
	    _this.direction = EndpointDirection.SendRecv;
	    _this.floorRequestActive = false;
	    _this.recordState = {
	      state: View.RecordState.Stopped,
	      userId: 0,
	      date: {
	        start: null,
	        pause: []
	      }
	    };
	    _this.microphoneLevelInterval = null;
	    window.addEventListener("unload", babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onWindowUnload));
	    _this.initPeers();
	    _this.pingUsersInterval = setInterval(_this.pingUsers.bind(babelHelpers.assertThisInitialized(_this)), pingPeriod$1);
	    _this.pingBackendInterval = setInterval(_this.pingBackend.bind(babelHelpers.assertThisInitialized(_this)), backendPingPeriod$1);
	    _this.lastPingReceivedTimeout = null;
	    _this.lastSelfPingReceivedTimeout = null;
	    _this.reinviteTimeout = null;
	    _this._reconnectionEventCount = 0;
	    _this.pullEventHandlers = {
	      'Call::answer': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventAnswer$1),
	      'Call::hangup': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventHangup$1),
	      'Call::usersJoined': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventUsersJoined$1),
	      'Call::usersInvited': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventUsersInvited$1),
	      'Call::userInviteTimeout': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventUserInviteTimeout$1),
	      'Call::ping': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventPing$1),
	      'Call::finish': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventFinish$1),
	      'Call::repeatAnswer': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventRepeatAnswer$1),
	      'Call::switchTrackRecordStatus': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventSwitchTrackRecordStatus)
	    };
	    _this._isCopilotActive = config.isCopilotActive;
	    _this._isCopilotFeaturesEnabled = true;
	    _this._isRecordWhenCopilotActivePopupAlreadyShow = false;
	    _this._isBoostExpired = false;
	    return _this;
	  }
	  babelHelpers.createClass(BitrixCall, [{
	    key: "initPeers",
	    value: function initPeers() {
	      var _this2 = this;
	      this.users.forEach(function (userId) {
	        userId = Number(userId);
	        _this2.peers[userId] = _this2.createPeer(userId);
	      });
	    }
	  }, {
	    key: "reinitPeers",
	    value: function reinitPeers() {
	      for (var userId in this.peers) {
	        if (this.peers.hasOwnProperty(userId) && this.peers[userId]) {
	          this.peers[userId].destroy();
	          this.peers[userId] = null;
	        }
	      }
	      this.initPeers();
	    }
	  }, {
	    key: "pingUsers",
	    value: function pingUsers() {
	      if (this.ready) {
	        var users = this.users.concat(this.userId);
	        this.signaling.sendPingToUsers({
	          userId: users
	        }, true);
	      }
	    }
	  }, {
	    key: "pingBackend",
	    value: function pingBackend() {
	      if (this.ready) {
	        this.signaling.sendPingToBackend();
	      }
	    }
	  }, {
	    key: "createPeer",
	    value: function createPeer(userId) {
	      var _this3 = this;
	      var incomingVideoAllowed;
	      if (this.videoAllowedFrom === UserMnemonic.all) {
	        incomingVideoAllowed = true;
	      } else if (this.videoAllowedFrom === UserMnemonic.none) {
	        incomingVideoAllowed = false;
	      } else if (main_core.Type.isArray(this.videoAllowedFrom)) {
	        incomingVideoAllowed = this.videoAllowedFrom.some(function (allowedUserId) {
	          return allowedUserId == userId;
	        });
	      } else {
	        incomingVideoAllowed = true;
	      }
	      return new Peer$1({
	        call: this,
	        userId: userId,
	        ready: userId == this.initiatorId,
	        isIncomingVideoAllowed: incomingVideoAllowed,
	        onMediaReceived: function onMediaReceived(e) {
	          _this3.runCallback(CallEvent.onRemoteMediaReceived, e);
	          if (e.kind === 'video') {
	            _this3.runCallback(CallEvent.onUserVideoPaused, {
	              userId: userId,
	              videoPaused: false
	            });
	          }
	        },
	        onMediaRemoved: function onMediaRemoved(e) {
	          _this3.runCallback(CallEvent.onRemoteMediaStopped, e);
	        },
	        onStateChanged: babelHelpers.classPrivateFieldGet(this, _onPeerStateChanged$1),
	        onInviteTimeout: babelHelpers.classPrivateFieldGet(this, _onPeerInviteTimeout$1)
	      });
	    }
	  }, {
	    key: "getUsers",
	    value: function getUsers() {
	      var result = {};
	      for (var userId in this.peers) {
	        result[userId] = this.peers[userId].calculatedState;
	      }
	      return result;
	    }
	  }, {
	    key: "getUserCount",
	    value: function getUserCount() {
	      return Object.keys(this.peers).length;
	    }
	  }, {
	    key: "canChangeMediaDevices",
	    value: function canChangeMediaDevices() {
	      var _this$BitrixCall;
	      return !((_this$BitrixCall = this.BitrixCall) !== null && _this$BitrixCall !== void 0 && _this$BitrixCall.isMediaMutedBySystem);
	    }
	  }, {
	    key: "setCameraId",
	    value: function setCameraId(cameraId) {
	      var _this4 = this;
	      if (this.cameraId === cameraId) {
	        return;
	      }
	      this.cameraId = cameraId;
	      if (this.BitrixCall) {
	        if (!cameraId) {
	          babelHelpers.classPrivateFieldGet(this, _onBeforeLocalMediaRendererRemoved).call(this, MediaStreamsKinds.Camera);
	          return;
	        }
	        if (this.BitrixCall.isVideoPublished()) {
	          _classPrivateMethodGet$2(this, _setPublishingState, _setPublishingState2).call(this, MediaStreamsKinds.Camera, true);
	        }
	        this.BitrixCall.switchActiveVideoDevice(this.cameraId).then(function () {
	          if (Hardware.isCameraOn) {
	            _this4.runCallback('onUpdateLastUsedCameraId');
	            if (_this4.BitrixCall.isVideoPublished() && _this4.canChangeMediaDevices()) {
	              _this4.BitrixCall.getLocalVideo().then(function (track) {
	                var mediaRenderer = new MediaRenderer({
	                  kind: 'video',
	                  track: track
	                });
	                _this4.runCallback(CallEvent.onLocalMediaReceived, {
	                  mediaRenderer: mediaRenderer,
	                  tag: 'main',
	                  stream: mediaRenderer.stream
	                });
	              })["finally"](function () {
	                if (_this4.BitrixCall.isVideoPublished()) {
	                  _classPrivateMethodGet$2(_this4, _setPublishingState, _setPublishingState2).call(_this4, MediaStreamsKinds.Camera, false);
	                }
	              });
	            } else if (!_this4.canChangeMediaDevices()) {
	              _this4.runCallback(CallEvent.onNeedResetMediaDevicesState);
	            } else {
	              _classPrivateMethodGet$2(_this4, _setPublishingState, _setPublishingState2).call(_this4, MediaStreamsKinds.Camera, true);
	              _this4.localVideoShown = true;
	              _this4.BitrixCall.enableVideo(true);
	            }
	          } else {
	            _classPrivateMethodGet$2(_this4, _setPublishingState, _setPublishingState2).call(_this4, MediaStreamsKinds.Camera, false);
	          }
	        })["catch"](function (e) {
	          _this4.log(e);
	          console.error(e);
	          babelHelpers.classPrivateFieldGet(_this4, _onBeforeLocalMediaRendererRemoved).call(_this4, MediaStreamsKinds.Camera);
	        });
	      }
	    }
	  }, {
	    key: "setMicrophoneId",
	    value: function setMicrophoneId(microphoneId) {
	      var _this5 = this;
	      if (this.microphoneId === microphoneId) {
	        return;
	      }
	      this.microphoneId = microphoneId;
	      if (this.BitrixCall) {
	        if (!microphoneId) {
	          babelHelpers.classPrivateFieldGet(this, _onBeforeLocalMediaRendererRemoved).call(this, MediaStreamsKinds.Microphone);
	          return;
	        }
	        _classPrivateMethodGet$2(this, _setPublishingState, _setPublishingState2).call(this, MediaStreamsKinds.Microphone, true);
	        babelHelpers.classPrivateFieldGet(this, _onEndpointVoiceEnd).call(this, {
	          userId: this.userId
	        });
	        this.BitrixCall.switchActiveAudioDevice(this.microphoneId).then(function () {
	          _this5.BitrixCall.getLocalAudio().then(function (track) {
	            babelHelpers.classPrivateFieldGet(_this5, _onMicAccessResult).call(_this5, {
	              result: true,
	              stream: new MediaStream([track])
	            });
	          });
	        })["catch"](function (e) {
	          _this5.log(e);
	          console.error(e);
	          _this5.runCallback(CallEvent.onUserMicrophoneState, {
	            userId: _this5.userId,
	            microphoneState: false
	          });
	        })["finally"](function () {
	          _classPrivateMethodGet$2(_this5, _setPublishingState, _setPublishingState2).call(_this5, MediaStreamsKinds.Microphone, false);
	          if (Hardware.isMicrophoneMuted && !_this5.canChangeMediaDevices()) {
	            _this5.BitrixCall.disableAudio();
	          }
	        });
	      }
	    }
	  }, {
	    key: "useHdVideo",
	    value: function useHdVideo(flag) {
	      this.videoHd = flag === true;
	    }
	  }, {
	    key: "setMainStream",
	    value: function setMainStream(userId) {
	      if (userId && userId !== this.userId) {
	        var _this$peers$userId;
	        var participant = (_this$peers$userId = this.peers[userId]) === null || _this$peers$userId === void 0 ? void 0 : _this$peers$userId.participant;
	        var kind = participant !== null && participant !== void 0 && participant.screenSharingEnabled ? MediaStreamsKinds.Screen : MediaStreamsKinds.Camera;
	        this.BitrixCall.setMainStream(userId, kind);
	      } else {
	        this.BitrixCall.resetMainStream();
	      }
	    }
	  }, {
	    key: "requestFloor",
	    value: function requestFloor(requestActive) {
	      if (this.floorRequestActive === requestActive) {
	        return;
	      }
	      this.floorRequestActive = requestActive;
	      this.BitrixCall.raiseHand(requestActive);
	    }
	  }, {
	    key: "sendRecordState",
	    value: function sendRecordState(recordState) {
	      recordState.senderId = this.userId;
	      if (!_classPrivateMethodGet$2(this, _changeRecordState$1, _changeRecordState2$1).call(this, recordState)) {
	        return;
	      }
	      this.runCallback(CallEvent.onUserRecordState, {
	        userId: this.userId,
	        recordState: this.recordState
	      });
	      this.signaling.sendRecordState(this.userId, this.recordState);
	    }
	  }, {
	    key: "sendCustomMessage",
	    value: function sendCustomMessage(message, repeatOnConnect) {
	      this.signaling.sendCustomMessage(message, repeatOnConnect);
	    }
	  }, {
	    key: "allowVideoFrom",
	    /**
	     * Updates list of users,
	     */
	    value: function allowVideoFrom(userList) {
	      if (this.videoAllowedFrom == userList) {
	        return;
	      }
	      this.videoAllowedFrom = userList;
	      if (userList === UserMnemonic.all) {
	        this.signaling.sendShowAll();
	        userList = Object.keys(this.peers);
	      } else if (userList === UserMnemonic.none) {
	        this.signaling.sendHideAll();
	        userList = [];
	      } else if (main_core.Type.isArray(userList)) {
	        this.signaling.sendShowUsers(userList);
	      } else {
	        throw new Error("userList is in wrong format");
	      }
	      var users = {};
	      userList.forEach(function (userId) {
	        return users[userId] = true;
	      });
	      for (var userId in this.peers) {
	        if (!this.peers.hasOwnProperty(userId)) {
	          continue;
	        }
	        if (users[userId]) {
	          this.peers[userId].allowIncomingVideo(true);
	        } else {
	          this.peers[userId].allowIncomingVideo(false);
	        }
	      }
	    }
	  }, {
	    key: "startScreenSharing",
	    value: function startScreenSharing() {
	      if (!this.BitrixCall) {
	        return;
	      }
	      this.waitingLocalScreenShare = true;
	      this.runCallback(CallEvent.onUserScreenState, {
	        userId: this.userId,
	        screenState: true
	      });
	      this.BitrixCall.startScreenShare();
	    }
	  }, {
	    key: "stopScreenSharing",
	    value: function stopScreenSharing() {
	      babelHelpers.classPrivateFieldGet(this, _onBeforeLocalMediaRendererRemoved).call(this, MediaStreamsKinds.Screen);
	    }
	  }, {
	    key: "isScreenSharingStarted",
	    value: function isScreenSharingStarted() {
	      return this.screenShared || this.waitingLocalScreenShare;
	    }
	  }, {
	    key: "isGetUserMediaFulfilled",
	    value: function isGetUserMediaFulfilled() {
	      return this.getUserMediaFulfilled;
	    }
	  }, {
	    key: "inviteUsers",
	    /**
	     * Invites users to participate in the call.
	     */
	    value: function inviteUsers() {
	      var _this6 = this;
	      var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      this.ready = true;
	      var users = main_core.Type.isArray(config.users) ? config.users : this.users;
	      this.attachToConference().then(function () {
	        _this6.signaling.sendPingToUsers({
	          userId: users
	        });
	        if (users.length > 0) {
	          return _this6.signaling.inviteUsers({
	            userIds: users,
	            video: Hardware.isCameraOn ? 'Y' : 'N',
	            show: config.show === true ? 'Y' : 'N'
	          });
	        }
	      }).then(function () {
	        _this6.state = CallState.Connected;
	        _this6.runCallback(CallEvent.onJoin, {
	          local: true
	        });
	        for (var i = 0; i < users.length; i++) {
	          var userId = parseInt(users[i]);
	          if (!_this6.users.includes(userId)) {
	            _this6.users.push(userId);
	          }
	          if (!_this6.peers[userId]) {
	            _this6.peers[userId] = _this6.createPeer(userId);
	            if (_this6.type === CallType.Instant) {
	              _this6.runCallback(CallEvent.onUserInvited, {
	                userId: userId
	              });
	            }
	          }
	          if (_this6.type === CallType.Instant) {
	            _this6.peers[userId].onInvited();
	            _this6.scheduleRepeatInvite();
	          }
	        }
	      })["catch"](function (e) {
	        babelHelpers.classPrivateFieldGet(_this6, _onFatalError).call(_this6, e);
	      });
	    }
	  }, {
	    key: "scheduleRepeatInvite",
	    value: function scheduleRepeatInvite() {
	      var _this7 = this;
	      clearTimeout(this.reinviteTimeout);
	      this.reinviteTimeout = setTimeout(function () {
	        return _this7.repeatInviteUsers();
	      }, reinvitePeriod$1);
	    }
	  }, {
	    key: "repeatInviteUsers",
	    value: function repeatInviteUsers() {
	      var _this8 = this;
	      clearTimeout(this.reinviteTimeout);
	      if (!this.ready) {
	        return;
	      }
	      var usersToRepeatInvite = [];
	      for (var userId in this.peers) {
	        if (this.peers.hasOwnProperty(userId) && this.peers[userId].calculatedState === UserState.Calling) {
	          usersToRepeatInvite.push(userId);
	        }
	      }
	      if (usersToRepeatInvite.length === 0) {
	        return;
	      }
	      var inviteParams = {
	        userIds: usersToRepeatInvite,
	        video: Hardware.isCameraOn ? 'Y' : 'N',
	        repeated: 'Y'
	      };
	      this.signaling.inviteUsers(inviteParams).then(function () {
	        return _this8.scheduleRepeatInvite();
	      });
	    }
	  }, {
	    key: "answer",
	    /**
	     * @param {Object} config
	     * @param {bool?} [config.useVideo]
	     * @param {bool?} [config.joinAsViewer]
	     */
	    value: function answer() {
	      var _this9 = this;
	      var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      this.ready = true;
	      var joinAsViewer = config.joinAsViewer === true;
	      this.videoEnabled = Hardware.isCameraOn;
	      this.muted = Hardware.isMicrophoneMuted;
	      clearTimeout(this.lastSelfPingReceivedTimeout);
	      if (!joinAsViewer) {
	        this._outgoingAnswer = this.signaling.sendAnswer();
	      }
	      this.attachToConference({
	        joinAsViewer: joinAsViewer
	      }).then(function () {
	        _this9.log("Attached to conference");
	        _this9.state = CallState.Connected;
	        _this9.runCallback(CallEvent.onJoin, {
	          local: true
	        });
	      })["catch"](function (err) {
	        babelHelpers.classPrivateFieldGet(_this9, _onFatalError).call(_this9, err);
	      });
	    }
	  }, {
	    key: "decline",
	    value: function decline(code) {
	      this.ready = false;
	      var data = {
	        callId: this.id,
	        callInstanceId: this.instanceId
	      };
	      if (code) {
	        data.code = code;
	      }
	      CallEngine.getRestClient().callMethod(ajaxActions$1.decline, data);
	    }
	  }, {
	    key: "hangup",
	    value: function hangup(code, reason) {
	      var _this10 = this;
	      var finishCall = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      if (!this.ready) {
	        var error = new Error("Hangup in wrong state");
	        this.log(error);
	        return;
	      }
	      var tempError = new Error();
	      tempError.name = "Call stack:";
	      this.log("Hangup received \n" + tempError.stack);
	      if (this.localVAD) {
	        this.localVAD.destroy();
	        this.localVAD = null;
	      }
	      clearInterval(this.microphoneLevelInterval);
	      var data = {};
	      this.ready = false;
	      if (typeof code != 'undefined') {
	        data.code = code;
	      }
	      if (typeof reason != 'undefined') {
	        data.reason = reason;
	      }
	      this.state = CallState.Proceeding;
	      this.runCallback(CallEvent.onLeave, {
	        local: true
	      });

	      //clone users and append current user id to send event to all participants of the call
	      data.userId = this.users.slice(0).concat(this.userId);
	      if (this._outgoingAnswer && !finishCall) {
	        this._outgoingAnswer.then(function () {
	          return _this10.signaling.sendHangup(data);
	        });
	      } else if (finishCall) {
	        this.signaling.sendFinish(data);
	      } else if (reason !== 'SIGNALING_DUPLICATE_PARTICIPANT') {
	        this.signaling.sendHangup(data);
	      }
	      if (reason !== 'SIGNALING_DUPLICATE_PARTICIPANT') {
	        // for future reconnections
	        this.reinitPeers();
	      }
	      if (this.BitrixCall) {
	        this.BitrixCall._replaceVideoSharing = false;
	        this.BitrixCall.hangup();
	        this.BitrixCall = null;
	      } else {
	        this.log("Tried to hangup, but this.BitrixCall points nowhere");
	        console.error("Tried to hangup, but this.BitrixCall points nowhere");
	      }
	      this.screenShared = false;
	      this.localVideoShown = false;
	    }
	  }, {
	    key: "attachToConference",
	    value: function attachToConference() {
	      var _this11 = this;
	      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      var joinAsViewer = options.joinAsViewer === true;
	      if (this.BitrixCall && this.BitrixCall.getState() === CALL_STATE.CONNECTED) {
	        if (this.joinedAsViewer === joinAsViewer) {
	          return Promise.resolve();
	        } else {
	          return Promise.reject("Already joined call in another mode");
	        }
	      }
	      return new Promise(function (resolve, reject) {
	        _this11.direction = joinAsViewer ? EndpointDirection.RecvOnly : EndpointDirection.SendRecv;
	        _this11.sendTelemetryEvent("call");
	        try {
	          _this11.localUserState = UserState.Connecting;
	          _this11.BitrixCall = new Call(_this11.userId);
	          if (Hardware.isCameraOn) {
	            _this11.localVideoShown = true;
	          }
	          _this11.joinedAsViewer = joinAsViewer;
	          if (!_this11.BitrixCall) {
	            _this11.log("Error: could not create Bitrix call");
	            return reject({
	              code: "BITRIX_NO_CALL"
	            });
	          }
	          _this11.runCallback(BitrixCallEvent.onCallConference, {
	            call: _this11
	          });
	          _this11.bindCallEvents();
	          _this11.subscribeHardwareChanges();
	          _this11.BitrixCall.on('Connected', function () {
	            _classPrivateMethodGet$2(_this11, _onCallConnected, _onCallConnected2).call(_this11);
	            resolve();
	          });
	          _this11.BitrixCall.on('Failed', function (e) {
	            _classPrivateMethodGet$2(_this11, _onCallFailed, _onCallFailed2).call(_this11, e);
	            reject(e);
	          });
	          if (!_this11.ready) {
	            // for rare cases with fast quit
	            return reject({
	              code: "BITRIX_NO_CALL"
	            });
	          }
	          _this11.BitrixCall.connect({
	            roomId: _this11.id,
	            userId: _this11.userId,
	            endpoint: _this11.connectionData.endpoint,
	            jwt: _this11.connectionData.jwt,
	            videoBitrate: 1000000,
	            videoSimulcast: true,
	            audioDeviceId: _this11.microphoneId,
	            videoDeviceId: _this11.cameraId
	          });
	        } catch (e) {
	          babelHelpers.classPrivateFieldGet(_this11, _onFatalError).call(_this11, e);
	        }
	      });
	    }
	  }, {
	    key: "bindCallEvents",
	    value: function bindCallEvents() {
	      this.BitrixCall.on('PublishSucceed', babelHelpers.classPrivateFieldGet(this, _onLocalMediaRendererAdded));
	      this.BitrixCall.on('PublishPaused', babelHelpers.classPrivateFieldGet(this, _onLocalMediaRendererMuteToggled));
	      this.BitrixCall.on('MediaMutedBySystem', babelHelpers.classPrivateFieldGet(this, _onMediaMutedBySystem));
	      this.BitrixCall.on('PublishFailed', babelHelpers.classPrivateFieldGet(this, _onLocalMediaRendererEnded));
	      this.BitrixCall.on('PublishEnded', babelHelpers.classPrivateFieldGet(this, _onLocalMediaRendererEnded));
	      this.BitrixCall.on('GetUserMediaStarted', babelHelpers.classPrivateFieldGet(this, _onGetUserMediaStarted).bind(this));
	      this.BitrixCall.on('GetUserMediaEnded', babelHelpers.classPrivateFieldGet(this, _onGetUserMediaEnded));
	      this.BitrixCall.on('GetUserMediaSuccess', babelHelpers.classPrivateFieldGet(this, _onGetUserMediaSuccess).bind(this));
	      this.BitrixCall.on('RemoteMediaAdded', babelHelpers.classPrivateFieldGet(this, _onRemoteMediaAdded));
	      this.BitrixCall.on('RemoteMediaRemoved', babelHelpers.classPrivateFieldGet(this, _onRemoteMediaRemoved));
	      this.BitrixCall.on('RemoteMediaMuted', babelHelpers.classPrivateFieldGet(this, _onRemoteMediaMuteToggled));
	      this.BitrixCall.on('RemoteMediaUnmuted', babelHelpers.classPrivateFieldGet(this, _onRemoteMediaMuteToggled));
	      this.BitrixCall.on('ParticipantJoined', babelHelpers.classPrivateFieldGet(this, _onParticipantJoined));
	      this.BitrixCall.on('ParticipantStateUpdated', function () {
	        return console.log('handleParticipantStateUpdated');
	      });
	      this.BitrixCall.on('ParticipantLeaved', babelHelpers.classPrivateFieldGet(this, _onParticipantLeaved));
	      this.BitrixCall.on('MessageReceived', babelHelpers.classPrivateFieldGet(this, _onCallMessageReceived));
	      this.BitrixCall.on('HandRaised', babelHelpers.classPrivateFieldGet(this, _onCallHandRaised));
	      this.BitrixCall.on('VoiceStarted', babelHelpers.classPrivateFieldGet(this, _onEndpointVoiceStart));
	      this.BitrixCall.on('VoiceEnded', babelHelpers.classPrivateFieldGet(this, _onEndpointVoiceEnd));
	      this.BitrixCall.on('Reconnecting', babelHelpers.classPrivateFieldGet(this, _onCallReconnecting));
	      this.BitrixCall.on('Reconnected', babelHelpers.classPrivateFieldGet(this, _onCallReconnected));
	      this.BitrixCall.on('Disconnected', babelHelpers.classPrivateFieldGet(this, _onCallDisconnected));
	      // if (Util.shouldCollectStats())
	      // {
	      this.BitrixCall.on('CallStatsReceived', babelHelpers.classPrivateFieldGet(this, _onCallStatsReceived));
	      // }
	      this.BitrixCall.on('UpdatePacketLoss', babelHelpers.classPrivateFieldGet(this, _onUpdatePacketLoss));
	      this.BitrixCall.on('ConnectionQualityChanged', babelHelpers.classPrivateFieldGet(this, _onConnectionQualityChanged));
	      this.BitrixCall.on('ToggleRemoteParticipantVideo', babelHelpers.classPrivateFieldGet(this, _onToggleRemoteParticipantVideo));
	    }
	  }, {
	    key: "removeCallEvents",
	    value: function removeCallEvents() {
	      if (this.BitrixCall) {
	        this.BitrixCall.on('Failed', BX.DoNothing);
	        this.BitrixCall.on('PublishSucceed', BX.DoNothing);
	        this.BitrixCall.on('PublishFailed', BX.DoNothing);
	        this.BitrixCall.on('PublishEnded', BX.DoNothing);
	        this.BitrixCall.on('GetUserMediaEnded', BX.DoNothing);
	        this.BitrixCall.on('RemoteMediaAdded', BX.DoNothing);
	        this.BitrixCall.on('RemoteMediaRemoved', BX.DoNothing);
	        this.BitrixCall.on('ParticipantJoined', BX.DoNothing);
	        this.BitrixCall.on('ParticipantStateUpdated', BX.DoNothing);
	        this.BitrixCall.on('ParticipantLeaved', BX.DoNothing);
	        this.BitrixCall.on('MessageReceived', BX.DoNothing);
	        this.BitrixCall.on('HandRaised', BX.DoNothing);
	        this.BitrixCall.on('VoiceStarted', BX.DoNothing);
	        this.BitrixCall.on('VoiceEnded', BX.DoNothing);
	        this.BitrixCall.on('Reconnecting', BX.DoNothing);
	        this.BitrixCall.on('Reconnected', BX.DoNothing);
	        this.BitrixCall.on('Disconnected', BX.DoNothing);
	        // if (Util.shouldCollectStats())
	        // {
	        this.BitrixCall.on('CallStatsReceived', BX.DoNothing);
	        // }
	        this.BitrixCall.on('UpdatePacketLoss', BX.DoNothing);
	        this.BitrixCall.on('ConnectionQualityChanged', BX.DoNothing);
	        this.BitrixCall.on('ToggleRemoteParticipantVideo', BX.DoNothing);
	      }
	    }
	  }, {
	    key: "subscribeHardwareChanges",
	    value: function subscribeHardwareChanges() {
	      Hardware.subscribe(Hardware.Events.onChangeMicrophoneMuted, this.setMuted);
	      Hardware.subscribe(Hardware.Events.onChangeCameraOn, this.setVideoEnabled);
	    }
	  }, {
	    key: "unsubscribeHardwareChanges",
	    value: function unsubscribeHardwareChanges() {
	      Hardware.unsubscribe(Hardware.Events.onChangeMicrophoneMuted, this.setMuted);
	      Hardware.unsubscribe(Hardware.Events.onChangeCameraOn, this.setVideoEnabled);
	    }
	  }, {
	    key: "addJoinedUsers",
	    /**
	     * Adds new users to call
	     * @param {Number[]} users
	     */
	    value: function addJoinedUsers(users) {
	      for (var i = 0; i < users.length; i++) {
	        var userId = Number(users[i]);
	        if (userId == this.userId || this.peers[userId]) {
	          continue;
	        }
	        this.peers[userId] = this.createPeer(userId);
	        if (!this.users.includes(userId)) {
	          this.users.push(userId);
	        }
	        this.runCallback(CallEvent.onUserInvited, {
	          userId: userId
	        });
	      }
	    }
	  }, {
	    key: "addInvitedUsers",
	    /**
	     * Adds users, invited by you or someone else
	     * @param {Number[]} users
	     */
	    value: function addInvitedUsers(users, show) {
	      for (var i = 0; i < users.length; i++) {
	        var userId = Number(users[i]);
	        if (userId == this.userId) {
	          continue;
	        }
	        if (!this.peers[userId]) {
	          this.peers[userId] = this.createPeer(userId);
	          this.runCallback(CallEvent.onUserInvited, {
	            userId: userId
	          });
	        }
	        if (this.type === CallType.Instant && this.peers[userId].calculatedState !== UserState.Calling) {
	          this.peers[userId].onInvited(show);
	        }
	        if (!this.users.includes(userId)) {
	          this.users.push(userId);
	        }
	      }
	    }
	  }, {
	    key: "toggleRemoteParticipantVideo",
	    value: function toggleRemoteParticipantVideo(participantIds, showVideo) {
	      var isPaginateToggle = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      if (this.BitrixCall) {
	        this.BitrixCall.toggleRemoteParticipantVideo(participantIds, showVideo, isPaginateToggle);
	      }
	    }
	  }, {
	    key: "isAnyoneParticipating",
	    value: function isAnyoneParticipating() {
	      for (var userId in this.peers) {
	        if (this.peers[userId].isParticipating()) {
	          return true;
	        }
	      }
	      return false;
	    }
	  }, {
	    key: "getParticipatingUsers",
	    value: function getParticipatingUsers() {
	      var result = [];
	      for (var userId in this.peers) {
	        if (this.peers[userId].isParticipating()) {
	          result.push(userId);
	        }
	      }
	      return result;
	    }
	  }, {
	    key: "__onPullEvent",
	    value: function __onPullEvent(command, params, extra) {
	      if (this.pullEventHandlers[command]) {
	        if (command !== 'Call::ping') {
	          this.log("Signaling: " + command + "; Parameters: " + JSON.stringify(params));
	        }
	        this.pullEventHandlers[command].call(this, params);
	      }
	    }
	  }, {
	    key: "__onPullEventAnswerSelf",
	    value: function __onPullEventAnswerSelf(params) {
	      if (params.callInstanceId === this.instanceId) {
	        return;
	      }

	      // call was answered elsewhere
	      this.joinedElsewhere = true;
	      this.runCallback(CallEvent.onJoin, {
	        local: false
	      });
	    }
	  }, {
	    key: "sendTelemetryEvent",
	    value: function sendTelemetryEvent(eventName) {
	      Util.sendTelemetryEvent({
	        call_id: this.id,
	        user_id: this.userId,
	        kind: "Bitrix",
	        event: eventName
	      });
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.ready = false;
	      this.joinedAsViewer = false;
	      this.localVideoShown = false;
	      if (this.localVAD) {
	        this.localVAD.destroy();
	        this.localVAD = null;
	      }
	      clearInterval(this.microphoneLevelInterval);
	      if (this.BitrixCall) {
	        this.removeCallEvents();
	        this.unsubscribeHardwareChanges();
	        this.BitrixCall.hangup();
	        this.BitrixCall = null;
	      }
	      for (var userId in this.peers) {
	        if (this.peers.hasOwnProperty(userId) && this.peers[userId]) {
	          this.peers[userId].destroy();
	        }
	      }
	      clearTimeout(this.lastPingReceivedTimeout);
	      clearTimeout(this.lastSelfPingReceivedTimeout);
	      clearInterval(this.pingUsersInterval);
	      clearInterval(this.pingBackendInterval);
	      window.removeEventListener("unload", babelHelpers.classPrivateFieldGet(this, _onWindowUnload));
	      return babelHelpers.get(babelHelpers.getPrototypeOf(BitrixCall.prototype), "destroy", this).call(this);
	    }
	  }, {
	    key: "provider",
	    get: function get() {
	      return Provider.Bitrix;
	    }
	  }, {
	    key: "screenShared",
	    get: function get() {
	      return this._screenShared;
	    },
	    set: function set(screenShared) {
	      if (screenShared !== this._screenShared) {
	        this._screenShared = screenShared;
	        this.signaling.sendScreenState(this._screenShared);
	      }
	    }
	  }, {
	    key: "isCopilotActive",
	    get: function get() {
	      return this._isCopilotActive;
	    },
	    set: function set(isCopilotActive) {
	      if (isCopilotActive !== this._isCopilotActive) {
	        this._isCopilotActive = isCopilotActive;
	      }
	    }
	  }, {
	    key: "isBoostExpired",
	    get: function get() {
	      return this._isBoostExpired;
	    },
	    set: function set(isBoostExpired) {
	      if (isBoostExpired !== this._isBoostExpired) {
	        this._isBoostExpired = isBoostExpired;
	      }
	    }
	  }, {
	    key: "isCopilotFeaturesEnabled",
	    get: function get() {
	      return this._isCopilotFeaturesEnabled;
	    },
	    set: function set(isCopilotFeaturesEnabled) {
	      if (isCopilotFeaturesEnabled !== this._isCopilotFeaturesEnabled) {
	        this._isCopilotFeaturesEnabled = isCopilotFeaturesEnabled;
	      }
	    }
	  }, {
	    key: "isRecordWhenCopilotActivePopupAlreadyShow",
	    get: function get() {
	      return this._isRecordWhenCopilotActivePopupAlreadyShow;
	    },
	    set: function set(isRecordWhenCopilotActivePopupAlreadyShow) {
	      if (isRecordWhenCopilotActivePopupAlreadyShow !== this._isRecordWhenCopilotActivePopupAlreadyShow) {
	        this._isRecordWhenCopilotActivePopupAlreadyShow = isRecordWhenCopilotActivePopupAlreadyShow;
	      }
	    }
	  }, {
	    key: "localUserState",
	    get: function get() {
	      return this._localUserState;
	    },
	    set: function set(state) {
	      if (state === this._localUserState) {
	        return;
	      }
	      this.runCallback(CallEvent.onUserStateChanged, {
	        userId: this.userId,
	        state: state,
	        previousState: this._localUserState,
	        direction: this.direction
	      });
	      this._localUserState = state;
	    }
	  }, {
	    key: "reconnectionEventCount",
	    get: function get() {
	      return this._reconnectionEventCount;
	    },
	    set: function set(newValue) {
	      if (this._reconnectionEventCount === 0 && newValue > 0) {
	        this.runCallback(CallEvent.onReconnecting, {
	          reconnectionEventCount: newValue
	        });
	      }
	      if (newValue === 0) {
	        this.runCallback(CallEvent.onReconnected);
	      }
	      this._reconnectionEventCount = newValue;
	    }
	  }]);
	  return BitrixCall;
	}(AbstractCall);
	function _setPublishingState2(deviceType, publishing) {
	  if (deviceType === MediaStreamsKinds.Camera) {
	    this.runCallback(CallEvent.onCameraPublishing, {
	      publishing: publishing
	    });
	  } else if (deviceType === MediaStreamsKinds.Microphone) {
	    this.runCallback(CallEvent.onMicrophonePublishing, {
	      publishing: publishing
	    });
	  }
	}
	function _onCallConnected2() {
	  this.reconnectionEventCount = 0;
	  this.log("Call connected");
	  this.sendTelemetryEvent("connect");
	  this.localUserState = UserState.Connected;
	  this.BitrixCall.on('Failed', babelHelpers.classPrivateFieldGet(this, _onCallDisconnected));
	  this.signaling.sendMicrophoneState(!Hardware.isMicrophoneMuted);
	  this.signaling.sendCameraState(Hardware.isCameraOn);
	  if (!this.BitrixCall.isAudioPublished()) {
	    _classPrivateMethodGet$2(this, _setPublishingState, _setPublishingState2).call(this, MediaStreamsKinds.Microphone, true);
	  }
	  this.BitrixCall.enableAudio(Hardware.isMicrophoneMuted);
	  if (Hardware.isCameraOn) {
	    if (!this.BitrixCall.isVideoPublished()) {
	      _classPrivateMethodGet$2(this, _setPublishingState, _setPublishingState2).call(this, MediaStreamsKinds.Camera, true);
	    }
	    this.BitrixCall.enableVideo();
	  }
	  if (this.videoAllowedFrom == UserMnemonic.none) {
	    this.signaling.sendHideAll();
	  } else if (main_core.Type.isArray(this.videoAllowedFrom)) {
	    this.signaling.sendShowUsers(this.videoAllowedFrom);
	  }
	}
	function _onCallFailed2(e) {
	  this.log("Could not attach to conference", e);
	  this.sendTelemetryEvent("connect_failure");
	  this.localUserState = UserState.Failed;
	  this.BitrixCall.enableSilentLogging(false);
	  this.BitrixCall.setLoggerCallback(null);
	}
	function _changeRecordState2$1(params) {
	  if (params.action !== View.RecordState.Started && this.recordState.userId != params.senderId) {
	    return false;
	  }
	  if (params.action === View.RecordState.Started) {
	    if (this.recordState.state !== View.RecordState.Stopped) {
	      return false;
	    }
	    this.recordState.state = View.RecordState.Started;
	    this.recordState.userId = params.senderId;
	    this.recordState.date.start = params.date;
	    this.recordState.date.pause = [];
	  } else if (params.action === View.RecordState.Paused) {
	    if (this.recordState.state !== View.RecordState.Started) {
	      return false;
	    }
	    this.recordState.state = View.RecordState.Paused;
	    this.recordState.date.pause.push({
	      start: params.date,
	      finish: null
	    });
	  } else if (params.action === View.RecordState.Resumed) {
	    if (this.recordState.state !== View.RecordState.Paused) {
	      return false;
	    }
	    this.recordState.state = View.RecordState.Started;
	    var pauseElement = this.recordState.date.pause.find(function (element) {
	      return element.finish === null;
	    });
	    if (pauseElement) {
	      pauseElement.finish = params.date;
	    }
	  } else if (params.action === View.RecordState.Stopped) {
	    this.recordState.state = View.RecordState.Stopped;
	    this.recordState.userId = 0;
	    this.recordState.date.start = null;
	    this.recordState.date.pause = [];
	  }
	  return true;
	}
	babelHelpers.defineProperty(BitrixCall, "Event", BitrixCallEvent);
	var _sendPullEvent$1 = /*#__PURE__*/new WeakSet();
	var _sendMessage = /*#__PURE__*/new WeakSet();
	var _runRestAction$1 = /*#__PURE__*/new WeakSet();
	var Signaling$1 = /*#__PURE__*/function () {
	  function Signaling(params) {
	    babelHelpers.classCallCheck(this, Signaling);
	    _classPrivateMethodInitSpec$2(this, _runRestAction$1);
	    _classPrivateMethodInitSpec$2(this, _sendMessage);
	    _classPrivateMethodInitSpec$2(this, _sendPullEvent$1);
	    this.call = params.call;
	  }
	  babelHelpers.createClass(Signaling, [{
	    key: "inviteUsers",
	    value: function inviteUsers(data) {
	      return _classPrivateMethodGet$2(this, _runRestAction$1, _runRestAction2$1).call(this, ajaxActions$1.invite, data);
	    }
	  }, {
	    key: "sendAnswer",
	    value: function sendAnswer(data, repeated) {
	      if (repeated && CallEngine.getPullClient().isPublishingEnabled()) {
	        _classPrivateMethodGet$2(this, _sendPullEvent$1, _sendPullEvent2$1).call(this, pullEvents$1.answer, data);
	      } else {
	        return _classPrivateMethodGet$2(this, _runRestAction$1, _runRestAction2$1).call(this, ajaxActions$1.answer, data);
	      }
	    }
	  }, {
	    key: "sendHangup",
	    value: function sendHangup(data) {
	      if (CallEngine.getPullClient().isPublishingEnabled()) {
	        _classPrivateMethodGet$2(this, _sendPullEvent$1, _sendPullEvent2$1).call(this, pullEvents$1.hangup, data);
	        data.retransmit = false;
	        _classPrivateMethodGet$2(this, _runRestAction$1, _runRestAction2$1).call(this, ajaxActions$1.hangup, data);
	      } else {
	        data.retransmit = true;
	        _classPrivateMethodGet$2(this, _runRestAction$1, _runRestAction2$1).call(this, ajaxActions$1.hangup, data);
	      }
	    }
	  }, {
	    key: "sendFinish",
	    value: function sendFinish(data) {
	      if (CallEngine.getPullClient().isPublishingEnabled()) {
	        _classPrivateMethodGet$2(this, _sendPullEvent$1, _sendPullEvent2$1).call(this, pullEvents$1.hangup, data);
	        data.retransmit = false;
	        _classPrivateMethodGet$2(this, _runRestAction$1, _runRestAction2$1).call(this, ajaxActions$1.finish, data);
	      } else {
	        data.retransmit = true;
	        _classPrivateMethodGet$2(this, _runRestAction$1, _runRestAction2$1).call(this, ajaxActions$1.finish, data);
	      }
	    }
	  }, {
	    key: "sendCameraState",
	    value: function sendCameraState(cameraState) {
	      return _classPrivateMethodGet$2(this, _sendMessage, _sendMessage2).call(this, clientEvents.cameraState, {
	        cameraState: cameraState ? "Y" : "N"
	      });
	    }
	  }, {
	    key: "sendVideoPaused",
	    value: function sendVideoPaused(videoPaused) {
	      return _classPrivateMethodGet$2(this, _sendMessage, _sendMessage2).call(this, clientEvents.videoPaused, {
	        videoPaused: videoPaused ? "Y" : "N"
	      });
	    }
	  }, {
	    key: "sendMicrophoneState",
	    value: function sendMicrophoneState(microphoneState) {
	      return _classPrivateMethodGet$2(this, _sendMessage, _sendMessage2).call(this, clientEvents.microphoneState, {
	        microphoneState: microphoneState ? "Y" : "N"
	      });
	    }
	  }, {
	    key: "sendScreenState",
	    value: function sendScreenState(screenState) {
	      return _classPrivateMethodGet$2(this, _sendMessage, _sendMessage2).call(this, clientEvents.screenState, {
	        screenState: screenState ? "Y" : "N"
	      });
	    }
	  }, {
	    key: "sendRecordState",
	    value: function sendRecordState(userId, recordState) {
	      _classPrivateMethodGet$2(this, _sendMessage, _sendMessage2).call(this, clientEvents.recordState, {
	        senderId: userId,
	        recordState: recordState
	      });
	    }
	  }, {
	    key: "sendCustomMessage",
	    value: function sendCustomMessage(message, repeatOnConnect) {
	      return _classPrivateMethodGet$2(this, _sendMessage, _sendMessage2).call(this, clientEvents.customMessage, {
	        message: message,
	        repeatOnConnect: !!repeatOnConnect
	      });
	    }
	  }, {
	    key: "sendShowUsers",
	    value: function sendShowUsers(users) {
	      return _classPrivateMethodGet$2(this, _sendMessage, _sendMessage2).call(this, clientEvents.showUsers, {
	        users: users
	      });
	    }
	  }, {
	    key: "sendShowAll",
	    value: function sendShowAll() {
	      return _classPrivateMethodGet$2(this, _sendMessage, _sendMessage2).call(this, clientEvents.showAll, {});
	    }
	  }, {
	    key: "sendHideAll",
	    value: function sendHideAll() {
	      return _classPrivateMethodGet$2(this, _sendMessage, _sendMessage2).call(this, clientEvents.hideAll, {});
	    }
	  }, {
	    key: "sendPingToUsers",
	    value: function sendPingToUsers(data) {
	      if (CallEngine.getPullClient().isPublishingEnabled()) {
	        _classPrivateMethodGet$2(this, _sendPullEvent$1, _sendPullEvent2$1).call(this, pullEvents$1.ping, data, 0);
	      }
	    }
	  }, {
	    key: "sendPingToBackend",
	    value: function sendPingToBackend() {
	      _classPrivateMethodGet$2(this, _runRestAction$1, _runRestAction2$1).call(this, ajaxActions$1.ping, {
	        retransmit: false
	      });
	    }
	  }, {
	    key: "sendUserInviteTimeout",
	    value: function sendUserInviteTimeout(data) {
	      if (CallEngine.getPullClient().isPublishingEnabled()) {
	        _classPrivateMethodGet$2(this, _sendPullEvent$1, _sendPullEvent2$1).call(this, pullEvents$1.userInviteTimeout, data, 0);
	      }
	    }
	  }]);
	  return Signaling;
	}();
	function _sendPullEvent2$1(eventName, data, expiry) {
	  expiry = expiry || 5;
	  if (!data.userId) {
	    throw new Error('userId is not found in data');
	  }
	  if (!main_core.Type.isArray(data.userId)) {
	    data.userId = [data.userId];
	  }
	  if (data.userId.length === 0) {
	    // nobody to send, exit
	    return;
	  }
	  data.callInstanceId = this.call.instanceId;
	  data.senderId = this.call.userId;
	  data.callId = this.call.id;
	  data.requestId = Util.getUuidv4();
	  this.call.log('Sending p2p signaling event ' + eventName + '; ' + JSON.stringify(data));
	  CallEngine.getPullClient().sendMessage(data.userId, 'im', eventName, data, expiry);
	}
	function _sendMessage2(eventName, data) {
	  if (!this.call.BitrixCall) {
	    return;
	  }
	  if (!main_core.Type.isPlainObject(data)) {
	    data = {};
	  }
	  data.eventName = eventName;
	  data.requestId = Util.getUuidv4();
	  data.senderId = this.call.userId;
	  this.call.BitrixCall.sendMessage(JSON.stringify(data));
	}
	function _runRestAction2$1(signalName, data) {
	  if (!main_core.Type.isPlainObject(data)) {
	    data = {};
	  }
	  data.callId = this.call.id;
	  data.callInstanceId = this.call.instanceId;
	  data.requestId = Util.getUuidv4();
	  return CallEngine.getRestClient().callMethod(signalName, data);
	}
	var Peer$1 = /*#__PURE__*/function () {
	  function Peer(params) {
	    babelHelpers.classCallCheck(this, Peer);
	    this.userId = params.userId;
	    this.call = params.call;
	    this.ready = !!params.ready;
	    this.calling = false;
	    this.backgroundCalling = false;
	    this.declined = false;
	    this.busy = false;
	    this.inviteTimeout = false;
	    this.direction = params.direction || EndpointDirection.SendRecv;
	    this.stream = null;
	    this.mediaRenderers = [];
	    this.isIncomingVideoAllowed = params.isIncomingVideoAllowed !== false;
	    this.callingTimeout = 0;
	    this.callbacks = {
	      onStateChanged: main_core.Type.isFunction(params.onStateChanged) ? params.onStateChanged : BX.DoNothing,
	      onInviteTimeout: main_core.Type.isFunction(params.onInviteTimeout) ? params.onInviteTimeout : BX.DoNothing,
	      onMediaReceived: main_core.Type.isFunction(params.onMediaReceived) ? params.onMediaReceived : BX.DoNothing,
	      onMediaRemoved: main_core.Type.isFunction(params.onMediaRemoved) ? params.onMediaRemoved : BX.DoNothing
	    };
	    this.calculatedState = this.calculateState();
	  }
	  babelHelpers.createClass(Peer, [{
	    key: "setReady",
	    value: function setReady(ready) {
	      ready = !!ready;
	      if (this.ready === ready) {
	        return;
	      }
	      this.ready = ready;
	      if (this.calling || this.backgroundCalling) {
	        clearTimeout(this.callingTimeout);
	        this.calling = false;
	        this.backgroundCalling = false;
	        this.inviteTimeout = false;
	      }
	      if (this.ready) {
	        this.declined = false;
	        this.busy = false;
	      }
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "setDirection",
	    value: function setDirection(direction) {
	      if (this.direction === direction) {
	        return;
	      }
	      this.direction = direction;
	    }
	  }, {
	    key: "setDeclined",
	    value: function setDeclined(declined) {
	      this.declined = declined;
	      if (this.calling || this.backgroundCalling) {
	        clearTimeout(this.callingTimeout);
	        this.calling = false;
	        this.backgroundCalling = false;
	      }
	      if (this.declined) {
	        this.ready = false;
	        this.busy = false;
	      }
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "setBusy",
	    value: function setBusy(busy) {
	      this.busy = busy;
	      if (this.calling || this.backgroundCalling) {
	        clearTimeout(this.callingTimeout);
	        this.calling = false;
	        this.backgroundCalling = false;
	      }
	      if (this.busy) {
	        this.ready = false;
	        this.declined = false;
	      }
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "allowIncomingVideo",
	    value: function allowIncomingVideo(isIncomingVideoAllowed) {
	      if (this.isIncomingVideoAllowed == isIncomingVideoAllowed) {
	        return;
	      }
	      this.isIncomingVideoAllowed = !!isIncomingVideoAllowed;
	    }
	  }, {
	    key: "addMediaRenderer",
	    value: function addMediaRenderer(mediaRenderer) {
	      this.log('Adding media renderer for user' + this.userId, mediaRenderer);
	      this.mediaRenderers.push(mediaRenderer);
	      this.callbacks.onMediaReceived({
	        userId: this.userId,
	        kind: mediaRenderer.kind,
	        mediaRenderer: mediaRenderer
	      });
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "removeMediaRenderer",
	    value: function removeMediaRenderer(mediaRenderer) {
	      this.log('Removing media renderer for user' + this.userId, mediaRenderer);
	      var i;
	      this.mediaRenderers.forEach(function (el, index) {
	        if (el.kind === mediaRenderer.kind) {
	          i = index;
	        }
	      });
	      if (i >= 0) {
	        this.mediaRenderers.splice(i, 1);
	      }
	      this.callbacks.onMediaRemoved({
	        userId: this.userId,
	        kind: mediaRenderer.kind,
	        mediaRenderer: mediaRenderer
	      });
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "calculateState",
	    value: function calculateState() {
	      if (this.participant) {
	        return UserState.Connected;
	      }
	      if (this.calling) {
	        return UserState.Calling;
	      }
	      if (this.inviteTimeout) {
	        return UserState.Unavailable;
	      }
	      if (this.declined) {
	        return UserState.Declined;
	      }
	      if (this.busy) {
	        return UserState.Busy;
	      }
	      if (this.ready) {
	        return UserState.Ready;
	      }
	      return UserState.Idle;
	    }
	  }, {
	    key: "updateCalculatedState",
	    value: function updateCalculatedState() {
	      var calculatedState = this.calculateState();
	      if (this.calculatedState !== calculatedState) {
	        this.callbacks.onStateChanged({
	          userId: this.userId,
	          state: calculatedState,
	          previousState: this.calculatedState,
	          direction: this.direction
	        });
	        this.calculatedState = calculatedState;
	      }
	    }
	  }, {
	    key: "isParticipating",
	    value: function isParticipating() {
	      return (this.calling || this.backgroundCalling || this.ready || this.participant) && !this.declined;
	    }
	  }, {
	    key: "onInvited",
	    value: function onInvited() {
	      var _this12 = this;
	      var showUser = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
	      this.ready = false;
	      this.inviteTimeout = false;
	      this.declined = false;
	      if (showUser) {
	        this.calling = true;
	      } else {
	        this.backgroundCalling = true;
	      }
	      if (this.callingTimeout) {
	        clearTimeout(this.callingTimeout);
	      }
	      this.callingTimeout = setTimeout(function () {
	        return _this12.onInviteTimeout(true);
	      }, 30000);
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "onInviteTimeout",
	    value: function onInviteTimeout(internal) {
	      clearTimeout(this.callingTimeout);
	      if (!(this.calling || this.backgroundCalling)) {
	        return;
	      }
	      this.calling = false;
	      this.backgroundCalling = false;
	      this.inviteTimeout = true;
	      if (internal) {
	        this.callbacks.onInviteTimeout({
	          userId: this.userId
	        });
	      }
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "log",
	    value: function log() {
	      this.call.log.apply(this.call, arguments);
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      if (this.stream) {
	        Util.stopMediaStream(this.stream);
	        this.stream = null;
	      }
	      this.callbacks.onStateChanged = BX.DoNothing;
	      this.callbacks.onInviteTimeout = BX.DoNothing;
	      this.callbacks.onMediaReceived = BX.DoNothing;
	      this.callbacks.onMediaRemoved = BX.DoNothing;
	      clearTimeout(this.callingTimeout);
	      this.callingTimeout = null;
	    }
	  }]);
	  return Peer;
	}();
	var MediaRenderer = /*#__PURE__*/function () {
	  function MediaRenderer(params) {
	    babelHelpers.classCallCheck(this, MediaRenderer);
	    babelHelpers.defineProperty(this, "element", null);
	    params = params || {};
	    this.kind = params.kind || 'video';
	    if (params.track) {
	      this.stream = new MediaStream([params.track]);
	    } else {
	      this.stream = new MediaStream();
	    }
	  }
	  babelHelpers.createClass(MediaRenderer, [{
	    key: "render",
	    value: function render(el) {
	      if (!el.srcObject || !el.srcObject.active || el.srcObject.id !== this.stream.id) {
	        el.srcObject = this.stream;
	      }
	    }
	  }, {
	    key: "requestVideoSize",
	    value: function requestVideoSize() {}
	  }]);
	  return MediaRenderer;
	}();

	function _classPrivateFieldInitSpec$2(obj, privateMap, value) { _checkPrivateRedeclaration$3(obj, privateMap); privateMap.set(obj, value); }
	function _classPrivateMethodInitSpec$3(obj, privateSet) { _checkPrivateRedeclaration$3(obj, privateSet); privateSet.add(obj); }
	function _checkPrivateRedeclaration$3(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }
	function _classPrivateMethodGet$3(receiver, privateSet, fn) { if (!privateSet.has(receiver)) { throw new TypeError("attempted to get private field on non-instance"); } return fn; }

	/**
	 * Implements Call interface
	 * Public methods:
	 * - inviteUsers
	 * - cancel
	 * - answer
	 * - decline
	 * - hangup
	 *
	 * Events:
	 * - onCallStateChanged //not sure about this.
	 * - onUserStateChanged
	 * - onStreamReceived
	 * - onStreamRemoved
	 * - onDestroy
	 */

	var ajaxActions$2 = {
	  invite: 'im.call.invite',
	  cancel: 'im.call.cancel',
	  answer: 'im.call.answer',
	  decline: 'im.call.decline',
	  hangup: 'im.call.hangup',
	  ping: 'im.call.ping'
	};
	var pullEvents$2 = {
	  ping: 'Call::ping',
	  answer: 'Call::answer',
	  hangup: 'Call::hangup',
	  userInviteTimeout: 'Call::userInviteTimeout',
	  repeatAnswer: 'Call::repeatAnswer'
	};
	var clientEvents$1 = {
	  voiceStarted: 'Call::voiceStarted',
	  voiceStopped: 'Call::voiceStopped',
	  microphoneState: 'Call::microphoneState',
	  cameraState: 'Call::cameraState',
	  videoPaused: 'Call::videoPaused',
	  screenState: 'Call::screenState',
	  recordState: 'Call::recordState',
	  floorRequest: 'Call::floorRequest',
	  emotion: 'Call::emotion',
	  customMessage: 'Call::customMessage',
	  showUsers: 'Call::showUsers',
	  showAll: 'Call::showAll',
	  hideAll: 'Call::hideAll',
	  joinRoom: 'Call::joinRoom',
	  leaveRoom: 'Call::leaveRoom',
	  listRooms: 'Call::listRooms',
	  requestRoomSpeaker: 'Call::requestRoomSpeaker'
	};
	var scenarioEvents$1 = {
	  viewerJoined: 'Call::viewerJoined',
	  viewerLeft: 'Call::viewerLeft',
	  joinRoomOffer: 'Call::joinRoomOffer',
	  transferRoomHost: 'Call::transferRoomHost',
	  listRoomsResponse: 'Call::listRoomsResponse',
	  roomUpdated: 'Call::roomUpdated'
	};
	var VoximplantCallEvent = {
	  onCallConference: 'VoximplantCall::onCallConference'
	};
	var pingPeriod$2 = 5000;
	var backendPingPeriod$2 = 25000;
	var reinvitePeriod$2 = 5500;
	var connectionRestoreTime = 15000;

	// const MAX_USERS_WITHOUT_SIMULCAST = 6;
	var _showLocalVideo = /*#__PURE__*/new WeakSet();
	var _hideLocalVideo = /*#__PURE__*/new WeakSet();
	var _onCallConnected$1 = /*#__PURE__*/new WeakSet();
	var _onCallFailed$1 = /*#__PURE__*/new WeakSet();
	var _onPeerStateChanged$2 = /*#__PURE__*/new WeakMap();
	var _onPeerInviteTimeout$2 = /*#__PURE__*/new WeakMap();
	var _onPullEventAnswer$2 = /*#__PURE__*/new WeakMap();
	var _onPullEventHangup$2 = /*#__PURE__*/new WeakMap();
	var _onPullEventUsersJoined$2 = /*#__PURE__*/new WeakMap();
	var _onPullEventUsersInvited$2 = /*#__PURE__*/new WeakMap();
	var _onPullEventUserInviteTimeout$2 = /*#__PURE__*/new WeakMap();
	var _onPullEventPing$2 = /*#__PURE__*/new WeakMap();
	var _onNoPingsReceived$1 = /*#__PURE__*/new WeakMap();
	var _onNoSelfPingsReceived$1 = /*#__PURE__*/new WeakMap();
	var _onPullEventFinish$2 = /*#__PURE__*/new WeakMap();
	var _onPullEventRepeatAnswer$2 = /*#__PURE__*/new WeakMap();
	var _onLocalMediaRendererAdded$1 = /*#__PURE__*/new WeakMap();
	var _onBeforeLocalMediaRendererRemoved$1 = /*#__PURE__*/new WeakMap();
	var _onMicAccessResult$1 = /*#__PURE__*/new WeakMap();
	var _onCallReconnecting$1 = /*#__PURE__*/new WeakMap();
	var _onCallReconnected$1 = /*#__PURE__*/new WeakMap();
	var _onClientReconnecting = /*#__PURE__*/new WeakMap();
	var _onClientReconnected = /*#__PURE__*/new WeakMap();
	var _onCallDisconnected$1 = /*#__PURE__*/new WeakMap();
	var _onWindowUnload$1 = /*#__PURE__*/new WeakMap();
	var _onFatalError$1 = /*#__PURE__*/new WeakMap();
	var _setEndpointForUser = /*#__PURE__*/new WeakSet();
	var _onCallEndpointAdded = /*#__PURE__*/new WeakMap();
	var _onCallStatsReceived$1 = /*#__PURE__*/new WeakMap();
	var _onJoinRoomOffer = /*#__PURE__*/new WeakMap();
	var _onRoomUpdated = /*#__PURE__*/new WeakMap();
	var _onCallMessageReceived$1 = /*#__PURE__*/new WeakMap();
	var VoximplantCall = /*#__PURE__*/function (_AbstractCall) {
	  babelHelpers.inherits(VoximplantCall, _AbstractCall);
	  function VoximplantCall(config) {
	    var _this;
	    babelHelpers.classCallCheck(this, VoximplantCall);
	    _this = babelHelpers.possibleConstructorReturn(this, babelHelpers.getPrototypeOf(VoximplantCall).call(this, config));
	    _classPrivateMethodInitSpec$3(babelHelpers.assertThisInitialized(_this), _setEndpointForUser);
	    _classPrivateMethodInitSpec$3(babelHelpers.assertThisInitialized(_this), _onCallFailed$1);
	    _classPrivateMethodInitSpec$3(babelHelpers.assertThisInitialized(_this), _onCallConnected$1);
	    _classPrivateMethodInitSpec$3(babelHelpers.assertThisInitialized(_this), _hideLocalVideo);
	    _classPrivateMethodInitSpec$3(babelHelpers.assertThisInitialized(_this), _showLocalVideo);
	    babelHelpers.defineProperty(babelHelpers.assertThisInitialized(_this), "setMuted", function (event) {
	      if (_this.muted == event.data.isMicrophoneMuted) {
	        return;
	      }
	      _this.muted = event.data.isMicrophoneMuted;
	      if (_this.voximplantCall) {
	        if (_this.muted) {
	          _this.voximplantCall.muteMicrophone();
	        } else {
	          _this.voximplantCall.unmuteMicrophone();
	        }
	        _this.signaling.sendMicrophoneState(!_this.muted);
	      }
	    });
	    babelHelpers.defineProperty(babelHelpers.assertThisInitialized(_this), "setVideoEnabled", function (event) {
	      if (_this.videoEnabled == event.data.isCameraOn) {
	        return;
	      }
	      _this.videoEnabled = event.data.isCameraOn;
	      if (_this.voximplantCall) {
	        if (_this.videoEnabled) {
	          _classPrivateMethodGet$3(babelHelpers.assertThisInitialized(_this), _showLocalVideo, _showLocalVideo2).call(babelHelpers.assertThisInitialized(_this));
	        } else {
	          if (_this.localVideoShown) {
	            VoxImplant.Hardware.StreamManager.get().hideLocalVideo().then(function () {
	              _this.localVideoShown = false;
	              _this.runCallback(CallEvent.onLocalMediaReceived, {
	                tag: "main",
	                stream: new MediaStream()
	              });
	            });
	          }
	        }
	        _this.voximplantCall.sendVideo(_this.videoEnabled);
	        _this.signaling.sendCameraState(_this.videoEnabled);
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onPeerStateChanged$2, {
	      writable: true,
	      value: function value(e) {
	        _this.runCallback(CallEvent.onUserStateChanged, e);
	        if (!_this.ready) {
	          return;
	        }
	        if (e.state == UserState.Failed || e.state == UserState.Unavailable || e.state == UserState.Declined || e.state == UserState.Idle) {
	          if (_this.type == CallType.Instant && !_this.isAnyoneParticipating()) {
	            _this.hangup();
	          }
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onPeerInviteTimeout$2, {
	      writable: true,
	      value: function value(e) {
	        if (!_this.ready) {
	          return;
	        }
	        _this.signaling.sendUserInviteTimeout({
	          userId: _this.users,
	          failedUserId: e.userId
	        });
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onPullEventAnswer$2, {
	      writable: true,
	      value: function value(params) {
	        var senderId = Number(params.senderId);
	        if (senderId == _this.userId) {
	          return _this.__onPullEventAnswerSelf(params);
	        }
	        if (!_this.peers[senderId]) {
	          _this.peers[senderId] = _this.createPeer(senderId);
	          _this.runCallback(CallEvent.onUserInvited, {
	            userId: senderId
	          });
	        }
	        if (!_this.users.includes(senderId)) {
	          _this.users.push(senderId);
	        }
	        _this.peers[senderId].setReady(true);
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onPullEventHangup$2, {
	      writable: true,
	      value: function value(params) {
	        var senderId = params.senderId;
	        if (_this.userId == senderId && _this.instanceId != params.callInstanceId) {
	          // Call declined by the same user elsewhere
	          _this.runCallback(CallEvent.onLeave, {
	            local: false
	          });
	          return;
	        }
	        if (!_this.peers[senderId]) {
	          return;
	        }
	        _this.peers[senderId].setReady(false);
	        if (params.code == 603) {
	          _this.peers[senderId].setDeclined(true);
	        } else if (params.code == 486) {
	          _this.peers[senderId].setBusy(true);
	          console.error("user " + senderId + " is busy");
	        }
	        if (_this.ready && _this.type == CallType.Instant && !_this.isAnyoneParticipating()) {
	          _this.hangup();
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onPullEventUsersJoined$2, {
	      writable: true,
	      value: function value(params) {
	        _this.log('__onPullEventUsersJoined', params);
	        var users = params.users;
	        _this.addJoinedUsers(users);
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onPullEventUsersInvited$2, {
	      writable: true,
	      value: function value(params) {
	        _this.log('__onPullEventUsersInvited', params);
	        var users = params.users;
	        if (_this.type === CallType.Instant) {
	          _this.addInvitedUsers(users);
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onPullEventUserInviteTimeout$2, {
	      writable: true,
	      value: function value(params) {
	        _this.log('__onPullEventUserInviteTimeout', params);
	        var failedUserId = params.failedUserId;
	        if (_this.peers[failedUserId]) {
	          _this.peers[failedUserId].onInviteTimeout(false);
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onPullEventPing$2, {
	      writable: true,
	      value: function value(params) {
	        if (params.callInstanceId == _this.instanceId) {
	          // ignore self ping
	          return;
	        }
	        var senderId = Number(params.senderId);
	        if (senderId == _this.userId) {
	          if (!_this.joinedElsewhere) {
	            _this.runCallback(CallEvent.onJoin, {
	              local: false
	            });
	            _this.joinedElsewhere = true;
	          }
	          clearTimeout(_this.lastSelfPingReceivedTimeout);
	          _this.lastSelfPingReceivedTimeout = setTimeout(babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onNoSelfPingsReceived$1), pingPeriod$2 * 2.1);
	        }
	        clearTimeout(_this.lastPingReceivedTimeout);
	        _this.lastPingReceivedTimeout = setTimeout(babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onNoPingsReceived$1), pingPeriod$2 * 2.1);
	        if (_this.peers[senderId]) {
	          _this.peers[senderId].setReady(true);
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onNoPingsReceived$1, {
	      writable: true,
	      value: function value() {
	        if (!_this.ready) {
	          _this.destroy();
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onNoSelfPingsReceived$1, {
	      writable: true,
	      value: function value() {
	        _this.runCallback(CallEvent.onLeave, {
	          local: false
	        });
	        _this.joinedElsewhere = false;
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onPullEventFinish$2, {
	      writable: true,
	      value: function value() {
	        _this.destroy();
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onPullEventRepeatAnswer$2, {
	      writable: true,
	      value: function value() {
	        if (_this.ready) {
	          _this.signaling.sendAnswer({
	            userId: _this.userId
	          }, true);
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onLocalMediaRendererAdded$1, {
	      writable: true,
	      value: function value(e) {
	        var renderer = e.renderer;
	        var trackLabel = renderer.stream.getVideoTracks().length > 0 ? renderer.stream.getVideoTracks()[0].label : "";
	        _this.log("__onLocalMediaRendererAdded", renderer.kind, trackLabel);
	        if (renderer.kind === "video") {
	          var tag;
	          if (trackLabel.match(/^screen|window|tab|web-contents-media-stream/i)) {
	            tag = "screen";
	          } else {
	            tag = "main";
	          }
	          _this.screenShared = tag === "screen";
	          _this.runCallback(CallEvent.onLocalMediaReceived, {
	            tag: tag,
	            stream: renderer.stream
	          });
	        } else if (renderer.kind === "sharing") {
	          _this.runCallback(CallEvent.onLocalMediaReceived, {
	            tag: "screen",
	            stream: renderer.stream
	          });
	          _this.screenShared = true;
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onBeforeLocalMediaRendererRemoved$1, {
	      writable: true,
	      value: function value(e) {
	        var renderer = e.renderer;
	        _this.log("__onBeforeLocalMediaRendererRemoved", renderer.kind);
	        if (renderer.kind === "sharing" && !Hardware.isCameraOn) {
	          _this.runCallback(CallEvent.onLocalMediaReceived, {
	            tag: "main",
	            stream: new MediaStream()
	          });
	          _this.screenShared = false;
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onMicAccessResult$1, {
	      writable: true,
	      value: function value(e) {
	        if (_this.ready && e.result) {
	          if (e.stream.getAudioTracks().length > 0) {
	            if (_this.localVAD) {
	              _this.localVAD.destroy();
	            }
	            _this.localVAD = new SimpleVAD({
	              mediaStream: e.stream,
	              onVoiceStarted: function onVoiceStarted() {
	                _this.runCallback(CallEvent.onUserVoiceStarted, {
	                  userId: _this.userId,
	                  local: true
	                });
	              },
	              onVoiceStopped: function onVoiceStopped() {
	                _this.runCallback(CallEvent.onUserVoiceStopped, {
	                  userId: _this.userId,
	                  local: true
	                });
	              }
	            });
	            clearInterval(_this.microphoneLevelInterval);
	            _this.microphoneLevelInterval = setInterval(function () {
	              return _this.microphoneLevel = _this.localVAD.currentVolume;
	            }, 200);
	          }
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onCallReconnecting$1, {
	      writable: true,
	      value: function value() {
	        _this.reconnectionEventCount++;
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onCallReconnected$1, {
	      writable: true,
	      value: function value() {
	        _this.reconnectionEventCount--;
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onClientReconnecting, {
	      writable: true,
	      value: function value() {
	        _this.reconnectionEventCount++;
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onClientReconnected, {
	      writable: true,
	      value: function value() {
	        _this.reconnectionEventCount--;
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onCallDisconnected$1, {
	      writable: true,
	      value: function value(e) {
	        _this.log("__onCallDisconnected", e && e.headers ? {
	          headers: e.headers
	        } : null);
	        _this.sendTelemetryEvent("disconnect");
	        _this.localUserState = UserState.Idle;
	        _this.ready = false;
	        _this.joinedAsViewer = false;
	        _this.reinitPeers();
	        _classPrivateMethodGet$3(babelHelpers.assertThisInitialized(_this), _hideLocalVideo, _hideLocalVideo2).call(babelHelpers.assertThisInitialized(_this));
	        _this.removeCallEvents();
	        _this.unsubscribeHardwareChanges();
	        _this.voximplantCall = null;
	        var client = VoxImplant.getInstance();
	        client.enableSilentLogging(false);
	        client.setLoggerCallback(null);
	        _this.state = CallState.Proceeding;
	        _this.runCallback(CallEvent.onLeave, {
	          local: true
	        });
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onWindowUnload$1, {
	      writable: true,
	      value: function value() {
	        if (_this.ready && _this.voximplantCall) {
	          _this.signaling.sendHangup({
	            userId: _this.users
	          });
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onFatalError$1, {
	      writable: true,
	      value: function value(error) {
	        if (error && error.call) {
	          delete error.call;
	        }
	        _this.log("onFatalError", error);
	        _this.ready = false;
	        _this.localUserState = UserState.Failed;
	        _this.reinitPeers();
	        _classPrivateMethodGet$3(babelHelpers.assertThisInitialized(_this), _hideLocalVideo, _hideLocalVideo2).call(babelHelpers.assertThisInitialized(_this)).then(function () {
	          if (_this.voximplantCall) {
	            _this.removeCallEvents();
	            _this.unsubscribeHardwareChanges();
	            try {
	              _this.voximplantCall.hangup({
	                'X-Reason': 'Fatal error',
	                'X-Error': typeof error === 'string' ? error : error.code || error.name
	              });
	            } catch (e) {
	              _this.log("Voximplant hangup error: ", e);
	              console.error("Voximplant hangup error: ", e);
	            }
	            _this.voximplantCall = null;
	          }
	          if (typeof VoxImplant !== 'undefined') {
	            var client = VoxImplant.getInstance();
	            client.enableSilentLogging(false);
	            client.setLoggerCallback(null);
	          }
	          if (typeof error === "string") {
	            _this.runCallback(CallEvent.onCallFailure, {
	              name: error
	            });
	          } else if (error.name) {
	            _this.runCallback(CallEvent.onCallFailure, error);
	          }
	        });
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onCallEndpointAdded, {
	      writable: true,
	      value: function value(e) {
	        var endpoint = e.endpoint;
	        var userName = endpoint.userName;
	        _this.log("__onCallEndpointAdded (" + userName + ")", e.endpoint);
	        console.log("__onCallEndpointAdded (" + userName + ")", e.endpoint);
	        if (main_core.Type.isStringFilled(userName) && userName.startsWith('user')) {
	          _classPrivateMethodGet$3(babelHelpers.assertThisInitialized(_this), _setEndpointForUser, _setEndpointForUser2).call(babelHelpers.assertThisInitialized(_this), userName, endpoint);
	        } else {
	          endpoint.addEventListener(VoxImplant.EndpointEvents.InfoUpdated, function (e) {
	            var endpoint = e.endpoint;
	            var userName = endpoint.userName;
	            _this.log("VoxImplant.EndpointEvents.InfoUpdated (" + userName + ")", e.endpoint);
	            if (main_core.Type.isStringFilled(userName) && userName.startsWith('user')) {
	              _classPrivateMethodGet$3(babelHelpers.assertThisInitialized(_this), _setEndpointForUser, _setEndpointForUser2).call(babelHelpers.assertThisInitialized(_this), userName, endpoint);
	            }
	          });
	          _this.log('Unknown endpoint ' + userName);
	          console.warn('Unknown endpoint ' + userName);
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onCallStatsReceived$1, {
	      writable: true,
	      value: function value(e) {
	        if (_this.logger) {
	          _this.logger.sendStat(transformVoxStats$1(e.stats, _this.voximplantCall));
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onJoinRoomOffer, {
	      writable: true,
	      value: function value(e) {
	        console.warn("__onJoinRoomOffer", e);
	        _this.updateRoom({
	          id: e.roomId,
	          users: e.users,
	          speaker: e.speaker
	        });
	        _this.runCallback(CallEvent.onJoinRoomOffer, {
	          roomId: e.roomId,
	          users: e.users,
	          initiator: e.initiator,
	          speaker: e.speaker
	        });
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onRoomUpdated, {
	      writable: true,
	      value: function value(e) {
	        var speakerChanged = e.roomId === _this._currentRoomId && _this.rooms[e.roomId] && _this.rooms[e.roomId].speaker != e.speaker;
	        var previousSpeaker = speakerChanged && _this.rooms[e.roomId].speaker;
	        console.log("__onRoomUpdated; speakerChanged: ", speakerChanged);
	        _this.updateRoom({
	          id: e.roomId,
	          users: e.users,
	          speaker: e.speaker
	        });
	        if (e.roomId === _this._currentRoomId && e.users.indexOf(_this.userId) === -1) {
	          _this._currentRoomId = null;
	          _this.runCallback(CallEvent.onLeaveRoom, {
	            roomId: e.roomId
	          });
	        } else if (e.roomId !== _this._currentRoomId && e.users.indexOf(_this.userId) !== -1) {
	          _this._currentRoomId = e.roomId;
	          _this.runCallback(CallEvent.onJoinRoom, {
	            roomId: e.roomId,
	            speaker: _this.currentRoom().speaker,
	            users: _this.currentRoom().users
	          });
	        } else if (speakerChanged) {
	          _this.runCallback(CallEvent.onTransferRoomSpeaker, {
	            roomId: e.roomId,
	            speaker: e.speaker,
	            previousSpeaker: previousSpeaker,
	            initiator: e.initiator
	          });
	        }
	      }
	    });
	    _classPrivateFieldInitSpec$2(babelHelpers.assertThisInitialized(_this), _onCallMessageReceived$1, {
	      writable: true,
	      value: function value(e) {
	        var message;
	        var peer;
	        try {
	          message = JSON.parse(e.text);
	        } catch (err) {
	          _this.log("Could not parse scenario message.", err);
	          return;
	        }
	        var eventName = message.eventName;
	        if (eventName === clientEvents$1.voiceStarted) {
	          // todo: remove after switching to SDK VAD events
	          _this.runCallback(CallEvent.onUserVoiceStarted, {
	            userId: message.senderId
	          });
	        } else if (eventName === clientEvents$1.voiceStopped) {
	          // todo: remove after switching to SDK VAD events
	          _this.runCallback(CallEvent.onUserVoiceStopped, {
	            userId: message.senderId
	          });
	        } else if (eventName === clientEvents$1.microphoneState) {
	          _this.runCallback(CallEvent.onUserMicrophoneState, {
	            userId: message.senderId,
	            microphoneState: message.microphoneState === "Y"
	          });
	        } else if (eventName === clientEvents$1.cameraState) {
	          _this.runCallback(CallEvent.onUserCameraState, {
	            userId: message.senderId,
	            cameraState: message.cameraState === "Y"
	          });
	        } else if (eventName === clientEvents$1.videoPaused) {
	          _this.runCallback(CallEvent.onUserVideoPaused, {
	            userId: message.senderId,
	            videoPaused: message.videoPaused === "Y"
	          });
	        } else if (eventName === clientEvents$1.screenState) {
	          _this.runCallback(CallEvent.onUserScreenState, {
	            userId: message.senderId,
	            screenState: message.screenState === "Y"
	          });
	        } else if (eventName === clientEvents$1.recordState) {
	          _this.runCallback(CallEvent.onUserRecordState, {
	            userId: message.senderId,
	            recordState: message.recordState
	          });
	        } else if (eventName === clientEvents$1.floorRequest) {
	          _this.runCallback(CallEvent.onUserFloorRequest, {
	            userId: message.senderId,
	            requestActive: message.requestActive === "Y"
	          });
	        } else if (eventName === clientEvents$1.emotion) {
	          _this.runCallback(CallEvent.onUserEmotion, {
	            userId: message.senderId,
	            toUserId: message.toUserId,
	            emotion: message.emotion
	          });
	        } else if (eventName === clientEvents$1.customMessage) {
	          _this.runCallback(CallEvent.onCustomMessage, {
	            message: message.message
	          });
	        } else if (eventName === "scenarioLogUrl") {
	          console.warn("scenario log url: " + message.logUrl);
	        } else if (eventName === scenarioEvents$1.joinRoomOffer) {
	          console.log(message);
	          babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onJoinRoomOffer).call(babelHelpers.assertThisInitialized(_this), message);
	        } else if (eventName === scenarioEvents$1.roomUpdated) {
	          // console.log(message)
	          babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onRoomUpdated).call(babelHelpers.assertThisInitialized(_this), message);
	        } else if (eventName === scenarioEvents$1.listRoomsResponse) {
	          if (_this.__resolveListRooms) {
	            _this.__resolveListRooms(message.rooms);
	            delete _this.__resolveListRooms;
	          }
	        } else if (eventName === scenarioEvents$1.viewerJoined) {
	          console.log("viewer " + message.senderId + " joined");
	          peer = _this.peers[message.senderId];
	          if (peer) {
	            peer.setDirection(EndpointDirection.RecvOnly);
	            peer.setReady(true);
	          }
	        } else if (eventName === scenarioEvents$1.viewerLeft) {
	          console.log("viewer " + message.senderId + " left");
	          peer = _this.peers[message.senderId];
	          if (peer) {
	            peer.setReady(false);
	          }
	        } else {
	          _this.log("Unknown scenario event " + eventName);
	        }
	      }
	    });
	    _this.debug = config.debug;
	    _this.videoQuality = Quality.VeryHigh; // initial video quality. will drop on new peers connecting

	    _this.voximplantCall = null;
	    _this.signaling = new Signaling$2({
	      call: babelHelpers.assertThisInitialized(_this)
	    });
	    _this.peers = {};
	    _this.joinedElsewhere = false;
	    _this.joinedAsViewer = false;
	    _this.localVideoShown = false;
	    _this._localUserState = UserState.Idle;
	    _this.clientEventsBound = false;
	    _this._screenShared = false;
	    _this.videoAllowedFrom = UserMnemonic.all;
	    _this.direction = EndpointDirection.SendRecv;
	    _this.microphoneLevelInterval = null;
	    _this.rooms = {};
	    window.addEventListener("unload", babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onWindowUnload$1));
	    _this.initPeers();
	    _this.pingUsersInterval = setInterval(_this.pingUsers.bind(babelHelpers.assertThisInitialized(_this)), pingPeriod$2);
	    _this.pingBackendInterval = setInterval(_this.pingBackend.bind(babelHelpers.assertThisInitialized(_this)), backendPingPeriod$2);
	    _this.lastPingReceivedTimeout = null;
	    _this.lastSelfPingReceivedTimeout = null;
	    _this.reinviteTimeout = null;

	    // There are two kinds of reconnection events: from call (for media connection) and from client (for signaling).
	    // So we have to use counter to convert these two events to one
	    _this._reconnectionEventCount = 0;
	    _this.pullEventHandlers = {
	      'Call::answer': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventAnswer$2),
	      'Call::hangup': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventHangup$2),
	      'Call::usersJoined': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventUsersJoined$2),
	      'Call::usersInvited': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventUsersInvited$2),
	      'Call::userInviteTimeout': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventUserInviteTimeout$2),
	      'Call::ping': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventPing$2),
	      'Call::finish': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventFinish$2),
	      'Call::repeatAnswer': babelHelpers.classPrivateFieldGet(babelHelpers.assertThisInitialized(_this), _onPullEventRepeatAnswer$2)
	    };
	    return _this;
	  }
	  babelHelpers.createClass(VoximplantCall, [{
	    key: "initPeers",
	    value: function initPeers() {
	      var _this2 = this;
	      this.users.forEach(function (userId) {
	        userId = Number(userId);
	        _this2.peers[userId] = _this2.createPeer(userId);
	      });
	    }
	  }, {
	    key: "reinitPeers",
	    value: function reinitPeers() {
	      for (var userId in this.peers) {
	        if (this.peers.hasOwnProperty(userId) && this.peers[userId]) {
	          this.peers[userId].destroy();
	          this.peers[userId] = null;
	        }
	      }
	      this.initPeers();
	    }
	  }, {
	    key: "pingUsers",
	    value: function pingUsers() {
	      if (this.ready) {
	        var users = this.users.concat(this.userId);
	        this.signaling.sendPingToUsers({
	          userId: users
	        }, true);
	      }
	    }
	  }, {
	    key: "pingBackend",
	    value: function pingBackend() {
	      if (this.ready) {
	        this.signaling.sendPingToBackend();
	      }
	    }
	  }, {
	    key: "createPeer",
	    value: function createPeer(userId) {
	      var _this3 = this;
	      var incomingVideoAllowed;
	      if (this.videoAllowedFrom === UserMnemonic.all) {
	        incomingVideoAllowed = true;
	      } else if (this.videoAllowedFrom === UserMnemonic.none) {
	        incomingVideoAllowed = false;
	      } else if (main_core.Type.isArray(this.videoAllowedFrom)) {
	        incomingVideoAllowed = this.videoAllowedFrom.some(function (allowedUserId) {
	          return allowedUserId == userId;
	        });
	      } else {
	        incomingVideoAllowed = true;
	      }
	      return new Peer$2({
	        call: this,
	        userId: userId,
	        ready: userId == this.initiatorId,
	        isIncomingVideoAllowed: incomingVideoAllowed,
	        onMediaReceived: function onMediaReceived(e) {
	          _this3.runCallback(CallEvent.onRemoteMediaReceived, e);
	          if (e.kind === 'video') {
	            _this3.runCallback(CallEvent.onUserVideoPaused, {
	              userId: userId,
	              videoPaused: false
	            });
	          }
	        },
	        onMediaRemoved: function onMediaRemoved(e) {
	          _this3.runCallback(CallEvent.onRemoteMediaStopped, e);
	        },
	        onMediaRenderEnabled: function onMediaRenderEnabled(e) {
	          var endpoint = e.endpoint;
	          var userName = endpoint.userName;
	          // user connected to conference (userName is in format `user${id}`
	          var userId = parseInt(userName.substring(4));
	          if (_this3.peers[userId]) {
	            _this3.runCallback(CallEvent.onBadNetworkIndicator, {
	              userId: userId,
	              badNetworkIndicator: false
	            });
	          }
	        },
	        onMediaRenderDisabled: function onMediaRenderDisabled(e) {
	          var endpoint = e.endpoint;
	          var userName = endpoint.userName;
	          if (main_core.Type.isStringFilled(userName) && userName.startsWith('user')) {
	            var _userId = parseInt(userName.substring(4));
	            if (_this3.peers[_userId] && e.reason === 'disabledByServer') {
	              _this3.runCallback(CallEvent.onBadNetworkIndicator, {
	                userId: _userId,
	                badNetworkIndicator: true
	              });
	            }
	          }
	        },
	        onVoiceStarted: function onVoiceStarted() {
	          // todo: uncomment to switch to SDK VAD events
	          /*this.runCallback(Event.onUserVoiceStarted, {
	          	userId: userId
	          });*/
	        },
	        onVoiceEnded: function onVoiceEnded() {
	          // todo: uncomment to switch to SDK VAD events
	          /*this.runCallback(Event.onUserVoiceStopped, {
	          	userId: userId
	          });*/
	        },
	        onStateChanged: babelHelpers.classPrivateFieldGet(this, _onPeerStateChanged$2),
	        onInviteTimeout: babelHelpers.classPrivateFieldGet(this, _onPeerInviteTimeout$2)
	      });
	    }
	  }, {
	    key: "getUsers",
	    value: function getUsers() {
	      var result = {};
	      for (var userId in this.peers) {
	        result[userId] = this.peers[userId].calculatedState;
	      }
	      return result;
	    }
	  }, {
	    key: "getUserCount",
	    value: function getUserCount() {
	      return Object.keys(this.peers).length;
	    }
	  }, {
	    key: "getClient",
	    value: function getClient() {
	      var _this4 = this;
	      return new Promise(function (resolve, reject) {
	        BX.Voximplant.getClient({
	          debug: _this4.debug,
	          restClient: CallEngine.getRestClient()
	        }).then(function (client) {
	          client.enableSilentLogging();
	          client.setLoggerCallback(function (e) {
	            return _this4.log(e.label + ": " + e.message);
	          });
	          _this4.log("User agent: " + navigator.userAgent);
	          _this4.log("Voximplant SDK version: " + VoxImplant.version);
	          _this4.bindClientEvents();
	          resolve(client);
	        })["catch"](reject);
	      });
	    }
	  }, {
	    key: "bindClientEvents",
	    value: function bindClientEvents() {
	      var streamManager = VoxImplant.Hardware.StreamManager.get();
	      if (!this.clientEventsBound) {
	        VoxImplant.getInstance().on(VoxImplant.Events.MicAccessResult, babelHelpers.classPrivateFieldGet(this, _onMicAccessResult$1));
	        if (VoxImplant.Events.Reconnecting) {
	          VoxImplant.getInstance().on(VoxImplant.Events.Reconnecting, babelHelpers.classPrivateFieldGet(this, _onClientReconnecting));
	          VoxImplant.getInstance().on(VoxImplant.Events.Reconnected, babelHelpers.classPrivateFieldGet(this, _onClientReconnected));
	        }

	        // streamManager.on(VoxImplant.Hardware.HardwareEvents.DevicesUpdated, this.#onLocalDevicesUpdated);
	        streamManager.on(VoxImplant.Hardware.HardwareEvents.MediaRendererAdded, babelHelpers.classPrivateFieldGet(this, _onLocalMediaRendererAdded$1));
	        streamManager.on(VoxImplant.Hardware.HardwareEvents.MediaRendererUpdated, babelHelpers.classPrivateFieldGet(this, _onLocalMediaRendererAdded$1));
	        streamManager.on(VoxImplant.Hardware.HardwareEvents.BeforeMediaRendererRemoved, babelHelpers.classPrivateFieldGet(this, _onBeforeLocalMediaRendererRemoved$1));
	        this.clientEventsBound = true;
	      }
	    }
	  }, {
	    key: "removeClientEvents",
	    value: function removeClientEvents() {
	      if (!('VoxImplant' in window)) {
	        return;
	      }
	      VoxImplant.getInstance().off(VoxImplant.Events.MicAccessResult, babelHelpers.classPrivateFieldGet(this, _onMicAccessResult$1));
	      if (VoxImplant.Events.Reconnecting) {
	        VoxImplant.getInstance().off(VoxImplant.Events.Reconnecting, babelHelpers.classPrivateFieldGet(this, _onClientReconnecting));
	        VoxImplant.getInstance().off(VoxImplant.Events.Reconnected, babelHelpers.classPrivateFieldGet(this, _onClientReconnected));
	      }
	      var streamManager = VoxImplant.Hardware.StreamManager.get();
	      // streamManager.off(VoxImplant.Hardware.HardwareEvents.DevicesUpdated, this.#onLocalDevicesUpdated);
	      streamManager.off(VoxImplant.Hardware.HardwareEvents.MediaRendererAdded, babelHelpers.classPrivateFieldGet(this, _onLocalMediaRendererAdded$1));
	      streamManager.off(VoxImplant.Hardware.HardwareEvents.BeforeMediaRendererRemoved, babelHelpers.classPrivateFieldGet(this, _onBeforeLocalMediaRendererRemoved$1));
	      this.clientEventsBound = false;
	    }
	  }, {
	    key: "setCameraId",
	    value: function setCameraId(cameraId) {
	      var _this5 = this;
	      if (this.cameraId == cameraId) {
	        return;
	      }
	      this.cameraId = cameraId;
	      if (this.voximplantCall) {
	        VoxImplant.Hardware.CameraManager.get().getInputDevices().then(function () {
	          VoxImplant.Hardware.CameraManager.get().setCallVideoSettings(_this5.voximplantCall, _this5.constructCameraParams());
	        });
	      }
	    }
	  }, {
	    key: "setMicrophoneId",
	    value: function setMicrophoneId(microphoneId) {
	      var _this6 = this;
	      if (this.microphoneId == microphoneId) {
	        return;
	      }
	      this.microphoneId = microphoneId;
	      if (this.voximplantCall) {
	        VoxImplant.Hardware.AudioDeviceManager.get().getInputDevices().then(function () {
	          VoxImplant.Hardware.AudioDeviceManager.get().setCallAudioSettings(_this6.voximplantCall, {
	            inputId: _this6.microphoneId
	          });
	        });
	      }
	    }
	  }, {
	    key: "getCurrentMicrophoneId",
	    value: function getCurrentMicrophoneId() {
	      if (this.voximplantCall.peerConnection.impl.getTransceivers) {
	        var transceivers = this.voximplantCall.peerConnection.impl.getTransceivers();
	        if (transceivers.length > 0) {
	          var audioTrack = transceivers[0].sender.track;
	          var audioTrackSettings = audioTrack.getSettings();
	          return audioTrackSettings.deviceId;
	        }
	      }
	      return this.microphoneId;
	    }
	  }, {
	    key: "constructCameraParams",
	    value: function constructCameraParams() {
	      var result = {};
	      if (this.cameraId) {
	        result.cameraId = this.cameraId;
	      }
	      result.videoQuality = this.videoHd ? VoxImplant.Hardware.VideoQuality.VIDEO_SIZE_HD : VoxImplant.Hardware.VideoQuality.VIDEO_SIZE_nHD;
	      result.facingMode = true;
	      return result;
	    }
	  }, {
	    key: "useHdVideo",
	    value: function useHdVideo(flag) {
	      this.videoHd = flag === true;
	    }
	  }, {
	    key: "requestFloor",
	    value: function requestFloor(requestActive) {
	      this.signaling.sendFloorRequest(requestActive);
	    }
	  }, {
	    key: "sendRecordState",
	    value: function sendRecordState(recordState) {
	      this.signaling.sendRecordState(recordState);
	    }
	  }, {
	    key: "sendEmotion",
	    value: function sendEmotion(toUserId, emotion) {
	      this.signaling.sendEmotion(toUserId, emotion);
	    }
	  }, {
	    key: "sendCustomMessage",
	    value: function sendCustomMessage(message, repeatOnConnect) {
	      this.signaling.sendCustomMessage(message, repeatOnConnect);
	    }
	  }, {
	    key: "allowVideoFrom",
	    /**
	     * Updates list of users,
	     */
	    value: function allowVideoFrom(userList) {
	      if (this.videoAllowedFrom == userList) {
	        return;
	      }
	      this.videoAllowedFrom = userList;
	      if (userList === UserMnemonic.all) {
	        this.signaling.sendShowAll();
	        userList = Object.keys(this.peers);
	      } else if (userList === UserMnemonic.none) {
	        this.signaling.sendHideAll();
	        userList = [];
	      } else if (main_core.Type.isArray(userList)) {
	        this.signaling.sendShowUsers(userList);
	      } else {
	        throw new Error("userList is in wrong format");
	      }
	      var users = {};
	      userList.forEach(function (userId) {
	        return users[userId] = true;
	      });
	      for (var userId in this.peers) {
	        if (!this.peers.hasOwnProperty(userId)) {
	          continue;
	        }
	        if (users[userId]) {
	          this.peers[userId].allowIncomingVideo(true);
	        } else {
	          this.peers[userId].allowIncomingVideo(false);
	        }
	      }
	    }
	  }, {
	    key: "startScreenSharing",
	    value: function startScreenSharing() {
	      var _this7 = this;
	      if (!this.voximplantCall) {
	        return;
	      }
	      var showLocalView = !Hardware.isCameraOn;
	      var replaceTrack = Hardware.isCameraOn || this.screenShared;
	      this.voximplantCall.shareScreen(showLocalView, replaceTrack).then(function () {
	        _this7.log("Screen shared");
	        _this7.screenShared = true;
	      })["catch"](function (error) {
	        console.error(error);
	        _this7.log("Screen sharing error:", error);
	      });
	    }
	  }, {
	    key: "stopScreenSharing",
	    value: function stopScreenSharing() {
	      var _this8 = this;
	      if (!this.voximplantCall) {
	        return;
	      }
	      this.voximplantCall.stopSharingScreen().then(function () {
	        _this8.log("Screen is no longer shared");
	        _this8.screenShared = false;
	      });
	    }
	  }, {
	    key: "isScreenSharingStarted",
	    value: function isScreenSharingStarted() {
	      return this.screenShared;
	    }
	  }, {
	    key: "inviteUsers",
	    /**
	     * Invites users to participate in the call.
	     */
	    value: function inviteUsers() {
	      var _this9 = this;
	      var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      this.ready = true;
	      var users = main_core.Type.isArray(config.users) ? config.users : this.users;
	      this.attachToConference().then(function () {
	        _this9.signaling.sendPingToUsers({
	          userId: users
	        });
	        if (users.length > 0) {
	          return _this9.signaling.inviteUsers({
	            userIds: users,
	            video: Hardware.isCameraOn ? 'Y' : 'N'
	          });
	        }
	      }).then(function () {
	        _this9.state = CallState.Connected;
	        _this9.runCallback(CallEvent.onJoin, {
	          local: true
	        });
	        for (var i = 0; i < users.length; i++) {
	          var userId = parseInt(users[i]);
	          if (!_this9.users.includes(userId)) {
	            _this9.users.push(userId);
	          }
	          if (!_this9.peers[userId]) {
	            _this9.peers[userId] = _this9.createPeer(userId);
	            if (_this9.type === CallType.Instant) {
	              _this9.runCallback(CallEvent.onUserInvited, {
	                userId: userId
	              });
	            }
	          }
	          if (_this9.type === CallType.Instant) {
	            _this9.peers[userId].onInvited();
	            _this9.scheduleRepeatInvite();
	          }
	        }
	      })["catch"](function (e) {
	        babelHelpers.classPrivateFieldGet(_this9, _onFatalError$1).call(_this9, e);
	      });
	    }
	  }, {
	    key: "scheduleRepeatInvite",
	    value: function scheduleRepeatInvite() {
	      var _this10 = this;
	      clearTimeout(this.reinviteTimeout);
	      this.reinviteTimeout = setTimeout(function () {
	        return _this10.repeatInviteUsers();
	      }, reinvitePeriod$2);
	    }
	  }, {
	    key: "repeatInviteUsers",
	    value: function repeatInviteUsers() {
	      var _this11 = this;
	      clearTimeout(this.reinviteTimeout);
	      if (!this.ready) {
	        return;
	      }
	      var usersToRepeatInvite = [];
	      for (var userId in this.peers) {
	        if (this.peers.hasOwnProperty(userId) && this.peers[userId].calculatedState === UserState.Calling) {
	          usersToRepeatInvite.push(userId);
	        }
	      }
	      if (usersToRepeatInvite.length === 0) {
	        return;
	      }
	      var inviteParams = {
	        userIds: usersToRepeatInvite,
	        video: Hardware.isCameraOn ? 'Y' : 'N',
	        repeated: 'Y'
	      };
	      this.signaling.inviteUsers(inviteParams).then(function () {
	        return _this11.scheduleRepeatInvite();
	      });
	    }
	  }, {
	    key: "answer",
	    /**
	     * @param {Object} config
	     * @param {bool?} [config.useVideo]
	     * @param {bool?} [config.joinAsViewer]
	     */
	    value: function answer() {
	      var _this12 = this;
	      var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      this.ready = true;
	      var joinAsViewer = config.joinAsViewer === true;
	      this.videoEnabled = Hardware.isCameraOn;
	      this.muted = Hardware.isMicrophoneMuted;
	      if (!joinAsViewer) {
	        this.signaling.sendAnswer();
	      }
	      this.attachToConference({
	        joinAsViewer: joinAsViewer
	      }).then(function () {
	        _this12.log("Attached to conference");
	        _this12.state = CallState.Connected;
	        _this12.runCallback(CallEvent.onJoin, {
	          local: true
	        });
	      })["catch"](function (err) {
	        babelHelpers.classPrivateFieldGet(_this12, _onFatalError$1).call(_this12, err);
	      });
	    }
	  }, {
	    key: "decline",
	    value: function decline(code) {
	      this.ready = false;
	      var data = {
	        callId: this.id,
	        callInstanceId: this.instanceId
	      };
	      if (code) {
	        data.code = code;
	      }
	      CallEngine.getRestClient().callMethod(ajaxActions$2.decline, data);
	    }
	  }, {
	    key: "hangup",
	    value: function hangup(code, reason) {
	      if (!this.ready) {
	        var error = new Error("Hangup in wrong state");
	        this.log(error);
	        return;
	      }
	      var tempError = new Error();
	      tempError.name = "Call stack:";
	      this.log("Hangup received \n" + tempError.stack);
	      if (this.localVAD) {
	        this.localVAD.destroy();
	        this.localVAD = null;
	      }
	      clearInterval(this.microphoneLevelInterval);
	      var data = {};
	      this.ready = false;
	      if (typeof code != 'undefined') {
	        data.code = code;
	      }
	      if (typeof reason != 'undefined') {
	        data.reason = reason;
	      }
	      this.state = CallState.Proceeding;
	      this.runCallback(CallEvent.onLeave, {
	        local: true
	      });

	      //clone users and append current user id to send event to all participants of the call
	      data.userId = this.users.slice(0).concat(this.userId);
	      this.signaling.sendHangup(data);

	      // for future reconnections
	      this.reinitPeers();
	      if (this.voximplantCall) {
	        this.voximplantCall._replaceVideoSharing = false;
	        try {
	          this.voximplantCall.hangup();
	        } catch (e) {
	          this.log("Voximplant hangup error: ", e);
	          console.error("Voximplant hangup error: ", e);
	        }
	      } else {
	        this.log("Tried to hangup, but this.voximplantCall points nowhere");
	        console.error("Tried to hangup, but this.voximplantCall points nowhere");
	      }
	      this.screenShared = false;
	      _classPrivateMethodGet$3(this, _hideLocalVideo, _hideLocalVideo2).call(this);
	    }
	  }, {
	    key: "attachToConference",
	    value: function attachToConference() {
	      var _this13 = this;
	      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      var joinAsViewer = options.joinAsViewer === true;
	      if (this.voximplantCall && this.voximplantCall.state() === "CONNECTED") {
	        if (this.joinedAsViewer === joinAsViewer) {
	          return Promise.resolve();
	        } else {
	          return Promise.reject("Already joined call in another mode");
	        }
	      }
	      return new Promise(function (resolve, reject) {
	        _this13.direction = joinAsViewer ? EndpointDirection.RecvOnly : EndpointDirection.SendRecv;
	        _this13.sendTelemetryEvent("call");
	        _this13.getClient().then(function (voximplantClient) {
	          _this13.localUserState = UserState.Connecting;

	          // workaround to set default video settings before starting call. ugly, but I do not see another way
	          VoxImplant.Hardware.CameraManager.get().setDefaultVideoSettings(_this13.constructCameraParams());
	          if (_this13.microphoneId) {
	            VoxImplant.Hardware.AudioDeviceManager.get().setDefaultAudioSettings({
	              inputId: _this13.microphoneId
	            });
	          }
	          if (Hardware.isCameraOn) {
	            _classPrivateMethodGet$3(_this13, _showLocalVideo, _showLocalVideo2).call(_this13);
	          }
	          try {
	            if (!_this13.ready) {
	              _this13.log("Error: trying to attach after hangup");
	              return reject({
	                code: "VOX_NO_CALL"
	              });
	            }
	            if (joinAsViewer) {
	              _this13.voximplantCall = voximplantClient.joinAsViewer("bx_conf_" + _this13.id, {
	                'X-Direction': EndpointDirection.RecvOnly
	              });
	            } else {
	              _this13.voximplantCall = voximplantClient.callConference({
	                number: "bx_conf_" + _this13.id,
	                video: {
	                  sendVideo: Hardware.isCameraOn,
	                  receiveVideo: true
	                },
	                // simulcast: (this.getUserCount() > MAX_USERS_WITHOUT_SIMULCAST),
	                // simulcastProfileName: 'b24',
	                customData: JSON.stringify({
	                  cameraState: Hardware.isCameraOn
	                })
	              });
	            }
	          } catch (e) {
	            console.error(e);
	            return reject(e);
	          }
	          _this13.joinedAsViewer = joinAsViewer;
	          if (!_this13.voximplantCall) {
	            _this13.log("Error: could not create voximplant call");
	            return reject({
	              code: "VOX_NO_CALL"
	            });
	          }
	          _this13.runCallback(VoximplantCallEvent.onCallConference, {
	            call: _this13
	          });
	          _this13.bindCallEvents();
	          _this13.subscribeHardwareChanges();
	          _this13.voximplantCall.on(VoxImplant.CallEvents.Connected, function () {
	            _classPrivateMethodGet$3(_this13, _onCallConnected$1, _onCallConnected2$1).call(_this13);
	            resolve();
	          }, {
	            once: true
	          });
	          _this13.voximplantCall.on(VoxImplant.CallEvents.Failed, function (e) {
	            _classPrivateMethodGet$3(_this13, _onCallFailed$1, _onCallFailed2$1).call(_this13, e);
	            reject(e);
	          }, {
	            once: true
	          });
	        })["catch"](babelHelpers.classPrivateFieldGet(_this13, _onFatalError$1).bind(_this13));
	      });
	    }
	  }, {
	    key: "bindCallEvents",
	    value: function bindCallEvents() {
	      this.voximplantCall.on(VoxImplant.CallEvents.Disconnected, babelHelpers.classPrivateFieldGet(this, _onCallDisconnected$1));
	      this.voximplantCall.on(VoxImplant.CallEvents.MessageReceived, babelHelpers.classPrivateFieldGet(this, _onCallMessageReceived$1));
	      if (Util.shouldCollectStats()) {
	        this.voximplantCall.on(VoxImplant.CallEvents.CallStatsReceived, babelHelpers.classPrivateFieldGet(this, _onCallStatsReceived$1));
	      }
	      this.voximplantCall.on(VoxImplant.CallEvents.EndpointAdded, babelHelpers.classPrivateFieldGet(this, _onCallEndpointAdded));
	      if (VoxImplant.CallEvents.Reconnecting) {
	        this.voximplantCall.on(VoxImplant.CallEvents.Reconnecting, babelHelpers.classPrivateFieldGet(this, _onCallReconnecting$1));
	        this.voximplantCall.on(VoxImplant.CallEvents.Reconnected, babelHelpers.classPrivateFieldGet(this, _onCallReconnected$1));
	      }
	    }
	  }, {
	    key: "removeCallEvents",
	    value: function removeCallEvents() {
	      if (this.voximplantCall) {
	        this.voximplantCall.removeEventListener(VoxImplant.CallEvents.Disconnected, babelHelpers.classPrivateFieldGet(this, _onCallDisconnected$1));
	        this.voximplantCall.removeEventListener(VoxImplant.CallEvents.MessageReceived, babelHelpers.classPrivateFieldGet(this, _onCallMessageReceived$1));
	        if (Util.shouldCollectStats()) {
	          this.voximplantCall.removeEventListener(VoxImplant.CallEvents.CallStatsReceived, babelHelpers.classPrivateFieldGet(this, _onCallStatsReceived$1));
	        }
	        this.voximplantCall.removeEventListener(VoxImplant.CallEvents.EndpointAdded, babelHelpers.classPrivateFieldGet(this, _onCallEndpointAdded));
	        if (VoxImplant.CallEvents.Reconnecting) {
	          this.voximplantCall.removeEventListener(VoxImplant.CallEvents.Reconnecting, babelHelpers.classPrivateFieldGet(this, _onCallReconnecting$1));
	          this.voximplantCall.removeEventListener(VoxImplant.CallEvents.Reconnected, babelHelpers.classPrivateFieldGet(this, _onCallReconnected$1));
	        }
	      }
	    }
	  }, {
	    key: "subscribeHardwareChanges",
	    value: function subscribeHardwareChanges() {
	      Hardware.subscribe(Hardware.Events.onChangeMicrophoneMuted, this.setMuted);
	      Hardware.subscribe(Hardware.Events.onChangeCameraOn, this.setVideoEnabled);
	    }
	  }, {
	    key: "unsubscribeHardwareChanges",
	    value: function unsubscribeHardwareChanges() {
	      Hardware.unsubscribe(Hardware.Events.onChangeMicrophoneMuted, this.setMuted);
	      Hardware.unsubscribe(Hardware.Events.onChangeCameraOn, this.setVideoEnabled);
	    }
	  }, {
	    key: "addJoinedUsers",
	    /**
	     * Adds new users to call
	     * @param {Number[]} users
	     */
	    value: function addJoinedUsers(users) {
	      for (var i = 0; i < users.length; i++) {
	        var userId = Number(users[i]);
	        if (userId == this.userId || this.peers[userId]) {
	          continue;
	        }
	        this.peers[userId] = this.createPeer(userId);
	        if (!this.users.includes(userId)) {
	          this.users.push(userId);
	        }
	        this.runCallback(CallEvent.onUserInvited, {
	          userId: userId
	        });
	      }
	    }
	  }, {
	    key: "addInvitedUsers",
	    /**
	     * Adds users, invited by you or someone else
	     * @param {Number[]} users
	     */
	    value: function addInvitedUsers(users) {
	      for (var i = 0; i < users.length; i++) {
	        var userId = Number(users[i]);
	        if (userId == this.userId) {
	          continue;
	        }
	        if (this.peers[userId]) {
	          if (this.peers[userId].calculatedState === UserState.Failed || this.peers[userId].calculatedState === UserState.Idle) {
	            if (this.type === CallType.Instant) {
	              this.peers[userId].onInvited();
	            }
	          }
	        } else {
	          this.peers[userId] = this.createPeer(userId);
	          if (this.type === CallType.Instant) {
	            this.peers[userId].onInvited();
	          }
	        }
	        if (!this.users.includes(userId)) {
	          this.users.push(userId);
	        }
	        this.runCallback(CallEvent.onUserInvited, {
	          userId: userId
	        });
	      }
	    }
	  }, {
	    key: "isAnyoneParticipating",
	    value: function isAnyoneParticipating() {
	      for (var userId in this.peers) {
	        if (this.peers[userId].isParticipating()) {
	          return true;
	        }
	      }
	      return false;
	    }
	  }, {
	    key: "getParticipatingUsers",
	    value: function getParticipatingUsers() {
	      var result = [];
	      for (var userId in this.peers) {
	        if (this.peers[userId].isParticipating()) {
	          result.push(userId);
	        }
	      }
	      return result;
	    }
	  }, {
	    key: "updateRoom",
	    value: function updateRoom(roomData) {
	      if (!this.rooms[roomData.id]) {
	        this.rooms[roomData.id] = {
	          id: roomData.id,
	          users: roomData.users,
	          speaker: roomData.speaker
	        };
	      } else {
	        this.rooms[roomData.id].users = roomData.users;
	        this.rooms[roomData.id].speaker = roomData.speaker;
	      }
	    }
	  }, {
	    key: "currentRoom",
	    value: function currentRoom() {
	      return this._currentRoomId ? this.rooms[this._currentRoomId] : null;
	    }
	  }, {
	    key: "isRoomSpeaker",
	    value: function isRoomSpeaker() {
	      return this.currentRoom() ? this.currentRoom().speaker == this.userId : false;
	    }
	  }, {
	    key: "joinRoom",
	    value: function joinRoom(roomId) {
	      this.signaling.sendJoinRoom(roomId);
	    }
	  }, {
	    key: "requestRoomSpeaker",
	    value: function requestRoomSpeaker() {
	      this.signaling.sendRequestRoomSpeaker(this._currentRoomId);
	    }
	  }, {
	    key: "leaveCurrentRoom",
	    value: function leaveCurrentRoom() {
	      this.signaling.sendLeaveRoom(this._currentRoomId);
	    }
	  }, {
	    key: "listRooms",
	    value: function listRooms() {
	      var _this14 = this;
	      return new Promise(function (resolve) {
	        _this14.signaling.sendListRooms();
	        _this14.__resolveListRooms = resolve;
	      });
	    }
	  }, {
	    key: "__onPullEvent",
	    value: function __onPullEvent(command, params, extra) {
	      if (this.pullEventHandlers[command]) {
	        if (command != 'Call::ping') {
	          this.log("Signaling: " + command + "; Parameters: " + JSON.stringify(params));
	        }
	        this.pullEventHandlers[command].call(this, params);
	      }
	    }
	  }, {
	    key: "__onPullEventAnswerSelf",
	    value: function __onPullEventAnswerSelf(params) {
	      if (params.callInstanceId === this.instanceId) {
	        return;
	      }

	      // call was answered elsewhere
	      this.joinedElsewhere = true;
	      this.runCallback(CallEvent.onJoin, {
	        local: false
	      });
	    }
	  }, {
	    key: "sendTelemetryEvent",
	    value: function sendTelemetryEvent(eventName) {
	      Util.sendTelemetryEvent({
	        call_id: this.id,
	        user_id: this.userId,
	        kind: "voximplant",
	        event: eventName
	      });
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.ready = false;
	      this.joinedAsViewer = false;
	      _classPrivateMethodGet$3(this, _hideLocalVideo, _hideLocalVideo2).call(this);
	      if (this.localVAD) {
	        this.localVAD.destroy();
	        this.localVAD = null;
	      }
	      clearInterval(this.microphoneLevelInterval);
	      if (this.voximplantCall) {
	        this.removeCallEvents();
	        this.unsubscribeHardwareChanges();
	        if (this.voximplantCall.state() != "ENDED") {
	          this.voximplantCall.hangup();
	        }
	        this.voximplantCall = null;
	      }
	      for (var userId in this.peers) {
	        if (this.peers.hasOwnProperty(userId) && this.peers[userId]) {
	          this.peers[userId].destroy();
	        }
	      }
	      this.removeClientEvents();
	      clearTimeout(this.lastPingReceivedTimeout);
	      clearTimeout(this.lastSelfPingReceivedTimeout);
	      clearInterval(this.pingUsersInterval);
	      clearInterval(this.pingBackendInterval);
	      window.removeEventListener("unload", babelHelpers.classPrivateFieldGet(this, _onWindowUnload$1));
	      return babelHelpers.get(babelHelpers.getPrototypeOf(VoximplantCall.prototype), "destroy", this).call(this);
	    }
	  }, {
	    key: "provider",
	    get: function get() {
	      return Provider.Voximplant;
	    }
	  }, {
	    key: "screenShared",
	    get: function get() {
	      return this._screenShared;
	    },
	    set: function set(screenShared) {
	      if (screenShared != this._screenShared) {
	        this._screenShared = screenShared;
	        this.signaling.sendScreenState(this._screenShared);
	      }
	    }
	  }, {
	    key: "localUserState",
	    get: function get() {
	      return this._localUserState;
	    },
	    set: function set(state) {
	      if (state == this._localUserState) {
	        return;
	      }
	      this.runCallback(CallEvent.onUserStateChanged, {
	        userId: this.userId,
	        state: state,
	        previousState: this._localUserState,
	        direction: this.direction
	      });
	      this._localUserState = state;
	    }
	  }, {
	    key: "reconnectionEventCount",
	    get: function get() {
	      return this._reconnectionEventCount;
	    },
	    set: function set(newValue) {
	      if (this._reconnectionEventCount === 0 && newValue > 0) {
	        this.runCallback(CallEvent.onReconnecting);
	      }
	      if (newValue === 0) {
	        this.runCallback(CallEvent.onReconnected);
	      }
	      this._reconnectionEventCount = newValue;
	    }
	  }]);
	  return VoximplantCall;
	}(AbstractCall);
	function _showLocalVideo2() {
	  var _this17 = this;
	  return new Promise(function (resolve) {
	    VoxImplant.Hardware.StreamManager.get().showLocalVideo(false).then(function () {
	      _this17.localVideoShown = true;
	      resolve();
	    }, function () {
	      _this17.localVideoShown = true;
	      resolve();
	    });
	  });
	}
	function _hideLocalVideo2() {
	  var _this18 = this;
	  return new Promise(function (resolve) {
	    if (!('VoxImplant' in window)) {
	      resolve();
	      return;
	    }
	    VoxImplant.Hardware.StreamManager.get().hideLocalVideo().then(function () {
	      _this18.localVideoShown = false;
	      resolve();
	    }, function () {
	      _this18.localVideoShown = false;
	      resolve();
	    });
	  });
	}
	function _onCallConnected2$1() {
	  this.log("Call connected");
	  this.sendTelemetryEvent("connect");
	  this.localUserState = UserState.Connected;
	  this.voximplantCall.on(VoxImplant.CallEvents.Failed, babelHelpers.classPrivateFieldGet(this, _onCallDisconnected$1));
	  if (Hardware.isMicrophoneMuted) {
	    this.voximplantCall.muteMicrophone();
	  }
	  this.signaling.sendMicrophoneState(!Hardware.isMicrophoneMuted);
	  this.signaling.sendCameraState(Hardware.isCameraOn);
	  if (this.videoAllowedFrom == UserMnemonic.none) {
	    this.signaling.sendHideAll();
	  } else if (main_core.Type.isArray(this.videoAllowedFrom)) {
	    this.signaling.sendShowUsers(this.videoAllowedFrom);
	  }
	}
	function _onCallFailed2$1(e) {
	  this.log("Could not attach to conference", e);
	  this.sendTelemetryEvent("connect_failure");
	  this.localUserState = UserState.Failed;
	  var client = VoxImplant.getInstance();
	  client.enableSilentLogging(false);
	  client.setLoggerCallback(null);
	}
	function _setEndpointForUser2(userName, endpoint) {
	  // user connected to conference (userName is in format `user${id}`
	  var userId = parseInt(userName.substring(4));
	  if (this.peers[userId]) {
	    this.peers[userId].setEndpoint(endpoint);
	  }
	  this.wasConnected = true;
	}
	babelHelpers.defineProperty(VoximplantCall, "Event", VoximplantCallEvent);
	var _sendPullEvent$2 = /*#__PURE__*/new WeakSet();
	var _sendMessage$1 = /*#__PURE__*/new WeakSet();
	var _runRestAction$2 = /*#__PURE__*/new WeakSet();
	var Signaling$2 = /*#__PURE__*/function () {
	  function Signaling(params) {
	    babelHelpers.classCallCheck(this, Signaling);
	    _classPrivateMethodInitSpec$3(this, _runRestAction$2);
	    _classPrivateMethodInitSpec$3(this, _sendMessage$1);
	    _classPrivateMethodInitSpec$3(this, _sendPullEvent$2);
	    this.call = params.call;
	  }
	  babelHelpers.createClass(Signaling, [{
	    key: "inviteUsers",
	    value: function inviteUsers(data) {
	      return _classPrivateMethodGet$3(this, _runRestAction$2, _runRestAction2$2).call(this, ajaxActions$2.invite, data);
	    }
	  }, {
	    key: "sendAnswer",
	    value: function sendAnswer(data, repeated) {
	      if (repeated && CallEngine.getPullClient().isPublishingEnabled()) {
	        _classPrivateMethodGet$3(this, _sendPullEvent$2, _sendPullEvent2$2).call(this, pullEvents$2.answer, data);
	      } else {
	        return _classPrivateMethodGet$3(this, _runRestAction$2, _runRestAction2$2).call(this, ajaxActions$2.answer, data);
	      }
	    }
	  }, {
	    key: "sendCancel",
	    value: function sendCancel(data) {
	      return _classPrivateMethodGet$3(this, _runRestAction$2, _runRestAction2$2).call(this, ajaxActions$2.cancel, data);
	    }
	  }, {
	    key: "sendHangup",
	    value: function sendHangup(data) {
	      if (CallEngine.getPullClient().isPublishingEnabled()) {
	        _classPrivateMethodGet$3(this, _sendPullEvent$2, _sendPullEvent2$2).call(this, pullEvents$2.hangup, data);
	        data.retransmit = false;
	        _classPrivateMethodGet$3(this, _runRestAction$2, _runRestAction2$2).call(this, ajaxActions$2.hangup, data);
	      } else {
	        data.retransmit = true;
	        _classPrivateMethodGet$3(this, _runRestAction$2, _runRestAction2$2).call(this, ajaxActions$2.hangup, data);
	      }
	    }
	  }, {
	    key: "sendVoiceStarted",
	    value: function sendVoiceStarted(data) {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.voiceStarted, data);
	    }
	  }, {
	    key: "sendVoiceStopped",
	    value: function sendVoiceStopped(data) {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.voiceStopped, data);
	    }
	  }, {
	    key: "sendMicrophoneState",
	    value: function sendMicrophoneState(microphoneState) {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.microphoneState, {
	        microphoneState: microphoneState ? "Y" : "N"
	      });
	    }
	  }, {
	    key: "sendCameraState",
	    value: function sendCameraState(cameraState) {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.cameraState, {
	        cameraState: cameraState ? "Y" : "N"
	      });
	    }
	  }, {
	    key: "sendScreenState",
	    value: function sendScreenState(screenState) {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.screenState, {
	        screenState: screenState ? "Y" : "N"
	      });
	    }
	  }, {
	    key: "sendRecordState",
	    value: function sendRecordState(recordState) {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.recordState, recordState);
	    }
	  }, {
	    key: "sendFloorRequest",
	    value: function sendFloorRequest(requestActive) {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.floorRequest, {
	        requestActive: requestActive ? "Y" : "N"
	      });
	    }
	  }, {
	    key: "sendEmotion",
	    value: function sendEmotion(toUserId, emotion) {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.emotion, {
	        toUserId: toUserId,
	        emotion: emotion
	      });
	    }
	  }, {
	    key: "sendCustomMessage",
	    value: function sendCustomMessage(message, repeatOnConnect) {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.customMessage, {
	        message: message,
	        repeatOnConnect: !!repeatOnConnect
	      });
	    }
	  }, {
	    key: "sendShowUsers",
	    value: function sendShowUsers(users) {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.showUsers, {
	        users: users
	      });
	    }
	  }, {
	    key: "sendShowAll",
	    value: function sendShowAll() {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.showAll, {});
	    }
	  }, {
	    key: "sendHideAll",
	    value: function sendHideAll() {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.hideAll, {});
	    }
	  }, {
	    key: "sendPingToUsers",
	    value: function sendPingToUsers(data) {
	      if (CallEngine.getPullClient().isPublishingEnabled()) {
	        _classPrivateMethodGet$3(this, _sendPullEvent$2, _sendPullEvent2$2).call(this, pullEvents$2.ping, data, 0);
	      }
	    }
	  }, {
	    key: "sendPingToBackend",
	    value: function sendPingToBackend() {
	      _classPrivateMethodGet$3(this, _runRestAction$2, _runRestAction2$2).call(this, ajaxActions$2.ping, {
	        retransmit: false
	      });
	    }
	  }, {
	    key: "sendUserInviteTimeout",
	    value: function sendUserInviteTimeout(data) {
	      if (CallEngine.getPullClient().isPublishingEnabled()) {
	        _classPrivateMethodGet$3(this, _sendPullEvent$2, _sendPullEvent2$2).call(this, pullEvents$2.userInviteTimeout, data, 0);
	      }
	    }
	  }, {
	    key: "sendJoinRoom",
	    value: function sendJoinRoom(roomId) {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.joinRoom, {
	        roomId: roomId
	      });
	    }
	  }, {
	    key: "sendLeaveRoom",
	    value: function sendLeaveRoom(roomId) {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.leaveRoom, {
	        roomId: roomId
	      });
	    }
	  }, {
	    key: "sendListRooms",
	    value: function sendListRooms() {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.listRooms);
	    }
	  }, {
	    key: "sendRequestRoomSpeaker",
	    value: function sendRequestRoomSpeaker(roomId) {
	      return _classPrivateMethodGet$3(this, _sendMessage$1, _sendMessage2$1).call(this, clientEvents$1.requestRoomSpeaker, {
	        roomId: roomId
	      });
	    }
	  }]);
	  return Signaling;
	}();
	function _sendPullEvent2$2(eventName, data, expiry) {
	  expiry = expiry || 5;
	  if (!data.userId) {
	    throw new Error('userId is not found in data');
	  }
	  if (!main_core.Type.isArray(data.userId)) {
	    data.userId = [data.userId];
	  }
	  if (data.userId.length === 0) {
	    // nobody to send, exit
	    return;
	  }
	  data.callInstanceId = this.call.instanceId;
	  data.senderId = this.call.userId;
	  data.callId = this.call.id;
	  data.requestId = Util.getUuidv4();
	  this.call.log('Sending p2p signaling event ' + eventName + '; ' + JSON.stringify(data));
	  CallEngine.getPullClient().sendMessage(data.userId, 'im', eventName, data, expiry);
	}
	function _sendMessage2$1(eventName, data) {
	  if (!this.call.voximplantCall) {
	    return;
	  }
	  if (!main_core.Type.isPlainObject(data)) {
	    data = {};
	  }
	  data.eventName = eventName;
	  data.requestId = Util.getUuidv4();
	  this.call.voximplantCall.sendMessage(JSON.stringify(data));
	}
	function _runRestAction2$2(signalName, data) {
	  if (!main_core.Type.isPlainObject(data)) {
	    data = {};
	  }
	  data.callId = this.call.id;
	  data.callInstanceId = this.call.instanceId;
	  data.requestId = Util.getUuidv4();
	  return CallEngine.getRestClient().callMethod(signalName, data);
	}
	var _onEndpointRemoteMediaAdded = /*#__PURE__*/new WeakMap();
	var _onEndpointRemoteMediaRemoved = /*#__PURE__*/new WeakMap();
	var _onEndpointVoiceStart$1 = /*#__PURE__*/new WeakMap();
	var _onEndpointVoiceEnd$1 = /*#__PURE__*/new WeakMap();
	var _onEndpointRemoved = /*#__PURE__*/new WeakMap();
	var _onEndpointMediaRenderEnabled = /*#__PURE__*/new WeakMap();
	var _onEndpointMediaRenderDisabled = /*#__PURE__*/new WeakMap();
	var Peer$2 = /*#__PURE__*/function () {
	  function Peer(params) {
	    var _this15 = this;
	    babelHelpers.classCallCheck(this, Peer);
	    _classPrivateFieldInitSpec$2(this, _onEndpointRemoteMediaAdded, {
	      writable: true,
	      value: function value(e) {
	        _this15.log("VoxImplant.EndpointEvents.RemoteMediaAdded", e.mediaRenderer);

	        // voximplant audio auto-play bug workaround:
	        if (e.mediaRenderer.element) {
	          e.mediaRenderer.element.volume = 0;
	          e.mediaRenderer.element.srcObject = null;
	        }
	        _this15.addMediaRenderer(e.mediaRenderer);
	      }
	    });
	    _classPrivateFieldInitSpec$2(this, _onEndpointRemoteMediaRemoved, {
	      writable: true,
	      value: function value(e) {
	        console.log("VoxImplant.EndpointEvents.RemoteMediaRemoved, ", e.mediaRenderer);
	        //this.log("VoxImplant.EndpointEvents.RemoteMediaRemoved, ", e);
	        _this15.removeMediaRenderer(e.mediaRenderer);
	      }
	    });
	    _classPrivateFieldInitSpec$2(this, _onEndpointVoiceStart$1, {
	      writable: true,
	      value: function value() {
	        _this15.callbacks.onVoiceStarted();
	      }
	    });
	    _classPrivateFieldInitSpec$2(this, _onEndpointVoiceEnd$1, {
	      writable: true,
	      value: function value() {
	        _this15.callbacks.onVoiceEnded();
	      }
	    });
	    _classPrivateFieldInitSpec$2(this, _onEndpointRemoved, {
	      writable: true,
	      value: function value(e) {
	        _this15.log("VoxImplant.EndpointEvents.Removed", e);
	        if (_this15.endpoint) {
	          _this15.removeEndpointEventHandlers();
	          _this15.endpoint = null;
	        }
	        if (_this15.stream) {
	          _this15.stream = null;
	        }
	        if (_this15.ready) {
	          _this15.waitForConnectionRestore();
	        }
	        _this15.updateCalculatedState();
	      }
	    });
	    _classPrivateFieldInitSpec$2(this, _onEndpointMediaRenderEnabled, {
	      writable: true,
	      value: function value(e) {
	        _this15.callbacks.onMediaRenderEnabled(e);
	      }
	    });
	    _classPrivateFieldInitSpec$2(this, _onEndpointMediaRenderDisabled, {
	      writable: true,
	      value: function value(e) {
	        _this15.callbacks.onMediaRenderDisabled(e);
	      }
	    });
	    this.userId = params.userId;
	    this.call = params.call;
	    this.ready = !!params.ready;
	    this.calling = false;
	    this.declined = false;
	    this.busy = false;
	    this.inviteTimeout = false;
	    this.endpoint = null;
	    this.direction = params.direction || EndpointDirection.SendRecv;
	    this.stream = null;
	    this.mediaRenderers = [];
	    this.isIncomingVideoAllowed = params.isIncomingVideoAllowed !== false;
	    this.callingTimeout = 0;
	    this.connectionRestoreTimeout = 0;
	    this.callbacks = {
	      onStateChanged: main_core.Type.isFunction(params.onStateChanged) ? params.onStateChanged : BX.DoNothing,
	      onInviteTimeout: main_core.Type.isFunction(params.onInviteTimeout) ? params.onInviteTimeout : BX.DoNothing,
	      onMediaReceived: main_core.Type.isFunction(params.onMediaReceived) ? params.onMediaReceived : BX.DoNothing,
	      onMediaRemoved: main_core.Type.isFunction(params.onMediaRemoved) ? params.onMediaRemoved : BX.DoNothing,
	      onVoiceStarted: main_core.Type.isFunction(params.onVoiceStarted) ? params.onVoiceStarted : BX.DoNothing,
	      onVoiceEnded: main_core.Type.isFunction(params.onVoiceEnded) ? params.onVoiceEnded : BX.DoNothing,
	      onMediaRenderEnabled: main_core.Type.isFunction(params.onMediaRenderEnabled) ? params.onMediaRenderEnabled : BX.DoNothing,
	      onMediaRenderDisabled: main_core.Type.isFunction(params.onMediaRenderDisabled) ? params.onMediaRenderDisabled : BX.DoNothing
	    };
	    this.calculatedState = this.calculateState();
	  }
	  babelHelpers.createClass(Peer, [{
	    key: "setReady",
	    value: function setReady(ready) {
	      ready = !!ready;
	      if (this.ready == ready) {
	        return;
	      }
	      this.ready = ready;
	      this.readyStack = new Error().stack;
	      if (this.calling) {
	        clearTimeout(this.callingTimeout);
	        this.calling = false;
	        this.inviteTimeout = false;
	      }
	      if (this.ready) {
	        this.declined = false;
	        this.busy = false;
	      } else {
	        clearTimeout(this.connectionRestoreTimeout);
	      }
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "setDirection",
	    value: function setDirection(direction) {
	      if (this.direction == direction) {
	        return;
	      }
	      this.direction = direction;
	    }
	  }, {
	    key: "setDeclined",
	    value: function setDeclined(declined) {
	      this.declined = declined;
	      if (this.calling) {
	        clearTimeout(this.callingTimeout);
	        this.calling = false;
	      }
	      if (this.declined) {
	        this.ready = false;
	        this.busy = false;
	      }
	      clearTimeout(this.connectionRestoreTimeout);
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "setBusy",
	    value: function setBusy(busy) {
	      this.busy = busy;
	      if (this.calling) {
	        clearTimeout(this.callingTimeout);
	        this.calling = false;
	      }
	      if (this.busy) {
	        this.ready = false;
	        this.declined = false;
	      }
	      clearTimeout(this.connectionRestoreTimeout);
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "setEndpoint",
	    value: function setEndpoint(endpoint) {
	      this.log("Adding endpoint with " + endpoint.mediaRenderers.length + " media renderers");
	      this.setReady(true);
	      this.inviteTimeout = false;
	      this.declined = false;
	      clearTimeout(this.connectionRestoreTimeout);
	      if (this.endpoint) {
	        this.removeEndpointEventHandlers();
	        this.endpoint = null;
	      }
	      this.endpoint = endpoint;
	      for (var i = 0; i < this.endpoint.mediaRenderers.length; i++) {
	        this.addMediaRenderer(this.endpoint.mediaRenderers[i]);
	        if (this.endpoint.mediaRenderers[i].element) ;
	      }
	      this.bindEndpointEventHandlers();
	    }
	  }, {
	    key: "allowIncomingVideo",
	    value: function allowIncomingVideo(isIncomingVideoAllowed) {
	      if (this.isIncomingVideoAllowed == isIncomingVideoAllowed) {
	        return;
	      }
	      this.isIncomingVideoAllowed = !!isIncomingVideoAllowed;
	    }
	  }, {
	    key: "addMediaRenderer",
	    value: function addMediaRenderer(mediaRenderer) {
	      this.log('Adding media renderer for user' + this.userId, mediaRenderer);
	      this.mediaRenderers.push(mediaRenderer);
	      this.callbacks.onMediaReceived({
	        userId: this.userId,
	        kind: mediaRenderer.kind,
	        mediaRenderer: mediaRenderer
	      });
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "removeMediaRenderer",
	    value: function removeMediaRenderer(mediaRenderer) {
	      this.log('Removing media renderer for user' + this.userId, mediaRenderer);
	      var i = this.mediaRenderers.indexOf(mediaRenderer);
	      if (i >= 0) {
	        this.mediaRenderers.splice(i, 1);
	      }
	      this.callbacks.onMediaRemoved({
	        userId: this.userId,
	        kind: mediaRenderer.kind,
	        mediaRenderer: mediaRenderer
	      });
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "bindEndpointEventHandlers",
	    value: function bindEndpointEventHandlers() {
	      this.endpoint.addEventListener(VoxImplant.EndpointEvents.RemoteMediaAdded, babelHelpers.classPrivateFieldGet(this, _onEndpointRemoteMediaAdded));
	      this.endpoint.addEventListener(VoxImplant.EndpointEvents.RemoteMediaRemoved, babelHelpers.classPrivateFieldGet(this, _onEndpointRemoteMediaRemoved));
	      this.endpoint.addEventListener(VoxImplant.EndpointEvents.VoiceStart, babelHelpers.classPrivateFieldGet(this, _onEndpointVoiceStart$1));
	      this.endpoint.addEventListener(VoxImplant.EndpointEvents.VoiceEnd, babelHelpers.classPrivateFieldGet(this, _onEndpointVoiceEnd$1));
	      this.endpoint.addEventListener(VoxImplant.EndpointEvents.Removed, babelHelpers.classPrivateFieldGet(this, _onEndpointRemoved));
	      this.endpoint.addEventListener(VoxImplant.EndpointEvents.MediaRenderEnabled, babelHelpers.classPrivateFieldGet(this, _onEndpointMediaRenderEnabled));
	      this.endpoint.addEventListener(VoxImplant.EndpointEvents.MediaRenderDisabled, babelHelpers.classPrivateFieldGet(this, _onEndpointMediaRenderDisabled));
	    }
	  }, {
	    key: "removeEndpointEventHandlers",
	    value: function removeEndpointEventHandlers() {
	      this.endpoint.removeEventListener(VoxImplant.EndpointEvents.RemoteMediaAdded, babelHelpers.classPrivateFieldGet(this, _onEndpointRemoteMediaAdded));
	      this.endpoint.removeEventListener(VoxImplant.EndpointEvents.RemoteMediaRemoved, babelHelpers.classPrivateFieldGet(this, _onEndpointRemoteMediaRemoved));
	      this.endpoint.removeEventListener(VoxImplant.EndpointEvents.VoiceStart, babelHelpers.classPrivateFieldGet(this, _onEndpointVoiceStart$1));
	      this.endpoint.removeEventListener(VoxImplant.EndpointEvents.VoiceEnd, babelHelpers.classPrivateFieldGet(this, _onEndpointVoiceEnd$1));
	      this.endpoint.removeEventListener(VoxImplant.EndpointEvents.Removed, babelHelpers.classPrivateFieldGet(this, _onEndpointRemoved));
	      this.endpoint.removeEventListener(VoxImplant.EndpointEvents.MediaRenderEnabled, babelHelpers.classPrivateFieldGet(this, _onEndpointMediaRenderEnabled));
	      this.endpoint.removeEventListener(VoxImplant.EndpointEvents.MediaRenderDisabled, babelHelpers.classPrivateFieldGet(this, _onEndpointMediaRenderDisabled));
	    }
	  }, {
	    key: "calculateState",
	    value: function calculateState() {
	      if (this.endpoint) {
	        return UserState.Connected;
	      }
	      if (this.calling) {
	        return UserState.Calling;
	      }
	      if (this.inviteTimeout) {
	        return UserState.Unavailable;
	      }
	      if (this.declined) {
	        return UserState.Declined;
	      }
	      if (this.busy) {
	        return UserState.Busy;
	      }
	      if (this.ready) {
	        return UserState.Ready;
	      }
	      return UserState.Idle;
	    }
	  }, {
	    key: "updateCalculatedState",
	    value: function updateCalculatedState() {
	      var calculatedState = this.calculateState();
	      if (this.calculatedState != calculatedState) {
	        this.callbacks.onStateChanged({
	          userId: this.userId,
	          state: calculatedState,
	          previousState: this.calculatedState,
	          direction: this.direction
	        });
	        this.calculatedState = calculatedState;
	      }
	    }
	  }, {
	    key: "isParticipating",
	    value: function isParticipating() {
	      return (this.calling || this.ready || this.endpoint) && !this.declined;
	    }
	  }, {
	    key: "waitForConnectionRestore",
	    value: function waitForConnectionRestore() {
	      clearTimeout(this.connectionRestoreTimeout);
	      this.connectionRestoreTimeout = setTimeout(this.onConnectionRestoreTimeout.bind(this), connectionRestoreTime);
	    }
	  }, {
	    key: "onInvited",
	    value: function onInvited() {
	      var _this16 = this;
	      this.ready = false;
	      this.inviteTimeout = false;
	      this.declined = false;
	      this.calling = true;
	      clearTimeout(this.connectionRestoreTimeout);
	      if (this.callingTimeout) {
	        clearTimeout(this.callingTimeout);
	      }
	      this.callingTimeout = setTimeout(function () {
	        return _this16.onInviteTimeout(true);
	      }, 30000);
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "onInviteTimeout",
	    value: function onInviteTimeout(internal) {
	      clearTimeout(this.callingTimeout);
	      if (!this.calling) {
	        return;
	      }
	      this.calling = false;
	      this.inviteTimeout = true;
	      if (internal) {
	        this.callbacks.onInviteTimeout({
	          userId: this.userId
	        });
	      }
	      this.updateCalculatedState();
	    }
	  }, {
	    key: "onConnectionRestoreTimeout",
	    value: function onConnectionRestoreTimeout() {
	      if (this.endpoint || !this.ready) {
	        return;
	      }
	      this.log("Done waiting for connection restoration");
	      this.setReady(false);
	    }
	  }, {
	    key: "log",
	    value: function log() {
	      this.call.log.apply(this.call, arguments);
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      if (this.stream) {
	        Util.stopMediaStream(this.stream);
	        this.stream = null;
	      }
	      if (this.endpoint) {
	        this.removeEndpointEventHandlers();
	        this.endpoint = null;
	      }
	      this.callbacks.onStateChanged = BX.DoNothing;
	      this.callbacks.onInviteTimeout = BX.DoNothing;
	      this.callbacks.onMediaReceived = BX.DoNothing;
	      this.callbacks.onMediaRemoved = BX.DoNothing;
	      clearTimeout(this.callingTimeout);
	      clearTimeout(this.connectionRestoreTimeout);
	      this.callingTimeout = null;
	      this.connectionRestoreTimeout = null;
	    }
	  }]);
	  return Peer;
	}();
	var transformVoxStats$1 = function transformVoxStats(s, voximplantCall) {
	  var result = {
	    connection: s.connection,
	    outboundAudio: [],
	    outboundVideo: [],
	    inboundAudio: [],
	    inboundVideo: []
	  };
	  var endpoints = {};
	  if (voximplantCall.getEndpoints) {
	    voximplantCall.getEndpoints().forEach(function (endpoint) {
	      return endpoints[endpoint.id] = endpoint;
	    });
	  }
	  if (!result.connection.timestamp) {
	    result.connection.timestamp = Date.now();
	  }
	  for (var trackId in s.outbound) {
	    if (!s.outbound.hasOwnProperty(trackId)) {
	      continue;
	    }
	    var statGroup = s.outbound[trackId];
	    for (var i = 0; i < statGroup.length; i++) {
	      var stat = statGroup[i];
	      stat.trackId = trackId;
	      if ('audioLevel' in stat) {
	        result.outboundAudio.push(stat);
	      } else {
	        result.outboundVideo.push(stat);
	      }
	    }
	  }
	  var _loop = function _loop() {
	    if (!s.inbound.hasOwnProperty(_trackId)) {
	      return "continue";
	    }
	    var stat = s.inbound[_trackId];
	    if (!('endpoint' in stat)) {
	      return "continue";
	    }
	    stat.trackId = _trackId;
	    if ('audioLevel' in stat) {
	      result.inboundAudio.push(stat);
	    } else {
	      if (endpoints[stat.endpoint]) {
	        var videoRenderer = endpoints[stat.endpoint].mediaRenderers.find(function (r) {
	          return r.id == stat.trackId;
	        });
	        if (videoRenderer && videoRenderer.element) {
	          stat.actualHeight = videoRenderer.element.videoHeight;
	          stat.actualWidth = videoRenderer.element.videoWidth;
	        }
	      }
	      result.inboundVideo.push(stat);
	    }
	  };
	  for (var _trackId in s.inbound) {
	    var _ret = _loop();
	    if (_ret === "continue") continue;
	  }
	  return result;
	};

	var CallStub = /*#__PURE__*/function () {
	  function CallStub(config) {
	    var _this = this;
	    babelHelpers.classCallCheck(this, CallStub);
	    this.callId = config.callId;
	    this.lifetime = config.lifetime || 120;
	    this.callbacks = {
	      onDelete: main_core.Type.isFunction(config.onDelete) ? config.onDelete : BX.DoNothing
	    };
	    this.deleteTimeout = setTimeout(function () {
	      _this.callbacks.onDelete({
	        callId: _this.callId
	      });
	    }, this.lifetime * 1000);
	  }
	  babelHelpers.createClass(CallStub, [{
	    key: "__onPullEvent",
	    value: function __onPullEvent(command, params, extra) {
	      // do nothing
	    }
	  }, {
	    key: "isAnyoneParticipating",
	    value: function isAnyoneParticipating() {
	      return false;
	    }
	  }, {
	    key: "addEventListener",
	    value: function addEventListener() {
	      return false;
	    }
	  }, {
	    key: "removeEventListener",
	    value: function removeEventListener() {
	      return false;
	    }
	  }, {
	    key: "addInvitedUsers",
	    value: function addInvitedUsers() {
	      console.error("unexpected call to CallStub.addInvitedUsers");
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      clearTimeout(this.deleteTimeout);
	      this.callbacks.onDelete = BX.DoNothing;
	    }
	  }]);
	  return CallStub;
	}();

	function _classPrivateMethodInitSpec$4(obj, privateSet) { _checkPrivateRedeclaration$4(obj, privateSet); privateSet.add(obj); }
	function _checkPrivateRedeclaration$4(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }
	function _classPrivateMethodGet$4(receiver, privateSet, fn) { if (!privateSet.has(receiver)) { throw new TypeError("attempted to get private field on non-instance"); } return fn; }
	var CallState = {
	  Idle: 'Idle',
	  Proceeding: 'Proceeding',
	  Connected: 'Connected',
	  Finished: 'Finished'
	};
	var UserState = {
	  Idle: 'Idle',
	  Busy: 'Busy',
	  Calling: 'Calling',
	  Unavailable: 'Unavailable',
	  Declined: 'Declined',
	  Ready: 'Ready',
	  Connecting: 'Connecting',
	  Connected: 'Connected',
	  Failed: 'Failed'
	};
	var EndpointDirection = {
	  SendOnly: 'send',
	  RecvOnly: 'recv',
	  SendRecv: 'sendrecv'
	};
	var CallType = {
	  Instant: 1,
	  Permanent: 2
	};
	var Provider = {
	  Plain: 'Plain',
	  Voximplant: 'Voximplant',
	  Bitrix: 'Bitrix',
	  BitrixDev: 'BitrixDev'
	};
	var Direction = {
	  Incoming: 'Incoming',
	  Outgoing: 'Outgoing'
	};
	var Quality = {
	  VeryHigh: "very_high",
	  High: "high",
	  Medium: "medium",
	  Low: "low",
	  VeryLow: "very_low"
	};
	var UserMnemonic = {
	  all: 'all',
	  none: 'none'
	};
	var CallEvent = {
	  onUserInvited: 'onUserInvited',
	  onUserStateChanged: 'onUserStateChanged',
	  onUserMicrophoneState: 'onUserMicrophoneState',
	  onUserCameraState: 'onUserCameraState',
	  onCameraPublishing: 'onCameraPublishing',
	  onMicrophonePublishing: 'onMicrophonePublishing',
	  onNeedResetMediaDevicesState: 'onNeedResetMediaDevicesState',
	  onUserVideoPaused: 'onUserVideoPaused',
	  onUserScreenState: 'onUserScreenState',
	  onUserRecordState: 'onUserRecordState',
	  onUserVoiceStarted: 'onUserVoiceStarted',
	  onUserVoiceStopped: 'onUserVoiceStopped',
	  onUserFloorRequest: 'onUserFloorRequest',
	  // request for a permission to speak
	  onUserEmotion: 'onUserEmotion',
	  onUserStatsReceived: 'onUserStatsReceived',
	  onCustomMessage: 'onCustomMessage',
	  onLocalMediaReceived: 'onLocalMediaReceived',
	  onLocalMediaStopped: 'onLocalMediaStopped',
	  onMicrophoneLevel: 'onMicrophoneLevel',
	  onDeviceListUpdated: 'onDeviceListUpdated',
	  onRTCStatsReceived: 'onRTCStatsReceived',
	  onCallFailure: 'onCallFailure',
	  onRemoteMediaReceived: 'onRemoteMediaReceived',
	  onRemoteMediaStopped: 'onRemoteMediaStopped',
	  onBadNetworkIndicator: 'onBadNetworkIndicator',
	  onConnectionQualityChanged: 'onConnectionQualityChanged',
	  onNetworkProblem: 'onNetworkProblem',
	  onReconnecting: 'onReconnecting',
	  onReconnected: 'onReconnected',
	  onJoin: 'onJoin',
	  onLeave: 'onLeave',
	  onJoinRoomOffer: 'onJoinRoomOffer',
	  onJoinRoom: 'onJoinRoom',
	  onLeaveRoom: 'onLeaveRoom',
	  onListRooms: 'onListRooms',
	  onUpdateRoom: 'onUpdateRoom',
	  onTransferRoomSpeakerRequest: 'onTransferRoomSpeakerRequest',
	  onTransferRoomSpeaker: 'onTransferRoomSpeaker',
	  onDestroy: 'onDestroy',
	  onGetUserMediaEnded: 'onGetUserMediaEnded',
	  onUpdateLastUsedCameraId: 'onUpdateLastUsedCameraId',
	  onToggleRemoteParticipantVideo: 'onToggleRemoteParticipantVideo',
	  onSwitchTrackRecordStatus: 'onSwitchTrackRecordStatus'
	};
	var ajaxActions$3 = {
	  createCall: 'im.call.create',
	  createChildCall: 'im.call.createChildCall',
	  getPublicChannels: 'pull.channel.public.list',
	  getCall: 'im.call.get'
	};
	var _instantiateCall = /*#__PURE__*/new WeakSet();
	var _onPullEvent = /*#__PURE__*/new WeakSet();
	var _onPullClientEvent = /*#__PURE__*/new WeakSet();
	var _onPullIncomingCall = /*#__PURE__*/new WeakSet();
	var _onUnknownCallPing = /*#__PURE__*/new WeakSet();
	var _onCallDestroy = /*#__PURE__*/new WeakSet();
	var _isCallAppInitialized = /*#__PURE__*/new WeakSet();
	var _getCallFactory = /*#__PURE__*/new WeakSet();
	var Engine = /*#__PURE__*/function () {
	  function Engine() {
	    babelHelpers.classCallCheck(this, Engine);
	    _classPrivateMethodInitSpec$4(this, _getCallFactory);
	    _classPrivateMethodInitSpec$4(this, _isCallAppInitialized);
	    _classPrivateMethodInitSpec$4(this, _onCallDestroy);
	    _classPrivateMethodInitSpec$4(this, _onUnknownCallPing);
	    _classPrivateMethodInitSpec$4(this, _onPullIncomingCall);
	    _classPrivateMethodInitSpec$4(this, _onPullClientEvent);
	    _classPrivateMethodInitSpec$4(this, _onPullEvent);
	    _classPrivateMethodInitSpec$4(this, _instantiateCall);
	    babelHelpers.defineProperty(this, "handlers", {
	      'Call::incoming': _classPrivateMethodGet$4(this, _onPullIncomingCall, _onPullIncomingCall2).bind(this)
	    });
	    this.debugFlag = false;
	    this.calls = {};
	    this.userId = Number(BX.message('USER_ID'));
	    this.siteId = '';
	    this.unknownCalls = {};
	    this.restClient = null;
	    this.pullClient = null;
	    this.finishedCalls = new Set();
	    this.init();
	  }
	  babelHelpers.createClass(Engine, [{
	    key: "init",
	    value: function init() {
	      BX.addCustomEvent("onPullEvent-im", _classPrivateMethodGet$4(this, _onPullEvent, _onPullEvent2).bind(this));
	      BX.addCustomEvent("onPullClientEvent-im", _classPrivateMethodGet$4(this, _onPullClientEvent, _onPullClientEvent2).bind(this));
	    }
	  }, {
	    key: "getSiteId",
	    value: function getSiteId() {
	      return this.siteId || BX.message('SITE_ID') || '';
	    }
	  }, {
	    key: "setSiteId",
	    value: function setSiteId(siteId) {
	      this.siteId = siteId;
	    }
	  }, {
	    key: "getCurrentUserId",
	    value: function getCurrentUserId() {
	      return this.userId;
	    }
	  }, {
	    key: "setCurrentUserId",
	    value: function setCurrentUserId(userId) {
	      this.userId = Number(userId);
	    }
	  }, {
	    key: "setRestClient",
	    value: function setRestClient(restClient) {
	      this.restClient = restClient;
	    }
	  }, {
	    key: "setPullClient",
	    value: function setPullClient(pullClient) {
	      this.pullClient = pullClient;
	    }
	  }, {
	    key: "getRestClient",
	    value: function getRestClient() {
	      return this.restClient || BX.rest;
	    }
	  }, {
	    key: "getPullClient",
	    value: function getPullClient() {
	      return this.pullClient || BX.PULL;
	    }
	  }, {
	    key: "getLogService",
	    value: function getLogService() {
	      return BX.message("call_log_service");
	    }
	  }, {
	    key: "onCallCreated",
	    value: function onCallCreated(call) {
	      BX.onCustomEvent(window, "CallEvents::callCreated", [{
	        call: call
	      }]);
	    }
	  }, {
	    key: "createCall",
	    value: function createCall(config) {
	      var _this = this;
	      return new Promise(function (resolve, reject) {
	        var callType = config.type || CallType.Instant;
	        var callProvider = config.provider || _this.getDefaultProvider();
	        if (config.joinExisting) {
	          for (var callId in _this.calls) {
	            if (_this.calls.hasOwnProperty(callId)) {
	              var call = _this.calls[callId];
	              if (call.provider == config.provider && call.associatedEntity.type == config.entityType && call.associatedEntity.id == config.entityId) {
	                _this.log(callId, "Found existing call, attaching to it");
	                _this.onCallCreated(call);
	                Hardware.isCameraOn = config.videoEnabled === true;
	                return resolve({
	                  call: call,
	                  isNew: false
	                });
	              }
	            }
	          }
	        }
	        var callParameters = {
	          type: callType,
	          provider: callProvider,
	          entityType: config.entityType,
	          entityId: config.entityId,
	          joinExisting: !!config.joinExisting,
	          userIds: main_core.Type.isArray(config.userIds) ? config.userIds : []
	        };
	        _this.getRestClient().callMethod(ajaxActions$3.createCall, callParameters).then(function (response) {
	          if (response.error()) {
	            var error = response.error().getError();
	            return reject({
	              code: error.error,
	              message: error.error_description
	            });
	          }
	          var createCallResponse = response.data();
	          if (createCallResponse.userData) {
	            Util.setUserData(createCallResponse.userData);
	          }
	          if (createCallResponse.publicChannels) {
	            _this.getPullClient().setPublicIds(Object.values(createCallResponse.publicChannels));
	          }
	          if (createCallResponse.ai) {
	            CallAI.setup(createCallResponse.ai);
	          }
	          var callFields = createCallResponse.call;
	          if (_this.calls[callFields['ID']]) {
	            if (_this.calls[callFields['ID']] instanceof CallStub) {
	              _this.calls[callFields['ID']].destroy();
	            } else {
	              console.error("Call " + callFields['ID'] + " already exists");
	              return resolve({
	                call: _this.calls[callFields['ID']],
	                isNew: false
	              });
	            }
	          }
	          var callFactory = _classPrivateMethodGet$4(_this, _getCallFactory, _getCallFactory2).call(_this, callFields['PROVIDER']);
	          Hardware.isCameraOn = config.videoEnabled === true;
	          var call = callFactory.createCall({
	            id: parseInt(callFields['ID']),
	            instanceId: Util.getUuidv4(),
	            direction: Direction.Outgoing,
	            users: createCallResponse.users,
	            userData: createCallResponse.userData,
	            enableMicAutoParameters: config.enableMicAutoParameters !== false,
	            associatedEntity: callFields.ASSOCIATED_ENTITY,
	            type: callFields.TYPE,
	            startDate: callFields.START_DATE,
	            events: {
	              onDestroy: _classPrivateMethodGet$4(_this, _onCallDestroy, _onCallDestroy2).bind(_this)
	            },
	            debug: config.debug === true,
	            logToken: createCallResponse.logToken,
	            connectionData: createCallResponse.connectionData,
	            isCopilotActive: callFields['RECORD_AUDIO']
	            // jwt: callFields['JWT'],
	            // endpoint: callFields['ENDPOINT'],
	          });

	          _this.calls[callFields['ID']] = call;
	          if (createCallResponse.isNew) {
	            _this.log(call.id, "Creating new call");
	          } else {
	            _this.log(call.id, "Server returned existing call, attaching to it");
	          }
	          _this.onCallCreated(call);
	          resolve({
	            call: call,
	            userData: createCallResponse.userData,
	            isNew: createCallResponse.isNew
	          });
	        })["catch"](function (error) {
	          if (main_core.Type.isFunction(error.error)) {
	            error = error.error().getError();
	          }
	          reject({
	            code: error.error,
	            message: error.error_description
	          });
	        });
	      });
	    }
	  }, {
	    key: "createChildCall",
	    value: function createChildCall(parentId, newProvider, newUsers, config) {
	      var _this2 = this;
	      if (!this.calls[parentId]) {
	        return Promise.reject('Parent call is not found');
	      }
	      return new Promise(function (resolve) {
	        var parentCall = _this2.calls[parentId];
	        var callParameters = {
	          parentId: parentId,
	          newProvider: newProvider,
	          newUsers: newUsers
	        };
	        _this2.getRestClient().callMethod(ajaxActions$3.createChildCall, callParameters, function (response) {
	          var createCallResponse = response.data();
	          var callFields = createCallResponse.call;
	          var callFactory = _classPrivateMethodGet$4(_this2, _getCallFactory, _getCallFactory2).call(_this2, callFields['PROVIDER']);
	          var call = callFactory.createCall({
	            id: parseInt(callFields['ID']),
	            instanceId: Util.getUuidv4(),
	            parentId: callFields['PARENT_ID'],
	            direction: Direction.Outgoing,
	            users: createCallResponse.users,
	            userData: createCallResponse.userData,
	            enableMicAutoParameters: parentCall.enableMicAutoParameters !== false,
	            associatedEntity: callFields.ASSOCIATED_ENTITY,
	            type: callFields.TYPE,
	            startDate: callFields.START_DATE,
	            events: {
	              onDestroy: _classPrivateMethodGet$4(_this2, _onCallDestroy, _onCallDestroy2).bind(_this2)
	            },
	            logToken: createCallResponse.logToken,
	            connectionData: createCallResponse.connectionData,
	            debug: config.debug,
	            isCopilotActive: callFields['RECORD_AUDIO']
	            // jwt: callFields['JWT'],
	            // endpoint: callFields['ENDPOINT']
	          });

	          _this2.calls[callFields['ID']] = call;
	          _this2.onCallCreated(call);
	          resolve({
	            call: call,
	            isNew: createCallResponse.isNew
	          });
	        });
	      });
	    }
	  }, {
	    key: "getCallWithId",
	    value: function getCallWithId(id) {
	      var _this3 = this;
	      if (this.calls[id]) {
	        return Promise.resolve({
	          call: this.calls[id],
	          isNew: false
	        });
	      }
	      return new Promise(function (resolve, reject) {
	        _this3.getRestClient().callMethod(ajaxActions$3.getCall, {
	          callId: id
	        }).then(function (answer) {
	          var data = answer.data();
	          resolve({
	            call: _classPrivateMethodGet$4(_this3, _instantiateCall, _instantiateCall2).call(_this3, data.call, data.users, data.logToken, data.connectionData, data.userData),
	            isNew: false
	          });
	        })["catch"](function (error) {
	          console.error(error);
	          if (main_core.Type.isFunction(error.error)) {
	            error = error.error().getError();
	          }
	          reject({
	            code: error.error,
	            message: error.error_description
	          });
	        });
	      });
	    }
	  }, {
	    key: "getDefaultProvider",
	    value: function getDefaultProvider() {
	      return Provider.Plain;
	    }
	  }, {
	    key: "getConferencePageTag",
	    value: function getConferencePageTag(chatDialogId) {
	      return "conference-open-" + chatDialogId;
	    }
	  }, {
	    key: "debug",
	    value: function debug() {
	      var debugFlag = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
	      this.debugFlag = !!debugFlag;
	      return this.debugFlag;
	    }
	  }, {
	    key: "log",
	    value: function log() {
	      var text = Util.getLogMessage.call(Util, arguments);
	      if (im_v2_lib_desktopApi.DesktopApi.isDesktop()) {
	        im_v2_lib_desktopApi.DesktopApi.writeToLogFile(BX.message('USER_ID') + '.video.log', text);
	      }
	      if (this.debugFlag) {
	        if (console) {
	          var a = ['Call log [' + Util.getTimeForLog() + ']: '];
	          console.log.apply(this, a.concat(Array.prototype.slice.call(arguments)));
	        }
	      }
	    }
	  }, {
	    key: "getAllowedVideoQuality",
	    value: function getAllowedVideoQuality(participantsCount) {
	      if (participantsCount < 5) {
	        return Quality.VeryHigh;
	      } else if (participantsCount < 10) {
	        return Quality.High;
	      } else if (participantsCount < 16) {
	        return Quality.Medium;
	      } else if (participantsCount < 32) {
	        return Quality.Low;
	      } else {
	        return Quality.VeryLow;
	      }
	    }
	  }]);
	  return Engine;
	}();
	function _instantiateCall2(callFields, users, logToken, connectionData, userData) {
	  if (this.calls[callFields['ID']]) {
	    console.error("Call " + callFields['ID'] + " already exists");
	    return this.calls[callFields['ID']];
	  }
	  var callFactory = _classPrivateMethodGet$4(this, _getCallFactory, _getCallFactory2).call(this, callFields['PROVIDER']);
	  var call = callFactory.createCall({
	    id: parseInt(callFields['ID']),
	    instanceId: Util.getUuidv4(),
	    initiatorId: parseInt(callFields['INITIATOR_ID']),
	    parentId: callFields['PARENT_ID'],
	    direction: callFields['INITIATOR_ID'] == this.userId ? Direction.Outgoing : Direction.Incoming,
	    users: users,
	    userData: userData,
	    associatedEntity: callFields.ASSOCIATED_ENTITY,
	    type: callFields.TYPE,
	    startDate: callFields['START_DATE'],
	    logToken: logToken,
	    connectionData: connectionData,
	    isCopilotActive: callFields['RECORD_AUDIO'],
	    // jwt: callFields['JWT'],
	    // endpoint: callFields['ENDPOINT'],

	    events: {
	      onDestroy: _classPrivateMethodGet$4(this, _onCallDestroy, _onCallDestroy2).bind(this)
	    }
	  });
	  this.calls[callFields['ID']] = call;
	  this.onCallCreated(call);
	  return call;
	}
	function _onPullEvent2(command, params, extra) {
	  var _this4 = this;
	  if (command.startsWith('Call::')) {
	    if (params.publicIds) {
	      this.getPullClient().setPublicIds(Object.values(params.publicIds));
	    }
	    if (params.userData) {
	      Util.setUserData(params.userData);
	    }
	  }
	  if (this.handlers[command]) {
	    this.handlers[command].call(this, params, extra);
	  } else if (command.startsWith('Call::') && (params['call'] || params['callId'])) {
	    var callId = params['call'] ? params['call']['ID'] : params['callId'];
	    if (this.calls[callId]) {
	      this.calls[callId].__onPullEvent(command, params, extra);
	    } else if (command === 'Call::finish') {
	      this.log(callId, 'Got "Call::finish" before "Call::incoming"');
	      this.finishedCalls.add(callId);
	    } else if (command === 'Call::ping') {
	      _classPrivateMethodGet$4(this, _onUnknownCallPing, _onUnknownCallPing2).call(this, params, extra).then(function (result) {
	        if (result && _this4.calls[callId]) {
	          _this4.calls[callId].__onPullEvent(command, params, extra);
	        }
	      });
	    }
	  }
	}
	function _onPullClientEvent2(command, params, extra) {
	  var _this5 = this;
	  if (command.startsWith('Call::') && params['callId']) {
	    var callId = params['callId'];
	    if (this.calls[callId]) {
	      this.calls[callId].__onPullEvent(command, params, extra);
	    } else if (command === 'Call::ping') {
	      _classPrivateMethodGet$4(this, _onUnknownCallPing, _onUnknownCallPing2).call(this, params, extra).then(function (result) {
	        if (result && _this5.calls[callId]) {
	          _this5.calls[callId].__onPullEvent(command, params, extra);
	        }
	      });
	    }
	  }
	}
	function _onPullIncomingCall2(params, extra) {
	  console.log('#onPullIncomingCall', location.href);
	  if (extra.server_time_ago > 30) {
	    console.error("Call was started too long time ago");
	    return;
	  }
	  var callFields = params.call;
	  var callId = parseInt(callFields.ID);
	  var call;
	  if (this.finishedCalls.has(callId)) {
	    this.log(callId, 'Got "Call::incoming" after "Call::finish"');
	    return;
	  }
	  if (params.publicIds) {
	    this.getPullClient().setPublicIds(Object.values(params.publicIds));
	  }
	  if (params.userData) {
	    Util.setUserData(params.userData);
	  }
	  call = this.calls[callId];
	  if (!!call) {
	    call.associatedEntity = callFields.ASSOCIATED_ENTITY;
	    call.state = CallState.Idle;
	  }
	  if (!call) {
	    var callFactory = _classPrivateMethodGet$4(this, _getCallFactory, _getCallFactory2).call(this, callFields.PROVIDER);
	    call = callFactory.createCall({
	      id: callId,
	      instanceId: Util.getUuidv4(),
	      parentId: callFields.PARENT_ID || null,
	      callFromMobile: params.isLegacyMobile === true,
	      direction: Direction.Incoming,
	      users: params.users,
	      userData: params.userData,
	      initiatorId: params.senderId,
	      associatedEntity: callFields.ASSOCIATED_ENTITY,
	      type: callFields.TYPE,
	      startDate: callFields.START_DATE,
	      logToken: params.logToken,
	      connectionData: params.connectionData,
	      events: {
	        onDestroy: _classPrivateMethodGet$4(this, _onCallDestroy, _onCallDestroy2).bind(this)
	      },
	      isCopilotActive: callFields['RECORD_AUDIO']
	      // jwt: callFields['JWT'],
	      // endpoint: callFields['ENDPOINT']
	    });

	    this.calls[callId] = call;
	  }
	  this.onCallCreated(call);
	  if (call) {
	    call.addInvitedUsers(params.invitedUsers);
	    BX.onCustomEvent(window, "CallEvents::incomingCall", [{
	      call: call,
	      video: params.video === true,
	      isLegacyMobile: params.isLegacyMobile === true
	    }]);
	  }
	  this.log(call.id, "Incoming call " + call.id);
	}
	function _onUnknownCallPing2(params, extra) {
	  var _this6 = this;
	  var callId = Number(params.callId);
	  if (extra.server_time_ago > 10) {
	    this.log(callId, "Error: Ping was sent too long time ago");
	    return Promise.resolve(false);
	  }
	  if (!_classPrivateMethodGet$4(this, _isCallAppInitialized, _isCallAppInitialized2).call(this)) {
	    return Promise.resolve(false);
	  }
	  if (this.unknownCalls[callId]) {
	    return Promise.resolve(false);
	  }
	  this.unknownCalls[callId] = true;
	  if (params.userData) {
	    Util.setUserData(params.userData);
	  }
	  return new Promise(function (resolve) {
	    _this6.getCallWithId(callId).then(function () {
	      _this6.unknownCalls[callId] = false;
	      resolve(true);
	    })["catch"](function (error) {
	      _this6.unknownCalls[callId] = false;
	      _this6.log(callId, "Error: Could not instantiate call", error);
	      resolve(false);
	    });
	  });
	}
	function _onCallDestroy2(e) {
	  var _this7 = this;
	  var callId = e.call.id;
	  this.calls[callId] = new CallStub({
	    callId: callId,
	    onDelete: function onDelete() {
	      if (_this7.calls[callId]) {
	        delete _this7.calls[callId];
	      }
	    }
	  });
	  BX.onCustomEvent(window, "CallEvents::callDestroyed", [{
	    callId: e.call.id
	  }]);
	}
	function _isCallAppInitialized2() {
	  if ('BXIM' in window && 'init' in window.BXIM) {
	    return BXIM.init;
	  } else if (BX.Messenger && BX.Messenger.Application && BX.Messenger.Application.conference) {
	    return BX.Messenger.Application.conference.inited;
	  }

	  //TODO: support new chat
	  return true;
	}
	function _getCallFactory2(providerType) {
	  if (providerType == Provider.Plain) {
	    return PlainCallFactory;
	  } else if (providerType == Provider.Bitrix) {
	    return BitrixCallFactory;
	  } else if (providerType == Provider.Voximplant) {
	    return VoximplantCallFactory;
	  }
	  throw new Error("Unknown call provider type " + providerType);
	}
	var PlainCallFactory = /*#__PURE__*/function () {
	  function PlainCallFactory() {
	    babelHelpers.classCallCheck(this, PlainCallFactory);
	  }
	  babelHelpers.createClass(PlainCallFactory, null, [{
	    key: "createCall",
	    value: function createCall(config) {
	      return new PlainCall(config);
	    }
	  }]);
	  return PlainCallFactory;
	}();
	var BitrixCallFactory = /*#__PURE__*/function () {
	  function BitrixCallFactory() {
	    babelHelpers.classCallCheck(this, BitrixCallFactory);
	  }
	  babelHelpers.createClass(BitrixCallFactory, null, [{
	    key: "createCall",
	    value: function createCall(config) {
	      return new BitrixCall(config);
	    }
	  }]);
	  return BitrixCallFactory;
	}();
	var VoximplantCallFactory = /*#__PURE__*/function () {
	  function VoximplantCallFactory() {
	    babelHelpers.classCallCheck(this, VoximplantCallFactory);
	  }
	  babelHelpers.createClass(VoximplantCallFactory, null, [{
	    key: "createCall",
	    value: function createCall(config) {
	      return new VoximplantCall(config);
	    }
	  }]);
	  return VoximplantCallFactory;
	}();
	var CallEngine = new Engine();

	var blankAvatar = '/bitrix/js/im/images/blank.gif';
	var userData = {};
	var usersInProcess = {};
	function updateUserData(callId, users) {
	  var usersToUpdate = [];
	  for (var i = 0; i < users.length; i++) {
	    if (userData.hasOwnProperty(users[i])) {
	      continue;
	    }
	    usersToUpdate.push(users[i]);
	  }
	  var result = new Promise(function (resolve, reject) {
	    if (usersToUpdate.length === 0) {
	      return resolve();
	    }
	    CallEngine.getRestClient().callMethod("im.call.getUsers", {
	      callId: callId,
	      userIds: usersToUpdate
	    }).then(function (response) {
	      var result = main_core.Type.isPlainObject(response.answer.result) ? response.answer.result : {};
	      users.forEach(function (userId) {
	        if (result[userId]) {
	          userData[userId] = result[userId];
	        }
	        delete usersInProcess[userId];
	      });
	      resolve();
	    })["catch"](function (error) {
	      reject(error.answer);
	    });
	  });
	  for (var _i = 0; _i < usersToUpdate.length; _i++) {
	    usersInProcess[usersToUpdate[_i]] = result;
	  }
	  return result;
	}
	function setUserData(users) {
	  for (var userId in users) {
	    userData[userId] = users[userId];
	  }
	}
	var getDateForLog = function getDateForLog() {
	  var d = new Date();
	  return d.getFullYear() + "-" + lpad(d.getMonth() + 1, 2, '0') + "-" + lpad(d.getDate(), 2, '0') + " " + lpad(d.getHours(), 2, '0') + ":" + lpad(d.getMinutes(), 2, '0') + ":" + lpad(d.getSeconds(), 2, '0') + "." + d.getMilliseconds();
	};
	var getTimeForLog = function getTimeForLog() {
	  var d = new Date();
	  return lpad(d.getHours(), 2, '0') + ":" + lpad(d.getMinutes(), 2, '0') + ":" + lpad(d.getSeconds(), 2, '0') + "." + d.getMilliseconds();
	};
	function lpad(str, length, chr) {
	  str = str.toString();
	  chr = chr || ' ';
	  if (str.length > length) {
	    return str;
	  }
	  var result = '';
	  for (var i = 0; i < length - str.length; i++) {
	    result += chr;
	  }
	  return result + str;
	}
	function getUser(callId, userId) {
	  return new Promise(function (resolve, reject) {
	    if (userData.hasOwnProperty(userId)) {
	      return resolve(userData[userId]);
	    } else if (usersInProcess.hasOwnProperty(userId)) {
	      usersInProcess[userId].then(function () {
	        return resolve(userData[userId]);
	      });
	    } else {
	      updateUserData(callId, [userId]).then(function () {
	        return resolve(userData[userId]);
	      });
	    }
	  });
	}
	function getUserCached(userId) {
	  return userData.hasOwnProperty(userId) ? userData[userId] : null;
	}
	function getUsers(callId, users) {
	  return new Promise(function (resolve, reject) {
	    updateUserData(callId, users).then(function () {
	      var result = {};
	      users.forEach(function (userId) {
	        return result[userId] = userData[userId] || {};
	      });
	      return resolve(result);
	    });
	  });
	}
	function getUserName(callId, userId) {
	  return new Promise(function (resolve, reject) {
	    if (userData.hasOwnProperty(userId)) {
	      return resolve(userData[userId].name ? userData[userId].name : '');
	    } else if (usersInProcess.hasOwnProperty(userId)) {
	      usersInProcess[userId].then(function () {
	        return resolve(userData[userId].name ? userData[userId].name : '');
	      });
	    } else {
	      updateUserData(callId, [userId]).then(function () {
	        return resolve(userData[userId].name ? userData[userId].name : '');
	      });
	    }
	  });
	}
	function getUserAvatar(callId, userId) {
	  return new Promise(function (resolve, reject) {
	    if (userData.hasOwnProperty(userId)) {
	      return resolve(userData[userId].avatar_hr && !isBlank(userData[userId].avatar_hr) ? userData[userId].avatar_hr : '');
	    } else if (usersInProcess.hasOwnProperty(userId)) {
	      usersInProcess[userId].then(function () {
	        return resolve(userData[userId].avatar_hr && !isBlank(userData[userId].avatar_hr) ? userData[userId].avatar_hr : '');
	      });
	    } else {
	      updateUserData(callId, [userId]).then(function () {
	        return resolve(userData[userId].avatar_hr && !isBlank(userData[userId].avatar_hr) ? userData[userId].avatar_hr : '');
	      });
	    }
	  });
	}
	function getUserAvatars(callId, users) {
	  return new Promise(function (resolve, reject) {
	    updateUserData(callId, users).then(function () {
	      var result = {};
	      users.forEach(function (userId) {
	        result[userId] = userData[userId].avatar_hr && !isBlank(userData[userId].avatar_hr) ? userData[userId].avatar_hr : '';
	      });
	      return resolve(result);
	    });
	  });
	}
	function isAvatarBlank(url) {
	  return isBlank(url);
	}
	function getCustomMessage(message, userData) {
	  var messageText;
	  if (!main_core.Type.isPlainObject(userData)) {
	    userData = {};
	  }
	  if (userData.gender && BX.message.hasOwnProperty(message + '_' + userData.gender)) {
	    messageText = BX.message(message + '_' + userData.gender);
	  } else {
	    messageText = BX.message(message);
	  }
	  userData = convertKeysToUpper(userData);
	  return messageText.replace(/#.+?#/gm, function (match) {
	    var placeHolder = match.substr(1, match.length - 2);
	    return userData.hasOwnProperty(placeHolder) ? userData[placeHolder] : match;
	  });
	}
	function convertKeysToUpper(obj) {
	  var result = BX.util.objectClone(obj);
	  for (var k in result) {
	    var u = k.toUpperCase();
	    if (u != k) {
	      result[u] = result[k];
	      delete result[k];
	    }
	  }
	  return result;
	}
	function appendChildren(parent, children) {
	  children.forEach(function (child) {
	    return parent.appendChild(child);
	  });
	}
	function containsVideoTrack(stream) {
	  if (!(stream instanceof MediaStream)) {
	    return false;
	  }
	  return stream.getVideoTracks().length > 0;
	}
	function hasHdVideo(stream) {
	  if (!(stream instanceof MediaStream) || stream.getVideoTracks().length === 0) {
	    return false;
	  }
	  var videoTrack = stream.getVideoTracks()[0];
	  var trackSettings = videoTrack.getSettings();
	  return trackSettings.width >= 1280;
	}
	function findBestElementSize(width, height, userCount, minWidth, minHeight) {
	  minWidth = minWidth || 0;
	  minHeight = minHeight || 0;
	  var bestFilledArea = 0;
	  for (var i = 1; i <= userCount; i++) {
	    var area = getFilledArea(width, height, userCount, i);
	    if (area.area > bestFilledArea && area.elementWidth > minWidth && area.elementHeight > minHeight) {
	      bestFilledArea = area.area;
	      var bestWidth = area.elementWidth;
	      var bestHeight = area.elementHeight;
	    }
	    if (area.area < bestFilledArea) {
	      break;
	    }
	  }
	  if (bestFilledArea === 0) {
	    bestWidth = minWidth;
	    bestHeight = minHeight;
	  }
	  return {
	    width: bestWidth,
	    height: bestHeight
	  };
	}
	function getFilledArea(width, height, userCount, rowCount) {
	  var columnCount = Math.ceil(userCount / rowCount);
	  var maxElementWidth = Math.floor(width / columnCount);
	  var maxElementHeight = Math.floor(height / rowCount);
	  var ratio = maxElementHeight / maxElementWidth;
	  var neededRatio = 9 / 16;
	  var expectedElementHeight;
	  var expectedElementWidth;
	  if (ratio < neededRatio) {
	    expectedElementHeight = maxElementHeight;
	    expectedElementWidth = Math.floor(maxElementWidth * (ratio / neededRatio));
	  } else {
	    expectedElementWidth = maxElementWidth;
	    expectedElementHeight = Math.floor(maxElementHeight * (neededRatio / ratio));
	  }

	  //console.log(expectedElementWidth + 'x' + expectedElementHeight)
	  var area = expectedElementWidth * expectedElementHeight * userCount;
	  return {
	    area: area,
	    elementWidth: expectedElementWidth,
	    elementHeight: expectedElementHeight
	  };
	}
	var isWebRTCSupported = function isWebRTCSupported() {
	  return typeof webkitRTCPeerConnection != 'undefined' || typeof mozRTCPeerConnection != 'undefined' || typeof RTCPeerConnection != 'undefined';
	};
	var isCallServerAllowed = function isCallServerAllowed() {
	  return BX.message('call_server_enabled') === 'Y';
	};
	var isFeedbackAllowed = function isFeedbackAllowed() {
	  return BX.message('call_allow_feedback') === 'Y';
	};
	var shouldCollectStats = function shouldCollectStats() {
	  return BX.message('call_collect_stats') === 'Y';
	};
	var shouldShowDocumentButton = function shouldShowDocumentButton() {
	  return BX.message('call_docs_status') !== 'N' || BX.message('call_resumes_status') !== 'N';
	};
	var getDocumentsArticleCode = function getDocumentsArticleCode() {
	  if (!BX.message('call_docs_status').startsWith('L')) {
	    return false;
	  }
	  return BX.message('call_docs_status').substr(2);
	};
	var getResumesArticleCode = function getResumesArticleCode() {
	  if (!BX.message('call_resumes_status').startsWith('L')) {
	    return false;
	  }
	  return BX.message('call_resumes_status').substr(2);
	};
	var getUserLimit = function getUserLimit() {
	  if (isCallServerAllowed()) {
	    return parseInt(BX.message('call_server_max_users'));
	  }
	  return parseInt(BX.message('turn_server_max_users'));
	};
	var getClientSelfTestUrl = function getClientSelfTestUrl() {
	  var _BX$message;
	  return (_BX$message = BX.message('call_client_selftest_url')) !== null && _BX$message !== void 0 ? _BX$message : '';
	};
	var getCallFeatures = function getCallFeatures() {
	  return BX.message('call_features');
	};
	function getLogMessage() {
	  var text = getDateForLog();
	  for (var i = 0; i < arguments.length; i++) {
	    if (arguments[i] instanceof Error) {
	      text = arguments[i].message + "\n" + arguments[i].stack;
	    } else {
	      try {
	        text = text + ' | ' + (babelHelpers["typeof"](arguments[i]) == 'object' ? JSON.stringify(arguments[i]) : arguments[i]);
	      } catch (e) {
	        text = text + ' | (circular structure)';
	      }
	    }
	  }
	  return text;
	}
	var getUuidv4 = function getUuidv4() {
	  return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
	    var r = Math.random() * 16 | 0,
	      v = c == 'x' ? r : r & 0x3 | 0x8;
	    return v.toString(16);
	  });
	};
	function reportConnectionResult(callId, connectionResult) {
	  BX.ajax.runAction("im.call.reportConnection", {
	    data: {
	      callId: callId,
	      connectionResult: connectionResult
	    }
	  });
	}
	function sendTelemetryEvent(options) {
	  var url = (document.location.protocol == "https:" ? "https://" : "http://") + "bitrix.info/bx_stat";
	  var req = new XMLHttpRequest();
	  req.open("POST", url, true);
	  req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	  req.withCredentials = true;
	  options.op = "call";
	  options.d = document.location.host;
	  var query = BX.util.buildQueryString(options);
	  req.send(query);
	}
	var isDesktop = function isDesktop() {
	  return typeof BXDesktopSystem != "undefined" || typeof BXDesktopWindow != "undefined";
	};
	var getBrowserForStatistics = function getBrowserForStatistics() {
	  if (BX.browser.IsOpera()) {
	    return 'opera';
	  }
	  if (BX.browser.IsChrome()) {
	    return 'chrome';
	  }
	  if (BX.browser.IsFirefox()) {
	    return 'firefox';
	  }
	  if (BX.browser.IsSafari()) {
	    return 'safari';
	  }
	  return 'other';
	};
	function isBlank(url) {
	  return typeof url !== "string" || url == "" || url.endsWith(blankAvatar);
	}
	function stopMediaStreamAudioTracks(mediaStream) {
	  if (!mediaStream instanceof MediaStream) {
	    return;
	  }
	  mediaStream.getAudioTracks().forEach(function (track) {
	    if (track.readyState == 'live' && track.kind === 'audio') {
	      track.stop();
	    }
	    mediaStream.removeTrack(track);
	  });
	}
	function stopMediaStreamVideoTracks(mediaStream) {
	  if (!mediaStream instanceof MediaStream) {
	    return;
	  }
	  mediaStream.getTracks().forEach(function (track) {
	    if (track.readyState == 'live' && track.kind === 'video') {
	      track.stop();
	    }
	    mediaStream.removeTrack(track);
	  });
	}
	function stopMediaStream(mediaStream) {
	  if (!mediaStream instanceof MediaStream) {
	    return;
	  }
	  mediaStream.getTracks().forEach(function (track) {
	    track.stop();
	  });
	}
	function getConferenceProvider() {
	  if (isCallServerAllowed()) {
	    return Provider.Bitrix;
	  }
	  return Provider.Plain;
	}
	function setCodecToReport(report, codecs, reportsWithoutCodecs) {
	  if (codecs[report.codecId]) {
	    report.codecName = codecs[report.codecId];
	    return true;
	  }
	  return false;
	}
	function saveReportWithoutCodecs(report, reportsWithoutCodecs) {
	  if (reportsWithoutCodecs[report.codecId]) {
	    reportsWithoutCodecs[report.codecId].push(report);
	  } else {
	    reportsWithoutCodecs[report.codecId] = [report];
	  }
	}
	function processReportsWithoutCodecs(report, codecs, reportsWithoutCodecs) {
	  codecs[report.id] = report.mimeType;
	  if (reportsWithoutCodecs[report.id]) {
	    reportsWithoutCodecs[report.id].forEach(function (r) {
	      r.codecName = report.mimeType;
	    });
	    delete reportsWithoutCodecs[report.id];
	  }
	}
	function setLocalPacketsLostOrSaveReport(report, remoteReports, reportsWithoutRemoteInfo) {
	  if (remoteReports[report.id]) {
	    var packetsLostData = calcLocalPacketsLost(report, remoteReports[report.id]);
	    report.packetsLostData = packetsLostData;
	    report.packetsLost = packetsLostData.totalPacketsLost;
	    report.packetsLostExtended = formatPacketsLostData(packetsLostData);
	    delete remoteReports[report.id];
	    return true;
	  } else if (!report.packetsLostExtended) {
	    reportsWithoutRemoteInfo[report.id] = report;
	    return false;
	  }
	}
	function calcBitrate(currentReport, prevReport, isLocal) {
	  prevReport = prevReport || {};
	  var bytes = isLocal ? currentReport.bytesSent - (prevReport.bytesSent || 0) : currentReport.bytesReceived - (prevReport.bytesReceived || 0);
	  var time = currentReport.timestamp - (prevReport.timestamp || 0);
	  var bitrate = 8 * bytes / (time / 1000);
	  return bitrate < 0 ? 0 : Math.trunc(bitrate);
	}
	function calcLocalPacketsLost(currentReport, prevReport, remoteReport) {
	  prevReport = prevReport || {};
	  var packetsLost = Math.abs(remoteReport.packetsLost);
	  var deltaPacketsSent = currentReport.packetsSent - (prevReport.packetsSent || 0);
	  var deltaPacketsLost = packetsLost - (prevReport.packetsLost || 0);
	  var percentPacketLost = deltaPacketsLost / deltaPacketsSent * 100 || 0;
	  var percentPacketLostTotal = packetsLost / currentReport.packetsSent * 100 || 0;
	  return {
	    currentPacketsLost: deltaPacketsLost,
	    currentPercentPacketLost: percentPacketLost >= 0 ? Math.trunc(percentPacketLost) : 0,
	    totalPacketsLost: packetsLost,
	    totalPercentPacketLost: Math.trunc(percentPacketLostTotal)
	  };
	}
	function calcRemotePacketsLost(currentReport, prevReport) {
	  prevReport = prevReport || {};
	  var packetsLost = Math.abs(currentReport.packetsLost);
	  var deltaPacketsReceived = currentReport.packetsReceived - (prevReport.packetsReceived || 0);
	  var deltaPacketsLost = packetsLost - (prevReport.packetsLost || 0);
	  var percentPacketLost = deltaPacketsLost / (deltaPacketsReceived + deltaPacketsLost) * 100 || 0;
	  var percentPacketLostTotal = packetsLost / (currentReport.packetsReceived + packetsLost) * 100 || 0;
	  return {
	    currentPacketsLost: deltaPacketsLost,
	    currentPercentPacketLost: percentPacketLost >= 0 ? Math.trunc(percentPacketLost) : 0,
	    totalPacketsLost: packetsLost,
	    totalPercentPacketLost: Math.trunc(percentPacketLostTotal)
	  };
	}
	function formatPacketsLostData(data) {
	  return "".concat(data.currentPacketsLost, " - ").concat(data.currentPercentPacketLost, "% (total: ").concat(data.totalPacketsLost, " - ").concat(data.totalPercentPacketLost, "%)");
	}
	function getAvatarBackground() {
	  var colorList = ['#006484', '#00A2E8', '#559BE6', '#688800', '#7FA800', '#11A9D9', '#0B66C3', '#004F69', '#00789E', '#506900', '#828B95'];
	  return colorList[Math.floor(Math.random() * colorList.length)];
	}
	function getRecordTimeText(recordState) {
	  var returnInSeconds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	  if (!recordState) {
	    return '';
	  }
	  var nowDate = new Date();
	  var startDate = new Date(recordState.date.start);
	  if (startDate.getTime() < nowDate.getDate()) {
	    startDate = nowDate;
	  }
	  var pauseTime = recordState.date.pause.map(function (element) {
	    var finish = element.finish ? new Date(element.finish) : nowDate;
	    return finish - new Date(element.start);
	  }).reduce(function (sum, element) {
	    return sum + element;
	  }, 0);
	  var totalTime = nowDate - startDate - pauseTime;
	  if (totalTime <= 0) {
	    totalTime = 0;
	  }
	  var second = Math.floor(totalTime / 1000);
	  if (returnInSeconds) {
	    return second;
	  }
	  var hour = Math.floor(second / 60 / 60);
	  if (hour > 0) {
	    second -= hour * 60 * 60;
	  }
	  var minute = Math.floor(second / 60);
	  if (minute > 0) {
	    second -= minute * 60;
	  }
	  return (hour > 0 ? hour + ':' : '') + (hour > 0 ? minute.toString().padStart(2, "0") + ':' : minute + ':') + second.toString().padStart(2, "0");
	}
	function getTimeText(startTime) {
	  if (!startTime) {
	    return '';
	  }
	  var nowDate = new Date();
	  var startDate = new Date(startTime);
	  if (startDate.getTime() < nowDate.getDate()) {
	    startDate = nowDate;
	  }
	  var totalTime = nowDate - startDate;
	  if (totalTime <= 0) {
	    totalTime = 0;
	  }
	  var second = Math.floor(totalTime / 1000);
	  var hour = Math.floor(second / 60 / 60);
	  if (hour > 0) {
	    second -= hour * 60 * 60;
	  }
	  var minute = Math.floor(second / 60);
	  if (minute > 0) {
	    second -= minute * 60;
	  }
	  return (hour > 0 ? hour + ':' : '') + (hour > 0 ? minute.toString().padStart(2, "0") + ':' : minute + ':') + second.toString().padStart(2, "0");
	}
	function getTimeInSeconds(startTime) {
	  if (!startTime) {
	    return '';
	  }
	  var nowDate = new Date();
	  var startDate = new Date(startTime);
	  if (startDate.getTime() < nowDate.getDate()) {
	    startDate = nowDate;
	  }
	  var totalTime = nowDate - startDate;
	  if (totalTime <= 0) {
	    totalTime = 0;
	  }
	  return Math.floor(totalTime / 1000);
	}
	var isConferenceChatEnabled = function isConferenceChatEnabled() {
	  return BX.message('conference_chat_enabled');
	};
	function startSelfTest() {
	  var link = BX.Call.Util.getClientSelfTestUrl();
	  if (isDesktop()) {
	    window.open(link, '_blank', 'popup');
	    return;
	  }
	  window.open(link, '_blank');
	}
	var useTcpSdp = function useTcpSdp() {
	  return BX.message('call_use_tcp_sdp') === 'Y';
	};
	function openArticle(articleCode) {
	  var infoHelper = BX.UI.InfoHelper;
	  if (infoHelper.isOpen()) {
	    infoHelper.close();
	  }
	  infoHelper.show(articleCode);
	}
	var isUserControlFeatureEnabled = function isUserControlFeatureEnabled() {
	  var _Extension$getSetting;
	  return (_Extension$getSetting = main_core.Extension.getSettings('call.core')) === null || _Extension$getSetting === void 0 ? void 0 : _Extension$getSetting.isUserControlFeatureEnabled;
	};
	var isPictureInPictureFeatureEnabled = function isPictureInPictureFeatureEnabled() {
	  var _Extension$getSetting2;
	  return (_Extension$getSetting2 = main_core.Extension.getSettings('call.core')) === null || _Extension$getSetting2 === void 0 ? void 0 : _Extension$getSetting2.isPictureInPictureFeatureEnabled;
	};
	var isNewQOSEnabled = function isNewQOSEnabled() {
	  var _Extension$getSetting3;
	  return (_Extension$getSetting3 = main_core.Extension.getSettings('call.core')) === null || _Extension$getSetting3 === void 0 ? void 0 : _Extension$getSetting3.isNewQOSEnabled;
	};
	var Util = {
	  updateUserData: updateUserData,
	  setUserData: setUserData,
	  getDateForLog: getDateForLog,
	  getTimeForLog: getTimeForLog,
	  lpad: lpad,
	  getUser: getUser,
	  getUserCached: getUserCached,
	  getUsers: getUsers,
	  getUserName: getUserName,
	  getUserAvatar: getUserAvatar,
	  getUserAvatars: getUserAvatars,
	  isAvatarBlank: isAvatarBlank,
	  getCustomMessage: getCustomMessage,
	  convertKeysToUpper: convertKeysToUpper,
	  appendChildren: appendChildren,
	  containsVideoTrack: containsVideoTrack,
	  hasHdVideo: hasHdVideo,
	  findBestElementSize: findBestElementSize,
	  getFilledArea: getFilledArea,
	  isWebRTCSupported: isWebRTCSupported,
	  isCallServerAllowed: isCallServerAllowed,
	  isFeedbackAllowed: isFeedbackAllowed,
	  shouldCollectStats: shouldCollectStats,
	  shouldShowDocumentButton: shouldShowDocumentButton,
	  getDocumentsArticleCode: getDocumentsArticleCode,
	  getResumesArticleCode: getResumesArticleCode,
	  getUserLimit: getUserLimit,
	  getClientSelfTestUrl: getClientSelfTestUrl,
	  getLogMessage: getLogMessage,
	  getUuidv4: getUuidv4,
	  reportConnectionResult: reportConnectionResult,
	  sendTelemetryEvent: sendTelemetryEvent,
	  isDesktop: isDesktop,
	  getBrowserForStatistics: getBrowserForStatistics,
	  isBlank: isBlank,
	  stopMediaStream: stopMediaStream,
	  stopMediaStreamVideoTracks: stopMediaStreamVideoTracks,
	  stopMediaStreamAudioTracks: stopMediaStreamAudioTracks,
	  getConferenceProvider: getConferenceProvider,
	  setCodecToReport: setCodecToReport,
	  saveReportWithoutCodecs: saveReportWithoutCodecs,
	  processReportsWithoutCodecs: processReportsWithoutCodecs,
	  setLocalPacketsLostOrSaveReport: setLocalPacketsLostOrSaveReport,
	  calcBitrate: calcBitrate,
	  calcLocalPacketsLost: calcLocalPacketsLost,
	  calcRemotePacketsLost: calcRemotePacketsLost,
	  formatPacketsLostData: formatPacketsLostData,
	  getCallFeatures: getCallFeatures,
	  getAvatarBackground: getAvatarBackground,
	  getRecordTimeText: getRecordTimeText,
	  getTimeText: getTimeText,
	  getTimeInSeconds: getTimeInSeconds,
	  isConferenceChatEnabled: isConferenceChatEnabled,
	  startSelfTest: startSelfTest,
	  useTcpSdp: useTcpSdp,
	  openArticle: openArticle,
	  isUserControlFeatureEnabled: isUserControlFeatureEnabled,
	  isPictureInPictureFeatureEnabled: isPictureInPictureFeatureEnabled,
	  isNewQOSEnabled: isNewQOSEnabled
	};

	function _classPrivateMethodInitSpec$5(obj, privateSet) { _checkPrivateRedeclaration$5(obj, privateSet); privateSet.add(obj); }
	function _checkPrivateRedeclaration$5(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }
	function _classPrivateMethodGet$5(receiver, privateSet, fn) { if (!privateSet.has(receiver)) { throw new TypeError("attempted to get private field on non-instance"); } return fn; }
	var Events$1 = {
	  onClose: 'onClose',
	  onDestroy: 'onDestroy',
	  onButtonClick: 'onButtonClick'
	};
	var InternalEvents = {
	  setHasCamera: "CallNotification::setHasCamera",
	  contentReady: "CallNotification::contentReady",
	  onButtonClick: "CallNotification::onButtonClick"
	};
	var _subscribeEvents = /*#__PURE__*/new WeakSet();
	var _onButtonClick = /*#__PURE__*/new WeakSet();
	var _onContentReady = /*#__PURE__*/new WeakSet();
	var IncomingNotification = /*#__PURE__*/function (_EventEmitter) {
	  babelHelpers.inherits(IncomingNotification, _EventEmitter);
	  function IncomingNotification(_config) {
	    var _this;
	    babelHelpers.classCallCheck(this, IncomingNotification);
	    _this = babelHelpers.possibleConstructorReturn(this, babelHelpers.getPrototypeOf(IncomingNotification).call(this));
	    _classPrivateMethodInitSpec$5(babelHelpers.assertThisInitialized(_this), _onContentReady);
	    _classPrivateMethodInitSpec$5(babelHelpers.assertThisInitialized(_this), _onButtonClick);
	    _classPrivateMethodInitSpec$5(babelHelpers.assertThisInitialized(_this), _subscribeEvents);
	    _this.setEventNamespace('BX.Call.IncomingNotification');
	    _this.popup = null;
	    _this.window = null;
	    _this.callerAvatar = main_core.Type.isStringFilled(_config.callerAvatar) ? _config.callerAvatar : "";
	    if (Util.isAvatarBlank(_this.callerAvatar)) {
	      _this.callerAvatar = "";
	    }
	    _this.callerName = _config.callerName;
	    _this.callerType = _config.callerType;
	    _this.callerColor = _config.callerColor;
	    _this.video = _config.video;
	    _this.hasCamera = _config.hasCamera === true;
	    _this.zIndex = _config.zIndex;
	    _this.isMessengerOpen = _config.isMessengerOpen;
	    _this.contentReady = false;
	    _this.postponedEvents = [];
	    _this.microphoneState = _config.microphoneState;
	    _this.cameraState = _config.cameraState;
	    _classPrivateMethodGet$5(babelHelpers.assertThisInitialized(_this), _subscribeEvents, _subscribeEvents2).call(babelHelpers.assertThisInitialized(_this), _config);
	    if (im_v2_lib_desktopApi.DesktopApi.isDesktop()) {
	      _this.onButtonClickHandler = _classPrivateMethodGet$5(babelHelpers.assertThisInitialized(_this), _onButtonClick, _onButtonClick2).bind(babelHelpers.assertThisInitialized(_this));
	      _this.onContentReadyHandler = _classPrivateMethodGet$5(babelHelpers.assertThisInitialized(_this), _onContentReady, _onContentReady2).bind(babelHelpers.assertThisInitialized(_this));
	      im_v2_lib_desktopApi.DesktopApi.subscribe(InternalEvents.onButtonClick, _this.onButtonClickHandler);
	      im_v2_lib_desktopApi.DesktopApi.subscribe(InternalEvents.contentReady, _this.onContentReadyHandler);
	    }
	    return _this;
	  }
	  babelHelpers.createClass(IncomingNotification, [{
	    key: "show",
	    value: function show() {
	      var _this2 = this;
	      console.log('incoming notification : SHOW');
	      if (im_v2_lib_desktopApi.DesktopApi.isChatWindow()) {
	        console.log('incoming notification : ISDESKTOP');
	        var params = {
	          video: this.video,
	          hasCamera: this.hasCamera,
	          callerAvatar: this.callerAvatar,
	          callerName: this.callerName,
	          callerType: this.callerType,
	          callerColor: this.callerColor,
	          microphoneState: this.microphoneState,
	          cameraState: this.cameraState,
	          isMessengerOpen: this.isMessengerOpen
	        };
	        if (this.window) {
	          this.window.BXDesktopWindow.ExecuteCommand("show");
	        } else {
	          var js = "\n\t\t\t\t\twindow.callNotification = new BX.Call.IncomingNotificationContent(".concat(JSON.stringify(params), ");\n\t\t\t\t\twindow.callNotification.showInDesktop();\n\t\t\t\t");
	          var htmlContent = im_v2_lib_desktopApi.DesktopApi.prepareHtml("", js);
	          this.window = im_v2_lib_desktopApi.DesktopApi.createTopmostWindow(htmlContent);
	        }
	      } else {
	        console.log('incoming notification : ISNOTDESKTOP');
	        this.content = new IncomingNotificationContent({
	          video: this.video,
	          hasCamera: this.hasCamera,
	          callerAvatar: this.callerAvatar,
	          callerName: this.callerName,
	          callerType: this.callerType,
	          callerColor: this.callerColor,
	          microphoneState: this.microphoneState,
	          cameraState: this.cameraState,
	          isMessengerOpen: this.isMessengerOpen,
	          onClose: function onClose() {
	            return _this2.emit(Events$1.onClose);
	          },
	          onDestroy: function onDestroy() {
	            return _this2.emit(Events$1.onDestroy);
	          },
	          onButtonClick: function onButtonClick(e) {
	            return _this2.emit(Events$1.onButtonClick, Object.assign({}, e.data));
	          }
	        });
	        this.createPopup(this.content.render());
	        this.popup.show();
	        window.addEventListener('resize', function () {
	          _this2.onResize();
	        });
	      }
	    }
	  }, {
	    key: "onResize",
	    value: function onResize() {
	      if (this.popup) {
	        this.popup.setMaxHeight(document.body.clientHeight);
	      }
	    }
	  }, {
	    key: "createPopup",
	    value: function createPopup(content) {
	      var _this3 = this;
	      this.popup = new main_popup.Popup({
	        id: "bx-messenger-call-notify",
	        bindElement: null,
	        targetContainer: document.body,
	        content: content,
	        closeIcon: false,
	        noAllPaddings: true,
	        zIndex: this.zIndex,
	        disableScroll: true,
	        maxHeight: document.body.clientHeight,
	        offsetLeft: 0,
	        offsetTop: 0,
	        closeByEsc: false,
	        draggable: {
	          restrict: false
	        },
	        borderRadius: '25px',
	        overlay: {
	          backgroundColor: 'black',
	          opacity: 30
	        },
	        events: {
	          onPopupClose: function onPopupClose() {
	            window.removeEventListener('resize', function () {
	              _this3.onResize();
	            });
	            _this3.emit(Events$1.onClose);
	          },
	          onPopupDestroy: function onPopupDestroy() {
	            return _this3.popup = null;
	          }
	        }
	      });
	    }
	  }, {
	    key: "setHasCamera",
	    value: function setHasCamera(hasCamera) {
	      if (this.window) {
	        // desktop; send event to the window
	        if (this.contentReady) {
	          im_v2_lib_desktopApi.DesktopApi.emit(InternalEvents.setHasCamera, [hasCamera]);
	        } else {
	          this.postponedEvents.push({
	            name: InternalEvents.setHasCamera,
	            params: [hasCamera]
	          });
	        }
	      } else if (this.content) {
	        this.content.setHasCamera(hasCamera);
	      }
	    }
	  }, {
	    key: "sendPostponedEvents",
	    value: function sendPostponedEvents() {
	      this.postponedEvents.forEach(function (event) {
	        im_v2_lib_desktopApi.DesktopApi.emit(event.name, event.params);
	      });
	      this.postponedEvents = [];
	    }
	  }, {
	    key: "close",
	    value: function close() {
	      if (this.popup) {
	        this.popup.close();
	      }
	      if (this.window) {
	        this.window.BXDesktopWindow.ExecuteCommand("hide");
	      }
	      this.emit(Events$1.onClose);
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      if (this.popup) {
	        this.popup.destroy();
	        this.popup = null;
	      }
	      if (this.window) {
	        this.window.BXDesktopWindow.ExecuteCommand("close");
	        this.window = null;
	      }
	      if (this.content) {
	        this.content.destroy();
	        this.content = null;
	      }
	      if (im_v2_lib_desktopApi.DesktopApi.isDesktop()) {
	        im_v2_lib_desktopApi.DesktopApi.unsubscribe(InternalEvents.onButtonClick, this.onButtonClickHandler);
	        im_v2_lib_desktopApi.DesktopApi.unsubscribe(InternalEvents.contentReady, this.onContentReadyHandler);
	      }
	      this.emit(Events$1.onDestroy);
	      this.unsubscribeAll(Events$1.onButtonClick);
	      this.unsubscribeAll(Events$1.onClick);
	      this.unsubscribeAll(Events$1.onDestroy);
	    }
	  }]);
	  return IncomingNotification;
	}(main_core_events.EventEmitter);
	function _subscribeEvents2(config) {
	  var eventKeys = Object.keys(Events$1);
	  for (var _i = 0, _eventKeys = eventKeys; _i < _eventKeys.length; _i++) {
	    var eventName = _eventKeys[_i];
	    if (main_core.Type.isFunction(config[eventName])) {
	      this.subscribe(Events$1[eventName], config[eventName]);
	    }
	  }
	}
	function _onButtonClick2(event) {
	  this.emit(Events$1.onButtonClick, event);
	}
	function _onContentReady2() {
	  this.contentReady = true;
	  this.sendPostponedEvents();
	}
	babelHelpers.defineProperty(IncomingNotification, "Events", Events$1);
	var _subscribeEvents3 = /*#__PURE__*/new WeakSet();
	var _onHasCamera = /*#__PURE__*/new WeakSet();
	var _onMicrophoneSettingClick = /*#__PURE__*/new WeakSet();
	var _onCameraSettingClick = /*#__PURE__*/new WeakSet();
	var _onAnswerButtonClick = /*#__PURE__*/new WeakSet();
	var _onAnswerWithVideoButtonClick = /*#__PURE__*/new WeakSet();
	var _onDeclineButtonClick = /*#__PURE__*/new WeakSet();
	var IncomingNotificationContent = /*#__PURE__*/function (_EventEmitter2) {
	  babelHelpers.inherits(IncomingNotificationContent, _EventEmitter2);
	  function IncomingNotificationContent(_config2) {
	    var _this4;
	    babelHelpers.classCallCheck(this, IncomingNotificationContent);
	    _this4 = babelHelpers.possibleConstructorReturn(this, babelHelpers.getPrototypeOf(IncomingNotificationContent).call(this));
	    _classPrivateMethodInitSpec$5(babelHelpers.assertThisInitialized(_this4), _onDeclineButtonClick);
	    _classPrivateMethodInitSpec$5(babelHelpers.assertThisInitialized(_this4), _onAnswerWithVideoButtonClick);
	    _classPrivateMethodInitSpec$5(babelHelpers.assertThisInitialized(_this4), _onAnswerButtonClick);
	    _classPrivateMethodInitSpec$5(babelHelpers.assertThisInitialized(_this4), _onCameraSettingClick);
	    _classPrivateMethodInitSpec$5(babelHelpers.assertThisInitialized(_this4), _onMicrophoneSettingClick);
	    _classPrivateMethodInitSpec$5(babelHelpers.assertThisInitialized(_this4), _onHasCamera);
	    _classPrivateMethodInitSpec$5(babelHelpers.assertThisInitialized(_this4), _subscribeEvents3);
	    _this4.setEventNamespace('BX.Call.IncomingNotificationContent');
	    _this4.video = !!_config2.video;
	    _this4.hasCamera = !!_config2.hasCamera;
	    _this4.callerAvatar = _config2.callerAvatar || '';
	    _this4.callerName = _config2.callerName || BX.message('IM_M_CALL_VIDEO_HD');
	    _this4.callerType = _config2.callerType || 'chat';
	    _this4.callerColor = _config2.callerColor || '';
	    _this4.microphoneState = _config2.microphoneState;
	    _this4.cameraState = _config2.cameraState;
	    _this4.isMessengerOpen = _config2.isMessengerOpen;
	    _this4.elements = {
	      root: null,
	      avatar: null,
	      buttons: {
	        answerVideo: null
	      }
	    };
	    _classPrivateMethodGet$5(babelHelpers.assertThisInitialized(_this4), _subscribeEvents3, _subscribeEvents4).call(babelHelpers.assertThisInitialized(_this4), _config2);
	    if (im_v2_lib_desktopApi.DesktopApi.isDesktop()) {
	      _this4.onHasCameraHandler = _classPrivateMethodGet$5(babelHelpers.assertThisInitialized(_this4), _onHasCamera, _onHasCamera2).bind(babelHelpers.assertThisInitialized(_this4));
	      im_v2_lib_desktopApi.DesktopApi.subscribe(InternalEvents.setHasCamera, _this4.onHasCameraHandler);
	      im_v2_lib_desktopApi.DesktopApi.emitToMainWindow(InternalEvents.contentReady, []);
	    }
	    return _this4;
	  }
	  babelHelpers.createClass(IncomingNotificationContent, [{
	    key: "render",
	    value: function render() {
	      var _this$elements$window, _this$elements$button;
	      var callerPrefix;
	      if (this.video) {
	        if (this.callerType === 'private') {
	          callerPrefix = BX.message("IM_M_VIDEO_CALL_FROM");
	        } else {
	          callerPrefix = BX.message("IM_M_VIDEO_CALL_FROM_CHAT");
	        }
	      } else {
	        if (this.callerType === 'private') {
	          callerPrefix = BX.message("IM_M_CALL_FROM");
	        } else {
	          callerPrefix = BX.message("IM_M_CALL_FROM_CHAT");
	        }
	      }
	      var avatarClass = '';
	      var avatarImageStyles;
	      var avatarImageText = '';
	      if (this.callerAvatar) {
	        avatarImageStyles = {
	          backgroundImage: "url('" + this.callerAvatar + "')",
	          backgroundColor: '#fff',
	          backgroundSize: 'cover'
	        };
	      } else {
	        var callerType = this.callerType === 'private' ? 'user' : this.callerType;
	        avatarClass = 'bx-messenger-panel-avatar-' + callerType;
	        avatarImageStyles = {
	          backgroundColor: this.callerColor || '#525252',
	          backgroundSize: '40px',
	          backgroundPosition: 'center center'
	        };
	        avatarImageText = im_v2_lib_utils.Utils.text.getFirstLetters(this.callerName).toUpperCase();
	      }
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-call-window" + (im_v2_lib_desktopApi.DesktopApi.isDesktop() ? ' desktop' : '')
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-call-window-body"
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-call-window-top"
	            },
	            children: [main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-call-window-photo bx-messenger-videocall-incoming-call-avatar-pulse"
	              },
	              children: [main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-call-window-photo-left " + avatarClass
	                },
	                children: [this.elements.avatar = main_core.Dom.create("div", {
	                  props: {
	                    className: "bx-messenger-call-window-photo-block"
	                  },
	                  style: avatarImageStyles,
	                  text: avatarImageText
	                })]
	              }), main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-incoming-call-pulse-element",
	                  style: "animation-delay: -2s;"
	                }
	              }), main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-incoming-call-pulse-element",
	                  style: "animation-delay: -1.5s;"
	                }
	              }), main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-incoming-call-pulse-element",
	                  style: "animation-delay: -1s;"
	                }
	              }), main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-incoming-call-pulse-element",
	                  style: "animation-delay: -0.5s;"
	                }
	              })]
	            }), main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-call-window-title"
	              },
	              children: [main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-call-window-title-block"
	                },
	                children: [main_core.Dom.create("div", {
	                  props: {
	                    className: "bx-messenger-call-overlay-title-caller-prefix"
	                  },
	                  text: callerPrefix
	                }), main_core.Dom.create("div", {
	                  props: {
	                    className: "bx-messenger-call-overlay-title-caller"
	                  },
	                  text: main_core.Text.decode(this.callerName)
	                })]
	              })]
	            })]
	          }), this.elements.windowBottom = main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-call-window-bottom"
	            },
	            children: [main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-call-window-buttons"
	              },
	              children: [this.elements.buttonsBlock = main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-call-window-buttons-block"
	                },
	                children: []
	              })]
	            })]
	          })]
	        })]
	      });
	      (_this$elements$window = this.elements.windowBottom).prepend.apply(_this$elements$window, [main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-call-window-settings-block"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-call-window-settings-block-title"
	          },
	          text: BX.message("CALL_M_INCOMING_NOTIFICATION_SETTINGS_TITLE")
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-call-window-settings-buttons-block"
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-call-window-settings-button"
	            },
	            children: [this.elements.buttons.toggleMicrophoneIcon = main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-call-window-settings-icon microphone-" + (this.microphoneState ? "on" : "off")
	              }
	            }), main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-call-window-settings-text microphone"
	              },
	              text: BX.message("IM_M_CALL_BTN_MIC")
	            })],
	            events: {
	              click: _classPrivateMethodGet$5(this, _onMicrophoneSettingClick, _onMicrophoneSettingClick2).bind(this)
	            }
	          }), main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-call-window-settings-separator"
	            }
	          }), main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-call-window-settings-button"
	            },
	            children: [this.elements.buttons.toggleCameraIcon = main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-call-window-settings-icon camera-" + (this.cameraState && this.hasCamera ? "on" : "off") + (this.hasCamera ? "" : " bx-messenger-call-window-button-disabled")
	              }
	            }), main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-call-window-settings-text camera"
	              },
	              text: BX.message("IM_M_CALL_BTN_CAMERA")
	            })],
	            events: {
	              click: _classPrivateMethodGet$5(this, _onCameraSettingClick, _onCameraSettingClick2).bind(this)
	            }
	          })]
	        })]
	      })]);
	      (_this$elements$button = this.elements.buttonsBlock).append.apply(_this$elements$button, [main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-call-window-button bx-messenger-call-window-button-danger"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-call-window-button-icon bx-messenger-call-window-button-icon-phone-down",
	            title: BX.message("IM_M_CALL_BTN_DECLINE")
	          }
	        })],
	        events: {
	          click: _classPrivateMethodGet$5(this, _onDeclineButtonClick, _onDeclineButtonClick2).bind(this)
	        }
	      }), this.elements.buttons.answer = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-call-window-button" + (this.withBlur ? ' with-blur' : ''),
	          title: BX.message("IM_M_CALL_BTN_ANSWER")
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-call-window-button-icon bx-messenger-call-window-button-icon-phone-up"
	          }
	        })],
	        events: {
	          click: _classPrivateMethodGet$5(this, _onAnswerButtonClick, _onAnswerButtonClick2).bind(this)
	        }
	      })]);
	      return this.elements.root;
	    }
	  }, {
	    key: "showInDesktop",
	    value: function showInDesktop() {
	      var _window$opener$BXIM;
	      // Workaround to prevent incoming call window from hanging.
	      // Without it, there is a possible scenario, when BXDesktopWindow.ExecuteCommand("close") is executed too early
	      // (if invite window is closed before appearing), which leads to hanging of the window
	      if ((_window$opener$BXIM = window.opener.BXIM) !== null && _window$opener$BXIM !== void 0 && _window$opener$BXIM.callController && !window.opener.BXIM.callController.callNotification) {
	        BXDesktopWindow.ExecuteCommand("close");
	        return;
	      }
	      var width = 450;
	      var height = 575;
	      this.render();
	      document.body.appendChild(this.elements.root);
	      im_v2_lib_desktopApi.DesktopApi.setWindowPosition({
	        x: STP_CENTER,
	        y: STP_VCENTER,
	        width: width,
	        height: height
	      });
	    }
	  }, {
	    key: "setHasCamera",
	    value: function setHasCamera(hasCamera) {
	      this.hasCamera = !!hasCamera;
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      if (im_v2_lib_desktopApi.DesktopApi.isDesktop()) {
	        im_v2_lib_desktopApi.DesktopApi.unsubscribe(InternalEvents.setHasCamera, this.onHasCameraHandler);
	      }
	      this.unsubscribeAll(Events$1.onButtonClick);
	      this.unsubscribeAll(Events$1.onClick);
	      this.unsubscribeAll(Events$1.onDestroy);
	    }
	  }]);
	  return IncomingNotificationContent;
	}(main_core_events.EventEmitter);
	function _subscribeEvents4(config) {
	  var eventKeys = Object.keys(Events$1);
	  for (var _i2 = 0, _eventKeys2 = eventKeys; _i2 < _eventKeys2.length; _i2++) {
	    var eventName = _eventKeys2[_i2];
	    if (main_core.Type.isFunction(config[eventName])) {
	      this.subscribe(Events$1[eventName], config[eventName]);
	    }
	  }
	}
	function _onHasCamera2() {}
	function _onMicrophoneSettingClick2() {
	  this.microphoneState = !this.microphoneState;
	  if (this.microphoneState) {
	    this.elements.buttons.toggleMicrophoneIcon.classList.add('microphone-on');
	    this.elements.buttons.toggleMicrophoneIcon.classList.remove('microphone-off');
	  } else {
	    this.elements.buttons.toggleMicrophoneIcon.classList.add('microphone-off');
	    this.elements.buttons.toggleMicrophoneIcon.classList.remove('microphone-on');
	  }
	}
	function _onCameraSettingClick2() {
	  this.cameraState = !this.cameraState;
	  if (this.cameraState) {
	    this.elements.buttons.toggleCameraIcon.classList.add('camera-on');
	    this.elements.buttons.toggleCameraIcon.classList.remove('camera-off');
	  } else {
	    this.elements.buttons.toggleCameraIcon.classList.add('camera-off');
	    this.elements.buttons.toggleCameraIcon.classList.remove('camera-on');
	  }
	}
	function _onAnswerButtonClick2() {
	  if (!this.hasCamera) {
	    this.cameraState = false;
	    this.microphoneState = true;
	  }
	  if (this.isMessengerOpen && typeof BX.SidePanel !== 'undefined' && BX.SidePanel.Instance.isOpen()) {
	    BX.SidePanel.Instance.close();
	  }
	  if (im_v2_lib_desktopApi.DesktopApi.isDesktop()) {
	    im_v2_lib_desktopApi.DesktopApi.closeWindow();
	    im_v2_lib_desktopApi.DesktopApi.emitToMainWindow(InternalEvents.onButtonClick, [{
	      button: 'answer',
	      mediaParams: {
	        audio: this.microphoneState,
	        video: this.cameraState
	      }
	    }]);
	  } else {
	    this.emit(Events$1.onButtonClick, {
	      button: 'answer',
	      mediaParams: {
	        audio: this.microphoneState,
	        video: this.cameraState
	      }
	    });
	  }
	}
	function _onDeclineButtonClick2() {
	  if (im_v2_lib_desktopApi.DesktopApi.isDesktop()) {
	    im_v2_lib_desktopApi.DesktopApi.closeWindow();
	    im_v2_lib_desktopApi.DesktopApi.emitToMainWindow(InternalEvents.onButtonClick, [{
	      button: 'decline'
	    }]);
	  } else {
	    this.emit(Events$1.onButtonClick, {
	      button: 'decline'
	    });
	  }
	}

	var Events$2 = {
	  onButtonClick: "ConferenceNotification::onButtonClick"
	};

	/**
	 *
	 * @param {Object} config
	 * @param {string} config.callerName
	 * @param {string} config.callerAvatar
	 * @param {number} config.zIndex
	 * @param {function} config.onClose
	 * @param {function} config.onDestroy
	 * @param {function} config.onButtonClick
	 * @constructor
	 */
	var ConferenceNotifications = /*#__PURE__*/function () {
	  function ConferenceNotifications(config) {
	    babelHelpers.classCallCheck(this, ConferenceNotifications);
	    this.popup = null;
	    this.window = null;
	    this.callerAvatar = main_core.Type.isStringFilled(config.callerAvatar) ? config.callerAvatar : "";
	    this.zIndex = config.zIndex;
	    if (Util.isAvatarBlank(this.callerAvatar)) {
	      this.callerAvatar = "";
	    }
	    this.callerName = config.callerName;
	    this.callerColor = config.callerColor;
	    this.callbacks = {
	      onClose: main_core.Type.isFunction(config.onClose) ? config.onClose : BX.DoNothing,
	      onDestroy: main_core.Type.isFunction(config.onDestroy) ? config.onDestroy : BX.DoNothing,
	      onButtonClick: main_core.Type.isFunction(config.onButtonClick) ? config.onButtonClick : BX.DoNothing
	    };
	    this._onContentButtonClickHandler = this._onContentButtonClick.bind(this);
	    if (im_v2_lib_desktopApi.DesktopApi.isDesktop()) {
	      im_v2_lib_desktopApi.DesktopApi.subscribe(Events$2.onButtonClick, this._onContentButtonClickHandler);
	    }
	  }
	  babelHelpers.createClass(ConferenceNotifications, [{
	    key: "show",
	    value: function show() {
	      var _this = this;
	      if (im_v2_lib_desktopApi.DesktopApi.isChatWindow()) {
	        var params = {
	          callerAvatar: this.callerAvatar,
	          callerName: this.callerName,
	          callerColor: this.callerColor
	        };
	        if (this.window) {
	          this.window.BXDesktopWindow.ExecuteCommand("show");
	        } else {
	          var js = "\n\t\t\t\t\twindow.conferenceNotification = new BX.Call.NotificationConferenceContent(".concat(JSON.stringify(params), ");\n\t\t\t\t\twindow.conferenceNotification.showInDesktop();\n\t\t\t\t");
	          var html = im_v2_lib_desktopApi.DesktopApi.prepareHtml('', js);
	          this.window = im_v2_lib_desktopApi.DesktopApi.createTopmostWindow(html);
	        }
	      } else {
	        this.content = new NotificationConferenceContent({
	          callerAvatar: this.callerAvatar,
	          callerName: this.callerName,
	          callerColor: this.callerColor,
	          onClose: this.callbacks.onClose,
	          onDestroy: this.callbacks.onDestroy,
	          onButtonClick: this.callbacks.onButtonClick
	        });
	        this.createPopup(this.content.render());
	        this.popup.show();
	        window.addEventListener('resize', function () {
	          _this.onResize();
	        });
	      }
	    }
	  }, {
	    key: "onResize",
	    value: function onResize() {
	      if (this.popup) {
	        this.popup.setMaxHeight(document.body.clientHeight);
	      }
	    }
	  }, {
	    key: "createPopup",
	    value: function createPopup(content) {
	      this.popup = new main_popup.Popup({
	        id: "bx-messenger-call-notify",
	        targetContainer: document.body,
	        content: content,
	        closeIcon: false,
	        noAllPaddings: true,
	        zIndex: this.zIndex,
	        offsetLeft: 0,
	        offsetTop: 0,
	        closeByEsc: false,
	        draggable: {
	          restrict: false
	        },
	        borderRadius: '25px',
	        disableScroll: true,
	        maxHeight: document.body.clientHeight,
	        overlay: {
	          backgroundColor: 'black',
	          opacity: 30
	        },
	        events: {
	          onPopupClose: function () {
	            var _this2 = this;
	            window.removeEventListener('resize', function () {
	              _this2.onResize();
	            });
	            this.callbacks.onClose();
	          }.bind(this),
	          onPopupDestroy: function () {
	            this.popup = null;
	          }.bind(this)
	        }
	      });
	    }
	  }, {
	    key: "close",
	    value: function close() {
	      if (this.popup) {
	        this.popup.close();
	      }
	      if (this.window) {
	        this.window.BXDesktopWindow.ExecuteCommand("hide");
	      }
	      this.callbacks.onClose();
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      if (this.popup) {
	        this.popup.destroy();
	        this.popup = null;
	      }
	      if (this.window) {
	        this.window.BXDesktopWindow.ExecuteCommand("close");
	        this.window = null;
	      }
	      if (im_v2_lib_desktopApi.DesktopApi.isDesktop()) {
	        im_v2_lib_desktopApi.DesktopApi.unsubscribe(Events$2.onButtonClick, this._onContentButtonClickHandler);
	      }
	      this.callbacks.onDestroy();
	    }
	  }, {
	    key: "_onContentButtonClick",
	    value: function _onContentButtonClick(e) {
	      this.callbacks.onButtonClick(e);
	    }
	  }]);
	  return ConferenceNotifications;
	}();
	var NotificationConferenceContent = /*#__PURE__*/function () {
	  function NotificationConferenceContent(config) {
	    babelHelpers.classCallCheck(this, NotificationConferenceContent);
	    this.callerAvatar = config.callerAvatar || '';
	    this.callerName = config.callerName || BX.message('IM_CL_USER');
	    this.callerColor = config.callerColor || '#525252';
	    this.elements = {
	      root: null,
	      avatar: null
	    };
	    this.callbacks = {
	      onClose: main_core.Type.isFunction(config.onClose) ? config.onClose : BX.DoNothing,
	      onDestroy: main_core.Type.isFunction(config.onDestroy) ? config.onDestroy : BX.DoNothing,
	      onButtonClick: main_core.Type.isFunction(config.onButtonClick) ? config.onButtonClick : BX.DoNothing
	    };
	  }
	  babelHelpers.createClass(NotificationConferenceContent, [{
	    key: "render",
	    value: function render() {
	      var _this$elements$button;
	      var avatarImageStyles;
	      var avatarImageText = '';
	      if (this.callerAvatar) {
	        avatarImageStyles = {
	          backgroundImage: "url('" + this.callerAvatar + "')",
	          backgroundColor: '#fff',
	          backgroundSize: 'cover'
	        };
	      } else {
	        avatarImageStyles = {
	          backgroundImage: 'none',
	          backgroundColor: this.callerColor,
	          backgroundSize: '80px',
	          backgroundRepeat: 'no-repeat',
	          backgroundPosition: 'center center'
	        };
	        avatarImageText = im_v2_lib_utils.Utils.text.getFirstLetters(this.callerName).toUpperCase();
	      }
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-call-window" + (im_v2_lib_desktopApi.DesktopApi.isDesktop() ? ' desktop' : '')
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-call-window-body"
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-call-window-top"
	            },
	            children: [main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-call-window-photo bx-messenger-videocall-incoming-call-avatar-pulse"
	              },
	              children: [main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-call-window-photo-left"
	                },
	                children: [this.elements.avatar = main_core.Dom.create("div", {
	                  props: {
	                    className: "bx-messenger-call-window-photo-block"
	                  },
	                  style: avatarImageStyles,
	                  text: avatarImageText
	                })]
	              }), main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-incoming-call-pulse-element",
	                  style: "animation-delay: -2s;"
	                }
	              }), main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-incoming-call-pulse-element",
	                  style: "animation-delay: -1.5s;"
	                }
	              }), main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-incoming-call-pulse-element",
	                  style: "animation-delay: -1s;"
	                }
	              }), main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-videocall-incoming-call-pulse-element",
	                  style: "animation-delay: -0.5s;"
	                }
	              })]
	            }), main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-call-window-title"
	              },
	              children: [main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-call-window-title-block"
	                },
	                children: [main_core.Dom.create("div", {
	                  props: {
	                    className: "bx-messenger-call-overlay-title-caller-prefix"
	                  },
	                  text: BX.message("IM_M_VIDEO_CALL_FROM")
	                }), main_core.Dom.create("div", {
	                  text: main_core.Text.encode(this.callerName),
	                  props: {
	                    className: "bx-messenger-call-overlay-title-caller"
	                  }
	                })]
	              })]
	            })]
	          }), main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-call-window-bottom"
	            },
	            children: [main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-call-window-buttons"
	              },
	              children: [this.elements.buttonsBlock = main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-call-window-buttons-block"
	                },
	                children: []
	              })]
	            })]
	          })]
	        })]
	      });
	      (_this$elements$button = this.elements.buttonsBlock).append.apply(_this$elements$button, [main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-call-window-button bx-messenger-call-window-button-danger"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-call-window-button-icon bx-messenger-call-window-button-icon-phone-down",
	            title: BX.message("IM_M_CALL_BTN_SKIP_CONFERENCE")
	          }
	        })],
	        events: {
	          click: this._onSkipConferenceButtonClick.bind(this)
	        }
	      }), main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-call-window-button" + (this.withBlur ? ' with-blur' : '')
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-call-window-button-icon bx-messenger-call-window-button-icon-phone-up",
	            title: BX.message("IM_M_CALL_BTN_ANSWER_CONFERENCE")
	          }
	        })],
	        events: {
	          click: this._onAnswerConferenceButtonClick.bind(this)
	        }
	      })]);
	      return this.elements.root;
	    }
	  }, {
	    key: "showInDesktop",
	    value: function showInDesktop() {
	      var width = 450;
	      var height = 575;
	      this.render();
	      document.body.appendChild(this.elements.root);
	      im_v2_lib_desktopApi.DesktopApi.setWindowPosition({
	        x: STP_CENTER,
	        y: STP_VCENTER,
	        width: width,
	        height: height
	      });
	    }
	  }, {
	    key: "_onAnswerConferenceButtonClick",
	    value: function _onAnswerConferenceButtonClick(e) {
	      if (im_v2_lib_desktopApi.DesktopApi.isDesktop()) {
	        im_v2_lib_desktopApi.DesktopApi.closeWindow();
	        im_v2_lib_desktopApi.DesktopApi.emitToMainWindow(Events$2.onButtonClick, [{
	          button: 'answerConference'
	        }]);
	      } else {
	        this.callbacks.onButtonClick({
	          button: 'answerConference'
	        });
	      }
	    }
	  }, {
	    key: "_onSkipConferenceButtonClick",
	    value: function _onSkipConferenceButtonClick(e) {
	      if (im_v2_lib_desktopApi.DesktopApi.isDesktop()) {
	        im_v2_lib_desktopApi.DesktopApi.closeWindow();
	        im_v2_lib_desktopApi.DesktopApi.emitToMainWindow(Events$2.onButtonClick, [{
	          button: 'skipConference'
	        }]);
	      } else {
	        this.callbacks.onButtonClick({
	          button: 'skipConference'
	        });
	      }
	    }
	  }]);
	  return NotificationConferenceContent;
	}();

	var Events$3 = {
	  onBackToCallClick: "FloatingScreenshare::onBackToCallClick",
	  onStopSharingClick: "FloatingScreenshare::onStopSharingClick",
	  onChangeScreenClick: "FloatingScreenshare::onChangeScreenClick"
	};
	var POPUP_WIDTH = 291;
	var POPUP_HEIGHT = 81;
	var POPUP_OFFSET_X = 80;
	var POPUP_OFFSET_Y = 80;

	/**
	 *
	 * @param {object} config
	 * @constructor
	 */
	var FloatingScreenShare = /*#__PURE__*/function () {
	  function FloatingScreenShare(config) {
	    babelHelpers.classCallCheck(this, FloatingScreenShare);
	    if (babelHelpers["typeof"](config) !== "object") {
	      config = {};
	    }
	    this.darkMode = config.darkMode || false;
	    this.window = null;
	    this.sharedWindowX = null;
	    this.sharedWindowY = null;
	    this.sharedWindowHeight = null;
	    this.sharedWindowWidth = null;
	    this.title = '';
	    this.app = '';
	    this.screens = [];
	    this.screenToUse = null;
	    this.callbacks = {
	      onBackToCallClick: main_core.Type.isFunction(config.onBackToCallClick) ? config.onBackToCallClick : BX.DoNothing,
	      onStopSharingClick: main_core.Type.isFunction(config.onStopSharingClick) ? config.onStopSharingClick : BX.DoNothing,
	      onChangeScreenClick: main_core.Type.isFunction(config.onChangeScreenClick) ? config.onChangeScreenClick : BX.DoNothing
	    };
	    this._onBackToCallClickHandler = this._onBackToCallClick.bind(this);
	    this._onStopSharingClickHandler = this._onStopSharingClick.bind(this);
	    this._onChangeScreenClickHandler = this._onChangeScreenClick.bind(this);
	    this.bindEventHandlers();
	  }
	  babelHelpers.createClass(FloatingScreenShare, [{
	    key: "bindEventHandlers",
	    value: function bindEventHandlers() {
	      im_v2_lib_desktopApi.DesktopApi.subscribe(Events$3.onBackToCallClick, this._onBackToCallClickHandler);
	      im_v2_lib_desktopApi.DesktopApi.subscribe(Events$3.onStopSharingClick, this._onStopSharingClickHandler);
	      im_v2_lib_desktopApi.DesktopApi.subscribe(Events$3.onChangeScreenClick, this._onChangeScreenClickHandler);
	    }
	  }, {
	    key: "saveExistingScreens",
	    value: function saveExistingScreens() {
	      var _this = this;
	      return new Promise(function (resolve, reject) {
	        if (_this.screens.length > 0) {
	          return resolve();
	        }
	        BXDesktopSystem.ListScreenMedia(function (result) {
	          result.forEach(function (item) {
	            if (item.id.slice(0, 6) === 'screen') {
	              _this.screens.push({
	                id: item.id,
	                x: item.x,
	                y: item.y,
	                width: item.width,
	                height: item.height
	              });
	            }
	          });
	          return resolve();
	        });
	      });
	    }
	  }, {
	    key: "_onBackToCallClick",
	    value: function _onBackToCallClick() {
	      this.callbacks.onBackToCallClick();
	    }
	  }, {
	    key: "_onStopSharingClick",
	    value: function _onStopSharingClick() {
	      this.close();
	      this.callbacks.onStopSharingClick();
	    }
	  }, {
	    key: "_onChangeScreenClick",
	    value: function _onChangeScreenClick() {
	      this.callbacks.onChangeScreenClick();
	    }
	  }, {
	    key: "setSharingData",
	    value: function setSharingData(data) {
	      var _this2 = this;
	      return this.saveExistingScreens().then(function () {
	        _this2.sharedWindowX = data.x + 10;
	        _this2.sharedWindowY = data.y + 10;
	        _this2.sharedWindowWidth = data.width;
	        _this2.sharedWindowHeight = data.height;
	        _this2.title = data.title;
	        _this2.app = data.app;
	        for (var i = 0; i < _this2.screens.length; i++) {
	          if (_this2.sharedWindowX >= _this2.screens[i].x && _this2.sharedWindowX <= _this2.screens[i].x + _this2.screens[i].width && _this2.sharedWindowY >= _this2.screens[i].y && _this2.sharedWindowY <= _this2.screens[i].y + _this2.screens[i].height) {
	            _this2.screenToUse = _this2.screens[i];
	            break;
	          }
	        }
	        if (!_this2.screenToUse && _this2.screens.length > 0) {
	          _this2.screenToUse = _this2.screens[0];
	        }
	      })["catch"](function (error) {
	        console.log('save existing screens error', error);
	      });
	    }
	  }, {
	    key: "show",
	    value: function show() {
	      if (!im_v2_lib_desktopApi.DesktopApi.isDesktop() || im_v2_lib_desktopApi.DesktopApi.getApiVersion() > 74) {
	        return;
	      }
	      if (this.window) {
	        this.window.BXDesktopWindow.ExecuteCommand("show");
	      } else {
	        var params = {
	          title: this.title,
	          app: this.app,
	          sharedWindowX: this.sharedWindowX,
	          sharedWindowY: this.sharedWindowY,
	          sharedWindowWidth: this.sharedWindowWidth,
	          sharedWindowHeight: this.sharedWindowHeight,
	          screenToUse: this.screenToUse,
	          darkMode: this.darkMode
	        };
	        var js = "window.FSSC = new BX.Call.FloatingScreenShareContent(".concat(JSON.stringify(params), ");");
	        var htmlContent = im_v2_lib_desktopApi.DesktopApi.prepareHtml('', js);
	        this.window = im_v2_lib_desktopApi.DesktopApi.createTopmostWindow(htmlContent);
	      }
	    }
	  }, {
	    key: "hide",
	    value: function hide() {
	      if (!this.window || !this.window.document) {
	        return false;
	      }
	      this.window.BXDesktopWindow.ExecuteCommand("hide");
	    }
	  }, {
	    key: "close",
	    value: function close() {
	      if (!this.window || !this.window.document) {
	        return false;
	      }
	      this.window.BXDesktopWindow.ExecuteCommand("close");
	      this.window = null;
	      this.visible = false;
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      if (this.window) {
	        im_v2_lib_desktopApi.DesktopApi.closeWindow();
	        this.window = null;
	      }
	      im_v2_lib_desktopApi.DesktopApi.unsubscribe(Events$3.onBackToCallClick, this._onBackToCallClickHandler);
	      im_v2_lib_desktopApi.DesktopApi.unsubscribe(Events$3.onStopSharingClick, this._onStopSharingClickHandler);
	      im_v2_lib_desktopApi.DesktopApi.unsubscribe(Events$3.onChangeScreenClick, this._onChangeScreenClickHandler);
	    }
	  }]);
	  return FloatingScreenShare;
	}();
	var FloatingScreenShareContent = /*#__PURE__*/function () {
	  function FloatingScreenShareContent(config) {
	    babelHelpers.classCallCheck(this, FloatingScreenShareContent);
	    this.title = config.title || '';
	    this.app = config.app || '';
	    this.sharedWindowX = config.sharedWindowX || 0;
	    this.sharedWindowY = config.sharedWindowY || 0;
	    this.sharedWindowHeight = config.sharedWindowHeight || 0;
	    this.sharedWindowWidth = config.sharedWindowWidth || 0;
	    this.screenToUse = config.screenToUse || null;
	    this.darkMode = config.darkMode || false;
	    this.elements = {
	      container: null
	    };
	    this.render();
	    this.adjustWindow(POPUP_WIDTH, POPUP_HEIGHT);
	  }
	  babelHelpers.createClass(FloatingScreenShareContent, [{
	    key: "render",
	    value: function render() {
	      var title = this.app ? this.app + ' - ' + this.title : this.title;
	      this.elements.container = main_core.Dom.create("div", {
	        props: {
	          className: 'bx-messenger-call-floating-screenshare-wrap' + (this.darkMode ? ' dark-mode' : '')
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: 'bx-messenger-call-floating-screenshare-top'
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: 'bx-messenger-call-floating-screenshare-top-icon'
	            }
	          }), main_core.Dom.create("div", {
	            props: {
	              className: 'bx-messenger-call-floating-screenshare-top-text',
	              title: title
	            },
	            text: title
	          })]
	        }), main_core.Dom.create("div", {
	          props: {
	            className: 'bx-messenger-call-floating-screenshare-bottom'
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: 'bx-messenger-call-floating-screenshare-bottom-left'
	            },
	            children: [main_core.Dom.create("div", {
	              props: {
	                className: 'bx-messenger-call-floating-screenshare-back-icon'
	              }
	            }), main_core.Dom.create("div", {
	              props: {
	                className: 'bx-messenger-call-floating-screenshare-back-text'
	              },
	              text: BX.message('IM_M_CALL_SCREENSHARE_BACK_TO_CALL')
	            })],
	            events: {
	              click: this.onBackToCallClick.bind(this)
	            }
	          }), main_core.Dom.create("div", {
	            props: {
	              className: 'bx-messenger-call-floating-screenshare-bottom-center'
	            },
	            children: [main_core.Dom.create("div", {
	              props: {
	                className: 'bx-messenger-call-floating-screenshare-change-screen-icon'
	              }
	            }), main_core.Dom.create("div", {
	              props: {
	                className: 'bx-messenger-call-floating-screenshare-change-screen-text'
	              },
	              text: BX.message('IM_M_CALL_SCREENSHARE_CHANGE_SCREEN')
	            })],
	            events: {
	              click: this.onChangeScreenClick.bind(this)
	            }
	          }), main_core.Dom.create("div", {
	            props: {
	              className: 'bx-messenger-call-floating-screenshare-bottom-right'
	            },
	            children: [main_core.Dom.create("div", {
	              props: {
	                className: 'bx-messenger-call-floating-screenshare-stop-icon'
	              }
	            }), main_core.Dom.create("div", {
	              props: {
	                className: 'bx-messenger-call-floating-screenshare-stop-text'
	              },
	              text: BX.message('IM_M_CALL_SCREENSHARE_STOP')
	            })],
	            events: {
	              click: this.onStopSharingClick.bind(this)
	            }
	          })]
	        })]
	      });
	      document.body.appendChild(this.elements.container);
	      document.body.classList.add('bx-messenger-call-floating-screenshare');
	    }
	  }, {
	    key: "onBackToCallClick",
	    value: function onBackToCallClick() {
	      this.dispatchEvent(Events$3.onBackToCallClick, []);
	    }
	  }, {
	    key: "onChangeScreenClick",
	    value: function onChangeScreenClick() {
	      this.dispatchEvent(Events$3.onChangeScreenClick, []);
	    }
	  }, {
	    key: "onStopSharingClick",
	    value: function onStopSharingClick() {
	      this.dispatchEvent(Events$3.onStopSharingClick, []);
	    }
	  }, {
	    key: "adjustWindow",
	    value: function adjustWindow(width, height) {
	      if (!this.screenToUse) {
	        return;
	      }
	      var blockOffset = 22;
	      var popupPadding = 22;
	      var leftBlockWidth = document.querySelector('.bx-messenger-call-floating-screenshare-bottom-left').scrollWidth;
	      var centerBlockWidth = document.querySelector('.bx-messenger-call-floating-screenshare-bottom-center').scrollWidth;
	      var rightBlockWidth = document.querySelector('.bx-messenger-call-floating-screenshare-bottom-right').scrollWidth;
	      var fullWidth = leftBlockWidth + centerBlockWidth + rightBlockWidth + 2 * blockOffset + 2 * popupPadding;
	      if (fullWidth > POPUP_WIDTH) {
	        width = fullWidth;
	      }
	      this.elements.container.style.width = width + "px";
	      this.elements.container.style.height = height + "px";
	      BXDesktopWindow.SetProperty("minClientSize", {
	        Width: width,
	        Height: height
	      });
	      BXDesktopWindow.SetProperty("resizable", false);
	      BXDesktopWindow.SetProperty("closable", false);
	      BXDesktopWindow.SetProperty("title", BX.message('IM_M_CALL_SCREENSHARE_TITLE'));
	      BXDesktopWindow.SetProperty("position", {
	        X: this.screenToUse.x + this.screenToUse.width - width - POPUP_OFFSET_X,
	        Y: this.screenToUse.y + POPUP_OFFSET_Y,
	        Width: width,
	        Height: height,
	        Mode: STP_FRONT
	      });
	    }
	  }, {
	    key: "dispatchEvent",
	    value: function dispatchEvent(name, params) {
	      var convertedParams = {};
	      for (var i = 0; i < params.length; i++) {
	        convertedParams[i] = params[i];
	      }
	      var mainWindow = opener ? opener : top;
	      mainWindow.BXWindows.forEach(function (windowItem) {
	        if (windowItem && windowItem.name !== '' && windowItem.BXDesktopWindow && windowItem.BXDesktopWindow.DispatchCustomEvent) {
	          windowItem.BXDesktopWindow.DispatchCustomEvent(name, convertedParams);
	        }
	      });
	      mainWindow.BXDesktopWindow.DispatchCustomEvent(name, convertedParams);
	    }
	  }]);
	  return FloatingScreenShareContent;
	}();

	var CallHint = /*#__PURE__*/function () {
	  function CallHint(options) {
	    babelHelpers.classCallCheck(this, CallHint);
	    this.popup = null;
	    this.title = BX.prop.getString(options, "title", main_core.Text.encode(BX.message("IM_CALL_MIC_MUTED_WHILE_TALKING")));
	    this.icon = BX.prop.getString(options, "icon", "mic");
	    this.bindElement = BX.prop.getElementNode(options, "bindElement", null);
	    this.targetContainer = BX.prop.getElementNode(options, "targetContainer", null);
	    this.callFolded = BX.prop.getBoolean(options, "callFolded", false);
	    this.autoCloseDelay = BX.prop.getInteger(options, "autoCloseDelay", 5000);
	    this.buttonsLayout = BX.prop.getString(options, "buttonsLayout", "right");
	    this.buttons = BX.prop.getArray(options, "buttons", []);
	    this.callbacks = {
	      onClose: BX.prop.getFunction(options, "onClose", BX.DoNothing)
	    };
	    this.autoCloseTimeout = 0;
	  }
	  babelHelpers.createClass(CallHint, [{
	    key: "show",
	    value: function show() {
	      var _this = this;
	      clearTimeout(this.autoCloseTimeout);
	      if (this.autoCloseDelay > 0) {
	        this.autoCloseTimeout = setTimeout(function () {
	          return _this.onAutoClose();
	        }, this.autoCloseDelay);
	      }
	      if (this.popup) {
	        this.popup.show();
	        return;
	      }
	      this.popup = new main_popup.Popup({
	        bindElement: this.bindElement,
	        targetContainer: this.targetContainer,
	        content: this.render(),
	        padding: 0,
	        contentPadding: 14,
	        // height: this.getPopupHeight(),
	        className: 'bx-call-view-popup-call-hint',
	        contentBackground: 'unset',
	        maxWidth: 600,
	        angle: false,
	        events: {
	          onClose: function onClose() {
	            return _this.popup.destroy();
	          },
	          onDestroy: function onDestroy() {
	            return _this.popup = null;
	          }
	        }
	      });
	      this.popup.show();
	    }
	  }, {
	    key: "render",
	    value: function render() {
	      var _this2 = this;
	      return main_core.Dom.create("div", {
	        props: {
	          className: "bx-call-view-popup-call-hint-body layout-" + this.buttonsLayout
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-call-view-popup-call-hint-icon " + this.icon
	          }
	        }), main_core.Dom.create("div", {
	          props: {
	            className: "bx-call-view-popup-call-hint-middle-block"
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-call-view-popup-call-hint-text"
	            },
	            html: this.getPopupMessage()
	          }), this.buttonsLayout == "bottom" ? this.renderButtons() : null]
	        }), this.buttonsLayout == "right" ? this.renderButtons() : null, main_core.Dom.create("div", {
	          props: {
	            className: "bx-call-view-popup-call-hint-close"
	          },
	          events: {
	            click: function click() {
	              _this2.callbacks.onClose();
	              if (_this2.popup) {
	                _this2.popup.close();
	              }
	            }
	          }
	        })]
	      });
	    }
	  }, {
	    key: "renderButtons",
	    value: function renderButtons() {
	      return main_core.Dom.create("div", {
	        props: {
	          className: "bx-call-view-popup-call-hint-buttons-container"
	        },
	        children: this.buttons.map(function (button) {
	          return button.render();
	        })
	      });
	    }
	  }, {
	    key: "getPopupMessage",
	    value: function getPopupMessage() {
	      if (!Util.isDesktop()) {
	        return this.title;
	      }
	      var hotKeyMessage = BX.message("IM_CALL_MIC_MUTED_WHILE_TALKING_HOTKEY");
	      if (this.callFolded) {
	        var hotkey = BX.browser.IsMac() ? 'Shift + &#8984; + A' : 'Ctrl + Shift + A';
	        hotKeyMessage = BX.message("IM_CALL_MIC_MUTED_WHILE_TALKING_FOLDED_CALL_HOTKEY").replace('#HOTKEY#', hotkey);
	      }
	      hotKeyMessage = '<span class="bx-call-view-popup-call-hint-text-hotkey">' + hotKeyMessage + '</span>';
	      return this.title + '<br>' + hotKeyMessage;
	    }
	    /**
	     * Returns height in pixels for the popup.
	     * The height depends on the hotkey hint (hint appears only in the desktop app).
	     *
	     * @returns {number}
	     */
	  }, {
	    key: "getPopupHeight",
	    value: function getPopupHeight() {
	      return Util.isDesktop() ? 60 : 54;
	    }
	  }, {
	    key: "close",
	    value: function close() {
	      if (this.popup) {
	        this.popup.close();
	        this.callbacks.onClose();
	      }
	    }
	  }, {
	    key: "onAutoClose",
	    value: function onAutoClose() {
	      this.close();
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      if (this.popup) {
	        this.popup.destroy();
	      }
	      clearTimeout(this.autoCloseTimeout);
	    }
	  }]);
	  return CallHint;
	}();

	var Events$4 = {
	  onActionClick: 'onActionClick',
	  onClose: 'onClose'
	};
	var PromoPopup = /*#__PURE__*/function () {
	  function PromoPopup(options) {
	    babelHelpers.classCallCheck(this, PromoPopup);
	    options = main_core.Type.isPlainObject(options) ? options : {};
	    this.promoCode = main_core.Type.isStringFilled(options.promoCode) ? options.promoCode : '';
	    this.bindElement = options.bindElement;
	    this.elements = {
	      root: null
	    };
	    this.popup = null;
	    this.dontShowAgain = false;
	    this.eventEmitter = new main_core_events.EventEmitter(this, "BX.Call.PromoPopup");
	    if (options.events) {
	      this.subscribeToEvents(options.events);
	    }
	  }
	  babelHelpers.createClass(PromoPopup, [{
	    key: "subscribeToEvents",
	    value: function subscribeToEvents(events) {
	      for (var eventName in events) {
	        if (events.hasOwnProperty(eventName)) {
	          this.eventEmitter.subscribe(eventName, events[eventName]);
	        }
	      }
	    }
	  }, {
	    key: "render",
	    value: function render() {
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-call-promo-container"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-call-promo-content"
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-call-promo-icon-section"
	            },
	            children: [main_core.Dom.create("div", {
	              props: {
	                className: "bx-call-promo-icon"
	              }
	            })]
	          }), main_core.Dom.create("div", {
	            props: {
	              className: "bx-call-promo-text-section"
	            },
	            children: [main_core.Dom.create("div", {
	              props: {
	                className: "bx-call-promo-title"
	              },
	              text: BX.message("IM_CALL_DOCUMENT_PROMO_TITLE")
	            }), main_core.Dom.create("div", {
	              props: {
	                className: "bx-call-promo-text"
	              },
	              html: BX.message("IM_CALL_DOCUMENT_PROMO_TEXT")
	            }), main_core.Dom.create("div", {
	              props: {
	                className: "bx-call-promo-refuse"
	              },
	              children: [main_core.Dom.create("input", {
	                attrs: {
	                  type: "checkbox"
	                },
	                props: {
	                  className: "bx-call-promo-refuse-checkbox",
	                  id: "bx-call-promo-refuse-checkbox"
	                },
	                events: {
	                  change: this.onCheckboxChange.bind(this)
	                }
	              }), main_core.Dom.create("label", {
	                attrs: {
	                  "for": "bx-call-promo-refuse-checkbox"
	                },
	                props: {
	                  className: "bx-call-promo-refuse-text"
	                },
	                text: BX.message("IM_CALL_DOCUMENT_PROMO_DONT_SHOW_AGAIN")
	              })]
	            })]
	          }), main_core.Dom.create("div", {
	            props: {
	              className: "bx-call-promo-button-section"
	            },
	            children: [main_core.Dom.create("button", {
	              props: {
	                className: "bx-call-promo-button bx-call-promo-button-action ui-btn ui-btn-round"
	              },
	              text: BX.message("IM_CALL_DOCUMENT_PROMO_ACTION"),
	              events: {
	                click: this.onActionClick.bind(this)
	              }
	            }), main_core.Dom.create("button", {
	              props: {
	                className: "bx-call-promo-button bx-call-promo-button-action-close ui-btn ui-btn-round"
	              },
	              text: BX.message("IM_CALL_DOCUMENT_PROMO_ACTION_CLOSE"),
	              events: {
	                click: this.close.bind(this)
	              }
	            })]
	          })]
	        })]
	      });
	    }
	  }, {
	    key: "show",
	    value: function show() {
	      if (!this.elements.root) {
	        this.render();
	      }
	      this.createPopup();
	      this.popup.show();
	    }
	  }, {
	    key: "close",
	    value: function close() {
	      if (!this.popup) {
	        return false;
	      }
	      this.popup.close();
	    }
	  }, {
	    key: "createPopup",
	    value: function createPopup() {
	      this.popup = new main_popup.Popup({
	        id: 'bx-call-promo-popup',
	        bindElement: this.bindElement,
	        targetContainer: document.body,
	        content: this.elements.root,
	        cacheable: false,
	        closeIcon: true,
	        bindOptions: {
	          position: "top"
	        },
	        angle: {
	          position: "bottom",
	          offset: 49
	        },
	        className: 'bx-call-promo-popup',
	        contentBackground: 'unset',
	        events: {
	          onPopupClose: this.onPopupClose.bind(this)
	        }
	      });
	    }
	  }, {
	    key: "onPopupClose",
	    value: function onPopupClose() {
	      this.popup.destroy();
	      this.destroy();
	    }
	  }, {
	    key: "onCheckboxChange",
	    value: function onCheckboxChange(event) {
	      this.dontShowAgain = event.currentTarget.checked;
	    }
	  }, {
	    key: "onActionClick",
	    value: function onActionClick() {
	      this.eventEmitter.emit(Events$4.onActionClick);
	    }
	  }, {
	    key: "destroy",
	    value: function destroy() {
	      this.eventEmitter.emit(Events$4.onClose, {
	        dontShowAgain: this.dontShowAgain
	      });
	      this.eventEmitter.unsubscribeAll(Events$4.onClose);
	      this.eventEmitter = null;
	      this.elements = null;
	    }
	  }]);
	  return PromoPopup;
	}();
	PromoPopup.Events = Events$4;
	var PromoPopup3D = /*#__PURE__*/function () {
	  function PromoPopup3D(options) {
	    babelHelpers.classCallCheck(this, PromoPopup3D);
	    options = main_core.Type.isPlainObject(options) ? options : {};
	    this.callView = options.callView;
	    this.bindElement = options.bindElement;
	    this.popup = null;
	    options.events = main_core.Type.isPlainObject(options.events) ? options.events : {};
	    this.events = {
	      onActionClick: options.events.onActionClick ? options.events.onActionClick : function () {},
	      onClose: options.events.onClose ? options.events.onClose : function () {}
	    };
	  }
	  babelHelpers.createClass(PromoPopup3D, [{
	    key: "show",
	    value: function show() {
	      this.createPopup();
	      this.popup.show();
	      BX.bind(BX('promo-popup-3d-button'), "click", this.openWindow.bind(this));
	    }
	  }, {
	    key: "openWindow",
	    value: function openWindow() {
	      var _this = this;
	      BackgroundDialog.open({
	        tab: 'mask'
	      });
	      setTimeout(function () {
	        return _this.close();
	      }, 100);
	    }
	  }, {
	    key: "openLearningPopup",
	    value: function openLearningPopup() {
	      var _this2 = this;
	      var bindElement = BX('bx-messenger-videocall-panel-item-with-arrow-camera');
	      if (!bindElement) {
	        return true;
	      }
	      var title = BX.message('IM_PROMO_3DAVATAR_30112022_LEARNING_TITLE');
	      var description = BX.message('IM_PROMO_3DAVATAR_30112022_LEARNING_TEXT');
	      var content = "\n\t\t\t<div class=\"promo-popup-3d-learning-content\">\n\t\t\t\t<h4 class=\"ui-typography-heading-h4 promo-popup-3d-learning-content__title\">".concat(title, "</h4>\n\t\t\t\t<p class=\"promo-popup-3d-learning-content__description\">").concat(description, "</p>\n\t\t\t</div>\n\t\t");
	      this.popup = new main_popup.Popup({
	        id: 'bx-call-promo-learning-popup',
	        bindElement: bindElement,
	        targetContainer: document.body,
	        content: content,
	        cacheable: false,
	        closeIcon: true,
	        autoHide: true,
	        closeByEsc: true,
	        bindOptions: {
	          position: "top",
	          forceTop: -100,
	          forceLeft: 100,
	          forceBindPosition: true
	        },
	        angle: {
	          position: "top",
	          offset: 49
	        },
	        className: 'bx-call-promo-popup-learn',
	        contentBackground: 'unset',
	        events: {
	          onPopupClose: function onPopupClose() {
	            _this2.events.onClose();
	          }
	        }
	      });
	      this.popup.show();
	      this.callView.subscribe(View.Event.onDeviceSelectorShow, function () {
	        return _this2.popup ? _this2.popup.close() : '';
	      });
	    }
	  }, {
	    key: "close",
	    value: function close() {
	      if (!this.popup) {
	        return false;
	      }
	      this.popup.close();
	    }
	  }, {
	    key: "createPopup",
	    value: function createPopup() {
	      var title = BX.message('IM_PROMO_3DAVATAR_30112022_TITLE');
	      var description = BX.message('IM_PROMO_3DAVATAR_30112022_TEXT');
	      var btnText = BX.message('IM_PROMO_3DAVATAR_30112022_BUTTON');
	      var content = "\n\t\t\t<div class=\"promo-popup-3d-content\">\n\t\t\t\t<div class=\"promo-popup-3d-content__masks-container\">\n\t\t\t\t\t<div class=\"promo-popup-3d-content__mask --left-2 --bear\"></div>\n\t\t\t\t\t<div class=\"promo-popup-3d-content__mask --left-1 --pole-bear\"></div>\n\t\t\t\t\t<div class=\"promo-popup-3d-content__mask --center --fox\"></div>\n\t\t\t\t\t<div class=\"promo-popup-3d-content__mask --right-1 --santa\"></div>\n\t\t\t\t\t<div class=\"promo-popup-3d-content__mask --right-2 --owl\"></div>\n\t\t\t\t</div>\n\t\t\t\t<h3 class=\"ui-typography-heading-h2 promo-popup-3d-content__title\">".concat(title, "</h3>\n\t\t\t\t<p class=\"promo-popup-3d-content__description\">").concat(description, "</p>\n\t\t\t\t<div class=\"promo-popup-3d-content__actions-btn\">\n\t\t\t\t\t<span class=\"ui-btn btn-primary ui-btn-lg ui-btn-round ui-btn-primary\" id=\"promo-popup-3d-button\">").concat(btnText, "</span>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t");
	      this.popup = new main_popup.Popup({
	        id: 'bx-call-promo-popup-3d',
	        bindElement: this.bindElement,
	        targetContainer: document.body,
	        content: content,
	        cacheable: false,
	        closeIcon: true,
	        overlay: {
	          backgroundColor: '#000',
	          opacity: 40
	        },
	        width: 531,
	        minHeight: 481,
	        bindOptions: {
	          position: "top"
	        },
	        className: 'bx-call-promo-popup-3d-masks',
	        events: {
	          onPopupClose: this.onPopupClose.bind(this)
	        }
	      });
	    }
	  }, {
	    key: "onPopupClose",
	    value: function onPopupClose() {
	      this.popup.destroy();
	      this.openLearningPopup();
	    }
	  }]);
	  return PromoPopup3D;
	}();
	PromoPopup3D.Events = Events$4;

	var Events$5 = {
	  onClose: 'onClose',
	  onDestroy: 'onDestroy',
	  onCloseClicked: 'onCloseClicked'
	};
	var Sidebar = /*#__PURE__*/function (_EventEmitter) {
	  babelHelpers.inherits(Sidebar, _EventEmitter);
	  function Sidebar(options) {
	    var _this;
	    babelHelpers.classCallCheck(this, Sidebar);
	    _this = babelHelpers.possibleConstructorReturn(this, babelHelpers.getPrototypeOf(Sidebar).call(this));
	    _this.setEventNamespace("BX.Call.SideBar");
	    _this.container = options.container;
	    _this.width = BX.prop.getInteger(options, 'width', 200);
	    _this.elements = {
	      root: null,
	      close: null,
	      contentContainer: null
	    };
	    if (options.events) {
	      for (var eventName in options.events) {
	        if (options.events.hasOwnProperty(eventName)) {
	          _this.subscribe(eventName, options.events[eventName]);
	        }
	      }
	    }
	    return _this;
	  }
	  babelHelpers.createClass(Sidebar, [{
	    key: "render",
	    value: function render() {
	      var _this2 = this;
	      if (this.elements.root) {
	        return this.elements.root;
	      }
	      this.elements.root = main_core.Dom.create("div", {
	        props: {
	          className: "bx-messenger-call-sidebar-root"
	        },
	        children: [main_core.Dom.create("div", {
	          props: {
	            className: "bx-messenger-call-sidebar-labels"
	          },
	          style: {
	            top: '39px' /*'17px'*/
	          },
	          children: [main_core.Dom.create("div", {
	            props: {
	              className: "bx-messenger-call-sidebar-label"
	            },
	            style: {
	              maxWidth: '40px'
	            },
	            children: [main_core.Dom.create("div", {
	              props: {
	                className: "bx-messenger-call-sidebar-label-icon-box"
	              },
	              attrs: {
	                title: BX.message("IM_M_CALL_BTN_CLOSE")
	              },
	              children: [main_core.Dom.create("div", {
	                props: {
	                  className: "bx-messenger-call-sidebar-label-icon bx-messenger-call-sidebar-label-icon-close"
	                }
	              })]
	            })],
	            events: {
	              click: function click() {
	                return _this2.emit(Events$5.onCloseClicked);
	              }
	            }
	          })]
	        }), this.elements.contentContainer = main_core.Dom.create("div", {
	          props: {
	            c