
CREATE TABLE IF NOT EXISTS b_call_track (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CALL_ID int NOT NULL,
  EXTERNAL_TRACK_ID int,
  FILE_ID int,
  DISK_FILE_ID int,
  DATE_CREATE timestamp NOT NULL DEFAULT current_timestamp,
  TYPE varchar(50),
  DURATION int,
  DOWNLOAD_URL text,
  FILE_NAME varchar(100),
  FILE_SIZE int8,
  FILE_MIME_TYPE varchar(50) DEFAULT null,
  DOWNLOADED char(1) NOT NULL DEFAULT 'N',
  TEMP_PATH varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_call_track_call_id_type ON b_call_track (call_id, type);
CREATE INDEX ix_b_call_track_date_create ON b_call_track (date_create);

CREATE TABLE IF NOT EXISTS b_call_ai_task (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CALL_ID int NOT NULL,
  TRACK_ID int,
  OUTCOME_ID int,
  TYPE varchar(50),
  DATE_CREATE timestamp NOT NULL DEFAULT current_timestamp,
  DATE_FINISHED timestamp,
  STATUS varchar(32) NOT NULL,
  HASH varchar(50),
  LANGUAGE_ID char(2),
  ERROR_CODE varchar(100),
  ERROR_MESSAGE text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_call_ai_task_hash ON b_call_ai_task (hash);
CREATE INDEX ix_b_call_ai_task_call_id ON b_call_ai_task (call_id);
CREATE INDEX ix_b_call_ai_task_track_id ON b_call_ai_task (track_id);
CREATE INDEX ix_b_call_ai_task_outcome_id ON b_call_ai_task (outcome_id);
CREATE INDEX ix_b_call_ai_task_date_create ON b_call_ai_task (date_create);

CREATE TABLE IF NOT EXISTS b_call_outcome (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CALL_ID int NOT NULL,
  TRACK_ID int,
  TYPE varchar(50),
  DATE_CREATE timestamp NOT NULL DEFAULT current_timestamp,
  LANGUAGE_ID char(5),
  CONTENT text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_call_outcome_call_id_type ON b_call_outcome (call_id, type);
CREATE INDEX ix_b_call_outcome_track_id ON b_call_outcome (track_id);
CREATE INDEX ix_b_call_outcome_date_create ON b_call_outcome (date_create);

CREATE TABLE IF NOT EXISTS b_call_outcome_property (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  OUTCOME_ID int NOT NULL,
  CODE varchar(100) NOT NULL,
  CONTENT text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_call_outcome_property_outcome_id ON b_call_outcome_property (outcome_id);
CREATE INDEX ix_b_call_outcome_property_outcome_id_code ON b_call_outcome_property (outcome_id, code);
