/**
 * @module calendar/sync-page/title
 */
jn.define('calendar/sync-page/title', (require, exports, module) => {
	const AppTheme = require('apptheme');
	const { Loc } = require('loc');

	const items = [
		Loc.getMessage('M_CALENDAR_SYNC_PAGE_TITLE_1'),
		Loc.getMessage('M_CALENDAR_SYNC_PAGE_TITLE_2'),
	];

	const Title = () => View(
		{
			style: {
				justifyContent: 'center',
				alignItems: 'center',
				flexDirection: 'column',
				paddingBottom: 10,
				marginTop: 32,
				paddingTop: 10,
			},
			testId: `sync_page_title`,
		},
		View(
			{
				style: {
					justifyContent: 'center',
					paddingLeft: 24,
					paddingRight: 24,
				},
			},
			Image(
				{
					svg: {
						content: icons.calendarSync,
					},
					style: {
						width: 148,
						height: 116,
					},
				},
			),
		),
		View(
			{
				style: {
					marginTop: 20,
					paddingLeft: 40,
					paddingRight: 40,
				},
			},
			...items.map((text, index) => titleItem(text, index)),
		),
	);

	const titleItem = (text, index) => View(
		{
			style: {
				flexDirection: 'row',
				marginTop: index === 0 ? 0 : 16,
			},
		},
		Image(
			{
				style: {
					width: 20,
					height: 20,
				},
				svg: {
					content: icons.check,
				},
			},
		),
		Text(
			{
				style: {
					paddingRight: 20,
					marginLeft: 10,
					fontSize: 15,
					fontWeight: '400',
					color: AppTheme.colors.base0,
				},
				ellipsize: 'end',
				text,
			},
		),
	);

	const icons = {
		calendarSync: '<svg width="148" height="116" viewBox="0 0 148 116" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M106.136 -0.619235C107.032 -0.619235 107.759 -1.3456 107.759 -2.24162C107.759 -3.13765 107.032 -3.86401 106.136 -3.86401C105.24 -3.86401 104.514 -3.13765 104.514 -2.24162C104.514 -1.3456 105.24 -0.619235 106.136 -0.619235ZM26.0794 13.3956C28.0218 13.3956 29.5965 11.821 29.5965 9.87852C29.5965 7.93609 28.0218 6.36143 26.0794 6.36143C24.1369 6.36143 22.5623 7.93609 22.5623 9.87852C22.5623 11.821 24.1369 13.3956 26.0794 13.3956ZM26.0794 11.4346C26.9388 11.4346 27.6355 10.7379 27.6355 9.87852C27.6355 9.01911 26.9388 8.32241 26.0794 8.32241C25.2199 8.32241 24.5233 9.01911 24.5233 9.87852C24.5233 10.7379 25.2199 11.4346 26.0794 11.4346ZM8.21153 47.7309C10.8277 47.7309 12.9486 45.61 12.9486 42.9938C12.9486 40.3776 10.8277 38.2568 8.21153 38.2568C5.59533 38.2568 3.47448 40.3776 3.47448 42.9938C3.47448 45.61 5.59533 47.7309 8.21153 47.7309ZM8.21153 45.2586C9.46234 45.2586 10.4763 44.2446 10.4763 42.9938C10.4763 41.743 9.46234 40.729 8.21153 40.729C6.96073 40.729 5.94675 41.743 5.94675 42.9938C5.94675 44.2446 6.96073 45.2586 8.21153 45.2586ZM128.48 107.337C130.343 107.337 131.853 105.827 131.853 103.965C131.853 102.102 130.343 100.592 128.48 100.592C126.618 100.592 125.108 102.102 125.108 103.965C125.108 105.827 126.618 107.337 128.48 107.337ZM128.48 105.582C129.373 105.582 130.098 104.858 130.098 103.965C130.098 103.071 129.373 102.347 128.48 102.347C127.587 102.347 126.863 103.071 126.863 103.965C126.863 104.858 127.587 105.582 128.48 105.582ZM74.5 116C106.533 116 132.5 90.0324 132.5 57.9999C132.5 25.9674 106.533 -0.000102282 74.5 -0.000102282C42.4675 -0.000102282 16.5 25.9674 16.5 57.9999C16.5 90.0324 42.4675 116 74.5 116ZM16.4722 111.946H5.1969C5.10042 111.946 5.00477 111.942 4.91008 111.935C2.36183 111.875 0.314094 109.734 0.313965 107.101C0.314706 105.818 0.811467 104.587 1.69497 103.68C2.14784 103.215 2.68331 102.855 3.26589 102.614C3.25614 102.484 3.25118 102.352 3.25118 102.219C3.25198 100.865 3.77616 99.5662 4.70839 98.6094C5.64062 97.6525 6.90456 97.1154 8.22213 97.1162C9.90991 97.1183 11.4 97.9857 12.2956 99.3096C12.7208 99.1547 13.1786 99.0705 13.6555 99.0708C15.7624 99.0734 17.4928 100.724 17.6934 102.835C19.7121 103.287 21.2227 105.135 21.2209 107.345C21.2189 109.891 19.209 111.954 16.7311 111.953C16.6442 111.953 16.5579 111.951 16.4722 111.946ZM135.965 22.2505H143.967C144.028 22.2539 144.089 22.2557 144.151 22.2557C145.909 22.2564 147.336 20.8499 147.337 19.1136C147.338 17.6069 146.266 16.3468 144.834 16.0384C144.691 14.5992 143.463 13.4739 141.968 13.4721C141.63 13.472 141.305 13.5293 141.003 13.6349C140.368 12.7323 139.31 12.1409 138.112 12.1394C137.177 12.1389 136.28 12.5051 135.619 13.1575C134.957 13.8099 134.585 14.6951 134.584 15.6183C134.584 15.7091 134.588 15.7991 134.595 15.8881C134.181 16.0523 133.801 16.2979 133.48 16.6149C132.853 17.2332 132.501 18.0722 132.5 18.9471C132.5 20.7423 133.953 22.2024 135.762 22.2431C135.829 22.248 135.897 22.2505 135.965 22.2505Z" fill="#E5F9FF"/><g filter="url(#filter0_d_2840_366816)"><path d="M38.5524 35.5518C38.5524 30.3048 42.799 26.0513 48.0375 26.0513H101.561C106.799 26.0513 111.046 30.3048 111.046 35.5518V43.0165C111.046 48.2635 106.799 52.5171 101.561 52.5171H48.0375C42.799 52.5171 38.5524 48.2635 38.5524 43.0165V35.5518Z" fill="#9EE8FF"/></g><g filter="url(#filter1_d_2840_366816)"><path d="M38.5524 52.5843C38.5524 47.3373 42.799 43.0837 48.0375 43.0837H101.561C106.799 43.0837 111.046 47.3373 111.046 52.5843V84.479C111.046 89.726 106.799 93.9795 101.561 93.9795H48.0375C42.799 93.9795 38.5524 89.726 38.5524 84.479V52.5843Z" fill="#D5D7DB"/></g><path d="M38.5524 50.9883C38.5524 45.7413 42.799 41.4878 48.0375 41.4878H101.561C106.799 41.4878 111.046 45.7413 111.046 50.9883V82.883C111.046 88.13 106.799 92.3836 101.561 92.3836H48.0375C42.799 92.3836 38.5524 88.13 38.5524 82.883V50.9883Z" fill="#E6E7E9"/><path d="M38.5522 49.3926C38.5522 44.1456 42.7989 39.8921 48.0374 39.8921H101.561C106.799 39.8921 111.046 44.1456 111.046 49.3926V81.2873C111.046 86.5343 106.799 90.7878 101.561 90.7878H48.0374C42.7989 90.7878 38.5522 86.5343 38.5522 81.2873V49.3926Z" fill="white"/><rect opacity="0.2" x="52.0952" y="21.3013" width="5.57643" height="14.3627" rx="2.78822" fill="#11A9D9"/><rect x="52.0952" y="19.7051" width="5.57643" height="14.3627" rx="2.78822" fill="#2FC6F6"/><rect opacity="0.2" x="92.7239" y="21.3013" width="5.57643" height="14.3627" rx="2.78822" fill="#11A9D9"/><rect x="92.7239" y="19.7051" width="5.57643" height="14.3627" rx="2.78822" fill="#2FC6F6"/><path fill-rule="evenodd" clip-rule="evenodd" d="M88.6308 63.7493C88.6295 63.7842 88.6283 63.8191 88.6283 63.854C92.0847 64.8944 94.4339 68.0992 94.3864 71.7093C94.4763 76.0926 91.0134 79.7273 86.6319 79.8483H65.4293V79.839C65.4008 79.84 65.3723 79.841 65.3439 79.842C65.2588 79.8452 65.1739 79.8483 65.0882 79.8483C59.4272 79.8483 54.8388 75.0609 54.8388 69.1562C54.7892 64.7101 57.4995 60.6986 61.6423 59.0864C61.6386 59.0339 61.6386 58.982 61.6386 58.9295C61.6386 54.1019 65.3867 50.186 70.0146 50.186C73.4716 50.225 76.5506 52.3814 77.7696 55.6174C78.6367 55.2984 79.5533 55.1352 80.4772 55.1353C84.981 55.1353 88.6333 58.9474 88.6333 63.6445C88.6333 63.6794 88.632 63.7143 88.6308 63.7493ZM79.3122 62.2744C77.9598 60.8495 76.0479 59.961 73.9285 59.961C70.0744 59.961 66.9064 62.8992 66.5411 66.6583L69.0594 66.9282C69.2898 64.441 71.3819 62.4938 73.9286 62.4938C75.3487 62.4938 76.6275 63.0993 77.5209 64.0662L75.7793 65.8083C75.7163 65.8713 75.7609 65.979 75.85 65.979H81.3682C81.4234 65.979 81.4682 65.9342 81.4682 65.879V60.3594C81.4682 60.2703 81.3605 60.2257 81.2975 60.2887L79.3122 62.2744ZM68.654 72.609C69.9993 73.9683 71.8659 74.8104 73.9292 74.8104C77.7306 74.8104 80.8645 71.9519 81.3 68.2666L78.7423 68.251C78.334 70.54 76.334 72.2776 73.9282 72.2776C72.5644 72.2776 71.331 71.7192 70.4441 70.8185L72.2558 69.0064C72.3188 68.9434 72.2742 68.8357 72.1851 68.8357H66.6669C66.6117 68.8357 66.5669 68.8804 66.5669 68.9357L66.5669 74.4553C66.5669 74.5444 66.6746 74.589 66.7376 74.526L68.654 72.609Z" fill="#2FC6F6"/><defs><filter id="filter0_d_2840_366816" x="35.5524" y="23.5513" width="78.4937" height="32.4658" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.5"/><feGaussianBlur stdDeviation="1.5"/><feComposite in2="hardAlpha" operator="out"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.470588 0 0 0 0 0.619608 0 0 0 0.14 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2840_366816"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_2840_366816" result="shape"/></filter><filter id="filter1_d_2840_366816" x="35.5524" y="40.5837" width="78.4937" height="56.8958" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.5"/><feGaussianBlur stdDeviation="1.5"/><feComposite in2="hardAlpha" operator="out"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.14 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2840_366816"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_2840_366816" result="shape"/></filter></defs></svg>',
		check: '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20 10C20 15.5228 15.5228 20 10 20C4.47715 20 0 15.5228 0 10C0 4.47715 4.47715 0 10 0C15.5228 0 20 4.47715 20 10Z" fill="#E1F3F9"/><path fill-rule="evenodd" clip-rule="evenodd" d="M8.54786 11.0331L6.46936 8.9336L5 10.4178L8.4679 13.9207L8.46933 13.9192L8.5493 14L15 7.48419L13.5306 6L8.54786 11.0331Z" fill="#2FC6F6"/></svg>',
	};

	module.exports = { Title };
});
