/**
 * @module calendar/sync-page/provider/factory
 */
jn.define('calendar/sync-page/provider/factory', (require, exports, module) => {
	const AppTheme = require('apptheme');
	const { Loc } = require('loc');
	const { SyncProvider } = require('calendar/sync-page/provider/sync-provider');

	/**
	 * @class SyncProviderFactory
	 */
	class SyncProviderFactory
	{
		/**
		 * @param {SyncProviderInfo} providerInfo
		 * @param props
		 * @returns {SyncProvider|null}
		 */
		static createByProviderInfo(providerInfo, props = {})
		{
			const type = providerInfo.type;
			if (!providerTypes[type])
			{
				return null;
			}

			const customEventEmitter = props.customEventEmitter;

			const newProps = {
				type,
				customEventEmitter,
				title: SyncProviderFactory.getTitle(type),
				icon: SyncProviderFactory.getIcon(type),
				id: providerInfo.id || null,
				connected: providerInfo.connected || false,
				syncOffset: providerInfo.syncOffset,
				status: providerInfo.status,
			};

			return new SyncProvider(newProps);
		}

		static getIcon(providerType)
		{
			return providerIcons[providerType];
		}

		static getTitle(providerType)
		{
			const phraseCode = `M_CALENDAR_SYNC_PROVIDER_TITLE_${providerType.toUpperCase()}`;

			return Loc.getMessage(phraseCode);
		}
	}

	const providerTypes = {
		google: 'google',
		office365: 'office365',
		icloud: 'icloud',
	};

	const providerIcons = {
		google: {
			svg: '<svg width="38" height="38" viewBox="0 0 38 38" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M28.638 9.36475H9.36816V28.6346H28.638V9.36475Z" fill="white"/><path d="M28.6348 37.3067L37.3062 28.6353H28.6348V37.3067Z" fill="#EA4335"/><path d="M37.3062 9.36475H28.6348V28.6346H37.3062V9.36475Z" fill="#FBBC04"/><path d="M28.638 28.6353H9.36816V37.3067H28.638V28.6353Z" fill="#34A853"/><path d="M0.695312 28.6353V34.4162C0.695312 36.0132 1.9888 37.3067 3.58579 37.3067H9.36674V28.6353H0.695312Z" fill="#188038"/><path d="M37.3062 9.36503V3.58408C37.3062 1.98709 36.0127 0.693604 34.4157 0.693604H28.6348V9.36503H37.3062Z" fill="#1967D2"/><path d="M28.6346 0.693604H3.58383C1.98685 0.693604 0.693359 1.98709 0.693359 3.58408V28.6349H9.36479V9.36503H28.6346V0.693604Z" fill="#4285F4"/><path d="M13.3211 24.3139C12.6009 23.8274 12.1023 23.1168 11.8301 22.1774L13.5017 21.4885C13.6535 22.0666 13.9184 22.5146 14.2966 22.8326C14.6724 23.1505 15.13 23.3071 15.6648 23.3071C16.2116 23.3071 16.6813 23.1409 17.0739 22.8085C17.4665 22.4761 17.664 22.0521 17.664 21.5391C17.664 21.014 17.4569 20.5852 17.0426 20.2528C16.6283 19.9204 16.108 19.7542 15.4865 19.7542H14.5206V18.0994H15.3878C15.9225 18.0994 16.3729 17.9549 16.7391 17.6658C17.1052 17.3768 17.2883 16.9818 17.2883 16.4783C17.2883 16.0303 17.1245 15.6738 16.7969 15.4065C16.4693 15.1391 16.055 15.0042 15.5516 15.0042C15.0602 15.0042 14.67 15.1343 14.3809 15.3968C14.0921 15.6601 13.8749 15.9924 13.7498 16.3627L12.095 15.6738C12.3142 15.0524 12.7165 14.5032 13.3066 14.0287C13.8968 13.5541 14.6507 13.3157 15.566 13.3157C16.2429 13.3157 16.8523 13.4457 17.3918 13.7083C17.9314 13.9708 18.3553 14.3346 18.6612 14.797C18.9671 15.2619 19.1189 15.7822 19.1189 16.3603C19.1189 16.9504 18.9768 17.4491 18.6925 17.8585C18.4083 18.268 18.059 18.5812 17.6447 18.8003V18.8991C18.1797 19.1197 18.6444 19.4819 18.9888 19.9469C19.3381 20.4166 19.5139 20.9778 19.5139 21.633C19.5139 22.2882 19.3477 22.8735 19.0153 23.3866C18.6829 23.8996 18.2228 24.3043 17.6399 24.5982C17.0546 24.892 16.397 25.0414 15.6672 25.0414C14.8217 25.0438 14.0413 24.8005 13.3211 24.3139ZM23.5895 16.0183L21.754 17.3455L20.8363 15.9532L24.129 13.5782H25.3912V24.7812H23.5895V16.0183Z" fill="#4285F4"/></svg>',
			width: 38,
			height: 38,
			tintColor: null,
		},
		office365: {
			svg: '<svg width="32" height="38" viewBox="0 0 32 38" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M20.4931 5.86186C16.1369 6.91662 11.8013 7.96642 7.44735 9.02068V9.3147C7.44739 15.2491 7.44669 21.1835 7.45113 27.118C7.45125 27.28 7.41026 27.3627 7.25601 27.4232C5.56365 28.0864 3.87401 28.7566 2.18378 29.4253C1.72256 29.6078 1.2618 29.7915 0.800781 29.9747C0.802301 29.9874 0.803821 30.0001 0.805341 30.0128C7.3629 30.9274 13.9205 31.842 20.4931 32.7587V5.86186ZM31.5379 18.9028C31.5378 24.0154 31.5368 29.1281 31.5417 34.2407C31.5419 34.4365 31.4968 34.5191 31.2959 34.5753C27.7786 35.5595 24.2647 36.5559 20.7482 37.5429C20.6351 37.5746 20.4917 37.5654 20.381 37.5238C14.3867 35.2725 8.39448 33.0157 2.40203 30.7594C1.93134 30.5821 1.4624 30.3999 0.989254 30.2297C0.851117 30.18 0.809701 30.1057 0.809741 29.9578C0.811457 22.5768 0.809578 15.1958 0.803084 7.81483C0.80292 7.65427 0.855733 7.58895 0.997219 7.53488C7.44937 5.0696 13.8999 2.59965 20.3531 0.137242C20.48 0.0888685 20.6477 0.0867038 20.779 0.124961C24.2923 1.14916 27.8028 2.18286 31.3157 3.20844C31.4928 3.2601 31.5425 3.3382 31.5423 3.52332C31.5368 8.64979 31.5379 13.7763 31.5379 18.9028Z" fill="#FF0000"/></svg>',
			width: 32,
			height: 38,
			tintColor: null,
		},
		icloud: {
			svg: '<svg width="29" height="34" viewBox="0 0 29 34" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M21.2316 0.164108C21.2926 0.957966 21.4574 3.1015 19.4439 5.4537C17.9854 7.13113 16.2143 8.11268 14.272 7.96618C14.1083 5.94447 14.8748 4.14985 16.1771 2.69949C17.3603 1.34437 19.4365 0.245617 21.2299 0.143066L21.2316 0.164108ZM27.211 11.2902C24.7439 12.7962 23.5251 14.8411 23.5397 17.5504C23.5397 17.5543 23.5395 17.5613 23.5393 17.5714C23.5294 17.9291 23.414 22.1305 28.0701 24.3347C27.1743 27.0514 24.1051 33.0901 20.5366 33.1418C19.5369 33.1418 18.7371 32.8315 17.9126 32.5117C17.0355 32.1714 16.1304 31.8204 14.9269 31.8204C13.624 31.8204 12.6435 32.1941 11.7249 32.5442C10.9455 32.8413 10.2106 33.1214 9.3612 33.1418C5.82208 33.2525 2.4298 26.6085 1.48995 23.8992C0.785061 21.8395 0.432617 19.8389 0.432617 17.9048C0.432617 11.3567 4.78677 8.13801 8.88394 8.07157C10.0198 8.07157 11.334 8.54898 12.4565 8.95673C13.2932 9.26066 14.0233 9.52588 14.4937 9.52588C14.874 9.52588 15.4946 9.29507 16.2561 9.01186C17.5824 8.51862 19.336 7.86644 20.9919 7.99775C23.7453 8.21184 25.8306 9.30441 27.211 11.2902Z" fill="#151515"/></svg>',
			width: 29,
			height: 34,
			tintColor: AppTheme.colors.base0,
		},
	};

	module.exports = { SyncProviderFactory };
});
