/**
 * @module calendar/event-list-view/sharing-button
 */
jn.define('calendar/event-list-view/sharing-button', (require, exports, module) => {
	const { Color } = require('tokens');
	const { getFeatureRestriction } = require('tariff-plan-restriction');
	const { BottomSheet } = require('bottom-sheet');

	const { DialogSharing } = require('calendar/layout/dialog/dialog-sharing');
	const { FeatureId } = require('calendar/enums');

	class SharingButton
	{
		constructor(props)
		{
			this.props = props;
		}

		/**
		 *
		 * @returns {Sharing}
		 */
		get sharing()
		{
			return this.props.sharing;
		}

		getButton()
		{
			const { isRestricted } = getFeatureRestriction(FeatureId.CALENDAR_SHARING);
			const isEnabled = this.sharing.isOn() && !isRestricted();

			return {
				type: 'options',
				badgeCode: isEnabled ? 'sharing_enabled' : 'sharing_disabled',
				callback: this.openSharingDialog,
				svg: {
					content: isEnabled ? sharingMenuIconEnabled : sharingMenuIconDisabled,
				},
			};
		}

		openSharingDialog = () => {
			const { isRestricted, showRestriction } = getFeatureRestriction(FeatureId.CALENDAR_SHARING);

			if (isRestricted())
			{
				showRestriction({
					parentWidget: this.props.layout,
				});
			}
			else
			{
				const component = (layoutWidget) => new DialogSharing({
					layoutWidget,
					sharing: this.sharing,
					onSharing: (fields) => {
						this.sharing.getModel().setFields(fields);
						this.props.onSharing();
					},
				});

				void new BottomSheet({ component })
					.setBackgroundColor(Color.bgNavigation.toHex())
					.setMediumPositionPercent(70)
					.disableContentSwipe()
					.open()
				;
			}
		};
	}

	const sharingMenuIconDisabled = `<svg width="28" height="28" viewBox="0 0 28 28" fill="${Color.base4.toHex()}" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M12.3084 21.4087C12.6934 21.4087 13.0084 21.7237 13.0084 22.1087C13.0084 22.4937 12.6934 22.8087 12.3084 22.8087H7.81675C6.07841 22.8087 4.66675 21.397 4.66675 19.6587V10.1503C4.66675 8.41199 6.07841 7.00033 7.81675 7.00033H9.04175V5.61199C9.04175 5.08699 9.46175 4.66699 9.98675 4.66699C10.5117 4.66699 10.9317 5.08699 10.9317 5.61199V7.00033H17.0451V5.61199C17.0451 5.08699 17.4651 4.66699 17.9901 4.66699C18.5151 4.66699 18.9351 5.08699 18.9351 5.61199V7.00033H20.1601C21.8984 7.00033 23.3101 8.41199 23.3101 10.1503V13.067C23.3101 13.452 22.9951 13.767 22.6101 13.767C22.2251 13.767 21.9101 13.452 21.9101 13.067V10.1503C21.9101 9.18199 21.1284 8.40033 20.1601 8.40033H18.9351V9.08866C18.9351 9.61366 18.5151 10.0337 17.9901 10.0337C17.4651 10.0337 17.0451 9.61366 17.0451 9.08866V8.40033H10.9317V9.08866C10.9317 9.61366 10.5117 10.0337 9.98675 10.0337C9.46175 10.0337 9.04175 9.61366 9.04175 9.08866V8.40033H7.81675C6.84841 8.40033 6.06675 9.18199 6.06675 10.1503V19.6587C6.06675 20.627 6.84841 21.4087 7.81675 21.4087H12.3084ZM15.4115 13.4405V12.4488C15.4115 11.9355 14.9915 11.5155 14.4782 11.5155H13.5332C13.0199 11.5155 12.5999 11.9355 12.5999 12.4488V13.4405C12.5999 13.9538 13.0199 14.3738 13.5332 14.3738H14.4782C14.9915 14.3738 15.4115 13.9538 15.4115 13.4405ZM10.2553 11.5269C10.7686 11.5269 11.1886 11.9469 11.1886 12.4602V13.4519C11.1886 13.9652 10.7686 14.3852 10.2553 14.3852H9.31029C8.79695 14.3852 8.37695 13.9652 8.37695 13.4519V12.4602C8.37695 11.9469 8.79695 11.5269 9.31029 11.5269H10.2553ZM9.31029 15.96H10.2553C10.7686 15.96 11.1886 16.38 11.1886 16.8933V17.885C11.1886 18.3983 10.7686 18.8183 10.2553 18.8183H9.31029C8.79695 18.8183 8.37695 18.3983 8.37695 17.885V16.8933C8.37695 16.38 8.79695 15.96 9.31029 15.96ZM20.9066 14.6767L23.24 17.01V17.0217C23.5083 17.3017 23.5083 17.745 23.24 18.0133L20.9066 20.3467C20.6266 20.615 20.1833 20.615 19.915 20.3467C19.6466 20.0667 19.6466 19.6233 19.915 19.355L21.0583 18.2117H19.25C17.6983 18.2117 16.45 19.46 16.45 21.0117V22.3417C16.45 22.7267 16.135 23.0417 15.75 23.0417C15.365 23.0417 15.05 22.7267 15.05 22.3417V21.0117C15.05 18.69 16.9283 16.8117 19.25 16.8117H21.0583L19.915 15.6683C19.6466 15.3883 19.6466 14.945 19.915 14.6767C20.195 14.4083 20.6383 14.4083 20.9066 14.6767Z" fill="${Color.base4.toHex()}"/></svg>`;
	const sharingMenuIconEnabled = `<svg width="28" height="28" viewBox="0 0 28 28" fill="${Color.accentMainSuccess.toHex()}" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M12.3084 21.4087C12.6934 21.4087 13.0084 21.7237 13.0084 22.1087C13.0084 22.4937 12.6934 22.8087 12.3084 22.8087H7.81675C6.07841 22.8087 4.66675 21.397 4.66675 19.6587V10.1503C4.66675 8.41199 6.07841 7.00033 7.81675 7.00033H9.04175V5.61199C9.04175 5.08699 9.46175 4.66699 9.98675 4.66699C10.5117 4.66699 10.9317 5.08699 10.9317 5.61199V7.00033H17.0451V5.61199C17.0451 5.08699 17.4651 4.66699 17.9901 4.66699C18.5151 4.66699 18.9351 5.08699 18.9351 5.61199V7.00033H20.1601C21.8984 7.00033 23.3101 8.41199 23.3101 10.1503V13.067C23.3101 13.452 22.9951 13.767 22.6101 13.767C22.2251 13.767 21.9101 13.452 21.9101 13.067V10.1503C21.9101 9.18199 21.1284 8.40033 20.1601 8.40033H18.9351V9.08866C18.9351 9.61366 18.5151 10.0337 17.9901 10.0337C17.4651 10.0337 17.0451 9.61366 17.0451 9.08866V8.40033H10.9317V9.08866C10.9317 9.61366 10.5117 10.0337 9.98675 10.0337C9.46175 10.0337 9.04175 9.61366 9.04175 9.08866V8.40033H7.81675C6.84841 8.40033 6.06675 9.18199 6.06675 10.1503V19.6587C6.06675 20.627 6.84841 21.4087 7.81675 21.4087H12.3084ZM15.4115 13.4405V12.4488C15.4115 11.9355 14.9915 11.5155 14.4782 11.5155H13.5332C13.0199 11.5155 12.5999 11.9355 12.5999 12.4488V13.4405C12.5999 13.9538 13.0199 14.3738 13.5332 14.3738H14.4782C14.9915 14.3738 15.4115 13.9538 15.4115 13.4405ZM10.2553 11.5269C10.7686 11.5269 11.1886 11.9469 11.1886 12.4602V13.4519C11.1886 13.9652 10.7686 14.3852 10.2553 14.3852H9.31029C8.79695 14.3852 8.37695 13.9652 8.37695 13.4519V12.4602C8.37695 11.9469 8.79695 11.5269 9.31029 11.5269H10.2553ZM9.31029 15.96H10.2553C10.7686 15.96 11.1886 16.38 11.1886 16.8933V17.885C11.1886 18.3983 10.7686 18.8183 10.2553 18.8183H9.31029C8.79695 18.8183 8.37695 18.3983 8.37695 17.885V16.8933C8.37695 16.38 8.79695 15.96 9.31029 15.96ZM20.9066 14.6767L23.24 17.01V17.0217C23.5083 17.3017 23.5083 17.745 23.24 18.0133L20.9066 20.3467C20.6266 20.615 20.1833 20.615 19.915 20.3467C19.6466 20.0667 19.6466 19.6233 19.915 19.355L21.0583 18.2117H19.25C17.6983 18.2117 16.45 19.46 16.45 21.0117V22.3417C16.45 22.7267 16.135 23.0417 15.75 23.0417C15.365 23.0417 15.05 22.7267 15.05 22.3417V21.0117C15.05 18.69 16.9283 16.8117 19.25 16.8117H21.0583L19.915 15.6683C19.6466 15.3883 19.6466 14.945 19.915 14.6767C20.195 14.4083 20.6383 14.4083 20.9066 14.6767Z" fill="${Color.accentMainSuccess.toHex()}"/></svg>`;

	module.exports = { SharingButton };
});
