/**
 * @module calendar/event-edit-form/layout/slot-list-empty-state
 */
jn.define('calendar/event-edit-form/layout/slot-list-empty-state', (require, exports, module) => {
	const { Loc } = require('loc');
	const { Color } = require('tokens');
	const { StatusBlock } = require('ui-system/blocks/status-block');

	const SlotListEmptyState = () => View(
		{
			style: {
				flex: 1,
				opacity: 0,
				alignItems: 'center',
			},
			ref: (ref) => ref?.animate({ duration: 200, opacity: 1 }),
		},
		StatusBlock({
			testId: 'calendar-event-edit-form-empty-day',
			image: Image({
				svg: {
					content: icon,
				},
				style: {
					width: 109,
					height: 108,
					justifyContent: 'center',
				},
			}),
			title: Loc.getMessage('M_CALENDAR_EVENT_EDIT_FORM_EMPTY_STATE_TITLE'),
		}),
	);

	const icon = `<svg width="109" height="108" viewBox="0 0 109 108" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M101.077 79.7341C101.077 83.5698 98.1828 86.7874 94.3685 87.1922L16.2147 95.4874C11.7842 95.9576 7.9231 92.4846 7.9231 88.0293V19.7589C7.9231 15.3754 11.6663 11.9262 16.0351 12.2839L94.189 18.6829C98.0808 19.0015 101.077 22.253 101.077 26.1579V79.7341Z" fill="${Color.base8.toHex()}" stroke="${Color.bgSeparatorPrimary.toHex()}"/><path fill-rule="evenodd" clip-rule="evenodd" d="M57.2691 61.4291C57.2691 71.1688 49.7904 79.2762 40.0823 80.0607C29.2007 80.94 19.8845 72.3462 19.8845 61.4291V59.3492C19.8845 48.8315 28.5587 40.3845 39.0726 40.6634C49.1994 40.9321 57.2691 49.2188 57.2691 59.3492V61.4291Z" fill="${Color.accentMainPrimary.toHex()}" fill-opacity="0.78"/><path d="M56.7691 61.4291C56.7691 70.9083 49.4904 78.7988 40.0421 79.5623C29.4515 80.4181 20.3845 72.0542 20.3845 61.4291V59.3492C20.3845 49.1128 28.8267 40.8917 39.0594 41.1633C48.9153 41.4248 56.7691 49.4898 56.7691 59.3492V61.4291Z" stroke="${Color.baseWhiteFixed.toHex()}" stroke-opacity="0.18"/><mask id="path-4-inside-1_10997_56776" fill="${Color.baseWhiteFixed.toHex()}"><path fill-rule="evenodd" clip-rule="evenodd" d="M26.8077 9.95794V12.6922L16.0875 11.7988C11.4233 11.4101 7.4231 15.0909 7.4231 19.7712V29.8311L101.577 34.6152V26.284C101.577 22.1233 98.3876 18.6572 94.2413 18.3116L84.9616 17.5383V14.058C84.9616 12.6077 83.8426 11.4031 82.3962 11.2963C80.7909 11.1778 79.4231 12.4483 79.4231 14.058V17.0768L32.3462 13.1537V9.95794C32.3462 8.52659 31.2554 7.3311 29.83 7.20029C28.2075 7.0514 26.8077 8.3286 26.8077 9.95794Z"/></mask><path fill-rule="evenodd" clip-rule="evenodd" d="M26.8077 9.95794V12.6922L16.0875 11.7988C11.4233 11.4101 7.4231 15.0909 7.4231 19.7712V29.8311L101.577 34.6152V26.284C101.577 22.1233 98.3876 18.6572 94.2413 18.3116L84.9616 17.5383V14.058C84.9616 12.6077 83.8426 11.4031 82.3962 11.2963C80.7909 11.1778 79.4231 12.4483 79.4231 14.058V17.0768L32.3462 13.1537V9.95794C32.3462 8.52659 31.2554 7.3311 29.83 7.20029C28.2075 7.0514 26.8077 8.3286 26.8077 9.95794Z" fill="${Color.accentMainSuccess.toHex()}" fill-opacity="0.78"/><path d="M26.8077 12.6922L26.7247 13.6887L27.8077 13.779V12.6922H26.8077ZM16.0875 11.7988L16.1705 10.8023L16.0875 11.7988ZM7.4231 29.8311H6.4231V30.7815L7.37235 30.8298L7.4231 29.8311ZM101.577 34.6152L101.526 35.614L102.577 35.6674V34.6152H101.577ZM101.577 26.284L100.577 26.284V26.284H101.577ZM94.2413 18.3116L94.3243 17.3151L94.2413 18.3116ZM84.9616 17.5383H83.9616V18.4585L84.8785 18.5349L84.9616 17.5383ZM82.3962 11.2963L82.4699 10.299L82.3962 11.2963ZM79.4231 17.0768L79.34 18.0733L80.4231 18.1636V17.0768H79.4231ZM32.3462 13.1537H31.3462V14.0738L32.2631 14.1503L32.3462 13.1537ZM29.83 7.20029L29.9214 6.20448V6.20448L29.83 7.20029ZM27.8077 12.6922V9.95794H25.8077V12.6922H27.8077ZM16.0044 12.7954L26.7247 13.6887L26.8908 11.6956L16.1705 10.8023L16.0044 12.7954ZM8.4231 19.7712C8.4231 15.6759 11.9233 12.4553 16.0044 12.7954L16.1705 10.8023C10.9233 10.365 6.4231 14.5058 6.4231 19.7712H8.4231ZM8.4231 29.8311V19.7712H6.4231V29.8311H8.4231ZM101.628 33.6165L7.47384 28.8324L7.37235 30.8298L101.526 35.614L101.628 33.6165ZM100.577 26.284V34.6152H102.577V26.284H100.577ZM94.1582 19.3082C97.7863 19.6105 100.577 22.6434 100.577 26.284L102.577 26.284C102.577 21.6032 98.989 17.7038 94.3243 17.3151L94.1582 19.3082ZM84.8785 18.5349L94.1583 19.3082L94.3243 17.3151L85.0446 16.5418L84.8785 18.5349ZM83.9616 14.058V17.5383H85.9616V14.058H83.9616ZM82.3226 12.2936C83.2467 12.3618 83.9616 13.1315 83.9616 14.058H85.9616C85.9616 12.084 84.4385 10.4444 82.4699 10.299L82.3226 12.2936ZM80.4231 14.058C80.4231 13.0296 81.297 12.2179 82.3226 12.2936L82.4699 10.299C80.2848 10.1377 78.4231 11.867 78.4231 14.058H80.4231ZM80.4231 17.0768V14.058H78.4231V17.0768H80.4231ZM32.2631 14.1503L79.34 18.0733L79.5061 16.0802L32.4292 12.1572L32.2631 14.1503ZM31.3462 9.95794V13.1537H33.3462V9.95794H31.3462ZM29.7386 8.19611C30.6493 8.27968 31.3462 9.04346 31.3462 9.95794H33.3462C33.3462 8.00971 31.8615 6.38252 29.9214 6.20448L29.7386 8.19611ZM27.8077 9.95794C27.8077 8.91697 28.702 8.10098 29.7386 8.19611L29.9214 6.20448C27.713 6.00181 25.8077 7.74023 25.8077 9.95794H27.8077Z" fill="${Color.base8.toHex()}" fill-opacity="0.18" mask="url(#path-4-inside-1_10997_56776)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M78.0384 52.4672C78.0384 53.2928 77.3712 53.9632 76.5456 53.9672L71.2379 53.9927C70.4067 53.9967 69.7307 53.3239 69.7307 52.4927V45.8448C69.7307 45.002 70.4249 44.3246 71.2674 44.3452L76.5751 44.4751C77.389 44.495 78.0384 45.1605 78.0384 45.9747V52.4672Z" fill="${Color.base5.toHex()}"/><path fill-rule="evenodd" clip-rule="evenodd" d="M90.5001 52.4677C90.5001 53.2934 89.8328 53.9638 89.0072 53.9677L83.6995 53.9928C82.8683 53.9967 82.1924 53.324 82.1924 52.4928V45.8435C82.1924 45.0012 82.8858 44.324 83.7279 44.3439L89.0356 44.4695C89.8499 44.4888 90.5001 45.1545 90.5001 45.9691V52.4677Z" fill="${Color.base5.toHex()}"/><path fill-rule="evenodd" clip-rule="evenodd" d="M78.0384 64.6756C78.0384 65.4796 77.4045 66.1407 76.6011 66.1743L71.2934 66.3964C70.4411 66.4321 69.7307 65.7508 69.7307 64.8977V58.3559C69.7307 57.5349 70.3908 56.8664 71.2117 56.856L76.5194 56.7888C77.3552 56.7782 78.0384 57.4528 78.0384 58.2887V64.6756Z" fill="${Color.base6.toHex()}"/><path fill-rule="evenodd" clip-rule="evenodd" d="M78.0384 76.9031C78.0384 77.6877 77.4339 78.3397 76.6516 78.3989L71.3439 78.8007C70.4734 78.8666 69.7307 78.178 69.7307 77.3049V71.0533C69.7307 70.2523 70.36 69.5927 71.16 69.555L76.4677 69.3046C77.3229 69.2642 78.0384 69.9467 78.0384 70.8029V76.9031Z" fill="${Color.base6.toHex()}"/><path fill-rule="evenodd" clip-rule="evenodd" d="M90.5001 64.28C90.5001 65.0857 89.8636 65.7475 89.0585 65.7789L83.7508 65.9857C82.9001 66.0189 82.1924 65.3382 82.1924 64.4869V58.3525C82.1924 57.5311 82.8529 56.8626 83.6741 56.8526L88.9818 56.788C89.8173 56.7778 90.5001 57.4523 90.5001 58.2879V64.28Z" fill="${Color.base6.toHex()}"/><g filter="url(#filter0_d_10997_56776)"><path fill-rule="evenodd" clip-rule="evenodd" d="M30.4552 64.7347C32.1146 68.9087 35.8219 71.4972 39.7904 71.2973C44.9877 71.1491 49.0586 66.2444 48.9598 60.3367C48.9598 55.88 46.6154 51.8128 43.0034 50.0516C39.3526 48.2696 35.1299 49.1864 32.3477 52.4057C29.5407 55.6491 28.7851 60.5469 30.4552 64.7382V64.7347ZM38.191 54.6461C38.191 53.8774 38.7383 53.2639 39.4091 53.2777C40.08 53.2915 40.6237 53.9257 40.6237 54.6909V58.8546L43.0387 58.8856C43.7025 58.8925 44.2392 59.5198 44.2392 60.2815C44.2392 61.0432 43.7025 61.6568 43.0387 61.6499L39.4268 61.6189H39.4127C38.7418 61.612 38.1946 60.9847 38.1946 60.216V54.6461H38.191Z" fill="${Color.baseWhiteFixed.toHex()}" fill-opacity="0.9" shape-rendering="crispEdges"/></g><defs><filter id="filter0_d_10997_56776" x="19.5769" y="43.1543" width="39.3845" height="42.1543" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4"/><feGaussianBlur stdDeviation="5"/><feComposite in2="hardAlpha" operator="out"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_10997_56776"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_10997_56776" result="shape"/></filter></defs></svg>`;

	module.exports = { SlotListEmptyState };
});
