;(function(window) {

	function Search(calendar, data)
	{
		this.calendar = calendar;
		this.util = this.calendar.util;
		this.filterId = data.filterId;
		this.minSearchStringLength = 2;

		this.showCounters = false;
		this.counters = [
			{
				id: 'invitation',
				className: 'calendar-counter-invitation',
				pluralMessageId: 'EC_COUNTER_INVITATION',
				value: data.counters.invitation || 0
			}
			//{
			//	id: 'new_comments',
			//	className: 'calendar-counter-new-comments',
			//	pluralMessageId: 'EC_COUNTER_NEW_COMMENTS',
			//	value: 2
			//}
		];

		this.filter = BX.Main.filterManager.getById(this.filterId);
		if (this.filter)
		{
			this.filterApi = this.filter.getApi();
			//BX.addCustomEvent('BX.Main.Filter:beforeApply', BX.delegate(this.beforeFilterApply, this));
			BX.addCustomEvent('BX.Main.Filter:apply', BX.delegate(this.applyFilter, this));
		}
	}

	Search.prototype = {
		getFilter: function()
		{
			return this.filter;
		},

		updateCounters: function ()
		{
			var i, _this = this;

			this.showCounters = false;

			BX.cleanNode(this.calendar.countersCont);
			this.countersWrap = this.calendar.countersCont.appendChild(BX.create('DIV', {props: {className: 'calendar-counter-title'}}));

			for (i = 0; i < this.counters.length; i++)
			{
				if (this.counters[i] && this.counters[i].value > 0)
				{
					this.showCounters = true;
					break;
				}
			}

			if (this.showCounters)
			{
				this.countersWrap.appendChild(BX.create('span', {
					props: {className: 'calendar-counter-page-name'},
					text: BX.message('EC_COUNTER_TOTAL') + ':'
				}));

				for (i = 0; i < this.counters.length; i++)
				{
					if (this.counters[i] && this.counters[i].value > 0)
					{
						this.countersWrap.appendChild(BX.create('span', {
							props: {className: 'calendar-counter-container' + ' ' + this.counters[i].className},
							attrs: {'data-bx-counter': this.counters[i].id},
							html: '<span class="calendar-counter-inner">' +
								'<span class="calendar-counter-number">' + this.counters[i].value + '</span>' +
								'<span class="calendar-counter-text">' + BX.Loc.getMessagePlural(this.counters[i].pluralMessageId, this.counters[i].value) + '</span>' +
							'</span>',
							events: {
								click: (function (counter)
								{
									return function ()
									{
										_this.appplyCounterEntries(counter.id);
									}
								})(this.counters[i])
							}
						}));
					}
				}
			}
			else
			{
				this.countersWrap.innerHTML = BX.message('EC_NO_COUNTERS');
			}
		},

		appplyCounterEntries: function(counterId)
		{
			if (counterId === 'invitation')
			{
				this.filterApi.setFilter({
					preset_id: "filter_calendar_meeting_status_q"
				});
			}
		},

		beforeFilterApply: function()
		{
			if (!this.isFilterEmpty())
			{
				// 1. Set list view
				//this.calendar.setView('list', {animation: false});
				//setTimeout(BX.delegate(function ()

				//	this.calendar.getView().applyFilterMode();
				//	// 2. Show animation
				//}, this), 100);
			}
		},

		applyFilter: function(id, data, ctx, promise, params)
		{
			return new Promise(function(resolve)
			{
				if (params)
				{
					params.autoResolve = false;
				}
				if (this.isFilterEmpty())
				{
					if (this.calendar.getView().resetFilterMode)
					{
						this.calendar.getView().resetFilterMode({resetSearchFilter: false});
					}
					if (promise)
					{
						promise.fulfill();
					}
				}
				else
				{
					this.calendar.setView('list', {animation: false});
					this.calendar.getView().applyFilterMode();
					
					BX.ajax.runAction('calendar.api.calendarajax.getFilterData', {
						data: {
							ownerId: this.calendar.util.config.ownerId,
							userId: this.calendar.util.config.userId,
							type: this.calendar.util.config.type,
						}
					})
						.then(function(response)
							{
								if (response.data.entries)
								{
									if (!this.calendar.getView().filterMode)
									{
										this.calendar.getView().applyFilterMode();
										this.displaySearchResult(response.data);
									}
									else
									{
										this.displaySearchResult(response.data);
									}
								}
								
								if (promise)
								{
									promise.fulfill();
								}
								
								resolve(response.data);
							}.bind(this),
							function(response){
								resolve(response.data);
							}.bind(this)
						)
				}
			});
		},

		displaySearchResult: function(response)
		{
			var i, entries = [];
			for (i = 0; i < response.entries.length; i++)
			{
				entries.push(new window.BXEventCalendar.Entry(this.calendar, response.entries[i]));
			}
			this.calendar.getView().displayResult(entries);

			this.setCountersValue(response.counters);
		},

		setCountersValue: function(counters)
		{
			if (BX.type.isPlainObject(counters))
			{
				for (var i = 0; i < this.counters.length; i++)
				{
					if (counters[this.counters[i].id] !== undefined)
					{
						this.counters[i].value = counters[this.counters[i].id] || 0;
					}
				}
				this.updateCounters();
			}
		},

		isFilterEmpty: function()
		{
			var searchField = this.filter.getSearch();
			return !searchField.getLastSquare() && (!searchField.getSearchString() || searchField.getSearchString().length < this.minSearchStringLength);
		},

		searchInput: function()
		{
		},

		resetFilter: function()
		{
			this.filter.resetFilter();
		}
	};

	if (window.BXEventCalendar)
	{
		window.BXEventCalendar.Search = Search;
	}
	else
	{
		BX.addCustomEvent(window, "OnBXEventCalendarInit", function()
		{
			window.BXEventCalendar.Search = Search;
		});
	}
})(window);