
CREATE TABLE b_blog_site_path (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SITE_ID char(2) NOT NULL,
  PATH varchar(255) NOT NULL,
  TYPE char(1),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_blog_site_path_site_id_type ON b_blog_site_path (site_id, type);

CREATE TABLE b_blog (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) NOT NULL,
  DESCRIPTION text,
  DATE_CREATE timestamp NOT NULL,
  DATE_UPDATE timestamp NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  OWNER_ID int,
  SOCNET_GROUP_ID int,
  URL varchar(255) NOT NULL,
  REAL_URL varchar(255),
  GROUP_ID int NOT NULL,
  ENABLE_COMMENTS char(1) NOT NULL DEFAULT 'Y',
  ENABLE_IMG_VERIF char(1) NOT NULL DEFAULT 'N',
  ENABLE_RSS char(1) NOT NULL DEFAULT 'Y',
  LAST_POST_ID int,
  LAST_POST_DATE timestamp,
  AUTO_GROUPS varchar(255),
  EMAIL_NOTIFY char(1) NOT NULL DEFAULT 'Y',
  ALLOW_HTML char(1) NOT NULL DEFAULT 'N',
  SEARCH_INDEX char(1) NOT NULL DEFAULT 'Y',
  USE_SOCNET char(1) NOT NULL DEFAULT 'N',
  EDITOR_USE_FONT char(1) DEFAULT 'N',
  EDITOR_USE_LINK char(1) DEFAULT 'N',
  EDITOR_USE_IMAGE char(1) DEFAULT 'N',
  EDITOR_USE_VIDEO char(1) DEFAULT 'N',
  EDITOR_USE_FORMAT char(1) DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_blog_group_id_active ON b_blog (group_id, active);
CREATE INDEX ix_b_blog_owner_id ON b_blog (owner_id);
CREATE UNIQUE INDEX ux_b_blog_url ON b_blog (url);
CREATE INDEX ix_b_blog_last_post_date ON b_blog (last_post_date);
CREATE INDEX ix_b_blog_socnet_group_id ON b_blog (socnet_group_id);

CREATE TABLE b_blog_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) NOT NULL,
  SITE_ID char(2) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_blog_group_site_id ON b_blog_group (site_id);

CREATE TABLE b_blog_post (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TITLE varchar(255) NOT NULL,
  BLOG_ID int NOT NULL,
  AUTHOR_ID int NOT NULL,
  PREVIEW_TEXT text,
  PREVIEW_TEXT_TYPE char(4) NOT NULL DEFAULT 'text',
  DETAIL_TEXT text NOT NULL,
  DETAIL_TEXT_TYPE char(4) NOT NULL DEFAULT 'text',
  DATE_CREATE timestamp NOT NULL,
  DATE_PUBLISH timestamp NOT NULL,
  KEYWORDS varchar(255),
  PUBLISH_STATUS char(1) NOT NULL DEFAULT 'P',
  CATEGORY_ID varchar(255),
  ATRIBUTE varchar(255),
  ENABLE_TRACKBACK char(1) NOT NULL DEFAULT 'Y',
  ENABLE_COMMENTS char(1) NOT NULL DEFAULT 'Y',
  ATTACH_IMG int,
  NUM_COMMENTS int NOT NULL DEFAULT '0',
  NUM_COMMENTS_ALL int NOT NULL DEFAULT '0',
  NUM_TRACKBACKS int NOT NULL DEFAULT '0',
  VIEWS int,
  FAVORITE_SORT int,
  PATH varchar(255),
  CODE varchar(255),
  MICRO char(1) NOT NULL DEFAULT 'N',
  HAS_IMAGES varchar(1) DEFAULT NULL,
  HAS_PROPS varchar(1) DEFAULT NULL,
  HAS_TAGS varchar(1) DEFAULT NULL,
  HAS_COMMENT_IMAGES varchar(1) DEFAULT NULL,
  HAS_SOCNET_ALL varchar(1) DEFAULT NULL,
  SEO_TITLE varchar(255),
  SEO_TAGS varchar(255),
  SEO_DESCRIPTION text,
  BACKGROUND_CODE varchar(100),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_blog_post_blog_id_publish_status_date_publish ON b_blog_post (blog_id, publish_status, date_publish);
CREATE INDEX ix_b_blog_post_blog_id_date_publish_publish_status ON b_blog_post (blog_id, date_publish, publish_status);
CREATE INDEX ix_b_blog_post_blog_id_category_id ON b_blog_post (blog_id, category_id);
CREATE INDEX ix_b_blog_post_publish_status_date_publish ON b_blog_post (publish_status, date_publish);
CREATE INDEX ix_b_blog_post_date_publish_author_id ON b_blog_post (date_publish, author_id);
CREATE INDEX ix_b_blog_post_blog_id_code ON b_blog_post (blog_id, code);
CREATE INDEX ix_b_blog_post_code ON b_blog_post (code);

CREATE TABLE b_blog_category (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  BLOG_ID int NOT NULL,
  NAME varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_blog_category_blog_id_name ON b_blog_category (blog_id, name);

CREATE TABLE b_blog_comment (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  BLOG_ID int NOT NULL,
  POST_ID int NOT NULL,
  PARENT_ID int,
  AUTHOR_ID int,
  ICON_ID int,
  AUTHOR_NAME varchar(255),
  AUTHOR_EMAIL varchar(255),
  AUTHOR_IP varchar(20),
  AUTHOR_IP1 varchar(20),
  DATE_CREATE timestamp NOT NULL,
  TITLE varchar(255),
  POST_TEXT text NOT NULL,
  PUBLISH_STATUS char(1) NOT NULL DEFAULT 'P',
  HAS_PROPS varchar(1) DEFAULT null,
  SHARE_DEST text,
  PATH varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_blog_comment_blog_id_post_id ON b_blog_comment (blog_id, post_id);
CREATE INDEX ix_b_blog_comment_author_id ON b_blog_comment (author_id);
CREATE INDEX ix_b_blog_comment_date_create_author_id ON b_blog_comment (date_create, author_id);
CREATE INDEX ix_b_blog_comment_post_id ON b_blog_comment (post_id);

CREATE TABLE b_blog_user (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  ALIAS varchar(255),
  DESCRIPTION text,
  AVATAR int,
  INTERESTS varchar(255),
  LAST_VISIT timestamp,
  DATE_REG timestamp NOT NULL,
  ALLOW_POST char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_blog_user_user_id ON b_blog_user (user_id);
CREATE INDEX ix_b_blog_user_alias ON b_blog_user (alias);

CREATE TABLE b_blog_user_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  BLOG_ID int,
  NAME varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_blog_user_group_blog_id ON b_blog_user_group (blog_id);

CREATE TABLE b_blog_user2user_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  BLOG_ID int NOT NULL,
  USER_GROUP_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_blog_user2user_group_user_id_blog_id_user_group_id ON b_blog_user2user_group (user_id, blog_id, user_group_id);

CREATE TABLE b_blog_user_group_perms (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  BLOG_ID int NOT NULL,
  USER_GROUP_ID int NOT NULL,
  PERMS_TYPE char(1) NOT NULL DEFAULT 'P',
  POST_ID int,
  PERMS char(1) NOT NULL DEFAULT 'D',
  AUTOSET char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_blog_user_group_perms_blog_id_user_group_id_perms_type_pos ON b_blog_user_group_perms (blog_id, user_group_id, perms_type, post_id);
CREATE INDEX ix_b_blog_user_group_perms_user_group_id_perms_type_post_id ON b_blog_user_group_perms (user_group_id, perms_type, post_id);
CREATE INDEX ix_b_blog_user_group_perms_post_id_user_group_id_perms_type ON b_blog_user_group_perms (post_id, user_group_id, perms_type);

CREATE TABLE b_blog_user2blog (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  BLOG_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_blog_user2blog_blog_id_user_id ON b_blog_user2blog (blog_id, user_id);

CREATE TABLE b_blog_trackback (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TITLE varchar(255) NOT NULL,
  URL varchar(255) NOT NULL,
  PREVIEW_TEXT text NOT NULL,
  BLOG_NAME varchar(255),
  POST_DATE timestamp NOT NULL,
  BLOG_ID int NOT NULL,
  POST_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_blog_trackback_blog_id_post_id ON b_blog_trackback (blog_id, post_id);
CREATE INDEX ix_b_blog_trackback_post_id ON b_blog_trackback (post_id);

CREATE TABLE b_blog_image (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  FILE_ID int NOT NULL DEFAULT '0',
  BLOG_ID int NOT NULL DEFAULT '0',
  POST_ID int NOT NULL DEFAULT '0',
  USER_ID int NOT NULL DEFAULT '0',
  TIMESTAMP_X timestamp NOT NULL DEFAULT '1970-01-01 00:00:01',
  TITLE varchar(255),
  IMAGE_SIZE int NOT NULL DEFAULT '0',
  IS_COMMENT varchar(1) NOT NULL DEFAULT 'N',
  COMMENT_ID int DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_blog_image_post_id_blog_id ON b_blog_image (post_id, blog_id);

CREATE TABLE b_blog_post_category (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  BLOG_ID int NOT NULL,
  POST_ID int NOT NULL,
  CATEGORY_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_blog_post_category_post_id_category_id ON b_blog_post_category (post_id, category_id);
CREATE INDEX ix_b_blog_post_category_category_id ON b_blog_post_category (category_id);

CREATE TABLE b_blog_socnet (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  BLOG_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_blog_socnet_blog_id ON b_blog_socnet (blog_id);

CREATE TABLE b_blog_socnet_rights (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  POST_ID int NOT NULL,
  ENTITY_TYPE varchar(45) NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY varchar(45) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_blog_socnet_rights_post_id ON b_blog_socnet_rights (post_id);
CREATE INDEX ix_b_blog_socnet_rights_entity ON b_blog_socnet_rights (entity);

CREATE TABLE b_blog_post_param (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  POST_ID int,
  USER_ID int,
  NAME varchar(50) NOT NULL,
  VALUE varchar(255) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_blog_post_param_post_id_user_id ON b_blog_post_param (post_id, user_id);
CREATE INDEX ix_b_blog_post_param_user_id ON b_blog_post_param (user_id);
