/**
 * @module bizproc/workflow/timeline/icons
 */
jn.define('bizproc/workflow/timeline/icons', (require, exports, module) => {
	const AppTheme = require('apptheme');

	const check = ({ color = AppTheme.colors.accentMainSuccess } = {}) => `<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.73773 8.87384L4.88796 6.95801L3.43457 8.80778L6.73773 12.1109L12.9834 5.86524L11.3622 4.18335L6.73773 8.87384Z" fill="${color}"/></svg>`;
	const cross = ({ color = AppTheme.colors.base4 } = {}) => `<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none"><path fill-rule="evenodd" clip-rule="evenodd" d="M9.11272 8L12 10.8873L10.8873 12L8 9.11272L5.11272 12L4 10.8873L6.88728 8L4 5.11272L5.11272 4L8 6.88728L10.8873 4L12 5.11272L9.11272 8Z" fill="${color}"/></svg>`;
	const union = ({ color = AppTheme.colors.baseWhiteFixed } = {}) => `<svg xmlns="http://www.w3.org/2000/svg" width="11" height="9" viewBox="0 0 11 9" fill="none"><path d="M10.391 1.60505C10.5363 1.45971 10.5363 1.22407 10.391 1.07873C10.2457 0.933392 10.01 0.933392 9.86468 1.07873L3.81205 7.13136L1.13532 4.45463C0.989981 4.30929 0.754341 4.30929 0.609003 4.45463C0.463665 4.59997 0.463666 4.83561 0.609004 4.98095L3.54889 7.92083C3.55798 7.92992 3.56741 7.93843 3.57716 7.94638C3.72333 8.06561 3.93895 8.05709 4.07521 7.92083L10.391 1.60505Z" fill="${color}" stroke="white" stroke-linecap="round"/></svg>`;
	const clock = ({ outlineColor = AppTheme.colors.bgContentPrimary } = {}) => `<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none"><circle cx="9" cy="9" r="9" fill="${outlineColor}"/><circle cx="9" cy="9" r="6" fill="white"/><path fill-rule="evenodd" clip-rule="evenodd" d="M9 17C13.4183 17 17 13.4183 17 9C17 4.58172 13.4183 1 9 1C4.58172 1 1 4.58172 1 9C1 13.4183 4.58172 17 9 17ZM9.99015 4.04879H8.00983V8.00941V8.99957V9.98972H12.9606V8.00941H9.99015V4.04879Z" fill="#00A2E8"/></svg>`;
	const flag = () => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path fill-rule="evenodd" clip-rule="evenodd" d="M18.9889 6.40529C18.9935 6.44246 18.9975 6.47545 18.9975 6.50845C18.9977 6.67523 18.9982 6.842 18.9987 7.00878C19 7.50924 19.0014 8.00971 18.997 8.51017C18.9874 9.69312 18.9744 10.8761 18.9581 12.059C18.9494 12.6676 18.934 13.2761 18.9114 13.8842C18.909 13.9491 18.8542 14.0453 18.7984 14.0703C18.1055 14.3821 17.3717 14.5173 16.6173 14.473C15.7887 14.4244 15.0001 14.1872 14.2409 13.8548C13.9364 13.7216 13.6336 13.584 13.3307 13.4463C12.7675 13.1903 12.2043 12.9343 11.6298 12.7065C10.4945 12.2562 9.37073 12.2365 8.34987 13.0216C8.10727 13.2082 7.88389 13.4201 7.65429 13.6379C7.54712 13.7396 7.43859 13.8425 7.32612 13.9448V12.2914C7.32622 11.9037 7.32637 11.5161 7.32653 11.1285C7.32714 9.5784 7.32776 8.02836 7.32468 6.47863C7.3242 6.33238 7.35834 6.22751 7.46701 6.12648C8.21042 5.43615 9.08125 5.0412 10.1007 5.06766C10.8628 5.08786 11.6024 5.27548 12.3155 5.54728C12.7105 5.69779 13.1037 5.85316 13.4969 6.00855C14.02 6.21523 14.543 6.42192 15.0703 6.61717C15.6849 6.84424 16.322 7.00876 16.9827 7.02368C17.6477 7.03907 18.2666 6.87406 18.8071 6.46564C18.8421 6.43871 18.8782 6.4132 18.9215 6.38268C18.9401 6.36957 18.96 6.35554 18.9816 6.34008C18.9838 6.36351 18.9865 6.38502 18.9889 6.40529ZM6.29928 18.9998H5V5.4542H6.29928V18.9998Z" fill="#9DCF00"/></svg>';
	const dots = ({ color = AppTheme.colors.base4 } = {}) => `<svg width="3" height="9" viewBox="0 0 3 9" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="1.5" cy="8" r="1" transform="rotate(-90 1.5 8)" fill="${color}"/><circle cx="1.5" cy="4.5" r="1" transform="rotate(-90 1.5 4.5)" fill="${color}"/><circle cx="1.5" cy="1" r="1" transform="rotate(-90 1.5 1)" fill="${color}"/></svg>`;

	const documents = {
		lists: ({ color = AppTheme.colors.base3 } = {}) => `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.95801 4.30347C6.40572 4.30347 5.95801 4.75118 5.95801 5.30347L5.95805 18.775C5.95805 19.3273 6.40576 19.775 6.95805 19.775H17.0418C17.5941 19.775 18.0418 19.3273 18.0418 18.775V9.48352C18.0418 8.98133 17.8529 8.49752 17.5126 8.12822L14.728 4.94816C14.3494 4.53724 13.8161 4.30347 13.2573 4.30347H6.95801ZM8.77992 8.46418C8.34375 8.46418 7.99016 8.82178 7.99016 9.25795C7.99016 9.69412 8.34375 10.0517 8.77992 10.0517H14.6352C15.0714 10.0517 15.425 9.69412 15.425 9.25795C15.425 8.82178 15.0714 8.46418 14.6352 8.46418H8.77992ZM8.77992 11.4794C8.34375 11.4794 7.99016 11.837 7.99016 12.2732C7.99016 12.7094 8.34375 13.067 8.77992 13.067H14.6352C15.0714 13.067 15.425 12.7094 15.425 12.2732C15.425 11.837 15.0714 11.4794 14.6352 11.4794H8.77992ZM7.99016 15.2482C7.99016 14.812 8.34375 14.4544 8.77992 14.4544H12.9225C13.3586 14.4544 13.7122 14.812 13.7122 15.2482C13.7122 15.6843 13.3586 16.0419 12.9225 16.0419H8.77992C8.34375 16.0419 7.99016 15.6843 7.99016 15.2482Z" fill="${color}"/></svg>`,
		crm: {
			lead: ({ color = AppTheme.colors.base3 } = {}) => `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path fill-rule="evenodd" clip-rule="evenodd" d="M13.9144 10.5887C13.8581 10.5291 13.7906 10.4809 13.7134 10.4451C13.6378 10.4105 13.5578 10.3917 13.4755 10.3917C13.392 10.3917 13.3142 10.4099 13.237 10.4451C13.1592 10.4809 13.0939 10.528 13.0366 10.5887C12.9798 10.6489 12.9344 10.7193 12.9009 10.7971C12.8668 10.8755 12.8503 10.9538 12.8503 11.0373C12.8503 11.1208 12.8674 11.202 12.9009 11.2809C12.9338 11.3598 12.9798 11.4296 13.036 11.4887C13.0933 11.5477 13.1592 11.5943 13.2364 11.6295C13.3914 11.6999 13.5606 11.6993 13.7134 11.6295C13.7912 11.5943 13.8587 11.5466 13.9149 11.4887C13.9711 11.4302 14.0166 11.3598 14.0501 11.2809C14.083 11.202 14.1 11.1202 14.1 11.0373C14.1 10.9544 14.0836 10.8755 14.0501 10.7971C14.0166 10.7193 13.9706 10.6489 13.9144 10.5887ZM20.6453 17.8739H8.10962V16.0922H17.1585C17.3845 16.0922 17.6837 15.7935 17.6837 15.567V9.86523H20.6453V17.8739ZM7.40976 13.895C6.88172 13.8779 6.47291 13.8745 6.06523 13.849C5.58772 13.8183 5.10964 13.7769 4.65087 13.6315C4.56343 13.6048 4.4811 13.5634 4.39764 13.5259C4.32496 13.493 4.28976 13.4402 4.30168 13.3579C4.33518 13.1336 4.34824 12.9053 4.40047 12.6856C4.47258 12.3801 4.67245 12.178 4.9853 12.0695C5.39524 11.9287 5.79951 11.7726 6.20378 11.6176C6.44565 11.525 6.59839 11.3144 6.59214 11.0952C6.59158 11.06 6.57568 11.0174 6.55183 10.9919C6.25715 10.6773 6.07148 10.3139 6.00902 9.8932C5.95508 9.52924 5.95168 9.16416 6.06978 8.80929C6.2157 8.36868 6.52458 8.10296 6.99982 8.01836C7.29223 7.96555 7.57783 7.98202 7.85434 8.08422C8.25634 8.23298 8.47153 8.53448 8.56862 8.92568C8.64243 9.22434 8.63903 9.52357 8.60325 9.82733C8.55726 10.206 8.41759 10.5445 8.17798 10.8448C8.14789 10.8834 8.1195 10.9254 8.08259 10.9561C8.01673 11.0112 8.00083 11.0748 8.02808 11.1503C8.05988 11.2389 8.09281 11.3269 8.13029 11.4126C8.16549 11.4915 8.22738 11.5466 8.31084 11.5778C8.69524 11.7232 9.07906 11.8674 9.46232 12.015C9.59859 12.0673 9.7394 12.115 9.86375 12.1882C10.075 12.3131 10.1766 12.5198 10.2209 12.7458C10.2629 12.9587 10.276 13.1767 10.3038 13.3919C10.3095 13.4396 10.2879 13.4663 10.2493 13.493C10.0931 13.5992 9.91371 13.6548 9.73145 13.6883C9.43052 13.7428 9.12733 13.795 8.82356 13.8189C8.31425 13.8592 7.80267 13.8751 7.40976 13.895ZM10.9976 9.78361C11.1356 9.46792 11.3184 9.29361 11.5495 9.07161L11.6097 9.01369C11.8686 8.76443 12.1758 8.56571 12.5238 8.42319C12.8719 8.28011 13.254 8.208 13.6594 8.208C14.0336 8.208 14.3868 8.27102 14.7087 8.39537C15.0323 8.51971 15.3168 8.69346 15.5547 8.91035C15.7926 9.12839 15.9828 9.38787 16.1197 9.68141C16.2559 9.97666 16.3252 10.2946 16.3252 10.6285C16.3252 10.9101 16.2894 11.1713 16.2179 11.4047C16.1458 11.6403 16.0413 11.8458 15.9084 12.0162C15.7744 12.1871 15.6109 12.3222 15.4218 12.417C15.2333 12.5113 15.0187 12.559 14.7836 12.559C14.6502 12.559 14.5287 12.5238 14.4225 12.4545C14.3357 12.3983 14.2573 12.3245 14.1892 12.2342C14.0501 12.3642 13.9138 12.4483 13.7843 12.4852C13.4721 12.5749 13.2052 12.5669 12.9099 12.4346C12.7481 12.3619 12.5982 12.258 12.4642 12.1269C12.3302 11.9952 12.2178 11.8362 12.1298 11.655C12.0401 11.4711 11.9947 11.2655 11.9947 11.0441C11.9947 10.8278 12.0372 10.6262 12.1224 10.4445C12.2076 10.2628 12.3194 10.1056 12.4557 9.9778C12.5908 9.84834 12.7493 9.74784 12.9264 9.67687C13.1024 9.6059 13.2858 9.57013 13.4686 9.57013C13.6713 9.57013 13.8525 9.60987 14.0058 9.68879C14.112 9.7433 14.1994 9.81144 14.2675 9.89093L14.3135 9.63145H15.0516L15.0443 9.69504L14.8404 11.3916C14.8268 11.4966 14.82 11.6039 14.82 11.7124C14.82 11.7442 14.8268 11.7675 14.841 11.7839C14.8558 11.8027 14.8688 11.8055 14.879 11.8055C14.971 11.8055 15.0545 11.7754 15.134 11.7147C15.2163 11.6516 15.289 11.5659 15.3509 11.4586C15.4139 11.3501 15.4633 11.2241 15.4985 11.085C15.5337 10.9464 15.5513 10.8 15.5513 10.6489C15.5513 10.3997 15.5025 10.1697 15.4065 9.96417C15.3106 9.7592 15.1771 9.58262 15.0091 9.43897C14.8404 9.29418 14.6389 9.18062 14.4112 9.1017C14.1812 9.02221 13.9303 8.9819 13.6662 8.9819C13.3608 8.9819 13.0757 9.0347 12.8185 9.13804C12.5613 9.24138 12.3359 9.38389 12.1491 9.56218C11.9623 9.73989 11.8141 9.95509 11.7079 10.2009C11.6029 10.4485 11.5489 10.7159 11.5489 10.9964C11.5489 11.3132 11.6074 11.6011 11.7216 11.8526C11.8363 12.1025 11.9924 12.316 12.1871 12.4869C12.383 12.6583 12.6147 12.7906 12.877 12.8809C13.1399 12.9718 13.4238 13.0177 13.7207 13.0177C13.8979 13.0177 14.054 13.0121 14.1863 13.0007C14.3181 12.9899 14.4441 12.9689 14.5616 12.9383C14.6803 12.9065 14.7933 12.8639 14.8978 12.8122C15.0062 12.7594 15.1272 12.6896 15.2566 12.6044L15.3077 12.5709L15.7131 13.3005L15.6671 13.3295C15.3872 13.5038 15.0897 13.6349 14.7842 13.7212C14.4907 13.8019 14.1057 13.8484 13.7276 13.8484C13.2535 13.8484 12.7981 13.7701 12.4466 13.627C12.0849 13.4794 11.7732 13.2755 11.5189 13.0212C11.235 12.7378 11.0402 12.35 10.9267 12.0741C10.7887 11.7379 10.7188 11.3757 10.7188 10.9964C10.7188 10.57 10.8693 10.0766 10.9976 9.78361ZM21.2122 8.77011L17.6839 8.7843V6.53302C17.6839 6.30647 17.3847 6.00781 17.1587 6.00781H3.71742C3.49088 6.00781 3.19165 6.30647 3.19165 6.53302V15.5666C3.19165 15.7931 3.49088 16.0918 3.71742 16.0918H7.07476V18.3856C7.07476 18.6127 7.37342 18.9114 7.60054 18.9114L21.2122 18.8552C21.4387 18.8552 21.7374 18.669 21.7374 18.3294V9.29588C21.7374 9.18233 21.4387 8.77011 21.2122 8.77011Z" fill="${color}"/></svg>`,
			deal: ({ color = AppTheme.colors.base3 } = {}) => `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path fill-rule="evenodd" clip-rule="evenodd" d="M4.02686 7.86365C4.02686 6.86998 4.83238 6.06445 5.82605 6.06445H18.1122C19.1059 6.06445 19.9114 6.86998 19.9114 7.86365V16.108C19.9114 17.1017 19.1059 17.9072 18.1122 17.9072H5.82605C4.83238 17.9072 4.02686 17.1017 4.02686 16.108V7.86365ZM11.094 8.86426C10.7101 8.86426 10.3989 9.17547 10.3989 9.55937C10.3989 9.94327 10.7101 10.2545 11.094 10.2545H16.6314C17.0153 10.2545 17.3265 9.94327 17.3265 9.55937C17.3265 9.17547 17.0153 8.86426 16.6314 8.86426H11.094ZM11.094 11.8147C10.7101 11.8147 10.3989 12.1259 10.3989 12.5098C10.3989 12.8937 10.7101 13.2049 11.094 13.2049H14.9627C15.3466 13.2049 15.6578 12.8937 15.6578 12.5098C15.6578 12.1259 15.3466 11.8147 14.9627 11.8147H11.094ZM7.4834 11.1518C8.29767 11.1518 8.95776 10.4917 8.95776 9.67744C8.95776 8.86317 8.29767 8.20307 7.4834 8.20307C6.66913 8.20307 6.00903 8.86317 6.00903 9.67744C6.00903 10.4917 6.66913 11.1518 7.4834 11.1518Z" fill="${color}"/></svg>`,
			dynamic: ({ color = AppTheme.colors.base3 } = {}) => `<svg xmlns="http://www.w3.org/2000/svg" width="16" height="18" viewBox="0 0 16 18" fill="none"><path d="M7.11868 0.749048C7.11868 0.496356 7.42419 0.369807 7.60287 0.548487L10.1881 3.13368C10.2988 3.24445 10.2988 3.42404 10.1881 3.5348L7.60287 6.12C7.42419 6.29868 7.11868 6.17213 7.11868 5.91944V4.69424C6.59134 4.78192 6.0787 4.947 5.59875 5.1842C5.45841 5.25356 5.28595 5.20577 5.20923 5.06932L4.2447 3.35375C4.16787 3.21711 4.21624 3.04358 4.3556 2.97181C5.21789 2.52773 6.15544 2.24407 7.11868 2.13538V0.749048Z" fill="${color}"/><path d="M12.0032 6.38257C11.8975 6.26694 11.8954 6.08769 12.0053 5.97604L13.3864 4.57348C13.4963 4.4619 13.6763 4.46019 13.7839 4.57395C16.0897 7.01138 16.6787 10.7483 14.9835 13.852C13.2957 16.9421 9.85594 18.4665 6.5719 17.865C6.41786 17.8368 6.32119 17.685 6.35485 17.532L6.77797 15.6096C6.81165 15.4566 6.96307 15.3607 7.11765 15.3863C9.32771 15.7526 11.6242 14.714 12.7587 12.6368C13.8983 10.5504 13.5227 8.04399 12.0032 6.38257Z" fill="${color}"/><path d="M4.19143 17.0195C4.30356 17.0808 4.41652 17.139 4.53022 17.1944C4.67119 17.2629 4.83912 17.1977 4.90251 17.0543L5.69828 15.2545C5.76158 15.1113 5.69655 14.9446 5.55694 14.8739C5.5066 14.8483 5.45649 14.822 5.40662 14.7947C3.95539 14.0021 3.01109 12.6423 2.69869 11.141C2.66679 10.9877 2.5228 10.8814 2.36805 10.9052L0.422911 11.2038C0.267998 11.2276 0.161232 11.3727 0.190621 11.5266C0.621079 13.7815 2.01949 15.8333 4.19143 17.0195Z" fill="${color}"/><path d="M0.345649 9.58542C0.189352 9.57615 0.0696018 9.44192 0.0843612 9.28605C0.183034 8.24396 0.490302 7.20435 1.02385 6.22747C1.43626 5.4724 1.95326 4.81082 2.54704 4.2509C2.661 4.14344 2.84056 4.15552 2.94387 4.27326L4.24219 5.75289C4.34551 5.87064 4.33323 6.04933 4.22108 6.15871C3.8439 6.52657 3.51443 6.95611 3.24871 7.44263C2.90063 8.07992 2.69392 8.75641 2.61799 9.43603C2.60059 9.59179 2.46704 9.71128 2.31059 9.702L0.345649 9.58542Z" fill="${color}"/><path d="M4.34791 10.418C4.12638 10.1965 4.12638 9.8373 4.34791 9.61577L4.93343 9.03025C5.15496 8.80872 5.51414 8.80872 5.73567 9.03025L7.16054 10.4551L10.1924 7.42324C10.414 7.2017 10.7731 7.2017 10.9947 7.42324L11.5802 8.00875C11.8017 8.23028 11.8017 8.58946 11.5802 8.81099L7.56185 12.8293C7.53499 12.8562 7.50611 12.8798 7.47569 12.9001C7.25523 13.0478 6.95412 13.0242 6.75938 12.8295L4.34791 10.418Z" fill="${color}"/></svg>`,
			company: ({ color = AppTheme.colors.base3 } = {}) => `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path d="M9.60002 7.9438H12.8695V9.74148H9.60002V7.9438Z" fill="${color}"/><path d="M12.8959 11.4492H9.60002V13.2469H12.8959V11.4492Z" fill="${color}"/><path fill-rule="evenodd" clip-rule="evenodd" d="M15.8645 5.35011V9.92121H18.3823C18.6377 9.92121 18.8448 10.1282 18.8448 10.3836V18.6308C18.8448 18.8847 18.6401 19.0911 18.3862 19.0932L7.09127 19.1874C6.83439 19.1895 6.625 18.9819 6.625 18.725V5.35011C6.625 5.09472 6.83203 4.8877 7.08741 4.8877H15.402C15.6574 4.8877 15.8645 5.09472 15.8645 5.35011ZM12.9124 17.2916H14.1707L14.2606 6.59543H8.07197V17.2916H9.33035V14.9547H12.9124V17.2916ZM17.4066 16.8424H15.6089V15.0447H17.4066V16.8424ZM15.6089 13.3368H17.4066V11.5391H15.6089V13.3368Z" fill="${color}"/></svg>`,
			contact: ({ color = AppTheme.colors.base3 } = {}) => `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.8002 12.6956C7.85465 12.3436 8.12744 12.0654 8.47894 12.005C8.47894 12.005 9.01482 11.8595 9.69679 11.6002C9.69787 11.4498 9.80839 11.3231 9.95664 11.3015H10.1858L10.1523 10.812C9.83265 10.6842 9.61161 10.3888 9.5798 10.0459C9.52266 9.62542 9.48708 9.20168 9.4736 8.77686C9.46982 8.72942 9.46875 8.68197 9.4709 8.63399C9.50055 7.99245 10.0445 7.55577 10.6855 7.58543H10.7146C10.7933 7.57626 10.8726 7.57572 10.9518 7.58381C11.581 7.64581 12.0408 8.14772 11.9783 8.77686C11.9724 9.20275 11.9368 9.6265 11.8721 10.0465C11.8284 10.3845 11.6112 10.6751 11.2996 10.8125L11.2661 11.302H11.4947C11.6419 11.3171 11.754 11.4411 11.7551 11.5889C12.4592 11.8368 12.8932 11.9705 12.8932 11.9705C13.2344 12.0784 13.5083 12.3927 13.6388 12.7264C13.6431 12.7415 13.6458 12.7571 13.6468 12.7733V13.1949C13.6393 13.2547 13.614 13.3118 13.5746 13.3582C13.5358 13.404 13.4786 13.4305 13.4183 13.4305C13.4183 13.4305 12.5018 13.8316 10.6418 13.8564C8.78138 13.8811 8.02231 13.3722 8.02231 13.3722C8.00399 13.3717 7.98619 13.3685 7.96894 13.3625C7.92366 13.3517 7.88376 13.3248 7.85573 13.2881C7.83363 13.2617 7.81853 13.231 7.80937 13.1986L7.8002 13.1356V12.6956ZM17.7867 6.62258C17.7867 6.40801 17.6104 6.12444 17.2875 6.12444H16.1904V7.16061H16.8551V17.9309H8.17219V17.2996H15.5688C15.7952 17.2996 16.0933 17.0446 16.0933 16.8522V16.2662H14.7385C14.6609 16.2662 14.5978 16.2031 14.5978 16.1255V14.7707C14.5978 14.693 14.6609 14.63 14.7385 14.63H16.0933V14.1065H14.7385C14.6609 14.1065 14.5978 14.0434 14.5978 13.9658V12.611C14.5978 12.5334 14.6609 12.4703 14.7385 12.4703H16.0933V11.9468H14.7385C14.6609 11.9468 14.5978 11.8837 14.5978 11.8067V10.4513C14.5978 10.3737 14.6609 10.3106 14.7385 10.3106H16.0933V9.78715H14.7385C14.6609 9.78715 14.5978 9.72407 14.5978 9.64698V8.29166C14.5978 8.21403 14.6609 8.15095 14.7385 8.15095H16.0933V7.62802H14.7385C14.6609 7.62802 14.5978 7.5644 14.5978 7.48731V6.13199C14.5978 6.05489 14.6609 5.99128 14.7385 5.99128H16.0933V5.40742C16.0933 5.21496 15.7952 4.95996 15.5688 4.95996H6.55917C6.33328 4.95996 6.03516 5.21496 6.03516 5.40742V16.8522C6.03516 16.926 6.08637 17.0058 6.15268 17.0802C6.36779 17.4021 7.38563 18.9137 7.57809 18.9137H17.3414C17.5565 18.9137 17.8406 18.6302 17.8406 18.4145L17.7867 6.62258Z" fill="${color}"/></svg>`,
			invoice: ({ color = AppTheme.colors.base3 } = {}) => `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.5 4C5.94772 4 5.5 4.44772 5.5 5V19C5.5 19.5523 5.94772 20 6.5 20H17.5C18.0523 20 18.5 19.5523 18.5 19V5C18.5 4.44772 18.0523 4 17.5 4H6.5ZM16.8015 5.7H7.19876V18.3H16.8015V5.7ZM8.4209 10.4065C8.4209 8.42967 10.0235 6.82715 12.0004 6.82715C13.9772 6.82715 15.5798 8.42967 15.5798 10.4065C15.5798 12.3835 13.9772 13.986 12.0004 13.986C10.0235 13.986 8.4209 12.3835 8.4209 10.4065ZM12.2734 12.884V12.2646C12.9718 12.1432 13.3544 11.6817 13.3544 11.1412C13.3544 10.5946 13.0628 10.2607 12.3403 10.0056C11.824 9.81128 11.6115 9.68377 11.6115 9.48331C11.6115 9.31334 11.739 9.14327 12.1338 9.14327C12.5317 9.14327 12.7988 9.25905 12.9627 9.33009C12.9789 9.33711 12.9941 9.34368 13.0083 9.34967L13.1843 8.66354C12.9839 8.56633 12.7106 8.4813 12.3038 8.46318V7.92871H11.7087V8.50565C11.0588 8.63325 10.6824 9.05219 10.6824 9.58656C10.6824 10.1757 11.1257 10.4793 11.7755 10.6979C12.2249 10.8497 12.4191 10.9954 12.4191 11.2262C12.4191 11.4691 12.1823 11.6027 11.8362 11.6027C11.4414 11.6027 11.0832 11.4753 10.8281 11.3355L10.646 12.046C10.8768 12.1796 11.2714 12.2889 11.6783 12.3071V12.884H12.2734ZM14.9418 15.2002H9.05724C8.89868 15.2002 8.76904 15.3268 8.76904 15.4844V16.5115C8.76904 16.6681 8.89868 16.7967 9.05724 16.7967H14.9418C15.1014 16.7967 15.231 16.6681 15.231 16.5115V15.4844C15.231 15.3268 15.1014 15.2002 14.9418 15.2002Z" fill="${color}"/></svg>`,
		},
	};

	module.exports = {
		check,
		cross,
		dots,
		union,
		clock,
		flag,
		documents,
	};
});
