<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true)
{
	die();
}

/**
 * Bitrix vars
 * @var array $arParams
 * @var array $arResult
 * @var CMain $APPLICATION
 * @var CUser $USER
 * @var CDatabase $DB
 * @var CBitrixComponentTemplate $this
 * @var string $templateName
 * @var string $templateFile
 * @var string $templateFolder
 * @var string $componentPath
 * @var CBitrixComponent $component
 */

use Bitrix\Main\Loader;
use Bitrix\Main\UI\Extension;
use Bitrix\Main\Localization\Loc;

Extension::load([
	'ui.design-tokens',
	'ui.sidepanel-content',
	'ui.buttons',
	'ui.info-helper',
]);
?>
<div class="wraper-bi">
	<div class="ui-slider-section biconnector-market__description">
		<div class="biconnector-market__section-icon">
			<svg width="158" height="129" viewBox="0 0 158 129" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path fill-rule="evenodd" clip-rule="evenodd" d="M113.818 4.33817C114.776 4.33817 115.552 3.56171 115.552 2.60389C115.552 1.64608 114.776 0.869614 113.818 0.869614C112.86 0.869614 112.084 1.64608 112.084 2.60389C112.084 3.56171 112.86 4.33817 113.818 4.33817ZM28.2401 19.3196C30.3165 19.3196 31.9997 17.6363 31.9997 15.5599C31.9997 13.4835 30.3165 11.8003 28.2401 11.8003C26.1637 11.8003 24.4804 13.4835 24.4804 15.5599C24.4804 17.6363 26.1637 19.3196 28.2401 19.3196ZM28.2401 17.2233C29.1588 17.2233 29.9035 16.4786 29.9035 15.5599C29.9035 14.6412 29.1588 13.8965 28.2401 13.8965C27.3214 13.8965 26.5766 14.6412 26.5766 15.5599C26.5766 16.4786 27.3214 17.2233 28.2401 17.2233ZM9.13998 56.0228C11.9366 56.0228 14.2037 53.7557 14.2037 50.959C14.2037 48.1624 11.9366 45.8953 9.13998 45.8953C6.34335 45.8953 4.07624 48.1624 4.07624 50.959C4.07624 53.7557 6.34335 56.0228 9.13998 56.0228ZM9.13998 53.38C10.4771 53.38 11.561 52.2961 11.561 50.959C11.561 49.6219 10.4771 48.538 9.13998 48.538C7.80292 48.538 6.71901 49.6219 6.71901 50.959C6.71901 52.2961 7.80292 53.38 9.13998 53.38ZM137.703 119.74C139.694 119.74 141.308 118.126 141.308 116.135C141.308 114.144 139.694 112.53 137.703 112.53C135.712 112.53 134.098 114.144 134.098 116.135C134.098 118.126 135.712 119.74 137.703 119.74ZM137.703 117.864C138.658 117.864 139.432 117.09 139.432 116.135C139.432 115.18 138.658 114.406 137.703 114.406C136.748 114.406 135.974 115.18 135.974 116.135C135.974 117.09 136.748 117.864 137.703 117.864ZM80.0001 129C114.242 129 142 101.242 142 67C142 32.7583 114.242 5 80.0001 5C45.7584 5 18.0001 32.7583 18.0001 67C18.0001 101.242 45.7584 129 80.0001 129ZM17.9704 124.666H5.91744C5.81431 124.666 5.71207 124.662 5.61084 124.655C2.88685 124.591 0.697892 122.302 0.697754 119.487C0.698546 118.115 1.22957 116.8 2.174 115.831C2.6581 115.334 3.2305 114.949 3.85326 114.691C3.84284 114.552 3.83753 114.411 3.83753 114.268C3.83839 112.821 4.39872 111.433 5.39524 110.41C6.39177 109.387 7.74287 108.813 9.15131 108.814C10.9555 108.816 12.5484 109.743 13.5057 111.159C13.9603 110.993 14.4496 110.903 14.9594 110.903C17.2116 110.906 19.0613 112.67 19.2757 114.927C21.4336 115.41 23.0485 117.386 23.0466 119.748C23.0444 122.47 20.8959 124.676 18.2471 124.674C18.1542 124.674 18.0619 124.672 17.9704 124.666ZM145.704 28.7851H154.258C154.323 28.7888 154.389 28.7907 154.454 28.7907C156.334 28.7915 157.859 27.2879 157.861 25.4319C157.862 23.8213 156.716 22.4742 155.184 22.1446C155.032 20.6062 153.72 19.4033 152.121 19.4014C151.759 19.4012 151.412 19.4625 151.09 19.5754C150.41 18.6105 149.28 17.9783 147.999 17.9767C147 17.9761 146.041 18.3676 145.334 19.065C144.627 19.7624 144.229 20.7087 144.228 21.6956C144.228 21.7926 144.232 21.8888 144.239 21.984C143.798 22.1594 143.391 22.4221 143.048 22.7609C142.378 23.4218 142.001 24.3186 142 25.254C142 27.1729 143.554 28.7338 145.487 28.7772C145.559 28.7825 145.631 28.7851 145.704 28.7851Z" fill="#E5F9FF"/>
				<path fill-rule="evenodd" clip-rule="evenodd" d="M113.818 4.33817C114.776 4.33817 115.552 3.56171 115.552 2.60389C115.552 1.64608 114.776 0.869614 113.818 0.869614C112.86 0.869614 112.084 1.64608 112.084 2.60389C112.084 3.56171 112.86 4.33817 113.818 4.33817ZM28.2401 19.3196C30.3165 19.3196 31.9997 17.6363 31.9997 15.5599C31.9997 13.4835 30.3165 11.8003 28.2401 11.8003C26.1637 11.8003 24.4804 13.4835 24.4804 15.5599C24.4804 17.6363 26.1637 19.3196 28.2401 19.3196ZM28.2401 17.2233C29.1588 17.2233 29.9035 16.4786 29.9035 15.5599C29.9035 14.6412 29.1588 13.8965 28.2401 13.8965C27.3214 13.8965 26.5766 14.6412 26.5766 15.5599C26.5766 16.4786 27.3214 17.2233 28.2401 17.2233ZM9.13998 56.0228C11.9366 56.0228 14.2037 53.7557 14.2037 50.959C14.2037 48.1624 11.9366 45.8953 9.13998 45.8953C6.34335 45.8953 4.07623 48.1624 4.07623 50.959C4.07623 53.7557 6.34335 56.0228 9.13998 56.0228ZM9.13998 53.38C10.4771 53.38 11.561 52.2961 11.561 50.959C11.561 49.6219 10.4771 48.538 9.13998 48.538C7.80292 48.538 6.71901 49.6219 6.71901 50.959C6.71901 52.2961 7.80292 53.38 9.13998 53.38ZM137.703 119.74C139.694 119.74 141.308 118.126 141.308 116.135C141.308 114.144 139.694 112.53 137.703 112.53C135.712 112.53 134.098 114.144 134.098 116.135C134.098 118.126 135.712 119.74 137.703 119.74ZM137.703 117.864C138.658 117.864 139.432 117.09 139.432 116.135C139.432 115.18 138.658 114.406 137.703 114.406C136.748 114.406 135.974 115.18 135.974 116.135C135.974 117.09 136.748 117.864 137.703 117.864ZM80.0001 129C114.242 129 142 101.242 142 67C142 32.7583 114.242 5 80.0001 5C45.7584 5 18.0001 32.7583 18.0001 67C18.0001 101.242 45.7584 129 80.0001 129ZM17.9704 124.666H5.91744C5.81431 124.666 5.71207 124.662 5.61085 124.655C2.88685 124.591 0.697892 122.302 0.697754 119.487C0.698546 118.115 1.22957 116.8 2.174 115.831C2.6581 115.334 3.2305 114.949 3.85326 114.691C3.84284 114.552 3.83753 114.411 3.83753 114.268C3.83839 112.821 4.39872 111.433 5.39524 110.41C6.39177 109.387 7.74287 108.813 9.15131 108.814C10.9555 108.816 12.5484 109.743 13.5057 111.159C13.9603 110.993 14.4496 110.903 14.9594 110.903C17.2116 110.906 19.0613 112.67 19.2757 114.927C21.4336 115.41 23.0485 117.386 23.0466 119.748C23.0444 122.47 20.8959 124.676 18.2471 124.674C18.1542 124.674 18.0619 124.672 17.9704 124.666ZM145.704 28.7851H154.258C154.323 28.7888 154.389 28.7907 154.454 28.7907C156.334 28.7915 157.859 27.2879 157.861 25.4319C157.862 23.8213 156.716 22.4742 155.184 22.1446C155.032 20.6062 153.72 19.4033 152.121 19.4014C151.759 19.4012 151.412 19.4625 151.09 19.5754C150.41 18.6105 149.28 17.9783 147.999 17.9767C147 17.9761 146.041 18.3676 145.334 19.065C144.627 19.7624 144.229 20.7087 144.228 21.6956C144.228 21.7926 144.232 21.8888 144.239 21.984C143.798 22.1594 143.391 22.4221 143.048 22.7609C142.377 23.4218 142.001 24.3186 142 25.254C142 27.1729 143.554 28.7338 145.487 28.7772C145.559 28.7825 145.631 28.7851 145.704 28.7851Z" fill="#E5F9FF"/>
				<g filter="url(#filter0_d_1468_71909)">
					<path fill-rule="evenodd" clip-rule="evenodd" d="M104.162 92.7854H57.9939C57.5988 92.7854 57.2072 92.7707 56.8195 92.7417C46.3853 92.5013 38.0005 83.8678 38 73.2532C38.003 68.0795 40.0371 63.119 43.6547 59.4629C45.5091 57.5888 47.7016 56.1361 50.0871 55.1656C50.0472 54.6392 50.0268 54.1072 50.0268 53.5704C50.0301 48.1114 52.1764 42.8774 55.9936 39.0197C59.8108 35.162 64.9861 32.9967 70.3811 33C77.292 33.0085 83.3935 36.5054 87.0604 41.8426C88.8017 41.2183 90.6762 40.879 92.629 40.8801C101.256 40.8906 108.341 47.5446 109.162 56.054C117.428 57.8774 123.614 65.3285 123.607 74.2372C123.598 84.5036 115.368 92.8206 105.222 92.8163C104.866 92.8162 104.513 92.8058 104.162 92.7854Z" fill="white"/>
				</g>
				<path fill-rule="evenodd" clip-rule="evenodd" d="M81.9256 50.4629C91.027 50.4629 98.406 57.8418 98.406 66.9432C98.406 76.0446 91.027 83.4236 81.9256 83.4236C72.8243 83.4236 65.4453 76.0446 65.4453 66.9432C65.4453 57.8418 72.8243 50.4629 81.9256 50.4629Z" fill="url(#paint0_linear_1468_71909)"/>
				<path fill-rule="evenodd" clip-rule="evenodd" d="M83.1601 66.0638H88.7621C89.9354 66.0607 90.8896 66.9323 90.8941 68.0113C90.892 68.5294 90.6662 69.0255 90.2664 69.3904C89.8665 69.7553 89.3254 69.9591 88.7621 69.957H81.2861C81.2018 69.9663 81.1161 69.9711 81.0291 69.9711C79.8522 69.9711 78.8982 69.0937 78.8982 68.0113V58.4653C78.8997 57.9473 79.125 57.451 79.5244 57.0858C79.9239 56.7205 80.4648 56.5162 81.0281 56.5178C82.2014 56.5147 83.1556 57.3863 83.1601 58.4653V66.0638Z" fill="white"/>
				<defs>
					<filter id="filter0_d_1468_71909" x="30" y="30" width="101.607" height="75.8163" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
						<feFlood flood-opacity="0" result="BackgroundImageFix"/>
						<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
						<feOffset dy="5.00001"/>
						<feGaussianBlur stdDeviation="4.00001"/>
						<feComposite in2="hardAlpha" operator="out"/>
						<feColorMatrix type="matrix" values="0 0 0 0 0.0335938 0 0 0 0 0.382893 0 0 0 0 0.5375 0 0 0 0.2 0"/>
						<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_1468_71909"/>
						<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_1468_71909" result="shape"/>
					</filter>
					<linearGradient id="paint0_linear_1468_71909" x1="98.406" y1="83.4236" x2="98.406" y2="50.4629" gradientUnits="userSpaceOnUse">
						<stop stop-color="#61DF00"/>
						<stop offset="1" stop-color="#4CCA00"/>
					</linearGradient>
				</defs>
			</svg>

		</div>
		<div class="biconnector-market__content">
			<div class="biconnector-market__section-title ui-typography-heading-h1"><?=Loc::getMessage('TITLE_REPORT_TEMPLATES')?></div>
			<div class="ui-slider-inner-box">
				<p class="ui-slider-paragraph-2 biconnector-market__section-paragraph"><?=Loc::getMessage('DESCRIPTION_REPORT_TEMPLATES')?></p>
				<p class="ui-slider-paragraph-2">
					<a href="javascript:top.BX.Helper.show('redirect=detail&code=17402700');" class="biconnector-market__section-link"><?=Loc::getMessage('LINK_MANUAL_REPORT_TEMPLATES')?></a>
				</p>
			</div>
		</div>
	</div>

	<?php
	if (Loader::includeModule('market'))
	{
		$APPLICATION->IncludeComponent(
			'bitrix:market.list',
			'',
			[
				'IS_COLLECTION' => 'Y',
				'COLLECTION_CODE' => 'bi_templates',
				'HIDE_CATEGORIES' => 'Y',
				'HIDE_TOOLBAR' => 'Y',
				'HIDE_BREADCRUMBS' => 'Y',
				'SHOW_TITLE' => 'N',
				'CHANGE_HISTORY' => 'N',
				'ADDITIONAL_BODY_CLASS' => 'biconnector-market__body-slider',
			]
		);
	}
	?>

</div>
<script>
	BX.ready(() => {
		<?php if ($arResult['SHOW_TITLE'] === 'N'): ?>
		document.querySelector('.ui-side-panel-wrap-title-name').innerText = '';
		<?php endif; ?>
	});
</script>
